
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
                       'test' => {
                                   'TESTS' => 't/*.t'
                                 },
                       'NAME' => 'DateTimeX::Easy',
                       'DISTNAME' => 'DateTimeX-Easy',
                       'CONFIGURE_REQUIRES' => {
                                                 'ExtUtils::MakeMaker' => '6.31'
                                               },
                       'AUTHOR' => 'Robert Krimen <robertkrimen@gmail.com>',
                       'BUILD_REQUIRES' => {
                                             'Test::Most' => '0'
                                           },
                       'ABSTRACT' => 'Parse a date/time string using the best method available',
                       'EXE_FILES' => [],
                       'VERSION' => '0.088_1',
                       'PREREQ_PM' => {
                                        'Scalar::Util' => '0',
                                        'DateTime::Format::Flexible' => '0',
                                        'DateTime' => '0',
                                        'DateTime::Format::Natural' => '0',
                                        'DateTime::Format::ICal' => '0',
                                        'Time::Zone' => '0',
                                        'Date::Parse' => '0'
                                      },
                       'LICENSE' => 'perl'
                     );


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM}; 
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod}; 
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



