package Dist::Zilla::Config::Perl;
our $VERSION = '1.092200';

use Moose;
with qw(
  Dist::Zilla::Config
  Dist::Zilla::ConfigRole::Findable
  Dist::Zilla::ConfigRole::MVP
);
# ABSTRACT: the reader for dist.pl files


# Clearly this should be an attribute with a builder blah blah blah. -- rjbs,
# 2009-07-25
sub default_filename { 'dist.pl' }
sub filename         { $_[0]->default_filename }

sub can_be_found {
  my ($self, $arg) = @_;

  my $config_file = $arg->{root}->file( $self->filename );
  return -r "$config_file" and -f _;
}

sub read_config {
  my ($self, $arg) = @_;
  my $config_file = $arg->{root}->file( $self->filename );

  my $asm = $self->assembler;

  my @input = do $config_file;
  while (@input and ! ref $input[0]) {
    my ($key, $value) = (shift(@input), shift(@input));
    $asm->add_value($key => $value);
  }

  my $plugins = shift @input;

  confess "too much input" if @input;

  while (my ($ident, $arg) = splice @$plugins, 0, 2) {
    unless (ref $arg) {
      unshift @$plugins, $arg;
      $arg = [];
    }

    my ($moniker, $name) = ref $ident ? @$ident : (($ident) x 2);
    $asm->change_section($moniker, $name);
    my @to_iter = ref $arg eq 'HASH' ? %$arg : @$arg;
    while (my ($key, $value) = splice @to_iter, 0, 2) {
      $asm->add_value($key, $value);
    }
  }

  return $self->config_struct;
}

no Moose;
__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Dist::Zilla::Config::Perl - the reader for dist.pl files

=head1 VERSION

version 1.092200

=head1 DESCRIPTION

Dist::Zilla::Config reads in the F<dist.pl> file for a distribution.  It uses
L<Config::MVP::Assembler> to do most of the heavy lifting, using the helpers
set up in L<Dist::Zilla::Role::ConfigMVP>.

=head1 AUTHOR

  Ricardo SIGNES <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2009 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut 


