#!/usr/bin/env perl

use Mojolicious::Lite;

use Test::More;
use Test::Mojo;
use Test::LongString;

use File::Spec;
use File::Basename;

use lib 'lib';
use lib '../lib';

## Webapp START

my $testdir = File::Spec->catdir( dirname(__FILE__), '..', 'test' );

plugin('Prove' => {
  tests => {
    base => $testdir,
  }
});

## Webapp END

my $t = Test::Mojo->new;

$t->get_ok( '/prove/test/base/run' )->status_is( 200 );

my $content = $t->tx->res->body;
like_string $content, qr/\A<!DOCTYPE/;
like_string $content, qr!<tr class="test-run passed" id="[^"]+01-success-t">!;
like_string $content, qr!<tr class="test-run failed severity-very-high" id="[^"]+02-fail-t">!;
like_string $content, qr/Generated by TAP::Formatter::HTML/;

done_testing();

