#!/usr/bin/perl

### OPEN SOURCE LICENSE - GNU AFFERO PUBLIC LICENSE Version 3.0 #######
#
#    Net::FullAuto Demonstration GUI
#    Copyright (C) 2000-2015  Brian M. Kelly
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but **WITHOUT ANY WARRANTY**; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public
#    License along with this program.  If not, see:
#    <http://www.gnu.org/licenses/agpl.html>.
#
#######################################################################

use Wx::Perl::Packager;
use Wx;
use Cwd;
our $begin_cwd=cwd();
chdir "$ENV{PAR_TEMP}/inc" if -e "$ENV{PAR_TEMP}/inc";

our $VERSION = '0.01';

use 5.010;
use strict;
use warnings;
use Wx qw(:everything :id :misc :panel);
use Wx::Event qw(EVT_BUTTON EVT_TREE_SEL_CHANGED EVT_MENU EVT_CLOSE
                 EVT_MEDIA_LOADED EVT_MEDIA_PLAY EVT_ACTIVATE
                 EVT_NOTEBOOK_PAGE_CHANGED EVT_MEDIA_STATECHANGED
                 EVT_DROP_FILES EVT_FILEPICKER_CHANGED EVT_TEXT
                 EVT_PAINT EVT_CHECKBOX);

use Wx::Media;
use Wx::WebView;
use Wx::DND;
use Wx::Perl::ProcessStream qw( :everything );
use wxPerl::Constructors;
use File::Copy qw(copy);
use File::Find;
use Win32::TieRegistry;

# create the WxApplication
my $app = Wx::SimpleApp->new;
my $frame = Wx::Frame->new(undef, -1,
		           'FullAuto Automates EVERYTHING Demonstration',
                           wxDefaultPosition,[ 800, 600 ]);
SplitterWindow($frame);
$frame->Show;
$app->MainLoop;

# Example specific code
sub SplitterWindow {

   my ( $self ) = @_;

   my $splitterWindow = Wx::SplitterWindow->new($self, -1);
   #get our logo
   Wx::InitAllImageHandlers();

   # create menu bar
   my $bar  = Wx::MenuBar->new;
   my $file = Wx::Menu->new;
   my $help = Wx::Menu->new;
   my $edit = Wx::Menu->new;

   $file->Append( wxID_EXIT, '' );

   $help->Append( wxID_ABOUT, '' );

   $edit->Append( wxID_COPY,  '' );
   $edit->Append( wxID_FIND,  '' );
   my $find_again = $edit->Append( -1, "Find Again\tF3" );

   $bar->Append( $file, "&File" );
   #$bar->Append( $edit, "&Edit" );
   $bar->Append( $help, "&Help" );

   $self->SetMenuBar( $bar );
   $self->{menu_count} = $self->GetMenuBar->GetMenuCount;
   $self->{par_temp} = $ENV{PAR_TEMP} if exists $ENV{PAR_TEMP};
   $self->{begin_cwd}= $begin_cwd;

   my $logo = Wx::Bitmap->new("fullautogreenbannerpower.png",
                              wxBITMAP_TYPE_PNG );

   my $banner = Wx::BannerWindow->new($splitterWindow);
   $banner->SetBitmap( $logo );
   $banner->Show(1);
	
   my $rightWindows = Wx::SplitterWindow->new($splitterWindow, -1);
   $rightWindows->Show(1);

   my $pem_file='';
   my $full_pem='';
   my $ppk_file='';
   my $ip_txt='';
   my $saved_txt='';
   my $cre_file='';
   opendir(PH,".");
   while (my $f=readdir(PH)) {
      next if $f eq '.';
      next if $f eq '..';
      if ($f=~/\.pem$/) {
         $pem_file=$f;
      } elsif ($f=~/\.ppk$/) {
         $ppk_file=$f;
      } elsif ($f=~/^ip.txt$/) {
         open (FH,"<ip.txt");
         my @ip_txt=<FH>;
         $ip_txt=join "\n", @ip_txt;
         close FH;
         $ip_txt=~s/^\s*.*?(\d+[.]\d+[.]\d+[.]\d+).*$/$1/s;
      } elsif ($f=~/^saved.txt$/) {
         open(FH,"<saved.txt");
         my @lines=<FH>;
         close FH;
         foreach my $line (@lines) {
            chomp $line;
            $saved_txt=$line if
                $line=~s/^\s*.*?(\d+[.]\d+[.]\d+[.]\d+).*$/$1/s;
            $ppk_file=$line if $line=~/ppk$/;
            $full_pem=$line if $line=~/pem$/;
            $cre_file=$line if $line=~/csv$/;
         }
         $pem_file=$full_pem;
         $pem_file=~s/^.*\\(.*)$/$1/;
         last;
      }
   }
   close PH;

   my $righttop = Wx::Notebook->new($rightWindows,-1,[-1,-1],[-1,-1],
         wxNO_FULL_REPAINT_ON_RESIZE|wxCLIP_CHILDREN);
   $righttop->Show(1);

   my $media = Wx::MediaCtrl->new($righttop, -1, '', [-1,-1], [-1,-1], 0 );
   my $media2 = Wx::MediaCtrl->new($righttop, -1, '', [-1,-1], [-1,-1], 0 );
   my $media3 = Wx::MediaCtrl->new($righttop, -1, '', [-1,-1], [-1,-1], 0 );
   my $vid='https://r3---sn-ab5l6nes.googlevideo.com/videoplayback?dur=617.302&ip=69.25.144.254&initcwndbps=4688750&mv=m&ratebypass=yes&source=youtube&ms=au&signature=CCA382E02C2A6E58F582ADF2CD663BEAF974146B.83B792C58FB29BCE980E4C404CC1027300B16B67&requiressl=yes&mm=31&upn=JJpLOAYKmkY&id=o-AHB_PkzC0_bSsJANgu_GNbmo-_uUzMUGWjvRjCwk1Tri&expire=1420788513&key=yt5&mime=video%2Fmp4&ipbits=0&sver=3&sparams=dur%2Cid%2Cinitcwndbps%2Cip%2Cipbits%2Citag%2Cmime%2Cmm%2Cms%2Cmv%2Cratebypass%2Crequiressl%2Csource%2Cupn%2Cexpire&fexp=900718%2C908206%2C916645%2C927622%2C930825%2C932404%2C938628%2C938809%2C9405921%2C941004%2C943917%2C947209%2C947218%2C948124%2C952302%2C952605%2C952901%2C955301%2C957103%2C957105%2C957201%2C959701&mt=1420766869&itag=22';
   $vid="Learning_Cloud_Computing_With_Amazon_Web_".
        "Services_What_Is_The_Cloud.mp4";
   my $vid2='https://r9---sn-vgqsen7z.googlevideo.com/videoplayback?ms=au&source=youtube&dur=382.664&mv=m&mime=video%2Fmp4&ip=75.49.211.167&initcwndbps=376250&fexp=900718%2C908206%2C916645%2C927622%2C930825%2C932404%2C938628%2C938809%2C9405921%2C941004%2C943917%2C947209%2C947218%2C948124%2C952302%2C952605%2C952901%2C955301%2C957103%2C957105%2C957201%2C959701&id=o-AL3m1Tg5lAwFanYTH8Dsp64QmLtSry4iocuReg3GKyJQ&key=yt5&expire=1420791851&mm=31&ipbits=0&mt=1420770225&itag=22&sver=3&upn=x4z3LvYfGgc&sparams=dur%2Cid%2Cinitcwndbps%2Cip%2Cipbits%2Citag%2Cmime%2Cmm%2Cms%2Cmv%2Cratebypass%2Crequiressl%2Csource%2Cupn%2Cexpire&requiressl=yes&ratebypass=yes&signature=B42BF536A709157F30A16B543235B972ECA64EE6.440606815336C90E38117954EBE3A82BDA7EBBF2';
   $vid2="Introduction_to_Amazon_Elastic_Compute_Cloud_EC2.mp4";
   $media->LoadURI("THIS.avi");
   $media->Show( 1 );
   $media->ShowPlayerControls;
   $righttop->{media}=$media;
   $media2->LoadURI($vid);
   $media2->Show( 1 );
   $media2->ShowPlayerControls;
   $righttop->{media2}=$media2;
   $media3->LoadURI($vid2);
   $media3->Show( 1 );
   $media3->ShowPlayerControls;
   $righttop->{media3}=$media3;

   EVT_MEDIA_STATECHANGED($righttop, $media,\&main::on_media_loaded);
   EVT_MEDIA_STATECHANGED($righttop, $media2,\&main::on_media2_loaded);
   EVT_MEDIA_STATECHANGED($righttop, $media3,\&main::on_media3_loaded);

if (0) {
   my $webpanel = Wx::Panel->new($righttop, wxID_ANY);

   my $aws_url='https://portal.aws.amazon.com/gp/aws/developer/'.
               'registration/index.html';
   $webpanel->{defaulturl}=$aws_url;
   my $html = Wx::WebView::New($webpanel, wxID_ANY, $webpanel->{defaulturl});
   $html->{defaulturl}=$aws_url;
   $webpanel->{webview}=$html;

   my $dfbrow  = Wx::Button->new($webpanel, wxID_ANY, 'Go to Default Browser');
   my $btnurl  = Wx::Button->new($webpanel, wxID_ANY, 'Load URL');
   my $btnback = Wx::Button->new($webpanel, wxID_ANY, 'Back');
   my $btnforw = Wx::Button->new($webpanel, wxID_ANY, 'Forward');
   my $btnhist = Wx::Button->new($webpanel, wxID_ANY, 'History');

   my $buttonsizer = Wx::BoxSizer->new(wxHORIZONTAL);
   $buttonsizer->Add($dfbrow,  0, wxLEFT|wxRIGHT, 0);
   $buttonsizer->Add($btnurl,  0, wxLEFT|wxRIGHT, 0);
   $buttonsizer->Add($btnback, 0, wxLEFT|wxRIGHT, 0);
   $buttonsizer->Add($btnforw, 0, wxLEFT|wxRIGHT, 0);
   $buttonsizer->Add($btnhist, 0, wxLEFT|wxRIGHT, 0);

   EVT_BUTTON($webpanel, $dfbrow,  sub { shift->main::GoToDefBrowser( @_ ); });
   EVT_BUTTON($webpanel, $btnurl,  sub { shift->main::OnBtnURL( @_ ); });
   EVT_BUTTON($webpanel, $btnback, sub { shift->main::OnBtnBack( @_ ); });
   EVT_BUTTON($webpanel, $btnforw, sub { shift->main::OnBtnForward( @_ ); });
   EVT_BUTTON($webpanel, $btnhist, sub { shift->main::OnBtnHistory( @_ ); });

   my $msizer = Wx::BoxSizer->new( wxVERTICAL );
   $msizer->Add($html, 1, wxEXPAND|wxALL, 0);
   $msizer->Add($buttonsizer, 0, wxEXPAND|wxALL, 0);

   $webpanel->SetSizer( $msizer );
   $webpanel->Layout;
   $webpanel->Refresh;

}

   $self->{media}=$media;

   $righttop->AddPage( $media, " FullAuto Demonstration ", 1 );
   #$righttop->AddPage( $webpanel, "Amazon Web Services", 0 );
   $righttop->AddPage( $media2, " What is the CLOUD? ", 0 );
   $righttop->AddPage( $media3, " Amazon Web Services EC2 ", 0 );

   $righttop->Show(1);

   my $rightbottom = Wx::Panel->new($rightWindows,-1,[-1,-1]);

   # http://avtanski.net/projects/lcd/applet.html
   my $notready  = Wx::Bitmap->new("notready.jpg",
                                 wxBITMAP_TYPE_JPEG );
   my $presshere = Wx::Bitmap->new("presshere.jpg",
                                 wxBITMAP_TYPE_JPEG );
   my $underway  = Wx::Bitmap->new("underway.jpg",
                                 wxBITMAP_TYPE_JPEG );
   my $demodone  = Wx::Bitmap->new("demodone.jpg",
                                 wxBITMAP_TYPE_JPEG );
   my $steel = Wx::Bitmap->new(
         "Scratched_Steel_Texture_by_AaronDesign_Enlarged.jpg",
         wxBITMAP_TYPE_JPEG);
   $rightbottom->{steel}=$steel;
   EVT_PAINT($rightbottom,\&on_paint);

   my $statbm = '';
   if($pem_file && $ip_txt) {
     $statbm = Wx::StaticBitmap->new($rightbottom,-1,$presshere,[440,30]);
   } elsif ($saved_txt) {
     $statbm = Wx::StaticBitmap->new($rightbottom,-1,$presshere,[440,105]);
   } else {
     $statbm = Wx::StaticBitmap->new($rightbottom,-1,$notready,[440,105]);
   }
   $rightbottom->{statbm}=$statbm;
   $rightbottom->{notready}=$notready;
   $rightbottom->{presshere}=$presshere;
   $rightbottom->{underway}=$underway;
   $rightbottom->{demodone}=$demodone;
   $rightbottom->{righttop}=$righttop;
   #$rightbottom->{html}=$html;
   $rightbottom->DragAcceptFiles(1);
   $rightbottom->SetBackgroundColour(Wx::Colour->new(192,192,192));
   my $fp1 = '';my $fp2='';
   unless ($pem_file && $ip_txt) {
     my $pem_f=($full_pem)?$full_pem:'';
     $fp1 = Wx::FilePickerCtrl->new( $rightbottom, -1, $pem_f,
                "Find and Select AWS Key File -> yourkeyfile.pem",
                "PEM files (*.pem)|*.pem|All files|*.*",
                [30, 15], [400,-1],wxFLP_USE_TEXTCTRL);
     $fp1->SetPath($pem_file) if $pem_file && $ip_txt;
     $fp1->Enable(0) if $pem_f;
     $fp1->Show(1);
     $rightbottom->{fp1}=$fp1;
     EVT_FILEPICKER_CHANGED( $rightbottom, $fp1, \&on_change );
     my $csv_f=($full_pem)?$cre_file:'';
     $fp2 = Wx::FilePickerCtrl->new( $rightbottom, -1, $csv_f,
                "Find and Select AWS Credentials file -> credentials.csv",
                "CSV files (*.csv)|*.csv|All files|*.*",
                [30, 45], [400,-1],wxFLP_USE_TEXTCTRL);
     $fp2->Show(1);
     $fp2->Enable(0) if $csv_f;
     $rightbottom->{fp2}=$fp2;
     EVT_FILEPICKER_CHANGED( $rightbottom, $fp2, \&on_change );

     my $button1=wxPerl::Button->new(
         $rightbottom,
         'Launch + Get Key (.pem) File',
         id        => -1,
         position  => [440,15],
         size      => [176,-1],
         style     => 0,
         validator => Wx::wxDefaultValidator(),
         name      => 'key',
     );
     $rightbottom->{key}=$button1;
     $button1->Enable(0) if $full_pem;
     EVT_BUTTON( $rightbottom, $button1, \&main::OnClick_button1 );

     my $button2=wxPerl::Button->new(
        $rightbottom,
        'Get AWS  credentials.csv  File',
        id        => -1,
        position  => [440,45],
        size      => [176,-1],
        style     => 0,
        validator => Wx::wxDefaultValidator(),
        name      => 'credentials',
     );
     $rightbottom->{credentials}=$button2;
     $button2->Enable(0) if $full_pem; 
     EVT_BUTTON( $rightbottom, $button2, \&main::OnClick_button2 );

     my $ins=($saved_txt)?'Go To Amazon EC2 Dashboard':
                          'Get IP Address of Instance';
     my $button3=wxPerl::Button->new(
        $rightbottom,
        $ins,
        id        => -1,
        position  => [440,75],
        size      => [176,-1],
        style     => 0,
        validator => Wx::wxDefaultValidator(),
        name      => 'ip',
     );
     $rightbottom->{dashboard}=$button3;
     if ($saved_txt) {
        $button3->SetBackgroundColour(Wx::Colour->new(32,161,35));
     } else {
        $button3->SetBackgroundColour(Wx::Colour->new("RED"));
     }
     EVT_BUTTON( $rightbottom, $button3, \&main::OnClick_button3 );
     my $ip_=($saved_txt)?$saved_txt:'';
     my $ipbox=wxPerl::TextCtrl->new(
        $rightbottom,
        $ip_,
        id        => -1,
        position  => [330,76],
        size      => [100,-1],
        style     => 0,
        validator => Wx::wxDefaultValidator(),
        name      => 'ipbox',
     );
     $rightbottom->{ipbox}=$ipbox;
     $ipbox->Show(1);
     $ipbox->Enable(0) if $ip_;
     EVT_TEXT( $rightbottom, $ipbox, \&on_change );
   }

   my $bmp = Wx::Bitmap->new("fakey.png",
                         wxBITMAP_TYPE_PNG );

   my $bht=105;
   if ($pem_file && $ip_txt) {
      $bht=30;
   }
   my $bb=Wx::BitmapButton->new($rightbottom,-1,$bmp,[555,$bht]);
   if (($pem_file && $ip_txt) || $saved_txt) {
      $bb->Enable(1);
   } else {
      $bb->Enable(0);
   }

   my $cleanup_chkbox='';
   my $new_server_chkbox='';
   my $export_putty_chkbox='';
   my $chk=169;
   $chk=99 if !exists $rightbottom->{firstpaint} && $pem_file && $ip_txt;
   $cleanup_chkbox=Wx::CheckBox->new($rightbottom,-1,'',
                          [118,$chk],[-1,-1],wxTRANSPARENT_WINDOW);
   $cleanup_chkbox->SetBackgroundColour(Wx::Colour->new(77,77,77));
   $rightbottom->{cucb}=$cleanup_chkbox;
   $self->{cucb}=$cleanup_chkbox;
   EVT_CHECKBOX( $rightbottom, $cleanup_chkbox, \&main::OnClick_chkbox1 );
   $export_putty_chkbox=Wx::CheckBox->new($rightbottom,-1,'',
                          [280,$chk],[-1,-1],wxTRANSPARENT_WINDOW);
   $export_putty_chkbox->SetBackgroundColour(Wx::Colour->new(77,77,77));
   $rightbottom->{epcb}=$export_putty_chkbox;
   EVT_CHECKBOX( $rightbottom, $export_putty_chkbox, \&main::OnClick_chkbox2 );
   $new_server_chkbox=Wx::CheckBox->new($rightbottom,-1,'',
                       [440,$chk],[-1,-1],wxTRANSPARENT_WINDOW);
   $new_server_chkbox->SetBackgroundColour(Wx::Colour->new(77,77,77));
   $rightbottom->{nscb}=$new_server_chkbox;
   $new_server_chkbox->SetValue(1) unless ($ip_txt || $saved_txt);
   EVT_CHECKBOX( $rightbottom, $new_server_chkbox, \&main::OnClick_chkbox3 );
   my $eng = Wx::Bitmap->new("engineroom.jpg",
                         wxBITMAP_TYPE_JPEG );
   my $eht=86;
   if ($pem_file && $ip_txt) {
      $eht=16;
   }
   my $er=Wx::BitmapButton->new($rightbottom,-1,$eng,[30,$eht]);
   $er->Enable(1);
   $rightbottom->{bb}=$bb;
   $rightbottom->{bmp}=$bmp;

   my $gif='';
   if (-e "standup.gif") {
      $gif=Wx::Animation->new();
      # Scrolling Gif Generator
      # http://www.ottoschellekens.nl/downloads/downloads.html
      $gif->LoadFile("standup.gif",wxANIMATION_TYPE_GIF);
      my $ht=115;
      if ($pem_file && $ip_txt) {
         $ht=40;
      }
      my $newAni=Wx::AnimationCtrl->new(
            $rightbottom,-1, $gif, [118,$ht], [-1,-1], 0 );
      $newAni->Play();
   }
   $rightbottom->{ppk_file} = $ppk_file if $ppk_file;
   $rightbottom->{ip_txt} = $ip_txt if $ip_txt;
   EVT_BUTTON( $rightbottom, $bb, \&fullauto_button);
   EVT_BUTTON( $rightbottom, $er, \&enginerm_button);
   EVT_DROP_FILES( $rightbottom, \&main::on_drop );

   $rightbottom->Show(1);

   $splitterWindow->SetMinimumPaneSize(5);
   $rightWindows->SetMinimumPaneSize(5);

   if ($pem_file && $ip_txt) {
      $rightWindows->SplitHorizontally($righttop,$rightbottom,419);
   } else {
      $rightWindows->SplitHorizontally($righttop,$rightbottom,345);
   }
   $rightWindows->SetSashGravity(1.0);
   $splitterWindow->SplitVertically($banner,$rightWindows,142);

   EVT_CLOSE( $self, \&on_close );
   EVT_MENU( $self, wxID_ABOUT, \&on_about );
   EVT_MENU( $self, wxID_EXIT, sub { $self->Close } );
   EVT_MENU( $self, wxID_COPY, \&on_copy );
   EVT_MENU( $self, wxID_FIND, \&on_find );
   EVT_MENU( $self, $find_again, \&on_find_again );

   $self->SetIcon(Wx::Icon->new("FA.ico",wxBITMAP_TYPE_ICO));
   $self->Show;

}

sub on_paint {

    my $self = shift;
    my $dc = Wx::PaintDC->new( $self );

    $dc->DrawBitmap( $self->{steel},0,0,0);
    my $chk=169;
    my $firstpaint=0;
    if (!exists $self->{firstpaint} && (exists $self->{ip_txt})) {
       $chk=99;
       $firstpaint=1;
    }
    $self->{firstpaint}=$firstpaint;
    $dc->DrawText('Launch New FullAuto Server',460,$chk);
    $dc->DrawText('Cleanup on Terminate',139,$chk);
    $dc->DrawText('Export PuTTY',301,$chk);

}

sub evt_process_exit {
    my ($self, $event) = @_;
    $event->Skip(1);
    my $process = $event->GetProcess;
    #my $line = $event->GetLine;
    #my @buffers = @{ $process->GetStdOutBuffer };
    #my @errors = @{ $process->GetStdErrBuffer };
    #my $exitcode = $process->GetExitCode;
    $process||='';
    $process->Destroy if $process;
    open (FH,"<putty.log");
    my @lines=<FH>;
    close FH;
    my $out=join '',@lines;
    my $liferay_url='';
    my $set_shifted_flag=0;
    my $liferay_flag=0;
    if (!exists $self->{shifted_cmds} &&
          (-1<index $out,'Nothing to do')) {
      copy "cmds_saved.template", "cmds.txt";
      my $iptext=$self->{ip_txt};
#print "HERE WE GO and IPTEXT=$iptext\n";
      my $set_shifted_flag=1;
      my $proc=Wx::Perl::ProcessStream::Process->new(
            "runputty fullauto.ppk $iptext",'putty',$self);
      $self->{shifted_cmds}=$proc;
      $proc->Run;
    } elsif (!exists $self->{liferay}) {
      open(PL,"putty.log");
      while (my $line=<PL>) {
         if (-1<index $line,'ACCESS LIFERAY PORTAL AT:') {
            $liferay_url=$line;
            $liferay_url=~s/^.*ACCESS LIFERAY PORTAL AT:\s+(http.*8080)\s*/$1/;
            last;
         }
      }
    }
    if (!exists $self->{liferay} && $liferay_url) {
      $self->{dashboard}->SetBackgroundColour(Wx::Colour->new(32,161,35));
      $self->{statbm}->SetBitmap($self->{demodone});
      $liferay_flag=1;
      $self->{liferay}=1;
      Wx::LaunchDefaultBrowser($liferay_url,wxBROWSER_NEW_WINDOW);
      $self->{bb}->Enable(1);
    } 
    if ((!exists $self->{shifted_cmds} && !exists $self->{liferay}) ||
         (!$set_shifted_flag && !$liferay_flag)) {
      $self->{dashboard}->SetBackgroundColour(Wx::Colour->new(32,161,35));
      $self->{statbm}->SetBitmap($self->{presshere});
      $self->{bb}->Enable(1);
    }
}

sub fullauto_button {

   my ($self, $event) =@_;
   # http://proton-ce.sourceforge.net/rc/wxwidgets \
   # /docs/html/wx/wx_processfunctions.html
   $self->{key}->Enable(0);
   $self->{credentials}->Enable(0);
   $self->{ipbox}->Enable(0);
   $self->{fp1}->Enable(0);
   $self->{fp2}->Enable(0);
   $self->{dashboard}->SetBackgroundColour(Wx::Colour->new(248,115,17));
   $self->{statbm}->SetBitmap($self->{underway});
   $self->{nscb}->SetValue(0);
   $self->{bb}->Enable(0);
   my $key=$self->{fp1}->GetPath();
   $key=~s/^.*\/(.*)$/$1/;
   my $keybasename=$key;
   $keybasename=~s/^.*\\(.*)\.pem/$1/;
   my $i=$self->{ipbox}->GetLineText(0);
   my $path=$ENV{HOMEDRIVE}.$ENV{HOMEPATH};
   my $iptext='';
   if (exists $self->{ip_txt}) {
      $iptext=$self->{ip_txt};
   } else {
      $iptext=$self->{ipbox}->GetLineText(0);
      $self->{ip_txt}=$iptext;
   }
   unless (-e "putty.log") {
      Wx::ExecuteCommand("puttycfg $iptext",wxEXEC_SYNC)
   }
   unless ((-e "saved.txt") || (-e "ip.txt")) {
      unless (-e "$keybasename.ppk") {
         Wx::ExecuteCommand("puttykey $key",wxEXEC_SYNC);
      }
      if (exists $ENV{PAR_TEMP} && (-e "$ENV{PAR_TEMP}/inc")) {
print "THIS=$path/fullauto.ppk\n";
         copy "$path/fullauto.ppk", "$ENV{PAR_TEMP}/inc";
      } else {
         copy "$path/fullauto.ppk", cwd();
      }
      unlink "$path/fullauto.ppk";
      Wx::ExecuteCommand("puttyyes $keybasename.ppk ec2-user $i",
         wxEXEC_SYNC);
      $self->{ppk_file}="$keybasename.ppk";
      my $c="pscp.exe -batch -v -i $keybasename.ppk ".
            "MyConfig.pm ec2-user\@$i:/home/ec2-user";
      Wx::Shell($c);
      $c="pscp.exe -batch -v -i $keybasename.ppk ".
            "$keybasename.pem ec2-user\@$i:/home/ec2-user";
      Wx::Shell($c);
      $c="pscp.exe -batch -v -i $keybasename.ppk ".
            "credentials.csv ec2-user\@$i:/home/ec2-user";
      Wx::Shell($c);
      copy "cmds.template", "cmds.txt";
   } elsif (-e "ip.txt") {
      copy "cmds_ip.template", "cmds.txt";
   } else {
      copy "cmds_saved.template", "cmds.txt";
   }
   #unless (exists $self->{secret_access_key}) { 
   #   open(FH,"<credentials.csv");
   #   my @creds=<FH>;
   #   close FH;
   #   my $id='';my $aki='';my $sac='';
   #   chomp $creds[1];
   #   ($id,$aki,$sac)=split ',',$creds[1];
   #   $self->{access_key_id}=$aki;
   #   $self->{secret_access_key}=$sac;
   #}
   open(FH,"+<cmds.txt");
   my $out='';my $k=$keybasename.'.pem';
   while(my $line=<FH>) {
      #$line=~s/_k_/$self->{access_key_id}/eg;
      #$line=~s/_s_/$self->{secret_access_key}/eg;
      $line=~s/_p_/$k/eg;
      $out.=$line;
   }
   seek(FH,0,0);
   print FH $out;
   truncate(FH,tell(FH));
   close(FH);
   open(FH,">saved.txt");
   print FH $iptext."\n";
   print FH $self->{ppk_file}."\n";
   print FH $self->{fp1}->GetPath()."\n";
   print FH $self->{fp2}->GetPath()."\n";
   close FH;
   EVT_WXP_PROCESS_STREAM_EXIT($self, \&evt_process_exit);
   my $proc1=Wx::Perl::ProcessStream::Process->new(
         "runputty fullauto.ppk $iptext",'putty',$self);
   $proc1->Run;

}

sub enginerm_button {

   my ($self, $event) =@_;
   my $cwd=cwd();
print "CWD=$cwd\n";
   Wx::Shell("$cwd/engine.exe"); 

}

sub on_change {

   my ($self, $event) =@_;
   my $text=$self->{ipbox}->GetLineText(0);
   my $key='';my $cred='';
   if ($text=~/\d+\.\d+\.\d+\.\d+/ &&
         ($cred=$self->{fp2}->GetPath()) &&
         ($key=$self->{fp1}->GetPath())) {
      if (exists $ENV{PAR_TEMP} && (-e "$ENV{PAR_TEMP}/inc")) {
         copy $cred, "$ENV{PAR_TEMP}/inc";
         copy $key,  "$ENV{PAR_TEMP}/inc";
print "PAR=$ENV{PAR_TEMP}/inc\n";
      } else {
         copy $cred, cwd();
         #open(FH,"<credentials.csv");
         #my @creds=<FH>;
         #close FH;
         #my $id='';my $aki='';my $sac='';
         #chomp $creds[1];
         #($id,$aki,$sac)=split ',',$creds[1];
         #$self->{access_key_id}=$aki;
         #$self->{secret_access_key}=$sac;
#print "SAC=$self->{secret_access_key}\n";
         copy $key, cwd();
      }
      $self->{statbm}->SetBitmap($self->{presshere});
      $self->{dashboard}->SetLabel('Go To Amazon EC2 Dashboard');
      $self->{dashboard}->SetBackgroundColour(Wx::Colour->new(32,161,35));
      $self->{bb}->SetBitmap($self->{bmp});
      $self->{bb}->Enable(1);
   } elsif ($text=$self->{fp1}->GetPath()) {
      $self->{statbm}->SetBitmap($self->{notready});
      $self->{bb}->Enable(0);
   }
}

sub OnClick_chkbox1 {

   my ($self, $event) =@_;
   my $title='Cleanup on Terminate?';
   my $message='When this box is checked, upon termination of the '.
               'FullAuto Automates EVERYTHING Demonstration window, '.
               'a cleanup process is launched which will destroy all the '.
               'servers this Demo creates on Amazon EC2, as well as all files '.
               'cached locally. NOTHING will be saved except for this '.
               'FullAuto_DEMO_MSWin.exe file itself, which you '.
               'may manually delete. You will have to launch a '.
               'new FullAuto server from Amazon and download a new '.
               'key file and credentials file to run the Demo again, '.
               'if you terminate this instance of the Demo with this '.
               'box checked. So it is recommended that you DO NOT have '.
               'this box checked until you are pretty certain you have no '.
               'more need to run the FullAuto Demo, for yourself or others.';
   my $dialog=Wx::MessageDialog->new(
      $self,$message,$title,wxOK|wxCANCEL|wxICON_EXCLAMATION);
   $dialog->SetOKCancelLabels('OK','CANCEL Cleanup');
   my $choice=$dialog->ShowModal() if $self->{cucb}->IsChecked();
   $choice||=0;
   if ($choice==5101) {
      $self->{cucb}->SetValue(0);
   }

}

sub OnClick_chkbox2 {

   my ($self, $event) =@_;
   my $desktop=$ENV{HOMEDRIVE}.$ENV{HOMEPATH}.'\\desktop';
   my $filedlg = Wx::FileDialog->new($self,         # parent
                                     'Open File',   # Caption
                                     $desktop,      # Default directory
                                     'putty',       # Default file
                                     "putty utilities (*.exe)|*.exe", # wildcard
                                     wxFD_SAVE|wxFD_OVERWRITE_PROMPT); #style
   # If the user really selected one
   if ($filedlg->ShowModal==wxID_OK)
   {
       my $filename = $filedlg->GetPath;
       my $dir=$filename;
       $dir=~s/^(.*)\\.*$/$1/;
       copy "putty.exe", $filename;
       copy "puttygen.exe", "$dir\\puttygen.exe";
       copy "pscp.exe", "$dir\\pscp.exe";
   }
   $self->{epcb}->SetValue(0);

}

sub OnClick_chkbox3 {

   my ($self, $event) =@_;
   my $title='Launch New FullAuto Server?';
   my $message='';
   if (-e "ip.txt") {
      $message='It is important to note that this copy of '.
               'FullAuto_DEMO_MSWin.exe is supplied with active '.
               'credentials enabling you to bypass the somewhat lengthy '.
               'FullAuto Server setup, and saving you the task of having '.
               'to work with Amazon\'s AWS EC2 web dashboard. If you proceed '.
               'with this choice, you will have to first launch a server '.
               'from the Amazon AWS EC2 dashboard, create and download a new '.
               'private key, and obtain access credentials for the Amazon '.
               'API. Then you will have to wait at least 20 minutes for '.
               'a new FullAuto setup to be downloaded and installed on the '.
               'new FullAuto server before you can obtain the same setup, '.
               'access, and ability to run and view the Demo that you have '.
               "now.\n\nYOU CANNOT REVERSE THIS DECISION!\n\nOnce you proceed ".
               'with the choise to Launch a new FullAuto Server, the '.
               'currently active credentials will be permanently discarded '.
               "and unrecoverable.\n\nDo you still wish to proceed?";
   } elsif (-e "saved.txt") {
      $message='You have checked the box to Launch a New FullAuto Server. '.
               'Understand that if you proceed with this choice, that your '.
               'current settings will be permanently discarded. You will '.
               'again have to launch a server from the Amazon AWS EC2 '.
               'dashboard, or specify a pre-existing server (use the Amazon '.
               'AWS EC2 dashboard to learn the IP Address of any pre-existing '.
               'servers.) You will again have to create, download and '.
               'specify a credentials.csv file, or use a pre-existing one '.
               '(if the credentials are still active in AWS.) You will again '.
               'have to indicate a key file (<filename>.pem, a new one you '.
               'can choose to create when launching a new server, or '.
               'pre-existing if you have one that is still active. You will '.
               'again have to wait at least 20 minutes for a new FullAuto '.
               'install to take place before you can obtain the same setup '.
               'access, and ability to run and view the Demp that have now. '.
               "\n\nYOU CANNOT REVERSE THIS DECISION!\n\nOnce you proceed ".
               'with the choice to Launch a new FullAuto Server, the current '.
               'settings will be permanently discarded and unrecoverable '.
               "(except by manual re-entry.)\n\nDo you still wish to proceed?";
   } else {
      $self->{nscb}->SetValue(1);
      $message='There are no saved settings, and a Demo is not currently '.
               'running. To run the FullAuto Demo, a fully functioning '.
               'FullAuto Server is necessary, which it is the job of this '.
               'FullAuto_DEMO_MSWin.exe application/utility to assist you '.
               'with. Therefore, this box will remain checked until such '.
               'time as the first FullAuto Server install has been launched';
      my $dialog=Wx::MessageDialog->new(
         $self,$message,$title,wxOK);
      my $choice=$dialog->ShowModal();
      return;
   }
   my $dialog=Wx::MessageDialog->new(
      $self,$message,$title,wxYES|wxNO|wxICON_EXCLAMATION);
   my $choice=$dialog->ShowModal() if $self->{nscb}->IsChecked();
   $choice||=0;
   if ($choice==5104) {
      $self->{nscb}->SetValue(0);
   } elsif (-e "saved.txt") {
      unlink "saved.txt";
      unlink "putty.log";
      $self->{key}->Enable(1);
      $self->{credentials}->Enable(1);
      $self->{ipbox}->Clear();
      $self->{ipbox}->Enable(1);
      $self->{fp1}->SetPath('');
      $self->{fp1}->Enable(1);
      $self->{fp2}->SetPath('');
      $self->{fp2}->Enable(1);
      $self->{dashboard}->SetBackgroundColour(Wx::Colour->new("RED"));
      $self->{statbm}->SetBitmap($self->{notready});
      $self->{nscb}->SetValue(1);
      $self->{bb}->Enable(0);
   }
}

sub OnClick_button1 {

   my ($self, $event) =@_;
   my $url='https://portal.aws.amazon.com/gp/aws/developer/'.
           'registration/index.html';
   Wx::LaunchDefaultBrowser($url,wxBROWSER_NEW_WINDOW);
   #$self->{righttop}->ChangeSelection(1);
   #$self->{html}->LoadURL($self->{html}->{defaulturl});
   #print "BUTTON ONE WAS PRESSED\n";

}

sub OnClick_button2 {

   my ($self, $event) =@_;
   my $url='https://console.aws.amazon.com/iam/#users';
   Wx::LaunchDefaultBrowser($url,wxBROWSER_NEW_WINDOW);
   #$self->{righttop}->ChangeSelection(1);
   #$self->{html}->LoadURL('https://console.aws.amazon.com/iam/#users');
   #print "BUTTON TWO WAS PRESSED\n";

}

sub OnClick_button3 {

   my ($self, $event) =@_;
   my $url='https://console.aws.amazon.com/ec2';
   Wx::LaunchDefaultBrowser($url,wxBROWSER_NEW_WINDOW);
   #$self->{righttop}->ChangeSelection(1);
   #$self->{html}->LoadURL('https://console.aws.amazon.com/ec2');
   #print "BUTTON THREE WAS PRESSED\n";

}

sub on_drop {

    my( $self, $wxDropFilesEvent ) = @_;
    my @files = $wxDropFilesEvent->GetFiles;
    if ($files[0]=~/csv$/) {
       $self->{fp2}->SetPath($files[0]);
    } elsif ($files[0]=~/pem$/) {
       $self->{fp1}->SetPath($files[0]);
    }
}

sub on_media3_loaded {

    my( $self, $event ) = @_;
    #Wx::LogMessage( 'Media loaded, start playback' );
    unless (exists $self->{done3}) {
       $self->{media3}->Play;
       $self->{media3}->Pause;
       $self->{media3}->Seek(0,0);
       $self->{done3}=1;
    }
}

sub on_media2_loaded {

    my( $self, $event ) = @_;
    #Wx::LogMessage( 'Media loaded, start playback' );
    unless (exists $self->{done2}) {
       $self->{media2}->Play;
       $self->{media2}->Pause;
       $self->{media2}->Seek(0,0);
       $self->{done2}=1;
    }
}

sub on_media_loaded {

    my( $self, $event ) = @_;
    #Wx::LogMessage( 'Media loaded, start playback' );
    unless (exists $self->{done}) {
       $self->{media}->Play;
       $self->{media}->Pause;
       $self->{media}->Seek(0,0);
       $self->{done}=1;
    }
}

sub GoToDefBrowser {

   my ( $self ) = @_;
   my $url=$self->{webview}->GetCurrentURL();
   Wx::LaunchDefaultBrowser($url,wxBROWSER_NEW_WINDOW);

   return;

}

sub OnBtnURL {
    my ($self, $event) = @_;

    my $url=$self->{webview}->GetCurrentURL();
    my $dialog = Wx::TextEntryDialog->new
        ( $self, "Enter a URL to load", "Enter a URL to load",
        $url );
    my $res = $dialog->ShowModal;
    my $rvalue =  $dialog->GetValue;
    $dialog->Destroy;
    return if $res == wxID_CANCEL;
    $self->{defaulturl} = $rvalue;
    $self->{webview}->LoadURL( $rvalue );
}

sub OnBtnBack {
    my ($self, $event) = @_;
    $self->{webview}->GoBack if $self->{webview}->CanGoBack;
}

sub OnBtnForward {
    my ($self, $event) = @_;
    $self->{webview}->GoForward if $self->{webview}->CanGoForward;
}

sub OnBtnHistory {
    my ($self, $event) = @_;
    my @past = $self->{webview}->GetBackwardHistory;
    my @future = $self->{webview}->GetForwardHistory;

    my $ptext = '<h3>Backward History</h3><br>';
    $ptext .= $_->GetTitle . ' : ' .  $_->GetUrl . '<br>' for ( @past );
    $ptext .= '<h3>Forward History</h3><br>';
    $ptext .= $_->GetTitle . ' : ' .  $_->GetUrl . '<br>' for ( @future );
    $ptext .= '</font>';

    $self->{webview}->SelectAll;
    $self->{webview}->DeleteSelection;

    $self->{webview}->SetPage($ptext, 'http://localhost:54321/');
}

sub on_find {

   my( $self ) = @_;
   $self->get_search_term;
   $self->search;

   return;
}

sub on_find_again {

   my( $self ) = @_;
   if (not $self->search_term) {
       $self->get_search_term;
   }
   $self->search;

   return;
}

sub get_search_term {

   my ($self) = @_;

   my $search_term = $self->search_term || '';
   my $dialog = Wx::TextEntryDialog->new( $self, "",
                "Search term", $search_term );
   if ($dialog->ShowModal == wxID_CANCEL) {
       $dialog->Destroy;
       return;
   }
   $search_term = $dialog->GetValue;
   $self->search_term($search_term);
   $dialog->Destroy;
   return;
}

sub search {

   my ($self) = @_;

   my $search_term = $self->search_term;
   return if not $search_term;

   my $code = $self->{source};
   my ($from, $to) = $code->GetSelection;
   my $last = $code->isa( 'Wx::TextCtrl' ) ? $code->GetLastPosition()
            : $code->GetLength();
   my $str  = $code->isa( 'Wx::TextCtrl' ) ? $code->GetRange(0, $last) 
            : $code->GetTextRange(0, $last);
   my $pos = index($str, $search_term, $from+1);
   if (-1 == $pos) {
       $pos = index($str, $search_term);
   }
   if (-1 == $pos) {
       return; # not found
   }

   $code->SetSelection($pos, $pos+length($search_term));

   return;
}

sub on_close {

   my( $self, $event ) = @_;
   chdir $self->{begin_cwd};
   $event->Skip;
   if ($self->{cucb}->IsChecked()) {
print "PAR_TEMP=$ENV{PAR_TEMP}\n" if exists $ENV{PAR_TEMP};
      if (exists $ENV{PAR_TEMP}) {
         my $pardir=$ENV{PAR_TEMP};
         eval {
            unlink $pardir."/inc/putty.log";
         };
         print $@ if $@;
         $pardir=~s/^(.*)\\.*$/$1/;
         open(FH,">clean_fullauto_demo.bat");
         print FH "ping 127.0.0.1 -n 1 -w 2000 > nul\n";
         print FH "rmdir /S /Q $pardir\n";
         print FH "ping 127.0.0.1 -n 1 -w 2000 > nul\n";
         print FH "rmdir /S /Q $pardir\n";
         print FH 'start /b "" cmd /c del "%~f0"&exit /b';
         close FH;
         my @arg=('clean_fullauto_demo.bat');
         exec @arg;
      }
   }
   
}

sub on_about {

   my( $self ) = @_;
   use Wx qw(wxOK wxCENTRE wxVERSION_STRING);

   my $info = Wx::AboutDialogInfo->new;

   $info->SetName( "FullAuto Demonstration" );
   $info->SetVersion( '0.01' );
   $info->SetDescription( 'FullAuto Automates EVERYTHING Demonstration' );
   $info->SetCopyright(
      "(c) 2000-2015 Brian Kelly <Brian.Kelly\@FullAutoSoftware.net>" );
   $info->SetWebSite(
      'http://www.FullAutoSoftware.net', 'The FullAuto web site' );
   $info->AddDeveloper( 'Brian Kelly <Brian.Kelly@FullAutoSoftware.net>' );
   $info->SetIcon(Wx::Icon->new("FA.ico",wxBITMAP_TYPE_ICO));

   Wx::AboutBox( $info );

}

# TODO: disallow copy when not the code is in focus
# or copy the text from the log window too.
sub on_copy {
print "ONCOPY\n";
   my( $self ) = @_;

   my $code = $self->{source};
   my ($from, $to) = $code->GetSelection;
   my $str = $code->isa( 'Wx::TextCtrl' ) ? $code->GetRange($from, $to)
                                           : $code->GetTextRange($from, $to);
   if (wxTheClipboard->Open()) {
       wxTheClipboard->SetData( Wx::TextDataObject->new($str) );
       wxTheClipboard->Close();
   }

   return;
}

1;
