#!/usr/bin/perl
# $Id: Makefile.PL 41 2005-06-21 18:27:04Z rcaputo $

use ExtUtils::MakeMaker;

# Touch CHANGES so it exists.
open(CHANGES, ">>CHANGES") and close CHANGES;

WriteMakefile(
  NAME         => 'POE::Component::Client::Ping',
  AUTHOR       => 'Rocco Caputo <rcaputo@cpan.org>',
  ABSTRACT     => 'POE component for non-blocking/concurrent ICMP ping.',
  VERSION_FROM => 'Ping.pm',

  PM           => { 'Ping.pm'   => '$(INST_LIBDIR)/Ping.pm' },
  PREREQ_PM    => {
    POE         => 0.11,
    Time::HiRes => 1.20,
  },
  dist         => {
    COMPRESS   => 'gzip -9f',
    SUFFIX     => 'gz',
    PREOP      => (
      'svn-log.perl --repo https://thirdlobe.com/svn/poco-client-ping| ' .
      'tee ./$(DISTNAME)-$(VERSION)/CHANGES > ./CHANGES'
    ),
  },
);
