package Alien::FFI;

use strict;
use warnings;
use 5.010;
use Carp qw( croak );

# ABSTRACT: Get libffi compiler and linker flags
our $VERSION = '0.08'; # VERSION


sub new
{
  my($class) = @_;
  bless {}, $class;
}

my $pkg_config = 'pkg-config';
if(eval q{ use PkgConfig (); 1 })
{
  $pkg_config = "$^X $INC{'PkgConfig.pm'}";
}

sub install_type
{
  'system';
}

sub cflags
{
  state $cflags;
  
  unless(defined $cflags)
  {
    $cflags = `$pkg_config --cflags libffi`;
    $cflags = '' unless $? == 0;
    chomp $cflags;
  }
  
  $cflags;
}

sub libs
{
  state $libs;
  
  unless(defined $libs)
  {
    $libs = `$pkg_config --libs libffi`;
    $libs = '-lffi' unless $? == 0;
    chomp $libs;
  }
  
  $libs;
}

sub dist_dir
{
  croak "Failed to find share dir for dist 'Alt-Alien-FFI-System'";
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Alien::FFI - Get libffi compiler and linker flags

=head1 VERSION

version 0.08

=head1 SYNOPSIS

 use Alien::FFI;
 my $cflags = Alien::FFI->cflags;
 my $libs   = Alien::FFI->libs;

=head1 DESCRIPTION

This is an alternate implementation of L<Alien::FFI>.  For the
full documentation, see

L<https://metacpan.org/pod/Alien::FFI>

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
