#!perl

use strict;
use warnings;

use Test::More tests => 3829;

my $class;

BEGIN { $class = 'Math::BigInt::Lite'; }
BEGIN { use_ok($class, '0.16'); }

while (<DATA>) {
    s/#.*$//;           # remove comments
    s/\s+$//;           # remove trailing whitespace
    next unless length; # skip empty lines

    my ($in0, $out0) = split /:/;
    my $x;

    my $test = qq|\$x = $class -> from_hex("$in0");|;
    my $desc = $test;

    eval $test;
    die $@ if $@;       # this should never happen

    subtest $desc, sub {
        plan tests => 2,

        # Check output.

        # Explcitly setting Math::BigInt here is bad. We should use be able to
        # use Math::BigInt::Lite -> config("upgrade"), but that doesn't work
        # yet. FIXME!

        my $xref = ref($x);
        ok($xref eq $class || $xref eq 'Math::BigInt',
           "output arg is a $class or a Math::BigInt");

        is($x, $out0, 'output arg has the right value');
    };

}

__END__

NaN:NaN
+inf:NaN
-inf:NaN

###############################################################################
# Absolute value is close to 2^1 = 2
###############################################################################

# Unsigned

0x0:0
0x1:1
0x2:2
0x3:3
0x4:4

x0:0
x1:1
x2:2
x3:3
x4:4

0:0
1:1
2:2
3:3
4:4

# Positive

+0x0:0
+0x1:1
+0x2:2
+0x3:3
+0x4:4

+x0:0
+x1:1
+x2:2
+x3:3
+x4:4

+0:0
+1:1
+2:2
+3:3
+4:4

# Negative

-0x0:0
-0x1:-1
-0x2:-2
-0x3:-3
-0x4:-4

-x0:0
-x1:-1
-x2:-2
-x3:-3
-x4:-4

-0:0
-1:-1
-2:-2
-3:-3
-4:-4

###############################################################################
# Absolute value is close to 2^2 = 4
###############################################################################

# Unsigned

0x2:2
0x3:3
0x4:4
0x5:5
0x6:6

x2:2
x3:3
x4:4
x5:5
x6:6

2:2
3:3
4:4
5:5
6:6

# Positive

+0x2:2
+0x3:3
+0x4:4
+0x5:5
+0x6:6

+x2:2
+x3:3
+x4:4
+x5:5
+x6:6

+2:2
+3:3
+4:4
+5:5
+6:6

# Negative

-0x2:-2
-0x3:-3
-0x4:-4
-0x5:-5
-0x6:-6

-x2:-2
-x3:-3
-x4:-4
-x5:-5
-x6:-6

-2:-2
-3:-3
-4:-4
-5:-5
-6:-6

###############################################################################
# Absolute value is close to 2^3 = 8
###############################################################################

# Unsigned

0x6:6
0x7:7
0x8:8
0x9:9
0xa:10

x6:6
x7:7
x8:8
x9:9
xa:10

6:6
7:7
8:8
9:9
a:10

# Positive

+0x6:6
+0x7:7
+0x8:8
+0x9:9
+0xa:10

+x6:6
+x7:7
+x8:8
+x9:9
+xa:10

+6:6
+7:7
+8:8
+9:9
+a:10

# Negative

-0x6:-6
-0x7:-7
-0x8:-8
-0x9:-9
-0xa:-10

-x6:-6
-x7:-7
-x8:-8
-x9:-9
-xa:-10

-6:-6
-7:-7
-8:-8
-9:-9
-a:-10

###############################################################################
# Absolute value is close to 2^4 = 16
###############################################################################

# Unsigned

0xe:14
0xf:15
0x10:16
0x11:17
0x12:18

xe:14
xf:15
x10:16
x11:17
x12:18

e:14
f:15
10:16
11:17
12:18

# Positive

+0xe:14
+0xf:15
+0x10:16
+0x11:17
+0x12:18

+xe:14
+xf:15
+x10:16
+x11:17
+x12:18

+e:14
+f:15
+10:16
+11:17
+12:18

# Negative

-0xe:-14
-0xf:-15
-0x10:-16
-0x11:-17
-0x12:-18

-xe:-14
-xf:-15
-x10:-16
-x11:-17
-x12:-18

-e:-14
-f:-15
-10:-16
-11:-17
-12:-18

###############################################################################
# Absolute value is close to 2^5 = 32
###############################################################################

# Unsigned

0x1e:30
0x1f:31
0x20:32
0x21:33
0x22:34

x1e:30
x1f:31
x20:32
x21:33
x22:34

1e:30
1f:31
20:32
21:33
22:34

# Positive

+0x1e:30
+0x1f:31
+0x20:32
+0x21:33
+0x22:34

+x1e:30
+x1f:31
+x20:32
+x21:33
+x22:34

+1e:30
+1f:31
+20:32
+21:33
+22:34

# Negative

-0x1e:-30
-0x1f:-31
-0x20:-32
-0x21:-33
-0x22:-34

-x1e:-30
-x1f:-31
-x20:-32
-x21:-33
-x22:-34

-1e:-30
-1f:-31
-20:-32
-21:-33
-22:-34

###############################################################################
# Absolute value is close to 2^6 = 64
###############################################################################

# Unsigned

0x3e:62
0x3f:63
0x40:64
0x41:65
0x42:66

x3e:62
x3f:63
x40:64
x41:65
x42:66

3e:62
3f:63
40:64
41:65
42:66

# Positive

+0x3e:62
+0x3f:63
+0x40:64
+0x41:65
+0x42:66

+x3e:62
+x3f:63
+x40:64
+x41:65
+x42:66

+3e:62
+3f:63
+40:64
+41:65
+42:66

# Negative

-0x3e:-62
-0x3f:-63
-0x40:-64
-0x41:-65
-0x42:-66

-x3e:-62
-x3f:-63
-x40:-64
-x41:-65
-x42:-66

-3e:-62
-3f:-63
-40:-64
-41:-65
-42:-66

###############################################################################
# Absolute value is close to 2^7 = 128
###############################################################################

# Unsigned

0x7e:126
0x7f:127
0x80:128
0x81:129
0x82:130

x7e:126
x7f:127
x80:128
x81:129
x82:130

7e:126
7f:127
80:128
81:129
82:130

# Positive

+0x7e:126
+0x7f:127
+0x80:128
+0x81:129
+0x82:130

+x7e:126
+x7f:127
+x80:128
+x81:129
+x82:130

+7e:126
+7f:127
+80:128
+81:129
+82:130

# Negative

-0x7e:-126
-0x7f:-127
-0x80:-128
-0x81:-129
-0x82:-130

-x7e:-126
-x7f:-127
-x80:-128
-x81:-129
-x82:-130

-7e:-126
-7f:-127
-80:-128
-81:-129
-82:-130

###############################################################################
# Absolute value is close to 2^8 = 256
###############################################################################

# Unsigned

0xfe:254
0xff:255
0x100:256
0x101:257
0x102:258

xfe:254
xff:255
x100:256
x101:257
x102:258

fe:254
ff:255
100:256
101:257
102:258

# Positive

+0xfe:254
+0xff:255
+0x100:256
+0x101:257
+0x102:258

+xfe:254
+xff:255
+x100:256
+x101:257
+x102:258

+fe:254
+ff:255
+100:256
+101:257
+102:258

# Negative

-0xfe:-254
-0xff:-255
-0x100:-256
-0x101:-257
-0x102:-258

-xfe:-254
-xff:-255
-x100:-256
-x101:-257
-x102:-258

-fe:-254
-ff:-255
-100:-256
-101:-257
-102:-258

###############################################################################
# Absolute value is close to 2^9 = 512
###############################################################################

# Unsigned

0x1fe:510
0x1ff:511
0x200:512
0x201:513
0x202:514

x1fe:510
x1ff:511
x200:512
x201:513
x202:514

1fe:510
1ff:511
200:512
201:513
202:514

# Positive

+0x1fe:510
+0x1ff:511
+0x200:512
+0x201:513
+0x202:514

+x1fe:510
+x1ff:511
+x200:512
+x201:513
+x202:514

+1fe:510
+1ff:511
+200:512
+201:513
+202:514

# Negative

-0x1fe:-510
-0x1ff:-511
-0x200:-512
-0x201:-513
-0x202:-514

-x1fe:-510
-x1ff:-511
-x200:-512
-x201:-513
-x202:-514

-1fe:-510
-1ff:-511
-200:-512
-201:-513
-202:-514

###############################################################################
# Absolute value is close to 2^10 = 1024
###############################################################################

# Unsigned

0x3fe:1022
0x3ff:1023
0x400:1024
0x401:1025
0x402:1026

x3fe:1022
x3ff:1023
x400:1024
x401:1025
x402:1026

3fe:1022
3ff:1023
400:1024
401:1025
402:1026

# Positive

+0x3fe:1022
+0x3ff:1023
+0x400:1024
+0x401:1025
+0x402:1026

+x3fe:1022
+x3ff:1023
+x400:1024
+x401:1025
+x402:1026

+3fe:1022
+3ff:1023
+400:1024
+401:1025
+402:1026

# Negative

-0x3fe:-1022
-0x3ff:-1023
-0x400:-1024
-0x401:-1025
-0x402:-1026

-x3fe:-1022
-x3ff:-1023
-x400:-1024
-x401:-1025
-x402:-1026

-3fe:-1022
-3ff:-1023
-400:-1024
-401:-1025
-402:-1026

###############################################################################
# Absolute value is close to 2^11 = 2048
###############################################################################

# Unsigned

0x7fe:2046
0x7ff:2047
0x800:2048
0x801:2049
0x802:2050

x7fe:2046
x7ff:2047
x800:2048
x801:2049
x802:2050

7fe:2046
7ff:2047
800:2048
801:2049
802:2050

# Positive

+0x7fe:2046
+0x7ff:2047
+0x800:2048
+0x801:2049
+0x802:2050

+x7fe:2046
+x7ff:2047
+x800:2048
+x801:2049
+x802:2050

+7fe:2046
+7ff:2047
+800:2048
+801:2049
+802:2050

# Negative

-0x7fe:-2046
-0x7ff:-2047
-0x800:-2048
-0x801:-2049
-0x802:-2050

-x7fe:-2046
-x7ff:-2047
-x800:-2048
-x801:-2049
-x802:-2050

-7fe:-2046
-7ff:-2047
-800:-2048
-801:-2049
-802:-2050

###############################################################################
# Absolute value is close to 2^12 = 4096
###############################################################################

# Unsigned

0xffe:4094
0xfff:4095
0x1000:4096
0x1001:4097
0x1002:4098

xffe:4094
xfff:4095
x1000:4096
x1001:4097
x1002:4098

ffe:4094
fff:4095
1000:4096
1001:4097
1002:4098

# Positive

+0xffe:4094
+0xfff:4095
+0x1000:4096
+0x1001:4097
+0x1002:4098

+xffe:4094
+xfff:4095
+x1000:4096
+x1001:4097
+x1002:4098

+ffe:4094
+fff:4095
+1000:4096
+1001:4097
+1002:4098

# Negative

-0xffe:-4094
-0xfff:-4095
-0x1000:-4096
-0x1001:-4097
-0x1002:-4098

-xffe:-4094
-xfff:-4095
-x1000:-4096
-x1001:-4097
-x1002:-4098

-ffe:-4094
-fff:-4095
-1000:-4096
-1001:-4097
-1002:-4098

###############################################################################
# Absolute value is close to 2^13 = 8192
###############################################################################

# Unsigned

0x1ffe:8190
0x1fff:8191
0x2000:8192
0x2001:8193
0x2002:8194

x1ffe:8190
x1fff:8191
x2000:8192
x2001:8193
x2002:8194

1ffe:8190
1fff:8191
2000:8192
2001:8193
2002:8194

# Positive

+0x1ffe:8190
+0x1fff:8191
+0x2000:8192
+0x2001:8193
+0x2002:8194

+x1ffe:8190
+x1fff:8191
+x2000:8192
+x2001:8193
+x2002:8194

+1ffe:8190
+1fff:8191
+2000:8192
+2001:8193
+2002:8194

# Negative

-0x1ffe:-8190
-0x1fff:-8191
-0x2000:-8192
-0x2001:-8193
-0x2002:-8194

-x1ffe:-8190
-x1fff:-8191
-x2000:-8192
-x2001:-8193
-x2002:-8194

-1ffe:-8190
-1fff:-8191
-2000:-8192
-2001:-8193
-2002:-8194

###############################################################################
# Absolute value is close to 2^14 = 16384
###############################################################################

# Unsigned

0x3ffe:16382
0x3fff:16383
0x4000:16384
0x4001:16385
0x4002:16386

x3ffe:16382
x3fff:16383
x4000:16384
x4001:16385
x4002:16386

3ffe:16382
3fff:16383
4000:16384
4001:16385
4002:16386

# Positive

+0x3ffe:16382
+0x3fff:16383
+0x4000:16384
+0x4001:16385
+0x4002:16386

+x3ffe:16382
+x3fff:16383
+x4000:16384
+x4001:16385
+x4002:16386

+3ffe:16382
+3fff:16383
+4000:16384
+4001:16385
+4002:16386

# Negative

-0x3ffe:-16382
-0x3fff:-16383
-0x4000:-16384
-0x4001:-16385
-0x4002:-16386

-x3ffe:-16382
-x3fff:-16383
-x4000:-16384
-x4001:-16385
-x4002:-16386

-3ffe:-16382
-3fff:-16383
-4000:-16384
-4001:-16385
-4002:-16386

###############################################################################
# Absolute value is close to 2^15 = 32768
###############################################################################

# Unsigned

0x7ffe:32766
0x7fff:32767
0x8000:32768
0x8001:32769
0x8002:32770

x7ffe:32766
x7fff:32767
x8000:32768
x8001:32769
x8002:32770

7ffe:32766
7fff:32767
8000:32768
8001:32769
8002:32770

# Positive

+0x7ffe:32766
+0x7fff:32767
+0x8000:32768
+0x8001:32769
+0x8002:32770

+x7ffe:32766
+x7fff:32767
+x8000:32768
+x8001:32769
+x8002:32770

+7ffe:32766
+7fff:32767
+8000:32768
+8001:32769
+8002:32770

# Negative

-0x7ffe:-32766
-0x7fff:-32767
-0x8000:-32768
-0x8001:-32769
-0x8002:-32770

-x7ffe:-32766
-x7fff:-32767
-x8000:-32768
-x8001:-32769
-x8002:-32770

-7ffe:-32766
-7fff:-32767
-8000:-32768
-8001:-32769
-8002:-32770

###############################################################################
# Absolute value is close to 2^16 = 65536
###############################################################################

# Unsigned

0xfffe:65534
0xffff:65535
0x10000:65536
0x10001:65537
0x10002:65538

xfffe:65534
xffff:65535
x10000:65536
x10001:65537
x10002:65538

fffe:65534
ffff:65535
10000:65536
10001:65537
10002:65538

# Positive

+0xfffe:65534
+0xffff:65535
+0x10000:65536
+0x10001:65537
+0x10002:65538

+xfffe:65534
+xffff:65535
+x10000:65536
+x10001:65537
+x10002:65538

+fffe:65534
+ffff:65535
+10000:65536
+10001:65537
+10002:65538

# Negative

-0xfffe:-65534
-0xffff:-65535
-0x10000:-65536
-0x10001:-65537
-0x10002:-65538

-xfffe:-65534
-xffff:-65535
-x10000:-65536
-x10001:-65537
-x10002:-65538

-fffe:-65534
-ffff:-65535
-10000:-65536
-10001:-65537
-10002:-65538

###############################################################################
# Absolute value is close to 2^17 = 131072
###############################################################################

# Unsigned

0x1fffe:131070
0x1ffff:131071
0x20000:131072
0x20001:131073
0x20002:131074

x1fffe:131070
x1ffff:131071
x20000:131072
x20001:131073
x20002:131074

1fffe:131070
1ffff:131071
20000:131072
20001:131073
20002:131074

# Positive

+0x1fffe:131070
+0x1ffff:131071
+0x20000:131072
+0x20001:131073
+0x20002:131074

+x1fffe:131070
+x1ffff:131071
+x20000:131072
+x20001:131073
+x20002:131074

+1fffe:131070
+1ffff:131071
+20000:131072
+20001:131073
+20002:131074

# Negative

-0x1fffe:-131070
-0x1ffff:-131071
-0x20000:-131072
-0x20001:-131073
-0x20002:-131074

-x1fffe:-131070
-x1ffff:-131071
-x20000:-131072
-x20001:-131073
-x20002:-131074

-1fffe:-131070
-1ffff:-131071
-20000:-131072
-20001:-131073
-20002:-131074

###############################################################################
# Absolute value is close to 2^18 = 262144
###############################################################################

# Unsigned

0x3fffe:262142
0x3ffff:262143
0x40000:262144
0x40001:262145
0x40002:262146

x3fffe:262142
x3ffff:262143
x40000:262144
x40001:262145
x40002:262146

3fffe:262142
3ffff:262143
40000:262144
40001:262145
40002:262146

# Positive

+0x3fffe:262142
+0x3ffff:262143
+0x40000:262144
+0x40001:262145
+0x40002:262146

+x3fffe:262142
+x3ffff:262143
+x40000:262144
+x40001:262145
+x40002:262146

+3fffe:262142
+3ffff:262143
+40000:262144
+40001:262145
+40002:262146

# Negative

-0x3fffe:-262142
-0x3ffff:-262143
-0x40000:-262144
-0x40001:-262145
-0x40002:-262146

-x3fffe:-262142
-x3ffff:-262143
-x40000:-262144
-x40001:-262145
-x40002:-262146

-3fffe:-262142
-3ffff:-262143
-40000:-262144
-40001:-262145
-40002:-262146

###############################################################################
# Absolute value is close to 2^19 = 524288
###############################################################################

# Unsigned

0x7fffe:524286
0x7ffff:524287
0x80000:524288
0x80001:524289
0x80002:524290

x7fffe:524286
x7ffff:524287
x80000:524288
x80001:524289
x80002:524290

7fffe:524286
7ffff:524287
80000:524288
80001:524289
80002:524290

# Positive

+0x7fffe:524286
+0x7ffff:524287
+0x80000:524288
+0x80001:524289
+0x80002:524290

+x7fffe:524286
+x7ffff:524287
+x80000:524288
+x80001:524289
+x80002:524290

+7fffe:524286
+7ffff:524287
+80000:524288
+80001:524289
+80002:524290

# Negative

-0x7fffe:-524286
-0x7ffff:-524287
-0x80000:-524288
-0x80001:-524289
-0x80002:-524290

-x7fffe:-524286
-x7ffff:-524287
-x80000:-524288
-x80001:-524289
-x80002:-524290

-7fffe:-524286
-7ffff:-524287
-80000:-524288
-80001:-524289
-80002:-524290

###############################################################################
# Absolute value is close to 2^20 = 1048576
###############################################################################

# Unsigned

0xffffe:1048574
0xfffff:1048575
0x100000:1048576
0x100001:1048577
0x100002:1048578

xffffe:1048574
xfffff:1048575
x100000:1048576
x100001:1048577
x100002:1048578

ffffe:1048574
fffff:1048575
100000:1048576
100001:1048577
100002:1048578

# Positive

+0xffffe:1048574
+0xfffff:1048575
+0x100000:1048576
+0x100001:1048577
+0x100002:1048578

+xffffe:1048574
+xfffff:1048575
+x100000:1048576
+x100001:1048577
+x100002:1048578

+ffffe:1048574
+fffff:1048575
+100000:1048576
+100001:1048577
+100002:1048578

# Negative

-0xffffe:-1048574
-0xfffff:-1048575
-0x100000:-1048576
-0x100001:-1048577
-0x100002:-1048578

-xffffe:-1048574
-xfffff:-1048575
-x100000:-1048576
-x100001:-1048577
-x100002:-1048578

-ffffe:-1048574
-fffff:-1048575
-100000:-1048576
-100001:-1048577
-100002:-1048578

###############################################################################
# Absolute value is close to 2^21 = 2097152
###############################################################################

# Unsigned

0x1ffffe:2097150
0x1fffff:2097151
0x200000:2097152
0x200001:2097153
0x200002:2097154

x1ffffe:2097150
x1fffff:2097151
x200000:2097152
x200001:2097153
x200002:2097154

1ffffe:2097150
1fffff:2097151
200000:2097152
200001:2097153
200002:2097154

# Positive

+0x1ffffe:2097150
+0x1fffff:2097151
+0x200000:2097152
+0x200001:2097153
+0x200002:2097154

+x1ffffe:2097150
+x1fffff:2097151
+x200000:2097152
+x200001:2097153
+x200002:2097154

+1ffffe:2097150
+1fffff:2097151
+200000:2097152
+200001:2097153
+200002:2097154

# Negative

-0x1ffffe:-2097150
-0x1fffff:-2097151
-0x200000:-2097152
-0x200001:-2097153
-0x200002:-2097154

-x1ffffe:-2097150
-x1fffff:-2097151
-x200000:-2097152
-x200001:-2097153
-x200002:-2097154

-1ffffe:-2097150
-1fffff:-2097151
-200000:-2097152
-200001:-2097153
-200002:-2097154

###############################################################################
# Absolute value is close to 2^22 = 4194304
###############################################################################

# Unsigned

0x3ffffe:4194302
0x3fffff:4194303
0x400000:4194304
0x400001:4194305
0x400002:4194306

x3ffffe:4194302
x3fffff:4194303
x400000:4194304
x400001:4194305
x400002:4194306

3ffffe:4194302
3fffff:4194303
400000:4194304
400001:4194305
400002:4194306

# Positive

+0x3ffffe:4194302
+0x3fffff:4194303
+0x400000:4194304
+0x400001:4194305
+0x400002:4194306

+x3ffffe:4194302
+x3fffff:4194303
+x400000:4194304
+x400001:4194305
+x400002:4194306

+3ffffe:4194302
+3fffff:4194303
+400000:4194304
+400001:4194305
+400002:4194306

# Negative

-0x3ffffe:-4194302
-0x3fffff:-4194303
-0x400000:-4194304
-0x400001:-4194305
-0x400002:-4194306

-x3ffffe:-4194302
-x3fffff:-4194303
-x400000:-4194304
-x400001:-4194305
-x400002:-4194306

-3ffffe:-4194302
-3fffff:-4194303
-400000:-4194304
-400001:-4194305
-400002:-4194306

###############################################################################
# Absolute value is close to 2^23 = 8388608
###############################################################################

# Unsigned

0x7ffffe:8388606
0x7fffff:8388607
0x800000:8388608
0x800001:8388609
0x800002:8388610

x7ffffe:8388606
x7fffff:8388607
x800000:8388608
x800001:8388609
x800002:8388610

7ffffe:8388606
7fffff:8388607
800000:8388608
800001:8388609
800002:8388610

# Positive

+0x7ffffe:8388606
+0x7fffff:8388607
+0x800000:8388608
+0x800001:8388609
+0x800002:8388610

+x7ffffe:8388606
+x7fffff:8388607
+x800000:8388608
+x800001:8388609
+x800002:8388610

+7ffffe:8388606
+7fffff:8388607
+800000:8388608
+800001:8388609
+800002:8388610

# Negative

-0x7ffffe:-8388606
-0x7fffff:-8388607
-0x800000:-8388608
-0x800001:-8388609
-0x800002:-8388610

-x7ffffe:-8388606
-x7fffff:-8388607
-x800000:-8388608
-x800001:-8388609
-x800002:-8388610

-7ffffe:-8388606
-7fffff:-8388607
-800000:-8388608
-800001:-8388609
-800002:-8388610

###############################################################################
# Absolute value is close to 2^24 = 16777216
###############################################################################

# Unsigned

0xfffffe:16777214
0xffffff:16777215
0x1000000:16777216
0x1000001:16777217
0x1000002:16777218

xfffffe:16777214
xffffff:16777215
x1000000:16777216
x1000001:16777217
x1000002:16777218

fffffe:16777214
ffffff:16777215
1000000:16777216
1000001:16777217
1000002:16777218

# Positive

+0xfffffe:16777214
+0xffffff:16777215
+0x1000000:16777216
+0x1000001:16777217
+0x1000002:16777218

+xfffffe:16777214
+xffffff:16777215
+x1000000:16777216
+x1000001:16777217
+x1000002:16777218

+fffffe:16777214
+ffffff:16777215
+1000000:16777216
+1000001:16777217
+1000002:16777218

# Negative

-0xfffffe:-16777214
-0xffffff:-16777215
-0x1000000:-16777216
-0x1000001:-16777217
-0x1000002:-16777218

-xfffffe:-16777214
-xffffff:-16777215
-x1000000:-16777216
-x1000001:-16777217
-x1000002:-16777218

-fffffe:-16777214
-ffffff:-16777215
-1000000:-16777216
-1000001:-16777217
-1000002:-16777218

###############################################################################
# Absolute value is close to 2^25 = 33554432
###############################################################################

# Unsigned

0x1fffffe:33554430
0x1ffffff:33554431
0x2000000:33554432
0x2000001:33554433
0x2000002:33554434

x1fffffe:33554430
x1ffffff:33554431
x2000000:33554432
x2000001:33554433
x2000002:33554434

1fffffe:33554430
1ffffff:33554431
2000000:33554432
2000001:33554433
2000002:33554434

# Positive

+0x1fffffe:33554430
+0x1ffffff:33554431
+0x2000000:33554432
+0x2000001:33554433
+0x2000002:33554434

+x1fffffe:33554430
+x1ffffff:33554431
+x2000000:33554432
+x2000001:33554433
+x2000002:33554434

+1fffffe:33554430
+1ffffff:33554431
+2000000:33554432
+2000001:33554433
+2000002:33554434

# Negative

-0x1fffffe:-33554430
-0x1ffffff:-33554431
-0x2000000:-33554432
-0x2000001:-33554433
-0x2000002:-33554434

-x1fffffe:-33554430
-x1ffffff:-33554431
-x2000000:-33554432
-x2000001:-33554433
-x2000002:-33554434

-1fffffe:-33554430
-1ffffff:-33554431
-2000000:-33554432
-2000001:-33554433
-2000002:-33554434

###############################################################################
# Absolute value is close to 2^26 = 67108864
###############################################################################

# Unsigned

0x3fffffe:67108862
0x3ffffff:67108863
0x4000000:67108864
0x4000001:67108865
0x4000002:67108866

x3fffffe:67108862
x3ffffff:67108863
x4000000:67108864
x4000001:67108865
x4000002:67108866

3fffffe:67108862
3ffffff:67108863
4000000:67108864
4000001:67108865
4000002:67108866

# Positive

+0x3fffffe:67108862
+0x3ffffff:67108863
+0x4000000:67108864
+0x4000001:67108865
+0x4000002:67108866

+x3fffffe:67108862
+x3ffffff:67108863
+x4000000:67108864
+x4000001:67108865
+x4000002:67108866

+3fffffe:67108862
+3ffffff:67108863
+4000000:67108864
+4000001:67108865
+4000002:67108866

# Negative

-0x3fffffe:-67108862
-0x3ffffff:-67108863
-0x4000000:-67108864
-0x4000001:-67108865
-0x4000002:-67108866

-x3fffffe:-67108862
-x3ffffff:-67108863
-x4000000:-67108864
-x4000001:-67108865
-x4000002:-67108866

-3fffffe:-67108862
-3ffffff:-67108863
-4000000:-67108864
-4000001:-67108865
-4000002:-67108866

###############################################################################
# Absolute value is close to 2^27 = 134217728
###############################################################################

# Unsigned

0x7fffffe:134217726
0x7ffffff:134217727
0x8000000:134217728
0x8000001:134217729
0x8000002:134217730

x7fffffe:134217726
x7ffffff:134217727
x8000000:134217728
x8000001:134217729
x8000002:134217730

7fffffe:134217726
7ffffff:134217727
8000000:134217728
8000001:134217729
8000002:134217730

# Positive

+0x7fffffe:134217726
+0x7ffffff:134217727
+0x8000000:134217728
+0x8000001:134217729
+0x8000002:134217730

+x7fffffe:134217726
+x7ffffff:134217727
+x8000000:134217728
+x8000001:134217729
+x8000002:134217730

+7fffffe:134217726
+7ffffff:134217727
+8000000:134217728
+8000001:134217729
+8000002:134217730

# Negative

-0x7fffffe:-134217726
-0x7ffffff:-134217727
-0x8000000:-134217728
-0x8000001:-134217729
-0x8000002:-134217730

-x7fffffe:-134217726
-x7ffffff:-134217727
-x8000000:-134217728
-x8000001:-134217729
-x8000002:-134217730

-7fffffe:-134217726
-7ffffff:-134217727
-8000000:-134217728
-8000001:-134217729
-8000002:-134217730

###############################################################################
# Absolute value is close to 2^28 = 268435456
###############################################################################

# Unsigned

0xffffffe:268435454
0xfffffff:268435455
0x10000000:268435456
0x10000001:268435457
0x10000002:268435458

xffffffe:268435454
xfffffff:268435455
x10000000:268435456
x10000001:268435457
x10000002:268435458

ffffffe:268435454
fffffff:268435455
10000000:268435456
10000001:268435457
10000002:268435458

# Positive

+0xffffffe:268435454
+0xfffffff:268435455
+0x10000000:268435456
+0x10000001:268435457
+0x10000002:268435458

+xffffffe:268435454
+xfffffff:268435455
+x10000000:268435456
+x10000001:268435457
+x10000002:268435458

+ffffffe:268435454
+fffffff:268435455
+10000000:268435456
+10000001:268435457
+10000002:268435458

# Negative

-0xffffffe:-268435454
-0xfffffff:-268435455
-0x10000000:-268435456
-0x10000001:-268435457
-0x10000002:-268435458

-xffffffe:-268435454
-xfffffff:-268435455
-x10000000:-268435456
-x10000001:-268435457
-x10000002:-268435458

-ffffffe:-268435454
-fffffff:-268435455
-10000000:-268435456
-10000001:-268435457
-10000002:-268435458

###############################################################################
# Absolute value is close to 2^29 = 536870912
###############################################################################

# Unsigned

0x1ffffffe:536870910
0x1fffffff:536870911
0x20000000:536870912
0x20000001:536870913
0x20000002:536870914

x1ffffffe:536870910
x1fffffff:536870911
x20000000:536870912
x20000001:536870913
x20000002:536870914

1ffffffe:536870910
1fffffff:536870911
20000000:536870912
20000001:536870913
20000002:536870914

# Positive

+0x1ffffffe:536870910
+0x1fffffff:536870911
+0x20000000:536870912
+0x20000001:536870913
+0x20000002:536870914

+x1ffffffe:536870910
+x1fffffff:536870911
+x20000000:536870912
+x20000001:536870913
+x20000002:536870914

+1ffffffe:536870910
+1fffffff:536870911
+20000000:536870912
+20000001:536870913
+20000002:536870914

# Negative

-0x1ffffffe:-536870910
-0x1fffffff:-536870911
-0x20000000:-536870912
-0x20000001:-536870913
-0x20000002:-536870914

-x1ffffffe:-536870910
-x1fffffff:-536870911
-x20000000:-536870912
-x20000001:-536870913
-x20000002:-536870914

-1ffffffe:-536870910
-1fffffff:-536870911
-20000000:-536870912
-20000001:-536870913
-20000002:-536870914

###############################################################################
# Absolute value is close to 2^30 = 1073741824
###############################################################################

# Unsigned

0x3ffffffe:1073741822
0x3fffffff:1073741823
0x40000000:1073741824
0x40000001:1073741825
0x40000002:1073741826

x3ffffffe:1073741822
x3fffffff:1073741823
x40000000:1073741824
x40000001:1073741825
x40000002:1073741826

3ffffffe:1073741822
3fffffff:1073741823
40000000:1073741824
40000001:1073741825
40000002:1073741826

# Positive

+0x3ffffffe:1073741822
+0x3fffffff:1073741823
+0x40000000:1073741824
+0x40000001:1073741825
+0x40000002:1073741826

+x3ffffffe:1073741822
+x3fffffff:1073741823
+x40000000:1073741824
+x40000001:1073741825
+x40000002:1073741826

+3ffffffe:1073741822
+3fffffff:1073741823
+40000000:1073741824
+40000001:1073741825
+40000002:1073741826

# Negative

-0x3ffffffe:-1073741822
-0x3fffffff:-1073741823
-0x40000000:-1073741824
-0x40000001:-1073741825
-0x40000002:-1073741826

-x3ffffffe:-1073741822
-x3fffffff:-1073741823
-x40000000:-1073741824
-x40000001:-1073741825
-x40000002:-1073741826

-3ffffffe:-1073741822
-3fffffff:-1073741823
-40000000:-1073741824
-40000001:-1073741825
-40000002:-1073741826

###############################################################################
# Absolute value is close to 2^31 = 2147483648
###############################################################################

# Unsigned

0x7ffffffe:2147483646
0x7fffffff:2147483647
0x80000000:2147483648
0x80000001:2147483649
0x80000002:2147483650

x7ffffffe:2147483646
x7fffffff:2147483647
x80000000:2147483648
x80000001:2147483649
x80000002:2147483650

7ffffffe:2147483646
7fffffff:2147483647
80000000:2147483648
80000001:2147483649
80000002:2147483650

# Positive

+0x7ffffffe:2147483646
+0x7fffffff:2147483647
+0x80000000:2147483648
+0x80000001:2147483649
+0x80000002:2147483650

+x7ffffffe:2147483646
+x7fffffff:2147483647
+x80000000:2147483648
+x80000001:2147483649
+x80000002:2147483650

+7ffffffe:2147483646
+7fffffff:2147483647
+80000000:2147483648
+80000001:2147483649
+80000002:2147483650

# Negative

-0x7ffffffe:-2147483646
-0x7fffffff:-2147483647
-0x80000000:-2147483648
-0x80000001:-2147483649
-0x80000002:-2147483650

-x7ffffffe:-2147483646
-x7fffffff:-2147483647
-x80000000:-2147483648
-x80000001:-2147483649
-x80000002:-2147483650

-7ffffffe:-2147483646
-7fffffff:-2147483647
-80000000:-2147483648
-80000001:-2147483649
-80000002:-2147483650

###############################################################################
# Absolute value is close to 2^32 = 4294967296
###############################################################################

# Unsigned

0xfffffffe:4294967294
0xffffffff:4294967295
0x100000000:4294967296
0x100000001:4294967297
0x100000002:4294967298

xfffffffe:4294967294
xffffffff:4294967295
x100000000:4294967296
x100000001:4294967297
x100000002:4294967298

fffffffe:4294967294
ffffffff:4294967295
100000000:4294967296
100000001:4294967297
100000002:4294967298

# Positive

+0xfffffffe:4294967294
+0xffffffff:4294967295
+0x100000000:4294967296
+0x100000001:4294967297
+0x100000002:4294967298

+xfffffffe:4294967294
+xffffffff:4294967295
+x100000000:4294967296
+x100000001:4294967297
+x100000002:4294967298

+fffffffe:4294967294
+ffffffff:4294967295
+100000000:4294967296
+100000001:4294967297
+100000002:4294967298

# Negative

-0xfffffffe:-4294967294
-0xffffffff:-4294967295
-0x100000000:-4294967296
-0x100000001:-4294967297
-0x100000002:-4294967298

-xfffffffe:-4294967294
-xffffffff:-4294967295
-x100000000:-4294967296
-x100000001:-4294967297
-x100000002:-4294967298

-fffffffe:-4294967294
-ffffffff:-4294967295
-100000000:-4294967296
-100000001:-4294967297
-100000002:-4294967298

###############################################################################
# Absolute value is close to 2^33 = 8589934592
###############################################################################

# Unsigned

0x1fffffffe:8589934590
0x1ffffffff:8589934591
0x200000000:8589934592
0x200000001:8589934593
0x200000002:8589934594

x1fffffffe:8589934590
x1ffffffff:8589934591
x200000000:8589934592
x200000001:8589934593
x200000002:8589934594

1fffffffe:8589934590
1ffffffff:8589934591
200000000:8589934592
200000001:8589934593
200000002:8589934594

# Positive

+0x1fffffffe:8589934590
+0x1ffffffff:8589934591
+0x200000000:8589934592
+0x200000001:8589934593
+0x200000002:8589934594

+x1fffffffe:8589934590
+x1ffffffff:8589934591
+x200000000:8589934592
+x200000001:8589934593
+x200000002:8589934594

+1fffffffe:8589934590
+1ffffffff:8589934591
+200000000:8589934592
+200000001:8589934593
+200000002:8589934594

# Negative

-0x1fffffffe:-8589934590
-0x1ffffffff:-8589934591
-0x200000000:-8589934592
-0x200000001:-8589934593
-0x200000002:-8589934594

-x1fffffffe:-8589934590
-x1ffffffff:-8589934591
-x200000000:-8589934592
-x200000001:-8589934593
-x200000002:-8589934594

-1fffffffe:-8589934590
-1ffffffff:-8589934591
-200000000:-8589934592
-200000001:-8589934593
-200000002:-8589934594

###############################################################################
# Absolute value is close to 2^34 = 17179869184
###############################################################################

# Unsigned

0x3fffffffe:17179869182
0x3ffffffff:17179869183
0x400000000:17179869184
0x400000001:17179869185
0x400000002:17179869186

x3fffffffe:17179869182
x3ffffffff:17179869183
x400000000:17179869184
x400000001:17179869185
x400000002:17179869186

3fffffffe:17179869182
3ffffffff:17179869183
400000000:17179869184
400000001:17179869185
400000002:17179869186

# Positive

+0x3fffffffe:17179869182
+0x3ffffffff:17179869183
+0x400000000:17179869184
+0x400000001:17179869185
+0x400000002:17179869186

+x3fffffffe:17179869182
+x3ffffffff:17179869183
+x400000000:17179869184
+x400000001:17179869185
+x400000002:17179869186

+3fffffffe:17179869182
+3ffffffff:17179869183
+400000000:17179869184
+400000001:17179869185
+400000002:17179869186

# Negative

-0x3fffffffe:-17179869182
-0x3ffffffff:-17179869183
-0x400000000:-17179869184
-0x400000001:-17179869185
-0x400000002:-17179869186

-x3fffffffe:-17179869182
-x3ffffffff:-17179869183
-x400000000:-17179869184
-x400000001:-17179869185
-x400000002:-17179869186

-3fffffffe:-17179869182
-3ffffffff:-17179869183
-400000000:-17179869184
-400000001:-17179869185
-400000002:-17179869186

###############################################################################
# Absolute value is close to 2^35 = 34359738368
###############################################################################

# Unsigned

0x7fffffffe:34359738366
0x7ffffffff:34359738367
0x800000000:34359738368
0x800000001:34359738369
0x800000002:34359738370

x7fffffffe:34359738366
x7ffffffff:34359738367
x800000000:34359738368
x800000001:34359738369
x800000002:34359738370

7fffffffe:34359738366
7ffffffff:34359738367
800000000:34359738368
800000001:34359738369
800000002:34359738370

# Positive

+0x7fffffffe:34359738366
+0x7ffffffff:34359738367
+0x800000000:34359738368
+0x800000001:34359738369
+0x800000002:34359738370

+x7fffffffe:34359738366
+x7ffffffff:34359738367
+x800000000:34359738368
+x800000001:34359738369
+x800000002:34359738370

+7fffffffe:34359738366
+7ffffffff:34359738367
+800000000:34359738368
+800000001:34359738369
+800000002:34359738370

# Negative

-0x7fffffffe:-34359738366
-0x7ffffffff:-34359738367
-0x800000000:-34359738368
-0x800000001:-34359738369
-0x800000002:-34359738370

-x7fffffffe:-34359738366
-x7ffffffff:-34359738367
-x800000000:-34359738368
-x800000001:-34359738369
-x800000002:-34359738370

-7fffffffe:-34359738366
-7ffffffff:-34359738367
-800000000:-34359738368
-800000001:-34359738369
-800000002:-34359738370

###############################################################################
# Absolute value is close to 2^36 = 68719476736
###############################################################################

# Unsigned

0xffffffffe:68719476734
0xfffffffff:68719476735
0x1000000000:68719476736
0x1000000001:68719476737
0x1000000002:68719476738

xffffffffe:68719476734
xfffffffff:68719476735
x1000000000:68719476736
x1000000001:68719476737
x1000000002:68719476738

ffffffffe:68719476734
fffffffff:68719476735
1000000000:68719476736
1000000001:68719476737
1000000002:68719476738

# Positive

+0xffffffffe:68719476734
+0xfffffffff:68719476735
+0x1000000000:68719476736
+0x1000000001:68719476737
+0x1000000002:68719476738

+xffffffffe:68719476734
+xfffffffff:68719476735
+x1000000000:68719476736
+x1000000001:68719476737
+x1000000002:68719476738

+ffffffffe:68719476734
+fffffffff:68719476735
+1000000000:68719476736
+1000000001:68719476737
+1000000002:68719476738

# Negative

-0xffffffffe:-68719476734
-0xfffffffff:-68719476735
-0x1000000000:-68719476736
-0x1000000001:-68719476737
-0x1000000002:-68719476738

-xffffffffe:-68719476734
-xfffffffff:-68719476735
-x1000000000:-68719476736
-x1000000001:-68719476737
-x1000000002:-68719476738

-ffffffffe:-68719476734
-fffffffff:-68719476735
-1000000000:-68719476736
-1000000001:-68719476737
-1000000002:-68719476738

###############################################################################
# Absolute value is close to 2^37 = 137438953472
###############################################################################

# Unsigned

0x1ffffffffe:137438953470
0x1fffffffff:137438953471
0x2000000000:137438953472
0x2000000001:137438953473
0x2000000002:137438953474

x1ffffffffe:137438953470
x1fffffffff:137438953471
x2000000000:137438953472
x2000000001:137438953473
x2000000002:137438953474

1ffffffffe:137438953470
1fffffffff:137438953471
2000000000:137438953472
2000000001:137438953473
2000000002:137438953474

# Positive

+0x1ffffffffe:137438953470
+0x1fffffffff:137438953471
+0x2000000000:137438953472
+0x2000000001:137438953473
+0x2000000002:137438953474

+x1ffffffffe:137438953470
+x1fffffffff:137438953471
+x2000000000:137438953472
+x2000000001:137438953473
+x2000000002:137438953474

+1ffffffffe:137438953470
+1fffffffff:137438953471
+2000000000:137438953472
+2000000001:137438953473
+2000000002:137438953474

# Negative

-0x1ffffffffe:-137438953470
-0x1fffffffff:-137438953471
-0x2000000000:-137438953472
-0x2000000001:-137438953473
-0x2000000002:-137438953474

-x1ffffffffe:-137438953470
-x1fffffffff:-137438953471
-x2000000000:-137438953472
-x2000000001:-137438953473
-x2000000002:-137438953474

-1ffffffffe:-137438953470
-1fffffffff:-137438953471
-2000000000:-137438953472
-2000000001:-137438953473
-2000000002:-137438953474

###############################################################################
# Absolute value is close to 2^38 = 274877906944
###############################################################################

# Unsigned

0x3ffffffffe:274877906942
0x3fffffffff:274877906943
0x4000000000:274877906944
0x4000000001:274877906945
0x4000000002:274877906946

x3ffffffffe:274877906942
x3fffffffff:274877906943
x4000000000:274877906944
x4000000001:274877906945
x4000000002:274877906946

3ffffffffe:274877906942
3fffffffff:274877906943
4000000000:274877906944
4000000001:274877906945
4000000002:274877906946

# Positive

+0x3ffffffffe:274877906942
+0x3fffffffff:274877906943
+0x4000000000:274877906944
+0x4000000001:274877906945
+0x4000000002:274877906946

+x3ffffffffe:274877906942
+x3fffffffff:274877906943
+x4000000000:274877906944
+x4000000001:274877906945
+x4000000002:274877906946

+3ffffffffe:274877906942
+3fffffffff:274877906943
+4000000000:274877906944
+4000000001:274877906945
+4000000002:274877906946

# Negative

-0x3ffffffffe:-274877906942
-0x3fffffffff:-274877906943
-0x4000000000:-274877906944
-0x4000000001:-274877906945
-0x4000000002:-274877906946

-x3ffffffffe:-274877906942
-x3fffffffff:-274877906943
-x4000000000:-274877906944
-x4000000001:-274877906945
-x4000000002:-274877906946

-3ffffffffe:-274877906942
-3fffffffff:-274877906943
-4000000000:-274877906944
-4000000001:-274877906945
-4000000002:-274877906946

###############################################################################
# Absolute value is close to 2^39 = 549755813888
###############################################################################

# Unsigned

0x7ffffffffe:549755813886
0x7fffffffff:549755813887
0x8000000000:549755813888
0x8000000001:549755813889
0x8000000002:549755813890

x7ffffffffe:549755813886
x7fffffffff:549755813887
x8000000000:549755813888
x8000000001:549755813889
x8000000002:549755813890

7ffffffffe:549755813886
7fffffffff:549755813887
8000000000:549755813888
8000000001:549755813889
8000000002:549755813890

# Positive

+0x7ffffffffe:549755813886
+0x7fffffffff:549755813887
+0x8000000000:549755813888
+0x8000000001:549755813889
+0x8000000002:549755813890

+x7ffffffffe:549755813886
+x7fffffffff:549755813887
+x8000000000:549755813888
+x8000000001:549755813889
+x8000000002:549755813890

+7ffffffffe:549755813886
+7fffffffff:549755813887
+8000000000:549755813888
+8000000001:549755813889
+8000000002:549755813890

# Negative

-0x7ffffffffe:-549755813886
-0x7fffffffff:-549755813887
-0x8000000000:-549755813888
-0x8000000001:-549755813889
-0x8000000002:-549755813890

-x7ffffffffe:-549755813886
-x7fffffffff:-549755813887
-x8000000000:-549755813888
-x8000000001:-549755813889
-x8000000002:-549755813890

-7ffffffffe:-549755813886
-7fffffffff:-549755813887
-8000000000:-549755813888
-8000000001:-549755813889
-8000000002:-549755813890

###############################################################################
# Absolute value is close to 2^40 = 1099511627776
###############################################################################

# Unsigned

0xfffffffffe:1099511627774
0xffffffffff:1099511627775
0x10000000000:1099511627776
0x10000000001:1099511627777
0x10000000002:1099511627778

xfffffffffe:1099511627774
xffffffffff:1099511627775
x10000000000:1099511627776
x10000000001:1099511627777
x10000000002:1099511627778

fffffffffe:1099511627774
ffffffffff:1099511627775
10000000000:1099511627776
10000000001:1099511627777
10000000002:1099511627778

# Positive

+0xfffffffffe:1099511627774
+0xffffffffff:1099511627775
+0x10000000000:1099511627776
+0x10000000001:1099511627777
+0x10000000002:1099511627778

+xfffffffffe:1099511627774
+xffffffffff:1099511627775
+x10000000000:1099511627776
+x10000000001:1099511627777
+x10000000002:1099511627778

+fffffffffe:1099511627774
+ffffffffff:1099511627775
+10000000000:1099511627776
+10000000001:1099511627777
+10000000002:1099511627778

# Negative

-0xfffffffffe:-1099511627774
-0xffffffffff:-1099511627775
-0x10000000000:-1099511627776
-0x10000000001:-1099511627777
-0x10000000002:-1099511627778

-xfffffffffe:-1099511627774
-xffffffffff:-1099511627775
-x10000000000:-1099511627776
-x10000000001:-1099511627777
-x10000000002:-1099511627778

-fffffffffe:-1099511627774
-ffffffffff:-1099511627775
-10000000000:-1099511627776
-10000000001:-1099511627777
-10000000002:-1099511627778

###############################################################################
# Absolute value is close to 2^41 = 2199023255552
###############################################################################

# Unsigned

0x1fffffffffe:2199023255550
0x1ffffffffff:2199023255551
0x20000000000:2199023255552
0x20000000001:2199023255553
0x20000000002:2199023255554

x1fffffffffe:2199023255550
x1ffffffffff:2199023255551
x20000000000:2199023255552
x20000000001:2199023255553
x20000000002:2199023255554

1fffffffffe:2199023255550
1ffffffffff:2199023255551
20000000000:2199023255552
20000000001:2199023255553
20000000002:2199023255554

# Positive

+0x1fffffffffe:2199023255550
+0x1ffffffffff:2199023255551
+0x20000000000:2199023255552
+0x20000000001:2199023255553
+0x20000000002:2199023255554

+x1fffffffffe:2199023255550
+x1ffffffffff:2199023255551
+x20000000000:2199023255552
+x20000000001:2199023255553
+x20000000002:2199023255554

+1fffffffffe:2199023255550
+1ffffffffff:2199023255551
+20000000000:2199023255552
+20000000001:2199023255553
+20000000002:2199023255554

# Negative

-0x1fffffffffe:-2199023255550
-0x1ffffffffff:-2199023255551
-0x20000000000:-2199023255552
-0x20000000001:-2199023255553
-0x20000000002:-2199023255554

-x1fffffffffe:-2199023255550
-x1ffffffffff:-2199023255551
-x20000000000:-2199023255552
-x20000000001:-2199023255553
-x20000000002:-2199023255554

-1fffffffffe:-2199023255550
-1ffffffffff:-2199023255551
-20000000000:-2199023255552
-20000000001:-2199023255553
-20000000002:-2199023255554

###############################################################################
# Absolute value is close to 2^42 = 4398046511104
###############################################################################

# Unsigned

0x3fffffffffe:4398046511102
0x3ffffffffff:4398046511103
0x40000000000:4398046511104
0x40000000001:4398046511105
0x40000000002:4398046511106

x3fffffffffe:4398046511102
x3ffffffffff:4398046511103
x40000000000:4398046511104
x40000000001:4398046511105
x40000000002:4398046511106

3fffffffffe:4398046511102
3ffffffffff:4398046511103
40000000000:4398046511104
40000000001:4398046511105
40000000002:4398046511106

# Positive

+0x3fffffffffe:4398046511102
+0x3ffffffffff:4398046511103
+0x40000000000:4398046511104
+0x40000000001:4398046511105
+0x40000000002:4398046511106

+x3fffffffffe:4398046511102
+x3ffffffffff:4398046511103
+x40000000000:4398046511104
+x40000000001:4398046511105
+x40000000002:4398046511106

+3fffffffffe:4398046511102
+3ffffffffff:4398046511103
+40000000000:4398046511104
+40000000001:4398046511105
+40000000002:4398046511106

# Negative

-0x3fffffffffe:-4398046511102
-0x3ffffffffff:-4398046511103
-0x40000000000:-4398046511104
-0x40000000001:-4398046511105
-0x40000000002:-4398046511106

-x3fffffffffe:-4398046511102
-x3ffffffffff:-4398046511103
-x40000000000:-4398046511104
-x40000000001:-4398046511105
-x40000000002:-4398046511106

-3fffffffffe:-4398046511102
-3ffffffffff:-4398046511103
-40000000000:-4398046511104
-40000000001:-4398046511105
-40000000002:-4398046511106

###############################################################################
# Absolute value is close to 2^43 = 8796093022208
###############################################################################

# Unsigned

0x7fffffffffe:8796093022206
0x7ffffffffff:8796093022207
0x80000000000:8796093022208
0x80000000001:8796093022209
0x80000000002:8796093022210

x7fffffffffe:8796093022206
x7ffffffffff:8796093022207
x80000000000:8796093022208
x80000000001:8796093022209
x80000000002:8796093022210

7fffffffffe:8796093022206
7ffffffffff:8796093022207
80000000000:8796093022208
80000000001:8796093022209
80000000002:8796093022210

# Positive

+0x7fffffffffe:8796093022206
+0x7ffffffffff:8796093022207
+0x80000000000:8796093022208
+0x80000000001:8796093022209
+0x80000000002:8796093022210

+x7fffffffffe:8796093022206
+x7ffffffffff:8796093022207
+x80000000000:8796093022208
+x80000000001:8796093022209
+x80000000002:8796093022210

+7fffffffffe:8796093022206
+7ffffffffff:8796093022207
+80000000000:8796093022208
+80000000001:8796093022209
+80000000002:8796093022210

# Negative

-0x7fffffffffe:-8796093022206
-0x7ffffffffff:-8796093022207
-0x80000000000:-8796093022208
-0x80000000001:-8796093022209
-0x80000000002:-8796093022210

-x7fffffffffe:-8796093022206
-x7ffffffffff:-8796093022207
-x80000000000:-8796093022208
-x80000000001:-8796093022209
-x80000000002:-8796093022210

-7fffffffffe:-8796093022206
-7ffffffffff:-8796093022207
-80000000000:-8796093022208
-80000000001:-8796093022209
-80000000002:-8796093022210

###############################################################################
# Absolute value is close to 2^44 = 17592186044416
###############################################################################

# Unsigned

0xffffffffffe:17592186044414
0xfffffffffff:17592186044415
0x100000000000:17592186044416
0x100000000001:17592186044417
0x100000000002:17592186044418

xffffffffffe:17592186044414
xfffffffffff:17592186044415
x100000000000:17592186044416
x100000000001:17592186044417
x100000000002:17592186044418

ffffffffffe:17592186044414
fffffffffff:17592186044415
100000000000:17592186044416
100000000001:17592186044417
100000000002:17592186044418

# Positive

+0xffffffffffe:17592186044414
+0xfffffffffff:17592186044415
+0x100000000000:17592186044416
+0x100000000001:17592186044417
+0x100000000002:17592186044418

+xffffffffffe:17592186044414
+xfffffffffff:17592186044415
+x100000000000:17592186044416
+x100000000001:17592186044417
+x100000000002:17592186044418

+ffffffffffe:17592186044414
+fffffffffff:17592186044415
+100000000000:17592186044416
+100000000001:17592186044417
+100000000002:17592186044418

# Negative

-0xffffffffffe:-17592186044414
-0xfffffffffff:-17592186044415
-0x100000000000:-17592186044416
-0x100000000001:-17592186044417
-0x100000000002:-17592186044418

-xffffffffffe:-17592186044414
-xfffffffffff:-17592186044415
-x100000000000:-17592186044416
-x100000000001:-17592186044417
-x100000000002:-17592186044418

-ffffffffffe:-17592186044414
-fffffffffff:-17592186044415
-100000000000:-17592186044416
-100000000001:-17592186044417
-100000000002:-17592186044418

###############################################################################
# Absolute value is close to 2^45 = 35184372088832
###############################################################################

# Unsigned

0x1ffffffffffe:35184372088830
0x1fffffffffff:35184372088831
0x200000000000:35184372088832
0x200000000001:35184372088833
0x200000000002:35184372088834

x1ffffffffffe:35184372088830
x1fffffffffff:35184372088831
x200000000000:35184372088832
x200000000001:35184372088833
x200000000002:35184372088834

1ffffffffffe:35184372088830
1fffffffffff:35184372088831
200000000000:35184372088832
200000000001:35184372088833
200000000002:35184372088834

# Positive

+0x1ffffffffffe:35184372088830
+0x1fffffffffff:35184372088831
+0x200000000000:35184372088832
+0x200000000001:35184372088833
+0x200000000002:35184372088834

+x1ffffffffffe:35184372088830
+x1fffffffffff:35184372088831
+x200000000000:35184372088832
+x200000000001:35184372088833
+x200000000002:35184372088834

+1ffffffffffe:35184372088830
+1fffffffffff:35184372088831
+200000000000:35184372088832
+200000000001:35184372088833
+200000000002:35184372088834

# Negative

-0x1ffffffffffe:-35184372088830
-0x1fffffffffff:-35184372088831
-0x200000000000:-35184372088832
-0x200000000001:-35184372088833
-0x200000000002:-35184372088834

-x1ffffffffffe:-35184372088830
-x1fffffffffff:-35184372088831
-x200000000000:-35184372088832
-x200000000001:-35184372088833
-x200000000002:-35184372088834

-1ffffffffffe:-35184372088830
-1fffffffffff:-35184372088831
-200000000000:-35184372088832
-200000000001:-35184372088833
-200000000002:-35184372088834

###############################################################################
# Absolute value is close to 2^46 = 70368744177664
###############################################################################

# Unsigned

0x3ffffffffffe:70368744177662
0x3fffffffffff:70368744177663
0x400000000000:70368744177664
0x400000000001:70368744177665
0x400000000002:70368744177666

x3ffffffffffe:70368744177662
x3fffffffffff:70368744177663
x400000000000:70368744177664
x400000000001:70368744177665
x400000000002:70368744177666

3ffffffffffe:70368744177662
3fffffffffff:70368744177663
400000000000:70368744177664
400000000001:70368744177665
400000000002:70368744177666

# Positive

+0x3ffffffffffe:70368744177662
+0x3fffffffffff:70368744177663
+0x400000000000:70368744177664
+0x400000000001:70368744177665
+0x400000000002:70368744177666

+x3ffffffffffe:70368744177662
+x3fffffffffff:70368744177663
+x400000000000:70368744177664
+x400000000001:70368744177665
+x400000000002:70368744177666

+3ffffffffffe:70368744177662
+3fffffffffff:70368744177663
+400000000000:70368744177664
+400000000001:70368744177665
+400000000002:70368744177666

# Negative

-0x3ffffffffffe:-70368744177662
-0x3fffffffffff:-70368744177663
-0x400000000000:-70368744177664
-0x400000000001:-70368744177665
-0x400000000002:-70368744177666

-x3ffffffffffe:-70368744177662
-x3fffffffffff:-70368744177663
-x400000000000:-70368744177664
-x400000000001:-70368744177665
-x400000000002:-70368744177666

-3ffffffffffe:-70368744177662
-3fffffffffff:-70368744177663
-400000000000:-70368744177664
-400000000001:-70368744177665
-400000000002:-70368744177666

###############################################################################
# Absolute value is close to 2^47 = 140737488355328
###############################################################################

# Unsigned

0x7ffffffffffe:140737488355326
0x7fffffffffff:140737488355327
0x800000000000:140737488355328
0x800000000001:140737488355329
0x800000000002:140737488355330

x7ffffffffffe:140737488355326
x7fffffffffff:140737488355327
x800000000000:140737488355328
x800000000001:140737488355329
x800000000002:140737488355330

7ffffffffffe:140737488355326
7fffffffffff:140737488355327
800000000000:140737488355328
800000000001:140737488355329
800000000002:140737488355330

# Positive

+0x7ffffffffffe:140737488355326
+0x7fffffffffff:140737488355327
+0x800000000000:140737488355328
+0x800000000001:140737488355329
+0x800000000002:140737488355330

+x7ffffffffffe:140737488355326
+x7fffffffffff:140737488355327
+x800000000000:140737488355328
+x800000000001:140737488355329
+x800000000002:140737488355330

+7ffffffffffe:140737488355326
+7fffffffffff:140737488355327
+800000000000:140737488355328
+800000000001:140737488355329
+800000000002:140737488355330

# Negative

-0x7ffffffffffe:-140737488355326
-0x7fffffffffff:-140737488355327
-0x800000000000:-140737488355328
-0x800000000001:-140737488355329
-0x800000000002:-140737488355330

-x7ffffffffffe:-140737488355326
-x7fffffffffff:-140737488355327
-x800000000000:-140737488355328
-x800000000001:-140737488355329
-x800000000002:-140737488355330

-7ffffffffffe:-140737488355326
-7fffffffffff:-140737488355327
-800000000000:-140737488355328
-800000000001:-140737488355329
-800000000002:-140737488355330

###############################################################################
# Absolute value is close to 2^48 = 281474976710656
###############################################################################

# Unsigned

0xfffffffffffe:281474976710654
0xffffffffffff:281474976710655
0x1000000000000:281474976710656
0x1000000000001:281474976710657
0x1000000000002:281474976710658

xfffffffffffe:281474976710654
xffffffffffff:281474976710655
x1000000000000:281474976710656
x1000000000001:281474976710657
x1000000000002:281474976710658

fffffffffffe:281474976710654
ffffffffffff:281474976710655
1000000000000:281474976710656
1000000000001:281474976710657
1000000000002:281474976710658

# Positive

+0xfffffffffffe:281474976710654
+0xffffffffffff:281474976710655
+0x1000000000000:281474976710656
+0x1000000000001:281474976710657
+0x1000000000002:281474976710658

+xfffffffffffe:281474976710654
+xffffffffffff:281474976710655
+x1000000000000:281474976710656
+x1000000000001:281474976710657
+x1000000000002:281474976710658

+fffffffffffe:281474976710654
+ffffffffffff:281474976710655
+1000000000000:281474976710656
+1000000000001:281474976710657
+1000000000002:281474976710658

# Negative

-0xfffffffffffe:-281474976710654
-0xffffffffffff:-281474976710655
-0x1000000000000:-281474976710656
-0x1000000000001:-281474976710657
-0x1000000000002:-281474976710658

-xfffffffffffe:-281474976710654
-xffffffffffff:-281474976710655
-x1000000000000:-281474976710656
-x1000000000001:-281474976710657
-x1000000000002:-281474976710658

-fffffffffffe:-281474976710654
-ffffffffffff:-281474976710655
-1000000000000:-281474976710656
-1000000000001:-281474976710657
-1000000000002:-281474976710658

###############################################################################
# Absolute value is close to 2^49 = 562949953421312
###############################################################################

# Unsigned

0x1fffffffffffe:562949953421310
0x1ffffffffffff:562949953421311
0x2000000000000:562949953421312
0x2000000000001:562949953421313
0x2000000000002:562949953421314

x1fffffffffffe:562949953421310
x1ffffffffffff:562949953421311
x2000000000000:562949953421312
x2000000000001:562949953421313
x2000000000002:562949953421314

1fffffffffffe:562949953421310
1ffffffffffff:562949953421311
2000000000000:562949953421312
2000000000001:562949953421313
2000000000002:562949953421314

# Positive

+0x1fffffffffffe:562949953421310
+0x1ffffffffffff:562949953421311
+0x2000000000000:562949953421312
+0x2000000000001:562949953421313
+0x2000000000002:562949953421314

+x1fffffffffffe:562949953421310
+x1ffffffffffff:562949953421311
+x2000000000000:562949953421312
+x2000000000001:562949953421313
+x2000000000002:562949953421314

+1fffffffffffe:562949953421310
+1ffffffffffff:562949953421311
+2000000000000:562949953421312
+2000000000001:562949953421313
+2000000000002:562949953421314

# Negative

-0x1fffffffffffe:-562949953421310
-0x1ffffffffffff:-562949953421311
-0x2000000000000:-562949953421312
-0x2000000000001:-562949953421313
-0x2000000000002:-562949953421314

-x1fffffffffffe:-562949953421310
-x1ffffffffffff:-562949953421311
-x2000000000000:-562949953421312
-x2000000000001:-562949953421313
-x2000000000002:-562949953421314

-1fffffffffffe:-562949953421310
-1ffffffffffff:-562949953421311
-2000000000000:-562949953421312
-2000000000001:-562949953421313
-2000000000002:-562949953421314

###############################################################################
# Absolute value is close to 2^50 = 1125899906842624
###############################################################################

# Unsigned

0x3fffffffffffe:1125899906842622
0x3ffffffffffff:1125899906842623
0x4000000000000:1125899906842624
0x4000000000001:1125899906842625
0x4000000000002:1125899906842626

x3fffffffffffe:1125899906842622
x3ffffffffffff:1125899906842623
x4000000000000:1125899906842624
x4000000000001:1125899906842625
x4000000000002:1125899906842626

3fffffffffffe:1125899906842622
3ffffffffffff:1125899906842623
4000000000000:1125899906842624
4000000000001:1125899906842625
4000000000002:1125899906842626

# Positive

+0x3fffffffffffe:1125899906842622
+0x3ffffffffffff:1125899906842623
+0x4000000000000:1125899906842624
+0x4000000000001:1125899906842625
+0x4000000000002:1125899906842626

+x3fffffffffffe:1125899906842622
+x3ffffffffffff:1125899906842623
+x4000000000000:1125899906842624
+x4000000000001:1125899906842625
+x4000000000002:1125899906842626

+3fffffffffffe:1125899906842622
+3ffffffffffff:1125899906842623
+4000000000000:1125899906842624
+4000000000001:1125899906842625
+4000000000002:1125899906842626

# Negative

-0x3fffffffffffe:-1125899906842622
-0x3ffffffffffff:-1125899906842623
-0x4000000000000:-1125899906842624
-0x4000000000001:-1125899906842625
-0x4000000000002:-1125899906842626

-x3fffffffffffe:-1125899906842622
-x3ffffffffffff:-1125899906842623
-x4000000000000:-1125899906842624
-x4000000000001:-1125899906842625
-x4000000000002:-1125899906842626

-3fffffffffffe:-1125899906842622
-3ffffffffffff:-1125899906842623
-4000000000000:-1125899906842624
-4000000000001:-1125899906842625
-4000000000002:-1125899906842626

###############################################################################
# Absolute value is close to 2^51 = 2251799813685248
###############################################################################

# Unsigned

0x7fffffffffffe:2251799813685246
0x7ffffffffffff:2251799813685247
0x8000000000000:2251799813685248
0x8000000000001:2251799813685249
0x8000000000002:2251799813685250

x7fffffffffffe:2251799813685246
x7ffffffffffff:2251799813685247
x8000000000000:2251799813685248
x8000000000001:2251799813685249
x8000000000002:2251799813685250

7fffffffffffe:2251799813685246
7ffffffffffff:2251799813685247
8000000000000:2251799813685248
8000000000001:2251799813685249
8000000000002:2251799813685250

# Positive

+0x7fffffffffffe:2251799813685246
+0x7ffffffffffff:2251799813685247
+0x8000000000000:2251799813685248
+0x8000000000001:2251799813685249
+0x8000000000002:2251799813685250

+x7fffffffffffe:2251799813685246
+x7ffffffffffff:2251799813685247
+x8000000000000:2251799813685248
+x8000000000001:2251799813685249
+x8000000000002:2251799813685250

+7fffffffffffe:2251799813685246
+7ffffffffffff:2251799813685247
+8000000000000:2251799813685248
+8000000000001:2251799813685249
+8000000000002:2251799813685250

# Negative

-0x7fffffffffffe:-2251799813685246
-0x7ffffffffffff:-2251799813685247
-0x8000000000000:-2251799813685248
-0x8000000000001:-2251799813685249
-0x8000000000002:-2251799813685250

-x7fffffffffffe:-2251799813685246
-x7ffffffffffff:-2251799813685247
-x8000000000000:-2251799813685248
-x8000000000001:-2251799813685249
-x8000000000002:-2251799813685250

-7fffffffffffe:-2251799813685246
-7ffffffffffff:-2251799813685247
-8000000000000:-2251799813685248
-8000000000001:-2251799813685249
-8000000000002:-2251799813685250

###############################################################################
# Absolute value is close to 2^52 = 4503599627370496
###############################################################################

# Unsigned

0xffffffffffffe:4503599627370494
0xfffffffffffff:4503599627370495
0x10000000000000:4503599627370496
0x10000000000001:4503599627370497
0x10000000000002:4503599627370498

xffffffffffffe:4503599627370494
xfffffffffffff:4503599627370495
x10000000000000:4503599627370496
x10000000000001:4503599627370497
x10000000000002:4503599627370498

ffffffffffffe:4503599627370494
fffffffffffff:4503599627370495
10000000000000:4503599627370496
10000000000001:4503599627370497
10000000000002:4503599627370498

# Positive

+0xffffffffffffe:4503599627370494
+0xfffffffffffff:4503599627370495
+0x10000000000000:4503599627370496
+0x10000000000001:4503599627370497
+0x10000000000002:4503599627370498

+xffffffffffffe:4503599627370494
+xfffffffffffff:4503599627370495
+x10000000000000:4503599627370496
+x10000000000001:4503599627370497
+x10000000000002:4503599627370498

+ffffffffffffe:4503599627370494
+fffffffffffff:4503599627370495
+10000000000000:4503599627370496
+10000000000001:4503599627370497
+10000000000002:4503599627370498

# Negative

-0xffffffffffffe:-4503599627370494
-0xfffffffffffff:-4503599627370495
-0x10000000000000:-4503599627370496
-0x10000000000001:-4503599627370497
-0x10000000000002:-4503599627370498

-xffffffffffffe:-4503599627370494
-xfffffffffffff:-4503599627370495
-x10000000000000:-4503599627370496
-x10000000000001:-4503599627370497
-x10000000000002:-4503599627370498

-ffffffffffffe:-4503599627370494
-fffffffffffff:-4503599627370495
-10000000000000:-4503599627370496
-10000000000001:-4503599627370497
-10000000000002:-4503599627370498

###############################################################################
# Absolute value is close to 2^53 = 9007199254740992
###############################################################################

# Unsigned

0x1ffffffffffffe:9007199254740990
0x1fffffffffffff:9007199254740991
0x20000000000000:9007199254740992
0x20000000000001:9007199254740993
0x20000000000002:9007199254740994

x1ffffffffffffe:9007199254740990
x1fffffffffffff:9007199254740991
x20000000000000:9007199254740992
x20000000000001:9007199254740993
x20000000000002:9007199254740994

1ffffffffffffe:9007199254740990
1fffffffffffff:9007199254740991
20000000000000:9007199254740992
20000000000001:9007199254740993
20000000000002:9007199254740994

# Positive

+0x1ffffffffffffe:9007199254740990
+0x1fffffffffffff:9007199254740991
+0x20000000000000:9007199254740992
+0x20000000000001:9007199254740993
+0x20000000000002:9007199254740994

+x1ffffffffffffe:9007199254740990
+x1fffffffffffff:9007199254740991
+x20000000000000:9007199254740992
+x20000000000001:9007199254740993
+x20000000000002:9007199254740994

+1ffffffffffffe:9007199254740990
+1fffffffffffff:9007199254740991
+20000000000000:9007199254740992
+20000000000001:9007199254740993
+20000000000002:9007199254740994

# Negative

-0x1ffffffffffffe:-9007199254740990
-0x1fffffffffffff:-9007199254740991
-0x20000000000000:-9007199254740992
-0x20000000000001:-9007199254740993
-0x20000000000002:-9007199254740994

-x1ffffffffffffe:-9007199254740990
-x1fffffffffffff:-9007199254740991
-x20000000000000:-9007199254740992
-x20000000000001:-9007199254740993
-x20000000000002:-9007199254740994

-1ffffffffffffe:-9007199254740990
-1fffffffffffff:-9007199254740991
-20000000000000:-9007199254740992
-20000000000001:-9007199254740993
-20000000000002:-9007199254740994

###############################################################################
# Absolute value is close to 2^54 = 18014398509481984
###############################################################################

# Unsigned

0x3ffffffffffffe:18014398509481982
0x3fffffffffffff:18014398509481983
0x40000000000000:18014398509481984
0x40000000000001:18014398509481985
0x40000000000002:18014398509481986

x3ffffffffffffe:18014398509481982
x3fffffffffffff:18014398509481983
x40000000000000:18014398509481984
x40000000000001:18014398509481985
x40000000000002:18014398509481986

3ffffffffffffe:18014398509481982
3fffffffffffff:18014398509481983
40000000000000:18014398509481984
40000000000001:18014398509481985
40000000000002:18014398509481986

# Positive

+0x3ffffffffffffe:18014398509481982
+0x3fffffffffffff:18014398509481983
+0x40000000000000:18014398509481984
+0x40000000000001:18014398509481985
+0x40000000000002:18014398509481986

+x3ffffffffffffe:18014398509481982
+x3fffffffffffff:18014398509481983
+x40000000000000:18014398509481984
+x40000000000001:18014398509481985
+x40000000000002:18014398509481986

+3ffffffffffffe:18014398509481982
+3fffffffffffff:18014398509481983
+40000000000000:18014398509481984
+40000000000001:18014398509481985
+40000000000002:18014398509481986

# Negative

-0x3ffffffffffffe:-18014398509481982
-0x3fffffffffffff:-18014398509481983
-0x40000000000000:-18014398509481984
-0x40000000000001:-18014398509481985
-0x40000000000002:-18014398509481986

-x3ffffffffffffe:-18014398509481982
-x3fffffffffffff:-18014398509481983
-x40000000000000:-18014398509481984
-x40000000000001:-18014398509481985
-x40000000000002:-18014398509481986

-3ffffffffffffe:-18014398509481982
-3fffffffffffff:-18014398509481983
-40000000000000:-18014398509481984
-40000000000001:-18014398509481985
-40000000000002:-18014398509481986

###############################################################################
# Absolute value is close to 2^55 = 36028797018963968
###############################################################################

# Unsigned

0x7ffffffffffffe:36028797018963966
0x7fffffffffffff:36028797018963967
0x80000000000000:36028797018963968
0x80000000000001:36028797018963969
0x80000000000002:36028797018963970

x7ffffffffffffe:36028797018963966
x7fffffffffffff:36028797018963967
x80000000000000:36028797018963968
x80000000000001:36028797018963969
x80000000000002:36028797018963970

7ffffffffffffe:36028797018963966
7fffffffffffff:36028797018963967
80000000000000:36028797018963968
80000000000001:36028797018963969
80000000000002:36028797018963970

# Positive

+0x7ffffffffffffe:36028797018963966
+0x7fffffffffffff:36028797018963967
+0x80000000000000:36028797018963968
+0x80000000000001:36028797018963969
+0x80000000000002:36028797018963970

+x7ffffffffffffe:36028797018963966
+x7fffffffffffff:36028797018963967
+x80000000000000:36028797018963968
+x80000000000001:36028797018963969
+x80000000000002:36028797018963970

+7ffffffffffffe:36028797018963966
+7fffffffffffff:36028797018963967
+80000000000000:36028797018963968
+80000000000001:36028797018963969
+80000000000002:36028797018963970

# Negative

-0x7ffffffffffffe:-36028797018963966
-0x7fffffffffffff:-36028797018963967
-0x80000000000000:-36028797018963968
-0x80000000000001:-36028797018963969
-0x80000000000002:-36028797018963970

-x7ffffffffffffe:-36028797018963966
-x7fffffffffffff:-36028797018963967
-x80000000000000:-36028797018963968
-x80000000000001:-36028797018963969
-x80000000000002:-36028797018963970

-7ffffffffffffe:-36028797018963966
-7fffffffffffff:-36028797018963967
-80000000000000:-36028797018963968
-80000000000001:-36028797018963969
-80000000000002:-36028797018963970

###############################################################################
# Absolute value is close to 2^56 = 72057594037927936
###############################################################################

# Unsigned

0xfffffffffffffe:72057594037927934
0xffffffffffffff:72057594037927935
0x100000000000000:72057594037927936
0x100000000000001:72057594037927937
0x100000000000002:72057594037927938

xfffffffffffffe:72057594037927934
xffffffffffffff:72057594037927935
x100000000000000:72057594037927936
x100000000000001:72057594037927937
x100000000000002:72057594037927938

fffffffffffffe:72057594037927934
ffffffffffffff:72057594037927935
100000000000000:72057594037927936
100000000000001:72057594037927937
100000000000002:72057594037927938

# Positive

+0xfffffffffffffe:72057594037927934
+0xffffffffffffff:72057594037927935
+0x100000000000000:72057594037927936
+0x100000000000001:72057594037927937
+0x100000000000002:72057594037927938

+xfffffffffffffe:72057594037927934
+xffffffffffffff:72057594037927935
+x100000000000000:72057594037927936
+x100000000000001:72057594037927937
+x100000000000002:72057594037927938

+fffffffffffffe:72057594037927934
+ffffffffffffff:72057594037927935
+100000000000000:72057594037927936
+100000000000001:72057594037927937
+100000000000002:72057594037927938

# Negative

-0xfffffffffffffe:-72057594037927934
-0xffffffffffffff:-72057594037927935
-0x100000000000000:-72057594037927936
-0x100000000000001:-72057594037927937
-0x100000000000002:-72057594037927938

-xfffffffffffffe:-72057594037927934
-xffffffffffffff:-72057594037927935
-x100000000000000:-72057594037927936
-x100000000000001:-72057594037927937
-x100000000000002:-72057594037927938

-fffffffffffffe:-72057594037927934
-ffffffffffffff:-72057594037927935
-100000000000000:-72057594037927936
-100000000000001:-72057594037927937
-100000000000002:-72057594037927938

###############################################################################
# Absolute value is close to 2^57 = 144115188075855872
###############################################################################

# Unsigned

0x1fffffffffffffe:144115188075855870
0x1ffffffffffffff:144115188075855871
0x200000000000000:144115188075855872
0x200000000000001:144115188075855873
0x200000000000002:144115188075855874

x1fffffffffffffe:144115188075855870
x1ffffffffffffff:144115188075855871
x200000000000000:144115188075855872
x200000000000001:144115188075855873
x200000000000002:144115188075855874

1fffffffffffffe:144115188075855870
1ffffffffffffff:144115188075855871
200000000000000:144115188075855872
200000000000001:144115188075855873
200000000000002:144115188075855874

# Positive

+0x1fffffffffffffe:144115188075855870
+0x1ffffffffffffff:144115188075855871
+0x200000000000000:144115188075855872
+0x200000000000001:144115188075855873
+0x200000000000002:144115188075855874

+x1fffffffffffffe:144115188075855870
+x1ffffffffffffff:144115188075855871
+x200000000000000:144115188075855872
+x200000000000001:144115188075855873
+x200000000000002:144115188075855874

+1fffffffffffffe:144115188075855870
+1ffffffffffffff:144115188075855871
+200000000000000:144115188075855872
+200000000000001:144115188075855873
+200000000000002:144115188075855874

# Negative

-0x1fffffffffffffe:-144115188075855870
-0x1ffffffffffffff:-144115188075855871
-0x200000000000000:-144115188075855872
-0x200000000000001:-144115188075855873
-0x200000000000002:-144115188075855874

-x1fffffffffffffe:-144115188075855870
-x1ffffffffffffff:-144115188075855871
-x200000000000000:-144115188075855872
-x200000000000001:-144115188075855873
-x200000000000002:-144115188075855874

-1fffffffffffffe:-144115188075855870
-1ffffffffffffff:-144115188075855871
-200000000000000:-144115188075855872
-200000000000001:-144115188075855873
-200000000000002:-144115188075855874

###############################################################################
# Absolute value is close to 2^58 = 288230376151711744
###############################################################################

# Unsigned

0x3fffffffffffffe:288230376151711742
0x3ffffffffffffff:288230376151711743
0x400000000000000:288230376151711744
0x400000000000001:288230376151711745
0x400000000000002:288230376151711746

x3fffffffffffffe:288230376151711742
x3ffffffffffffff:288230376151711743
x400000000000000:288230376151711744
x400000000000001:288230376151711745
x400000000000002:288230376151711746

3fffffffffffffe:288230376151711742
3ffffffffffffff:288230376151711743
400000000000000:288230376151711744
400000000000001:288230376151711745
400000000000002:288230376151711746

# Positive

+0x3fffffffffffffe:288230376151711742
+0x3ffffffffffffff:288230376151711743
+0x400000000000000:288230376151711744
+0x400000000000001:288230376151711745
+0x400000000000002:288230376151711746

+x3fffffffffffffe:288230376151711742
+x3ffffffffffffff:288230376151711743
+x400000000000000:288230376151711744
+x400000000000001:288230376151711745
+x400000000000002:288230376151711746

+3fffffffffffffe:288230376151711742
+3ffffffffffffff:288230376151711743
+400000000000000:288230376151711744
+400000000000001:288230376151711745
+400000000000002:288230376151711746

# Negative

-0x3fffffffffffffe:-288230376151711742
-0x3ffffffffffffff:-288230376151711743
-0x400000000000000:-288230376151711744
-0x400000000000001:-288230376151711745
-0x400000000000002:-288230376151711746

-x3fffffffffffffe:-288230376151711742
-x3ffffffffffffff:-288230376151711743
-x400000000000000:-288230376151711744
-x400000000000001:-288230376151711745
-x400000000000002:-288230376151711746

-3fffffffffffffe:-288230376151711742
-3ffffffffffffff:-288230376151711743
-400000000000000:-288230376151711744
-400000000000001:-288230376151711745
-400000000000002:-288230376151711746

###############################################################################
# Absolute value is close to 2^59 = 576460752303423488
###############################################################################

# Unsigned

0x7fffffffffffffe:576460752303423486
0x7ffffffffffffff:576460752303423487
0x800000000000000:576460752303423488
0x800000000000001:576460752303423489
0x800000000000002:576460752303423490

x7fffffffffffffe:576460752303423486
x7ffffffffffffff:576460752303423487
x800000000000000:576460752303423488
x800000000000001:576460752303423489
x800000000000002:576460752303423490

7fffffffffffffe:576460752303423486
7ffffffffffffff:576460752303423487
800000000000000:576460752303423488
800000000000001:576460752303423489
800000000000002:576460752303423490

# Positive

+0x7fffffffffffffe:576460752303423486
+0x7ffffffffffffff:576460752303423487
+0x800000000000000:576460752303423488
+0x800000000000001:576460752303423489
+0x800000000000002:576460752303423490

+x7fffffffffffffe:576460752303423486
+x7ffffffffffffff:576460752303423487
+x800000000000000:576460752303423488
+x800000000000001:576460752303423489
+x800000000000002:576460752303423490

+7fffffffffffffe:576460752303423486
+7ffffffffffffff:576460752303423487
+800000000000000:576460752303423488
+800000000000001:576460752303423489
+800000000000002:576460752303423490

# Negative

-0x7fffffffffffffe:-576460752303423486
-0x7ffffffffffffff:-576460752303423487
-0x800000000000000:-576460752303423488
-0x800000000000001:-576460752303423489
-0x800000000000002:-576460752303423490

-x7fffffffffffffe:-576460752303423486
-x7ffffffffffffff:-576460752303423487
-x800000000000000:-576460752303423488
-x800000000000001:-576460752303423489
-x800000000000002:-576460752303423490

-7fffffffffffffe:-576460752303423486
-7ffffffffffffff:-576460752303423487
-800000000000000:-576460752303423488
-800000000000001:-576460752303423489
-800000000000002:-576460752303423490

###############################################################################
# Absolute value is close to 2^60 = 1152921504606846976
###############################################################################

# Unsigned

0xffffffffffffffe:1152921504606846974
0xfffffffffffffff:1152921504606846975
0x1000000000000000:1152921504606846976
0x1000000000000001:1152921504606846977
0x1000000000000002:1152921504606846978

xffffffffffffffe:1152921504606846974
xfffffffffffffff:1152921504606846975
x1000000000000000:1152921504606846976
x1000000000000001:1152921504606846977
x1000000000000002:1152921504606846978

ffffffffffffffe:1152921504606846974
fffffffffffffff:1152921504606846975
1000000000000000:1152921504606846976
1000000000000001:1152921504606846977
1000000000000002:1152921504606846978

# Positive

+0xffffffffffffffe:1152921504606846974
+0xfffffffffffffff:1152921504606846975
+0x1000000000000000:1152921504606846976
+0x1000000000000001:1152921504606846977
+0x1000000000000002:1152921504606846978

+xffffffffffffffe:1152921504606846974
+xfffffffffffffff:1152921504606846975
+x1000000000000000:1152921504606846976
+x1000000000000001:1152921504606846977
+x1000000000000002:1152921504606846978

+ffffffffffffffe:1152921504606846974
+fffffffffffffff:1152921504606846975
+1000000000000000:1152921504606846976
+1000000000000001:1152921504606846977
+1000000000000002:1152921504606846978

# Negative

-0xffffffffffffffe:-1152921504606846974
-0xfffffffffffffff:-1152921504606846975
-0x1000000000000000:-1152921504606846976
-0x1000000000000001:-1152921504606846977
-0x1000000000000002:-1152921504606846978

-xffffffffffffffe:-1152921504606846974
-xfffffffffffffff:-1152921504606846975
-x1000000000000000:-1152921504606846976
-x1000000000000001:-1152921504606846977
-x1000000000000002:-1152921504606846978

-ffffffffffffffe:-1152921504606846974
-fffffffffffffff:-1152921504606846975
-1000000000000000:-1152921504606846976
-1000000000000001:-1152921504606846977
-1000000000000002:-1152921504606846978

###############################################################################
# Absolute value is close to 2^61 = 2305843009213693952
###############################################################################

# Unsigned

0x1ffffffffffffffe:2305843009213693950
0x1fffffffffffffff:2305843009213693951
0x2000000000000000:2305843009213693952
0x2000000000000001:2305843009213693953
0x2000000000000002:2305843009213693954

x1ffffffffffffffe:2305843009213693950
x1fffffffffffffff:2305843009213693951
x2000000000000000:2305843009213693952
x2000000000000001:2305843009213693953
x2000000000000002:2305843009213693954

1ffffffffffffffe:2305843009213693950
1fffffffffffffff:2305843009213693951
2000000000000000:2305843009213693952
2000000000000001:2305843009213693953
2000000000000002:2305843009213693954

# Positive

+0x1ffffffffffffffe:2305843009213693950
+0x1fffffffffffffff:2305843009213693951
+0x2000000000000000:2305843009213693952
+0x2000000000000001:2305843009213693953
+0x2000000000000002:2305843009213693954

+x1ffffffffffffffe:2305843009213693950
+x1fffffffffffffff:2305843009213693951
+x2000000000000000:2305843009213693952
+x2000000000000001:2305843009213693953
+x2000000000000002:2305843009213693954

+1ffffffffffffffe:2305843009213693950
+1fffffffffffffff:2305843009213693951
+2000000000000000:2305843009213693952
+2000000000000001:2305843009213693953
+2000000000000002:2305843009213693954

# Negative

-0x1ffffffffffffffe:-2305843009213693950
-0x1fffffffffffffff:-2305843009213693951
-0x2000000000000000:-2305843009213693952
-0x2000000000000001:-2305843009213693953
-0x2000000000000002:-2305843009213693954

-x1ffffffffffffffe:-2305843009213693950
-x1fffffffffffffff:-2305843009213693951
-x2000000000000000:-2305843009213693952
-x2000000000000001:-2305843009213693953
-x2000000000000002:-2305843009213693954

-1ffffffffffffffe:-2305843009213693950
-1fffffffffffffff:-2305843009213693951
-2000000000000000:-2305843009213693952
-2000000000000001:-2305843009213693953
-2000000000000002:-2305843009213693954

###############################################################################
# Absolute value is close to 2^62 = 4611686018427387904
###############################################################################

# Unsigned

0x3ffffffffffffffe:4611686018427387902
0x3fffffffffffffff:4611686018427387903
0x4000000000000000:4611686018427387904
0x4000000000000001:4611686018427387905
0x4000000000000002:4611686018427387906

x3ffffffffffffffe:4611686018427387902
x3fffffffffffffff:4611686018427387903
x4000000000000000:4611686018427387904
x4000000000000001:4611686018427387905
x4000000000000002:4611686018427387906

3ffffffffffffffe:4611686018427387902
3fffffffffffffff:4611686018427387903
4000000000000000:4611686018427387904
4000000000000001:4611686018427387905
4000000000000002:4611686018427387906

# Positive

+0x3ffffffffffffffe:4611686018427387902
+0x3fffffffffffffff:4611686018427387903
+0x4000000000000000:4611686018427387904
+0x4000000000000001:4611686018427387905
+0x4000000000000002:4611686018427387906

+x3ffffffffffffffe:4611686018427387902
+x3fffffffffffffff:4611686018427387903
+x4000000000000000:4611686018427387904
+x4000000000000001:4611686018427387905
+x4000000000000002:4611686018427387906

+3ffffffffffffffe:4611686018427387902
+3fffffffffffffff:4611686018427387903
+4000000000000000:4611686018427387904
+4000000000000001:4611686018427387905
+4000000000000002:4611686018427387906

# Negative

-0x3ffffffffffffffe:-4611686018427387902
-0x3fffffffffffffff:-4611686018427387903
-0x4000000000000000:-4611686018427387904
-0x4000000000000001:-4611686018427387905
-0x4000000000000002:-4611686018427387906

-x3ffffffffffffffe:-4611686018427387902
-x3fffffffffffffff:-4611686018427387903
-x4000000000000000:-4611686018427387904
-x4000000000000001:-4611686018427387905
-x4000000000000002:-4611686018427387906

-3ffffffffffffffe:-4611686018427387902
-3fffffffffffffff:-4611686018427387903
-4000000000000000:-4611686018427387904
-4000000000000001:-4611686018427387905
-4000000000000002:-4611686018427387906

###############################################################################
# Absolute value is close to 2^63 = 9223372036854775808
###############################################################################

# Unsigned

0x7ffffffffffffffe:9223372036854775806
0x7fffffffffffffff:9223372036854775807
0x8000000000000000:9223372036854775808
0x8000000000000001:9223372036854775809
0x8000000000000002:9223372036854775810

x7ffffffffffffffe:9223372036854775806
x7fffffffffffffff:9223372036854775807
x8000000000000000:9223372036854775808
x8000000000000001:9223372036854775809
x8000000000000002:9223372036854775810

7ffffffffffffffe:9223372036854775806
7fffffffffffffff:9223372036854775807
8000000000000000:9223372036854775808
8000000000000001:9223372036854775809
8000000000000002:9223372036854775810

# Positive

+0x7ffffffffffffffe:9223372036854775806
+0x7fffffffffffffff:9223372036854775807
+0x8000000000000000:9223372036854775808
+0x8000000000000001:9223372036854775809
+0x8000000000000002:9223372036854775810

+x7ffffffffffffffe:9223372036854775806
+x7fffffffffffffff:9223372036854775807
+x8000000000000000:9223372036854775808
+x8000000000000001:9223372036854775809
+x8000000000000002:9223372036854775810

+7ffffffffffffffe:9223372036854775806
+7fffffffffffffff:9223372036854775807
+8000000000000000:9223372036854775808
+8000000000000001:9223372036854775809
+8000000000000002:9223372036854775810

# Negative

-0x7ffffffffffffffe:-9223372036854775806
-0x7fffffffffffffff:-9223372036854775807
-0x8000000000000000:-9223372036854775808
-0x8000000000000001:-9223372036854775809
-0x8000000000000002:-9223372036854775810

-x7ffffffffffffffe:-9223372036854775806
-x7fffffffffffffff:-9223372036854775807
-x8000000000000000:-9223372036854775808
-x8000000000000001:-9223372036854775809
-x8000000000000002:-9223372036854775810

-7ffffffffffffffe:-9223372036854775806
-7fffffffffffffff:-9223372036854775807
-8000000000000000:-9223372036854775808
-8000000000000001:-9223372036854775809
-8000000000000002:-9223372036854775810

###############################################################################
# Absolute value is close to 2^64 = 18446744073709551616
###############################################################################

# Unsigned

0xfffffffffffffffe:18446744073709551614
0xffffffffffffffff:18446744073709551615
0x10000000000000000:18446744073709551616
0x10000000000000001:18446744073709551617
0x10000000000000002:18446744073709551618

xfffffffffffffffe:18446744073709551614
xffffffffffffffff:18446744073709551615
x10000000000000000:18446744073709551616
x10000000000000001:18446744073709551617
x10000000000000002:18446744073709551618

fffffffffffffffe:18446744073709551614
ffffffffffffffff:18446744073709551615
10000000000000000:18446744073709551616
10000000000000001:18446744073709551617
10000000000000002:18446744073709551618

# Positive

+0xfffffffffffffffe:18446744073709551614
+0xffffffffffffffff:18446744073709551615
+0x10000000000000000:18446744073709551616
+0x10000000000000001:18446744073709551617
+0x10000000000000002:18446744073709551618

+xfffffffffffffffe:18446744073709551614
+xffffffffffffffff:18446744073709551615
+x10000000000000000:18446744073709551616
+x10000000000000001:18446744073709551617
+x10000000000000002:18446744073709551618

+fffffffffffffffe:18446744073709551614
+ffffffffffffffff:18446744073709551615
+10000000000000000:18446744073709551616
+10000000000000001:18446744073709551617
+10000000000000002:18446744073709551618

# Negative

-0xfffffffffffffffe:-18446744073709551614
-0xffffffffffffffff:-18446744073709551615
-0x10000000000000000:-18446744073709551616
-0x10000000000000001:-18446744073709551617
-0x10000000000000002:-18446744073709551618

-xfffffffffffffffe:-18446744073709551614
-xffffffffffffffff:-18446744073709551615
-x10000000000000000:-18446744073709551616
-x10000000000000001:-18446744073709551617
-x10000000000000002:-18446744073709551618

-fffffffffffffffe:-18446744073709551614
-ffffffffffffffff:-18446744073709551615
-10000000000000000:-18446744073709551616
-10000000000000001:-18446744073709551617
-10000000000000002:-18446744073709551618

###############################################################################
# Absolute value is close to 2^65 = 36893488147419103232
###############################################################################

# Unsigned

0x1fffffffffffffffe:36893488147419103230
0x1ffffffffffffffff:36893488147419103231
0x20000000000000000:36893488147419103232
0x20000000000000001:36893488147419103233
0x20000000000000002:36893488147419103234

x1fffffffffffffffe:36893488147419103230
x1ffffffffffffffff:36893488147419103231
x20000000000000000:36893488147419103232
x20000000000000001:36893488147419103233
x20000000000000002:36893488147419103234

1fffffffffffffffe:36893488147419103230
1ffffffffffffffff:36893488147419103231
20000000000000000:36893488147419103232
20000000000000001:36893488147419103233
20000000000000002:36893488147419103234

# Positive

+0x1fffffffffffffffe:36893488147419103230
+0x1ffffffffffffffff:36893488147419103231
+0x20000000000000000:36893488147419103232
+0x20000000000000001:36893488147419103233
+0x20000000000000002:36893488147419103234

+x1fffffffffffffffe:36893488147419103230
+x1ffffffffffffffff:36893488147419103231
+x20000000000000000:36893488147419103232
+x20000000000000001:36893488147419103233
+x20000000000000002:36893488147419103234

+1fffffffffffffffe:36893488147419103230
+1ffffffffffffffff:36893488147419103231
+20000000000000000:36893488147419103232
+20000000000000001:36893488147419103233
+20000000000000002:36893488147419103234

# Negative

-0x1fffffffffffffffe:-36893488147419103230
-0x1ffffffffffffffff:-36893488147419103231
-0x20000000000000000:-36893488147419103232
-0x20000000000000001:-36893488147419103233
-0x20000000000000002:-36893488147419103234

-x1fffffffffffffffe:-36893488147419103230
-x1ffffffffffffffff:-36893488147419103231
-x20000000000000000:-36893488147419103232
-x20000000000000001:-36893488147419103233
-x20000000000000002:-36893488147419103234

-1fffffffffffffffe:-36893488147419103230
-1ffffffffffffffff:-36893488147419103231
-20000000000000000:-36893488147419103232
-20000000000000001:-36893488147419103233
-20000000000000002:-36893488147419103234

###############################################################################
# Absolute value is close to 10^1 = 10
###############################################################################

# Unsigned

0x8:8
0x9:9
0xa:10
0xb:11
0xc:12

x8:8
x9:9
xa:10
xb:11
xc:12

8:8
9:9
a:10
b:11
c:12

# Positive

+0x8:8
+0x9:9
+0xa:10
+0xb:11
+0xc:12

+x8:8
+x9:9
+xa:10
+xb:11
+xc:12

+8:8
+9:9
+a:10
+b:11
+c:12

# Negative

-0x8:-8
-0x9:-9
-0xa:-10
-0xb:-11
-0xc:-12

-x8:-8
-x9:-9
-xa:-10
-xb:-11
-xc:-12

-8:-8
-9:-9
-a:-10
-b:-11
-c:-12

###############################################################################
# Absolute value is close to 10^2 = 100
###############################################################################

# Unsigned

0x62:98
0x63:99
0x64:100
0x65:101
0x66:102

x62:98
x63:99
x64:100
x65:101
x66:102

62:98
63:99
64:100
65:101
66:102

# Positive

+0x62:98
+0x63:99
+0x64:100
+0x65:101
+0x66:102

+x62:98
+x63:99
+x64:100
+x65:101
+x66:102

+62:98
+63:99
+64:100
+65:101
+66:102

# Negative

-0x62:-98
-0x63:-99
-0x64:-100
-0x65:-101
-0x66:-102

-x62:-98
-x63:-99
-x64:-100
-x65:-101
-x66:-102

-62:-98
-63:-99
-64:-100
-65:-101
-66:-102

###############################################################################
# Absolute value is close to 10^3 = 1000
###############################################################################

# Unsigned

0x3e6:998
0x3e7:999
0x3e8:1000
0x3e9:1001
0x3ea:1002

x3e6:998
x3e7:999
x3e8:1000
x3e9:1001
x3ea:1002

3e6:998
3e7:999
3e8:1000
3e9:1001
3ea:1002

# Positive

+0x3e6:998
+0x3e7:999
+0x3e8:1000
+0x3e9:1001
+0x3ea:1002

+x3e6:998
+x3e7:999
+x3e8:1000
+x3e9:1001
+x3ea:1002

+3e6:998
+3e7:999
+3e8:1000
+3e9:1001
+3ea:1002

# Negative

-0x3e6:-998
-0x3e7:-999
-0x3e8:-1000
-0x3e9:-1001
-0x3ea:-1002

-x3e6:-998
-x3e7:-999
-x3e8:-1000
-x3e9:-1001
-x3ea:-1002

-3e6:-998
-3e7:-999
-3e8:-1000
-3e9:-1001
-3ea:-1002

###############################################################################
# Absolute value is close to 10^4 = 10000
###############################################################################

# Unsigned

0x270e:9998
0x270f:9999
0x2710:10000
0x2711:10001
0x2712:10002

x270e:9998
x270f:9999
x2710:10000
x2711:10001
x2712:10002

270e:9998
270f:9999
2710:10000
2711:10001
2712:10002

# Positive

+0x270e:9998
+0x270f:9999
+0x2710:10000
+0x2711:10001
+0x2712:10002

+x270e:9998
+x270f:9999
+x2710:10000
+x2711:10001
+x2712:10002

+270e:9998
+270f:9999
+2710:10000
+2711:10001
+2712:10002

# Negative

-0x270e:-9998
-0x270f:-9999
-0x2710:-10000
-0x2711:-10001
-0x2712:-10002

-x270e:-9998
-x270f:-9999
-x2710:-10000
-x2711:-10001
-x2712:-10002

-270e:-9998
-270f:-9999
-2710:-10000
-2711:-10001
-2712:-10002

###############################################################################
# Absolute value is close to 10^5 = 100000
###############################################################################

# Unsigned

0x1869e:99998
0x1869f:99999
0x186a0:100000
0x186a1:100001
0x186a2:100002

x1869e:99998
x1869f:99999
x186a0:100000
x186a1:100001
x186a2:100002

1869e:99998
1869f:99999
186a0:100000
186a1:100001
186a2:100002

# Positive

+0x1869e:99998
+0x1869f:99999
+0x186a0:100000
+0x186a1:100001
+0x186a2:100002

+x1869e:99998
+x1869f:99999
+x186a0:100000
+x186a1:100001
+x186a2:100002

+1869e:99998
+1869f:99999
+186a0:100000
+186a1:100001
+186a2:100002

# Negative

-0x1869e:-99998
-0x1869f:-99999
-0x186a0:-100000
-0x186a1:-100001
-0x186a2:-100002

-x1869e:-99998
-x1869f:-99999
-x186a0:-100000
-x186a1:-100001
-x186a2:-100002

-1869e:-99998
-1869f:-99999
-186a0:-100000
-186a1:-100001
-186a2:-100002

###############################################################################
# Absolute value is close to 10^6 = 1000000
###############################################################################

# Unsigned

0xf423e:999998
0xf423f:999999
0xf4240:1000000
0xf4241:1000001
0xf4242:1000002

xf423e:999998
xf423f:999999
xf4240:1000000
xf4241:1000001
xf4242:1000002

f423e:999998
f423f:999999
f4240:1000000
f4241:1000001
f4242:1000002

# Positive

+0xf423e:999998
+0xf423f:999999
+0xf4240:1000000
+0xf4241:1000001
+0xf4242:1000002

+xf423e:999998
+xf423f:999999
+xf4240:1000000
+xf4241:1000001
+xf4242:1000002

+f423e:999998
+f423f:999999
+f4240:1000000
+f4241:1000001
+f4242:1000002

# Negative

-0xf423e:-999998
-0xf423f:-999999
-0xf4240:-1000000
-0xf4241:-1000001
-0xf4242:-1000002

-xf423e:-999998
-xf423f:-999999
-xf4240:-1000000
-xf4241:-1000001
-xf4242:-1000002

-f423e:-999998
-f423f:-999999
-f4240:-1000000
-f4241:-1000001
-f4242:-1000002

###############################################################################
# Absolute value is close to 10^7 = 10000000
###############################################################################

# Unsigned

0x98967e:9999998
0x98967f:9999999
0x989680:10000000
0x989681:10000001
0x989682:10000002

x98967e:9999998
x98967f:9999999
x989680:10000000
x989681:10000001
x989682:10000002

98967e:9999998
98967f:9999999
989680:10000000
989681:10000001
989682:10000002

# Positive

+0x98967e:9999998
+0x98967f:9999999
+0x989680:10000000
+0x989681:10000001
+0x989682:10000002

+x98967e:9999998
+x98967f:9999999
+x989680:10000000
+x989681:10000001
+x989682:10000002

+98967e:9999998
+98967f:9999999
+989680:10000000
+989681:10000001
+989682:10000002

# Negative

-0x98967e:-9999998
-0x98967f:-9999999
-0x989680:-10000000
-0x989681:-10000001
-0x989682:-10000002

-x98967e:-9999998
-x98967f:-9999999
-x989680:-10000000
-x989681:-10000001
-x989682:-10000002

-98967e:-9999998
-98967f:-9999999
-989680:-10000000
-989681:-10000001
-989682:-10000002

###############################################################################
# Absolute value is close to 10^8 = 100000000
###############################################################################

# Unsigned

0x5f5e0fe:99999998
0x5f5e0ff:99999999
0x5f5e100:100000000
0x5f5e101:100000001
0x5f5e102:100000002

x5f5e0fe:99999998
x5f5e0ff:99999999
x5f5e100:100000000
x5f5e101:100000001
x5f5e102:100000002

5f5e0fe:99999998
5f5e0ff:99999999
5f5e100:100000000
5f5e101:100000001
5f5e102:100000002

# Positive

+0x5f5e0fe:99999998
+0x5f5e0ff:99999999
+0x5f5e100:100000000
+0x5f5e101:100000001
+0x5f5e102:100000002

+x5f5e0fe:99999998
+x5f5e0ff:99999999
+x5f5e100:100000000
+x5f5e101:100000001
+x5f5e102:100000002

+5f5e0fe:99999998
+5f5e0ff:99999999
+5f5e100:100000000
+5f5e101:100000001
+5f5e102:100000002

# Negative

-0x5f5e0fe:-99999998
-0x5f5e0ff:-99999999
-0x5f5e100:-100000000
-0x5f5e101:-100000001
-0x5f5e102:-100000002

-x5f5e0fe:-99999998
-x5f5e0ff:-99999999
-x5f5e100:-100000000
-x5f5e101:-100000001
-x5f5e102:-100000002

-5f5e0fe:-99999998
-5f5e0ff:-99999999
-5f5e100:-100000000
-5f5e101:-100000001
-5f5e102:-100000002

###############################################################################
# Absolute value is close to 10^9 = 1000000000
###############################################################################

# Unsigned

0x3b9ac9fe:999999998
0x3b9ac9ff:999999999
0x3b9aca00:1000000000
0x3b9aca01:1000000001
0x3b9aca02:1000000002

x3b9ac9fe:999999998
x3b9ac9ff:999999999
x3b9aca00:1000000000
x3b9aca01:1000000001
x3b9aca02:1000000002

3b9ac9fe:999999998
3b9ac9ff:999999999
3b9aca00:1000000000
3b9aca01:1000000001
3b9aca02:1000000002

# Positive

+0x3b9ac9fe:999999998
+0x3b9ac9ff:999999999
+0x3b9aca00:1000000000
+0x3b9aca01:1000000001
+0x3b9aca02:1000000002

+x3b9ac9fe:999999998
+x3b9ac9ff:999999999
+x3b9aca00:1000000000
+x3b9aca01:1000000001
+x3b9aca02:1000000002

+3b9ac9fe:999999998
+3b9ac9ff:999999999
+3b9aca00:1000000000
+3b9aca01:1000000001
+3b9aca02:1000000002

# Negative

-0x3b9ac9fe:-999999998
-0x3b9ac9ff:-999999999
-0x3b9aca00:-1000000000
-0x3b9aca01:-1000000001
-0x3b9aca02:-1000000002

-x3b9ac9fe:-999999998
-x3b9ac9ff:-999999999
-x3b9aca00:-1000000000
-x3b9aca01:-1000000001
-x3b9aca02:-1000000002

-3b9ac9fe:-999999998
-3b9ac9ff:-999999999
-3b9aca00:-1000000000
-3b9aca01:-1000000001
-3b9aca02:-1000000002

###############################################################################
# Absolute value is close to 10^10 = 10000000000
###############################################################################

# Unsigned

0x2540be3fe:9999999998
0x2540be3ff:9999999999
0x2540be400:10000000000
0x2540be401:10000000001
0x2540be402:10000000002

x2540be3fe:9999999998
x2540be3ff:9999999999
x2540be400:10000000000
x2540be401:10000000001
x2540be402:10000000002

2540be3fe:9999999998
2540be3ff:9999999999
2540be400:10000000000
2540be401:10000000001
2540be402:10000000002

# Positive

+0x2540be3fe:9999999998
+0x2540be3ff:9999999999
+0x2540be400:10000000000
+0x2540be401:10000000001
+0x2540be402:10000000002

+x2540be3fe:9999999998
+x2540be3ff:9999999999
+x2540be400:10000000000
+x2540be401:10000000001
+x2540be402:10000000002

+2540be3fe:9999999998
+2540be3ff:9999999999
+2540be400:10000000000
+2540be401:10000000001
+2540be402:10000000002

# Negative

-0x2540be3fe:-9999999998
-0x2540be3ff:-9999999999
-0x2540be400:-10000000000
-0x2540be401:-10000000001
-0x2540be402:-10000000002

-x2540be3fe:-9999999998
-x2540be3ff:-9999999999
-x2540be400:-10000000000
-x2540be401:-10000000001
-x2540be402:-10000000002

-2540be3fe:-9999999998
-2540be3ff:-9999999999
-2540be400:-10000000000
-2540be401:-10000000001
-2540be402:-10000000002

###############################################################################
# Absolute value is close to 10^11 = 100000000000
###############################################################################

# Unsigned

0x174876e7fe:99999999998
0x174876e7ff:99999999999
0x174876e800:100000000000
0x174876e801:100000000001
0x174876e802:100000000002

x174876e7fe:99999999998
x174876e7ff:99999999999
x174876e800:100000000000
x174876e801:100000000001
x174876e802:100000000002

174876e7fe:99999999998
174876e7ff:99999999999
174876e800:100000000000
174876e801:100000000001
174876e802:100000000002

# Positive

+0x174876e7fe:99999999998
+0x174876e7ff:99999999999
+0x174876e800:100000000000
+0x174876e801:100000000001
+0x174876e802:100000000002

+x174876e7fe:99999999998
+x174876e7ff:99999999999
+x174876e800:100000000000
+x174876e801:100000000001
+x174876e802:100000000002

+174876e7fe:99999999998
+174876e7ff:99999999999
+174876e800:100000000000
+174876e801:100000000001
+174876e802:100000000002

# Negative

-0x174876e7fe:-99999999998
-0x174876e7ff:-99999999999
-0x174876e800:-100000000000
-0x174876e801:-100000000001
-0x174876e802:-100000000002

-x174876e7fe:-99999999998
-x174876e7ff:-99999999999
-x174876e800:-100000000000
-x174876e801:-100000000001
-x174876e802:-100000000002

-174876e7fe:-99999999998
-174876e7ff:-99999999999
-174876e800:-100000000000
-174876e801:-100000000001
-174876e802:-100000000002

###############################################################################
# Absolute value is close to 10^12 = 1000000000000
###############################################################################

# Unsigned

0xe8d4a50ffe:999999999998
0xe8d4a50fff:999999999999
0xe8d4a51000:1000000000000
0xe8d4a51001:1000000000001
0xe8d4a51002:1000000000002

xe8d4a50ffe:999999999998
xe8d4a50fff:999999999999
xe8d4a51000:1000000000000
xe8d4a51001:1000000000001
xe8d4a51002:1000000000002

e8d4a50ffe:999999999998
e8d4a50fff:999999999999
e8d4a51000:1000000000000
e8d4a51001:1000000000001
e8d4a51002:1000000000002

# Positive

+0xe8d4a50ffe:999999999998
+0xe8d4a50fff:999999999999
+0xe8d4a51000:1000000000000
+0xe8d4a51001:1000000000001
+0xe8d4a51002:1000000000002

+xe8d4a50ffe:999999999998
+xe8d4a50fff:999999999999
+xe8d4a51000:1000000000000
+xe8d4a51001:1000000000001
+xe8d4a51002:1000000000002

+e8d4a50ffe:999999999998
+e8d4a50fff:999999999999
+e8d4a51000:1000000000000
+e8d4a51001:1000000000001
+e8d4a51002:1000000000002

# Negative

-0xe8d4a50ffe:-999999999998
-0xe8d4a50fff:-999999999999
-0xe8d4a51000:-1000000000000
-0xe8d4a51001:-1000000000001
-0xe8d4a51002:-1000000000002

-xe8d4a50ffe:-999999999998
-xe8d4a50fff:-999999999999
-xe8d4a51000:-1000000000000
-xe8d4a51001:-1000000000001
-xe8d4a51002:-1000000000002

-e8d4a50ffe:-999999999998
-e8d4a50fff:-999999999999
-e8d4a51000:-1000000000000
-e8d4a51001:-1000000000001
-e8d4a51002:-1000000000002

###############################################################################
# Absolute value is close to 10^13 = 10000000000000
###############################################################################

# Unsigned

0x9184e729ffe:9999999999998
0x9184e729fff:9999999999999
0x9184e72a000:10000000000000
0x9184e72a001:10000000000001
0x9184e72a002:10000000000002

x9184e729ffe:9999999999998
x9184e729fff:9999999999999
x9184e72a000:10000000000000
x9184e72a001:10000000000001
x9184e72a002:10000000000002

9184e729ffe:9999999999998
9184e729fff:9999999999999
9184e72a000:10000000000000
9184e72a001:10000000000001
9184e72a002:10000000000002

# Positive

+0x9184e729ffe:9999999999998
+0x9184e729fff:9999999999999
+0x9184e72a000:10000000000000
+0x9184e72a001:10000000000001
+0x9184e72a002:10000000000002

+x9184e729ffe:9999999999998
+x9184e729fff:9999999999999
+x9184e72a000:10000000000000
+x9184e72a001:10000000000001
+x9184e72a002:10000000000002

+9184e729ffe:9999999999998
+9184e729fff:9999999999999
+9184e72a000:10000000000000
+9184e72a001:10000000000001
+9184e72a002:10000000000002

# Negative

-0x9184e729ffe:-9999999999998
-0x9184e729fff:-9999999999999
-0x9184e72a000:-10000000000000
-0x9184e72a001:-10000000000001
-0x9184e72a002:-10000000000002

-x9184e729ffe:-9999999999998
-x9184e729fff:-9999999999999
-x9184e72a000:-10000000000000
-x9184e72a001:-10000000000001
-x9184e72a002:-10000000000002

-9184e729ffe:-9999999999998
-9184e729fff:-9999999999999
-9184e72a000:-10000000000000
-9184e72a001:-10000000000001
-9184e72a002:-10000000000002

###############################################################################
# Absolute value is close to 10^14 = 100000000000000
###############################################################################

# Unsigned

0x5af3107a3ffe:99999999999998
0x5af3107a3fff:99999999999999
0x5af3107a4000:100000000000000
0x5af3107a4001:100000000000001
0x5af3107a4002:100000000000002

x5af3107a3ffe:99999999999998
x5af3107a3fff:99999999999999
x5af3107a4000:100000000000000
x5af3107a4001:100000000000001
x5af3107a4002:100000000000002

5af3107a3ffe:99999999999998
5af3107a3fff:99999999999999
5af3107a4000:100000000000000
5af3107a4001:100000000000001
5af3107a4002:100000000000002

# Positive

+0x5af3107a3ffe:99999999999998
+0x5af3107a3fff:99999999999999
+0x5af3107a4000:100000000000000
+0x5af3107a4001:100000000000001
+0x5af3107a4002:100000000000002

+x5af3107a3ffe:99999999999998
+x5af3107a3fff:99999999999999
+x5af3107a4000:100000000000000
+x5af3107a4001:100000000000001
+x5af3107a4002:100000000000002

+5af3107a3ffe:99999999999998
+5af3107a3fff:99999999999999
+5af3107a4000:100000000000000
+5af3107a4001:100000000000001
+5af3107a4002:100000000000002

# Negative

-0x5af3107a3ffe:-99999999999998
-0x5af3107a3fff:-99999999999999
-0x5af3107a4000:-100000000000000
-0x5af3107a4001:-100000000000001
-0x5af3107a4002:-100000000000002

-x5af3107a3ffe:-99999999999998
-x5af3107a3fff:-99999999999999
-x5af3107a4000:-100000000000000
-x5af3107a4001:-100000000000001
-x5af3107a4002:-100000000000002

-5af3107a3ffe:-99999999999998
-5af3107a3fff:-99999999999999
-5af3107a4000:-100000000000000
-5af3107a4001:-100000000000001
-5af3107a4002:-100000000000002

###############################################################################
# Absolute value is close to 10^15 = 1000000000000000
###############################################################################

# Unsigned

0x38d7ea4c67ffe:999999999999998
0x38d7ea4c67fff:999999999999999
0x38d7ea4c68000:1000000000000000
0x38d7ea4c68001:1000000000000001
0x38d7ea4c68002:1000000000000002

x38d7ea4c67ffe:999999999999998
x38d7ea4c67fff:999999999999999
x38d7ea4c68000:1000000000000000
x38d7ea4c68001:1000000000000001
x38d7ea4c68002:1000000000000002

38d7ea4c67ffe:999999999999998
38d7ea4c67fff:999999999999999
38d7ea4c68000:1000000000000000
38d7ea4c68001:1000000000000001
38d7ea4c68002:1000000000000002

# Positive

+0x38d7ea4c67ffe:999999999999998
+0x38d7ea4c67fff:999999999999999
+0x38d7ea4c68000:1000000000000000
+0x38d7ea4c68001:1000000000000001
+0x38d7ea4c68002:1000000000000002

+x38d7ea4c67ffe:999999999999998
+x38d7ea4c67fff:999999999999999
+x38d7ea4c68000:1000000000000000
+x38d7ea4c68001:1000000000000001
+x38d7ea4c68002:1000000000000002

+38d7ea4c67ffe:999999999999998
+38d7ea4c67fff:999999999999999
+38d7ea4c68000:1000000000000000
+38d7ea4c68001:1000000000000001
+38d7ea4c68002:1000000000000002

# Negative

-0x38d7ea4c67ffe:-999999999999998
-0x38d7ea4c67fff:-999999999999999
-0x38d7ea4c68000:-1000000000000000
-0x38d7ea4c68001:-1000000000000001
-0x38d7ea4c68002:-1000000000000002

-x38d7ea4c67ffe:-999999999999998
-x38d7ea4c67fff:-999999999999999
-x38d7ea4c68000:-1000000000000000
-x38d7ea4c68001:-1000000000000001
-x38d7ea4c68002:-1000000000000002

-38d7ea4c67ffe:-999999999999998
-38d7ea4c67fff:-999999999999999
-38d7ea4c68000:-1000000000000000
-38d7ea4c68001:-1000000000000001
-38d7ea4c68002:-1000000000000002

###############################################################################
# Absolute value is close to 10^16 = 10000000000000000
###############################################################################

# Unsigned

0x2386f26fc0fffe:9999999999999998
0x2386f26fc0ffff:9999999999999999
0x2386f26fc10000:10000000000000000
0x2386f26fc10001:10000000000000001
0x2386f26fc10002:10000000000000002

x2386f26fc0fffe:9999999999999998
x2386f26fc0ffff:9999999999999999
x2386f26fc10000:10000000000000000
x2386f26fc10001:10000000000000001
x2386f26fc10002:10000000000000002

2386f26fc0fffe:9999999999999998
2386f26fc0ffff:9999999999999999
2386f26fc10000:10000000000000000
2386f26fc10001:10000000000000001
2386f26fc10002:10000000000000002

# Positive

+0x2386f26fc0fffe:9999999999999998
+0x2386f26fc0ffff:9999999999999999
+0x2386f26fc10000:10000000000000000
+0x2386f26fc10001:10000000000000001
+0x2386f26fc10002:10000000000000002

+x2386f26fc0fffe:9999999999999998
+x2386f26fc0ffff:9999999999999999
+x2386f26fc10000:10000000000000000
+x2386f26fc10001:10000000000000001
+x2386f26fc10002:10000000000000002

+2386f26fc0fffe:9999999999999998
+2386f26fc0ffff:9999999999999999
+2386f26fc10000:10000000000000000
+2386f26fc10001:10000000000000001
+2386f26fc10002:10000000000000002

# Negative

-0x2386f26fc0fffe:-9999999999999998
-0x2386f26fc0ffff:-9999999999999999
-0x2386f26fc10000:-10000000000000000
-0x2386f26fc10001:-10000000000000001
-0x2386f26fc10002:-10000000000000002

-x2386f26fc0fffe:-9999999999999998
-x2386f26fc0ffff:-9999999999999999
-x2386f26fc10000:-10000000000000000
-x2386f26fc10001:-10000000000000001
-x2386f26fc10002:-10000000000000002

-2386f26fc0fffe:-9999999999999998
-2386f26fc0ffff:-9999999999999999
-2386f26fc10000:-10000000000000000
-2386f26fc10001:-10000000000000001
-2386f26fc10002:-10000000000000002

###############################################################################
# Absolute value is close to 10^17 = 100000000000000000
###############################################################################

# Unsigned

0x16345785d89fffe:99999999999999998
0x16345785d89ffff:99999999999999999
0x16345785d8a0000:100000000000000000
0x16345785d8a0001:100000000000000001
0x16345785d8a0002:100000000000000002

x16345785d89fffe:99999999999999998
x16345785d89ffff:99999999999999999
x16345785d8a0000:100000000000000000
x16345785d8a0001:100000000000000001
x16345785d8a0002:100000000000000002

16345785d89fffe:99999999999999998
16345785d89ffff:99999999999999999
16345785d8a0000:100000000000000000
16345785d8a0001:100000000000000001
16345785d8a0002:100000000000000002

# Positive

+0x16345785d89fffe:99999999999999998
+0x16345785d89ffff:99999999999999999
+0x16345785d8a0000:100000000000000000
+0x16345785d8a0001:100000000000000001
+0x16345785d8a0002:100000000000000002

+x16345785d89fffe:99999999999999998
+x16345785d89ffff:99999999999999999
+x16345785d8a0000:100000000000000000
+x16345785d8a0001:100000000000000001
+x16345785d8a0002:100000000000000002

+16345785d89fffe:99999999999999998
+16345785d89ffff:99999999999999999
+16345785d8a0000:100000000000000000
+16345785d8a0001:100000000000000001
+16345785d8a0002:100000000000000002

# Negative

-0x16345785d89fffe:-99999999999999998
-0x16345785d89ffff:-99999999999999999
-0x16345785d8a0000:-100000000000000000
-0x16345785d8a0001:-100000000000000001
-0x16345785d8a0002:-100000000000000002

-x16345785d89fffe:-99999999999999998
-x16345785d89ffff:-99999999999999999
-x16345785d8a0000:-100000000000000000
-x16345785d8a0001:-100000000000000001
-x16345785d8a0002:-100000000000000002

-16345785d89fffe:-99999999999999998
-16345785d89ffff:-99999999999999999
-16345785d8a0000:-100000000000000000
-16345785d8a0001:-100000000000000001
-16345785d8a0002:-100000000000000002

###############################################################################
# Absolute value is close to 10^18 = 1000000000000000000
###############################################################################

# Unsigned

0xde0b6b3a763fffe:999999999999999998
0xde0b6b3a763ffff:999999999999999999
0xde0b6b3a7640000:1000000000000000000
0xde0b6b3a7640001:1000000000000000001
0xde0b6b3a7640002:1000000000000000002

xde0b6b3a763fffe:999999999999999998
xde0b6b3a763ffff:999999999999999999
xde0b6b3a7640000:1000000000000000000
xde0b6b3a7640001:1000000000000000001
xde0b6b3a7640002:1000000000000000002

de0b6b3a763fffe:999999999999999998
de0b6b3a763ffff:999999999999999999
de0b6b3a7640000:1000000000000000000
de0b6b3a7640001:1000000000000000001
de0b6b3a7640002:1000000000000000002

# Positive

+0xde0b6b3a763fffe:999999999999999998
+0xde0b6b3a763ffff:999999999999999999
+0xde0b6b3a7640000:1000000000000000000
+0xde0b6b3a7640001:1000000000000000001
+0xde0b6b3a7640002:1000000000000000002

+xde0b6b3a763fffe:999999999999999998
+xde0b6b3a763ffff:999999999999999999
+xde0b6b3a7640000:1000000000000000000
+xde0b6b3a7640001:1000000000000000001
+xde0b6b3a7640002:1000000000000000002

+de0b6b3a763fffe:999999999999999998
+de0b6b3a763ffff:999999999999999999
+de0b6b3a7640000:1000000000000000000
+de0b6b3a7640001:1000000000000000001
+de0b6b3a7640002:1000000000000000002

# Negative

-0xde0b6b3a763fffe:-999999999999999998
-0xde0b6b3a763ffff:-999999999999999999
-0xde0b6b3a7640000:-1000000000000000000
-0xde0b6b3a7640001:-1000000000000000001
-0xde0b6b3a7640002:-1000000000000000002

-xde0b6b3a763fffe:-999999999999999998
-xde0b6b3a763ffff:-999999999999999999
-xde0b6b3a7640000:-1000000000000000000
-xde0b6b3a7640001:-1000000000000000001
-xde0b6b3a7640002:-1000000000000000002

-de0b6b3a763fffe:-999999999999999998
-de0b6b3a763ffff:-999999999999999999
-de0b6b3a7640000:-1000000000000000000
-de0b6b3a7640001:-1000000000000000001
-de0b6b3a7640002:-1000000000000000002

###############################################################################
# Absolute value is close to 10^19 = 10000000000000000000
###############################################################################

# Unsigned

0x8ac7230489e7fffe:9999999999999999998
0x8ac7230489e7ffff:9999999999999999999
0x8ac7230489e80000:10000000000000000000
0x8ac7230489e80001:10000000000000000001
0x8ac7230489e80002:10000000000000000002

x8ac7230489e7fffe:9999999999999999998
x8ac7230489e7ffff:9999999999999999999
x8ac7230489e80000:10000000000000000000
x8ac7230489e80001:10000000000000000001
x8ac7230489e80002:10000000000000000002

8ac7230489e7fffe:9999999999999999998
8ac7230489e7ffff:9999999999999999999
8ac7230489e80000:10000000000000000000
8ac7230489e80001:10000000000000000001
8ac7230489e80002:10000000000000000002

# Positive

+0x8ac7230489e7fffe:9999999999999999998
+0x8ac7230489e7ffff:9999999999999999999
+0x8ac7230489e80000:10000000000000000000
+0x8ac7230489e80001:10000000000000000001
+0x8ac7230489e80002:10000000000000000002

+x8ac7230489e7fffe:9999999999999999998
+x8ac7230489e7ffff:9999999999999999999
+x8ac7230489e80000:10000000000000000000
+x8ac7230489e80001:10000000000000000001
+x8ac7230489e80002:10000000000000000002

+8ac7230489e7fffe:9999999999999999998
+8ac7230489e7ffff:9999999999999999999
+8ac7230489e80000:10000000000000000000
+8ac7230489e80001:10000000000000000001
+8ac7230489e80002:10000000000000000002

# Negative

-0x8ac7230489e7fffe:-9999999999999999998
-0x8ac7230489e7ffff:-9999999999999999999
-0x8ac7230489e80000:-10000000000000000000
-0x8ac7230489e80001:-10000000000000000001
-0x8ac7230489e80002:-10000000000000000002

-x8ac7230489e7fffe:-9999999999999999998
-x8ac7230489e7ffff:-9999999999999999999
-x8ac7230489e80000:-10000000000000000000
-x8ac7230489e80001:-10000000000000000001
-x8ac7230489e80002:-10000000000000000002

-8ac7230489e7fffe:-9999999999999999998
-8ac7230489e7ffff:-9999999999999999999
-8ac7230489e80000:-10000000000000000000
-8ac7230489e80001:-10000000000000000001
-8ac7230489e80002:-10000000000000000002

###############################################################################
# Absolute value is close to 10^20 = 100000000000000000000
###############################################################################

# Unsigned

0x56bc75e2d630ffffe:99999999999999999998
0x56bc75e2d630fffff:99999999999999999999
0x56bc75e2d63100000:100000000000000000000
0x56bc75e2d63100001:100000000000000000001
0x56bc75e2d63100002:100000000000000000002

x56bc75e2d630ffffe:99999999999999999998
x56bc75e2d630fffff:99999999999999999999
x56bc75e2d63100000:100000000000000000000
x56bc75e2d63100001:100000000000000000001
x56bc75e2d63100002:100000000000000000002

56bc75e2d630ffffe:99999999999999999998
56bc75e2d630fffff:99999999999999999999
56bc75e2d63100000:100000000000000000000
56bc75e2d63100001:100000000000000000001
56bc75e2d63100002:100000000000000000002

# Positive

+0x56bc75e2d630ffffe:99999999999999999998
+0x56bc75e2d630fffff:99999999999999999999
+0x56bc75e2d63100000:100000000000000000000
+0x56bc75e2d63100001:100000000000000000001
+0x56bc75e2d63100002:100000000000000000002

+x56bc75e2d630ffffe:99999999999999999998
+x56bc75e2d630fffff:99999999999999999999
+x56bc75e2d63100000:100000000000000000000
+x56bc75e2d63100001:100000000000000000001
+x56bc75e2d63100002:100000000000000000002

+56bc75e2d630ffffe:99999999999999999998
+56bc75e2d630fffff:99999999999999999999
+56bc75e2d63100000:100000000000000000000
+56bc75e2d63100001:100000000000000000001
+56bc75e2d63100002:100000000000000000002

# Negative

-0x56bc75e2d630ffffe:-99999999999999999998
-0x56bc75e2d630fffff:-99999999999999999999
-0x56bc75e2d63100000:-100000000000000000000
-0x56bc75e2d63100001:-100000000000000000001
-0x56bc75e2d63100002:-100000000000000000002

-x56bc75e2d630ffffe:-99999999999999999998
-x56bc75e2d630fffff:-99999999999999999999
-x56bc75e2d63100000:-100000000000000000000
-x56bc75e2d63100001:-100000000000000000001
-x56bc75e2d63100002:-100000000000000000002

-56bc75e2d630ffffe:-99999999999999999998
-56bc75e2d630fffff:-99999999999999999999
-56bc75e2d63100000:-100000000000000000000
-56bc75e2d63100001:-100000000000000000001
-56bc75e2d63100002:-100000000000000000002
