package API::MailboxOrg::API::Capabilities;

# ABSTRACT: MailboxOrg::API::Capabilities

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.0'; # VERSION

my %validators = (
    'set' => validation_for(
        params => {
            mail         => { type => Str, optional => 0 },
            capabilities => { type => Enum[qw(MAIL_SPAMPROTECTION MAIL_BLACKLIST MAIL_BACKUPRECOVER MAIL_OTP MAIL_PASSWORDRESET_SMS BMBO_VIDEOCHAT)], optional => 0 },

        },
    ),

);


sub set ($self, %params) {
    my $validator = $validators{'set'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.capabilities.set', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Capabilities - MailboxOrg::API::Capabilities

=head1 VERSION

version 1.0.0

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 set

Modifies email capabilities

Available for admin, reseller, account, domain

Parameters:

=over 4

=item * mail

=item * capabilities

=back

returns: boolean

    $api->capabilities->set(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
