package Module::Build::Base::Patch::DumpAndExit;

our $DATE = '2015-01-14'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
no warnings;

use Data::Dump;
use Module::Patch 0.19 qw();
use base qw(Module::Patch);

our %config;

sub _dump {
    print "# BEGIN DUMP $config{-tag}\n";
    dd @_;
    print "# END DUMP $config{-tag}\n";
}

sub _create_build_script {
    _dump(shift);
    $config{-exit_method} eq 'exit' ? exit(0) : die;
}

sub patch_data {
    return {
        v => 3,
        patches => [
            {
                action      => 'replace',
                sub_name    => 'create_build_script',
                code        => \&_create_build_script,
            },
        ],
        config => {
            -tag => {
                schema  => 'str*',
                default => 'TAG',
            },
            -exit_method => {
                schema  => 'str*',
                default => 'exit',
            },
        },
   };
}

1;
# ABSTRACT: Patch Module::Build's create_build_script to dump object and exit

__END__

=pod

=encoding UTF-8

=head1 NAME

Module::Build::Base::Patch::DumpAndExit - Patch Module::Build's create_build_script to dump object and exit

=head1 VERSION

This document describes version 0.02 of Module::Build::Base::Patch::DumpAndExit (from Perl distribution Module-Build-Dump), released on 2015-01-14.

=head1 DESCRIPTION

This patch can be used to extract object content from `Build.PL` script
without actually producing a Build script.

=for Pod::Coverage ^(patch_data)$

=head1 SEE ALSO

L<ExtUtils::MakeMaker::Patch::DumpAndExit>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Module-Build-Dump>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Module-Build-Dump>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Module-Build-Dump>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
