package Bencher::Scenario::TreeObject::descendants;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::TreeObject;
use Tree::Create::Size;

my $classes = \%Bencher::ScenarioUtil::TreeObject::classes;

our $scenario = {
    summary => 'Benchmark descendants()',
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                module => $_,
                code_template => "state \$tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => '".($spec->{use_my_class} ? "My::$_":$_)."'); my \@res = \$tree->descendants; scalar(\@res)",
            }
        } sort keys %$classes,
    ],
    datasets => [
        {
            name => 'small1 (31 nodes)',
            args => {height=>4, num_children=>2},
        },
        {
            name => 'small2 (364 nodes)',
            args => {height=>5, num_children=>3},
        },
        {
            name => 'small3 (1365 nodes)',
            args => {height=>5, num_children=>4},
        },
        {
            name => 'medium1 (19531 nodes)',
            args => {height=>6, num_children=>5},
        },
    ],
};

1;
# ABSTRACT: Benchmark descendants()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TreeObject::descendants - Benchmark descendants()

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::TreeObject::descendants (from Perl distribution Bencher-Scenarios-TreeObject), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TreeObject::descendants

To run module startup overhead benchmark:

 % bencher --module-startup -m TreeObject::descendants

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Tree::Object::Array> 0.05

L<Tree::Object::Array::Glob> 0.05

L<Tree::Object::Hash> 0.05

L<Tree::Object::Hash::ChildrenAsList> 0.05

L<Tree::ObjectXS::Array> 0.02

L<Tree::ObjectXS::Hash> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Tree::Object::Array (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::Object::Array'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Array::Glob (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::Object::Array::Glob'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Hash (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::Object::Hash'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Hash::ChildrenAsList (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::Object::Hash::ChildrenAsList'); my @res = $tree->descendants; scalar(@res)



=item * Tree::ObjectXS::Array (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::ObjectXS::Array'); my @res = $tree->descendants; scalar(@res)



=item * Tree::ObjectXS::Hash (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::ObjectXS::Hash'); my @res = $tree->descendants; scalar(@res)



=back

=head1 BENCHMARK DATASETS

=over

=item * small1 (31 nodes)

=item * small2 (364 nodes)

=item * small3 (1365 nodes)

=item * medium1 (19531 nodes)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with C<< bencher -m TreeObject::descendants --include-datasets 'small1 (31 nodes)' >>:

 +------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                        | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+-----------+------------+---------+---------+
 | Tree::Object::Array::Glob          | 1.2e+04   | 85        | 1          | 1.1e-07 | 20      |
 | Tree::Object::Hash                 | 1.3e+04   | 76        | 1.1        | 3e-07   | 23      |
 | Tree::Object::Array                | 1.5e+04   | 68        | 1.3        | 1.2e-07 | 26      |
 | Tree::Object::Hash::ChildrenAsList | 1.72e+04  | 58        | 1.47       | 2.3e-08 | 26      |
 | Tree::ObjectXS::Hash               | 1.8e+04   | 55        | 1.5        | 1.1e-07 | 20      |
 | Tree::ObjectXS::Array              | 1.9e+04   | 53        | 1.6        | 1e-07   | 21      |
 +------------------------------------+-----------+-----------+------------+---------+---------+


Benchmark with C<< bencher -m TreeObject::descendants --include-datasets 'medium1 (19531 nodes)' >>:

 +------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                        | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+-----------+------------+---------+---------+
 | Tree::Object::Array::Glob          | 19.5      | 51.3      | 1          | 4.7e-05 | 20      |
 | Tree::Object::Hash                 | 22.8      | 43.8      | 1.17       | 1.3e-05 | 20      |
 | Tree::Object::Hash::ChildrenAsList | 26.2      | 38.2      | 1.34       | 1.1e-05 | 21      |
 | Tree::Object::Array                | 27.6      | 36.3      | 1.41       | 2.1e-05 | 20      |
 | Tree::ObjectXS::Hash               | 30.4      | 32.9      | 1.56       | 9.1e-06 | 22      |
 | Tree::ObjectXS::Array              | 30.8      | 32.5      | 1.58       | 1.1e-05 | 20      |
 +------------------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TreeObject>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TreeObject>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TreeObject>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
