package Bencher::Scenario::DataCSel::Parsing;

our $DATE = '2016-04-12'; # DATE
our $VERSION = '0.03'; # VERSION

our $scenario = {
    summary => 'Benchmark parsing speed',
    modules => {
        'Data::CSel' => {version => '0.04'},
    },
    participants => [
        { fcall_template => 'Data::CSel::parse_csel(<expr>)' },
    ],
    datasets => [
        {args=>{expr=>'*'}},
        {args=>{expr=>'T'}},
        {args=>{expr=>'T T2 T3 T4 T5'}},
        {args=>{expr=>'T ~ T ~ T ~ T ~ T'}},
        {args=>{expr=>':has(T[length > 1])'}},
    ],
};

1;
# ABSTRACT: Benchmark parsing speed

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataCSel::Parsing - Benchmark parsing speed

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::DataCSel::Parsing (from Perl distribution Bencher-Scenarios-DataCSel), released on 2016-04-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataCSel::Parsing

To run module startup overhead benchmark:

 % bencher --module-startup -m DataCSel::Parsing

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::CSel> 0.07

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::CSel::parse_csel (perl_code)

Function call template:

 Data::CSel::parse_csel(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * *

=item * T

=item * T T2 T3 T4 T5

=item * T ~ T ~ T ~ T ~ T

=item * :has(T[length > 1])

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataCSel::Parsing >>):

 +---------------------+-----------+-----------+------------+---------+---------+
 | dataset             | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | :has(T[length > 1]) | 30739.1   | 32.5319   | 1          | 0       | 20      |
 | T ~ T ~ T ~ T ~ T   | 4.8e+04   | 21        | 1.6        | 2.6e-08 | 21      |
 | T T2 T3 T4 T5       | 4.91e+04  | 20.3      | 1.6        | 6.7e-09 | 20      |
 | T                   | 1.88e+05  | 5.31      | 6.13       | 4.2e-09 | 29      |
 | *                   | 1.93e+05  | 5.18      | 6.28       | 5e-09   | 20      |
 +---------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataCSel::Parsing --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::CSel          | 7.9       | 5.3                    | 1          | 2.8e-05 | 21      |
 | perl -e1 (baseline) | 2.6       | 0                      | 3          | 1.5e-05 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataCSel>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataCSel>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataCSel>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
