package Bencher::Scenario::ArraySet::union;

our $DATE = '2016-09-16'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark union operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_union(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'union',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->union($set2);', # $res->as_string
        },
        {
            module => 'Set::Scalar',
            function => 'union',
            code_template => 'my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->union($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[3..7] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[96..105] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[996..1005] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[951..1050] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark union operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::union - Benchmark union operation

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::ArraySet::union (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::union

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::union

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.05

L<Set::Object> 1.35

L<Set::Scalar> 1.29

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_union (perl_code)

Function call template:

 Array::Set::set_union(<set1>, <set2>)



=item * Set::Object::union (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->union($set2);



=item * Set::Scalar::union (perl_code)

Code template:

 my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->union($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m ArraySet::union --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.05/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |       304 |      3.29 |       1    | 1.3e-06 |      20 |
 | Array::Set::set_union | 0.02   |       364 |      2.75 |       1.2  | 9.1e-07 |      20 |
 | Array::Set::set_union | 0.05   |      1900 |      0.53 |       6.2  | 8.5e-07 |      20 |
 | Set::Object::union    |        |      2130 |      0.47 |       7.01 | 4.3e-07 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |       294 |     3.4   |       1    | 3.1e-06 |      21 |
 | Array::Set::set_union | 0.02   |       361 |     2.77  |       1.23 | 8.5e-07 |      20 |
 | Array::Set::set_union | 0.05   |      1890 |     0.529 |       6.42 | 2.7e-07 |      20 |
 | Set::Object::union    |        |      2100 |     0.48  |       7.1  | 4.8e-07 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |       264 |     3.79  |       1    | 1.8e-06 |      20 |
 | Array::Set::set_union | 0.02   |       333 |     3     |       1.26 | 9.1e-07 |      20 |
 | Array::Set::set_union | 0.05   |      1770 |     0.565 |       6.7  | 2.1e-07 |      20 |
 | Set::Object::union    |        |      1840 |     0.542 |       6.98 | 4.3e-07 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |       170 |     5.7   |       1    | 1.2e-05 |      20 |
 | Array::Set::set_union | 0.02   |       220 |     4.6   |       1.3  | 4.8e-06 |      21 |
 | Set::Object::union    |        |      1140 |     0.878 |       6.53 | 4.8e-07 |      20 |
 | Array::Set::set_union | 0.05   |      1360 |     0.735 |       7.81 |   2e-07 |      22 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |      2510 |       398 |       1    | 3.4e-07 |      32 |
 | Array::Set::set_union | 0.02   |      3480 |       288 |       1.38 | 2.1e-07 |      20 |
 | Set::Object::union    |        |     21000 |        47 |       8.4  | 5.3e-08 |      20 |
 | Array::Set::set_union | 0.05   |     22000 |        45 |       8.9  | 5.3e-08 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |      2360 |       423 |       1    | 2.1e-07 |      20 |
 | Array::Set::set_union | 0.02   |      3200 |       310 |       1.4  | 4.3e-07 |      20 |
 | Set::Object::union    |        |     19000 |        53 |       8    | 1.1e-07 |      31 |
 | Array::Set::set_union | 0.05   |     20800 |        48 |       8.81 | 1.1e-08 |      27 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |      1640 |     608   |       1    | 4.3e-07 |      20 |
 | Array::Set::set_union | 0.02   |      2140 |     466   |       1.3  | 4.3e-07 |      20 |
 | Set::Object::union    |        |     12000 |      86   |       7.1  | 9.4e-08 |      26 |
 | Array::Set::set_union | 0.05   |     15800 |      63.4 |       9.59 | 2.1e-08 |      32 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |     10000 |   95      |      1     | 9.9e-08 |      23 |
 | Array::Set::set_union | 0.02   |     30000 |   34      |      2.8   | 4.4e-08 |      30 |
 | Set::Object::union    |        |    123000 |    8.13   |     11.7   | 3.2e-09 |      23 |
 | Array::Set::set_union | 0.05   |    149590 |    6.6851 |     14.247 | 1.2e-11 |      28 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |      8690 |     115   |        1   | 5.3e-08 |      20 |
 | Array::Set::set_union | 0.02   |     20000 |      50   |        2.3 | 9.3e-08 |      20 |
 | Set::Object::union    |        |     90600 |      11   |       10.4 |   1e-08 |      20 |
 | Array::Set::set_union | 0.05   |    123000 |       8.1 |       14.2 | 3.3e-09 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |      9530 |    105    |        1   | 5.3e-08 |      20 |
 | Array::Set::set_union | 0.02   |     24000 |     41    |        2.5 | 1.2e-07 |      37 |
 | Set::Object::union    |        |    100000 |      9.5  |       11   |   1e-08 |      20 |
 | Array::Set::set_union | 0.05   |    136000 |      7.35 |       14.3 | 2.7e-09 |      30 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | participant           | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::union    |        |     15000 |     66    |        1   | 2.4e-07 |      35 |
 | Array::Set::set_union | 0.02   |    117000 |      8.56 |        7.7 | 3.1e-09 |      23 |
 | Set::Object::union    |        |    224000 |      4.47 |       14.7 | 1.7e-09 |      20 |
 | Array::Set::set_union | 0.05   |    646000 |      1.55 |       42.6 | 8.3e-10 |      20 |
 +-----------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::union --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Set::Object         |      16   |                   11.5 |        1   | 5.6e-05 |      20 |
 | Set::Scalar         |      15   |                   10.5 |        1.1 | 1.9e-05 |      22 |
 | Array::Set          |       8.2 |                    3.7 |        2   | 2.6e-05 |      20 |
 | perl -e1 (baseline) |       4.5 |                    0   |        3.6 | 1.6e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
