package Bencher::Scenario::ArraySet::intersect;

our $DATE = '2016-09-16'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark intersect operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_intersect(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'intersection',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);', # $res->as_string
        },
        {
            module => 'Set::Scalar',
            function => 'intersection',
            code_template => 'my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[1..5] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[1..10] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[1..10] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[1..100] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark intersect operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::intersect - Benchmark intersect operation

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::ArraySet::intersect (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::intersect

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::intersect

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.05

L<Set::Object> 1.35

L<Set::Scalar> 1.29

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_intersect (perl_code)

Function call template:

 Array::Set::set_intersect(<set1>, <set2>)



=item * Set::Object::intersection (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);



=item * Set::Scalar::intersection (perl_code)

Code template:

 my $set1 = Set::Scalar->new; $set1->insert(@{<set1>}); my $set2 = Set::Scalar->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m ArraySet::intersect --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.05/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       306 |     3.27  |       1    | 3.1e-06 |      36 |
 | Set::Scalar::intersection |        |       418 |     2.39  |       1.37 |   2e-06 |      20 |
 | Set::Object::intersection |        |      1170 |     0.855 |       3.82 | 6.2e-07 |      21 |
 | Array::Set::set_intersect | 0.05   |      5800 |     0.173 |      18.9  | 4.8e-08 |      25 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       327 |     3.06  |       1    | 4.3e-07 |      20 |
 | Set::Scalar::intersection |        |       400 |     2.5   |       1.2  | 3.6e-06 |      20 |
 | Set::Object::intersection |        |      1150 |     0.87  |       3.51 | 6.9e-07 |      20 |
 | Array::Set::set_intersect | 0.05   |      5630 |     0.178 |      17.2  | 4.6e-08 |      27 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       295 |     3.39  |       1    | 2.4e-06 |      20 |
 | Set::Scalar::intersection |        |       367 |     2.73  |       1.24 | 2.7e-06 |      20 |
 | Set::Object::intersection |        |      1100 |     0.9   |       3.8  | 9.1e-07 |      20 |
 | Array::Set::set_intersect | 0.05   |      4440 |     0.225 |      15    | 2.1e-07 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       130 |      7.5  |       1    | 2.9e-05 |      20 |
 | Set::Scalar::intersection |        |       257 |      3.89 |       1.93 | 1.7e-06 |      20 |
 | Set::Object::intersection |        |       920 |      1.09 |       6.92 | 7.1e-07 |      22 |
 | Array::Set::set_intersect | 0.05   |      1470 |      0.68 |      11.1  | 4.8e-07 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |      2230 |       448 |        1   |   2e-07 |      22 |
 | Array::Set::set_intersect | 0.02   |      2900 |       340 |        1.3 |   2e-06 |      20 |
 | Set::Object::intersection |        |     11000 |        88 |        5.1 |   2e-07 |      22 |
 | Array::Set::set_intersect | 0.05   |     63000 |        16 |       28   | 2.3e-08 |      27 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |      2140 |     468   |       1    | 2.7e-07 |      20 |
 | Array::Set::set_intersect | 0.02   |      2580 |     388   |       1.21 | 2.4e-07 |      24 |
 | Set::Object::intersection |        |     11000 |      91.1 |       5.14 | 8.9e-08 |      29 |
 | Array::Set::set_intersect | 0.05   |     49400 |      20.2 |      23.1  | 6.2e-09 |      23 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |      1360 |       734 |       1    | 2.6e-07 |      21 |
 | Set::Scalar::intersection |        |      1550 |       646 |       1.14 | 3.7e-07 |      20 |
 | Set::Object::intersection |        |      9200 |       110 |       6.7  | 2.1e-07 |      20 |
 | Array::Set::set_intersect | 0.05   |     17000 |        60 |      12    |   8e-08 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |      9900 |    100    |        1   | 1.1e-07 |      20 |
 | Array::Set::set_intersect | 0.02   |     25000 |     39    |        2.6 | 6.7e-08 |      20 |
 | Set::Object::intersection |        |     83000 |     12    |        8.4 | 1.3e-08 |      20 |
 | Array::Set::set_intersect | 0.05   |    306000 |      3.27 |       30.8 | 1.5e-09 |      26 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |      8300 |   120     |       1    | 1.7e-07 |      31 |
 | Array::Set::set_intersect | 0.02   |     14000 |    72     |       1.7  | 1.1e-07 |      28 |
 | Set::Object::intersection |        |     74000 |    14     |       8.8  | 2.7e-08 |      20 |
 | Array::Set::set_intersect | 0.05   |    132200 |     7.563 |      15.91 | 9.8e-11 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |      9120 |    110    |       1    | 5.3e-08 |      20 |
 | Array::Set::set_intersect | 0.02   |     18000 |     55    |       2    |   9e-08 |      28 |
 | Set::Object::intersection |        |     76300 |     13.1  |       8.37 | 6.5e-09 |      21 |
 | Array::Set::set_intersect | 0.05   |    188000 |      5.32 |      20.6  | 1.4e-09 |      28 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Set::Scalar::intersection |        |     15000 |   65      |      1     | 9.5e-08 |      25 |
 | Array::Set::set_intersect | 0.02   |     92000 |   11      |      5.9   | 1.3e-08 |      21 |
 | Set::Object::intersection |        |    205000 |    4.89   |     13.2   | 1.5e-09 |      26 |
 | Array::Set::set_intersect | 0.05   |    511340 |    1.9556 |     33.082 | 1.1e-11 |      24 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::intersect --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Set::Object         |      16   |                   11.5 |       1    |   1e-05 |      20 |
 | Set::Scalar         |      14.9 |                   10.4 |       1.07 | 1.2e-05 |      20 |
 | Array::Set          |       8.2 |                    3.7 |       2    |   4e-05 |      20 |
 | perl -e1 (baseline) |       4.5 |                    0   |       3.5  |   1e-05 |      21 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
