package Bencher::Scenario::GetoptModules;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark some popular Perl Getopt modules',

    module_startup => 1,

    participants => [
        {module=>'Getopt::Long', tags=>['getopt-long']},
        {module=>'Getopt::Long::Less', tags=>['getopt-long']},
        {module=>'Getopt::Long::EvenLess', tags=>['getopt-long']},
        {module=>'Getopt::Long::Complete', tags=>['getopt-long']},
        {module=>'Getopt::Long::Descriptive', tags=>['getopt-long']},
        {module=>'Getopt::Long::Subcommand', tags=>['getopt-long']},

        {module=>'Getopt::Std'},

        {module=>'MooseX::Getopt', tags=>['moox']},

        {module=>'Getopt::ArgvFile'},
        {module=>'Getopt::Lucid'},
        {module=>'Getopt::Panjang'},
        {module=>'Getopt::Std::Strict'},
    ],
};

1;
# ABSTRACT: Benchmark some popular Perl Getopt modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GetoptModules - Benchmark some popular Perl Getopt modules

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::GetoptModules (from Perl distribution Bencher-Scenario-GetoptModules), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m GetoptModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Getopt::Long> 2.49

L<Getopt::Long::Less> 0.06

L<Getopt::Long::EvenLess> 0.04

L<Getopt::Long::Complete> 0.27

L<Getopt::Long::Descriptive> 0.099

L<Getopt::Long::Subcommand> 0.05

L<Getopt::Std> 1.11

L<MooseX::Getopt> 0.68

L<Getopt::ArgvFile> 1.11

L<Getopt::Lucid> 1.06

L<Getopt::Panjang> 0.04

L<Getopt::Std::Strict> 1.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * Getopt::Long (perl_code) [getopt-long]

L<Getopt::Long>



=item * Getopt::Long::Less (perl_code) [getopt-long]

L<Getopt::Long::Less>



=item * Getopt::Long::EvenLess (perl_code) [getopt-long]

L<Getopt::Long::EvenLess>



=item * Getopt::Long::Complete (perl_code) [getopt-long]

L<Getopt::Long::Complete>



=item * Getopt::Long::Descriptive (perl_code) [getopt-long]

L<Getopt::Long::Descriptive>



=item * Getopt::Long::Subcommand (perl_code) [getopt-long]

L<Getopt::Long::Subcommand>



=item * Getopt::Std (perl_code)

L<Getopt::Std>



=item * MooseX::Getopt (perl_code) [moox]

L<MooseX::Getopt>



=item * Getopt::ArgvFile (perl_code)

L<Getopt::ArgvFile>



=item * Getopt::Lucid (perl_code)

L<Getopt::Lucid>



=item * Getopt::Panjang (perl_code)

L<Getopt::Panjang>



=item * Getopt::Std::Strict (perl_code)

L<Getopt::Std::Strict>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m GetoptModules >>):

 +---------------------------+-----------+------------------------+------------+----------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors  | samples |
 +---------------------------+-----------+------------------------+------------+----------+---------+
 | MooseX::Getopt            |     160   |                  157.5 |        1   |   0.0003 |      20 |
 | Getopt::Long::Descriptive |      26   |                   23.5 |        6.2 | 5.3e-05  |      20 |
 | Getopt::Lucid             |      20   |                   17.5 |        8.3 | 3.6e-05  |      20 |
 | Getopt::ArgvFile          |      15   |                   12.5 |       11   | 9.4e-05  |      20 |
 | Getopt::Long              |      11   |                    8.5 |       14   | 4.4e-05  |      20 |
 | Getopt::Long::Subcommand  |       9.4 |                    6.9 |       17   | 3.4e-05  |      20 |
 | Getopt::Std::Strict       |       6.8 |                    4.3 |       24   | 5.3e-05  |      20 |
 | Getopt::Long::Complete    |       5   |                    2.5 |       33   |   4e-05  |      20 |
 | Getopt::Long::Less        |       4.6 |                    2.1 |       35   | 2.7e-05  |      20 |
 | Getopt::Panjang           |       4   |                    1.5 |       40   | 6.2e-05  |      20 |
 | Getopt::Long::EvenLess    |       4   |                    1.5 |       40   | 6.1e-05  |      20 |
 | Getopt::Std               |       3.8 |                    1.3 |       43   | 3.1e-05  |      20 |
 | perl -e1 (baseline)       |       2.5 |                    0   |       64   |   1e-05  |      20 |
 +---------------------------+-----------+------------------------+------------+----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-GetoptModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupGetoptModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-GetoptModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
