package ArrayData::Lingua::Word::ID::Katla;

use strict;
use Role::Tiny::With;
with 'ArrayDataRole::Source::LinesInDATA';
with 'ArrayDataRole::BinarySearch::LinesInHandle';                # add has_item() that uses binary search
with 'Role::TinyCommons::Collection::FindItem::Iterator';         # add find_item() (has_item already added above)
with 'Role::TinyCommons::Collection::PickItems::RandomSeekLines'; # add pick_items() that uses binary search

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2022-03-06'; # DATE
our $DIST = 'ArrayData-Lingua-Word-ID-Wordle'; # DIST
our $VERSION = '20220306.0.0'; # VERSION

# STATS

1;
# ABSTRACT: Wordle words (Indonesian)

=pod

=encoding UTF-8

=head1 NAME

ArrayData::Lingua::Word::ID::Katla - Wordle words (Indonesian)

=head1 VERSION

This document describes version 20220306.0.0 of ArrayData::Lingua::Word::ID::Katla (from Perl distribution ArrayData-Lingua-Word-ID-Wordle), released on 2022-03-06.

=head1 SYNOPSIS

 use ArrayData::Lingua::Word::ID::Katla;

 my $ary = ArrayData::Lingua::Word::ID::Katla->new;

 # Iterate the elements
 $ary->reset_iterator;
 while ($ary->has_next_item) {
     my $element = $ary->get_next_item;
     ... # do something with the element
 }

 # Another way to iterate
 $ary->each_item(sub { my ($item, $obj, $pos) = @_; ... }); # return false in anonsub to exit early

 # Get elements by position (array index)
 my $element = $ary->get_item_at_pos(0);  # get the first element
 my $element = $ary->get_item_at_pos(90); # get the 91th element, will die if there is no element at that position.

 # Get number of elements in the list
 my $count = $ary->get_item_count;

 # Get all elements from the list
 my @all_elements = $ary->get_all_items;

 # Find an item.
 my @found = $ary->find_item(item => 'foo');
 my $has_item = $ary->has_item('foo'); # bool

 # Pick one or several random elements.
 my $element = $ary->pick_item;
 my @elements = $ary->pick_items(n=>3);

=head1 DESCRIPTION

This is the list of words used in Katla[1] (an Indonesian variant of the
Wordle[2] game), retrieved from its source code. It can be used as a source of
words for other writing games, or for doing some analysis.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/ArrayData-Lingua-Word-ID-Wordle>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-ArrayData-Lingua-Word-ID-Wordle>.

=head1 SEE ALSO

[1] L<https://katla.vercel.app>

[2] L<https://www.nytimes.com/games/wordle/index.html>

This word list in L<WordList> form: L<WordList::ID::Katla>.

Other C<ArrayData::Lingua::Word::ID::*> like
L<ArrayData::Lingua::Word::ID::KBBI>.

Other C<ArrayData::Lingua::Word::*::Wordle> like
L<ArrayData::Lingua::Word::EN::Wordle>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=ArrayData-Lingua-Word-ID-Wordle>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
abadi
abaka
abang
abate
abawi
abaya
abbas
abdas
abdis
abdul
abece
abian
abing
abjad
abjat
ablur
abnon
abnus
abone
aboya
abpar
abrab
abrak
abrap
abrar
abras
abrek
abrin
abrip
abrop
absah
absen
abses
absis
abtar
abuan
abung
abuya
abuza
abyad
acala
acang
acara
acawi
acian
acoan
acuan
acuci
acung
adaci
adaks
adamu
adang
adati
adelo
adena
adesi
adhan
adidi
adika
ading
adion
adios
adisi
aditi
adlib
admin
adnan
adobe
adong
adora
adpel
adpis
adres
aduan
adung
adven
advis
adzab
adzan
aerob
afair
afdal
afdol
afian
afiat
afiks
afkir
afoka
afore
afrit
afsun
aftab
afuah
afwah
agadi
agama
agami
agape
agens
agium
aglaf
aglet
agogo
agoni
agrad
agung
ahang
ahare
ahing
ahkam
ahlak
ahmak
ahmar
ahmer
ahori
ahsan
ahwal
aipda
airud
ajaib
ajang
ajian
ajing
ajnas
ajoli
ajuan
ajuna
ajung
akaid
akang
akasa
akbar
akene
akhir
akhli
aking
akmal
akmil
akpen
akper
akpol
akpri
akrab
aksen
aksep
akses
aksis
akson
aktif
aktin
aktip
aktor
akuan
akuwu
akwai
akwal
alaan
alami
alane
alang
alarm
alata
alban
albas
alber
albit
album
aldol
alena
algam
algin
algol
alhub
aliah
alias
alibi
alien
aling
alino
alins
alkah
alkap
alkil
alkom
alkus
allah
almon
aloco
aloha
aloin
alosa
alosu
alpin
alpis
altar
alula
alune
alung
alusi
alwah
amang
ambah
ambai
ambak
ambal
ambar
ambat
ambau
ambeg
ambek
amben
amber
ambet
ambil
ambin
amboi
ambon
ambua
ambuh
ambul
ambur
amdal
ameba
amida
amido
amien
amina
amino
amorf
amosi
ampah
ampai
ampak
ampar
ampas
ampat
ampau
ampek
ampel
ampen
ampet
ampik
ampil
ampis
ampit
ampog
ampok
ampon
ampos
ampuh
ampuk
ampul
ampun
amput
amril
amsal
amuba
amung
anang
anani
anbia
ancai
ancak
ancam
ancoa
ancol
ancuk
ancul
andai
andak
andal
andam
andan
andap
andar
andek
ander
andik
andil
andir
andoi
andok
anduh
anduk
andun
andur
aneka
anfal
anfas
angah
angan
angau
angel
angga
anggo
anggu
angin
angit
angka
angke
angku
anglo
angon
angop
angot
angsa
angsu
angur
angus
angut
anian
anime
animo
anion
anjak
anjal
anjar
anjat
anjik
anjir
anjun
anjur
ankum
anode
anomi
ansar
ansor
antah
antan
antap
antar
antek
antem
antep
antih
antik
antip
antoi
antol
anton
antop
antre
antri
antui
antuk
antul
antun
anual
anuma
anyak
anyam
anyar
anyel
anyik
anyir
aorta
apaan
apati
apean
aperd
apion
apiun
apkir
aplus
apnea
apoge
april
aprit
apron
apung
arame
arang
araro
arasy
arbab
arbei
arcas
areal
arena
areng
areta
argol
argon
argot
ariah
ariel
aries
aring
arkus
armed
armel
armos
arnal
aroma
arpus
arsap
arsen
arsik
arsip
arsir
arsis
artik
artis
aruan
aruda
arung
arwah
arzak
asali
asana
asasi
asbak
asbes
asbun
asbut
ascun
asese
asesi
asfal
asfar
ashar
asian
asing
asiri
askar
askes
asket
askon
askot
asmat
asnad
asong
aspal
aspek
aspel
aspri
asrar
asrot
astek
aster
asuan
asung
asura
aswad
asyar
asyik
atase
ateis
atlas
atlet
atlit
atman
atmil
atoni
atori
atowa
atung
audio
audit
auksi
aulia
auman
aural
auran
aurat
aurum
autad
autis
avgas
avtur
awang
ayeng
ayfat
aytek
azali
azeri
azmat
azuki
baang
babad
babah
babak
babal
baban
babar
babas
babat
babel
babil
babit
babon
babun
babur
babut
bacah
bacak
bacan
bacar
bacek
bacem
bacik
bacin
bacok
bacot
bacul
bacut
badai
badak
badal
badam
badan
badar
badau
bader
badik
badui
baduk
badur
badut
bafta
bagai
bagak
bagal
bagan
bagar
bagas
bagat
bagau
bagea
bager
bagor
baguk
bagul
bagur
bagus
bahak
baham
bahan
bahar
bahas
bahau
bahri
bahwa
baiat
bajaj
bajak
bajan
bajao
bajar
bajau
bajik
bajir
bajul
bakah
bakak
bakal
bakam
bakap
bakar
bakat
bakau
bakda
bakdu
bakes
bakhu
bakik
bakir
bakmi
bakon
baksi
bakso
bakti
bakul
bakum
bakup
bakut
balad
balah
balai
balak
balam
balan
balap
balar
balas
balau
baleg
balen
balet
balig
balik
balio
balit
baliu
balok
balon
balot
baluh
balui
baluk
balun
balur
balut
bambu
bamus
banal
banar
banat
banci
banda
bando
bandu
banga
banir
baniu
banji
banjo
banta
banto
bantu
banua
banyo
banyu
banzi
bapak
bapao
baper
bapet
barah
barai
barak
baran
barap
baras
barat
barau
bardi
barel
baren
barep
baret
barga
barid
barik
baris
barit
barli
barok
baron
baros
barso
barua
baruh
barut
basah
basal
basap
basar
basat
basau
basic
basil
basin
basir
basis
basmi
basuh
basut
batai
batak
batal
batan
batas
batat
batau
batel
batih
batik
batil
batin
batis
batok
baton
batua
batuk
batun
batur
baung
bauzi
bawab
bawah
bawak
bawal
bawas
bawat
bawel
bawon
bawor
bayah
bayak
bayam
bayan
bayar
bayas
bayat
bayem
bayuh
bayun
bayur
bazar
bazis
bebal
beban
bebar
bebas
bebat
bebek
bebel
beber
bebop
becak
becek
becik
becuk
becus
bedah
bedak
bedal
bedan
bedar
bedel
bedih
bedil
bedol
bedor
beduk
begah
begal
begap
begar
begog
beguk
behel
bejat
bekah
bekal
bekam
bekap
bekas
bekat
bekel
beken
beker
bekil
bekuk
belah
belai
belak
belam
belan
belar
belas
belat
belau
beldu
belek
belel
belia
belik
belis
belit
beloh
belok
belom
belon
belot
belta
beluk
belum
belur
belus
belut
benah
benak
benam
benar
benci
benda
bende
bendi
bendo
bendu
benep
bengu
benih
benin
bense
benta
benua
benum
benur
berai
berak
beram
beras
berat
berau
bereo
beres
beret
beria
berik
beril
berko
berma
bermi
berok
beron
berui
beruk
berus
besan
besar
besek
beser
beset
besit
besoa
besok
besot
besuk
besut
betah
betam
betas
betau
betek
betet
betik
betis
betok
beton
betot
betul
bewok
bezit
biadi
biang
biara
biasa
biaya
bibel
bibir
bibit
bibok
bidah
bidai
bidak
bidal
bidan
bidar
bidas
bidet
bidik
biduk
bidur
bigas
bigat
bigos
bigot
bihun
bijak
bijan
bijih
bikin
bikir
biksi
biksu
bilah
bilai
bilak
bilal
bilas
bilau
bilga
bilik
bilis
bilur
bimas
binal
binar
bincu
bindi
bindu
binen
biner
bines
bingi
binti
biola
bioma
biota
bipim
bipod
birah
birai
biram
biras
birat
birih
birit
bisai
bisan
bisik
bison
bissu
bisul
bitot
biuku
bivak
biyak
bkkbn
bkkks
bksda
blang
blauk
bleng
blitz
blong
bloon
blues
boano
bobak
bobat
bobin
bobok
bobol
bobos
bobot
bocah
bocok
bocor
bodar
bodoh
bodok
bodor
bofot
bogam
bogel
bogem
bogok
bogol
bogor
bogot
bohok
bokap
bokar
bokca
bokeh
bokek
bokeo
bokep
bokoh
bokop
bokor
bokot
boksu
bolak
boleh
bolos
bolot
bolta
bomoh
bomor
bonai
bonar
bonga
bongo
bonto
bonus
bopem
bopok
borak
borat
borci
bordu
boreh
borek
borok
boron
boros
borto
bosan
boson
bosor
bosot
bosun
botak
botia
botoh
botok
botol
botor
boxer
boyak
boyas
bozah
bphtb
bpkln
brajg
brana
brata
bruto
buana
buang
buani
buari
buaya
bubar
bubuh
bubuk
bubul
bubun
bubur
bubus
bubut
budak
budek
buduk
budur
bueng
bufer
bufet
bugar
bugat
buggy
bugil
bugis
buhuk
buhul
buhur
bujal
bujam
bujan
bujet
bujuk
bujul
bujur
bujut
bukan
bukat
bukau
buket
bukit
bukti
bukur
bukut
bulai
bulak
bulan
bular
bulat
bulek
bulga
bulik
bulir
bulog
bulug
buluh
buluk
bulur
bulus
bumbu
bumel
bunak
bunda
bunga
buntu
bunuh
bunut
bunyi
bupet
burai
burak
buram
buras
burat
burda
buret
burgo
burik
burit
burka
burma
burok
buron
bursa
buruh
buruj
buruk
burum
burun
burut
busai
busar
buser
buset
busik
busuk
busur
busut
butek
butik
butir
buton
butuh
butul
butun
butut
buwei
buwuh
buyar
buyur
buyut
cabai
cabak
cabar
cabau
cabik
cabir
cabor
cabuh
cabuk
cabul
cabur
cabut
cacah
cacak
cacap
cacar
cacat
cacau
cacil
cadai
cadar
cadas
cadel
cadik
cadir
cadok
caduk
cagak
cagar
cager
cagil
caguh
cagun
cagut
cahar
caima
caing
cakah
cakak
cakap
cakar
cakep
cakil
cakra
cakup
cakur
cakus
calak
calar
caleg
calir
calit
calok
calon
calui
caluk
calus
camar
camat
camau
camca
camil
campa
camuk
camur
canai
canak
canda
candi
candu
caong
capah
capai
capak
capal
capan
capar
capeg
capek
caper
capik
capil
capit
capuk
carah
carak
caram
caran
carat
caren
caret
carik
carok
caruk
carut
casan
casis
catan
catat
catek
catel
catet
catik
catok
catuk
catur
catut
caung
cawai
cawak
cawan
cawat
cawis
cebak
ceban
cebik
cebil
cebir
cebis
cebok
cebol
cebur
cecah
cecak
cecap
cecar
ceceh
cecer
cecok
cedal
cedok
ceduk
ceeng
cegah
cegak
cegar
cegas
cegat
ceguk
cekah
cekak
cekal
cekam
cekap
cekar
cekat
cekau
cekek
cekel
ceker
cekih
cekik
cekit
cekok
cekuh
cekuk
cekup
cekur
cekut
celah
celak
celar
celas
celat
celek
celep
celih
celik
celis
celok
celos
celuk
celum
celup
celur
celus
cemar
cemas
cemat
cemce
cemeh
cemek
cemen
cemer
cempa
cempe
cemuk
cenah
cenak
cengi
cengo
cenil
cento
cepak
cepal
cepat
cepek
ceper
cepit
cepol
cepuk
cerah
cerai
cerak
ceram
cerap
cerat
cerau
cerca
cerek
ceret
ceria
cerih
cerna
cerpu
ceruh
ceruk
cerun
cerup
cerut
cetai
cetak
cetek
ceter
cetok
cetus
ceuki
cewek
china
cibir
cibit
cibuk
cicah
cicak
cicih
cicik
cicil
cicip
cicir
cicit
ciduk
cigak
cihui
cikal
cikar
cikok
cikun
cikut
cilap
cilik
cilok
cimin
cimol
cincu
cinda
cinde
cinta
cipai
cipan
cipeh
cipoa
cipok
cipta
ciput
circa
cirit
citah
citai
citak
citra
clear
cling
coang
coban
cobek
cocok
cocol
cocor
codak
codet
codot
cogah
cogan
cogok
cokar
cokek
coker
coket
cokok
cokol
colak
colek
colet
colok
colon
colot
comek
comel
comor
comot
comro
conet
congo
copar
copet
copol
copot
corak
coran
corek
coret
corob
corot
cotet
cotok
count
cowok
crash
cuaca
cuang
cuban
cubit
cucan
cucuh
cucuk
cucun
cucup
cucur
cucut
cudak
cudat
cudit
cuduh
cugat
cukai
cukam
cukil
cukin
cukir
cukit
cukup
cukur
culak
culan
culas
culik
culim
culun
cuman
cumbu
cumil
cunam
cunda
cungo
cunia
cupai
cupak
cupar
cupet
cupit
cupul
curah
curai
curam
curas
curat
curie
curik
curna
curut
cutak
cutel
dabak
dabal
dabat
dabih
dabik
dabir
dabit
dabol
dabus
dacin
dadah
dadak
dadal
dadap
dadar
dadek
dadia
dadih
daduh
daduk
daeng
dagel
dahak
daham
dahan
dahar
daing
dairi
dajal
dakah
dakar
dakik
dakon
daksa
dakwa
dalal
dalam
dalem
dalih
dalil
damah
damai
damak
damal
daman
damar
damas
damat
damba
damen
damik
damir
dampo
danau
danda
dandi
dange
danki
dansa
danta
danuh
danur
danus
dapar
dapat
dapil
dapra
dapuk
dapur
darab
darah
darai
daras
darat
darih
darji
darma
darun
darus
dasar
dasin
dassi
dasun
datar
datau
datif
datin
datuk
datum
dawai
dawan
dawat
daweh
dawet
dawuh
dayah
dayak
dayas
dayuh
dayuk
dayus
debah
debak
debam
debap
debar
debas
debat
debet
debik
debil
debit
debuk
debum
debun
debup
debur
debus
debut
decah
decak
decap
deceh
decit
decup
decur
decus
decut
dedah
dedai
dedak
dedal
dedap
dedar
dedas
dedau
dedek
dedel
deder
dedes
degam
degan
degap
degar
degen
degil
degos
deguk
degum
degup
deham
dehem
dekah
dekam
dekan
dekap
dekar
dekat
dekik
dekil
dekor
dekus
dekut
delah
delan
delap
delas
delat
deler
delik
delit
delta
delut
demah
demak
demam
demap
demek
demen
demes
demik
demit
demon
demta
denah
denai
denak
denar
denda
dendi
denen
dengu
denim
denma
denok
depak
depan
depap
depok
depot
depun
depus
derai
derak
deram
deran
derap
deras
derau
derbi
derek
derel
derep
deres
deret
deria
derik
deris
derit
derji
derma
deruk
derum
derun
derup
derus
derut
desah
desak
desar
desau
desih
desik
desil
desir
desis
desit
desuk
desup
desur
desus
desut
detak
detap
detar
detas
detia
detik
detil
detup
detus
deuce
dewan
diang
diare
diari
didih
didik
didis
digen
digit
digul
dikau
dikir
dikit
diksa
diksi
dikte
dikti
dilah
dilak
dilam
dildo
diler
dimba
dimer
dinar
dinas
dinda
dingo
dioda
diode
dione
dipan
diplo
dipol
dirah
direk
diris
dirum
dirus
dirut
disel
diska
disko
disup
diuji
dlika
doang
dobel
doble
dobol
dobra
dodet
dodoi
dodok
dodol
dodor
dodos
dodot
dogel
doger
dogma
dogol
dogon
dohoi
dohok
dohyo
dokar
doket
dokoh
dolan
dolar
dolat
dolim
dolog
dolok
domba
domei
domen
domot
dompu
donat
dondo
donor
donto
dopak
dopis
dorbi
dorna
dosen
dosin
dosir
dosis
doula
dowel
dower
doyak
doyan
drama
druma
druwe
duafa
duaja
duane
dubes
duble
dubuk
dubur
duduh
duduk
dudur
dudus
dugal
dugas
dugem
duhai
duhur
dukan
dukat
dukuh
dukun
dulag
dulur
dumai
dumbo
dumut
dunah
dunak
dungu
dunia
dupak
dupet
duplo
durap
durat
duren
durja
durma
durna
durno
dusin
dusta
dusun
duvet
duwet
duyun
eboni
eceng
edema
edisi
efusi
egois
ejaan
ekagi
ekang
ekrak
ekrin
eksak
eksem
ekses
eksil
eksim
eksin
eksis
eksit
ekspo
elang
elegi
elemi
eleng
eling
elips
elite
eltor
eluat
eluen
elung
elusi
email
emang
embah
embak
embal
emban
embar
embat
embek
embel
ember
embih
embik
embok
embol
embuh
embun
embus
embut
emeri
emisi
emoji
emong
emosi
empal
empap
empar
empas
empat
empek
emper
empet
empik
empoh
empok
empos
empot
empuk
empul
emrat
emumu
encal
enceh
encek
encel
encer
encik
encim
encit
encok
encot
endal
endam
endap
endon
enduk
endul
endus
endut
enema
eneng
engah
engas
engku
enjak
enjal
enjin
enjut
entah
entak
ental
entar
entas
enten
entit
entok
entos
entot
entre
entri
envoi
enyah
enyak
enzim
eofil
eolit
eosen
eosin
erang
erata
erbis
ercis
ereng
ergot
ering
erkan
erong
eropa
erosi
erpah
erpak
esais
esens
eskas
eskro
essay
ester
etana
etape
etida
etika
etnik
etnis
etude
evdem
evdik
evgeo
evlap
eweai
eyang
faali
fabel
fadem
fadil
fagot
faham
fajar
fakih
fakir
faksi
fakta
falah
falaj
falak
famai
faqir
farad
faraj
farak
fardu
farik
farji
fasad
faset
fasia
fasid
fasih
fasik
fasis
fasos
fasum
fatah
fatal
fatir
fatom
fatri
fatur
fatwa
fault
fauna
felon
fenit
fenol
feral
feron
ferum
feses
fetis
fetor
fetus
fiber
fiche
fidah
fider
figur
fikih
fikir
fikli
fiksi
fikus
filem
filet
filum
final
finir
finis
firma
fisik
fisin
fisip
fisis
fitol
fiton
fitri
fitur
fjord
flaks
floem
floit
flora
fluks
fluor
fmipa
fobia
fobos
fokus
folat
folio
fondu
fonem
fonik
fonis
fonon
fonta
forki
forma
forte
forum
fosil
foton
fotur
fovea
foyer
fpips
frasa
frase
freon
front
fujur
fulan
fulus
fungi
furuk
fusia
fusta
fusuk
futoi
futur
fyord
gabah
gabai
gabak
gabal
gabas
gabir
gabor
gabro
gabsi
gabuk
gabus
gabut
gacok
gacor
gadah
gadai
gadeh
gadis
gadon
gadri
gaduh
gaduk
gadun
gafar
gafer
gafur
gagah
gagai
gagak
gagal
gagan
gagap
gagar
gagas
gagau
gaguk
gaham
gahar
gaing
gajah
gajak
gajas
gajih
gajul
gajus
gakin
galah
galai
galak
galan
galar
galas
galat
galau
galib
galih
galir
galon
galos
galuh
galur
gamak
gamal
gamam
gaman
gamat
gambu
gamel
gamet
gamik
gamis
gamit
gamma
gamon
gamuh
ganal
ganar
ganas
ganco
gancu
ganda
gandi
gandu
ganih
ganja
ganti
gapah
gapai
gapan
gapil
gapit
gaple
gapuk
garah
garai
garam
garan
garap
garar
garau
garba
garda
gardu
garib
garis
garit
garpu
garuk
garut
garwa
gasab
gasak
gasal
gasir
gatal
gatap
gatet
gatot
gatra
gatuk
gatul
gaung
gaura
gawai
gawal
gawan
gawar
gawat
gawir
gawul
gayal
gayam
gayat
gayau
gayor
gayuh
gayuk
gayun
gayut
gazal
gbray
gebah
gebal
gebar
gebel
geber
gebok
gebos
gebot
gebuk
gecak
gecar
gecek
gecer
gecik
gecul
gedam
gedek
gedik
gedor
gegai
gegap
gegar
gegas
gegat
gegau
gegem
gegep
geger
gegua
gejah
gejos
gelak
gelam
gelap
gelar
gelas
gelek
geler
gelet
gelik
gelis
geluh
geluk
gelup
gelut
gemah
gemak
gemal
geman
gemap
gemar
gemas
gemik
gemin
gemit
gempa
gemuk
gemul
genah
genap
genih
genis
genit
genom
genre
genta
genuk
genus
geoda
gepit
gepok
gepuk
gerah
gerai
gerak
geram
gerat
gerau
gerda
gereh
gerek
geret
gerha
geria
gerih
gerik
gerim
gerip
gerit
germo
geros
geruh
gerun
gerup
gerus
gerut
gesau
gesek
gesel
geser
gesit
getah
getap
getar
getas
getek
getih
getik
getil
getir
getis
getok
getol
getuk
getun
gewor
ghaib
ghoib
gibah
gibas
gidik
gigan
gigih
gigil
gigir
gigis
gigit
gilap
gilas
gilda
gilik
gilir
gimik
gincu
ginje
gipsi
girah
giral
giras
girik
giris
girus
gisar
gisik
gisil
gitar
gites
gitik
gitok
giung
gladi
glans
globe
glori
glosa
gnota
gobah
gobak
goban
gobar
gobek
gober
gobet
gocap
gocek
gocoh
godak
godam
godek
godet
godok
godot
gogoh
gogok
gogos
gohok
gojek
gokar
gokil
golak
golbi
golek
goler
golok
golpi
gomer
gonad
gonio
gonje
gopek
gopoh
gorap
gorek
gores
gorga
gorit
goroh
gorok
gorup
gosan
gosip
gosok
gotes
gotik
gotri
gotun
gowai
gowes
gowok
goyah
goyak
graha
grasi
gravi
greha
griya
grogi
grubi
guano
gubah
gubal
gubar
gubel
gubit
gubuk
gucen
gudam
gudeg
gudep
gudik
gufra
gugah
gugat
guguh
guguk
gugup
gugur
gugus
gulah
gulai
gulam
gulat
gulir
gulma
gulud
guluk
gulut
gumal
gumam
gumba
gumil
gumoh
gumuk
gumul
gumun
gunci
gundi
gundu
gurab
gurah
guram
gurat
gurau
gurdi
gurem
gurih
gurik
gurit
guroa
gurub
guruh
guruk
gurun
gurur
gusah
gusar
gusel
gusti
gusul
gusur
gutik
gutis
gutuk
guyon
guyot
guyub
guyur
habib
habil
habis
habuk
hadal
hadam
hadap
hadas
hadat
hadir
hadis
hadro
hadyu
hafal
hafen
hafiz
haiku
hajah
hajar
hajat
hajib
hajim
hajis
hakam
hakim
halal
halau
halba
halia
halim
halit
halma
halok
halte
halus
halwa
hamal
hamam
hamba
hamdu
hamik
hamil
hampa
hamud
hamun
hanca
hanif
hanra
hantu
hanya
hapal
hapus
harak
haram
harap
harbi
harem
harga
haris
harit
haroa
harpa
harta
harum
harun
harus
hasab
hasad
hasai
hasan
hasar
hasib
hasid
hasil
hasta
hasud
hasut
hatif
hatta
hauri
hawar
hawik
hayat
hazad
heban
hebat
hebel
heboh
hegah
heiho
helah
helai
helat
hemat
hendi
henry
henti
hepar
heran
herba
hertz
hewan
hibah
hibat
hibob
hibuk
hibur
hidro
hidup
hiena
hijab
hijau
hijir
hikam
hilal
hilap
hilau
hilir
hilum
himar
himen
himne
hinap
hindi
hindu
hipmi
hipui
hirap
hirau
hirta
hiruk
hirup
hisab
hisap
hiski
hitam
hoaks
hodah
hokah
homer
honae
honje
honji
honor
horak
horas
horja
horor
hosti
hotel
hubad
hubar
hubla
hudai
hudud
hufaz
hujah
hujaj
hujan
hujat
hujin
hukah
hukum
hulam
huler
hulul
hulur
human
humas
humik
humin
humor
humus
hunus
hurah
huria
huruf
husuk
hutan
hymne
iaido
ialah
ibing
iblis
ibrah
ibrit
ibung
ictus
ideal
idiil
idiom
idiot
idola
idrak
idris
idzin
ifrit
iftar
igora
ihdad
ihlas
ihram
ihsan
ihsas
ihwal
ijbar
ijmak
ijmal
ikapi
ikasi
iklan
iklas
iklim
ikrab
ikram
ikrar
ilafi
ilahi
ilang
ileum
ilham
ilian
iling
ilusi
ilyas
imago
imaji
imang
imani
imbak
imbal
imbas
imbau
imbit
imbuh
imkan
imlek
impak
impas
impek
impit
impor
impun
imsak
inang
inapu
incar
incer
incit
incut
indah
indai
indak
indap
inden
india
indie
indik
indra
induk
infak
infus
ingar
ingat
ingau
inggu
ingin
ingot
ingus
injak
injap
injil
inkus
input
insaf
insan
insar
insek
inses
inset
intai
intan
intel
intil
intim
intip
intro
inyik
inzar
inzet
iodin
ionik
ipeda
iprit
iptek
ipung
irama
ireda
ireks
irian
iring
irjen
ironi
irung
isama
isbat
iseng
ishak
isian
islah
islam
islan
isnad
israf
israk
istal
istan
istaz
istri
itjen
itlak
ittik
iuran
ivori
iwapi
jabal
jaban
jabar
jabat
jabel
jabil
jabir
jabon
jabot
jadah
jadam
jaduk
jagal
jagat
jagra
jagur
jahan
jahar
jahas
jahat
jahil
jahit
jahul
jajah
jajak
jajal
jajan
jajar
jakal
jakas
jaket
jaksa
jaksi
jakun
jakut
jalad
jalak
jalal
jalan
jalar
jalen
jalil
jalin
jalon
jalur
jamah
jamak
jamal
jaman
jambe
jambi
jambu
jamda
jamik
jamil
jamin
jamis
jamor
jampi
jamur
janah
janat
janda
jando
jandu
janik
janin
janji
janom
janur
japah
japan
japin
japri
japuk
jarab
jarah
jarak
jaram
jaran
jaras
jarem
jarik
jarit
jarum
jarwa
jasad
jasus
jatah
jatim
jatuh
jauza
jawab
jawat
jawer
jawil
jayau
jazab
jazam
jebab
jebah
jebai
jebak
jebat
jebik
jebol
jebor
jebot
jebuh
jebuk
jebur
jedot
jegal
jegil
jegir
jegog
jejak
jejal
jejap
jejas
jejer
jeket
jeksi
jelah
jelai
jelak
jelar
jelas
jelau
jelek
jelih
jelir
jelit
jelma
jeluk
jelum
jelus
jelut
jemah
jemba
jemur
jenah
jenak
jenat
jenis
jenuh
jepet
jepit
jepun
jeput
jerah
jeram
jeran
jerap
jerat
jerau
jerba
jerih
jerit
jerok
jersi
jeruk
jerum
jerun
jetis
jewer
jibti
jibun
jicap
jidal
jidar
jidat
jidor
jidur
jigur
jihad
jihat
jijik
jijit
jilah
jilam
jilat
jilid
jimak
jimat
jimbe
jimut
jinak
jingo
jingu
jipro
jipsi
jirak
jiran
jirat
jirus
jisim
jitak
jitok
jiwat
jiwit
joang
jobak
jodoh
jogan
jogar
joged
joget
joglo
jogor
johan
johar
jojol
joker
jolak
jolek
jolok
jolor
jomlo
jompo
joran
jorok
josna
jotos
joule
jreng
juang
juara
jubah
jubel
jubin
jubir
judek
judes
judul
juhut
juita
jujah
jujai
jujat
jujoh
jujuh
jujul
jujur
jujut
jukut
julab
julai
julat
julid
julir
juluk
julur
jumat
jumbo
jumit
jumpa
jumud
junam
junel
junta
junub
junun
jupen
jurah
jurai
juran
jurat
jurik
juris
jurit
juruh
jurus
kabab
kabag
kabak
kabar
kabat
kabau
kabel
kabid
kabil
kabin
kabir
kabit
kaboi
kabul
kabur
kabus
kabut
kacak
kacam
kacar
kacau
kacek
kacer
kacih
kacik
kacip
kacir
kacuk
kadah
kadai
kadal
kadam
kadar
kadas
kader
kades
kadet
kadha
kadih
kadil
kadim
kadin
kadir
kadit
kadiv
kadok
kadru
kadut
kaeti
kafah
kafan
kafil
kafir
kafoa
kagak
kaget
kagok
kagum
kahaf
kahak
kahan
kahar
kahat
kahin
kahwa
kaido
kaili
kaimo
kaing
kajai
kakah
kakak
kakao
kakap
kakar
kakas
kakek
kakok
kaksa
kakus
kalah
kalai
kalak
kalam
kalan
kalap
kalar
kalas
kalat
kalau
kalbi
kalbu
kaldu
kalem
kalih
kalio
kalis
kalke
kalor
kalui
kaluk
kalus
kalut
kamal
kamar
kamas
kamat
kamau
kamba
kambi
kambu
kameo
kamil
kamir
kamis
kamka
kampa
kamra
kamus
kanaf
kanah
kanal
kanan
kanat
kanda
kandi
kania
kanja
kanji
kanon
kanta
kanti
kanto
kantu
kanum
kanun
kanya
kaomu
kapah
kapai
kapak
kapal
kapan
kapar
kapas
kapat
kapel
kaper
kapet
kapir
kapis
kapit
kapok
kapol
kapon
kappa
kapri
kapuk
kapur
kapus
karaf
karah
karak
karam
karap
karar
karas
karat
karau
karbo
karel
karet
kargo
karia
karib
karih
karil
karim
karir
karma
karon
karsa
karst
karti
kartu
karun
karut
karya
kasab
kasad
kasah
kasai
kasam
kasap
kasar
kasau
kasdu
kasep
kaset
kasia
kasid
kasih
kasim
kasip
kasir
kaspe
kasta
kasti
kasui
kasum
kasur
kasus
kasut
kaswi
katah
katai
katak
katam
katan
katar
katek
katel
kater
kates
katib
katik
katil
katir
katok
katuk
katun
katup
katut
kaula
kauli
kaung
kausa
kaver
kawah
kawak
kawal
kawan
kawat
kawih
kawin
kawuk
kawul
kayai
kayak
kayal
kayan
kayas
kayat
kayau
kayuh
kayun
kazak
kbray
kebab
kebah
kebai
kebal
kebam
kebas
kebat
kebel
keben
kebil
kebin
kebit
kebuk
kebul
kebun
kebur
kebut
kecah
kecai
kecak
kecam
kecap
kecar
kecek
kecer
kecik
kecil
kecit
kecoa
kecoh
kecup
kecut
kedah
kedai
kedal
kedam
kedap
kedar
kedau
kedek
keder
kedik
kedip
kedok
kedot
kedua
keduk
kedul
kedut
kefir
kehel
kejai
kejam
kejan
kejap
kejar
kejat
kejen
kejer
kejip
kejur
kejut
kekah
kekal
kekam
kekar
kekas
kekat
kekau
kekeh
kekek
kekel
kekep
keker
kekok
kekol
kelab
kelah
kelai
kelak
kelam
kelap
kelar
kelas
kelat
kelek
kelem
kelep
keler
kelet
kelih
kelik
kelim
kelip
kelir
kelis
kelit
kelok
kelom
kelon
kelop
kelor
kelos
kelot
kelua
keluh
kelui
keluk
kelun
kelus
kelut
kemah
kemal
kemam
kemas
kemat
kembu
kemih
kemik
kemil
kemis
kemit
kemon
kempa
kempu
kemul
kemut
kenaf
kenal
kenan
kenap
kenas
kendi
kendo
kenek
kenem
kenes
kenop
kenor
kento
kenur
kenya
kenyi
keong
kepah
kepai
kepak
kepal
kepam
kepar
kepau
kepek
kepel
keper
kepet
kepik
kepil
kepis
kepit
kepoh
kepok
kepol
kepot
kepuh
kepuk
kepul
kerah
kerai
kerak
keram
keran
kerap
keras
kerat
kerau
kerek
keren
keret
kerih
kerik
kerip
keris
kerit
kerja
kermi
kernu
keroh
kerok
kerom
keron
kerop
kerot
keruh
keruk
kerul
kerun
kerup
kerut
kesah
kesak
kesal
kesam
kesan
kesat
kesek
kesel
keset
kesik
kesip
kesot
kesra
kesup
kesut
ketah
ketai
ketak
ketal
ketam
ketan
ketap
ketar
ketat
ketek
ketel
ketes
ketik
ketil
ketip
ketis
ketok
keton
ketua
ketuk
ketul
ketun
ketup
ketur
ketus
ketut
kewer
kewes
kewuh
khafi
khair
khaki
khali
khasi
khauf
khaul
khiar
khoja
khudu
kiang
kiani
kiara
kiasi
kiban
kibar
kibas
kibik
kibir
kibor
kibul
kicak
kicau
kicep
kicik
kicuh
kicut
kidab
kidal
kidam
kidar
kidul
kijag
kijai
kijil
kijip
kikas
kikav
kikih
kikik
kikil
kikim
kikir
kikis
kikuk
kikus
kilah
kilai
kilan
kilap
kilar
kilas
kilat
kilau
kilik
kilin
kilir
kilit
kilus
kimah
kimar
kimia
kimki
kimlo
kimpa
kimri
kimus
kinan
kinca
kinja
kinte
kioko
kiong
kipah
kipai
kipal
kipam
kipan
kipar
kipas
kiper
kirab
kirai
kiran
kirap
kiras
kirau
kirik
kirim
kirip
kiris
kiruh
kisah
kisai
kisam
kisar
kisas
kisat
kisik
kista
kisut
kitab
kitar
kitik
kitin
kitir
kitri
kiuri
kizib
klaim
kledi
klien
klise
klona
kluet
kluwo
koaks
koala
koana
koang
kobah
kobak
kobar
kober
koboi
kobok
koboy
kobra
kocak
kocek
kocoh
kocok
kocor
kodak
kodal
kodam
kodau
kodek
kodim
kodok
kodya
kogab
kohir
kohol
kohor
kojah
kojoh
kojol
kojor
kokah
kokam
kokas
kokoh
kokok
kokol
kokon
kokop
kokot
koksa
kokus
kolah
kolak
kolam
kolbu
kolek
kolet
kolik
kolin
kolok
kolom
kolon
kolor
kolot
kolum
koman
kombo
kombu
komen
komet
komik
komis
kompa
kompi
konan
konco
konda
konde
konga
konis
konjo
konon
konro
konte
konus
koops
kopah
kopak
kopal
kopda
kopek
kopel
koper
kopet
kopka
koplo
kopok
kopor
kopra
koptu
kopur
koral
koran
korea
kored
korek
korem
kores
koret
korma
koroh
korok
korps
korsi
korum
korup
korut
korve
kosar
kosek
kosel
kosen
koset
kotah
kotai
kotak
kotek
kotes
kotok
kotor
kover
kowad
kowak
kowal
kowan
kowau
kowek
koyah
koyak
koyam
koyan
koyok
krama
krans
krebo
kredo
kreol
kriau
kribo
krida
kring
kriya
kroco
kroma
kromo
kroni
kroto
kuaci
kuala
kuali
kuang
kuari
kuark
kuart
kuasa
kuasi
kuaya
kubah
kubak
kubik
kubil
kubin
kubis
kubit
kubra
kubti
kubul
kubur
kubus
kucai
kucak
kucam
kucek
kucel
kucil
kucir
kucit
kucup
kucur
kucut
kudai
kudap
kudet
kudil
kudis
kuduk
kudup
kudus
kueni
kueri
kufur
kuhap
kuhpt
kuilu
kuing
kuini
kujur
kujut
kukai
kukis
kukuh
kukuk
kukul
kukup
kukur
kukus
kukut
kulah
kulai
kulak
kulan
kulat
kuldi
kulim
kulin
kulio
kulir
kulit
kulon
kulot
kulpa
kulub
kuluk
kulum
kulup
kulur
kulut
kumai
kumal
kuman
kumat
kumba
kumbu
kumdo
kumel
kumis
kumpi
kumuh
kumur
kumus
kumut
kunca
kunci
kundi
kunir
kunta
kunut
kuota
kupak
kupas
kupat
kupel
kupil
kupir
kupon
kupui
kupur
kurai
kuran
kurap
kuras
kurau
kurdi
kuren
kuret
kuria
kurik
kurir
kurma
kurok
kursi
kurun
kurus
kurva
kusal
kusam
kusau
kusen
kusik
kusir
kusta
kusti
kusuf
kusuk
kusut
kutai
kutak
kutal
kutan
kutat
kutik
kutil
kutin
kutip
kutub
kutuk
kutut
kuvet
kuwuk
kuwur
kuyam
kuyup
kwaca
kwaci
kweni
labak
labas
labeh
label
labia
labil
labuh
labun
labur
labut
lacak
lacur
lacut
ladah
ladak
ladam
ladan
ladar
ladas
laden
lafal
lafaz
lagak
lagam
lagan
lagau
lahab
lahad
lahak
lahan
lahap
lahar
lahat
laher
lahip
lahir
laici
lajak
lajat
lajim
lajur
lakab
lakak
lakar
laken
lakip
lakon
lakri
laksa
lakum
lakur
lalah
lalai
lalak
lalap
lalat
lalau
laler
lalim
lamak
laman
lamar
lambe
lambo
lambu
lames
lamin
lamma
lampa
lampu
lamun
lamur
lanar
lanas
lanau
lanca
landa
langi
langu
lanja
lanji
lansi
lantu
lanun
lanus
lanyo
laocu
lapad
lapah
lapak
lapal
lapan
lapar
lapas
lapaz
lapel
lapih
lapik
lapir
lapis
lapor
lapuk
lapun
lapur
larah
larai
larak
laram
larap
laras
larat
larau
largo
larih
larik
laris
laron
larut
larva
larwo
lasah
lasak
lasat
laser
lasik
lasit
lasuh
lasut
latah
latak
latam
latar
latas
laten
latif
latih
latin
latis
latma
latuh
latuk
latur
lauje
laulu
laung
lauya
lawah
lawai
lawak
lawan
lawar
lawas
lawat
lawer
lawon
layah
layak
layam
layan
layap
layar
layas
layat
layer
layon
layuh
layuk
layup
layur
layut
lazat
lazim
lebah
lebai
lebak
lebam
leban
lebap
lebar
lebas
lebat
lebay
leber
lebih
lebon
lebuh
lebuk
lebum
lebun
lebur
lecah
lecak
lecap
lecat
leceh
lecek
lecer
lecet
lecit
lecok
lecuh
lecun
lecup
lecur
lecut
ledak
ledek
ledes
ledos
ledre
leduk
legah
legal
legam
legan
legap
legar
legat
legek
legen
leger
leges
legih
legio
legir
legit
legok
legum
lehar
leher
lejar
lejas
lejit
lejok
lekah
lekam
lekap
lekar
lekas
lekat
lekir
lekit
lekok
lekuk
lekum
lekun
lelah
lelai
lelak
lelap
lelar
lelas
lelat
leleh
lelep
leler
leles
lelet
lemah
lemak
leman
lemas
lemau
lembo
lembu
lemes
lemma
lemon
lemur
lenan
lenca
lenci
lenda
lendo
lenek
lenga
lenge
lenis
lenja
lenor
lensa
lense
lenso
lento
lepai
lepak
lepap
lepas
lepat
lepau
lepek
leper
lepes
lepet
lepih
lepik
lepit
lepoh
lepok
lepot
lepra
lepuh
lepuk
lepur
lerah
lerai
lerak
leram
lerap
leret
lerik
lerok
lerot
lerum
lesah
lesak
lesan
lesap
lesat
lesau
lesbi
leseh
lesek
leset
lesih
lesir
lesit
lesot
lesus
lesut
letai
letak
letal
letda
letek
leter
letih
letik
letis
letoi
letos
lettu
letuk
letum
letup
letur
letus
leuca
levan
level
lever
lewah
lewar
lewat
leyeh
leyot
lezat
liana
liang
libas
libat
libei
libra
libur
licak
licau
licik
licin
lidah
lidar
lidas
lidid
ligan
ligar
ligas
ligat
ligih
lihai
lihap
lihat
likah
likas
likat
likir
likra
likur
likut
lilah
lilan
lilau
lilin
lilit
liman
limar
limas
limau
limed
limeh
limfa
limit
limpa
limun
limut
linan
linau
linda
lindi
lindu
linen
lines
linud
liong
lipai
lipan
lipas
lipat
lipid
lipit
lipur
liput
lirih
lirik
liris
lisah
lisan
lisin
lisis
lisol
lisus
lisut
litah
litak
liter
liver
liwan
liwat
liwet
liyan
lobak
loban
lobok
lobus
locok
locot
lodan
lodeh
lodoh
lodra
logam
logat
logis
lohan
lohok
lohor
lokal
lokan
lokap
lokek
loker
loket
lokia
lokio
lokon
lokos
lokum
lokus
lolak
loloh
lolos
lomba
lomek
lomie
lomot
lompo
lonan
lonco
longo
lonte
lonto
lopak
lopek
loper
lopis
lopor
lorah
loran
lorat
lorek
lorot
losin
lotak
lotek
lotik
lotis
lotre
lotus
loyak
loyal
loyar
lppks
luang
luasa
luban
luber
lubuk
lubur
lucah
lucak
lucup
lucut
ludah
ludat
ludes
lugas
lugut
luhak
luhur
luing
lukah
lukas
lukat
lukeh
lukis
lukut
lulai
luluh
luluk
lulum
lulup
lulur
lulus
lulut
lumar
lumas
lumat
lumbu
lumen
lumer
lumuh
lumur
lumus
lumut
lunak
lunar
lunas
lunau
lundi
lundu
luner
lunta
lupat
lupuh
lupuk
lupus
luput
lurah
lurik
lurub
luruh
luruk
lurus
lurut
lusin
lusuh
lutut
luwes
luyak
luyut
mabal
mabau
mabes
mabir
mabok
mabuh
mabuk
mabul
macam
macan
macat
macet
macis
madah
madam
madar
madat
maden
madia
madik
madya
mafia
mafik
mafur
magel
mager
magik
magis
magma
magun
mahah
mahal
mahar
mahda
mahdi
mahia
mahir
mahwu
maido
maiwa
majal
majas
majer
majir
majuh
majuj
majun
makam
makan
makao
makar
makas
makda
maket
makin
makna
makro
maksi
makua
makul
malah
malai
malak
malam
malan
malap
malar
malas
malau
malbi
maleo
malih
malik
malim
malin
malis
malka
maloh
malun
mamah
mamai
mamak
maman
mamar
mamat
mambi
mambo
mambu
mamik
mampu
mamut
manah
manai
manau
manci
manda
mandi
mandu
manee
manem
manga
mangu
mania
manik
manis
manja
manna
manol
manta
manti
mantu
manuk
manut
maois
maori
mapak
mapan
mapel
mapor
mappi
mapur
marah
marak
maras
marau
marem
maret
marga
maria
marka
marki
maros
marus
marut
masai
masak
masal
masam
masan
masap
masep
maser
masif
masih
masin
masip
masir
masoi
mason
massa
masuk
matan
matik
matoa
maton
matra
matun
matur
maula
maung
mawar
mawas
mawat
mawes
mawin
mawon
mawut
mayam
mayar
mayas
mayat
mayit
mayor
mayos
mayur
mboja
mbojo
meaks
mebel
mecin
mecis
medan
media
medik
medil
medio
medis
medit
medok
meduk
megah
megak
megan
megar
megat
mejam
mejan
mejen
mekah
mekan
mekap
mekar
mekis
melar
melas
melek
meler
melik
melit
melon
melor
melur
memar
memek
memur
menag
menak
menat
mendi
mendu
menep
mengi
menir
menit
menlu
menor
menta
mento
menua
menur
menwa
meong
mepet
merah
merak
meram
merat
merca
mercu
merdu
merek
merem
meres
merih
merik
merok
merot
merta
merua
merut
mesan
mesem
meses
mesik
mesin
mesiu
meski
meson
mesra
mesta
mesti
mesui
mesum
mesut
metah
metai
metal
meter
metil
metro
mewah
mewek
meyah
meyak
mezzo
miana
miang
micin
midar
midik
miere
migas
mihun
mijil
mikat
mikro
milad
milik
milir
milis
mimas
mimik
mimis
mimpi
minat
minda
mindi
minim
minor
minta
minum
minus
mioma
mipis
mirah
mirai
miras
mirat
mirih
mirik
mirin
mirip
miris
misai
misal
misan
misil
misoa
misri
misro
misua
misuh
mitos
mitra
mizab
mizan
mobil
mobud
mocaf
mocok
modal
modar
model
modem
modin
modis
modul
modus
mofet
mogao
mogas
mogok
mohon
mohor
mojah
moksa
moksu
molal
molar
molek
molen
moler
moles
molof
molor
molos
momen
momok
monad
monas
monel
monti
moped
mopit
mopok
moral
morel
mores
moril
moron
morse
motel
motif
motil
motor
motto
mozah
mpasi
muang
muara
mubah
mubes
mubut
mudah
mudat
mudik
mudra
mudun
mufti
muhal
muhib
muhit
mujur
mukah
mukim
mukun
mukus
mulai
mulas
mulat
mules
mulet
mulia
muloh
mulok
mulsa
muluk
mulur
mulus
mulut
mumet
mumuk
mumur
mumut
munas
munci
mundu
munib
muntu
mupus
murad
murah
murai
mural
muram
muras
murba
murca
murid
muris
murka
murni
murop
murup
murus
murut
musda
musik
musim
muson
musti
musuh
mutah
mutan
mutih
muton
mutur
muzah
nabab
naban
nabet
nabil
nadam
nadar
nadim
nadir
nafar
nafas
nafri
nafsi
nafsu
nafta
nagam
nahak
nahas
nahwu
najam
najen
najis
nakal
nakas
nalam
nalar
nalca
nalih
nambi
namun
nanah
nanap
nanar
nanas
nanda
nandu
nanti
napal
napas
napsi
napsu
napuh
naqal
naqli
nasab
nasal
nasar
nasel
nasib
nasti
nasut
natal
natar
natur
naulu
naung
nayam
nayap
nayor
nazam
nazar
nazim
nazir
ndoro
nduga
neala
neces
necis
neger
negri
negro
negus
nekad
nekat
nekel
nenar
nenas
nenda
nenek
nenen
nener
nenes
netra
netto
ngada
ngaju
ngalo
ngawi
ngeri
nggem
ngilu
ngoko
ngoyo
ngung
niaga
nifak
nifas
nihil
nijas
nikab
nikah
nikel
nilai
nilam
nilau
nilem
nilon
nimfa
ninik
ninja
nipah
nipas
nipis
nisab
nisan
nisbi
nisin
nista
nkkbs
nobat
nobuk
nodus
noken
nolam
nomad
nomer
nomor
nonai
nonet
nonoh
nonok
nonol
nopek
norak
norit
norma
nosel
notes
novel
novis
novum
noyod
nozel
nrima
nudis
nufur
nugal
nugat
nuget
nujum
nukil
nunut
nusuk
nusyu
nutan
nuzul
nyadu
nyala
nyale
nyali
nyana
nyang
nyara
nyata
nyawa
nyepi
nyeri
nyiri
nyiru
nyiur
nyolo
nyong
oasis
obeks
obeng
objek
oblak
oblik
obral
obras
obrol
obrus
obyek
odmil
ofset
ojung
okapi
oknum
oktaf
oktal
oktan
oktet
okura
oleng
oleum
oliva
ombak
ombre
omega
omong
ompok
ompol
omset
omzet
onani
oncat
oncek
oncen
oncer
oncoe
oncom
oncor
onder
ondok
ondos
ongeh
ongji
ongok
oniks
onjem
onsen
ontam
ontel
onyok
onyot
oolit
oosit
opdar
opera
opini
opior
opium
oplah
oplas
oplet
oplos
opmak
opsen
opsin
opsir
opsus
optik
optis
optuh
orang
orari
orasi
orbit
order
oreng
oreol
organ
orgel
orien
orion
orkes
ormas
orpol
osara
osean
oseng
osing
ospek
otsus
ovari
ovasi
oyong
paban
pacad
pacai
pacak
pacal
pacar
pacat
pacau
pacek
pacet
pacih
pacik
pacis
pacoi
pacok
pacuk
pacul
padah
padak
padam
padan
padar
padas
padat
padma
padmi
padoe
padri
paduk
pagan
pagar
pagas
pagon
pagun
pagur
pagut
paham
pahar
pahat
pahit
paing
pajak
pajan
pajuh
pakai
pakal
pakan
pakar
pakat
pakau
pakde
pakem
paker
paket
pakir
pakis
pakma
paksa
paksi
pakta
pakuh
pakuk
pakus
palai
palak
palam
palar
palas
palat
palau
paldu
palem
palen
pales
palet
palis
palit
palka
palma
palsu
paltu
palue
paluh
palun
palut
pamah
paman
pamen
pamer
pamit
pamor
pampa
panah
panai
panar
panas
panau
panci
panco
panda
pandu
panel
panen
panik
panil
panir
panja
panji
panko
panti
panto
panus
papah
papak
papan
papar
papas
papat
papua
papui
papus
parab
paraf
parah
parak
param
paran
parap
paras
parau
pareo
parfe
parga
paria
parih
parik
paris
parit
parji
parka
paron
parse
parsi
paruh
parun
parut
parwa
pasah
pasai
pasak
pasal
pasan
pasar
pasat
paser
paset
pasif
pasik
pasim
pasir
pasit
pasok
pasta
pasti
pasto
pasuk
patah
patal
patam
patar
patas
patek
paten
pater
patet
patih
patik
patil
patin
patio
patka
patok
patos
patri
patuh
patuk
patut
pauhi
paung
pause
pawai
pawak
payah
payar
payau
payet
payir
payon
pbvsi
peang
pecah
pecai
pecak
pecal
pecat
pecel
pecok
pecuk
pecun
pecut
pedah
pedak
pedal
pedar
pedas
pedel
pedet
pedih
pedis
pedok
pedut
pegah
pegal
pegan
pegar
pegas
pegat
pegoh
pegon
pegun
pejal
pejam
pekah
pekak
pekal
pekam
pekan
pekas
pekat
pekau
pekek
pekik
pekir
pekis
peksi
pekuk
pekur
pelah
pelak
pelan
pelas
pelat
pelda
peleh
pelek
peles
pelet
pelik
pelir
pelit
pelni
pelog
peloh
pelok
pelor
pelti
peltu
peluh
peluk
pelus
pemda
pemeo
pemue
penad
penai
penak
penat
pencu
penda
penes
penis
pensi
penuh
penyu
pepah
pepak
pepas
pepat
pepek
peper
pepes
pepet
perah
perai
perak
peram
peran
perap
peras
perat
perca
perda
perdu
pereh
perei
perek
peres
pergi
peria
perih
perin
perit
perji
perli
perlu
perma
peroi
peron
perop
perot
peruk
perum
perun
perus
perut
pesai
pesak
pesam
pesan
pesat
pesek
peser
peset
peski
pesok
pesta
pesuk
pesut
petah
petai
petak
petal
petam
petan
petas
petek
petel
petes
petia
petik
petir
petis
petok
petor
petra
petuk
petus
petut
peuji
pewat
peyek
peyot
photo
piala
piama
piang
piano
piara
piatu
picah
picik
picis
picit
pidem
pidie
pidit
pigmi
pihak
pijah
pijak
pijar
pijat
pijin
pijit
pikap
pikat
pikau
piket
pikir
pikot
pikul
pikun
pikup
pilah
pilak
pilar
pilas
pilau
pileh
pilek
pilih
pilik
pilin
pilis
pilon
pilot
pilus
pinak
pinar
pinas
pinda
pines
pinga
pinis
pinru
pinsa
pinta
pintu
pinus
piong
pipet
pipih
pipil
pipis
pipit
pipot
pirai
pirau
pirik
pirit
pirol
pirsa
piruk
pirus
pisah
pisak
pisau
pises
pisik
pisin
pisir
pisit
pista
pisuh
pitah
pitak
pitam
pitar
pitih
pitis
piton
pitot
pitut
piung
pivot
piyik
plang
plano
plato
plaza
plbsi
pleno
plong
pltgu
pluto
pobsi
poces
pocok
podak
podsi
pohon
poise
pojok
pokah
poker
poket
pokja
pokko
pokok
pokta
polah
polan
polar
polda
polen
poler
poles
polet
polio
polip
polis
polka
polok
polos
polri
pomad
pomal
pomau
pompa
ponco
ponil
ponok
ponor
ponte
ponti
ponto
ponyo
popok
popor
porah
porda
poren
porno
porok
poros
porot
porsi
porta
porto
porus
posel
poser
posko
posma
possi
potas
potel
potia
potol
ppatk
praba
prabu
prada
praja
praka
prama
prami
prasi
pratu
premi
prima
primi
prive
proco
prodi
promo
prona
prosa
psalm
psasi
psike
ptmsi
puaka
puasa
puber
pubes
pucat
pucik
pucuk
pudar
pudat
pudek
pudel
puder
pudur
puebi
pueyd
pugak
pugar
pugas
puguh
puing
puisi
pujer
pujuk
pujur
pujut
pukah
pukal
pukas
pukat
pukau
puket
pukul
pulai
pulan
pulas
pulau
pulen
pules
pulih
pulik
pulir
pulpa
pulsa
puluh
pulun
pulus
pulut
punah
punai
punan
punar
punat
punca
punch
punci
pundi
punia
punti
punuk
punya
pupil
pupuh
pupuk
pupur
pupus
puput
purba
purek
puren
purik
purin
puris
puruk
purun
purus
purut
purwa
pusak
pusar
pusat
puser
puspa
pusri
pusta
pustu
pusut
putar
putat
putau
puter
putih
putik
putra
putri
putus
putut
puyan
puyer
puyuh
qalbu
qanun
qasar
qolbu
qudsi
qurah
quran
rabak
raban
rabas
rabat
rabeg
rabet
rabik
rabit
rabok
rabon
rabuk
rabun
rabut
racak
racau
racik
racuh
racun
radah
radai
radak
radar
radas
radat
raden
rader
rades
radif
radin
radio
radis
radon
rafas
rafia
rafik
ragam
ragas
ragaz
ragib
ragil
ragit
raguk
ragum
ragut
rahab
rahak
rahap
rahat
rahib
rahim
rahum
rajab
rajah
rajam
rajim
rajin
rajok
rajuk
rajul
rajut
rakah
rakap
rakat
raker
raket
rakis
rakit
rakna
rakor
raksa
raksi
rakuk
rakun
rakus
rakut
rakyu
ralat
ralip
ramah
ramai
ramal
ramas
rambi
rambu
ramen
rames
ramet
ramin
rampa
rampi
ramus
ranah
ranai
ranap
ranau
ranca
rancu
randa
rande
randi
randu
rangu
ranji
ranju
rante
ranti
ranum
rapah
rapai
rapak
rapal
rapat
rapbd
rapbn
rapel
rapih
rapik
rapim
rapor
rapuh
rapun
rapus
rarai
rarak
raras
rasai
rasam
rasan
rasau
rasem
rasia
rasio
rasis
rasta
rasuk
rasul
ratah
ratap
ratas
ratep
ratib
ratna
ratun
ratus
raung
rawah
rawai
rawak
rawan
rawas
rawat
rawin
rawis
rawit
rawon
rawun
rayah
rayan
rayap
rayau
rayon
rayun
razia
rebab
rebah
rebak
reban
rebas
rebat
rebeh
rebek
rebes
rebet
rebok
rebon
rebuk
rebus
rebut
recak
receh
recet
recik
recok
recup
redah
redam
redap
redas
redih
redik
redum
redup
redut
regah
regan
regas
regat
regel
regen
reges
regim
regio
regol
reguk
regup
rehab
rehal
rehat
rejab
rejah
rejam
rejan
rejeh
rejim
rejuk
rekah
rekal
rekam
rekan
rekap
rekat
reken
rekes
rekor
reksa
rekto
relai
relap
relas
relau
relik
reluh
reluk
remah
remai
remak
remas
remeh
remet
remis
remoh
rempa
remuk
renah
renai
renal
renda
renek
renes
renet
rengo
renik
renin
renop
renso
renta
rente
renti
repah
repak
repas
repek
repes
repet
repih
repis
repok
repot
repuh
repui
reput
rerak
reras
rerot
resah
resak
resam
resan
resap
resek
resem
resep
reses
reset
resik
resin
resko
resmi
resor
resto
restu
resus
retak
retal
retas
retek
retet
retih
retok
retro
retur
retus
reuni
rewak
rewan
rewel
rewet
reyal
reyot
rezim
riang
ribat
riben
ribet
ribut
ricau
ricik
ricis
ricuh
ridan
ridha
ridho
ridip
rigai
rihal
rihat
rijal
rikuh
rilis
rimah
rimas
rimba
rimbu
rimih
rimis
rimpi
rimpu
rinai
rinci
rincu
rindu
ripai
ripit
ripuh
ripuk
ririt
risak
risau
riset
risih
risik
risin
risit
ritak
ritel
ritma
ritme
ritul
ritus
riung
rival
riwan
rizki
rizom
rkakl
rkask
robeh
robek
roboh
robok
robot
rocet
rodan
rodat
rodok
rogoh
rogok
rogol
rojol
roker
roket
rokok
rolet
roman
romet
romok
rompi
ronce
ronda
ronde
rondo
roneo
ronta
rorod
rorok
roset
rosin
rosok
rosot
rotan
rotok
rotor
rouge
rouks
rowot
royak
royal
royan
royer
rspad
ruang
ruaya
rubah
rubai
ruban
rubel
rubik
rubin
rubuh
rucah
rucuk
rudah
rudal
rudat
rudin
rudui
rudus
rugbi
rugul
ruing
rujah
rujak
rujuk
rukam
rukuh
rukuk
rukun
rumah
rumal
rumba
rumbu
rumen
rumin
rumit
rumor
rumpi
rumuk
rumus
rungu
runti
runut
rupst
rural
ruruh
rurut
rusak
rusip
rusuh
rusuk
rusun
rutab
rutan
ruter
rutin
rutuk
rutup
ruwah
ruwat
ruwet
ruyak
ruyap
ruyat
ruyup
saama
sabah
sabak
saban
sabar
sabas
sabat
sabda
sabel
saben
saber
sabet
sabil
sabit
sabot
sabtu
sabuk
sabun
sabur
sabut
sadah
sadai
sadak
sadap
sadar
sadau
sadei
sadel
sadeu
sadik
sadin
sadir
sadis
sadur
saepi
safan
safar
safih
safir
sagai
sagar
sagon
sagun
sagur
saham
sahan
sahap
sahda
sahdu
sahib
sahid
sahih
sahir
sahur
sahut
saidi
sailo
saing
sains
sajak
sajen
sakai
sakal
sakap
sakar
sakat
sakau
sakbu
sakhi
sakin
sakit
saksi
sakti
salaf
salah
salai
salak
salam
salap
salar
salat
saldo
saleh
salem
salep
salib
salih
salik
salim
salin
salip
salir
salju
salon
salto
saluk
salur
salut
salvo
salwa
samad
samak
saman
samar
samas
samba
sambi
samin
samir
sampa
sampi
sampo
sampu
samsu
samuh
samum
samun
sanad
sanak
sanat
sanca
sanda
sandi
sando
sanga
sango
sangu
sanik
santa
santo
santu
sanya
sapai
sapar
sapat
sapau
sapih
sapir
sapit
sapun
saput
saraf
sarai
sarak
saran
sarap
sarat
sarau
sareh
saren
sarik
sarin
sarip
sarit
sarju
sarmi
sarok
saron
saruk
sarun
sarut
sarwa
sasak
sasan
sasap
sasar
sasau
saset
sasis
satai
satak
satar
saten
satih
satin
satir
satru
satwa
saucu
sauna
saung
sauri
sause
savan
sawab
sawah
sawai
sawak
sawan
sawar
sawat
sawer
sawit
sawut
sayak
sayap
sayat
sayet
sayib
sayid
sayup
sayur
sayut
sbkri
sebab
sebai
sebak
sebal
sebam
sebar
sebat
sebau
sebel
sebet
sebih
sebik
sebit
sebon
sebuk
sebum
sebun
sebut
secco
sedah
sedak
sedam
sedan
sedap
sedat
sedek
sedia
sedih
sedoa
sedot
sedua
seduh
sedut
seeng
segah
segai
segak
segan
segar
segeh
segel
seget
sehat
seisi
sejak
sejat
sejuk
sekah
sekak
sekal
sekam
sekan
sekap
sekar
sekat
sekda
seken
sekin
sekip
sekoi
sekon
sekop
seksi
sekte
sekui
sekul
sekum
selai
selak
selam
selan
selap
selar
selat
seleo
selia
selip
selir
selit
seliu
selok
selom
selon
selop
selot
selre
selui
seluk
selup
selut
semah
semai
semak
seman
semat
semau
semek
semem
semen
semir
semok
semua
semur
semut
senak
senam
senan
senar
senat
senda
sendi
sendu
senen
senil
senin
senja
senta
senti
senuh
senuk
senur
sepah
sepai
sepak
sepal
sepam
sepan
sepat
sepel
sepen
sepet
sepih
sepir
sepit
sepoi
sepon
sepuh
sepui
sepuk
sepul
sepur
seput
serah
serai
serak
seram
seran
serap
serat
serau
serba
serbi
serbu
serda
serdi
sereh
serep
seret
serge
serin
serip
serit
serka
serma
seroh
serok
serot
serpa
serse
sersi
serta
sertu
seruh
serui
seruk
serul
serum
serun
serut
serve
sesah
sesai
sesak
sesal
sesam
sesap
sesar
sesat
seser
sesil
sesko
sespa
setai
setal
setan
setat
setek
setel
setem
seten
seter
setia
setik
setin
setip
setir
setom
seton
setop
setor
setra
setti
setua
setum
setup
sewah
sewal
sewar
sewat
sewot
siaga
siang
siapa
sibak
sibar
siber
sibir
sibuk
sibur
sidai
sidak
sidat
sider
sidik
siduk
siena
sifar
sifat
sifon
sigai
sigak
sigap
sigar
sigau
siger
sigma
sigot
sihir
sijil
sikah
sikai
sikak
sikap
sikas
sikat
sikep
sikil
sikin
sikit
sikka
sikon
siksa
sikut
silaf
silah
silam
silap
silat
silau
silet
silia
silih
silik
silir
silok
silpa
siluk
simai
simak
simpe
sinar
sinau
sinci
sinda
singa
sinis
sinka
sinom
sinse
sinus
sinyo
sioca
siong
sipai
sipat
sipil
sipir
sipit
sipoa
sippt
siput
sirah
siram
sirap
sirat
sirep
sirib
sirih
sirik
sirip
sirke
sirna
sirop
sirup
sirus
sisal
sisih
sisik
sisil
sisip
sisir
sista
siswa
siswi
sitak
sitar
sitat
siter
sitir
situn
situs
siung
siupp
siwak
siwar
siwek
siwer
siwet
siwil
skafa
skala
skalu
skema
skene
skors
skrin
skrip
skrub
skshh
skuad
skuas
skuba
slang
sling
sluri
soang
soban
sobat
sobei
sobek
sobok
sodam
sodet
sodok
sodor
sofis
sogan
sogok
sohar
sohib
sohor
sohun
sojah
sokah
soker
soket
sokom
soksi
solah
solak
solar
solat
soleh
solek
solet
solid
solis
solok
solor
solot
solum
somah
sonar
sonde
sonik
sonor
sopak
sopan
sopek
sopir
sorak
sorek
soren
sorga
sorog
sorok
sorot
sorus
sosak
sosek
sosis
sosoh
sosok
sosor
sosot
sotis
sotoh
sotor
sougb
sowan
soyak
spasi
spesi
spina
spion
spons
spora
sport
sriti
stabo
stain
start
stasi
steik
stela
stele
stema
steno
stepa
stilb
stkip
stola
stori
stpdn
stres
strip
strok
struk
sttal
studi
stuko
stupa
suabo
suaka
suami
suang
suara
suari
suasa
suatu
subak
subal
subam
suban
subei
subuh
subur
sudah
sudak
sudan
sudet
sudip
sudra
suduk
sudur
sudut
sufah
sufal
sufel
sugar
sugih
sugra
suguh
sugul
sugun
suhad
suhuf
suhun
suite
sujau
sujen
sujud
sukan
sukar
sukat
suket
sukma
sukuk
sukun
sukur
sulah
sulam
sulap
sulbi
sulih
sulit
sulub
suluh
suluk
sulup
sulur
sulut
sumah
sumba
sumbi
sumbu
sumeh
sumir
sumpa
sumur
sumut
sunah
sunam
sunan
sunat
sunda
sungu
sunti
sunyi
supai
supel
super
supir
supit
surah
surai
suram
surat
surau
surek
surel
suren
surga
surih
suris
suruh
suruk
surup
surut
surya
susah
susuh
susuk
susul
susun
susup
susur
susut
susyi
sutan
suten
sutet
sutil
sutra
suwir
swazi
swike
syair
syaka
syala
syeir
syekh
syeti
syiar
syiwa
syura
taala
tabah
tabak
tabal
taban
tabat
tabel
taber
tabia
tabib
tabii
tabik
tabir
tabla
tablo
tabok
tabot
tabuh
tabun
tabur
tabut
tadah
tadir
tadut
taena
tafia
tagak
tagal
tagan
tagar
tagas
tageh
tagen
tagih
tagma
tagut
tahak
tahan
tahap
tahar
tahil
tahir
tahta
tahun
taici
taiga
taiko
taiso
tajak
tajam
tajau
tajen
tajik
tajin
tajio
tajir
tajuk
tajur
takah
takak
takal
takar
takat
takaw
takeh
takel
takik
takir
takma
takmu
takol
taksa
taksi
taksu
takuh
takuk
takur
takut
takwa
talah
talai
talak
talam
talar
talas
talek
talen
talib
talon
talum
talun
talus
talut
tamak
tamam
taman
tamar
tamas
tamat
tambi
tambo
tamil
tampi
tampo
tamuk
tanah
tanai
tanak
tanam
tanau
tanbo
tanda
tando
tandu
tango
tania
tanih
tanin
tanji
tanju
tanpa
tansi
tante
tanti
tanur
tanya
taoci
taoco
taoge
taoke
taori
taosi
tapah
tapai
tapak
tapal
tapih
tapin
tapir
tapis
tapol
taptu
tapui
tapuk
tapus
taqwa
taraf
tarah
tarak
taram
taran
tarap
taras
tarib
tarif
tarik
tarip
taris
tarof
tarot
tarra
tarub
taruh
taruk
tarum
tarup
tasai
tasak
tasel
tasik
taska
tatah
tatai
tatak
tatal
tatap
tatar
tatib
tatih
tauco
tauge
tauke
taung
tause
tawaf
tawak
tawan
tawar
tawas
tawes
tawon
tawur
tayib
tayub
tayum
tazir
tebah
tebak
tebal
teban
tebar
tebas
tebat
tebet
tebok
tebon
tebuk
tebus
tedak
tedas
teduh
tefeu
tegah
tegak
tegal
tegap
tegar
tegas
tegel
teger
tegil
tegor
teguh
teguk
tegun
tegur
tehid
tekad
tekah
tekak
tekam
tekan
tekap
tekat
tekek
tekel
teken
teker
tekik
tekis
tekoh
tekor
tekpi
tekte
tekua
tekuk
tekun
tekup
tekur
telah
telak
telan
telap
telas
telat
telau
telek
teler
teles
telik
telis
telop
telor
teluh
teluk
telur
telus
telut
temak
teman
temar
temas
tembu
temeh
temin
tempa
tempe
tempo
tenak
tenam
tenar
tenat
tenda
tendo
tener
tenge
tengu
tenis
tenok
tenor
tensi
tentu
tenuk
tenun
teori
tepak
tepam
tepas
tepat
tepeh
tepek
tepet
tepik
tepis
tepok
tepos
tepra
tepuk
tepus
terak
teral
teram
teran
terap
teras
terau
terem
teres
teret
terik
terin
terka
terna
terok
teror
terpa
teruk
terum
terup
terus
tesis
tesla
testa
tetak
tetal
tetap
tetar
tetas
teteh
tetek
teter
tetes
tetis
tetra
tetua
tetun
teuku
tewas
teyan
tiada
tiaga
tiang
tiara
tiban
tibia
tibum
tidak
tidur
tifus
tigas
tigel
tihul
tijak
tikai
tikam
tikan
tikar
tikas
tiket
tikim
tikpi
tikus
tilam
tilan
tilap
tilas
tilde
tilik
timah
timba
timbo
timol
timor
timpa
timuk
timun
timur
timus
tinai
tinea
tiner
tingi
tinja
tinju
tinta
tipak
tipar
tipat
tipes
tipis
tipus
tirah
tirai
tiram
tiran
tiras
tirau
tirik
tiris
tirta
tirus
tisik
tisis
titah
titan
titar
titel
titen
titer
titih
titik
titip
titir
titis
titit
tiwah
tiwul
toala
tobak
tobat
toboh
todak
tofan
togan
togel
togok
tohok
tohor
tojoh
tokak
tokek
token
tokoh
tokok
tokol
tokwi
tolak
tolan
tolap
toleh
tolok
tolol
toman
tomas
tomat
tomon
tonda
tonem
tonga
tonik
tonil
tonit
tonus
topah
topan
topas
topek
topes
topik
torak
toreh
torek
tores
torka
torne
torog
torsi
torso
torus
total
totau
totem
totok
totol
towaf
towei
towel
toyah
toyoh
toyor
tpihi
trafo
trama
trans
trema
trica
triko
triol
trips
trofi
troli
tropi
trusa
tsuru
tuala
tuana
tuang
tuban
tubin
tubir
tubuh
tudak
tuduh
tufah
tugal
tugar
tugas
tugur
tuhan
tuhur
tuidi
tujah
tujuh
tujul
tukai
tukak
tukal
tukam
tukar
tukas
tukik
tukil
tukin
tukuk
tukul
tukun
tukup
tulad
tulah
tulak
tular
tulat
tulen
tulip
tulis
tulup
tulus
tuman
tumbu
tumis
tumit
tumor
tumpu
tumus
tunai
tunak
tunam
tunan
tunas
tunda
tungi
tungo
tungu
tunik
tupai
tupat
turap
turas
turba
turis
turki
turne
tursi
turun
turus
turut
tusah
tusam
tusir
tusuk
tuter
tutor
tutuh
tutuk
tutul
tutup
tutur
tutus
tutut
tuyuk
tuyul
uanda
uapan
ubang
ubaya
ubung
uceng
udang
udani
udara
udema
udeng
ujana
ujang
ujian
ujung
ukhti
uktab
ulama
ulang
uling
ulkus
ulong
ulser
ultah
uluai
ulung
umami
umara
umbah
umbai
umban
umbar
umbin
umbra
umbuk
umbul
umbun
umbur
umbut
umonu
umpak
umpan
umpat
umpet
umpil
umpuk
umpun
umput
umrah
umrat
umroh
unair
unand
uncen
uncit
uncue
uncui
undae
undak
undan
undar
undip
unduh
undur
ungam
ungar
ungka
ungsi
ungti
unhas
uniat
unida
unila
union
unjam
unjon
unjuk
unjun
unjur
unjut
unlam
unmul
unnes
unpad
unpar
unram
unsil
unsri
unsur
untad
untag
untai
untal
untan
untar
until
untir
untuk
untun
untut
unwan
unwar
unyai
unyil
upaya
upeti
urang
urban
urdal
ureum
urgen
urian
urine
uring
urita
urung
usada
usaha
usali
usang
using
uskup
usrek
ustad
ustaz
usung
uswah
utama
utang
utara
uteri
uuspn
uvula
uwete
uyung
uzbek
uzlah
vadem
vados
vakum
valas
valid
valin
valis
varia
vasal
vegan
velar
velum
venal
venda
venus
verba
versi
verso
vespa
veste
veter
video
vidio
vifer
vigia
vigor
vinil
viola
viper
viral
virga
virgo
virus
visnu
vista
visum
visus
vital
vodka
vokal
volan
vonis
votum
vulva
wabah
wadah
wadak
wadal
wadam
wadan
wadar
wadas
wadat
wader
wadir
waduh
waduk
wafak
wafat
wafel
wafer
wagon
wagub
wagyu
wahah
wahai
waham
wahan
wahau
wahib
wahid
wahon
wahyu
waima
waina
wajah
wajan
wajar
wajib
wajik
wajit
wakaf
wakas
wakde
wakif
wakil
waktu
wakun
walad
walah
walak
walas
walat
walau
waleh
walet
walhi
walsa
waluh
wamil
wanam
wanda
wangi
wanua
wanyi
waqaf
warak
waras
wardi
warem
wares
warga
waria
warid
warik
waris
warna
warok
warsa
warta
wasak
wasal
wasir
wasit
wastu
watak
watan
watas
water
waton
watun
wawas
wayuh
wazan
wazir
weber
wedam
wedar
wedel
weduk
wekel
weker
welas
welit
welut
wembi
werak
werda
werek
werit
werst
wesel
wetan
weton
wiaoe
wifik
wijen
wijik
wiket
wilis
windu
wirid
wiron
wisal
wisik
wiski
wisma
wisnu
wispy
witel
witir
wiwik
wodka
wolio
wondo
wonti
woton
wrang
wreda
wregu
wudhu
wuduk
wufer
wujud
wuker
wukuf
wulan
wulen
wundo
wungu
wushu
wusul
wutuh
wuwur
xenia
xenon
xerik
xilan
xilem
xilol
yacht
yahud
yahwe
yahya
yaitu
yakai
yakik
yakin
yakis
yakni
yakon
yaksa
yakub
yakut
yamna
yasan
yasti
yatim
yawat
yesus
yetfa
yirip
ylbhi
yogia
yokal
yolks
yonif
yonko
yowot
yudas
yudha
yunda
yunta
yunus
yurin
yuris
yusuf
zabad
zabah
zabib
zabur
zadah
zadat
zahid
zahir
zakar
zakat
zakum
zalim
zalir
zaman
zamin
zapin
zarah
zatua
zawal
zebra
zefir
zelot
zenit
zigot
zikir
zinah
zinak
zipur
zirah
ziter
zodia
zohal
zohor
zolim
zombi
zonal
zuama
zubur
zuhud
zuhur
zumba
