package Acme::CPANLists::PERLANCAR::Retired;

our $DATE = '2016-02-25'; # DATE
our $VERSION = '0.11'; # VERSION

our @Module_Lists = (
    # list: Retired modules
    {
        summary => 'Retired modules',
        description => <<'_',

This is a list of some of the modules which I wrote but have now been retired,
for various reasons but mostly because they are no longer necessary. I've
purged/retired more modules than these (mostly failed experiments) but they are
not worth mentioning here because nobody else seems to have used them.

Note that you can always get these retired modules from BackPAN or GitHub (I
don't purge most of the repos) if needed.

_
        entries => [
            {
                module => 'Data::Schema',
                description => <<'_',

Superseded by `Data::Sah` since 2012.

_
                alternate_modules => ['Data::Sah'],
            },
            {
                module => 'Carp::Always::Dump',
                description => <<'_',

Superseded by `Devel::Confess`, which can do color (`Carp::Always::Color`),
dumps (`Carp::Always::Dump`), as well as a few other tricks, all in a single
package.

_
                alternate_modules => ['Devel::Confess'],
            },
            {
                module => 'Passwd::Unix::Alt',
                description => <<'_',

Abandoned this fork of `Passwd::Unix` due to a couple of fundamental issues and
superseded by `Unix::Passwd::File` which is a clean-slate attempt.

_
                alternate_modules => ['Unix::Passwd::File'],
            },
        ],
    },
);

1;
# ABSTRACT: Retired modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::PERLANCAR::Retired - Retired modules

=head1 VERSION

This document describes version 0.11 of Acme::CPANLists::PERLANCAR::Retired (from Perl distribution Acme-CPANLists-PERLANCAR), released on 2016-02-25.

=head1 MODULE LISTS

=head2 Retired modules

This is a list of some of the modules which I wrote but have now been retired,
for various reasons but mostly because they are no longer necessary. I've
purged/retired more modules than these (mostly failed experiments) but they are
not worth mentioning here because nobody else seems to have used them.

Note that you can always get these retired modules from BackPAN or GitHub (I
don't purge most of the repos) if needed.


=over

=item * L<Data::Schema>

Superseded by C<Data::Sah> since 2012.


Alternate modules: L<Data::Sah>

=item * L<Carp::Always::Dump>

Superseded by C<Devel::Confess>, which can do color (C<Carp::Always::Color>),
dumps (C<Carp::Always::Dump>), as well as a few other tricks, all in a single
package.


Alternate modules: L<Devel::Confess>

=item * L<Passwd::Unix::Alt>

Abandoned this fork of C<Passwd::Unix> due to a couple of fundamental issues and
superseded by C<Unix::Passwd::File> which is a clean-slate attempt.


Alternate modules: L<Unix::Passwd::File>

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANLists> - about the Acme::CPANLists namespace

L<acme-cpanlists> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
