package Geo::TigerLine::Record::I;

use strict;

use Carp::Assert;
use base qw(Geo::TigerLine::Record::Parser Geo::TigerLine::Record::Accessor
            Geo::TigerLine::Record Class::Data::Inheritable);

use vars qw($VERSION);
$VERSION = '0.01';


# Auto-generated data dictionary.
my %Data_Dict = (
               'polyidl' => {
                              'beg' => '27',
                              'bv' => 'Yes',
                              'description' => 'Polygon Identification Code, Left',
                              'fieldnum' => '8',
                              'len' => '10',
                              'end' => '36',
                              'fmt' => 'R',
                              'field' => 'polyidl',
                              'type' => 'N'
                            },
               'state' => {
                            'beg' => '16',
                            'bv' => 'No',
                            'description' => 'FIPS State Code for File',
                            'fieldnum' => '4',
                            'len' => '2',
                            'end' => '17',
                            'fmt' => 'L',
                            'field' => 'state',
                            'type' => 'N'
                          },
               'county' => {
                             'beg' => '18',
                             'bv' => 'No',
                             'description' => 'FIPS County Code for File',
                             'fieldnum' => '5',
                             'len' => '3',
                             'end' => '20',
                             'fmt' => 'L',
                             'field' => 'county',
                             'type' => 'N'
                           },
               'filler' => {
                             'beg' => '52',
                             'bv' => 'Yes',
                             'description' => 'Filler (to make even character count)',
                             'fieldnum' => '11',
                             'len' => '1',
                             'end' => '52',
                             'fmt' => 'L',
                             'field' => 'filler',
                             'type' => 'A'
                           },
               'cenidl' => {
                             'beg' => '22',
                             'bv' => 'Yes',
                             'description' => 'Census File Identification Code, Left',
                             'fieldnum' => '7',
                             'len' => '5',
                             'end' => '26',
                             'fmt' => 'L',
                             'field' => 'cenidl',
                             'type' => 'A'
                           },
               'rtlink' => {
                             'beg' => '21',
                             'bv' => 'No',
                             'description' => 'Record Type of Link',
                             'fieldnum' => '6',
                             'len' => '1',
                             'end' => '21',
                             'fmt' => 'L',
                             'field' => 'rtlink',
                             'type' => 'A'
                           },
               'polyidr' => {
                              'beg' => '42',
                              'bv' => 'Yes',
                              'description' => 'Polygon Identification Code, Right',
                              'fieldnum' => '10',
                              'len' => '10',
                              'end' => '51',
                              'fmt' => 'R',
                              'field' => 'polyidr',
                              'type' => 'N'
                            },
               'tlid' => {
                           'beg' => '6',
                           'bv' => 'No',
                           'description' => 'TIGER/Line ID, Permanent Record Number',
                           'fieldnum' => '3',
                           'len' => '10',
                           'end' => '15',
                           'fmt' => 'R',
                           'field' => 'tlid',
                           'type' => 'N'
                         },
               'cenidr' => {
                             'beg' => '37',
                             'bv' => 'Yes',
                             'description' => 'Census File Identification Code, Right',
                             'fieldnum' => '9',
                             'len' => '5',
                             'end' => '41',
                             'fmt' => 'L',
                             'field' => 'cenidr',
                             'type' => 'A'
                           },
               'version' => {
                              'beg' => '2',
                              'bv' => 'No',
                              'description' => 'Version Number',
                              'fieldnum' => '2',
                              'len' => '4',
                              'end' => '5',
                              'fmt' => 'L',
                              'field' => 'version',
                              'type' => 'N'
                            },
               'rt' => {
                         'beg' => '1',
                         'bv' => 'No',
                         'description' => 'Record Type',
                         'fieldnum' => '1',
                         'len' => '1',
                         'end' => '1',
                         'fmt' => 'L',
                         'field' => 'rt',
                         'type' => 'A'
                       }
             );


my @Data_Fields = (
                 'rt',
                 'version',
                 'tlid',
                 'state',
                 'county',
                 'rtlink',
                 'cenidl',
                 'polyidl',
                 'cenidr',
                 'polyidr',
                 'filler'
               );


assert(keys %Data_Dict == @Data_Fields);

# Turn the data dictionary into class data
__PACKAGE__->mk_classdata('Fields');
__PACKAGE__->mk_classdata('Dict');
__PACKAGE__->mk_classdata('Pack_Tmpl');

__PACKAGE__->Dict(\%Data_Dict);
__PACKAGE__->Fields(\@Data_Fields);

# Generate a pack template for parsing and turn it into class data.
my $pack_tmpl = join ' ', map { "A$_" } map { $_->{len} } 
                                          @Data_Dict{@Data_Fields};
__PACKAGE__->Pack_Tmpl($pack_tmpl);

# Generate accessors for each data field
foreach my $def (@Data_Dict{@Data_Fields}) {
    __PACKAGE__->mk_accessor($def);
}


=pod

=head1 NAME

Geo::TigerLine::Record::I - TIGER/Line 1998 Link Between Complete Chains and Polygons

=head1 SYNOPSIS

  use Geo::TigerLine::Record::I;

  @records = Geo::TigerLine::Record::I->parse_file($fh);
  @records = Geo::TigerLine::Record::I->parse_file($fh, \&callback);

  $record = Geo::TigerLine::Record::I->new(\%fields);

  $record->rt();
  $record->version();
  $record->tlid();
  $record->state();
  $record->county();
  $record->rtlink();
  $record->cenidl();
  $record->polyidl();
  $record->cenidr();
  $record->polyidr();
  $record->filler();


=head1 DESCRIPTION

This is a class representing record type I of the TIGER/Line 1998
census geographic database.  Each object is one record.  It also
contains methods to parse TIGER/Line record type I files and turn them
into objects.

This is intended as an intermediate format between pulling the raw
data out of the simplistic TIGER/Line data files into something more
sophisticated (a process you should only have to do once).  As such,
its not very fast, but its careful, easy to use and performs some
verifications on the data being read.

As this class is autogenerated by mk_parsers, think before you modify this
file.  Its OO, so consider sub-classing instead.


=head2 Accessors

These are simple get/set accessors for each field of a record
generated from the TIGER/Line 1998 data dictionary.  They perform some
data validation.

=over 4

=item B<rt>

    $data = $record->rt();
    $record->rt($data);

Record Type.  

Expects alphanumeric data of no more than 1 characters.  $data cannot be blank 
and should be left justified.


=item B<version>

    $data = $record->version();
    $record->version($data);

Version Number.  

Expects numeric data of no more than 4 characters.  $data cannot be blank 
and should be left justified.


=item B<tlid>

    $data = $record->tlid();
    $record->tlid($data);

TIGER/Line ID, Permanent Record Number.  

Expects numeric data of no more than 10 characters.  $data cannot be blank 
and should be right justified.


=item B<state>

    $data = $record->state();
    $record->state($data);

FIPS State Code for File.  

Expects numeric data of no more than 2 characters.  $data cannot be blank 
and should be left justified.


=item B<county>

    $data = $record->county();
    $record->county($data);

FIPS County Code for File.  

Expects numeric data of no more than 3 characters.  $data cannot be blank 
and should be left justified.


=item B<rtlink>

    $data = $record->rtlink();
    $record->rtlink($data);

Record Type of Link.  

Expects alphanumeric data of no more than 1 characters.  $data cannot be blank 
and should be left justified.


=item B<cenidl>

    $data = $record->cenidl();
    $record->cenidl($data);

Census File Identification Code, Left.  

Expects alphanumeric data of no more than 5 characters.  $data can be blank 
and should be left justified.


=item B<polyidl>

    $data = $record->polyidl();
    $record->polyidl($data);

Polygon Identification Code, Left.  

Expects numeric data of no more than 10 characters.  $data can be blank 
and should be right justified.


=item B<cenidr>

    $data = $record->cenidr();
    $record->cenidr($data);

Census File Identification Code, Right.  

Expects alphanumeric data of no more than 5 characters.  $data can be blank 
and should be left justified.


=item B<polyidr>

    $data = $record->polyidr();
    $record->polyidr($data);

Polygon Identification Code, Right.  

Expects numeric data of no more than 10 characters.  $data can be blank 
and should be right justified.


=item B<filler>

    $data = $record->filler();
    $record->filler($data);

Filler (to make even character count).  

Expects alphanumeric data of no more than 1 characters.  $data can be blank 
and should be left justified.



=back


=head2 Data dictionary

This is the original TIGER/Line 1998 data dictionary from which this
class was generated.

    Record Type I - Link Between Complete Chains and Polygons
    
         Field   BV  Fmt  Type  Beg  End  Len  Description
            RT   No    L     A    1    1    1  Record Type
       VERSION   No    L     N    2    5    4  Version Number
          TLID   No    R     N    6   15   10  TIGER/Line ID, Permanent Record Number
         STATE   No    L     N   16   17    2  FIPS State Code for File
        COUNTY   No    L     N   18   20    3  FIPS County Code for File
        RTLINK   No    L     A   21   21    1  Record Type of Link
        CENIDL  Yes    L     A   22   26    5  Census File Identification Code, Left
       POLYIDL  Yes    R     N   27   36   10  Polygon Identification Code, Left
        CENIDR  Yes    L     A   37   41    5  Census File Identification Code, Right
       POLYIDR  Yes    R     N   42   51   10  Polygon Identification Code, Right
        FILLER  Yes    L     A   52   52    1  Filler (to make even character count)
    
    
    



=head1 AUTHOR

Michael G Schwern <schwern@pobox.com>

=head1 SEE ALSO

L<Geo::TigerLine>, L<mk_parsers>

=cut


return 'Honey flash!';
