package App::bif::log::topic;
use strict;
use warnings;
use feature 'state';
use Bif::Mo;

our $VERSION = '0.1.5_7';
extends 'App::bif::log';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;
    my $info = $self->get_node( $opts->{id}, 'topic' );

    state $have_dbix = DBIx::ThinSQL->import(qw/ qv concat coalesce/);
    my $now = $self->now;

    my $sth = $db->xprepare(
        select => [
            'ltd.topic_id AS id',
            'n.uuid AS uuid',
            concat( qv('c'), 'ltd.change_id' )->as('change_id'),
            'c.uuid AS change_uuid',
            'ltd.title',
            'c.mtime AS mtime',
            "c.mtimetz AS mtimetz",
            'c.mtimetzhm AS mtimetzhm',
            "$now - c.mtime AS mtime_age",
            'c.action',
            'COALESCE(c.author,e.name) AS author',
            "COALESCE(c.author_contact_method || ': ' || "
              . "c.author_contact, ecm.method || ': ' || "
              . "ecm.mvalue) AS contact",
            'ts.status',
            'ts.status',
            'p.title AS project_title',
            'ct.depth',
            'c.message',
        ],
        from       => 'topics t',
        inner_join => 'link_topic_deltas ltd',
        on         => 'ltd.link_topic_id = t.link_topic_id',
        inner_join => 'changes c',
        on         => 'c.id = ltd.change_id',
        inner_join => 'entities e',
        on         => 'e.id = c.identity_id',
        inner_join => 'entity_contact_methods ecm',
        on         => 'ecm.id = e.default_contact_method_id',
        inner_join => 'nodes n',
        on         => 'n.id = t.id',
        left_join  => 'topic_status ts',
        on         => 'ts.id = ltd.topic_status_id',
        left_join  => 'projects p',
        on         => 'p.id = ts.project_id',
        left_join  => 'hubs h',
        on         => 'h.id = p.default_hub_id',
        inner_join => 'changes_tree ct',
        on         => {
            'ct.parent' => $info->{first_change_id},
            'ct.child'  => \'ltd.change_id'
        },
        where    => { 't.id' => $info->{id} },
        order_by => 'c.path ASC',
    );

    $sth->execute;

    $self->start_pager;

    my $first = $sth->hashref;
    $first->{ctime}     = $first->{mtime};
    $first->{ctimetz}   = $first->{mtimetz};
    $first->{ctimetzhm} = $first->{mtimetzhm};
    $first->{ctime_age} = $first->{mtime_age};
    $self->log_item( $first, 'topic' );

    $self->log_comment($_) for $sth->hashrefs;

    return $self->ok( 'Log' . ucfirst( $info->{tkind} ) );
}

1;
__END__

=head1 NAME

=for bif-doc #history

bif-log-topic - review a topic history

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif log topic ID [OPTIONS...]

=head1 DESCRIPTION

The B<bif-log-topic> command displays a topic history.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

A topic ID.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

