CREATE TABLE func_import_new_task(
    task_status_uuid VARCHAR(40) NOT NULL,
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_new_task_bi_1
BEFORE INSERT ON
    func_import_new_task
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.task_status_uuid,
        NEW.title,
        NEW.uuid
    );

    INSERT INTO
        func_new_task(
            change_id,
            id,
            task_status_id,
            title,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('nodes'),
        ts.id,
        NEW.title,
        NEW.uuid
    FROM
        nodes ts
    WHERE
        ts.uuid = NEW.task_status_uuid
    ;

    SELECT RAISE(IGNORE);
END;
