CREATE TABLE func_new_hub_repo(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    hub_id INTEGER NOT NULL,
    location VARCHAR NOT NULL,
    uuid VARCHAR(40)
);

CREATE TRIGGER
    func_new_hub_repo_bi_1
BEFORE INSERT ON
    func_new_hub_repo
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.hub_id,
        NEW.location,
        NEW.uuid
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_hub_repo' || x'0A'
                || '  hub_uuid: ' || h.uuid || x'0A'
                || CASE WHEN
                    instr(NEW.location, ' ')
                THEN
                    '  location: ''' || NEW.location || '''' || x'0A'
                ELSE
                    '  location: ' || NEW.location || x'0A'
                END
            FROM
                topics h
            WHERE
                h.id = NEW.hub_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_topic2(
        id,
        change_id,
        kind,
        uuid
    )
    VALUES(
        NEW.id,
        NEW.change_id,
        'hub_repo',
        NEW.uuid
    );


    INSERT INTO
        hub_repos(
            id,
            hub_id,
            location
        )
    VALUES(
        NEW.id,
        NEW.hub_id,
        NEW.location
    );


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_hub_repo'
    );

    INSERT INTO
        hub_repo_deltas(
            id,
            change_id,
            hub_id,
            hub_repo_id,
            new,
            location
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.hub_id,
        NEW.id,
        1,
        NEW.location
    );

    SELECT RAISE(IGNORE);
END;
