package WebService::Mattermost::V4::API::Resource::Compliance::Report;

# ABSTRACT: Wrapped API methods for the compliance report API endpoints.

use Moo;
use Types::Standard 'Str';

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

has view_name => (is => 'ro', isa => Str, default => 'Compliance::Report');

################################################################################

around [ qw(get download) ] => sub {
    my $orig = shift;
    my $self = shift;
    my $id   = shift;

    return $self->validate_id($orig, $id, @_);
};

sub get {
    my $self = shift;
    my $id   = shift;

    return $self->_single_view_get({
        endpoint => 'reports/%s',
        ids      => [ $id ],
    });
}

sub download {
    my $self = shift;
    my $id   = shift;

    return $self->_single_view_get({
        view     => 'Binary',
        endpoint => 'reports/%s/download',
        ids      => [ $id ],
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Compliance::Report - Wrapped API methods for the compliance report API endpoints.

=head1 VERSION

version 0.29

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->compliance_report;

=head2 METHODS

=over 4

=item C<get()>

Get a compliance report by its ID.

    my $response = $resource->get('REPORT-ID-HERE');

=item C<download()>

Download a compliance report by its ID.

    my $response = $resource->download('REPORT-ID-HERE');

=back

=head1 SEE ALSO

=over 4

=item L<Official compliance documentation|https://api.mattermost.com/#tag/compliance>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
