# ABSTRACT: PONAPI - Perl implementation of {JSON:API} (http://jsonapi.org/) v1.0
package PONAPI::DAO::Request::Role::HasPage;

use Moose::Role;

has page => (
    traits   => [ 'Hash' ],
    is       => 'ro',
    isa      => 'HashRef',
    handles  => {
        "has_page" => 'count',
    },
);

sub _validate_page {
    my $self = shift;

    $self->has_page
        or $self->_bad_request( "`page` is missing values" );

    return;
}

no Moose::Role; 1;

__END__

=pod

=encoding UTF-8

=head1 NAME

PONAPI::DAO::Request::Role::HasPage - PONAPI - Perl implementation of {JSON:API} (http://jsonapi.org/) v1.0

=head1 VERSION

version 0.001001

=head1 AUTHOR

Mickey Nasriachi <mickey@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Mickey Nasriachi, Stevan Little, Brian Fraser.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
