# Descrip.MMS for perl5 on VMS
# Last revised 27-Feb-1998 by Charles Bailey  bailey@genetics.upenn.edu
#
#: This file uses MMS syntax, and can be processed using DEC's MMS product,
#: or the free MMK clone (available by ftp at ftp.spc.edu).  If you want to
#: a Unix-style MAKE tool, run this file through mms2make.pl, which should
#: be found in the same directory as this file.  (There should be a pre-made
#: copy of Makefile for VAXC in this directory to allow you to build perl.)
#:
#: Lines beginning with "#:" will be removed by mms2make.pl when converting
#: this file to MAKE syntax.
#:
#:	Usage:
#: Building with VAX C, on system without DEC C installed or with VAX C default:
#:	$ MMS
#: Building with VAX C, on system with DEC C installed as default C compiler:
#:	$ MMS /MACRO=("cc=CC/VAXC")
#: Building with DEC C, on system without VAX C installed or with DEC C default:
#:	$ MMS /MACRO=("decc=1")
#: Building with DEC C, on system with VAX C installed as default C compiler:
#:	$ MMS /MACRO=("decc=1","cc=CC/DECC")
#: Building with GNU C
#:	$ MMS /MACRO=("gnuc=1")
#: To each of the above, add /Macro="__AXP__=1" if building on an AXP,
#:                           /Macro="__DEBUG__=1" to build a debug version
#:                           (i.e. VMS debugger, not perl -D), and
#:                           /Macro="SOCKETSHR_SOCKETS=1" to include
#:                           SOCKETSHR socket support.
#:                           /Macro="DECC_SOCKETS=1" to include UCX (or
#:                           compatible) socket support
#:			     /Macro="OLDTHREADED=1" to compile with the old
#:			     pthreads API (VMS version 6.2 and previous)
#:                           /Macro="THREADED=1" to compile with full POSIX
#:                           threads. (VMS 7.0 and above)
#:                           /Macro="FAKETHREADED=1" to compile with the
#:                           fake threads package
#
#	tidy      -- purge files generated by executing this file
#	clean     -- remove all intermediate (e.g. object files, C files generated
#	             during build) files generated by executing this file,
#	             but leave `installable' files (images, library) intact
#	realclean -- remove all files generated by executing this file
#	cleansrc  -- `realclean' + purge *.c,*.h,descrip.mms
#	crtl.opt  -- compiler-specific linker options file (made automatically)
#

#### Start of system configuration section. ####


#: >>>>> Architecture-specific options <<<<<
.ifdef AXE
# File type to use for object files
O = .abj
# File type to use for object libraries
OLB = .alb
# File type to use for executable images
E = .axe
.else
# File type to use for object files
O = .obj
# File type to use for object libraries
OLB = .olb
# File type to use for executable images
E = .exe
.endif

.ifdef __AXP__
DECC = 1
ARCH = VMS_AXP
OBJVAL = $(O)
.else
ARCH = VMS_VAX
OBJVAL = $(MMS$TARGET_NAME)$(O)
.endif

# Updated by fndvers.com -- do not edit by hand
PERL_VERSION = 5_00463#

.ifdef DECC_SOCKETS
SOCKET=1
.endif

.ifdef SOCKETSHR_SOCKETS
SOCKET=1
.endif

# If they defined SOCKET but didn't choose a stack, default to SOCKETSHR
.ifdef DECC_SOCKETS
.else
.ifdef SOCKETSHR_SOCKETS
.else
.ifdef SOCKET
SOCKETSHR_SOCKETS=1
.endif
.endif
.endif


ARCHDIR =  [.lib.$(ARCH).$(PERL_VERSION)]
ARCHCORE = [.lib.$(ARCH).$(PERL_VERSION).CORE]
ARCHAUTO = [.lib.$(ARCH).$(PERL_VERSION).auto]


#: Backwards compatibility
.ifdef DECC_PIPES_BROKEN
PIPES_BROKEN = 1
.endif

.ifdef __DEBUG__
NOX2P = 1
.endif

#: >>>>>Compiler-specific options <<<<<
.ifdef GNUC
.first
	@ @[.vms]fndvers.com "" "" "[.vms]descrip.mms"
	@ If F$TrnLnm("Sys").eqs."" Then Define/NoLog SYS GNU_CC_Include:[VMS]
CC = gcc
PIPES_BROKEN = 1
# -fno-builtin avoids bug in gcc up to version 2.6.2 which can destroy
# data when memcpy() is called on large (>64 kB) blocks of memory
# (fixed in gcc 2.6.3)
XTRACCFLAGS = /Obj=$(MMS$TARGET_NAME)$(O)/NoCase_Hack/Optimize=2
DBGSPECFLAGS =
XTRADEF = ,GNUC_ATTRIBUTE_CHECK
XTRAOBJS =
LIBS1 = GNU_CC:[000000]GCCLIB.OLB/Library
LIBS2 = Sys$Share:VAXCRTL/Shareable
POSIX =
.else
XTRAOBJS = 
LIBS1 = $(XTRAOBJS)
DBGSPECFLAGS = /Show=All
.ifdef decc
# Some versions of DECCRTL on AXP have a bug in chdir() which causes the change
# to persist after the image exits, even when this was not requested, iff
# SYSNAM is enabled.  This is fixed in CSC Patch # AXPACRT04_061, but turning
# off SYSNAM for the MM[SK] subprocess doesn't hurt anything, so we do it
# just in case.
.first
	@ Set Process/Privilege=(NoSYSNAM)
	@ @[.vms]fndvers.com "" "" "[.vms]descrip.mms"
	@ If F$TrnLnm("Sys").eqs."" .and. F$TrnLnm("DECC$System_Include").nes."" Then Define/NoLog SYS DECC$System_Include
.ifdef __AXP__
	@ If F$TrnLnm("Sys").eqs."" .and. F$TrnLnm("DECC$System_Include").eqs."" Then Define/NoLog SYS Sys$Library
.else
	@ If F$TrnLnm("Sys").eqs."" .and. F$TrnLnm("DECC$System_Include").eqs."" Then Define/NoLog SYS DECC$Library_Include
.endif

LIBS2 = 
XTRACCFLAGS = /Include=[]/Standard=Relaxed_ANSI/Prefix=All/Obj=$(OBJVAL)
XTRADEF =
POSIX = POSIX
.else # VAXC
.first
	@ @[.vms]fndvers.com "" "" "[.vms]descrip.mms"
	@ If F$TrnLnm("Sys").eqs."" .and. F$TrnLnm("VAXC$Include").eqs."" Then Define/NoLog SYS Sys$Library
	@ If F$TrnLnm("Sys").eqs."" .and. F$TrnLnm("VAXC$Include").nes."" Then Define/NoLog SYS VAXC$Include

XTRACCFLAGS = /Include=[]/Object=$(O)
XTRADEF =
LIBS2 = Sys$Share:VAXCRTL/Shareable
POSIX =
.endif
.endif


#: >>>>> Configuration options <<<<<
#: __DEBUG__: builds images with full VMS debugger support
.ifdef __DEBUG__
DBGCCFLAGS = /List/Debug/NoOpt$(DBGSPECFLAGS)
DBGLINKFLAGS = /Trace/Debug/Map/Full/Cross
DBG = DBG
.else
DBGCCFLAGS = /NoList
DBGLINKFLAGS = /NoTrace/NoMap
DBG = 
.endif

#: SOCKET: build in support for TCP/IP sockets
#: By default, used SOCKETSHR library; see ReadMe.VMS
#: for information on changing socket support
.ifdef SOCKET
.ifdef DECC_SOCKETS
SOCKDEF = ,VMS_DO_SOCKETS,DECCRTL_SOCKETS
SOCKLIB = 
.else
SOCKDEF = ,VMS_DO_SOCKETS
SOCKLIB = SocketShr/Share
.endif
# N.B. the targets for $(SOCKC) and $(SOCKH) assume that the permanent
# copies live in [.vms], and the `clean' target will delete copies of
# these files in the current default directory.
SOCKC = sockadapt.c
SOCKH = sockadapt.h
SOCKCLIS = ,$(SOCKC)
SOCKHLIS = ,$(SOCKH)
SOCKOBJ = ,sockadapt$(O)
SOCKPM = [.lib]Socket.pm
.else
SOCKDEF =
SOCKLIB =
SOCKC =
SOCKH =
SOCKCLIS =
SOCKHLIS =
SOCKOBJ =
SOCKPM =
.endif

THREAD = 

.ifdef THREADED
THREADDEF = ,USE_THREADS,MULTIPLICITY
THREAD = THREAD
.endif

.ifdef OLDTHREADED
THREADDEF = ,USE_THREADS,MULTIPLICITY,OLD_PTHREADS_API
THREAD = THREAD
LIBS2 = sys$share:cma$lib_shr/share,cma$rtl/share
.ifdef __AXP__
LIBS2 = $(LIBS2),sys$share:cma$open_lib_shr/share,cma$open_rtl/share
.endif
.endif

.ifdef FAKETHREADED
THREADDEF = ,USE_THREADS,MULTIPLICITY,FAKE_THREADS
THREADH = fakethr.h
acth = $(ARCHCORE)fakethr.h
THREAD = THREAD
.else
THREADH =
acth =
.endif

# C preprocessor manifest "DEBUGGING" ==> perl -D, not the VMS debugger
CFLAGS = /Define=(DEBUGGING$(SOCKDEF)$(XTRADEF)$(THREADDEF))$(XTRACCFLAGS)$(DBGCCFLAGS)
LINKFLAGS = $(DBGLINKFLAGS)

MAKE = $(MMS)
MAKEFILE = [.VMS]Descrip.MMS   # this file
NOOP = continue

# Macros to invoke a copy of miniperl during the build.  Targets which
# are built using these macros should depend on $(MINIPERL_EXE)
MINIPERL_EXE = Sys$Disk:[]miniperl$(E)
MINIPERL = MCR $(MINIPERL_EXE) "-I[.lib]"
XSUBPP = $(MINIPERL) [.lib.extutils]xsubpp -noprototypes
# Macro to invoke a preexisting copy of Perl.  This is used to regenerate
# some header files when rebuilding Perl, but premade versions are provided
# in the distribution, so it's OK if this doesn't work; it's here to make
# life easier for those who modify Perl and rebuild it.
INSTPERL = perl

# Space-separated list of "static" extensions to build into perlshr (case counts).
MYEXT = DynaLoader
# object files for these extensions; the trailing comma is required if
# there are any object files specified
# These must be built separately, or you must add rules below to build them
myextobj = [.ext.dynaloader]dl_vms$(O),
#: We include the Socket extension by default if we're building with socket
#: support, since it's small and not really worth bothering to keep track
#: of separately.
.ifdef SOCKET
EXT = $(MYEXT) Socket
extobj = $(myextobj) [.ext.socket]socket$(O), 
.else
EXT = $(MYEXT)
extobj = $(myextobj)
.endif


#### End of system configuration section. ####


h1 = EXTERN.h, INTERN.h, XSUB.h, av.h, bytecode.h, byterun.h, config.h, cop.h, cv.h
h2 = embed.h, form.h, gv.h, handy.h, hv.h, keywords.h, mg.h, op.h, thread.h
h3 = opcode.h, patchlevel.h, perl.h, perly.h, pp.h, proto.h, regcomp.h
h4 = regexp.h, scope.h, sv.h, vmsish.h, util.h, perlio.h, perlsdio.h
h5 = embedvar.h, intrpvar.h, perlvars.h, thrdvar.h, atomic.h
h = $(h1), $(h2), $(h3), $(h4), $(h5) $(SOCKHLIS) $(THREADH)

c1 = av.c, scope.c, op.c, doop.c, doio.c, dump.c, hv.c, mg.c, universal.c, perlio.c
c2 = perl.c, perly.c, pp.c, pp_hot.c, pp_ctl.c, pp_sys.c, regcomp.c, regexec.c
c3 = gv.c, sv.c, taint.c, toke.c, util.c, deb.c, run.c, globals.c, vms.c, byterun.c $(SOCKCLIS)

c = $(c1), $(c2), $(c3), miniperlmain.c, perlmain.c, byteperl.c

obj1 = perl$(O), gv$(O), toke$(O), perly$(O), op$(O), regcomp$(O), dump$(O), util$(O), mg$(O), perlio$(O)
obj2 = hv$(O), av$(O), run$(O), pp_hot$(O), sv$(O), pp$(O), scope$(O), pp_ctl$(O), pp_sys$(O)
obj3 = doop$(O), doio$(O), regexec$(O), taint$(O), deb$(O), universal$(O), globals$(O), vms$(O), byterun$(O) $(SOCKOBJ)

obj = $(obj1), $(obj2), $(obj3)

ac1 = $(ARCHCORE)EXTERN.h $(ARCHCORE)INTERN.h  $(ARCHCORE)XSUB.h $(ARCHCORE)av.h
ac2 = $(ARCHCORE)config.h $(ARCHCORE)cop.h $(ARCHCORE)cv.h $(ARCHCORE)embed.h
ac3 = $(ARCHCORE)form.h $(ARCHCORE)gv.h $(ARCHCORE)handy.h $(ARCHCORE)hv.h
ac4 = $(ARCHCORE)keywords.h $(ARCHCORE)mg.h $(ARCHCORE)op.h $(ARCHCORE)opcode.h
ac5 = $(ARCHCORE)patchlevel.h $(ARCHCORE)perl.h $(ARCHCORE)perly.h $(ARCHCORE)thread.h
ac6 = $(ARCHCORE)perldir.h $(ARCHCORE)perlenv.h $(ARCHCORE)perllio.h $(ARCHCORE)atomic.h
ac7 = $(ARCHCORE)perlmem.h $(ARCHCORE)perlproc.h $(ARCHCORE)perlsock.h
ac8 = $(ARCHCORE)pp.h $(ARCHCORE)proto.h $(ARCHCORE)regcomp.h $(ARCHCORE)perlio.h $(ARCHCORE)perlsdio.h
ac9 = $(ARCHCORE)regexp.h $(ARCHCORE)scope.h $(ARCHCORE)sv.h $(ARCHCORE)util.h
ac10 = $(ARCHCORE)embedvar.h $(ARCHCORE)intrpvar.h $(ARCHCORE)perlvars.h $(ARCHCORE)thrdvar.h
ac11 = $(ARCHCORE)vmsish.h $(ARCHCORE)$(DBG)libperl$(OLB) $(ARCHCORE)perlshr_attr.opt
ac12 = $(ARCHCORE)$(DBG)perlshr_bld.opt $(ARCHCORE)bytecode.h $(ARCHCORE)byterun.h
.ifdef SOCKET
acs = $(ARCHCORE)$(SOCKH)
.else
acs =
.endif

CRTL = []crtl.opt
CRTLOPTS =,$(CRTL)/Options

.SUFFIXES

.ifdef LINK_ONLY
.else
.SUFFIXES $(O) .c .xs

.xs.c :
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)


.c$(O) :
	$(CC) $(CFLAGS) $(MMS$SOURCE)

.xs$(O) :
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$SOURCE_NAME).c
	$(CC) $(CFLAGS) $(MMS$SOURCE_NAME).c
.endif

# Modules which must be installed before we can build extensions
LIBPREREQ = $(ARCHDIR)Config.pm [.lib]DynaLoader.pm [.lib]vmsish.pm [.lib.VMS]Filespec.pm [.lib.ExtUtils]XSSymSet.pm

utils1 = [.lib.pod]perldoc.com [.lib.ExtUtils]Miniperl.pm [.utils]c2ph.com [.utils]h2ph.com [.utils]h2xs.com [.lib]perlbug.com
utils2 = [.lib]splain.com [.utils]pl2pm.com

.ifdef NOX2P
all : base extras archcorefiles preplibrary perlpods
	@ $(NOOP)
.else
all : base extras x2p archcorefiles preplibrary perlpods
	@ $(NOOP)
.endif
base : miniperl perl
	@ $(NOOP)
extras : Fcntl IO Opcode attrs B $(POSIX) $(THREAD) SDBM_File libmods utils podxform
	@ $(NOOP)
libmods : $(LIBPREREQ)
	@ $(NOOP)
utils : $(utils1) $(utils2)
	@ $(NOOP)
podxform : [.lib.pod]pod2text.com [.lib.pod]pod2html.com [.lib.pod]pod2latex.com [.lib.pod]pod2man.com
	@ $(NOOP)
x2p : [.x2p]a2p$(E) [.x2p]s2p.com [.x2p]find2perl.com 
	@ $(NOOP)

pod1 = [.lib.pod]perl.pod [.lib.pod]perlapio.pod [.lib.pod]perlbook.pod [.lib.pod]perlbot.pod [.lib.pod]perlcall.pod
pod2 = [.lib.pod]perldata.pod [.lib.pod]perldebug.pod [.lib.pod]perldelta.pod [.lib.pod]perldiag.pod [.lib.pod]perldsc.pod
pod3 = [.lib.pod]perlembed.pod [.lib.pod]perlform.pod [.lib.pod]perlfunc.pod [.lib.pod]perlguts.pod
pod4 = [.lib.pod]perlipc.pod [.lib.pod]perllocale.pod [.lib.pod]perllol.pod [.lib.pod]perlmod.pod [.lib.pod]perlobj.pod
pod5 = [.lib.pod]perlop.pod [.lib.pod]perlpod.pod [.lib.pod]perlre.pod [.lib.pod]perlref.pod [.lib.pod]perlrun.pod
pod6 = [.lib.pod]perlsec.pod [.lib.pod]perlstyle.pod [.lib.pod]perlsub.pod [.lib.pod]perlsyn.pod
pod7 = [.lib.pod]perltie.pod [.lib.pod]perltoc.pod [.lib.pod]perltoot.pod
pod8 = [.lib.pod]perltrap.pod [.lib.pod]perlvar.pod [.lib.pod]perlxs.pod [.lib.pod]perlxstut.pod

perlpods : $(pod1) $(pod2) $(pod3) $(pod4) $(pod5) $(pod6) $(pod7) $(pod8) [.lib.pod]perlvms.pod
	@ $(NOOP)

archcorefiles :  $(ac1) $(ac2) $(ac3) $(ac4) $(ac5) $(ac6) $(ac7) $(ac8) $(ac9) $(ac10) $(ac11) $(ac12) $(acs) $(acth) $(ARCHAUTO)time.stamp
	@ $(NOOP)

miniperl : $(DBG)miniperl$(E)
	@ Continue
$(MINIPERL_EXE) :  miniperlmain$(O), $(DBG)libperl$(OLB) $(CRTL)
	Link $(LINKFLAGS)/NoDebug/Trace/NoMap/NoFull/NoCross/Exe=$(MMS$TARGET) miniperlmain$(O), $(DBG)libperl$(OLB)/Library/Include=globals $(CRTLOPTS)
$(DBG)miniperl$(E) :  miniperlmain$(O), $(DBG)libperl$(OLB) $(CRTL)
	Link $(LINKFLAGS)/Trace/Exe=$(MMS$TARGET) miniperlmain$(O),$(DBG)libperl$(OLB)/Library/Include=globals  $(CRTLOPTS)

$(DBG)libperl$(OLB) : $(obj)
	@ If F$Search("$(MMS$TARGET)").eqs."" Then Library/Object/Create $(MMS$TARGET)
	Library/Object/Replace $(MMS$TARGET) $(obj1)
	Library/Object/Replace $(MMS$TARGET) $(obj2)
	Library/Object/Replace $(MMS$TARGET) $(obj3)

perlmain.c : miniperlmain.c $(MINIPERL_EXE) [.vms]writemain.pl
	$(MINIPERL) [.VMS]Writemain.pl "$(EXT)"

byteperl.c : [.ext.B]byteperl.c
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

.ifdef __DEBUG__
# Link an extra perl that doesn't invoke the debugger
perl : $(DBG)perl$(E) $(DBG)byteperl$(E)
	Link $(LINKFLAGS)/NoDebug/Trace/NoMap/NoCross/NoFull/Exe=N$(DBG)perl$(E) perlmain$(O), perlshr.opt/Option, perlshr_attr.opt/Option $(CRTLOPTS)
	Link $(LINKFLAGS)/NoDebug/Trace/NoMap/NoCross/NoFull/Exe=N$(DBG)byteperl$(E) byteperl$(O), perlshr.opt/Option, perlshr_attr.opt/Option $(CRTLOPTS)
.else
perl : $(DBG)perl$(E) $(DBG)byteperl$(E)
	@ Continue
.endif

$(DBG)perl$(E) : perlmain$(O), $(DBG)perlshr$(E), $(MINIPERL_EXE)
	@ @[.vms]genopt "PerlShr.Opt/Write" "|" "''F$Environment("Default")'$(DBG)PerlShr$(E)/Share"
	Link $(LINKFLAGS)/Exe=$(MMS$TARGET) perlmain$(O), perlshr.opt/Option, perlshr_attr.opt/Option $(CRTLOPTS)

$(DBG)byteperl$(E) : byteperl$(O), $(DBG)perlshr$(E), $(MINIPERL_EXE)
	@ @[.vms]genopt "PerlShr.Opt/Write" "|" "''F$Environment("Default")'$(DBG)PerlShr$(E)/Share"
	Link $(LINKFLAGS)/Exe=$(MMS$TARGET) byteperl$(O), perlshr.opt/Option, perlshr_attr.opt/Option $(CRTLOPTS)

$(DBG)perlshr$(E) : $(DBG)libperl$(OLB) $(extobj) $(DBG)perlshr_xtras.ts
	Link $(LINKFLAGS)/Share=$(MMS$TARGET) $(extobj) []$(DBG)perlshr_bld.opt/Option, perlshr_attr.opt/Option

# The following files are built in one go by gen_shrfls.pl:
#  perlshr_attr.opt, $(DBG)perlshr_bld.opt - VAX and AXP
#  perlshr_gbl*.mar, perlshr_gbl*$(O) - VAX only
# The song and dance with gen_shrfls.opt accomodates DCL's 255 character
# line length limit.
.ifdef PIPES_BROKEN
# This is a backup target used only with older versions of the DECCRTL which
# can't deal with pipes properly.  See ReadMe.VMS for details.
$(DBG)perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl $(MINIPERL_EXE) $(MAKEFILE) $(CRTL)
	$(CC) $(CFLAGS)/NoObject/NoList/PreProcess=perl.i perl.h
	@ $(MINIPERL) -e "print join('|',@ARGV),'|';" "~~NOCC~~perl.i~~$(CC)$(CFLAGS)" >gen_shrfls.opt
	@ $(MINIPERL) -e "print join('|',@ARGV);" "$(O)" "$(DBG)" "$(OLB)" "$(EXT)" "$(CRTL)" >>gen_shrfls.opt
	$(MINIPERL) [.vms]gen_shrfls.pl -f gen_shrfls.opt
	@ Delete/NoLog/NoConfirm perl.i;, gen_shrfls.opt;
	@ If F$Search("$(DBG)perlshr_xtras.ts").nes."" Then Delete/NoLog/NoConfirm $(DBG)perlshr_xtras.ts;*
	@ Copy _NLA0: $(DBG)perlshr_xtras.ts
.else
$(DBG)perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl $(MINIPERL_EXE) $(MAKEFILE) $(CRTL)
	@ $(MINIPERL) -e "print join('|',@ARGV),'|';" "$(CC)$(CFLAGS)" >gen_shrfls.opt
	@ $(MINIPERL) -e "print join('|',@ARGV);" "$(O)" "$(DBG)" "$(OLB)" "$(EXT)" "$(CRTL)" >>gen_shrfls.opt
	$(MINIPERL) [.vms]gen_shrfls.pl -f gen_shrfls.opt
	@ Delete/NoLog/NoConfirm gen_shrfls.opt;
	@ If F$Search("$(DBG)perlshr_xtras.ts").nes."" Then Delete/NoLog/NoConfirm $(DBG)perlshr_xtras.ts;*
	@ Copy _NLA0: $(DBG)perlshr_xtras.ts
.endif

$(ARCHDIR)config.pm : [.lib]config.pm
	Create/Directory $(ARCHDIR)
	Copy $(MMS$SOURCE) $(MMS$TARGET)

# Once again, we accomodate DCL's 255 character buffer
[.lib]config.pm : [.vms]config.vms [.vms]genconfig.pl $(MINIPERL_EXE)
	@ $(MINIPERL) -e "print join('|',@ARGV),'|';" "cc=$(CC)$(CFLAGS)" >genconfig.opt
	@ $(MINIPERL) -e "print join('|',@ARGV),'|';" "ldflags=$(LINKFLAGS)|obj_ext=$(O)|exe_ext=$(E)|lib_ext=$(OLB)|dbgprefix=$(DBG)" >>genconfig.opt
	$(MINIPERL) [.VMS]GenConfig.Pl -f genconfig.opt
	@ Delete/NoLog/NoConfirm genconfig.opt;
	$(MINIPERL) ConfigPM.

[.ext.dynaloader]dl_vms.c : [.ext.dynaloader]dl_vms.xs [.lib.ExtUtils]XSSymSet.pm $(MINIPERL_EXE)
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)

[.ext.dynaloader]dl_vms$(O) : [.ext.dynaloader]dl_vms.c
	$(CC) $(CFLAGS) /Include=([],[.ext.dynaloader])/Object=$(MMS$TARGET) $(MMS$SOURCE)

[.lib]DynaLoader.pm : [.ext.dynaloader]dynaloader.pm
	Copy/Log/NoConfirm [.ext.dynaloader]dynaloader.pm [.lib]DynaLoader.pm
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ $(MINIPERL) -e "use AutoSplit; autosplit_lib_modules(@ARGV)" [.lib]DynaLoader.pm

Opcode : [.lib]Opcode.pm [.lib]ops.pm [.lib]Safe.pm [.lib.auto.Opcode]Opcode$(E)
	@ $(NOOP)

[.lib]Opcode.pm : [.ext.Opcode]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.Opcode]
	$(MMS)
	@ Set Default [--]

[.lib]ops.pm : [.ext.Opcode]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.Opcode]
	$(MMS)
	@ Set Default [--]

[.lib]Safe.pm : [.ext.Opcode]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.Opcode]
	$(MMS)
	@ Set Default [--]

[.lib.auto.Opcode]Opcode$(E) : [.ext.Opcode]Descrip.MMS
	@ Set Default [.ext.Opcode]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.Opcode]Descrip.MMS : [.ext.Opcode]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.Opcode]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

Fcntl : [.lib]Fcntl.pm [.lib.auto.Fcntl]Fcntl$(E)
	@ $(NOOP)

[.lib]Fcntl.pm : [.ext.Fcntl]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.Fcntl]
	$(MMS)
	@ Set Default [--]

[.lib.auto.Fcntl]Fcntl$(E) : [.ext.Fcntl]Descrip.MMS
	@ Set Default [.ext.Fcntl]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.Fcntl]Descrip.MMS : [.ext.Fcntl]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.Fcntl]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

attrs : [.lib]attrs.pm [.lib.auto.attrs]attrs$(E)
	@ $(NOOP)

[.lib]attrs.pm : [.ext.attrs]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.attrs]
	$(MMS)
	@ Set Default [--]

[.lib.auto.attrs]attrs$(E) : [.ext.attrs]Descrip.MMS
	@ Set Default [.ext.attrs]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.attrs]Descrip.MMS : [.ext.Fcntl]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.attrs]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

POSIX : [.lib]POSIX.pm [.lib.auto.POSIX]POSIX$(E)
	@ $(NOOP)

[.lib]POSIX.pm : [.ext.POSIX]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.POSIX]
	$(MMS)
	@ Set Default [--]

[.lib.auto.POSIX]POSIX$(E) : [.ext.POSIX]Descrip.MMS
	@ Set Default [.ext.POSIX]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.POSIX]Descrip.MMS : [.ext.POSIX]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.POSIX]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

THREAD : [.lib]THREAD.pm [.lib.auto.THREAD]THREAD$(E)
	@ $(NOOP)

[.lib]THREAD.pm : [.ext.THREAD]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.THREAD]
	$(MMS)
	@ Set Default [--]

[.lib.auto.THREAD]THREAD$(E) : [.ext.THREAD]Descrip.MMS
	@ Set Default [.ext.THREAD]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.THREAD]Descrip.MMS : [.ext.THREAD]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.THREAD]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

SDBM_File : [.lib]SDBM_File.pm [.lib.auto.SDBM_File]SDBM_File$(E) 
	@ $(NOOP)

[.lib]SDBM_File.pm : [.ext.SDBM_File]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ If F$Search("[.lib.auto]sdbm.dir").eqs."" Then Create/Directory [.lib.auto.sdbm]
	@ Set Default [.ext.SDBM_File]
	$(MMS)
	@ Set Default [--]

[.lib.auto.SDBM_File]SDBM_File$(E) : [.ext.SDBM_File]Descrip.MMS
	@ Set Default [.ext.SDBM_File]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.SDBM_File]Descrip.MMS : [.ext.SDBM_File]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.SDBM_File]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

IO : [.lib]IO.pm [.lib.IO]File.pm [.lib.IO]Handle.pm [.lib.IO]Pipe.pm [.lib.IO]Seekable.pm [.lib.IO]Socket.pm [.lib.auto.IO]IO$(E)
	@ $(NOOP)

[.lib]IO.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.IO]File.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.IO]Handle.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.IO]Pipe.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.IO]Seekable.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.IO]Socket.pm : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

[.lib.auto.IO]IO$(E) : [.ext.IO]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.IO]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.IO]Descrip.MMS : [.ext.IO]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.IO]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

B : [.lib]B.pm [.lib]O.pm [.lib.B]Asmdata.pm [.lib.B]Assembler.pm [.lib.B]Bblock.pm [.lib.B]Bytecode.pm [.lib.B]C.pm [.lib.B]CC.pm [.lib.B]Debug.pm [.lib.B]Deparse.pm [.lib.B]Disassembler.pm [.lib.B]Lint.pm [.lib.B]Showlex.pm [.lib.B]Stackobj.pm [.lib.B]Terse.pm [.lib.B]Xref.pm [.lib.auto.B]B$(E)
	@ $(NOOP)

[.lib]B.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib]O.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Asmdata.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Assembler.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Bblock.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Bytecode.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]C.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]CC.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Debug.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Deparse.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Disassembler.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Lint.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Showlex.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Stackobj.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Terse.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.B]Xref.pm : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

[.lib.auto.B]B$(E) : [.ext.B]Descrip.MMS
	@ If F$Search("[.lib]auto.dir").eqs."" Then Create/Directory [.lib.auto]
	@ Set Default [.ext.B]
	$(MMS)
	@ Set Default [--]

# Add "-I[--.lib]" t $(MINIPERL) so we use this copy of lib after C<chdir>
# ${@} necessary to distract different versions of MM[SK]/make
[.ext.B]Descrip.MMS : [.ext.B]Makefile.PL $(LIBPREREQ) $(DBG)perlshr$(E)
	$(MINIPERL) "-I[--.lib]" -e "chdir('[.ext.B]') or die $!; do 'Makefile.PL'; print ${@} if ${@};" "INST_LIB=[--.lib]" "INST_ARCHLIB=[--.lib]"

[.lib]vmsish.pm : [.vms.ext]vmsish.pm
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

[.lib.VMS]Filespec.pm : [.vms.ext]Filespec.pm
	@ If F$Search("[.lib]VMS.Dir").eqs."" Then Create/Directory [.lib.VMS]
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

[.lib.ExtUtils]XSSymSet.pm : [.vms.ext]XSSymSet.pm
	@ If F$Search("[.lib]VMS.Dir").eqs."" Then Create/Directory [.lib.VMS]
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldoc.com : [.utils]perldoc.PL $(ARCHDIR)Config.pm
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	$(MINIPERL) $(MMS$SOURCE)
	Copy/Log [.utils]perldoc.com $(MMS$TARGET)

[.lib.ExtUtils]Miniperl.pm : Minimod.PL miniperlmain.c $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE) >$(MMS$TARGET)

[.utils]c2ph.com : [.utils]c2ph.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

[.utils]h2ph.com : [.utils]h2ph.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

[.utils]h2xs.com : [.utils]h2xs.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

[.lib]perlbug.com : [.utils]perlbug.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.utils]perlbug.com $(MMS$TARGET)

[.utils]pl2pm.com : [.utils]pl2pm.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

[.lib]splain.com : [.utils]splain.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.utils]splain.com $(MMS$TARGET)

[.x2p]find2perl.com : [.x2p]find2perl.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

[.x2p]s2p.com : [.x2p]s2p.PL $(ARCHDIR)Config.pm
	$(MINIPERL) $(MMS$SOURCE)

# Rename catches problem with some DECC versions in which object file is
# placed in current default dir, not same one as source file.
[.x2p]$(DBG)a2p$(E) : [.x2p]a2p$(O), [.x2p]hash$(O), [.x2p]str$(O), [.x2p]util$(O), [.x2p]walk$(O)
	@ If F$Search("hash$(O)").nes."" Then Rename/NoLog hash$(O),str$(O),util$(O),walk$(O) [.x2p]
	Link $(LINKFLAGS) /Exe=$(MMS$TARGET) $(MMS$SOURCE_LIST) $(CRTLOPTS)

# Accomodate buggy cpp in some version of DECC, which chokes on illegal
# filespec "y.tab.c", and broken gcc cpp, which doesn't start #include ""
# search in same dir as source file
[.x2p]a2p$(O) : [.x2p]a2p.c $(MINIPERL_EXE)
	$(MINIPERL) -pe "s/^#line\s+(\d+)\s+\Q""y.tab.c""/#line $1 ""y_tab.c""/;" $(MMS$SOURCE) >$(MMS$TARGET_NAME)_vms.c
	$(CC) $(CFLAGS) /Object=$(MMS$TARGET)/Include=([.x2p],[]) $(MMS$TARGET_NAME)_vms.c
	Delete/Log/NoConfirm $(MMS$TARGET_NAME)_vms.c;

# gcc cpp broken -- doesn't look in directory of source file for #include ""
.ifdef GNUC
[.x2p]hash$(O) : [.x2p]hash.c
	$(CC) $(CFLAGS) /Include=[.x2p] $(MMS$SOURCE)

[.x2p]str$(O) : [.x2p]str.c
	$(CC) $(CFLAGS) /Include=[.x2p] $(MMS$SOURCE)

[.x2p]util$(O) : [.x2p]util.c
	$(CC) $(CFLAGS) /Include=[.x2p] $(MMS$SOURCE)

[.x2p]walk$(O) : [.x2p]walk.c
	$(CC) $(CFLAGS) /Include=[.x2p] $(MMS$SOURCE)
.endif

[.lib.pod]pod2html.com : [.pod]pod2html.PL $(ARCHDIR)Config.pm
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.pod]pod2html.com $(MMS$TARGET)

[.lib.pod]pod2latex.com : [.pod]pod2latex.PL $(ARCHDIR)Config.pm
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.pod]pod2latex.com $(MMS$TARGET)

[.lib.pod]pod2man.com : [.pod]pod2man.PL $(ARCHDIR)Config.pm
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.pod]pod2man.com $(MMS$TARGET)

[.lib.pod]pod2text.com : [.pod]pod2text.PL $(ARCHDIR)Config.pm
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	$(MINIPERL) $(MMS$SOURCE)
	Rename/Log [.pod]pod2text.com $(MMS$TARGET)

preplibrary : $(MINIPERL_EXE) $(LIBPREREQ) $(SOCKPM)
	@ Write Sys$Output "Autosplitting Perl library . . ."
	@ Create/Directory [.lib.auto]
	@ $(MINIPERL) -e "use AutoSplit; autosplit_lib_modules(@ARGV)" [.lib]*.pm [.lib.*]*.pm

[.lib.pod]perl.pod : [.pod]perl.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlapio.pod : [.pod]perlapio.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlbook.pod : [.pod]perlbook.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlbot.pod : [.pod]perlbot.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlcall.pod : [.pod]perlcall.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldata.pod : [.pod]perldata.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldebug.pod : [.pod]perldebug.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldelta.pod : [.pod]perldelta.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldiag.pod : [.pod]perldiag.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perldsc.pod : [.pod]perldsc.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlembed.pod : [.pod]perlembed.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlform.pod : [.pod]perlform.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlfunc.pod : [.pod]perlfunc.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlguts.pod : [.pod]perlguts.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perllocale.pod : [.pod]perllocale.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlipc.pod : [.pod]perlipc.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perllol.pod : [.pod]perllol.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlmod.pod : [.pod]perlmod.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlobj.pod : [.pod]perlobj.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlop.pod : [.pod]perlop.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlpod.pod : [.pod]perlpod.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlre.pod : [.pod]perlre.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlref.pod : [.pod]perlref.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlrun.pod : [.pod]perlrun.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlsec.pod : [.pod]perlsec.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlstyle.pod : [.pod]perlstyle.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlsub.pod : [.pod]perlsub.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlsyn.pod : [.pod]perlsyn.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perltie.pod : [.pod]perltie.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perltoc.pod : [.pod]perltoc.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perltoot.pod : [.pod]perltoot.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perltrap.pod : [.pod]perltrap.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlvar.pod : [.pod]perlvar.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlxs.pod : [.pod]perlxs.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlxstut.pod : [.pod]perlxstut.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

[.lib.pod]perlvms.pod : [.vms]perlvms.pod
	@ If F$Search("[.lib]pod.dir").eqs."" Then Create/Directory [.lib.pod]
	@ Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

printconfig :
        @ @[.vms]make_command $(MMS) $(MMSQUALIFIERS) $(MMSTARGETS)
        @ @[.vms]myconfig "$(CC)" "$(CFLAGS)" "$(LINKFLAGS)" "$(LIBS1)" "$(LIBS2)" "$(SOCKLIB)" "$(EXT)" "$(DBG)"

.ifdef SOCKET

.ifdef LINK_ONLY
.else
[.ext.Socket]Socket$(O) : [.ext.Socket]Socket.c
	$(CC) $(CFLAGS) /Object=$(MMS$TARGET) $(MMS$SOURCE)

[.ext.Socket]Socket.c : [.ext.Socket]Socket.xs [.lib.ExtUtils]XSSymSet.pm $(MINIPERL_EXE)
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)
.endif # !LINK_ONLY

vmsish.h : $(SOCKH)

$(SOCKOBJ) : $(SOCKC) EXTERN.h perl.h config.h embed.h perlio.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h

$(SOCKC) : [.vms]$(SOCKC)
	Copy/Log/NoConfirm [.vms]$(SOCKC) []$(SOCKC)

$(SOCKH) : [.vms]$(SOCKH)
	Copy/Log/NoConfirm [.vms]$(SOCKH) []$(SOCKH)

[.lib]Socket.pm : [.ext.Socket]Socket.pm
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)
.endif

# The following three header files are generated automatically
#	keywords.h :	keywords.pl
#	opcode.h :	opcode.pl
#	embed.h :	embed.pl global.sym interp.sym
# The correct versions should be already supplied with the perl kit,
# in case you don't have perl available.
# To force them to run, type
#	MMS regen_headers
regen_headers :
	$(INSTPERL) keywords.pl
	$(INSTPERL) opcode.pl
	$(INSTPERL) embed.pl

# VMS uses modified perly.[ch] with tags for globaldefs if using DEC compiler
perly.c : [.vms]perly_c.vms
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
perly.h : [.vms]perly_h.vms
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)

# I now supply perly.c with the kits, so the following section is
# commented out if you don't have byacc.
# Altered for VMS by Charles Bailey  bailey@genetics.upenn.edu
# perly.c:
# 	@ Write Sys$Output "Expect 80 shift/reduce and 62 reduce/reduce conflicts"
# 	\$(BYACC) -d perly.y
# Has to be done by hand or by POSIX shell under VMS
# 	sh \$(shellflags) ./perly.fixer y.tab.c perly.c
# 	rename y.tab.h perly.h
# 	$(INSTPERL) [.vms]vms_yfix.pl perly.c perly.h [.vms]perly_c.vms [.vms]perly_h.vms

.ifdef LINK_ONLY
.else
perly$(O) : perly.c, perly.h, $(h)
	$(CC) $(CFLAGS) $(MMS$SOURCE)
.endif

[.t.lib]vmsfspec.t : [.vms.ext]filespec.t
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

[.t.lib]vmsish.t : [.vms.ext]vmsish.t
	Copy/Log/NoConfirm $(MMS$SOURCE) $(MMS$TARGET)

test : all [.t.lib]vmsfspec.t [.t.lib]vmsish.t
	- @[.VMS]Test.Com "$(E)"

archify : all
	@ Write Sys$Output "Moving files to architecture-specific locations for $(ARCH)"
	archroot = "$(ARCHAUTO)" - "]" + "...]"
	Backup/Log/Verify [.lib.auto...]*.*;/Exclude=(*.al,*.ix) 'archroot'/New_Version
	Delete/Log/NoConfirm [.lib.auto...]*.*;*/exclude=(*.al,*.ix,*.dir)
	Delete/Log/NoConfirm [.lib]Config.pm;*
	Copy/Log/NoConfirm *$(E);,[.x2p]a2p$(E); $(ARCHDIR)
	Delete/Log/NoConfirm Perl*$(E);*,[.x2p]a2p$(E);*
	@ Write Sys$Output "Architecture-specific setup completed."
	@ Write Sys$Output "Before building for another architecture, be sure to"
	@ Write Sys$Output "    1. $(MMS)$(MMSQUALIFIERS) clean"
	@ Write Sys$Output "    2. Delete Miniperl$(E)"

# CORE subset for MakeMaker, so we can build Perl without sources
# Should move to VMS installperl when we get one
$(ARCHCORE)EXTERN.h : EXTERN.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)INTERN.h : INTERN.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)XSUB.h : XSUB.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)bytecode.h : bytecode.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)byterun.h : byterun.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)atomic.h : atomic.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)av.h : av.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)config.h : config.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)cop.h : cop.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)cv.h : cv.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)embed.h : embed.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)embedvar.h : embedvar.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.ifdef FAKETHREADED
$(ARCHCORE)fakethr.h : fakethr.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.endif
$(ARCHCORE)form.h : form.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)gv.h : gv.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)handy.h : handy.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)hv.h : hv.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)intrpvar.h : intrpvar.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)keywords.h : keywords.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)mg.h : mg.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)op.h : op.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)opcode.h : opcode.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)patchlevel.h : patchlevel.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perl.h : perl.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perldir.h : perldir.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlenv.h : perlenv.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlio.h : perlio.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perllio.h : perllio.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlmem.h : perlmem.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlproc.h : perlproc.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlsdio.h : perlsdio.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlsock.h : perlsock.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlvars.h : perlvars.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perly.h : perly.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)pp.h : pp.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)proto.h : proto.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)regcomp.h : regcomp.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)regexp.h : regexp.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)scope.h : scope.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)sv.h : sv.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)thrdvar.h : thrdvar.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)thread.h : thread.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)util.h : util.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)vmsish.h : vmsish.h
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.ifdef SOCKET
$(ARCHCORE)$(SOCKH) : $(SOCKH)
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
.endif
$(ARCHCORE)$(DBG)libperl$(OLB) : $(DBG)libperl$(OLB) $(DBG)perlshr_xtras.ts
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(MMS$SOURCE) $(MMS$TARGET)
$(ARCHCORE)perlshr_attr.opt : $(DBG)perlshr_xtras.ts
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log perlshr_attr.opt $(MMS$TARGET)
$(ARCHCORE)$(DBG)perlshr_bld.opt : $(DBG)perlshr_xtras.ts
	@ If F$Search("$(ARCHDIR)CORE.dir").eqs."" Then Create/Directory $(ARCHCORE)
	Copy/Log $(DBG)perlshr_bld.opt $(MMS$TARGET)
$(ARCHAUTO)time.stamp :
	@ If F$Search("$(ARCHDIR)auto.dir").eqs."" Then Create/Directory $(ARCHAUTO)
	@ If F$Search("$(MMS$TARGET)").eqs."" Then Copy/NoConfirm _NLA0: $(MMS$TARGET)

.ifdef LINK_ONLY
.else
# We need an action line here for broken older versions of MMS which
# otherwise conclude that they should be compiling [.x2p]utils.c :-(
util$(O) : util.c
	$(CC) $(CFLAGS) util.c
# AUTOMATICALLY GENERATED MAKE DEPENDENCIES--PUT NOTHING BELOW THIS LINE
av$(O) : av.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
byterun$(O) : byterun.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
deb$(O) : deb.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
doio$(O) : doio.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
doop$(O) : doop.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
dump$(O) : dump.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
globals$(O) : globals.c INTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
gv$(O) : gv.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
hv$(O) : hv.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
malloc$(O) : malloc.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
mg$(O) : mg.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
miniperlmain$(O) : miniperlmain.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
op$(O) : op.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
perl$(O) : perl.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h patchlevel.h
perlio$(O) : perlio.c config.h EXTERN.h perl.h bytecode.h byterun.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
perlmain$(O) : perlmain.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
byteperl$(O) : byteperl.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
perly$(O) : perly.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
pp$(O) : pp.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
pp_ctl$(O) : pp_ctl.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
pp_hot$(O) : pp_hot.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
pp_sys$(O) : pp_sys.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
regcomp$(O) : regcomp.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h INTERN.h regcomp.h
regexec$(O) : regexec.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h regcomp.h
run$(O) : run.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
scope$(O) : scope.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
sv$(O) : sv.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
taint$(O) : taint.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
toke$(O) : toke.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h keywords.h
universal$(O) : universal.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h XSUB.h
util$(O) : util.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h
vms$(O) : vms.c EXTERN.h perl.h bytecode.h byterun.h config.h embed.h perlio.h perldir.h perlenv.h perllio.h perlmem.h perlproc.h perlsock.h perlsdio.h handy.h vmsish.h regexp.h sv.h util.h form.h gv.h cv.h opcode.h op.h cop.h av.h hv.h mg.h scope.h perly.h thread.h pp.h proto.h embedvar.h perlvars.h thrdvar.h intrpvar.h XSUB.h
[.x2p]a2p$(O) : [.x2p]a2p.c [.x2p]a2py.c [.x2p]INTERN.h [.x2p]a2p.h [.x2p]hash.h [.x2p]str.h config.h handy.h
[.x2p]hash$(O) : [.x2p]hash.c [.x2p]EXTERN.h [.x2p]a2p.h [.x2p]hash.h [.x2p]str.h [.x2p]util.h config.h handy.h
[.x2p]str$(O) : [.x2p]str.c [.x2p]EXTERN.h [.x2p]a2p.h [.x2p]hash.h [.x2p]str.h [.x2p]util.h config.h handy.h
[.x2p]util$(O) : [.x2p]util.c [.x2p]EXTERN.h [.x2p]INTERN.h [.x2p]a2p.h [.x2p]hash.h [.x2p]str.h [.x2p]util.h config.h handy.h
[.x2p]walk$(O) : [.x2p]walk.c [.x2p]EXTERN.h [.x2p]a2p.h [.x2p]hash.h [.x2p]str.h [.x2p]util.h config.h handy.h
# End of automatically generated make dependencies
.endif # !LINK_ONLY

config.h : [.vms]config.vms
	Copy/Log/NoConfirm [.vms]config.vms []config.h

vmsish.h : [.vms]vmsish.h
	Copy/Log/NoConfirm [.vms]vmsish.h []vmsish.h

vms.c : [.vms]vms.c
	Copy/Log/Noconfirm [.vms]vms.c []

$(CRTL) : $(MAKEFILE)
	@ @[.vms]genopt "$(CRTL)/Write" "|" "$(LIBS1)|$(LIBS2)|$(SOCKLIB)"


cleanlis :
	- If F$Search("*.Lis").nes."" Then Delete/NoConfirm/Log *.Lis;*
	- If F$Search("*.CPP").nes."" Then Delete/NoConfirm/Log *.CPP;*
	- If F$Search("*.Map").nes."" Then Delete/NoConfirm/Log *.Map;*

tidy : cleanlis
	- If F$Search("[...]*.Opt;-1").nes."" Then Purge/NoConfirm/Log [...]*.Opt
	- If F$Search("[...]*$(O);-1").nes."" Then Purge/NoConfirm/Log [...]*$(O)
	- If F$Search("[...]*$(E);-1").nes."" Then Purge/NoConfirm/Log [...]*$(E)
	- If F$Search("Config.H;-1").nes."" Then Purge/NoConfirm/Log Config.H
	- If F$Search("Config.SH;-1").nes."" Then Purge/NoConfirm/Log Config.SH
	- If F$Search("perly.c;-1").nes."" Then Purge/NoConfirm/Log perly.c
	- If F$Search("perly.h;-1").nes."" Then Purge/NoConfirm/Log perly.h
	- If F$Search("VMSish.H;-1").nes."" Then Purge/NoConfirm/Log VMSish.H
	- If F$Search("VMS.C;-1")   .nes."" Then Purge/NoConfirm/Log VMS.C
	- If F$Search("Perlmain.C;-1")   .nes."" Then Purge/NoConfirm/Log Perlmain.C
	- If F$Search("byteperl.C;-1")   .nes."" Then Purge/NoConfirm/Log byteperl.C
	- If F$Search("Perlshr_Gbl*.Mar;-1")   .nes."" Then Purge/NoConfirm/Log Perlshr_Gbl*.Mar
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O);-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O)
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C;-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C
	- If F$Search("[.Ext.Opcode...];-1").nes."" Then Purge/NoConfirm/Log [.Ext.Opcode]
	- If F$Search("[.VMS.Ext...]*.C;-1").nes."" Then Purge/NoConfirm/Log [.VMS.Ext...]*.C
	- If F$Search("[.VMS.Ext...]*$(O);-1").nes."" Then Purge/NoConfirm/Log [.VMS.Ext...]*$(O)
	- If F$Search("[.Lib.Auto...]*.al;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]*.al
	- If F$Search("[.Lib.Auto...]autosplit.ix;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]autosplit.ix
	- If F$Search("[.Lib]DynaLoader.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]DynaLoader.pm
	- If F$Search("[.Lib]Socket.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]Socket.pm
	- If F$Search("[.Lib]Config.pm;-1").nes."" Then Purge/NoConfirm/Log [.Lib]Config.pm
	- If F$Search("$(ARCHDIR)Config.pm;-1").nes."" Then Purge/NoConfirm/Log $(ARCHDIR)Config.pm
	- If F$Search("[.lib.ExtUtils]Miniperl.pm").nes."" Then Purge/NoConfirm/Log [.lib.ExtUtils]Miniperl.pm
	- If F$Search("[.lib.ExtUtils]XSSymSet.pm").nes."" Then Purge/NoConfirm/Log [.lib.ExtUtils]XSSymSet.pm
	- If F$Search("[.Lib.VMS]*.*;-1").nes."" Then Purge/NoConfirm/Log [.Lib.VMS]*.*
	- If F$Search("[.Lib.Pod]*.Pod;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Pod]*.Pod
	- If F$Search("$(ARCHCORE)*.*").nes."" Then Purge/NoConfirm/Log $(ARCHCORE)*.*
	- If F$Search("[.lib]*.com;-1").nes."" Then Purge/NoConfirm/Log [.lib]*.com
	- If F$Search("[.utils]*.com;-1").nes."" Then Purge/NoConfirm/Log [.utils]*.com
	- If F$Search("[.x2p]*.com;-1").nes."" Then Purge/NoConfirm/Log [.x2p]*.com
	- If F$Search("[.lib.pod]*.com;-1").nes."" Then Purge/NoConfirm/Log [.lib.pod]*.com

clean : tidy
	Set Default [.ext.Fcntl]
	- $(MMS) clean
	Set Default [--]
	Set Default [.ext.IO]
	- $(MMS) clean
	Set Default [--]
	Set Default [.ext.Opcode]
	- $(MMS) clean
	Set Default [--]
	Set Default [.ext.attrs]
	- $(MMS) clean
	Set Default [--]
	Set Default [.ext.B]
	- $(MMS) clean
	Set Default [--]
.ifdef THREAD
	Set Default [.ext.Thread]
	- $(MMS) realclean
	Set Default [--]
.endif
.ifdef DECC
	Set Default [.ext.POSIX]
	- $(MMS) clean
	Set Default [--]
.endif
    Set Default [.ext.SDBM_File]
    - $(MMS) clean
    Set Default [--]
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*/Exclude=PerlShr_*.Opt
	- If F$Search("[...]*$(O);*") .nes."" Then Delete/NoConfirm/Log [...]*$(O);*
	- If F$Search("Config.H").nes."" Then Delete/NoConfirm/Log Config.H;*
	- If F$Search("Config.SH").nes."" Then Delete/NoConfirm/Log Config.SH;*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKH)")).nes."" Then Delete/NoConfirm/Log $(SOCKH);*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKC)")).nes."" Then Delete/NoConfirm/Log $(SOCKC);*
	- If F$Search("perly.c").nes."" Then Delete/NoConfirm/Log perly.c;*
	- If F$Search("perly.h").nes."" Then Delete/NoConfirm/Log perly.h;*
	- If F$Search("VMSish.H").nes."" Then Delete/NoConfirm/Log VMSish.H;*
	- If F$Search("VMS.C")   .nes."" Then Delete/NoConfirm/Log VMS.C;*
	- If F$Search("Perlmain.C")   .nes."" Then Delete/NoConfirm/Log Perlmain.C;*
	- If F$Search("byteperl.C")   .nes."" Then Delete/NoConfirm/Log byteperl.C;*
	- If F$Search("Perlshr_Gbl*.Mar")   .nes."" Then Delete/NoConfirm/Log Perlshr_Gbl*.Mar;*
	- If F$Search("*.TS").nes."" Then Delete/NoConfirm/Log *.TS;*
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O)").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O);*
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C;*
	- If F$Search("[.Ext.Socket]Socket$(O)").nes."" Then Delete/NoConfirm/Log [.Ext.Socket]Socket$(O);*
	- If F$Search("[.Ext.Socket]Socket.C").nes."" Then Delete/NoConfirm/Log [.Ext.Socket]Socket.C;*
	- If F$Search("[.VMS.Ext...]*.C").nes."" Then Delete/NoConfirm/Log [.VMS.Ext...]*.C;*
	- If F$Search("[.VMS.Ext...]*$(O)").nes."" Then Delete/NoConfirm/Log [.VMS.Ext...]*$(O);*

realclean : clean
	Set Default [.ext.Fcntl]
	- $(MMS) realclean
	Set Default [--]
	Set Default [.ext.IO]
	- $(MMS) realclean
	Set Default [--]
	Set Default [.ext.Opcode]
	- $(MMS) realclean
	Set Default [--]
	Set Default [.ext.attrs]
	- $(MMS) realclean
	Set Default [--]
	Set Default [.ext.B]
	- $(MMS) realclean
	Set Default [--]
.ifdef THREAD
	Set Default [.ext.Thread]
	- $(MMS) realclean
	Set Default [--]
.endif
.ifdef DECC
	Set Default [.ext.POSIX]
	- $(MMS) realclean
	Set Default [--]
.endif
    Set Default [.ext.SDBM_File]
    - $(MMS) realclean
    Set Default [--]
	- If F$Search("*$(OLB)").nes."" Then Delete/NoConfirm/Log *$(OLB);*
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*
	- $(MINIPERL) -e "use File::Path; rmtree(['lib/auto','lib/VMS','lib/$(ARCH)'],1,0);"
	- If F$Search("[.Lib]DynaLoader.pm").nes."" Then Delete/NoConfirm/Log [.Lib]DynaLoader.pm;*
	- If F$Search("[.Lib]Socket.pm").nes."" Then Delete/NoConfirm/Log [.Lib]Socket.pm;*
	- If F$Search("[.Lib]Config.pm").nes."" Then Delete/NoConfirm/Log [.Lib]Config.pm;*
	- If F$Search("[.Lib]*.com").nes."" Then Delete/NoConfirm/Log [.Lib]*.com;*
	- If F$Search("[.utils]*.com").nes."" Then Delete/NoConfirm/Log [.utils]*.com;*
	- If F$Search("[.x2p]*.com").nes."" Then Delete/NoConfirm/Log [.x2p]*.com;*
	- If F$Search("$(ARCHDIR)Config.pm").nes."" Then Delete/NoConfirm/Log $(ARCHDIR)Config.pm;*
	- If F$Search("[.lib.ExtUtils]Miniperl.pm").nes."" Then Delete/NoConfirm/Log [.lib.ExtUtils]Miniperl.pm;*
	- If F$Search("[.lib.ExtUtils]XSSymSet.pm").nes."" Then Delete/NoConfirm/Log [.lib.ExtUtils]XSSymSet.pm;*
	- If F$Search("[.lib.pod]*.pod").nes."" Then Delete/NoConfirm/Log [.lib.pod]*.pod;*
	- If F$Search("[.lib.pod]perldoc.com").nes."" Then Delete/NoConfirm/Log [.lib.pod]perldoc.com;*
	- If F$Search("[.lib.pod]pod2*.com").nes."" Then Delete/NoConfirm/Log [.lib.pod]pod2*.com;*
	- If F$Search("[.t.lib]vms*.t").nes."" Then Delete/NoConfirm/Log [.t.lib]vms*.t;*
	- If F$Search("[...]*$(E)").nes."" Then Delete/NoConfirm/Log [...]*$(E);*

cleansrc : clean
	- If F$Search("*.C;-1").nes."" Then Purge/NoConfirm/Log *.C
	- If F$Search("*.H;-1").nes."" Then Purge/NoConfirm/Log *.H
	- If F$Search("*.VMS;-1").nes."" Then Purge/NoConfirm/Log *.VMS
	- If F$Search("[.VMS]$(MAKEFILE);-1").nes."" Then Purge/NoConfirm/Log [.VMS]$(MAKEFILE)
	- If F$Search("[.VMS]*.C;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.C
	- If F$Search("[.VMS]*.H;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.H
	- If F$Search("[.VMS]*.Pl;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.Pl
	- If F$Search("[.VMS]*.VMS;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.VMS
	- If F$Search("[.VMS...]*.pm;-1").nes."" Then Purge/NoConfirm/Log [.VMS...]*.pm
	- If F$Search("[.VMS...]*.xs;-1").nes."" Then Purge/NoConfirm/Log [.VMS...]*.xs
