################################################################################
#
# $Project: /Convert-Binary-C $
# $Author: mhx $
# $Date: 2008/04/15 15:37:38 +0200 $
# $Revision: 7 $
# $Source: /tests/503_bfgeneric.t $
#
################################################################################
#
# Copyright (c) 2002-2008 Marcus Holland-Moritz. All rights reserved.
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
################################################################################

use Test::More tests => 9031;
use Convert::Binary::C @ARGV;
use strict;

$^W = 1;

my $BIN = $] < 5.006 ? '%x' : '%08b';

my @compiler = (
  {
    'name' => 'cygwin/gcc32_plain',
    'config' => {
      'LongSize' => 4,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 4,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 8,
      'LongLongSize' => 8,
      'LongDoubleSize' => 12,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'decosf_alpha/cc_plain',
    'config' => {
      'LongSize' => 8,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 8,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 8,
      'LongLongSize' => 8,
      'LongDoubleSize' => 16,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'freebsd_alpha/gcc_plain',
    'config' => {
      'LongSize' => 8,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 8,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 8,
      'LongLongSize' => 8,
      'LongDoubleSize' => 8,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'hpux11_ia64/cc_plain',
    'config' => {
      'LongSize' => 4,
      'IntSize' => 4,
      'ByteOrder' => 'BigEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 4,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 8,
      'LongLongSize' => 8,
      'LongDoubleSize' => 16,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'linux/armgcc34_plain',
    'config' => {
      'LongSize' => 4,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 4,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 4,
      'LongLongSize' => 8,
      'LongDoubleSize' => 8,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 4
    }
  },
  {
    'name' => 'linux/gcc41_plain',
    'config' => {
      'LongSize' => 4,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 4,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 4,
      'LongLongSize' => 8,
      'LongDoubleSize' => 12,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'linux/hppagcc33_plain',
    'config' => {
      'LongSize' => 8,
      'IntSize' => 4,
      'ByteOrder' => 'BigEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 8,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 8,
      'LongLongSize' => 8,
      'LongDoubleSize' => 16,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'linux/vaxgcc33_plain',
    'config' => {
      'LongSize' => 4,
      'IntSize' => 4,
      'ByteOrder' => 'LittleEndian',
      'ShortSize' => 2,
      'DoubleSize' => 8,
      'CharSize' => 1,
      'PointerSize' => 4,
      'EnumSize' => 4,
      'FloatSize' => 4,
      'Alignment' => 4,
      'LongLongSize' => 8,
      'LongDoubleSize' => 8,
      'HasCPPComments' => 1,
      'CompoundAlignment' => 1
    }
  },
  {
    'name' => 'linux_parisc64/gcc_plain',
    'config' => {
      'ByteOrder' => 'BigEndian',
      'LongSize' => '4',
      'IntSize' => '4',
      'ShortSize' => '2',
      'DoubleSize' => '8',
      'CharSize' => '1',
      'PointerSize' => '4',
      'EnumSize' => '4',
      'FloatSize' => '4',
      'LongLongSize' => '8',
      'Alignment' => '8',
      'LongDoubleSize' => '8',
      'HasCPPComments' => 1,
      'CompoundAlignment' => '1'
    }
  }
);


my @c = eval { map { Convert::Binary::C->new(Bitfields => {Engine => 'Generic'},
                                             EnumType  => 'String',
                                             %{$_->{config}}) } @compiler };
is($@, '', "failed to create Convert::Binary::C objects");

sub debug
{
  $ENV{CBC_TEST_DEBUG} and diag(@_);
}

sub showbits
{
  join ' ', map { sprintf $BIN, $_ } unpack "C*", shift;
}

sub get_data
{
  my $want = shift || 'list';
  my $term = shift || '[-=]';
  local $_;
  my @lines;
  while (<DATA>) {
    if (/^($term)$/) {
      $term = $1;
      last;
    }
    push @lines, $_
  }
  if ($want eq 'list') {
    chomp @lines;
    return $term, @lines;
  }
  return $term, join('', @lines);
}

sub reccmp
{
  my($ref, $val) = @_;

  unless (defined $ref and defined $val) {
    return defined($ref) == defined($val);
  }

  ref $ref or return $ref eq $val;

  if (ref $ref eq 'ARRAY') {
    @$ref == @$val or return 0;
    for (0..$#$ref) {
      reccmp($ref->[$_], $val->[$_]) or return 0;
    }
  }
  elsif (ref $ref eq 'HASH') {
    @{[keys %$ref]} == @{[keys %$val]} or return 0;
    for (keys %$ref) {
      reccmp($ref->{$_}, $val->{$_}) or return 0;
    }
  }
  else { return 0 }

  return 1;
}

while (1) {
  my(undef, $code) = get_data('block');
  last if $code !~ /\S/;
  debug("Code:\n$code");
  eval { $_->clean->parse($code) for @c };
  is($@, '', "parse code") or diag($code);
  is(scalar $c[0]->compound_names, 1, join(', ', $c[0]->compound_names));
  my($type) = $c[0]->compound_names;
  while (1) {
    my($term, $init, @packed) = get_data;
    debug("Init: $init");
    my $data = eval $init;
    my $succ = 0;
    for (@packed) { $_ = pack "H*", $_ }
    for my $i (0 .. $#packed) {
      debug("Compiler: [$i] $compiler[$i]{name}");
      $c[$i]->sizeof($type) == length($packed[$i]) and $succ++;

      my $p = $c[$i]->pack($type, $data);
      if ($p eq $packed[$i]) {
        $succ++;
      }
      else {
        diag("[$i] $compiler[$i]{name}\n",
             $code,
             "data = $init\n",
             "expected: ", showbits($packed[$i]), "\n",
             "     got: ", showbits($p), "\n");       
      }

      my $u = $c[$i]->unpack($type, $packed[$i]);
      if (reccmp($data, $u)) {
        $succ++;
      }
      else {
        diag("[$i] $compiler[$i]{name}\n", $code, "data = $init\n");
        eval {
          require Data::Dumper;
          diag(Data::Dumper->Dump([$data, $u], [qw(*expected *got)]));
        };
      }
    }
    is($succ, 3*@packed, "$type ($init)");
    last if $term eq '=';
  }
}

__DATA__
struct basic {
  unsigned int a:9;
};
-
{a=>509}
fd010000
fd010000
fd010000
fe800000
fd010000
fd010000
fe800000
fd010000
fe800000
-
{a=>352}
60010000
60010000
60010000
b0000000
60010000
60010000
b0000000
60010000
b0000000
-
{a=>349}
5d010000
5d010000
5d010000
ae800000
5d010000
5d010000
ae800000
5d010000
ae800000
-
{a=>398}
8e010000
8e010000
8e010000
c7000000
8e010000
8e010000
c7000000
8e010000
c7000000
-
{a=>453}
c5010000
c5010000
c5010000
e2800000
c5010000
c5010000
e2800000
c5010000
e2800000
=
struct basic {
  unsigned int a:9;
  unsigned int b:2;
};
-
{a=>228,b=>3}
e4060000
e4060000
e4060000
72600000
e4060000
e4060000
72600000
e4060000
72600000
-
{a=>163,b=>0}
a3000000
a3000000
a3000000
51800000
a3000000
a3000000
51800000
a3000000
51800000
-
{a=>333,b=>3}
4d070000
4d070000
4d070000
a6e00000
4d070000
4d070000
a6e00000
4d070000
a6e00000
-
{a=>495,b=>3}
ef070000
ef070000
ef070000
f7e00000
ef070000
ef070000
f7e00000
ef070000
f7e00000
-
{a=>193,b=>3}
c1060000
c1060000
c1060000
60e00000
c1060000
c1060000
60e00000
c1060000
60e00000
=
struct basic {
  unsigned int a:9;
  unsigned int b:2;
  unsigned int  :3;
};
-
{a=>115,b=>1}
73020000
73020000
73020000
39a00000
73020000
73020000
39a00000
73020000
39a00000
-
{a=>283,b=>0}
1b010000
1b010000
1b010000
8d800000
1b010000
1b010000
8d800000
1b010000
8d800000
-
{a=>12,b=>1}
0c020000
0c020000
0c020000
06200000
0c020000
0c020000
06200000
0c020000
06200000
-
{a=>417,b=>3}
a1070000
a1070000
a1070000
d0e00000
a1070000
a1070000
d0e00000
a1070000
d0e00000
-
{a=>129,b=>2}
81040000
81040000
81040000
40c00000
81040000
81040000
40c00000
81040000
40c00000
=
struct basic {
  unsigned int a:9;
  unsigned int b:2;
  unsigned int  :3;
  unsigned int c:2;
};
-
{c=>1,a=>473,b=>1}
d9430000
d9430000
d9430000
eca10000
d9430000
d9430000
eca10000
d9430000
eca10000
-
{c=>2,a=>149,b=>2}
95840000
95840000
95840000
4ac20000
95840000
95840000
4ac20000
95840000
4ac20000
-
{c=>3,a=>227,b=>2}
e3c40000
e3c40000
e3c40000
71c30000
e3c40000
e3c40000
71c30000
e3c40000
71c30000
-
{c=>0,a=>114,b=>0}
72000000
72000000
72000000
39000000
72000000
72000000
39000000
72000000
39000000
-
{c=>2,a=>83,b=>3}
53860000
53860000
53860000
29e20000
53860000
53860000
29e20000
53860000
29e20000
=
struct basic {
  unsigned int a:9;
  unsigned int b:2;
  unsigned int  :3;
  unsigned int c:2;
  unsigned int d;
};
-
{c=>0,a=>134,b=>3,d=>231}
86060000e7000000
86060000e7000000
86060000e7000000
43600000000000e7
86060000e7000000
86060000e7000000
43600000000000e7
86060000e7000000
43600000000000e7
-
{c=>0,a=>60,b=>0,d=>10}
3c0000000a000000
3c0000000a000000
3c0000000a000000
1e0000000000000a
3c0000000a000000
3c0000000a000000
1e0000000000000a
3c0000000a000000
1e0000000000000a
-
{c=>2,a=>170,b=>2,d=>252}
aa840000fc000000
aa840000fc000000
aa840000fc000000
55420000000000fc
aa840000fc000000
aa840000fc000000
55420000000000fc
aa840000fc000000
55420000000000fc
-
{c=>3,a=>53,b=>1,d=>248}
35c20000f8000000
35c20000f8000000
35c20000f8000000
1aa30000000000f8
35c20000f8000000
35c20000f8000000
1aa30000000000f8
35c20000f8000000
1aa30000000000f8
-
{c=>3,a=>74,b=>3,d=>85}
4ac6000055000000
4ac6000055000000
4ac6000055000000
2563000000000055
4ac6000055000000
4ac6000055000000
2563000000000055
4ac6000055000000
2563000000000055
=
struct basic {
  char a;
  unsigned int b:9;
};
-
{a=>95,b=>334}
5f4e0100
5f4e0100
5f4e0100
5fa70000
5f4e0100
5f4e0100
5fa70000
5f4e0100
5fa70000
-
{a=>43,b=>139}
2b8b0000
2b8b0000
2b8b0000
2b458000
2b8b0000
2b8b0000
2b458000
2b8b0000
2b458000
-
{a=>103,b=>500}
67f40100
67f40100
67f40100
67fa0000
67f40100
67f40100
67fa0000
67f40100
67fa0000
-
{a=>-82,b=>491}
aeeb0100
aeeb0100
aeeb0100
aef58000
aeeb0100
aeeb0100
aef58000
aeeb0100
aef58000
-
{a=>-81,b=>456}
afc80100
afc80100
afc80100
afe40000
afc80100
afc80100
afe40000
afc80100
afe40000
=
struct basic {
  char a;
  unsigned int b:9;
  unsigned int c:2;
};
-
{c=>1,a=>62,b=>455}
3ec70300
3ec70300
3ec70300
3ee3a000
3ec70300
3ec70300
3ee3a000
3ec70300
3ee3a000
-
{c=>0,a=>-46,b=>32}
d2200000
d2200000
d2200000
d2100000
d2200000
d2200000
d2100000
d2200000
d2100000
-
{c=>0,a=>55,b=>501}
37f50100
37f50100
37f50100
37fa8000
37f50100
37f50100
37fa8000
37f50100
37fa8000
-
{c=>3,a=>72,b=>97}
48610600
48610600
48610600
4830e000
48610600
48610600
4830e000
48610600
4830e000
-
{c=>3,a=>91,b=>180}
5bb40600
5bb40600
5bb40600
5b5a6000
5bb40600
5bb40600
5b5a6000
5bb40600
5b5a6000
=
struct basic {
  char a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
};
-
{c=>1,a=>-64,b=>1}
c0010200
c0010200
c0010200
c000a000
c0010200
c0010200
c000a000
c0010200
c000a000
-
{c=>3,a=>43,b=>409}
2b990700
2b990700
2b990700
2bcce000
2b990700
2b990700
2bcce000
2b990700
2bcce000
-
{c=>1,a=>-30,b=>413}
e29d0300
e29d0300
e29d0300
e2cea000
e29d0300
e29d0300
e2cea000
e29d0300
e2cea000
-
{c=>3,a=>107,b=>399}
6b8f0700
6b8f0700
6b8f0700
6bc7e000
6b8f0700
6b8f0700
6bc7e000
6b8f0700
6bc7e000
-
{c=>2,a=>-59,b=>474}
c5da0500
c5da0500
c5da0500
c5ed4000
c5da0500
c5da0500
c5ed4000
c5da0500
c5ed4000
=
struct basic {
  char a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
};
-
{c=>0,a=>-60,b=>352,d=>2}
c4608100
c4608100
c4608100
c4b00200
c4608100
c4608100
c4b00200
c4608100
c4b00200
-
{c=>1,a=>89,b=>103,d=>2}
59678200
59678200
59678200
5933a200
59678200
59678200
5933a200
59678200
5933a200
-
{c=>0,a=>31,b=>136,d=>2}
1f888000
1f888000
1f888000
1f440200
1f888000
1f888000
1f440200
1f888000
1f440200
-
{c=>0,a=>-103,b=>343,d=>0}
99570100
99570100
99570100
99ab8000
99570100
99570100
99ab8000
99570100
99ab8000
-
{c=>2,a=>-102,b=>358,d=>0}
9a660500
9a660500
9a660500
9ab34000
9a660500
9a660500
9ab34000
9a660500
9ab34000
=
struct basic {
  char a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
  unsigned int e;
};
-
{e=>205,c=>0,a=>57,b=>85,d=>3}
3955c000cd000000
3955c000cd000000
3955c000cd000000
392a8300000000cd
3955c000cd000000
3955c000cd000000
392a8300000000cd
3955c000cd000000
392a8300000000cd
-
{e=>218,c=>2,a=>-89,b=>129,d=>1}
a7814400da000000
a7814400da000000
a7814400da000000
a740c100000000da
a7814400da000000
a7814400da000000
a740c100000000da
a7814400da000000
a740c100000000da
-
{e=>90,c=>3,a=>105,b=>77,d=>1}
694d46005a000000
694d46005a000000
694d46005a000000
6926e1000000005a
694d46005a000000
694d46005a000000
6926e1000000005a
694d46005a000000
6926e1000000005a
-
{e=>82,c=>3,a=>89,b=>507,d=>0}
59fb070052000000
59fb070052000000
59fb070052000000
59fde00000000052
59fb070052000000
59fb070052000000
59fde00000000052
59fb070052000000
59fde00000000052
-
{e=>10,c=>1,a=>-7,b=>126,d=>0}
f97e02000a000000
f97e02000a000000
f97e02000a000000
f93f20000000000a
f97e02000a000000
f97e02000a000000
f93f20000000000a
f97e02000a000000
f93f20000000000a
=
struct basic {
  short a;
  unsigned int b:9;
};
-
{a=>44,b=>211}
2c00d300
2c00d300
2c00d300
002c6980
2c00d300
2c00d300
002c6980
2c00d300
002c6980
-
{a=>106,b=>55}
6a003700
6a003700
6a003700
006a1b80
6a003700
6a003700
006a1b80
6a003700
006a1b80
-
{a=>-99,b=>100}
9dff6400
9dff6400
9dff6400
ff9d3200
9dff6400
9dff6400
ff9d3200
9dff6400
ff9d3200
-
{a=>-25,b=>17}
e7ff1100
e7ff1100
e7ff1100
ffe70880
e7ff1100
e7ff1100
ffe70880
e7ff1100
ffe70880
-
{a=>-60,b=>31}
c4ff1f00
c4ff1f00
c4ff1f00
ffc40f80
c4ff1f00
c4ff1f00
ffc40f80
c4ff1f00
ffc40f80
=
struct basic {
  short a;
  unsigned int b:9;
  unsigned int c:2;
};
-
{c=>0,a=>-3,b=>65}
fdff4100
fdff4100
fdff4100
fffd2080
fdff4100
fdff4100
fffd2080
fdff4100
fffd2080
-
{c=>3,a=>127,b=>141}
7f008d06
7f008d06
7f008d06
007f46e0
7f008d06
7f008d06
007f46e0
7f008d06
007f46e0
-
{c=>1,a=>-53,b=>123}
cbff7b02
cbff7b02
cbff7b02
ffcb3da0
cbff7b02
cbff7b02
ffcb3da0
cbff7b02
ffcb3da0
-
{c=>3,a=>-110,b=>69}
92ff4506
92ff4506
92ff4506
ff9222e0
92ff4506
92ff4506
ff9222e0
92ff4506
ff9222e0
-
{c=>1,a=>-63,b=>183}
c1ffb702
c1ffb702
c1ffb702
ffc15ba0
c1ffb702
c1ffb702
ffc15ba0
c1ffb702
ffc15ba0
=
struct basic {
  short a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
};
-
{c=>1,a=>-32,b=>280}
e0ff1803
e0ff1803
e0ff1803
ffe08c20
e0ff1803
e0ff1803
ffe08c20
e0ff1803
ffe08c20
-
{c=>0,a=>-76,b=>473}
b4ffd901
b4ffd901
b4ffd901
ffb4ec80
b4ffd901
b4ffd901
ffb4ec80
b4ffd901
ffb4ec80
-
{c=>2,a=>-60,b=>271}
c4ff0f05
c4ff0f05
c4ff0f05
ffc487c0
c4ff0f05
c4ff0f05
ffc487c0
c4ff0f05
ffc487c0
-
{c=>1,a=>72,b=>50}
48003202
48003202
48003202
00481920
48003202
48003202
00481920
48003202
00481920
-
{c=>1,a=>-97,b=>440}
9fffb803
9fffb803
9fffb803
ff9fdc20
9fffb803
9fffb803
ff9fdc20
9fffb803
ff9fdc20
=
struct basic {
  short a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
};
-
{c=>3,a=>-78,b=>286,d=>1}
b2ff1e47
b2ff1e47
b2ff1e47
ffb28f61
b2ff1e47
b2ff1e47
ffb28f61
b2ff1e47
ffb28f61
-
{c=>2,a=>-105,b=>330,d=>3}
97ff4ac5
97ff4ac5
97ff4ac5
ff97a543
97ff4ac5
97ff4ac5
ff97a543
97ff4ac5
ff97a543
-
{c=>0,a=>73,b=>33,d=>1}
49002140
49002140
49002140
00491081
49002140
49002140
00491081
49002140
00491081
-
{c=>0,a=>-67,b=>463,d=>2}
bdffcf81
bdffcf81
bdffcf81
ffbde782
bdffcf81
bdffcf81
ffbde782
bdffcf81
ffbde782
-
{c=>0,a=>87,b=>452,d=>2}
5700c481
5700c481
5700c481
0057e202
5700c481
5700c481
0057e202
5700c481
0057e202
=
struct basic {
  short a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
  unsigned int e;
};
-
{e=>78,c=>2,a=>-39,b=>178,d=>3}
d9ffb2c44e000000
d9ffb2c44e000000
d9ffb2c44e000000
ffd959430000004e
d9ffb2c44e000000
d9ffb2c44e000000
ffd959430000004e
d9ffb2c44e000000
ffd959430000004e
-
{e=>4,c=>2,a=>51,b=>65,d=>2}
3300418404000000
3300418404000000
3300418404000000
003320c200000004
3300418404000000
3300418404000000
003320c200000004
3300418404000000
003320c200000004
-
{e=>225,c=>1,a=>-16,b=>99,d=>1}
f0ff6342e1000000
f0ff6342e1000000
f0ff6342e1000000
fff031a1000000e1
f0ff6342e1000000
f0ff6342e1000000
fff031a1000000e1
f0ff6342e1000000
fff031a1000000e1
-
{e=>23,c=>0,a=>-1,b=>254,d=>0}
fffffe0017000000
fffffe0017000000
fffffe0017000000
ffff7f0000000017
fffffe0017000000
fffffe0017000000
ffff7f0000000017
fffffe0017000000
ffff7f0000000017
-
{e=>75,c=>0,a=>7,b=>128,d=>1}
070080404b000000
070080404b000000
070080404b000000
000740010000004b
070080404b000000
070080404b000000
000740010000004b
070080404b000000
000740010000004b
=
struct basic {
  int a;
  unsigned int b:9;
};
-
{a=>26,b=>294}
1a00000026010000
1a00000026010000
1a00000026010000
0000001a93000000
1a00000026010000
1a00000026010000
0000001a93000000
1a00000026010000
0000001a93000000
-
{a=>120,b=>54}
7800000036000000
7800000036000000
7800000036000000
000000781b000000
7800000036000000
7800000036000000
000000781b000000
7800000036000000
000000781b000000
-
{a=>-16,b=>377}
f0ffffff79010000
f0ffffff79010000
f0ffffff79010000
fffffff0bc800000
f0ffffff79010000
f0ffffff79010000
fffffff0bc800000
f0ffffff79010000
fffffff0bc800000
-
{a=>38,b=>179}
26000000b3000000
26000000b3000000
26000000b3000000
0000002659800000
26000000b3000000
26000000b3000000
0000002659800000
26000000b3000000
0000002659800000
-
{a=>116,b=>289}
7400000021010000
7400000021010000
7400000021010000
0000007490800000
7400000021010000
7400000021010000
0000007490800000
7400000021010000
0000007490800000
=
struct basic {
  int a;
  unsigned int b:9;
  unsigned int c:2;
};
-
{c=>1,a=>49,b=>430}
31000000ae030000
31000000ae030000
31000000ae030000
00000031d7200000
31000000ae030000
31000000ae030000
00000031d7200000
31000000ae030000
00000031d7200000
-
{c=>3,a=>118,b=>459}
76000000cb070000
76000000cb070000
76000000cb070000
00000076e5e00000
76000000cb070000
76000000cb070000
00000076e5e00000
76000000cb070000
00000076e5e00000
-
{c=>0,a=>1,b=>148}
0100000094000000
0100000094000000
0100000094000000
000000014a000000
0100000094000000
0100000094000000
000000014a000000
0100000094000000
000000014a000000
-
{c=>0,a=>-80,b=>164}
b0ffffffa4000000
b0ffffffa4000000
b0ffffffa4000000
ffffffb052000000
b0ffffffa4000000
b0ffffffa4000000
ffffffb052000000
b0ffffffa4000000
ffffffb052000000
-
{c=>3,a=>-5,b=>38}
fbffffff26060000
fbffffff26060000
fbffffff26060000
fffffffb13600000
fbffffff26060000
fbffffff26060000
fffffffb13600000
fbffffff26060000
fffffffb13600000
=
struct basic {
  int a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
};
-
{c=>0,a=>73,b=>253}
49000000fd000000
49000000fd000000
49000000fd000000
000000497e800000
49000000fd000000
49000000fd000000
000000497e800000
49000000fd000000
000000497e800000
-
{c=>3,a=>91,b=>302}
5b0000002e070000
5b0000002e070000
5b0000002e070000
0000005b97600000
5b0000002e070000
5b0000002e070000
0000005b97600000
5b0000002e070000
0000005b97600000
-
{c=>3,a=>30,b=>58}
1e0000003a060000
1e0000003a060000
1e0000003a060000
0000001e1d600000
1e0000003a060000
1e0000003a060000
0000001e1d600000
1e0000003a060000
0000001e1d600000
-
{c=>0,a=>-109,b=>436}
93ffffffb4010000
93ffffffb4010000
93ffffffb4010000
ffffff93da000000
93ffffffb4010000
93ffffffb4010000
ffffff93da000000
93ffffffb4010000
ffffff93da000000
-
{c=>3,a=>-89,b=>300}
a7ffffff2c070000
a7ffffff2c070000
a7ffffff2c070000
ffffffa796600000
a7ffffff2c070000
a7ffffff2c070000
ffffffa796600000
a7ffffff2c070000
ffffffa796600000
=
struct basic {
  int a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
};
-
{c=>2,a=>-81,b=>332,d=>0}
afffffff4c050000
afffffff4c050000
afffffff4c050000
ffffffafa6400000
afffffff4c050000
afffffff4c050000
ffffffafa6400000
afffffff4c050000
ffffffafa6400000
-
{c=>0,a=>-118,b=>311,d=>3}
8affffff37c10000
8affffff37c10000
8affffff37c10000
ffffff8a9b830000
8affffff37c10000
8affffff37c10000
ffffff8a9b830000
8affffff37c10000
ffffff8a9b830000
-
{c=>2,a=>93,b=>362,d=>1}
5d0000006a450000
5d0000006a450000
5d0000006a450000
0000005db5410000
5d0000006a450000
5d0000006a450000
0000005db5410000
5d0000006a450000
0000005db5410000
-
{c=>0,a=>122,b=>370,d=>0}
7a00000072010000
7a00000072010000
7a00000072010000
0000007ab9000000
7a00000072010000
7a00000072010000
0000007ab9000000
7a00000072010000
0000007ab9000000
-
{c=>2,a=>87,b=>107,d=>2}
570000006b840000
570000006b840000
570000006b840000
0000005735c20000
570000006b840000
570000006b840000
0000005735c20000
570000006b840000
0000005735c20000
=
struct basic {
  int a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
  unsigned int e;
};
-
{e=>246,c=>1,a=>109,b=>275,d=>1}
6d00000013430000f6000000
6d00000013430000f6000000
6d00000013430000f6000000
0000006d89a10000000000f6
6d00000013430000f6000000
6d00000013430000f6000000
0000006d89a10000000000f6
6d00000013430000f6000000
0000006d89a10000000000f6
-
{e=>120,c=>3,a=>80,b=>215,d=>2}
50000000d786000078000000
50000000d786000078000000
50000000d786000078000000
000000506be2000000000078
50000000d786000078000000
50000000d786000078000000
000000506be2000000000078
50000000d786000078000000
000000506be2000000000078
-
{e=>236,c=>0,a=>88,b=>484,d=>2}
58000000e4810000ec000000
58000000e4810000ec000000
58000000e4810000ec000000
00000058f2020000000000ec
58000000e4810000ec000000
58000000e4810000ec000000
00000058f2020000000000ec
58000000e4810000ec000000
00000058f2020000000000ec
-
{e=>9,c=>1,a=>-20,b=>117,d=>2}
ecffffff7582000009000000
ecffffff7582000009000000
ecffffff7582000009000000
ffffffec3aa2000000000009
ecffffff7582000009000000
ecffffff7582000009000000
ffffffec3aa2000000000009
ecffffff7582000009000000
ffffffec3aa2000000000009
-
{e=>135,c=>3,a=>126,b=>333,d=>1}
7e0000004d47000087000000
7e0000004d47000087000000
7e0000004d47000087000000
0000007ea6e1000000000087
7e0000004d47000087000000
7e0000004d47000087000000
0000007ea6e1000000000087
7e0000004d47000087000000
0000007ea6e1000000000087
=
struct basic {
  long a;
  unsigned int b:9;
};
-
{a=>-90,b=>99}
a6ffffff63000000
a6ffffffffffffff6300000000000000
a6ffffffffffffff6300000000000000
ffffffa631800000
a6ffffff63000000
a6ffffff63000000
ffffffffffffffa63180000000000000
a6ffffff63000000
ffffffa631800000
-
{a=>18,b=>50}
1200000032000000
12000000000000003200000000000000
12000000000000003200000000000000
0000001219000000
1200000032000000
1200000032000000
00000000000000121900000000000000
1200000032000000
0000001219000000
-
{a=>-120,b=>264}
88ffffff08010000
88ffffffffffffff0801000000000000
88ffffffffffffff0801000000000000
ffffff8884000000
88ffffff08010000
88ffffff08010000
ffffffffffffff888400000000000000
88ffffff08010000
ffffff8884000000
-
{a=>23,b=>32}
1700000020000000
17000000000000002000000000000000
17000000000000002000000000000000
0000001710000000
1700000020000000
1700000020000000
00000000000000171000000000000000
1700000020000000
0000001710000000
-
{a=>42,b=>321}
2a00000041010000
2a000000000000004101000000000000
2a000000000000004101000000000000
0000002aa0800000
2a00000041010000
2a00000041010000
000000000000002aa080000000000000
2a00000041010000
0000002aa0800000
=
struct basic {
  long a;
  unsigned int b:9;
  unsigned int c:2;
};
-
{c=>3,a=>37,b=>303}
250000002f070000
25000000000000002f07000000000000
25000000000000002f07000000000000
0000002597e00000
250000002f070000
250000002f070000
000000000000002597e0000000000000
250000002f070000
0000002597e00000
-
{c=>3,a=>-87,b=>458}
a9ffffffca070000
a9ffffffffffffffca07000000000000
a9ffffffffffffffca07000000000000
ffffffa9e5600000
a9ffffffca070000
a9ffffffca070000
ffffffffffffffa9e560000000000000
a9ffffffca070000
ffffffa9e5600000
-
{c=>3,a=>-86,b=>453}
aaffffffc5070000
aaffffffffffffffc507000000000000
aaffffffffffffffc507000000000000
ffffffaae2e00000
aaffffffc5070000
aaffffffc5070000
ffffffffffffffaae2e0000000000000
aaffffffc5070000
ffffffaae2e00000
-
{c=>0,a=>96,b=>71}
6000000047000000
60000000000000004700000000000000
60000000000000004700000000000000
0000006023800000
6000000047000000
6000000047000000
00000000000000602380000000000000
6000000047000000
0000006023800000
-
{c=>0,a=>-46,b=>254}
d2fffffffe000000
d2fffffffffffffffe00000000000000
d2fffffffffffffffe00000000000000
ffffffd27f000000
d2fffffffe000000
d2fffffffe000000
ffffffffffffffd27f00000000000000
d2fffffffe000000
ffffffd27f000000
=
struct basic {
  long a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
};
-
{c=>1,a=>-123,b=>56}
85ffffff38020000
85ffffffffffffff3802000000000000
85ffffffffffffff3802000000000000
ffffff851c200000
85ffffff38020000
85ffffff38020000
ffffffffffffff851c20000000000000
85ffffff38020000
ffffff851c200000
-
{c=>1,a=>-36,b=>276}
dcffffff14030000
dcffffffffffffff1403000000000000
dcffffffffffffff1403000000000000
ffffffdc8a200000
dcffffff14030000
dcffffff14030000
ffffffffffffffdc8a20000000000000
dcffffff14030000
ffffffdc8a200000
-
{c=>2,a=>26,b=>453}
1a000000c5050000
1a00000000000000c505000000000000
1a00000000000000c505000000000000
0000001ae2c00000
1a000000c5050000
1a000000c5050000
000000000000001ae2c0000000000000
1a000000c5050000
0000001ae2c00000
-
{c=>0,a=>95,b=>479}
5f000000df010000
5f00000000000000df01000000000000
5f00000000000000df01000000000000
0000005fef800000
5f000000df010000
5f000000df010000
000000000000005fef80000000000000
5f000000df010000
0000005fef800000
-
{c=>1,a=>28,b=>16}
1c00000010020000
1c000000000000001002000000000000
1c000000000000001002000000000000
0000001c08200000
1c00000010020000
1c00000010020000
000000000000001c0820000000000000
1c00000010020000
0000001c08200000
=
struct basic {
  long a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
};
-
{c=>3,a=>-75,b=>292,d=>0}
b5ffffff24070000
b5ffffffffffffff2407000000000000
b5ffffffffffffff2407000000000000
ffffffb592600000
b5ffffff24070000
b5ffffff24070000
ffffffffffffffb59260000000000000
b5ffffff24070000
ffffffb592600000
-
{c=>0,a=>24,b=>330,d=>0}
180000004a010000
18000000000000004a01000000000000
18000000000000004a01000000000000
00000018a5000000
180000004a010000
180000004a010000
0000000000000018a500000000000000
180000004a010000
00000018a5000000
-
{c=>3,a=>2,b=>332,d=>1}
020000004c470000
02000000000000004c47000000000000
02000000000000004c47000000000000
00000002a6610000
020000004c470000
020000004c470000
0000000000000002a661000000000000
020000004c470000
00000002a6610000
-
{c=>2,a=>74,b=>257,d=>1}
4a00000001450000
4a000000000000000145000000000000
4a000000000000000145000000000000
0000004a80c10000
4a00000001450000
4a00000001450000
000000000000004a80c1000000000000
4a00000001450000
0000004a80c10000
-
{c=>2,a=>106,b=>208,d=>3}
6a000000d0c40000
6a00000000000000d0c4000000000000
6a00000000000000d0c4000000000000
0000006a68430000
6a000000d0c40000
6a000000d0c40000
000000000000006a6843000000000000
6a000000d0c40000
0000006a68430000
=
struct basic {
  long a;
  unsigned int b:9;
  unsigned int c:2;
  unsigned int  :3;
  unsigned int d:2;
  unsigned int e;
};
-
{e=>118,c=>0,a=>26,b=>490,d=>2}
1a000000ea81000076000000
1a00000000000000ea81000076000000
1a00000000000000ea81000076000000
0000001af502000000000076
1a000000ea81000076000000
1a000000ea81000076000000
000000000000001af502000000000076
1a000000ea81000076000000
0000001af502000000000076
-
{e=>200,c=>0,a=>6,b=>418,d=>1}
06000000a2410000c8000000
0600000000000000a2410000c8000000
0600000000000000a2410000c8000000
00000006d1010000000000c8
06000000a2410000c8000000
06000000a2410000c8000000
0000000000000006d1010000000000c8
06000000a2410000c8000000
00000006d1010000000000c8
-
{e=>40,c=>1,a=>41,b=>444,d=>2}
29000000bc83000028000000
2900000000000000bc83000028000000
2900000000000000bc83000028000000
00000029de22000000000028
29000000bc83000028000000
29000000bc83000028000000
0000000000000029de22000000000028
29000000bc83000028000000
00000029de22000000000028
-
{e=>154,c=>0,a=>0,b=>88,d=>3}
0000000058c000009a000000
000000000000000058c000009a000000
000000000000000058c000009a000000
000000002c0300000000009a
0000000058c000009a000000
0000000058c000009a000000
00000000000000002c0300000000009a
0000000058c000009a000000
000000002c0300000000009a
-
{e=>163,c=>3,a=>-5,b=>393,d=>0}
fbffffff89070000a3000000
fbffffffffffffff89070000a3000000
fbffffffffffffff89070000a3000000
fffffffbc4e00000000000a3
fbffffff89070000a3000000
fbffffff89070000a3000000
fffffffffffffffbc4e00000000000a3
fbffffff89070000a3000000
fffffffbc4e00000000000a3
=
struct uchar {
  unsigned char  a:1;
};
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
=
struct uchar {
  unsigned char  a:1;
  unsigned char  b:1;
};
-
{a=>1,b=>0}
01
01
01
80
01000000
01
80
01
80
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>0,b=>1}
02
02
02
40
02000000
02
40
02
40
=
struct uchar {
  unsigned char  a:1;
  unsigned char  b:1;
  unsigned char  c:1;
};
-
{c=>1,a=>1,b=>1}
07
07
07
e0
07000000
07
e0
07
e0
-
{c=>1,a=>0,b=>0}
04
04
04
20
04000000
04
20
04
20
-
{c=>0,a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{c=>1,a=>1,b=>1}
07
07
07
e0
07000000
07
e0
07
e0
-
{c=>1,a=>1,b=>0}
05
05
05
a0
05000000
05
a0
05
a0
=
struct uchar {
  unsigned char  a:1;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
};
-
{c=>1,a=>0,b=>1,d=>1}
0e
0e
0e
70
0e000000
0e
70
0e
70
-
{c=>0,a=>1,b=>0,d=>0}
01
01
01
80
01000000
01
80
01
80
-
{c=>0,a=>0,b=>1,d=>1}
0a
0a
0a
50
0a000000
0a
50
0a
50
-
{c=>1,a=>0,b=>0,d=>1}
0c
0c
0c
30
0c000000
0c
30
0c
30
-
{c=>0,a=>1,b=>0,d=>0}
01
01
01
80
01000000
01
80
01
80
=
struct uchar {
  unsigned char  a:1;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned int   e;
};
-
{e=>111,c=>1,a=>1,b=>1,d=>1}
0f0000006f000000
0f0000006f000000
0f0000006f000000
f00000000000006f
0f0000006f000000
0f0000006f000000
f00000000000006f
0f0000006f000000
f00000000000006f
-
{e=>24,c=>0,a=>0,b=>1,d=>0}
0200000018000000
0200000018000000
0200000018000000
4000000000000018
0200000018000000
0200000018000000
4000000000000018
0200000018000000
4000000000000018
-
{e=>185,c=>0,a=>0,b=>1,d=>0}
02000000b9000000
02000000b9000000
02000000b9000000
40000000000000b9
02000000b9000000
02000000b9000000
40000000000000b9
02000000b9000000
40000000000000b9
-
{e=>229,c=>1,a=>0,b=>1,d=>1}
0e000000e5000000
0e000000e5000000
0e000000e5000000
70000000000000e5
0e000000e5000000
0e000000e5000000
70000000000000e5
0e000000e5000000
70000000000000e5
-
{e=>255,c=>0,a=>1,b=>0,d=>1}
09000000ff000000
09000000ff000000
09000000ff000000
90000000000000ff
09000000ff000000
09000000ff000000
90000000000000ff
09000000ff000000
90000000000000ff
=
struct uchar {
  char a;
  unsigned char  b:1;
};
-
{a=>-120,b=>1}
8801
8801
8801
8880
88010000
8801
8880
8801
8880
-
{a=>70,b=>0}
4600
4600
4600
4600
46000000
4600
4600
4600
4600
-
{a=>81,b=>0}
5100
5100
5100
5100
51000000
5100
5100
5100
5100
-
{a=>56,b=>1}
3801
3801
3801
3880
38010000
3801
3880
3801
3880
-
{a=>126,b=>0}
7e00
7e00
7e00
7e00
7e000000
7e00
7e00
7e00
7e00
=
struct uchar {
  char a;
  unsigned char  b:1;
  unsigned char  c:1;
};
-
{c=>1,a=>16,b=>1}
1003
1003
1003
10c0
10030000
1003
10c0
1003
10c0
-
{c=>0,a=>90,b=>1}
5a01
5a01
5a01
5a80
5a010000
5a01
5a80
5a01
5a80
-
{c=>0,a=>-85,b=>0}
ab00
ab00
ab00
ab00
ab000000
ab00
ab00
ab00
ab00
-
{c=>0,a=>74,b=>1}
4a01
4a01
4a01
4a80
4a010000
4a01
4a80
4a01
4a80
-
{c=>0,a=>-127,b=>0}
8100
8100
8100
8100
81000000
8100
8100
8100
8100
=
struct uchar {
  char a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
};
-
{c=>1,a=>-84,b=>0,d=>1}
ac06
ac06
ac06
ac60
ac060000
ac06
ac60
ac06
ac60
-
{c=>1,a=>-93,b=>1,d=>0}
a303
a303
a303
a3c0
a3030000
a303
a3c0
a303
a3c0
-
{c=>1,a=>-94,b=>1,d=>1}
a207
a207
a207
a2e0
a2070000
a207
a2e0
a207
a2e0
-
{c=>1,a=>116,b=>0,d=>0}
7402
7402
7402
7440
74020000
7402
7440
7402
7440
-
{c=>1,a=>92,b=>0,d=>1}
5c06
5c06
5c06
5c60
5c060000
5c06
5c60
5c06
5c60
=
struct uchar {
  char a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
};
-
{e=>1,c=>0,a=>-104,b=>1,d=>0}
9809
9809
9809
9890
98090000
9809
9890
9809
9890
-
{e=>0,c=>1,a=>-94,b=>0,d=>0}
a202
a202
a202
a240
a2020000
a202
a240
a202
a240
-
{e=>0,c=>0,a=>113,b=>1,d=>0}
7101
7101
7101
7180
71010000
7101
7180
7101
7180
-
{e=>1,c=>0,a=>25,b=>1,d=>1}
190d
190d
190d
19b0
190d0000
190d
19b0
190d
19b0
-
{e=>0,c=>0,a=>-21,b=>1,d=>1}
eb05
eb05
eb05
eba0
eb050000
eb05
eba0
eb05
eba0
=
struct uchar {
  char a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
  unsigned int   f;
};
-
{e=>1,c=>1,a=>58,b=>1,d=>0,f=>7}
3a0b000007000000
3a0b000007000000
3a0b000007000000
3ad0000000000007
3a0b000007000000
3a0b000007000000
3ad0000000000007
3a0b000007000000
3ad0000000000007
-
{e=>0,c=>0,a=>9,b=>0,d=>1,f=>220}
09040000dc000000
09040000dc000000
09040000dc000000
09200000000000dc
09040000dc000000
09040000dc000000
09200000000000dc
09040000dc000000
09200000000000dc
-
{e=>0,c=>1,a=>123,b=>1,d=>0,f=>59}
7b0300003b000000
7b0300003b000000
7b0300003b000000
7bc000000000003b
7b0300003b000000
7b0300003b000000
7bc000000000003b
7b0300003b000000
7bc000000000003b
-
{e=>0,c=>1,a=>-113,b=>1,d=>1,f=>172}
8f070000ac000000
8f070000ac000000
8f070000ac000000
8fe00000000000ac
8f070000ac000000
8f070000ac000000
8fe00000000000ac
8f070000ac000000
8fe00000000000ac
-
{e=>0,c=>1,a=>75,b=>0,d=>1,f=>175}
4b060000af000000
4b060000af000000
4b060000af000000
4b600000000000af
4b060000af000000
4b060000af000000
4b600000000000af
4b060000af000000
4b600000000000af
=
struct uchar {
  short a;
  unsigned char  b:1;
};
-
{a=>-46,b=>1}
d2ff0100
d2ff0100
d2ff0100
ffd28000
d2ff0100
d2ff0100
ffd28000
d2ff0100
ffd28000
-
{a=>32,b=>1}
20000100
20000100
20000100
00208000
20000100
20000100
00208000
20000100
00208000
-
{a=>-26,b=>0}
e6ff0000
e6ff0000
e6ff0000
ffe60000
e6ff0000
e6ff0000
ffe60000
e6ff0000
ffe60000
-
{a=>122,b=>0}
7a000000
7a000000
7a000000
007a0000
7a000000
7a000000
007a0000
7a000000
007a0000
-
{a=>-51,b=>0}
cdff0000
cdff0000
cdff0000
ffcd0000
cdff0000
cdff0000
ffcd0000
cdff0000
ffcd0000
=
struct uchar {
  short a;
  unsigned char  b:1;
  unsigned char  c:1;
};
-
{c=>1,a=>14,b=>0}
0e000200
0e000200
0e000200
000e4000
0e000200
0e000200
000e4000
0e000200
000e4000
-
{c=>1,a=>-41,b=>0}
d7ff0200
d7ff0200
d7ff0200
ffd74000
d7ff0200
d7ff0200
ffd74000
d7ff0200
ffd74000
-
{c=>1,a=>-93,b=>1}
a3ff0300
a3ff0300
a3ff0300
ffa3c000
a3ff0300
a3ff0300
ffa3c000
a3ff0300
ffa3c000
-
{c=>0,a=>-76,b=>1}
b4ff0100
b4ff0100
b4ff0100
ffb48000
b4ff0100
b4ff0100
ffb48000
b4ff0100
ffb48000
-
{c=>0,a=>-111,b=>0}
91ff0000
91ff0000
91ff0000
ff910000
91ff0000
91ff0000
ff910000
91ff0000
ff910000
=
struct uchar {
  short a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
};
-
{c=>0,a=>7,b=>1,d=>0}
07000100
07000100
07000100
00078000
07000100
07000100
00078000
07000100
00078000
-
{c=>0,a=>64,b=>0,d=>0}
40000000
40000000
40000000
00400000
40000000
40000000
00400000
40000000
00400000
-
{c=>1,a=>7,b=>0,d=>0}
07000200
07000200
07000200
00074000
07000200
07000200
00074000
07000200
00074000
-
{c=>1,a=>-72,b=>1,d=>1}
b8ff0700
b8ff0700
b8ff0700
ffb8e000
b8ff0700
b8ff0700
ffb8e000
b8ff0700
ffb8e000
-
{c=>1,a=>62,b=>0,d=>1}
3e000600
3e000600
3e000600
003e6000
3e000600
3e000600
003e6000
3e000600
003e6000
=
struct uchar {
  short a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
};
-
{e=>0,c=>1,a=>-108,b=>1,d=>0}
94ff0300
94ff0300
94ff0300
ff94c000
94ff0300
94ff0300
ff94c000
94ff0300
ff94c000
-
{e=>1,c=>0,a=>-125,b=>1,d=>0}
83ff0900
83ff0900
83ff0900
ff839000
83ff0900
83ff0900
ff839000
83ff0900
ff839000
-
{e=>0,c=>1,a=>52,b=>1,d=>0}
34000300
34000300
34000300
0034c000
34000300
34000300
0034c000
34000300
0034c000
-
{e=>0,c=>0,a=>-93,b=>0,d=>0}
a3ff0000
a3ff0000
a3ff0000
ffa30000
a3ff0000
a3ff0000
ffa30000
a3ff0000
ffa30000
-
{e=>1,c=>0,a=>-128,b=>0,d=>1}
80ff0c00
80ff0c00
80ff0c00
ff803000
80ff0c00
80ff0c00
ff803000
80ff0c00
ff803000
=
struct uchar {
  short a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
  unsigned int   f;
};
-
{e=>0,c=>0,a=>72,b=>1,d=>1,f=>111}
480005006f000000
480005006f000000
480005006f000000
0048a0000000006f
480005006f000000
480005006f000000
0048a0000000006f
480005006f000000
0048a0000000006f
-
{e=>0,c=>1,a=>-44,b=>0,d=>0,f=>40}
d4ff020028000000
d4ff020028000000
d4ff020028000000
ffd4400000000028
d4ff020028000000
d4ff020028000000
ffd4400000000028
d4ff020028000000
ffd4400000000028
-
{e=>1,c=>1,a=>121,b=>1,d=>0,f=>41}
79000b0029000000
79000b0029000000
79000b0029000000
0079d00000000029
79000b0029000000
79000b0029000000
0079d00000000029
79000b0029000000
0079d00000000029
-
{e=>0,c=>1,a=>-68,b=>1,d=>0,f=>136}
bcff030088000000
bcff030088000000
bcff030088000000
ffbcc00000000088
bcff030088000000
bcff030088000000
ffbcc00000000088
bcff030088000000
ffbcc00000000088
-
{e=>0,c=>0,a=>-73,b=>1,d=>0,f=>25}
b7ff010019000000
b7ff010019000000
b7ff010019000000
ffb7800000000019
b7ff010019000000
b7ff010019000000
ffb7800000000019
b7ff010019000000
ffb7800000000019
=
struct uchar {
  int a;
  unsigned char  b:1;
};
-
{a=>-57,b=>0}
c7ffffff00000000
c7ffffff00000000
c7ffffff00000000
ffffffc700000000
c7ffffff00000000
c7ffffff00000000
ffffffc700000000
c7ffffff00000000
ffffffc700000000
-
{a=>-29,b=>0}
e3ffffff00000000
e3ffffff00000000
e3ffffff00000000
ffffffe300000000
e3ffffff00000000
e3ffffff00000000
ffffffe300000000
e3ffffff00000000
ffffffe300000000
-
{a=>-23,b=>0}
e9ffffff00000000
e9ffffff00000000
e9ffffff00000000
ffffffe900000000
e9ffffff00000000
e9ffffff00000000
ffffffe900000000
e9ffffff00000000
ffffffe900000000
-
{a=>-128,b=>1}
80ffffff01000000
80ffffff01000000
80ffffff01000000
ffffff8080000000
80ffffff01000000
80ffffff01000000
ffffff8080000000
80ffffff01000000
ffffff8080000000
-
{a=>-58,b=>0}
c6ffffff00000000
c6ffffff00000000
c6ffffff00000000
ffffffc600000000
c6ffffff00000000
c6ffffff00000000
ffffffc600000000
c6ffffff00000000
ffffffc600000000
=
struct uchar {
  int a;
  unsigned char  b:1;
  unsigned char  c:1;
};
-
{c=>1,a=>-78,b=>1}
b2ffffff03000000
b2ffffff03000000
b2ffffff03000000
ffffffb2c0000000
b2ffffff03000000
b2ffffff03000000
ffffffb2c0000000
b2ffffff03000000
ffffffb2c0000000
-
{c=>0,a=>-100,b=>1}
9cffffff01000000
9cffffff01000000
9cffffff01000000
ffffff9c80000000
9cffffff01000000
9cffffff01000000
ffffff9c80000000
9cffffff01000000
ffffff9c80000000
-
{c=>0,a=>-27,b=>0}
e5ffffff00000000
e5ffffff00000000
e5ffffff00000000
ffffffe500000000
e5ffffff00000000
e5ffffff00000000
ffffffe500000000
e5ffffff00000000
ffffffe500000000
-
{c=>1,a=>-123,b=>1}
85ffffff03000000
85ffffff03000000
85ffffff03000000
ffffff85c0000000
85ffffff03000000
85ffffff03000000
ffffff85c0000000
85ffffff03000000
ffffff85c0000000
-
{c=>0,a=>-84,b=>0}
acffffff00000000
acffffff00000000
acffffff00000000
ffffffac00000000
acffffff00000000
acffffff00000000
ffffffac00000000
acffffff00000000
ffffffac00000000
=
struct uchar {
  int a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
};
-
{c=>1,a=>82,b=>0,d=>0}
5200000002000000
5200000002000000
5200000002000000
0000005240000000
5200000002000000
5200000002000000
0000005240000000
5200000002000000
0000005240000000
-
{c=>0,a=>20,b=>0,d=>1}
1400000004000000
1400000004000000
1400000004000000
0000001420000000
1400000004000000
1400000004000000
0000001420000000
1400000004000000
0000001420000000
-
{c=>1,a=>95,b=>0,d=>0}
5f00000002000000
5f00000002000000
5f00000002000000
0000005f40000000
5f00000002000000
5f00000002000000
0000005f40000000
5f00000002000000
0000005f40000000
-
{c=>0,a=>71,b=>0,d=>0}
4700000000000000
4700000000000000
4700000000000000
0000004700000000
4700000000000000
4700000000000000
0000004700000000
4700000000000000
0000004700000000
-
{c=>1,a=>-38,b=>0,d=>0}
daffffff02000000
daffffff02000000
daffffff02000000
ffffffda40000000
daffffff02000000
daffffff02000000
ffffffda40000000
daffffff02000000
ffffffda40000000
=
struct uchar {
  int a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
};
-
{e=>0,c=>0,a=>-32,b=>1,d=>1}
e0ffffff05000000
e0ffffff05000000
e0ffffff05000000
ffffffe0a0000000
e0ffffff05000000
e0ffffff05000000
ffffffe0a0000000
e0ffffff05000000
ffffffe0a0000000
-
{e=>0,c=>1,a=>-34,b=>1,d=>1}
deffffff07000000
deffffff07000000
deffffff07000000
ffffffdee0000000
deffffff07000000
deffffff07000000
ffffffdee0000000
deffffff07000000
ffffffdee0000000
-
{e=>1,c=>1,a=>70,b=>1,d=>1}
460000000f000000
460000000f000000
460000000f000000
00000046f0000000
460000000f000000
460000000f000000
00000046f0000000
460000000f000000
00000046f0000000
-
{e=>0,c=>1,a=>127,b=>1,d=>1}
7f00000007000000
7f00000007000000
7f00000007000000
0000007fe0000000
7f00000007000000
7f00000007000000
0000007fe0000000
7f00000007000000
0000007fe0000000
-
{e=>1,c=>0,a=>54,b=>1,d=>1}
360000000d000000
360000000d000000
360000000d000000
00000036b0000000
360000000d000000
360000000d000000
00000036b0000000
360000000d000000
00000036b0000000
=
struct uchar {
  int a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
  unsigned int   f;
};
-
{e=>0,c=>0,a=>-63,b=>1,d=>1,f=>112}
c1ffffff0500000070000000
c1ffffff0500000070000000
c1ffffff0500000070000000
ffffffc1a000000000000070
c1ffffff0500000070000000
c1ffffff0500000070000000
ffffffc1a000000000000070
c1ffffff0500000070000000
ffffffc1a000000000000070
-
{e=>0,c=>1,a=>-107,b=>0,d=>0,f=>190}
95ffffff02000000be000000
95ffffff02000000be000000
95ffffff02000000be000000
ffffff9540000000000000be
95ffffff02000000be000000
95ffffff02000000be000000
ffffff9540000000000000be
95ffffff02000000be000000
ffffff9540000000000000be
-
{e=>0,c=>0,a=>-47,b=>1,d=>1,f=>78}
d1ffffff050000004e000000
d1ffffff050000004e000000
d1ffffff050000004e000000
ffffffd1a00000000000004e
d1ffffff050000004e000000
d1ffffff050000004e000000
ffffffd1a00000000000004e
d1ffffff050000004e000000
ffffffd1a00000000000004e
-
{e=>1,c=>0,a=>65,b=>1,d=>1,f=>14}
410000000d0000000e000000
410000000d0000000e000000
410000000d0000000e000000
00000041b00000000000000e
410000000d0000000e000000
410000000d0000000e000000
00000041b00000000000000e
410000000d0000000e000000
00000041b00000000000000e
-
{e=>1,c=>0,a=>52,b=>0,d=>1,f=>169}
340000000c000000a9000000
340000000c000000a9000000
340000000c000000a9000000
0000003430000000000000a9
340000000c000000a9000000
340000000c000000a9000000
0000003430000000000000a9
340000000c000000a9000000
0000003430000000000000a9
=
struct uchar {
  long a;
  unsigned char  b:1;
};
-
{a=>118,b=>0}
7600000000000000
76000000000000000000000000000000
76000000000000000000000000000000
0000007600000000
7600000000000000
7600000000000000
00000000000000760000000000000000
7600000000000000
0000007600000000
-
{a=>-95,b=>1}
a1ffffff01000000
a1ffffffffffffff0100000000000000
a1ffffffffffffff0100000000000000
ffffffa180000000
a1ffffff01000000
a1ffffff01000000
ffffffffffffffa18000000000000000
a1ffffff01000000
ffffffa180000000
-
{a=>38,b=>0}
2600000000000000
26000000000000000000000000000000
26000000000000000000000000000000
0000002600000000
2600000000000000
2600000000000000
00000000000000260000000000000000
2600000000000000
0000002600000000
-
{a=>50,b=>0}
3200000000000000
32000000000000000000000000000000
32000000000000000000000000000000
0000003200000000
3200000000000000
3200000000000000
00000000000000320000000000000000
3200000000000000
0000003200000000
-
{a=>81,b=>0}
5100000000000000
51000000000000000000000000000000
51000000000000000000000000000000
0000005100000000
5100000000000000
5100000000000000
00000000000000510000000000000000
5100000000000000
0000005100000000
=
struct uchar {
  long a;
  unsigned char  b:1;
  unsigned char  c:1;
};
-
{c=>0,a=>97,b=>0}
6100000000000000
61000000000000000000000000000000
61000000000000000000000000000000
0000006100000000
6100000000000000
6100000000000000
00000000000000610000000000000000
6100000000000000
0000006100000000
-
{c=>0,a=>-20,b=>0}
ecffffff00000000
ecffffffffffffff0000000000000000
ecffffffffffffff0000000000000000
ffffffec00000000
ecffffff00000000
ecffffff00000000
ffffffffffffffec0000000000000000
ecffffff00000000
ffffffec00000000
-
{c=>0,a=>-81,b=>0}
afffffff00000000
afffffffffffffff0000000000000000
afffffffffffffff0000000000000000
ffffffaf00000000
afffffff00000000
afffffff00000000
ffffffffffffffaf0000000000000000
afffffff00000000
ffffffaf00000000
-
{c=>0,a=>75,b=>0}
4b00000000000000
4b000000000000000000000000000000
4b000000000000000000000000000000
0000004b00000000
4b00000000000000
4b00000000000000
000000000000004b0000000000000000
4b00000000000000
0000004b00000000
-
{c=>0,a=>-108,b=>1}
94ffffff01000000
94ffffffffffffff0100000000000000
94ffffffffffffff0100000000000000
ffffff9480000000
94ffffff01000000
94ffffff01000000
ffffffffffffff948000000000000000
94ffffff01000000
ffffff9480000000
=
struct uchar {
  long a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
};
-
{c=>1,a=>101,b=>1,d=>0}
6500000003000000
65000000000000000300000000000000
65000000000000000300000000000000
00000065c0000000
6500000003000000
6500000003000000
0000000000000065c000000000000000
6500000003000000
00000065c0000000
-
{c=>0,a=>-71,b=>0,d=>1}
b9ffffff04000000
b9ffffffffffffff0400000000000000
b9ffffffffffffff0400000000000000
ffffffb920000000
b9ffffff04000000
b9ffffff04000000
ffffffffffffffb92000000000000000
b9ffffff04000000
ffffffb920000000
-
{c=>1,a=>-61,b=>0,d=>1}
c3ffffff06000000
c3ffffffffffffff0600000000000000
c3ffffffffffffff0600000000000000
ffffffc360000000
c3ffffff06000000
c3ffffff06000000
ffffffffffffffc36000000000000000
c3ffffff06000000
ffffffc360000000
-
{c=>1,a=>-98,b=>0,d=>1}
9effffff06000000
9effffffffffffff0600000000000000
9effffffffffffff0600000000000000
ffffff9e60000000
9effffff06000000
9effffff06000000
ffffffffffffff9e6000000000000000
9effffff06000000
ffffff9e60000000
-
{c=>0,a=>86,b=>0,d=>0}
5600000000000000
56000000000000000000000000000000
56000000000000000000000000000000
0000005600000000
5600000000000000
5600000000000000
00000000000000560000000000000000
5600000000000000
0000005600000000
=
struct uchar {
  long a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
};
-
{e=>0,c=>1,a=>-117,b=>1,d=>1}
8bffffff07000000
8bffffffffffffff0700000000000000
8bffffffffffffff0700000000000000
ffffff8be0000000
8bffffff07000000
8bffffff07000000
ffffffffffffff8be000000000000000
8bffffff07000000
ffffff8be0000000
-
{e=>1,c=>0,a=>47,b=>1,d=>1}
2f0000000d000000
2f000000000000000d00000000000000
2f000000000000000d00000000000000
0000002fb0000000
2f0000000d000000
2f0000000d000000
000000000000002fb000000000000000
2f0000000d000000
0000002fb0000000
-
{e=>1,c=>1,a=>-116,b=>0,d=>0}
8cffffff0a000000
8cffffffffffffff0a00000000000000
8cffffffffffffff0a00000000000000
ffffff8c50000000
8cffffff0a000000
8cffffff0a000000
ffffffffffffff8c5000000000000000
8cffffff0a000000
ffffff8c50000000
-
{e=>1,c=>1,a=>-118,b=>0,d=>1}
8affffff0e000000
8affffffffffffff0e00000000000000
8affffffffffffff0e00000000000000
ffffff8a70000000
8affffff0e000000
8affffff0e000000
ffffffffffffff8a7000000000000000
8affffff0e000000
ffffff8a70000000
-
{e=>1,c=>1,a=>-38,b=>0,d=>1}
daffffff0e000000
daffffffffffffff0e00000000000000
daffffffffffffff0e00000000000000
ffffffda70000000
daffffff0e000000
daffffff0e000000
ffffffffffffffda7000000000000000
daffffff0e000000
ffffffda70000000
=
struct uchar {
  long a;
  unsigned char  b:1;
  unsigned char  c:1;
  unsigned char  d:1;
  unsigned char  e:1;
  unsigned int   f;
};
-
{e=>0,c=>1,a=>-47,b=>0,d=>1,f=>41}
d1ffffff0600000029000000
d1ffffffffffffff0600000029000000
d1ffffffffffffff0600000029000000
ffffffd16000000000000029
d1ffffff0600000029000000
d1ffffff0600000029000000
ffffffffffffffd16000000000000029
d1ffffff0600000029000000
ffffffd16000000000000029
-
{e=>0,c=>1,a=>-89,b=>1,d=>0,f=>152}
a7ffffff0300000098000000
a7ffffffffffffff0300000098000000
a7ffffffffffffff0300000098000000
ffffffa7c000000000000098
a7ffffff0300000098000000
a7ffffff0300000098000000
ffffffffffffffa7c000000000000098
a7ffffff0300000098000000
ffffffa7c000000000000098
-
{e=>1,c=>1,a=>114,b=>1,d=>1,f=>37}
720000000f00000025000000
72000000000000000f00000025000000
72000000000000000f00000025000000
00000072f000000000000025
720000000f00000025000000
720000000f00000025000000
0000000000000072f000000000000025
720000000f00000025000000
00000072f000000000000025
-
{e=>1,c=>1,a=>127,b=>1,d=>1,f=>22}
7f0000000f00000016000000
7f000000000000000f00000016000000
7f000000000000000f00000016000000
0000007ff000000000000016
7f0000000f00000016000000
7f0000000f00000016000000
000000000000007ff000000000000016
7f0000000f00000016000000
0000007ff000000000000016
-
{e=>0,c=>0,a=>-95,b=>1,d=>0,f=>125}
a1ffffff010000007d000000
a1ffffffffffffff010000007d000000
a1ffffffffffffff010000007d000000
ffffffa1800000000000007d
a1ffffff010000007d000000
a1ffffff010000007d000000
ffffffffffffffa1800000000000007d
a1ffffff010000007d000000
ffffffa1800000000000007d
=
struct ushort {
  unsigned short a:1;
};
-
{a=>1}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
-
{a=>1}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
-
{a=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
=
struct ushort {
  unsigned short a:1;
  unsigned short b:1;
};
-
{a=>1,b=>1}
0300
0300
0300
c000
03000000
0300
c000
0300
c000
-
{a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>1,b=>0}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
-
{a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>0,b=>1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
=
struct ushort {
  unsigned short a:1;
  unsigned short b:1;
  unsigned short c:1;
};
-
{c=>1,a=>0,b=>1}
0600
0600
0600
6000
06000000
0600
6000
0600
6000
-
{c=>0,a=>1,b=>1}
0300
0300
0300
c000
03000000
0300
c000
0300
c000
-
{c=>1,a=>0,b=>1}
0600
0600
0600
6000
06000000
0600
6000
0600
6000
-
{c=>0,a=>0,b=>1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
-
{c=>1,a=>0,b=>1}
0600
0600
0600
6000
06000000
0600
6000
0600
6000
=
struct ushort {
  unsigned short a:1;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
};
-
{c=>0,a=>0,b=>0,d=>1}
0800
0800
0800
1000
08000000
0800
1000
0800
1000
-
{c=>1,a=>1,b=>1,d=>0}
0700
0700
0700
e000
07000000
0700
e000
0700
e000
-
{c=>1,a=>1,b=>1,d=>1}
0f00
0f00
0f00
f000
0f000000
0f00
f000
0f00
f000
-
{c=>1,a=>1,b=>0,d=>0}
0500
0500
0500
a000
05000000
0500
a000
0500
a000
-
{c=>1,a=>0,b=>0,d=>0}
0400
0400
0400
2000
04000000
0400
2000
0400
2000
=
struct ushort {
  unsigned short a:1;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned int   e;
};
-
{e=>78,c=>1,a=>0,b=>0,d=>1}
0c0000004e000000
0c0000004e000000
0c0000004e000000
300000000000004e
0c0000004e000000
0c0000004e000000
300000000000004e
0c0000004e000000
300000000000004e
-
{e=>118,c=>1,a=>1,b=>0,d=>0}
0500000076000000
0500000076000000
0500000076000000
a000000000000076
0500000076000000
0500000076000000
a000000000000076
0500000076000000
a000000000000076
-
{e=>65,c=>0,a=>0,b=>1,d=>1}
0a00000041000000
0a00000041000000
0a00000041000000
5000000000000041
0a00000041000000
0a00000041000000
5000000000000041
0a00000041000000
5000000000000041
-
{e=>216,c=>0,a=>0,b=>1,d=>1}
0a000000d8000000
0a000000d8000000
0a000000d8000000
50000000000000d8
0a000000d8000000
0a000000d8000000
50000000000000d8
0a000000d8000000
50000000000000d8
-
{e=>98,c=>0,a=>0,b=>1,d=>1}
0a00000062000000
0a00000062000000
0a00000062000000
5000000000000062
0a00000062000000
0a00000062000000
5000000000000062
0a00000062000000
5000000000000062
=
struct ushort {
  char a;
  unsigned short b:1;
};
-
{a=>22,b=>1}
1601
1601
1601
1680
16010000
1601
1680
1601
1680
-
{a=>-76,b=>0}
b400
b400
b400
b400
b4000000
b400
b400
b400
b400
-
{a=>101,b=>1}
6501
6501
6501
6580
65010000
6501
6580
6501
6580
-
{a=>110,b=>0}
6e00
6e00
6e00
6e00
6e000000
6e00
6e00
6e00
6e00
-
{a=>19,b=>1}
1301
1301
1301
1380
13010000
1301
1380
1301
1380
=
struct ushort {
  char a;
  unsigned short b:1;
  unsigned short c:1;
};
-
{c=>0,a=>103,b=>1}
6701
6701
6701
6780
67010000
6701
6780
6701
6780
-
{c=>1,a=>-109,b=>1}
9303
9303
9303
93c0
93030000
9303
93c0
9303
93c0
-
{c=>1,a=>-16,b=>0}
f002
f002
f002
f040
f0020000
f002
f040
f002
f040
-
{c=>1,a=>124,b=>1}
7c03
7c03
7c03
7cc0
7c030000
7c03
7cc0
7c03
7cc0
-
{c=>1,a=>109,b=>0}
6d02
6d02
6d02
6d40
6d020000
6d02
6d40
6d02
6d40
=
struct ushort {
  char a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
};
-
{c=>0,a=>-25,b=>1,d=>0}
e701
e701
e701
e780
e7010000
e701
e780
e701
e780
-
{c=>1,a=>-79,b=>0,d=>0}
b102
b102
b102
b140
b1020000
b102
b140
b102
b140
-
{c=>1,a=>102,b=>0,d=>1}
6606
6606
6606
6660
66060000
6606
6660
6606
6660
-
{c=>0,a=>125,b=>1,d=>1}
7d05
7d05
7d05
7da0
7d050000
7d05
7da0
7d05
7da0
-
{c=>0,a=>5,b=>1,d=>1}
0505
0505
0505
05a0
05050000
0505
05a0
0505
05a0
=
struct ushort {
  char a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
};
-
{e=>1,c=>0,a=>9,b=>1,d=>0}
0909
0909
0909
0990
09090000
0909
0990
0909
0990
-
{e=>1,c=>0,a=>44,b=>1,d=>1}
2c0d
2c0d
2c0d
2cb0
2c0d0000
2c0d
2cb0
2c0d
2cb0
-
{e=>0,c=>0,a=>44,b=>0,d=>0}
2c00
2c00
2c00
2c00
2c000000
2c00
2c00
2c00
2c00
-
{e=>1,c=>1,a=>-13,b=>0,d=>1}
f30e
f30e
f30e
f370
f30e0000
f30e
f370
f30e
f370
-
{e=>0,c=>1,a=>-2,b=>0,d=>0}
fe02
fe02
fe02
fe40
fe020000
fe02
fe40
fe02
fe40
=
struct ushort {
  char a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
  unsigned int   f;
};
-
{e=>1,c=>1,a=>107,b=>1,d=>0,f=>112}
6b0b000070000000
6b0b000070000000
6b0b000070000000
6bd0000000000070
6b0b000070000000
6b0b000070000000
6bd0000000000070
6b0b000070000000
6bd0000000000070
-
{e=>0,c=>1,a=>-68,b=>1,d=>1,f=>129}
bc07000081000000
bc07000081000000
bc07000081000000
bce0000000000081
bc07000081000000
bc07000081000000
bce0000000000081
bc07000081000000
bce0000000000081
-
{e=>0,c=>0,a=>72,b=>1,d=>1,f=>226}
48050000e2000000
48050000e2000000
48050000e2000000
48a00000000000e2
48050000e2000000
48050000e2000000
48a00000000000e2
48050000e2000000
48a00000000000e2
-
{e=>0,c=>0,a=>-102,b=>0,d=>1,f=>147}
9a04000093000000
9a04000093000000
9a04000093000000
9a20000000000093
9a04000093000000
9a04000093000000
9a20000000000093
9a04000093000000
9a20000000000093
-
{e=>1,c=>1,a=>-25,b=>1,d=>1,f=>7}
e70f000007000000
e70f000007000000
e70f000007000000
e7f0000000000007
e70f000007000000
e70f000007000000
e7f0000000000007
e70f000007000000
e7f0000000000007
=
struct ushort {
  short a;
  unsigned short b:1;
};
-
{a=>89,b=>1}
59000100
59000100
59000100
00598000
59000100
59000100
00598000
59000100
00598000
-
{a=>-24,b=>0}
e8ff0000
e8ff0000
e8ff0000
ffe80000
e8ff0000
e8ff0000
ffe80000
e8ff0000
ffe80000
-
{a=>53,b=>1}
35000100
35000100
35000100
00358000
35000100
35000100
00358000
35000100
00358000
-
{a=>60,b=>1}
3c000100
3c000100
3c000100
003c8000
3c000100
3c000100
003c8000
3c000100
003c8000
-
{a=>-33,b=>1}
dfff0100
dfff0100
dfff0100
ffdf8000
dfff0100
dfff0100
ffdf8000
dfff0100
ffdf8000
=
struct ushort {
  short a;
  unsigned short b:1;
  unsigned short c:1;
};
-
{c=>1,a=>-21,b=>0}
ebff0200
ebff0200
ebff0200
ffeb4000
ebff0200
ebff0200
ffeb4000
ebff0200
ffeb4000
-
{c=>0,a=>65,b=>0}
41000000
41000000
41000000
00410000
41000000
41000000
00410000
41000000
00410000
-
{c=>0,a=>-82,b=>0}
aeff0000
aeff0000
aeff0000
ffae0000
aeff0000
aeff0000
ffae0000
aeff0000
ffae0000
-
{c=>1,a=>-45,b=>0}
d3ff0200
d3ff0200
d3ff0200
ffd34000
d3ff0200
d3ff0200
ffd34000
d3ff0200
ffd34000
-
{c=>1,a=>-105,b=>0}
97ff0200
97ff0200
97ff0200
ff974000
97ff0200
97ff0200
ff974000
97ff0200
ff974000
=
struct ushort {
  short a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
};
-
{c=>0,a=>5,b=>1,d=>1}
05000500
05000500
05000500
0005a000
05000500
05000500
0005a000
05000500
0005a000
-
{c=>1,a=>-68,b=>1,d=>0}
bcff0300
bcff0300
bcff0300
ffbcc000
bcff0300
bcff0300
ffbcc000
bcff0300
ffbcc000
-
{c=>1,a=>-4,b=>0,d=>0}
fcff0200
fcff0200
fcff0200
fffc4000
fcff0200
fcff0200
fffc4000
fcff0200
fffc4000
-
{c=>1,a=>122,b=>1,d=>1}
7a000700
7a000700
7a000700
007ae000
7a000700
7a000700
007ae000
7a000700
007ae000
-
{c=>1,a=>-64,b=>1,d=>0}
c0ff0300
c0ff0300
c0ff0300
ffc0c000
c0ff0300
c0ff0300
ffc0c000
c0ff0300
ffc0c000
=
struct ushort {
  short a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
};
-
{e=>1,c=>1,a=>96,b=>1,d=>1}
60000f00
60000f00
60000f00
0060f000
60000f00
60000f00
0060f000
60000f00
0060f000
-
{e=>0,c=>0,a=>-110,b=>1,d=>0}
92ff0100
92ff0100
92ff0100
ff928000
92ff0100
92ff0100
ff928000
92ff0100
ff928000
-
{e=>1,c=>1,a=>-47,b=>1,d=>0}
d1ff0b00
d1ff0b00
d1ff0b00
ffd1d000
d1ff0b00
d1ff0b00
ffd1d000
d1ff0b00
ffd1d000
-
{e=>0,c=>1,a=>71,b=>1,d=>0}
47000300
47000300
47000300
0047c000
47000300
47000300
0047c000
47000300
0047c000
-
{e=>1,c=>1,a=>-110,b=>1,d=>1}
92ff0f00
92ff0f00
92ff0f00
ff92f000
92ff0f00
92ff0f00
ff92f000
92ff0f00
ff92f000
=
struct ushort {
  short a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
  unsigned int   f;
};
-
{e=>0,c=>1,a=>-77,b=>1,d=>0,f=>56}
b3ff030038000000
b3ff030038000000
b3ff030038000000
ffb3c00000000038
b3ff030038000000
b3ff030038000000
ffb3c00000000038
b3ff030038000000
ffb3c00000000038
-
{e=>0,c=>0,a=>108,b=>1,d=>1,f=>82}
6c00050052000000
6c00050052000000
6c00050052000000
006ca00000000052
6c00050052000000
6c00050052000000
006ca00000000052
6c00050052000000
006ca00000000052
-
{e=>0,c=>0,a=>4,b=>1,d=>1,f=>96}
0400050060000000
0400050060000000
0400050060000000
0004a00000000060
0400050060000000
0400050060000000
0004a00000000060
0400050060000000
0004a00000000060
-
{e=>0,c=>0,a=>93,b=>1,d=>1,f=>28}
5d0005001c000000
5d0005001c000000
5d0005001c000000
005da0000000001c
5d0005001c000000
5d0005001c000000
005da0000000001c
5d0005001c000000
005da0000000001c
-
{e=>1,c=>0,a=>40,b=>1,d=>1,f=>174}
28000d00ae000000
28000d00ae000000
28000d00ae000000
0028b000000000ae
28000d00ae000000
28000d00ae000000
0028b000000000ae
28000d00ae000000
0028b000000000ae
=
struct ushort {
  int a;
  unsigned short b:1;
};
-
{a=>88,b=>1}
5800000001000000
5800000001000000
5800000001000000
0000005880000000
5800000001000000
5800000001000000
0000005880000000
5800000001000000
0000005880000000
-
{a=>-118,b=>1}
8affffff01000000
8affffff01000000
8affffff01000000
ffffff8a80000000
8affffff01000000
8affffff01000000
ffffff8a80000000
8affffff01000000
ffffff8a80000000
-
{a=>122,b=>1}
7a00000001000000
7a00000001000000
7a00000001000000
0000007a80000000
7a00000001000000
7a00000001000000
0000007a80000000
7a00000001000000
0000007a80000000
-
{a=>-125,b=>0}
83ffffff00000000
83ffffff00000000
83ffffff00000000
ffffff8300000000
83ffffff00000000
83ffffff00000000
ffffff8300000000
83ffffff00000000
ffffff8300000000
-
{a=>-83,b=>0}
adffffff00000000
adffffff00000000
adffffff00000000
ffffffad00000000
adffffff00000000
adffffff00000000
ffffffad00000000
adffffff00000000
ffffffad00000000
=
struct ushort {
  int a;
  unsigned short b:1;
  unsigned short c:1;
};
-
{c=>0,a=>-73,b=>1}
b7ffffff01000000
b7ffffff01000000
b7ffffff01000000
ffffffb780000000
b7ffffff01000000
b7ffffff01000000
ffffffb780000000
b7ffffff01000000
ffffffb780000000
-
{c=>1,a=>41,b=>0}
2900000002000000
2900000002000000
2900000002000000
0000002940000000
2900000002000000
2900000002000000
0000002940000000
2900000002000000
0000002940000000
-
{c=>0,a=>-10,b=>0}
f6ffffff00000000
f6ffffff00000000
f6ffffff00000000
fffffff600000000
f6ffffff00000000
f6ffffff00000000
fffffff600000000
f6ffffff00000000
fffffff600000000
-
{c=>1,a=>46,b=>1}
2e00000003000000
2e00000003000000
2e00000003000000
0000002ec0000000
2e00000003000000
2e00000003000000
0000002ec0000000
2e00000003000000
0000002ec0000000
-
{c=>0,a=>91,b=>1}
5b00000001000000
5b00000001000000
5b00000001000000
0000005b80000000
5b00000001000000
5b00000001000000
0000005b80000000
5b00000001000000
0000005b80000000
=
struct ushort {
  int a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
};
-
{c=>0,a=>62,b=>1,d=>1}
3e00000005000000
3e00000005000000
3e00000005000000
0000003ea0000000
3e00000005000000
3e00000005000000
0000003ea0000000
3e00000005000000
0000003ea0000000
-
{c=>1,a=>-98,b=>1,d=>1}
9effffff07000000
9effffff07000000
9effffff07000000
ffffff9ee0000000
9effffff07000000
9effffff07000000
ffffff9ee0000000
9effffff07000000
ffffff9ee0000000
-
{c=>0,a=>-94,b=>0,d=>0}
a2ffffff00000000
a2ffffff00000000
a2ffffff00000000
ffffffa200000000
a2ffffff00000000
a2ffffff00000000
ffffffa200000000
a2ffffff00000000
ffffffa200000000
-
{c=>0,a=>36,b=>1,d=>0}
2400000001000000
2400000001000000
2400000001000000
0000002480000000
2400000001000000
2400000001000000
0000002480000000
2400000001000000
0000002480000000
-
{c=>1,a=>-4,b=>0,d=>1}
fcffffff06000000
fcffffff06000000
fcffffff06000000
fffffffc60000000
fcffffff06000000
fcffffff06000000
fffffffc60000000
fcffffff06000000
fffffffc60000000
=
struct ushort {
  int a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
};
-
{e=>0,c=>0,a=>96,b=>0,d=>0}
6000000000000000
6000000000000000
6000000000000000
0000006000000000
6000000000000000
6000000000000000
0000006000000000
6000000000000000
0000006000000000
-
{e=>1,c=>0,a=>127,b=>1,d=>0}
7f00000009000000
7f00000009000000
7f00000009000000
0000007f90000000
7f00000009000000
7f00000009000000
0000007f90000000
7f00000009000000
0000007f90000000
-
{e=>1,c=>0,a=>40,b=>0,d=>0}
2800000008000000
2800000008000000
2800000008000000
0000002810000000
2800000008000000
2800000008000000
0000002810000000
2800000008000000
0000002810000000
-
{e=>1,c=>0,a=>96,b=>0,d=>1}
600000000c000000
600000000c000000
600000000c000000
0000006030000000
600000000c000000
600000000c000000
0000006030000000
600000000c000000
0000006030000000
-
{e=>0,c=>0,a=>-42,b=>0,d=>1}
d6ffffff04000000
d6ffffff04000000
d6ffffff04000000
ffffffd620000000
d6ffffff04000000
d6ffffff04000000
ffffffd620000000
d6ffffff04000000
ffffffd620000000
=
struct ushort {
  int a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
  unsigned int   f;
};
-
{e=>0,c=>1,a=>15,b=>0,d=>0,f=>0}
0f0000000200000000000000
0f0000000200000000000000
0f0000000200000000000000
0000000f4000000000000000
0f0000000200000000000000
0f0000000200000000000000
0000000f4000000000000000
0f0000000200000000000000
0000000f4000000000000000
-
{e=>1,c=>0,a=>-90,b=>1,d=>1,f=>104}
a6ffffff0d00000068000000
a6ffffff0d00000068000000
a6ffffff0d00000068000000
ffffffa6b000000000000068
a6ffffff0d00000068000000
a6ffffff0d00000068000000
ffffffa6b000000000000068
a6ffffff0d00000068000000
ffffffa6b000000000000068
-
{e=>1,c=>0,a=>-53,b=>1,d=>0,f=>14}
cbffffff090000000e000000
cbffffff090000000e000000
cbffffff090000000e000000
ffffffcb900000000000000e
cbffffff090000000e000000
cbffffff090000000e000000
ffffffcb900000000000000e
cbffffff090000000e000000
ffffffcb900000000000000e
-
{e=>0,c=>1,a=>41,b=>0,d=>1,f=>247}
2900000006000000f7000000
2900000006000000f7000000
2900000006000000f7000000
0000002960000000000000f7
2900000006000000f7000000
2900000006000000f7000000
0000002960000000000000f7
2900000006000000f7000000
0000002960000000000000f7
-
{e=>1,c=>1,a=>-21,b=>0,d=>0,f=>111}
ebffffff0a0000006f000000
ebffffff0a0000006f000000
ebffffff0a0000006f000000
ffffffeb500000000000006f
ebffffff0a0000006f000000
ebffffff0a0000006f000000
ffffffeb500000000000006f
ebffffff0a0000006f000000
ffffffeb500000000000006f
=
struct ushort {
  long a;
  unsigned short b:1;
};
-
{a=>-109,b=>0}
93ffffff00000000
93ffffffffffffff0000000000000000
93ffffffffffffff0000000000000000
ffffff9300000000
93ffffff00000000
93ffffff00000000
ffffffffffffff930000000000000000
93ffffff00000000
ffffff9300000000
-
{a=>68,b=>1}
4400000001000000
44000000000000000100000000000000
44000000000000000100000000000000
0000004480000000
4400000001000000
4400000001000000
00000000000000448000000000000000
4400000001000000
0000004480000000
-
{a=>-127,b=>0}
81ffffff00000000
81ffffffffffffff0000000000000000
81ffffffffffffff0000000000000000
ffffff8100000000
81ffffff00000000
81ffffff00000000
ffffffffffffff810000000000000000
81ffffff00000000
ffffff8100000000
-
{a=>-101,b=>1}
9bffffff01000000
9bffffffffffffff0100000000000000
9bffffffffffffff0100000000000000
ffffff9b80000000
9bffffff01000000
9bffffff01000000
ffffffffffffff9b8000000000000000
9bffffff01000000
ffffff9b80000000
-
{a=>65,b=>1}
4100000001000000
41000000000000000100000000000000
41000000000000000100000000000000
0000004180000000
4100000001000000
4100000001000000
00000000000000418000000000000000
4100000001000000
0000004180000000
=
struct ushort {
  long a;
  unsigned short b:1;
  unsigned short c:1;
};
-
{c=>0,a=>-118,b=>0}
8affffff00000000
8affffffffffffff0000000000000000
8affffffffffffff0000000000000000
ffffff8a00000000
8affffff00000000
8affffff00000000
ffffffffffffff8a0000000000000000
8affffff00000000
ffffff8a00000000
-
{c=>0,a=>98,b=>1}
6200000001000000
62000000000000000100000000000000
62000000000000000100000000000000
0000006280000000
6200000001000000
6200000001000000
00000000000000628000000000000000
6200000001000000
0000006280000000
-
{c=>0,a=>20,b=>0}
1400000000000000
14000000000000000000000000000000
14000000000000000000000000000000
0000001400000000
1400000000000000
1400000000000000
00000000000000140000000000000000
1400000000000000
0000001400000000
-
{c=>0,a=>-71,b=>0}
b9ffffff00000000
b9ffffffffffffff0000000000000000
b9ffffffffffffff0000000000000000
ffffffb900000000
b9ffffff00000000
b9ffffff00000000
ffffffffffffffb90000000000000000
b9ffffff00000000
ffffffb900000000
-
{c=>0,a=>-104,b=>1}
98ffffff01000000
98ffffffffffffff0100000000000000
98ffffffffffffff0100000000000000
ffffff9880000000
98ffffff01000000
98ffffff01000000
ffffffffffffff988000000000000000
98ffffff01000000
ffffff9880000000
=
struct ushort {
  long a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
};
-
{c=>0,a=>31,b=>1,d=>1}
1f00000005000000
1f000000000000000500000000000000
1f000000000000000500000000000000
0000001fa0000000
1f00000005000000
1f00000005000000
000000000000001fa000000000000000
1f00000005000000
0000001fa0000000
-
{c=>1,a=>105,b=>0,d=>1}
6900000006000000
69000000000000000600000000000000
69000000000000000600000000000000
0000006960000000
6900000006000000
6900000006000000
00000000000000696000000000000000
6900000006000000
0000006960000000
-
{c=>1,a=>-124,b=>1,d=>0}
84ffffff03000000
84ffffffffffffff0300000000000000
84ffffffffffffff0300000000000000
ffffff84c0000000
84ffffff03000000
84ffffff03000000
ffffffffffffff84c000000000000000
84ffffff03000000
ffffff84c0000000
-
{c=>1,a=>11,b=>1,d=>1}
0b00000007000000
0b000000000000000700000000000000
0b000000000000000700000000000000
0000000be0000000
0b00000007000000
0b00000007000000
000000000000000be000000000000000
0b00000007000000
0000000be0000000
-
{c=>1,a=>21,b=>0,d=>1}
1500000006000000
15000000000000000600000000000000
15000000000000000600000000000000
0000001560000000
1500000006000000
1500000006000000
00000000000000156000000000000000
1500000006000000
0000001560000000
=
struct ushort {
  long a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
};
-
{e=>0,c=>0,a=>51,b=>0,d=>0}
3300000000000000
33000000000000000000000000000000
33000000000000000000000000000000
0000003300000000
3300000000000000
3300000000000000
00000000000000330000000000000000
3300000000000000
0000003300000000
-
{e=>1,c=>1,a=>16,b=>1,d=>1}
100000000f000000
10000000000000000f00000000000000
10000000000000000f00000000000000
00000010f0000000
100000000f000000
100000000f000000
0000000000000010f000000000000000
100000000f000000
00000010f0000000
-
{e=>1,c=>1,a=>-30,b=>1,d=>1}
e2ffffff0f000000
e2ffffffffffffff0f00000000000000
e2ffffffffffffff0f00000000000000
ffffffe2f0000000
e2ffffff0f000000
e2ffffff0f000000
ffffffffffffffe2f000000000000000
e2ffffff0f000000
ffffffe2f0000000
-
{e=>1,c=>0,a=>-27,b=>1,d=>0}
e5ffffff09000000
e5ffffffffffffff0900000000000000
e5ffffffffffffff0900000000000000
ffffffe590000000
e5ffffff09000000
e5ffffff09000000
ffffffffffffffe59000000000000000
e5ffffff09000000
ffffffe590000000
-
{e=>0,c=>0,a=>44,b=>1,d=>1}
2c00000005000000
2c000000000000000500000000000000
2c000000000000000500000000000000
0000002ca0000000
2c00000005000000
2c00000005000000
000000000000002ca000000000000000
2c00000005000000
0000002ca0000000
=
struct ushort {
  long a;
  unsigned short b:1;
  unsigned short c:1;
  unsigned short d:1;
  unsigned short e:1;
  unsigned int   f;
};
-
{e=>0,c=>1,a=>-43,b=>1,d=>0,f=>98}
d5ffffff0300000062000000
d5ffffffffffffff0300000062000000
d5ffffffffffffff0300000062000000
ffffffd5c000000000000062
d5ffffff0300000062000000
d5ffffff0300000062000000
ffffffffffffffd5c000000000000062
d5ffffff0300000062000000
ffffffd5c000000000000062
-
{e=>1,c=>0,a=>-40,b=>1,d=>1,f=>138}
d8ffffff0d0000008a000000
d8ffffffffffffff0d0000008a000000
d8ffffffffffffff0d0000008a000000
ffffffd8b00000000000008a
d8ffffff0d0000008a000000
d8ffffff0d0000008a000000
ffffffffffffffd8b00000000000008a
d8ffffff0d0000008a000000
ffffffd8b00000000000008a
-
{e=>1,c=>0,a=>14,b=>1,d=>1,f=>44}
0e0000000d0000002c000000
0e000000000000000d0000002c000000
0e000000000000000d0000002c000000
0000000eb00000000000002c
0e0000000d0000002c000000
0e0000000d0000002c000000
000000000000000eb00000000000002c
0e0000000d0000002c000000
0000000eb00000000000002c
-
{e=>1,c=>1,a=>-30,b=>1,d=>0,f=>32}
e2ffffff0b00000020000000
e2ffffffffffffff0b00000020000000
e2ffffffffffffff0b00000020000000
ffffffe2d000000000000020
e2ffffff0b00000020000000
e2ffffff0b00000020000000
ffffffffffffffe2d000000000000020
e2ffffff0b00000020000000
ffffffe2d000000000000020
-
{e=>0,c=>1,a=>87,b=>0,d=>1,f=>216}
5700000006000000d8000000
570000000000000006000000d8000000
570000000000000006000000d8000000
0000005760000000000000d8
5700000006000000d8000000
5700000006000000d8000000
000000000000005760000000000000d8
5700000006000000d8000000
0000005760000000000000d8
=
struct uint {
  unsigned int   a:1;
};
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>1}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>1}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
=
struct uint {
  unsigned int   a:1;
  unsigned int   b:1;
};
-
{a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct uint {
  unsigned int   a:1;
  unsigned int   b:1;
  unsigned int   c:1;
};
-
{c=>0,a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{c=>1,a=>1,b=>0}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{c=>0,a=>1,b=>1}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{c=>1,a=>0,b=>0}
04000000
04000000
04000000
20000000
04000000
04000000
20000000
04000000
20000000
-
{c=>0,a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
=
struct uint {
  unsigned int   a:1;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
};
-
{c=>0,a=>1,b=>1,d=>0}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{c=>0,a=>0,b=>0,d=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{c=>1,a=>0,b=>0,d=>1}
0c000000
0c000000
0c000000
30000000
0c000000
0c000000
30000000
0c000000
30000000
-
{c=>0,a=>0,b=>1,d=>0}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{c=>1,a=>0,b=>1,d=>0}
06000000
06000000
06000000
60000000
06000000
06000000
60000000
06000000
60000000
=
struct uint {
  unsigned int   a:1;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned char  e;
};
-
{e=>191,c=>1,a=>1,b=>1,d=>1}
0fbf0000
0fbf0000
0fbf0000
f0bf0000
0fbf0000
0fbf0000
f0bf0000
0fbf0000
f0bf0000
-
{e=>169,c=>0,a=>1,b=>0,d=>0}
01a90000
01a90000
01a90000
80a90000
01a90000
01a90000
80a90000
01a90000
80a90000
-
{e=>146,c=>0,a=>1,b=>1,d=>0}
03920000
03920000
03920000
c0920000
03920000
03920000
c0920000
03920000
c0920000
-
{e=>101,c=>1,a=>1,b=>0,d=>0}
05650000
05650000
05650000
a0650000
05650000
05650000
a0650000
05650000
a0650000
-
{e=>214,c=>0,a=>0,b=>1,d=>0}
02d60000
02d60000
02d60000
40d60000
02d60000
02d60000
40d60000
02d60000
40d60000
=
struct uint {
  char a;
  unsigned int   b:1;
};
-
{a=>75,b=>1}
4b010000
4b010000
4b010000
4b800000
4b010000
4b010000
4b800000
4b010000
4b800000
-
{a=>-108,b=>1}
94010000
94010000
94010000
94800000
94010000
94010000
94800000
94010000
94800000
-
{a=>-66,b=>0}
be000000
be000000
be000000
be000000
be000000
be000000
be000000
be000000
be000000
-
{a=>70,b=>0}
46000000
46000000
46000000
46000000
46000000
46000000
46000000
46000000
46000000
-
{a=>42,b=>0}
2a000000
2a000000
2a000000
2a000000
2a000000
2a000000
2a000000
2a000000
2a000000
=
struct uint {
  char a;
  unsigned int   b:1;
  unsigned int   c:1;
};
-
{c=>1,a=>-100,b=>1}
9c030000
9c030000
9c030000
9cc00000
9c030000
9c030000
9cc00000
9c030000
9cc00000
-
{c=>1,a=>93,b=>0}
5d020000
5d020000
5d020000
5d400000
5d020000
5d020000
5d400000
5d020000
5d400000
-
{c=>1,a=>40,b=>0}
28020000
28020000
28020000
28400000
28020000
28020000
28400000
28020000
28400000
-
{c=>1,a=>-20,b=>1}
ec030000
ec030000
ec030000
ecc00000
ec030000
ec030000
ecc00000
ec030000
ecc00000
-
{c=>1,a=>5,b=>0}
05020000
05020000
05020000
05400000
05020000
05020000
05400000
05020000
05400000
=
struct uint {
  char a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
};
-
{c=>0,a=>-26,b=>0,d=>0}
e6000000
e6000000
e6000000
e6000000
e6000000
e6000000
e6000000
e6000000
e6000000
-
{c=>0,a=>-121,b=>0,d=>0}
87000000
87000000
87000000
87000000
87000000
87000000
87000000
87000000
87000000
-
{c=>1,a=>2,b=>0,d=>1}
02060000
02060000
02060000
02600000
02060000
02060000
02600000
02060000
02600000
-
{c=>1,a=>-54,b=>1,d=>0}
ca030000
ca030000
ca030000
cac00000
ca030000
ca030000
cac00000
ca030000
cac00000
-
{c=>1,a=>79,b=>0,d=>0}
4f020000
4f020000
4f020000
4f400000
4f020000
4f020000
4f400000
4f020000
4f400000
=
struct uint {
  char a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
};
-
{e=>0,c=>1,a=>123,b=>0,d=>1}
7b060000
7b060000
7b060000
7b600000
7b060000
7b060000
7b600000
7b060000
7b600000
-
{e=>0,c=>0,a=>-85,b=>1,d=>0}
ab010000
ab010000
ab010000
ab800000
ab010000
ab010000
ab800000
ab010000
ab800000
-
{e=>0,c=>1,a=>108,b=>1,d=>0}
6c030000
6c030000
6c030000
6cc00000
6c030000
6c030000
6cc00000
6c030000
6cc00000
-
{e=>0,c=>0,a=>5,b=>1,d=>0}
05010000
05010000
05010000
05800000
05010000
05010000
05800000
05010000
05800000
-
{e=>1,c=>0,a=>37,b=>0,d=>0}
25080000
25080000
25080000
25100000
25080000
25080000
25100000
25080000
25100000
=
struct uint {
  char a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>-3,b=>0,d=>0,f=>33}
fd0a2100
fd0a2100
fd0a2100
fd502100
fd0a2100
fd0a2100
fd502100
fd0a2100
fd502100
-
{e=>1,c=>0,a=>-54,b=>1,d=>1,f=>25}
ca0d1900
ca0d1900
ca0d1900
cab01900
ca0d1900
ca0d1900
cab01900
ca0d1900
cab01900
-
{e=>1,c=>1,a=>99,b=>0,d=>0,f=>1}
630a0100
630a0100
630a0100
63500100
630a0100
630a0100
63500100
630a0100
63500100
-
{e=>0,c=>0,a=>36,b=>0,d=>1,f=>171}
2404ab00
2404ab00
2404ab00
2420ab00
2404ab00
2404ab00
2420ab00
2404ab00
2420ab00
-
{e=>0,c=>0,a=>-112,b=>0,d=>1,f=>44}
90042c00
90042c00
90042c00
90202c00
90042c00
90042c00
90202c00
90042c00
90202c00
=
struct uint {
  short a;
  unsigned int   b:1;
};
-
{a=>17,b=>1}
11000100
11000100
11000100
00118000
11000100
11000100
00118000
11000100
00118000
-
{a=>-109,b=>0}
93ff0000
93ff0000
93ff0000
ff930000
93ff0000
93ff0000
ff930000
93ff0000
ff930000
-
{a=>66,b=>1}
42000100
42000100
42000100
00428000
42000100
42000100
00428000
42000100
00428000
-
{a=>15,b=>0}
0f000000
0f000000
0f000000
000f0000
0f000000
0f000000
000f0000
0f000000
000f0000
-
{a=>67,b=>1}
43000100
43000100
43000100
00438000
43000100
43000100
00438000
43000100
00438000
=
struct uint {
  short a;
  unsigned int   b:1;
  unsigned int   c:1;
};
-
{c=>1,a=>-17,b=>0}
efff0200
efff0200
efff0200
ffef4000
efff0200
efff0200
ffef4000
efff0200
ffef4000
-
{c=>0,a=>-96,b=>0}
a0ff0000
a0ff0000
a0ff0000
ffa00000
a0ff0000
a0ff0000
ffa00000
a0ff0000
ffa00000
-
{c=>0,a=>19,b=>0}
13000000
13000000
13000000
00130000
13000000
13000000
00130000
13000000
00130000
-
{c=>1,a=>-75,b=>1}
b5ff0300
b5ff0300
b5ff0300
ffb5c000
b5ff0300
b5ff0300
ffb5c000
b5ff0300
ffb5c000
-
{c=>0,a=>-26,b=>1}
e6ff0100
e6ff0100
e6ff0100
ffe68000
e6ff0100
e6ff0100
ffe68000
e6ff0100
ffe68000
=
struct uint {
  short a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
};
-
{c=>0,a=>-128,b=>0,d=>1}
80ff0400
80ff0400
80ff0400
ff802000
80ff0400
80ff0400
ff802000
80ff0400
ff802000
-
{c=>0,a=>6,b=>0,d=>1}
06000400
06000400
06000400
00062000
06000400
06000400
00062000
06000400
00062000
-
{c=>1,a=>-76,b=>1,d=>0}
b4ff0300
b4ff0300
b4ff0300
ffb4c000
b4ff0300
b4ff0300
ffb4c000
b4ff0300
ffb4c000
-
{c=>0,a=>-60,b=>1,d=>0}
c4ff0100
c4ff0100
c4ff0100
ffc48000
c4ff0100
c4ff0100
ffc48000
c4ff0100
ffc48000
-
{c=>1,a=>-102,b=>1,d=>1}
9aff0700
9aff0700
9aff0700
ff9ae000
9aff0700
9aff0700
ff9ae000
9aff0700
ff9ae000
=
struct uint {
  short a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
};
-
{e=>0,c=>0,a=>-11,b=>0,d=>1}
f5ff0400
f5ff0400
f5ff0400
fff52000
f5ff0400
f5ff0400
fff52000
f5ff0400
fff52000
-
{e=>1,c=>0,a=>-23,b=>1,d=>1}
e9ff0d00
e9ff0d00
e9ff0d00
ffe9b000
e9ff0d00
e9ff0d00
ffe9b000
e9ff0d00
ffe9b000
-
{e=>1,c=>1,a=>81,b=>0,d=>0}
51000a00
51000a00
51000a00
00515000
51000a00
51000a00
00515000
51000a00
00515000
-
{e=>0,c=>0,a=>16,b=>0,d=>0}
10000000
10000000
10000000
00100000
10000000
10000000
00100000
10000000
00100000
-
{e=>1,c=>1,a=>90,b=>1,d=>0}
5a000b00
5a000b00
5a000b00
005ad000
5a000b00
5a000b00
005ad000
5a000b00
005ad000
=
struct uint {
  short a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
  unsigned char  f;
};
-
{e=>0,c=>1,a=>108,b=>0,d=>1,f=>91}
6c00065b
6c00065b
6c00065b
006c605b
6c00065b
6c00065b
006c605b
6c00065b
006c605b
-
{e=>0,c=>0,a=>113,b=>1,d=>0,f=>123}
7100017b
7100017b
7100017b
0071807b
7100017b
7100017b
0071807b
7100017b
0071807b
-
{e=>0,c=>0,a=>-118,b=>1,d=>1,f=>27}
8aff051b
8aff051b
8aff051b
ff8aa01b
8aff051b
8aff051b
ff8aa01b
8aff051b
ff8aa01b
-
{e=>0,c=>0,a=>105,b=>1,d=>1,f=>227}
690005e3
690005e3
690005e3
0069a0e3
690005e3
690005e3
0069a0e3
690005e3
0069a0e3
-
{e=>0,c=>1,a=>58,b=>0,d=>0,f=>37}
3a000225
3a000225
3a000225
003a4025
3a000225
3a000225
003a4025
3a000225
003a4025
=
struct uint {
  int a;
  unsigned int   b:1;
};
-
{a=>123,b=>0}
7b00000000000000
7b00000000000000
7b00000000000000
0000007b00000000
7b00000000000000
7b00000000000000
0000007b00000000
7b00000000000000
0000007b00000000
-
{a=>-82,b=>1}
aeffffff01000000
aeffffff01000000
aeffffff01000000
ffffffae80000000
aeffffff01000000
aeffffff01000000
ffffffae80000000
aeffffff01000000
ffffffae80000000
-
{a=>-71,b=>0}
b9ffffff00000000
b9ffffff00000000
b9ffffff00000000
ffffffb900000000
b9ffffff00000000
b9ffffff00000000
ffffffb900000000
b9ffffff00000000
ffffffb900000000
-
{a=>-16,b=>0}
f0ffffff00000000
f0ffffff00000000
f0ffffff00000000
fffffff000000000
f0ffffff00000000
f0ffffff00000000
fffffff000000000
f0ffffff00000000
fffffff000000000
-
{a=>82,b=>0}
5200000000000000
5200000000000000
5200000000000000
0000005200000000
5200000000000000
5200000000000000
0000005200000000
5200000000000000
0000005200000000
=
struct uint {
  int a;
  unsigned int   b:1;
  unsigned int   c:1;
};
-
{c=>0,a=>-82,b=>1}
aeffffff01000000
aeffffff01000000
aeffffff01000000
ffffffae80000000
aeffffff01000000
aeffffff01000000
ffffffae80000000
aeffffff01000000
ffffffae80000000
-
{c=>1,a=>76,b=>1}
4c00000003000000
4c00000003000000
4c00000003000000
0000004cc0000000
4c00000003000000
4c00000003000000
0000004cc0000000
4c00000003000000
0000004cc0000000
-
{c=>0,a=>90,b=>1}
5a00000001000000
5a00000001000000
5a00000001000000
0000005a80000000
5a00000001000000
5a00000001000000
0000005a80000000
5a00000001000000
0000005a80000000
-
{c=>0,a=>-87,b=>1}
a9ffffff01000000
a9ffffff01000000
a9ffffff01000000
ffffffa980000000
a9ffffff01000000
a9ffffff01000000
ffffffa980000000
a9ffffff01000000
ffffffa980000000
-
{c=>1,a=>-70,b=>0}
baffffff02000000
baffffff02000000
baffffff02000000
ffffffba40000000
baffffff02000000
baffffff02000000
ffffffba40000000
baffffff02000000
ffffffba40000000
=
struct uint {
  int a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
};
-
{c=>0,a=>103,b=>1,d=>1}
6700000005000000
6700000005000000
6700000005000000
00000067a0000000
6700000005000000
6700000005000000
00000067a0000000
6700000005000000
00000067a0000000
-
{c=>0,a=>-102,b=>1,d=>0}
9affffff01000000
9affffff01000000
9affffff01000000
ffffff9a80000000
9affffff01000000
9affffff01000000
ffffff9a80000000
9affffff01000000
ffffff9a80000000
-
{c=>1,a=>8,b=>1,d=>1}
0800000007000000
0800000007000000
0800000007000000
00000008e0000000
0800000007000000
0800000007000000
00000008e0000000
0800000007000000
00000008e0000000
-
{c=>1,a=>24,b=>0,d=>1}
1800000006000000
1800000006000000
1800000006000000
0000001860000000
1800000006000000
1800000006000000
0000001860000000
1800000006000000
0000001860000000
-
{c=>0,a=>-37,b=>1,d=>1}
dbffffff05000000
dbffffff05000000
dbffffff05000000
ffffffdba0000000
dbffffff05000000
dbffffff05000000
ffffffdba0000000
dbffffff05000000
ffffffdba0000000
=
struct uint {
  int a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
};
-
{e=>1,c=>1,a=>73,b=>0,d=>0}
490000000a000000
490000000a000000
490000000a000000
0000004950000000
490000000a000000
490000000a000000
0000004950000000
490000000a000000
0000004950000000
-
{e=>0,c=>0,a=>-47,b=>1,d=>1}
d1ffffff05000000
d1ffffff05000000
d1ffffff05000000
ffffffd1a0000000
d1ffffff05000000
d1ffffff05000000
ffffffd1a0000000
d1ffffff05000000
ffffffd1a0000000
-
{e=>1,c=>1,a=>105,b=>0,d=>1}
690000000e000000
690000000e000000
690000000e000000
0000006970000000
690000000e000000
690000000e000000
0000006970000000
690000000e000000
0000006970000000
-
{e=>1,c=>0,a=>39,b=>1,d=>1}
270000000d000000
270000000d000000
270000000d000000
00000027b0000000
270000000d000000
270000000d000000
00000027b0000000
270000000d000000
00000027b0000000
-
{e=>0,c=>1,a=>-19,b=>0,d=>0}
edffffff02000000
edffffff02000000
edffffff02000000
ffffffed40000000
edffffff02000000
edffffff02000000
ffffffed40000000
edffffff02000000
ffffffed40000000
=
struct uint {
  int a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
  unsigned char  f;
};
-
{e=>0,c=>1,a=>-13,b=>0,d=>0,f=>179}
f3ffffff02b30000
f3ffffff02b30000
f3ffffff02b30000
fffffff340b30000
f3ffffff02b30000
f3ffffff02b30000
fffffff340b30000
f3ffffff02b30000
fffffff340b30000
-
{e=>0,c=>1,a=>-50,b=>0,d=>1,f=>86}
ceffffff06560000
ceffffff06560000
ceffffff06560000
ffffffce60560000
ceffffff06560000
ceffffff06560000
ffffffce60560000
ceffffff06560000
ffffffce60560000
-
{e=>1,c=>1,a=>127,b=>0,d=>1,f=>197}
7f0000000ec50000
7f0000000ec50000
7f0000000ec50000
0000007f70c50000
7f0000000ec50000
7f0000000ec50000
0000007f70c50000
7f0000000ec50000
0000007f70c50000
-
{e=>0,c=>1,a=>22,b=>0,d=>1,f=>205}
1600000006cd0000
1600000006cd0000
1600000006cd0000
0000001660cd0000
1600000006cd0000
1600000006cd0000
0000001660cd0000
1600000006cd0000
0000001660cd0000
-
{e=>1,c=>1,a=>-24,b=>1,d=>0,f=>208}
e8ffffff0bd00000
e8ffffff0bd00000
e8ffffff0bd00000
ffffffe8d0d00000
e8ffffff0bd00000
e8ffffff0bd00000
ffffffe8d0d00000
e8ffffff0bd00000
ffffffe8d0d00000
=
struct uint {
  long a;
  unsigned int   b:1;
};
-
{a=>125,b=>0}
7d00000000000000
7d000000000000000000000000000000
7d000000000000000000000000000000
0000007d00000000
7d00000000000000
7d00000000000000
000000000000007d0000000000000000
7d00000000000000
0000007d00000000
-
{a=>76,b=>0}
4c00000000000000
4c000000000000000000000000000000
4c000000000000000000000000000000
0000004c00000000
4c00000000000000
4c00000000000000
000000000000004c0000000000000000
4c00000000000000
0000004c00000000
-
{a=>118,b=>1}
7600000001000000
76000000000000000100000000000000
76000000000000000100000000000000
0000007680000000
7600000001000000
7600000001000000
00000000000000768000000000000000
7600000001000000
0000007680000000
-
{a=>39,b=>1}
2700000001000000
27000000000000000100000000000000
27000000000000000100000000000000
0000002780000000
2700000001000000
2700000001000000
00000000000000278000000000000000
2700000001000000
0000002780000000
-
{a=>117,b=>0}
7500000000000000
75000000000000000000000000000000
75000000000000000000000000000000
0000007500000000
7500000000000000
7500000000000000
00000000000000750000000000000000
7500000000000000
0000007500000000
=
struct uint {
  long a;
  unsigned int   b:1;
  unsigned int   c:1;
};
-
{c=>0,a=>96,b=>1}
6000000001000000
60000000000000000100000000000000
60000000000000000100000000000000
0000006080000000
6000000001000000
6000000001000000
00000000000000608000000000000000
6000000001000000
0000006080000000
-
{c=>0,a=>85,b=>0}
5500000000000000
55000000000000000000000000000000
55000000000000000000000000000000
0000005500000000
5500000000000000
5500000000000000
00000000000000550000000000000000
5500000000000000
0000005500000000
-
{c=>0,a=>-120,b=>1}
88ffffff01000000
88ffffffffffffff0100000000000000
88ffffffffffffff0100000000000000
ffffff8880000000
88ffffff01000000
88ffffff01000000
ffffffffffffff888000000000000000
88ffffff01000000
ffffff8880000000
-
{c=>1,a=>46,b=>1}
2e00000003000000
2e000000000000000300000000000000
2e000000000000000300000000000000
0000002ec0000000
2e00000003000000
2e00000003000000
000000000000002ec000000000000000
2e00000003000000
0000002ec0000000
-
{c=>1,a=>-15,b=>1}
f1ffffff03000000
f1ffffffffffffff0300000000000000
f1ffffffffffffff0300000000000000
fffffff1c0000000
f1ffffff03000000
f1ffffff03000000
fffffffffffffff1c000000000000000
f1ffffff03000000
fffffff1c0000000
=
struct uint {
  long a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
};
-
{c=>1,a=>86,b=>0,d=>0}
5600000002000000
56000000000000000200000000000000
56000000000000000200000000000000
0000005640000000
5600000002000000
5600000002000000
00000000000000564000000000000000
5600000002000000
0000005640000000
-
{c=>0,a=>-29,b=>1,d=>1}
e3ffffff05000000
e3ffffffffffffff0500000000000000
e3ffffffffffffff0500000000000000
ffffffe3a0000000
e3ffffff05000000
e3ffffff05000000
ffffffffffffffe3a000000000000000
e3ffffff05000000
ffffffe3a0000000
-
{c=>0,a=>97,b=>1,d=>0}
6100000001000000
61000000000000000100000000000000
61000000000000000100000000000000
0000006180000000
6100000001000000
6100000001000000
00000000000000618000000000000000
6100000001000000
0000006180000000
-
{c=>1,a=>92,b=>1,d=>0}
5c00000003000000
5c000000000000000300000000000000
5c000000000000000300000000000000
0000005cc0000000
5c00000003000000
5c00000003000000
000000000000005cc000000000000000
5c00000003000000
0000005cc0000000
-
{c=>1,a=>-52,b=>0,d=>1}
ccffffff06000000
ccffffffffffffff0600000000000000
ccffffffffffffff0600000000000000
ffffffcc60000000
ccffffff06000000
ccffffff06000000
ffffffffffffffcc6000000000000000
ccffffff06000000
ffffffcc60000000
=
struct uint {
  long a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
};
-
{e=>1,c=>1,a=>46,b=>1,d=>0}
2e0000000b000000
2e000000000000000b00000000000000
2e000000000000000b00000000000000
0000002ed0000000
2e0000000b000000
2e0000000b000000
000000000000002ed000000000000000
2e0000000b000000
0000002ed0000000
-
{e=>0,c=>1,a=>6,b=>0,d=>1}
0600000006000000
06000000000000000600000000000000
06000000000000000600000000000000
0000000660000000
0600000006000000
0600000006000000
00000000000000066000000000000000
0600000006000000
0000000660000000
-
{e=>0,c=>1,a=>-88,b=>1,d=>0}
a8ffffff03000000
a8ffffffffffffff0300000000000000
a8ffffffffffffff0300000000000000
ffffffa8c0000000
a8ffffff03000000
a8ffffff03000000
ffffffffffffffa8c000000000000000
a8ffffff03000000
ffffffa8c0000000
-
{e=>1,c=>1,a=>61,b=>0,d=>0}
3d0000000a000000
3d000000000000000a00000000000000
3d000000000000000a00000000000000
0000003d50000000
3d0000000a000000
3d0000000a000000
000000000000003d5000000000000000
3d0000000a000000
0000003d50000000
-
{e=>1,c=>1,a=>-91,b=>0,d=>1}
a5ffffff0e000000
a5ffffffffffffff0e00000000000000
a5ffffffffffffff0e00000000000000
ffffffa570000000
a5ffffff0e000000
a5ffffff0e000000
ffffffffffffffa57000000000000000
a5ffffff0e000000
ffffffa570000000
=
struct uint {
  long a;
  unsigned int   b:1;
  unsigned int   c:1;
  unsigned int   d:1;
  unsigned int   e:1;
  unsigned char  f;
};
-
{e=>1,c=>0,a=>0,b=>0,d=>0,f=>3}
0000000008030000
00000000000000000803000000000000
00000000000000000803000000000000
0000000010030000
0000000008030000
0000000008030000
00000000000000001003000000000000
0000000008030000
0000000010030000
-
{e=>1,c=>0,a=>-78,b=>1,d=>0,f=>176}
b2ffffff09b00000
b2ffffffffffffff09b0000000000000
b2ffffffffffffff09b0000000000000
ffffffb290b00000
b2ffffff09b00000
b2ffffff09b00000
ffffffffffffffb290b0000000000000
b2ffffff09b00000
ffffffb290b00000
-
{e=>0,c=>1,a=>-121,b=>1,d=>1,f=>153}
87ffffff07990000
87ffffffffffffff0799000000000000
87ffffffffffffff0799000000000000
ffffff87e0990000
87ffffff07990000
87ffffff07990000
ffffffffffffff87e099000000000000
87ffffff07990000
ffffff87e0990000
-
{e=>0,c=>1,a=>-50,b=>1,d=>0,f=>143}
ceffffff038f0000
ceffffffffffffff038f000000000000
ceffffffffffffff038f000000000000
ffffffcec08f0000
ceffffff038f0000
ceffffff038f0000
ffffffffffffffcec08f000000000000
ceffffff038f0000
ffffffcec08f0000
-
{e=>0,c=>1,a=>-106,b=>0,d=>0,f=>229}
96ffffff02e50000
96ffffffffffffff02e5000000000000
96ffffffffffffff02e5000000000000
ffffff9640e50000
96ffffff02e50000
96ffffff02e50000
ffffffffffffff9640e5000000000000
96ffffff02e50000
ffffff9640e50000
=
struct ulong {
  unsigned long  a:1;
};
-
{a=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
-
{a=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
-
{a=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
-
{a=>1}
01000000
0100000000000000
0100000000000000
80000000
01000000
01000000
8000000000000000
01000000
80000000
-
{a=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
=
struct ulong {
  unsigned long  a:1;
  unsigned long  b:1;
};
-
{a=>0,b=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
-
{a=>1,b=>1}
03000000
0300000000000000
0300000000000000
c0000000
03000000
03000000
c000000000000000
03000000
c0000000
-
{a=>1,b=>0}
01000000
0100000000000000
0100000000000000
80000000
01000000
01000000
8000000000000000
01000000
80000000
-
{a=>1,b=>1}
03000000
0300000000000000
0300000000000000
c0000000
03000000
03000000
c000000000000000
03000000
c0000000
-
{a=>0,b=>1}
02000000
0200000000000000
0200000000000000
40000000
02000000
02000000
4000000000000000
02000000
40000000
=
struct ulong {
  unsigned long  a:1;
  unsigned long  b:1;
  unsigned long  c:1;
};
-
{c=>0,a=>0,b=>0}
00000000
0000000000000000
0000000000000000
00000000
00000000
00000000
0000000000000000
00000000
00000000
-
{c=>0,a=>1,b=>1}
03000000
0300000000000000
0300000000000000
c0000000
03000000
03000000
c000000000000000
03000000
c0000000
-
{c=>0,a=>0,b=>1}
02000000
0200000000000000
0200000000000000
40000000
02000000
02000000
4000000000000000
02000000
40000000
-
{c=>1,a=>0,b=>1}
06000000
0600000000000000
0600000000000000
60000000
06000000
06000000
6000000000000000
06000000
60000000
-
{c=>1,a=>0,b=>0}
04000000
0400000000000000
0400000000000000
20000000
04000000
04000000
2000000000000000
04000000
20000000
=
struct ulong {
  unsigned long  a:1;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
};
-
{c=>1,a=>1,b=>1,d=>0}
07000000
0700000000000000
0700000000000000
e0000000
07000000
07000000
e000000000000000
07000000
e0000000
-
{c=>1,a=>0,b=>0,d=>0}
04000000
0400000000000000
0400000000000000
20000000
04000000
04000000
2000000000000000
04000000
20000000
-
{c=>0,a=>1,b=>1,d=>1}
0b000000
0b00000000000000
0b00000000000000
d0000000
0b000000
0b000000
d000000000000000
0b000000
d0000000
-
{c=>0,a=>1,b=>0,d=>0}
01000000
0100000000000000
0100000000000000
80000000
01000000
01000000
8000000000000000
01000000
80000000
-
{c=>1,a=>0,b=>1,d=>0}
06000000
0600000000000000
0600000000000000
60000000
06000000
06000000
6000000000000000
06000000
60000000
=
struct ulong {
  unsigned long  a:1;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned char  e;
};
-
{e=>171,c=>0,a=>1,b=>0,d=>0}
01ab0000
01ab000000000000
01ab000000000000
80ab0000
01ab0000
01ab0000
80ab000000000000
01ab0000
80ab0000
-
{e=>112,c=>0,a=>0,b=>0,d=>0}
00700000
0070000000000000
0070000000000000
00700000
00700000
00700000
0070000000000000
00700000
00700000
-
{e=>62,c=>0,a=>0,b=>0,d=>1}
083e0000
083e000000000000
083e000000000000
103e0000
083e0000
083e0000
103e000000000000
083e0000
103e0000
-
{e=>210,c=>0,a=>0,b=>1,d=>1}
0ad20000
0ad2000000000000
0ad2000000000000
50d20000
0ad20000
0ad20000
50d2000000000000
0ad20000
50d20000
-
{e=>159,c=>1,a=>0,b=>1,d=>1}
0e9f0000
0e9f000000000000
0e9f000000000000
709f0000
0e9f0000
0e9f0000
709f000000000000
0e9f0000
709f0000
=
struct ulong {
  char a;
  unsigned long  b:1;
};
-
{a=>-121,b=>1}
87010000
8701000000000000
8701000000000000
87800000
87010000
87010000
8780000000000000
87010000
87800000
-
{a=>50,b=>1}
32010000
3201000000000000
3201000000000000
32800000
32010000
32010000
3280000000000000
32010000
32800000
-
{a=>-89,b=>1}
a7010000
a701000000000000
a701000000000000
a7800000
a7010000
a7010000
a780000000000000
a7010000
a7800000
-
{a=>92,b=>0}
5c000000
5c00000000000000
5c00000000000000
5c000000
5c000000
5c000000
5c00000000000000
5c000000
5c000000
-
{a=>-41,b=>0}
d7000000
d700000000000000
d700000000000000
d7000000
d7000000
d7000000
d700000000000000
d7000000
d7000000
=
struct ulong {
  char a;
  unsigned long  b:1;
  unsigned long  c:1;
};
-
{c=>1,a=>-46,b=>1}
d2030000
d203000000000000
d203000000000000
d2c00000
d2030000
d2030000
d2c0000000000000
d2030000
d2c00000
-
{c=>0,a=>-85,b=>0}
ab000000
ab00000000000000
ab00000000000000
ab000000
ab000000
ab000000
ab00000000000000
ab000000
ab000000
-
{c=>0,a=>78,b=>0}
4e000000
4e00000000000000
4e00000000000000
4e000000
4e000000
4e000000
4e00000000000000
4e000000
4e000000
-
{c=>0,a=>-50,b=>0}
ce000000
ce00000000000000
ce00000000000000
ce000000
ce000000
ce000000
ce00000000000000
ce000000
ce000000
-
{c=>1,a=>-57,b=>1}
c7030000
c703000000000000
c703000000000000
c7c00000
c7030000
c7030000
c7c0000000000000
c7030000
c7c00000
=
struct ulong {
  char a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
};
-
{c=>0,a=>-7,b=>0,d=>1}
f9040000
f904000000000000
f904000000000000
f9200000
f9040000
f9040000
f920000000000000
f9040000
f9200000
-
{c=>0,a=>69,b=>0,d=>0}
45000000
4500000000000000
4500000000000000
45000000
45000000
45000000
4500000000000000
45000000
45000000
-
{c=>1,a=>78,b=>1,d=>1}
4e070000
4e07000000000000
4e07000000000000
4ee00000
4e070000
4e070000
4ee0000000000000
4e070000
4ee00000
-
{c=>1,a=>19,b=>0,d=>0}
13020000
1302000000000000
1302000000000000
13400000
13020000
13020000
1340000000000000
13020000
13400000
-
{c=>1,a=>-18,b=>1,d=>0}
ee030000
ee03000000000000
ee03000000000000
eec00000
ee030000
ee030000
eec0000000000000
ee030000
eec00000
=
struct ulong {
  char a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>0,a=>-82,b=>1,d=>1}
ae0d0000
ae0d000000000000
ae0d000000000000
aeb00000
ae0d0000
ae0d0000
aeb0000000000000
ae0d0000
aeb00000
-
{e=>1,c=>1,a=>125,b=>0,d=>1}
7d0e0000
7d0e000000000000
7d0e000000000000
7d700000
7d0e0000
7d0e0000
7d70000000000000
7d0e0000
7d700000
-
{e=>1,c=>1,a=>-119,b=>0,d=>1}
890e0000
890e000000000000
890e000000000000
89700000
890e0000
890e0000
8970000000000000
890e0000
89700000
-
{e=>1,c=>1,a=>39,b=>0,d=>1}
270e0000
270e000000000000
270e000000000000
27700000
270e0000
270e0000
2770000000000000
270e0000
27700000
-
{e=>0,c=>1,a=>14,b=>0,d=>0}
0e020000
0e02000000000000
0e02000000000000
0e400000
0e020000
0e020000
0e40000000000000
0e020000
0e400000
=
struct ulong {
  char a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>0,a=>-3,b=>1,d=>0,f=>197}
fd09c500
fd09c50000000000
fd09c50000000000
fd90c500
fd09c500
fd09c500
fd90c50000000000
fd09c500
fd90c500
-
{e=>0,c=>1,a=>87,b=>0,d=>0,f=>225}
5702e100
5702e10000000000
5702e10000000000
5740e100
5702e100
5702e100
5740e10000000000
5702e100
5740e100
-
{e=>0,c=>1,a=>-120,b=>1,d=>1,f=>123}
88077b00
88077b0000000000
88077b0000000000
88e07b00
88077b00
88077b00
88e07b0000000000
88077b00
88e07b00
-
{e=>1,c=>0,a=>-101,b=>0,d=>0,f=>120}
9b087800
9b08780000000000
9b08780000000000
9b107800
9b087800
9b087800
9b10780000000000
9b087800
9b107800
-
{e=>1,c=>1,a=>13,b=>0,d=>1,f=>245}
0d0ef500
0d0ef50000000000
0d0ef50000000000
0d70f500
0d0ef500
0d0ef500
0d70f50000000000
0d0ef500
0d70f500
=
struct ulong {
  short a;
  unsigned long  b:1;
};
-
{a=>-34,b=>1}
deff0100
deff010000000000
deff010000000000
ffde8000
deff0100
deff0100
ffde800000000000
deff0100
ffde8000
-
{a=>-97,b=>1}
9fff0100
9fff010000000000
9fff010000000000
ff9f8000
9fff0100
9fff0100
ff9f800000000000
9fff0100
ff9f8000
-
{a=>125,b=>0}
7d000000
7d00000000000000
7d00000000000000
007d0000
7d000000
7d000000
007d000000000000
7d000000
007d0000
-
{a=>-4,b=>1}
fcff0100
fcff010000000000
fcff010000000000
fffc8000
fcff0100
fcff0100
fffc800000000000
fcff0100
fffc8000
-
{a=>-46,b=>0}
d2ff0000
d2ff000000000000
d2ff000000000000
ffd20000
d2ff0000
d2ff0000
ffd2000000000000
d2ff0000
ffd20000
=
struct ulong {
  short a;
  unsigned long  b:1;
  unsigned long  c:1;
};
-
{c=>0,a=>54,b=>1}
36000100
3600010000000000
3600010000000000
00368000
36000100
36000100
0036800000000000
36000100
00368000
-
{c=>1,a=>25,b=>1}
19000300
1900030000000000
1900030000000000
0019c000
19000300
19000300
0019c00000000000
19000300
0019c000
-
{c=>1,a=>-112,b=>1}
90ff0300
90ff030000000000
90ff030000000000
ff90c000
90ff0300
90ff0300
ff90c00000000000
90ff0300
ff90c000
-
{c=>0,a=>53,b=>1}
35000100
3500010000000000
3500010000000000
00358000
35000100
35000100
0035800000000000
35000100
00358000
-
{c=>0,a=>-72,b=>0}
b8ff0000
b8ff000000000000
b8ff000000000000
ffb80000
b8ff0000
b8ff0000
ffb8000000000000
b8ff0000
ffb80000
=
struct ulong {
  short a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
};
-
{c=>0,a=>-37,b=>0,d=>1}
dbff0400
dbff040000000000
dbff040000000000
ffdb2000
dbff0400
dbff0400
ffdb200000000000
dbff0400
ffdb2000
-
{c=>1,a=>59,b=>0,d=>1}
3b000600
3b00060000000000
3b00060000000000
003b6000
3b000600
3b000600
003b600000000000
3b000600
003b6000
-
{c=>1,a=>-10,b=>1,d=>1}
f6ff0700
f6ff070000000000
f6ff070000000000
fff6e000
f6ff0700
f6ff0700
fff6e00000000000
f6ff0700
fff6e000
-
{c=>0,a=>-39,b=>1,d=>0}
d9ff0100
d9ff010000000000
d9ff010000000000
ffd98000
d9ff0100
d9ff0100
ffd9800000000000
d9ff0100
ffd98000
-
{c=>0,a=>26,b=>0,d=>1}
1a000400
1a00040000000000
1a00040000000000
001a2000
1a000400
1a000400
001a200000000000
1a000400
001a2000
=
struct ulong {
  short a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>1,a=>77,b=>1,d=>0}
4d000b00
4d000b0000000000
4d000b0000000000
004dd000
4d000b00
4d000b00
004dd00000000000
4d000b00
004dd000
-
{e=>0,c=>0,a=>71,b=>1,d=>1}
47000500
4700050000000000
4700050000000000
0047a000
47000500
47000500
0047a00000000000
47000500
0047a000
-
{e=>1,c=>0,a=>12,b=>1,d=>0}
0c000900
0c00090000000000
0c00090000000000
000c9000
0c000900
0c000900
000c900000000000
0c000900
000c9000
-
{e=>1,c=>1,a=>-120,b=>1,d=>1}
88ff0f00
88ff0f0000000000
88ff0f0000000000
ff88f000
88ff0f00
88ff0f00
ff88f00000000000
88ff0f00
ff88f000
-
{e=>0,c=>0,a=>-106,b=>0,d=>1}
96ff0400
96ff040000000000
96ff040000000000
ff962000
96ff0400
96ff0400
ff96200000000000
96ff0400
ff962000
=
struct ulong {
  short a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>93,b=>1,d=>0,f=>203}
5d000bcb
5d000bcb00000000
5d000bcb00000000
005dd0cb
5d000bcb
5d000bcb
005dd0cb00000000
5d000bcb
005dd0cb
-
{e=>1,c=>1,a=>-61,b=>1,d=>0,f=>222}
c3ff0bde
c3ff0bde00000000
c3ff0bde00000000
ffc3d0de
c3ff0bde
c3ff0bde
ffc3d0de00000000
c3ff0bde
ffc3d0de
-
{e=>0,c=>1,a=>-4,b=>0,d=>0,f=>177}
fcff02b1
fcff02b100000000
fcff02b100000000
fffc40b1
fcff02b1
fcff02b1
fffc40b100000000
fcff02b1
fffc40b1
-
{e=>0,c=>1,a=>-34,b=>1,d=>1,f=>92}
deff075c
deff075c00000000
deff075c00000000
ffdee05c
deff075c
deff075c
ffdee05c00000000
deff075c
ffdee05c
-
{e=>0,c=>1,a=>6,b=>0,d=>1,f=>117}
06000675
0600067500000000
0600067500000000
00066075
06000675
06000675
0006607500000000
06000675
00066075
=
struct ulong {
  int a;
  unsigned long  b:1;
};
-
{a=>20,b=>1}
1400000001000000
1400000001000000
1400000001000000
0000001480000000
1400000001000000
1400000001000000
0000001480000000
1400000001000000
0000001480000000
-
{a=>-70,b=>1}
baffffff01000000
baffffff01000000
baffffff01000000
ffffffba80000000
baffffff01000000
baffffff01000000
ffffffba80000000
baffffff01000000
ffffffba80000000
-
{a=>-124,b=>0}
84ffffff00000000
84ffffff00000000
84ffffff00000000
ffffff8400000000
84ffffff00000000
84ffffff00000000
ffffff8400000000
84ffffff00000000
ffffff8400000000
-
{a=>-106,b=>0}
96ffffff00000000
96ffffff00000000
96ffffff00000000
ffffff9600000000
96ffffff00000000
96ffffff00000000
ffffff9600000000
96ffffff00000000
ffffff9600000000
-
{a=>25,b=>1}
1900000001000000
1900000001000000
1900000001000000
0000001980000000
1900000001000000
1900000001000000
0000001980000000
1900000001000000
0000001980000000
=
struct ulong {
  int a;
  unsigned long  b:1;
  unsigned long  c:1;
};
-
{c=>1,a=>42,b=>0}
2a00000002000000
2a00000002000000
2a00000002000000
0000002a40000000
2a00000002000000
2a00000002000000
0000002a40000000
2a00000002000000
0000002a40000000
-
{c=>1,a=>-120,b=>1}
88ffffff03000000
88ffffff03000000
88ffffff03000000
ffffff88c0000000
88ffffff03000000
88ffffff03000000
ffffff88c0000000
88ffffff03000000
ffffff88c0000000
-
{c=>1,a=>-122,b=>1}
86ffffff03000000
86ffffff03000000
86ffffff03000000
ffffff86c0000000
86ffffff03000000
86ffffff03000000
ffffff86c0000000
86ffffff03000000
ffffff86c0000000
-
{c=>0,a=>-34,b=>0}
deffffff00000000
deffffff00000000
deffffff00000000
ffffffde00000000
deffffff00000000
deffffff00000000
ffffffde00000000
deffffff00000000
ffffffde00000000
-
{c=>0,a=>-40,b=>0}
d8ffffff00000000
d8ffffff00000000
d8ffffff00000000
ffffffd800000000
d8ffffff00000000
d8ffffff00000000
ffffffd800000000
d8ffffff00000000
ffffffd800000000
=
struct ulong {
  int a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
};
-
{c=>0,a=>44,b=>1,d=>0}
2c00000001000000
2c00000001000000
2c00000001000000
0000002c80000000
2c00000001000000
2c00000001000000
0000002c80000000
2c00000001000000
0000002c80000000
-
{c=>1,a=>119,b=>1,d=>0}
7700000003000000
7700000003000000
7700000003000000
00000077c0000000
7700000003000000
7700000003000000
00000077c0000000
7700000003000000
00000077c0000000
-
{c=>1,a=>30,b=>1,d=>0}
1e00000003000000
1e00000003000000
1e00000003000000
0000001ec0000000
1e00000003000000
1e00000003000000
0000001ec0000000
1e00000003000000
0000001ec0000000
-
{c=>0,a=>-76,b=>0,d=>0}
b4ffffff00000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
ffffffb400000000
-
{c=>1,a=>71,b=>0,d=>1}
4700000006000000
4700000006000000
4700000006000000
0000004760000000
4700000006000000
4700000006000000
0000004760000000
4700000006000000
0000004760000000
=
struct ulong {
  int a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
};
-
{e=>0,c=>0,a=>-96,b=>1,d=>0}
a0ffffff01000000
a0ffffff01000000
a0ffffff01000000
ffffffa080000000
a0ffffff01000000
a0ffffff01000000
ffffffa080000000
a0ffffff01000000
ffffffa080000000
-
{e=>0,c=>0,a=>112,b=>1,d=>0}
7000000001000000
7000000001000000
7000000001000000
0000007080000000
7000000001000000
7000000001000000
0000007080000000
7000000001000000
0000007080000000
-
{e=>1,c=>0,a=>-48,b=>1,d=>0}
d0ffffff09000000
d0ffffff09000000
d0ffffff09000000
ffffffd090000000
d0ffffff09000000
d0ffffff09000000
ffffffd090000000
d0ffffff09000000
ffffffd090000000
-
{e=>0,c=>0,a=>101,b=>0,d=>0}
6500000000000000
6500000000000000
6500000000000000
0000006500000000
6500000000000000
6500000000000000
0000006500000000
6500000000000000
0000006500000000
-
{e=>0,c=>0,a=>113,b=>1,d=>1}
7100000005000000
7100000005000000
7100000005000000
00000071a0000000
7100000005000000
7100000005000000
00000071a0000000
7100000005000000
00000071a0000000
=
struct ulong {
  int a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>53,b=>0,d=>1,f=>237}
350000000eed0000
350000000eed0000
350000000eed0000
0000003570ed0000
350000000eed0000
350000000eed0000
0000003570ed0000
350000000eed0000
0000003570ed0000
-
{e=>1,c=>0,a=>-64,b=>1,d=>0,f=>197}
c0ffffff09c50000
c0ffffff09c50000
c0ffffff09c50000
ffffffc090c50000
c0ffffff09c50000
c0ffffff09c50000
ffffffc090c50000
c0ffffff09c50000
ffffffc090c50000
-
{e=>0,c=>1,a=>-88,b=>1,d=>0,f=>178}
a8ffffff03b20000
a8ffffff03b20000
a8ffffff03b20000
ffffffa8c0b20000
a8ffffff03b20000
a8ffffff03b20000
ffffffa8c0b20000
a8ffffff03b20000
ffffffa8c0b20000
-
{e=>1,c=>1,a=>-104,b=>0,d=>1,f=>185}
98ffffff0eb90000
98ffffff0eb90000
98ffffff0eb90000
ffffff9870b90000
98ffffff0eb90000
98ffffff0eb90000
ffffff9870b90000
98ffffff0eb90000
ffffff9870b90000
-
{e=>1,c=>1,a=>121,b=>0,d=>1,f=>176}
790000000eb00000
790000000eb00000
790000000eb00000
0000007970b00000
790000000eb00000
790000000eb00000
0000007970b00000
790000000eb00000
0000007970b00000
=
struct ulong {
  long a;
  unsigned long  b:1;
};
-
{a=>123,b=>0}
7b00000000000000
7b000000000000000000000000000000
7b000000000000000000000000000000
0000007b00000000
7b00000000000000
7b00000000000000
000000000000007b0000000000000000
7b00000000000000
0000007b00000000
-
{a=>-51,b=>1}
cdffffff01000000
cdffffffffffffff0100000000000000
cdffffffffffffff0100000000000000
ffffffcd80000000
cdffffff01000000
cdffffff01000000
ffffffffffffffcd8000000000000000
cdffffff01000000
ffffffcd80000000
-
{a=>123,b=>0}
7b00000000000000
7b000000000000000000000000000000
7b000000000000000000000000000000
0000007b00000000
7b00000000000000
7b00000000000000
000000000000007b0000000000000000
7b00000000000000
0000007b00000000
-
{a=>-16,b=>1}
f0ffffff01000000
f0ffffffffffffff0100000000000000
f0ffffffffffffff0100000000000000
fffffff080000000
f0ffffff01000000
f0ffffff01000000
fffffffffffffff08000000000000000
f0ffffff01000000
fffffff080000000
-
{a=>-33,b=>1}
dfffffff01000000
dfffffffffffffff0100000000000000
dfffffffffffffff0100000000000000
ffffffdf80000000
dfffffff01000000
dfffffff01000000
ffffffffffffffdf8000000000000000
dfffffff01000000
ffffffdf80000000
=
struct ulong {
  long a;
  unsigned long  b:1;
  unsigned long  c:1;
};
-
{c=>1,a=>65,b=>1}
4100000003000000
41000000000000000300000000000000
41000000000000000300000000000000
00000041c0000000
4100000003000000
4100000003000000
0000000000000041c000000000000000
4100000003000000
00000041c0000000
-
{c=>1,a=>108,b=>0}
6c00000002000000
6c000000000000000200000000000000
6c000000000000000200000000000000
0000006c40000000
6c00000002000000
6c00000002000000
000000000000006c4000000000000000
6c00000002000000
0000006c40000000
-
{c=>1,a=>-3,b=>1}
fdffffff03000000
fdffffffffffffff0300000000000000
fdffffffffffffff0300000000000000
fffffffdc0000000
fdffffff03000000
fdffffff03000000
fffffffffffffffdc000000000000000
fdffffff03000000
fffffffdc0000000
-
{c=>0,a=>48,b=>1}
3000000001000000
30000000000000000100000000000000
30000000000000000100000000000000
0000003080000000
3000000001000000
3000000001000000
00000000000000308000000000000000
3000000001000000
0000003080000000
-
{c=>0,a=>39,b=>0}
2700000000000000
27000000000000000000000000000000
27000000000000000000000000000000
0000002700000000
2700000000000000
2700000000000000
00000000000000270000000000000000
2700000000000000
0000002700000000
=
struct ulong {
  long a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
};
-
{c=>0,a=>-118,b=>0,d=>1}
8affffff04000000
8affffffffffffff0400000000000000
8affffffffffffff0400000000000000
ffffff8a20000000
8affffff04000000
8affffff04000000
ffffffffffffff8a2000000000000000
8affffff04000000
ffffff8a20000000
-
{c=>1,a=>-68,b=>1,d=>1}
bcffffff07000000
bcffffffffffffff0700000000000000
bcffffffffffffff0700000000000000
ffffffbce0000000
bcffffff07000000
bcffffff07000000
ffffffffffffffbce000000000000000
bcffffff07000000
ffffffbce0000000
-
{c=>0,a=>-88,b=>1,d=>1}
a8ffffff05000000
a8ffffffffffffff0500000000000000
a8ffffffffffffff0500000000000000
ffffffa8a0000000
a8ffffff05000000
a8ffffff05000000
ffffffffffffffa8a000000000000000
a8ffffff05000000
ffffffa8a0000000
-
{c=>0,a=>-79,b=>0,d=>1}
b1ffffff04000000
b1ffffffffffffff0400000000000000
b1ffffffffffffff0400000000000000
ffffffb120000000
b1ffffff04000000
b1ffffff04000000
ffffffffffffffb12000000000000000
b1ffffff04000000
ffffffb120000000
-
{c=>1,a=>-62,b=>0,d=>0}
c2ffffff02000000
c2ffffffffffffff0200000000000000
c2ffffffffffffff0200000000000000
ffffffc240000000
c2ffffff02000000
c2ffffff02000000
ffffffffffffffc24000000000000000
c2ffffff02000000
ffffffc240000000
=
struct ulong {
  long a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>1,a=>-102,b=>1,d=>0}
9affffff0b000000
9affffffffffffff0b00000000000000
9affffffffffffff0b00000000000000
ffffff9ad0000000
9affffff0b000000
9affffff0b000000
ffffffffffffff9ad000000000000000
9affffff0b000000
ffffff9ad0000000
-
{e=>1,c=>0,a=>-99,b=>1,d=>0}
9dffffff09000000
9dffffffffffffff0900000000000000
9dffffffffffffff0900000000000000
ffffff9d90000000
9dffffff09000000
9dffffff09000000
ffffffffffffff9d9000000000000000
9dffffff09000000
ffffff9d90000000
-
{e=>0,c=>0,a=>3,b=>0,d=>0}
0300000000000000
03000000000000000000000000000000
03000000000000000000000000000000
0000000300000000
0300000000000000
0300000000000000
00000000000000030000000000000000
0300000000000000
0000000300000000
-
{e=>1,c=>0,a=>6,b=>1,d=>0}
0600000009000000
06000000000000000900000000000000
06000000000000000900000000000000
0000000690000000
0600000009000000
0600000009000000
00000000000000069000000000000000
0600000009000000
0000000690000000
-
{e=>0,c=>1,a=>105,b=>0,d=>0}
6900000002000000
69000000000000000200000000000000
69000000000000000200000000000000
0000006940000000
6900000002000000
6900000002000000
00000000000000694000000000000000
6900000002000000
0000006940000000
=
struct ulong {
  long a;
  unsigned long  b:1;
  unsigned long  c:1;
  unsigned long  d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>0,a=>73,b=>1,d=>1,f=>147}
490000000d930000
49000000000000000d93000000000000
49000000000000000d93000000000000
00000049b0930000
490000000d930000
490000000d930000
0000000000000049b093000000000000
490000000d930000
00000049b0930000
-
{e=>0,c=>1,a=>9,b=>0,d=>0,f=>160}
0900000002a00000
090000000000000002a0000000000000
090000000000000002a0000000000000
0000000940a00000
0900000002a00000
0900000002a00000
000000000000000940a0000000000000
0900000002a00000
0000000940a00000
-
{e=>0,c=>1,a=>78,b=>1,d=>1,f=>51}
4e00000007330000
4e000000000000000733000000000000
4e000000000000000733000000000000
0000004ee0330000
4e00000007330000
4e00000007330000
000000000000004ee033000000000000
4e00000007330000
0000004ee0330000
-
{e=>1,c=>0,a=>96,b=>1,d=>1,f=>245}
600000000df50000
60000000000000000df5000000000000
60000000000000000df5000000000000
00000060b0f50000
600000000df50000
600000000df50000
0000000000000060b0f5000000000000
600000000df50000
00000060b0f50000
-
{e=>0,c=>0,a=>101,b=>1,d=>1,f=>35}
6500000005230000
65000000000000000523000000000000
65000000000000000523000000000000
00000065a0230000
6500000005230000
6500000005230000
0000000000000065a023000000000000
6500000005230000
00000065a0230000
=
struct umixed {
  unsigned char  a:1;
};
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
=
struct umixed {
  unsigned char  a:1;
  unsigned short b:1;
};
-
{a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>0,b=>1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
-
{a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>0,b=>1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
-
{a=>1,b=>0}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
=
struct umixed {
  unsigned char  a:1;
  unsigned short b:1;
  unsigned int   c:1;
};
-
{c=>0,a=>1,b=>1}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{c=>1,a=>0,b=>0}
04000000
04000000
04000000
20000000
04000000
04000000
20000000
04000000
20000000
-
{c=>1,a=>0,b=>1}
06000000
06000000
06000000
60000000
06000000
06000000
60000000
06000000
60000000
-
{c=>0,a=>1,b=>1}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{c=>0,a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct umixed {
  unsigned char  a:1;
  unsigned short b:1;
  unsigned int   c:1;
  unsigned long  d:1;
};
-
{c=>1,a=>1,b=>0,d=>1}
0d000000
0d00000000000000
0d00000000000000
b0000000
0d000000
0d000000
b000000000000000
0d000000
b0000000
-
{c=>0,a=>0,b=>0,d=>1}
08000000
0800000000000000
0800000000000000
10000000
08000000
08000000
1000000000000000
08000000
10000000
-
{c=>1,a=>1,b=>0,d=>1}
0d000000
0d00000000000000
0d00000000000000
b0000000
0d000000
0d000000
b000000000000000
0d000000
b0000000
-
{c=>0,a=>0,b=>1,d=>0}
02000000
0200000000000000
0200000000000000
40000000
02000000
02000000
4000000000000000
02000000
40000000
-
{c=>0,a=>0,b=>1,d=>1}
0a000000
0a00000000000000
0a00000000000000
50000000
0a000000
0a000000
5000000000000000
0a000000
50000000
=
struct umixed {
  unsigned char  a:1;
  unsigned short b:1;
  unsigned int   c:1;
  unsigned long  d:1;
  unsigned char  e;
};
-
{e=>216,c=>0,a=>1,b=>0,d=>1}
09d80000
09d8000000000000
09d8000000000000
90d80000
09d80000
09d80000
90d8000000000000
09d80000
90d80000
-
{e=>111,c=>0,a=>0,b=>1,d=>0}
026f0000
026f000000000000
026f000000000000
406f0000
026f0000
026f0000
406f000000000000
026f0000
406f0000
-
{e=>156,c=>1,a=>0,b=>0,d=>0}
049c0000
049c000000000000
049c000000000000
209c0000
049c0000
049c0000
209c000000000000
049c0000
209c0000
-
{e=>93,c=>0,a=>0,b=>1,d=>0}
025d0000
025d000000000000
025d000000000000
405d0000
025d0000
025d0000
405d000000000000
025d0000
405d0000
-
{e=>187,c=>0,a=>0,b=>1,d=>0}
02bb0000
02bb000000000000
02bb000000000000
40bb0000
02bb0000
02bb0000
40bb000000000000
02bb0000
40bb0000
=
struct umixed {
  char a;
  unsigned char  b:1;
};
-
{a=>122,b=>0}
7a00
7a00
7a00
7a00
7a000000
7a00
7a00
7a00
7a00
-
{a=>102,b=>0}
6600
6600
6600
6600
66000000
6600
6600
6600
6600
-
{a=>105,b=>0}
6900
6900
6900
6900
69000000
6900
6900
6900
6900
-
{a=>6,b=>1}
0601
0601
0601
0680
06010000
0601
0680
0601
0680
-
{a=>110,b=>0}
6e00
6e00
6e00
6e00
6e000000
6e00
6e00
6e00
6e00
=
struct umixed {
  char a;
  unsigned char  b:1;
  unsigned short c:1;
};
-
{c=>0,a=>-64,b=>0}
c000
c000
c000
c000
c0000000
c000
c000
c000
c000
-
{c=>0,a=>92,b=>1}
5c01
5c01
5c01
5c80
5c010000
5c01
5c80
5c01
5c80
-
{c=>1,a=>-60,b=>1}
c403
c403
c403
c4c0
c4030000
c403
c4c0
c403
c4c0
-
{c=>0,a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{c=>0,a=>-90,b=>1}
a601
a601
a601
a680
a6010000
a601
a680
a601
a680
=
struct umixed {
  char a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
};
-
{c=>1,a=>43,b=>0,d=>1}
2b060000
2b060000
2b060000
2b600000
2b060000
2b060000
2b600000
2b060000
2b600000
-
{c=>0,a=>65,b=>1,d=>1}
41050000
41050000
41050000
41a00000
41050000
41050000
41a00000
41050000
41a00000
-
{c=>1,a=>-28,b=>0,d=>1}
e4060000
e4060000
e4060000
e4600000
e4060000
e4060000
e4600000
e4060000
e4600000
-
{c=>1,a=>-67,b=>1,d=>0}
bd030000
bd030000
bd030000
bdc00000
bd030000
bd030000
bdc00000
bd030000
bdc00000
-
{c=>1,a=>-56,b=>0,d=>1}
c8060000
c8060000
c8060000
c8600000
c8060000
c8060000
c8600000
c8060000
c8600000
=
struct umixed {
  char a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>1,a=>-36,b=>0,d=>0}
dc0a0000
dc0a000000000000
dc0a000000000000
dc500000
dc0a0000
dc0a0000
dc50000000000000
dc0a0000
dc500000
-
{e=>1,c=>1,a=>-40,b=>1,d=>1}
d80f0000
d80f000000000000
d80f000000000000
d8f00000
d80f0000
d80f0000
d8f0000000000000
d80f0000
d8f00000
-
{e=>0,c=>1,a=>56,b=>0,d=>1}
38060000
3806000000000000
3806000000000000
38600000
38060000
38060000
3860000000000000
38060000
38600000
-
{e=>0,c=>1,a=>18,b=>1,d=>0}
12030000
1203000000000000
1203000000000000
12c00000
12030000
12030000
12c0000000000000
12030000
12c00000
-
{e=>1,c=>0,a=>-68,b=>1,d=>0}
bc090000
bc09000000000000
bc09000000000000
bc900000
bc090000
bc090000
bc90000000000000
bc090000
bc900000
=
struct umixed {
  char a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>77,b=>0,d=>0,f=>112}
4d0a7000
4d0a700000000000
4d0a700000000000
4d507000
4d0a7000
4d0a7000
4d50700000000000
4d0a7000
4d507000
-
{e=>1,c=>0,a=>115,b=>0,d=>1,f=>9}
730c0900
730c090000000000
730c090000000000
73300900
730c0900
730c0900
7330090000000000
730c0900
73300900
-
{e=>0,c=>0,a=>-25,b=>0,d=>0,f=>91}
e7005b00
e7005b0000000000
e7005b0000000000
e7005b00
e7005b00
e7005b00
e7005b0000000000
e7005b00
e7005b00
-
{e=>0,c=>0,a=>-68,b=>1,d=>0,f=>5}
bc010500
bc01050000000000
bc01050000000000
bc800500
bc010500
bc010500
bc80050000000000
bc010500
bc800500
-
{e=>0,c=>1,a=>86,b=>0,d=>0,f=>30}
56021e00
56021e0000000000
56021e0000000000
56401e00
56021e00
56021e00
56401e0000000000
56021e00
56401e00
=
struct umixed {
  short a;
  unsigned char  b:1;
};
-
{a=>49,b=>0}
31000000
31000000
31000000
00310000
31000000
31000000
00310000
31000000
00310000
-
{a=>84,b=>1}
54000100
54000100
54000100
00548000
54000100
54000100
00548000
54000100
00548000
-
{a=>-73,b=>0}
b7ff0000
b7ff0000
b7ff0000
ffb70000
b7ff0000
b7ff0000
ffb70000
b7ff0000
ffb70000
-
{a=>92,b=>0}
5c000000
5c000000
5c000000
005c0000
5c000000
5c000000
005c0000
5c000000
005c0000
-
{a=>76,b=>0}
4c000000
4c000000
4c000000
004c0000
4c000000
4c000000
004c0000
4c000000
004c0000
=
struct umixed {
  short a;
  unsigned char  b:1;
  unsigned short c:1;
};
-
{c=>1,a=>-69,b=>0}
bbff0200
bbff0200
bbff0200
ffbb4000
bbff0200
bbff0200
ffbb4000
bbff0200
ffbb4000
-
{c=>1,a=>103,b=>0}
67000200
67000200
67000200
00674000
67000200
67000200
00674000
67000200
00674000
-
{c=>0,a=>-68,b=>0}
bcff0000
bcff0000
bcff0000
ffbc0000
bcff0000
bcff0000
ffbc0000
bcff0000
ffbc0000
-
{c=>0,a=>-31,b=>0}
e1ff0000
e1ff0000
e1ff0000
ffe10000
e1ff0000
e1ff0000
ffe10000
e1ff0000
ffe10000
-
{c=>0,a=>87,b=>1}
57000100
57000100
57000100
00578000
57000100
57000100
00578000
57000100
00578000
=
struct umixed {
  short a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
};
-
{c=>0,a=>-26,b=>1,d=>0}
e6ff0100
e6ff0100
e6ff0100
ffe68000
e6ff0100
e6ff0100
ffe68000
e6ff0100
ffe68000
-
{c=>1,a=>41,b=>0,d=>1}
29000600
29000600
29000600
00296000
29000600
29000600
00296000
29000600
00296000
-
{c=>0,a=>47,b=>1,d=>1}
2f000500
2f000500
2f000500
002fa000
2f000500
2f000500
002fa000
2f000500
002fa000
-
{c=>0,a=>-115,b=>0,d=>0}
8dff0000
8dff0000
8dff0000
ff8d0000
8dff0000
8dff0000
ff8d0000
8dff0000
ff8d0000
-
{c=>1,a=>16,b=>1,d=>0}
10000300
10000300
10000300
0010c000
10000300
10000300
0010c000
10000300
0010c000
=
struct umixed {
  short a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>1,a=>-24,b=>0,d=>0}
e8ff0a00
e8ff0a0000000000
e8ff0a0000000000
ffe85000
e8ff0a00
e8ff0a00
ffe8500000000000
e8ff0a00
ffe85000
-
{e=>1,c=>1,a=>-4,b=>1,d=>0}
fcff0b00
fcff0b0000000000
fcff0b0000000000
fffcd000
fcff0b00
fcff0b00
fffcd00000000000
fcff0b00
fffcd000
-
{e=>0,c=>0,a=>-80,b=>1,d=>0}
b0ff0100
b0ff010000000000
b0ff010000000000
ffb08000
b0ff0100
b0ff0100
ffb0800000000000
b0ff0100
ffb08000
-
{e=>0,c=>0,a=>18,b=>1,d=>0}
12000100
1200010000000000
1200010000000000
00128000
12000100
12000100
0012800000000000
12000100
00128000
-
{e=>0,c=>0,a=>-46,b=>1,d=>0}
d2ff0100
d2ff010000000000
d2ff010000000000
ffd28000
d2ff0100
d2ff0100
ffd2800000000000
d2ff0100
ffd28000
=
struct umixed {
  short a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>5,b=>0,d=>0,f=>113}
05000a71
05000a7100000000
05000a7100000000
00055071
05000a71
05000a71
0005507100000000
05000a71
00055071
-
{e=>0,c=>0,a=>67,b=>1,d=>1,f=>126}
4300057e
4300057e00000000
4300057e00000000
0043a07e
4300057e
4300057e
0043a07e00000000
4300057e
0043a07e
-
{e=>0,c=>0,a=>49,b=>0,d=>1,f=>165}
310004a5
310004a500000000
310004a500000000
003120a5
310004a5
310004a5
003120a500000000
310004a5
003120a5
-
{e=>1,c=>0,a=>0,b=>0,d=>1,f=>40}
00000c28
00000c2800000000
00000c2800000000
00003028
00000c28
00000c28
0000302800000000
00000c28
00003028
-
{e=>0,c=>1,a=>66,b=>0,d=>1,f=>177}
420006b1
420006b100000000
420006b100000000
004260b1
420006b1
420006b1
004260b100000000
420006b1
004260b1
=
struct umixed {
  int a;
  unsigned char  b:1;
};
-
{a=>-94,b=>0}
a2ffffff00000000
a2ffffff00000000
a2ffffff00000000
ffffffa200000000
a2ffffff00000000
a2ffffff00000000
ffffffa200000000
a2ffffff00000000
ffffffa200000000
-
{a=>-14,b=>0}
f2ffffff00000000
f2ffffff00000000
f2ffffff00000000
fffffff200000000
f2ffffff00000000
f2ffffff00000000
fffffff200000000
f2ffffff00000000
fffffff200000000
-
{a=>-40,b=>0}
d8ffffff00000000
d8ffffff00000000
d8ffffff00000000
ffffffd800000000
d8ffffff00000000
d8ffffff00000000
ffffffd800000000
d8ffffff00000000
ffffffd800000000
-
{a=>89,b=>0}
5900000000000000
5900000000000000
5900000000000000
0000005900000000
5900000000000000
5900000000000000
0000005900000000
5900000000000000
0000005900000000
-
{a=>-2,b=>1}
feffffff01000000
feffffff01000000
feffffff01000000
fffffffe80000000
feffffff01000000
feffffff01000000
fffffffe80000000
feffffff01000000
fffffffe80000000
=
struct umixed {
  int a;
  unsigned char  b:1;
  unsigned short c:1;
};
-
{c=>0,a=>114,b=>1}
7200000001000000
7200000001000000
7200000001000000
0000007280000000
7200000001000000
7200000001000000
0000007280000000
7200000001000000
0000007280000000
-
{c=>1,a=>-68,b=>1}
bcffffff03000000
bcffffff03000000
bcffffff03000000
ffffffbcc0000000
bcffffff03000000
bcffffff03000000
ffffffbcc0000000
bcffffff03000000
ffffffbcc0000000
-
{c=>0,a=>60,b=>1}
3c00000001000000
3c00000001000000
3c00000001000000
0000003c80000000
3c00000001000000
3c00000001000000
0000003c80000000
3c00000001000000
0000003c80000000
-
{c=>0,a=>-105,b=>1}
97ffffff01000000
97ffffff01000000
97ffffff01000000
ffffff9780000000
97ffffff01000000
97ffffff01000000
ffffff9780000000
97ffffff01000000
ffffff9780000000
-
{c=>1,a=>-90,b=>0}
a6ffffff02000000
a6ffffff02000000
a6ffffff02000000
ffffffa640000000
a6ffffff02000000
a6ffffff02000000
ffffffa640000000
a6ffffff02000000
ffffffa640000000
=
struct umixed {
  int a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
};
-
{c=>1,a=>44,b=>0,d=>1}
2c00000006000000
2c00000006000000
2c00000006000000
0000002c60000000
2c00000006000000
2c00000006000000
0000002c60000000
2c00000006000000
0000002c60000000
-
{c=>1,a=>-90,b=>0,d=>0}
a6ffffff02000000
a6ffffff02000000
a6ffffff02000000
ffffffa640000000
a6ffffff02000000
a6ffffff02000000
ffffffa640000000
a6ffffff02000000
ffffffa640000000
-
{c=>1,a=>-11,b=>0,d=>0}
f5ffffff02000000
f5ffffff02000000
f5ffffff02000000
fffffff540000000
f5ffffff02000000
f5ffffff02000000
fffffff540000000
f5ffffff02000000
fffffff540000000
-
{c=>1,a=>18,b=>1,d=>1}
1200000007000000
1200000007000000
1200000007000000
00000012e0000000
1200000007000000
1200000007000000
00000012e0000000
1200000007000000
00000012e0000000
-
{c=>0,a=>-25,b=>0,d=>0}
e7ffffff00000000
e7ffffff00000000
e7ffffff00000000
ffffffe700000000
e7ffffff00000000
e7ffffff00000000
ffffffe700000000
e7ffffff00000000
ffffffe700000000
=
struct umixed {
  int a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
};
-
{e=>0,c=>0,a=>-47,b=>1,d=>0}
d1ffffff01000000
d1ffffff01000000
d1ffffff01000000
ffffffd180000000
d1ffffff01000000
d1ffffff01000000
ffffffd180000000
d1ffffff01000000
ffffffd180000000
-
{e=>0,c=>1,a=>-12,b=>0,d=>1}
f4ffffff06000000
f4ffffff06000000
f4ffffff06000000
fffffff460000000
f4ffffff06000000
f4ffffff06000000
fffffff460000000
f4ffffff06000000
fffffff460000000
-
{e=>1,c=>1,a=>-74,b=>1,d=>0}
b6ffffff0b000000
b6ffffff0b000000
b6ffffff0b000000
ffffffb6d0000000
b6ffffff0b000000
b6ffffff0b000000
ffffffb6d0000000
b6ffffff0b000000
ffffffb6d0000000
-
{e=>1,c=>1,a=>-49,b=>1,d=>0}
cfffffff0b000000
cfffffff0b000000
cfffffff0b000000
ffffffcfd0000000
cfffffff0b000000
cfffffff0b000000
ffffffcfd0000000
cfffffff0b000000
ffffffcfd0000000
-
{e=>1,c=>1,a=>61,b=>1,d=>0}
3d0000000b000000
3d0000000b000000
3d0000000b000000
0000003dd0000000
3d0000000b000000
3d0000000b000000
0000003dd0000000
3d0000000b000000
0000003dd0000000
=
struct umixed {
  int a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>1,a=>-19,b=>0,d=>0,f=>112}
edffffff0a700000
edffffff0a700000
edffffff0a700000
ffffffed50700000
edffffff0a700000
edffffff0a700000
ffffffed50700000
edffffff0a700000
ffffffed50700000
-
{e=>1,c=>0,a=>-74,b=>1,d=>0,f=>149}
b6ffffff09950000
b6ffffff09950000
b6ffffff09950000
ffffffb690950000
b6ffffff09950000
b6ffffff09950000
ffffffb690950000
b6ffffff09950000
ffffffb690950000
-
{e=>0,c=>1,a=>-124,b=>1,d=>1,f=>78}
84ffffff074e0000
84ffffff074e0000
84ffffff074e0000
ffffff84e04e0000
84ffffff074e0000
84ffffff074e0000
ffffff84e04e0000
84ffffff074e0000
ffffff84e04e0000
-
{e=>1,c=>0,a=>-25,b=>0,d=>0,f=>222}
e7ffffff08de0000
e7ffffff08de0000
e7ffffff08de0000
ffffffe710de0000
e7ffffff08de0000
e7ffffff08de0000
ffffffe710de0000
e7ffffff08de0000
ffffffe710de0000
-
{e=>0,c=>0,a=>127,b=>1,d=>0,f=>81}
7f00000001510000
7f00000001510000
7f00000001510000
0000007f80510000
7f00000001510000
7f00000001510000
0000007f80510000
7f00000001510000
0000007f80510000
=
struct umixed {
  long a;
  unsigned char  b:1;
};
-
{a=>127,b=>0}
7f00000000000000
7f000000000000000000000000000000
7f000000000000000000000000000000
0000007f00000000
7f00000000000000
7f00000000000000
000000000000007f0000000000000000
7f00000000000000
0000007f00000000
-
{a=>66,b=>1}
4200000001000000
42000000000000000100000000000000
42000000000000000100000000000000
0000004280000000
4200000001000000
4200000001000000
00000000000000428000000000000000
4200000001000000
0000004280000000
-
{a=>13,b=>1}
0d00000001000000
0d000000000000000100000000000000
0d000000000000000100000000000000
0000000d80000000
0d00000001000000
0d00000001000000
000000000000000d8000000000000000
0d00000001000000
0000000d80000000
-
{a=>114,b=>0}
7200000000000000
72000000000000000000000000000000
72000000000000000000000000000000
0000007200000000
7200000000000000
7200000000000000
00000000000000720000000000000000
7200000000000000
0000007200000000
-
{a=>-73,b=>1}
b7ffffff01000000
b7ffffffffffffff0100000000000000
b7ffffffffffffff0100000000000000
ffffffb780000000
b7ffffff01000000
b7ffffff01000000
ffffffffffffffb78000000000000000
b7ffffff01000000
ffffffb780000000
=
struct umixed {
  long a;
  unsigned char  b:1;
  unsigned short c:1;
};
-
{c=>1,a=>105,b=>0}
6900000002000000
69000000000000000200000000000000
69000000000000000200000000000000
0000006940000000
6900000002000000
6900000002000000
00000000000000694000000000000000
6900000002000000
0000006940000000
-
{c=>1,a=>-8,b=>0}
f8ffffff02000000
f8ffffffffffffff0200000000000000
f8ffffffffffffff0200000000000000
fffffff840000000
f8ffffff02000000
f8ffffff02000000
fffffffffffffff84000000000000000
f8ffffff02000000
fffffff840000000
-
{c=>0,a=>5,b=>0}
0500000000000000
05000000000000000000000000000000
05000000000000000000000000000000
0000000500000000
0500000000000000
0500000000000000
00000000000000050000000000000000
0500000000000000
0000000500000000
-
{c=>1,a=>-123,b=>0}
85ffffff02000000
85ffffffffffffff0200000000000000
85ffffffffffffff0200000000000000
ffffff8540000000
85ffffff02000000
85ffffff02000000
ffffffffffffff854000000000000000
85ffffff02000000
ffffff8540000000
-
{c=>1,a=>103,b=>1}
6700000003000000
67000000000000000300000000000000
67000000000000000300000000000000
00000067c0000000
6700000003000000
6700000003000000
0000000000000067c000000000000000
6700000003000000
00000067c0000000
=
struct umixed {
  long a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
};
-
{c=>1,a=>-17,b=>1,d=>0}
efffffff03000000
efffffffffffffff0300000000000000
efffffffffffffff0300000000000000
ffffffefc0000000
efffffff03000000
efffffff03000000
ffffffffffffffefc000000000000000
efffffff03000000
ffffffefc0000000
-
{c=>1,a=>-127,b=>1,d=>0}
81ffffff03000000
81ffffffffffffff0300000000000000
81ffffffffffffff0300000000000000
ffffff81c0000000
81ffffff03000000
81ffffff03000000
ffffffffffffff81c000000000000000
81ffffff03000000
ffffff81c0000000
-
{c=>1,a=>102,b=>1,d=>1}
6600000007000000
66000000000000000700000000000000
66000000000000000700000000000000
00000066e0000000
6600000007000000
6600000007000000
0000000000000066e000000000000000
6600000007000000
00000066e0000000
-
{c=>1,a=>-88,b=>1,d=>1}
a8ffffff07000000
a8ffffffffffffff0700000000000000
a8ffffffffffffff0700000000000000
ffffffa8e0000000
a8ffffff07000000
a8ffffff07000000
ffffffffffffffa8e000000000000000
a8ffffff07000000
ffffffa8e0000000
-
{c=>1,a=>15,b=>1,d=>1}
0f00000007000000
0f000000000000000700000000000000
0f000000000000000700000000000000
0000000fe0000000
0f00000007000000
0f00000007000000
000000000000000fe000000000000000
0f00000007000000
0000000fe0000000
=
struct umixed {
  long a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
};
-
{e=>1,c=>1,a=>118,b=>1,d=>1}
760000000f000000
76000000000000000f00000000000000
76000000000000000f00000000000000
00000076f0000000
760000000f000000
760000000f000000
0000000000000076f000000000000000
760000000f000000
00000076f0000000
-
{e=>1,c=>0,a=>-90,b=>0,d=>1}
a6ffffff0c000000
a6ffffffffffffff0c00000000000000
a6ffffffffffffff0c00000000000000
ffffffa630000000
a6ffffff0c000000
a6ffffff0c000000
ffffffffffffffa63000000000000000
a6ffffff0c000000
ffffffa630000000
-
{e=>0,c=>0,a=>103,b=>0,d=>0}
6700000000000000
67000000000000000000000000000000
67000000000000000000000000000000
0000006700000000
6700000000000000
6700000000000000
00000000000000670000000000000000
6700000000000000
0000006700000000
-
{e=>0,c=>1,a=>-84,b=>0,d=>1}
acffffff06000000
acffffffffffffff0600000000000000
acffffffffffffff0600000000000000
ffffffac60000000
acffffff06000000
acffffff06000000
ffffffffffffffac6000000000000000
acffffff06000000
ffffffac60000000
-
{e=>1,c=>1,a=>92,b=>0,d=>0}
5c0000000a000000
5c000000000000000a00000000000000
5c000000000000000a00000000000000
0000005c50000000
5c0000000a000000
5c0000000a000000
000000000000005c5000000000000000
5c0000000a000000
0000005c50000000
=
struct umixed {
  long a;
  unsigned char  b:1;
  unsigned short c:1;
  unsigned int   d:1;
  unsigned long  e:1;
  unsigned char  f;
};
-
{e=>1,c=>0,a=>51,b=>0,d=>0,f=>187}
3300000008bb0000
330000000000000008bb000000000000
330000000000000008bb000000000000
0000003310bb0000
3300000008bb0000
3300000008bb0000
000000000000003310bb000000000000
3300000008bb0000
0000003310bb0000
-
{e=>0,c=>1,a=>-115,b=>1,d=>1,f=>46}
8dffffff072e0000
8dffffffffffffff072e000000000000
8dffffffffffffff072e000000000000
ffffff8de02e0000
8dffffff072e0000
8dffffff072e0000
ffffffffffffff8de02e000000000000
8dffffff072e0000
ffffff8de02e0000
-
{e=>1,c=>0,a=>105,b=>0,d=>0,f=>59}
69000000083b0000
6900000000000000083b000000000000
6900000000000000083b000000000000
00000069103b0000
69000000083b0000
69000000083b0000
0000000000000069103b000000000000
69000000083b0000
00000069103b0000
-
{e=>1,c=>1,a=>-128,b=>0,d=>1,f=>86}
80ffffff0e560000
80ffffffffffffff0e56000000000000
80ffffffffffffff0e56000000000000
ffffff8070560000
80ffffff0e560000
80ffffff0e560000
ffffffffffffff807056000000000000
80ffffff0e560000
ffffff8070560000
-
{e=>1,c=>1,a=>24,b=>1,d=>1,f=>117}
180000000f750000
18000000000000000f75000000000000
18000000000000000f75000000000000
00000018f0750000
180000000f750000
180000000f750000
0000000000000018f075000000000000
180000000f750000
00000018f0750000
=
struct smixed {
  signed char  a:1;
};
-
{a=>-1}
01
01
01
80
01000000
01
80
01
80
-
{a=>-1}
01
01
01
80
01000000
01
80
01
80
-
{a=>-1}
01
01
01
80
01000000
01
80
01
80
-
{a=>-1}
01
01
01
80
01000000
01
80
01
80
-
{a=>-1}
01
01
01
80
01000000
01
80
01
80
=
struct smixed {
  signed char  a:1;
  signed short b:1;
};
-
{a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{a=>-1,b=>0}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
-
{a=>0,b=>-1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
-
{a=>0,b=>-1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
-
{a=>0,b=>-1}
0200
0200
0200
4000
02000000
0200
4000
0200
4000
=
struct smixed {
  signed char  a:1;
  signed short b:1;
  signed int   c:1;
};
-
{c=>0,a=>0,b=>-1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{c=>-1,a=>-1,b=>0}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{c=>0,a=>0,b=>-1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{c=>-1,a=>0,b=>0}
04000000
04000000
04000000
20000000
04000000
04000000
20000000
04000000
20000000
-
{c=>0,a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct smixed {
  signed char  a:1;
  signed short b:1;
  signed int   c:1;
  signed long  d:1;
};
-
{c=>-1,a=>-1,b=>-1,d=>-1}
0f000000
0f00000000000000
0f00000000000000
f0000000
0f000000
0f000000
f000000000000000
0f000000
f0000000
-
{c=>0,a=>-1,b=>0,d=>0}
01000000
0100000000000000
0100000000000000
80000000
01000000
01000000
8000000000000000
01000000
80000000
-
{c=>-1,a=>0,b=>-1,d=>-1}
0e000000
0e00000000000000
0e00000000000000
70000000
0e000000
0e000000
7000000000000000
0e000000
70000000
-
{c=>-1,a=>-1,b=>0,d=>0}
05000000
0500000000000000
0500000000000000
a0000000
05000000
05000000
a000000000000000
05000000
a0000000
-
{c=>0,a=>-1,b=>0,d=>-1}
09000000
0900000000000000
0900000000000000
90000000
09000000
09000000
9000000000000000
09000000
90000000
=
struct smixed {
  signed char  a:1;
  signed short b:1;
  signed int   c:1;
  signed long  d:1;
  signed int   e;
};
-
{e=>-8,c=>0,a=>-1,b=>0,d=>-1}
09000000f8ffffff
09000000f8ffffff
09000000f8ffffff
90000000fffffff8
09000000f8ffffff
09000000f8ffffff
90000000fffffff8
09000000f8ffffff
90000000fffffff8
-
{e=>93,c=>-1,a=>0,b=>-1,d=>0}
060000005d000000
060000005d000000
060000005d000000
600000000000005d
060000005d000000
060000005d000000
600000000000005d
060000005d000000
600000000000005d
-
{e=>98,c=>-1,a=>-1,b=>-1,d=>-1}
0f00000062000000
0f00000062000000
0f00000062000000
f000000000000062
0f00000062000000
0f00000062000000
f000000000000062
0f00000062000000
f000000000000062
-
{e=>-79,c=>0,a=>0,b=>-1,d=>-1}
0a000000b1ffffff
0a000000b1ffffff
0a000000b1ffffff
50000000ffffffb1
0a000000b1ffffff
0a000000b1ffffff
50000000ffffffb1
0a000000b1ffffff
50000000ffffffb1
-
{e=>-60,c=>-1,a=>0,b=>0,d=>-1}
0c000000c4ffffff
0c000000c4ffffff
0c000000c4ffffff
30000000ffffffc4
0c000000c4ffffff
0c000000c4ffffff
30000000ffffffc4
0c000000c4ffffff
30000000ffffffc4
=
struct smixed {
  char a;
  signed char  b:1;
};
-
{a=>28,b=>0}
1c00
1c00
1c00
1c00
1c000000
1c00
1c00
1c00
1c00
-
{a=>-89,b=>-1}
a701
a701
a701
a780
a7010000
a701
a780
a701
a780
-
{a=>52,b=>-1}
3401
3401
3401
3480
34010000
3401
3480
3401
3480
-
{a=>91,b=>0}
5b00
5b00
5b00
5b00
5b000000
5b00
5b00
5b00
5b00
-
{a=>-106,b=>0}
9600
9600
9600
9600
96000000
9600
9600
9600
9600
=
struct smixed {
  char a;
  signed char  b:1;
  signed short c:1;
};
-
{c=>-1,a=>-38,b=>0}
da02
da02
da02
da40
da020000
da02
da40
da02
da40
-
{c=>0,a=>-57,b=>-1}
c701
c701
c701
c780
c7010000
c701
c780
c701
c780
-
{c=>-1,a=>-94,b=>-1}
a203
a203
a203
a2c0
a2030000
a203
a2c0
a203
a2c0
-
{c=>-1,a=>107,b=>-1}
6b03
6b03
6b03
6bc0
6b030000
6b03
6bc0
6b03
6bc0
-
{c=>0,a=>-95,b=>0}
a100
a100
a100
a100
a1000000
a100
a100
a100
a100
=
struct smixed {
  char a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
};
-
{c=>0,a=>35,b=>-1,d=>0}
23010000
23010000
23010000
23800000
23010000
23010000
23800000
23010000
23800000
-
{c=>-1,a=>-97,b=>-1,d=>0}
9f030000
9f030000
9f030000
9fc00000
9f030000
9f030000
9fc00000
9f030000
9fc00000
-
{c=>0,a=>79,b=>-1,d=>-1}
4f050000
4f050000
4f050000
4fa00000
4f050000
4f050000
4fa00000
4f050000
4fa00000
-
{c=>0,a=>-2,b=>0,d=>-1}
fe040000
fe040000
fe040000
fe200000
fe040000
fe040000
fe200000
fe040000
fe200000
-
{c=>-1,a=>52,b=>-1,d=>0}
34030000
34030000
34030000
34c00000
34030000
34030000
34c00000
34030000
34c00000
=
struct smixed {
  char a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
};
-
{e=>0,c=>0,a=>63,b=>-1,d=>-1}
3f050000
3f05000000000000
3f05000000000000
3fa00000
3f050000
3f050000
3fa0000000000000
3f050000
3fa00000
-
{e=>-1,c=>0,a=>105,b=>0,d=>-1}
690c0000
690c000000000000
690c000000000000
69300000
690c0000
690c0000
6930000000000000
690c0000
69300000
-
{e=>0,c=>-1,a=>84,b=>0,d=>-1}
54060000
5406000000000000
5406000000000000
54600000
54060000
54060000
5460000000000000
54060000
54600000
-
{e=>-1,c=>0,a=>40,b=>-1,d=>-1}
280d0000
280d000000000000
280d000000000000
28b00000
280d0000
280d0000
28b0000000000000
280d0000
28b00000
-
{e=>0,c=>0,a=>114,b=>-1,d=>0}
72010000
7201000000000000
7201000000000000
72800000
72010000
72010000
7280000000000000
72010000
72800000
=
struct smixed {
  char a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
  signed int   f;
};
-
{e=>-1,c=>-1,a=>-50,b=>-1,d=>-1,f=>37}
ce0f000025000000
ce0f000025000000
ce0f000025000000
cef0000000000025
ce0f000025000000
ce0f000025000000
cef0000000000025
ce0f000025000000
cef0000000000025
-
{e=>-1,c=>-1,a=>-111,b=>-1,d=>-1,f=>-13}
910f0000f3ffffff
910f0000f3ffffff
910f0000f3ffffff
91f00000fffffff3
910f0000f3ffffff
910f0000f3ffffff
91f00000fffffff3
910f0000f3ffffff
91f00000fffffff3
-
{e=>0,c=>0,a=>-7,b=>0,d=>-1,f=>-107}
f904000095ffffff
f904000095ffffff
f904000095ffffff
f9200000ffffff95
f904000095ffffff
f904000095ffffff
f9200000ffffff95
f904000095ffffff
f9200000ffffff95
-
{e=>0,c=>-1,a=>8,b=>0,d=>-1,f=>-10}
08060000f6ffffff
08060000f6ffffff
08060000f6ffffff
08600000fffffff6
08060000f6ffffff
08060000f6ffffff
08600000fffffff6
08060000f6ffffff
08600000fffffff6
-
{e=>-1,c=>-1,a=>-89,b=>0,d=>-1,f=>127}
a70e00007f000000
a70e00007f000000
a70e00007f000000
a77000000000007f
a70e00007f000000
a70e00007f000000
a77000000000007f
a70e00007f000000
a77000000000007f
=
struct smixed {
  short a;
  signed char  b:1;
};
-
{a=>-94,b=>-1}
a2ff0100
a2ff0100
a2ff0100
ffa28000
a2ff0100
a2ff0100
ffa28000
a2ff0100
ffa28000
-
{a=>19,b=>-1}
13000100
13000100
13000100
00138000
13000100
13000100
00138000
13000100
00138000
-
{a=>-68,b=>-1}
bcff0100
bcff0100
bcff0100
ffbc8000
bcff0100
bcff0100
ffbc8000
bcff0100
ffbc8000
-
{a=>-102,b=>-1}
9aff0100
9aff0100
9aff0100
ff9a8000
9aff0100
9aff0100
ff9a8000
9aff0100
ff9a8000
-
{a=>-111,b=>-1}
91ff0100
91ff0100
91ff0100
ff918000
91ff0100
91ff0100
ff918000
91ff0100
ff918000
=
struct smixed {
  short a;
  signed char  b:1;
  signed short c:1;
};
-
{c=>-1,a=>41,b=>0}
29000200
29000200
29000200
00294000
29000200
29000200
00294000
29000200
00294000
-
{c=>-1,a=>99,b=>0}
63000200
63000200
63000200
00634000
63000200
63000200
00634000
63000200
00634000
-
{c=>-1,a=>-58,b=>0}
c6ff0200
c6ff0200
c6ff0200
ffc64000
c6ff0200
c6ff0200
ffc64000
c6ff0200
ffc64000
-
{c=>-1,a=>28,b=>0}
1c000200
1c000200
1c000200
001c4000
1c000200
1c000200
001c4000
1c000200
001c4000
-
{c=>-1,a=>-117,b=>0}
8bff0200
8bff0200
8bff0200
ff8b4000
8bff0200
8bff0200
ff8b4000
8bff0200
ff8b4000
=
struct smixed {
  short a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
};
-
{c=>-1,a=>114,b=>-1,d=>-1}
72000700
72000700
72000700
0072e000
72000700
72000700
0072e000
72000700
0072e000
-
{c=>0,a=>-58,b=>-1,d=>-1}
c6ff0500
c6ff0500
c6ff0500
ffc6a000
c6ff0500
c6ff0500
ffc6a000
c6ff0500
ffc6a000
-
{c=>-1,a=>15,b=>-1,d=>0}
0f000300
0f000300
0f000300
000fc000
0f000300
0f000300
000fc000
0f000300
000fc000
-
{c=>0,a=>-98,b=>0,d=>0}
9eff0000
9eff0000
9eff0000
ff9e0000
9eff0000
9eff0000
ff9e0000
9eff0000
ff9e0000
-
{c=>-1,a=>26,b=>0,d=>0}
1a000200
1a000200
1a000200
001a4000
1a000200
1a000200
001a4000
1a000200
001a4000
=
struct smixed {
  short a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
};
-
{e=>-1,c=>0,a=>-4,b=>0,d=>0}
fcff0800
fcff080000000000
fcff080000000000
fffc1000
fcff0800
fcff0800
fffc100000000000
fcff0800
fffc1000
-
{e=>-1,c=>0,a=>6,b=>0,d=>-1}
06000c00
06000c0000000000
06000c0000000000
00063000
06000c00
06000c00
0006300000000000
06000c00
00063000
-
{e=>0,c=>-1,a=>40,b=>-1,d=>-1}
28000700
2800070000000000
2800070000000000
0028e000
28000700
28000700
0028e00000000000
28000700
0028e000
-
{e=>-1,c=>0,a=>32,b=>-1,d=>0}
20000900
2000090000000000
2000090000000000
00209000
20000900
20000900
0020900000000000
20000900
00209000
-
{e=>0,c=>-1,a=>-119,b=>0,d=>-1}
89ff0600
89ff060000000000
89ff060000000000
ff896000
89ff0600
89ff0600
ff89600000000000
89ff0600
ff896000
=
struct smixed {
  short a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
  signed int   f;
};
-
{e=>0,c=>0,a=>-8,b=>-1,d=>-1,f=>-2}
f8ff0500feffffff
f8ff0500feffffff
f8ff0500feffffff
fff8a000fffffffe
f8ff0500feffffff
f8ff0500feffffff
fff8a000fffffffe
f8ff0500feffffff
fff8a000fffffffe
-
{e=>-1,c=>0,a=>-61,b=>-1,d=>0,f=>-61}
c3ff0900c3ffffff
c3ff0900c3ffffff
c3ff0900c3ffffff
ffc39000ffffffc3
c3ff0900c3ffffff
c3ff0900c3ffffff
ffc39000ffffffc3
c3ff0900c3ffffff
ffc39000ffffffc3
-
{e=>0,c=>0,a=>63,b=>-1,d=>-1,f=>-95}
3f000500a1ffffff
3f000500a1ffffff
3f000500a1ffffff
003fa000ffffffa1
3f000500a1ffffff
3f000500a1ffffff
003fa000ffffffa1
3f000500a1ffffff
003fa000ffffffa1
-
{e=>0,c=>0,a=>60,b=>0,d=>0,f=>92}
3c0000005c000000
3c0000005c000000
3c0000005c000000
003c00000000005c
3c0000005c000000
3c0000005c000000
003c00000000005c
3c0000005c000000
003c00000000005c
-
{e=>0,c=>-1,a=>-67,b=>0,d=>-1,f=>19}
bdff060013000000
bdff060013000000
bdff060013000000
ffbd600000000013
bdff060013000000
bdff060013000000
ffbd600000000013
bdff060013000000
ffbd600000000013
=
struct smixed {
  int a;
  signed char  b:1;
};
-
{a=>95,b=>-1}
5f00000001000000
5f00000001000000
5f00000001000000
0000005f80000000
5f00000001000000
5f00000001000000
0000005f80000000
5f00000001000000
0000005f80000000
-
{a=>50,b=>0}
3200000000000000
3200000000000000
3200000000000000
0000003200000000
3200000000000000
3200000000000000
0000003200000000
3200000000000000
0000003200000000
-
{a=>-64,b=>-1}
c0ffffff01000000
c0ffffff01000000
c0ffffff01000000
ffffffc080000000
c0ffffff01000000
c0ffffff01000000
ffffffc080000000
c0ffffff01000000
ffffffc080000000
-
{a=>-33,b=>-1}
dfffffff01000000
dfffffff01000000
dfffffff01000000
ffffffdf80000000
dfffffff01000000
dfffffff01000000
ffffffdf80000000
dfffffff01000000
ffffffdf80000000
-
{a=>-44,b=>-1}
d4ffffff01000000
d4ffffff01000000
d4ffffff01000000
ffffffd480000000
d4ffffff01000000
d4ffffff01000000
ffffffd480000000
d4ffffff01000000
ffffffd480000000
=
struct smixed {
  int a;
  signed char  b:1;
  signed short c:1;
};
-
{c=>0,a=>-115,b=>0}
8dffffff00000000
8dffffff00000000
8dffffff00000000
ffffff8d00000000
8dffffff00000000
8dffffff00000000
ffffff8d00000000
8dffffff00000000
ffffff8d00000000
-
{c=>-1,a=>-6,b=>0}
faffffff02000000
faffffff02000000
faffffff02000000
fffffffa40000000
faffffff02000000
faffffff02000000
fffffffa40000000
faffffff02000000
fffffffa40000000
-
{c=>0,a=>40,b=>-1}
2800000001000000
2800000001000000
2800000001000000
0000002880000000
2800000001000000
2800000001000000
0000002880000000
2800000001000000
0000002880000000
-
{c=>-1,a=>-100,b=>-1}
9cffffff03000000
9cffffff03000000
9cffffff03000000
ffffff9cc0000000
9cffffff03000000
9cffffff03000000
ffffff9cc0000000
9cffffff03000000
ffffff9cc0000000
-
{c=>-1,a=>-26,b=>-1}
e6ffffff03000000
e6ffffff03000000
e6ffffff03000000
ffffffe6c0000000
e6ffffff03000000
e6ffffff03000000
ffffffe6c0000000
e6ffffff03000000
ffffffe6c0000000
=
struct smixed {
  int a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
};
-
{c=>0,a=>111,b=>-1,d=>0}
6f00000001000000
6f00000001000000
6f00000001000000
0000006f80000000
6f00000001000000
6f00000001000000
0000006f80000000
6f00000001000000
0000006f80000000
-
{c=>-1,a=>-15,b=>-1,d=>0}
f1ffffff03000000
f1ffffff03000000
f1ffffff03000000
fffffff1c0000000
f1ffffff03000000
f1ffffff03000000
fffffff1c0000000
f1ffffff03000000
fffffff1c0000000
-
{c=>-1,a=>27,b=>-1,d=>0}
1b00000003000000
1b00000003000000
1b00000003000000
0000001bc0000000
1b00000003000000
1b00000003000000
0000001bc0000000
1b00000003000000
0000001bc0000000
-
{c=>0,a=>95,b=>-1,d=>0}
5f00000001000000
5f00000001000000
5f00000001000000
0000005f80000000
5f00000001000000
5f00000001000000
0000005f80000000
5f00000001000000
0000005f80000000
-
{c=>0,a=>40,b=>0,d=>0}
2800000000000000
2800000000000000
2800000000000000
0000002800000000
2800000000000000
2800000000000000
0000002800000000
2800000000000000
0000002800000000
=
struct smixed {
  int a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
};
-
{e=>0,c=>0,a=>106,b=>0,d=>-1}
6a00000004000000
6a00000004000000
6a00000004000000
0000006a20000000
6a00000004000000
6a00000004000000
0000006a20000000
6a00000004000000
0000006a20000000
-
{e=>0,c=>0,a=>-60,b=>-1,d=>-1}
c4ffffff05000000
c4ffffff05000000
c4ffffff05000000
ffffffc4a0000000
c4ffffff05000000
c4ffffff05000000
ffffffc4a0000000
c4ffffff05000000
ffffffc4a0000000
-
{e=>-1,c=>-1,a=>21,b=>0,d=>-1}
150000000e000000
150000000e000000
150000000e000000
0000001570000000
150000000e000000
150000000e000000
0000001570000000
150000000e000000
0000001570000000
-
{e=>-1,c=>-1,a=>12,b=>0,d=>0}
0c0000000a000000
0c0000000a000000
0c0000000a000000
0000000c50000000
0c0000000a000000
0c0000000a000000
0000000c50000000
0c0000000a000000
0000000c50000000
-
{e=>0,c=>-1,a=>-11,b=>-1,d=>-1}
f5ffffff07000000
f5ffffff07000000
f5ffffff07000000
fffffff5e0000000
f5ffffff07000000
f5ffffff07000000
fffffff5e0000000
f5ffffff07000000
fffffff5e0000000
=
struct smixed {
  int a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
  signed int   f;
};
-
{e=>-1,c=>-1,a=>1,b=>-1,d=>-1,f=>-92}
010000000f000000a4ffffff
010000000f000000a4ffffff00000000
010000000f000000a4ffffff00000000
00000001f0000000ffffffa4
010000000f000000a4ffffff
010000000f000000a4ffffff
00000001f0000000ffffffa400000000
010000000f000000a4ffffff
00000001f0000000ffffffa4
-
{e=>-1,c=>-1,a=>-79,b=>0,d=>0,f=>47}
b1ffffff0a0000002f000000
b1ffffff0a0000002f00000000000000
b1ffffff0a0000002f00000000000000
ffffffb1500000000000002f
b1ffffff0a0000002f000000
b1ffffff0a0000002f000000
ffffffb1500000000000002f00000000
b1ffffff0a0000002f000000
ffffffb1500000000000002f
-
{e=>-1,c=>-1,a=>81,b=>-1,d=>0,f=>-106}
510000000b00000096ffffff
510000000b00000096ffffff00000000
510000000b00000096ffffff00000000
00000051d0000000ffffff96
510000000b00000096ffffff
510000000b00000096ffffff
00000051d0000000ffffff9600000000
510000000b00000096ffffff
00000051d0000000ffffff96
-
{e=>0,c=>0,a=>15,b=>0,d=>-1,f=>2}
0f0000000400000002000000
0f000000040000000200000000000000
0f000000040000000200000000000000
0000000f2000000000000002
0f0000000400000002000000
0f0000000400000002000000
0000000f200000000000000200000000
0f0000000400000002000000
0000000f2000000000000002
-
{e=>0,c=>0,a=>91,b=>-1,d=>0,f=>98}
5b0000000100000062000000
5b000000010000006200000000000000
5b000000010000006200000000000000
0000005b8000000000000062
5b0000000100000062000000
5b0000000100000062000000
0000005b800000000000006200000000
5b0000000100000062000000
0000005b8000000000000062
=
struct smixed {
  long a;
  signed char  b:1;
};
-
{a=>60,b=>-1}
3c00000001000000
3c000000000000000100000000000000
3c000000000000000100000000000000
0000003c80000000
3c00000001000000
3c00000001000000
000000000000003c8000000000000000
3c00000001000000
0000003c80000000
-
{a=>125,b=>-1}
7d00000001000000
7d000000000000000100000000000000
7d000000000000000100000000000000
0000007d80000000
7d00000001000000
7d00000001000000
000000000000007d8000000000000000
7d00000001000000
0000007d80000000
-
{a=>-23,b=>-1}
e9ffffff01000000
e9ffffffffffffff0100000000000000
e9ffffffffffffff0100000000000000
ffffffe980000000
e9ffffff01000000
e9ffffff01000000
ffffffffffffffe98000000000000000
e9ffffff01000000
ffffffe980000000
-
{a=>-14,b=>-1}
f2ffffff01000000
f2ffffffffffffff0100000000000000
f2ffffffffffffff0100000000000000
fffffff280000000
f2ffffff01000000
f2ffffff01000000
fffffffffffffff28000000000000000
f2ffffff01000000
fffffff280000000
-
{a=>51,b=>0}
3300000000000000
33000000000000000000000000000000
33000000000000000000000000000000
0000003300000000
3300000000000000
3300000000000000
00000000000000330000000000000000
3300000000000000
0000003300000000
=
struct smixed {
  long a;
  signed char  b:1;
  signed short c:1;
};
-
{c=>-1,a=>-105,b=>-1}
97ffffff03000000
97ffffffffffffff0300000000000000
97ffffffffffffff0300000000000000
ffffff97c0000000
97ffffff03000000
97ffffff03000000
ffffffffffffff97c000000000000000
97ffffff03000000
ffffff97c0000000
-
{c=>0,a=>31,b=>0}
1f00000000000000
1f000000000000000000000000000000
1f000000000000000000000000000000
0000001f00000000
1f00000000000000
1f00000000000000
000000000000001f0000000000000000
1f00000000000000
0000001f00000000
-
{c=>0,a=>43,b=>0}
2b00000000000000
2b000000000000000000000000000000
2b000000000000000000000000000000
0000002b00000000
2b00000000000000
2b00000000000000
000000000000002b0000000000000000
2b00000000000000
0000002b00000000
-
{c=>0,a=>-128,b=>0}
80ffffff00000000
80ffffffffffffff0000000000000000
80ffffffffffffff0000000000000000
ffffff8000000000
80ffffff00000000
80ffffff00000000
ffffffffffffff800000000000000000
80ffffff00000000
ffffff8000000000
-
{c=>-1,a=>101,b=>0}
6500000002000000
65000000000000000200000000000000
65000000000000000200000000000000
0000006540000000
6500000002000000
6500000002000000
00000000000000654000000000000000
6500000002000000
0000006540000000
=
struct smixed {
  long a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
};
-
{c=>0,a=>18,b=>0,d=>-1}
1200000004000000
12000000000000000400000000000000
12000000000000000400000000000000
0000001220000000
1200000004000000
1200000004000000
00000000000000122000000000000000
1200000004000000
0000001220000000
-
{c=>-1,a=>-93,b=>-1,d=>0}
a3ffffff03000000
a3ffffffffffffff0300000000000000
a3ffffffffffffff0300000000000000
ffffffa3c0000000
a3ffffff03000000
a3ffffff03000000
ffffffffffffffa3c000000000000000
a3ffffff03000000
ffffffa3c0000000
-
{c=>-1,a=>-110,b=>-1,d=>-1}
92ffffff07000000
92ffffffffffffff0700000000000000
92ffffffffffffff0700000000000000
ffffff92e0000000
92ffffff07000000
92ffffff07000000
ffffffffffffff92e000000000000000
92ffffff07000000
ffffff92e0000000
-
{c=>-1,a=>-52,b=>0,d=>-1}
ccffffff06000000
ccffffffffffffff0600000000000000
ccffffffffffffff0600000000000000
ffffffcc60000000
ccffffff06000000
ccffffff06000000
ffffffffffffffcc6000000000000000
ccffffff06000000
ffffffcc60000000
-
{c=>0,a=>120,b=>-1,d=>-1}
7800000005000000
78000000000000000500000000000000
78000000000000000500000000000000
00000078a0000000
7800000005000000
7800000005000000
0000000000000078a000000000000000
7800000005000000
00000078a0000000
=
struct smixed {
  long a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
};
-
{e=>-1,c=>-1,a=>-121,b=>0,d=>-1}
87ffffff0e000000
87ffffffffffffff0e00000000000000
87ffffffffffffff0e00000000000000
ffffff8770000000
87ffffff0e000000
87ffffff0e000000
ffffffffffffff877000000000000000
87ffffff0e000000
ffffff8770000000
-
{e=>0,c=>0,a=>-86,b=>0,d=>-1}
aaffffff04000000
aaffffffffffffff0400000000000000
aaffffffffffffff0400000000000000
ffffffaa20000000
aaffffff04000000
aaffffff04000000
ffffffffffffffaa2000000000000000
aaffffff04000000
ffffffaa20000000
-
{e=>-1,c=>0,a=>115,b=>-1,d=>0}
7300000009000000
73000000000000000900000000000000
73000000000000000900000000000000
0000007390000000
7300000009000000
7300000009000000
00000000000000739000000000000000
7300000009000000
0000007390000000
-
{e=>-1,c=>-1,a=>26,b=>-1,d=>-1}
1a0000000f000000
1a000000000000000f00000000000000
1a000000000000000f00000000000000
0000001af0000000
1a0000000f000000
1a0000000f000000
000000000000001af000000000000000
1a0000000f000000
0000001af0000000
-
{e=>-1,c=>-1,a=>-108,b=>-1,d=>-1}
94ffffff0f000000
94ffffffffffffff0f00000000000000
94ffffffffffffff0f00000000000000
ffffff94f0000000
94ffffff0f000000
94ffffff0f000000
ffffffffffffff94f000000000000000
94ffffff0f000000
ffffff94f0000000
=
struct smixed {
  long a;
  signed char  b:1;
  signed short c:1;
  signed int   d:1;
  signed long  e:1;
  signed int   f;
};
-
{e=>-1,c=>-1,a=>26,b=>0,d=>-1,f=>-117}
1a0000000e0000008bffffff
1a000000000000000e0000008bffffff
1a000000000000000e0000008bffffff
0000001a70000000ffffff8b
1a0000000e0000008bffffff
1a0000000e0000008bffffff
000000000000001a70000000ffffff8b
1a0000000e0000008bffffff
0000001a70000000ffffff8b
-
{e=>-1,c=>0,a=>-97,b=>0,d=>-1,f=>99}
9fffffff0c00000063000000
9fffffffffffffff0c00000063000000
9fffffffffffffff0c00000063000000
ffffff9f3000000000000063
9fffffff0c00000063000000
9fffffff0c00000063000000
ffffffffffffff9f3000000000000063
9fffffff0c00000063000000
ffffff9f3000000000000063
-
{e=>0,c=>-1,a=>-23,b=>-1,d=>0,f=>63}
e9ffffff030000003f000000
e9ffffffffffffff030000003f000000
e9ffffffffffffff030000003f000000
ffffffe9c00000000000003f
e9ffffff030000003f000000
e9ffffff030000003f000000
ffffffffffffffe9c00000000000003f
e9ffffff030000003f000000
ffffffe9c00000000000003f
-
{e=>0,c=>-1,a=>95,b=>0,d=>-1,f=>108}
5f000000060000006c000000
5f00000000000000060000006c000000
5f00000000000000060000006c000000
0000005f600000000000006c
5f000000060000006c000000
5f000000060000006c000000
000000000000005f600000000000006c
5f000000060000006c000000
0000005f600000000000006c
-
{e=>-1,c=>0,a=>-97,b=>0,d=>0,f=>86}
9fffffff0800000056000000
9fffffffffffffff0800000056000000
9fffffffffffffff0800000056000000
ffffff9f1000000000000056
9fffffff0800000056000000
9fffffff0800000056000000
ffffffffffffff9f1000000000000056
9fffffff0800000056000000
ffffff9f1000000000000056
=
struct mixed {
  unsigned char  a:1;
};
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
};
-
{a=>0,b=>-1}
02
02
02
40
02000000
02
40
02
40
-
{a=>1,b=>0}
01
01
01
80
01000000
01
80
01
80
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1,b=>0}
01
01
01
80
01000000
01
80
01
80
-
{a=>1,b=>0}
01
01
01
80
01000000
01
80
01
80
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
};
-
{c=>1,a=>0,b=>0}
0400
0400
0400
2000
04000000
0400
2000
0400
2000
-
{c=>1,a=>1,b=>-1}
0700
0700
0700
e000
07000000
0700
e000
0700
e000
-
{c=>1,a=>0,b=>0}
0400
0400
0400
2000
04000000
0400
2000
0400
2000
-
{c=>1,a=>1,b=>-1}
0700
0700
0700
e000
07000000
0700
e000
0700
e000
-
{c=>1,a=>0,b=>-1}
0600
0600
0600
6000
06000000
0600
6000
0600
6000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
};
-
{c=>0,a=>1,b=>0,d=>-1}
0900
0900
0900
9000
09000000
0900
9000
0900
9000
-
{c=>0,a=>1,b=>0,d=>-1}
0900
0900
0900
9000
09000000
0900
9000
0900
9000
-
{c=>0,a=>1,b=>-1,d=>0}
0300
0300
0300
c000
03000000
0300
c000
0300
c000
-
{c=>1,a=>1,b=>-1,d=>0}
0700
0700
0700
e000
07000000
0700
e000
0700
e000
-
{c=>1,a=>0,b=>-1,d=>-1}
0e00
0e00
0e00
7000
0e000000
0e00
7000
0e00
7000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
  unsigned int   e:1;
};
-
{e=>1,c=>1,a=>0,b=>-1,d=>-1}
1e000000
1e000000
1e000000
78000000
1e000000
1e000000
78000000
1e000000
78000000
-
{e=>0,c=>1,a=>1,b=>-1,d=>-1}
0f000000
0f000000
0f000000
f0000000
0f000000
0f000000
f0000000
0f000000
f0000000
-
{e=>1,c=>1,a=>0,b=>0,d=>0}
14000000
14000000
14000000
28000000
14000000
14000000
28000000
14000000
28000000
-
{e=>0,c=>1,a=>1,b=>0,d=>-1}
0d000000
0d000000
0d000000
b0000000
0d000000
0d000000
b0000000
0d000000
b0000000
-
{e=>0,c=>0,a=>1,b=>0,d=>-1}
09000000
09000000
09000000
90000000
09000000
09000000
90000000
09000000
90000000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
  unsigned int   e:1;
  signed   int   f:1;
};
-
{e=>0,c=>0,a=>0,b=>0,d=>-1,f=>-1}
28000000
28000000
28000000
14000000
28000000
28000000
14000000
28000000
14000000
-
{e=>0,c=>0,a=>1,b=>0,d=>-1,f=>-1}
29000000
29000000
29000000
94000000
29000000
29000000
94000000
29000000
94000000
-
{e=>0,c=>1,a=>0,b=>-1,d=>-1,f=>-1}
2e000000
2e000000
2e000000
74000000
2e000000
2e000000
74000000
2e000000
74000000
-
{e=>1,c=>0,a=>0,b=>-1,d=>-1,f=>0}
1a000000
1a000000
1a000000
58000000
1a000000
1a000000
58000000
1a000000
58000000
-
{e=>0,c=>0,a=>0,b=>0,d=>0,f=>-1}
20000000
20000000
20000000
04000000
20000000
20000000
04000000
20000000
04000000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
  unsigned int   e:1;
  signed   int   f:1;
  unsigned long  g:1;
};
-
{e=>0,c=>0,a=>0,g=>0,b=>-1,d=>0,f=>0}
02000000
0200000000000000
0200000000000000
40000000
02000000
02000000
4000000000000000
02000000
40000000
-
{e=>1,c=>0,a=>1,g=>0,b=>0,d=>-1,f=>-1}
39000000
3900000000000000
3900000000000000
9c000000
39000000
39000000
9c00000000000000
39000000
9c000000
-
{e=>1,c=>0,a=>1,g=>1,b=>0,d=>0,f=>0}
51000000
5100000000000000
5100000000000000
8a000000
51000000
51000000
8a00000000000000
51000000
8a000000
-
{e=>0,c=>0,a=>1,g=>0,b=>-1,d=>-1,f=>0}
0b000000
0b00000000000000
0b00000000000000
d0000000
0b000000
0b000000
d000000000000000
0b000000
d0000000
-
{e=>0,c=>1,a=>0,g=>1,b=>-1,d=>0,f=>0}
46000000
4600000000000000
4600000000000000
62000000
46000000
46000000
6200000000000000
46000000
62000000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
  unsigned int   e:1;
  signed   int   f:1;
  unsigned long  g:1;
  signed   long  h:1;
};
-
{e=>1,a=>1,d=>-1,c=>1,h=>0,b=>-1,g=>1,f=>-1}
7f000000
7f00000000000000
7f00000000000000
fe000000
7f000000
7f000000
fe00000000000000
7f000000
fe000000
-
{e=>0,a=>0,d=>-1,c=>1,h=>0,b=>0,g=>0,f=>0}
0c000000
0c00000000000000
0c00000000000000
30000000
0c000000
0c000000
3000000000000000
0c000000
30000000
-
{e=>1,a=>0,d=>-1,c=>0,h=>-1,b=>0,g=>1,f=>0}
d8000000
d800000000000000
d800000000000000
1b000000
d8000000
d8000000
1b00000000000000
d8000000
1b000000
-
{e=>1,a=>0,d=>-1,c=>0,h=>-1,b=>0,g=>0,f=>0}
98000000
9800000000000000
9800000000000000
19000000
98000000
98000000
1900000000000000
98000000
19000000
-
{e=>1,a=>1,d=>0,c=>1,h=>0,b=>-1,g=>0,f=>0}
17000000
1700000000000000
1700000000000000
e8000000
17000000
17000000
e800000000000000
17000000
e8000000
=
struct mixed {
  unsigned char  a:1;
  signed   char  b:1;
  unsigned short c:1;
  signed   short d:1;
  unsigned int   e:1;
  signed   int   f:1;
  unsigned long  g:1;
  signed   long  h:1;
  unsigned char  i;
};
-
{e=>1,a=>0,d=>-1,c=>1,h=>-1,b=>-1,g=>0,f=>-1,i=>162}
bea20000
bea2000000000000
bea2000000000000
7da20000
bea20000
bea20000
7da2000000000000
bea20000
7da20000
-
{e=>1,a=>1,d=>0,c=>0,h=>0,b=>-1,g=>0,f=>0,i=>113}
13710000
1371000000000000
1371000000000000
c8710000
13710000
13710000
c871000000000000
13710000
c8710000
-
{e=>0,a=>1,d=>0,c=>1,h=>0,b=>0,g=>1,f=>-1,i=>177}
65b10000
65b1000000000000
65b1000000000000
a6b10000
65b10000
65b10000
a6b1000000000000
65b10000
a6b10000
-
{e=>0,a=>1,d=>-1,c=>1,h=>0,b=>0,g=>1,f=>-1,i=>254}
6dfe0000
6dfe000000000000
6dfe000000000000
b6fe0000
6dfe0000
6dfe0000
b6fe000000000000
6dfe0000
b6fe0000
-
{e=>1,a=>0,d=>-1,c=>0,h=>0,b=>0,g=>0,f=>-1,i=>196}
38c40000
38c4000000000000
38c4000000000000
1cc40000
38c40000
38c40000
1cc4000000000000
38c40000
1cc40000
=
struct mixed {
  char a;
  unsigned char  b:1;
};
-
{a=>59,b=>1}
3b01
3b01
3b01
3b80
3b010000
3b01
3b80
3b01
3b80
-
{a=>126,b=>1}
7e01
7e01
7e01
7e80
7e010000
7e01
7e80
7e01
7e80
-
{a=>58,b=>1}
3a01
3a01
3a01
3a80
3a010000
3a01
3a80
3a01
3a80
-
{a=>84,b=>0}
5400
5400
5400
5400
54000000
5400
5400
5400
5400
-
{a=>-59,b=>1}
c501
c501
c501
c580
c5010000
c501
c580
c501
c580
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
};
-
{c=>0,a=>-8,b=>1}
f801
f801
f801
f880
f8010000
f801
f880
f801
f880
-
{c=>-1,a=>-61,b=>1}
c303
c303
c303
c3c0
c3030000
c303
c3c0
c303
c3c0
-
{c=>0,a=>38,b=>0}
2600
2600
2600
2600
26000000
2600
2600
2600
2600
-
{c=>0,a=>103,b=>1}
6701
6701
6701
6780
67010000
6701
6780
6701
6780
-
{c=>0,a=>-74,b=>0}
b600
b600
b600
b600
b6000000
b600
b600
b600
b600
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
};
-
{c=>-1,a=>-94,b=>0,d=>0}
a202
a202
a202
a240
a2020000
a202
a240
a202
a240
-
{c=>0,a=>18,b=>1,d=>0}
1201
1201
1201
1280
12010000
1201
1280
1201
1280
-
{c=>0,a=>83,b=>1,d=>1}
5305
5305
5305
53a0
53050000
5305
53a0
5305
53a0
-
{c=>-1,a=>41,b=>1,d=>1}
2907
2907
2907
29e0
29070000
2907
29e0
2907
29e0
-
{c=>-1,a=>28,b=>0,d=>1}
1c06
1c06
1c06
1c60
1c060000
1c06
1c60
1c06
1c60
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
};
-
{e=>0,c=>-1,a=>112,b=>1,d=>0}
7003
7003
7003
70c0
70030000
7003
70c0
7003
70c0
-
{e=>-1,c=>0,a=>72,b=>1,d=>1}
480d
480d
480d
48b0
480d0000
480d
48b0
480d
48b0
-
{e=>-1,c=>0,a=>33,b=>0,d=>1}
210c
210c
210c
2130
210c0000
210c
2130
210c
2130
-
{e=>-1,c=>-1,a=>57,b=>1,d=>0}
390b
390b
390b
39d0
390b0000
390b
39d0
390b
39d0
-
{e=>0,c=>0,a=>99,b=>1,d=>1}
6305
6305
6305
63a0
63050000
6305
63a0
6305
63a0
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
};
-
{e=>0,c=>0,a=>-16,b=>0,d=>0,f=>1}
f0100000
f0100000
f0100000
f0080000
f0100000
f0100000
f0080000
f0100000
f0080000
-
{e=>0,c=>0,a=>35,b=>0,d=>1,f=>1}
23140000
23140000
23140000
23280000
23140000
23140000
23280000
23140000
23280000
-
{e=>0,c=>-1,a=>24,b=>1,d=>0,f=>1}
18130000
18130000
18130000
18c80000
18130000
18130000
18c80000
18130000
18c80000
-
{e=>-1,c=>0,a=>-56,b=>0,d=>1,f=>1}
c81c0000
c81c0000
c81c0000
c8380000
c81c0000
c81c0000
c8380000
c81c0000
c8380000
-
{e=>0,c=>0,a=>-67,b=>1,d=>0,f=>0}
bd010000
bd010000
bd010000
bd800000
bd010000
bd010000
bd800000
bd010000
bd800000
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
};
-
{e=>-1,c=>0,a=>-105,g=>0,b=>0,d=>0,f=>0}
97080000
97080000
97080000
97100000
97080000
97080000
97100000
97080000
97100000
-
{e=>0,c=>-1,a=>101,g=>-1,b=>0,d=>0,f=>0}
65220000
65220000
65220000
65440000
65220000
65220000
65440000
65220000
65440000
-
{e=>0,c=>0,a=>-86,g=>-1,b=>0,d=>1,f=>0}
aa240000
aa240000
aa240000
aa240000
aa240000
aa240000
aa240000
aa240000
aa240000
-
{e=>0,c=>-1,a=>-47,g=>-1,b=>0,d=>0,f=>0}
d1220000
d1220000
d1220000
d1440000
d1220000
d1220000
d1440000
d1220000
d1440000
-
{e=>0,c=>0,a=>117,g=>-1,b=>1,d=>0,f=>0}
75210000
75210000
75210000
75840000
75210000
75210000
75840000
75210000
75840000
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
};
-
{e=>-1,a=>77,d=>0,c=>0,h=>0,b=>1,g=>0,f=>1}
4d190000
4d19000000000000
4d19000000000000
4d980000
4d190000
4d190000
4d98000000000000
4d190000
4d980000
-
{e=>-1,a=>-38,d=>1,c=>-1,h=>1,b=>0,g=>0,f=>0}
da4e0000
da4e000000000000
da4e000000000000
da720000
da4e0000
da4e0000
da72000000000000
da4e0000
da720000
-
{e=>-1,a=>-89,d=>0,c=>0,h=>1,b=>1,g=>-1,f=>1}
a7790000
a779000000000000
a779000000000000
a79e0000
a7790000
a7790000
a79e000000000000
a7790000
a79e0000
-
{e=>0,a=>-55,d=>1,c=>-1,h=>1,b=>1,g=>-1,f=>1}
c9770000
c977000000000000
c977000000000000
c9ee0000
c9770000
c9770000
c9ee000000000000
c9770000
c9ee0000
-
{e=>0,a=>76,d=>0,c=>-1,h=>0,b=>0,g=>-1,f=>1}
4c320000
4c32000000000000
4c32000000000000
4c4c0000
4c320000
4c320000
4c4c000000000000
4c320000
4c4c0000
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
};
-
{e=>0,a=>51,d=>1,c=>0,h=>1,b=>1,g=>-1,f=>0,i=>-1}
33e50000
33e5000000000000
33e5000000000000
33a70000
33e50000
33e50000
33a7000000000000
33e50000
33a70000
-
{e=>0,a=>101,d=>0,c=>-1,h=>1,b=>0,g=>-1,f=>0,i=>-1}
65e20000
65e2000000000000
65e2000000000000
65470000
65e20000
65e20000
6547000000000000
65e20000
65470000
-
{e=>0,a=>-74,d=>1,c=>-1,h=>0,b=>0,g=>0,f=>0,i=>0}
b6060000
b606000000000000
b606000000000000
b6600000
b6060000
b6060000
b660000000000000
b6060000
b6600000
-
{e=>0,a=>124,d=>1,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>-1}
7c970000
7c97000000000000
7c97000000000000
7ce90000
7c970000
7c970000
7ce9000000000000
7c970000
7ce90000
-
{e=>-1,a=>24,d=>0,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>0}
181b0000
181b000000000000
181b000000000000
18d80000
181b0000
181b0000
18d8000000000000
181b0000
18d80000
=
struct mixed {
  char a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
  unsigned char  j;
};
-
{e=>-1,a=>-115,d=>0,j=>73,c=>-1,h=>1,b=>0,g=>0,f=>0,i=>-1}
8dca4900
8dca490000000000
8dca490000000000
8d534900
8dca4900
8dca4900
8d53490000000000
8dca4900
8d534900
-
{e=>0,a=>112,d=>0,j=>186,c=>0,h=>1,b=>0,g=>0,f=>1,i=>0}
7050ba00
7050ba0000000000
7050ba0000000000
700aba00
7050ba00
7050ba00
700aba0000000000
7050ba00
700aba00
-
{e=>0,a=>27,d=>0,j=>247,c=>-1,h=>1,b=>1,g=>0,f=>1,i=>0}
1b53f700
1b53f70000000000
1b53f70000000000
1bcaf700
1b53f700
1b53f700
1bcaf70000000000
1b53f700
1bcaf700
-
{e=>-1,a=>0,d=>1,j=>68,c=>-1,h=>1,b=>0,g=>0,f=>0,i=>0}
004e4400
004e440000000000
004e440000000000
00724400
004e4400
004e4400
0072440000000000
004e4400
00724400
-
{e=>-1,a=>116,d=>0,j=>30,c=>-1,h=>1,b=>0,g=>-1,f=>1,i=>0}
747a1e00
747a1e0000000000
747a1e0000000000
745e1e00
747a1e00
747a1e00
745e1e0000000000
747a1e00
745e1e00
=
struct mixed {
  short a;
  unsigned char  b:1;
};
-
{a=>43,b=>0}
2b000000
2b000000
2b000000
002b0000
2b000000
2b000000
002b0000
2b000000
002b0000
-
{a=>-77,b=>0}
b3ff0000
b3ff0000
b3ff0000
ffb30000
b3ff0000
b3ff0000
ffb30000
b3ff0000
ffb30000
-
{a=>-127,b=>0}
81ff0000
81ff0000
81ff0000
ff810000
81ff0000
81ff0000
ff810000
81ff0000
ff810000
-
{a=>-70,b=>0}
baff0000
baff0000
baff0000
ffba0000
baff0000
baff0000
ffba0000
baff0000
ffba0000
-
{a=>-21,b=>0}
ebff0000
ebff0000
ebff0000
ffeb0000
ebff0000
ebff0000
ffeb0000
ebff0000
ffeb0000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
};
-
{c=>0,a=>1,b=>1}
01000100
01000100
01000100
00018000
01000100
01000100
00018000
01000100
00018000
-
{c=>-1,a=>-65,b=>0}
bfff0200
bfff0200
bfff0200
ffbf4000
bfff0200
bfff0200
ffbf4000
bfff0200
ffbf4000
-
{c=>0,a=>-122,b=>0}
86ff0000
86ff0000
86ff0000
ff860000
86ff0000
86ff0000
ff860000
86ff0000
ff860000
-
{c=>-1,a=>-8,b=>1}
f8ff0300
f8ff0300
f8ff0300
fff8c000
f8ff0300
f8ff0300
fff8c000
f8ff0300
fff8c000
-
{c=>-1,a=>50,b=>1}
32000300
32000300
32000300
0032c000
32000300
32000300
0032c000
32000300
0032c000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
};
-
{c=>0,a=>24,b=>1,d=>1}
18000500
18000500
18000500
0018a000
18000500
18000500
0018a000
18000500
0018a000
-
{c=>0,a=>-41,b=>0,d=>1}
d7ff0400
d7ff0400
d7ff0400
ffd72000
d7ff0400
d7ff0400
ffd72000
d7ff0400
ffd72000
-
{c=>-1,a=>-82,b=>0,d=>0}
aeff0200
aeff0200
aeff0200
ffae4000
aeff0200
aeff0200
ffae4000
aeff0200
ffae4000
-
{c=>0,a=>124,b=>1,d=>0}
7c000100
7c000100
7c000100
007c8000
7c000100
7c000100
007c8000
7c000100
007c8000
-
{c=>0,a=>-85,b=>0,d=>1}
abff0400
abff0400
abff0400
ffab2000
abff0400
abff0400
ffab2000
abff0400
ffab2000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
};
-
{e=>-1,c=>0,a=>92,b=>1,d=>0}
5c000900
5c000900
5c000900
005c9000
5c000900
5c000900
005c9000
5c000900
005c9000
-
{e=>0,c=>0,a=>104,b=>1,d=>0}
68000100
68000100
68000100
00688000
68000100
68000100
00688000
68000100
00688000
-
{e=>-1,c=>-1,a=>-96,b=>1,d=>0}
a0ff0b00
a0ff0b00
a0ff0b00
ffa0d000
a0ff0b00
a0ff0b00
ffa0d000
a0ff0b00
ffa0d000
-
{e=>0,c=>0,a=>-66,b=>0,d=>1}
beff0400
beff0400
beff0400
ffbe2000
beff0400
beff0400
ffbe2000
beff0400
ffbe2000
-
{e=>0,c=>0,a=>126,b=>0,d=>0}
7e000000
7e000000
7e000000
007e0000
7e000000
7e000000
007e0000
7e000000
007e0000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
};
-
{e=>0,c=>0,a=>-15,b=>1,d=>1,f=>1}
f1ff1500
f1ff1500
f1ff1500
fff1a800
f1ff1500
f1ff1500
fff1a800
f1ff1500
fff1a800
-
{e=>-1,c=>-1,a=>15,b=>0,d=>0,f=>1}
0f001a00
0f001a00
0f001a00
000f5800
0f001a00
0f001a00
000f5800
0f001a00
000f5800
-
{e=>-1,c=>-1,a=>75,b=>1,d=>1,f=>1}
4b001f00
4b001f00
4b001f00
004bf800
4b001f00
4b001f00
004bf800
4b001f00
004bf800
-
{e=>0,c=>0,a=>127,b=>0,d=>0,f=>1}
7f001000
7f001000
7f001000
007f0800
7f001000
7f001000
007f0800
7f001000
007f0800
-
{e=>-1,c=>-1,a=>0,b=>0,d=>0,f=>0}
00000a00
00000a00
00000a00
00005000
00000a00
00000a00
00005000
00000a00
00005000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
};
-
{e=>-1,c=>0,a=>-96,g=>0,b=>0,d=>1,f=>0}
a0ff0c00
a0ff0c00
a0ff0c00
ffa03000
a0ff0c00
a0ff0c00
ffa03000
a0ff0c00
ffa03000
-
{e=>-1,c=>-1,a=>-116,g=>-1,b=>0,d=>1,f=>1}
8cff3e00
8cff3e00
8cff3e00
ff8c7c00
8cff3e00
8cff3e00
ff8c7c00
8cff3e00
ff8c7c00
-
{e=>0,c=>0,a=>16,g=>0,b=>1,d=>0,f=>1}
10001100
10001100
10001100
00108800
10001100
10001100
00108800
10001100
00108800
-
{e=>-1,c=>0,a=>108,g=>-1,b=>1,d=>0,f=>1}
6c003900
6c003900
6c003900
006c9c00
6c003900
6c003900
006c9c00
6c003900
006c9c00
-
{e=>-1,c=>0,a=>89,g=>0,b=>1,d=>1,f=>0}
59000d00
59000d00
59000d00
0059b000
59000d00
59000d00
0059b000
59000d00
0059b000
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
};
-
{e=>0,a=>-94,d=>1,c=>0,h=>1,b=>0,g=>0,f=>0}
a2ff4400
a2ff440000000000
a2ff440000000000
ffa22200
a2ff4400
a2ff4400
ffa2220000000000
a2ff4400
ffa22200
-
{e=>-1,a=>-38,d=>1,c=>0,h=>0,b=>1,g=>-1,f=>1}
daff3d00
daff3d0000000000
daff3d0000000000
ffdabc00
daff3d00
daff3d00
ffdabc0000000000
daff3d00
ffdabc00
-
{e=>0,a=>-42,d=>0,c=>0,h=>0,b=>0,g=>-1,f=>0}
d6ff2000
d6ff200000000000
d6ff200000000000
ffd60400
d6ff2000
d6ff2000
ffd6040000000000
d6ff2000
ffd60400
-
{e=>0,a=>-80,d=>0,c=>0,h=>1,b=>0,g=>0,f=>0}
b0ff4000
b0ff400000000000
b0ff400000000000
ffb00200
b0ff4000
b0ff4000
ffb0020000000000
b0ff4000
ffb00200
-
{e=>0,a=>-7,d=>0,c=>0,h=>1,b=>1,g=>0,f=>1}
f9ff5100
f9ff510000000000
f9ff510000000000
fff98a00
f9ff5100
f9ff5100
fff98a0000000000
f9ff5100
fff98a00
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
};
-
{e=>-1,a=>106,d=>1,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>0}
6a001f00
6a001f0000000000
6a001f0000000000
006af800
6a001f00
6a001f00
006af80000000000
6a001f00
006af800
-
{e=>0,a=>10,d=>0,c=>0,h=>1,b=>0,g=>-1,f=>0,i=>-1}
0a00e000
0a00e00000000000
0a00e00000000000
000a0700
0a00e000
0a00e000
000a070000000000
0a00e000
000a0700
-
{e=>-1,a=>93,d=>1,c=>0,h=>0,b=>0,g=>0,f=>0,i=>0}
5d000c00
5d000c0000000000
5d000c0000000000
005d3000
5d000c00
5d000c00
005d300000000000
5d000c00
005d3000
-
{e=>-1,a=>-24,d=>0,c=>0,h=>1,b=>1,g=>0,f=>1,i=>0}
e8ff5900
e8ff590000000000
e8ff590000000000
ffe89a00
e8ff5900
e8ff5900
ffe89a0000000000
e8ff5900
ffe89a00
-
{e=>0,a=>-98,d=>0,c=>0,h=>1,b=>0,g=>-1,f=>1,i=>-1}
9efff000
9efff00000000000
9efff00000000000
ff9e0f00
9efff000
9efff000
ff9e0f0000000000
9efff000
ff9e0f00
=
struct mixed {
  short a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
  unsigned char  j;
};
-
{e=>-1,a=>-30,d=>0,j=>167,c=>0,h=>1,b=>1,g=>0,f=>0,i=>0}
e2ff49a7
e2ff49a700000000
e2ff49a700000000
ffe292a7
e2ff49a7
e2ff49a7
ffe292a700000000
e2ff49a7
ffe292a7
-
{e=>0,a=>34,d=>1,j=>13,c=>0,h=>1,b=>1,g=>0,f=>0,i=>-1}
2200c50d
2200c50d00000000
2200c50d00000000
0022a30d
2200c50d
2200c50d
0022a30d00000000
2200c50d
0022a30d
-
{e=>-1,a=>-125,d=>0,j=>209,c=>0,h=>0,b=>0,g=>0,f=>0,i=>0}
83ff08d1
83ff08d100000000
83ff08d100000000
ff8310d1
83ff08d1
83ff08d1
ff8310d100000000
83ff08d1
ff8310d1
-
{e=>0,a=>57,d=>0,j=>197,c=>0,h=>0,b=>0,g=>-1,f=>1,i=>-1}
3900b0c5
3900b0c500000000
3900b0c500000000
00390dc5
3900b0c5
3900b0c5
00390dc500000000
3900b0c5
00390dc5
-
{e=>-1,a=>101,d=>1,j=>141,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>-1}
65009f8d
65009f8d00000000
65009f8d00000000
0065f98d
65009f8d
65009f8d
0065f98d00000000
65009f8d
0065f98d
=
struct mixed {
  int a;
  unsigned char  b:1;
};
-
{a=>59,b=>1}
3b00000001000000
3b00000001000000
3b00000001000000
0000003b80000000
3b00000001000000
3b00000001000000
0000003b80000000
3b00000001000000
0000003b80000000
-
{a=>25,b=>0}
1900000000000000
1900000000000000
1900000000000000
0000001900000000
1900000000000000
1900000000000000
0000001900000000
1900000000000000
0000001900000000
-
{a=>-69,b=>1}
bbffffff01000000
bbffffff01000000
bbffffff01000000
ffffffbb80000000
bbffffff01000000
bbffffff01000000
ffffffbb80000000
bbffffff01000000
ffffffbb80000000
-
{a=>106,b=>0}
6a00000000000000
6a00000000000000
6a00000000000000
0000006a00000000
6a00000000000000
6a00000000000000
0000006a00000000
6a00000000000000
0000006a00000000
-
{a=>112,b=>1}
7000000001000000
7000000001000000
7000000001000000
0000007080000000
7000000001000000
7000000001000000
0000007080000000
7000000001000000
0000007080000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
};
-
{c=>-1,a=>17,b=>0}
1100000002000000
1100000002000000
1100000002000000
0000001140000000
1100000002000000
1100000002000000
0000001140000000
1100000002000000
0000001140000000
-
{c=>-1,a=>-75,b=>1}
b5ffffff03000000
b5ffffff03000000
b5ffffff03000000
ffffffb5c0000000
b5ffffff03000000
b5ffffff03000000
ffffffb5c0000000
b5ffffff03000000
ffffffb5c0000000
-
{c=>-1,a=>86,b=>0}
5600000002000000
5600000002000000
5600000002000000
0000005640000000
5600000002000000
5600000002000000
0000005640000000
5600000002000000
0000005640000000
-
{c=>0,a=>-126,b=>1}
82ffffff01000000
82ffffff01000000
82ffffff01000000
ffffff8280000000
82ffffff01000000
82ffffff01000000
ffffff8280000000
82ffffff01000000
ffffff8280000000
-
{c=>-1,a=>49,b=>1}
3100000003000000
3100000003000000
3100000003000000
00000031c0000000
3100000003000000
3100000003000000
00000031c0000000
3100000003000000
00000031c0000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
};
-
{c=>-1,a=>-126,b=>0,d=>0}
82ffffff02000000
82ffffff02000000
82ffffff02000000
ffffff8240000000
82ffffff02000000
82ffffff02000000
ffffff8240000000
82ffffff02000000
ffffff8240000000
-
{c=>0,a=>-97,b=>0,d=>1}
9fffffff04000000
9fffffff04000000
9fffffff04000000
ffffff9f20000000
9fffffff04000000
9fffffff04000000
ffffff9f20000000
9fffffff04000000
ffffff9f20000000
-
{c=>0,a=>25,b=>0,d=>0}
1900000000000000
1900000000000000
1900000000000000
0000001900000000
1900000000000000
1900000000000000
0000001900000000
1900000000000000
0000001900000000
-
{c=>0,a=>-28,b=>1,d=>1}
e4ffffff05000000
e4ffffff05000000
e4ffffff05000000
ffffffe4a0000000
e4ffffff05000000
e4ffffff05000000
ffffffe4a0000000
e4ffffff05000000
ffffffe4a0000000
-
{c=>-1,a=>112,b=>1,d=>0}
7000000003000000
7000000003000000
7000000003000000
00000070c0000000
7000000003000000
7000000003000000
00000070c0000000
7000000003000000
00000070c0000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
};
-
{e=>0,c=>-1,a=>122,b=>0,d=>1}
7a00000006000000
7a00000006000000
7a00000006000000
0000007a60000000
7a00000006000000
7a00000006000000
0000007a60000000
7a00000006000000
0000007a60000000
-
{e=>-1,c=>-1,a=>-41,b=>1,d=>0}
d7ffffff0b000000
d7ffffff0b000000
d7ffffff0b000000
ffffffd7d0000000
d7ffffff0b000000
d7ffffff0b000000
ffffffd7d0000000
d7ffffff0b000000
ffffffd7d0000000
-
{e=>-1,c=>-1,a=>67,b=>0,d=>0}
430000000a000000
430000000a000000
430000000a000000
0000004350000000
430000000a000000
430000000a000000
0000004350000000
430000000a000000
0000004350000000
-
{e=>0,c=>0,a=>-109,b=>0,d=>1}
93ffffff04000000
93ffffff04000000
93ffffff04000000
ffffff9320000000
93ffffff04000000
93ffffff04000000
ffffff9320000000
93ffffff04000000
ffffff9320000000
-
{e=>0,c=>0,a=>-80,b=>1,d=>0}
b0ffffff01000000
b0ffffff01000000
b0ffffff01000000
ffffffb080000000
b0ffffff01000000
b0ffffff01000000
ffffffb080000000
b0ffffff01000000
ffffffb080000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
};
-
{e=>0,c=>-1,a=>-35,b=>1,d=>0,f=>0}
ddffffff03000000
ddffffff03000000
ddffffff03000000
ffffffddc0000000
ddffffff03000000
ddffffff03000000
ffffffddc0000000
ddffffff03000000
ffffffddc0000000
-
{e=>-1,c=>-1,a=>-61,b=>0,d=>0,f=>0}
c3ffffff0a000000
c3ffffff0a000000
c3ffffff0a000000
ffffffc350000000
c3ffffff0a000000
c3ffffff0a000000
ffffffc350000000
c3ffffff0a000000
ffffffc350000000
-
{e=>0,c=>0,a=>94,b=>0,d=>0,f=>1}
5e00000010000000
5e00000010000000
5e00000010000000
0000005e08000000
5e00000010000000
5e00000010000000
0000005e08000000
5e00000010000000
0000005e08000000
-
{e=>0,c=>-1,a=>-17,b=>0,d=>0,f=>0}
efffffff02000000
efffffff02000000
efffffff02000000
ffffffef40000000
efffffff02000000
efffffff02000000
ffffffef40000000
efffffff02000000
ffffffef40000000
-
{e=>-1,c=>-1,a=>-4,b=>0,d=>1,f=>0}
fcffffff0e000000
fcffffff0e000000
fcffffff0e000000
fffffffc70000000
fcffffff0e000000
fcffffff0e000000
fffffffc70000000
fcffffff0e000000
fffffffc70000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
};
-
{e=>-1,c=>-1,a=>66,g=>0,b=>0,d=>0,f=>1}
420000001a000000
420000001a000000
420000001a000000
0000004258000000
420000001a000000
420000001a000000
0000004258000000
420000001a000000
0000004258000000
-
{e=>0,c=>-1,a=>88,g=>-1,b=>0,d=>1,f=>1}
5800000036000000
5800000036000000
5800000036000000
000000586c000000
5800000036000000
5800000036000000
000000586c000000
5800000036000000
000000586c000000
-
{e=>-1,c=>0,a=>22,g=>0,b=>0,d=>0,f=>0}
1600000008000000
1600000008000000
1600000008000000
0000001610000000
1600000008000000
1600000008000000
0000001610000000
1600000008000000
0000001610000000
-
{e=>0,c=>-1,a=>54,g=>-1,b=>0,d=>0,f=>1}
3600000032000000
3600000032000000
3600000032000000
000000364c000000
3600000032000000
3600000032000000
000000364c000000
3600000032000000
000000364c000000
-
{e=>-1,c=>-1,a=>98,g=>-1,b=>0,d=>0,f=>0}
620000002a000000
620000002a000000
620000002a000000
0000006254000000
620000002a000000
620000002a000000
0000006254000000
620000002a000000
0000006254000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
};
-
{e=>-1,a=>-102,d=>1,c=>0,h=>0,b=>1,g=>-1,f=>0}
9affffff2d000000
9affffff2d000000
9affffff2d000000
ffffff9ab4000000
9affffff2d000000
9affffff2d000000
ffffff9ab4000000
9affffff2d000000
ffffff9ab4000000
-
{e=>-1,a=>84,d=>1,c=>0,h=>0,b=>0,g=>0,f=>0}
540000000c000000
540000000c000000
540000000c000000
0000005430000000
540000000c000000
540000000c000000
0000005430000000
540000000c000000
0000005430000000
-
{e=>-1,a=>-63,d=>1,c=>-1,h=>0,b=>1,g=>0,f=>0}
c1ffffff0f000000
c1ffffff0f000000
c1ffffff0f000000
ffffffc1f0000000
c1ffffff0f000000
c1ffffff0f000000
ffffffc1f0000000
c1ffffff0f000000
ffffffc1f0000000
-
{e=>0,a=>-36,d=>0,c=>0,h=>0,b=>1,g=>-1,f=>1}
dcffffff31000000
dcffffff31000000
dcffffff31000000
ffffffdc8c000000
dcffffff31000000
dcffffff31000000
ffffffdc8c000000
dcffffff31000000
ffffffdc8c000000
-
{e=>0,a=>17,d=>0,c=>0,h=>0,b=>1,g=>-1,f=>0}
1100000021000000
1100000021000000
1100000021000000
0000001184000000
1100000021000000
1100000021000000
0000001184000000
1100000021000000
0000001184000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
};
-
{e=>0,a=>98,d=>1,c=>0,h=>1,b=>0,g=>-1,f=>0,i=>-1}
62000000e4000000
62000000e4000000
62000000e4000000
0000006227000000
62000000e4000000
62000000e4000000
0000006227000000
62000000e4000000
0000006227000000
-
{e=>0,a=>-97,d=>0,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>-1}
9fffffff93000000
9fffffff93000000
9fffffff93000000
ffffff9fc9000000
9fffffff93000000
9fffffff93000000
ffffff9fc9000000
9fffffff93000000
ffffff9fc9000000
-
{e=>-1,a=>15,d=>1,c=>-1,h=>0,b=>0,g=>0,f=>1,i=>0}
0f0000001e000000
0f0000001e000000
0f0000001e000000
0000000f78000000
0f0000001e000000
0f0000001e000000
0000000f78000000
0f0000001e000000
0000000f78000000
-
{e=>-1,a=>-3,d=>0,c=>-1,h=>0,b=>1,g=>0,f=>1,i=>0}
fdffffff1b000000
fdffffff1b000000
fdffffff1b000000
fffffffdd8000000
fdffffff1b000000
fdffffff1b000000
fffffffdd8000000
fdffffff1b000000
fffffffdd8000000
-
{e=>0,a=>101,d=>1,c=>0,h=>0,b=>0,g=>-1,f=>1,i=>-1}
65000000b4000000
65000000b4000000
65000000b4000000
000000652d000000
65000000b4000000
65000000b4000000
000000652d000000
65000000b4000000
000000652d000000
=
struct mixed {
  int a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
  unsigned char  j;
};
-
{e=>-1,a=>-121,d=>1,j=>162,c=>0,h=>1,b=>0,g=>-1,f=>0,i=>0}
87ffffff6ca20000
87ffffff6ca20000
87ffffff6ca20000
ffffff8736a20000
87ffffff6ca20000
87ffffff6ca20000
ffffff8736a20000
87ffffff6ca20000
ffffff8736a20000
-
{e=>0,a=>-14,d=>1,j=>104,c=>-1,h=>0,b=>0,g=>0,f=>1,i=>-1}
f2ffffff96680000
f2ffffff96680000
f2ffffff96680000
fffffff269680000
f2ffffff96680000
f2ffffff96680000
fffffff269680000
f2ffffff96680000
fffffff269680000
-
{e=>-1,a=>4,d=>0,j=>93,c=>-1,h=>0,b=>0,g=>0,f=>1,i=>0}
040000001a5d0000
040000001a5d0000
040000001a5d0000
00000004585d0000
040000001a5d0000
040000001a5d0000
00000004585d0000
040000001a5d0000
00000004585d0000
-
{e=>-1,a=>17,d=>0,j=>133,c=>0,h=>0,b=>1,g=>0,f=>0,i=>0}
1100000009850000
1100000009850000
1100000009850000
0000001190850000
1100000009850000
1100000009850000
0000001190850000
1100000009850000
0000001190850000
-
{e=>0,a=>56,d=>0,j=>65,c=>-1,h=>0,b=>0,g=>-1,f=>0,i=>-1}
38000000a2410000
38000000a2410000
38000000a2410000
0000003845410000
38000000a2410000
38000000a2410000
0000003845410000
38000000a2410000
0000003845410000
=
struct mixed {
  long a;
  unsigned char  b:1;
};
-
{a=>99,b=>1}
6300000001000000
63000000000000000100000000000000
63000000000000000100000000000000
0000006380000000
6300000001000000
6300000001000000
00000000000000638000000000000000
6300000001000000
0000006380000000
-
{a=>8,b=>0}
0800000000000000
08000000000000000000000000000000
08000000000000000000000000000000
0000000800000000
0800000000000000
0800000000000000
00000000000000080000000000000000
0800000000000000
0000000800000000
-
{a=>-122,b=>0}
86ffffff00000000
86ffffffffffffff0000000000000000
86ffffffffffffff0000000000000000
ffffff8600000000
86ffffff00000000
86ffffff00000000
ffffffffffffff860000000000000000
86ffffff00000000
ffffff8600000000
-
{a=>-2,b=>1}
feffffff01000000
feffffffffffffff0100000000000000
feffffffffffffff0100000000000000
fffffffe80000000
feffffff01000000
feffffff01000000
fffffffffffffffe8000000000000000
feffffff01000000
fffffffe80000000
-
{a=>102,b=>0}
6600000000000000
66000000000000000000000000000000
66000000000000000000000000000000
0000006600000000
6600000000000000
6600000000000000
00000000000000660000000000000000
6600000000000000
0000006600000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
};
-
{c=>-1,a=>96,b=>0}
6000000002000000
60000000000000000200000000000000
60000000000000000200000000000000
0000006040000000
6000000002000000
6000000002000000
00000000000000604000000000000000
6000000002000000
0000006040000000
-
{c=>-1,a=>59,b=>0}
3b00000002000000
3b000000000000000200000000000000
3b000000000000000200000000000000
0000003b40000000
3b00000002000000
3b00000002000000
000000000000003b4000000000000000
3b00000002000000
0000003b40000000
-
{c=>-1,a=>120,b=>1}
7800000003000000
78000000000000000300000000000000
78000000000000000300000000000000
00000078c0000000
7800000003000000
7800000003000000
0000000000000078c000000000000000
7800000003000000
00000078c0000000
-
{c=>0,a=>-13,b=>1}
f3ffffff01000000
f3ffffffffffffff0100000000000000
f3ffffffffffffff0100000000000000
fffffff380000000
f3ffffff01000000
f3ffffff01000000
fffffffffffffff38000000000000000
f3ffffff01000000
fffffff380000000
-
{c=>0,a=>-28,b=>0}
e4ffffff00000000
e4ffffffffffffff0000000000000000
e4ffffffffffffff0000000000000000
ffffffe400000000
e4ffffff00000000
e4ffffff00000000
ffffffffffffffe40000000000000000
e4ffffff00000000
ffffffe400000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
};
-
{c=>0,a=>109,b=>1,d=>0}
6d00000001000000
6d000000000000000100000000000000
6d000000000000000100000000000000
0000006d80000000
6d00000001000000
6d00000001000000
000000000000006d8000000000000000
6d00000001000000
0000006d80000000
-
{c=>0,a=>107,b=>0,d=>0}
6b00000000000000
6b000000000000000000000000000000
6b000000000000000000000000000000
0000006b00000000
6b00000000000000
6b00000000000000
000000000000006b0000000000000000
6b00000000000000
0000006b00000000
-
{c=>0,a=>28,b=>1,d=>1}
1c00000005000000
1c000000000000000500000000000000
1c000000000000000500000000000000
0000001ca0000000
1c00000005000000
1c00000005000000
000000000000001ca000000000000000
1c00000005000000
0000001ca0000000
-
{c=>0,a=>72,b=>0,d=>1}
4800000004000000
48000000000000000400000000000000
48000000000000000400000000000000
0000004820000000
4800000004000000
4800000004000000
00000000000000482000000000000000
4800000004000000
0000004820000000
-
{c=>0,a=>-52,b=>0,d=>1}
ccffffff04000000
ccffffffffffffff0400000000000000
ccffffffffffffff0400000000000000
ffffffcc20000000
ccffffff04000000
ccffffff04000000
ffffffffffffffcc2000000000000000
ccffffff04000000
ffffffcc20000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
};
-
{e=>0,c=>0,a=>25,b=>0,d=>1}
1900000004000000
19000000000000000400000000000000
19000000000000000400000000000000
0000001920000000
1900000004000000
1900000004000000
00000000000000192000000000000000
1900000004000000
0000001920000000
-
{e=>-1,c=>-1,a=>59,b=>1,d=>1}
3b0000000f000000
3b000000000000000f00000000000000
3b000000000000000f00000000000000
0000003bf0000000
3b0000000f000000
3b0000000f000000
000000000000003bf000000000000000
3b0000000f000000
0000003bf0000000
-
{e=>-1,c=>0,a=>124,b=>0,d=>1}
7c0000000c000000
7c000000000000000c00000000000000
7c000000000000000c00000000000000
0000007c30000000
7c0000000c000000
7c0000000c000000
000000000000007c3000000000000000
7c0000000c000000
0000007c30000000
-
{e=>-1,c=>0,a=>74,b=>0,d=>0}
4a00000008000000
4a000000000000000800000000000000
4a000000000000000800000000000000
0000004a10000000
4a00000008000000
4a00000008000000
000000000000004a1000000000000000
4a00000008000000
0000004a10000000
-
{e=>-1,c=>0,a=>-39,b=>0,d=>1}
d9ffffff0c000000
d9ffffffffffffff0c00000000000000
d9ffffffffffffff0c00000000000000
ffffffd930000000
d9ffffff0c000000
d9ffffff0c000000
ffffffffffffffd93000000000000000
d9ffffff0c000000
ffffffd930000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
};
-
{e=>-1,c=>-1,a=>-33,b=>0,d=>0,f=>0}
dfffffff0a000000
dfffffffffffffff0a00000000000000
dfffffffffffffff0a00000000000000
ffffffdf50000000
dfffffff0a000000
dfffffff0a000000
ffffffffffffffdf5000000000000000
dfffffff0a000000
ffffffdf50000000
-
{e=>0,c=>0,a=>-57,b=>1,d=>0,f=>0}
c7ffffff01000000
c7ffffffffffffff0100000000000000
c7ffffffffffffff0100000000000000
ffffffc780000000
c7ffffff01000000
c7ffffff01000000
ffffffffffffffc78000000000000000
c7ffffff01000000
ffffffc780000000
-
{e=>0,c=>-1,a=>-10,b=>0,d=>1,f=>0}
f6ffffff06000000
f6ffffffffffffff0600000000000000
f6ffffffffffffff0600000000000000
fffffff660000000
f6ffffff06000000
f6ffffff06000000
fffffffffffffff66000000000000000
f6ffffff06000000
fffffff660000000
-
{e=>0,c=>-1,a=>52,b=>0,d=>0,f=>1}
3400000012000000
34000000000000001200000000000000
34000000000000001200000000000000
0000003448000000
3400000012000000
3400000012000000
00000000000000344800000000000000
3400000012000000
0000003448000000
-
{e=>-1,c=>0,a=>127,b=>0,d=>0,f=>0}
7f00000008000000
7f000000000000000800000000000000
7f000000000000000800000000000000
0000007f10000000
7f00000008000000
7f00000008000000
000000000000007f1000000000000000
7f00000008000000
0000007f10000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
};
-
{e=>0,c=>-1,a=>-7,g=>0,b=>0,d=>0,f=>1}
f9ffffff12000000
f9ffffffffffffff1200000000000000
f9ffffffffffffff1200000000000000
fffffff948000000
f9ffffff12000000
f9ffffff12000000
fffffffffffffff94800000000000000
f9ffffff12000000
fffffff948000000
-
{e=>0,c=>0,a=>18,g=>-1,b=>1,d=>0,f=>1}
1200000031000000
12000000000000003100000000000000
12000000000000003100000000000000
000000128c000000
1200000031000000
1200000031000000
00000000000000128c00000000000000
1200000031000000
000000128c000000
-
{e=>-1,c=>-1,a=>84,g=>0,b=>0,d=>1,f=>1}
540000001e000000
54000000000000001e00000000000000
54000000000000001e00000000000000
0000005478000000
540000001e000000
540000001e000000
00000000000000547800000000000000
540000001e000000
0000005478000000
-
{e=>0,c=>-1,a=>21,g=>0,b=>0,d=>1,f=>0}
1500000006000000
15000000000000000600000000000000
15000000000000000600000000000000
0000001560000000
1500000006000000
1500000006000000
00000000000000156000000000000000
1500000006000000
0000001560000000
-
{e=>-1,c=>-1,a=>-2,g=>-1,b=>1,d=>0,f=>1}
feffffff3b000000
feffffffffffffff3b00000000000000
feffffffffffffff3b00000000000000
fffffffedc000000
feffffff3b000000
feffffff3b000000
fffffffffffffffedc00000000000000
feffffff3b000000
fffffffedc000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
};
-
{e=>-1,a=>11,d=>0,c=>0,h=>1,b=>1,g=>0,f=>1}
0b00000059000000
0b000000000000005900000000000000
0b000000000000005900000000000000
0000000b9a000000
0b00000059000000
0b00000059000000
000000000000000b9a00000000000000
0b00000059000000
0000000b9a000000
-
{e=>0,a=>-17,d=>0,c=>0,h=>1,b=>0,g=>0,f=>0}
efffffff40000000
efffffffffffffff4000000000000000
efffffffffffffff4000000000000000
ffffffef02000000
efffffff40000000
efffffff40000000
ffffffffffffffef0200000000000000
efffffff40000000
ffffffef02000000
-
{e=>-1,a=>2,d=>1,c=>-1,h=>0,b=>1,g=>0,f=>0}
020000000f000000
02000000000000000f00000000000000
02000000000000000f00000000000000
00000002f0000000
020000000f000000
020000000f000000
0000000000000002f000000000000000
020000000f000000
00000002f0000000
-
{e=>0,a=>6,d=>1,c=>-1,h=>0,b=>1,g=>-1,f=>1}
0600000037000000
06000000000000003700000000000000
06000000000000003700000000000000
00000006ec000000
0600000037000000
0600000037000000
0000000000000006ec00000000000000
0600000037000000
00000006ec000000
-
{e=>0,a=>103,d=>0,c=>0,h=>0,b=>1,g=>-1,f=>0}
6700000021000000
67000000000000002100000000000000
67000000000000002100000000000000
0000006784000000
6700000021000000
6700000021000000
00000000000000678400000000000000
6700000021000000
0000006784000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
};
-
{e=>-1,a=>-66,d=>0,c=>0,h=>0,b=>1,g=>0,f=>1,i=>-1}
beffffff99000000
beffffffffffffff9900000000000000
beffffffffffffff9900000000000000
ffffffbe99000000
beffffff99000000
beffffff99000000
ffffffffffffffbe9900000000000000
beffffff99000000
ffffffbe99000000
-
{e=>0,a=>-106,d=>0,c=>0,h=>1,b=>0,g=>-1,f=>0,i=>0}
96ffffff60000000
96ffffffffffffff6000000000000000
96ffffffffffffff6000000000000000
ffffff9606000000
96ffffff60000000
96ffffff60000000
ffffffffffffff960600000000000000
96ffffff60000000
ffffff9606000000
-
{e=>-1,a=>-86,d=>0,c=>0,h=>0,b=>1,g=>0,f=>0,i=>0}
aaffffff09000000
aaffffffffffffff0900000000000000
aaffffffffffffff0900000000000000
ffffffaa90000000
aaffffff09000000
aaffffff09000000
ffffffffffffffaa9000000000000000
aaffffff09000000
ffffffaa90000000
-
{e=>-1,a=>-98,d=>0,c=>0,h=>0,b=>0,g=>0,f=>1,i=>0}
9effffff18000000
9effffffffffffff1800000000000000
9effffffffffffff1800000000000000
ffffff9e18000000
9effffff18000000
9effffff18000000
ffffffffffffff9e1800000000000000
9effffff18000000
ffffff9e18000000
-
{e=>0,a=>40,d=>0,c=>0,h=>1,b=>1,g=>0,f=>1,i=>0}
2800000051000000
28000000000000005100000000000000
28000000000000005100000000000000
000000288a000000
2800000051000000
2800000051000000
00000000000000288a00000000000000
2800000051000000
000000288a000000
=
struct mixed {
  long a;
  unsigned char  b:1;
  signed   char  c:1;
  unsigned short d:1;
  signed   short e:1;
  unsigned int   f:1;
  signed   int   g:1;
  unsigned long  h:1;
  signed   long  i:1;
  unsigned char  j;
};
-
{e=>-1,a=>-49,d=>1,j=>205,c=>0,h=>0,b=>1,g=>0,f=>1,i=>-1}
cfffffff9dcd0000
cfffffffffffffff9dcd000000000000
cfffffffffffffff9dcd000000000000
ffffffcfb9cd0000
cfffffff9dcd0000
cfffffff9dcd0000
ffffffffffffffcfb9cd000000000000
cfffffff9dcd0000
ffffffcfb9cd0000
-
{e=>-1,a=>126,d=>0,j=>0,c=>-1,h=>1,b=>1,g=>-1,f=>0,i=>0}
7e0000006b000000
7e000000000000006b00000000000000
7e000000000000006b00000000000000
0000007ed6000000
7e0000006b000000
7e0000006b000000
000000000000007ed600000000000000
7e0000006b000000
0000007ed6000000
-
{e=>0,a=>-31,d=>0,j=>105,c=>-1,h=>0,b=>1,g=>0,f=>0,i=>-1}
e1ffffff83690000
e1ffffffffffffff8369000000000000
e1ffffffffffffff8369000000000000
ffffffe1c1690000
e1ffffff83690000
e1ffffff83690000
ffffffffffffffe1c169000000000000
e1ffffff83690000
ffffffe1c1690000
-
{e=>-1,a=>-1,d=>1,j=>21,c=>-1,h=>0,b=>1,g=>-1,f=>0,i=>0}
ffffffff2f150000
ffffffffffffffff2f15000000000000
ffffffffffffffff2f15000000000000
fffffffff4150000
ffffffff2f150000
ffffffff2f150000
fffffffffffffffff415000000000000
ffffffff2f150000
fffffffff4150000
-
{e=>-1,a=>99,d=>0,j=>132,c=>0,h=>0,b=>0,g=>0,f=>1,i=>0}
6300000018840000
63000000000000001884000000000000
63000000000000001884000000000000
0000006318840000
6300000018840000
6300000018840000
00000000000000631884000000000000
6300000018840000
0000006318840000
=
struct force_align1 {
  unsigned char a:1;
};
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
-
{a=>1}
01
01
01
80
01000000
01
80
01
80
=
struct force_align1 {
  unsigned char a:1;
  unsigned char b:1;
};
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>0,b=>1}
02
02
02
40
02000000
02
40
02
40
-
{a=>0,b=>1}
02
02
02
40
02000000
02
40
02
40
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
=
struct force_align1 {
  unsigned char a:1;
  unsigned char b:1;
  unsigned char  :0;
};
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0,b=>1}
02
02
02
40
02000000
02
40
02
40
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1,b=>1}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>1,b=>0}
01
01
01
80
01000000
01
80
01
80
=
struct force_align1 {
  unsigned char a:1;
  unsigned char b:1;
  unsigned char  :0;
  unsigned char c:1;
};
-
{c=>1,a=>1,b=>0}
0101
0101
0101
8080
01010000
0101
8080
0101
8080
-
{c=>1,a=>1,b=>1}
0301
0301
0301
c080
03010000
0301
c080
0301
c080
-
{c=>0,a=>1,b=>1}
0300
0300
0300
c000
03000000
0300
c000
0300
c000
-
{c=>0,a=>0,b=>0}
0000
0000
0000
0000
00000000
0000
0000
0000
0000
-
{c=>0,a=>1,b=>0}
0100
0100
0100
8000
01000000
0100
8000
0100
8000
=
struct force_align1 {
  unsigned char a:1;
  unsigned char b:1;
  unsigned char  :0;
  unsigned char c:1;
  unsigned int  d;
};
-
{c=>0,a=>0,b=>1,d=>114}
0200000072000000
0200000072000000
0200000072000000
4000000000000072
0200000072000000
0200000072000000
4000000000000072
0200000072000000
4000000000000072
-
{c=>0,a=>1,b=>0,d=>177}
01000000b1000000
01000000b1000000
01000000b1000000
80000000000000b1
01000000b1000000
01000000b1000000
80000000000000b1
01000000b1000000
80000000000000b1
-
{c=>1,a=>1,b=>1,d=>163}
03010000a3000000
03010000a3000000
03010000a3000000
c0800000000000a3
03010000a3000000
03010000a3000000
c0800000000000a3
03010000a3000000
c0800000000000a3
-
{c=>0,a=>0,b=>1,d=>180}
02000000b4000000
02000000b4000000
02000000b4000000
40000000000000b4
02000000b4000000
02000000b4000000
40000000000000b4
02000000b4000000
40000000000000b4
-
{c=>0,a=>1,b=>0,d=>131}
0100000083000000
0100000083000000
0100000083000000
8000000000000083
0100000083000000
0100000083000000
8000000000000083
0100000083000000
8000000000000083
=
struct force_align1 {
  char a;
  unsigned char b:1;
};
-
{a=>105,b=>1}
6901
6901
6901
6980
69010000
6901
6980
6901
6980
-
{a=>-17,b=>1}
ef01
ef01
ef01
ef80
ef010000
ef01
ef80
ef01
ef80
-
{a=>-128,b=>1}
8001
8001
8001
8080
80010000
8001
8080
8001
8080
-
{a=>35,b=>0}
2300
2300
2300
2300
23000000
2300
2300
2300
2300
-
{a=>-120,b=>0}
8800
8800
8800
8800
88000000
8800
8800
8800
8800
=
struct force_align1 {
  char a;
  unsigned char b:1;
  unsigned char c:1;
};
-
{c=>0,a=>87,b=>0}
5700
5700
5700
5700
57000000
5700
5700
5700
5700
-
{c=>0,a=>12,b=>1}
0c01
0c01
0c01
0c80
0c010000
0c01
0c80
0c01
0c80
-
{c=>0,a=>107,b=>0}
6b00
6b00
6b00
6b00
6b000000
6b00
6b00
6b00
6b00
-
{c=>1,a=>-100,b=>0}
9c02
9c02
9c02
9c40
9c020000
9c02
9c40
9c02
9c40
-
{c=>1,a=>-61,b=>0}
c302
c302
c302
c340
c3020000
c302
c340
c302
c340
=
struct force_align1 {
  char a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
};
-
{c=>0,a=>-59,b=>0}
c500
c500
c500
c500
c5000000
c500
c500
c500
c500
-
{c=>0,a=>-128,b=>0}
8000
8000
8000
8000
80000000
8000
8000
8000
8000
-
{c=>0,a=>-43,b=>1}
d501
d501
d501
d580
d5010000
d501
d580
d501
d580
-
{c=>0,a=>55,b=>0}
3700
3700
3700
3700
37000000
3700
3700
3700
3700
-
{c=>0,a=>-27,b=>1}
e501
e501
e501
e580
e5010000
e501
e580
e501
e580
=
struct force_align1 {
  char a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
};
-
{c=>1,a=>-22,b=>1,d=>0}
ea0300
ea0300
ea0300
eac000
ea030000
ea0300
eac000
ea0300
eac000
-
{c=>1,a=>115,b=>1,d=>0}
730300
730300
730300
73c000
73030000
730300
73c000
730300
73c000
-
{c=>1,a=>-2,b=>0,d=>0}
fe0200
fe0200
fe0200
fe4000
fe020000
fe0200
fe4000
fe0200
fe4000
-
{c=>0,a=>-40,b=>1,d=>0}
d80100
d80100
d80100
d88000
d8010000
d80100
d88000
d80100
d88000
-
{c=>1,a=>52,b=>0,d=>0}
340200
340200
340200
344000
34020000
340200
344000
340200
344000
=
struct force_align1 {
  char a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
  unsigned int  e;
};
-
{e=>84,c=>0,a=>-2,b=>1,d=>1}
fe01010054000000
fe01010054000000
fe01010054000000
fe80800000000054
fe01010054000000
fe01010054000000
fe80800000000054
fe01010054000000
fe80800000000054
-
{e=>26,c=>1,a=>-22,b=>0,d=>1}
ea0201001a000000
ea0201001a000000
ea0201001a000000
ea4080000000001a
ea0201001a000000
ea0201001a000000
ea4080000000001a
ea0201001a000000
ea4080000000001a
-
{e=>229,c=>0,a=>-4,b=>1,d=>0}
fc010000e5000000
fc010000e5000000
fc010000e5000000
fc800000000000e5
fc010000e5000000
fc010000e5000000
fc800000000000e5
fc010000e5000000
fc800000000000e5
-
{e=>140,c=>0,a=>-121,b=>0,d=>1}
870001008c000000
870001008c000000
870001008c000000
870080000000008c
870001008c000000
870001008c000000
870080000000008c
870001008c000000
870080000000008c
-
{e=>135,c=>0,a=>23,b=>0,d=>0}
1700000087000000
1700000087000000
1700000087000000
1700000000000087
1700000087000000
1700000087000000
1700000000000087
1700000087000000
1700000000000087
=
struct force_align1 {
  short a;
  unsigned char b:1;
};
-
{a=>108,b=>1}
6c000100
6c000100
6c000100
006c8000
6c000100
6c000100
006c8000
6c000100
006c8000
-
{a=>-114,b=>0}
8eff0000
8eff0000
8eff0000
ff8e0000
8eff0000
8eff0000
ff8e0000
8eff0000
ff8e0000
-
{a=>64,b=>1}
40000100
40000100
40000100
00408000
40000100
40000100
00408000
40000100
00408000
-
{a=>19,b=>1}
13000100
13000100
13000100
00138000
13000100
13000100
00138000
13000100
00138000
-
{a=>-123,b=>0}
85ff0000
85ff0000
85ff0000
ff850000
85ff0000
85ff0000
ff850000
85ff0000
ff850000
=
struct force_align1 {
  short a;
  unsigned char b:1;
  unsigned char c:1;
};
-
{c=>0,a=>-11,b=>1}
f5ff0100
f5ff0100
f5ff0100
fff58000
f5ff0100
f5ff0100
fff58000
f5ff0100
fff58000
-
{c=>1,a=>90,b=>0}
5a000200
5a000200
5a000200
005a4000
5a000200
5a000200
005a4000
5a000200
005a4000
-
{c=>0,a=>107,b=>0}
6b000000
6b000000
6b000000
006b0000
6b000000
6b000000
006b0000
6b000000
006b0000
-
{c=>0,a=>-75,b=>1}
b5ff0100
b5ff0100
b5ff0100
ffb58000
b5ff0100
b5ff0100
ffb58000
b5ff0100
ffb58000
-
{c=>1,a=>-80,b=>0}
b0ff0200
b0ff0200
b0ff0200
ffb04000
b0ff0200
b0ff0200
ffb04000
b0ff0200
ffb04000
=
struct force_align1 {
  short a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
};
-
{c=>1,a=>105,b=>1}
69000300
69000300
69000300
0069c000
69000300
69000300
0069c000
69000300
0069c000
-
{c=>0,a=>49,b=>1}
31000100
31000100
31000100
00318000
31000100
31000100
00318000
31000100
00318000
-
{c=>1,a=>37,b=>0}
25000200
25000200
25000200
00254000
25000200
25000200
00254000
25000200
00254000
-
{c=>0,a=>-82,b=>0}
aeff0000
aeff0000
aeff0000
ffae0000
aeff0000
aeff0000
ffae0000
aeff0000
ffae0000
-
{c=>1,a=>-88,b=>1}
a8ff0300
a8ff0300
a8ff0300
ffa8c000
a8ff0300
a8ff0300
ffa8c000
a8ff0300
ffa8c000
=
struct force_align1 {
  short a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
};
-
{c=>0,a=>-121,b=>1,d=>0}
87ff0100
87ff0100
87ff0100
ff878000
87ff0100
87ff0100
ff878000
87ff0100
ff878000
-
{c=>1,a=>80,b=>0,d=>1}
50000201
50000201
50000201
00504080
50000201
50000201
00504080
50000201
00504080
-
{c=>0,a=>-79,b=>1,d=>1}
b1ff0101
b1ff0101
b1ff0101
ffb18080
b1ff0101
b1ff0101
ffb18080
b1ff0101
ffb18080
-
{c=>0,a=>106,b=>1,d=>0}
6a000100
6a000100
6a000100
006a8000
6a000100
6a000100
006a8000
6a000100
006a8000
-
{c=>1,a=>113,b=>0,d=>1}
71000201
71000201
71000201
00714080
71000201
71000201
00714080
71000201
00714080
=
struct force_align1 {
  short a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
  unsigned int  e;
};
-
{e=>56,c=>0,a=>80,b=>0,d=>0}
5000000038000000
5000000038000000
5000000038000000
0050000000000038
5000000038000000
5000000038000000
0050000000000038
5000000038000000
0050000000000038
-
{e=>189,c=>1,a=>6,b=>1,d=>1}
06000301bd000000
06000301bd000000
06000301bd000000
0006c080000000bd
06000301bd000000
06000301bd000000
0006c080000000bd
06000301bd000000
0006c080000000bd
-
{e=>198,c=>1,a=>-106,b=>0,d=>0}
96ff0200c6000000
96ff0200c6000000
96ff0200c6000000
ff964000000000c6
96ff0200c6000000
96ff0200c6000000
ff964000000000c6
96ff0200c6000000
ff964000000000c6
-
{e=>167,c=>1,a=>-17,b=>1,d=>0}
efff0300a7000000
efff0300a7000000
efff0300a7000000
ffefc000000000a7
efff0300a7000000
efff0300a7000000
ffefc000000000a7
efff0300a7000000
ffefc000000000a7
-
{e=>89,c=>0,a=>-78,b=>1,d=>0}
b2ff010059000000
b2ff010059000000
b2ff010059000000
ffb2800000000059
b2ff010059000000
b2ff010059000000
ffb2800000000059
b2ff010059000000
ffb2800000000059
=
struct force_align1 {
  int a;
  unsigned char b:1;
};
-
{a=>19,b=>1}
1300000001000000
1300000001000000
1300000001000000
0000001380000000
1300000001000000
1300000001000000
0000001380000000
1300000001000000
0000001380000000
-
{a=>79,b=>0}
4f00000000000000
4f00000000000000
4f00000000000000
0000004f00000000
4f00000000000000
4f00000000000000
0000004f00000000
4f00000000000000
0000004f00000000
-
{a=>-101,b=>1}
9bffffff01000000
9bffffff01000000
9bffffff01000000
ffffff9b80000000
9bffffff01000000
9bffffff01000000
ffffff9b80000000
9bffffff01000000
ffffff9b80000000
-
{a=>11,b=>1}
0b00000001000000
0b00000001000000
0b00000001000000
0000000b80000000
0b00000001000000
0b00000001000000
0000000b80000000
0b00000001000000
0000000b80000000
-
{a=>79,b=>0}
4f00000000000000
4f00000000000000
4f00000000000000
0000004f00000000
4f00000000000000
4f00000000000000
0000004f00000000
4f00000000000000
0000004f00000000
=
struct force_align1 {
  int a;
  unsigned char b:1;
  unsigned char c:1;
};
-
{c=>1,a=>-25,b=>0}
e7ffffff02000000
e7ffffff02000000
e7ffffff02000000
ffffffe740000000
e7ffffff02000000
e7ffffff02000000
ffffffe740000000
e7ffffff02000000
ffffffe740000000
-
{c=>1,a=>-98,b=>0}
9effffff02000000
9effffff02000000
9effffff02000000
ffffff9e40000000
9effffff02000000
9effffff02000000
ffffff9e40000000
9effffff02000000
ffffff9e40000000
-
{c=>0,a=>-118,b=>0}
8affffff00000000
8affffff00000000
8affffff00000000
ffffff8a00000000
8affffff00000000
8affffff00000000
ffffff8a00000000
8affffff00000000
ffffff8a00000000
-
{c=>1,a=>-46,b=>1}
d2ffffff03000000
d2ffffff03000000
d2ffffff03000000
ffffffd2c0000000
d2ffffff03000000
d2ffffff03000000
ffffffd2c0000000
d2ffffff03000000
ffffffd2c0000000
-
{c=>0,a=>92,b=>0}
5c00000000000000
5c00000000000000
5c00000000000000
0000005c00000000
5c00000000000000
5c00000000000000
0000005c00000000
5c00000000000000
0000005c00000000
=
struct force_align1 {
  int a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
};
-
{c=>0,a=>27,b=>1}
1b00000001000000
1b00000001000000
1b00000001000000
0000001b80000000
1b00000001000000
1b00000001000000
0000001b80000000
1b00000001000000
0000001b80000000
-
{c=>1,a=>71,b=>1}
4700000003000000
4700000003000000
4700000003000000
00000047c0000000
4700000003000000
4700000003000000
00000047c0000000
4700000003000000
00000047c0000000
-
{c=>0,a=>53,b=>0}
3500000000000000
3500000000000000
3500000000000000
0000003500000000
3500000000000000
3500000000000000
0000003500000000
3500000000000000
0000003500000000
-
{c=>0,a=>-126,b=>1}
82ffffff01000000
82ffffff01000000
82ffffff01000000
ffffff8280000000
82ffffff01000000
82ffffff01000000
ffffff8280000000
82ffffff01000000
ffffff8280000000
-
{c=>0,a=>-59,b=>1}
c5ffffff01000000
c5ffffff01000000
c5ffffff01000000
ffffffc580000000
c5ffffff01000000
c5ffffff01000000
ffffffc580000000
c5ffffff01000000
ffffffc580000000
=
struct force_align1 {
  int a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
};
-
{c=>1,a=>49,b=>1,d=>0}
3100000003000000
3100000003000000
3100000003000000
00000031c0000000
3100000003000000
3100000003000000
00000031c0000000
3100000003000000
00000031c0000000
-
{c=>1,a=>-97,b=>0,d=>0}
9fffffff02000000
9fffffff02000000
9fffffff02000000
ffffff9f40000000
9fffffff02000000
9fffffff02000000
ffffff9f40000000
9fffffff02000000
ffffff9f40000000
-
{c=>1,a=>114,b=>1,d=>1}
7200000003010000
7200000003010000
7200000003010000
00000072c0800000
7200000003010000
7200000003010000
00000072c0800000
7200000003010000
00000072c0800000
-
{c=>0,a=>-38,b=>1,d=>0}
daffffff01000000
daffffff01000000
daffffff01000000
ffffffda80000000
daffffff01000000
daffffff01000000
ffffffda80000000
daffffff01000000
ffffffda80000000
-
{c=>0,a=>-74,b=>0,d=>0}
b6ffffff00000000
b6ffffff00000000
b6ffffff00000000
ffffffb600000000
b6ffffff00000000
b6ffffff00000000
ffffffb600000000
b6ffffff00000000
ffffffb600000000
=
struct force_align1 {
  int a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
  unsigned int  e;
};
-
{e=>174,c=>0,a=>102,b=>0,d=>1}
6600000000010000ae000000
6600000000010000ae000000
6600000000010000ae000000
0000006600800000000000ae
6600000000010000ae000000
6600000000010000ae000000
0000006600800000000000ae
6600000000010000ae000000
0000006600800000000000ae
-
{e=>77,c=>1,a=>85,b=>0,d=>0}
55000000020000004d000000
55000000020000004d000000
55000000020000004d000000
00000055400000000000004d
55000000020000004d000000
55000000020000004d000000
00000055400000000000004d
55000000020000004d000000
00000055400000000000004d
-
{e=>97,c=>1,a=>-95,b=>0,d=>1}
a1ffffff0201000061000000
a1ffffff0201000061000000
a1ffffff0201000061000000
ffffffa14080000000000061
a1ffffff0201000061000000
a1ffffff0201000061000000
ffffffa14080000000000061
a1ffffff0201000061000000
ffffffa14080000000000061
-
{e=>21,c=>1,a=>-30,b=>0,d=>1}
e2ffffff0201000015000000
e2ffffff0201000015000000
e2ffffff0201000015000000
ffffffe24080000000000015
e2ffffff0201000015000000
e2ffffff0201000015000000
ffffffe24080000000000015
e2ffffff0201000015000000
ffffffe24080000000000015
-
{e=>169,c=>0,a=>-9,b=>1,d=>0}
f7ffffff01000000a9000000
f7ffffff01000000a9000000
f7ffffff01000000a9000000
fffffff780000000000000a9
f7ffffff01000000a9000000
f7ffffff01000000a9000000
fffffff780000000000000a9
f7ffffff01000000a9000000
fffffff780000000000000a9
=
struct force_align1 {
  long a;
  unsigned char b:1;
};
-
{a=>67,b=>0}
4300000000000000
43000000000000000000000000000000
43000000000000000000000000000000
0000004300000000
4300000000000000
4300000000000000
00000000000000430000000000000000
4300000000000000
0000004300000000
-
{a=>122,b=>0}
7a00000000000000
7a000000000000000000000000000000
7a000000000000000000000000000000
0000007a00000000
7a00000000000000
7a00000000000000
000000000000007a0000000000000000
7a00000000000000
0000007a00000000
-
{a=>104,b=>0}
6800000000000000
68000000000000000000000000000000
68000000000000000000000000000000
0000006800000000
6800000000000000
6800000000000000
00000000000000680000000000000000
6800000000000000
0000006800000000
-
{a=>-99,b=>0}
9dffffff00000000
9dffffffffffffff0000000000000000
9dffffffffffffff0000000000000000
ffffff9d00000000
9dffffff00000000
9dffffff00000000
ffffffffffffff9d0000000000000000
9dffffff00000000
ffffff9d00000000
-
{a=>-11,b=>1}
f5ffffff01000000
f5ffffffffffffff0100000000000000
f5ffffffffffffff0100000000000000
fffffff580000000
f5ffffff01000000
f5ffffff01000000
fffffffffffffff58000000000000000
f5ffffff01000000
fffffff580000000
=
struct force_align1 {
  long a;
  unsigned char b:1;
  unsigned char c:1;
};
-
{c=>1,a=>-95,b=>0}
a1ffffff02000000
a1ffffffffffffff0200000000000000
a1ffffffffffffff0200000000000000
ffffffa140000000
a1ffffff02000000
a1ffffff02000000
ffffffffffffffa14000000000000000
a1ffffff02000000
ffffffa140000000
-
{c=>0,a=>74,b=>1}
4a00000001000000
4a000000000000000100000000000000
4a000000000000000100000000000000
0000004a80000000
4a00000001000000
4a00000001000000
000000000000004a8000000000000000
4a00000001000000
0000004a80000000
-
{c=>0,a=>31,b=>1}
1f00000001000000
1f000000000000000100000000000000
1f000000000000000100000000000000
0000001f80000000
1f00000001000000
1f00000001000000
000000000000001f8000000000000000
1f00000001000000
0000001f80000000
-
{c=>0,a=>-31,b=>1}
e1ffffff01000000
e1ffffffffffffff0100000000000000
e1ffffffffffffff0100000000000000
ffffffe180000000
e1ffffff01000000
e1ffffff01000000
ffffffffffffffe18000000000000000
e1ffffff01000000
ffffffe180000000
-
{c=>0,a=>47,b=>1}
2f00000001000000
2f000000000000000100000000000000
2f000000000000000100000000000000
0000002f80000000
2f00000001000000
2f00000001000000
000000000000002f8000000000000000
2f00000001000000
0000002f80000000
=
struct force_align1 {
  long a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
};
-
{c=>1,a=>-52,b=>0}
ccffffff02000000
ccffffffffffffff0200000000000000
ccffffffffffffff0200000000000000
ffffffcc40000000
ccffffff02000000
ccffffff02000000
ffffffffffffffcc4000000000000000
ccffffff02000000
ffffffcc40000000
-
{c=>1,a=>9,b=>0}
0900000002000000
09000000000000000200000000000000
09000000000000000200000000000000
0000000940000000
0900000002000000
0900000002000000
00000000000000094000000000000000
0900000002000000
0000000940000000
-
{c=>1,a=>9,b=>1}
0900000003000000
09000000000000000300000000000000
09000000000000000300000000000000
00000009c0000000
0900000003000000
0900000003000000
0000000000000009c000000000000000
0900000003000000
00000009c0000000
-
{c=>1,a=>32,b=>1}
2000000003000000
20000000000000000300000000000000
20000000000000000300000000000000
00000020c0000000
2000000003000000
2000000003000000
0000000000000020c000000000000000
2000000003000000
00000020c0000000
-
{c=>1,a=>-30,b=>0}
e2ffffff02000000
e2ffffffffffffff0200000000000000
e2ffffffffffffff0200000000000000
ffffffe240000000
e2ffffff02000000
e2ffffff02000000
ffffffffffffffe24000000000000000
e2ffffff02000000
ffffffe240000000
=
struct force_align1 {
  long a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
};
-
{c=>1,a=>-45,b=>1,d=>0}
d3ffffff03000000
d3ffffffffffffff0300000000000000
d3ffffffffffffff0300000000000000
ffffffd3c0000000
d3ffffff03000000
d3ffffff03000000
ffffffffffffffd3c000000000000000
d3ffffff03000000
ffffffd3c0000000
-
{c=>0,a=>44,b=>0,d=>0}
2c00000000000000
2c000000000000000000000000000000
2c000000000000000000000000000000
0000002c00000000
2c00000000000000
2c00000000000000
000000000000002c0000000000000000
2c00000000000000
0000002c00000000
-
{c=>1,a=>88,b=>1,d=>1}
5800000003010000
58000000000000000301000000000000
58000000000000000301000000000000
00000058c0800000
5800000003010000
5800000003010000
0000000000000058c080000000000000
5800000003010000
00000058c0800000
-
{c=>1,a=>99,b=>0,d=>0}
6300000002000000
63000000000000000200000000000000
63000000000000000200000000000000
0000006340000000
6300000002000000
6300000002000000
00000000000000634000000000000000
6300000002000000
0000006340000000
-
{c=>1,a=>94,b=>1,d=>0}
5e00000003000000
5e000000000000000300000000000000
5e000000000000000300000000000000
0000005ec0000000
5e00000003000000
5e00000003000000
000000000000005ec000000000000000
5e00000003000000
0000005ec0000000
=
struct force_align1 {
  long a;
  unsigned char b:1;
  unsigned char c:1;
  unsigned char  :0;
  unsigned char d:1;
  unsigned int  e;
};
-
{e=>84,c=>1,a=>-57,b=>0,d=>1}
c7ffffff0201000054000000
c7ffffffffffffff0201000054000000
c7ffffffffffffff0201000054000000
ffffffc74080000000000054
c7ffffff0201000054000000
c7ffffff0201000054000000
ffffffffffffffc74080000000000054
c7ffffff0201000054000000
ffffffc74080000000000054
-
{e=>202,c=>0,a=>-67,b=>0,d=>1}
bdffffff00010000ca000000
bdffffffffffffff00010000ca000000
bdffffffffffffff00010000ca000000
ffffffbd00800000000000ca
bdffffff00010000ca000000
bdffffff00010000ca000000
ffffffffffffffbd00800000000000ca
bdffffff00010000ca000000
ffffffbd00800000000000ca
-
{e=>108,c=>0,a=>108,b=>1,d=>0}
6c000000010000006c000000
6c00000000000000010000006c000000
6c00000000000000010000006c000000
0000006c800000000000006c
6c000000010000006c000000
6c000000010000006c000000
000000000000006c800000000000006c
6c000000010000006c000000
0000006c800000000000006c
-
{e=>5,c=>0,a=>51,b=>1,d=>0}
330000000100000005000000
33000000000000000100000005000000
33000000000000000100000005000000
000000338000000000000005
330000000100000005000000
330000000100000005000000
00000000000000338000000000000005
330000000100000005000000
000000338000000000000005
-
{e=>228,c=>0,a=>-15,b=>0,d=>0}
f1ffffff00000000e4000000
f1ffffffffffffff00000000e4000000
f1ffffffffffffff00000000e4000000
fffffff100000000000000e4
f1ffffff00000000e4000000
f1ffffff00000000e4000000
fffffffffffffff100000000000000e4
f1ffffff00000000e4000000
fffffff100000000000000e4
=
struct force_align2 {
  unsigned char  a:2;
};
-
{a=>2}
02
02
02
80
02000000
02
80
02
80
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>3}
03
03
03
c0
03000000
03
c0
03
c0
-
{a=>3}
03
03
03
c0
03000000
03
c0
03
c0
=
struct force_align2 {
  unsigned char  a:2;
  unsigned char  b:2;
};
-
{a=>0,b=>3}
0c
0c
0c
30
0c000000
0c
30
0c
30
-
{a=>0,b=>1}
04
04
04
10
04000000
04
10
04
10
-
{a=>2,b=>3}
0e
0e
0e
b0
0e000000
0e
b0
0e
b0
-
{a=>2,b=>1}
06
06
06
90
06000000
06
90
06
90
-
{a=>3,b=>3}
0f
0f
0f
f0
0f000000
0f
f0
0f
f0
=
struct force_align2 {
  unsigned char  a:2;
  unsigned char  b:2;
  unsigned char   :0;
};
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>0,b=>1}
04
04
04
10
04000000
04
10
04
10
-
{a=>1,b=>3}
0d
0d
0d
70
0d000000
0d
70
0d
70
-
{a=>2,b=>0}
02
02
02
80
02000000
02
80
02
80
-
{a=>0,b=>2}
08
08
08
20
08000000
08
20
08
20
=
struct force_align2 {
  unsigned char  a:2;
  unsigned char  b:2;
  unsigned char   :0;
  unsigned char  c:2;
};
-
{c=>1,a=>1,b=>3}
0d01
0d01
0d01
7040
0d010000
0d01
7040
0d01
7040
-
{c=>2,a=>2,b=>1}
0602
0602
0602
9080
06020000
0602
9080
0602
9080
-
{c=>1,a=>2,b=>0}
0201
0201
0201
8040
02010000
0201
8040
0201
8040
-
{c=>2,a=>3,b=>3}
0f02
0f02
0f02
f080
0f020000
0f02
f080
0f02
f080
-
{c=>0,a=>1,b=>3}
0d00
0d00
0d00
7000
0d000000
0d00
7000
0d00
7000
=
struct force_align2 {
  unsigned char  a:2;
  unsigned char  b:2;
  unsigned char   :0;
  unsigned char  c:2;
  unsigned short d;
};
-
{c=>0,a=>1,b=>0,d=>112}
01007000
01007000
01007000
40000070
01007000
01007000
40000070
01007000
40000070
-
{c=>0,a=>3,b=>3,d=>128}
0f008000
0f008000
0f008000
f0000080
0f008000
0f008000
f0000080
0f008000
f0000080
-
{c=>1,a=>2,b=>0,d=>190}
0201be00
0201be00
0201be00
804000be
0201be00
0201be00
804000be
0201be00
804000be
-
{c=>0,a=>3,b=>2,d=>63}
0b003f00
0b003f00
0b003f00
e000003f
0b003f00
0b003f00
e000003f
0b003f00
e000003f
-
{c=>2,a=>2,b=>2,d=>241}
0a02f100
0a02f100
0a02f100
a08000f1
0a02f100
0a02f100
a08000f1
0a02f100
a08000f1
=
struct force_align2 {
  char a;
  unsigned char  b:2;
};
-
{a=>74,b=>1}
4a01
4a01
4a01
4a40
4a010000
4a01
4a40
4a01
4a40
-
{a=>-7,b=>1}
f901
f901
f901
f940
f9010000
f901
f940
f901
f940
-
{a=>102,b=>1}
6601
6601
6601
6640
66010000
6601
6640
6601
6640
-
{a=>10,b=>3}
0a03
0a03
0a03
0ac0
0a030000
0a03
0ac0
0a03
0ac0
-
{a=>-7,b=>2}
f902
f902
f902
f980
f9020000
f902
f980
f902
f980
=
struct force_align2 {
  char a;
  unsigned char  b:2;
  unsigned char  c:2;
};
-
{c=>3,a=>7,b=>1}
070d
070d
070d
0770
070d0000
070d
0770
070d
0770
-
{c=>3,a=>50,b=>0}
320c
320c
320c
3230
320c0000
320c
3230
320c
3230
-
{c=>2,a=>-125,b=>0}
8308
8308
8308
8320
83080000
8308
8320
8308
8320
-
{c=>2,a=>-32,b=>0}
e008
e008
e008
e020
e0080000
e008
e020
e008
e020
-
{c=>1,a=>68,b=>0}
4404
4404
4404
4410
44040000
4404
4410
4404
4410
=
struct force_align2 {
  char a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
};
-
{c=>2,a=>-127,b=>0}
8108
8108
8108
8120
81080000
8108
8120
8108
8120
-
{c=>1,a=>-27,b=>0}
e504
e504
e504
e510
e5040000
e504
e510
e504
e510
-
{c=>2,a=>30,b=>1}
1e09
1e09
1e09
1e60
1e090000
1e09
1e60
1e09
1e60
-
{c=>0,a=>-25,b=>1}
e701
e701
e701
e740
e7010000
e701
e740
e701
e740
-
{c=>2,a=>-15,b=>1}
f109
f109
f109
f160
f1090000
f109
f160
f109
f160
=
struct force_align2 {
  char a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
};
-
{c=>1,a=>75,b=>1,d=>2}
4b0502
4b0502
4b0502
4b5080
4b050200
4b0502
4b5080
4b0502
4b5080
-
{c=>1,a=>18,b=>1,d=>3}
120503
120503
120503
1250c0
12050300
120503
1250c0
120503
1250c0
-
{c=>2,a=>-39,b=>2,d=>0}
d90a00
d90a00
d90a00
d9a000
d90a0000
d90a00
d9a000
d90a00
d9a000
-
{c=>3,a=>-91,b=>2,d=>0}
a50e00
a50e00
a50e00
a5b000
a50e0000
a50e00
a5b000
a50e00
a5b000
-
{c=>1,a=>60,b=>1,d=>0}
3c0500
3c0500
3c0500
3c5000
3c050000
3c0500
3c5000
3c0500
3c5000
=
struct force_align2 {
  char a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
  unsigned short e;
};
-
{e=>11,c=>2,a=>39,b=>0,d=>2}
270802000b00
270802000b00
270802000b00
27208000000b
270802000b000000
270802000b00
27208000000b
270802000b00
27208000000b
-
{e=>219,c=>0,a=>42,b=>3,d=>1}
2a030100db00
2a030100db00
2a030100db00
2ac0400000db
2a030100db000000
2a030100db00
2ac0400000db
2a030100db00
2ac0400000db
-
{e=>154,c=>0,a=>-14,b=>1,d=>1}
f20101009a00
f20101009a00
f20101009a00
f2404000009a
f20101009a000000
f20101009a00
f2404000009a
f20101009a00
f2404000009a
-
{e=>86,c=>1,a=>20,b=>3,d=>1}
140701005600
140701005600
140701005600
14d040000056
1407010056000000
140701005600
14d040000056
140701005600
14d040000056
-
{e=>7,c=>0,a=>-109,b=>1,d=>1}
930101000700
930101000700
930101000700
934040000007
9301010007000000
930101000700
934040000007
930101000700
934040000007
=
struct force_align2 {
  short a;
  unsigned char  b:2;
};
-
{a=>-77,b=>0}
b3ff0000
b3ff0000
b3ff0000
ffb30000
b3ff0000
b3ff0000
ffb30000
b3ff0000
ffb30000
-
{a=>32,b=>1}
20000100
20000100
20000100
00204000
20000100
20000100
00204000
20000100
00204000
-
{a=>-116,b=>3}
8cff0300
8cff0300
8cff0300
ff8cc000
8cff0300
8cff0300
ff8cc000
8cff0300
ff8cc000
-
{a=>127,b=>2}
7f000200
7f000200
7f000200
007f8000
7f000200
7f000200
007f8000
7f000200
007f8000
-
{a=>47,b=>2}
2f000200
2f000200
2f000200
002f8000
2f000200
2f000200
002f8000
2f000200
002f8000
=
struct force_align2 {
  short a;
  unsigned char  b:2;
  unsigned char  c:2;
};
-
{c=>1,a=>-56,b=>2}
c8ff0600
c8ff0600
c8ff0600
ffc89000
c8ff0600
c8ff0600
ffc89000
c8ff0600
ffc89000
-
{c=>1,a=>96,b=>0}
60000400
60000400
60000400
00601000
60000400
60000400
00601000
60000400
00601000
-
{c=>1,a=>-89,b=>1}
a7ff0500
a7ff0500
a7ff0500
ffa75000
a7ff0500
a7ff0500
ffa75000
a7ff0500
ffa75000
-
{c=>1,a=>-121,b=>1}
87ff0500
87ff0500
87ff0500
ff875000
87ff0500
87ff0500
ff875000
87ff0500
ff875000
-
{c=>2,a=>80,b=>3}
50000b00
50000b00
50000b00
0050e000
50000b00
50000b00
0050e000
50000b00
0050e000
=
struct force_align2 {
  short a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
};
-
{c=>0,a=>-50,b=>1}
ceff0100
ceff0100
ceff0100
ffce4000
ceff0100
ceff0100
ffce4000
ceff0100
ffce4000
-
{c=>3,a=>26,b=>0}
1a000c00
1a000c00
1a000c00
001a3000
1a000c00
1a000c00
001a3000
1a000c00
001a3000
-
{c=>2,a=>-116,b=>2}
8cff0a00
8cff0a00
8cff0a00
ff8ca000
8cff0a00
8cff0a00
ff8ca000
8cff0a00
ff8ca000
-
{c=>3,a=>-72,b=>2}
b8ff0e00
b8ff0e00
b8ff0e00
ffb8b000
b8ff0e00
b8ff0e00
ffb8b000
b8ff0e00
ffb8b000
-
{c=>1,a=>87,b=>2}
57000600
57000600
57000600
00579000
57000600
57000600
00579000
57000600
00579000
=
struct force_align2 {
  short a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
};
-
{c=>0,a=>-94,b=>1,d=>3}
a2ff0103
a2ff0103
a2ff0103
ffa240c0
a2ff0103
a2ff0103
ffa240c0
a2ff0103
ffa240c0
-
{c=>0,a=>-117,b=>0,d=>1}
8bff0001
8bff0001
8bff0001
ff8b0040
8bff0001
8bff0001
ff8b0040
8bff0001
ff8b0040
-
{c=>2,a=>18,b=>2,d=>2}
12000a02
12000a02
12000a02
0012a080
12000a02
12000a02
0012a080
12000a02
0012a080
-
{c=>3,a=>-15,b=>0,d=>0}
f1ff0c00
f1ff0c00
f1ff0c00
fff13000
f1ff0c00
f1ff0c00
fff13000
f1ff0c00
fff13000
-
{c=>0,a=>-39,b=>2,d=>3}
d9ff0203
d9ff0203
d9ff0203
ffd980c0
d9ff0203
d9ff0203
ffd980c0
d9ff0203
ffd980c0
=
struct force_align2 {
  short a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
  unsigned short e;
};
-
{e=>213,c=>2,a=>98,b=>3,d=>0}
62000b00d500
62000b00d500
62000b00d500
0062e00000d5
62000b00d5000000
62000b00d500
0062e00000d5
62000b00d500
0062e00000d5
-
{e=>183,c=>3,a=>104,b=>2,d=>0}
68000e00b700
68000e00b700
68000e00b700
0068b00000b7
68000e00b7000000
68000e00b700
0068b00000b7
68000e00b700
0068b00000b7
-
{e=>152,c=>3,a=>68,b=>3,d=>1}
44000f019800
44000f019800
44000f019800
0044f0400098
44000f0198000000
44000f019800
0044f0400098
44000f019800
0044f0400098
-
{e=>117,c=>0,a=>83,b=>2,d=>1}
530002017500
530002017500
530002017500
005380400075
5300020175000000
530002017500
005380400075
530002017500
005380400075
-
{e=>183,c=>0,a=>-82,b=>3,d=>3}
aeff0303b700
aeff0303b700
aeff0303b700
ffaec0c000b7
aeff0303b7000000
aeff0303b700
ffaec0c000b7
aeff0303b700
ffaec0c000b7
=
struct force_align2 {
  int a;
  unsigned char  b:2;
};
-
{a=>-20,b=>3}
ecffffff03000000
ecffffff03000000
ecffffff03000000
ffffffecc0000000
ecffffff03000000
ecffffff03000000
ffffffecc0000000
ecffffff03000000
ffffffecc0000000
-
{a=>123,b=>1}
7b00000001000000
7b00000001000000
7b00000001000000
0000007b40000000
7b00000001000000
7b00000001000000
0000007b40000000
7b00000001000000
0000007b40000000
-
{a=>-106,b=>0}
96ffffff00000000
96ffffff00000000
96ffffff00000000
ffffff9600000000
96ffffff00000000
96ffffff00000000
ffffff9600000000
96ffffff00000000
ffffff9600000000
-
{a=>6,b=>3}
0600000003000000
0600000003000000
0600000003000000
00000006c0000000
0600000003000000
0600000003000000
00000006c0000000
0600000003000000
00000006c0000000
-
{a=>60,b=>0}
3c00000000000000
3c00000000000000
3c00000000000000
0000003c00000000
3c00000000000000
3c00000000000000
0000003c00000000
3c00000000000000
0000003c00000000
=
struct force_align2 {
  int a;
  unsigned char  b:2;
  unsigned char  c:2;
};
-
{c=>2,a=>55,b=>0}
3700000008000000
3700000008000000
3700000008000000
0000003720000000
3700000008000000
3700000008000000
0000003720000000
3700000008000000
0000003720000000
-
{c=>2,a=>-128,b=>3}
80ffffff0b000000
80ffffff0b000000
80ffffff0b000000
ffffff80e0000000
80ffffff0b000000
80ffffff0b000000
ffffff80e0000000
80ffffff0b000000
ffffff80e0000000
-
{c=>3,a=>-119,b=>3}
89ffffff0f000000
89ffffff0f000000
89ffffff0f000000
ffffff89f0000000
89ffffff0f000000
89ffffff0f000000
ffffff89f0000000
89ffffff0f000000
ffffff89f0000000
-
{c=>2,a=>46,b=>0}
2e00000008000000
2e00000008000000
2e00000008000000
0000002e20000000
2e00000008000000
2e00000008000000
0000002e20000000
2e00000008000000
0000002e20000000
-
{c=>2,a=>-13,b=>2}
f3ffffff0a000000
f3ffffff0a000000
f3ffffff0a000000
fffffff3a0000000
f3ffffff0a000000
f3ffffff0a000000
fffffff3a0000000
f3ffffff0a000000
fffffff3a0000000
=
struct force_align2 {
  int a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
};
-
{c=>3,a=>-72,b=>3}
b8ffffff0f000000
b8ffffff0f000000
b8ffffff0f000000
ffffffb8f0000000
b8ffffff0f000000
b8ffffff0f000000
ffffffb8f0000000
b8ffffff0f000000
ffffffb8f0000000
-
{c=>3,a=>31,b=>0}
1f0000000c000000
1f0000000c000000
1f0000000c000000
0000001f30000000
1f0000000c000000
1f0000000c000000
0000001f30000000
1f0000000c000000
0000001f30000000
-
{c=>0,a=>105,b=>1}
6900000001000000
6900000001000000
6900000001000000
0000006940000000
6900000001000000
6900000001000000
0000006940000000
6900000001000000
0000006940000000
-
{c=>2,a=>74,b=>1}
4a00000009000000
4a00000009000000
4a00000009000000
0000004a60000000
4a00000009000000
4a00000009000000
0000004a60000000
4a00000009000000
0000004a60000000
-
{c=>0,a=>12,b=>1}
0c00000001000000
0c00000001000000
0c00000001000000
0000000c40000000
0c00000001000000
0c00000001000000
0000000c40000000
0c00000001000000
0000000c40000000
=
struct force_align2 {
  int a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
};
-
{c=>2,a=>-93,b=>0,d=>3}
a3ffffff08030000
a3ffffff08030000
a3ffffff08030000
ffffffa320c00000
a3ffffff08030000
a3ffffff08030000
ffffffa320c00000
a3ffffff08030000
ffffffa320c00000
-
{c=>0,a=>-88,b=>2,d=>0}
a8ffffff02000000
a8ffffff02000000
a8ffffff02000000
ffffffa880000000
a8ffffff02000000
a8ffffff02000000
ffffffa880000000
a8ffffff02000000
ffffffa880000000
-
{c=>0,a=>89,b=>3,d=>0}
5900000003000000
5900000003000000
5900000003000000
00000059c0000000
5900000003000000
5900000003000000
00000059c0000000
5900000003000000
00000059c0000000
-
{c=>1,a=>-61,b=>2,d=>1}
c3ffffff06010000
c3ffffff06010000
c3ffffff06010000
ffffffc390400000
c3ffffff06010000
c3ffffff06010000
ffffffc390400000
c3ffffff06010000
ffffffc390400000
-
{c=>0,a=>-21,b=>0,d=>1}
ebffffff00010000
ebffffff00010000
ebffffff00010000
ffffffeb00400000
ebffffff00010000
ebffffff00010000
ffffffeb00400000
ebffffff00010000
ffffffeb00400000
=
struct force_align2 {
  int a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
  unsigned short e;
};
-
{e=>23,c=>0,a=>-79,b=>1,d=>3}
b1ffffff01031700
b1ffffff01031700
b1ffffff01031700
ffffffb140c00017
b1ffffff01031700
b1ffffff01031700
ffffffb140c00017
b1ffffff01031700
ffffffb140c00017
-
{e=>106,c=>2,a=>-36,b=>0,d=>0}
dcffffff08006a00
dcffffff08006a00
dcffffff08006a00
ffffffdc2000006a
dcffffff08006a00
dcffffff08006a00
ffffffdc2000006a
dcffffff08006a00
ffffffdc2000006a
-
{e=>139,c=>3,a=>114,b=>3,d=>3}
720000000f038b00
720000000f038b00
720000000f038b00
00000072f0c0008b
720000000f038b00
720000000f038b00
00000072f0c0008b
720000000f038b00
00000072f0c0008b
-
{e=>151,c=>2,a=>-110,b=>0,d=>3}
92ffffff08039700
92ffffff08039700
92ffffff08039700
ffffff9220c00097
92ffffff08039700
92ffffff08039700
ffffff9220c00097
92ffffff08039700
ffffff9220c00097
-
{e=>15,c=>1,a=>-72,b=>0,d=>3}
b8ffffff04030f00
b8ffffff04030f00
b8ffffff04030f00
ffffffb810c0000f
b8ffffff04030f00
b8ffffff04030f00
ffffffb810c0000f
b8ffffff04030f00
ffffffb810c0000f
=
struct force_align2 {
  long a;
  unsigned char  b:2;
};
-
{a=>-86,b=>1}
aaffffff01000000
aaffffffffffffff0100000000000000
aaffffffffffffff0100000000000000
ffffffaa40000000
aaffffff01000000
aaffffff01000000
ffffffffffffffaa4000000000000000
aaffffff01000000
ffffffaa40000000
-
{a=>-16,b=>0}
f0ffffff00000000
f0ffffffffffffff0000000000000000
f0ffffffffffffff0000000000000000
fffffff000000000
f0ffffff00000000
f0ffffff00000000
fffffffffffffff00000000000000000
f0ffffff00000000
fffffff000000000
-
{a=>-65,b=>2}
bfffffff02000000
bfffffffffffffff0200000000000000
bfffffffffffffff0200000000000000
ffffffbf80000000
bfffffff02000000
bfffffff02000000
ffffffffffffffbf8000000000000000
bfffffff02000000
ffffffbf80000000
-
{a=>2,b=>2}
0200000002000000
02000000000000000200000000000000
02000000000000000200000000000000
0000000280000000
0200000002000000
0200000002000000
00000000000000028000000000000000
0200000002000000
0000000280000000
-
{a=>-85,b=>2}
abffffff02000000
abffffffffffffff0200000000000000
abffffffffffffff0200000000000000
ffffffab80000000
abffffff02000000
abffffff02000000
ffffffffffffffab8000000000000000
abffffff02000000
ffffffab80000000
=
struct force_align2 {
  long a;
  unsigned char  b:2;
  unsigned char  c:2;
};
-
{c=>3,a=>-105,b=>2}
97ffffff0e000000
97ffffffffffffff0e00000000000000
97ffffffffffffff0e00000000000000
ffffff97b0000000
97ffffff0e000000
97ffffff0e000000
ffffffffffffff97b000000000000000
97ffffff0e000000
ffffff97b0000000
-
{c=>1,a=>14,b=>1}
0e00000005000000
0e000000000000000500000000000000
0e000000000000000500000000000000
0000000e50000000
0e00000005000000
0e00000005000000
000000000000000e5000000000000000
0e00000005000000
0000000e50000000
-
{c=>1,a=>-120,b=>2}
88ffffff06000000
88ffffffffffffff0600000000000000
88ffffffffffffff0600000000000000
ffffff8890000000
88ffffff06000000
88ffffff06000000
ffffffffffffff889000000000000000
88ffffff06000000
ffffff8890000000
-
{c=>2,a=>67,b=>3}
430000000b000000
43000000000000000b00000000000000
43000000000000000b00000000000000
00000043e0000000
430000000b000000
430000000b000000
0000000000000043e000000000000000
430000000b000000
00000043e0000000
-
{c=>1,a=>85,b=>0}
5500000004000000
55000000000000000400000000000000
55000000000000000400000000000000
0000005510000000
5500000004000000
5500000004000000
00000000000000551000000000000000
5500000004000000
0000005510000000
=
struct force_align2 {
  long a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
};
-
{c=>1,a=>113,b=>1}
7100000005000000
71000000000000000500000000000000
71000000000000000500000000000000
0000007150000000
7100000005000000
7100000005000000
00000000000000715000000000000000
7100000005000000
0000007150000000
-
{c=>0,a=>-59,b=>2}
c5ffffff02000000
c5ffffffffffffff0200000000000000
c5ffffffffffffff0200000000000000
ffffffc580000000
c5ffffff02000000
c5ffffff02000000
ffffffffffffffc58000000000000000
c5ffffff02000000
ffffffc580000000
-
{c=>2,a=>115,b=>1}
7300000009000000
73000000000000000900000000000000
73000000000000000900000000000000
0000007360000000
7300000009000000
7300000009000000
00000000000000736000000000000000
7300000009000000
0000007360000000
-
{c=>1,a=>-97,b=>3}
9fffffff07000000
9fffffffffffffff0700000000000000
9fffffffffffffff0700000000000000
ffffff9fd0000000
9fffffff07000000
9fffffff07000000
ffffffffffffff9fd000000000000000
9fffffff07000000
ffffff9fd0000000
-
{c=>2,a=>38,b=>2}
260000000a000000
26000000000000000a00000000000000
26000000000000000a00000000000000
00000026a0000000
260000000a000000
260000000a000000
0000000000000026a000000000000000
260000000a000000
00000026a0000000
=
struct force_align2 {
  long a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
};
-
{c=>2,a=>14,b=>0,d=>0}
0e00000008000000
0e000000000000000800000000000000
0e000000000000000800000000000000
0000000e20000000
0e00000008000000
0e00000008000000
000000000000000e2000000000000000
0e00000008000000
0000000e20000000
-
{c=>3,a=>-56,b=>0,d=>3}
c8ffffff0c030000
c8ffffffffffffff0c03000000000000
c8ffffffffffffff0c03000000000000
ffffffc830c00000
c8ffffff0c030000
c8ffffff0c030000
ffffffffffffffc830c0000000000000
c8ffffff0c030000
ffffffc830c00000
-
{c=>1,a=>84,b=>0,d=>2}
5400000004020000
54000000000000000402000000000000
54000000000000000402000000000000
0000005410800000
5400000004020000
5400000004020000
00000000000000541080000000000000
5400000004020000
0000005410800000
-
{c=>1,a=>-54,b=>2,d=>0}
caffffff06000000
caffffffffffffff0600000000000000
caffffffffffffff0600000000000000
ffffffca90000000
caffffff06000000
caffffff06000000
ffffffffffffffca9000000000000000
caffffff06000000
ffffffca90000000
-
{c=>0,a=>61,b=>2,d=>0}
3d00000002000000
3d000000000000000200000000000000
3d000000000000000200000000000000
0000003d80000000
3d00000002000000
3d00000002000000
000000000000003d8000000000000000
3d00000002000000
0000003d80000000
=
struct force_align2 {
  long a;
  unsigned char  b:2;
  unsigned char  c:2;
  unsigned char   :0;
  unsigned char  d:2;
  unsigned short e;
};
-
{e=>109,c=>0,a=>66,b=>0,d=>1}
4200000000016d00
420000000000000000016d0000000000
420000000000000000016d0000000000
000000420040006d
4200000000016d00
4200000000016d00
00000000000000420040006d00000000
4200000000016d00
000000420040006d
-
{e=>167,c=>2,a=>-15,b=>2,d=>0}
f1ffffff0a00a700
f1ffffffffffffff0a00a70000000000
f1ffffffffffffff0a00a70000000000
fffffff1a00000a7
f1ffffff0a00a700
f1ffffff0a00a700
fffffffffffffff1a00000a700000000
f1ffffff0a00a700
fffffff1a00000a7
-
{e=>39,c=>1,a=>92,b=>1,d=>3}
5c00000005032700
5c000000000000000503270000000000
5c000000000000000503270000000000
0000005c50c00027
5c00000005032700
5c00000005032700
000000000000005c50c0002700000000
5c00000005032700
0000005c50c00027
-
{e=>135,c=>3,a=>-67,b=>0,d=>2}
bdffffff0c028700
bdffffffffffffff0c02870000000000
bdffffffffffffff0c02870000000000
ffffffbd30800087
bdffffff0c028700
bdffffff0c028700
ffffffffffffffbd3080008700000000
bdffffff0c028700
ffffffbd30800087
-
{e=>180,c=>1,a=>38,b=>0,d=>0}
260000000400b400
26000000000000000400b40000000000
26000000000000000400b40000000000
00000026100000b4
260000000400b400
260000000400b400
0000000000000026100000b400000000
260000000400b400
00000026100000b4
=
struct mixed1 {
  unsigned int a:1;
};
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>1}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>1}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
};
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>1,b=>1}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
};
-
{a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{a=>1,b=>0}
01000000
01000000
01000000
80000000
01000000
01000000
80000000
01000000
80000000
-
{a=>0,b=>1}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>1,b=>1}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
};
-
{c=>1,a=>0,b=>0}
0000000001000000
0000000001000000
0000000001000000
0000000080000000
0000000001000000
0000000001000000
0000000080000000
0000000001000000
0000000080000000
-
{c=>1,a=>1,b=>1}
0300000001000000
0300000001000000
0300000001000000
c000000080000000
0300000001000000
0300000001000000
c000000080000000
0300000001000000
c000000080000000
-
{c=>0,a=>1,b=>0}
0100000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
8000000000000000
-
{c=>0,a=>0,b=>1}
0200000000000000
0200000000000000
0200000000000000
4000000000000000
0200000000000000
0200000000000000
4000000000000000
0200000000000000
4000000000000000
-
{c=>0,a=>1,b=>0}
0100000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
8000000000000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
};
-
{c=>0,a=>1,b=>1,d=>0}
0300000000000000
0300000000000000
0300000000000000
c000000000000000
0300000000000000
0300000000000000
c000000000000000
0300000000000000
c000000000000000
-
{c=>0,a=>1,b=>1,d=>-1}
0300000002000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
c000000040000000
-
{c=>1,a=>0,b=>0,d=>0}
0000000001000000
0000000001000000
0000000001000000
0000000080000000
0000000001000000
0000000001000000
0000000080000000
0000000001000000
0000000080000000
-
{c=>0,a=>1,b=>1,d=>-1}
0300000002000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
c000000040000000
-
{c=>0,a=>1,b=>0,d=>0}
0100000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
0100000000000000
8000000000000000
0100000000000000
8000000000000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
};
-
{e=>0,c=>0,a=>0,b=>1,d=>0}
0200000000000000
0200000000000000
0200000000000000
4000000000000000
0200000000000000
0200000000000000
4000000000000000
0200000000000000
4000000000000000
-
{e=>-1,c=>0,a=>0,b=>1,d=>-1}
0200000006000000
0200000006000000
0200000006000000
4000000060000000
0200000006000000
0200000006000000
4000000060000000
0200000006000000
4000000060000000
-
{e=>0,c=>0,a=>1,b=>1,d=>-1}
0300000002000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
0300000002000000
c000000040000000
0300000002000000
c000000040000000
-
{e=>-1,c=>1,a=>1,b=>0,d=>-1}
0100000007000000
0100000007000000
0100000007000000
80000000e0000000
0100000007000000
0100000007000000
80000000e0000000
0100000007000000
80000000e0000000
-
{e=>0,c=>0,a=>0,b=>0,d=>0}
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
};
-
{e=>-1,c=>0,a=>1,b=>0,d=>-1}
0100000006000000
0100000006000000
0100000006000000
8000000060000000
0100000006000000
0100000006000000
8000000060000000
0100000006000000
8000000060000000
-
{e=>0,c=>1,a=>1,b=>0,d=>0}
0100000001000000
0100000001000000
0100000001000000
8000000080000000
0100000001000000
0100000001000000
8000000080000000
0100000001000000
8000000080000000
-
{e=>-1,c=>0,a=>1,b=>0,d=>0}
0100000004000000
0100000004000000
0100000004000000
8000000020000000
0100000004000000
0100000004000000
8000000020000000
0100000004000000
8000000020000000
-
{e=>0,c=>1,a=>0,b=>1,d=>-1}
0200000003000000
0200000003000000
0200000003000000
40000000c0000000
0200000003000000
0200000003000000
40000000c0000000
0200000003000000
40000000c0000000
-
{e=>-1,c=>1,a=>1,b=>1,d=>-1}
0300000007000000
0300000007000000
0300000007000000
c0000000e0000000
0300000007000000
0300000007000000
c0000000e0000000
0300000007000000
c0000000e0000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
};
-
{e=>-1,c=>1,a=>0,b=>1,d=>-1,f=>-1}
020000000700000001000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
40000000e000000080000000
-
{e=>-1,c=>0,a=>0,b=>1,d=>0,f=>-1}
020000000400000001000000
020000000400000001000000
020000000400000001000000
400000002000000080000000
020000000400000001000000
020000000400000001000000
400000002000000080000000
020000000400000001000000
400000002000000080000000
-
{e=>-1,c=>1,a=>0,b=>1,d=>-1,f=>-1}
020000000700000001000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
40000000e000000080000000
-
{e=>0,c=>1,a=>0,b=>0,d=>0,f=>-1}
000000000100000001000000
000000000100000001000000
000000000100000001000000
000000008000000080000000
000000000100000001000000
000000000100000001000000
000000008000000080000000
000000000100000001000000
000000008000000080000000
-
{e=>-1,c=>1,a=>0,b=>1,d=>-1,f=>-1}
020000000700000001000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
020000000700000001000000
40000000e000000080000000
020000000700000001000000
40000000e000000080000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
  int          g:1;
};
-
{e=>0,c=>1,a=>1,g=>-1,b=>1,d=>-1,f=>-1}
030000000300000003000000
030000000300000003000000
030000000300000003000000
c0000000c0000000c0000000
030000000300000003000000
030000000300000003000000
c0000000c0000000c0000000
030000000300000003000000
c0000000c0000000c0000000
-
{e=>0,c=>0,a=>1,g=>-1,b=>1,d=>0,f=>-1}
030000000000000003000000
030000000000000003000000
030000000000000003000000
c000000000000000c0000000
030000000000000003000000
030000000000000003000000
c000000000000000c0000000
030000000000000003000000
c000000000000000c0000000
-
{e=>0,c=>0,a=>0,g=>-1,b=>0,d=>0,f=>-1}
000000000000000003000000
000000000000000003000000
000000000000000003000000
0000000000000000c0000000
000000000000000003000000
000000000000000003000000
0000000000000000c0000000
000000000000000003000000
0000000000000000c0000000
-
{e=>0,c=>1,a=>1,g=>0,b=>1,d=>0,f=>0}
030000000100000000000000
030000000100000000000000
030000000100000000000000
c00000008000000000000000
030000000100000000000000
030000000100000000000000
c00000008000000000000000
030000000100000000000000
c00000008000000000000000
-
{e=>0,c=>1,a=>0,g=>-1,b=>1,d=>0,f=>0}
020000000100000002000000
020000000100000002000000
020000000100000002000000
400000008000000040000000
020000000100000002000000
020000000100000002000000
400000008000000040000000
020000000100000002000000
400000008000000040000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
  int          g:1;
  int          h:1;
};
-
{e=>0,a=>1,d=>-1,c=>0,h=>0,b=>1,g=>-1,f=>-1}
030000000200000003000000
030000000200000003000000
030000000200000003000000
c000000040000000c0000000
030000000200000003000000
030000000200000003000000
c000000040000000c0000000
030000000200000003000000
c000000040000000c0000000
-
{e=>0,a=>0,d=>0,c=>0,h=>-1,b=>1,g=>-1,f=>-1}
020000000000000007000000
020000000000000007000000
020000000000000007000000
4000000000000000e0000000
020000000000000007000000
020000000000000007000000
4000000000000000e0000000
020000000000000007000000
4000000000000000e0000000
-
{e=>0,a=>0,d=>-1,c=>1,h=>0,b=>1,g=>-1,f=>0}
020000000300000002000000
020000000300000002000000
020000000300000002000000
40000000c000000040000000
020000000300000002000000
020000000300000002000000
40000000c000000040000000
020000000300000002000000
40000000c000000040000000
-
{e=>0,a=>0,d=>-1,c=>1,h=>-1,b=>0,g=>-1,f=>0}
000000000300000006000000
000000000300000006000000
000000000300000006000000
00000000c000000060000000
000000000300000006000000
000000000300000006000000
00000000c000000060000000
000000000300000006000000
00000000c000000060000000
-
{e=>0,a=>1,d=>-1,c=>0,h=>-1,b=>1,g=>0,f=>-1}
030000000200000005000000
030000000200000005000000
030000000200000005000000
c000000040000000a0000000
030000000200000005000000
030000000200000005000000
c000000040000000a0000000
030000000200000005000000
c000000040000000a0000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
  int          g:1;
  int          h:1;
  int           :0;
};
-
{e=>0,a=>1,d=>0,c=>0,h=>-1,b=>0,g=>0,f=>-1}
010000000000000005000000
010000000000000005000000
010000000000000005000000
8000000000000000a0000000
010000000000000005000000
010000000000000005000000
8000000000000000a0000000
010000000000000005000000
8000000000000000a0000000
-
{e=>0,a=>1,d=>-1,c=>0,h=>-1,b=>0,g=>0,f=>-1}
010000000200000005000000
010000000200000005000000
010000000200000005000000
8000000040000000a0000000
010000000200000005000000
010000000200000005000000
8000000040000000a0000000
010000000200000005000000
8000000040000000a0000000
-
{e=>-1,a=>0,d=>0,c=>0,h=>0,b=>1,g=>0,f=>-1}
020000000400000001000000
020000000400000001000000
020000000400000001000000
400000002000000080000000
020000000400000001000000
020000000400000001000000
400000002000000080000000
020000000400000001000000
400000002000000080000000
-
{e=>0,a=>1,d=>-1,c=>0,h=>-1,b=>1,g=>0,f=>-1}
030000000200000005000000
030000000200000005000000
030000000200000005000000
c000000040000000a0000000
030000000200000005000000
030000000200000005000000
c000000040000000a0000000
030000000200000005000000
c000000040000000a0000000
-
{e=>-1,a=>1,d=>0,c=>0,h=>0,b=>0,g=>-1,f=>-1}
010000000400000003000000
010000000400000003000000
010000000400000003000000
8000000020000000c0000000
010000000400000003000000
010000000400000003000000
8000000020000000c0000000
010000000400000003000000
8000000020000000c0000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
  int          g:1;
  int          h:1;
  int           :0;
  int          i:1;
};
-
{e=>-1,a=>1,d=>0,c=>1,h=>-1,b=>0,g=>-1,f=>-1,i=>0}
01000000050000000700000000000000
01000000050000000700000000000000
01000000050000000700000000000000
80000000a0000000e000000000000000
01000000050000000700000000000000
01000000050000000700000000000000
80000000a0000000e000000000000000
01000000050000000700000000000000
80000000a0000000e000000000000000
-
{e=>0,a=>1,d=>0,c=>0,h=>-1,b=>0,g=>0,f=>-1,i=>0}
01000000000000000500000000000000
01000000000000000500000000000000
01000000000000000500000000000000
8000000000000000a000000000000000
01000000000000000500000000000000
01000000000000000500000000000000
8000000000000000a000000000000000
01000000000000000500000000000000
8000000000000000a000000000000000
-
{e=>0,a=>1,d=>-1,c=>1,h=>-1,b=>0,g=>0,f=>-1,i=>0}
01000000030000000500000000000000
01000000030000000500000000000000
01000000030000000500000000000000
80000000c0000000a000000000000000
01000000030000000500000000000000
01000000030000000500000000000000
80000000c0000000a000000000000000
01000000030000000500000000000000
80000000c0000000a000000000000000
-
{e=>0,a=>1,d=>-1,c=>1,h=>-1,b=>1,g=>0,f=>-1,i=>0}
03000000030000000500000000000000
03000000030000000500000000000000
03000000030000000500000000000000
c0000000c0000000a000000000000000
03000000030000000500000000000000
03000000030000000500000000000000
c0000000c0000000a000000000000000
03000000030000000500000000000000
c0000000c0000000a000000000000000
-
{e=>-1,a=>1,d=>-1,c=>0,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
01000000060000000600000001000000
01000000060000000600000001000000
01000000060000000600000001000000
80000000600000006000000080000000
01000000060000000600000001000000
01000000060000000600000001000000
80000000600000006000000080000000
01000000060000000600000001000000
80000000600000006000000080000000
=
struct mixed1 {
  unsigned int a:1;
  unsigned int b:1;
  unsigned int  :0;
  unsigned int c:1;
  signed   int d:1;
  signed   int e:1;
  signed   int  :0;
  signed   int f:1;
  int          g:1;
  int          h:1;
  int           :0;
  int          i:1;
  long         j;
};
-
{e=>-1,a=>0,d=>-1,j=>95,c=>0,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
000000000600000006000000010000005f000000
000000000600000006000000010000005f00000000000000
000000000600000006000000010000005f00000000000000
000000006000000060000000800000000000005f
000000000600000006000000010000005f000000
000000000600000006000000010000005f000000
00000000600000006000000080000000000000000000005f
000000000600000006000000010000005f000000
000000006000000060000000800000000000005f
-
{e=>-1,a=>0,d=>0,j=>6,c=>1,h=>-1,b=>1,g=>0,f=>-1,i=>0}
0200000005000000050000000000000006000000
020000000500000005000000000000000600000000000000
020000000500000005000000000000000600000000000000
40000000a0000000a00000000000000000000006
0200000005000000050000000000000006000000
0200000005000000050000000000000006000000
40000000a0000000a0000000000000000000000000000006
0200000005000000050000000000000006000000
40000000a0000000a00000000000000000000006
-
{e=>0,a=>1,d=>-1,j=>2,c=>1,h=>0,b=>1,g=>0,f=>-1,i=>-1}
0300000003000000010000000100000002000000
030000000300000001000000010000000200000000000000
030000000300000001000000010000000200000000000000
c0000000c0000000800000008000000000000002
0300000003000000010000000100000002000000
0300000003000000010000000100000002000000
c0000000c000000080000000800000000000000000000002
0300000003000000010000000100000002000000
c0000000c0000000800000008000000000000002
-
{e=>0,a=>1,d=>0,j=>29,c=>0,h=>0,b=>1,g=>0,f=>0,i=>-1}
030000000000000000000000010000001d000000
030000000000000000000000010000001d00000000000000
030000000000000000000000010000001d00000000000000
c00000000000000000000000800000000000001d
030000000000000000000000010000001d000000
030000000000000000000000010000001d000000
c0000000000000000000000080000000000000000000001d
030000000000000000000000010000001d000000
c00000000000000000000000800000000000001d
-
{e=>0,a=>0,d=>-1,j=>-28,c=>0,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
02000000020000000700000000000000e4ffffff
02000000020000000700000000000000e4ffffffffffffff
02000000020000000700000000000000e4ffffffffffffff
4000000040000000e000000000000000ffffffe4
02000000020000000700000000000000e4ffffff
02000000020000000700000000000000e4ffffff
4000000040000000e000000000000000ffffffffffffffe4
02000000020000000700000000000000e4ffffff
4000000040000000e000000000000000ffffffe4
=
struct mixed1 {
  char a;
  unsigned int b:1;
};
-
{a=>110,b=>1}
6e010000
6e010000
6e010000
6e800000
6e010000
6e010000
6e800000
6e010000
6e800000
-
{a=>-117,b=>1}
8b010000
8b010000
8b010000
8b800000
8b010000
8b010000
8b800000
8b010000
8b800000
-
{a=>-103,b=>0}
99000000
99000000
99000000
99000000
99000000
99000000
99000000
99000000
99000000
-
{a=>-42,b=>0}
d6000000
d6000000
d6000000
d6000000
d6000000
d6000000
d6000000
d6000000
d6000000
-
{a=>71,b=>1}
47010000
47010000
47010000
47800000
47010000
47010000
47800000
47010000
47800000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
};
-
{c=>0,a=>53,b=>0}
35000000
35000000
35000000
35000000
35000000
35000000
35000000
35000000
35000000
-
{c=>1,a=>5,b=>1}
05030000
05030000
05030000
05c00000
05030000
05030000
05c00000
05030000
05c00000
-
{c=>0,a=>-80,b=>0}
b0000000
b0000000
b0000000
b0000000
b0000000
b0000000
b0000000
b0000000
b0000000
-
{c=>1,a=>100,b=>0}
64020000
64020000
64020000
64400000
64020000
64020000
64400000
64020000
64400000
-
{c=>1,a=>-94,b=>1}
a2030000
a2030000
a2030000
a2c00000
a2030000
a2030000
a2c00000
a2030000
a2c00000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
};
-
{c=>0,a=>-121,b=>1}
87010000
87010000
87010000
87800000
87010000
87010000
87800000
87010000
87800000
-
{c=>0,a=>-57,b=>1}
c7010000
c7010000
c7010000
c7800000
c7010000
c7010000
c7800000
c7010000
c7800000
-
{c=>0,a=>37,b=>1}
25010000
25010000
25010000
25800000
25010000
25010000
25800000
25010000
25800000
-
{c=>1,a=>37,b=>1}
25030000
25030000
25030000
25c00000
25030000
25030000
25c00000
25030000
25c00000
-
{c=>0,a=>-110,b=>0}
92000000
92000000
92000000
92000000
92000000
92000000
92000000
92000000
92000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
};
-
{c=>0,a=>43,b=>0,d=>0}
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
2b00000000000000
-
{c=>1,a=>72,b=>1,d=>0}
4803000000000000
4803000000000000
4803000000000000
48c0000000000000
4803000000000000
4803000000000000
48c0000000000000
4803000000000000
48c0000000000000
-
{c=>1,a=>70,b=>0,d=>0}
4602000000000000
4602000000000000
4602000000000000
4640000000000000
4602000000000000
4602000000000000
4640000000000000
4602000000000000
4640000000000000
-
{c=>1,a=>50,b=>1,d=>0}
3203000000000000
3203000000000000
3203000000000000
32c0000000000000
3203000000000000
3203000000000000
32c0000000000000
3203000000000000
32c0000000000000
-
{c=>0,a=>104,b=>0,d=>0}
6800000000000000
6800000000000000
6800000000000000
6800000000000000
6800000000000000
6800000000000000
6800000000000000
6800000000000000
6800000000000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
};
-
{e=>0,c=>0,a=>48,b=>1,d=>1}
3001000001000000
3001000001000000
3001000001000000
3080000080000000
3001000001000000
3001000001000000
3080000080000000
3001000001000000
3080000080000000
-
{e=>-1,c=>0,a=>-115,b=>1,d=>0}
8d01000002000000
8d01000002000000
8d01000002000000
8d80000040000000
8d01000002000000
8d01000002000000
8d80000040000000
8d01000002000000
8d80000040000000
-
{e=>-1,c=>1,a=>-71,b=>0,d=>1}
b902000003000000
b902000003000000
b902000003000000
b9400000c0000000
b902000003000000
b902000003000000
b9400000c0000000
b902000003000000
b9400000c0000000
-
{e=>-1,c=>0,a=>38,b=>0,d=>0}
2600000002000000
2600000002000000
2600000002000000
2600000040000000
2600000002000000
2600000002000000
2600000040000000
2600000002000000
2600000040000000
-
{e=>-1,c=>1,a=>110,b=>0,d=>0}
6e02000002000000
6e02000002000000
6e02000002000000
6e40000040000000
6e02000002000000
6e02000002000000
6e40000040000000
6e02000002000000
6e40000040000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
};
-
{e=>0,c=>0,a=>-12,b=>0,d=>1,f=>0}
f400000001000000
f400000001000000
f400000001000000
f400000080000000
f400000001000000
f400000001000000
f400000080000000
f400000001000000
f400000080000000
-
{e=>0,c=>0,a=>5,b=>0,d=>1,f=>0}
0500000001000000
0500000001000000
0500000001000000
0500000080000000
0500000001000000
0500000001000000
0500000080000000
0500000001000000
0500000080000000
-
{e=>-1,c=>1,a=>47,b=>0,d=>0,f=>0}
2f02000002000000
2f02000002000000
2f02000002000000
2f40000040000000
2f02000002000000
2f02000002000000
2f40000040000000
2f02000002000000
2f40000040000000
-
{e=>-1,c=>1,a=>87,b=>0,d=>0,f=>-1}
5702000006000000
5702000006000000
5702000006000000
5740000060000000
5702000006000000
5702000006000000
5740000060000000
5702000006000000
5740000060000000
-
{e=>0,c=>0,a=>-26,b=>1,d=>1,f=>0}
e601000001000000
e601000001000000
e601000001000000
e680000080000000
e601000001000000
e601000001000000
e680000080000000
e601000001000000
e680000080000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
};
-
{e=>0,c=>0,a=>-46,b=>1,d=>1,f=>0}
d201000001000000
d201000001000000
d201000001000000
d280000080000000
d201000001000000
d201000001000000
d280000080000000
d201000001000000
d280000080000000
-
{e=>-1,c=>0,a=>-8,b=>1,d=>1,f=>0}
f801000003000000
f801000003000000
f801000003000000
f8800000c0000000
f801000003000000
f801000003000000
f8800000c0000000
f801000003000000
f8800000c0000000
-
{e=>-1,c=>1,a=>-104,b=>1,d=>0,f=>-1}
9803000006000000
9803000006000000
9803000006000000
98c0000060000000
9803000006000000
9803000006000000
98c0000060000000
9803000006000000
98c0000060000000
-
{e=>0,c=>1,a=>111,b=>1,d=>1,f=>0}
6f03000001000000
6f03000001000000
6f03000001000000
6fc0000080000000
6f03000001000000
6f03000001000000
6fc0000080000000
6f03000001000000
6fc0000080000000
-
{e=>-1,c=>1,a=>66,b=>1,d=>0,f=>-1}
4203000006000000
4203000006000000
4203000006000000
42c0000060000000
4203000006000000
4203000006000000
42c0000060000000
4203000006000000
42c0000060000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
};
-
{e=>0,c=>0,a=>33,g=>0,b=>1,d=>1,f=>-1}
210100000500000000000000
210100000500000000000000
210100000500000000000000
21800000a000000000000000
210100000500000000000000
210100000500000000000000
21800000a000000000000000
210100000500000000000000
21800000a000000000000000
-
{e=>0,c=>1,a=>-26,g=>0,b=>1,d=>1,f=>-1}
e60300000500000000000000
e60300000500000000000000
e60300000500000000000000
e6c00000a000000000000000
e60300000500000000000000
e60300000500000000000000
e6c00000a000000000000000
e60300000500000000000000
e6c00000a000000000000000
-
{e=>-1,c=>1,a=>-58,g=>0,b=>0,d=>1,f=>-1}
c60200000700000000000000
c60200000700000000000000
c60200000700000000000000
c6400000e000000000000000
c60200000700000000000000
c60200000700000000000000
c6400000e000000000000000
c60200000700000000000000
c6400000e000000000000000
-
{e=>0,c=>1,a=>-27,g=>-1,b=>0,d=>0,f=>-1}
e50200000400000001000000
e50200000400000001000000
e50200000400000001000000
e54000002000000080000000
e50200000400000001000000
e50200000400000001000000
e54000002000000080000000
e50200000400000001000000
e54000002000000080000000
-
{e=>-1,c=>1,a=>-33,g=>0,b=>0,d=>1,f=>0}
df0200000300000000000000
df0200000300000000000000
df0200000300000000000000
df400000c000000000000000
df0200000300000000000000
df0200000300000000000000
df400000c000000000000000
df0200000300000000000000
df400000c000000000000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
};
-
{e=>-1,a=>40,d=>0,c=>1,h=>0,b=>1,g=>0,f=>0}
280300000200000000000000
280300000200000000000000
280300000200000000000000
28c000004000000000000000
280300000200000000000000
280300000200000000000000
28c000004000000000000000
280300000200000000000000
28c000004000000000000000
-
{e=>-1,a=>123,d=>0,c=>0,h=>0,b=>1,g=>-1,f=>-1}
7b0100000600000001000000
7b0100000600000001000000
7b0100000600000001000000
7b8000006000000080000000
7b0100000600000001000000
7b0100000600000001000000
7b8000006000000080000000
7b0100000600000001000000
7b8000006000000080000000
-
{e=>-1,a=>102,d=>0,c=>1,h=>0,b=>0,g=>-1,f=>-1}
660200000600000001000000
660200000600000001000000
660200000600000001000000
664000006000000080000000
660200000600000001000000
660200000600000001000000
664000006000000080000000
660200000600000001000000
664000006000000080000000
-
{e=>0,a=>-10,d=>1,c=>1,h=>-1,b=>1,g=>0,f=>-1}
f60300000500000002000000
f60300000500000002000000
f60300000500000002000000
f6c00000a000000040000000
f60300000500000002000000
f60300000500000002000000
f6c00000a000000040000000
f60300000500000002000000
f6c00000a000000040000000
-
{e=>0,a=>49,d=>1,c=>0,h=>0,b=>0,g=>-1,f=>-1}
310000000500000001000000
310000000500000001000000
310000000500000001000000
31000000a000000080000000
310000000500000001000000
310000000500000001000000
31000000a000000080000000
310000000500000001000000
31000000a000000080000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
};
-
{e=>-1,a=>-11,d=>1,c=>1,h=>-1,b=>1,g=>-1,f=>0,i=>-1}
f50300000300000007000000
f50300000300000007000000
f50300000300000007000000
f5c00000c0000000e0000000
f50300000300000007000000
f50300000300000007000000
f5c00000c0000000e0000000
f50300000300000007000000
f5c00000c0000000e0000000
-
{e=>0,a=>-102,d=>0,c=>0,h=>0,b=>0,g=>-1,f=>-1,i=>0}
9a0000000400000001000000
9a0000000400000001000000
9a0000000400000001000000
9a0000002000000080000000
9a0000000400000001000000
9a0000000400000001000000
9a0000002000000080000000
9a0000000400000001000000
9a0000002000000080000000
-
{e=>0,a=>-33,d=>1,c=>0,h=>-1,b=>0,g=>0,f=>0,i=>0}
df0000000100000002000000
df0000000100000002000000
df0000000100000002000000
df0000008000000040000000
df0000000100000002000000
df0000000100000002000000
df0000008000000040000000
df0000000100000002000000
df0000008000000040000000
-
{e=>-1,a=>-96,d=>1,c=>0,h=>0,b=>1,g=>0,f=>0,i=>0}
a00100000300000000000000
a00100000300000000000000
a00100000300000000000000
a0800000c000000000000000
a00100000300000000000000
a00100000300000000000000
a0800000c000000000000000
a00100000300000000000000
a0800000c000000000000000
-
{e=>-1,a=>125,d=>1,c=>1,h=>-1,b=>0,g=>0,f=>-1,i=>-1}
7d0200000700000006000000
7d0200000700000006000000
7d0200000700000006000000
7d400000e000000060000000
7d0200000700000006000000
7d0200000700000006000000
7d400000e000000060000000
7d0200000700000006000000
7d400000e000000060000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
};
-
{e=>-1,a=>-41,d=>0,c=>0,h=>-1,b=>1,g=>-1,f=>-1,i=>-1}
d70100000600000007000000
d70100000600000007000000
d70100000600000007000000
d780000060000000e0000000
d70100000600000007000000
d70100000600000007000000
d780000060000000e0000000
d70100000600000007000000
d780000060000000e0000000
-
{e=>-1,a=>51,d=>1,c=>0,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
330100000700000003000000
330100000700000003000000
330100000700000003000000
33800000e0000000c0000000
330100000700000003000000
330100000700000003000000
33800000e0000000c0000000
330100000700000003000000
33800000e0000000c0000000
-
{e=>0,a=>43,d=>0,c=>0,h=>0,b=>1,g=>0,f=>-1,i=>-1}
2b0100000400000004000000
2b0100000400000004000000
2b0100000400000004000000
2b8000002000000020000000
2b0100000400000004000000
2b0100000400000004000000
2b8000002000000020000000
2b0100000400000004000000
2b8000002000000020000000
-
{e=>0,a=>33,d=>0,c=>1,h=>-1,b=>0,g=>0,f=>0,i=>-1}
210200000000000006000000
210200000000000006000000
210200000000000006000000
214000000000000060000000
210200000000000006000000
210200000000000006000000
214000000000000060000000
210200000000000006000000
214000000000000060000000
-
{e=>-1,a=>-111,d=>1,c=>1,h=>0,b=>0,g=>0,f=>-1,i=>0}
910200000700000000000000
910200000700000000000000
910200000700000000000000
91400000e000000000000000
910200000700000000000000
910200000700000000000000
91400000e000000000000000
910200000700000000000000
91400000e000000000000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
};
-
{e=>-1,a=>-32,d=>0,j=>-1,c=>1,h=>-1,b=>0,g=>-1,f=>0,i=>0}
e0020000020000000300000001000000
e0020000020000000300000001000000
e0020000020000000300000001000000
e040000040000000c000000080000000
e0020000020000000300000001000000
e0020000020000000300000001000000
e040000040000000c000000080000000
e0020000020000000300000001000000
e040000040000000c000000080000000
-
{e=>0,a=>-11,d=>0,j=>0,c=>1,h=>0,b=>1,g=>-1,f=>-1,i=>-1}
f5030000040000000500000000000000
f5030000040000000500000000000000
f5030000040000000500000000000000
f5c0000020000000a000000000000000
f5030000040000000500000000000000
f5030000040000000500000000000000
f5c0000020000000a000000000000000
f5030000040000000500000000000000
f5c0000020000000a000000000000000
-
{e=>0,a=>-110,d=>1,j=>-1,c=>1,h=>-1,b=>1,g=>-1,f=>0,i=>-1}
92030000010000000700000001000000
92030000010000000700000001000000
92030000010000000700000001000000
92c0000080000000e000000080000000
92030000010000000700000001000000
92030000010000000700000001000000
92c0000080000000e000000080000000
92030000010000000700000001000000
92c0000080000000e000000080000000
-
{e=>-1,a=>-1,d=>0,j=>-1,c=>1,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
ff020000020000000700000001000000
ff020000020000000700000001000000
ff020000020000000700000001000000
ff40000040000000e000000080000000
ff020000020000000700000001000000
ff020000020000000700000001000000
ff40000040000000e000000080000000
ff020000020000000700000001000000
ff40000040000000e000000080000000
-
{e=>0,a=>-47,d=>0,j=>-1,c=>1,h=>0,b=>1,g=>0,f=>0,i=>-1}
d1030000000000000400000001000000
d1030000000000000400000001000000
d1030000000000000400000001000000
d1c00000000000002000000080000000
d1030000000000000400000001000000
d1030000000000000400000001000000
d1c00000000000002000000080000000
d1030000000000000400000001000000
d1c00000000000002000000080000000
=
struct mixed1 {
  char a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
  long         k;
};
-
{e=>0,a=>-103,d=>1,j=>0,c=>1,k=>81,h=>0,b=>1,g=>0,f=>0,i=>0}
9903000001000000000000000000000051000000
990300000100000000000000000000005100000000000000
990300000100000000000000000000005100000000000000
99c0000080000000000000000000000000000051
9903000001000000000000000000000051000000
9903000001000000000000000000000051000000
99c000008000000000000000000000000000000000000051
9903000001000000000000000000000051000000
99c0000080000000000000000000000000000051
-
{e=>0,a=>5,d=>0,j=>0,c=>1,k=>-43,h=>0,b=>0,g=>0,f=>-1,i=>-1}
05020000040000000400000000000000d5ffffff
05020000040000000400000000000000d5ffffffffffffff
05020000040000000400000000000000d5ffffffffffffff
05400000200000002000000000000000ffffffd5
05020000040000000400000000000000d5ffffff
05020000040000000400000000000000d5ffffff
05400000200000002000000000000000ffffffffffffffd5
05020000040000000400000000000000d5ffffff
05400000200000002000000000000000ffffffd5
-
{e=>0,a=>48,d=>0,j=>0,c=>1,k=>-96,h=>0,b=>0,g=>0,f=>-1,i=>0}
30020000040000000000000000000000a0ffffff
30020000040000000000000000000000a0ffffffffffffff
30020000040000000000000000000000a0ffffffffffffff
30400000200000000000000000000000ffffffa0
30020000040000000000000000000000a0ffffff
30020000040000000000000000000000a0ffffff
30400000200000000000000000000000ffffffffffffffa0
30020000040000000000000000000000a0ffffff
30400000200000000000000000000000ffffffa0
-
{e=>-1,a=>113,d=>0,j=>-1,c=>1,k=>-112,h=>-1,b=>1,g=>0,f=>-1,i=>0}
7103000006000000020000000100000090ffffff
7103000006000000020000000100000090ffffffffffffff
7103000006000000020000000100000090ffffffffffffff
71c00000600000004000000080000000ffffff90
7103000006000000020000000100000090ffffff
7103000006000000020000000100000090ffffff
71c00000600000004000000080000000ffffffffffffff90
7103000006000000020000000100000090ffffff
71c00000600000004000000080000000ffffff90
-
{e=>0,a=>124,d=>1,j=>-1,c=>1,k=>62,h=>0,b=>0,g=>0,f=>-1,i=>0}
7c0200000500000000000000010000003e000000
7c0200000500000000000000010000003e00000000000000
7c0200000500000000000000010000003e00000000000000
7c400000a000000000000000800000000000003e
7c0200000500000000000000010000003e000000
7c0200000500000000000000010000003e000000
7c400000a00000000000000080000000000000000000003e
7c0200000500000000000000010000003e000000
7c400000a000000000000000800000000000003e
=
struct mixed1 {
  short a;
  unsigned int b:1;
};
-
{a=>110,b=>1}
6e000100
6e000100
6e000100
006e8000
6e000100
6e000100
006e8000
6e000100
006e8000
-
{a=>-33,b=>1}
dfff0100
dfff0100
dfff0100
ffdf8000
dfff0100
dfff0100
ffdf8000
dfff0100
ffdf8000
-
{a=>-68,b=>0}
bcff0000
bcff0000
bcff0000
ffbc0000
bcff0000
bcff0000
ffbc0000
bcff0000
ffbc0000
-
{a=>-44,b=>1}
d4ff0100
d4ff0100
d4ff0100
ffd48000
d4ff0100
d4ff0100
ffd48000
d4ff0100
ffd48000
-
{a=>94,b=>0}
5e000000
5e000000
5e000000
005e0000
5e000000
5e000000
005e0000
5e000000
005e0000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
};
-
{c=>1,a=>-20,b=>1}
ecff0300
ecff0300
ecff0300
ffecc000
ecff0300
ecff0300
ffecc000
ecff0300
ffecc000
-
{c=>1,a=>-53,b=>1}
cbff0300
cbff0300
cbff0300
ffcbc000
cbff0300
cbff0300
ffcbc000
cbff0300
ffcbc000
-
{c=>1,a=>123,b=>0}
7b000200
7b000200
7b000200
007b4000
7b000200
7b000200
007b4000
7b000200
007b4000
-
{c=>1,a=>-52,b=>0}
ccff0200
ccff0200
ccff0200
ffcc4000
ccff0200
ccff0200
ffcc4000
ccff0200
ffcc4000
-
{c=>1,a=>93,b=>0}
5d000200
5d000200
5d000200
005d4000
5d000200
5d000200
005d4000
5d000200
005d4000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
};
-
{c=>1,a=>110,b=>0}
6e000200
6e000200
6e000200
006e4000
6e000200
6e000200
006e4000
6e000200
006e4000
-
{c=>0,a=>51,b=>0}
33000000
33000000
33000000
00330000
33000000
33000000
00330000
33000000
00330000
-
{c=>0,a=>118,b=>0}
76000000
76000000
76000000
00760000
76000000
76000000
00760000
76000000
00760000
-
{c=>1,a=>27,b=>1}
1b000300
1b000300
1b000300
001bc000
1b000300
1b000300
001bc000
1b000300
001bc000
-
{c=>0,a=>-97,b=>1}
9fff0100
9fff0100
9fff0100
ff9f8000
9fff0100
9fff0100
ff9f8000
9fff0100
ff9f8000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
};
-
{c=>1,a=>102,b=>1,d=>0}
6600030000000000
6600030000000000
6600030000000000
0066c00000000000
6600030000000000
6600030000000000
0066c00000000000
6600030000000000
0066c00000000000
-
{c=>0,a=>-89,b=>1,d=>0}
a7ff010000000000
a7ff010000000000
a7ff010000000000
ffa7800000000000
a7ff010000000000
a7ff010000000000
ffa7800000000000
a7ff010000000000
ffa7800000000000
-
{c=>1,a=>37,b=>0,d=>0}
2500020000000000
2500020000000000
2500020000000000
0025400000000000
2500020000000000
2500020000000000
0025400000000000
2500020000000000
0025400000000000
-
{c=>1,a=>111,b=>1,d=>0}
6f00030000000000
6f00030000000000
6f00030000000000
006fc00000000000
6f00030000000000
6f00030000000000
006fc00000000000
6f00030000000000
006fc00000000000
-
{c=>0,a=>33,b=>0,d=>0}
2100000000000000
2100000000000000
2100000000000000
0021000000000000
2100000000000000
2100000000000000
0021000000000000
2100000000000000
0021000000000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
};
-
{e=>0,c=>1,a=>-77,b=>0,d=>0}
b3ff020000000000
b3ff020000000000
b3ff020000000000
ffb3400000000000
b3ff020000000000
b3ff020000000000
ffb3400000000000
b3ff020000000000
ffb3400000000000
-
{e=>-1,c=>0,a=>73,b=>1,d=>1}
4900010003000000
4900010003000000
4900010003000000
00498000c0000000
4900010003000000
4900010003000000
00498000c0000000
4900010003000000
00498000c0000000
-
{e=>-1,c=>0,a=>50,b=>1,d=>0}
3200010002000000
3200010002000000
3200010002000000
0032800040000000
3200010002000000
3200010002000000
0032800040000000
3200010002000000
0032800040000000
-
{e=>0,c=>1,a=>-125,b=>0,d=>1}
83ff020001000000
83ff020001000000
83ff020001000000
ff83400080000000
83ff020001000000
83ff020001000000
ff83400080000000
83ff020001000000
ff83400080000000
-
{e=>0,c=>0,a=>55,b=>1,d=>0}
3700010000000000
3700010000000000
3700010000000000
0037800000000000
3700010000000000
3700010000000000
0037800000000000
3700010000000000
0037800000000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
};
-
{e=>0,c=>1,a=>-25,b=>1,d=>1,f=>-1}
e7ff030005000000
e7ff030005000000
e7ff030005000000
ffe7c000a0000000
e7ff030005000000
e7ff030005000000
ffe7c000a0000000
e7ff030005000000
ffe7c000a0000000
-
{e=>0,c=>0,a=>110,b=>0,d=>0,f=>-1}
6e00000004000000
6e00000004000000
6e00000004000000
006e000020000000
6e00000004000000
6e00000004000000
006e000020000000
6e00000004000000
006e000020000000
-
{e=>0,c=>0,a=>-28,b=>1,d=>0,f=>0}
e4ff010000000000
e4ff010000000000
e4ff010000000000
ffe4800000000000
e4ff010000000000
e4ff010000000000
ffe4800000000000
e4ff010000000000
ffe4800000000000
-
{e=>0,c=>1,a=>38,b=>1,d=>1,f=>0}
2600030001000000
2600030001000000
2600030001000000
0026c00080000000
2600030001000000
2600030001000000
0026c00080000000
2600030001000000
0026c00080000000
-
{e=>-1,c=>0,a=>38,b=>0,d=>1,f=>-1}
2600000007000000
2600000007000000
2600000007000000
00260000e0000000
2600000007000000
2600000007000000
00260000e0000000
2600000007000000
00260000e0000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
};
-
{e=>0,c=>0,a=>-35,b=>1,d=>1,f=>-1}
ddff010005000000
ddff010005000000
ddff010005000000
ffdd8000a0000000
ddff010005000000
ddff010005000000
ffdd8000a0000000
ddff010005000000
ffdd8000a0000000
-
{e=>0,c=>0,a=>-82,b=>0,d=>0,f=>0}
aeff000000000000
aeff000000000000
aeff000000000000
ffae000000000000
aeff000000000000
aeff000000000000
ffae000000000000
aeff000000000000
ffae000000000000
-
{e=>0,c=>0,a=>-124,b=>1,d=>0,f=>0}
84ff010000000000
84ff010000000000
84ff010000000000
ff84800000000000
84ff010000000000
84ff010000000000
ff84800000000000
84ff010000000000
ff84800000000000
-
{e=>0,c=>0,a=>-50,b=>0,d=>1,f=>0}
ceff000001000000
ceff000001000000
ceff000001000000
ffce000080000000
ceff000001000000
ceff000001000000
ffce000080000000
ceff000001000000
ffce000080000000
-
{e=>-1,c=>1,a=>-121,b=>0,d=>0,f=>-1}
87ff020006000000
87ff020006000000
87ff020006000000
ff87400060000000
87ff020006000000
87ff020006000000
ff87400060000000
87ff020006000000
ff87400060000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
};
-
{e=>-1,c=>1,a=>39,g=>0,b=>1,d=>1,f=>0}
270003000300000000000000
270003000300000000000000
270003000300000000000000
0027c000c000000000000000
270003000300000000000000
270003000300000000000000
0027c000c000000000000000
270003000300000000000000
0027c000c000000000000000
-
{e=>-1,c=>0,a=>-21,g=>0,b=>0,d=>0,f=>0}
ebff00000200000000000000
ebff00000200000000000000
ebff00000200000000000000
ffeb00004000000000000000
ebff00000200000000000000
ebff00000200000000000000
ffeb00004000000000000000
ebff00000200000000000000
ffeb00004000000000000000
-
{e=>-1,c=>1,a=>-9,g=>-1,b=>1,d=>0,f=>0}
f7ff03000200000001000000
f7ff03000200000001000000
f7ff03000200000001000000
fff7c0004000000080000000
f7ff03000200000001000000
f7ff03000200000001000000
fff7c0004000000080000000
f7ff03000200000001000000
fff7c0004000000080000000
-
{e=>0,c=>0,a=>39,g=>-1,b=>0,d=>1,f=>0}
270000000100000001000000
270000000100000001000000
270000000100000001000000
002700008000000080000000
270000000100000001000000
270000000100000001000000
002700008000000080000000
270000000100000001000000
002700008000000080000000
-
{e=>0,c=>0,a=>-23,g=>0,b=>1,d=>1,f=>0}
e9ff01000100000000000000
e9ff01000100000000000000
e9ff01000100000000000000
ffe980008000000000000000
e9ff01000100000000000000
e9ff01000100000000000000
ffe980008000000000000000
e9ff01000100000000000000
ffe980008000000000000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
};
-
{e=>-1,a=>-109,d=>1,c=>1,h=>0,b=>0,g=>0,f=>-1}
93ff02000700000000000000
93ff02000700000000000000
93ff02000700000000000000
ff934000e000000000000000
93ff02000700000000000000
93ff02000700000000000000
ff934000e000000000000000
93ff02000700000000000000
ff934000e000000000000000
-
{e=>0,a=>113,d=>1,c=>0,h=>-1,b=>0,g=>0,f=>-1}
710000000500000002000000
710000000500000002000000
710000000500000002000000
00710000a000000040000000
710000000500000002000000
710000000500000002000000
00710000a000000040000000
710000000500000002000000
00710000a000000040000000
-
{e=>-1,a=>115,d=>1,c=>0,h=>-1,b=>1,g=>-1,f=>0}
730001000300000003000000
730001000300000003000000
730001000300000003000000
00738000c0000000c0000000
730001000300000003000000
730001000300000003000000
00738000c0000000c0000000
730001000300000003000000
00738000c0000000c0000000
-
{e=>0,a=>86,d=>1,c=>0,h=>0,b=>0,g=>0,f=>0}
560000000100000000000000
560000000100000000000000
560000000100000000000000
005600008000000000000000
560000000100000000000000
560000000100000000000000
005600008000000000000000
560000000100000000000000
005600008000000000000000
-
{e=>-1,a=>-14,d=>1,c=>1,h=>-1,b=>1,g=>-1,f=>0}
f2ff03000300000003000000
f2ff03000300000003000000
f2ff03000300000003000000
fff2c000c0000000c0000000
f2ff03000300000003000000
f2ff03000300000003000000
fff2c000c0000000c0000000
f2ff03000300000003000000
fff2c000c0000000c0000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
};
-
{e=>-1,a=>97,d=>1,c=>0,h=>-1,b=>0,g=>-1,f=>0,i=>0}
610000000300000003000000
610000000300000003000000
610000000300000003000000
00610000c0000000c0000000
610000000300000003000000
610000000300000003000000
00610000c0000000c0000000
610000000300000003000000
00610000c0000000c0000000
-
{e=>0,a=>-1,d=>0,c=>0,h=>-1,b=>1,g=>0,f=>0,i=>0}
ffff01000000000002000000
ffff01000000000002000000
ffff01000000000002000000
ffff80000000000040000000
ffff01000000000002000000
ffff01000000000002000000
ffff80000000000040000000
ffff01000000000002000000
ffff80000000000040000000
-
{e=>-1,a=>62,d=>1,c=>0,h=>0,b=>0,g=>-1,f=>0,i=>-1}
3e0000000300000005000000
3e0000000300000005000000
3e0000000300000005000000
003e0000c0000000a0000000
3e0000000300000005000000
3e0000000300000005000000
003e0000c0000000a0000000
3e0000000300000005000000
003e0000c0000000a0000000
-
{e=>0,a=>-110,d=>0,c=>0,h=>-1,b=>1,g=>0,f=>0,i=>-1}
92ff01000000000006000000
92ff01000000000006000000
92ff01000000000006000000
ff9280000000000060000000
92ff01000000000006000000
92ff01000000000006000000
ff9280000000000060000000
92ff01000000000006000000
ff9280000000000060000000
-
{e=>0,a=>-40,d=>1,c=>0,h=>-1,b=>0,g=>0,f=>-1,i=>0}
d8ff00000500000002000000
d8ff00000500000002000000
d8ff00000500000002000000
ffd80000a000000040000000
d8ff00000500000002000000
d8ff00000500000002000000
ffd80000a000000040000000
d8ff00000500000002000000
ffd80000a000000040000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
};
-
{e=>-1,a=>-48,d=>0,c=>1,h=>0,b=>0,g=>0,f=>0,i=>0}
d0ff02000200000000000000
d0ff02000200000000000000
d0ff02000200000000000000
ffd040004000000000000000
d0ff02000200000000000000
d0ff02000200000000000000
ffd040004000000000000000
d0ff02000200000000000000
ffd040004000000000000000
-
{e=>0,a=>27,d=>1,c=>0,h=>0,b=>0,g=>-1,f=>-1,i=>-1}
1b0000000500000005000000
1b0000000500000005000000
1b0000000500000005000000
001b0000a0000000a0000000
1b0000000500000005000000
1b0000000500000005000000
001b0000a0000000a0000000
1b0000000500000005000000
001b0000a0000000a0000000
-
{e=>0,a=>47,d=>1,c=>0,h=>-1,b=>1,g=>0,f=>0,i=>-1}
2f0001000100000006000000
2f0001000100000006000000
2f0001000100000006000000
002f80008000000060000000
2f0001000100000006000000
2f0001000100000006000000
002f80008000000060000000
2f0001000100000006000000
002f80008000000060000000
-
{e=>-1,a=>24,d=>0,c=>1,h=>-1,b=>1,g=>-1,f=>-1,i=>-1}
180003000600000007000000
180003000600000007000000
180003000600000007000000
0018c00060000000e0000000
180003000600000007000000
180003000600000007000000
0018c00060000000e0000000
180003000600000007000000
0018c00060000000e0000000
-
{e=>0,a=>-105,d=>1,c=>1,h=>-1,b=>0,g=>-1,f=>0,i=>0}
97ff02000100000003000000
97ff02000100000003000000
97ff02000100000003000000
ff97400080000000c0000000
97ff02000100000003000000
97ff02000100000003000000
ff97400080000000c0000000
97ff02000100000003000000
ff97400080000000c0000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
};
-
{e=>-1,a=>-24,d=>0,j=>0,c=>1,h=>0,b=>0,g=>0,f=>0,i=>0}
e8ff0200020000000000000000000000
e8ff0200020000000000000000000000
e8ff0200020000000000000000000000
ffe84000400000000000000000000000
e8ff0200020000000000000000000000
e8ff0200020000000000000000000000
ffe84000400000000000000000000000
e8ff0200020000000000000000000000
ffe84000400000000000000000000000
-
{e=>-1,a=>-22,d=>0,j=>0,c=>1,h=>0,b=>0,g=>-1,f=>0,i=>0}
eaff0200020000000100000000000000
eaff0200020000000100000000000000
eaff0200020000000100000000000000
ffea4000400000008000000000000000
eaff0200020000000100000000000000
eaff0200020000000100000000000000
ffea4000400000008000000000000000
eaff0200020000000100000000000000
ffea4000400000008000000000000000
-
{e=>0,a=>-38,d=>0,j=>-1,c=>0,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
daff0100040000000300000001000000
daff0100040000000300000001000000
daff0100040000000300000001000000
ffda800020000000c000000080000000
daff0100040000000300000001000000
daff0100040000000300000001000000
ffda800020000000c000000080000000
daff0100040000000300000001000000
ffda800020000000c000000080000000
-
{e=>0,a=>72,d=>1,j=>0,c=>1,h=>-1,b=>1,g=>0,f=>-1,i=>0}
48000300050000000200000000000000
48000300050000000200000000000000
48000300050000000200000000000000
0048c000a00000004000000000000000
48000300050000000200000000000000
48000300050000000200000000000000
0048c000a00000004000000000000000
48000300050000000200000000000000
0048c000a00000004000000000000000
-
{e=>0,a=>-62,d=>0,j=>0,c=>0,h=>0,b=>1,g=>-1,f=>-1,i=>0}
c2ff0100040000000100000000000000
c2ff0100040000000100000000000000
c2ff0100040000000100000000000000
ffc28000200000008000000000000000
c2ff0100040000000100000000000000
c2ff0100040000000100000000000000
ffc28000200000008000000000000000
c2ff0100040000000100000000000000
ffc28000200000008000000000000000
=
struct mixed1 {
  short a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
  long         k;
};
-
{e=>-1,a=>29,d=>0,j=>-1,c=>1,k=>-52,h=>-1,b=>1,g=>0,f=>0,i=>0}
1d000300020000000200000001000000ccffffff
1d000300020000000200000001000000ccffffffffffffff
1d000300020000000200000001000000ccffffffffffffff
001dc000400000004000000080000000ffffffcc
1d000300020000000200000001000000ccffffff
1d000300020000000200000001000000ccffffff
001dc000400000004000000080000000ffffffffffffffcc
1d000300020000000200000001000000ccffffff
001dc000400000004000000080000000ffffffcc
-
{e=>0,a=>71,d=>0,j=>-1,c=>0,k=>11,h=>0,b=>0,g=>0,f=>0,i=>-1}
470000000000000004000000010000000b000000
470000000000000004000000010000000b00000000000000
470000000000000004000000010000000b00000000000000
004700000000000020000000800000000000000b
470000000000000004000000010000000b000000
470000000000000004000000010000000b000000
00470000000000002000000080000000000000000000000b
470000000000000004000000010000000b000000
004700000000000020000000800000000000000b
-
{e=>-1,a=>7,d=>0,j=>0,c=>0,k=>101,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
0700000002000000070000000000000065000000
070000000200000007000000000000006500000000000000
070000000200000007000000000000006500000000000000
0007000040000000e00000000000000000000065
0700000002000000070000000000000065000000
0700000002000000070000000000000065000000
0007000040000000e0000000000000000000000000000065
0700000002000000070000000000000065000000
0007000040000000e00000000000000000000065
-
{e=>-1,a=>-19,d=>1,j=>0,c=>0,k=>8,h=>-1,b=>1,g=>0,f=>0,i=>-1}
edff010003000000060000000000000008000000
edff01000300000006000000000000000800000000000000
edff01000300000006000000000000000800000000000000
ffed8000c0000000600000000000000000000008
edff010003000000060000000000000008000000
edff010003000000060000000000000008000000
ffed8000c000000060000000000000000000000000000008
edff010003000000060000000000000008000000
ffed8000c0000000600000000000000000000008
-
{e=>-1,a=>71,d=>1,j=>0,c=>0,k=>-64,h=>0,b=>1,g=>-1,f=>-1,i=>-1}
47000100070000000500000000000000c0ffffff
47000100070000000500000000000000c0ffffffffffffff
47000100070000000500000000000000c0ffffffffffffff
00478000e0000000a000000000000000ffffffc0
47000100070000000500000000000000c0ffffff
47000100070000000500000000000000c0ffffff
00478000e0000000a000000000000000ffffffffffffffc0
47000100070000000500000000000000c0ffffff
00478000e0000000a000000000000000ffffffc0
=
struct mixed1 {
  int a;
  unsigned int b:1;
};
-
{a=>-120,b=>0}
88ffffff00000000
88ffffff00000000
88ffffff00000000
ffffff8800000000
88ffffff00000000
88ffffff00000000
ffffff8800000000
88ffffff00000000
ffffff8800000000
-
{a=>-74,b=>1}
b6ffffff01000000
b6ffffff01000000
b6ffffff01000000
ffffffb680000000
b6ffffff01000000
b6ffffff01000000
ffffffb680000000
b6ffffff01000000
ffffffb680000000
-
{a=>-4,b=>1}
fcffffff01000000
fcffffff01000000
fcffffff01000000
fffffffc80000000
fcffffff01000000
fcffffff01000000
fffffffc80000000
fcffffff01000000
fffffffc80000000
-
{a=>-89,b=>0}
a7ffffff00000000
a7ffffff00000000
a7ffffff00000000
ffffffa700000000
a7ffffff00000000
a7ffffff00000000
ffffffa700000000
a7ffffff00000000
ffffffa700000000
-
{a=>95,b=>0}
5f00000000000000
5f00000000000000
5f00000000000000
0000005f00000000
5f00000000000000
5f00000000000000
0000005f00000000
5f00000000000000
0000005f00000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
};
-
{c=>0,a=>124,b=>1}
7c00000001000000
7c00000001000000
7c00000001000000
0000007c80000000
7c00000001000000
7c00000001000000
0000007c80000000
7c00000001000000
0000007c80000000
-
{c=>0,a=>97,b=>1}
6100000001000000
6100000001000000
6100000001000000
0000006180000000
6100000001000000
6100000001000000
0000006180000000
6100000001000000
0000006180000000
-
{c=>0,a=>-1,b=>0}
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
ffffffff00000000
-
{c=>0,a=>-59,b=>0}
c5ffffff00000000
c5ffffff00000000
c5ffffff00000000
ffffffc500000000
c5ffffff00000000
c5ffffff00000000
ffffffc500000000
c5ffffff00000000
ffffffc500000000
-
{c=>1,a=>23,b=>1}
1700000003000000
1700000003000000
1700000003000000
00000017c0000000
1700000003000000
1700000003000000
00000017c0000000
1700000003000000
00000017c0000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
};
-
{c=>0,a=>1,b=>0}
0100000000000000
0100000000000000
0100000000000000
0000000100000000
0100000000000000
0100000000000000
0000000100000000
0100000000000000
0000000100000000
-
{c=>0,a=>-43,b=>1}
d5ffffff01000000
d5ffffff01000000
d5ffffff01000000
ffffffd580000000
d5ffffff01000000
d5ffffff01000000
ffffffd580000000
d5ffffff01000000
ffffffd580000000
-
{c=>0,a=>-32,b=>1}
e0ffffff01000000
e0ffffff01000000
e0ffffff01000000
ffffffe080000000
e0ffffff01000000
e0ffffff01000000
ffffffe080000000
e0ffffff01000000
ffffffe080000000
-
{c=>0,a=>-65,b=>1}
bfffffff01000000
bfffffff01000000
bfffffff01000000
ffffffbf80000000
bfffffff01000000
bfffffff01000000
ffffffbf80000000
bfffffff01000000
ffffffbf80000000
-
{c=>0,a=>-14,b=>0}
f2ffffff00000000
f2ffffff00000000
f2ffffff00000000
fffffff200000000
f2ffffff00000000
f2ffffff00000000
fffffff200000000
f2ffffff00000000
fffffff200000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
};
-
{c=>0,a=>89,b=>0,d=>0}
590000000000000000000000
590000000000000000000000
590000000000000000000000
000000590000000000000000
590000000000000000000000
590000000000000000000000
000000590000000000000000
590000000000000000000000
000000590000000000000000
-
{c=>0,a=>-30,b=>0,d=>1}
e2ffffff0000000001000000
e2ffffff0000000001000000
e2ffffff0000000001000000
ffffffe20000000080000000
e2ffffff0000000001000000
e2ffffff0000000001000000
ffffffe20000000080000000
e2ffffff0000000001000000
ffffffe20000000080000000
-
{c=>1,a=>-6,b=>0,d=>0}
faffffff0200000000000000
faffffff0200000000000000
faffffff0200000000000000
fffffffa4000000000000000
faffffff0200000000000000
faffffff0200000000000000
fffffffa4000000000000000
faffffff0200000000000000
fffffffa4000000000000000
-
{c=>1,a=>-16,b=>1,d=>0}
f0ffffff0300000000000000
f0ffffff0300000000000000
f0ffffff0300000000000000
fffffff0c000000000000000
f0ffffff0300000000000000
f0ffffff0300000000000000
fffffff0c000000000000000
f0ffffff0300000000000000
fffffff0c000000000000000
-
{c=>0,a=>94,b=>1,d=>1}
5e0000000100000001000000
5e0000000100000001000000
5e0000000100000001000000
0000005e8000000080000000
5e0000000100000001000000
5e0000000100000001000000
0000005e8000000080000000
5e0000000100000001000000
0000005e8000000080000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
};
-
{e=>-1,c=>0,a=>-26,b=>1,d=>1}
e6ffffff0100000003000000
e6ffffff0100000003000000
e6ffffff0100000003000000
ffffffe680000000c0000000
e6ffffff0100000003000000
e6ffffff0100000003000000
ffffffe680000000c0000000
e6ffffff0100000003000000
ffffffe680000000c0000000
-
{e=>0,c=>0,a=>-38,b=>1,d=>0}
daffffff0100000000000000
daffffff0100000000000000
daffffff0100000000000000
ffffffda8000000000000000
daffffff0100000000000000
daffffff0100000000000000
ffffffda8000000000000000
daffffff0100000000000000
ffffffda8000000000000000
-
{e=>-1,c=>1,a=>82,b=>1,d=>1}
520000000300000003000000
520000000300000003000000
520000000300000003000000
00000052c0000000c0000000
520000000300000003000000
520000000300000003000000
00000052c0000000c0000000
520000000300000003000000
00000052c0000000c0000000
-
{e=>-1,c=>1,a=>-3,b=>1,d=>0}
fdffffff0300000002000000
fdffffff0300000002000000
fdffffff0300000002000000
fffffffdc000000040000000
fdffffff0300000002000000
fdffffff0300000002000000
fffffffdc000000040000000
fdffffff0300000002000000
fffffffdc000000040000000
-
{e=>-1,c=>1,a=>104,b=>0,d=>1}
680000000200000003000000
680000000200000003000000
680000000200000003000000
0000006840000000c0000000
680000000200000003000000
680000000200000003000000
0000006840000000c0000000
680000000200000003000000
0000006840000000c0000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
};
-
{e=>-1,c=>0,a=>-49,b=>0,d=>1,f=>0}
cfffffff0000000003000000
cfffffff0000000003000000
cfffffff0000000003000000
ffffffcf00000000c0000000
cfffffff0000000003000000
cfffffff0000000003000000
ffffffcf00000000c0000000
cfffffff0000000003000000
ffffffcf00000000c0000000
-
{e=>-1,c=>1,a=>-85,b=>0,d=>1,f=>-1}
abffffff0200000007000000
abffffff0200000007000000
abffffff0200000007000000
ffffffab40000000e0000000
abffffff0200000007000000
abffffff0200000007000000
ffffffab40000000e0000000
abffffff0200000007000000
ffffffab40000000e0000000
-
{e=>0,c=>1,a=>-109,b=>0,d=>0,f=>0}
93ffffff0200000000000000
93ffffff0200000000000000
93ffffff0200000000000000
ffffff934000000000000000
93ffffff0200000000000000
93ffffff0200000000000000
ffffff934000000000000000
93ffffff0200000000000000
ffffff934000000000000000
-
{e=>0,c=>0,a=>109,b=>0,d=>0,f=>0}
6d0000000000000000000000
6d0000000000000000000000
6d0000000000000000000000
0000006d0000000000000000
6d0000000000000000000000
6d0000000000000000000000
0000006d0000000000000000
6d0000000000000000000000
0000006d0000000000000000
-
{e=>0,c=>1,a=>-3,b=>0,d=>0,f=>0}
fdffffff0200000000000000
fdffffff0200000000000000
fdffffff0200000000000000
fffffffd4000000000000000
fdffffff0200000000000000
fdffffff0200000000000000
fffffffd4000000000000000
fdffffff0200000000000000
fffffffd4000000000000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
};
-
{e=>0,c=>0,a=>-89,b=>0,d=>0,f=>-1}
a7ffffff0000000004000000
a7ffffff0000000004000000
a7ffffff0000000004000000
ffffffa70000000020000000
a7ffffff0000000004000000
a7ffffff0000000004000000
ffffffa70000000020000000
a7ffffff0000000004000000
ffffffa70000000020000000
-
{e=>-1,c=>0,a=>-6,b=>1,d=>1,f=>0}
faffffff0100000003000000
faffffff0100000003000000
faffffff0100000003000000
fffffffa80000000c0000000
faffffff0100000003000000
faffffff0100000003000000
fffffffa80000000c0000000
faffffff0100000003000000
fffffffa80000000c0000000
-
{e=>0,c=>0,a=>-60,b=>0,d=>1,f=>0}
c4ffffff0000000001000000
c4ffffff0000000001000000
c4ffffff0000000001000000
ffffffc40000000080000000
c4ffffff0000000001000000
c4ffffff0000000001000000
ffffffc40000000080000000
c4ffffff0000000001000000
ffffffc40000000080000000
-
{e=>-1,c=>1,a=>-65,b=>0,d=>1,f=>0}
bfffffff0200000003000000
bfffffff0200000003000000
bfffffff0200000003000000
ffffffbf40000000c0000000
bfffffff0200000003000000
bfffffff0200000003000000
ffffffbf40000000c0000000
bfffffff0200000003000000
ffffffbf40000000c0000000
-
{e=>0,c=>0,a=>-92,b=>0,d=>0,f=>-1}
a4ffffff0000000004000000
a4ffffff0000000004000000
a4ffffff0000000004000000
ffffffa40000000020000000
a4ffffff0000000004000000
a4ffffff0000000004000000
ffffffa40000000020000000
a4ffffff0000000004000000
ffffffa40000000020000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
};
-
{e=>0,c=>1,a=>23,g=>0,b=>0,d=>0,f=>0}
17000000020000000000000000000000
17000000020000000000000000000000
17000000020000000000000000000000
00000017400000000000000000000000
17000000020000000000000000000000
17000000020000000000000000000000
00000017400000000000000000000000
17000000020000000000000000000000
00000017400000000000000000000000
-
{e=>0,c=>0,a=>-110,g=>-1,b=>1,d=>1,f=>0}
92ffffff010000000100000001000000
92ffffff010000000100000001000000
92ffffff010000000100000001000000
ffffff92800000008000000080000000
92ffffff010000000100000001000000
92ffffff010000000100000001000000
ffffff92800000008000000080000000
92ffffff010000000100000001000000
ffffff92800000008000000080000000
-
{e=>0,c=>1,a=>6,g=>0,b=>0,d=>1,f=>-1}
06000000020000000500000000000000
06000000020000000500000000000000
06000000020000000500000000000000
0000000640000000a000000000000000
06000000020000000500000000000000
06000000020000000500000000000000
0000000640000000a000000000000000
06000000020000000500000000000000
0000000640000000a000000000000000
-
{e=>-1,c=>0,a=>-15,g=>-1,b=>0,d=>1,f=>0}
f1ffffff000000000300000001000000
f1ffffff000000000300000001000000
f1ffffff000000000300000001000000
fffffff100000000c000000080000000
f1ffffff000000000300000001000000
f1ffffff000000000300000001000000
fffffff100000000c000000080000000
f1ffffff000000000300000001000000
fffffff100000000c000000080000000
-
{e=>-1,c=>1,a=>-105,g=>-1,b=>1,d=>1,f=>-1}
97ffffff030000000700000001000000
97ffffff030000000700000001000000
97ffffff030000000700000001000000
ffffff97c0000000e000000080000000
97ffffff030000000700000001000000
97ffffff030000000700000001000000
ffffff97c0000000e000000080000000
97ffffff030000000700000001000000
ffffff97c0000000e000000080000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
};
-
{e=>-1,a=>-67,d=>0,c=>1,h=>-1,b=>1,g=>-1,f=>-1}
bdffffff030000000600000003000000
bdffffff030000000600000003000000
bdffffff030000000600000003000000
ffffffbdc000000060000000c0000000
bdffffff030000000600000003000000
bdffffff030000000600000003000000
ffffffbdc000000060000000c0000000
bdffffff030000000600000003000000
ffffffbdc000000060000000c0000000
-
{e=>0,a=>16,d=>0,c=>1,h=>0,b=>0,g=>-1,f=>-1}
10000000020000000400000001000000
10000000020000000400000001000000
10000000020000000400000001000000
00000010400000002000000080000000
10000000020000000400000001000000
10000000020000000400000001000000
00000010400000002000000080000000
10000000020000000400000001000000
00000010400000002000000080000000
-
{e=>0,a=>75,d=>0,c=>0,h=>0,b=>0,g=>0,f=>-1}
4b000000000000000400000000000000
4b000000000000000400000000000000
4b000000000000000400000000000000
0000004b000000002000000000000000
4b000000000000000400000000000000
4b000000000000000400000000000000
0000004b000000002000000000000000
4b000000000000000400000000000000
0000004b000000002000000000000000
-
{e=>-1,a=>-78,d=>0,c=>1,h=>0,b=>1,g=>-1,f=>0}
b2ffffff030000000200000001000000
b2ffffff030000000200000001000000
b2ffffff030000000200000001000000
ffffffb2c00000004000000080000000
b2ffffff030000000200000001000000
b2ffffff030000000200000001000000
ffffffb2c00000004000000080000000
b2ffffff030000000200000001000000
ffffffb2c00000004000000080000000
-
{e=>0,a=>50,d=>1,c=>1,h=>0,b=>1,g=>0,f=>0}
32000000030000000100000000000000
32000000030000000100000000000000
32000000030000000100000000000000
00000032c00000008000000000000000
32000000030000000100000000000000
32000000030000000100000000000000
00000032c00000008000000000000000
32000000030000000100000000000000
00000032c00000008000000000000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
};
-
{e=>0,a=>45,d=>0,c=>1,h=>0,b=>0,g=>-1,f=>-1,i=>-1}
2d000000020000000400000005000000
2d000000020000000400000005000000
2d000000020000000400000005000000
0000002d4000000020000000a0000000
2d000000020000000400000005000000
2d000000020000000400000005000000
0000002d4000000020000000a0000000
2d000000020000000400000005000000
0000002d4000000020000000a0000000
-
{e=>0,a=>-65,d=>1,c=>1,h=>-1,b=>0,g=>-1,f=>-1,i=>0}
bfffffff020000000500000003000000
bfffffff020000000500000003000000
bfffffff020000000500000003000000
ffffffbf40000000a0000000c0000000
bfffffff020000000500000003000000
bfffffff020000000500000003000000
ffffffbf40000000a0000000c0000000
bfffffff020000000500000003000000
ffffffbf40000000a0000000c0000000
-
{e=>-1,a=>5,d=>0,c=>1,h=>0,b=>1,g=>0,f=>-1,i=>0}
05000000030000000600000000000000
05000000030000000600000000000000
05000000030000000600000000000000
00000005c00000006000000000000000
05000000030000000600000000000000
05000000030000000600000000000000
00000005c00000006000000000000000
05000000030000000600000000000000
00000005c00000006000000000000000
-
{e=>-1,a=>53,d=>1,c=>0,h=>-1,b=>1,g=>0,f=>-1,i=>-1}
35000000010000000700000006000000
35000000010000000700000006000000
35000000010000000700000006000000
0000003580000000e000000060000000
35000000010000000700000006000000
35000000010000000700000006000000
0000003580000000e000000060000000
35000000010000000700000006000000
0000003580000000e000000060000000
-
{e=>-1,a=>-98,d=>0,c=>1,h=>-1,b=>1,g=>0,f=>0,i=>-1}
9effffff030000000200000006000000
9effffff030000000200000006000000
9effffff030000000200000006000000
ffffff9ec00000004000000060000000
9effffff030000000200000006000000
9effffff030000000200000006000000
ffffff9ec00000004000000060000000
9effffff030000000200000006000000
ffffff9ec00000004000000060000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
};
-
{e=>0,a=>79,d=>0,c=>0,h=>-1,b=>1,g=>-1,f=>0,i=>0}
4f000000010000000000000003000000
4f000000010000000000000003000000
4f000000010000000000000003000000
0000004f8000000000000000c0000000
4f000000010000000000000003000000
4f000000010000000000000003000000
0000004f8000000000000000c0000000
4f000000010000000000000003000000
0000004f8000000000000000c0000000
-
{e=>0,a=>-115,d=>1,c=>0,h=>0,b=>1,g=>0,f=>-1,i=>-1}
8dffffff010000000500000004000000
8dffffff010000000500000004000000
8dffffff010000000500000004000000
ffffff8d80000000a000000020000000
8dffffff010000000500000004000000
8dffffff010000000500000004000000
ffffff8d80000000a000000020000000
8dffffff010000000500000004000000
ffffff8d80000000a000000020000000
-
{e=>-1,a=>-69,d=>0,c=>1,h=>-1,b=>1,g=>-1,f=>0,i=>0}
bbffffff030000000200000003000000
bbffffff030000000200000003000000
bbffffff030000000200000003000000
ffffffbbc000000040000000c0000000
bbffffff030000000200000003000000
bbffffff030000000200000003000000
ffffffbbc000000040000000c0000000
bbffffff030000000200000003000000
ffffffbbc000000040000000c0000000
-
{e=>-1,a=>0,d=>0,c=>1,h=>0,b=>1,g=>-1,f=>0,i=>-1}
00000000030000000200000005000000
00000000030000000200000005000000
00000000030000000200000005000000
00000000c000000040000000a0000000
00000000030000000200000005000000
00000000030000000200000005000000
00000000c000000040000000a0000000
00000000030000000200000005000000
00000000c000000040000000a0000000
-
{e=>-1,a=>34,d=>1,c=>1,h=>0,b=>1,g=>0,f=>-1,i=>-1}
22000000030000000700000004000000
22000000030000000700000004000000
22000000030000000700000004000000
00000022c0000000e000000020000000
22000000030000000700000004000000
22000000030000000700000004000000
00000022c0000000e000000020000000
22000000030000000700000004000000
00000022c0000000e000000020000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
};
-
{e=>0,a=>67,d=>0,j=>0,c=>1,h=>0,b=>1,g=>0,f=>-1,i=>0}
4300000003000000040000000000000000000000
4300000003000000040000000000000000000000
4300000003000000040000000000000000000000
00000043c0000000200000000000000000000000
4300000003000000040000000000000000000000
4300000003000000040000000000000000000000
00000043c0000000200000000000000000000000
4300000003000000040000000000000000000000
00000043c0000000200000000000000000000000
-
{e=>0,a=>23,d=>0,j=>-1,c=>1,h=>0,b=>0,g=>-1,f=>-1,i=>-1}
1700000002000000040000000500000001000000
1700000002000000040000000500000001000000
1700000002000000040000000500000001000000
000000174000000020000000a000000080000000
1700000002000000040000000500000001000000
1700000002000000040000000500000001000000
000000174000000020000000a000000080000000
1700000002000000040000000500000001000000
000000174000000020000000a000000080000000
-
{e=>0,a=>89,d=>0,j=>0,c=>0,h=>-1,b=>0,g=>-1,f=>-1,i=>0}
5900000000000000040000000300000000000000
5900000000000000040000000300000000000000
5900000000000000040000000300000000000000
000000590000000020000000c000000000000000
5900000000000000040000000300000000000000
5900000000000000040000000300000000000000
000000590000000020000000c000000000000000
5900000000000000040000000300000000000000
000000590000000020000000c000000000000000
-
{e=>0,a=>-97,d=>0,j=>0,c=>1,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
9fffffff02000000000000000700000000000000
9fffffff02000000000000000700000000000000
9fffffff02000000000000000700000000000000
ffffff9f4000000000000000e000000000000000
9fffffff02000000000000000700000000000000
9fffffff02000000000000000700000000000000
ffffff9f4000000000000000e000000000000000
9fffffff02000000000000000700000000000000
ffffff9f4000000000000000e000000000000000
-
{e=>0,a=>-76,d=>1,j=>-1,c=>0,h=>-1,b=>1,g=>-1,f=>0,i=>0}
b4ffffff01000000010000000300000001000000
b4ffffff01000000010000000300000001000000
b4ffffff01000000010000000300000001000000
ffffffb48000000080000000c000000080000000
b4ffffff01000000010000000300000001000000
b4ffffff01000000010000000300000001000000
ffffffb48000000080000000c000000080000000
b4ffffff01000000010000000300000001000000
ffffffb48000000080000000c000000080000000
=
struct mixed1 {
  int a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
  long         k;
};
-
{e=>0,a=>-74,d=>1,j=>0,c=>1,k=>96,h=>0,b=>1,g=>-1,f=>0,i=>0}
b6ffffff0300000001000000010000000000000060000000
b6ffffff03000000010000000100000000000000000000006000000000000000
b6ffffff03000000010000000100000000000000000000006000000000000000
ffffffb6c000000080000000800000000000000000000060
b6ffffff0300000001000000010000000000000060000000
b6ffffff0300000001000000010000000000000060000000
ffffffb6c0000000800000008000000000000000000000000000000000000060
b6ffffff0300000001000000010000000000000060000000
ffffffb6c000000080000000800000000000000000000060
-
{e=>0,a=>89,d=>1,j=>0,c=>0,k=>-51,h=>0,b=>0,g=>-1,f=>0,i=>-1}
5900000000000000010000000500000000000000cdffffff
590000000000000001000000050000000000000000000000cdffffffffffffff
590000000000000001000000050000000000000000000000cdffffffffffffff
000000590000000080000000a000000000000000ffffffcd
5900000000000000010000000500000000000000cdffffff
5900000000000000010000000500000000000000cdffffff
000000590000000080000000a00000000000000000000000ffffffffffffffcd
5900000000000000010000000500000000000000cdffffff
000000590000000080000000a000000000000000ffffffcd
-
{e=>-1,a=>48,d=>0,j=>0,c=>0,k=>116,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
300000000000000002000000070000000000000074000000
3000000000000000020000000700000000000000000000007400000000000000
3000000000000000020000000700000000000000000000007400000000000000
000000300000000040000000e00000000000000000000074
300000000000000002000000070000000000000074000000
300000000000000002000000070000000000000074000000
000000300000000040000000e000000000000000000000000000000000000074
300000000000000002000000070000000000000074000000
000000300000000040000000e00000000000000000000074
-
{e=>0,a=>-74,d=>0,j=>0,c=>1,k=>59,h=>0,b=>1,g=>0,f=>-1,i=>0}
b6ffffff030000000400000000000000000000003b000000
b6ffffff03000000040000000000000000000000000000003b00000000000000
b6ffffff03000000040000000000000000000000000000003b00000000000000
ffffffb6c00000002000000000000000000000000000003b
b6ffffff030000000400000000000000000000003b000000
b6ffffff030000000400000000000000000000003b000000
ffffffb6c000000020000000000000000000000000000000000000000000003b
b6ffffff030000000400000000000000000000003b000000
ffffffb6c00000002000000000000000000000000000003b
-
{e=>-1,a=>63,d=>1,j=>-1,c=>0,k=>49,h=>0,b=>0,g=>-1,f=>0,i=>0}
3f0000000000000003000000010000000100000031000000
3f00000000000000030000000100000001000000000000003100000000000000
3f00000000000000030000000100000001000000000000003100000000000000
0000003f00000000c0000000800000008000000000000031
3f0000000000000003000000010000000100000031000000
3f0000000000000003000000010000000100000031000000
0000003f00000000c00000008000000080000000000000000000000000000031
3f0000000000000003000000010000000100000031000000
0000003f00000000c0000000800000008000000000000031
=
struct mixed1 {
  long a;
  unsigned int b:1;
};
-
{a=>-77,b=>1}
b3ffffff01000000
b3ffffffffffffff0100000000000000
b3ffffffffffffff0100000000000000
ffffffb380000000
b3ffffff01000000
b3ffffff01000000
ffffffffffffffb38000000000000000
b3ffffff01000000
ffffffb380000000
-
{a=>-4,b=>0}
fcffffff00000000
fcffffffffffffff0000000000000000
fcffffffffffffff0000000000000000
fffffffc00000000
fcffffff00000000
fcffffff00000000
fffffffffffffffc0000000000000000
fcffffff00000000
fffffffc00000000
-
{a=>106,b=>1}
6a00000001000000
6a000000000000000100000000000000
6a000000000000000100000000000000
0000006a80000000
6a00000001000000
6a00000001000000
000000000000006a8000000000000000
6a00000001000000
0000006a80000000
-
{a=>-44,b=>1}
d4ffffff01000000
d4ffffffffffffff0100000000000000
d4ffffffffffffff0100000000000000
ffffffd480000000
d4ffffff01000000
d4ffffff01000000
ffffffffffffffd48000000000000000
d4ffffff01000000
ffffffd480000000
-
{a=>-88,b=>1}
a8ffffff01000000
a8ffffffffffffff0100000000000000
a8ffffffffffffff0100000000000000
ffffffa880000000
a8ffffff01000000
a8ffffff01000000
ffffffffffffffa88000000000000000
a8ffffff01000000
ffffffa880000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
};
-
{c=>0,a=>-69,b=>1}
bbffffff01000000
bbffffffffffffff0100000000000000
bbffffffffffffff0100000000000000
ffffffbb80000000
bbffffff01000000
bbffffff01000000
ffffffffffffffbb8000000000000000
bbffffff01000000
ffffffbb80000000
-
{c=>0,a=>-85,b=>1}
abffffff01000000
abffffffffffffff0100000000000000
abffffffffffffff0100000000000000
ffffffab80000000
abffffff01000000
abffffff01000000
ffffffffffffffab8000000000000000
abffffff01000000
ffffffab80000000
-
{c=>0,a=>33,b=>1}
2100000001000000
21000000000000000100000000000000
21000000000000000100000000000000
0000002180000000
2100000001000000
2100000001000000
00000000000000218000000000000000
2100000001000000
0000002180000000
-
{c=>1,a=>40,b=>1}
2800000003000000
28000000000000000300000000000000
28000000000000000300000000000000
00000028c0000000
2800000003000000
2800000003000000
0000000000000028c000000000000000
2800000003000000
00000028c0000000
-
{c=>0,a=>-14,b=>1}
f2ffffff01000000
f2ffffffffffffff0100000000000000
f2ffffffffffffff0100000000000000
fffffff280000000
f2ffffff01000000
f2ffffff01000000
fffffffffffffff28000000000000000
f2ffffff01000000
fffffff280000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
};
-
{c=>0,a=>-30,b=>0}
e2ffffff00000000
e2ffffffffffffff0000000000000000
e2ffffffffffffff0000000000000000
ffffffe200000000
e2ffffff00000000
e2ffffff00000000
ffffffffffffffe20000000000000000
e2ffffff00000000
ffffffe200000000
-
{c=>0,a=>-60,b=>0}
c4ffffff00000000
c4ffffffffffffff0000000000000000
c4ffffffffffffff0000000000000000
ffffffc400000000
c4ffffff00000000
c4ffffff00000000
ffffffffffffffc40000000000000000
c4ffffff00000000
ffffffc400000000
-
{c=>1,a=>57,b=>0}
3900000002000000
39000000000000000200000000000000
39000000000000000200000000000000
0000003940000000
3900000002000000
3900000002000000
00000000000000394000000000000000
3900000002000000
0000003940000000
-
{c=>1,a=>11,b=>0}
0b00000002000000
0b000000000000000200000000000000
0b000000000000000200000000000000
0000000b40000000
0b00000002000000
0b00000002000000
000000000000000b4000000000000000
0b00000002000000
0000000b40000000
-
{c=>1,a=>-73,b=>1}
b7ffffff03000000
b7ffffffffffffff0300000000000000
b7ffffffffffffff0300000000000000
ffffffb7c0000000
b7ffffff03000000
b7ffffff03000000
ffffffffffffffb7c000000000000000
b7ffffff03000000
ffffffb7c0000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
};
-
{c=>0,a=>-46,b=>0,d=>1}
d2ffffff0000000001000000
d2ffffffffffffff0000000001000000
d2ffffffffffffff0000000001000000
ffffffd20000000080000000
d2ffffff0000000001000000
d2ffffff0000000001000000
ffffffffffffffd20000000080000000
d2ffffff0000000001000000
ffffffd20000000080000000
-
{c=>0,a=>27,b=>0,d=>0}
1b0000000000000000000000
1b000000000000000000000000000000
1b000000000000000000000000000000
0000001b0000000000000000
1b0000000000000000000000
1b0000000000000000000000
000000000000001b0000000000000000
1b0000000000000000000000
0000001b0000000000000000
-
{c=>1,a=>1,b=>1,d=>0}
010000000300000000000000
01000000000000000300000000000000
01000000000000000300000000000000
00000001c000000000000000
010000000300000000000000
010000000300000000000000
0000000000000001c000000000000000
010000000300000000000000
00000001c000000000000000
-
{c=>1,a=>71,b=>0,d=>0}
470000000200000000000000
47000000000000000200000000000000
47000000000000000200000000000000
000000474000000000000000
470000000200000000000000
470000000200000000000000
00000000000000474000000000000000
470000000200000000000000
000000474000000000000000
-
{c=>0,a=>-14,b=>1,d=>1}
f2ffffff0100000001000000
f2ffffffffffffff0100000001000000
f2ffffffffffffff0100000001000000
fffffff28000000080000000
f2ffffff0100000001000000
f2ffffff0100000001000000
fffffffffffffff28000000080000000
f2ffffff0100000001000000
fffffff28000000080000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
};
-
{e=>-1,c=>1,a=>19,b=>0,d=>0}
130000000200000002000000
13000000000000000200000002000000
13000000000000000200000002000000
000000134000000040000000
130000000200000002000000
130000000200000002000000
00000000000000134000000040000000
130000000200000002000000
000000134000000040000000
-
{e=>-1,c=>1,a=>70,b=>0,d=>1}
460000000200000003000000
46000000000000000200000003000000
46000000000000000200000003000000
0000004640000000c0000000
460000000200000003000000
460000000200000003000000
000000000000004640000000c0000000
460000000200000003000000
0000004640000000c0000000
-
{e=>-1,c=>1,a=>-112,b=>1,d=>0}
90ffffff0300000002000000
90ffffffffffffff0300000002000000
90ffffffffffffff0300000002000000
ffffff90c000000040000000
90ffffff0300000002000000
90ffffff0300000002000000
ffffffffffffff90c000000040000000
90ffffff0300000002000000
ffffff90c000000040000000
-
{e=>0,c=>0,a=>90,b=>0,d=>1}
5a0000000000000001000000
5a000000000000000000000001000000
5a000000000000000000000001000000
0000005a0000000080000000
5a0000000000000001000000
5a0000000000000001000000
000000000000005a0000000080000000
5a0000000000000001000000
0000005a0000000080000000
-
{e=>-1,c=>1,a=>-16,b=>1,d=>0}
f0ffffff0300000002000000
f0ffffffffffffff0300000002000000
f0ffffffffffffff0300000002000000
fffffff0c000000040000000
f0ffffff0300000002000000
f0ffffff0300000002000000
fffffffffffffff0c000000040000000
f0ffffff0300000002000000
fffffff0c000000040000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
};
-
{e=>-1,c=>1,a=>92,b=>0,d=>0,f=>-1}
5c0000000200000006000000
5c000000000000000200000006000000
5c000000000000000200000006000000
0000005c4000000060000000
5c0000000200000006000000
5c0000000200000006000000
000000000000005c4000000060000000
5c0000000200000006000000
0000005c4000000060000000
-
{e=>0,c=>1,a=>-112,b=>1,d=>0,f=>0}
90ffffff0300000000000000
90ffffffffffffff0300000000000000
90ffffffffffffff0300000000000000
ffffff90c000000000000000
90ffffff0300000000000000
90ffffff0300000000000000
ffffffffffffff90c000000000000000
90ffffff0300000000000000
ffffff90c000000000000000
-
{e=>-1,c=>0,a=>-75,b=>1,d=>1,f=>0}
b5ffffff0100000003000000
b5ffffffffffffff0100000003000000
b5ffffffffffffff0100000003000000
ffffffb580000000c0000000
b5ffffff0100000003000000
b5ffffff0100000003000000
ffffffffffffffb580000000c0000000
b5ffffff0100000003000000
ffffffb580000000c0000000
-
{e=>0,c=>0,a=>-54,b=>1,d=>1,f=>-1}
caffffff0100000005000000
caffffffffffffff0100000005000000
caffffffffffffff0100000005000000
ffffffca80000000a0000000
caffffff0100000005000000
caffffff0100000005000000
ffffffffffffffca80000000a0000000
caffffff0100000005000000
ffffffca80000000a0000000
-
{e=>0,c=>0,a=>-3,b=>0,d=>0,f=>-1}
fdffffff0000000004000000
fdffffffffffffff0000000004000000
fdffffffffffffff0000000004000000
fffffffd0000000020000000
fdffffff0000000004000000
fdffffff0000000004000000
fffffffffffffffd0000000020000000
fdffffff0000000004000000
fffffffd0000000020000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
};
-
{e=>0,c=>1,a=>99,b=>1,d=>0,f=>0}
630000000300000000000000
63000000000000000300000000000000
63000000000000000300000000000000
00000063c000000000000000
630000000300000000000000
630000000300000000000000
0000000000000063c000000000000000
630000000300000000000000
00000063c000000000000000
-
{e=>0,c=>1,a=>121,b=>1,d=>1,f=>0}
790000000300000001000000
79000000000000000300000001000000
79000000000000000300000001000000
00000079c000000080000000
790000000300000001000000
790000000300000001000000
0000000000000079c000000080000000
790000000300000001000000
00000079c000000080000000
-
{e=>0,c=>1,a=>101,b=>0,d=>0,f=>-1}
650000000200000004000000
65000000000000000200000004000000
65000000000000000200000004000000
000000654000000020000000
650000000200000004000000
650000000200000004000000
00000000000000654000000020000000
650000000200000004000000
000000654000000020000000
-
{e=>0,c=>1,a=>-100,b=>0,d=>0,f=>0}
9cffffff0200000000000000
9cffffffffffffff0200000000000000
9cffffffffffffff0200000000000000
ffffff9c4000000000000000
9cffffff0200000000000000
9cffffff0200000000000000
ffffffffffffff9c4000000000000000
9cffffff0200000000000000
ffffff9c4000000000000000
-
{e=>0,c=>1,a=>-59,b=>0,d=>1,f=>0}
c5ffffff0200000001000000
c5ffffffffffffff0200000001000000
c5ffffffffffffff0200000001000000
ffffffc54000000080000000
c5ffffff0200000001000000
c5ffffff0200000001000000
ffffffffffffffc54000000080000000
c5ffffff0200000001000000
ffffffc54000000080000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
};
-
{e=>0,c=>0,a=>73,g=>-1,b=>1,d=>1,f=>-1}
49000000010000000500000001000000
490000000000000001000000050000000100000000000000
490000000000000001000000050000000100000000000000
0000004980000000a000000080000000
49000000010000000500000001000000
49000000010000000500000001000000
000000000000004980000000a00000008000000000000000
49000000010000000500000001000000
0000004980000000a000000080000000
-
{e=>0,c=>0,a=>11,g=>0,b=>1,d=>0,f=>0}
0b000000010000000000000000000000
0b0000000000000001000000000000000000000000000000
0b0000000000000001000000000000000000000000000000
0000000b800000000000000000000000
0b000000010000000000000000000000
0b000000010000000000000000000000
000000000000000b80000000000000000000000000000000
0b000000010000000000000000000000
0000000b800000000000000000000000
-
{e=>-1,c=>0,a=>-31,g=>-1,b=>1,d=>1,f=>0}
e1ffffff010000000300000001000000
e1ffffffffffffff01000000030000000100000000000000
e1ffffffffffffff01000000030000000100000000000000
ffffffe180000000c000000080000000
e1ffffff010000000300000001000000
e1ffffff010000000300000001000000
ffffffffffffffe180000000c00000008000000000000000
e1ffffff010000000300000001000000
ffffffe180000000c000000080000000
-
{e=>-1,c=>0,a=>-124,g=>-1,b=>1,d=>1,f=>-1}
84ffffff010000000700000001000000
84ffffffffffffff01000000070000000100000000000000
84ffffffffffffff01000000070000000100000000000000
ffffff8480000000e000000080000000
84ffffff010000000700000001000000
84ffffff010000000700000001000000
ffffffffffffff8480000000e00000008000000000000000
84ffffff010000000700000001000000
ffffff8480000000e000000080000000
-
{e=>-1,c=>0,a=>-42,g=>0,b=>1,d=>0,f=>-1}
d6ffffff010000000600000000000000
d6ffffffffffffff01000000060000000000000000000000
d6ffffffffffffff01000000060000000000000000000000
ffffffd6800000006000000000000000
d6ffffff010000000600000000000000
d6ffffff010000000600000000000000
ffffffffffffffd680000000600000000000000000000000
d6ffffff010000000600000000000000
ffffffd6800000006000000000000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
};
-
{e=>-1,a=>86,d=>0,c=>0,h=>0,b=>0,g=>0,f=>-1}
56000000000000000600000000000000
560000000000000000000000060000000000000000000000
560000000000000000000000060000000000000000000000
00000056000000006000000000000000
56000000000000000600000000000000
56000000000000000600000000000000
000000000000005600000000600000000000000000000000
56000000000000000600000000000000
00000056000000006000000000000000
-
{e=>-1,a=>-97,d=>1,c=>0,h=>0,b=>0,g=>-1,f=>-1}
9fffffff000000000700000001000000
9fffffffffffffff00000000070000000100000000000000
9fffffffffffffff00000000070000000100000000000000
ffffff9f00000000e000000080000000
9fffffff000000000700000001000000
9fffffff000000000700000001000000
ffffffffffffff9f00000000e00000008000000000000000
9fffffff000000000700000001000000
ffffff9f00000000e000000080000000
-
{e=>0,a=>18,d=>0,c=>1,h=>-1,b=>0,g=>0,f=>0}
12000000020000000000000002000000
120000000000000002000000000000000200000000000000
120000000000000002000000000000000200000000000000
00000012400000000000000040000000
12000000020000000000000002000000
12000000020000000000000002000000
000000000000001240000000000000004000000000000000
12000000020000000000000002000000
00000012400000000000000040000000
-
{e=>0,a=>-102,d=>0,c=>0,h=>-1,b=>1,g=>-1,f=>0}
9affffff010000000000000003000000
9affffffffffffff01000000000000000300000000000000
9affffffffffffff01000000000000000300000000000000
ffffff9a8000000000000000c0000000
9affffff010000000000000003000000
9affffff010000000000000003000000
ffffffffffffff9a8000000000000000c000000000000000
9affffff010000000000000003000000
ffffff9a8000000000000000c0000000
-
{e=>0,a=>-36,d=>0,c=>0,h=>-1,b=>1,g=>0,f=>0}
dcffffff010000000000000002000000
dcffffffffffffff01000000000000000200000000000000
dcffffffffffffff01000000000000000200000000000000
ffffffdc800000000000000040000000
dcffffff010000000000000002000000
dcffffff010000000000000002000000
ffffffffffffffdc80000000000000004000000000000000
dcffffff010000000000000002000000
ffffffdc800000000000000040000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
};
-
{e=>-1,a=>83,d=>1,c=>1,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
53000000030000000700000003000000
530000000000000003000000070000000300000000000000
530000000000000003000000070000000300000000000000
00000053c0000000e0000000c0000000
53000000030000000700000003000000
53000000030000000700000003000000
0000000000000053c0000000e0000000c000000000000000
53000000030000000700000003000000
00000053c0000000e0000000c0000000
-
{e=>0,a=>35,d=>1,c=>0,h=>0,b=>1,g=>-1,f=>0,i=>0}
23000000010000000100000001000000
230000000000000001000000010000000100000000000000
230000000000000001000000010000000100000000000000
00000023800000008000000080000000
23000000010000000100000001000000
23000000010000000100000001000000
000000000000002380000000800000008000000000000000
23000000010000000100000001000000
00000023800000008000000080000000
-
{e=>-1,a=>-48,d=>1,c=>1,h=>-1,b=>0,g=>0,f=>-1,i=>0}
d0ffffff020000000700000002000000
d0ffffffffffffff02000000070000000200000000000000
d0ffffffffffffff02000000070000000200000000000000
ffffffd040000000e000000040000000
d0ffffff020000000700000002000000
d0ffffff020000000700000002000000
ffffffffffffffd040000000e00000004000000000000000
d0ffffff020000000700000002000000
ffffffd040000000e000000040000000
-
{e=>-1,a=>47,d=>1,c=>1,h=>-1,b=>0,g=>0,f=>0,i=>0}
2f000000020000000300000002000000
2f0000000000000002000000030000000200000000000000
2f0000000000000002000000030000000200000000000000
0000002f40000000c000000040000000
2f000000020000000300000002000000
2f000000020000000300000002000000
000000000000002f40000000c00000004000000000000000
2f000000020000000300000002000000
0000002f40000000c000000040000000
-
{e=>-1,a=>-92,d=>1,c=>0,h=>-1,b=>1,g=>-1,f=>0,i=>0}
a4ffffff010000000300000003000000
a4ffffffffffffff01000000030000000300000000000000
a4ffffffffffffff01000000030000000300000000000000
ffffffa480000000c0000000c0000000
a4ffffff010000000300000003000000
a4ffffff010000000300000003000000
ffffffffffffffa480000000c0000000c000000000000000
a4ffffff010000000300000003000000
ffffffa480000000c0000000c0000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
};
-
{e=>0,a=>-32,d=>0,c=>0,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
e0ffffff010000000400000003000000
e0ffffffffffffff01000000040000000300000000000000
e0ffffffffffffff01000000040000000300000000000000
ffffffe08000000020000000c0000000
e0ffffff010000000400000003000000
e0ffffff010000000400000003000000
ffffffffffffffe08000000020000000c000000000000000
e0ffffff010000000400000003000000
ffffffe08000000020000000c0000000
-
{e=>0,a=>-105,d=>1,c=>1,h=>0,b=>0,g=>-1,f=>-1,i=>-1}
97ffffff020000000500000005000000
97ffffffffffffff02000000050000000500000000000000
97ffffffffffffff02000000050000000500000000000000
ffffff9740000000a0000000a0000000
97ffffff020000000500000005000000
97ffffff020000000500000005000000
ffffffffffffff9740000000a0000000a000000000000000
97ffffff020000000500000005000000
ffffff9740000000a0000000a0000000
-
{e=>0,a=>95,d=>1,c=>1,h=>-1,b=>1,g=>-1,f=>-1,i=>-1}
5f000000030000000500000007000000
5f0000000000000003000000050000000700000000000000
5f0000000000000003000000050000000700000000000000
0000005fc0000000a0000000e0000000
5f000000030000000500000007000000
5f000000030000000500000007000000
000000000000005fc0000000a0000000e000000000000000
5f000000030000000500000007000000
0000005fc0000000a0000000e0000000
-
{e=>-1,a=>-81,d=>0,c=>0,h=>0,b=>1,g=>0,f=>0,i=>0}
afffffff010000000200000000000000
afffffffffffffff01000000020000000000000000000000
afffffffffffffff01000000020000000000000000000000
ffffffaf800000004000000000000000
afffffff010000000200000000000000
afffffff010000000200000000000000
ffffffffffffffaf80000000400000000000000000000000
afffffff010000000200000000000000
ffffffaf800000004000000000000000
-
{e=>-1,a=>54,d=>0,c=>0,h=>-1,b=>0,g=>-1,f=>0,i=>-1}
36000000000000000200000007000000
360000000000000000000000020000000700000000000000
360000000000000000000000020000000700000000000000
000000360000000040000000e0000000
36000000000000000200000007000000
36000000000000000200000007000000
00000000000000360000000040000000e000000000000000
36000000000000000200000007000000
000000360000000040000000e0000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
};
-
{e=>0,a=>-112,d=>0,j=>0,c=>1,h=>0,b=>1,g=>-1,f=>0,i=>-1}
90ffffff03000000000000000500000000000000
90ffffffffffffff03000000000000000500000000000000
90ffffffffffffff03000000000000000500000000000000
ffffff90c000000000000000a000000000000000
90ffffff03000000000000000500000000000000
90ffffff03000000000000000500000000000000
ffffffffffffff90c000000000000000a000000000000000
90ffffff03000000000000000500000000000000
ffffff90c000000000000000a000000000000000
-
{e=>0,a=>39,d=>0,j=>0,c=>1,h=>-1,b=>1,g=>-1,f=>-1,i=>0}
2700000003000000040000000300000000000000
270000000000000003000000040000000300000000000000
270000000000000003000000040000000300000000000000
00000027c000000020000000c000000000000000
2700000003000000040000000300000000000000
2700000003000000040000000300000000000000
0000000000000027c000000020000000c000000000000000
2700000003000000040000000300000000000000
00000027c000000020000000c000000000000000
-
{e=>-1,a=>113,d=>1,j=>-1,c=>1,h=>-1,b=>0,g=>0,f=>-1,i=>0}
7100000002000000070000000200000001000000
710000000000000002000000070000000200000001000000
710000000000000002000000070000000200000001000000
0000007140000000e00000004000000080000000
7100000002000000070000000200000001000000
7100000002000000070000000200000001000000
000000000000007140000000e00000004000000080000000
7100000002000000070000000200000001000000
0000007140000000e00000004000000080000000
-
{e=>0,a=>118,d=>1,j=>0,c=>1,h=>0,b=>0,g=>0,f=>0,i=>-1}
7600000002000000010000000400000000000000
760000000000000002000000010000000400000000000000
760000000000000002000000010000000400000000000000
0000007640000000800000002000000000000000
7600000002000000010000000400000000000000
7600000002000000010000000400000000000000
000000000000007640000000800000002000000000000000
7600000002000000010000000400000000000000
0000007640000000800000002000000000000000
-
{e=>-1,a=>80,d=>0,j=>-1,c=>1,h=>0,b=>0,g=>-1,f=>-1,i=>0}
5000000002000000060000000100000001000000
500000000000000002000000060000000100000001000000
500000000000000002000000060000000100000001000000
0000005040000000600000008000000080000000
5000000002000000060000000100000001000000
5000000002000000060000000100000001000000
000000000000005040000000600000008000000080000000
5000000002000000060000000100000001000000
0000005040000000600000008000000080000000
=
struct mixed1 {
  long a;
  unsigned int b:1;
  unsigned int c:1;
  unsigned int  :0;
  unsigned int d:1;
  signed   int e:1;
  signed   int f:1;
  signed   int  :0;
  signed   int g:1;
  int          h:1;
  int          i:1;
  int           :0;
  int          j:1;
  long         k;
};
-
{e=>-1,a=>2,d=>0,j=>0,c=>1,k=>-79,h=>0,b=>1,g=>0,f=>0,i=>0}
0200000003000000020000000000000000000000b1ffffff
020000000000000003000000020000000000000000000000b1ffffffffffffff
020000000000000003000000020000000000000000000000b1ffffffffffffff
00000002c0000000400000000000000000000000ffffffb1
0200000003000000020000000000000000000000b1ffffff
0200000003000000020000000000000000000000b1ffffff
0000000000000002c0000000400000000000000000000000ffffffffffffffb1
0200000003000000020000000000000000000000b1ffffff
00000002c0000000400000000000000000000000ffffffb1
-
{e=>0,a=>-88,d=>1,j=>0,c=>1,k=>-90,h=>0,b=>0,g=>-1,f=>0,i=>0}
a8ffffff02000000010000000100000000000000a6ffffff
a8ffffffffffffff02000000010000000100000000000000a6ffffffffffffff
a8ffffffffffffff02000000010000000100000000000000a6ffffffffffffff
ffffffa840000000800000008000000000000000ffffffa6
a8ffffff02000000010000000100000000000000a6ffffff
a8ffffff02000000010000000100000000000000a6ffffff
ffffffffffffffa840000000800000008000000000000000ffffffffffffffa6
a8ffffff02000000010000000100000000000000a6ffffff
ffffffa840000000800000008000000000000000ffffffa6
-
{e=>0,a=>-63,d=>0,j=>-1,c=>1,k=>22,h=>-1,b=>0,g=>0,f=>-1,i=>0}
c1ffffff0200000004000000020000000100000016000000
c1ffffffffffffff020000000400000002000000010000001600000000000000
c1ffffffffffffff020000000400000002000000010000001600000000000000
ffffffc14000000020000000400000008000000000000016
c1ffffff0200000004000000020000000100000016000000
c1ffffff0200000004000000020000000100000016000000
ffffffffffffffc1400000002000000040000000800000000000000000000016
c1ffffff0200000004000000020000000100000016000000
ffffffc14000000020000000400000008000000000000016
-
{e=>0,a=>23,d=>1,j=>0,c=>1,k=>21,h=>0,b=>1,g=>-1,f=>-1,i=>0}
170000000300000005000000010000000000000015000000
1700000000000000030000000500000001000000000000001500000000000000
1700000000000000030000000500000001000000000000001500000000000000
00000017c0000000a0000000800000000000000000000015
170000000300000005000000010000000000000015000000
170000000300000005000000010000000000000015000000
0000000000000017c0000000a000000080000000000000000000000000000015
170000000300000005000000010000000000000015000000
00000017c0000000a0000000800000000000000000000015
-
{e=>-1,a=>84,d=>1,j=>-1,c=>1,k=>47,h=>0,b=>1,g=>-1,f=>0,i=>-1}
54000000030000000300000005000000010000002f000000
5400000000000000030000000300000005000000010000002f00000000000000
5400000000000000030000000300000005000000010000002f00000000000000
00000054c0000000c0000000a0000000800000000000002f
54000000030000000300000005000000010000002f000000
54000000030000000300000005000000010000002f000000
0000000000000054c0000000c0000000a000000080000000000000000000002f
54000000030000000300000005000000010000002f000000
00000054c0000000c0000000a0000000800000000000002f
=
struct mixed2 {
  unsigned int a:2;
};
-
{a=>1}
01000000
01000000
01000000
40000000
01000000
01000000
40000000
01000000
40000000
-
{a=>2}
02000000
02000000
02000000
80000000
02000000
02000000
80000000
02000000
80000000
-
{a=>2}
02000000
02000000
02000000
80000000
02000000
02000000
80000000
02000000
80000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
};
-
{a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>0,b=>2}
08000000
08000000
08000000
20000000
08000000
08000000
20000000
08000000
20000000
-
{a=>3,b=>3}
0f000000
0f000000
0f000000
f0000000
0f000000
0f000000
f0000000
0f000000
f0000000
-
{a=>2,b=>1}
06000000
06000000
06000000
90000000
06000000
06000000
90000000
06000000
90000000
-
{a=>0,b=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
};
-
{a=>2,b=>1}
06000000
06000000
06000000
90000000
06000000
06000000
90000000
06000000
90000000
-
{a=>0,b=>3}
0c000000
0c000000
0c000000
30000000
0c000000
0c000000
30000000
0c000000
30000000
-
{a=>2,b=>2}
0a000000
0a000000
0a000000
a0000000
0a000000
0a000000
a0000000
0a000000
a0000000
-
{a=>3,b=>0}
03000000
03000000
03000000
c0000000
03000000
03000000
c0000000
03000000
c0000000
-
{a=>3,b=>1}
07000000
07000000
07000000
d0000000
07000000
07000000
d0000000
07000000
d0000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
};
-
{c=>0,a=>3,b=>2}
0b00000000000000
0b00000000000000
0b00000000000000
e000000000000000
0b00000000000000
0b00000000000000
e000000000000000
0b00000000000000
e000000000000000
-
{c=>2,a=>2,b=>3}
0e00000002000000
0e00000002000000
0e00000002000000
b000000080000000
0e00000002000000
0e00000002000000
b000000080000000
0e00000002000000
b000000080000000
-
{c=>3,a=>2,b=>2}
0a00000003000000
0a00000003000000
0a00000003000000
a0000000c0000000
0a00000003000000
0a00000003000000
a0000000c0000000
0a00000003000000
a0000000c0000000
-
{c=>1,a=>2,b=>3}
0e00000001000000
0e00000001000000
0e00000001000000
b000000040000000
0e00000001000000
0e00000001000000
b000000040000000
0e00000001000000
b000000040000000
-
{c=>1,a=>0,b=>1}
0400000001000000
0400000001000000
0400000001000000
1000000040000000
0400000001000000
0400000001000000
1000000040000000
0400000001000000
1000000040000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
};
-
{c=>0,a=>2,b=>2,d=>-1}
0a0000000c000000
0a0000000c000000
0a0000000c000000
a000000030000000
0a0000000c000000
0a0000000c000000
a000000030000000
0a0000000c000000
a000000030000000
-
{c=>1,a=>0,b=>1,d=>0}
0400000001000000
0400000001000000
0400000001000000
1000000040000000
0400000001000000
0400000001000000
1000000040000000
0400000001000000
1000000040000000
-
{c=>2,a=>2,b=>1,d=>0}
0600000002000000
0600000002000000
0600000002000000
9000000080000000
0600000002000000
0600000002000000
9000000080000000
0600000002000000
9000000080000000
-
{c=>2,a=>0,b=>2,d=>0}
0800000002000000
0800000002000000
0800000002000000
2000000080000000
0800000002000000
0800000002000000
2000000080000000
0800000002000000
2000000080000000
-
{c=>1,a=>1,b=>3,d=>0}
0d00000001000000
0d00000001000000
0d00000001000000
7000000040000000
0d00000001000000
0d00000001000000
7000000040000000
0d00000001000000
7000000040000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
};
-
{e=>1,c=>0,a=>1,b=>2,d=>-2}
0900000018000000
0900000018000000
0900000018000000
6000000024000000
0900000018000000
0900000018000000
6000000024000000
0900000018000000
6000000024000000
-
{e=>0,c=>1,a=>0,b=>2,d=>-1}
080000000d000000
080000000d000000
080000000d000000
2000000070000000
080000000d000000
080000000d000000
2000000070000000
080000000d000000
2000000070000000
-
{e=>-2,c=>3,a=>3,b=>1,d=>1}
0700000027000000
0700000027000000
0700000027000000
d0000000d8000000
0700000027000000
0700000027000000
d0000000d8000000
0700000027000000
d0000000d8000000
-
{e=>1,c=>3,a=>0,b=>1,d=>-1}
040000001f000000
040000001f000000
040000001f000000
10000000f4000000
040000001f000000
040000001f000000
10000000f4000000
040000001f000000
10000000f4000000
-
{e=>-2,c=>0,a=>0,b=>3,d=>-2}
0c00000028000000
0c00000028000000
0c00000028000000
3000000028000000
0c00000028000000
0c00000028000000
3000000028000000
0c00000028000000
3000000028000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
};
-
{e=>-1,c=>3,a=>2,b=>1,d=>1}
0600000037000000
0600000037000000
0600000037000000
90000000dc000000
0600000037000000
0600000037000000
90000000dc000000
0600000037000000
90000000dc000000
-
{e=>-2,c=>0,a=>1,b=>2,d=>-2}
0900000028000000
0900000028000000
0900000028000000
6000000028000000
0900000028000000
0900000028000000
6000000028000000
0900000028000000
6000000028000000
-
{e=>0,c=>3,a=>2,b=>2,d=>0}
0a00000003000000
0a00000003000000
0a00000003000000
a0000000c0000000
0a00000003000000
0a00000003000000
a0000000c0000000
0a00000003000000
a0000000c0000000
-
{e=>1,c=>2,a=>1,b=>2,d=>-2}
090000001a000000
090000001a000000
090000001a000000
60000000a4000000
090000001a000000
090000001a000000
60000000a4000000
090000001a000000
60000000a4000000
-
{e=>1,c=>2,a=>2,b=>3,d=>0}
0e00000012000000
0e00000012000000
0e00000012000000
b000000084000000
0e00000012000000
0e00000012000000
b000000084000000
0e00000012000000
b000000084000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
};
-
{e=>0,c=>1,a=>2,b=>3,d=>0,f=>-1}
0e0000000100000003000000
0e0000000100000003000000
0e0000000100000003000000
b000000040000000c0000000
0e0000000100000003000000
0e0000000100000003000000
b000000040000000c0000000
0e0000000100000003000000
b000000040000000c0000000
-
{e=>0,c=>0,a=>0,b=>2,d=>-1,f=>1}
080000000c00000001000000
080000000c00000001000000
080000000c00000001000000
200000003000000040000000
080000000c00000001000000
080000000c00000001000000
200000003000000040000000
080000000c00000001000000
200000003000000040000000
-
{e=>0,c=>2,a=>0,b=>0,d=>0,f=>-2}
000000000200000002000000
000000000200000002000000
000000000200000002000000
000000008000000080000000
000000000200000002000000
000000000200000002000000
000000008000000080000000
000000000200000002000000
000000008000000080000000
-
{e=>-2,c=>3,a=>2,b=>1,d=>-2,f=>-2}
060000002b00000002000000
060000002b00000002000000
060000002b00000002000000
90000000e800000080000000
060000002b00000002000000
060000002b00000002000000
90000000e800000080000000
060000002b00000002000000
90000000e800000080000000
-
{e=>-2,c=>2,a=>0,b=>3,d=>-2,f=>-1}
0c0000002a00000003000000
0c0000002a00000003000000
0c0000002a00000003000000
30000000a8000000c0000000
0c0000002a00000003000000
0c0000002a00000003000000
30000000a8000000c0000000
0c0000002a00000003000000
30000000a8000000c0000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
  int          g:2;
};
-
{e=>0,c=>2,a=>1,g=>-1,b=>3,d=>1,f=>-1}
0d000000060000000f000000
0d000000060000000f000000
0d000000060000000f000000
7000000090000000f0000000
0d000000060000000f000000
0d000000060000000f000000
7000000090000000f0000000
0d000000060000000f000000
7000000090000000f0000000
-
{e=>1,c=>2,a=>2,g=>1,b=>2,d=>1,f=>1}
0a0000001600000005000000
0a0000001600000005000000
0a0000001600000005000000
a00000009400000050000000
0a0000001600000005000000
0a0000001600000005000000
a00000009400000050000000
0a0000001600000005000000
a00000009400000050000000
-
{e=>0,c=>2,a=>2,g=>-1,b=>2,d=>-2,f=>-1}
0a0000000a0000000f000000
0a0000000a0000000f000000
0a0000000a0000000f000000
a0000000a0000000f0000000
0a0000000a0000000f000000
0a0000000a0000000f000000
a0000000a0000000f0000000
0a0000000a0000000f000000
a0000000a0000000f0000000
-
{e=>-2,c=>0,a=>2,g=>-2,b=>1,d=>-1,f=>1}
060000002c00000009000000
060000002c00000009000000
060000002c00000009000000
900000003800000060000000
060000002c00000009000000
060000002c00000009000000
900000003800000060000000
060000002c00000009000000
900000003800000060000000
-
{e=>-1,c=>3,a=>1,g=>-1,b=>0,d=>0,f=>0}
01000000330000000c000000
01000000330000000c000000
01000000330000000c000000
40000000cc00000030000000
01000000330000000c000000
01000000330000000c000000
40000000cc00000030000000
01000000330000000c000000
40000000cc00000030000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
  int          g:2;
  int          h:2;
};
-
{e=>-2,a=>0,d=>1,c=>2,h=>-1,b=>1,g=>-2,f=>-2}
04000000260000003a000000
04000000260000003a000000
04000000260000003a000000
1000000098000000ac000000
04000000260000003a000000
04000000260000003a000000
1000000098000000ac000000
04000000260000003a000000
1000000098000000ac000000
-
{e=>-2,a=>0,d=>1,c=>0,h=>0,b=>0,g=>1,f=>0}
000000002400000004000000
000000002400000004000000
000000002400000004000000
000000001800000010000000
000000002400000004000000
000000002400000004000000
000000001800000010000000
000000002400000004000000
000000001800000010000000
-
{e=>1,a=>1,d=>1,c=>1,h=>0,b=>0,g=>-1,f=>-2}
01000000150000000e000000
01000000150000000e000000
01000000150000000e000000
4000000054000000b0000000
01000000150000000e000000
01000000150000000e000000
4000000054000000b0000000
01000000150000000e000000
4000000054000000b0000000
-
{e=>0,a=>3,d=>0,c=>0,h=>1,b=>2,g=>0,f=>1}
0b0000000000000011000000
0b0000000000000011000000
0b0000000000000011000000
e00000000000000044000000
0b0000000000000011000000
0b0000000000000011000000
e00000000000000044000000
0b0000000000000011000000
e00000000000000044000000
-
{e=>-1,a=>1,d=>0,c=>1,h=>0,b=>0,g=>0,f=>0}
010000003100000000000000
010000003100000000000000
010000003100000000000000
400000004c00000000000000
010000003100000000000000
010000003100000000000000
400000004c00000000000000
010000003100000000000000
400000004c00000000000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
  int          g:2;
  int          h:2;
  int           :0;
};
-
{e=>-2,a=>0,d=>0,c=>0,h=>-1,b=>1,g=>0,f=>-2}
040000002000000032000000
040000002000000032000000
040000002000000032000000
10000000080000008c000000
040000002000000032000000
040000002000000032000000
10000000080000008c000000
040000002000000032000000
10000000080000008c000000
-
{e=>0,a=>3,d=>-2,c=>2,h=>-1,b=>3,g=>-1,f=>-2}
0f0000000a0000003e000000
0f0000000a0000003e000000
0f0000000a0000003e000000
f0000000a0000000bc000000
0f0000000a0000003e000000
0f0000000a0000003e000000
f0000000a0000000bc000000
0f0000000a0000003e000000
f0000000a0000000bc000000
-
{e=>-1,a=>0,d=>0,c=>1,h=>-1,b=>0,g=>-1,f=>0}
00000000310000003c000000
00000000310000003c000000
00000000310000003c000000
000000004c0000003c000000
00000000310000003c000000
00000000310000003c000000
000000004c0000003c000000
00000000310000003c000000
000000004c0000003c000000
-
{e=>0,a=>3,d=>-2,c=>0,h=>1,b=>2,g=>-2,f=>1}
0b0000000800000019000000
0b0000000800000019000000
0b0000000800000019000000
e00000002000000064000000
0b0000000800000019000000
0b0000000800000019000000
e00000002000000064000000
0b0000000800000019000000
e00000002000000064000000
-
{e=>-1,a=>2,d=>0,c=>1,h=>1,b=>0,g=>0,f=>1}
020000003100000011000000
020000003100000011000000
020000003100000011000000
800000004c00000044000000
020000003100000011000000
020000003100000011000000
800000004c00000044000000
020000003100000011000000
800000004c00000044000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
  int          g:2;
  int          h:2;
  int           :0;
  int          i:2;
};
-
{e=>0,a=>0,d=>0,c=>2,h=>-1,b=>2,g=>1,f=>0,i=>1}
08000000020000003400000001000000
08000000020000003400000001000000
08000000020000003400000001000000
20000000800000001c00000040000000
08000000020000003400000001000000
08000000020000003400000001000000
20000000800000001c00000040000000
08000000020000003400000001000000
20000000800000001c00000040000000
-
{e=>0,a=>0,d=>-2,c=>0,h=>-1,b=>0,g=>-2,f=>1,i=>1}
00000000080000003900000001000000
00000000080000003900000001000000
00000000080000003900000001000000
00000000200000006c00000040000000
00000000080000003900000001000000
00000000080000003900000001000000
00000000200000006c00000040000000
00000000080000003900000001000000
00000000200000006c00000040000000
-
{e=>-1,a=>2,d=>0,c=>0,h=>0,b=>1,g=>-2,f=>0,i=>-1}
06000000300000000800000003000000
06000000300000000800000003000000
06000000300000000800000003000000
900000000c00000020000000c0000000
06000000300000000800000003000000
06000000300000000800000003000000
900000000c00000020000000c0000000
06000000300000000800000003000000
900000000c00000020000000c0000000
-
{e=>1,a=>0,d=>0,c=>2,h=>0,b=>2,g=>1,f=>0,i=>1}
08000000120000000400000001000000
08000000120000000400000001000000
08000000120000000400000001000000
20000000840000001000000040000000
08000000120000000400000001000000
08000000120000000400000001000000
20000000840000001000000040000000
08000000120000000400000001000000
20000000840000001000000040000000
-
{e=>0,a=>3,d=>-1,c=>0,h=>-1,b=>2,g=>-2,f=>0,i=>-2}
0b0000000c0000003800000002000000
0b0000000c0000003800000002000000
0b0000000c0000003800000002000000
e0000000300000002c00000080000000
0b0000000c0000003800000002000000
0b0000000c0000003800000002000000
e0000000300000002c00000080000000
0b0000000c0000003800000002000000
e0000000300000002c00000080000000
=
struct mixed2 {
  unsigned int a:2;
  unsigned int b:2;
  unsigned int  :0;
  unsigned int c:2;
  signed   int d:2;
  signed   int e:2;
  signed   int  :0;
  signed   int f:2;
  int          g:2;
  int          h:2;
  int           :0;
  int          i:2;
  int          j;
};
-
{e=>-2,a=>1,d=>0,j=>11,c=>0,h=>-2,b=>1,g=>1,f=>-1,i=>-1}
050000002000000027000000030000000b000000
050000002000000027000000030000000b000000
050000002000000027000000030000000b000000
5000000008000000d8000000c00000000000000b
050000002000000027000000030000000b000000
050000002000000027000000030000000b000000
5000000008000000d8000000c00000000000000b
050000002000000027000000030000000b000000
5000000008000000d8000000c00000000000000b
-
{e=>1,a=>2,d=>-2,j=>76,c=>3,h=>-1,b=>1,g=>0,f=>-1,i=>1}
060000001b00000033000000010000004c000000
060000001b00000033000000010000004c000000
060000001b00000033000000010000004c000000
90000000e4000000cc000000400000000000004c
060000001b00000033000000010000004c000000
060000001b00000033000000010000004c000000
90000000e4000000cc000000400000000000004c
060000001b00000033000000010000004c000000
90000000e4000000cc000000400000000000004c
-
{e=>1,a=>3,d=>0,j=>-66,c=>0,h=>-2,b=>3,g=>-2,f=>-1,i=>-2}
0f000000100000002b00000002000000beffffff
0f000000100000002b00000002000000beffffff
0f000000100000002b00000002000000beffffff
f000000004000000e800000080000000ffffffbe
0f000000100000002b00000002000000beffffff
0f000000100000002b00000002000000beffffff
f000000004000000e800000080000000ffffffbe
0f000000100000002b00000002000000beffffff
f000000004000000e800000080000000ffffffbe
-
{e=>-1,a=>0,d=>0,j=>-99,c=>1,h=>0,b=>1,g=>-2,f=>0,i=>1}
040000003100000008000000010000009dffffff
040000003100000008000000010000009dffffff
040000003100000008000000010000009dffffff
100000004c0000002000000040000000ffffff9d
040000003100000008000000010000009dffffff
040000003100000008000000010000009dffffff
100000004c0000002000000040000000ffffff9d
040000003100000008000000010000009dffffff
100000004c0000002000000040000000ffffff9d
-
{e=>-1,a=>2,d=>1,j=>94,c=>3,h=>-2,b=>3,g=>1,f=>-2,i=>-2}
0e0000003700000026000000020000005e000000
0e0000003700000026000000020000005e000000
0e0000003700000026000000020000005e000000
b0000000dc00000098000000800000000000005e
0e0000003700000026000000020000005e000000
0e0000003700000026000000020000005e000000
b0000000dc00000098000000800000000000005e
0e0000003700000026000000020000005e000000
b0000000dc00000098000000800000000000005e
=
struct mixed2 {
  char a;
  unsigned int b:2;
};
-
{a=>-56,b=>3}
c8030000
c8030000
c8030000
c8c00000
c8030000
c8030000
c8c00000
c8030000
c8c00000
-
{a=>127,b=>0}
7f000000
7f000000
7f000000
7f000000
7f000000
7f000000
7f000000
7f000000
7f000000
-
{a=>43,b=>2}
2b020000
2b020000
2b020000
2b800000
2b020000
2b020000
2b800000
2b020000
2b800000
-
{a=>-28,b=>1}
e4010000
e4010000
e4010000
e4400000
e4010000
e4010000
e4400000
e4010000
e4400000
-
{a=>38,b=>0}
26000000
26000000
26000000
26000000
26000000
26000000
26000000
26000000
26000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
};
-
{c=>0,a=>35,b=>1}
23010000
23010000
23010000
23400000
23010000
23010000
23400000
23010000
23400000
-
{c=>0,a=>53,b=>3}
35030000
35030000
35030000
35c00000
35030000
35030000
35c00000
35030000
35c00000
-
{c=>3,a=>120,b=>0}
780c0000
780c0000
780c0000
78300000
780c0000
780c0000
78300000
780c0000
78300000
-
{c=>3,a=>-123,b=>1}
850d0000
850d0000
850d0000
85700000
850d0000
850d0000
85700000
850d0000
85700000
-
{c=>1,a=>29,b=>3}
1d070000
1d070000
1d070000
1dd00000
1d070000
1d070000
1dd00000
1d070000
1dd00000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
};
-
{c=>2,a=>79,b=>2}
4f0a0000
4f0a0000
4f0a0000
4fa00000
4f0a0000
4f0a0000
4fa00000
4f0a0000
4fa00000
-
{c=>1,a=>-102,b=>2}
9a060000
9a060000
9a060000
9a900000
9a060000
9a060000
9a900000
9a060000
9a900000
-
{c=>0,a=>-112,b=>1}
90010000
90010000
90010000
90400000
90010000
90010000
90400000
90010000
90400000
-
{c=>0,a=>86,b=>0}
56000000
56000000
56000000
56000000
56000000
56000000
56000000
56000000
56000000
-
{c=>2,a=>-112,b=>2}
900a0000
900a0000
900a0000
90a00000
900a0000
900a0000
90a00000
900a0000
90a00000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
};
-
{c=>1,a=>9,b=>1,d=>2}
0905000002000000
0905000002000000
0905000002000000
0950000080000000
0905000002000000
0905000002000000
0950000080000000
0905000002000000
0950000080000000
-
{c=>2,a=>-42,b=>0,d=>3}
d608000003000000
d608000003000000
d608000003000000
d6200000c0000000
d608000003000000
d608000003000000
d6200000c0000000
d608000003000000
d6200000c0000000
-
{c=>2,a=>65,b=>2,d=>2}
410a000002000000
410a000002000000
410a000002000000
41a0000080000000
410a000002000000
410a000002000000
41a0000080000000
410a000002000000
41a0000080000000
-
{c=>1,a=>-14,b=>2,d=>0}
f206000000000000
f206000000000000
f206000000000000
f290000000000000
f206000000000000
f206000000000000
f290000000000000
f206000000000000
f290000000000000
-
{c=>3,a=>-69,b=>1,d=>1}
bb0d000001000000
bb0d000001000000
bb0d000001000000
bb70000040000000
bb0d000001000000
bb0d000001000000
bb70000040000000
bb0d000001000000
bb70000040000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
};
-
{e=>0,c=>1,a=>-38,b=>2,d=>1}
da06000001000000
da06000001000000
da06000001000000
da90000040000000
da06000001000000
da06000001000000
da90000040000000
da06000001000000
da90000040000000
-
{e=>0,c=>0,a=>66,b=>2,d=>1}
4202000001000000
4202000001000000
4202000001000000
4280000040000000
4202000001000000
4202000001000000
4280000040000000
4202000001000000
4280000040000000
-
{e=>1,c=>2,a=>-56,b=>1,d=>2}
c809000006000000
c809000006000000
c809000006000000
c860000090000000
c809000006000000
c809000006000000
c860000090000000
c809000006000000
c860000090000000
-
{e=>-1,c=>1,a=>120,b=>1,d=>2}
780500000e000000
780500000e000000
780500000e000000
78500000b0000000
780500000e000000
780500000e000000
78500000b0000000
780500000e000000
78500000b0000000
-
{e=>0,c=>2,a=>62,b=>0,d=>3}
3e08000003000000
3e08000003000000
3e08000003000000
3e200000c0000000
3e08000003000000
3e08000003000000
3e200000c0000000
3e08000003000000
3e200000c0000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
};
-
{e=>1,c=>3,a=>-41,b=>1,d=>2,f=>0}
d70d000006000000
d70d000006000000
d70d000006000000
d770000090000000
d70d000006000000
d70d000006000000
d770000090000000
d70d000006000000
d770000090000000
-
{e=>-2,c=>2,a=>100,b=>2,d=>1,f=>1}
640a000019000000
640a000019000000
640a000019000000
64a0000064000000
640a000019000000
640a000019000000
64a0000064000000
640a000019000000
64a0000064000000
-
{e=>1,c=>0,a=>86,b=>0,d=>3,f=>1}
5600000017000000
5600000017000000
5600000017000000
56000000d4000000
5600000017000000
5600000017000000
56000000d4000000
5600000017000000
56000000d4000000
-
{e=>1,c=>3,a=>-89,b=>3,d=>2,f=>-2}
a70f000026000000
a70f000026000000
a70f000026000000
a7f0000098000000
a70f000026000000
a70f000026000000
a7f0000098000000
a70f000026000000
a7f0000098000000
-
{e=>-1,c=>3,a=>-109,b=>3,d=>0,f=>1}
930f00001c000000
930f00001c000000
930f00001c000000
93f0000034000000
930f00001c000000
930f00001c000000
93f0000034000000
930f00001c000000
93f0000034000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
};
-
{e=>-2,c=>0,a=>-11,b=>1,d=>3,f=>1}
f50100001b000000
f50100001b000000
f50100001b000000
f5400000e4000000
f50100001b000000
f50100001b000000
f5400000e4000000
f50100001b000000
f5400000e4000000
-
{e=>-2,c=>0,a=>11,b=>0,d=>0,f=>1}
0b00000018000000
0b00000018000000
0b00000018000000
0b00000024000000
0b00000018000000
0b00000018000000
0b00000024000000
0b00000018000000
0b00000024000000
-
{e=>0,c=>3,a=>100,b=>1,d=>3,f=>0}
640d000003000000
640d000003000000
640d000003000000
64700000c0000000
640d000003000000
640d000003000000
64700000c0000000
640d000003000000
64700000c0000000
-
{e=>0,c=>3,a=>-21,b=>2,d=>0,f=>-2}
eb0e000020000000
eb0e000020000000
eb0e000020000000
ebb0000008000000
eb0e000020000000
eb0e000020000000
ebb0000008000000
eb0e000020000000
ebb0000008000000
-
{e=>1,c=>0,a=>-82,b=>1,d=>1,f=>-1}
ae01000035000000
ae01000035000000
ae01000035000000
ae4000005c000000
ae01000035000000
ae01000035000000
ae4000005c000000
ae01000035000000
ae4000005c000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
};
-
{e=>1,c=>1,a=>-87,g=>-2,b=>0,d=>0,f=>0}
a90400000400000002000000
a90400000400000002000000
a90400000400000002000000
a91000001000000080000000
a90400000400000002000000
a90400000400000002000000
a91000001000000080000000
a90400000400000002000000
a91000001000000080000000
-
{e=>-2,c=>1,a=>1,g=>-2,b=>0,d=>0,f=>-2}
010400002800000002000000
010400002800000002000000
010400002800000002000000
011000002800000080000000
010400002800000002000000
010400002800000002000000
011000002800000080000000
010400002800000002000000
011000002800000080000000
-
{e=>-1,c=>2,a=>107,g=>-2,b=>3,d=>3,f=>-1}
6b0b00003f00000002000000
6b0b00003f00000002000000
6b0b00003f00000002000000
6be00000fc00000080000000
6b0b00003f00000002000000
6b0b00003f00000002000000
6be00000fc00000080000000
6b0b00003f00000002000000
6be00000fc00000080000000
-
{e=>-1,c=>1,a=>-44,g=>0,b=>0,d=>0,f=>-1}
d40400003c00000000000000
d40400003c00000000000000
d40400003c00000000000000
d41000003c00000000000000
d40400003c00000000000000
d40400003c00000000000000
d41000003c00000000000000
d40400003c00000000000000
d41000003c00000000000000
-
{e=>-1,c=>2,a=>-40,g=>-1,b=>0,d=>3,f=>0}
d80800000f00000003000000
d80800000f00000003000000
d80800000f00000003000000
d8200000f0000000c0000000
d80800000f00000003000000
d80800000f00000003000000
d8200000f0000000c0000000
d80800000f00000003000000
d8200000f0000000c0000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
};
-
{e=>-2,a=>30,d=>2,c=>0,h=>-1,b=>1,g=>-2,f=>-1}
1e0100003a0000000e000000
1e0100003a0000000e000000
1e0100003a0000000e000000
1e400000ac000000b0000000
1e0100003a0000000e000000
1e0100003a0000000e000000
1e400000ac000000b0000000
1e0100003a0000000e000000
1e400000ac000000b0000000
-
{e=>1,a=>52,d=>3,c=>0,h=>-2,b=>2,g=>0,f=>0}
340200000700000008000000
340200000700000008000000
340200000700000008000000
34800000d000000020000000
340200000700000008000000
340200000700000008000000
34800000d000000020000000
340200000700000008000000
34800000d000000020000000
-
{e=>1,a=>-125,d=>2,c=>2,h=>1,b=>0,g=>1,f=>-1}
830800003600000005000000
830800003600000005000000
830800003600000005000000
832000009c00000050000000
830800003600000005000000
830800003600000005000000
832000009c00000050000000
830800003600000005000000
832000009c00000050000000
-
{e=>-1,a=>70,d=>0,c=>3,h=>-1,b=>3,g=>1,f=>-1}
460f00003c0000000d000000
460f00003c0000000d000000
460f00003c0000000d000000
46f000003c00000070000000
460f00003c0000000d000000
460f00003c0000000d000000
46f000003c00000070000000
460f00003c0000000d000000
46f000003c00000070000000
-
{e=>0,a=>-57,d=>2,c=>3,h=>1,b=>0,g=>-1,f=>-1}
c70c00003200000007000000
c70c00003200000007000000
c70c00003200000007000000
c73000008c000000d0000000
c70c00003200000007000000
c70c00003200000007000000
c73000008c000000d0000000
c70c00003200000007000000
c73000008c000000d0000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
};
-
{e=>-2,a=>122,d=>0,c=>1,h=>0,b=>1,g=>0,f=>0,i=>-2}
7a0500000800000020000000
7a0500000800000020000000
7a0500000800000020000000
7a5000002000000008000000
7a0500000800000020000000
7a0500000800000020000000
7a5000002000000008000000
7a0500000800000020000000
7a5000002000000008000000
-
{e=>-2,a=>76,d=>3,c=>3,h=>-1,b=>2,g=>0,f=>-1,i=>-1}
4c0e00003b0000003c000000
4c0e00003b0000003c000000
4c0e00003b0000003c000000
4cb00000ec0000003c000000
4c0e00003b0000003c000000
4c0e00003b0000003c000000
4cb00000ec0000003c000000
4c0e00003b0000003c000000
4cb00000ec0000003c000000
-
{e=>1,a=>56,d=>3,c=>2,h=>-1,b=>3,g=>-1,f=>1,i=>0}
380b0000170000000f000000
380b0000170000000f000000
380b0000170000000f000000
38e00000d4000000f0000000
380b0000170000000f000000
380b0000170000000f000000
38e00000d4000000f0000000
380b0000170000000f000000
38e00000d4000000f0000000
-
{e=>-2,a=>79,d=>0,c=>1,h=>1,b=>2,g=>-2,f=>0,i=>1}
4f0600000800000016000000
4f0600000800000016000000
4f0600000800000016000000
4f9000002000000094000000
4f0600000800000016000000
4f0600000800000016000000
4f9000002000000094000000
4f0600000800000016000000
4f9000002000000094000000
-
{e=>1,a=>-87,d=>2,c=>1,h=>-1,b=>1,g=>0,f=>0,i=>0}
a9050000060000000c000000
a9050000060000000c000000
a9050000060000000c000000
a95000009000000030000000
a9050000060000000c000000
a9050000060000000c000000
a95000009000000030000000
a9050000060000000c000000
a95000009000000030000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
};
-
{e=>-1,a=>-90,d=>0,c=>2,h=>1,b=>2,g=>0,f=>-2,i=>-2}
a60a00002c00000024000000
a60a00002c00000024000000
a60a00002c00000024000000
a6a000003800000018000000
a60a00002c00000024000000
a60a00002c00000024000000
a6a000003800000018000000
a60a00002c00000024000000
a6a000003800000018000000
-
{e=>-2,a=>-119,d=>1,c=>0,h=>0,b=>2,g=>-2,f=>-1,i=>1}
890200003900000012000000
890200003900000012000000
890200003900000012000000
898000006c00000084000000
890200003900000012000000
890200003900000012000000
898000006c00000084000000
890200003900000012000000
898000006c00000084000000
-
{e=>1,a=>108,d=>3,c=>3,h=>0,b=>3,g=>-1,f=>-1,i=>1}
6c0f00003700000013000000
6c0f00003700000013000000
6c0f00003700000013000000
6cf00000dc000000c4000000
6c0f00003700000013000000
6c0f00003700000013000000
6cf00000dc000000c4000000
6c0f00003700000013000000
6cf00000dc000000c4000000
-
{e=>0,a=>-126,d=>0,c=>3,h=>1,b=>2,g=>-2,f=>0,i=>-1}
820e00000000000036000000
820e00000000000036000000
820e00000000000036000000
82b00000000000009c000000
820e00000000000036000000
820e00000000000036000000
82b00000000000009c000000
820e00000000000036000000
82b00000000000009c000000
-
{e=>1,a=>-120,d=>2,c=>2,h=>0,b=>1,g=>-2,f=>0,i=>-1}
880900000600000032000000
880900000600000032000000
880900000600000032000000
88600000900000008c000000
880900000600000032000000
880900000600000032000000
88600000900000008c000000
880900000600000032000000
88600000900000008c000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
};
-
{e=>1,a=>-105,d=>3,j=>1,c=>3,h=>0,b=>1,g=>-2,f=>-2,i=>0}
970d0000270000000200000001000000
970d0000270000000200000001000000
970d0000270000000200000001000000
97700000d80000008000000040000000
970d0000270000000200000001000000
970d0000270000000200000001000000
97700000d80000008000000040000000
970d0000270000000200000001000000
97700000d80000008000000040000000
-
{e=>0,a=>32,d=>0,j=>0,c=>2,h=>1,b=>2,g=>1,f=>-1,i=>-1}
200a0000300000003500000000000000
200a0000300000003500000000000000
200a0000300000003500000000000000
20a000000c0000005c00000000000000
200a0000300000003500000000000000
200a0000300000003500000000000000
20a000000c0000005c00000000000000
200a0000300000003500000000000000
20a000000c0000005c00000000000000
-
{e=>1,a=>57,d=>1,j=>-2,c=>2,h=>-1,b=>1,g=>-2,f=>-2,i=>1}
39090000250000001e00000002000000
39090000250000001e00000002000000
39090000250000001e00000002000000
3960000058000000b400000080000000
39090000250000001e00000002000000
39090000250000001e00000002000000
3960000058000000b400000080000000
39090000250000001e00000002000000
3960000058000000b400000080000000
-
{e=>0,a=>59,d=>3,j=>-1,c=>0,h=>-2,b=>1,g=>0,f=>1,i=>-2}
3b010000130000002800000003000000
3b010000130000002800000003000000
3b010000130000002800000003000000
3b400000c400000028000000c0000000
3b010000130000002800000003000000
3b010000130000002800000003000000
3b400000c400000028000000c0000000
3b010000130000002800000003000000
3b400000c400000028000000c0000000
-
{e=>-2,a=>68,d=>0,j=>1,c=>0,h=>1,b=>3,g=>0,f=>-2,i=>0}
44030000280000000400000001000000
44030000280000000400000001000000
44030000280000000400000001000000
44c00000280000001000000040000000
44030000280000000400000001000000
44030000280000000400000001000000
44c00000280000001000000040000000
44030000280000000400000001000000
44c00000280000001000000040000000
=
struct mixed2 {
  char a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
  int          k;
};
-
{e=>1,a=>-55,d=>1,j=>-2,c=>3,k=>111,h=>-1,b=>1,g=>-1,f=>0,i=>-1}
c90d0000050000003f000000020000006f000000
c90d0000050000003f000000020000006f000000
c90d0000050000003f000000020000006f000000
c970000050000000fc000000800000000000006f
c90d0000050000003f000000020000006f000000
c90d0000050000003f000000020000006f000000
c970000050000000fc000000800000000000006f
c90d0000050000003f000000020000006f000000
c970000050000000fc000000800000000000006f
-
{e=>-2,a=>-69,d=>3,j=>0,c=>0,k=>-83,h=>0,b=>3,g=>0,f=>-1,i=>1}
bb0300003b0000001000000000000000adffffff
bb0300003b0000001000000000000000adffffff
bb0300003b0000001000000000000000adffffff
bbc00000ec0000000400000000000000ffffffad
bb0300003b0000001000000000000000adffffff
bb0300003b0000001000000000000000adffffff
bbc00000ec0000000400000000000000ffffffad
bb0300003b0000001000000000000000adffffff
bbc00000ec0000000400000000000000ffffffad
-
{e=>0,a=>110,d=>0,j=>0,c=>3,k=>116,h=>-1,b=>3,g=>-2,f=>1,i=>-1}
6e0f0000100000003e0000000000000074000000
6e0f0000100000003e0000000000000074000000
6e0f0000100000003e0000000000000074000000
6ef0000004000000bc0000000000000000000074
6e0f0000100000003e0000000000000074000000
6e0f0000100000003e0000000000000074000000
6ef0000004000000bc0000000000000000000074
6e0f0000100000003e0000000000000074000000
6ef0000004000000bc0000000000000000000074
-
{e=>0,a=>-42,d=>1,j=>-1,c=>0,k=>92,h=>-1,b=>2,g=>1,f=>-2,i=>-2}
d6020000210000002d000000030000005c000000
d6020000210000002d000000030000005c000000
d6020000210000002d000000030000005c000000
d68000004800000078000000c00000000000005c
d6020000210000002d000000030000005c000000
d6020000210000002d000000030000005c000000
d68000004800000078000000c00000000000005c
d6020000210000002d000000030000005c000000
d68000004800000078000000c00000000000005c
-
{e=>-1,a=>-34,d=>0,j=>-2,c=>3,k=>22,h=>-2,b=>2,g=>-1,f=>0,i=>0}
de0e00000c0000000b0000000200000016000000
de0e00000c0000000b0000000200000016000000
de0e00000c0000000b0000000200000016000000
deb0000030000000e00000008000000000000016
de0e00000c0000000b0000000200000016000000
de0e00000c0000000b0000000200000016000000
deb0000030000000e00000008000000000000016
de0e00000c0000000b0000000200000016000000
deb0000030000000e00000008000000000000016
=
struct mixed2 {
  short a;
  unsigned int b:2;
};
-
{a=>-36,b=>3}
dcff0300
dcff0300
dcff0300
ffdcc000
dcff0300
dcff0300
ffdcc000
dcff0300
ffdcc000
-
{a=>77,b=>0}
4d000000
4d000000
4d000000
004d0000
4d000000
4d000000
004d0000
4d000000
004d0000
-
{a=>-125,b=>0}
83ff0000
83ff0000
83ff0000
ff830000
83ff0000
83ff0000
ff830000
83ff0000
ff830000
-
{a=>33,b=>0}
21000000
21000000
21000000
00210000
21000000
21000000
00210000
21000000
00210000
-
{a=>18,b=>3}
12000300
12000300
12000300
0012c000
12000300
12000300
0012c000
12000300
0012c000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
};
-
{c=>2,a=>39,b=>2}
27000a00
27000a00
27000a00
0027a000
27000a00
27000a00
0027a000
27000a00
0027a000
-
{c=>2,a=>-73,b=>3}
b7ff0b00
b7ff0b00
b7ff0b00
ffb7e000
b7ff0b00
b7ff0b00
ffb7e000
b7ff0b00
ffb7e000
-
{c=>2,a=>12,b=>1}
0c000900
0c000900
0c000900
000c6000
0c000900
0c000900
000c6000
0c000900
000c6000
-
{c=>1,a=>107,b=>2}
6b000600
6b000600
6b000600
006b9000
6b000600
6b000600
006b9000
6b000600
006b9000
-
{c=>0,a=>-10,b=>2}
f6ff0200
f6ff0200
f6ff0200
fff68000
f6ff0200
f6ff0200
fff68000
f6ff0200
fff68000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
};
-
{c=>0,a=>-15,b=>0}
f1ff0000
f1ff0000
f1ff0000
fff10000
f1ff0000
f1ff0000
fff10000
f1ff0000
fff10000
-
{c=>2,a=>-103,b=>1}
99ff0900
99ff0900
99ff0900
ff996000
99ff0900
99ff0900
ff996000
99ff0900
ff996000
-
{c=>0,a=>106,b=>3}
6a000300
6a000300
6a000300
006ac000
6a000300
6a000300
006ac000
6a000300
006ac000
-
{c=>0,a=>77,b=>3}
4d000300
4d000300
4d000300
004dc000
4d000300
4d000300
004dc000
4d000300
004dc000
-
{c=>0,a=>-60,b=>2}
c4ff0200
c4ff0200
c4ff0200
ffc48000
c4ff0200
c4ff0200
ffc48000
c4ff0200
ffc48000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
};
-
{c=>3,a=>-90,b=>2,d=>1}
a6ff0e0001000000
a6ff0e0001000000
a6ff0e0001000000
ffa6b00040000000
a6ff0e0001000000
a6ff0e0001000000
ffa6b00040000000
a6ff0e0001000000
ffa6b00040000000
-
{c=>1,a=>-112,b=>3,d=>1}
90ff070001000000
90ff070001000000
90ff070001000000
ff90d00040000000
90ff070001000000
90ff070001000000
ff90d00040000000
90ff070001000000
ff90d00040000000
-
{c=>3,a=>-67,b=>0,d=>1}
bdff0c0001000000
bdff0c0001000000
bdff0c0001000000
ffbd300040000000
bdff0c0001000000
bdff0c0001000000
ffbd300040000000
bdff0c0001000000
ffbd300040000000
-
{c=>1,a=>-2,b=>0,d=>3}
feff040003000000
feff040003000000
feff040003000000
fffe1000c0000000
feff040003000000
feff040003000000
fffe1000c0000000
feff040003000000
fffe1000c0000000
-
{c=>0,a=>-45,b=>1,d=>1}
d3ff010001000000
d3ff010001000000
d3ff010001000000
ffd3400040000000
d3ff010001000000
d3ff010001000000
ffd3400040000000
d3ff010001000000
ffd3400040000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
};
-
{e=>-1,c=>2,a=>-104,b=>2,d=>0}
98ff0a000c000000
98ff0a000c000000
98ff0a000c000000
ff98a00030000000
98ff0a000c000000
98ff0a000c000000
ff98a00030000000
98ff0a000c000000
ff98a00030000000
-
{e=>-2,c=>1,a=>-128,b=>3,d=>2}
80ff07000a000000
80ff07000a000000
80ff07000a000000
ff80d000a0000000
80ff07000a000000
80ff07000a000000
ff80d000a0000000
80ff07000a000000
ff80d000a0000000
-
{e=>1,c=>3,a=>-119,b=>2,d=>1}
89ff0e0005000000
89ff0e0005000000
89ff0e0005000000
ff89b00050000000
89ff0e0005000000
89ff0e0005000000
ff89b00050000000
89ff0e0005000000
ff89b00050000000
-
{e=>-1,c=>3,a=>31,b=>1,d=>0}
1f000d000c000000
1f000d000c000000
1f000d000c000000
001f700030000000
1f000d000c000000
1f000d000c000000
001f700030000000
1f000d000c000000
001f700030000000
-
{e=>-1,c=>0,a=>-28,b=>1,d=>0}
e4ff01000c000000
e4ff01000c000000
e4ff01000c000000
ffe4400030000000
e4ff01000c000000
e4ff01000c000000
ffe4400030000000
e4ff01000c000000
ffe4400030000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
};
-
{e=>-1,c=>0,a=>15,b=>3,d=>0,f=>-2}
0f0003002c000000
0f0003002c000000
0f0003002c000000
000fc00038000000
0f0003002c000000
0f0003002c000000
000fc00038000000
0f0003002c000000
000fc00038000000
-
{e=>-1,c=>2,a=>-51,b=>3,d=>1,f=>0}
cdff0b000d000000
cdff0b000d000000
cdff0b000d000000
ffcde00070000000
cdff0b000d000000
cdff0b000d000000
ffcde00070000000
cdff0b000d000000
ffcde00070000000
-
{e=>-1,c=>2,a=>-69,b=>1,d=>3,f=>1}
bbff09001f000000
bbff09001f000000
bbff09001f000000
ffbb6000f4000000
bbff09001f000000
bbff09001f000000
ffbb6000f4000000
bbff09001f000000
ffbb6000f4000000
-
{e=>1,c=>3,a=>121,b=>2,d=>1,f=>0}
79000e0005000000
79000e0005000000
79000e0005000000
0079b00050000000
79000e0005000000
79000e0005000000
0079b00050000000
79000e0005000000
0079b00050000000
-
{e=>0,c=>2,a=>17,b=>3,d=>3,f=>-1}
11000b0033000000
11000b0033000000
11000b0033000000
0011e000cc000000
11000b0033000000
11000b0033000000
0011e000cc000000
11000b0033000000
0011e000cc000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
};
-
{e=>0,c=>1,a=>-102,b=>2,d=>2,f=>-1}
9aff060032000000
9aff060032000000
9aff060032000000
ff9a90008c000000
9aff060032000000
9aff060032000000
ff9a90008c000000
9aff060032000000
ff9a90008c000000
-
{e=>-2,c=>2,a=>-45,b=>2,d=>2,f=>-2}
d3ff0a002a000000
d3ff0a002a000000
d3ff0a002a000000
ffd3a000a8000000
d3ff0a002a000000
d3ff0a002a000000
ffd3a000a8000000
d3ff0a002a000000
ffd3a000a8000000
-
{e=>-2,c=>3,a=>1,b=>0,d=>1,f=>-1}
01000c0039000000
01000c0039000000
01000c0039000000
000130006c000000
01000c0039000000
01000c0039000000
000130006c000000
01000c0039000000
000130006c000000
-
{e=>1,c=>1,a=>-70,b=>0,d=>1,f=>0}
baff040005000000
baff040005000000
baff040005000000
ffba100050000000
baff040005000000
baff040005000000
ffba100050000000
baff040005000000
ffba100050000000
-
{e=>0,c=>3,a=>-67,b=>3,d=>2,f=>-2}
bdff0f0022000000
bdff0f0022000000
bdff0f0022000000
ffbdf00088000000
bdff0f0022000000
bdff0f0022000000
ffbdf00088000000
bdff0f0022000000
ffbdf00088000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
};
-
{e=>-1,c=>1,a=>-14,g=>-2,b=>2,d=>3,f=>0}
f2ff06000f00000002000000
f2ff06000f00000002000000
f2ff06000f00000002000000
fff29000f000000080000000
f2ff06000f00000002000000
f2ff06000f00000002000000
fff29000f000000080000000
f2ff06000f00000002000000
fff29000f000000080000000
-
{e=>0,c=>2,a=>-82,g=>-2,b=>2,d=>0,f=>0}
aeff0a000000000002000000
aeff0a000000000002000000
aeff0a000000000002000000
ffaea0000000000080000000
aeff0a000000000002000000
aeff0a000000000002000000
ffaea0000000000080000000
aeff0a000000000002000000
ffaea0000000000080000000
-
{e=>1,c=>1,a=>-117,g=>-1,b=>0,d=>3,f=>0}
8bff04000700000003000000
8bff04000700000003000000
8bff04000700000003000000
ff8b1000d0000000c0000000
8bff04000700000003000000
8bff04000700000003000000
ff8b1000d0000000c0000000
8bff04000700000003000000
ff8b1000d0000000c0000000
-
{e=>1,c=>3,a=>-88,g=>1,b=>3,d=>0,f=>0}
a8ff0f000400000001000000
a8ff0f000400000001000000
a8ff0f000400000001000000
ffa8f0001000000040000000
a8ff0f000400000001000000
a8ff0f000400000001000000
ffa8f0001000000040000000
a8ff0f000400000001000000
ffa8f0001000000040000000
-
{e=>0,c=>3,a=>38,g=>0,b=>3,d=>1,f=>-1}
26000f003100000000000000
26000f003100000000000000
26000f003100000000000000
0026f0004c00000000000000
26000f003100000000000000
26000f003100000000000000
0026f0004c00000000000000
26000f003100000000000000
0026f0004c00000000000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
};
-
{e=>0,a=>14,d=>3,c=>1,h=>-2,b=>2,g=>-2,f=>-2}
0e000600230000000a000000
0e000600230000000a000000
0e000600230000000a000000
000e9000c8000000a0000000
0e000600230000000a000000
0e000600230000000a000000
000e9000c8000000a0000000
0e000600230000000a000000
000e9000c8000000a0000000
-
{e=>1,a=>73,d=>0,c=>0,h=>-1,b=>3,g=>0,f=>0}
49000300040000000c000000
49000300040000000c000000
49000300040000000c000000
0049c0001000000030000000
49000300040000000c000000
49000300040000000c000000
0049c0001000000030000000
49000300040000000c000000
0049c0001000000030000000
-
{e=>-2,a=>5,d=>2,c=>1,h=>-1,b=>2,g=>1,f=>-2}
050006002a0000000d000000
050006002a0000000d000000
050006002a0000000d000000
00059000a800000070000000
050006002a0000000d000000
050006002a0000000d000000
00059000a800000070000000
050006002a0000000d000000
00059000a800000070000000
-
{e=>0,a=>-57,d=>2,c=>0,h=>-1,b=>0,g=>0,f=>1}
c7ff0000120000000c000000
c7ff0000120000000c000000
c7ff0000120000000c000000
ffc700008400000030000000
c7ff0000120000000c000000
c7ff0000120000000c000000
ffc700008400000030000000
c7ff0000120000000c000000
ffc700008400000030000000
-
{e=>-1,a=>-21,d=>0,c=>3,h=>-1,b=>0,g=>-1,f=>1}
ebff0c001c0000000f000000
ebff0c001c0000000f000000
ebff0c001c0000000f000000
ffeb300034000000f0000000
ebff0c001c0000000f000000
ebff0c001c0000000f000000
ffeb300034000000f0000000
ebff0c001c0000000f000000
ffeb300034000000f0000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
};
-
{e=>-2,a=>64,d=>3,c=>1,h=>1,b=>0,g=>1,f=>0,i=>-2}
400004000b00000025000000
400004000b00000025000000
400004000b00000025000000
00401000e000000058000000
400004000b00000025000000
400004000b00000025000000
00401000e000000058000000
400004000b00000025000000
00401000e000000058000000
-
{e=>-1,a=>-28,d=>2,c=>0,h=>-2,b=>3,g=>-1,f=>-1,i=>-1}
e4ff03003e0000003b000000
e4ff03003e0000003b000000
e4ff03003e0000003b000000
ffe4c000bc000000ec000000
e4ff03003e0000003b000000
e4ff03003e0000003b000000
ffe4c000bc000000ec000000
e4ff03003e0000003b000000
ffe4c000bc000000ec000000
-
{e=>-1,a=>16,d=>0,c=>1,h=>0,b=>2,g=>-1,f=>1,i=>-1}
100006001c00000033000000
100006001c00000033000000
100006001c00000033000000
0010900034000000cc000000
100006001c00000033000000
100006001c00000033000000
0010900034000000cc000000
100006001c00000033000000
0010900034000000cc000000
-
{e=>1,a=>-116,d=>0,c=>2,h=>-1,b=>3,g=>0,f=>-2,i=>0}
8cff0b00240000000c000000
8cff0b00240000000c000000
8cff0b00240000000c000000
ff8ce0001800000030000000
8cff0b00240000000c000000
8cff0b00240000000c000000
ff8ce0001800000030000000
8cff0b00240000000c000000
ff8ce0001800000030000000
-
{e=>0,a=>-24,d=>0,c=>0,h=>-1,b=>1,g=>1,f=>-2,i=>0}
e8ff0100200000000d000000
e8ff0100200000000d000000
e8ff0100200000000d000000
ffe840000800000070000000
e8ff0100200000000d000000
e8ff0100200000000d000000
ffe840000800000070000000
e8ff0100200000000d000000
ffe840000800000070000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
};
-
{e=>0,a=>-98,d=>3,c=>1,h=>-2,b=>3,g=>-2,f=>1,i=>-1}
9eff0700130000003a000000
9eff0700130000003a000000
9eff0700130000003a000000
ff9ed000c4000000ac000000
9eff0700130000003a000000
9eff0700130000003a000000
ff9ed000c4000000ac000000
9eff0700130000003a000000
ff9ed000c4000000ac000000
-
{e=>1,a=>87,d=>3,c=>2,h=>-1,b=>2,g=>-1,f=>-2,i=>-1}
57000a00270000003f000000
57000a00270000003f000000
57000a00270000003f000000
0057a000d8000000fc000000
57000a00270000003f000000
57000a00270000003f000000
0057a000d8000000fc000000
57000a00270000003f000000
0057a000d8000000fc000000
-
{e=>1,a=>-69,d=>2,c=>1,h=>0,b=>3,g=>0,f=>-2,i=>-1}
bbff07002600000030000000
bbff07002600000030000000
bbff07002600000030000000
ffbbd000980000000c000000
bbff07002600000030000000
bbff07002600000030000000
ffbbd000980000000c000000
bbff07002600000030000000
ffbbd000980000000c000000
-
{e=>-1,a=>-28,d=>3,c=>0,h=>-1,b=>1,g=>-1,f=>0,i=>-2}
e4ff01000f0000002f000000
e4ff01000f0000002f000000
e4ff01000f0000002f000000
ffe44000f0000000f8000000
e4ff01000f0000002f000000
e4ff01000f0000002f000000
ffe44000f0000000f8000000
e4ff01000f0000002f000000
ffe44000f0000000f8000000
-
{e=>0,a=>58,d=>3,c=>3,h=>0,b=>3,g=>-2,f=>-1,i=>0}
3a000f003300000002000000
3a000f003300000002000000
3a000f003300000002000000
003af000cc00000080000000
3a000f003300000002000000
3a000f003300000002000000
003af000cc00000080000000
3a000f003300000002000000
003af000cc00000080000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
};
-
{e=>0,a=>-102,d=>3,j=>-2,c=>1,h=>0,b=>2,g=>0,f=>0,i=>-1}
9aff0600030000003000000002000000
9aff0600030000003000000002000000
9aff0600030000003000000002000000
ff9a9000c00000000c00000080000000
9aff0600030000003000000002000000
9aff0600030000003000000002000000
ff9a9000c00000000c00000080000000
9aff0600030000003000000002000000
ff9a9000c00000000c00000080000000
-
{e=>-1,a=>-12,d=>1,j=>1,c=>1,h=>-2,b=>0,g=>-2,f=>1,i=>-2}
f4ff04001d0000002a00000001000000
f4ff04001d0000002a00000001000000
f4ff04001d0000002a00000001000000
fff4100074000000a800000040000000
f4ff04001d0000002a00000001000000
f4ff04001d0000002a00000001000000
fff4100074000000a800000040000000
f4ff04001d0000002a00000001000000
fff4100074000000a800000040000000
-
{e=>-2,a=>98,d=>3,j=>1,c=>0,h=>0,b=>0,g=>-1,f=>-2,i=>-2}
620000002b0000002300000001000000
620000002b0000002300000001000000
620000002b0000002300000001000000
00620000e8000000c800000040000000
620000002b0000002300000001000000
620000002b0000002300000001000000
00620000e8000000c800000040000000
620000002b0000002300000001000000
00620000e8000000c800000040000000
-
{e=>-1,a=>-38,d=>3,j=>-1,c=>1,h=>-1,b=>1,g=>-2,f=>0,i=>1}
daff05000f0000001e00000003000000
daff05000f0000001e00000003000000
daff05000f0000001e00000003000000
ffda5000f0000000b4000000c0000000
daff05000f0000001e00000003000000
daff05000f0000001e00000003000000
ffda5000f0000000b4000000c0000000
daff05000f0000001e00000003000000
ffda5000f0000000b4000000c0000000
-
{e=>1,a=>0,d=>2,j=>-2,c=>1,h=>0,b=>2,g=>1,f=>-2,i=>0}
00000600260000000100000002000000
00000600260000000100000002000000
00000600260000000100000002000000
00009000980000004000000080000000
00000600260000000100000002000000
00000600260000000100000002000000
00009000980000004000000080000000
00000600260000000100000002000000
00009000980000004000000080000000
=
struct mixed2 {
  short a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
  int          k;
};
-
{e=>-1,a=>-67,d=>0,j=>-2,c=>2,k=>-19,h=>1,b=>0,g=>0,f=>-1,i=>1}
bdff08003c0000001400000002000000edffffff
bdff08003c0000001400000002000000edffffff
bdff08003c0000001400000002000000edffffff
ffbd20003c0000001400000080000000ffffffed
bdff08003c0000001400000002000000edffffff
bdff08003c0000001400000002000000edffffff
ffbd20003c0000001400000080000000ffffffed
bdff08003c0000001400000002000000edffffff
ffbd20003c0000001400000080000000ffffffed
-
{e=>0,a=>-109,d=>2,j=>0,c=>1,k=>116,h=>0,b=>0,g=>1,f=>1,i=>-1}
93ff040012000000310000000000000074000000
93ff040012000000310000000000000074000000
93ff040012000000310000000000000074000000
ff931000840000004c0000000000000000000074
93ff040012000000310000000000000074000000
93ff040012000000310000000000000074000000
ff931000840000004c0000000000000000000074
93ff040012000000310000000000000074000000
ff931000840000004c0000000000000000000074
-
{e=>0,a=>102,d=>0,j=>1,c=>3,k=>116,h=>1,b=>2,g=>0,f=>1,i=>1}
66000e0010000000140000000100000074000000
66000e0010000000140000000100000074000000
66000e0010000000140000000100000074000000
0066b00004000000140000004000000000000074
66000e0010000000140000000100000074000000
66000e0010000000140000000100000074000000
0066b00004000000140000004000000000000074
66000e0010000000140000000100000074000000
0066b00004000000140000004000000000000074
-
{e=>0,a=>27,d=>1,j=>-1,c=>0,k=>-116,h=>-2,b=>2,g=>1,f=>-1,i=>-1}
1b0002003100000039000000030000008cffffff
1b0002003100000039000000030000008cffffff
1b0002003100000039000000030000008cffffff
001b80004c0000006c000000c0000000ffffff8c
1b0002003100000039000000030000008cffffff
1b0002003100000039000000030000008cffffff
001b80004c0000006c000000c0000000ffffff8c
1b0002003100000039000000030000008cffffff
001b80004c0000006c000000c0000000ffffff8c
-
{e=>1,a=>-68,d=>0,j=>-1,c=>3,k=>-47,h=>-1,b=>1,g=>0,f=>0,i=>-2}
bcff0d00040000002c00000003000000d1ffffff
bcff0d00040000002c00000003000000d1ffffff
bcff0d00040000002c00000003000000d1ffffff
ffbc70001000000038000000c0000000ffffffd1
bcff0d00040000002c00000003000000d1ffffff
bcff0d00040000002c00000003000000d1ffffff
ffbc70001000000038000000c0000000ffffffd1
bcff0d00040000002c00000003000000d1ffffff
ffbc70001000000038000000c0000000ffffffd1
=
struct mixed2 {
  int a;
  unsigned int b:2;
};
-
{a=>-99,b=>3}
9dffffff03000000
9dffffff03000000
9dffffff03000000
ffffff9dc0000000
9dffffff03000000
9dffffff03000000
ffffff9dc0000000
9dffffff03000000
ffffff9dc0000000
-
{a=>-83,b=>3}
adffffff03000000
adffffff03000000
adffffff03000000
ffffffadc0000000
adffffff03000000
adffffff03000000
ffffffadc0000000
adffffff03000000
ffffffadc0000000
-
{a=>15,b=>2}
0f00000002000000
0f00000002000000
0f00000002000000
0000000f80000000
0f00000002000000
0f00000002000000
0000000f80000000
0f00000002000000
0000000f80000000
-
{a=>60,b=>1}
3c00000001000000
3c00000001000000
3c00000001000000
0000003c40000000
3c00000001000000
3c00000001000000
0000003c40000000
3c00000001000000
0000003c40000000
-
{a=>15,b=>2}
0f00000002000000
0f00000002000000
0f00000002000000
0000000f80000000
0f00000002000000
0f00000002000000
0000000f80000000
0f00000002000000
0000000f80000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
};
-
{c=>2,a=>64,b=>2}
400000000a000000
400000000a000000
400000000a000000
00000040a0000000
400000000a000000
400000000a000000
00000040a0000000
400000000a000000
00000040a0000000
-
{c=>3,a=>21,b=>3}
150000000f000000
150000000f000000
150000000f000000
00000015f0000000
150000000f000000
150000000f000000
00000015f0000000
150000000f000000
00000015f0000000
-
{c=>1,a=>88,b=>1}
5800000005000000
5800000005000000
5800000005000000
0000005850000000
5800000005000000
5800000005000000
0000005850000000
5800000005000000
0000005850000000
-
{c=>2,a=>-84,b=>2}
acffffff0a000000
acffffff0a000000
acffffff0a000000
ffffffaca0000000
acffffff0a000000
acffffff0a000000
ffffffaca0000000
acffffff0a000000
ffffffaca0000000
-
{c=>3,a=>127,b=>2}
7f0000000e000000
7f0000000e000000
7f0000000e000000
0000007fb0000000
7f0000000e000000
7f0000000e000000
0000007fb0000000
7f0000000e000000
0000007fb0000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
};
-
{c=>0,a=>-11,b=>2}
f5ffffff02000000
f5ffffff02000000
f5ffffff02000000
fffffff580000000
f5ffffff02000000
f5ffffff02000000
fffffff580000000
f5ffffff02000000
fffffff580000000
-
{c=>1,a=>-114,b=>1}
8effffff05000000
8effffff05000000
8effffff05000000
ffffff8e50000000
8effffff05000000
8effffff05000000
ffffff8e50000000
8effffff05000000
ffffff8e50000000
-
{c=>3,a=>-66,b=>1}
beffffff0d000000
beffffff0d000000
beffffff0d000000
ffffffbe70000000
beffffff0d000000
beffffff0d000000
ffffffbe70000000
beffffff0d000000
ffffffbe70000000
-
{c=>2,a=>-101,b=>1}
9bffffff09000000
9bffffff09000000
9bffffff09000000
ffffff9b60000000
9bffffff09000000
9bffffff09000000
ffffff9b60000000
9bffffff09000000
ffffff9b60000000
-
{c=>2,a=>51,b=>3}
330000000b000000
330000000b000000
330000000b000000
00000033e0000000
330000000b000000
330000000b000000
00000033e0000000
330000000b000000
00000033e0000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
};
-
{c=>3,a=>71,b=>3,d=>2}
470000000f00000002000000
470000000f00000002000000
470000000f00000002000000
00000047f000000080000000
470000000f00000002000000
470000000f00000002000000
00000047f000000080000000
470000000f00000002000000
00000047f000000080000000
-
{c=>0,a=>-59,b=>3,d=>2}
c5ffffff0300000002000000
c5ffffff0300000002000000
c5ffffff0300000002000000
ffffffc5c000000080000000
c5ffffff0300000002000000
c5ffffff0300000002000000
ffffffc5c000000080000000
c5ffffff0300000002000000
ffffffc5c000000080000000
-
{c=>1,a=>-34,b=>1,d=>2}
deffffff0500000002000000
deffffff0500000002000000
deffffff0500000002000000
ffffffde5000000080000000
deffffff0500000002000000
deffffff0500000002000000
ffffffde5000000080000000
deffffff0500000002000000
ffffffde5000000080000000
-
{c=>1,a=>-50,b=>0,d=>2}
ceffffff0400000002000000
ceffffff0400000002000000
ceffffff0400000002000000
ffffffce1000000080000000
ceffffff0400000002000000
ceffffff0400000002000000
ffffffce1000000080000000
ceffffff0400000002000000
ffffffce1000000080000000
-
{c=>2,a=>98,b=>3,d=>1}
620000000b00000001000000
620000000b00000001000000
620000000b00000001000000
00000062e000000040000000
620000000b00000001000000
620000000b00000001000000
00000062e000000040000000
620000000b00000001000000
00000062e000000040000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
};
-
{e=>0,c=>2,a=>-115,b=>0,d=>3}
8dffffff0800000003000000
8dffffff0800000003000000
8dffffff0800000003000000
ffffff8d20000000c0000000
8dffffff0800000003000000
8dffffff0800000003000000
ffffff8d20000000c0000000
8dffffff0800000003000000
ffffff8d20000000c0000000
-
{e=>0,c=>2,a=>120,b=>0,d=>1}
780000000800000001000000
780000000800000001000000
780000000800000001000000
000000782000000040000000
780000000800000001000000
780000000800000001000000
000000782000000040000000
780000000800000001000000
000000782000000040000000
-
{e=>-1,c=>3,a=>-67,b=>0,d=>1}
bdffffff0c0000000d000000
bdffffff0c0000000d000000
bdffffff0c0000000d000000
ffffffbd3000000070000000
bdffffff0c0000000d000000
bdffffff0c0000000d000000
ffffffbd3000000070000000
bdffffff0c0000000d000000
ffffffbd3000000070000000
-
{e=>-2,c=>2,a=>52,b=>2,d=>0}
340000000a00000008000000
340000000a00000008000000
340000000a00000008000000
00000034a000000020000000
340000000a00000008000000
340000000a00000008000000
00000034a000000020000000
340000000a00000008000000
00000034a000000020000000
-
{e=>-1,c=>2,a=>94,b=>3,d=>2}
5e0000000b0000000e000000
5e0000000b0000000e000000
5e0000000b0000000e000000
0000005ee0000000b0000000
5e0000000b0000000e000000
5e0000000b0000000e000000
0000005ee0000000b0000000
5e0000000b0000000e000000
0000005ee0000000b0000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
};
-
{e=>0,c=>3,a=>-74,b=>1,d=>1,f=>1}
b6ffffff0d00000011000000
b6ffffff0d00000011000000
b6ffffff0d00000011000000
ffffffb67000000044000000
b6ffffff0d00000011000000
b6ffffff0d00000011000000
ffffffb67000000044000000
b6ffffff0d00000011000000
ffffffb67000000044000000
-
{e=>-1,c=>3,a=>117,b=>2,d=>1,f=>1}
750000000e0000001d000000
750000000e0000001d000000
750000000e0000001d000000
00000075b000000074000000
750000000e0000001d000000
750000000e0000001d000000
00000075b000000074000000
750000000e0000001d000000
00000075b000000074000000
-
{e=>1,c=>1,a=>-117,b=>0,d=>2,f=>-2}
8bffffff0400000026000000
8bffffff0400000026000000
8bffffff0400000026000000
ffffff8b1000000098000000
8bffffff0400000026000000
8bffffff0400000026000000
ffffff8b1000000098000000
8bffffff0400000026000000
ffffff8b1000000098000000
-
{e=>-2,c=>1,a=>-90,b=>1,d=>0,f=>-2}
a6ffffff0500000028000000
a6ffffff0500000028000000
a6ffffff0500000028000000
ffffffa65000000028000000
a6ffffff0500000028000000
a6ffffff0500000028000000
ffffffa65000000028000000
a6ffffff0500000028000000
ffffffa65000000028000000
-
{e=>-1,c=>2,a=>41,b=>0,d=>3,f=>0}
29000000080000000f000000
29000000080000000f000000
29000000080000000f000000
0000002920000000f0000000
29000000080000000f000000
29000000080000000f000000
0000002920000000f0000000
29000000080000000f000000
0000002920000000f0000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
};
-
{e=>0,c=>3,a=>-75,b=>1,d=>1,f=>0}
b5ffffff0d00000001000000
b5ffffff0d00000001000000
b5ffffff0d00000001000000
ffffffb57000000040000000
b5ffffff0d00000001000000
b5ffffff0d00000001000000
ffffffb57000000040000000
b5ffffff0d00000001000000
ffffffb57000000040000000
-
{e=>1,c=>3,a=>-74,b=>1,d=>1,f=>0}
b6ffffff0d00000005000000
b6ffffff0d00000005000000
b6ffffff0d00000005000000
ffffffb67000000050000000
b6ffffff0d00000005000000
b6ffffff0d00000005000000
ffffffb67000000050000000
b6ffffff0d00000005000000
ffffffb67000000050000000
-
{e=>-2,c=>0,a=>7,b=>2,d=>2,f=>0}
07000000020000000a000000
07000000020000000a000000
07000000020000000a000000
0000000780000000a0000000
07000000020000000a000000
07000000020000000a000000
0000000780000000a0000000
07000000020000000a000000
0000000780000000a0000000
-
{e=>-1,c=>0,a=>-14,b=>3,d=>2,f=>-1}
f2ffffff030000003e000000
f2ffffff030000003e000000
f2ffffff030000003e000000
fffffff2c0000000bc000000
f2ffffff030000003e000000
f2ffffff030000003e000000
fffffff2c0000000bc000000
f2ffffff030000003e000000
fffffff2c0000000bc000000
-
{e=>0,c=>2,a=>-68,b=>1,d=>3,f=>-2}
bcffffff0900000023000000
bcffffff0900000023000000
bcffffff0900000023000000
ffffffbc60000000c8000000
bcffffff0900000023000000
bcffffff0900000023000000
ffffffbc60000000c8000000
bcffffff0900000023000000
ffffffbc60000000c8000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
};
-
{e=>-1,c=>0,a=>-121,g=>-2,b=>1,d=>0,f=>-2}
87ffffff010000002c00000002000000
87ffffff010000002c00000002000000
87ffffff010000002c00000002000000
ffffff87400000003800000080000000
87ffffff010000002c00000002000000
87ffffff010000002c00000002000000
ffffff87400000003800000080000000
87ffffff010000002c00000002000000
ffffff87400000003800000080000000
-
{e=>-2,c=>2,a=>125,g=>-2,b=>3,d=>3,f=>-2}
7d0000000b0000002b00000002000000
7d0000000b0000002b00000002000000
7d0000000b0000002b00000002000000
0000007de0000000e800000080000000
7d0000000b0000002b00000002000000
7d0000000b0000002b00000002000000
0000007de0000000e800000080000000
7d0000000b0000002b00000002000000
0000007de0000000e800000080000000
-
{e=>-2,c=>0,a=>23,g=>-2,b=>0,d=>0,f=>1}
17000000000000001800000002000000
17000000000000001800000002000000
17000000000000001800000002000000
00000017000000002400000080000000
17000000000000001800000002000000
17000000000000001800000002000000
00000017000000002400000080000000
17000000000000001800000002000000
00000017000000002400000080000000
-
{e=>-2,c=>0,a=>-89,g=>1,b=>2,d=>2,f=>-1}
a7ffffff020000003a00000001000000
a7ffffff020000003a00000001000000
a7ffffff020000003a00000001000000
ffffffa780000000ac00000040000000
a7ffffff020000003a00000001000000
a7ffffff020000003a00000001000000
ffffffa780000000ac00000040000000
a7ffffff020000003a00000001000000
ffffffa780000000ac00000040000000
-
{e=>-1,c=>3,a=>46,g=>1,b=>1,d=>1,f=>0}
2e0000000d0000000d00000001000000
2e0000000d0000000d00000001000000
2e0000000d0000000d00000001000000
0000002e700000007000000040000000
2e0000000d0000000d00000001000000
2e0000000d0000000d00000001000000
0000002e700000007000000040000000
2e0000000d0000000d00000001000000
0000002e700000007000000040000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
};
-
{e=>-2,a=>-37,d=>1,c=>1,h=>0,b=>0,g=>1,f=>-1}
dbffffff040000003900000001000000
dbffffff040000003900000001000000
dbffffff040000003900000001000000
ffffffdb100000006c00000040000000
dbffffff040000003900000001000000
dbffffff040000003900000001000000
ffffffdb100000006c00000040000000
dbffffff040000003900000001000000
ffffffdb100000006c00000040000000
-
{e=>0,a=>-96,d=>3,c=>3,h=>1,b=>0,g=>-2,f=>1}
a0ffffff0c0000001300000006000000
a0ffffff0c0000001300000006000000
a0ffffff0c0000001300000006000000
ffffffa030000000c400000090000000
a0ffffff0c0000001300000006000000
a0ffffff0c0000001300000006000000
ffffffa030000000c400000090000000
a0ffffff0c0000001300000006000000
ffffffa030000000c400000090000000
-
{e=>-1,a=>-27,d=>1,c=>3,h=>-1,b=>1,g=>1,f=>-1}
e5ffffff0d0000003d0000000d000000
e5ffffff0d0000003d0000000d000000
e5ffffff0d0000003d0000000d000000
ffffffe5700000007c00000070000000
e5ffffff0d0000003d0000000d000000
e5ffffff0d0000003d0000000d000000
ffffffe5700000007c00000070000000
e5ffffff0d0000003d0000000d000000
ffffffe5700000007c00000070000000
-
{e=>-2,a=>-117,d=>3,c=>2,h=>-2,b=>1,g=>-1,f=>-2}
8bffffff090000002b0000000b000000
8bffffff090000002b0000000b000000
8bffffff090000002b0000000b000000
ffffff8b60000000e8000000e0000000
8bffffff090000002b0000000b000000
8bffffff090000002b0000000b000000
ffffff8b60000000e8000000e0000000
8bffffff090000002b0000000b000000
ffffff8b60000000e8000000e0000000
-
{e=>1,a=>-10,d=>0,c=>0,h=>-2,b=>0,g=>1,f=>1}
f6ffffff000000001400000009000000
f6ffffff000000001400000009000000
f6ffffff000000001400000009000000
fffffff6000000001400000060000000
f6ffffff000000001400000009000000
f6ffffff000000001400000009000000
fffffff6000000001400000060000000
f6ffffff000000001400000009000000
fffffff6000000001400000060000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
};
-
{e=>1,a=>-4,d=>3,c=>3,h=>-2,b=>0,g=>1,f=>-1,i=>-1}
fcffffff0c0000003700000039000000
fcffffff0c0000003700000039000000
fcffffff0c0000003700000039000000
fffffffc30000000dc0000006c000000
fcffffff0c0000003700000039000000
fcffffff0c0000003700000039000000
fffffffc30000000dc0000006c000000
fcffffff0c0000003700000039000000
fffffffc30000000dc0000006c000000
-
{e=>0,a=>98,d=>2,c=>2,h=>0,b=>2,g=>0,f=>1,i=>-2}
620000000a0000001200000020000000
620000000a0000001200000020000000
620000000a0000001200000020000000
00000062a00000008400000008000000
620000000a0000001200000020000000
620000000a0000001200000020000000
00000062a00000008400000008000000
620000000a0000001200000020000000
00000062a00000008400000008000000
-
{e=>1,a=>40,d=>3,c=>2,h=>1,b=>3,g=>0,f=>-1,i=>1}
280000000b0000003700000014000000
280000000b0000003700000014000000
280000000b0000003700000014000000
00000028e0000000dc00000014000000
280000000b0000003700000014000000
280000000b0000003700000014000000
00000028e0000000dc00000014000000
280000000b0000003700000014000000
00000028e0000000dc00000014000000
-
{e=>0,a=>-91,d=>0,c=>3,h=>0,b=>2,g=>-1,f=>-1,i=>-1}
a5ffffff0e0000003000000033000000
a5ffffff0e0000003000000033000000
a5ffffff0e0000003000000033000000
ffffffa5b00000000c000000cc000000
a5ffffff0e0000003000000033000000
a5ffffff0e0000003000000033000000
ffffffa5b00000000c000000cc000000
a5ffffff0e0000003000000033000000
ffffffa5b00000000c000000cc000000
-
{e=>0,a=>111,d=>2,c=>1,h=>-1,b=>0,g=>-2,f=>-2,i=>-1}
6f00000004000000220000003e000000
6f00000004000000220000003e000000
6f00000004000000220000003e000000
0000006f1000000088000000bc000000
6f00000004000000220000003e000000
6f00000004000000220000003e000000
0000006f1000000088000000bc000000
6f00000004000000220000003e000000
0000006f1000000088000000bc000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
};
-
{e=>0,a=>-110,d=>2,c=>3,h=>-1,b=>1,g=>0,f=>-2,i=>0}
92ffffff0d000000220000000c000000
92ffffff0d000000220000000c000000
92ffffff0d000000220000000c000000
ffffff92700000008800000030000000
92ffffff0d000000220000000c000000
92ffffff0d000000220000000c000000
ffffff92700000008800000030000000
92ffffff0d000000220000000c000000
ffffff92700000008800000030000000
-
{e=>-2,a=>-48,d=>1,c=>0,h=>-2,b=>3,g=>1,f=>0,i=>1}
d0ffffff030000000900000019000000
d0ffffff030000000900000019000000
d0ffffff030000000900000019000000
ffffffd0c00000006000000064000000
d0ffffff030000000900000019000000
d0ffffff030000000900000019000000
ffffffd0c00000006000000064000000
d0ffffff030000000900000019000000
ffffffd0c00000006000000064000000
-
{e=>-1,a=>107,d=>3,c=>3,h=>0,b=>3,g=>1,f=>1,i=>0}
6b0000000f0000001f00000001000000
6b0000000f0000001f00000001000000
6b0000000f0000001f00000001000000
0000006bf0000000f400000040000000
6b0000000f0000001f00000001000000
6b0000000f0000001f00000001000000
0000006bf0000000f400000040000000
6b0000000f0000001f00000001000000
0000006bf0000000f400000040000000
-
{e=>-1,a=>23,d=>3,c=>0,h=>-2,b=>0,g=>0,f=>0,i=>1}
17000000000000000f00000018000000
17000000000000000f00000018000000
17000000000000000f00000018000000
0000001700000000f000000024000000
17000000000000000f00000018000000
17000000000000000f00000018000000
0000001700000000f000000024000000
17000000000000000f00000018000000
0000001700000000f000000024000000
-
{e=>-2,a=>-85,d=>3,c=>2,h=>0,b=>1,g=>0,f=>-1,i=>1}
abffffff090000003b00000010000000
abffffff090000003b00000010000000
abffffff090000003b00000010000000
ffffffab60000000ec00000004000000
abffffff090000003b00000010000000
abffffff090000003b00000010000000
ffffffab60000000ec00000004000000
abffffff090000003b00000010000000
ffffffab60000000ec00000004000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
};
-
{e=>0,a=>-100,d=>3,j=>-1,c=>2,h=>-1,b=>1,g=>-1,f=>-1,i=>-1}
9cffffff09000000330000003f00000003000000
9cffffff09000000330000003f00000003000000
9cffffff09000000330000003f00000003000000
ffffff9c60000000cc000000fc000000c0000000
9cffffff09000000330000003f00000003000000
9cffffff09000000330000003f00000003000000
ffffff9c60000000cc000000fc000000c0000000
9cffffff09000000330000003f00000003000000
ffffff9c60000000cc000000fc000000c0000000
-
{e=>1,a=>18,d=>0,j=>1,c=>2,h=>-2,b=>2,g=>1,f=>-2,i=>0}
120000000a000000240000000900000001000000
120000000a000000240000000900000001000000
120000000a000000240000000900000001000000
00000012a0000000180000006000000040000000
120000000a000000240000000900000001000000
120000000a000000240000000900000001000000
00000012a0000000180000006000000040000000
120000000a000000240000000900000001000000
00000012a0000000180000006000000040000000
-
{e=>-2,a=>-36,d=>1,j=>0,c=>0,h=>-2,b=>2,g=>-1,f=>0,i=>-1}
dcffffff02000000090000003b00000000000000
dcffffff02000000090000003b00000000000000
dcffffff02000000090000003b00000000000000
ffffffdc8000000060000000ec00000000000000
dcffffff02000000090000003b00000000000000
dcffffff02000000090000003b00000000000000
ffffffdc8000000060000000ec00000000000000
dcffffff02000000090000003b00000000000000
ffffffdc8000000060000000ec00000000000000
-
{e=>1,a=>-45,d=>0,j=>0,c=>0,h=>0,b=>0,g=>1,f=>0,i=>-1}
d3ffffff00000000040000003100000000000000
d3ffffff00000000040000003100000000000000
d3ffffff00000000040000003100000000000000
ffffffd300000000100000004c00000000000000
d3ffffff00000000040000003100000000000000
d3ffffff00000000040000003100000000000000
ffffffd300000000100000004c00000000000000
d3ffffff00000000040000003100000000000000
ffffffd300000000100000004c00000000000000
-
{e=>-2,a=>103,d=>3,j=>-2,c=>0,h=>1,b=>0,g=>1,f=>0,i=>1}
67000000000000000b0000001500000002000000
67000000000000000b0000001500000002000000
67000000000000000b0000001500000002000000
0000006700000000e00000005400000080000000
67000000000000000b0000001500000002000000
67000000000000000b0000001500000002000000
0000006700000000e00000005400000080000000
67000000000000000b0000001500000002000000
0000006700000000e00000005400000080000000
=
struct mixed2 {
  int a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
  int          k;
};
-
{e=>-2,a=>108,d=>3,j=>-2,c=>0,k=>-117,h=>1,b=>0,g=>1,f=>-1,i=>-1}
6c000000000000003b00000035000000020000008bffffff
6c000000000000003b00000035000000020000008bffffff
6c000000000000003b00000035000000020000008bffffff
0000006c00000000ec0000005c00000080000000ffffff8b
6c000000000000003b00000035000000020000008bffffff
6c000000000000003b00000035000000020000008bffffff
0000006c00000000ec0000005c00000080000000ffffff8b
6c000000000000003b00000035000000020000008bffffff
0000006c00000000ec0000005c00000080000000ffffff8b
-
{e=>-1,a=>43,d=>1,j=>-1,c=>1,k=>16,h=>-2,b=>2,g=>-2,f=>-2,i=>1}
2b000000060000002d0000001a0000000300000010000000
2b000000060000002d0000001a0000000300000010000000
2b000000060000002d0000001a0000000300000010000000
0000002b9000000078000000a4000000c000000000000010
2b000000060000002d0000001a0000000300000010000000
2b000000060000002d0000001a0000000300000010000000
0000002b9000000078000000a4000000c000000000000010
2b000000060000002d0000001a0000000300000010000000
0000002b9000000078000000a4000000c000000000000010
-
{e=>1,a=>-38,d=>0,j=>0,c=>3,k=>-25,h=>-1,b=>0,g=>-1,f=>0,i=>1}
daffffff0c000000040000001f00000000000000e7ffffff
daffffff0c000000040000001f00000000000000e7ffffff
daffffff0c000000040000001f00000000000000e7ffffff
ffffffda3000000010000000f400000000000000ffffffe7
daffffff0c000000040000001f00000000000000e7ffffff
daffffff0c000000040000001f00000000000000e7ffffff
ffffffda3000000010000000f400000000000000ffffffe7
daffffff0c000000040000001f00000000000000e7ffffff
ffffffda3000000010000000f400000000000000ffffffe7
-
{e=>0,a=>-93,d=>3,j=>0,c=>1,k=>23,h=>-2,b=>1,g=>-1,f=>0,i=>0}
a3ffffff05000000030000000b0000000000000017000000
a3ffffff05000000030000000b0000000000000017000000
a3ffffff05000000030000000b0000000000000017000000
ffffffa350000000c0000000e00000000000000000000017
a3ffffff05000000030000000b0000000000000017000000
a3ffffff05000000030000000b0000000000000017000000
ffffffa350000000c0000000e00000000000000000000017
a3ffffff05000000030000000b0000000000000017000000
ffffffa350000000c0000000e00000000000000000000017
-
{e=>0,a=>108,d=>2,j=>-1,c=>1,k=>90,h=>-2,b=>0,g=>-2,f=>0,i=>1}
6c00000004000000020000001a000000030000005a000000
6c00000004000000020000001a000000030000005a000000
6c00000004000000020000001a000000030000005a000000
0000006c1000000080000000a4000000c00000000000005a
6c00000004000000020000001a000000030000005a000000
6c00000004000000020000001a000000030000005a000000
0000006c1000000080000000a4000000c00000000000005a
6c00000004000000020000001a000000030000005a000000
0000006c1000000080000000a4000000c00000000000005a
=
struct mixed2 {
  long a;
  unsigned int b:2;
};
-
{a=>25,b=>0}
1900000000000000
19000000000000000000000000000000
19000000000000000000000000000000
0000001900000000
1900000000000000
1900000000000000
00000000000000190000000000000000
1900000000000000
0000001900000000
-
{a=>-13,b=>2}
f3ffffff02000000
f3ffffffffffffff0200000000000000
f3ffffffffffffff0200000000000000
fffffff380000000
f3ffffff02000000
f3ffffff02000000
fffffffffffffff38000000000000000
f3ffffff02000000
fffffff380000000
-
{a=>-45,b=>3}
d3ffffff03000000
d3ffffffffffffff0300000000000000
d3ffffffffffffff0300000000000000
ffffffd3c0000000
d3ffffff03000000
d3ffffff03000000
ffffffffffffffd3c000000000000000
d3ffffff03000000
ffffffd3c0000000
-
{a=>-4,b=>0}
fcffffff00000000
fcffffffffffffff0000000000000000
fcffffffffffffff0000000000000000
fffffffc00000000
fcffffff00000000
fcffffff00000000
fffffffffffffffc0000000000000000
fcffffff00000000
fffffffc00000000
-
{a=>121,b=>3}
7900000003000000
79000000000000000300000000000000
79000000000000000300000000000000
00000079c0000000
7900000003000000
7900000003000000
0000000000000079c000000000000000
7900000003000000
00000079c0000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
};
-
{c=>2,a=>-103,b=>2}
99ffffff0a000000
99ffffffffffffff0a00000000000000
99ffffffffffffff0a00000000000000
ffffff99a0000000
99ffffff0a000000
99ffffff0a000000
ffffffffffffff99a000000000000000
99ffffff0a000000
ffffff99a0000000
-
{c=>1,a=>15,b=>2}
0f00000006000000
0f000000000000000600000000000000
0f000000000000000600000000000000
0000000f90000000
0f00000006000000
0f00000006000000
000000000000000f9000000000000000
0f00000006000000
0000000f90000000
-
{c=>2,a=>30,b=>1}
1e00000009000000
1e000000000000000900000000000000
1e000000000000000900000000000000
0000001e60000000
1e00000009000000
1e00000009000000
000000000000001e6000000000000000
1e00000009000000
0000001e60000000
-
{c=>0,a=>77,b=>1}
4d00000001000000
4d000000000000000100000000000000
4d000000000000000100000000000000
0000004d40000000
4d00000001000000
4d00000001000000
000000000000004d4000000000000000
4d00000001000000
0000004d40000000
-
{c=>0,a=>35,b=>3}
2300000003000000
23000000000000000300000000000000
23000000000000000300000000000000
00000023c0000000
2300000003000000
2300000003000000
0000000000000023c000000000000000
2300000003000000
00000023c0000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
};
-
{c=>3,a=>24,b=>2}
180000000e000000
18000000000000000e00000000000000
18000000000000000e00000000000000
00000018b0000000
180000000e000000
180000000e000000
0000000000000018b000000000000000
180000000e000000
00000018b0000000
-
{c=>1,a=>20,b=>0}
1400000004000000
14000000000000000400000000000000
14000000000000000400000000000000
0000001410000000
1400000004000000
1400000004000000
00000000000000141000000000000000
1400000004000000
0000001410000000
-
{c=>3,a=>-15,b=>2}
f1ffffff0e000000
f1ffffffffffffff0e00000000000000
f1ffffffffffffff0e00000000000000
fffffff1b0000000
f1ffffff0e000000
f1ffffff0e000000
fffffffffffffff1b000000000000000
f1ffffff0e000000
fffffff1b0000000
-
{c=>1,a=>8,b=>1}
0800000005000000
08000000000000000500000000000000
08000000000000000500000000000000
0000000850000000
0800000005000000
0800000005000000
00000000000000085000000000000000
0800000005000000
0000000850000000
-
{c=>3,a=>79,b=>3}
4f0000000f000000
4f000000000000000f00000000000000
4f000000000000000f00000000000000
0000004ff0000000
4f0000000f000000
4f0000000f000000
000000000000004ff000000000000000
4f0000000f000000
0000004ff0000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
};
-
{c=>1,a=>-41,b=>3,d=>0}
d7ffffff0700000000000000
d7ffffffffffffff0700000000000000
d7ffffffffffffff0700000000000000
ffffffd7d000000000000000
d7ffffff0700000000000000
d7ffffff0700000000000000
ffffffffffffffd7d000000000000000
d7ffffff0700000000000000
ffffffd7d000000000000000
-
{c=>0,a=>89,b=>3,d=>2}
590000000300000002000000
59000000000000000300000002000000
59000000000000000300000002000000
00000059c000000080000000
590000000300000002000000
590000000300000002000000
0000000000000059c000000080000000
590000000300000002000000
00000059c000000080000000
-
{c=>1,a=>72,b=>2,d=>1}
480000000600000001000000
48000000000000000600000001000000
48000000000000000600000001000000
000000489000000040000000
480000000600000001000000
480000000600000001000000
00000000000000489000000040000000
480000000600000001000000
000000489000000040000000
-
{c=>3,a=>-32,b=>1,d=>2}
e0ffffff0d00000002000000
e0ffffffffffffff0d00000002000000
e0ffffffffffffff0d00000002000000
ffffffe07000000080000000
e0ffffff0d00000002000000
e0ffffff0d00000002000000
ffffffffffffffe07000000080000000
e0ffffff0d00000002000000
ffffffe07000000080000000
-
{c=>1,a=>96,b=>0,d=>0}
600000000400000000000000
60000000000000000400000000000000
60000000000000000400000000000000
000000601000000000000000
600000000400000000000000
600000000400000000000000
00000000000000601000000000000000
600000000400000000000000
000000601000000000000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
};
-
{e=>-2,c=>1,a=>52,b=>3,d=>1}
340000000700000009000000
34000000000000000700000009000000
34000000000000000700000009000000
00000034d000000060000000
340000000700000009000000
340000000700000009000000
0000000000000034d000000060000000
340000000700000009000000
00000034d000000060000000
-
{e=>-1,c=>2,a=>-124,b=>2,d=>3}
84ffffff0a0000000f000000
84ffffffffffffff0a0000000f000000
84ffffffffffffff0a0000000f000000
ffffff84a0000000f0000000
84ffffff0a0000000f000000
84ffffff0a0000000f000000
ffffffffffffff84a0000000f0000000
84ffffff0a0000000f000000
ffffff84a0000000f0000000
-
{e=>-1,c=>1,a=>-79,b=>2,d=>1}
b1ffffff060000000d000000
b1ffffffffffffff060000000d000000
b1ffffffffffffff060000000d000000
ffffffb19000000070000000
b1ffffff060000000d000000
b1ffffff060000000d000000
ffffffffffffffb19000000070000000
b1ffffff060000000d000000
ffffffb19000000070000000
-
{e=>0,c=>0,a=>-70,b=>2,d=>2}
baffffff0200000002000000
baffffffffffffff0200000002000000
baffffffffffffff0200000002000000
ffffffba8000000080000000
baffffff0200000002000000
baffffff0200000002000000
ffffffffffffffba8000000080000000
baffffff0200000002000000
ffffffba8000000080000000
-
{e=>-1,c=>0,a=>-18,b=>2,d=>1}
eeffffff020000000d000000
eeffffffffffffff020000000d000000
eeffffffffffffff020000000d000000
ffffffee8000000070000000
eeffffff020000000d000000
eeffffff020000000d000000
ffffffffffffffee8000000070000000
eeffffff020000000d000000
ffffffee8000000070000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
};
-
{e=>-1,c=>2,a=>-31,b=>0,d=>2,f=>1}
e1ffffff080000001e000000
e1ffffffffffffff080000001e000000
e1ffffffffffffff080000001e000000
ffffffe120000000b4000000
e1ffffff080000001e000000
e1ffffff080000001e000000
ffffffffffffffe120000000b4000000
e1ffffff080000001e000000
ffffffe120000000b4000000
-
{e=>0,c=>2,a=>-103,b=>2,d=>1,f=>0}
99ffffff0a00000001000000
99ffffffffffffff0a00000001000000
99ffffffffffffff0a00000001000000
ffffff99a000000040000000
99ffffff0a00000001000000
99ffffff0a00000001000000
ffffffffffffff99a000000040000000
99ffffff0a00000001000000
ffffff99a000000040000000
-
{e=>-1,c=>2,a=>51,b=>3,d=>1,f=>-1}
330000000b0000003d000000
33000000000000000b0000003d000000
33000000000000000b0000003d000000
00000033e00000007c000000
330000000b0000003d000000
330000000b0000003d000000
0000000000000033e00000007c000000
330000000b0000003d000000
00000033e00000007c000000
-
{e=>1,c=>3,a=>-94,b=>0,d=>0,f=>-1}
a2ffffff0c00000034000000
a2ffffffffffffff0c00000034000000
a2ffffffffffffff0c00000034000000
ffffffa2300000001c000000
a2ffffff0c00000034000000
a2ffffff0c00000034000000
ffffffffffffffa2300000001c000000
a2ffffff0c00000034000000
ffffffa2300000001c000000
-
{e=>-1,c=>3,a=>-14,b=>0,d=>2,f=>-2}
f2ffffff0c0000002e000000
f2ffffffffffffff0c0000002e000000
f2ffffffffffffff0c0000002e000000
fffffff230000000b8000000
f2ffffff0c0000002e000000
f2ffffff0c0000002e000000
fffffffffffffff230000000b8000000
f2ffffff0c0000002e000000
fffffff230000000b8000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
};
-
{e=>-2,c=>0,a=>80,b=>1,d=>0,f=>0}
500000000100000008000000
50000000000000000100000008000000
50000000000000000100000008000000
000000504000000020000000
500000000100000008000000
500000000100000008000000
00000000000000504000000020000000
500000000100000008000000
000000504000000020000000
-
{e=>1,c=>2,a=>12,b=>1,d=>1,f=>-2}
0c0000000900000025000000
0c000000000000000900000025000000
0c000000000000000900000025000000
0000000c6000000058000000
0c0000000900000025000000
0c0000000900000025000000
000000000000000c6000000058000000
0c0000000900000025000000
0000000c6000000058000000
-
{e=>-2,c=>0,a=>-50,b=>2,d=>3,f=>-1}
ceffffff020000003b000000
ceffffffffffffff020000003b000000
ceffffffffffffff020000003b000000
ffffffce80000000ec000000
ceffffff020000003b000000
ceffffff020000003b000000
ffffffffffffffce80000000ec000000
ceffffff020000003b000000
ffffffce80000000ec000000
-
{e=>-1,c=>1,a=>95,b=>3,d=>2,f=>-1}
5f000000070000003e000000
5f00000000000000070000003e000000
5f00000000000000070000003e000000
0000005fd0000000bc000000
5f000000070000003e000000
5f000000070000003e000000
000000000000005fd0000000bc000000
5f000000070000003e000000
0000005fd0000000bc000000
-
{e=>1,c=>2,a=>99,b=>0,d=>3,f=>0}
630000000800000007000000
63000000000000000800000007000000
63000000000000000800000007000000
0000006320000000d0000000
630000000800000007000000
630000000800000007000000
000000000000006320000000d0000000
630000000800000007000000
0000006320000000d0000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
};
-
{e=>1,c=>2,a=>-83,g=>-2,b=>3,d=>2,f=>1}
adffffff0b0000001600000002000000
adffffffffffffff0b000000160000000200000000000000
adffffffffffffff0b000000160000000200000000000000
ffffffade00000009400000080000000
adffffff0b0000001600000002000000
adffffff0b0000001600000002000000
ffffffffffffffade0000000940000008000000000000000
adffffff0b0000001600000002000000
ffffffade00000009400000080000000
-
{e=>1,c=>2,a=>21,g=>-2,b=>3,d=>1,f=>1}
150000000b0000001500000002000000
15000000000000000b000000150000000200000000000000
15000000000000000b000000150000000200000000000000
00000015e00000005400000080000000
150000000b0000001500000002000000
150000000b0000001500000002000000
0000000000000015e0000000540000008000000000000000
150000000b0000001500000002000000
00000015e00000005400000080000000
-
{e=>0,c=>2,a=>90,g=>0,b=>0,d=>2,f=>1}
5a000000080000001200000000000000
5a0000000000000008000000120000000000000000000000
5a0000000000000008000000120000000000000000000000
0000005a200000008400000000000000
5a000000080000001200000000000000
5a000000080000001200000000000000
000000000000005a20000000840000000000000000000000
5a000000080000001200000000000000
0000005a200000008400000000000000
-
{e=>-2,c=>3,a=>-13,g=>-2,b=>2,d=>2,f=>-2}
f3ffffff0e0000002a00000002000000
f3ffffffffffffff0e0000002a0000000200000000000000
f3ffffffffffffff0e0000002a0000000200000000000000
fffffff3b0000000a800000080000000
f3ffffff0e0000002a00000002000000
f3ffffff0e0000002a00000002000000
fffffffffffffff3b0000000a80000008000000000000000
f3ffffff0e0000002a00000002000000
fffffff3b0000000a800000080000000
-
{e=>-2,c=>0,a=>125,g=>-1,b=>1,d=>1,f=>-2}
7d000000010000002900000003000000
7d0000000000000001000000290000000300000000000000
7d0000000000000001000000290000000300000000000000
0000007d4000000068000000c0000000
7d000000010000002900000003000000
7d000000010000002900000003000000
000000000000007d4000000068000000c000000000000000
7d000000010000002900000003000000
0000007d4000000068000000c0000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
};
-
{e=>1,a=>-118,d=>0,c=>1,h=>0,b=>2,g=>0,f=>1}
8affffff060000001400000000000000
8affffffffffffff06000000140000000000000000000000
8affffffffffffff06000000140000000000000000000000
ffffff8a900000001400000000000000
8affffff060000001400000000000000
8affffff060000001400000000000000
ffffffffffffff8a90000000140000000000000000000000
8affffff060000001400000000000000
ffffff8a900000001400000000000000
-
{e=>-1,a=>-22,d=>2,c=>1,h=>-2,b=>0,g=>-2,f=>-1}
eaffffff040000003e0000000a000000
eaffffffffffffff040000003e0000000a00000000000000
eaffffffffffffff040000003e0000000a00000000000000
ffffffea10000000bc000000a0000000
eaffffff040000003e0000000a000000
eaffffff040000003e0000000a000000
ffffffffffffffea10000000bc000000a000000000000000
eaffffff040000003e0000000a000000
ffffffea10000000bc000000a0000000
-
{e=>0,a=>35,d=>2,c=>2,h=>1,b=>0,g=>-1,f=>0}
23000000080000000200000007000000
230000000000000008000000020000000700000000000000
230000000000000008000000020000000700000000000000
000000232000000080000000d0000000
23000000080000000200000007000000
23000000080000000200000007000000
00000000000000232000000080000000d000000000000000
23000000080000000200000007000000
000000232000000080000000d0000000
-
{e=>1,a=>109,d=>0,c=>0,h=>0,b=>0,g=>1,f=>0}
6d000000000000000400000001000000
6d0000000000000000000000040000000100000000000000
6d0000000000000000000000040000000100000000000000
0000006d000000001000000040000000
6d000000000000000400000001000000
6d000000000000000400000001000000
000000000000006d00000000100000004000000000000000
6d000000000000000400000001000000
0000006d000000001000000040000000
-
{e=>1,a=>67,d=>1,c=>1,h=>0,b=>0,g=>-2,f=>0}
43000000040000000500000002000000
430000000000000004000000050000000200000000000000
430000000000000004000000050000000200000000000000
00000043100000005000000080000000
43000000040000000500000002000000
43000000040000000500000002000000
000000000000004310000000500000008000000000000000
43000000040000000500000002000000
00000043100000005000000080000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
};
-
{e=>-1,a=>-88,d=>2,c=>3,h=>-1,b=>3,g=>-2,f=>0,i=>-1}
a8ffffff0f0000000e0000003e000000
a8ffffffffffffff0f0000000e0000003e00000000000000
a8ffffffffffffff0f0000000e0000003e00000000000000
ffffffa8f0000000b0000000bc000000
a8ffffff0f0000000e0000003e000000
a8ffffff0f0000000e0000003e000000
ffffffffffffffa8f0000000b0000000bc00000000000000
a8ffffff0f0000000e0000003e000000
ffffffa8f0000000b0000000bc000000
-
{e=>-1,a=>117,d=>0,c=>2,h=>-1,b=>2,g=>-1,f=>0,i=>0}
750000000a0000000c0000000f000000
75000000000000000a0000000c0000000f00000000000000
75000000000000000a0000000c0000000f00000000000000
00000075a000000030000000f0000000
750000000a0000000c0000000f000000
750000000a0000000c0000000f000000
0000000000000075a000000030000000f000000000000000
750000000a0000000c0000000f000000
00000075a000000030000000f0000000
-
{e=>-1,a=>119,d=>1,c=>0,h=>-1,b=>2,g=>1,f=>-2,i=>1}
77000000020000002d0000001d000000
7700000000000000020000002d0000001d00000000000000
7700000000000000020000002d0000001d00000000000000
00000077800000007800000074000000
77000000020000002d0000001d000000
77000000020000002d0000001d000000
000000000000007780000000780000007400000000000000
77000000020000002d0000001d000000
00000077800000007800000074000000
-
{e=>0,a=>-126,d=>1,c=>2,h=>1,b=>2,g=>0,f=>0,i=>-2}
82ffffff0a0000000100000024000000
82ffffffffffffff0a000000010000002400000000000000
82ffffffffffffff0a000000010000002400000000000000
ffffff82a00000004000000018000000
82ffffff0a0000000100000024000000
82ffffff0a0000000100000024000000
ffffffffffffff82a0000000400000001800000000000000
82ffffff0a0000000100000024000000
ffffff82a00000004000000018000000
-
{e=>-1,a=>-78,d=>3,c=>2,h=>-2,b=>2,g=>-2,f=>-1,i=>1}
b2ffffff0a0000003f0000001a000000
b2ffffffffffffff0a0000003f0000001a00000000000000
b2ffffffffffffff0a0000003f0000001a00000000000000
ffffffb2a0000000fc000000a4000000
b2ffffff0a0000003f0000001a000000
b2ffffff0a0000003f0000001a000000
ffffffffffffffb2a0000000fc000000a400000000000000
b2ffffff0a0000003f0000001a000000
ffffffb2a0000000fc000000a4000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
};
-
{e=>0,a=>-53,d=>0,c=>3,h=>-1,b=>1,g=>1,f=>1,i=>0}
cbffffff0d000000100000000d000000
cbffffffffffffff0d000000100000000d00000000000000
cbffffffffffffff0d000000100000000d00000000000000
ffffffcb700000000400000070000000
cbffffff0d000000100000000d000000
cbffffff0d000000100000000d000000
ffffffffffffffcb70000000040000007000000000000000
cbffffff0d000000100000000d000000
ffffffcb700000000400000070000000
-
{e=>-2,a=>-108,d=>2,c=>0,h=>-1,b=>2,g=>-1,f=>0,i=>-2}
94ffffff020000000a0000002f000000
94ffffffffffffff020000000a0000002f00000000000000
94ffffffffffffff020000000a0000002f00000000000000
ffffff9480000000a0000000f8000000
94ffffff020000000a0000002f000000
94ffffff020000000a0000002f000000
ffffffffffffff9480000000a0000000f800000000000000
94ffffff020000000a0000002f000000
ffffff9480000000a0000000f8000000
-
{e=>1,a=>-117,d=>1,c=>1,h=>0,b=>1,g=>-2,f=>0,i=>-1}
8bffffff050000000500000032000000
8bffffffffffffff05000000050000003200000000000000
8bffffffffffffff05000000050000003200000000000000
ffffff8b50000000500000008c000000
8bffffff050000000500000032000000
8bffffff050000000500000032000000
ffffffffffffff8b50000000500000008c00000000000000
8bffffff050000000500000032000000
ffffff8b50000000500000008c000000
-
{e=>1,a=>121,d=>1,c=>1,h=>-2,b=>0,g=>1,f=>0,i=>1}
79000000040000000500000019000000
790000000000000004000000050000001900000000000000
790000000000000004000000050000001900000000000000
00000079100000005000000064000000
79000000040000000500000019000000
79000000040000000500000019000000
000000000000007910000000500000006400000000000000
79000000040000000500000019000000
00000079100000005000000064000000
-
{e=>-2,a=>-2,d=>1,c=>3,h=>-2,b=>0,g=>-1,f=>-2,i=>-2}
feffffff0c000000290000002b000000
feffffffffffffff0c000000290000002b00000000000000
feffffffffffffff0c000000290000002b00000000000000
fffffffe3000000068000000e8000000
feffffff0c000000290000002b000000
feffffff0c000000290000002b000000
fffffffffffffffe3000000068000000e800000000000000
feffffff0c000000290000002b000000
fffffffe3000000068000000e8000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
};
-
{e=>-1,a=>65,d=>2,j=>-1,c=>3,h=>0,b=>0,g=>1,f=>0,i=>0}
410000000c0000000e0000000100000003000000
41000000000000000c0000000e0000000100000003000000
41000000000000000c0000000e0000000100000003000000
0000004130000000b000000040000000c0000000
410000000c0000000e0000000100000003000000
410000000c0000000e0000000100000003000000
000000000000004130000000b000000040000000c0000000
410000000c0000000e0000000100000003000000
0000004130000000b000000040000000c0000000
-
{e=>-1,a=>68,d=>0,j=>1,c=>0,h=>-2,b=>2,g=>-1,f=>-2,i=>-1}
44000000020000002c0000003b00000001000000
4400000000000000020000002c0000003b00000001000000
4400000000000000020000002c0000003b00000001000000
000000448000000038000000ec00000040000000
44000000020000002c0000003b00000001000000
44000000020000002c0000003b00000001000000
00000000000000448000000038000000ec00000040000000
44000000020000002c0000003b00000001000000
000000448000000038000000ec00000040000000
-
{e=>1,a=>15,d=>3,j=>0,c=>0,h=>-1,b=>3,g=>1,f=>-2,i=>-1}
0f00000003000000270000003d00000000000000
0f0000000000000003000000270000003d00000000000000
0f0000000000000003000000270000003d00000000000000
0000000fc0000000d80000007c00000000000000
0f00000003000000270000003d00000000000000
0f00000003000000270000003d00000000000000
000000000000000fc0000000d80000007c00000000000000
0f00000003000000270000003d00000000000000
0000000fc0000000d80000007c00000000000000
-
{e=>-1,a=>-76,d=>3,j=>-2,c=>3,h=>1,b=>2,g=>1,f=>-2,i=>1}
b4ffffff0e0000002f0000001500000002000000
b4ffffffffffffff0e0000002f0000001500000002000000
b4ffffffffffffff0e0000002f0000001500000002000000
ffffffb4b0000000f80000005400000080000000
b4ffffff0e0000002f0000001500000002000000
b4ffffff0e0000002f0000001500000002000000
ffffffffffffffb4b0000000f80000005400000080000000
b4ffffff0e0000002f0000001500000002000000
ffffffb4b0000000f80000005400000080000000
-
{e=>-1,a=>65,d=>3,j=>1,c=>1,h=>0,b=>2,g=>0,f=>0,i=>0}
41000000060000000f0000000000000001000000
4100000000000000060000000f0000000000000001000000
4100000000000000060000000f0000000000000001000000
0000004190000000f00000000000000040000000
41000000060000000f0000000000000001000000
41000000060000000f0000000000000001000000
000000000000004190000000f00000000000000040000000
41000000060000000f0000000000000001000000
0000004190000000f00000000000000040000000
=
struct mixed2 {
  long a;
  unsigned int b:2;
  unsigned int c:2;
  unsigned int  :0;
  unsigned int d:2;
  signed   int e:2;
  signed   int f:2;
  signed   int  :0;
  signed   int g:2;
  int          h:2;
  int          i:2;
  int           :0;
  int          j:2;
  int          k;
};
-
{e=>1,a=>-49,d=>0,j=>-2,c=>3,k=>-42,h=>1,b=>0,g=>-2,f=>1,i=>-2}
cfffffff0c000000140000002600000002000000d6ffffff
cfffffffffffffff0c000000140000002600000002000000d6ffffff00000000
cfffffffffffffff0c000000140000002600000002000000d6ffffff00000000
ffffffcf30000000140000009800000080000000ffffffd6
cfffffff0c000000140000002600000002000000d6ffffff
cfffffff0c000000140000002600000002000000d6ffffff
ffffffffffffffcf30000000140000009800000080000000ffffffd600000000
cfffffff0c000000140000002600000002000000d6ffffff
ffffffcf30000000140000009800000080000000ffffffd6
-
{e=>0,a=>91,d=>3,j=>-2,c=>2,k=>-107,h=>0,b=>3,g=>-2,f=>-2,i=>0}
5b0000000b00000023000000020000000200000095ffffff
5b000000000000000b00000023000000020000000200000095ffffff00000000
5b000000000000000b00000023000000020000000200000095ffffff00000000
0000005be0000000c80000008000000080000000ffffff95
5b0000000b00000023000000020000000200000095ffffff
5b0000000b00000023000000020000000200000095ffffff
000000000000005be0000000c80000008000000080000000ffffff9500000000
5b0000000b00000023000000020000000200000095ffffff
0000005be0000000c80000008000000080000000ffffff95
-
{e=>-1,a=>119,d=>0,j=>-1,c=>2,k=>-75,h=>0,b=>0,g=>0,f=>0,i=>1}
77000000080000000c0000001000000003000000b5ffffff
7700000000000000080000000c0000001000000003000000b5ffffff00000000
7700000000000000080000000c0000001000000003000000b5ffffff00000000
00000077200000003000000004000000c0000000ffffffb5
77000000080000000c0000001000000003000000b5ffffff
77000000080000000c0000001000000003000000b5ffffff
0000000000000077200000003000000004000000c0000000ffffffb500000000
77000000080000000c0000001000000003000000b5ffffff
00000077200000003000000004000000c0000000ffffffb5
-
{e=>1,a=>56,d=>2,j=>-2,c=>1,k=>-42,h=>-2,b=>2,g=>0,f=>-1,i=>0}
3800000006000000360000000800000002000000d6ffffff
380000000000000006000000360000000800000002000000d6ffffff00000000
380000000000000006000000360000000800000002000000d6ffffff00000000
00000038900000009c0000002000000080000000ffffffd6
3800000006000000360000000800000002000000d6ffffff
3800000006000000360000000800000002000000d6ffffff
0000000000000038900000009c0000002000000080000000ffffffd600000000
3800000006000000360000000800000002000000d6ffffff
00000038900000009c0000002000000080000000ffffffd6
-
{e=>0,a=>47,d=>2,j=>1,c=>3,k=>-15,h=>-1,b=>0,g=>-1,f=>0,i=>1}
2f0000000c000000020000001f00000001000000f1ffffff
2f000000000000000c000000020000001f00000001000000f1ffffff00000000
2f000000000000000c000000020000001f00000001000000f1ffffff00000000
0000002f3000000080000000f400000040000000fffffff1
2f0000000c000000020000001f00000001000000f1ffffff
2f0000000c000000020000001f00000001000000f1ffffff
000000000000002f3000000080000000f400000040000000fffffff100000000
2f0000000c000000020000001f00000001000000f1ffffff
0000002f3000000080000000f400000040000000fffffff1
=
struct uch_wrap {
  unsigned char a:3;
};
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
-
{a=>4}
04
04
04
80
04000000
04
80
04
80
-
{a=>3}
03
03
03
60
03000000
03
60
03
60
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
-
{a=>7}
07
07
07
e0
07000000
07
e0
07
e0
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
};
-
{a=>1,b=>3}
19
19
19
2c
19000000
19
2c
19
2c
-
{a=>0,b=>4}
20
20
20
10
20000000
20
10
20
10
-
{a=>1,b=>6}
31
31
31
38
31000000
31
38
31
38
-
{a=>5,b=>4}
25
25
25
b0
25000000
25
b0
25
b0
-
{a=>0,b=>4}
20
20
20
10
20000000
20
10
20
10
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
};
-
{c=>4,a=>7,b=>7}
3f04
3f04
3f04
fc80
3f040000
3f04
fc80
3f04
fc80
-
{c=>7,a=>3,b=>3}
1b07
1b07
1b07
6ce0
1b070000
1b07
6ce0
1b07
6ce0
-
{c=>0,a=>6,b=>5}
2e00
2e00
2e00
d400
2e000000
2e00
d400
2e00
d400
-
{c=>3,a=>5,b=>3}
1d03
1d03
1d03
ac60
1d030000
1d03
ac60
1d03
ac60
-
{c=>5,a=>6,b=>1}
0e05
0e05
0e05
c4a0
0e050000
0e05
c4a0
0e05
c4a0
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
};
-
{c=>2,a=>2,b=>6,d=>2}
3212
3212
3212
5848
32120000
3212
5848
3212
5848
-
{c=>3,a=>2,b=>5,d=>7}
2a3b
2a3b
2a3b
547c
2a3b0000
2a3b
547c
2a3b
547c
-
{c=>2,a=>6,b=>7,d=>2}
3e12
3e12
3e12
dc48
3e120000
3e12
dc48
3e12
dc48
-
{c=>7,a=>6,b=>6,d=>4}
3627
3627
3627
d8f0
36270000
3627
d8f0
3627
d8f0
-
{c=>7,a=>2,b=>2,d=>7}
123f
123f
123f
48fc
123f0000
123f
48fc
123f
48fc
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
};
-
{e=>6,c=>0,a=>7,b=>2,d=>5}
172806
172806
172806
e814c0
17280600
172806
e814c0
172806
e814c0
-
{e=>0,c=>7,a=>1,b=>5,d=>5}
292f00
292f00
292f00
34f400
292f0000
292f00
34f400
292f00
34f400
-
{e=>7,c=>4,a=>7,b=>7,d=>7}
3f3c07
3f3c07
3f3c07
fc9ce0
3f3c0700
3f3c07
fc9ce0
3f3c07
fc9ce0
-
{e=>2,c=>2,a=>2,b=>6,d=>6}
323202
323202
323202
585840
32320200
323202
585840
323202
585840
-
{e=>0,c=>5,a=>6,b=>6,d=>5}
362d00
362d00
362d00
d8b400
362d0000
362d00
d8b400
362d00
d8b400
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
};
-
{e=>2,c=>2,a=>0,b=>7,d=>5,f=>4}
382a22
382a22
382a22
1c5450
382a2200
382a22
1c5450
382a22
1c5450
-
{e=>1,c=>5,a=>1,b=>5,d=>5,f=>5}
292d29
292d29
292d29
34b434
292d2900
292d29
34b434
292d29
34b434
-
{e=>5,c=>7,a=>1,b=>7,d=>6,f=>4}
393725
393725
393725
3cf8b0
39372500
393725
3cf8b0
393725
3cf8b0
-
{e=>5,c=>6,a=>6,b=>1,d=>4,f=>1}
0e260d
0e260d
0e260d
c4d0a4
0e260d00
0e260d
c4d0a4
0e260d
c4d0a4
-
{e=>6,c=>2,a=>7,b=>1,d=>6,f=>3}
0f321e
0f321e
0f321e
e458cc
0f321e00
0f321e
e458cc
0f321e
e458cc
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
};
-
{e=>7,c=>4,a=>5,g=>0,b=>1,d=>1,f=>1}
0d0c0f00
0d0c0f00
0d0c0f00
a484e400
0d0c0f00
0d0c0f00
a484e400
0d0c0f00
a484e400
-
{e=>3,c=>4,a=>6,g=>2,b=>4,d=>2,f=>0}
26140302
26140302
26140302
d0886040
26140302
26140302
d0886040
26140302
d0886040
-
{e=>2,c=>4,a=>7,g=>6,b=>6,d=>4,f=>6}
37243206
37243206
37243206
f89058c0
37243206
37243206
f89058c0
37243206
f89058c0
-
{e=>0,c=>6,a=>3,g=>0,b=>1,d=>6,f=>1}
0b360800
0b360800
0b360800
64d80400
0b360800
0b360800
64d80400
0b360800
64d80400
-
{e=>3,c=>7,a=>0,g=>4,b=>4,d=>1,f=>4}
200f2304
200f2304
200f2304
10e47080
200f2304
200f2304
10e47080
200f2304
10e47080
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
};
-
{e=>1,a=>1,d=>4,c=>6,h=>5,b=>3,g=>5,f=>5}
1926292d
1926292d
1926292d
2cd034b4
1926292d
1926292d
2cd034b4
1926292d
2cd034b4
-
{e=>7,a=>4,d=>6,c=>1,h=>0,b=>0,g=>0,f=>3}
04311f00
04311f00
04311f00
8038ec00
04311f00
04311f00
8038ec00
04311f00
8038ec00
-
{e=>2,a=>6,d=>4,c=>1,h=>5,b=>4,g=>6,f=>3}
26211a2e
26211a2e
26211a2e
d0304cd4
26211a2e
26211a2e
d0304cd4
26211a2e
d0304cd4
-
{e=>1,a=>2,d=>6,c=>2,h=>6,b=>4,g=>3,f=>0}
22320133
22320133
22320133
50582078
22320133
22320133
50582078
22320133
50582078
-
{e=>0,a=>1,d=>0,c=>3,h=>5,b=>3,g=>4,f=>5}
1903282c
1903282c
1903282c
2c601494
1903282c
1903282c
2c601494
1903282c
2c601494
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
};
-
{e=>4,a=>6,d=>7,c=>0,h=>5,b=>3,g=>6,f=>2,i=>5}
1e38142e05
1e38142e05
1e38142e05
cc1c88d4a0
1e38142e05000000
1e38142e05
cc1c88d4a0
1e38142e05
cc1c88d4a0
-
{e=>7,a=>3,d=>1,c=>0,h=>0,b=>2,g=>5,f=>6,i=>6}
1308370506
1308370506
1308370506
6804f8a0c0
1308370506000000
1308370506
6804f8a0c0
1308370506
6804f8a0c0
-
{e=>3,a=>2,d=>4,c=>3,h=>6,b=>2,g=>7,f=>7,i=>6}
12233b3706
12233b3706
12233b3706
48707cf8c0
12233b3706000000
12233b3706
48707cf8c0
12233b3706
48707cf8c0
-
{e=>0,a=>3,d=>7,c=>1,h=>7,b=>7,g=>0,f=>4,i=>0}
3b39203800
3b39203800
3b39203800
7c3c101c00
3b39203800000000
3b39203800
7c3c101c00
3b39203800
7c3c101c00
-
{e=>5,a=>7,d=>0,c=>1,h=>3,b=>7,g=>3,f=>6,i=>1}
3f01351b01
3f01351b01
3f01351b01
fc20b86c20
3f01351b01000000
3f01351b01
fc20b86c20
3f01351b01
fc20b86c20
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
};
-
{e=>3,a=>6,d=>1,j=>4,c=>0,h=>4,b=>1,g=>5,f=>4,i=>1}
0e08232521
0e08232521
0e08232521
c40470b030
0e08232521000000
0e08232521
c40470b030
0e08232521
c40470b030
-
{e=>6,a=>1,d=>1,j=>1,c=>2,h=>3,b=>4,g=>0,f=>5,i=>1}
210a2e1809
210a2e1809
210a2e1809
3044d40c24
210a2e1809000000
210a2e1809
3044d40c24
210a2e1809
3044d40c24
-
{e=>5,a=>2,d=>6,j=>3,c=>7,h=>0,b=>7,g=>1,f=>7,i=>3}
3a373d011b
3a373d011b
3a373d011b
5cf8bc206c
3a373d011b000000
3a373d011b
5cf8bc206c
3a373d011b
5cf8bc206c
-
{e=>6,a=>1,d=>3,j=>3,c=>5,h=>6,b=>1,g=>5,f=>3,i=>7}
091d1e351f
091d1e351f
091d1e351f
24acccb8ec
091d1e351f000000
091d1e351f
24acccb8ec
091d1e351f
24acccb8ec
-
{e=>4,a=>0,d=>5,j=>4,c=>5,h=>2,b=>1,g=>1,f=>1,i=>2}
082d0c1122
082d0c1122
082d0c1122
04b4842850
082d0c1122000000
082d0c1122
04b4842850
082d0c1122
04b4842850
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
};
-
{e=>0,a=>4,d=>4,j=>1,c=>3,k=>2,h=>3,b=>4,g=>2,f=>6,i=>2}
2423301a0a02
2423301a0a02
2423301a0a02
9070184c4440
2423301a0a020000
2423301a0a02
9070184c4440
2423301a0a02
9070184c4440
-
{e=>1,a=>6,d=>5,j=>4,c=>0,k=>1,h=>7,b=>1,g=>4,f=>7,i=>2}
0e28393c2201
0e28393c2201
0e28393c2201
c4143c9c5020
0e28393c22010000
0e28393c2201
c4143c9c5020
0e28393c2201
c4143c9c5020
-
{e=>6,a=>3,d=>6,j=>5,c=>4,k=>1,h=>2,b=>1,g=>2,f=>2,i=>7}
0b3416122f01
0b3416122f01
0b3416122f01
6498c848f420
0b3416122f010000
0b3416122f01
6498c848f420
0b3416122f01
6498c848f420
-
{e=>4,a=>2,d=>5,j=>1,c=>2,k=>7,h=>0,b=>0,g=>1,f=>0,i=>4}
022a04010c07
022a04010c07
022a04010c07
4054802084e0
022a04010c070000
022a04010c07
4054802084e0
022a04010c07
4054802084e0
-
{e=>5,a=>0,d=>0,j=>4,c=>6,k=>4,h=>1,b=>3,g=>4,f=>2,i=>2}
1806150c2204
1806150c2204
1806150c2204
0cc0a8845080
1806150c22040000
1806150c2204
0cc0a8845080
1806150c2204
0cc0a8845080
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
};
-
{e=>1,a=>4,d=>2,j=>3,l=>2,c=>1,k=>0,h=>2,b=>4,g=>2,f=>4,i=>7}
241121121f10
241121121f10
241121121f10
90283048ec08
241121121f100000
241121121f10
90283048ec08
241121121f10
90283048ec08
-
{e=>3,a=>2,d=>1,j=>0,l=>7,c=>0,k=>0,h=>5,b=>2,g=>6,f=>1,i=>0}
12080b2e0038
12080b2e0038
12080b2e0038
480464d4001c
12080b2e00380000
12080b2e0038
480464d4001c
12080b2e0038
480464d4001c
-
{e=>7,a=>6,d=>5,j=>3,l=>2,c=>7,k=>0,h=>4,b=>0,g=>7,f=>1,i=>5}
062f0f271d10
062f0f271d10
062f0f271d10
c0f4e4f0ac08
062f0f271d100000
062f0f271d10
c0f4e4f0ac08
062f0f271d10
c0f4e4f0ac08
-
{e=>0,a=>3,d=>3,j=>3,l=>1,c=>5,k=>4,h=>3,b=>4,g=>3,f=>5,i=>7}
231d281b1f0c
231d281b1f0c
231d281b1f0c
70ac146cec84
231d281b1f0c0000
231d281b1f0c
70ac146cec84
231d281b1f0c
70ac146cec84
-
{e=>2,a=>2,d=>6,j=>1,l=>1,c=>6,k=>7,h=>3,b=>7,g=>5,f=>4,i=>0}
3a36221d080f
3a36221d080f
3a36221d080f
5cd850ac04e4
3a36221d080f0000
3a36221d080f
5cd850ac04e4
3a36221d080f
5cd850ac04e4
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
};
-
{e=>3,a=>6,m=>7,d=>3,j=>4,l=>4,c=>2,k=>2,h=>5,b=>7,g=>6,f=>2,i=>3}
3e1a132e232207
3e1a132e232207
3e1a132e232207
dc4c68d47050e0
3e1a132e23220700
3e1a132e232207
dc4c68d47050e0
3e1a132e232207
dc4c68d47050e0
-
{e=>2,a=>3,m=>0,d=>7,j=>7,l=>0,c=>2,k=>3,h=>1,b=>2,g=>1,f=>7,i=>7}
133a3a093f0300
133a3a093f0300
133a3a093f0300
685c5c24fc6000
133a3a093f030000
133a3a093f0300
685c5c24fc6000
133a3a093f0300
685c5c24fc6000
-
{e=>3,a=>7,m=>0,d=>4,j=>6,l=>5,c=>1,k=>6,h=>2,b=>5,g=>7,f=>5,i=>1}
2f212b17312e00
2f212b17312e00
2f212b17312e00
f43074e838d400
2f212b17312e0000
2f212b17312e00
f43074e838d400
2f212b17312e00
f43074e838d400
-
{e=>6,a=>5,m=>3,d=>0,j=>1,l=>5,c=>1,k=>3,h=>0,b=>6,g=>4,f=>4,i=>2}
350126040a2b03
350126040a2b03
350126040a2b03
b820d080447460
350126040a2b0300
350126040a2b03
b820d080447460
350126040a2b03
b820d080447460
-
{e=>3,a=>3,m=>1,d=>1,j=>3,l=>4,c=>1,k=>6,h=>6,b=>1,g=>4,f=>1,i=>4}
0b090b341c2601
0b090b341c2601
0b090b341c2601
642464988cd020
0b090b341c260100
0b090b341c2601
642464988cd020
0b090b341c2601
642464988cd020
=
struct uch_wrap {
  unsigned char a:3;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  short         n;
};
-
{e=>1,n=>106,a=>2,m=>4,d=>4,j=>1,l=>4,c=>1,k=>6,h=>1,b=>0,g=>4,f=>7,i=>1}
0221390c092604006a00
0221390c092604006a00
0221390c092604006a00
40303c8424d08000006a
0221390c092604006a000000
0221390c092604006a00
40303c8424d08000006a
0221390c092604006a00
40303c8424d08000006a
-
{e=>4,n=>74,a=>5,m=>5,d=>7,j=>0,l=>4,c=>0,k=>0,h=>4,b=>7,g=>2,f=>7,i=>5}
3d383c22052005004a00
3d383c22052005004a00
3d383c22052005004a00
bc1c9c50a010a000004a
3d383c22052005004a000000
3d383c22052005004a00
bc1c9c50a010a000004a
3d383c22052005004a00
bc1c9c50a010a000004a
-
{e=>7,n=>-6,a=>5,m=>1,d=>2,j=>6,l=>5,c=>2,k=>2,h=>7,b=>2,g=>0,f=>0,i=>7}
15120738372a0100faff
15120738372a0100faff
15120738372a0100faff
a848e01cf8542000fffa
15120738372a0100faff0000
15120738372a0100faff
a848e01cf8542000fffa
15120738372a0100faff
a848e01cf8542000fffa
-
{e=>7,n=>-54,a=>2,m=>1,d=>4,j=>7,l=>3,c=>1,k=>2,h=>1,b=>2,g=>0,f=>5,i=>3}
12212f083b1a0100caff
12212f083b1a0100caff
12212f083b1a0100caff
4830f4047c4c2000ffca
12212f083b1a0100caff0000
12212f083b1a0100caff
4830f4047c4c2000ffca
12212f083b1a0100caff
4830f4047c4c2000ffca
-
{e=>6,n=>118,a=>5,m=>6,d=>0,j=>7,l=>4,c=>2,k=>6,h=>3,b=>6,g=>4,f=>7,i=>0}
35023e1c382606007600
35023e1c382606007600
35023e1c382606007600
b840dc8c1cd0c0000076
35023e1c3826060076000000
35023e1c382606007600
b840dc8c1cd0c0000076
35023e1c382606007600
b840dc8c1cd0c0000076
=
struct uch_wrap {
  char a;
  unsigned char b:3;
};
-
{a=>-70,b=>6}
ba06
ba06
ba06
bac0
ba060000
ba06
bac0
ba06
bac0
-
{a=>-97,b=>5}
9f05
9f05
9f05
9fa0
9f050000
9f05
9fa0
9f05
9fa0
-
{a=>-15,b=>0}
f100
f100
f100
f100
f1000000
f100
f100
f100
f100
-
{a=>-44,b=>0}
d400
d400
d400
d400
d4000000
d400
d400
d400
d400
-
{a=>102,b=>7}
6607
6607
6607
66e0
66070000
6607
66e0
6607
66e0
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
};
-
{c=>6,a=>32,b=>5}
2035
2035
2035
20b8
20350000
2035
20b8
2035
20b8
-
{c=>5,a=>-69,b=>3}
bb2b
bb2b
bb2b
bb74
bb2b0000
bb2b
bb74
bb2b
bb74
-
{c=>3,a=>90,b=>2}
5a1a
5a1a
5a1a
5a4c
5a1a0000
5a1a
5a4c
5a1a
5a4c
-
{c=>5,a=>80,b=>6}
502e
502e
502e
50d4
502e0000
502e
50d4
502e
50d4
-
{c=>6,a=>117,b=>3}
7533
7533
7533
7578
75330000
7533
7578
7533
7578
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
};
-
{c=>1,a=>4,b=>6,d=>2}
040e02
040e02
040e02
04c440
040e0200
040e02
04c440
040e02
04c440
-
{c=>7,a=>-20,b=>1,d=>3}
ec3903
ec3903
ec3903
ec3c60
ec390300
ec3903
ec3c60
ec3903
ec3c60
-
{c=>2,a=>127,b=>1,d=>3}
7f1103
7f1103
7f1103
7f2860
7f110300
7f1103
7f2860
7f1103
7f2860
-
{c=>6,a=>-48,b=>4,d=>4}
d03404
d03404
d03404
d09880
d0340400
d03404
d09880
d03404
d09880
-
{c=>4,a=>-78,b=>2,d=>5}
b22205
b22205
b22205
b250a0
b2220500
b22205
b250a0
b22205
b250a0
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
};
-
{e=>3,c=>0,a=>120,b=>7,d=>7}
78071f
78071f
78071f
78e0ec
78071f00
78071f
78e0ec
78071f
78e0ec
-
{e=>6,c=>6,a=>-75,b=>2,d=>3}
b53233
b53233
b53233
b55878
b5323300
b53233
b55878
b53233
b55878
-
{e=>3,c=>2,a=>-61,b=>6,d=>7}
c3161f
c3161f
c3161f
c3c8ec
c3161f00
c3161f
c3c8ec
c3161f
c3c8ec
-
{e=>1,c=>0,a=>59,b=>7,d=>2}
3b070a
3b070a
3b070a
3be044
3b070a00
3b070a
3be044
3b070a
3be044
-
{e=>2,c=>4,a=>61,b=>4,d=>6}
3d2416
3d2416
3d2416
3d90c8
3d241600
3d2416
3d90c8
3d2416
3d90c8
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
};
-
{e=>1,c=>4,a=>48,b=>5,d=>6,f=>3}
30250e03
30250e03
30250e03
30b0c460
30250e03
30250e03
30b0c460
30250e03
30b0c460
-
{e=>6,c=>0,a=>-47,b=>4,d=>5,f=>3}
d1043503
d1043503
d1043503
d180b860
d1043503
d1043503
d180b860
d1043503
d180b860
-
{e=>5,c=>1,a=>-5,b=>4,d=>1,f=>0}
fb0c2900
fb0c2900
fb0c2900
fb843400
fb0c2900
fb0c2900
fb843400
fb0c2900
fb843400
-
{e=>6,c=>2,a=>106,b=>7,d=>3,f=>4}
6a173304
6a173304
6a173304
6ae87880
6a173304
6a173304
6ae87880
6a173304
6ae87880
-
{e=>5,c=>5,a=>-105,b=>3,d=>6,f=>3}
972b2e03
972b2e03
972b2e03
9774d460
972b2e03
972b2e03
9774d460
972b2e03
9774d460
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
};
-
{e=>4,c=>1,a=>71,g=>5,b=>0,d=>7,f=>0}
47082728
47082728
47082728
4704f014
47082728
47082728
4704f014
47082728
4704f014
-
{e=>6,c=>7,a=>36,g=>5,b=>1,d=>5,f=>4}
2439352c
2439352c
2439352c
243cb894
2439352c
2439352c
243cb894
2439352c
243cb894
-
{e=>3,c=>5,a=>-22,g=>5,b=>5,d=>4,f=>1}
ea2d1c29
ea2d1c29
ea2d1c29
eab48c34
ea2d1c29
ea2d1c29
eab48c34
ea2d1c29
eab48c34
-
{e=>6,c=>2,a=>43,g=>6,b=>0,d=>2,f=>0}
2b103230
2b103230
2b103230
2b085818
2b103230
2b103230
2b085818
2b103230
2b085818
-
{e=>0,c=>1,a=>-119,g=>0,b=>4,d=>4,f=>1}
890c0401
890c0401
890c0401
89848020
890c0401
890c0401
89848020
890c0401
89848020
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
};
-
{e=>6,a=>88,d=>3,c=>5,h=>1,b=>3,g=>7,f=>2}
582b333a01
582b333a01
582b333a01
5874785c20
582b333a01000000
582b333a01
5874785c20
582b333a01
5874785c20
-
{e=>3,a=>-69,d=>7,c=>6,h=>7,b=>3,g=>7,f=>4}
bb331f3c07
bb331f3c07
bb331f3c07
bb78ec9ce0
bb331f3c07000000
bb331f3c07
bb78ec9ce0
bb331f3c07
bb78ec9ce0
-
{e=>7,a=>-30,d=>6,c=>4,h=>5,b=>0,g=>7,f=>3}
e2203e3b05
e2203e3b05
e2203e3b05
e210dc7ca0
e2203e3b05000000
e2203e3b05
e210dc7ca0
e2203e3b05
e210dc7ca0
-
{e=>6,a=>-16,d=>6,c=>7,h=>5,b=>2,g=>1,f=>6}
f03a360e05
f03a360e05
f03a360e05
f05cd8c4a0
f03a360e05000000
f03a360e05
f05cd8c4a0
f03a360e05
f05cd8c4a0
-
{e=>1,a=>72,d=>2,c=>1,h=>1,b=>5,g=>1,f=>6}
480d0a0e01
480d0a0e01
480d0a0e01
48a444c420
480d0a0e01000000
480d0a0e01
48a444c420
480d0a0e01
48a444c420
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
};
-
{e=>2,a=>-92,d=>4,c=>2,h=>6,b=>6,g=>0,f=>3,i=>7}
a41614033e
a41614033e
a41614033e
a4c88860dc
a41614033e000000
a41614033e
a4c88860dc
a41614033e
a4c88860dc
-
{e=>1,a=>50,d=>4,c=>7,h=>0,b=>5,g=>6,f=>2,i=>0}
323d0c3200
323d0c3200
323d0c3200
32bc845800
323d0c3200000000
323d0c3200
32bc845800
323d0c3200
32bc845800
-
{e=>7,a=>-126,d=>7,c=>3,h=>5,b=>2,g=>0,f=>0,i=>4}
821a3f0025
821a3f0025
821a3f0025
824cfc00b0
821a3f0025000000
821a3f0025
824cfc00b0
821a3f0025
824cfc00b0
-
{e=>6,a=>123,d=>7,c=>4,h=>6,b=>0,g=>3,f=>6,i=>4}
7b20371e26
7b20371e26
7b20371e26
7b10f8ccd0
7b20371e26000000
7b20371e26
7b10f8ccd0
7b20371e26
7b10f8ccd0
-
{e=>5,a=>21,d=>0,c=>7,h=>1,b=>3,g=>0,f=>7,i=>5}
153b280729
153b280729
153b280729
157c14e034
153b280729000000
153b280729
157c14e034
153b280729
157c14e034
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
};
-
{e=>1,a=>79,d=>6,j=>1,c=>6,h=>0,b=>1,g=>1,f=>5,i=>4}
4f310e0d2001
4f310e0d2001
4f310e0d2001
4f38c4a41020
4f310e0d20010000
4f310e0d2001
4f38c4a41020
4f310e0d2001
4f38c4a41020
-
{e=>5,a=>70,d=>7,j=>4,c=>1,h=>1,b=>4,g=>2,f=>5,i=>2}
460c2f151104
460c2f151104
460c2f151104
4684f4a82880
460c2f1511040000
460c2f151104
4684f4a82880
460c2f151104
4684f4a82880
-
{e=>2,a=>90,d=>2,j=>3,c=>7,h=>2,b=>6,g=>4,f=>7,i=>4}
5a3e12272203
5a3e12272203
5a3e12272203
5adc48f05060
5a3e122722030000
5a3e12272203
5adc48f05060
5a3e12272203
5adc48f05060
-
{e=>6,a=>48,d=>0,j=>3,c=>5,h=>3,b=>5,g=>6,f=>5,i=>3}
302d30351b03
302d30351b03
302d30351b03
30b418b86c60
302d30351b030000
302d30351b03
30b418b86c60
302d30351b03
30b418b86c60
-
{e=>6,a=>-79,d=>1,j=>4,c=>1,h=>6,b=>7,g=>6,f=>4,i=>5}
b10f31342e04
b10f31342e04
b10f31342e04
b1e43898d480
b10f31342e040000
b10f31342e04
b1e43898d480
b10f31342e04
b1e43898d480
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
};
-
{e=>3,a=>33,d=>5,j=>0,c=>5,k=>3,h=>3,b=>4,g=>0,f=>2,i=>4}
212c1d022318
212c1d022318
212c1d022318
2194ac40700c
212c1d0223180000
212c1d022318
2194ac40700c
212c1d022318
2194ac40700c
-
{e=>1,a=>64,d=>0,j=>2,c=>1,k=>7,h=>7,b=>1,g=>3,f=>0,i=>6}
40090818373a
40090818373a
40090818373a
4024040cf85c
40090818373a0000
40090818373a
4024040cf85c
40090818373a
4024040cf85c
-
{e=>0,a=>121,d=>0,j=>2,c=>3,k=>3,h=>1,b=>5,g=>0,f=>4,i=>5}
791d0004291a
791d0004291a
791d0004291a
79ac0080344c
791d0004291a0000
791d0004291a
79ac0080344c
791d0004291a
79ac0080344c
-
{e=>7,a=>-117,d=>1,j=>1,c=>6,k=>5,h=>1,b=>3,g=>1,f=>5,i=>4}
8b33390d2129
8b33390d2129
8b33390d2129
8b783ca43034
8b33390d21290000
8b33390d2129
8b783ca43034
8b33390d2129
8b783ca43034
-
{e=>5,a=>105,d=>3,j=>2,c=>3,k=>7,h=>6,b=>3,g=>5,f=>1,i=>1}
691b2b290e3a
691b2b290e3a
691b2b290e3a
696c7434c45c
691b2b290e3a0000
691b2b290e3a
696c7434c45c
691b2b290e3a
696c7434c45c
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
};
-
{e=>1,a=>-36,d=>3,j=>4,l=>1,c=>5,k=>1,h=>3,b=>7,g=>3,f=>0,i=>2}
dc2f0b18130c01
dc2f0b18130c01
dc2f0b18130c01
dcf4640c688420
dc2f0b18130c0100
dc2f0b18130c01
dcf4640c688420
dc2f0b18130c01
dcf4640c688420
-
{e=>5,a=>-81,d=>1,j=>6,l=>1,c=>3,k=>7,h=>3,b=>5,g=>3,f=>5,i=>1}
af1d291d0b3e01
af1d291d0b3e01
af1d291d0b3e01
afac34ac64dc20
af1d291d0b3e0100
af1d291d0b3e01
afac34ac64dc20
af1d291d0b3e01
afac34ac64dc20
-
{e=>0,a=>-44,d=>7,j=>3,l=>5,c=>3,k=>2,h=>2,b=>2,g=>3,f=>0,i=>6}
d41a0718321305
d41a0718321305
d41a0718321305
d44ce00c5868a0
d41a071832130500
d41a0718321305
d44ce00c5868a0
d41a0718321305
d44ce00c5868a0
-
{e=>1,a=>-34,d=>1,j=>6,l=>7,c=>6,k=>0,h=>6,b=>6,g=>5,f=>2,i=>5}
de36092a2e0607
de36092a2e0607
de36092a2e0607
ded82454d4c0e0
de36092a2e060700
de36092a2e0607
ded82454d4c0e0
de36092a2e0607
ded82454d4c0e0
-
{e=>0,a=>57,d=>4,j=>0,l=>4,c=>6,k=>1,h=>2,b=>2,g=>7,f=>6,i=>2}
3932043e120804
3932043e120804
3932043e120804
395880dc480480
3932043e12080400
3932043e120804
395880dc480480
3932043e120804
395880dc480480
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
};
-
{e=>7,a=>-101,m=>1,d=>6,j=>3,l=>6,c=>4,k=>6,h=>5,b=>1,g=>1,f=>6,i=>0}
9b213e0e05330e
9b213e0e05330e
9b213e0e05330e
9b30dcc4a078c4
9b213e0e05330e00
9b213e0e05330e
9b30dcc4a078c4
9b213e0e05330e
9b30dcc4a078c4
-
{e=>3,a=>-11,m=>4,d=>2,j=>6,l=>7,c=>6,k=>4,h=>7,b=>2,g=>1,f=>4,i=>3}
f5321a0c1f2627
f5321a0c1f2627
f5321a0c1f2627
f5584c84ecd0f0
f5321a0c1f262700
f5321a0c1f2627
f5584c84ecd0f0
f5321a0c1f2627
f5584c84ecd0f0
-
{e=>0,a=>47,m=>2,d=>7,j=>5,l=>2,c=>2,k=>3,h=>4,b=>5,g=>5,f=>1,i=>7}
2f1507293c1d12
2f1507293c1d12
2f1507293c1d12
2fa8e0349cac48
2f1507293c1d1200
2f1507293c1d12
2fa8e0349cac48
2f1507293c1d12
2fa8e0349cac48
-
{e=>1,a=>-113,m=>7,d=>2,j=>1,l=>6,c=>7,k=>4,h=>7,b=>5,g=>0,f=>6,i=>7}
8f3d0a063f213e
8f3d0a063f213e
8f3d0a063f213e
8fbc44c0fc30dc
8f3d0a063f213e00
8f3d0a063f213e
8fbc44c0fc30dc
8f3d0a063f213e
8fbc44c0fc30dc
-
{e=>2,a=>19,m=>6,d=>7,j=>5,l=>4,c=>3,k=>7,h=>4,b=>1,g=>4,f=>0,i=>3}
131917201c3d34
131917201c3d34
131917201c3d34
132ce8108cbc98
131917201c3d3400
131917201c3d34
132ce8108cbc98
131917201c3d34
132ce8108cbc98
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
};
-
{e=>6,n=>5,a=>-111,m=>0,d=>3,j=>5,l=>6,c=>7,k=>5,h=>6,b=>0,g=>4,f=>0,i=>6}
91383320362d0605
91383320362d0605
91383320362d0605
911c7810d8b4c0a0
91383320362d0605
91383320362d0605
911c7810d8b4c0a0
91383320362d0605
911c7810d8b4c0a0
-
{e=>7,n=>4,a=>-30,m=>6,d=>4,j=>3,l=>0,c=>4,k=>4,h=>1,b=>7,g=>7,f=>5,i=>0}
e2273c3d01233004
e2273c3d01233004
e2273c3d01233004
e2f09cbc20701880
e2273c3d01233004
e2273c3d01233004
e2f09cbc20701880
e2273c3d01233004
e2f09cbc20701880
-
{e=>0,n=>1,a=>22,m=>5,d=>7,j=>5,l=>0,c=>0,k=>1,h=>5,b=>3,g=>2,f=>7,i=>3}
160307171d0d2801
160307171d0d2801
160307171d0d2801
1660e0e8aca41420
160307171d0d2801
160307171d0d2801
1660e0e8aca41420
160307171d0d2801
1660e0e8aca41420
-
{e=>4,n=>5,a=>4,m=>0,d=>1,j=>2,l=>4,c=>1,k=>3,h=>0,b=>0,g=>0,f=>7,i=>6}
04082107301a0405
04082107301a0405
04082107301a0405
040430e0184c80a0
04082107301a0405
04082107301a0405
040430e0184c80a0
04082107301a0405
040430e0184c80a0
-
{e=>2,n=>3,a=>-83,m=>6,d=>6,j=>6,l=>6,c=>0,k=>1,h=>2,b=>6,g=>0,f=>6,i=>5}
ad0616062a0e3603
ad0616062a0e3603
ad0616062a0e3603
adc0c8c054c4d860
ad0616062a0e3603
ad0616062a0e3603
adc0c8c054c4d860
ad0616062a0e3603
adc0c8c054c4d860
=
struct uch_wrap {
  char a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
  short         o;
};
-
{e=>0,n=>2,a=>-105,m=>1,d=>3,j=>0,l=>1,c=>6,k=>1,h=>1,b=>2,g=>7,f=>2,o=>-102,i=>2}
9732033a110809029aff
9732033a110809029aff
9732033a110809029aff
9758605c28042440ff9a
9732033a110809029aff0000
9732033a110809029aff
9758605c28042440ff9a
9732033a110809029aff
9758605c28042440ff9a
-
{e=>1,n=>2,a=>-82,m=>2,d=>4,j=>2,l=>6,c=>0,k=>3,h=>1,b=>6,g=>6,f=>3,o=>29,i=>2}
ae060c33111a16021d00
ae060c33111a16021d00
ae060c33111a16021d00
aec08478284cc840001d
ae060c33111a16021d000000
ae060c33111a16021d00
aec08478284cc840001d
ae060c33111a16021d00
aec08478284cc840001d
-
{e=>5,n=>7,a=>-14,m=>4,d=>0,j=>7,l=>1,c=>2,k=>7,h=>7,b=>4,g=>1,f=>5,o=>-24,i=>2}
f214280d173f2107e8ff
f214280d173f2107e8ff
f214280d173f2107e8ff
f28814a4e8fc30e0ffe8
f214280d173f2107e8ff0000
f214280d173f2107e8ff
f28814a4e8fc30e0ffe8
f214280d173f2107e8ff
f28814a4e8fc30e0ffe8
-
{e=>0,n=>6,a=>96,m=>7,d=>3,j=>0,l=>3,c=>3,k=>1,h=>3,b=>6,g=>6,f=>7,o=>81,i=>2}
601e033713083b065100
601e033713083b065100
601e033713083b065100
60cc60f868047cc00051
601e033713083b0651000000
601e033713083b065100
60cc60f868047cc00051
601e033713083b065100
60cc60f868047cc00051
-
{e=>6,n=>2,a=>-36,m=>0,d=>2,j=>6,l=>5,c=>4,k=>0,h=>3,b=>6,g=>6,f=>5,o=>-17,i=>5}
dc2632352b060502efff
dc2632352b060502efff
dc2632352b060502efff
dcd058b874c0a040ffef
dc2632352b060502efff0000
dc2632352b060502efff
dcd058b874c0a040ffef
dc2632352b060502efff
dcd058b874c0a040ffef
=
struct uch_wrap {
  short a;
  unsigned char b:3;
};
-
{a=>102,b=>2}
66000200
66000200
66000200
00664000
66000200
66000200
00664000
66000200
00664000
-
{a=>39,b=>4}
27000400
27000400
27000400
00278000
27000400
27000400
00278000
27000400
00278000
-
{a=>-119,b=>5}
89ff0500
89ff0500
89ff0500
ff89a000
89ff0500
89ff0500
ff89a000
89ff0500
ff89a000
-
{a=>69,b=>7}
45000700
45000700
45000700
0045e000
45000700
45000700
0045e000
45000700
0045e000
-
{a=>46,b=>7}
2e000700
2e000700
2e000700
002ee000
2e000700
2e000700
002ee000
2e000700
002ee000
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
};
-
{c=>2,a=>-97,b=>2}
9fff1200
9fff1200
9fff1200
ff9f4800
9fff1200
9fff1200
ff9f4800
9fff1200
ff9f4800
-
{c=>5,a=>-16,b=>5}
f0ff2d00
f0ff2d00
f0ff2d00
fff0b400
f0ff2d00
f0ff2d00
fff0b400
f0ff2d00
fff0b400
-
{c=>5,a=>100,b=>5}
64002d00
64002d00
64002d00
0064b400
64002d00
64002d00
0064b400
64002d00
0064b400
-
{c=>1,a=>117,b=>2}
75000a00
75000a00
75000a00
00754400
75000a00
75000a00
00754400
75000a00
00754400
-
{c=>1,a=>-105,b=>4}
97ff0c00
97ff0c00
97ff0c00
ff978400
97ff0c00
97ff0c00
ff978400
97ff0c00
ff978400
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
};
-
{c=>2,a=>7,b=>5,d=>3}
07001503
07001503
07001503
0007a860
07001503
07001503
0007a860
07001503
0007a860
-
{c=>7,a=>-90,b=>4,d=>1}
a6ff3c01
a6ff3c01
a6ff3c01
ffa69c20
a6ff3c01
a6ff3c01
ffa69c20
a6ff3c01
ffa69c20
-
{c=>1,a=>61,b=>0,d=>2}
3d000802
3d000802
3d000802
003d0440
3d000802
3d000802
003d0440
3d000802
003d0440
-
{c=>1,a=>36,b=>7,d=>2}
24000f02
24000f02
24000f02
0024e440
24000f02
24000f02
0024e440
24000f02
0024e440
-
{c=>4,a=>-76,b=>5,d=>0}
b4ff2500
b4ff2500
b4ff2500
ffb4b000
b4ff2500
b4ff2500
ffb4b000
b4ff2500
ffb4b000
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
};
-
{e=>4,c=>2,a=>-103,b=>0,d=>3}
99ff1023
99ff1023
99ff1023
ff990870
99ff1023
99ff1023
ff990870
99ff1023
ff990870
-
{e=>2,c=>0,a=>17,b=>5,d=>5}
11000515
11000515
11000515
0011a0a8
11000515
11000515
0011a0a8
11000515
0011a0a8
-
{e=>5,c=>5,a=>27,b=>2,d=>1}
1b002a29
1b002a29
1b002a29
001b5434
1b002a29
1b002a29
001b5434
1b002a29
001b5434
-
{e=>1,c=>5,a=>-77,b=>3,d=>5}
b3ff2b0d
b3ff2b0d
b3ff2b0d
ffb374a4
b3ff2b0d
b3ff2b0d
ffb374a4
b3ff2b0d
ffb374a4
-
{e=>2,c=>0,a=>-112,b=>4,d=>1}
90ff0411
90ff0411
90ff0411
ff908028
90ff0411
90ff0411
ff908028
90ff0411
ff908028
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
};
-
{e=>3,c=>1,a=>61,b=>4,d=>2,f=>2}
3d000c1a0200
3d000c1a0200
3d000c1a0200
003d844c4000
3d000c1a02000000
3d000c1a0200
003d844c4000
3d000c1a0200
003d844c4000
-
{e=>1,c=>7,a=>-8,b=>0,d=>6,f=>0}
f8ff380e0000
f8ff380e0000
f8ff380e0000
fff81cc40000
f8ff380e00000000
f8ff380e0000
fff81cc40000
f8ff380e0000
fff81cc40000
-
{e=>2,c=>6,a=>-96,b=>0,d=>5,f=>7}
a0ff30150700
a0ff30150700
a0ff30150700
ffa018a8e000
a0ff301507000000
a0ff30150700
ffa018a8e000
a0ff30150700
ffa018a8e000
-
{e=>3,c=>2,a=>122,b=>5,d=>0,f=>0}
7a0015180000
7a0015180000
7a0015180000
007aa80c0000
7a00151800000000
7a0015180000
007aa80c0000
7a0015180000
007aa80c0000
-
{e=>3,c=>6,a=>-122,b=>0,d=>1,f=>2}
86ff30190200
86ff30190200
86ff30190200
ff86182c4000
86ff301902000000
86ff30190200
ff86182c4000
86ff30190200
ff86182c4000
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
};
-
{e=>1,c=>5,a=>-86,g=>7,b=>7,d=>7,f=>6}
aaff2f0f3e00
aaff2f0f3e00
aaff2f0f3e00
ffaaf4e4dc00
aaff2f0f3e000000
aaff2f0f3e00
ffaaf4e4dc00
aaff2f0f3e00
ffaaf4e4dc00
-
{e=>5,c=>7,a=>78,g=>2,b=>1,d=>6,f=>1}
4e00392e1100
4e00392e1100
4e00392e1100
004e3cd42800
4e00392e11000000
4e00392e1100
004e3cd42800
4e00392e1100
004e3cd42800
-
{e=>4,c=>0,a=>-57,g=>4,b=>2,d=>4,f=>1}
c7ff02242100
c7ff02242100
c7ff02242100
ffc740903000
c7ff022421000000
c7ff02242100
ffc740903000
c7ff02242100
ffc740903000
-
{e=>6,c=>6,a=>36,g=>3,b=>1,d=>5,f=>3}
240031351b00
240031351b00
240031351b00
002438b86c00
240031351b000000
240031351b00
002438b86c00
240031351b00
002438b86c00
-
{e=>5,c=>6,a=>-105,g=>2,b=>7,d=>7,f=>0}
97ff372f1000
97ff372f1000
97ff372f1000
ff97f8f40800
97ff372f10000000
97ff372f1000
ff97f8f40800
97ff372f1000
ff97f8f40800
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
};
-
{e=>2,a=>103,d=>5,c=>5,h=>6,b=>3,g=>2,f=>1}
67002b151106
67002b151106
67002b151106
006774a828c0
67002b1511060000
67002b151106
006774a828c0
67002b151106
006774a828c0
-
{e=>1,a=>-88,d=>4,c=>6,h=>1,b=>5,g=>2,f=>3}
a8ff350c1301
a8ff350c1301
a8ff350c1301
ffa8b8846820
a8ff350c13010000
a8ff350c1301
ffa8b8846820
a8ff350c1301
ffa8b8846820
-
{e=>0,a=>-80,d=>3,c=>7,h=>5,b=>3,g=>5,f=>6}
b0ff3b032e05
b0ff3b032e05
b0ff3b032e05
ffb07c60d4a0
b0ff3b032e050000
b0ff3b032e05
ffb07c60d4a0
b0ff3b032e05
ffb07c60d4a0
-
{e=>5,a=>-89,d=>6,c=>6,h=>1,b=>0,g=>4,f=>1}
a7ff302e2101
a7ff302e2101
a7ff302e2101
ffa718d43020
a7ff302e21010000
a7ff302e2101
ffa718d43020
a7ff302e2101
ffa718d43020
-
{e=>4,a=>-32,d=>5,c=>2,h=>0,b=>4,g=>7,f=>7}
e0ff14253f00
e0ff14253f00
e0ff14253f00
ffe088b0fc00
e0ff14253f000000
e0ff14253f00
ffe088b0fc00
e0ff14253f00
ffe088b0fc00
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
};
-
{e=>6,a=>-1,d=>6,c=>3,h=>1,b=>6,g=>2,f=>7,i=>5}
ffff1e361729
ffff1e361729
ffff1e361729
ffffccd8e834
ffff1e3617290000
ffff1e361729
ffffccd8e834
ffff1e361729
ffffccd8e834
-
{e=>1,a=>21,d=>3,c=>7,h=>0,b=>3,g=>5,f=>0,i=>1}
15003b0b2808
15003b0b2808
15003b0b2808
00157c641404
15003b0b28080000
15003b0b2808
00157c641404
15003b0b2808
00157c641404
-
{e=>4,a=>124,d=>0,c=>3,h=>5,b=>6,g=>1,f=>0,i=>7}
7c001e20083d
7c001e20083d
7c001e20083d
007ccc1004bc
7c001e20083d0000
7c001e20083d
007ccc1004bc
7c001e20083d
007ccc1004bc
-
{e=>6,a=>53,d=>6,c=>4,h=>3,b=>7,g=>3,f=>0,i=>0}
350027361803
350027361803
350027361803
0035f0d80c60
3500273618030000
350027361803
0035f0d80c60
350027361803
0035f0d80c60
-
{e=>5,a=>14,d=>0,c=>5,h=>0,b=>0,g=>0,f=>4,i=>1}
0e0028280408
0e0028280408
0e0028280408
000e14148004
0e00282804080000
0e0028280408
000e14148004
0e0028280408
000e14148004
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
};
-
{e=>4,a=>-128,d=>5,j=>4,c=>0,h=>4,b=>2,g=>7,f=>5,i=>5}
80ff02253d2c0400
80ff02253d2c0400
80ff02253d2c0400
ff8040b0bc948000
80ff02253d2c0400
80ff02253d2c0400
ff8040b0bc948000
80ff02253d2c0400
ff8040b0bc948000
-
{e=>5,a=>-33,d=>3,j=>4,c=>5,h=>7,b=>7,g=>1,f=>6,i=>5}
dfff2f2b0e2f0400
dfff2f2b0e2f0400
dfff2f2b0e2f0400
ffdff474c4f48000
dfff2f2b0e2f0400
dfff2f2b0e2f0400
ffdff474c4f48000
dfff2f2b0e2f0400
ffdff474c4f48000
-
{e=>3,a=>-96,d=>1,j=>1,c=>4,h=>2,b=>3,g=>7,f=>6,i=>6}
a0ff23193e320100
a0ff23193e320100
a0ff23193e320100
ffa0702cdc582000
a0ff23193e320100
a0ff23193e320100
ffa0702cdc582000
a0ff23193e320100
ffa0702cdc582000
-
{e=>7,a=>-9,d=>6,j=>4,c=>3,h=>1,b=>3,g=>3,f=>1,i=>0}
f7ff1b3e19010400
f7ff1b3e19010400
f7ff1b3e19010400
fff76cdc2c208000
f7ff1b3e19010400
f7ff1b3e19010400
fff76cdc2c208000
f7ff1b3e19010400
fff76cdc2c208000
-
{e=>2,a=>63,d=>4,j=>2,c=>4,h=>0,b=>4,g=>3,f=>5,i=>0}
3f0024141d000200
3f0024141d000200
3f0024141d000200
003f9088ac004000
3f0024141d000200
3f0024141d000200
003f9088ac004000
3f0024141d000200
003f9088ac004000
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
};
-
{e=>4,a=>57,d=>7,j=>7,c=>4,k=>0,h=>5,b=>3,g=>3,f=>4,i=>6}
390023271c350700
390023271c350700
390023271c350700
003970f08cb8e000
390023271c350700
390023271c350700
003970f08cb8e000
390023271c350700
003970f08cb8e000
-
{e=>7,a=>-11,d=>1,j=>4,c=>0,k=>5,h=>1,b=>5,g=>5,f=>7,i=>5}
f5ff05392f292c00
f5ff05392f292c00
f5ff05392f292c00
fff5a03cf4349400
f5ff05392f292c00
f5ff05392f292c00
fff5a03cf4349400
f5ff05392f292c00
fff5a03cf4349400
-
{e=>7,a=>-117,d=>2,j=>6,c=>7,k=>6,h=>1,b=>2,g=>0,f=>1,i=>1}
8bff3a3a01093600
8bff3a3a01093600
8bff3a3a01093600
ff8b5c5c2024d800
8bff3a3a01093600
8bff3a3a01093600
ff8b5c5c2024d800
8bff3a3a01093600
ff8b5c5c2024d800
-
{e=>7,a=>-118,d=>6,j=>3,c=>7,k=>4,h=>2,b=>4,g=>3,f=>6,i=>0}
8aff3c3e1e022300
8aff3c3e1e022300
8aff3c3e1e022300
ff8a9cdccc407000
8aff3c3e1e022300
8aff3c3e1e022300
ff8a9cdccc407000
8aff3c3e1e022300
ff8a9cdccc407000
-
{e=>4,a=>-15,d=>1,j=>1,c=>7,k=>6,h=>5,b=>4,g=>7,f=>3,i=>7}
f1ff3c213b3d3100
f1ff3c213b3d3100
f1ff3c213b3d3100
fff19c307cbc3800
f1ff3c213b3d3100
f1ff3c213b3d3100
fff19c307cbc3800
f1ff3c213b3d3100
fff19c307cbc3800
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
};
-
{e=>5,a=>24,d=>4,j=>2,l=>6,c=>3,k=>2,h=>1,b=>5,g=>4,f=>5,i=>2}
18001d2c25111206
18001d2c25111206
18001d2c25111206
0018ac94b02848c0
18001d2c25111206
18001d2c25111206
0018ac94b02848c0
18001d2c25111206
0018ac94b02848c0
-
{e=>7,a=>-76,d=>2,j=>2,l=>5,c=>2,k=>2,h=>3,b=>5,g=>4,f=>7,i=>5}
b4ff153a272b1205
b4ff153a272b1205
b4ff153a272b1205
ffb4a85cf07448a0
b4ff153a272b1205
b4ff153a272b1205
ffb4a85cf07448a0
b4ff153a272b1205
ffb4a85cf07448a0
-
{e=>4,a=>69,d=>4,j=>6,l=>1,c=>1,k=>0,h=>0,b=>6,g=>7,f=>1,i=>3}
45000e2439180601
45000e2439180601
45000e2439180601
0045c4903c0cc020
45000e2439180601
45000e2439180601
0045c4903c0cc020
45000e2439180601
0045c4903c0cc020
-
{e=>6,a=>-5,d=>4,j=>4,l=>7,c=>6,k=>6,h=>2,b=>3,g=>6,f=>5,i=>6}
fbff333435323407
fbff333435323407
fbff333435323407
fffb7898b85898e0
fbff333435323407
fbff333435323407
fffb7898b85898e0
fbff333435323407
fffb7898b85898e0
-
{e=>1,a=>84,d=>1,j=>5,l=>6,c=>3,k=>4,h=>7,b=>2,g=>6,f=>4,i=>3}
54001a09341f2506
54001a09341f2506
54001a09341f2506
00544c2498ecb0c0
54001a09341f2506
54001a09341f2506
00544c2498ecb0c0
54001a09341f2506
00544c2498ecb0c0
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
};
-
{e=>0,a=>-34,m=>7,d=>7,j=>0,l=>2,c=>3,k=>5,h=>5,b=>1,g=>0,f=>6,i=>6}
deff19070635283a
deff19070635283a
deff19070635283a
ffde2ce0c0b8145c
deff19070635283a
deff19070635283a
ffde2ce0c0b8145c
deff19070635283a
ffde2ce0c0b8145c
-
{e=>1,a=>-67,m=>0,d=>2,j=>7,l=>0,c=>2,k=>4,h=>2,b=>7,g=>3,f=>7,i=>4}
bdff170a1f222700
bdff170a1f222700
bdff170a1f222700
ffbde844ec50f000
bdff170a1f222700
bdff170a1f222700
ffbde844ec50f000
bdff170a1f222700
ffbde844ec50f000
-
{e=>5,a=>61,m=>7,d=>1,j=>3,l=>5,c=>6,k=>5,h=>3,b=>4,g=>7,f=>3,i=>7}
3d0034293b3b2b3d
3d0034293b3b2b3d
3d0034293b3b2b3d
003d98347c7c74bc
3d0034293b3b2b3d
3d0034293b3b2b3d
003d98347c7c74bc
3d0034293b3b2b3d
003d98347c7c74bc
-
{e=>5,a=>96,m=>6,d=>5,j=>4,l=>5,c=>1,k=>3,h=>1,b=>6,g=>2,f=>2,i=>3}
60000e2d12191c35
60000e2d12191c35
60000e2d12191c35
0060c4b4482c8cb8
60000e2d12191c35
60000e2d12191c35
0060c4b4482c8cb8
60000e2d12191c35
0060c4b4482c8cb8
-
{e=>3,a=>-6,m=>6,d=>3,j=>6,l=>6,c=>5,k=>2,h=>5,b=>6,g=>3,f=>5,i=>0}
faff2e1b1d051636
faff2e1b1d051636
faff2e1b1d051636
fffad46caca0c8d8
faff2e1b1d051636
faff2e1b1d051636
fffad46caca0c8d8
faff2e1b1d051636
fffad46caca0c8d8
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
};
-
{e=>7,n=>7,a=>-88,m=>4,d=>0,j=>4,l=>6,c=>3,k=>5,h=>2,b=>1,g=>6,f=>5,i=>7}
a8ff1938353a2c260700
a8ff1938353a2c260700
a8ff1938353a2c260700
ffa82c1cb85c94d0e000
a8ff1938353a2c2607000000
a8ff1938353a2c260700
ffa82c1cb85c94d0e000
a8ff1938353a2c260700
ffa82c1cb85c94d0e000
-
{e=>0,n=>1,a=>-51,m=>3,d=>3,j=>2,l=>4,c=>1,k=>1,h=>6,b=>6,g=>5,f=>7,i=>2}
cdff0e032f160a1c0100
cdff0e032f160a1c0100
cdff0e032f160a1c0100
ffcdc460f4c8448c2000
cdff0e032f160a1c01000000
cdff0e032f160a1c0100
ffcdc460f4c8448c2000
cdff0e032f160a1c0100
ffcdc460f4c8448c2000
-
{e=>2,n=>6,a=>20,m=>5,d=>3,j=>4,l=>6,c=>1,k=>3,h=>6,b=>5,g=>4,f=>2,i=>5}
14000d13222e1c2e0600
14000d13222e1c2e0600
14000d13222e1c2e0600
0014a46850d48cd4c000
14000d13222e1c2e06000000
14000d13222e1c2e0600
0014a46850d48cd4c000
14000d13222e1c2e0600
0014a46850d48cd4c000
-
{e=>4,n=>1,a=>-110,m=>2,d=>6,j=>4,l=>5,c=>4,k=>5,h=>0,b=>1,g=>7,f=>4,i=>6}
92ff21263c302c150100
92ff21263c302c150100
92ff21263c302c150100
ff9230d09c1894a82000
92ff21263c302c1501000000
92ff21263c302c150100
ff9230d09c1894a82000
92ff21263c302c150100
ff9230d09c1894a82000
-
{e=>0,n=>0,a=>-45,m=>2,d=>5,j=>7,l=>4,c=>5,k=>6,h=>1,b=>2,g=>6,f=>4,i=>0}
d3ff2a05340137140000
d3ff2a05340137140000
d3ff2a05340137140000
ffd354a09820f8880000
d3ff2a053401371400000000
d3ff2a05340137140000
ffd354a09820f8880000
d3ff2a05340137140000
ffd354a09820f8880000
=
struct uch_wrap {
  short a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
  short         o;
};
-
{e=>0,n=>2,a=>-65,m=>5,d=>5,j=>4,l=>2,c=>5,k=>0,h=>7,b=>2,g=>6,f=>3,o=>-15,i=>2}
bfff2a053317042a0200f1ff
bfff2a053317042a0200f1ff
bfff2a053317042a0200f1ff
ffbf54a078e880544000fff1
bfff2a053317042a0200f1ff
bfff2a053317042a0200f1ff
ffbf54a078e880544000fff1
bfff2a053317042a0200f1ff
ffbf54a078e880544000fff1
-
{e=>3,n=>6,a=>15,m=>2,d=>7,j=>7,l=>4,c=>5,k=>4,h=>2,b=>0,g=>3,f=>3,o=>30,i=>1}
0f00281f1b0a271406001e00
0f00281f1b0a271406001e00
0f00281f1b0a271406001e00
000f14ec6c44f088c000001e
0f00281f1b0a271406001e00
0f00281f1b0a271406001e00
000f14ec6c44f088c000001e
0f00281f1b0a271406001e00
000f14ec6c44f088c000001e
-
{e=>5,n=>7,a=>74,m=>6,d=>0,j=>7,l=>5,c=>3,k=>4,h=>4,b=>3,g=>6,f=>2,o=>69,i=>5}
4a001b28322c273507004500
4a001b28322c273507004500
4a001b28322c273507004500
004a6c145894f0b8e0000045
4a001b28322c273507004500
4a001b28322c273507004500
004a6c145894f0b8e0000045
4a001b28322c273507004500
004a6c145894f0b8e0000045
-
{e=>1,n=>2,a=>84,m=>2,d=>3,j=>5,l=>4,c=>3,k=>6,h=>6,b=>1,g=>6,f=>7,o=>98,i=>6}
5400190b3736351402006200
5400190b3736351402006200
5400190b3736351402006200
00542c64f8d8b88840000062
5400190b3736351402006200
5400190b3736351402006200
00542c64f8d8b88840000062
5400190b3736351402006200
00542c64f8d8b88840000062
-
{e=>3,n=>6,a=>57,m=>7,d=>6,j=>0,l=>4,c=>4,k=>1,h=>1,b=>2,g=>2,f=>7,o=>-43,i=>0}
3900221e1701083c0600d5ff
3900221e1701083c0600d5ff
3900221e1701083c0600d5ff
003950cce820049cc000ffd5
3900221e1701083c0600d5ff
3900221e1701083c0600d5ff
003950cce820049cc000ffd5
3900221e1701083c0600d5ff
003950cce820049cc000ffd5
=
struct uch_wrap {
  int a;
  unsigned char b:3;
};
-
{a=>-6,b=>4}
faffffff04000000
faffffff04000000
faffffff04000000
fffffffa80000000
faffffff04000000
faffffff04000000
fffffffa80000000
faffffff04000000
fffffffa80000000
-
{a=>48,b=>4}
3000000004000000
3000000004000000
3000000004000000
0000003080000000
3000000004000000
3000000004000000
0000003080000000
3000000004000000
0000003080000000
-
{a=>24,b=>4}
1800000004000000
1800000004000000
1800000004000000
0000001880000000
1800000004000000
1800000004000000
0000001880000000
1800000004000000
0000001880000000
-
{a=>-13,b=>5}
f3ffffff05000000
f3ffffff05000000
f3ffffff05000000
fffffff3a0000000
f3ffffff05000000
f3ffffff05000000
fffffff3a0000000
f3ffffff05000000
fffffff3a0000000
-
{a=>-58,b=>1}
c6ffffff01000000
c6ffffff01000000
c6ffffff01000000
ffffffc620000000
c6ffffff01000000
c6ffffff01000000
ffffffc620000000
c6ffffff01000000
ffffffc620000000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
};
-
{c=>3,a=>52,b=>2}
340000001a000000
340000001a000000
340000001a000000
000000344c000000
340000001a000000
340000001a000000
000000344c000000
340000001a000000
000000344c000000
-
{c=>6,a=>-113,b=>2}
8fffffff32000000
8fffffff32000000
8fffffff32000000
ffffff8f58000000
8fffffff32000000
8fffffff32000000
ffffff8f58000000
8fffffff32000000
ffffff8f58000000
-
{c=>7,a=>-72,b=>6}
b8ffffff3e000000
b8ffffff3e000000
b8ffffff3e000000
ffffffb8dc000000
b8ffffff3e000000
b8ffffff3e000000
ffffffb8dc000000
b8ffffff3e000000
ffffffb8dc000000
-
{c=>4,a=>93,b=>7}
5d00000027000000
5d00000027000000
5d00000027000000
0000005df0000000
5d00000027000000
5d00000027000000
0000005df0000000
5d00000027000000
0000005df0000000
-
{c=>5,a=>34,b=>5}
220000002d000000
220000002d000000
220000002d000000
00000022b4000000
220000002d000000
220000002d000000
00000022b4000000
220000002d000000
00000022b4000000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
};
-
{c=>4,a=>1,b=>6,d=>5}
0100000026050000
0100000026050000
0100000026050000
00000001d0a00000
0100000026050000
0100000026050000
00000001d0a00000
0100000026050000
00000001d0a00000
-
{c=>1,a=>35,b=>0,d=>6}
2300000008060000
2300000008060000
2300000008060000
0000002304c00000
2300000008060000
2300000008060000
0000002304c00000
2300000008060000
0000002304c00000
-
{c=>3,a=>81,b=>1,d=>7}
5100000019070000
5100000019070000
5100000019070000
000000512ce00000
5100000019070000
5100000019070000
000000512ce00000
5100000019070000
000000512ce00000
-
{c=>5,a=>19,b=>3,d=>2}
130000002b020000
130000002b020000
130000002b020000
0000001374400000
130000002b020000
130000002b020000
0000001374400000
130000002b020000
0000001374400000
-
{c=>7,a=>-108,b=>5,d=>3}
94ffffff3d030000
94ffffff3d030000
94ffffff3d030000
ffffff94bc600000
94ffffff3d030000
94ffffff3d030000
ffffff94bc600000
94ffffff3d030000
ffffff94bc600000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
};
-
{e=>0,c=>0,a=>58,b=>1,d=>6}
3a00000001060000
3a00000001060000
3a00000001060000
0000003a20c00000
3a00000001060000
3a00000001060000
0000003a20c00000
3a00000001060000
0000003a20c00000
-
{e=>4,c=>2,a=>67,b=>4,d=>2}
4300000014220000
4300000014220000
4300000014220000
0000004388500000
4300000014220000
4300000014220000
0000004388500000
4300000014220000
0000004388500000
-
{e=>0,c=>2,a=>20,b=>7,d=>4}
1400000017040000
1400000017040000
1400000017040000
00000014e8800000
1400000017040000
1400000017040000
00000014e8800000
1400000017040000
00000014e8800000
-
{e=>7,c=>4,a=>-17,b=>5,d=>7}
efffffff253f0000
efffffff253f0000
efffffff253f0000
ffffffefb0fc0000
efffffff253f0000
efffffff253f0000
ffffffefb0fc0000
efffffff253f0000
ffffffefb0fc0000
-
{e=>7,c=>1,a=>-49,b=>4,d=>7}
cfffffff0c3f0000
cfffffff0c3f0000
cfffffff0c3f0000
ffffffcf84fc0000
cfffffff0c3f0000
cfffffff0c3f0000
ffffffcf84fc0000
cfffffff0c3f0000
ffffffcf84fc0000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
};
-
{e=>7,c=>0,a=>-9,b=>1,d=>3,f=>6}
f7ffffff013b0600
f7ffffff013b0600
f7ffffff013b0600
fffffff7207cc000
f7ffffff013b0600
f7ffffff013b0600
fffffff7207cc000
f7ffffff013b0600
fffffff7207cc000
-
{e=>2,c=>2,a=>72,b=>4,d=>6,f=>1}
4800000014160100
4800000014160100
4800000014160100
0000004888c82000
4800000014160100
4800000014160100
0000004888c82000
4800000014160100
0000004888c82000
-
{e=>7,c=>0,a=>-66,b=>1,d=>4,f=>5}
beffffff013c0500
beffffff013c0500
beffffff013c0500
ffffffbe209ca000
beffffff013c0500
beffffff013c0500
ffffffbe209ca000
beffffff013c0500
ffffffbe209ca000
-
{e=>6,c=>1,a=>121,b=>7,d=>2,f=>2}
790000000f320200
790000000f320200
790000000f320200
00000079e4584000
790000000f320200
790000000f320200
00000079e4584000
790000000f320200
00000079e4584000
-
{e=>1,c=>6,a=>-56,b=>7,d=>4,f=>3}
c8ffffff370c0300
c8ffffff370c0300
c8ffffff370c0300
ffffffc8f8846000
c8ffffff370c0300
c8ffffff370c0300
ffffffc8f8846000
c8ffffff370c0300
ffffffc8f8846000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
};
-
{e=>6,c=>3,a=>76,g=>4,b=>6,d=>4,f=>4}
4c0000001e342400
4c0000001e342400
4c0000001e342400
0000004ccc989000
4c0000001e342400
4c0000001e342400
0000004ccc989000
4c0000001e342400
0000004ccc989000
-
{e=>0,c=>4,a=>-114,g=>7,b=>4,d=>6,f=>5}
8effffff24063d00
8effffff24063d00
8effffff24063d00
ffffff8e90c0bc00
8effffff24063d00
8effffff24063d00
ffffff8e90c0bc00
8effffff24063d00
ffffff8e90c0bc00
-
{e=>4,c=>5,a=>8,g=>7,b=>4,d=>0,f=>4}
080000002c203c00
080000002c203c00
080000002c203c00
0000000894109c00
080000002c203c00
080000002c203c00
0000000894109c00
080000002c203c00
0000000894109c00
-
{e=>5,c=>3,a=>-73,g=>2,b=>6,d=>6,f=>4}
b7ffffff1e2e1400
b7ffffff1e2e1400
b7ffffff1e2e1400
ffffffb7ccd48800
b7ffffff1e2e1400
b7ffffff1e2e1400
ffffffb7ccd48800
b7ffffff1e2e1400
ffffffb7ccd48800
-
{e=>7,c=>6,a=>69,g=>5,b=>2,d=>5,f=>2}
45000000323d2a00
45000000323d2a00
45000000323d2a00
0000004558bc5400
45000000323d2a00
45000000323d2a00
0000004558bc5400
45000000323d2a00
0000004558bc5400
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
};
-
{e=>0,a=>21,d=>5,c=>3,h=>0,b=>7,g=>4,f=>4}
150000001f052400
150000001f052400
150000001f052400
00000015eca09000
150000001f052400
150000001f052400
00000015eca09000
150000001f052400
00000015eca09000
-
{e=>5,a=>124,d=>3,c=>5,h=>6,b=>1,g=>3,f=>6}
7c000000292b1e06
7c000000292b1e06
7c000000292b1e06
0000007c3474ccc0
7c000000292b1e06
7c000000292b1e06
0000007c3474ccc0
7c000000292b1e06
0000007c3474ccc0
-
{e=>6,a=>1,d=>4,c=>7,h=>1,b=>2,g=>4,f=>7}
010000003a342701
010000003a342701
010000003a342701
000000015c98f020
010000003a342701
010000003a342701
000000015c98f020
010000003a342701
000000015c98f020
-
{e=>7,a=>36,d=>6,c=>0,h=>7,b=>1,g=>5,f=>2}
24000000013e2a07
24000000013e2a07
24000000013e2a07
0000002420dc54e0
24000000013e2a07
24000000013e2a07
0000002420dc54e0
24000000013e2a07
0000002420dc54e0
-
{e=>1,a=>121,d=>4,c=>4,h=>0,b=>0,g=>6,f=>5}
79000000200c3500
79000000200c3500
79000000200c3500
000000791084b800
79000000200c3500
79000000200c3500
000000791084b800
79000000200c3500
000000791084b800
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
};
-
{e=>4,a=>-75,d=>3,c=>1,h=>2,b=>0,g=>4,f=>3,i=>4}
b5ffffff08232322
b5ffffff08232322
b5ffffff08232322
ffffffb504707050
b5ffffff08232322
b5ffffff08232322
ffffffb504707050
b5ffffff08232322
ffffffb504707050
-
{e=>4,a=>-82,d=>3,c=>2,h=>4,b=>5,g=>0,f=>2,i=>2}
aeffffff15230214
aeffffff15230214
aeffffff15230214
ffffffaea8704088
aeffffff15230214
aeffffff15230214
ffffffaea8704088
aeffffff15230214
ffffffaea8704088
-
{e=>0,a=>46,d=>7,c=>3,h=>6,b=>6,g=>7,f=>6,i=>5}
2e0000001e073e2e
2e0000001e073e2e
2e0000001e073e2e
0000002ecce0dcd4
2e0000001e073e2e
2e0000001e073e2e
0000002ecce0dcd4
2e0000001e073e2e
0000002ecce0dcd4
-
{e=>0,a=>4,d=>0,c=>6,h=>3,b=>5,g=>3,f=>0,i=>3}
040000003500181b
040000003500181b
040000003500181b
00000004b8000c6c
040000003500181b
040000003500181b
00000004b8000c6c
040000003500181b
00000004b8000c6c
-
{e=>0,a=>-54,d=>1,c=>7,h=>7,b=>1,g=>7,f=>6,i=>6}
caffffff39013e37
caffffff39013e37
caffffff39013e37
ffffffca3c20dcf8
caffffff39013e37
caffffff39013e37
ffffffca3c20dcf8
caffffff39013e37
ffffffca3c20dcf8
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
};
-
{e=>4,a=>101,d=>4,j=>0,c=>1,h=>6,b=>4,g=>7,f=>6,i=>5}
650000000c243e2e00000000
650000000c243e2e00000000
650000000c243e2e00000000
000000658490dcd400000000
650000000c243e2e00000000
650000000c243e2e00000000
000000658490dcd400000000
650000000c243e2e00000000
000000658490dcd400000000
-
{e=>0,a=>33,d=>6,j=>1,c=>0,h=>2,b=>3,g=>0,f=>1,i=>4}
210000000306012201000000
210000000306012201000000
210000000306012201000000
0000002160c0205020000000
210000000306012201000000
210000000306012201000000
0000002160c0205020000000
210000000306012201000000
0000002160c0205020000000
-
{e=>0,a=>31,d=>4,j=>4,c=>3,h=>2,b=>7,g=>3,f=>7,i=>4}
1f0000001f041f2204000000
1f0000001f041f2204000000
1f0000001f041f2204000000
0000001fec80ec5080000000
1f0000001f041f2204000000
1f0000001f041f2204000000
0000001fec80ec5080000000
1f0000001f041f2204000000
0000001fec80ec5080000000
-
{e=>0,a=>-102,d=>5,j=>2,c=>1,h=>3,b=>1,g=>4,f=>5,i=>4}
9affffff0905252302000000
9affffff0905252302000000
9affffff0905252302000000
ffffff9a24a0b07040000000
9affffff0905252302000000
9affffff0905252302000000
ffffff9a24a0b07040000000
9affffff0905252302000000
ffffff9a24a0b07040000000
-
{e=>3,a=>117,d=>6,j=>5,c=>1,h=>3,b=>4,g=>4,f=>7,i=>4}
750000000c1e272305000000
750000000c1e272305000000
750000000c1e272305000000
0000007584ccf070a0000000
750000000c1e272305000000
750000000c1e272305000000
0000007584ccf070a0000000
750000000c1e272305000000
0000007584ccf070a0000000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
};
-
{e=>7,a=>7,d=>0,j=>2,c=>5,k=>6,h=>2,b=>2,g=>6,f=>1,i=>1}
070000002a38310a32000000
070000002a38310a32000000
070000002a38310a32000000
00000007541c384458000000
070000002a38310a32000000
070000002a38310a32000000
00000007541c384458000000
070000002a38310a32000000
00000007541c384458000000
-
{e=>0,a=>73,d=>0,j=>0,c=>6,k=>0,h=>7,b=>2,g=>4,f=>2,i=>6}
490000003200223700000000
490000003200223700000000
490000003200223700000000
00000049580050f800000000
490000003200223700000000
490000003200223700000000
00000049580050f800000000
490000003200223700000000
00000049580050f800000000
-
{e=>5,a=>-16,d=>1,j=>5,c=>2,k=>0,h=>5,b=>3,g=>5,f=>2,i=>0}
f0ffffff13292a0505000000
f0ffffff13292a0505000000
f0ffffff13292a0505000000
fffffff0683454a0a0000000
f0ffffff13292a0505000000
f0ffffff13292a0505000000
fffffff0683454a0a0000000
f0ffffff13292a0505000000
fffffff0683454a0a0000000
-
{e=>2,a=>85,d=>1,j=>7,c=>7,k=>5,h=>0,b=>2,g=>7,f=>4,i=>6}
550000003a113c302f000000
550000003a113c302f000000
550000003a113c302f000000
000000555c289c18f4000000
550000003a113c302f000000
550000003a113c302f000000
000000555c289c18f4000000
550000003a113c302f000000
000000555c289c18f4000000
-
{e=>1,a=>-111,d=>4,j=>1,c=>4,k=>4,h=>0,b=>1,g=>3,f=>1,i=>4}
91ffffff210c192021000000
91ffffff210c192021000000
91ffffff210c192021000000
ffffff9130842c1030000000
91ffffff210c192021000000
91ffffff210c192021000000
ffffff9130842c1030000000
91ffffff210c192021000000
ffffff9130842c1030000000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
};
-
{e=>4,a=>-94,d=>1,j=>5,l=>1,c=>6,k=>5,h=>7,b=>6,g=>1,f=>1,i=>7}
a2ffffff3621093f2d010000
a2ffffff3621093f2d010000
a2ffffff3621093f2d010000
ffffffa2d83024fcb4200000
a2ffffff3621093f2d010000
a2ffffff3621093f2d010000
ffffffa2d83024fcb4200000
a2ffffff3621093f2d010000
ffffffa2d83024fcb4200000
-
{e=>2,a=>-111,d=>5,j=>6,l=>5,c=>3,k=>0,h=>6,b=>2,g=>0,f=>1,i=>6}
91ffffff1a15013606050000
91ffffff1a15013606050000
91ffffff1a15013606050000
ffffff914ca820d8c0a00000
91ffffff1a15013606050000
91ffffff1a15013606050000
ffffff914ca820d8c0a00000
91ffffff1a15013606050000
ffffff914ca820d8c0a00000
-
{e=>6,a=>-48,d=>0,j=>4,l=>6,c=>7,k=>6,h=>2,b=>0,g=>6,f=>2,i=>3}
d0ffffff3830321a34060000
d0ffffff3830321a34060000
d0ffffff3830321a34060000
ffffffd01c18584c98c00000
d0ffffff3830321a34060000
d0ffffff3830321a34060000
ffffffd01c18584c98c00000
d0ffffff3830321a34060000
ffffffd01c18584c98c00000
-
{e=>4,a=>25,d=>5,j=>1,l=>4,c=>1,k=>1,h=>4,b=>3,g=>6,f=>7,i=>7}
190000000b25373c09040000
190000000b25373c09040000
190000000b25373c09040000
0000001964b0f89c24800000
190000000b25373c09040000
190000000b25373c09040000
0000001964b0f89c24800000
190000000b25373c09040000
0000001964b0f89c24800000
-
{e=>5,a=>-90,d=>1,j=>4,l=>1,c=>4,k=>6,h=>6,b=>6,g=>4,f=>7,i=>6}
a6ffffff2629273634010000
a6ffffff2629273634010000
a6ffffff2629273634010000
ffffffa6d034f0d898200000
a6ffffff2629273634010000
a6ffffff2629273634010000
ffffffa6d034f0d898200000
a6ffffff2629273634010000
ffffffa6d034f0d898200000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
};
-
{e=>0,a=>27,m=>0,d=>1,j=>1,l=>0,c=>1,k=>4,h=>7,b=>3,g=>3,f=>1,i=>7}
1b0000000b01193f21000000
1b0000000b01193f21000000
1b0000000b01193f21000000
0000001b64202cfc30000000
1b0000000b01193f21000000
1b0000000b01193f21000000
0000001b64202cfc30000000
1b0000000b01193f21000000
0000001b64202cfc30000000
-
{e=>4,a=>-76,m=>6,d=>7,j=>1,l=>5,c=>4,k=>7,h=>1,b=>3,g=>1,f=>4,i=>1}
b4ffffff23270c0939350000
b4ffffff23270c0939350000
b4ffffff23270c0939350000
ffffffb470f084243cb80000
b4ffffff23270c0939350000
b4ffffff23270c0939350000
ffffffb470f084243cb80000
b4ffffff23270c0939350000
ffffffb470f084243cb80000
-
{e=>2,a=>-46,m=>4,d=>7,j=>1,l=>1,c=>3,k=>7,h=>2,b=>4,g=>5,f=>0,i=>2}
d2ffffff1c17281239210000
d2ffffff1c17281239210000
d2ffffff1c17281239210000
ffffffd28ce814483c300000
d2ffffff1c17281239210000
d2ffffff1c17281239210000
ffffffd28ce814483c300000
d2ffffff1c17281239210000
ffffffd28ce814483c300000
-
{e=>2,a=>81,m=>0,d=>2,j=>0,l=>7,c=>1,k=>0,h=>1,b=>4,g=>7,f=>2,i=>6}
510000000c123a3100070000
510000000c123a3100070000
510000000c123a3100070000
0000005184485c3800e00000
510000000c123a3100070000
510000000c123a3100070000
0000005184485c3800e00000
510000000c123a3100070000
0000005184485c3800e00000
-
{e=>4,a=>-102,m=>6,d=>6,j=>4,l=>0,c=>7,k=>3,h=>1,b=>2,g=>3,f=>4,i=>6}
9affffff3a261c311c300000
9affffff3a261c311c300000
9affffff3a261c311c300000
ffffff9a5cd08c388c180000
9affffff3a261c311c300000
9affffff3a261c311c300000
ffffff9a5cd08c388c180000
9affffff3a261c311c300000
ffffff9a5cd08c388c180000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
};
-
{e=>0,n=>2,a=>71,m=>2,d=>1,j=>7,l=>0,c=>5,k=>5,h=>3,b=>5,g=>5,f=>0,i=>7}
470000002d01283b2f100200
470000002d01283b2f100200
470000002d01283b2f100200
00000047b420147cf4084000
470000002d01283b2f100200
470000002d01283b2f100200
00000047b420147cf4084000
470000002d01283b2f100200
00000047b420147cf4084000
-
{e=>1,n=>0,a=>26,m=>3,d=>0,j=>5,l=>7,c=>2,k=>0,h=>0,b=>7,g=>1,f=>6,i=>4}
1a00000017080e20051f0000
1a00000017080e20051f0000
1a00000017080e20051f0000
0000001ae804c410a0ec0000
1a00000017080e20051f0000
1a00000017080e20051f0000
0000001ae804c410a0ec0000
1a00000017080e20051f0000
0000001ae804c410a0ec0000
-
{e=>2,n=>4,a=>60,m=>5,d=>5,j=>6,l=>6,c=>6,k=>2,h=>3,b=>0,g=>2,f=>4,i=>3}
3c0000003015141b162e0400
3c0000003015141b162e0400
3c0000003015141b162e0400
0000003c18a8886cc8d48000
3c0000003015141b162e0400
3c0000003015141b162e0400
0000003c18a8886cc8d48000
3c0000003015141b162e0400
0000003c18a8886cc8d48000
-
{e=>7,n=>3,a=>95,m=>4,d=>7,j=>4,l=>5,c=>2,k=>6,h=>4,b=>0,g=>3,f=>0,i=>3}
5f000000103f181c34250300
5f000000103f181c34250300
5f000000103f181c34250300
0000005f08fc0c8c98b06000
5f000000103f181c34250300
5f000000103f181c34250300
0000005f08fc0c8c98b06000
5f000000103f181c34250300
0000005f08fc0c8c98b06000
-
{e=>6,n=>2,a=>-72,m=>1,d=>7,j=>3,l=>3,c=>4,k=>4,h=>2,b=>2,g=>7,f=>7,i=>3}
b8ffffff22373f1a230b0200
b8ffffff22373f1a230b0200
b8ffffff22373f1a230b0200
ffffffb850f8fc4c70644000
b8ffffff22373f1a230b0200
b8ffffff22373f1a230b0200
ffffffb850f8fc4c70644000
b8ffffff22373f1a230b0200
ffffffb850f8fc4c70644000
=
struct uch_wrap {
  int a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
  short         o;
};
-
{e=>3,n=>5,a=>-18,m=>0,d=>5,j=>5,l=>2,c=>0,k=>7,h=>6,b=>1,g=>3,f=>2,o=>-124,i=>5}
eeffffff011d1a2e3d02050084ff0000
eeffffff011d1a2e3d02050084ff0000
eeffffff011d1a2e3d02050084ff0000
ffffffee20ac4cd4bc40a000ff840000
eeffffff011d1a2e3d02050084ff0000
eeffffff011d1a2e3d02050084ff0000
ffffffee20ac4cd4bc40a000ff840000
eeffffff011d1a2e3d02050084ff0000
ffffffee20ac4cd4bc40a000ff840000
-
{e=>7,n=>6,a=>-18,m=>7,d=>6,j=>5,l=>7,c=>5,k=>6,h=>4,b=>5,g=>7,f=>5,o=>-74,i=>7}
eeffffff2d3e3d3c353f0600b6ff0000
eeffffff2d3e3d3c353f0600b6ff0000
eeffffff2d3e3d3c353f0600b6ff0000
ffffffeeb4dcbc9cb8fcc000ffb60000
eeffffff2d3e3d3c353f0600b6ff0000
eeffffff2d3e3d3c353f0600b6ff0000
ffffffeeb4dcbc9cb8fcc000ffb60000
eeffffff2d3e3d3c353f0600b6ff0000
ffffffeeb4dcbc9cb8fcc000ffb60000
-
{e=>1,n=>5,a=>121,m=>1,d=>3,j=>4,l=>5,c=>3,k=>7,h=>1,b=>0,g=>5,f=>1,o=>-94,i=>1}
79000000180b29093c0d0500a2ff0000
79000000180b29093c0d0500a2ff0000
79000000180b29093c0d0500a2ff0000
000000790c6434249ca4a000ffa20000
79000000180b29093c0d0500a2ff0000
79000000180b29093c0d0500a2ff0000
000000790c6434249ca4a000ffa20000
79000000180b29093c0d0500a2ff0000
000000790c6434249ca4a000ffa20000
-
{e=>2,n=>1,a=>-41,m=>4,d=>5,j=>7,l=>2,c=>6,k=>0,h=>4,b=>3,g=>7,f=>6,o=>-66,i=>7}
d7ffffff33153e3c07220100beff0000
d7ffffff33153e3c07220100beff0000
d7ffffff33153e3c07220100beff0000
ffffffd778a8dc9ce0502000ffbe0000
d7ffffff33153e3c07220100beff0000
d7ffffff33153e3c07220100beff0000
ffffffd778a8dc9ce0502000ffbe0000
d7ffffff33153e3c07220100beff0000
ffffffd778a8dc9ce0502000ffbe0000
-
{e=>7,n=>2,a=>39,m=>7,d=>4,j=>7,l=>6,c=>7,k=>2,h=>0,b=>7,g=>1,f=>2,o=>-125,i=>1}
270000003f3c0a08173e020083ff0000
270000003f3c0a08173e020083ff0000
270000003f3c0a08173e020083ff0000
00000027fc9c4404e8dc4000ff830000
270000003f3c0a08173e020083ff0000
270000003f3c0a08173e020083ff0000
00000027fc9c4404e8dc4000ff830000
270000003f3c0a08173e020083ff0000
00000027fc9c4404e8dc4000ff830000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
};
-
{a=>-40,b=>5}
d8ffffff05000000
d8ffffffffffffff0500000000000000
d8ffffffffffffff0500000000000000
ffffffd8a0000000
d8ffffff05000000
d8ffffff05000000
ffffffffffffffd8a000000000000000
d8ffffff05000000
ffffffd8a0000000
-
{a=>-42,b=>6}
d6ffffff06000000
d6ffffffffffffff0600000000000000
d6ffffffffffffff0600000000000000
ffffffd6c0000000
d6ffffff06000000
d6ffffff06000000
ffffffffffffffd6c000000000000000
d6ffffff06000000
ffffffd6c0000000
-
{a=>-83,b=>0}
adffffff00000000
adffffffffffffff0000000000000000
adffffffffffffff0000000000000000
ffffffad00000000
adffffff00000000
adffffff00000000
ffffffffffffffad0000000000000000
adffffff00000000
ffffffad00000000
-
{a=>6,b=>4}
0600000004000000
06000000000000000400000000000000
06000000000000000400000000000000
0000000680000000
0600000004000000
0600000004000000
00000000000000068000000000000000
0600000004000000
0000000680000000
-
{a=>-27,b=>4}
e5ffffff04000000
e5ffffffffffffff0400000000000000
e5ffffffffffffff0400000000000000
ffffffe580000000
e5ffffff04000000
e5ffffff04000000
ffffffffffffffe58000000000000000
e5ffffff04000000
ffffffe580000000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
};
-
{c=>4,a=>56,b=>5}
3800000025000000
38000000000000002500000000000000
38000000000000002500000000000000
00000038b0000000
3800000025000000
3800000025000000
0000000000000038b000000000000000
3800000025000000
00000038b0000000
-
{c=>4,a=>-12,b=>5}
f4ffffff25000000
f4ffffffffffffff2500000000000000
f4ffffffffffffff2500000000000000
fffffff4b0000000
f4ffffff25000000
f4ffffff25000000
fffffffffffffff4b000000000000000
f4ffffff25000000
fffffff4b0000000
-
{c=>0,a=>-103,b=>3}
99ffffff03000000
99ffffffffffffff0300000000000000
99ffffffffffffff0300000000000000
ffffff9960000000
99ffffff03000000
99ffffff03000000
ffffffffffffff996000000000000000
99ffffff03000000
ffffff9960000000
-
{c=>3,a=>104,b=>6}
680000001e000000
68000000000000001e00000000000000
68000000000000001e00000000000000
00000068cc000000
680000001e000000
680000001e000000
0000000000000068cc00000000000000
680000001e000000
00000068cc000000
-
{c=>6,a=>-64,b=>6}
c0ffffff36000000
c0ffffffffffffff3600000000000000
c0ffffffffffffff3600000000000000
ffffffc0d8000000
c0ffffff36000000
c0ffffff36000000
ffffffffffffffc0d800000000000000
c0ffffff36000000
ffffffc0d8000000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
};
-
{c=>6,a=>-23,b=>3,d=>2}
e9ffffff33020000
e9ffffffffffffff3302000000000000
e9ffffffffffffff3302000000000000
ffffffe978400000
e9ffffff33020000
e9ffffff33020000
ffffffffffffffe97840000000000000
e9ffffff33020000
ffffffe978400000
-
{c=>7,a=>-55,b=>6,d=>0}
c9ffffff3e000000
c9ffffffffffffff3e00000000000000
c9ffffffffffffff3e00000000000000
ffffffc9dc000000
c9ffffff3e000000
c9ffffff3e000000
ffffffffffffffc9dc00000000000000
c9ffffff3e000000
ffffffc9dc000000
-
{c=>0,a=>84,b=>5,d=>3}
5400000005030000
54000000000000000503000000000000
54000000000000000503000000000000
00000054a0600000
5400000005030000
5400000005030000
0000000000000054a060000000000000
5400000005030000
00000054a0600000
-
{c=>7,a=>-40,b=>0,d=>5}
d8ffffff38050000
d8ffffffffffffff3805000000000000
d8ffffffffffffff3805000000000000
ffffffd81ca00000
d8ffffff38050000
d8ffffff38050000
ffffffffffffffd81ca0000000000000
d8ffffff38050000
ffffffd81ca00000
-
{c=>6,a=>-97,b=>1,d=>1}
9fffffff31010000
9fffffffffffffff3101000000000000
9fffffffffffffff3101000000000000
ffffff9f38200000
9fffffff31010000
9fffffff31010000
ffffffffffffff9f3820000000000000
9fffffff31010000
ffffff9f38200000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
};
-
{e=>5,c=>5,a=>-118,b=>4,d=>3}
8affffff2c2b0000
8affffffffffffff2c2b000000000000
8affffffffffffff2c2b000000000000
ffffff8a94740000
8affffff2c2b0000
8affffff2c2b0000
ffffffffffffff8a9474000000000000
8affffff2c2b0000
ffffff8a94740000
-
{e=>7,c=>6,a=>-96,b=>3,d=>4}
a0ffffff333c0000
a0ffffffffffffff333c000000000000
a0ffffffffffffff333c000000000000
ffffffa0789c0000
a0ffffff333c0000
a0ffffff333c0000
ffffffffffffffa0789c000000000000
a0ffffff333c0000
ffffffa0789c0000
-
{e=>0,c=>5,a=>93,b=>2,d=>3}
5d0000002a030000
5d000000000000002a03000000000000
5d000000000000002a03000000000000
0000005d54600000
5d0000002a030000
5d0000002a030000
000000000000005d5460000000000000
5d0000002a030000
0000005d54600000
-
{e=>4,c=>6,a=>60,b=>0,d=>0}
3c00000030200000
3c000000000000003020000000000000
3c000000000000003020000000000000
0000003c18100000
3c00000030200000
3c00000030200000
000000000000003c1810000000000000
3c00000030200000
0000003c18100000
-
{e=>7,c=>0,a=>-10,b=>2,d=>6}
f6ffffff023e0000
f6ffffffffffffff023e000000000000
f6ffffffffffffff023e000000000000
fffffff640dc0000
f6ffffff023e0000
f6ffffff023e0000
fffffffffffffff640dc000000000000
f6ffffff023e0000
fffffff640dc0000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
};
-
{e=>0,c=>2,a=>-92,b=>1,d=>1,f=>0}
a4ffffff11010000
a4ffffffffffffff1101000000000000
a4ffffffffffffff1101000000000000
ffffffa428200000
a4ffffff11010000
a4ffffff11010000
ffffffffffffffa42820000000000000
a4ffffff11010000
ffffffa428200000
-
{e=>3,c=>4,a=>-86,b=>4,d=>0,f=>7}
aaffffff24180700
aaffffffffffffff2418070000000000
aaffffffffffffff2418070000000000
ffffffaa900ce000
aaffffff24180700
aaffffff24180700
ffffffffffffffaa900ce00000000000
aaffffff24180700
ffffffaa900ce000
-
{e=>0,c=>5,a=>117,b=>0,d=>1,f=>3}
7500000028010300
75000000000000002801030000000000
75000000000000002801030000000000
0000007514206000
7500000028010300
7500000028010300
00000000000000751420600000000000
7500000028010300
0000007514206000
-
{e=>4,c=>6,a=>103,b=>2,d=>4,f=>0}
6700000032240000
67000000000000003224000000000000
67000000000000003224000000000000
0000006758900000
6700000032240000
6700000032240000
00000000000000675890000000000000
6700000032240000
0000006758900000
-
{e=>2,c=>4,a=>42,b=>3,d=>2,f=>5}
2a00000023120500
2a000000000000002312050000000000
2a000000000000002312050000000000
0000002a7048a000
2a00000023120500
2a00000023120500
000000000000002a7048a00000000000
2a00000023120500
0000002a7048a000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
};
-
{e=>2,c=>0,a=>-3,g=>2,b=>5,d=>4,f=>5}
fdffffff05141500
fdffffffffffffff0514150000000000
fdffffffffffffff0514150000000000
fffffffda088a800
fdffffff05141500
fdffffff05141500
fffffffffffffffda088a80000000000
fdffffff05141500
fffffffda088a800
-
{e=>5,c=>6,a=>-39,g=>0,b=>0,d=>0,f=>1}
d9ffffff30280100
d9ffffffffffffff3028010000000000
d9ffffffffffffff3028010000000000
ffffffd918142000
d9ffffff30280100
d9ffffff30280100
ffffffffffffffd91814200000000000
d9ffffff30280100
ffffffd918142000
-
{e=>4,c=>0,a=>79,g=>3,b=>3,d=>7,f=>1}
4f00000003271900
4f000000000000000327190000000000
4f000000000000000327190000000000
0000004f60f02c00
4f00000003271900
4f00000003271900
000000000000004f60f02c0000000000
4f00000003271900
0000004f60f02c00
-
{e=>1,c=>2,a=>-123,g=>2,b=>1,d=>0,f=>4}
85ffffff11081400
85ffffffffffffff1108140000000000
85ffffffffffffff1108140000000000
ffffff8528048800
85ffffff11081400
85ffffff11081400
ffffffffffffff852804880000000000
85ffffff11081400
ffffff8528048800
-
{e=>4,c=>7,a=>100,g=>2,b=>3,d=>3,f=>6}
640000003b231600
64000000000000003b23160000000000
64000000000000003b23160000000000
000000647c70c800
640000003b231600
640000003b231600
00000000000000647c70c80000000000
640000003b231600
000000647c70c800
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
};
-
{e=>6,a=>-8,d=>6,c=>1,h=>6,b=>3,g=>1,f=>2}
f8ffffff0b360a06
f8ffffffffffffff0b360a0600000000
f8ffffffffffffff0b360a0600000000
fffffff864d844c0
f8ffffff0b360a06
f8ffffff0b360a06
fffffffffffffff864d844c000000000
f8ffffff0b360a06
fffffff864d844c0
-
{e=>4,a=>-75,d=>7,c=>3,h=>7,b=>3,g=>5,f=>3}
b5ffffff1b272b07
b5ffffffffffffff1b272b0700000000
b5ffffffffffffff1b272b0700000000
ffffffb56cf074e0
b5ffffff1b272b07
b5ffffff1b272b07
ffffffffffffffb56cf074e000000000
b5ffffff1b272b07
ffffffb56cf074e0
-
{e=>7,a=>-105,d=>6,c=>4,h=>5,b=>3,g=>2,f=>0}
97ffffff233e1005
97ffffffffffffff233e100500000000
97ffffffffffffff233e100500000000
ffffff9770dc08a0
97ffffff233e1005
97ffffff233e1005
ffffffffffffff9770dc08a000000000
97ffffff233e1005
ffffff9770dc08a0
-
{e=>4,a=>115,d=>1,c=>7,h=>4,b=>6,g=>0,f=>0}
730000003e210004
73000000000000003e21000400000000
73000000000000003e21000400000000
00000073dc300080
730000003e210004
730000003e210004
0000000000000073dc30008000000000
730000003e210004
00000073dc300080
-
{e=>4,a=>-9,d=>7,c=>1,h=>7,b=>7,g=>5,f=>3}
f7ffffff0f272b07
f7ffffffffffffff0f272b0700000000
f7ffffffffffffff0f272b0700000000
fffffff7e4f074e0
f7ffffff0f272b07
f7ffffff0f272b07
fffffffffffffff7e4f074e000000000
f7ffffff0f272b07
fffffff7e4f074e0
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
};
-
{e=>4,a=>-19,d=>4,c=>4,h=>6,b=>5,g=>6,f=>5,i=>7}
edffffff2524353e
edffffffffffffff2524353e00000000
edffffffffffffff2524353e00000000
ffffffedb090b8dc
edffffff2524353e
edffffff2524353e
ffffffffffffffedb090b8dc00000000
edffffff2524353e
ffffffedb090b8dc
-
{e=>6,a=>-94,d=>4,c=>3,h=>2,b=>4,g=>7,f=>3,i=>1}
a2ffffff1c343b0a
a2ffffffffffffff1c343b0a00000000
a2ffffffffffffff1c343b0a00000000
ffffffa28c987c44
a2ffffff1c343b0a
a2ffffff1c343b0a
ffffffffffffffa28c987c4400000000
a2ffffff1c343b0a
ffffffa28c987c44
-
{e=>5,a=>117,d=>2,c=>3,h=>2,b=>6,g=>0,f=>7,i=>3}
750000001e2a071a
75000000000000001e2a071a00000000
75000000000000001e2a071a00000000
00000075cc54e04c
750000001e2a071a
750000001e2a071a
0000000000000075cc54e04c00000000
750000001e2a071a
00000075cc54e04c
-
{e=>7,a=>-27,d=>5,c=>4,h=>4,b=>1,g=>0,f=>5,i=>6}
e5ffffff213d0534
e5ffffffffffffff213d053400000000
e5ffffffffffffff213d053400000000
ffffffe530bca098
e5ffffff213d0534
e5ffffff213d0534
ffffffffffffffe530bca09800000000
e5ffffff213d0534
ffffffe530bca098
-
{e=>4,a=>-18,d=>4,c=>3,h=>2,b=>0,g=>4,f=>1,i=>0}
eeffffff18242102
eeffffffffffffff1824210200000000
eeffffffffffffff1824210200000000
ffffffee0c903040
eeffffff18242102
eeffffff18242102
ffffffffffffffee0c90304000000000
eeffffff18242102
ffffffee0c903040
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
};
-
{e=>6,a=>-43,d=>7,j=>2,c=>3,h=>5,b=>4,g=>2,f=>2,i=>3}
d5ffffff1c37121d02000000
d5ffffffffffffff1c37121d02000000
d5ffffffffffffff1c37121d02000000
ffffffd58cf848ac40000000
d5ffffff1c37121d02000000
d5ffffff1c37121d02000000
ffffffffffffffd58cf848ac40000000
d5ffffff1c37121d02000000
ffffffd58cf848ac40000000
-
{e=>1,a=>41,d=>0,j=>6,c=>4,h=>7,b=>5,g=>5,f=>6,i=>0}
2900000025082e0706000000
290000000000000025082e0706000000
290000000000000025082e0706000000
00000029b004d4e0c0000000
2900000025082e0706000000
2900000025082e0706000000
0000000000000029b004d4e0c0000000
2900000025082e0706000000
00000029b004d4e0c0000000
-
{e=>0,a=>-53,d=>2,j=>3,c=>6,h=>4,b=>2,g=>2,f=>1,i=>3}
cbffffff3202111c03000000
cbffffffffffffff3202111c03000000
cbffffffffffffff3202111c03000000
ffffffcb5840288c60000000
cbffffff3202111c03000000
cbffffff3202111c03000000
ffffffffffffffcb5840288c60000000
cbffffff3202111c03000000
ffffffcb5840288c60000000
-
{e=>7,a=>6,d=>6,j=>3,c=>7,h=>3,b=>3,g=>4,f=>6,i=>0}
060000003b3e260303000000
06000000000000003b3e260303000000
06000000000000003b3e260303000000
000000067cdcd06060000000
060000003b3e260303000000
060000003b3e260303000000
00000000000000067cdcd06060000000
060000003b3e260303000000
000000067cdcd06060000000
-
{e=>7,a=>8,d=>4,j=>4,c=>4,h=>1,b=>2,g=>7,f=>1,i=>5}
08000000223c392904000000
0800000000000000223c392904000000
0800000000000000223c392904000000
00000008509c3c3480000000
08000000223c392904000000
08000000223c392904000000
0000000000000008509c3c3480000000
08000000223c392904000000
00000008509c3c3480000000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
};
-
{e=>2,a=>-120,d=>3,j=>3,c=>1,k=>7,h=>5,b=>6,g=>1,f=>2,i=>6}
88ffffff0e130a353b000000
88ffffffffffffff0e130a353b000000
88ffffffffffffff0e130a353b000000
ffffff88c46844b87c000000
88ffffff0e130a353b000000
88ffffff0e130a353b000000
ffffffffffffff88c46844b87c000000
88ffffff0e130a353b000000
ffffff88c46844b87c000000
-
{e=>0,a=>116,d=>7,j=>1,c=>4,k=>0,h=>3,b=>1,g=>4,f=>3,i=>1}
740000002107230b01000000
74000000000000002107230b01000000
74000000000000002107230b01000000
0000007430e0706420000000
740000002107230b01000000
740000002107230b01000000
000000000000007430e0706420000000
740000002107230b01000000
0000007430e0706420000000
-
{e=>4,a=>108,d=>2,j=>7,c=>4,k=>6,h=>2,b=>1,g=>0,f=>5,i=>0}
6c0000002122050237000000
6c000000000000002122050237000000
6c000000000000002122050237000000
0000006c3050a040f8000000
6c0000002122050237000000
6c0000002122050237000000
000000000000006c3050a040f8000000
6c0000002122050237000000
0000006c3050a040f8000000
-
{e=>3,a=>-126,d=>7,j=>0,c=>5,k=>6,h=>1,b=>0,g=>1,f=>7,i=>3}
82ffffff281f0f1930000000
82ffffffffffffff281f0f1930000000
82ffffffffffffff281f0f1930000000
ffffff8214ece42c18000000
82ffffff281f0f1930000000
82ffffff281f0f1930000000
ffffffffffffff8214ece42c18000000
82ffffff281f0f1930000000
ffffff8214ece42c18000000
-
{e=>2,a=>-78,d=>3,j=>3,c=>7,k=>4,h=>1,b=>7,g=>2,f=>1,i=>2}
b2ffffff3f13111123000000
b2ffffffffffffff3f13111123000000
b2ffffffffffffff3f13111123000000
ffffffb2fc68282870000000
b2ffffff3f13111123000000
b2ffffff3f13111123000000
ffffffffffffffb2fc68282870000000
b2ffffff3f13111123000000
ffffffb2fc68282870000000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
};
-
{e=>7,a=>14,d=>4,j=>1,l=>0,c=>6,k=>4,h=>3,b=>1,g=>2,f=>7,i=>1}
0e000000313c170b21000000
0e00000000000000313c170b21000000
0e00000000000000313c170b21000000
0000000e389ce86430000000
0e000000313c170b21000000
0e000000313c170b21000000
000000000000000e389ce86430000000
0e000000313c170b21000000
0000000e389ce86430000000
-
{e=>0,a=>121,d=>5,j=>2,l=>2,c=>3,k=>1,h=>2,b=>0,g=>4,f=>2,i=>0}
79000000180522020a020000
7900000000000000180522020a020000
7900000000000000180522020a020000
000000790ca0504044400000
79000000180522020a020000
79000000180522020a020000
00000000000000790ca0504044400000
79000000180522020a020000
000000790ca0504044400000
-
{e=>5,a=>-2,d=>5,j=>7,l=>4,c=>3,k=>0,h=>2,b=>2,g=>6,f=>3,i=>0}
feffffff1a2d330207040000
feffffffffffffff1a2d330207040000
feffffffffffffff1a2d330207040000
fffffffe4cb47840e0800000
feffffff1a2d330207040000
feffffff1a2d330207040000
fffffffffffffffe4cb47840e0800000
feffffff1a2d330207040000
fffffffe4cb47840e0800000
-
{e=>4,a=>8,d=>2,j=>4,l=>3,c=>7,k=>2,h=>6,b=>4,g=>0,f=>5,i=>2}
080000003c22051614030000
08000000000000003c22051614030000
08000000000000003c22051614030000
000000089c50a0c888600000
080000003c22051614030000
080000003c22051614030000
00000000000000089c50a0c888600000
080000003c22051614030000
000000089c50a0c888600000
-
{e=>1,a=>-123,d=>4,j=>6,l=>2,c=>4,k=>3,h=>5,b=>7,g=>1,f=>5,i=>6}
85ffffff270c0d351e020000
85ffffffffffffff270c0d351e020000
85ffffffffffffff270c0d351e020000
ffffff85f084a4b8cc400000
85ffffff270c0d351e020000
85ffffff270c0d351e020000
ffffffffffffff85f084a4b8cc400000
85ffffff270c0d351e020000
ffffff85f084a4b8cc400000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
};
-
{e=>5,a=>-111,m=>3,d=>7,j=>6,l=>5,c=>6,k=>6,h=>6,b=>0,g=>4,f=>1,i=>2}
91ffffff302f2116361d0000
91ffffffffffffff302f2116361d0000
91ffffffffffffff302f2116361d0000
ffffff9118f430c8d8ac0000
91ffffff302f2116361d0000
91ffffff302f2116361d0000
ffffffffffffff9118f430c8d8ac0000
91ffffff302f2116361d0000
ffffff9118f430c8d8ac0000
-
{e=>4,a=>-44,m=>0,d=>4,j=>5,l=>1,c=>5,k=>0,h=>2,b=>2,g=>4,f=>7,i=>6}
d4ffffff2a24273205010000
d4ffffffffffffff2a24273205010000
d4ffffffffffffff2a24273205010000
ffffffd45490f058a0200000
d4ffffff2a24273205010000
d4ffffff2a24273205010000
ffffffffffffffd45490f058a0200000
d4ffffff2a24273205010000
ffffffd45490f058a0200000
-
{e=>7,a=>-24,m=>0,d=>0,j=>3,l=>1,c=>5,k=>5,h=>1,b=>2,g=>3,f=>5,i=>4}
e8ffffff2a381d212b010000
e8ffffffffffffff2a381d212b010000
e8ffffffffffffff2a381d212b010000
ffffffe8541cac3074200000
e8ffffff2a381d212b010000
e8ffffff2a381d212b010000
ffffffffffffffe8541cac3074200000
e8ffffff2a381d212b010000
ffffffe8541cac3074200000
-
{e=>4,a=>96,m=>2,d=>0,j=>1,l=>2,c=>2,k=>4,h=>4,b=>4,g=>3,f=>7,i=>2}
6000000014201f1421120000
600000000000000014201f1421120000
600000000000000014201f1421120000
000000608810ec8830480000
6000000014201f1421120000
6000000014201f1421120000
00000000000000608810ec8830480000
6000000014201f1421120000
000000608810ec8830480000
-
{e=>2,a=>-3,m=>4,d=>0,j=>4,l=>5,c=>7,k=>3,h=>7,b=>5,g=>0,f=>1,i=>6}
fdffffff3d1001371c250000
fdffffffffffffff3d1001371c250000
fdffffffffffffff3d1001371c250000
fffffffdbc0820f88cb00000
fdffffff3d1001371c250000
fdffffff3d1001371c250000
fffffffffffffffdbc0820f88cb00000
fdffffff3d1001371c250000
fffffffdbc0820f88cb00000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
};
-
{e=>5,n=>3,a=>-107,m=>1,d=>3,j=>7,l=>5,c=>0,k=>2,h=>0,b=>6,g=>2,f=>2,i=>7}
95ffffff062b1238170d0300
95ffffffffffffff062b1238170d0300
95ffffffffffffff062b1238170d0300
ffffff95c074481ce8a46000
95ffffff062b1238170d0300
95ffffff062b1238170d0300
ffffffffffffff95c074481ce8a46000
95ffffff062b1238170d0300
ffffff95c074481ce8a46000
-
{e=>7,n=>1,a=>9,m=>6,d=>1,j=>2,l=>4,c=>7,k=>6,h=>7,b=>5,g=>4,f=>4,i=>6}
090000003d39243732340100
09000000000000003d39243732340100
09000000000000003d39243732340100
00000009bc3c90f858982000
090000003d39243732340100
090000003d39243732340100
0000000000000009bc3c90f858982000
090000003d39243732340100
00000009bc3c90f858982000
-
{e=>2,n=>1,a=>-50,m=>7,d=>3,j=>1,l=>6,c=>0,k=>2,h=>7,b=>2,g=>1,f=>5,i=>6}
ceffffff02130d37113e0100
ceffffffffffffff02130d37113e0100
ceffffffffffffff02130d37113e0100
ffffffce4068a4f828dc2000
ceffffff02130d37113e0100
ceffffff02130d37113e0100
ffffffffffffffce4068a4f828dc2000
ceffffff02130d37113e0100
ffffffce4068a4f828dc2000
-
{e=>7,n=>4,a=>123,m=>1,d=>1,j=>2,l=>4,c=>4,k=>7,h=>0,b=>4,g=>6,f=>0,i=>6}
7b000000243930303a0c0400
7b00000000000000243930303a0c0400
7b00000000000000243930303a0c0400
0000007b903c18185c848000
7b000000243930303a0c0400
7b000000243930303a0c0400
000000000000007b903c18185c848000
7b000000243930303a0c0400
0000007b903c18185c848000
-
{e=>2,n=>4,a=>-2,m=>5,d=>3,j=>4,l=>4,c=>3,k=>2,h=>7,b=>4,g=>7,f=>3,i=>4}
feffffff1c133b27142c0400
feffffffffffffff1c133b27142c0400
feffffffffffffff1c133b27142c0400
fffffffe8c687cf088948000
feffffff1c133b27142c0400
feffffff1c133b27142c0400
fffffffffffffffe8c687cf088948000
feffffff1c133b27142c0400
fffffffe8c687cf088948000
=
struct uch_wrap {
  long a;
  unsigned char b:3;
  unsigned char c:3;
  unsigned char d:3;
  unsigned char e:3;
  unsigned char f:3;
  unsigned char g:3;
  unsigned char h:3;
  unsigned char i:3;
  unsigned char j:3;
  unsigned char k:3;
  unsigned char l:3;
  unsigned char m:3;
  unsigned char n:3;
  short         o;
};
-
{e=>2,n=>2,a=>66,m=>1,d=>2,j=>2,l=>3,c=>0,k=>3,h=>7,b=>2,g=>5,f=>1,o=>-57,i=>2}
42000000021229171a0b0200c7ff0000
4200000000000000021229171a0b0200c7ff000000000000
4200000000000000021229171a0b0200c7ff000000000000
00000042404834e84c644000ffc70000
42000000021229171a0b0200c7ff0000
42000000021229171a0b0200c7ff0000
0000000000000042404834e84c644000ffc7000000000000
42000000021229171a0b0200c7ff0000
00000042404834e84c644000ffc70000
-
{e=>5,n=>3,a=>-74,m=>0,d=>7,j=>6,l=>1,c=>4,k=>7,h=>6,b=>7,g=>3,f=>5,o=>39,i=>2}
b6ffffff272f1d163e01030027000000
b6ffffffffffffff272f1d163e0103002700000000000000
b6ffffffffffffff272f1d163e0103002700000000000000
ffffffb6f0f4acc8dc20600000270000
b6ffffff272f1d163e01030027000000
b6ffffff272f1d163e01030027000000
ffffffffffffffb6f0f4acc8dc2060000027000000000000
b6ffffff272f1d163e01030027000000
ffffffb6f0f4acc8dc20600000270000
-
{e=>0,n=>4,a=>-119,m=>6,d=>5,j=>3,l=>4,c=>5,k=>2,h=>2,b=>3,g=>4,f=>1,o=>-9,i=>4}
89ffffff2b05212213340400f7ff0000
89ffffffffffffff2b05212213340400f7ff000000000000
89ffffffffffffff2b05212213340400f7ff000000000000
ffffff8974a0305068988000fff70000
89ffffff2b05212213340400f7ff0000
89ffffff2b05212213340400f7ff0000
ffffffffffffff8974a0305068988000fff7000000000000
89ffffff2b05212213340400f7ff0000
ffffff8974a0305068988000fff70000
-
{e=>3,n=>6,a=>-85,m=>7,d=>1,j=>6,l=>3,c=>7,k=>4,h=>4,b=>2,g=>5,f=>0,o=>120,i=>0}
abffffff3a192804263b060078000000
abffffffffffffff3a192804263b06007800000000000000
abffffffffffffff3a192804263b06007800000000000000
ffffffab5c2c1480d07cc00000780000
abffffff3a192804263b060078000000
abffffff3a192804263b060078000000
ffffffffffffffab5c2c1480d07cc0000078000000000000
abffffff3a192804263b060078000000
ffffffab5c2c1480d07cc00000780000
-
{e=>1,n=>6,a=>5,m=>5,d=>5,j=>2,l=>1,c=>4,k=>2,h=>0,b=>7,g=>0,f=>2,o=>-21,i=>6}
05000000270d023012290600ebff0000
0500000000000000270d023012290600ebff000000000000
0500000000000000270d023012290600ebff000000000000
00000005f0a440184834c000ffeb0000
05000000270d023012290600ebff0000
05000000270d023012290600ebff0000
0000000000000005f0a440184834c000ffeb000000000000
05000000270d023012290600ebff0000
00000005f0a440184834c000ffeb0000
=
struct int_wrap {
  int a:3;
};
-
{a=>3}
03000000
03000000
03000000
60000000
03000000
03000000
60000000
03000000
60000000
-
{a=>-2}
06000000
06000000
06000000
c0000000
06000000
06000000
c0000000
06000000
c0000000
-
{a=>-2}
06000000
06000000
06000000
c0000000
06000000
06000000
c0000000
06000000
c0000000
-
{a=>2}
02000000
02000000
02000000
40000000
02000000
02000000
40000000
02000000
40000000
-
{a=>1}
01000000
01000000
01000000
20000000
01000000
01000000
20000000
01000000
20000000
=
struct int_wrap {
  int a:3;
  int b:3;
};
-
{a=>-4,b=>-1}
3c000000
3c000000
3c000000
9c000000
3c000000
3c000000
9c000000
3c000000
9c000000
-
{a=>-1,b=>-1}
3f000000
3f000000
3f000000
fc000000
3f000000
3f000000
fc000000
3f000000
fc000000
-
{a=>2,b=>3}
1a000000
1a000000
1a000000
4c000000
1a000000
1a000000
4c000000
1a000000
4c000000
-
{a=>-2,b=>-4}
26000000
26000000
26000000
d0000000
26000000
26000000
d0000000
26000000
d0000000
-
{a=>-2,b=>1}
0e000000
0e000000
0e000000
c4000000
0e000000
0e000000
c4000000
0e000000
c4000000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
};
-
{c=>-2,a=>-3,b=>2}
95010000
95010000
95010000
ab000000
95010000
95010000
ab000000
95010000
ab000000
-
{c=>-3,a=>-4,b=>3}
5c010000
5c010000
5c010000
8e800000
5c010000
5c010000
8e800000
5c010000
8e800000
-
{c=>2,a=>1,b=>3}
99000000
99000000
99000000
2d000000
99000000
99000000
2d000000
99000000
2d000000
-
{c=>-4,a=>-4,b=>-1}
3c010000
3c010000
3c010000
9e000000
3c010000
3c010000
9e000000
3c010000
9e000000
-
{c=>-1,a=>-3,b=>-4}
e5010000
e5010000
e5010000
b3800000
e5010000
e5010000
b3800000
e5010000
b3800000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
};
-
{c=>-1,a=>0,b=>-1,d=>0}
f8010000
f8010000
f8010000
1f800000
f8010000
f8010000
1f800000
f8010000
1f800000
-
{c=>-2,a=>-2,b=>1,d=>2}
8e050000
8e050000
8e050000
c7200000
8e050000
8e050000
c7200000
8e050000
c7200000
-
{c=>-2,a=>0,b=>-4,d=>2}
a0050000
a0050000
a0050000
13200000
a0050000
a0050000
13200000
a0050000
13200000
-
{c=>-3,a=>1,b=>-4,d=>3}
61070000
61070000
61070000
32b00000
61070000
61070000
32b00000
61070000
32b00000
-
{c=>1,a=>-2,b=>2,d=>0}
56000000
56000000
56000000
c8800000
56000000
56000000
c8800000
56000000
c8800000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
};
-
{e=>-3,c=>-3,a=>1,b=>-4,d=>-4}
61590000
61590000
61590000
32ca0000
61590000
61590000
32ca0000
61590000
32ca0000
-
{e=>-3,c=>2,a=>0,b=>1,d=>0}
88500000
88500000
88500000
050a0000
88500000
88500000
050a0000
88500000
050a0000
-
{e=>-3,c=>3,a=>2,b=>-1,d=>0}
fa500000
fa500000
fa500000
5d8a0000
fa500000
fa500000
5d8a0000
fa500000
5d8a0000
-
{e=>1,c=>-2,a=>-2,b=>-2,d=>3}
b6170000
b6170000
b6170000
db320000
b6170000
b6170000
db320000
b6170000
db320000
-
{e=>3,c=>1,a=>-1,b=>2,d=>-2}
573c0000
573c0000
573c0000
e8e60000
573c0000
573c0000
e8e60000
573c0000
e8e60000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
};
-
{e=>-1,c=>-2,a=>-2,b=>2,d=>1,f=>3}
96f30100
96f30100
96f30100
cb1ec000
96f30100
96f30100
cb1ec000
96f30100
cb1ec000
-
{e=>-3,c=>-4,a=>3,b=>2,d=>1,f=>-3}
13d30200
13d30200
13d30200
6a1b4000
13d30200
13d30200
6a1b4000
13d30200
6a1b4000
-
{e=>-4,c=>0,a=>-1,b=>-4,d=>-1,f=>-2}
274e0300
274e0300
274e0300
f0798000
274e0300
274e0300
f0798000
274e0300
f0798000
-
{e=>-1,c=>-4,a=>-1,b=>1,d=>0,f=>-3}
0ff10200
0ff10200
0ff10200
e60f4000
0ff10200
0ff10200
e60f4000
0ff10200
e60f4000
-
{e=>-4,c=>-2,a=>1,b=>3,d=>2,f=>-3}
99c50200
99c50200
99c50200
2f294000
99c50200
99c50200
2f294000
99c50200
2f294000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
};
-
{e=>-4,c=>1,a=>-4,g=>0,b=>-2,d=>0,f=>-3}
74c00200
74c00200
74c00200
98894000
74c00200
74c00200
98894000
74c00200
98894000
-
{e=>-2,c=>0,a=>-4,g=>3,b=>-4,d=>0,f=>-3}
24e00e00
24e00e00
24e00e00
900d5800
24e00e00
24e00e00
900d5800
24e00e00
900d5800
-
{e=>0,c=>1,a=>3,g=>2,b=>-3,d=>0,f=>0}
6b000800
6b000800
6b000800
74801000
6b000800
6b000800
74801000
6b000800
74801000
-
{e=>-4,c=>-2,a=>-1,g=>3,b=>1,d=>1,f=>0}
8f430c00
8f430c00
8f430c00
e7181800
8f430c00
8f430c00
e7181800
8f430c00
e7181800
-
{e=>2,c=>-2,a=>-3,g=>0,b=>-3,d=>1,f=>-2}
ad230300
ad230300
ad230300
b7158000
ad230300
ad230300
b7158000
ad230300
b7158000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
};
-
{e=>-2,a=>3,d=>-1,c=>-4,h=>-2,b=>-1,g=>0,f=>-4}
3b6fc200
3b6fc200
3b6fc200
7e7d0600
3b6fc200
3b6fc200
7e7d0600
3b6fc200
7e7d0600
-
{e=>3,a=>-4,d=>1,c=>1,h=>0,b=>2,g=>-3,f=>2}
54321500
54321500
54321500
8896a800
54321500
54321500
8896a800
54321500
8896a800
-
{e=>2,a=>-2,d=>2,c=>3,h=>-3,b=>3,g=>3,f=>-4}
de24ae00
de24ae00
de24ae00
cda51d00
de24ae00
de24ae00
cda51d00
de24ae00
cda51d00
-
{e=>2,a=>-1,d=>-1,c=>1,h=>-3,b=>-4,g=>2,f=>-4}
672eaa00
672eaa00
672eaa00
f0f51500
672eaa00
672eaa00
f0f51500
672eaa00
f0f51500
-
{e=>0,a=>0,d=>0,c=>-4,h=>2,b=>3,g=>3,f=>0}
18014c00
18014c00
18014c00
0e001a00
18014c00
18014c00
0e001a00
18014c00
0e001a00
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
};
-
{e=>-4,a=>2,d=>-2,c=>-2,h=>3,b=>-3,g=>-2,f=>-3,i=>0}
aacd7a00
aacd7a00
aacd7a00
57697300
aacd7a00
aacd7a00
57697300
aacd7a00
57697300
-
{e=>-4,a=>-1,d=>2,c=>3,h=>1,b=>-1,g=>0,f=>-1,i=>0}
ffc42300
ffc42300
ffc42300
fda9c100
ffc42300
ffc42300
fda9c100
ffc42300
fda9c100
-
{e=>2,a=>0,d=>-1,c=>2,h=>2,b=>1,g=>3,f=>-1,i=>0}
88ae4f00
88ae4f00
88ae4f00
0575da00
88ae4f00
88ae4f00
0575da00
88ae4f00
0575da00
-
{e=>-3,a=>-4,d=>2,c=>-1,h=>-3,b=>2,g=>1,f=>-3,i=>-3}
d4d5a605
d4d5a605
d4d5a605
8bab4da0
d4d5a605
d4d5a605
8bab4da0
d4d5a605
8bab4da0
-
{e=>1,a=>-1,d=>-1,c=>-1,h=>0,b=>-1,g=>-3,f=>-3,i=>2}
ff9f1602
ff9f1602
ff9f1602
fff36840
ff9f1602
ff9f1602
fff36840
ff9f1602
fff36840
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
};
-
{e=>-3,a=>0,d=>-3,j=>-4,c=>3,h=>-1,b=>-3,g=>1,f=>1,i=>-4}
e8dae424
e8dae424
e8dae424
15da4f90
e8dae424
e8dae424
15da4f90
e8dae424
15da4f90
-
{e=>1,a=>3,d=>-3,j=>2,c=>-3,h=>3,b=>-1,g=>1,f=>-1,i=>-4}
7b9b6714
7b9b6714
7b9b6714
7ed3cb88
7b9b6714
7b9b6714
7ed3cb88
7b9b6714
7ed3cb88
-
{e=>-3,a=>-3,d=>1,j=>-4,c=>-4,h=>3,b=>-1,g=>-1,f=>-2,i=>0}
3d537f20
3d537f20
3d537f20
be1bbb10
3d537f20
3d537f20
be1bbb10
3d537f20
be1bbb10
-
{e=>2,a=>0,d=>-4,j=>1,c=>3,h=>1,b=>-2,g=>1,f=>-2,i=>2}
f028270a
f028270a
f028270a
19c58944
f028270a
f028270a
19c58944
f028270a
19c58944
-
{e=>-2,a=>1,d=>-1,j=>3,c=>-4,h=>2,b=>1,g=>0,f=>2,i=>3}
096f411b
096f411b
096f411b
267c826c
096f411b
096f411b
267c826c
096f411b
267c826c
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
};
-
{e=>-4,a=>2,d=>-4,j=>2,c=>-3,k=>-1,h=>-1,b=>2,g=>-3,f=>-3,i=>-4}
52c9f61407000000
52c9f61407000000
52c9f61407000000
4ac96f88e0000000
52c9f61407000000
52c9f61407000000
4ac96f88e0000000
52c9f61407000000
4ac96f88e0000000
-
{e=>3,a=>2,d=>-3,j=>-3,c=>-1,k=>-3,h=>-3,b=>0,g=>-4,f=>-3,i=>0}
c2bbb22805000000
c2bbb22805000000
c2bbb22805000000
43d76514a0000000
c2bbb22805000000
c2bbb22805000000
43d76514a0000000
c2bbb22805000000
43d76514a0000000
-
{e=>-2,a=>1,d=>3,j=>-4,c=>-1,k=>3,h=>3,b=>1,g=>1,f=>2,i=>-3}
c967652503000000
c967652503000000
c967652503000000
27bc8bb060000000
c967652503000000
c967652503000000
27bc8bb060000000
c967652503000000
27bc8bb060000000
-
{e=>2,a=>3,d=>-4,j=>-4,c=>0,k=>-4,h=>-4,b=>3,g=>3,f=>-3,i=>-2}
1ba88e2604000000
1ba88e2604000000
1ba88e2604000000
6c455cd080000000
1ba88e2604000000
1ba88e2604000000
6c455cd080000000
1ba88e2604000000
6c455cd080000000
-
{e=>-1,a=>0,d=>-1,j=>-3,c=>-1,k=>2,h=>2,b=>-4,g=>-4,f=>-4,i=>-1}
e07f522f02000000
e07f522f02000000
e07f522f02000000
13ff22f440000000
e07f522f02000000
e07f522f02000000
13ff22f440000000
e07f522f02000000
13ff22f440000000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
};
-
{e=>-3,a=>3,d=>-2,j=>-3,l=>0,c=>-3,k=>3,h=>-3,b=>-1,g=>1,f=>-3,i=>1}
7bdda62903000000
7bdda62903000000
7bdda62903000000
7eeb4d3460000000
7bdda62903000000
7bdda62903000000
7eeb4d3460000000
7bdda62903000000
7eeb4d3460000000
-
{e=>-2,a=>-1,d=>1,j=>3,l=>-3,c=>-2,k=>-1,h=>1,b=>3,g=>2,f=>-4,i=>2}
9f632a1a2f000000
9f632a1a2f000000
9f632a1a2f000000
ef1d114cf4000000
9f632a1a2f000000
9f632a1a2f000000
ef1d114cf4000000
9f632a1a2f000000
ef1d114cf4000000
-
{e=>-3,a=>3,d=>3,j=>3,l=>3,c=>2,k=>2,h=>-2,b=>0,g=>1,f=>-3,i=>-1}
83d6c61f1a000000
83d6c61f1a000000
83d6c61f1a000000
613b4eec4c000000
83d6c61f1a000000
83d6c61f1a000000
613b4eec4c000000
83d6c61f1a000000
613b4eec4c000000
-
{e=>1,a=>2,d=>-3,j=>-4,l=>-4,c=>-4,k=>-3,h=>0,b=>-4,g=>1,f=>2,i=>3}
221b052325000000
221b052325000000
221b052325000000
52528870b0000000
221b052325000000
221b052325000000
52528870b0000000
221b052325000000
52528870b0000000
-
{e=>0,a=>-4,d=>3,j=>-1,l=>0,c=>-1,k=>-3,h=>-2,b=>-3,g=>0,f=>-3,i=>-1}
ec87c23f05000000
ec87c23f05000000
ec87c23f05000000
97b146fca0000000
ec87c23f05000000
ec87c23f05000000
97b146fca0000000
ec87c23f05000000
97b146fca0000000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
};
-
{e=>2,a=>3,m=>-2,d=>0,j=>-1,l=>0,c=>-3,k=>-4,h=>0,b=>1,g=>1,f=>0,i=>-1}
4b21043f84010000
4b21043f84010000
4b21043f84010000
668408fc83000000
4b21043f84010000
4b21043f84010000
668408fc83000000
4b21043f84010000
668408fc83000000
-
{e=>1,a=>-1,m=>0,d=>3,j=>2,l=>-2,c=>1,k=>1,h=>-3,b=>0,g=>3,f=>0,i=>-1}
4716ac1731000000
4716ac1731000000
4716ac1731000000
e0b21de838000000
4716ac1731000000
4716ac1731000000
e0b21de838000000
4716ac1731000000
e0b21de838000000
-
{e=>3,a=>0,m=>-3,d=>2,j=>-4,l=>-3,c=>-4,k=>-1,h=>2,b=>2,g=>2,f=>-3,i=>-2}
10b54a266f010000
10b54a266f010000
10b54a266f010000
0a2752d0f6800000
10b54a266f010000
10b54a266f010000
0a2752d0f6800000
10b54a266f010000
0a2752d0f6800000
-
{e=>3,a=>1,m=>0,d=>3,j=>0,l=>3,c=>-4,k=>-1,h=>-3,b=>-3,g=>-3,f=>1,i=>1}
29b7b4011f000000
29b7b4011f000000
29b7b4011f000000
36366d20ec000000
29b7b4011f000000
29b7b4011f000000
36366d20ec000000
29b7b4011f000000
36366d20ec000000
-
{e=>-4,a=>-3,m=>1,d=>1,j=>-4,l=>0,c=>0,k=>0,h=>-1,b=>3,g=>1,f=>2,i=>3}
1d42e52340000000
1d42e52340000000
1d42e52340000000
ac188f7000800000
1d42e52340000000
1d42e52340000000
ac188f7000800000
1d42e52340000000
ac188f7000800000
=
struct int_wrap {
  int a:3;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n;
};
-
{e=>-4,n=>-50,a=>0,m=>-1,d=>-4,j=>-4,l=>3,c=>-4,k=>2,h=>2,b=>0,g=>1,f=>-1,i=>-3}
00c94725da010000ceffffff
00c94725da010000ceffffff
00c94725da010000ceffffff
0249cab04f800000ffffffce
00c94725da010000ceffffff
00c94725da010000ceffffff
0249cab04f800000ffffffce
00c94725da010000ceffffff
0249cab04f800000ffffffce
-
{e=>2,n=>59,a=>1,m=>2,d=>-1,j=>2,l=>0,c=>-3,k=>0,h=>-2,b=>-3,g=>-3,f=>0,i=>0}
692fd410800000003b000000
692fd410800000003b000000
692fd410800000003b000000
36f42e08010000000000003b
692fd410800000003b000000
692fd410800000003b000000
36f42e08010000000000003b
692fd410800000003b000000
36f42e08010000000000003b
-
{e=>3,n=>94,a=>2,m=>2,d=>-4,j=>-2,l=>-2,c=>-3,k=>-1,h=>-3,b=>-1,g=>-2,f=>2,i=>2}
7a39b932b70000005e000000
7a39b932b70000005e000000
7a39b932b70000005e000000
5ec6b558f90000000000005e
7a39b932b70000005e000000
7a39b932b70000005e000000
5ec6b558f90000000000005e
7a39b932b70000005e000000
5ec6b558f90000000000005e
-
{e=>0,n=>126,a=>3,m=>1,d=>0,j=>0,l=>2,c=>-2,k=>-1,h=>-4,b=>2,g=>-3,f=>0,i=>0}
93019400570000007e000000
93019400570000007e000000
93019400570000007e000000
6b002c00e88000000000007e
93019400570000007e000000
93019400570000007e000000
6b002c00e88000000000007e
93019400570000007e000000
6b002c00e88000000000007e
-
{e=>3,n=>50,a=>-3,m=>2,d=>2,j=>-2,l=>-3,c=>-2,k=>3,h=>-1,b=>-2,g=>2,f=>-3,i=>-1}
b5b5ea37ab00000032000000
b5b5ea37ab00000032000000
b5b5ea37ab00000032000000
bb2757f87500000000000032
b5b5ea37ab00000032000000
b5b5ea37ab00000032000000
bb2757f87500000000000032
b5b5ea37ab00000032000000
bb2757f87500000000000032
=
struct int_wrap {
  char a;
  int b:3;
};
-
{a=>-96,b=>2}
a0020000
a0020000
a0020000
a0400000
a0020000
a0020000
a0400000
a0020000
a0400000
-
{a=>-46,b=>2}
d2020000
d2020000
d2020000
d2400000
d2020000
d2020000
d2400000
d2020000
d2400000
-
{a=>-68,b=>3}
bc030000
bc030000
bc030000
bc600000
bc030000
bc030000
bc600000
bc030000
bc600000
-
{a=>0,b=>3}
00030000
00030000
00030000
00600000
00030000
00030000
00600000
00030000
00600000
-
{a=>-26,b=>-2}
e6060000
e6060000
e6060000
e6c00000
e6060000
e6060000
e6c00000
e6060000
e6c00000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
};
-
{c=>1,a=>123,b=>0}
7b080000
7b080000
7b080000
7b040000
7b080000
7b080000
7b040000
7b080000
7b040000
-
{c=>-1,a=>-98,b=>2}
9e3a0000
9e3a0000
9e3a0000
9e5c0000
9e3a0000
9e3a0000
9e5c0000
9e3a0000
9e5c0000
-
{c=>-3,a=>75,b=>-4}
4b2c0000
4b2c0000
4b2c0000
4b940000
4b2c0000
4b2c0000
4b940000
4b2c0000
4b940000
-
{c=>-4,a=>-4,b=>-4}
fc240000
fc240000
fc240000
fc900000
fc240000
fc240000
fc900000
fc240000
fc900000
-
{c=>-1,a=>17,b=>1}
11390000
11390000
11390000
113c0000
11390000
11390000
113c0000
11390000
113c0000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
};
-
{c=>-4,a=>17,b=>-2,d=>1}
11660000
11660000
11660000
11d08000
11660000
11660000
11d08000
11660000
11d08000
-
{c=>0,a=>75,b=>0,d=>3}
4bc00000
4bc00000
4bc00000
4b018000
4bc00000
4bc00000
4b018000
4bc00000
4b018000
-
{c=>3,a=>-89,b=>1,d=>1}
a7590000
a7590000
a7590000
a72c8000
a7590000
a7590000
a72c8000
a7590000
a72c8000
-
{c=>2,a=>86,b=>2,d=>3}
56d20000
56d20000
56d20000
56498000
56d20000
56d20000
56498000
56d20000
56498000
-
{c=>-4,a=>53,b=>-1,d=>0}
35270000
35270000
35270000
35f00000
35270000
35270000
35f00000
35270000
35f00000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
};
-
{e=>-4,c=>-3,a=>-104,b=>-2,d=>0}
982e0800
982e0800
982e0800
98d44000
982e0800
982e0800
98d44000
982e0800
98d44000
-
{e=>0,c=>2,a=>8,b=>2,d=>-3}
08520100
08520100
08520100
084a8000
08520100
08520100
084a8000
08520100
084a8000
-
{e=>0,c=>-2,a=>-41,b=>-2,d=>0}
d7360000
d7360000
d7360000
d7d80000
d7360000
d7360000
d7d80000
d7360000
d7d80000
-
{e=>-4,c=>-4,a=>56,b=>2,d=>-4}
38220900
38220900
38220900
38524000
38220900
38220900
38524000
38220900
38524000
-
{e=>-3,c=>3,a=>-43,b=>-2,d=>-3}
d55e0b00
d55e0b00
d55e0b00
d5ced000
d55e0b00
d55e0b00
d5ced000
d55e0b00
d5ced000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
};
-
{e=>-4,c=>1,a=>119,b=>1,d=>1,f=>1}
77491800
77491800
77491800
7724c200
77491800
77491800
7724c200
77491800
7724c200
-
{e=>-1,c=>-3,a=>-91,b=>-2,d=>2,f=>-4}
a5ae4e00
a5ae4e00
a5ae4e00
a5d57800
a5ae4e00
a5ae4e00
a5d57800
a5ae4e00
a5d57800
-
{e=>0,c=>-4,a=>-43,b=>2,d=>0,f=>-1}
d5227000
d5227000
d5227000
d5500e00
d5227000
d5227000
d5500e00
d5227000
d5500e00
-
{e=>1,c=>-3,a=>121,b=>2,d=>1,f=>-3}
796a5200
796a5200
796a5200
79549a00
796a5200
796a5200
79549a00
796a5200
79549a00
-
{e=>1,c=>3,a=>12,b=>0,d=>1,f=>-2}
0c586200
0c586200
0c586200
0c0c9c00
0c586200
0c586200
0c0c9c00
0c586200
0c0c9c00
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
};
-
{e=>1,c=>3,a=>92,g=>2,b=>0,d=>-4,f=>-1}
5c187301
5c187301
5c187301
5c0e1e80
5c187301
5c187301
5c0e1e80
5c187301
5c0e1e80
-
{e=>-3,c=>3,a=>70,g=>-1,b=>1,d=>2,f=>1}
46999a03
46999a03
46999a03
462d53c0
46999a03
46999a03
462d53c0
46999a03
462d53c0
-
{e=>0,c=>2,a=>61,g=>-4,b=>-3,d=>-3,f=>0}
3d550102
3d550102
3d550102
3daa8100
3d550102
3d550102
3daa8100
3d550102
3daa8100
-
{e=>1,c=>1,a=>-72,g=>-3,b=>2,d=>0,f=>0}
b80a8202
b80a8202
b80a8202
b8441140
b80a8202
b80a8202
b8441140
b80a8202
b8441140
-
{e=>3,c=>2,a=>36,g=>-3,b=>-1,d=>1,f=>-1}
2457f602
2457f602
2457f602
24e8bf40
2457f602
2457f602
24e8bf40
2457f602
24e8bf40
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
};
-
{e=>1,a=>2,d=>2,c=>-4,h=>1,b=>1,g=>3,f=>3}
02a1b205
02a1b205
02a1b205
023116c8
02a1b205
02a1b205
023116c8
02a1b205
023116c8
-
{e=>-4,a=>-16,d=>-2,c=>2,h=>-3,b=>0,g=>-4,f=>-3}
f0905916
f0905916
f0905916
f00b4b28
f0905916
f0905916
f00b4b28
f0905916
f00b4b28
-
{e=>-3,a=>86,d=>2,c=>3,h=>-3,b=>0,g=>1,f=>-3}
5698da14
5698da14
5698da14
560d5a68
5698da14
5698da14
560d5a68
5698da14
560d5a68
-
{e=>-2,a=>-5,d=>-2,c=>1,h=>2,b=>-1,g=>-4,f=>2}
fb8f2d0a
fb8f2d0a
fb8f2d0a
fbe76510
fb8f2d0a
fb8f2d0a
fbe76510
fb8f2d0a
fbe76510
-
{e=>3,a=>-13,d=>-3,c=>-2,h=>1,b=>-3,g=>2,f=>-2}
f3756705
f3756705
f3756705
f3babc88
f3756705
f3756705
f3babc88
f3756705
f3babc88
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
};
-
{e=>0,a=>87,d=>-1,c=>-2,h=>-2,b=>-2,g=>1,f=>-3,i=>-3}
57f6d1b8
57f6d1b8
57f6d1b8
57db8a75
57f6d1b8
57f6d1b8
57db8a75
57f6d1b8
57db8a75
-
{e=>0,a=>28,d=>-3,c=>-3,h=>1,b=>0,g=>-1,f=>2,i=>1}
1c68a127
1c68a127
1c68a127
1c1685c9
1c68a127
1c68a127
1c1685c9
1c68a127
1c1685c9
-
{e=>3,a=>63,d=>3,c=>2,h=>-3,b=>-4,g=>-2,f=>-2,i=>2}
3fd46657
3fd46657
3fd46657
3f89bdaa
3fd46657
3fd46657
3f89bdaa
3fd46657
3f89bdaa
-
{e=>-4,a=>70,d=>3,c=>-4,h=>2,b=>-1,g=>-2,f=>3,i=>-3}
46e738ab
46e738ab
46e738ab
46f1c795
46e738ab
46e738ab
46f1c795
46e738ab
46f1c795
-
{e=>-1,a=>16,d=>-4,c=>0,h=>-1,b=>-2,g=>-2,f=>2,i=>0}
10062f1f
10062f1f
10062f1f
10c275b8
10062f1f
10062f1f
10c275b8
10062f1f
10c275b8
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
};
-
{e=>3,a=>-82,d=>-3,j=>-4,c=>-2,h=>0,b=>-3,g=>2,f=>3,i=>0}
ae75370104000000
ae75370104000000
ae75370104000000
aebab68080000000
ae75370104000000
ae75370104000000
aebab68080000000
ae75370104000000
aebab68080000000
-
{e=>-2,a=>-73,d=>0,j=>-3,c=>-2,h=>2,b=>-4,g=>0,f=>0,i=>0}
b7340c0805000000
b7340c0805000000
b7340c0805000000
b7986010a0000000
b7340c0805000000
b7340c0805000000
b7986010a0000000
b7340c0805000000
b7986010a0000000
-
{e=>2,a=>-108,d=>3,j=>2,c=>2,h=>3,b=>1,g=>-1,f=>-2,i=>3}
94d1e46f02000000
94d1e46f02000000
94d1e46f02000000
9429addb40000000
94d1e46f02000000
94d1e46f02000000
9429addb40000000
94d1e46f02000000
9429addb40000000
-
{e=>-1,a=>-101,d=>1,j=>2,c=>-4,h=>0,b=>2,g=>-1,f=>-3,i=>2}
9b62de4302000000
9b62de4302000000
9b62de4302000000
9b50fbc240000000
9b62de4302000000
9b62de4302000000
9b50fbc240000000
9b62de4302000000
9b50fbc240000000
-
{e=>2,a=>67,d=>-1,j=>-1,c=>-4,h=>-4,b=>1,g=>-4,f=>-1,i=>-3}
43e175b207000000
43e175b207000000
43e175b207000000
4333af25e0000000
43e175b207000000
43e175b207000000
4333af25e0000000
43e175b207000000
4333af25e0000000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
};
-
{e=>-3,a=>-38,d=>-4,j=>0,c=>1,k=>3,h=>-1,b=>3,g=>-2,f=>2,i=>0}
da0b2b1f18000000
da0b2b1f18000000
da0b2b1f18000000
da6655b80c000000
da0b2b1f18000000
da0b2b1f18000000
da6655b80c000000
da0b2b1f18000000
da6655b80c000000
-
{e=>2,a=>-104,d=>-4,j=>-2,c=>2,k=>1,h=>0,b=>3,g=>1,f=>1,i=>-2}
981395c00e000000
981395c00e000000
981395c00e000000
986a2246c4000000
981395c00e000000
981395c00e000000
986a2246c4000000
981395c00e000000
986a2246c4000000
-
{e=>-1,a=>-37,d=>-1,j=>-3,c=>-4,k=>-4,h=>-1,b=>1,g=>-3,f=>-4,i=>0}
dbe1cf1e25000000
dbe1cf1e25000000
dbe1cf1e25000000
db33f978b0000000
dbe1cf1e25000000
dbe1cf1e25000000
db33f978b0000000
dbe1cf1e25000000
db33f978b0000000
-
{e=>1,a=>93,d=>3,j=>0,c=>0,k=>0,h=>-2,b=>1,g=>3,f=>2,i=>1}
5dc1a23900000000
5dc1a23900000000
5dc1a23900000000
5d2194f100000000
5dc1a23900000000
5dc1a23900000000
5d2194f100000000
5dc1a23900000000
5d2194f100000000
-
{e=>3,a=>41,d=>2,j=>-2,c=>3,k=>-1,h=>-3,b=>0,g=>-1,f=>0,i=>3}
299886773e000000
299886773e000000
299886773e000000
290d31ebdc000000
299886773e000000
299886773e000000
290d31ebdc000000
299886773e000000
290d31ebdc000000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
};
-
{e=>-1,a=>104,d=>3,j=>-3,l=>1,c=>-3,k=>3,h=>-2,b=>3,g=>-4,f=>-2,i=>-1}
68eb6efa5d000000
68eb6efa5d000000
68eb6efa5d000000
6875fd37ac800000
68eb6efa5d000000
68eb6efa5d000000
6875fd37ac800000
68eb6efa5d000000
6875fd37ac800000
-
{e=>-1,a=>-32,d=>2,j=>-3,l=>3,c=>0,k=>0,h=>-2,b=>-2,g=>1,f=>0,i=>0}
e0868e18c5000000
e0868e18c5000000
e0868e18c5000000
e0c17070a1800000
e0868e18c5000000
e0868e18c5000000
e0c17070a1800000
e0868e18c5000000
e0c17070a1800000
-
{e=>0,a=>-7,d=>2,j=>3,l=>3,c=>2,k=>1,h=>-4,b=>1,g=>-3,f=>-3,i=>-2}
f991d0d2cb000000
f991d0d2cb000000
f991d0d2cb000000
f9290b6665800000
f991d0d2cb000000
f991d0d2cb000000
f9290b6665800000
f991d0d2cb000000
f9290b6665800000
-
{e=>-1,a=>78,d=>0,j=>1,l=>-2,c=>-2,k=>3,h=>1,b=>-2,g=>1,f=>1,i=>0}
4e369e0499010000
4e369e0499010000
4e369e0499010000
4ed872482f000000
4e369e0499010000
4e369e0499010000
4ed872482f000000
4e369e0499010000
4ed872482f000000
-
{e=>2,a=>-39,d=>-4,j=>-4,l=>2,c=>3,k=>-1,h=>1,b=>2,g=>-3,f=>-2,i=>0}
d91ae506bc000000
d91ae506bc000000
d91ae506bc000000
d94e2d489d000000
d91ae506bc000000
d91ae506bc000000
d94e2d489d000000
d91ae506bc000000
d94e2d489d000000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
};
-
{e=>-4,a=>4,m=>-2,d=>-4,j=>2,l=>-2,c=>0,k=>1,h=>1,b=>2,g=>-3,f=>2,i=>1}
0402a9268a0d0000
0402a9268a0d0000
0402a9268a0d0000
0442454947600000
0402a9268a0d0000
0402a9268a0d0000
0442454947600000
0402a9268a0d0000
0442454947600000
-
{e=>-1,a=>-76,m=>-1,d=>1,j=>0,l=>-1,c=>-4,k=>3,h=>-1,b=>-1,g=>2,f=>0,i=>-3}
b4670ebdd80f0000
b4670ebdd80f0000
b4670ebdd80f0000
b4f0f0bd0ff00000
b4670ebdd80f0000
b4670ebdd80f0000
b4f0f0bd0ff00000
b4670ebdd80f0000
b4f0f0bd0ff00000
-
{e=>3,a=>64,m=>-2,d=>-2,j=>-1,l=>1,c=>2,k=>2,h=>2,b=>1,g=>-2,f=>3,i=>-2}
409137cb570c0000
409137cb570c0000
409137cb570c0000
402b3796e8e00000
409137cb570c0000
409137cb570c0000
402b3796e8e00000
409137cb570c0000
402b3796e8e00000
-
{e=>0,a=>13,m=>1,d=>-3,j=>0,l=>-3,c=>-4,k=>0,h=>-3,b=>0,g=>2,f=>3,i=>-1}
0d6031f540030000
0d6031f540030000
0d6031f540030000
0d1286af02900000
0d6031f540030000
0d6031f540030000
0d1286af02900000
0d6031f540030000
0d1286af02900000
-
{e=>-3,a=>-31,m=>3,d=>3,j=>-3,l=>-3,c=>-3,k=>1,h=>-3,b=>-1,g=>3,f=>0,i=>-2}
e1ef8ad54d070000
e1ef8ad54d070000
e1ef8ad54d070000
e1f5d0eea6b00000
e1ef8ad54d070000
e1ef8ad54d070000
e1f5d0eea6b00000
e1ef8ad54d070000
e1f5d0eea6b00000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
};
-
{e=>3,n=>0,a=>68,m=>2,d=>2,j=>-1,l=>0,c=>-1,k=>0,h=>-4,b=>-3,g=>2,f=>-2,i=>2}
44bd665107040000
44bd665107040000
44bd665107040000
44bd3ca2e0200000
44bd665107040000
44bd665107040000
44bd3ca2e0200000
44bd665107040000
44bd3ca2e0200000
-
{e=>-3,n=>-2,a=>83,m=>3,d=>-3,j=>0,l=>-4,c=>-3,k=>-3,h=>0,b=>2,g=>-4,f=>-1,i=>2}
536a7b4228670000
536a7b4228670000
536a7b4228670000
5356df02163c0000
536a7b4228670000
536a7b4228670000
5356df02163c0000
536a7b4228670000
5356df02163c0000
-
{e=>-4,n=>-1,a=>-51,m=>3,d=>-2,j=>-3,l=>-4,c=>3,k=>0,h=>2,b=>0,g=>0,f=>-3,i=>-3}
cd9859a805770000
cd9859a805770000
cd9859a805770000
cd0f4a15a23e0000
cd9859a805770000
cd9859a805770000
cd0f4a15a23e0000
cd9859a805770000
cd0f4a15a23e0000
-
{e=>-4,n=>-2,a=>53,m=>2,d=>0,j=>-4,l=>-1,c=>2,k=>-4,h=>-2,b=>0,g=>-1,f=>2,i=>1}
3510a83be4650000
3510a83be4650000
3510a83be4650000
350845f193ac0000
3510a83be4650000
3510a83be4650000
350845f193ac0000
3510a83be4650000
350845f193ac0000
-
{e=>-4,n=>-4,a=>-114,m=>-1,d=>-1,j=>0,l=>3,c=>-1,k=>3,h=>1,b=>0,g=>1,f=>-4,i=>0}
8ef8c904d84e0000
8ef8c904d84e0000
8ef8c904d84e0000
8e1fc8480df80000
8ef8c904d84e0000
8ef8c904d84e0000
8e1fc8480df80000
8ef8c904d84e0000
8e1fc8480df80000
=
struct int_wrap {
  char a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
  int o;
};
-
{e=>2,n=>2,a=>81,m=>3,d=>2,j=>0,l=>1,c=>-2,k=>-1,h=>3,b=>-2,g=>-1,f=>3,o=>64,i=>2}
51b6b44f7826000040000000
51b6b44f7826000040000000
51b6b44f7826000040000000
51d927da1cb4000000000040
51b6b44f7826000040000000
51b6b44f7826000040000000
51d927da1cb4000000000040
51b6b44f7826000040000000
51d927da1cb4000000000040
-
{e=>-3,n=>0,a=>114,m=>0,d=>1,j=>-1,l=>-4,c=>1,k=>0,h=>-3,b=>3,g=>-4,f=>-3,o=>31,i=>2}
724b5a56070100001f000000
724b5a56070100001f000000
724b5a56070100001f000000
7264db2ae20000000000001f
724b5a56070100001f000000
724b5a56070100001f000000
7264db2ae20000000000001f
724b5a56070100001f000000
7264db2ae20000000000001f
-
{e=>-2,n=>2,a=>-90,m=>-1,d=>-2,j=>1,l=>2,c=>-1,k=>-2,h=>-2,b=>-3,g=>2,f=>3,o=>11,i=>-2}
a6bd3dd9b12e00000b000000
a6bd3dd9b12e00000b000000
a6bd3dd9b12e00000b000000
a6bf66b6397400000000000b
a6bd3dd9b12e00000b000000
a6bd3dd9b12e00000b000000
a6bf66b6397400000000000b
a6bd3dd9b12e00000b000000
a6bf66b6397400000000000b
-
{e=>-4,n=>1,a=>-83,m=>2,d=>0,j=>-3,l=>3,c=>-3,k=>0,h=>0,b=>0,g=>-3,f=>-3,o=>-60,i=>-1}
ad28d8e2c5140000c4ffffff
ad28d8e2c5140000c4ffffff
ad28d8e2c5140000c4ffffff
ad144b47a1a20000ffffffc4
ad28d8e2c5140000c4ffffff
ad28d8e2c5140000c4ffffff
ad144b47a1a20000ffffffc4
ad28d8e2c5140000c4ffffff
ad144b47a1a20000ffffffc4
-
{e=>3,n=>0,a=>-38,m=>-4,d=>2,j=>-3,l=>-4,c=>-2,k=>-4,h=>-3,b=>0,g=>-4,f=>-4,o=>-32,i=>-4}
dab0469625090000e0ffffff
dab0469625090000e0ffffff
dab0469625090000e0ffffff
da19392cb2400000ffffffe0
dab0469625090000e0ffffff
dab0469625090000e0ffffff
da19392cb2400000ffffffe0
dab0469625090000e0ffffff
da19392cb2400000ffffffe0
=
struct int_wrap {
  short a;
  int b:3;
};
-
{a=>69,b=>-1}
45000700
45000700
45000700
0045e000
45000700
45000700
0045e000
45000700
0045e000
-
{a=>50,b=>1}
32000100
32000100
32000100
00322000
32000100
32000100
00322000
32000100
00322000
-
{a=>40,b=>0}
28000000
28000000
28000000
00280000
28000000
28000000
00280000
28000000
00280000
-
{a=>-10,b=>-4}
f6ff0400
f6ff0400
f6ff0400
fff68000
f6ff0400
f6ff0400
fff68000
f6ff0400
fff68000
-
{a=>-64,b=>-1}
c0ff0700
c0ff0700
c0ff0700
ffc0e000
c0ff0700
c0ff0700
ffc0e000
c0ff0700
ffc0e000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
};
-
{c=>0,a=>106,b=>-1}
6a000700
6a000700
6a000700
006ae000
6a000700
6a000700
006ae000
6a000700
006ae000
-
{c=>-3,a=>112,b=>0}
70002800
70002800
70002800
00701400
70002800
70002800
00701400
70002800
00701400
-
{c=>-1,a=>75,b=>-4}
4b003c00
4b003c00
4b003c00
004b9c00
4b003c00
4b003c00
004b9c00
4b003c00
004b9c00
-
{c=>1,a=>-46,b=>1}
d2ff0900
d2ff0900
d2ff0900
ffd22400
d2ff0900
d2ff0900
ffd22400
d2ff0900
ffd22400
-
{c=>-4,a=>22,b=>-4}
16002400
16002400
16002400
00169000
16002400
16002400
00169000
16002400
00169000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
};
-
{c=>0,a=>-84,b=>-2,d=>-1}
acffc601
acffc601
acffc601
ffacc380
acffc601
acffc601
ffacc380
acffc601
ffacc380
-
{c=>0,a=>-79,b=>2,d=>-1}
b1ffc201
b1ffc201
b1ffc201
ffb14380
b1ffc201
b1ffc201
ffb14380
b1ffc201
ffb14380
-
{c=>-2,a=>102,b=>2,d=>0}
66003200
66003200
66003200
00665800
66003200
66003200
00665800
66003200
00665800
-
{c=>-4,a=>117,b=>-3,d=>-2}
7500a501
7500a501
7500a501
0075b300
7500a501
7500a501
0075b300
7500a501
0075b300
-
{c=>-1,a=>-97,b=>-1,d=>-2}
9fffbf01
9fffbf01
9fffbf01
ff9fff00
9fffbf01
9fffbf01
ff9fff00
9fffbf01
ff9fff00
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
};
-
{e=>-1,c=>-2,a=>63,b=>0,d=>-4}
3f00300f
3f00300f
3f00300f
003f1a70
3f00300f
3f00300f
003f1a70
3f00300f
003f1a70
-
{e=>2,c=>-1,a=>-22,b=>-2,d=>2}
eaffbe04
eaffbe04
eaffbe04
ffeadd20
eaffbe04
eaffbe04
ffeadd20
eaffbe04
ffeadd20
-
{e=>0,c=>1,a=>-97,b=>0,d=>3}
9fffc800
9fffc800
9fffc800
ff9f0580
9fffc800
9fffc800
ff9f0580
9fffc800
ff9f0580
-
{e=>0,c=>-3,a=>-3,b=>-3,d=>3}
fdffed00
fdffed00
fdffed00
fffdb580
fdffed00
fdffed00
fffdb580
fdffed00
fffdb580
-
{e=>-2,c=>0,a=>-35,b=>-1,d=>-1}
ddffc70d
ddffc70d
ddffc70d
ffdde3e0
ddffc70d
ddffc70d
ffdde3e0
ddffc70d
ffdde3e0
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
};
-
{e=>-3,c=>0,a=>-77,b=>-2,d=>3,f=>3}
b3ffc63a
b3ffc63a
b3ffc63a
ffb3c1d6
b3ffc63a
b3ffc63a
ffb3c1d6
b3ffc63a
ffb3c1d6
-
{e=>-2,c=>1,a=>108,b=>2,d=>1,f=>2}
6c004a2c
6c004a2c
6c004a2c
006c44e4
6c004a2c
6c004a2c
006c44e4
6c004a2c
006c44e4
-
{e=>-3,c=>3,a=>-37,b=>-2,d=>-3,f=>2}
dbff5e2b
dbff5e2b
dbff5e2b
ffdbced4
dbff5e2b
dbff5e2b
ffdbced4
dbff5e2b
ffdbced4
-
{e=>-2,c=>3,a=>-8,b=>-3,d=>-1,f=>-1}
f8ffdd7d
f8ffdd7d
f8ffdd7d
fff8afee
f8ffdd7d
f8ffdd7d
fff8afee
f8ffdd7d
fff8afee
-
{e=>3,c=>-1,a=>-111,b=>-4,d=>-2,f=>-2}
91ffbc67
91ffbc67
91ffbc67
ff919f3c
91ffbc67
91ffbc67
ff919f3c
91ffbc67
ff919f3c
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
};
-
{e=>-2,c=>1,a=>81,g=>-3,b=>2,d=>-3,f=>3}
51004a3d05000000
51004a3d05000000
51004a3d05000000
005146e6a0000000
51004a3d05000000
51004a3d05000000
005146e6a0000000
51004a3d05000000
005146e6a0000000
-
{e=>1,c=>-2,a=>75,g=>-3,b=>-4,d=>-3,f=>-1}
4b00747305000000
4b00747305000000
4b00747305000000
004b9a9ea0000000
4b00747305000000
4b00747305000000
004b9a9ea0000000
4b00747305000000
004b9a9ea0000000
-
{e=>1,c=>-4,a=>54,g=>-4,b=>-1,d=>-4,f=>-4}
3600274304000000
3600274304000000
3600274304000000
0036f21880000000
3600274304000000
3600274304000000
0036f21880000000
3600274304000000
0036f21880000000
-
{e=>-1,c=>-2,a=>82,g=>3,b=>1,d=>-4,f=>-3}
5200315f03000000
5200315f03000000
5200315f03000000
00523a7a60000000
5200315f03000000
5200315f03000000
00523a7a60000000
5200315f03000000
00523a7a60000000
-
{e=>0,c=>-2,a=>-94,g=>3,b=>-1,d=>-4,f=>3}
a2ff373103000000
a2ff373103000000
a2ff373103000000
ffa2fa0660000000
a2ff373103000000
a2ff373103000000
ffa2fa0660000000
a2ff373103000000
ffa2fa0660000000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
};
-
{e=>-2,a=>-123,d=>2,c=>3,h=>0,b=>2,g=>2,f=>-2}
85ff9a6c02000000
85ff9a6c02000000
85ff9a6c02000000
ff854d6c40000000
85ff9a6c02000000
85ff9a6c02000000
ff854d6c40000000
85ff9a6c02000000
ff854d6c40000000
-
{e=>-4,a=>-75,d=>-2,c=>2,h=>-3,b=>0,g=>-4,f=>0}
b5ff90092c000000
b5ff90092c000000
b5ff90092c000000
ffb50b4094000000
b5ff90092c000000
b5ff90092c000000
ffb50b4094000000
b5ff90092c000000
ffb50b4094000000
-
{e=>-1,a=>-85,d=>0,c=>-4,h=>-4,b=>1,g=>-2,f=>-4}
abff214e26000000
abff214e26000000
abff214e26000000
ffab3078d0000000
abff214e26000000
abff214e26000000
ffab3078d0000000
abff214e26000000
ffab3078d0000000
-
{e=>-4,a=>94,d=>-1,c=>-4,h=>2,b=>-2,g=>-2,f=>3}
5e00e63916000000
5e00e63916000000
5e00e63916000000
005ed3c6c8000000
5e00e63916000000
5e00e63916000000
005ed3c6c8000000
5e00e63916000000
005ed3c6c8000000
-
{e=>1,a=>26,d=>-3,c=>-3,h=>-3,b=>2,g=>-4,f=>2}
1a006a232c000000
1a006a232c000000
1a006a232c000000
001a569494000000
1a006a232c000000
1a006a232c000000
001a569494000000
1a006a232c000000
001a569494000000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
};
-
{e=>-4,a=>-127,d=>1,c=>0,h=>3,b=>1,g=>-1,f=>3,i=>3}
81ff4138df000000
81ff4138df000000
81ff4138df000000
ff8120c6ed800000
81ff4138df000000
81ff4138df000000
ff8120c6ed800000
81ff4138df000000
ff8120c6ed800000
-
{e=>-2,a=>-73,d=>-3,c=>1,h=>-3,b=>-1,g=>3,f=>-3,i=>-4}
b7ff4f5d2b010000
b7ff4f5d2b010000
b7ff4f5d2b010000
ffb7e6ea76000000
b7ff4f5d2b010000
b7ff4f5d2b010000
ffb7e6ea76000000
b7ff4f5d2b010000
ffb7e6ea76000000
-
{e=>-4,a=>-22,d=>2,c=>-4,h=>3,b=>2,g=>0,f=>3,i=>-2}
eaffa23898010000
eaffa23898010000
eaffa23898010000
ffea51460f000000
eaffa23898010000
eaffa23898010000
ffea51460f000000
eaffa23898010000
ffea51460f000000
-
{e=>3,a=>-124,d=>3,c=>2,h=>3,b=>0,g=>0,f=>2,i=>2}
84ffd02698000000
84ffd02698000000
84ffd02698000000
ff8409b40d000000
84ffd02698000000
84ffd02698000000
ff8409b40d000000
84ffd02698000000
ff8409b40d000000
-
{e=>2,a=>115,d=>3,c=>1,h=>-3,b=>2,g=>3,f=>-1,i=>0}
7300ca742b000000
7300ca742b000000
7300ca742b000000
007345ae74000000
7300ca742b000000
7300ca742b000000
007345ae74000000
7300ca742b000000
007345ae74000000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
};
-
{e=>-4,a=>-21,d=>-2,j=>-2,c=>-1,h=>-1,b=>-2,g=>-2,f=>-3,i=>1}
ebffbe597e0c0000
ebffbe597e0c0000
ebffbe597e0c0000
ffebdf4adce00000
ebffbe597e0c0000
ebffbe597e0c0000
ffebdf4adce00000
ebffbe597e0c0000
ffebdf4adce00000
-
{e=>-3,a=>71,d=>1,j=>-1,c=>2,h=>0,b=>-4,g=>1,f=>-4,i=>-4}
4700544a010f0000
4700544a010f0000
4700544a010f0000
004788d822700000
4700544a010f0000
4700544a010f0000
004788d822700000
4700544a010f0000
004788d822700000
-
{e=>-2,a=>-5,d=>-3,j=>3,c=>-3,h=>1,b=>-3,g=>3,f=>2,i=>-1}
fbff6d2dcb070000
fbff6d2dcb070000
fbff6d2dcb070000
fffbb6e467b00000
fbff6d2dcb070000
fbff6d2dcb070000
fffbb6e467b00000
fbff6d2dcb070000
fffbb6e467b00000
-
{e=>1,a=>-46,d=>3,j=>-2,c=>3,h=>-4,b=>-4,g=>-3,f=>-2,i=>0}
d2ffdc62250c0000
d2ffdc62250c0000
d2ffdc62250c0000
ffd28d9cb0600000
d2ffdc62250c0000
d2ffdc62250c0000
ffd28d9cb0600000
d2ffdc62250c0000
ffd28d9cb0600000
-
{e=>2,a=>-69,d=>-4,j=>0,c=>3,h=>3,b=>1,g=>2,f=>-2,i=>2}
bbff19659a000000
bbff19659a000000
bbff19659a000000
ffbb2e2c4d000000
bbff19659a000000
bbff19659a000000
ffbb2e2c4d000000
bbff19659a000000
ffbb2e2c4d000000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
};
-
{e=>3,a=>-20,d=>2,j=>-2,c=>-4,k=>3,h=>-1,b=>-1,g=>-2,f=>-4,i=>-3}
ecffa7467e3d0000
ecffa7467e3d0000
ecffa7467e3d0000
ffecf138dee60000
ecffa7467e3d0000
ecffa7467e3d0000
ffecf138dee60000
ecffa7467e3d0000
ffecf138dee60000
-
{e=>-1,a=>-104,d=>2,j=>-4,c=>1,k=>-2,h=>-1,b=>1,g=>-3,f=>-4,i=>1}
98ff894e7d680000
98ff894e7d680000
98ff894e7d680000
ff982578bccc0000
98ff894e7d680000
98ff894e7d680000
ff982578bccc0000
98ff894e7d680000
ff982578bccc0000
-
{e=>3,a=>11,d=>3,j=>0,c=>2,k=>-3,h=>-3,b=>-2,g=>0,f=>-1,i=>-4}
0b00d67628510000
0b00d67628510000
0b00d67628510000
000bc9be160a0000
0b00d67628510000
0b00d67628510000
000bc9be160a0000
0b00d67628510000
000bc9be160a0000
-
{e=>-1,a=>102,d=>2,j=>-2,c=>-4,k=>-4,h=>-1,b=>0,g=>-4,f=>-2,i=>2}
6600a06ebc4c0000
6600a06ebc4c0000
6600a06ebc4c0000
0066117c9d680000
6600a06ebc4c0000
6600a06ebc4c0000
0066117c9d680000
6600a06ebc4c0000
0066117c9d680000
-
{e=>0,a=>-79,d=>-3,j=>-1,c=>0,k=>-2,h=>0,b=>3,g=>1,f=>-3,i=>-3}
b1ff4351416f0000
b1ff4351416f0000
b1ff4351416f0000
ffb1628a22fc0000
b1ff4351416f0000
b1ff4351416f0000
ffb1628a22fc0000
b1ff4351416f0000
ffb1628a22fc0000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
};
-
{e=>-3,a=>-109,d=>-4,j=>-3,l=>-4,c=>-4,k=>-4,h=>-1,b=>1,g=>-1,f=>-4,i=>1}
93ff214b7f4a0200
93ff214b7f4a0200
93ff214b7f4a0200
ff933258fcd90000
93ff214b7f4a0200
93ff214b7f4a0200
ff933258fcd90000
93ff214b7f4a0200
ff933258fcd90000
-
{e=>1,a=>-37,d=>-3,j=>-2,l=>-3,c=>2,k=>-3,h=>-4,b=>3,g=>-1,f=>-4,i=>-2}
dbff5343a7dd0200
dbff5343a7dd0200
dbff5343a7dd0200
ffdb6a98f36b4000
dbff5343a7dd0200
dbff5343a7dd0200
ffdb6a98f36b4000
dbff5343a7dd0200
ffdb6a98f36b4000
-
{e=>-3,a=>-27,d=>-3,j=>-2,l=>-3,c=>1,k=>1,h=>-2,b=>-4,g=>1,f=>3,i=>-4}
e5ff4c3b319d0200
e5ff4c3b319d0200
e5ff4c3b319d0200
ffe586d63a634000
e5ff4c3b319d0200
e5ff4c3b319d0200
ffe586d63a634000
e5ff4c3b319d0200
ffe586d63a634000
-
{e=>3,a=>-69,d=>-3,j=>-3,l=>-1,c=>-3,k=>1,h=>2,b=>3,g=>2,f=>0,i=>3}
bbff6b07d29a0300
bbff6b07d29a0300
bbff6b07d29a0300
ffbb76b049d3c000
bbff6b07d29a0300
bbff6b07d29a0300
ffbb76b049d3c000
bbff6b07d29a0300
ffbb76b049d3c000
-
{e=>0,a=>-52,d=>1,j=>2,l=>1,c=>-3,k=>-4,h=>0,b=>-3,g=>3,f=>-3,i=>0}
ccff6d5003c40000
ccff6d5003c40000
ccff6d5003c40000
ffccb48a60284000
ccff6d5003c40000
ccff6d5003c40000
ffccb48a60284000
ccff6d5003c40000
ffccb48a60284000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
};
-
{e=>1,a=>-21,m=>-3,d=>-4,j=>-2,l=>2,c=>-4,k=>-2,h=>-4,b=>-4,g=>2,f=>-1,i=>2}
ebff2473a26c1500
ebff2473a26c1500
ebff2473a26c1500
ffeb921e516ca800
ebff2473a26c1500
ebff2473a26c1500
ffeb921e516ca800
ebff2473a26c1500
ffeb921e516ca800
-
{e=>-1,a=>-68,m=>-2,d=>-2,j=>0,l=>1,c=>3,k=>2,h=>-3,b=>0,g=>3,f=>-3,i=>0}
bcff985f2ba01800
bcff985f2ba01800
bcff985f2ba01800
ffbc0f7a74047000
bcff985f2ba01800
bcff985f2ba01800
ffbc0f7a74047000
bcff985f2ba01800
ffbc0f7a74047000
-
{e=>-1,a=>-32,m=>-3,d=>0,j=>1,l=>2,c=>2,k=>-2,h=>0,b=>0,g=>-2,f=>-2,i=>-3}
e0ff106e46631500
e0ff106e46631500
e0ff106e46631500
ffe0087cc29ca800
e0ff106e46631500
e0ff106e46631500
ffe0087cc29ca800
e0ff106e46631500
ffe0087cc29ca800
-
{e=>1,a=>-68,m=>0,d=>1,j=>-3,l=>3,c=>-4,k=>2,h=>-4,b=>0,g=>3,f=>-1,i=>2}
bcff6072a3aa0100
bcff6072a3aa0100
bcff6072a3aa0100
ffbc109e7154c000
bcff6072a3aa0100
bcff6072a3aa0100
ffbc109e7154c000
bcff6072a3aa0100
ffbc109e7154c000
-
{e=>-4,a=>-109,m=>-4,d=>2,j=>2,l=>-1,c=>-2,k=>2,h=>-1,b=>-4,g=>-1,f=>0,i=>-2}
93ffb408bfa51300
93ffb408bfa51300
93ffb408bfa51300
ff939940ff25e000
93ffb408bfa51300
93ffb408bfa51300
ff939940ff25e000
93ffb408bfa51300
ff939940ff25e000
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
};
-
{e=>-2,n=>-4,a=>79,m=>-3,d=>3,j=>-2,l=>2,c=>-4,k=>-1,h=>0,b=>-1,g=>-4,f=>-4,i=>-4}
4f00e74c047d9500
4f00e74c047d9500
4f00e74c047d9500
004ff1e8826eac00
4f00e74c047d9500
4f00e74c047d9500
004ff1e8826eac00
4f00e74c047d9500
004ff1e8826eac00
-
{e=>3,n=>0,a=>-114,m=>-3,d=>-1,j=>2,l=>-1,c=>0,k=>1,h=>0,b=>-1,g=>-1,f=>3,i=>0}
8effc73707941700
8effc73707941700
8effc73707941700
ff8ee3b6e023e800
8effc73707941700
8effc73707941700
ff8ee3b6e023e800
8effc73707941700
ff8ee3b6e023e800
-
{e=>1,n=>0,a=>-17,m=>-1,d=>1,j=>2,l=>-2,c=>-4,k=>3,h=>-4,b=>-3,g=>-3,f=>0,i=>0}
efff650225341f00
efff650225341f00
efff650225341f00
ffefb090b027b800
efff650225341f00
efff650225341f00
ffefb090b027b800
efff650225341f00
ffefb090b027b800
-
{e=>2,n=>2,a=>-31,m=>0,d=>-4,j=>2,l=>-1,c=>0,k=>-2,h=>-1,b=>-3,g=>-4,f=>-2,i=>-1}
e1ff0565fce54300
e1ff0565fce54300
e1ff0565fce54300
ffe1a22c9fadc200
e1ff0565fce54300
e1ff0565fce54300
ffe1a22c9fadc200
e1ff0565fce54300
ffe1a22c9fadc200
-
{e=>-4,n=>3,a=>-41,m=>1,d=>-1,j=>0,l=>-2,c=>1,k=>-1,h=>-2,b=>1,g=>0,f=>0,i=>0}
d7ffc90930706700
d7ffc90930706700
d7ffc90930706700
ffd727c0180f8b00
d7ffc90930706700
d7ffc90930706700
ffd727c0180f8b00
d7ffc90930706700
ffd727c0180f8b00
=
struct int_wrap {
  short a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
  int o;
};
-
{e=>1,n=>0,a=>69,m=>-1,d=>-4,j=>1,l=>1,c=>-1,k=>-2,h=>-1,b=>-1,g=>-2,f=>-3,o=>1,i=>-1}
45003f53fee31c0001000000
45003f53fee31c0001000000
45003f53fee31c0001000000
0045fe1adf9c780000000001
45003f53fee31c0001000000
45003f53fee31c0001000000
0045fe1adf9c780000000001
45003f53fee31c0001000000
0045fe1adf9c780000000001
-
{e=>2,n=>0,a=>-113,m=>3,d=>1,j=>1,l=>-1,c=>0,k=>3,h=>2,b=>-1,g=>-1,f=>-4,o=>-65,i=>-3}
8fff474457b30f00bfffffff
8fff474457b30f00bfffffff
8fff474457b30f00bfffffff
ff8fe0a8ea97d800ffffffbf
8fff474457b30f00bfffffff
8fff474457b30f00bfffffff
ff8fe0a8ea97d800ffffffbf
8fff474457b30f00bfffffff
ff8fe0a8ea97d800ffffffbf
-
{e=>1,n=>-3,a=>-34,m=>0,d=>-1,j=>3,l=>0,c=>1,k=>3,h=>-1,b=>-1,g=>-1,f=>2,o=>-8,i=>0}
deffcf233f36a000f8ffffff
deffcf233f36a000f8ffffff
deffcf233f36a000f8ffffff
ffdee794fc360500fffffff8
deffcf233f36a000f8ffffff
deffcf233f36a000f8ffffff
ffdee794fc360500fffffff8
deffcf233f36a000f8ffffff
ffdee794fc360500fffffff8
-
{e=>3,n=>1,a=>84,m=>-2,d=>1,j=>1,l=>1,c=>2,k=>3,h=>3,b=>3,g=>-4,f=>3,o=>115,i=>-3}
540053365cb3380073000000
540053365cb3380073000000
540053365cb3380073000000
005468b68e96710000000073
540053365cb3380073000000
540053365cb3380073000000
005468b68e96710000000073
540053365cb3380073000000
005468b68e96710000000073
-
{e=>3,n=>0,a=>-51,m=>-3,d=>-3,j=>2,l=>0,c=>3,k=>2,h=>0,b=>1,g=>1,f=>3,o=>-72,i=>-3}
cdff593741251400b8ffffff
cdff593741251400b8ffffff
cdff593741251400b8ffffff
ffcd2eb622a42800ffffffb8
cdff593741251400b8ffffff
cdff593741251400b8ffffff
ffcd2eb622a42800ffffffb8
cdff593741251400b8ffffff
ffcd2eb622a42800ffffffb8
=
struct int_wrap {
  int a;
  int b:3;
};
-
{a=>-84,b=>-2}
acffffff06000000
acffffff06000000
acffffff06000000
ffffffacc0000000
acffffff06000000
acffffff06000000
ffffffacc0000000
acffffff06000000
ffffffacc0000000
-
{a=>71,b=>2}
4700000002000000
4700000002000000
4700000002000000
0000004740000000
4700000002000000
4700000002000000
0000004740000000
4700000002000000
0000004740000000
-
{a=>-81,b=>0}
afffffff00000000
afffffff00000000
afffffff00000000
ffffffaf00000000
afffffff00000000
afffffff00000000
ffffffaf00000000
afffffff00000000
ffffffaf00000000
-
{a=>-113,b=>-3}
8fffffff05000000
8fffffff05000000
8fffffff05000000
ffffff8fa0000000
8fffffff05000000
8fffffff05000000
ffffff8fa0000000
8fffffff05000000
ffffff8fa0000000
-
{a=>16,b=>-1}
1000000007000000
1000000007000000
1000000007000000
00000010e0000000
1000000007000000
1000000007000000
00000010e0000000
1000000007000000
00000010e0000000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
};
-
{c=>-3,a=>53,b=>-4}
350000002c000000
350000002c000000
350000002c000000
0000003594000000
350000002c000000
350000002c000000
0000003594000000
350000002c000000
0000003594000000
-
{c=>-3,a=>67,b=>-4}
430000002c000000
430000002c000000
430000002c000000
0000004394000000
430000002c000000
430000002c000000
0000004394000000
430000002c000000
0000004394000000
-
{c=>1,a=>102,b=>2}
660000000a000000
660000000a000000
660000000a000000
0000006644000000
660000000a000000
660000000a000000
0000006644000000
660000000a000000
0000006644000000
-
{c=>0,a=>-10,b=>1}
f6ffffff01000000
f6ffffff01000000
f6ffffff01000000
fffffff620000000
f6ffffff01000000
f6ffffff01000000
fffffff620000000
f6ffffff01000000
fffffff620000000
-
{c=>0,a=>-76,b=>0}
b4ffffff00000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
ffffffb400000000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
};
-
{c=>-1,a=>-33,b=>-1,d=>-1}
dfffffffff010000
dfffffffff010000
dfffffffff010000
ffffffdfff800000
dfffffffff010000
dfffffffff010000
ffffffdfff800000
dfffffffff010000
ffffffdfff800000
-
{c=>-4,a=>-87,b=>2,d=>-1}
a9ffffffe2010000
a9ffffffe2010000
a9ffffffe2010000
ffffffa953800000
a9ffffffe2010000
a9ffffffe2010000
ffffffa953800000
a9ffffffe2010000
ffffffa953800000
-
{c=>3,a=>19,b=>0,d=>3}
13000000d8000000
13000000d8000000
13000000d8000000
000000130d800000
13000000d8000000
13000000d8000000
000000130d800000
13000000d8000000
000000130d800000
-
{c=>-4,a=>39,b=>0,d=>-1}
27000000e0010000
27000000e0010000
27000000e0010000
0000002713800000
27000000e0010000
27000000e0010000
0000002713800000
27000000e0010000
0000002713800000
-
{c=>0,a=>-2,b=>3,d=>-4}
feffffff03010000
feffffff03010000
feffffff03010000
fffffffe62000000
feffffff03010000
feffffff03010000
fffffffe62000000
feffffff03010000
fffffffe62000000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
};
-
{e=>1,c=>2,a=>-32,b=>1,d=>-2}
e0ffffff91030000
e0ffffff91030000
e0ffffff91030000
ffffffe02b100000
e0ffffff91030000
e0ffffff91030000
ffffffe02b100000
e0ffffff91030000
ffffffe02b100000
-
{e=>-4,c=>0,a=>12,b=>0,d=>2}
0c00000080080000
0c00000080080000
0c00000080080000
0000000c01400000
0c00000080080000
0c00000080080000
0000000c01400000
0c00000080080000
0000000c01400000
-
{e=>-2,c=>1,a=>74,b=>0,d=>0}
4a000000080c0000
4a000000080c0000
4a000000080c0000
0000004a04600000
4a000000080c0000
4a000000080c0000
0000004a04600000
4a000000080c0000
0000004a04600000
-
{e=>-3,c=>3,a=>-43,b=>-1,d=>-1}
d5ffffffdf0b0000
d5ffffffdf0b0000
d5ffffffdf0b0000
ffffffd5efd00000
d5ffffffdf0b0000
d5ffffffdf0b0000
ffffffd5efd00000
d5ffffffdf0b0000
ffffffd5efd00000
-
{e=>3,c=>3,a=>67,b=>1,d=>-1}
43000000d9070000
43000000d9070000
43000000d9070000
000000432fb00000
43000000d9070000
43000000d9070000
000000432fb00000
43000000d9070000
000000432fb00000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
};
-
{e=>0,c=>3,a=>-63,b=>2,d=>0,f=>1}
c1ffffff1a100000
c1ffffff1a100000
c1ffffff1a100000
ffffffc14c020000
c1ffffff1a100000
c1ffffff1a100000
ffffffc14c020000
c1ffffff1a100000
ffffffc14c020000
-
{e=>3,c=>3,a=>-76,b=>-1,d=>-4,f=>3}
b4ffffff1f370000
b4ffffff1f370000
b4ffffff1f370000
ffffffb4ee360000
b4ffffff1f370000
b4ffffff1f370000
ffffffb4ee360000
b4ffffff1f370000
ffffffb4ee360000
-
{e=>-1,c=>0,a=>45,b=>3,d=>3,f=>0}
2d000000c30e0000
2d000000c30e0000
2d000000c30e0000
0000002d61f00000
2d000000c30e0000
2d000000c30e0000
0000002d61f00000
2d000000c30e0000
0000002d61f00000
-
{e=>1,c=>2,a=>117,b=>-1,d=>-3,f=>-2}
7500000057630000
7500000057630000
7500000057630000
00000075ea9c0000
7500000057630000
7500000057630000
00000075ea9c0000
7500000057630000
00000075ea9c0000
-
{e=>-3,c=>-1,a=>75,b=>-4,d=>3,f=>3}
4b000000fc3a0000
4b000000fc3a0000
4b000000fc3a0000
0000004b9dd60000
4b000000fc3a0000
4b000000fc3a0000
0000004b9dd60000
4b000000fc3a0000
0000004b9dd60000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
};
-
{e=>2,c=>0,a=>94,g=>-4,b=>2,d=>2,f=>2}
5e00000082240200
5e00000082240200
5e00000082240200
0000005e41250000
5e00000082240200
5e00000082240200
0000005e41250000
5e00000082240200
0000005e41250000
-
{e=>-4,c=>-3,a=>-22,g=>-3,b=>3,d=>3,f=>3}
eaffffffebb80200
eaffffffebb80200
eaffffffebb80200
ffffffea75c74000
eaffffffebb80200
eaffffffebb80200
ffffffea75c74000
eaffffffebb80200
ffffffea75c74000
-
{e=>3,c=>1,a=>14,g=>0,b=>1,d=>1,f=>1}
0e00000049160000
0e00000049160000
0e00000049160000
0000000e24b20000
0e00000049160000
0e00000049160000
0000000e24b20000
0e00000049160000
0000000e24b20000
-
{e=>-3,c=>3,a=>-61,g=>-1,b=>-3,d=>-2,f=>-4}
c3ffffff9dcb0300
c3ffffff9dcb0300
c3ffffff9dcb0300
ffffffc3af59c000
c3ffffff9dcb0300
c3ffffff9dcb0300
ffffffc3af59c000
c3ffffff9dcb0300
ffffffc3af59c000
-
{e=>-1,c=>-2,a=>28,g=>2,b=>1,d=>0,f=>-3}
1c000000315e0100
1c000000315e0100
1c000000315e0100
0000001c387a8000
1c000000315e0100
1c000000315e0100
0000001c387a8000
1c000000315e0100
0000001c387a8000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
};
-
{e=>1,a=>115,d=>2,c=>1,h=>0,b=>1,g=>1,f=>3}
7300000089b20000
7300000089b20000
7300000089b20000
0000007325164000
7300000089b20000
7300000089b20000
0000007325164000
7300000089b20000
0000007325164000
-
{e=>1,a=>19,d=>-2,c=>-3,h=>2,b=>-1,g=>-1,f=>-1}
13000000aff30b00
13000000aff30b00
13000000aff30b00
00000013f71fd000
13000000aff30b00
13000000aff30b00
00000013f71fd000
13000000aff30b00
00000013f71fd000
-
{e=>2,a=>-115,d=>2,c=>-4,h=>0,b=>-2,g=>-3,f=>-3}
8dffffffa6d40200
8dffffffa6d40200
8dffffffa6d40200
ffffff8dd12b4000
8dffffffa6d40200
8dffffffa6d40200
ffffff8dd12b4000
8dffffffa6d40200
ffffff8dd12b4000
-
{e=>-1,a=>126,d=>2,c=>-3,h=>2,b=>-4,g=>2,f=>2}
7e000000ac2e0900
7e000000ac2e0900
7e000000ac2e0900
0000007e95749000
7e000000ac2e0900
7e000000ac2e0900
0000007e95749000
7e000000ac2e0900
0000007e95749000
-
{e=>3,a=>123,d=>3,c=>0,h=>-4,b=>-2,g=>1,f=>-4}
7b000000c6c61000
7b000000c6c61000
7b000000c6c61000
0000007bc1b86000
7b000000c6c61000
7b000000c6c61000
0000007bc1b86000
7b000000c6c61000
0000007bc1b86000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
};
-
{e=>0,a=>-116,d=>-4,c=>0,h=>-3,b=>0,g=>-4,f=>3,i=>-1}
8cffffff0031f600
8cffffff0031f600
8cffffff0031f600
ffffff8c02072f00
8cffffff0031f600
8cffffff0031f600
ffffff8c02072f00
8cffffff0031f600
ffffff8c02072f00
-
{e=>-1,a=>-120,d=>0,c=>0,h=>-2,b=>2,g=>-1,f=>1,i=>-4}
88ffffff029e9b00
88ffffff029e9b00
88ffffff029e9b00
ffffff884073f400
88ffffff029e9b00
88ffffff029e9b00
ffffff884073f400
88ffffff029e9b00
ffffff884073f400
-
{e=>0,a=>89,d=>0,c=>-3,h=>3,b=>-2,g=>0,f=>-1,i=>-4}
590000002e708c00
590000002e708c00
590000002e708c00
00000059d40e1c00
590000002e708c00
590000002e708c00
00000059d40e1c00
590000002e708c00
00000059d40e1c00
-
{e=>2,a=>107,d=>-1,c=>0,h=>-4,b=>0,g=>-2,f=>1,i=>2}
6b000000c0155300
6b000000c0155300
6b000000c0155300
0000006b03a3a200
6b000000c0155300
6b000000c0155300
0000006b03a3a200
6b000000c0155300
0000006b03a3a200
-
{e=>1,a=>126,d=>-2,c=>-1,h=>-3,b=>1,g=>3,f=>-4,i=>-2}
7e000000b9c3d500
7e000000b9c3d500
7e000000b9c3d500
0000007e3f18ee00
7e000000b9c3d500
7e000000b9c3d500
0000007e3f18ee00
7e000000b9c3d500
0000007e3f18ee00
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
};
-
{e=>-1,a=>-65,d=>2,j=>-4,c=>-2,h=>-4,b=>0,g=>-1,f=>-3,i=>1}
bfffffffb0de3304
bfffffffb0de3304
bfffffffb0de3304
ffffffbf197be180
bfffffffb0de3304
bfffffffb0de3304
ffffffbf197be180
bfffffffb0de3304
ffffffbf197be180
-
{e=>-4,a=>-87,d=>-1,j=>1,c=>-2,h=>1,b=>3,g=>-2,f=>0,i=>2}
a9fffffff3094701
a9fffffff3094701
a9fffffff3094701
ffffffa97bc18a20
a9fffffff3094701
a9fffffff3094701
ffffffa97bc18a20
a9fffffff3094701
ffffffa97bc18a20
-
{e=>0,a=>19,d=>0,j=>0,c=>1,h=>1,b=>2,g=>-3,f=>3,i=>3}
130000000ab06600
130000000ab06600
130000000ab06600
0000001344074b00
130000000ab06600
130000000ab06600
0000001344074b00
130000000ab06600
0000001344074b00
-
{e=>1,a=>-111,d=>-2,j=>1,c=>3,h=>0,b=>-4,g=>-4,f=>1,i=>0}
91ffffff9c130201
91ffffff9c130201
91ffffff9c130201
ffffff918f130020
91ffffff9c130201
91ffffff9c130201
ffffff918f130020
91ffffff9c130201
ffffff918f130020
-
{e=>-1,a=>-103,d=>1,j=>0,c=>-1,h=>-4,b=>2,g=>1,f=>-3,i=>3}
99ffffff7ade7000
99ffffff7ade7000
99ffffff7ade7000
ffffff995cfa6300
99ffffff7ade7000
99ffffff7ade7000
ffffff995cfa6300
99ffffff7ade7000
ffffff995cfa6300
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
};
-
{e=>-3,a=>38,d=>-2,j=>2,c=>-2,k=>1,h=>1,b=>0,g=>0,f=>2,i=>0}
26000000b02b040a
26000000b02b040a
26000000b02b040a
000000261b540844
26000000b02b040a
26000000b02b040a
000000261b540844
26000000b02b040a
000000261b540844
-
{e=>2,a=>41,d=>0,j=>-3,c=>1,k=>-2,h=>-3,b=>0,g=>0,f=>0,i=>0}
2900000008041435
2900000008041435
2900000008041435
00000029042028b8
2900000008041435
2900000008041435
00000029042028b8
2900000008041435
00000029042028b8
-
{e=>3,a=>107,d=>-3,j=>-1,c=>2,k=>-2,h=>1,b=>0,g=>-1,f=>3,i=>1}
6b00000050b72737
6b00000050b72737
6b00000050b72737
0000006b0ab7c9f8
6b00000050b72737
6b00000050b72737
0000006b0ab7c9f8
6b00000050b72737
0000006b0ab7c9f8
-
{e=>3,a=>18,d=>-4,j=>2,c=>-4,k=>-1,h=>-3,b=>-1,g=>-3,f=>-3,i=>-3}
1200000027d7b63a
1200000027d7b63a
1200000027d7b63a
00000012f23b6d5c
1200000027d7b63a
1200000027d7b63a
00000012f23b6d5c
1200000027d7b63a
00000012f23b6d5c
-
{e=>3,a=>-10,d=>-4,j=>2,c=>1,k=>0,h=>-1,b=>-4,g=>0,f=>1,i=>2}
f6ffffff0c175c02
f6ffffff0c175c02
f6ffffff0c175c02
fffffff686323a40
f6ffffff0c175c02
f6ffffff0c175c02
fffffff686323a40
f6ffffff0c175c02
fffffff686323a40
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
};
-
{e=>1,a=>-91,d=>3,j=>-3,l=>2,c=>2,k=>-1,h=>1,b=>-1,g=>-4,f=>-2,i=>-3}
a5ffffffd762a63d02000000
a5ffffffd762a63d02000000
a5ffffffd762a63d02000000
ffffffa5e99d0dbc40000000
a5ffffffd762a63d02000000
a5ffffffd762a63d02000000
ffffffa5e99d0dbc40000000
a5ffffffd762a63d02000000
ffffffa5e99d0dbc40000000
-
{e=>-1,a=>-28,d=>0,j=>-4,l=>-3,c=>-2,k=>2,h=>-4,b=>-2,g=>-2,f=>-1,i=>0}
e4ffffff367e131405000000
e4ffffff367e131405000000
e4ffffff367e131405000000
ffffffe4d87fa088a0000000
e4ffffff367e131405000000
e4ffffff367e131405000000
ffffffe4d87fa088a0000000
e4ffffff367e131405000000
ffffffe4d87fa088a0000000
-
{e=>1,a=>78,d=>-3,j=>-3,l=>-2,c=>1,k=>2,h=>0,b=>-2,g=>0,f=>-2,i=>-3}
4e0000004e63a01506000000
4e0000004e63a01506000000
4e0000004e63a01506000000
0000004ec69c05a8c0000000
4e0000004e63a01506000000
4e0000004e63a01506000000
0000004ec69c05a8c0000000
4e0000004e63a01506000000
0000004ec69c05a8c0000000
-
{e=>-2,a=>71,d=>2,j=>-4,l=>-1,c=>-4,k=>2,h=>3,b=>1,g=>0,f=>-1,i=>1}
47000000a17c2c1407000000
47000000a17c2c1407000000
47000000a17c2c1407000000
00000047316e1988e0000000
47000000a17c2c1407000000
47000000a17c2c1407000000
00000047316e1988e0000000
47000000a17c2c1407000000
00000047316e1988e0000000
-
{e=>-2,a=>-99,d=>-4,j=>-2,l=>-4,c=>-2,k=>3,h=>-1,b=>1,g=>-4,f=>-1,i=>-1}
9dffffff317dfe1e04000000
9dffffff317dfe1e04000000
9dffffff317dfe1e04000000
ffffff9d3a6f3fcc80000000
9dffffff317dfe1e04000000
9dffffff317dfe1e04000000
ffffff9d3a6f3fcc80000000
9dffffff317dfe1e04000000
ffffff9d3a6f3fcc80000000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
};
-
{e=>1,a=>11,m=>3,d=>0,j=>-1,l=>2,c=>2,k=>-2,h=>0,b=>2,g=>-1,f=>-4,i=>-3}
0b00000012c2a3371a000000
0b00000012c2a3371a000000
0b00000012c2a3371a000000
0000000b4819c5f84c000000
0b00000012c2a3371a000000
0b00000012c2a3371a000000
0000000b4819c5f84c000000
0b00000012c2a3371a000000
0000000b4819c5f84c000000
-
{e=>3,a=>-31,m=>-1,d=>1,j=>3,l=>1,c=>-3,k=>-4,h=>-3,b=>-3,g=>3,f=>-2,i=>0}
e1ffffff6de6152339000000
e1ffffff6de6152339000000
e1ffffff6de6152339000000
ffffffe1b4bce8703c000000
e1ffffff6de6152339000000
e1ffffff6de6152339000000
ffffffe1b4bce8703c000000
e1ffffff6de6152339000000
ffffffe1b4bce8703c000000
-
{e=>-1,a=>-107,m=>-1,d=>-4,j=>3,l=>-4,c=>3,k=>-3,h=>3,b=>0,g=>3,f=>-1,i=>2}
95ffffff18ff4d2b3c000000
95ffffff18ff4d2b3c000000
95ffffff18ff4d2b3c000000
ffffff950e7eda749c000000
95ffffff18ff4d2b3c000000
95ffffff18ff4d2b3c000000
ffffff950e7eda749c000000
95ffffff18ff4d2b3c000000
ffffff950e7eda749c000000
-
{e=>-3,a=>-123,m=>-3,d=>3,j=>-1,l=>3,c=>2,k=>-2,h=>1,b=>2,g=>-4,f=>-2,i=>-2}
85ffffffd26ac6372b000000
85ffffffd26ac6372b000000
85ffffffd26ac6372b000000
ffffff8549dd0ef874000000
85ffffffd26ac6372b000000
85ffffffd26ac6372b000000
ffffff8549dd0ef874000000
85ffffffd26ac6372b000000
ffffff8549dd0ef874000000
-
{e=>-3,a=>-105,m=>-4,d=>-1,j=>-2,l=>-2,c=>-1,k=>3,h=>-4,b=>3,g=>-1,f=>3,i=>1}
97fffffffbbb331e26000000
97fffffffbbb331e26000000
97fffffffbbb331e26000000
ffffff977fd7e1ccd0000000
97fffffffbbb331e26000000
97fffffffbbb331e26000000
ffffff977fd7e1ccd0000000
97fffffffbbb331e26000000
ffffff977fd7e1ccd0000000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
};
-
{e=>1,n=>2,a=>-70,m=>2,d=>-1,j=>-2,l=>-2,c=>-4,k=>0,h=>-3,b=>-3,g=>-4,f=>0,i=>-2}
baffffffe503d60696000000
baffffffe503d60696000000
baffffffe503d60696000000
ffffffbab3912ec0c9000000
baffffffe503d60696000000
baffffffe503d60696000000
ffffffbab3912ec0c9000000
baffffffe503d60696000000
ffffffbab3912ec0c9000000
-
{e=>-2,n=>-3,a=>99,m=>1,d=>-4,j=>0,l=>2,c=>-3,k=>2,h=>-4,b=>3,g=>1,f=>3,i=>1}
630000002bbd30104a010000
630000002bbd30104a010000
630000002bbd30104a010000
000000637666610846800000
630000002bbd30104a010000
630000002bbd30104a010000
000000637666610846800000
630000002bbd30104a010000
000000637666610846800000
-
{e=>0,n=>-4,a=>-106,m=>2,d=>-4,j=>-1,l=>-3,c=>-1,k=>3,h=>2,b=>-4,g=>2,f=>-1,i=>2}
96ffffff3c71491f15010000
96ffffff3c71491f15010000
96ffffff3c71491f15010000
ffffff969e0e92ecaa000000
96ffffff3c71491f15010000
96ffffff3c71491f15010000
ffffff969e0e92ecaa000000
96ffffff3c71491f15010000
ffffff969e0e92ecaa000000
-
{e=>0,n=>1,a=>-37,m=>1,d=>1,j=>-3,l=>-4,c=>0,k=>-2,h=>0,b=>3,g=>-4,f=>-2,i=>-1}
dbffffff4360e2354c000000
dbffffff4360e2354c000000
dbffffff4360e2354c000000
ffffffdb608d07b884800000
dbffffff4360e2354c000000
dbffffff4360e2354c000000
ffffffdb608d07b884800000
dbffffff4360e2354c000000
ffffffdb608d07b884800000
-
{e=>-2,n=>-1,a=>21,m=>1,d=>-4,j=>-2,l=>0,c=>1,k=>-4,h=>-3,b=>1,g=>3,f=>-2,i=>-3}
1500000009edb526c8010000
1500000009edb526c8010000
1500000009edb526c8010000
00000015266cedd007800000
1500000009edb526c8010000
1500000009edb526c8010000
00000015266cedd007800000
1500000009edb526c8010000
00000015266cedd007800000
=
struct int_wrap {
  int a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
  int o;
};
-
{e=>-2,n=>-3,a=>77,m=>1,d=>0,j=>3,l=>-4,c=>1,k=>3,h=>-2,b=>-3,g=>0,f=>3,o=>-17,i=>2}
4d0000000d3c581b4c010000efffffff
4d0000000d3c581b4c010000efffffff
4d0000000d3c581b4c010000efffffff
0000004da466326c86800000ffffffef
4d0000000d3c581b4c010000efffffff
4d0000000d3c581b4c010000efffffff
0000004da466326c86800000ffffffef
4d0000000d3c581b4c010000efffffff
0000004da466326c86800000ffffffef
-
{e=>-1,n=>3,a=>113,m=>3,d=>3,j=>-1,l=>3,c=>3,k=>-3,h=>-4,b=>-4,g=>2,f=>-3,o=>72,i=>2}
71000000dc5e512fdb00000048000000
71000000dc5e512fdb00000048000000
71000000dc5e512fdb00000048000000
000000718dfaa2f46d80000000000048
71000000dc5e512fdb00000048000000
71000000dc5e512fdb00000048000000
000000718dfaa2f46d80000000000048
71000000dc5e512fdb00000048000000
000000718dfaa2f46d80000000000048
-
{e=>-4,n=>2,a=>0,m=>2,d=>1,j=>2,l=>-2,c=>2,k=>-1,h=>-1,b=>-2,g=>-3,f=>-4,o=>60,i=>2}
0000000056c85e3a960000003c000000
0000000056c85e3a960000003c000000
0000000056c85e3a960000003c000000
00000000c8c97a5cc90000000000003c
0000000056c85e3a960000003c000000
0000000056c85e3a960000003c000000
00000000c8c97a5cc90000000000003c
0000000056c85e3a960000003c000000
00000000c8c97a5cc90000000000003c
-
{e=>-1,n=>-3,a=>65,m=>2,d=>-2,j=>3,l=>2,c=>3,k=>0,h=>3,b=>-4,g=>0,f=>1,o=>-92,i=>0}
410000009c1f0c0352010000a4ffffff
410000009c1f0c0352010000a4ffffff
410000009c1f0c0352010000a4ffffff
000000418f7218604a800000ffffffa4
410000009c1f0c0352010000a4ffffff
410000009c1f0c0352010000a4ffffff
000000418f7218604a800000ffffffa4
410000009c1f0c0352010000a4ffffff
000000418f7218604a800000ffffffa4
-
{e=>1,n=>2,a=>64,m=>0,d=>-2,j=>2,l=>1,c=>-3,k=>0,h=>-1,b=>3,g=>2,f=>1,o=>-43,i=>-2}
40000000ab13dd0281000000d5ffffff
40000000ab13dd0281000000d5ffffff
40000000ab13dd0281000000d5ffffff
000000407712be4021000000ffffffd5
40000000ab13dd0281000000d5ffffff
40000000ab13dd0281000000d5ffffff
000000407712be4021000000ffffffd5
40000000ab13dd0281000000d5ffffff
000000407712be4021000000ffffffd5
=
struct int_wrap {
  long a;
  int b:3;
};
-
{a=>33,b=>-4}
2100000004000000
21000000000000000400000000000000
21000000000000000400000000000000
0000002180000000
2100000004000000
2100000004000000
00000000000000218000000000000000
2100000004000000
0000002180000000
-
{a=>122,b=>-4}
7a00000004000000
7a000000000000000400000000000000
7a000000000000000400000000000000
0000007a80000000
7a00000004000000
7a00000004000000
000000000000007a8000000000000000
7a00000004000000
0000007a80000000
-
{a=>107,b=>-3}
6b00000005000000
6b000000000000000500000000000000
6b000000000000000500000000000000
0000006ba0000000
6b00000005000000
6b00000005000000
000000000000006ba000000000000000
6b00000005000000
0000006ba0000000
-
{a=>17,b=>1}
1100000001000000
11000000000000000100000000000000
11000000000000000100000000000000
0000001120000000
1100000001000000
1100000001000000
00000000000000112000000000000000
1100000001000000
0000001120000000
-
{a=>-47,b=>2}
d1ffffff02000000
d1ffffffffffffff0200000000000000
d1ffffffffffffff0200000000000000
ffffffd140000000
d1ffffff02000000
d1ffffff02000000
ffffffffffffffd14000000000000000
d1ffffff02000000
ffffffd140000000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
};
-
{c=>-2,a=>-37,b=>1}
dbffffff31000000
dbffffffffffffff3100000000000000
dbffffffffffffff3100000000000000
ffffffdb38000000
dbffffff31000000
dbffffff31000000
ffffffffffffffdb3800000000000000
dbffffff31000000
ffffffdb38000000
-
{c=>-2,a=>-7,b=>1}
f9ffffff31000000
f9ffffffffffffff3100000000000000
f9ffffffffffffff3100000000000000
fffffff938000000
f9ffffff31000000
f9ffffff31000000
fffffffffffffff93800000000000000
f9ffffff31000000
fffffff938000000
-
{c=>3,a=>124,b=>0}
7c00000018000000
7c000000000000001800000000000000
7c000000000000001800000000000000
0000007c0c000000
7c00000018000000
7c00000018000000
000000000000007c0c00000000000000
7c00000018000000
0000007c0c000000
-
{c=>0,a=>-128,b=>-4}
80ffffff04000000
80ffffffffffffff0400000000000000
80ffffffffffffff0400000000000000
ffffff8080000000
80ffffff04000000
80ffffff04000000
ffffffffffffff808000000000000000
80ffffff04000000
ffffff8080000000
-
{c=>3,a=>5,b=>2}
050000001a000000
05000000000000001a00000000000000
05000000000000001a00000000000000
000000054c000000
050000001a000000
050000001a000000
00000000000000054c00000000000000
050000001a000000
000000054c000000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
};
-
{c=>3,a=>-33,b=>0,d=>-2}
dfffffff98010000
dfffffffffffffff9801000000000000
dfffffffffffffff9801000000000000
ffffffdf0f000000
dfffffff98010000
dfffffff98010000
ffffffffffffffdf0f00000000000000
dfffffff98010000
ffffffdf0f000000
-
{c=>1,a=>87,b=>1,d=>-3}
5700000049010000
57000000000000004901000000000000
57000000000000004901000000000000
0000005726800000
5700000049010000
5700000049010000
00000000000000572680000000000000
5700000049010000
0000005726800000
-
{c=>2,a=>-12,b=>0,d=>0}
f4ffffff10000000
f4ffffffffffffff1000000000000000
f4ffffffffffffff1000000000000000
fffffff408000000
f4ffffff10000000
f4ffffff10000000
fffffffffffffff40800000000000000
f4ffffff10000000
fffffff408000000
-
{c=>3,a=>-30,b=>-2,d=>3}
e2ffffffde000000
e2ffffffffffffffde00000000000000
e2ffffffffffffffde00000000000000
ffffffe2cd800000
e2ffffffde000000
e2ffffffde000000
ffffffffffffffe2cd80000000000000
e2ffffffde000000
ffffffe2cd800000
-
{c=>1,a=>81,b=>3,d=>2}
510000008b000000
51000000000000008b00000000000000
51000000000000008b00000000000000
0000005165000000
510000008b000000
510000008b000000
00000000000000516500000000000000
510000008b000000
0000005165000000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
};
-
{e=>2,c=>-1,a=>-61,b=>3,d=>2}
c3ffffffbb040000
c3ffffffffffffffbb04000000000000
c3ffffffffffffffbb04000000000000
ffffffc37d200000
c3ffffffbb040000
c3ffffffbb040000
ffffffffffffffc37d20000000000000
c3ffffffbb040000
ffffffc37d200000
-
{e=>-2,c=>-3,a=>86,b=>2,d=>-1}
56000000ea0d0000
5600000000000000ea0d000000000000
5600000000000000ea0d000000000000
0000005657e00000
56000000ea0d0000
56000000ea0d0000
000000000000005657e0000000000000
56000000ea0d0000
0000005657e00000
-
{e=>-2,c=>0,a=>126,b=>3,d=>-2}
7e000000830d0000
7e00000000000000830d000000000000
7e00000000000000830d000000000000
0000007e63600000
7e000000830d0000
7e000000830d0000
000000000000007e6360000000000000
7e000000830d0000
0000007e63600000
-
{e=>-4,c=>2,a=>-98,b=>-3,d=>-2}
9effffff95090000
9effffffffffffff9509000000000000
9effffffffffffff9509000000000000
ffffff9eab400000
9effffff95090000
9effffff95090000
ffffffffffffff9eab40000000000000
9effffff95090000
ffffff9eab400000
-
{e=>3,c=>3,a=>-97,b=>0,d=>3}
9fffffffd8060000
9fffffffffffffffd806000000000000
9fffffffffffffffd806000000000000
ffffff9f0db00000
9fffffffd8060000
9fffffffd8060000
ffffffffffffff9f0db0000000000000
9fffffffd8060000
ffffff9f0db00000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
};
-
{e=>-4,c=>-1,a=>-9,b=>-1,d=>1,f=>-2}
f7ffffff7f680000
f7ffffffffffffff7f68000000000000
f7ffffffffffffff7f68000000000000
fffffff7fccc0000
f7ffffff7f680000
f7ffffff7f680000
fffffffffffffff7fccc000000000000
f7ffffff7f680000
fffffff7fccc0000
-
{e=>1,c=>-4,a=>112,b=>-4,d=>1,f=>-3}
7000000064520000
70000000000000006452000000000000
70000000000000006452000000000000
00000070909a0000
7000000064520000
7000000064520000
0000000000000070909a000000000000
7000000064520000
00000070909a0000
-
{e=>3,c=>-1,a=>-116,b=>2,d=>2,f=>-4}
8cffffffba460000
8cffffffffffffffba46000000000000
8cffffffffffffffba46000000000000
ffffff8c5d380000
8cffffffba460000
8cffffffba460000
ffffffffffffff8c5d38000000000000
8cffffffba460000
ffffff8c5d380000
-
{e=>-4,c=>-3,a=>-4,b=>-4,d=>2,f=>1}
fcffffffac180000
fcffffffffffffffac18000000000000
fcffffffffffffffac18000000000000
fffffffc95420000
fcffffffac180000
fcffffffac180000
fffffffffffffffc9542000000000000
fcffffffac180000
fffffffc95420000
-
{e=>-2,c=>-3,a=>-52,b=>3,d=>3,f=>0}
ccffffffeb0c0000
ccffffffffffffffeb0c000000000000
ccffffffffffffffeb0c000000000000
ffffffcc75e00000
ccffffffeb0c0000
ccffffffeb0c0000
ffffffffffffffcc75e0000000000000
ccffffffeb0c0000
ffffffcc75e00000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
};
-
{e=>-2,c=>0,a=>92,g=>-1,b=>-2,d=>-2,f=>-2}
5c00000086ed0300
5c0000000000000086ed030000000000
5c0000000000000086ed030000000000
0000005cc36dc000
5c00000086ed0300
5c00000086ed0300
000000000000005cc36dc00000000000
5c00000086ed0300
0000005cc36dc000
-
{e=>1,c=>-1,a=>-32,g=>-4,b=>3,d=>0,f=>-1}
e0ffffff3b720200
e0ffffffffffffff3b72020000000000
e0ffffffffffffff3b72020000000000
ffffffe07c1f0000
e0ffffff3b720200
e0ffffff3b720200
ffffffffffffffe07c1f000000000000
e0ffffff3b720200
ffffffe07c1f0000
-
{e=>-4,c=>3,a=>17,g=>-4,b=>1,d=>-4,f=>2}
1100000019290200
11000000000000001929020000000000
11000000000000001929020000000000
000000112e450000
1100000019290200
1100000019290200
00000000000000112e45000000000000
1100000019290200
000000112e450000
-
{e=>1,c=>-4,a=>-113,g=>-1,b=>1,d=>-4,f=>-4}
8fffffff21c30300
8fffffffffffffff21c3030000000000
8fffffffffffffff21c3030000000000
ffffff8f3219c000
8fffffff21c30300
8fffffff21c30300
ffffffffffffff8f3219c00000000000
8fffffff21c30300
ffffff8f3219c000
-
{e=>0,c=>1,a=>23,g=>2,b=>3,d=>-3,f=>-3}
170000004b510100
17000000000000004b51010000000000
17000000000000004b51010000000000
00000017668a8000
170000004b510100
170000004b510100
0000000000000017668a800000000000
170000004b510100
00000017668a8000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
};
-
{e=>0,a=>76,d=>2,c=>-1,h=>-3,b=>3,g=>-3,f=>0}
4c000000bb801600
4c00000000000000bb80160000000000
4c00000000000000bb80160000000000
0000004c7d016800
4c000000bb801600
4c000000bb801600
000000000000004c7d01680000000000
4c000000bb801600
0000004c7d016800
-
{e=>3,a=>39,d=>-4,c=>-3,h=>1,b=>-2,g=>-2,f=>1}
270000002e170700
27000000000000002e17070000000000
27000000000000002e17070000000000
00000027d6338800
270000002e170700
270000002e170700
0000000000000027d633880000000000
270000002e170700
00000027d6338800
-
{e=>2,a=>108,d=>2,c=>1,h=>3,b=>1,g=>2,f=>-2}
6c00000089640d00
6c0000000000000089640d0000000000
6c0000000000000089640d0000000000
0000006c252c9800
6c00000089640d00
6c00000089640d00
000000000000006c252c980000000000
6c00000089640d00
0000006c252c9800
-
{e=>-2,a=>52,d=>-2,c=>-3,h=>-2,b=>1,g=>-4,f=>-2}
34000000a96d1a00
3400000000000000a96d1a0000000000
3400000000000000a96d1a0000000000
00000034376d3000
34000000a96d1a00
34000000a96d1a00
0000000000000034376d300000000000
34000000a96d1a00
00000034376d3000
-
{e=>-3,a=>-110,d=>-4,c=>-4,h=>2,b=>-1,g=>1,f=>2}
92ffffff27ab0800
92ffffffffffffff27ab080000000000
92ffffffffffffff27ab080000000000
ffffff92f2545000
92ffffff27ab0800
92ffffff27ab0800
ffffffffffffff92f254500000000000
92ffffff27ab0800
ffffff92f2545000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
};
-
{e=>2,a=>-27,d=>0,c=>0,h=>-3,b=>2,g=>-3,f=>-4,i=>-4}
e5ffffff02c49600
e5ffffffffffffff02c4960000000000
e5ffffffffffffff02c4960000000000
ffffffe540296c00
e5ffffff02c49600
e5ffffff02c49600
ffffffffffffffe540296c0000000000
e5ffffff02c49600
ffffffe540296c00
-
{e=>-1,a=>109,d=>2,c=>1,h=>-2,b=>1,g=>0,f=>-3,i=>-3}
6d000000895eb800
6d00000000000000895eb80000000000
6d00000000000000895eb80000000000
0000006d257a3500
6d000000895eb800
6d000000895eb800
000000000000006d257a350000000000
6d000000895eb800
0000006d257a3500
-
{e=>-3,a=>-65,d=>3,c=>2,h=>3,b=>0,g=>2,f=>-4,i=>-2}
bfffffffd04acd00
bfffffffffffffffd04acd0000000000
bfffffffffffffffd04acd0000000000
ffffffbf09d89e00
bfffffffd04acd00
bfffffffd04acd00
ffffffffffffffbf09d89e0000000000
bfffffffd04acd00
ffffffbf09d89e00
-
{e=>3,a=>-118,d=>-1,c=>1,h=>-1,b=>0,g=>3,f=>2,i=>-4}
8affffffc8a79d00
8affffffffffffffc8a79d0000000000
8affffffffffffffc8a79d0000000000
ffffff8a07b4fc00
8affffffc8a79d00
8affffffc8a79d00
ffffffffffffff8a07b4fc0000000000
8affffffc8a79d00
ffffff8a07b4fc00
-
{e=>-4,a=>77,d=>-3,c=>3,h=>-1,b=>-2,g=>-1,f=>-3,i=>-3}
4d0000005ed9bf00
4d000000000000005ed9bf0000000000
4d000000000000005ed9bf0000000000
0000004dcecbfd00
4d0000005ed9bf00
4d0000005ed9bf00
000000000000004dcecbfd0000000000
4d0000005ed9bf00
0000004dcecbfd00
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
};
-
{e=>-3,a=>60,d=>2,j=>2,c=>2,h=>-3,b=>3,g=>-1,f=>-2,i=>-1}
3c00000093eaf702
3c0000000000000093eaf70200000000
3c0000000000000093eaf70200000000
0000003c695def40
3c00000093eaf702
3c00000093eaf702
000000000000003c695def4000000000
3c00000093eaf702
0000003c695def40
-
{e=>-3,a=>-119,d=>0,j=>-2,c=>3,h=>-3,b=>3,g=>-3,f=>-3,i=>-3}
89ffffff1bdab606
89ffffffffffffff1bdab60600000000
89ffffffffffffff1bdab60600000000
ffffff896c5b6dc0
89ffffff1bdab606
89ffffff1bdab606
ffffffffffffff896c5b6dc000000000
89ffffff1bdab606
ffffff896c5b6dc0
-
{e=>-4,a=>94,d=>2,j=>2,c=>1,h=>3,b=>1,g=>1,f=>3,i=>3}
5e00000089b86c02
5e0000000000000089b86c0200000000
5e0000000000000089b86c0200000000
0000005e25465b40
5e00000089b86c02
5e00000089b86c02
000000000000005e25465b4000000000
5e00000089b86c02
0000005e25465b40
-
{e=>3,a=>116,d=>1,j=>2,c=>-4,h=>-3,b=>0,g=>3,f=>2,i=>-4}
7400000060a69502
740000000000000060a6950200000000
740000000000000060a6950200000000
0000007410b4ec40
7400000060a69502
7400000060a69502
000000000000007410b4ec4000000000
7400000060a69502
0000007410b4ec40
-
{e=>1,a=>42,d=>-4,j=>-4,c=>-2,h=>-2,b=>2,g=>-3,f=>-2,i=>-3}
2a00000032e3ba04
2a0000000000000032e3ba0400000000
2a0000000000000032e3ba0400000000
0000002a5a1d7580
2a00000032e3ba04
2a00000032e3ba04
000000000000002a5a1d758000000000
2a00000032e3ba04
0000002a5a1d7580
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
};
-
{e=>0,a=>15,d=>3,j=>2,c=>0,k=>3,h=>-4,b=>3,g=>-1,f=>-4,i=>-4}
0f000000c3c0931a
0f00000000000000c3c0931a00000000
0f00000000000000c3c0931a00000000
0000000f6189e44c
0f000000c3c0931a
0f000000c3c0931a
000000000000000f6189e44c00000000
0f000000c3c0931a
0000000f6189e44c
-
{e=>-2,a=>-58,d=>-3,j=>-1,c=>-1,k=>-2,h=>1,b=>-2,g=>3,f=>-4,i=>-3}
c6ffffff7ecda537
c6ffffffffffffff7ecda53700000000
c6ffffffffffffff7ecda53700000000
ffffffc6dee8cdf8
c6ffffff7ecda537
c6ffffff7ecda537
ffffffffffffffc6dee8cdf800000000
c6ffffff7ecda537
ffffffc6dee8cdf8
-
{e=>0,a=>3,d=>-4,j=>-4,c=>2,k=>1,h=>3,b=>0,g=>-4,f=>3,i=>-4}
0300000010318e0c
030000000000000010318e0c00000000
030000000000000010318e0c00000000
000000030a071c84
0300000010318e0c
0300000010318e0c
00000000000000030a071c8400000000
0300000010318e0c
000000030a071c84
-
{e=>-2,a=>9,d=>3,j=>3,c=>-3,k=>-2,h=>-1,b=>-1,g=>1,f=>-4,i=>3}
09000000efcc7c33
0900000000000000efcc7c3300000000
0900000000000000efcc7c3300000000
00000009f5e87b78
09000000efcc7c33
09000000efcc7c33
0000000000000009f5e87b7800000000
09000000efcc7c33
00000009f5e87b78
-
{e=>-2,a=>41,d=>2,j=>-1,c=>-3,k=>-2,h=>-4,b=>-2,g=>-1,f=>2,i=>3}
29000000aeac7337
2900000000000000aeac733700000000
2900000000000000aeac733700000000
00000029d565e3f8
29000000aeac7337
29000000aeac7337
0000000000000029d565e3f800000000
29000000aeac7337
00000029d565e3f8
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
};
-
{e=>-3,a=>-21,d=>3,j=>0,l=>-3,c=>-3,k=>3,h=>0,b=>2,g=>-4,f=>-3,i=>-3}
ebffffffea5aa21805000000
ebffffffffffffffea5aa21805000000
ebffffffffffffffea5aa21805000000
ffffffeb55db050ca0000000
ebffffffea5aa21805000000
ebffffffea5aa21805000000
ffffffffffffffeb55db050ca0000000
ebffffffea5aa21805000000
ffffffeb55db050ca0000000
-
{e=>0,a=>26,d=>3,j=>3,l=>-4,c=>0,k=>2,h=>-1,b=>-1,g=>-2,f=>0,i=>-4}
1a000000c7009f1304000000
1a00000000000000c7009f1304000000
1a00000000000000c7009f1304000000
0000001ae181bc6880000000
1a000000c7009f1304000000
1a000000c7009f1304000000
000000000000001ae181bc6880000000
1a000000c7009f1304000000
0000001ae181bc6880000000
-
{e=>-3,a=>-32,d=>-2,j=>0,l=>-4,c=>-3,k=>-2,h=>2,b=>-1,g=>1,f=>2,i=>-3}
e0ffffffafaba83004000000
e0ffffffffffffffafaba83004000000
e0ffffffffffffffafaba83004000000
ffffffe0f754551880000000
e0ffffffafaba83004000000
e0ffffffafaba83004000000
ffffffffffffffe0f754551880000000
e0ffffffafaba83004000000
ffffffe0f754551880000000
-
{e=>2,a=>-37,d=>-2,j=>-3,l=>-4,c=>1,k=>1,h=>-2,b=>2,g=>3,f=>0,i=>3}
dbffffff8a85790d04000000
dbffffffffffffff8a85790d04000000
dbffffffffffffff8a85790d04000000
ffffffdb4720f3a480000000
dbffffff8a85790d04000000
dbffffff8a85790d04000000
ffffffffffffffdb4720f3a480000000
dbffffff8a85790d04000000
ffffffdb4720f3a480000000
-
{e=>1,a=>-116,d=>-2,j=>0,l=>2,c=>1,k=>-4,h=>0,b=>2,g=>-3,f=>-1,i=>-4}
8cffffff8af3822002000000
8cffffffffffffff8af3822002000000
8cffffffffffffff8af3822002000000
ffffff8c471f441040000000
8cffffff8af3822002000000
8cffffff8af3822002000000
ffffffffffffff8c471f441040000000
8cffffff8af3822002000000
ffffff8c471f441040000000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
};
-
{e=>-1,a=>-6,m=>-3,d=>0,j=>3,l=>1,c=>-4,k=>1,h=>-4,b=>1,g=>2,f=>1,i=>2}
faffffff211e510b29000000
faffffffffffffff211e510b29000000
faffffffffffffff211e510b29000000
fffffffa3072a26434000000
faffffff211e510b29000000
faffffff211e510b29000000
fffffffffffffffa3072a26434000000
faffffff211e510b29000000
fffffffa3072a26434000000
-
{e=>2,a=>-118,m=>-4,d=>-1,j=>-2,l=>2,c=>3,k=>-3,h=>3,b=>0,g=>-3,f=>-4,i=>3}
8affffffd8c56e2e22000000
8affffffffffffffd8c56e2e22000000
8affffffffffffffd8c56e2e22000000
ffffff8a0fa95bd450000000
8affffffd8c56e2e22000000
8affffffd8c56e2e22000000
ffffffffffffff8a0fa95bd450000000
8affffffd8c56e2e22000000
ffffff8a0fa95bd450000000
-
{e=>3,a=>-56,m=>1,d=>3,j=>0,l=>3,c=>2,k=>-2,h=>1,b=>2,g=>0,f=>-3,i=>-2}
c8ffffffd256c4300b000000
c8ffffffffffffffd256c4300b000000
c8ffffffffffffffd256c4300b000000
ffffffc849ba0e1864000000
c8ffffffd256c4300b000000
c8ffffffd256c4300b000000
ffffffffffffffc849ba0e1864000000
c8ffffffd256c4300b000000
ffffffc849ba0e1864000000
-
{e=>1,a=>-55,m=>-4,d=>0,j=>-1,l=>3,c=>-3,k=>-4,h=>3,b=>-4,g=>2,f=>-2,i=>-4}
c9ffffff2c628d2723000000
c9ffffffffffffff2c628d2723000000
c9ffffffffffffff2c628d2723000000
ffffffc9941c9cf070000000
c9ffffff2c628d2723000000
c9ffffff2c628d2723000000
ffffffffffffffc9941c9cf070000000
c9ffffff2c628d2723000000
ffffffc9941c9cf070000000
-
{e=>-3,a=>-107,m=>0,d=>-1,j=>2,l=>-3,c=>-2,k=>-2,h=>-2,b=>-4,g=>2,f=>1,i=>-3}
95fffffff41bb93205000000
95fffffffffffffff41bb93205000000
95fffffffffffffff41bb93205000000
ffffff959bd2b558a0000000
95fffffff41bb93205000000
95fffffff41bb93205000000
ffffffffffffff959bd2b558a0000000
95fffffff41bb93205000000
ffffff959bd2b558a0000000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
};
-
{e=>-1,n=>-1,a=>-103,m=>-3,d=>-3,j=>2,l=>-4,c=>-3,k=>3,h=>2,b=>3,g=>-4,f=>1,i=>1}
99ffffff6b1f2a1aec010000
99ffffffffffffff6b1f2a1aec010000
99ffffffffffffff6b1f2a1aec010000
ffffff9976f3114c97800000
99ffffff6b1f2a1aec010000
99ffffff6b1f2a1aec010000
ffffffffffffff9976f3114c97800000
99ffffff6b1f2a1aec010000
ffffff9976f3114c97800000
-
{e=>1,n=>-1,a=>-117,m=>3,d=>-3,j=>3,l=>2,c=>-4,k=>2,h=>-1,b=>-3,g=>-1,f=>0,i=>-1}
8bffffff6583ff13da010000
8bffffffffffffff6583ff13da010000
8bffffffffffffff6583ff13da010000
ffffff8bb291ff684f800000
8bffffff6583ff13da010000
8bffffff6583ff13da010000
ffffffffffffff8bb291ff684f800000
8bffffff6583ff13da010000
ffffff8bb291ff684f800000
-
{e=>1,n=>-3,a=>28,m=>-1,d=>-4,j=>2,l=>-4,c=>3,k=>-4,h=>-2,b=>0,g=>2,f=>-4,i=>1}
1c000000184339227c010000
1c00000000000000184339227c010000
1c00000000000000184339227c010000
0000001c0e18b1509e800000
1c000000184339227c010000
1c000000184339227c010000
000000000000001c0e18b1509e800000
1c000000184339227c010000
0000001c0e18b1509e800000
-
{e=>-4,n=>3,a=>29,m=>-4,d=>2,j=>-2,l=>-4,c=>-2,k=>-2,h=>2,b=>-2,g=>-2,f=>-2,i=>-2}
1d000000b668cb36e4000000
1d00000000000000b668cb36e4000000
1d00000000000000b668cb36e4000000
0000001dd94d96d891800000
1d000000b668cb36e4000000
1d000000b668cb36e4000000
000000000000001dd94d96d891800000
1d000000b668cb36e4000000
0000001dd94d96d891800000
-
{e=>3,n=>-1,a=>-93,m=>-1,d=>3,j=>3,l=>-2,c=>2,k=>2,h=>-2,b=>1,g=>0,f=>3,i=>2}
a3ffffffd1365813fe010000
a3ffffffffffffffd1365813fe010000
a3ffffffffffffffd1365813fe010000
ffffffa329b63268df800000
a3ffffffd1365813fe010000
a3ffffffd1365813fe010000
ffffffffffffffa329b63268df800000
a3ffffffd1365813fe010000
ffffffa329b63268df800000
=
struct int_wrap {
  long a;
  int b:3;
  int c:3;
  int d:3;
  int e:3;
  int f:3;
  int g:3;
  int h:3;
  int i:3;
  int j:3;
  int k:3;
  int l:3;
  int m:3;
  int n:3;
  int o;
};
-
{e=>-3,n=>1,a=>-24,m=>2,d=>-2,j=>-2,l=>-4,c=>-1,k=>0,h=>-4,b=>-1,g=>-4,f=>0,o=>10,i=>1}
e8ffffffbf0b3206540000000a000000
e8ffffffffffffffbf0b3206540000000a00000000000000
e8ffffffffffffffbf0b3206540000000a00000000000000
ffffffe8ff5121c0888000000000000a
e8ffffffbf0b3206540000000a000000
e8ffffffbf0b3206540000000a000000
ffffffffffffffe8ff5121c0888000000000000a00000000
e8ffffffbf0b3206540000000a000000
ffffffe8ff5121c0888000000000000a
-
{e=>0,n=>3,a=>91,m=>3,d=>1,j=>-2,l=>-1,c=>-3,k=>0,h=>1,b=>3,g=>3,f=>0,o=>0,i=>0}
5b0000006b800506df00000000000000
5b000000000000006b800506df0000000000000000000000
5b000000000000006b800506df0000000000000000000000
0000005b7480c8c0ed80000000000000
5b0000006b800506df00000000000000
5b0000006b800506df00000000000000
000000000000005b7480c8c0ed8000000000000000000000
5b0000006b800506df00000000000000
0000005b7480c8c0ed80000000000000
-
{e=>-4,n=>-4,a=>-91,m=>0,d=>1,j=>0,l=>3,c=>1,k=>-4,h=>0,b=>3,g=>1,f=>-2,o=>81,i=>-3}
a5ffffff4be8a0200301000051000000
a5ffffffffffffff4be8a020030100005100000000000000
a5ffffffffffffff4be8a020030100005100000000000000
ffffffa564cc45106200000000000051
a5ffffff4be8a0200301000051000000
a5ffffff4be8a0200301000051000000
ffffffffffffffa564cc4510620000000000005100000000
a5ffffff4be8a0200301000051000000
ffffffa564cc45106200000000000051
-
{e=>0,n=>-3,a=>-22,m=>-1,d=>-4,j=>-1,l=>0,c=>3,k=>-2,h=>3,b=>-3,g=>-1,f=>-3,o=>40,i=>2}
eaffffff1dd14f377801000028000000
eaffffffffffffff1dd14f37780100002800000000000000
eaffffffffffffff1dd14f37780100002800000000000000
ffffffeaae0bdaf81e80000000000028
eaffffff1dd14f377801000028000000
eaffffff1dd14f377801000028000000
ffffffffffffffeaae0bdaf81e8000000000002800000000
eaffffff1dd14f377801000028000000
ffffffeaae0bdaf81e80000000000028
-
{e=>-2,n=>1,a=>-71,m=>2,d=>2,j=>-3,l=>-4,c=>0,k=>-3,h=>2,b=>-2,g=>2,f=>0,o=>-119,i=>-2}
b9ffffff860cc92d5400000089ffffff
b9ffffffffffffff860cc92d5400000089ffffff00000000
b9ffffffffffffff860cc92d5400000089ffffff00000000
ffffffb9c16096b488800000ffffff89
b9ffffff860cc92d5400000089ffffff
b9ffffff860cc92d5400000089ffffff
ffffffffffffffb9c16096b488800000ffffff8900000000
b9ffffff860cc92d5400000089ffffff
ffffffb9c16096b488800000ffffff89
=
struct umixed3 {
  unsigned char  a:3;
};
-
{a=>7}
07
07
07
e0
07000000
07
e0
07
e0
-
{a=>4}
04
04
04
80
04000000
04
80
04
80
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
-
{a=>2}
02
02
02
40
02000000
02
40
02
40
-
{a=>5}
05
05
05
a0
05000000
05
a0
05
a0
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
};
-
{a=>6,b=>0}
06
06
06
c0
06000000
06
c0
06
c0
-
{a=>0,b=>4}
20
20
20
10
20000000
20
10
20
10
-
{a=>2,b=>1}
0a
0a
0a
44
0a000000
0a
44
0a
44
-
{a=>7,b=>3}
1f
1f
1f
ec
1f000000
1f
ec
1f
ec
-
{a=>2,b=>3}
1a
1a
1a
4c
1a000000
1a
4c
1a
4c
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned int   c:3;
};
-
{c=>0,a=>7,b=>5}
2f000000
2f000000
2f000000
f4000000
2f000000
2f000000
f4000000
2f000000
f4000000
-
{c=>2,a=>6,b=>7}
be000000
be000000
be000000
dd000000
be000000
be000000
dd000000
be000000
dd000000
-
{c=>2,a=>7,b=>2}
97000000
97000000
97000000
e9000000
97000000
97000000
e9000000
97000000
e9000000
-
{c=>7,a=>1,b=>3}
d9010000
d9010000
d9010000
2f800000
d9010000
d9010000
2f800000
d9010000
2f800000
-
{c=>5,a=>3,b=>4}
63010000
63010000
63010000
72800000
63010000
63010000
72800000
63010000
72800000
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned int   c:3;
  unsigned char  d:3;
};
-
{c=>6,a=>2,b=>1,d=>2}
8a050000
8a050000
8a050000
47200000
8a050000
8a050000
47200000
8a050000
47200000
-
{c=>5,a=>6,b=>1,d=>3}
4e070000
4e070000
4e070000
c6b00000
4e070000
4e070000
c6b00000
4e070000
c6b00000
-
{c=>4,a=>6,b=>1,d=>0}
0e010000
0e010000
0e010000
c6000000
0e010000
0e010000
c6000000
0e010000
c6000000
-
{c=>0,a=>1,b=>5,d=>6}
290c0000
290c0000
290c0000
34600000
290c0000
290c0000
34600000
290c0000
34600000
-
{c=>7,a=>6,b=>2,d=>2}
d6050000
d6050000
d6050000
cba00000
d6050000
d6050000
cba00000
d6050000
cba00000
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned int   c:3;
  unsigned char  d:3;
  unsigned short e:3;
};
-
{e=>3,c=>6,a=>3,b=>0,d=>1}
83330000
83330000
83330000
63160000
83330000
83330000
63160000
83330000
63160000
-
{e=>6,c=>0,a=>3,b=>1,d=>5}
0b6a0000
0b6a0000
0b6a0000
645c0000
0b6a0000
0b6a0000
645c0000
0b6a0000
645c0000
-
{e=>7,c=>2,a=>2,b=>6,d=>5}
b27a0000
b27a0000
b27a0000
595e0000
b27a0000
b27a0000
595e0000
b27a0000
595e0000
-
{e=>6,c=>0,a=>3,b=>3,d=>3}
1b660000
1b660000
1b660000
6c3c0000
1b660000
1b660000
6c3c0000
1b660000
6c3c0000
-
{e=>6,c=>7,a=>0,b=>3,d=>3}
d8670000
d8670000
d8670000
0fbc0000
d8670000
d8670000
0fbc0000
d8670000
0fbc0000
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned int   c:3;
  unsigned char  d:3;
  unsigned short e:3;
  unsigned char  f:3;
};
-
{e=>3,c=>4,a=>4,b=>7,d=>6,f=>2}
3c3d0200
3c3d0200
3c3d0200
9e664000
3c3d0200
3c3d0200
9e664000
3c3d0200
9e664000
-
{e=>5,c=>4,a=>2,b=>7,d=>0,f=>6}
3a510600
3a510600
3a510600
5e0ac000
3a510600
3a510600
5e0ac000
3a510600
5e0ac000
-
{e=>7,c=>6,a=>0,b=>4,d=>1,f=>6}
a0730600
a0730600
a0730600
131ec000
a0730600
a0730600
131ec000
a0730600
131ec000
-
{e=>4,c=>6,a=>1,b=>0,d=>1,f=>3}
81430300
81430300
81430300
23186000
81430300
81430300
23186000
81430300
23186000
-
{e=>6,c=>4,a=>6,b=>6,d=>6,f=>0}
366d0000
366d0000
366d0000
da6c0000
366d0000
366d0000
da6c0000
366d0000
da6c0000
=
struct umixed3 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned int   c:3;
  unsigned char  d:3;
  unsigned short e:3;
  unsigned char  f:3;
  unsigned long  g;
};
-
{e=>4,c=>5,a=>4,g=>216,b=>7,d=>5,f=>4}
7c4b0400d8000000
7c4b040000000000d800000000000000
7c4b040000000000d800000000000000
9ed88000000000d8
7c4b0400d8000000
7c4b0400d8000000
9ed880000000000000000000000000d8
7c4b0400d8000000
9ed88000000000d8
-
{e=>0,c=>0,a=>7,g=>119,b=>7,d=>3,f=>5}
3f06050077000000
3f060500000000007700000000000000
3f060500000000007700000000000000
fc30a00000000077
3f06050077000000
3f06050077000000
fc30a000000000000000000000000077
3f06050077000000
fc30a00000000077
-
{e=>4,c=>0,a=>7,g=>69,b=>6,d=>3,f=>3}
3746030045000000
37460300000000004500000000000000
37460300000000004500000000000000
f838600000000045
3746030045000000
3746030045000000
f8386000000000000000000000000045
3746030045000000
f838600000000045
-
{e=>1,c=>0,a=>5,g=>247,b=>4,d=>1,f=>7}
25120700f7000000
2512070000000000f700000000000000
2512070000000000f700000000000000
b012e000000000f7
25120700f7000000
25120700f7000000
b012e0000000000000000000000000f7
25120700f7000000
b012e000000000f7
-
{e=>4,c=>5,a=>4,g=>112,b=>1,d=>3,f=>4}
4c47040070000000
4c470400000000007000000000000000
4c470400000000007000000000000000
86b8800000000070
4c47040070000000
4c47040070000000
86b88000000000000000000000000070
4c47040070000000
86b8800000000070
=
struct umixed3 {
  char a;
  unsigned char  b:3;
};
-
{a=>-63,b=>6}
c106
c106
c106
c1c0
c1060000
c106
c1c0
c106
c1c0
-
{a=>-85,b=>7}
ab07
ab07
ab07
abe0
ab070000
ab07
abe0
ab07
abe0
-
{a=>52,b=>0}
3400
3400
3400
3400
34000000
3400
3400
3400
3400
-
{a=>-89,b=>2}
a702
a702
a702
a740
a7020000
a702
a740
a702
a740
-
{a=>-62,b=>7}
c207
c207
c207
c2e0
c2070000
c207
c2e0
c207
c2e0
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>1,a=>77,b=>0}
4d08
4d08
4d08
4d04
4d080000
4d08
4d04
4d08
4d04
-
{c=>7,a=>73,b=>2}
493a
493a
493a
495c
493a0000
493a
495c
493a
495c
-
{c=>5,a=>116,b=>5}
742d
742d
742d
74b4
742d0000
742d
74b4
742d
74b4
-
{c=>7,a=>-44,b=>1}
d439
d439
d439
d43c
d4390000
d439
d43c
d439
d43c
-
{c=>7,a=>-66,b=>7}
be3f
be3f
be3f
befc
be3f0000
be3f
befc
be3f
befc
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
};
-
{c=>0,a=>-16,b=>5,d=>5}
f0450100
f0450100
f0450100
f0a28000
f0450100
f0450100
f0a28000
f0450100
f0a28000
-
{c=>0,a=>-4,b=>7,d=>6}
fc870100
fc870100
fc870100
fce30000
fc870100
fc870100
fce30000
fc870100
fce30000
-
{c=>5,a=>-11,b=>0,d=>2}
f5a80000
f5a80000
f5a80000
f5150000
f5a80000
f5a80000
f5150000
f5a80000
f5150000
-
{c=>6,a=>-39,b=>1,d=>0}
d9310000
d9310000
d9310000
d9380000
d9310000
d9310000
d9380000
d9310000
d9380000
-
{c=>7,a=>78,b=>1,d=>0}
4e390000
4e390000
4e390000
4e3c0000
4e390000
4e390000
4e3c0000
4e390000
4e3c0000
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
};
-
{e=>2,c=>6,a=>28,b=>6,d=>7}
1cf60500
1cf60500
1cf60500
1cdba000
1cf60500
1cf60500
1cdba000
1cf60500
1cdba000
-
{e=>0,c=>6,a=>-11,b=>2,d=>3}
f5f20000
f5f20000
f5f20000
f5598000
f5f20000
f5f20000
f5598000
f5f20000
f5598000
-
{e=>5,c=>7,a=>27,b=>0,d=>1}
1b780a00
1b780a00
1b780a00
1b1cd000
1b780a00
1b780a00
1b1cd000
1b780a00
1b1cd000
-
{e=>2,c=>5,a=>1,b=>0,d=>7}
01e80500
01e80500
01e80500
0117a000
01e80500
01e80500
0117a000
01e80500
0117a000
-
{e=>7,c=>1,a=>79,b=>3,d=>7}
4fcb0f00
4fcb0f00
4fcb0f00
4f67f000
4fcb0f00
4fcb0f00
4f67f000
4fcb0f00
4f67f000
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
};
-
{e=>1,c=>7,a=>43,b=>0,d=>7,f=>3}
2bf83300
2bf83300
2bf83300
2b1f9600
2bf83300
2bf83300
2b1f9600
2bf83300
2b1f9600
-
{e=>3,c=>7,a=>-115,b=>7,d=>5,f=>4}
8d7f4700
8d7f4700
8d7f4700
8dfeb800
8d7f4700
8d7f4700
8dfeb800
8d7f4700
8dfeb800
-
{e=>4,c=>7,a=>86,b=>7,d=>6,f=>6}
56bf6900
56bf6900
56bf6900
56ff4c00
56bf6900
56bf6900
56ff4c00
56bf6900
56ff4c00
-
{e=>1,c=>0,a=>-25,b=>3,d=>2,f=>1}
e7831200
e7831200
e7831200
e7611200
e7831200
e7831200
e7611200
e7831200
e7611200
-
{e=>7,c=>7,a=>19,b=>4,d=>7,f=>0}
13fc0f00
13fc0f00
13fc0f00
139ff000
13fc0f00
13fc0f00
139ff000
13fc0f00
139ff000
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
};
-
{e=>7,c=>3,a=>-86,g=>1,b=>7,d=>6,f=>1}
aa9f1f01
aa9f1f01
aa9f1f01
aaef7220
aa9f1f01
aa9f1f01
aaef7220
aa9f1f01
aaef7220
-
{e=>1,c=>6,a=>18,g=>4,b=>6,d=>5,f=>5}
12765304
12765304
12765304
12da9a80
12765304
12765304
12da9a80
12765304
12da9a80
-
{e=>0,c=>5,a=>6,g=>2,b=>6,d=>1,f=>0}
066e0002
066e0002
066e0002
06d48040
066e0002
066e0002
06d48040
066e0002
06d48040
-
{e=>0,c=>2,a=>2,g=>1,b=>5,d=>3,f=>4}
02d54001
02d54001
02d54001
02a98820
02d54001
02d54001
02a98820
02d54001
02a98820
-
{e=>4,c=>6,a=>110,g=>5,b=>6,d=>3,f=>1}
6ef61805
6ef61805
6ef61805
6ed9c2a0
6ef61805
6ef61805
6ed9c2a0
6ef61805
6ed9c2a0
=
struct umixed3 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
  unsigned long  h;
};
-
{e=>7,a=>-103,d=>2,c=>7,h=>28,b=>4,g=>0,f=>0}
99bc0e001c000000
99bc0e00000000001c00000000000000
99bc0e00000000001c00000000000000
999d70000000001c
99bc0e001c000000
99bc0e001c000000
999d700000000000000000000000001c
99bc0e001c000000
999d70000000001c
-
{e=>1,a=>-118,d=>7,c=>2,h=>87,b=>6,g=>2,f=>7}
8ad6730257000000
8ad67302000000005700000000000000
8ad67302000000005700000000000000
8acb9e4000000057
8ad6730257000000
8ad6730257000000
8acb9e40000000000000000000000057
8ad6730257000000
8acb9e4000000057
-
{e=>0,a=>93,d=>0,c=>4,h=>190,b=>4,g=>2,f=>4}
5d244002be000000
5d24400200000000be00000000000000
5d24400200000000be00000000000000
5d900840000000be
5d244002be000000
5d244002be000000
5d9008400000000000000000000000be
5d244002be000000
5d900840000000be
-
{e=>4,a=>119,d=>3,c=>2,h=>230,b=>0,g=>6,f=>3}
77d03806e6000000
77d0380600000000e600000000000000
77d0380600000000e600000000000000
7709c6c0000000e6
77d03806e6000000
77d03806e6000000
7709c6c00000000000000000000000e6
77d03806e6000000
7709c6c0000000e6
-
{e=>5,a=>-101,d=>5,c=>7,h=>52,b=>3,g=>7,f=>4}
9b7b4b0734000000
9b7b4b07000000003400000000000000
9b7b4b07000000003400000000000000
9b7ed8e000000034
9b7b4b0734000000
9b7b4b0734000000
9b7ed8e0000000000000000000000034
9b7b4b0734000000
9b7ed8e000000034
=
struct umixed3 {
  short a;
  unsigned char  b:3;
};
-
{a=>117,b=>6}
75000600
75000600
75000600
0075c000
75000600
75000600
0075c000
75000600
0075c000
-
{a=>27,b=>7}
1b000700
1b000700
1b000700
001be000
1b000700
1b000700
001be000
1b000700
001be000
-
{a=>-51,b=>0}
cdff0000
cdff0000
cdff0000
ffcd0000
cdff0000
cdff0000
ffcd0000
cdff0000
ffcd0000
-
{a=>-8,b=>4}
f8ff0400
f8ff0400
f8ff0400
fff88000
f8ff0400
f8ff0400
fff88000
f8ff0400
fff88000
-
{a=>72,b=>7}
48000700
48000700
48000700
0048e000
48000700
48000700
0048e000
48000700
0048e000
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>0,a=>-49,b=>3}
cfff0300
cfff0300
cfff0300
ffcf6000
cfff0300
cfff0300
ffcf6000
cfff0300
ffcf6000
-
{c=>4,a=>28,b=>7}
1c002700
1c002700
1c002700
001cf000
1c002700
1c002700
001cf000
1c002700
001cf000
-
{c=>2,a=>97,b=>5}
61001500
61001500
61001500
0061a800
61001500
61001500
0061a800
61001500
0061a800
-
{c=>3,a=>-123,b=>0}
85ff1800
85ff1800
85ff1800
ff850c00
85ff1800
85ff1800
ff850c00
85ff1800
ff850c00
-
{c=>3,a=>71,b=>7}
47001f00
47001f00
47001f00
0047ec00
47001f00
47001f00
0047ec00
47001f00
0047ec00
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
};
-
{c=>6,a=>-55,b=>7,d=>2}
c9ffb700
c9ffb700
c9ffb700
ffc9f900
c9ffb700
c9ffb700
ffc9f900
c9ffb700
ffc9f900
-
{c=>4,a=>118,b=>0,d=>7}
7600e001
7600e001
7600e001
00761380
7600e001
7600e001
00761380
7600e001
00761380
-
{c=>4,a=>-56,b=>7,d=>0}
c8ff2700
c8ff2700
c8ff2700
ffc8f000
c8ff2700
c8ff2700
ffc8f000
c8ff2700
ffc8f000
-
{c=>1,a=>111,b=>5,d=>1}
6f004d00
6f004d00
6f004d00
006fa480
6f004d00
6f004d00
006fa480
6f004d00
006fa480
-
{c=>4,a=>-108,b=>3,d=>3}
94ffe300
94ffe300
94ffe300
ff947180
94ffe300
94ffe300
ff947180
94ffe300
ff947180
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
};
-
{e=>2,c=>5,a=>2,b=>4,d=>4}
02002c05
02002c05
02002c05
00029620
02002c05
02002c05
00029620
02002c05
00029620
-
{e=>7,c=>2,a=>57,b=>2,d=>1}
3900520e
3900520e
3900520e
003948f0
3900520e
3900520e
003948f0
3900520e
003948f0
-
{e=>1,c=>6,a=>92,b=>1,d=>3}
5c00f102
5c00f102
5c00f102
005c3990
5c00f102
5c00f102
005c3990
5c00f102
005c3990
-
{e=>0,c=>1,a=>-36,b=>0,d=>2}
dcff8800
dcff8800
dcff8800
ffdc0500
dcff8800
dcff8800
ffdc0500
dcff8800
ffdc0500
-
{e=>1,c=>4,a=>-88,b=>1,d=>0}
a8ff2102
a8ff2102
a8ff2102
ffa83010
a8ff2102
a8ff2102
ffa83010
a8ff2102
ffa83010
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
};
-
{e=>0,c=>1,a=>-52,b=>6,d=>1,f=>6}
ccff4e60
ccff4e60
ccff4e60
ffccc48c
ccff4e60
ccff4e60
ffccc48c
ccff4e60
ffccc48c
-
{e=>3,c=>5,a=>-41,b=>2,d=>6,f=>0}
d7ffaa07
d7ffaa07
d7ffaa07
ffd75730
d7ffaa07
d7ffaa07
ffd75730
d7ffaa07
ffd75730
-
{e=>2,c=>3,a=>-90,b=>5,d=>7,f=>3}
a6ffdd35
a6ffdd35
a6ffdd35
ffa6afa6
a6ffdd35
a6ffdd35
ffa6afa6
a6ffdd35
ffa6afa6
-
{e=>1,c=>4,a=>6,b=>2,d=>4,f=>7}
06002273
06002273
06002273
0006521e
06002273
06002273
0006521e
06002273
0006521e
-
{e=>2,c=>4,a=>24,b=>4,d=>4,f=>7}
18002475
18002475
18002475
0018922e
18002475
18002475
0018922e
18002475
0018922e
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
};
-
{e=>4,c=>2,a=>-91,g=>7,b=>6,d=>2,f=>3}
a5ff963807000000
a5ff963807000000
a5ff963807000000
ffa5c946e0000000
a5ff963807000000
a5ff963807000000
ffa5c946e0000000
a5ff963807000000
ffa5c946e0000000
-
{e=>3,c=>0,a=>116,g=>7,b=>3,d=>7,f=>4}
7400c34707000000
7400c34707000000
7400c34707000000
007463b8e0000000
7400c34707000000
7400c34707000000
007463b8e0000000
7400c34707000000
007463b8e0000000
-
{e=>2,c=>7,a=>93,g=>4,b=>6,d=>6,f=>7}
5d00be7504000000
5d00be7504000000
5d00be7504000000
005ddf2e80000000
5d00be7504000000
5d00be7504000000
005ddf2e80000000
5d00be7504000000
005ddf2e80000000
-
{e=>2,c=>5,a=>108,g=>5,b=>4,d=>4,f=>2}
6c002c2505000000
6c002c2505000000
6c002c2505000000
006c9624a0000000
6c002c2505000000
6c002c2505000000
006c9624a0000000
6c002c2505000000
006c9624a0000000
-
{e=>4,c=>2,a=>-28,g=>3,b=>4,d=>2,f=>6}
e4ff946803000000
e4ff946803000000
e4ff946803000000
ffe4894c60000000
e4ff946803000000
e4ff946803000000
ffe4894c60000000
e4ff946803000000
ffe4894c60000000
=
struct umixed3 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
  unsigned long  h;
};
-
{e=>4,a=>-83,d=>2,c=>5,h=>218,b=>0,g=>2,f=>5}
adffa85802000000da000000
adffa85802000000da00000000000000
adffa85802000000da00000000000000
ffad154a40000000000000da
adffa85802000000da000000
adffa85802000000da000000
ffad154a4000000000000000000000da
adffa85802000000da000000
ffad154a40000000000000da
-
{e=>2,a=>12,d=>1,c=>2,h=>88,b=>2,g=>6,f=>2}
0c0052240600000058000000
0c005224060000005800000000000000
0c005224060000005800000000000000
000c48a4c000000000000058
0c0052240600000058000000
0c0052240600000058000000
000c48a4c00000000000000000000058
0c0052240600000058000000
000c48a4c000000000000058
-
{e=>1,a=>-57,d=>1,c=>1,h=>75,b=>1,g=>4,f=>3}
c7ff4932040000004b000000
c7ff4932040000004b00000000000000
c7ff4932040000004b00000000000000
ffc72496800000000000004b
c7ff4932040000004b000000
c7ff4932040000004b000000
ffc7249680000000000000000000004b
c7ff4932040000004b000000
ffc72496800000000000004b
-
{e=>7,a=>17,d=>6,c=>0,h=>143,b=>5,g=>4,f=>1}
1100851f040000008f000000
1100851f040000008f00000000000000
1100851f040000008f00000000000000
0011a372800000000000008f
1100851f040000008f000000
1100851f040000008f000000
0011a37280000000000000000000008f
1100851f040000008f000000
0011a372800000000000008f
-
{e=>1,a=>10,d=>6,c=>1,h=>73,b=>1,g=>0,f=>6}
0a0089630000000049000000
0a008963000000004900000000000000
0a008963000000004900000000000000
000a271c0000000000000049
0a0089630000000049000000
0a0089630000000049000000
000a271c000000000000000000000049
0a0089630000000049000000
000a271c0000000000000049
=
struct umixed3 {
  int a;
  unsigned char  b:3;
};
-
{a=>-62,b=>6}
c2ffffff06000000
c2ffffff06000000
c2ffffff06000000
ffffffc2c0000000
c2ffffff06000000
c2ffffff06000000
ffffffc2c0000000
c2ffffff06000000
ffffffc2c0000000
-
{a=>-53,b=>2}
cbffffff02000000
cbffffff02000000
cbffffff02000000
ffffffcb40000000
cbffffff02000000
cbffffff02000000
ffffffcb40000000
cbffffff02000000
ffffffcb40000000
-
{a=>118,b=>0}
7600000000000000
7600000000000000
7600000000000000
0000007600000000
7600000000000000
7600000000000000
0000007600000000
7600000000000000
0000007600000000
-
{a=>59,b=>0}
3b00000000000000
3b00000000000000
3b00000000000000
0000003b00000000
3b00000000000000
3b00000000000000
0000003b00000000
3b00000000000000
0000003b00000000
-
{a=>-20,b=>1}
ecffffff01000000
ecffffff01000000
ecffffff01000000
ffffffec20000000
ecffffff01000000
ecffffff01000000
ffffffec20000000
ecffffff01000000
ffffffec20000000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>5,a=>-62,b=>7}
c2ffffff2f000000
c2ffffff2f000000
c2ffffff2f000000
ffffffc2f4000000
c2ffffff2f000000
c2ffffff2f000000
ffffffc2f4000000
c2ffffff2f000000
ffffffc2f4000000
-
{c=>6,a=>-14,b=>1}
f2ffffff31000000
f2ffffff31000000
f2ffffff31000000
fffffff238000000
f2ffffff31000000
f2ffffff31000000
fffffff238000000
f2ffffff31000000
fffffff238000000
-
{c=>6,a=>63,b=>7}
3f00000037000000
3f00000037000000
3f00000037000000
0000003ff8000000
3f00000037000000
3f00000037000000
0000003ff8000000
3f00000037000000
0000003ff8000000
-
{c=>3,a=>41,b=>2}
290000001a000000
290000001a000000
290000001a000000
000000294c000000
290000001a000000
290000001a000000
000000294c000000
290000001a000000
000000294c000000
-
{c=>7,a=>18,b=>2}
120000003a000000
120000003a000000
120000003a000000
000000125c000000
120000003a000000
120000003a000000
000000125c000000
120000003a000000
000000125c000000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
};
-
{c=>5,a=>75,b=>4,d=>6}
4b000000ac010000
4b000000ac010000
4b000000ac010000
0000004b97000000
4b000000ac010000
4b000000ac010000
0000004b97000000
4b000000ac010000
0000004b97000000
-
{c=>0,a=>117,b=>6,d=>0}
7500000006000000
7500000006000000
7500000006000000
00000075c0000000
7500000006000000
7500000006000000
00000075c0000000
7500000006000000
00000075c0000000
-
{c=>2,a=>-47,b=>1,d=>6}
d1ffffff91010000
d1ffffff91010000
d1ffffff91010000
ffffffd12b000000
d1ffffff91010000
d1ffffff91010000
ffffffd12b000000
d1ffffff91010000
ffffffd12b000000
-
{c=>4,a=>-11,b=>0,d=>3}
f5ffffffe0000000
f5ffffffe0000000
f5ffffffe0000000
fffffff511800000
f5ffffffe0000000
f5ffffffe0000000
fffffff511800000
f5ffffffe0000000
fffffff511800000
-
{c=>1,a=>64,b=>7,d=>5}
400000004f010000
400000004f010000
400000004f010000
00000040e6800000
400000004f010000
400000004f010000
00000040e6800000
400000004f010000
00000040e6800000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
};
-
{e=>1,c=>3,a=>-106,b=>7,d=>0}
96ffffff1f020000
96ffffff1f020000
96ffffff1f020000
ffffff96ec100000
96ffffff1f020000
96ffffff1f020000
ffffff96ec100000
96ffffff1f020000
ffffff96ec100000
-
{e=>5,c=>5,a=>-62,b=>1,d=>2}
c2ffffffa90a0000
c2ffffffa90a0000
c2ffffffa90a0000
ffffffc235500000
c2ffffffa90a0000
c2ffffffa90a0000
ffffffc235500000
c2ffffffa90a0000
ffffffc235500000
-
{e=>6,c=>2,a=>-4,b=>4,d=>4}
fcffffff140d0000
fcffffff140d0000
fcffffff140d0000
fffffffc8a600000
fcffffff140d0000
fcffffff140d0000
fffffffc8a600000
fcffffff140d0000
fffffffc8a600000
-
{e=>5,c=>7,a=>-93,b=>4,d=>2}
a3ffffffbc0a0000
a3ffffffbc0a0000
a3ffffffbc0a0000
ffffffa39d500000
a3ffffffbc0a0000
a3ffffffbc0a0000
ffffffa39d500000
a3ffffffbc0a0000
ffffffa39d500000
-
{e=>7,c=>3,a=>67,b=>3,d=>2}
430000009b0e0000
430000009b0e0000
430000009b0e0000
000000436d700000
430000009b0e0000
430000009b0e0000
000000436d700000
430000009b0e0000
000000436d700000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
};
-
{e=>2,c=>6,a=>83,b=>3,d=>5,f=>4}
5300000073450000
5300000073450000
5300000073450000
000000537aa80000
5300000073450000
5300000073450000
000000537aa80000
5300000073450000
000000537aa80000
-
{e=>0,c=>5,a=>121,b=>1,d=>7,f=>3}
79000000e9310000
79000000e9310000
79000000e9310000
0000007937860000
79000000e9310000
79000000e9310000
0000007937860000
79000000e9310000
0000007937860000
-
{e=>7,c=>2,a=>-79,b=>3,d=>7,f=>1}
b1ffffffd31f0000
b1ffffffd31f0000
b1ffffffd31f0000
ffffffb16bf20000
b1ffffffd31f0000
b1ffffffd31f0000
ffffffb16bf20000
b1ffffffd31f0000
ffffffb16bf20000
-
{e=>4,c=>0,a=>-82,b=>1,d=>3,f=>3}
aeffffffc1380000
aeffffffc1380000
aeffffffc1380000
ffffffae21c60000
aeffffffc1380000
aeffffffc1380000
ffffffae21c60000
aeffffffc1380000
ffffffae21c60000
-
{e=>3,c=>4,a=>32,b=>4,d=>6,f=>0}
20000000a4070000
20000000a4070000
20000000a4070000
0000002093300000
20000000a4070000
20000000a4070000
0000002093300000
20000000a4070000
0000002093300000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
};
-
{e=>7,c=>4,a=>-119,g=>7,b=>6,d=>2,f=>5}
89ffffffa65e0700
89ffffffa65e0700
89ffffffa65e0700
ffffff89d17ae000
89ffffffa65e0700
89ffffffa65e0700
ffffff89d17ae000
89ffffffa65e0700
ffffff89d17ae000
-
{e=>4,c=>7,a=>75,g=>5,b=>7,d=>2,f=>3}
4b000000bf380500
4b000000bf380500
4b000000bf380500
0000004bfd46a000
4b000000bf380500
4b000000bf380500
0000004bfd46a000
4b000000bf380500
0000004bfd46a000
-
{e=>1,c=>0,a=>-122,g=>5,b=>5,d=>2,f=>1}
86ffffff85120500
86ffffff85120500
86ffffff85120500
ffffff86a112a000
86ffffff85120500
86ffffff85120500
ffffff86a112a000
86ffffff85120500
ffffff86a112a000
-
{e=>7,c=>6,a=>-118,g=>7,b=>5,d=>1,f=>3}
8affffff753e0700
8affffff753e0700
8affffff753e0700
ffffff8ab8f6e000
8affffff753e0700
8affffff753e0700
ffffff8ab8f6e000
8affffff753e0700
ffffff8ab8f6e000
-
{e=>6,c=>5,a=>-69,g=>0,b=>7,d=>1,f=>1}
bbffffff6f1c0000
bbffffff6f1c0000
bbffffff6f1c0000
ffffffbbf4e20000
bbffffff6f1c0000
bbffffff6f1c0000
ffffffbbf4e20000
bbffffff6f1c0000
ffffffbbf4e20000
=
struct umixed3 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
  unsigned long  h;
};
-
{e=>7,a=>22,d=>3,c=>6,h=>27,b=>7,g=>2,f=>4}
16000000f74e02001b000000
16000000f74e02001b00000000000000
16000000f74e02001b00000000000000
00000016f9f840000000001b
16000000f74e02001b000000
16000000f74e02001b000000
00000016f9f84000000000000000001b
16000000f74e02001b000000
00000016f9f840000000001b
-
{e=>0,a=>-54,d=>1,c=>7,h=>112,b=>1,g=>4,f=>2}
caffffff7920040070000000
caffffff792004007000000000000000
caffffff792004007000000000000000
ffffffca3c84800000000070
caffffff7920040070000000
caffffff7920040070000000
ffffffca3c8480000000000000000070
caffffff7920040070000000
ffffffca3c84800000000070
-
{e=>7,a=>1,d=>5,c=>7,h=>4,b=>5,g=>5,f=>4}
010000007d4f050004000000
010000007d4f05000400000000000000
010000007d4f05000400000000000000
00000001bef8a00000000004
010000007d4f050004000000
010000007d4f050004000000
00000001bef8a0000000000000000004
010000007d4f050004000000
00000001bef8a00000000004
-
{e=>2,a=>10,d=>0,c=>1,h=>37,b=>2,g=>4,f=>7}
0a0000000a74040025000000
0a0000000a7404002500000000000000
0a0000000a7404002500000000000000
0000000a442e800000000025
0a0000000a74040025000000
0a0000000a74040025000000
0000000a442e80000000000000000025
0a0000000a74040025000000
0000000a442e800000000025
-
{e=>4,a=>-17,d=>3,c=>0,h=>76,b=>4,g=>0,f=>6}
efffffffc46800004c000000
efffffffc46800004c00000000000000
efffffffc46800004c00000000000000
ffffffef81cc00000000004c
efffffffc46800004c000000
efffffffc46800004c000000
ffffffef81cc0000000000000000004c
efffffffc46800004c000000
ffffffef81cc00000000004c
=
struct umixed3 {
  long a;
  unsigned char  b:3;
};
-
{a=>83,b=>2}
5300000002000000
53000000000000000200000000000000
53000000000000000200000000000000
0000005340000000
5300000002000000
5300000002000000
00000000000000534000000000000000
5300000002000000
0000005340000000
-
{a=>21,b=>7}
1500000007000000
15000000000000000700000000000000
15000000000000000700000000000000
00000015e0000000
1500000007000000
1500000007000000
0000000000000015e000000000000000
1500000007000000
00000015e0000000
-
{a=>-112,b=>2}
90ffffff02000000
90ffffffffffffff0200000000000000
90ffffffffffffff0200000000000000
ffffff9040000000
90ffffff02000000
90ffffff02000000
ffffffffffffff904000000000000000
90ffffff02000000
ffffff9040000000
-
{a=>56,b=>1}
3800000001000000
38000000000000000100000000000000
38000000000000000100000000000000
0000003820000000
3800000001000000
3800000001000000
00000000000000382000000000000000
3800000001000000
0000003820000000
-
{a=>-36,b=>0}
dcffffff00000000
dcffffffffffffff0000000000000000
dcffffffffffffff0000000000000000
ffffffdc00000000
dcffffff00000000
dcffffff00000000
ffffffffffffffdc0000000000000000
dcffffff00000000
ffffffdc00000000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>5,a=>-25,b=>4}
e7ffffff2c000000
e7ffffffffffffff2c00000000000000
e7ffffffffffffff2c00000000000000
ffffffe794000000
e7ffffff2c000000
e7ffffff2c000000
ffffffffffffffe79400000000000000
e7ffffff2c000000
ffffffe794000000
-
{c=>4,a=>-122,b=>2}
86ffffff22000000
86ffffffffffffff2200000000000000
86ffffffffffffff2200000000000000
ffffff8650000000
86ffffff22000000
86ffffff22000000
ffffffffffffff865000000000000000
86ffffff22000000
ffffff8650000000
-
{c=>1,a=>-102,b=>1}
9affffff09000000
9affffffffffffff0900000000000000
9affffffffffffff0900000000000000
ffffff9a24000000
9affffff09000000
9affffff09000000
ffffffffffffff9a2400000000000000
9affffff09000000
ffffff9a24000000
-
{c=>4,a=>2,b=>3}
0200000023000000
02000000000000002300000000000000
02000000000000002300000000000000
0000000270000000
0200000023000000
0200000023000000
00000000000000027000000000000000
0200000023000000
0000000270000000
-
{c=>4,a=>120,b=>2}
7800000022000000
78000000000000002200000000000000
78000000000000002200000000000000
0000007850000000
7800000022000000
7800000022000000
00000000000000785000000000000000
7800000022000000
0000007850000000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
};
-
{c=>5,a=>-39,b=>2,d=>0}
d9ffffff2a000000
d9ffffffffffffff2a00000000000000
d9ffffffffffffff2a00000000000000
ffffffd954000000
d9ffffff2a000000
d9ffffff2a000000
ffffffffffffffd95400000000000000
d9ffffff2a000000
ffffffd954000000
-
{c=>3,a=>-53,b=>0,d=>4}
cbffffff18010000
cbffffffffffffff1801000000000000
cbffffffffffffff1801000000000000
ffffffcb0e000000
cbffffff18010000
cbffffff18010000
ffffffffffffffcb0e00000000000000
cbffffff18010000
ffffffcb0e000000
-
{c=>5,a=>-104,b=>4,d=>7}
98ffffffec010000
98ffffffffffffffec01000000000000
98ffffffffffffffec01000000000000
ffffff9897800000
98ffffffec010000
98ffffffec010000
ffffffffffffff989780000000000000
98ffffffec010000
ffffff9897800000
-
{c=>6,a=>-123,b=>4,d=>2}
85ffffffb4000000
85ffffffffffffffb400000000000000
85ffffffffffffffb400000000000000
ffffff8599000000
85ffffffb4000000
85ffffffb4000000
ffffffffffffff859900000000000000
85ffffffb4000000
ffffff8599000000
-
{c=>3,a=>-127,b=>3,d=>6}
81ffffff9b010000
81ffffffffffffff9b01000000000000
81ffffffffffffff9b01000000000000
ffffff816f000000
81ffffff9b010000
81ffffff9b010000
ffffffffffffff816f00000000000000
81ffffff9b010000
ffffff816f000000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
};
-
{e=>6,c=>5,a=>61,b=>1,d=>1}
3d000000690c0000
3d00000000000000690c000000000000
3d00000000000000690c000000000000
0000003d34e00000
3d000000690c0000
3d000000690c0000
000000000000003d34e0000000000000
3d000000690c0000
0000003d34e00000
-
{e=>7,c=>2,a=>72,b=>7,d=>7}
48000000d70f0000
4800000000000000d70f000000000000
4800000000000000d70f000000000000
00000048ebf00000
48000000d70f0000
48000000d70f0000
0000000000000048ebf0000000000000
48000000d70f0000
00000048ebf00000
-
{e=>6,c=>1,a=>33,b=>1,d=>5}
21000000490d0000
2100000000000000490d000000000000
2100000000000000490d000000000000
0000002126e00000
21000000490d0000
21000000490d0000
000000000000002126e0000000000000
21000000490d0000
0000002126e00000
-
{e=>1,c=>5,a=>59,b=>3,d=>6}
3b000000ab030000
3b00000000000000ab03000000000000
3b00000000000000ab03000000000000
0000003b77100000
3b000000ab030000
3b000000ab030000
000000000000003b7710000000000000
3b000000ab030000
0000003b77100000
-
{e=>5,c=>7,a=>-74,b=>4,d=>1}
b6ffffff7c0a0000
b6ffffffffffffff7c0a000000000000
b6ffffffffffffff7c0a000000000000
ffffffb69cd00000
b6ffffff7c0a0000
b6ffffff7c0a0000
ffffffffffffffb69cd0000000000000
b6ffffff7c0a0000
ffffffb69cd00000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
};
-
{e=>2,c=>0,a=>72,b=>0,d=>6,f=>6}
4800000080650000
48000000000000008065000000000000
48000000000000008065000000000000
00000048032c0000
4800000080650000
4800000080650000
0000000000000048032c000000000000
4800000080650000
00000048032c0000
-
{e=>1,c=>6,a=>-5,b=>3,d=>2,f=>4}
fbffffffb3420000
fbffffffffffffffb342000000000000
fbffffffffffffffb342000000000000
fffffffb79180000
fbffffffb3420000
fbffffffb3420000
fffffffffffffffb7918000000000000
fbffffffb3420000
fffffffb79180000
-
{e=>3,c=>4,a=>-25,b=>7,d=>2,f=>1}
e7ffffffa7160000
e7ffffffffffffffa716000000000000
e7ffffffffffffffa716000000000000
ffffffe7f1320000
e7ffffffa7160000
e7ffffffa7160000
ffffffffffffffe7f132000000000000
e7ffffffa7160000
ffffffe7f1320000
-
{e=>6,c=>2,a=>127,b=>5,d=>2,f=>0}
7f000000950c0000
7f00000000000000950c000000000000
7f00000000000000950c000000000000
0000007fa9600000
7f000000950c0000
7f000000950c0000
000000000000007fa960000000000000
7f000000950c0000
0000007fa9600000
-
{e=>1,c=>2,a=>-28,b=>2,d=>6,f=>6}
e4ffffff92630000
e4ffffffffffffff9263000000000000
e4ffffffffffffff9263000000000000
ffffffe44b1c0000
e4ffffff92630000
e4ffffff92630000
ffffffffffffffe44b1c000000000000
e4ffffff92630000
ffffffe44b1c0000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
};
-
{e=>5,c=>0,a=>-20,g=>4,b=>1,d=>6,f=>7}
ecffffff817b0400
ecffffffffffffff817b040000000000
ecffffffffffffff817b040000000000
ffffffec235e8000
ecffffff817b0400
ecffffff817b0400
ffffffffffffffec235e800000000000
ecffffff817b0400
ffffffec235e8000
-
{e=>6,c=>7,a=>89,g=>0,b=>6,d=>5,f=>4}
590000007e4d0000
59000000000000007e4d000000000000
59000000000000007e4d000000000000
00000059dee80000
590000007e4d0000
590000007e4d0000
0000000000000059dee8000000000000
590000007e4d0000
00000059dee80000
-
{e=>2,c=>7,a=>75,g=>1,b=>0,d=>5,f=>5}
4b00000078550100
4b000000000000007855010000000000
4b000000000000007855010000000000
0000004b1eaa2000
4b00000078550100
4b00000078550100
000000000000004b1eaa200000000000
4b00000078550100
0000004b1eaa2000
-
{e=>5,c=>6,a=>-7,g=>2,b=>2,d=>4,f=>2}
f9ffffff322b0200
f9ffffffffffffff322b020000000000
f9ffffffffffffff322b020000000000
fffffff95a544000
f9ffffff322b0200
f9ffffff322b0200
fffffffffffffff95a54400000000000
f9ffffff322b0200
fffffff95a544000
-
{e=>0,c=>5,a=>-93,g=>6,b=>5,d=>1,f=>2}
a3ffffff6d200600
a3ffffffffffffff6d20060000000000
a3ffffffffffffff6d20060000000000
ffffffa3b484c000
a3ffffff6d200600
a3ffffff6d200600
ffffffffffffffa3b484c00000000000
a3ffffff6d200600
ffffffa3b484c000
=
struct umixed3 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned int   d:3;
  unsigned char  e:3;
  unsigned short f:3;
  unsigned char  g:3;
  unsigned long  h;
};
-
{e=>7,a=>-73,d=>5,c=>2,h=>27,b=>3,g=>0,f=>5}
b7ffffff535f00001b000000
b7ffffffffffffff535f0000000000001b00000000000000
b7ffffffffffffff535f0000000000001b00000000000000
ffffffb76afa00000000001b
b7ffffff535f00001b000000
b7ffffff535f00001b000000
ffffffffffffffb76afa000000000000000000000000001b
b7ffffff535f00001b000000
ffffffb76afa00000000001b
-
{e=>5,a=>-115,d=>0,c=>4,h=>51,b=>2,g=>3,f=>6}
8dffffff226a030033000000
8dffffffffffffff226a0300000000003300000000000000
8dffffffffffffff226a0300000000003300000000000000
ffffff8d505c600000000033
8dffffff226a030033000000
8dffffff226a030033000000
ffffffffffffff8d505c6000000000000000000000000033
8dffffff226a030033000000
ffffff8d505c600000000033
-
{e=>4,a=>20,d=>0,c=>2,h=>56,b=>5,g=>7,f=>4}
140000001548070038000000
140000000000000015480700000000003800000000000000
140000000000000015480700000000003800000000000000
00000014a848e00000000038
140000001548070038000000
140000001548070038000000
0000000000000014a848e000000000000000000000000038
140000001548070038000000
00000014a848e00000000038
-
{e=>6,a=>115,d=>7,c=>2,h=>157,b=>2,g=>0,f=>3}
73000000d23d00009d000000
7300000000000000d23d0000000000009d00000000000000
7300000000000000d23d0000000000009d00000000000000
000000734be600000000009d
73000000d23d00009d000000
73000000d23d00009d000000
00000000000000734be6000000000000000000000000009d
73000000d23d00009d000000
000000734be600000000009d
-
{e=>1,a=>101,d=>4,c=>2,h=>189,b=>7,g=>1,f=>6}
6500000017630100bd000000
65000000000000001763010000000000bd00000000000000
65000000000000001763010000000000bd00000000000000
00000065ea1c2000000000bd
6500000017630100bd000000
6500000017630100bd000000
0000000000000065ea1c20000000000000000000000000bd
6500000017630100bd000000
00000065ea1c2000000000bd
=
struct umixed_no_pack {
  unsigned char  a:3;
};
-
{a=>2}
02
02
02
40
02000000
02
40
02
40
-
{a=>3}
03
03
03
60
03000000
03
60
03
60
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>6}
06
06
06
c0
06000000
06
c0
06
c0
-
{a=>5}
05
05
05
a0
05000000
05
a0
05
a0
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
};
-
{a=>3,b=>4}
23
23
23
70
23000000
23
70
23
70
-
{a=>4,b=>4}
24
24
24
90
24000000
24
90
24
90
-
{a=>0,b=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>6,b=>0}
06
06
06
c0
06000000
06
c0
06
c0
-
{a=>7,b=>2}
17
17
17
e8
17000000
17
e8
17
e8
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
};
-
{c=>2,a=>4,b=>5}
ac00
ac00
ac00
9500
ac000000
ac00
9500
ac00
9500
-
{c=>6,a=>2,b=>7}
ba01
ba01
ba01
5f00
ba010000
ba01
5f00
ba01
5f00
-
{c=>5,a=>1,b=>5}
6901
6901
6901
3680
69010000
6901
3680
6901
3680
-
{c=>5,a=>1,b=>5}
6901
6901
6901
3680
69010000
6901
3680
6901
3680
-
{c=>6,a=>2,b=>0}
8201
8201
8201
4300
82010000
8201
4300
8201
4300
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
};
-
{c=>2,a=>3,b=>4,d=>16659437}
a3000000ed33fe00
a3000000ed33fe00
a3000000ed33fe00
710000000fe33ed0
a3000000ed33fe00
a3000000ed33fe00
710000000fe33ed0
a3000000ed33fe00
710000000fe33ed0
-
{c=>7,a=>2,b=>3,d=>201260983}
da010000b7fffe0b
da010000b7fffe0b
da010000b7fffe0b
4f800000bfeffb70
da010000b7fffe0b
da010000b7fffe0b
4f800000bfeffb70
da010000b7fffe0b
4f800000bfeffb70
-
{c=>1,a=>6,b=>3,d=>256219575}
5e000000b799450f
5e000000b799450f
5e000000b799450f
cc800000f4599b70
5e000000b799450f
5e000000b799450f
cc800000f4599b70
5e000000b799450f
cc800000f4599b70
-
{c=>7,a=>6,b=>0,d=>55997687}
c6010000f7745603
c6010000f7745603
c6010000f7745603
c380000035674f70
c6010000f7745603
c6010000f7745603
c380000035674f70
c6010000f7745603
c380000035674f70
-
{c=>2,a=>4,b=>4,d=>103672891}
a40000003bec2d06
a40000003bec2d06
a40000003bec2d06
9100000062dec3b0
a40000003bec2d06
a40000003bec2d06
9100000062dec3b0
a40000003bec2d06
9100000062dec3b0
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
};
-
{e=>4,c=>3,a=>3,b=>1,d=>63303944}
cb00000008f1c543
cb00000008f1c543
cb00000008f1c543
658000003c5f1088
cb00000008f1c543
cb00000008f1c543
658000003c5f1088
cb00000008f1c543
658000003c5f1088
-
{e=>6,c=>1,a=>7,b=>5,d=>115286698}
6f000000aa22df66
6f000000aa22df66
6f000000aa22df66
f48000006df22aac
6f000000aa22df66
6f000000aa22df66
f48000006df22aac
6f000000aa22df66
f48000006df22aac
-
{e=>5,c=>7,a=>5,b=>1,d=>33758906}
cd010000ba1e0352
cd010000ba1e0352
cd010000ba1e0352
a78000002031ebaa
cd010000ba1e0352
cd010000ba1e0352
a78000002031ebaa
cd010000ba1e0352
a78000002031ebaa
-
{e=>1,c=>7,a=>2,b=>1,d=>75998826}
ca0100006aa68714
ca0100006aa68714
ca0100006aa68714
47800000487a66a2
ca0100006aa68714
ca0100006aa68714
47800000487a66a2
ca0100006aa68714
47800000487a66a2
-
{e=>0,c=>4,a=>2,b=>7,d=>23580046}
3a0100008ecd6701
3a0100008ecd6701
3a0100008ecd6701
5e000000167cd8e0
3a0100008ecd6701
3a0100008ecd6701
5e000000167cd8e0
3a0100008ecd6701
5e000000167cd8e0
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
};
-
{e=>1,c=>0,a=>2,b=>7,d=>158148049,f=>0}
3a000000d1256d1900000000
3a000000d1256d1900000000
3a000000d1256d1900000000
5c00000096d25d1200000000
3a000000d1256d1900000000
3a000000d1256d1900000000
5c00000096d25d1200000000
3a000000d1256d1900000000
5c00000096d25d1200000000
-
{e=>3,c=>1,a=>1,b=>7,d=>228592629,f=>0}
79000000f50ba03d00000000
79000000f50ba03d00000000
79000000f50ba03d00000000
3c800000da00bf5600000000
79000000f50ba03d00000000
79000000f50ba03d00000000
3c800000da00bf5600000000
79000000f50ba03d00000000
3c800000da00bf5600000000
-
{e=>6,c=>5,a=>5,b=>6,d=>13400160,f=>0}
750100006078cc6000000000
750100006078cc6000000000
750100006078cc6000000000
ba8000000cc7860c00000000
750100006078cc6000000000
750100006078cc6000000000
ba8000000cc7860c00000000
750100006078cc6000000000
ba8000000cc7860c00000000
-
{e=>1,c=>2,a=>1,b=>1,d=>252868262,f=>3}
89000000a676121f03000000
89000000a676121f03000000
89000000a676121f03000000
25000000f1276a62c0000000
89000000a676121f03000000
89000000a676121f03000000
25000000f1276a62c0000000
89000000a676121f03000000
25000000f1276a62c0000000
-
{e=>6,c=>3,a=>3,b=>0,d=>45793175,f=>0}
c300000097bfba6200000000
c300000097bfba6200000000
c300000097bfba6200000000
618000002babf97c00000000
c300000097bfba6200000000
c300000097bfba6200000000
618000002babf97c00000000
c300000097bfba6200000000
618000002babf97c00000000
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
};
-
{e=>1,c=>2,a=>6,g=>1699,b=>6,d=>41631336,f=>2}
b6000000683e7b128e1a0000
b6000000683e7b128e1a0000
b6000000683e7b128e1a0000
d900000027b3e6828d460000
b6000000683e7b128e1a0000
b6000000683e7b128e1a0000
d900000027b3e6828d460000
b6000000683e7b128e1a0000
d900000027b3e6828d460000
-
{e=>2,c=>0,a=>2,g=>602,b=>2,d=>186423654,f=>2}
1200000066991c2b6a090000
1200000066991c2b6a090000
1200000066991c2b6a090000
48000000b1c9966484b40000
1200000066991c2b6a090000
1200000066991c2b6a090000
48000000b1c9966484b40000
1200000066991c2b6a090000
48000000b1c9966484b40000
-
{e=>2,c=>7,a=>4,g=>6342,b=>7,d=>247473427,f=>2}
fc0100001325c02e1a630000
fc0100001325c02e1a630000
fc0100001325c02e1a630000
9f800000ec025134b18c0000
fc0100001325c02e1a630000
fc0100001325c02e1a630000
9f800000ec025134b18c0000
fc0100001325c02e1a630000
9f800000ec025134b18c0000
-
{e=>5,c=>7,a=>4,g=>2765,b=>7,d=>238172392,f=>1}
fc010000e838325e352b0000
fc010000e838325e352b0000
fc010000e838325e352b0000
9f800000e3238e8a559a0000
fc010000e838325e352b0000
fc010000e838325e352b0000
9f800000e3238e8a559a0000
fc010000e838325e352b0000
9f800000e3238e8a559a0000
-
{e=>1,c=>7,a=>1,g=>5584,b=>7,d=>2742541,f=>3}
f90100000dd9291043570000
f90100000dd9291043570000
f90100000dd9291043570000
3f800000029d90d2eba00000
f90100000dd9291043570000
f90100000dd9291043570000
3f800000029d90d2eba00000
f90100000dd9291043570000
3f800000029d90d2eba00000
=
struct umixed_no_pack {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
  signed   int   h;
};
-
{e=>5,a=>0,d=>63927408,c=>7,h=>-86,b=>6,g=>5835,f=>1}
f00100007074cf532d5b0000aaffffff
f00100007074cf532d5b0000aaffffff
f00100007074cf532d5b0000aaffffff
1b8000003cf7470a6d960000ffffffaa
f00100007074cf532d5b0000aaffffff
f00100007074cf532d5b0000aaffffff
1b8000003cf7470a6d960000ffffffaa
f00100007074cf532d5b0000aaffffff
1b8000003cf7470a6d960000ffffffaa
-
{e=>7,a=>3,d=>165783275,c=>6,h=>-85,b=>5,g=>3147,f=>0}
ab010000eba6e1792c310000abffffff
ab010000eba6e1792c310000abffffff
ab010000eba6e1792c310000abffffff
770000009e1a6ebe18960000ffffffab
ab010000eba6e1792c310000abffffff
ab010000eba6e1792c310000abffffff
770000009e1a6ebe18960000ffffffab
ab010000eba6e1792c310000abffffff
770000009e1a6ebe18960000ffffffab
-
{e=>7,a=>0,d=>262181766,c=>7,h=>-76,b=>2,g=>3227,f=>0}
d00100008693a07f6c320000b4ffffff
d00100008693a07f6c320000b4ffffff
d00100008693a07f6c320000b4ffffff
0b800000fa09386e19360000ffffffb4
d00100008693a07f6c320000b4ffffff
d00100008693a07f6c320000b4ffffff
0b800000fa09386e19360000ffffffb4
d00100008693a07f6c320000b4ffffff
0b800000fa09386e19360000ffffffb4
-
{e=>2,a=>1,d=>258295770,c=>1,h=>-44,b=>2,g=>2696,f=>2}
51000000da47652f222a0000d4ffffff
51000000da47652f222a0000d4ffffff
51000000da47652f222a0000d4ffffff
28800000f6547da495100000ffffffd4
51000000da47652f222a0000d4ffffff
51000000da47652f222a0000d4ffffff
28800000f6547da495100000ffffffd4
51000000da47652f222a0000d4ffffff
28800000f6547da495100000ffffffd4
-
{e=>6,a=>7,d=>149674579,c=>6,h=>44,b=>7,g=>3480,f=>1}
bf01000053daeb68613600002c000000
bf01000053daeb68613600002c000000
bf01000053daeb68613600002c000000
ff0000008ebda53c5b3000000000002c
bf01000053daeb68613600002c000000
bf01000053daeb68613600002c000000
ff0000008ebda53c5b3000000000002c
bf01000053daeb68613600002c000000
ff0000008ebda53c5b3000000000002c
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
};
-
{a=>18,b=>7}
1207
1207
1207
12e0
12070000
1207
12e0
1207
12e0
-
{a=>-34,b=>4}
de04
de04
de04
de80
de040000
de04
de80
de04
de80
-
{a=>-63,b=>4}
c104
c104
c104
c180
c1040000
c104
c180
c104
c180
-
{a=>-10,b=>4}
f604
f604
f604
f680
f6040000
f604
f680
f604
f680
-
{a=>117,b=>1}
7501
7501
7501
7520
75010000
7501
7520
7501
7520
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>4,a=>-68,b=>6}
bc26
bc26
bc26
bcd0
bc260000
bc26
bcd0
bc26
bcd0
-
{c=>7,a=>48,b=>6}
303e
303e
303e
30dc
303e0000
303e
30dc
303e
30dc
-
{c=>7,a=>124,b=>0}
7c38
7c38
7c38
7c1c
7c380000
7c38
7c1c
7c38
7c1c
-
{c=>7,a=>111,b=>4}
6f3c
6f3c
6f3c
6f9c
6f3c0000
6f3c
6f9c
6f3c
6f9c
-
{c=>5,a=>-83,b=>1}
ad29
ad29
ad29
ad34
ad290000
ad29
ad34
ad29
ad34
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>2,a=>116,b=>6,d=>5}
74160500
74160500
74160500
74c8a000
74160500
74160500
74c8a000
74160500
74c8a000
-
{c=>0,a=>-85,b=>7,d=>7}
ab070700
ab070700
ab070700
abe0e000
ab070700
ab070700
abe0e000
ab070700
abe0e000
-
{c=>7,a=>13,b=>7,d=>6}
0d3f0600
0d3f0600
0d3f0600
0dfcc000
0d3f0600
0d3f0600
0dfcc000
0d3f0600
0dfcc000
-
{c=>6,a=>118,b=>4,d=>6}
76340600
76340600
76340600
7698c000
76340600
76340600
7698c000
76340600
7698c000
-
{c=>3,a=>59,b=>4,d=>5}
3b1c0500
3b1c0500
3b1c0500
3b8ca000
3b1c0500
3b1c0500
3b8ca000
3b1c0500
3b8ca000
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>27672616,c=>4,a=>110,b=>5,d=>2}
6e2502002840a601
6e2502002840a601
6e2502002840a601
6eb040001a640280
6e2502002840a601
6e2502002840a601
6eb040001a640280
6e2502002840a601
6eb040001a640280
-
{e=>87433172,c=>4,a=>106,b=>7,d=>5}
6a270500d41f3605
6a270500d41f3605
6a270500d41f3605
6af0a0005361fd40
6a270500d41f3605
6a270500d41f3605
6af0a0005361fd40
6a270500d41f3605
6af0a0005361fd40
-
{e=>33757072,c=>4,a=>-72,b=>4,d=>2}
b824020090170302
b824020090170302
b824020090170302
b890400020317900
b824020090170302
b824020090170302
b890400020317900
b824020090170302
b890400020317900
-
{e=>12459290,c=>0,a=>49,b=>7,d=>0}
310700001a1dbe00
310700001a1dbe00
310700001a1dbe00
31e000000be1d1a0
310700001a1dbe00
310700001a1dbe00
31e000000be1d1a0
310700001a1dbe00
31e000000be1d1a0
-
{e=>265383931,c=>3,a=>-91,b=>4,d=>1}
a51c0100fb6fd10f
a51c0100fb6fd10f
a51c0100fb6fd10f
a58c2000fd16ffb0
a51c0100fb6fd10f
a51c0100fb6fd10f
a58c2000fd16ffb0
a51c0100fb6fd10f
a58c2000fd16ffb0
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>121017809,c=>3,a=>-127,b=>5,d=>0,f=>6}
811d0000d1953667
811d0000d1953667
811d0000d1953667
81ac000073695d1c
811d0000d1953667
811d0000d1953667
81ac000073695d1c
811d0000d1953667
81ac000073695d1c
-
{e=>38181014,c=>5,a=>-86,b=>4,d=>3,f=>1}
aa2c030096984612
aa2c030096984612
aa2c030096984612
aa94600024698962
aa2c030096984612
aa2c030096984612
aa94600024698962
aa2c030096984612
aa94600024698962
-
{e=>206063701,c=>2,a=>-126,b=>5,d=>3,f=>4}
821503005548484c
821503005548484c
821503005548484c
82a86000c4848558
821503005548484c
821503005548484c
82a86000c4848558
821503005548484c
82a86000c4848558
-
{e=>102799155,c=>1,a=>-102,b=>5,d=>0,f=>1}
9a0d000033972016
9a0d000033972016
9a0d000033972016
9aa4000062097332
9a0d000033972016
9a0d000033972016
9aa4000062097332
9a0d000033972016
9aa4000062097332
-
{e=>35733158,c=>5,a=>48,b=>7,d=>5,f=>4}
302f0500a63e2142
302f0500a63e2142
302f0500a63e2142
30f4a0002213ea68
302f0500a63e2142
302f0500a63e2142
30f4a0002213ea68
302f0500a63e2142
30f4a0002213ea68
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>259030873,c=>6,a=>-99,g=>3,b=>6,d=>6,f=>7}
9d360600597f707f03000000
9d360600597f707f03000000
9d360600597f707f03000000
9dd8c000f707f59ec0000000
9d360600597f707f03000000
9d360600597f707f03000000
9dd8c000f707f59ec0000000
9d360600597f707f03000000
9dd8c000f707f59ec0000000
-
{e=>113534093,c=>3,a=>-82,g=>1,b=>7,d=>1,f=>1}
ae1f01008d64c41601000000
ae1f01008d64c41601000000
ae1f01008d64c41601000000
aeec20006c4648d240000000
ae1f01008d64c41601000000
ae1f01008d64c41601000000
aeec20006c4648d240000000
ae1f01008d64c41601000000
aeec20006c4648d240000000
-
{e=>196254634,c=>6,a=>-82,g=>0,b=>2,d=>5,f=>3}
ae320500aa9bb23b00000000
ae320500aa9bb23b00000000
ae320500aa9bb23b00000000
ae58a000bb29baa600000000
ae320500aa9bb23b00000000
ae320500aa9bb23b00000000
ae58a000bb29baa600000000
ae320500aa9bb23b00000000
ae58a000bb29baa600000000
-
{e=>211207759,c=>7,a=>26,g=>3,b=>3,d=>6,f=>4}
1a3b06004fc6964c03000000
1a3b06004fc6964c03000000
1a3b06004fc6964c03000000
1a7cc000c96c64f8c0000000
1a3b06004fc6964c03000000
1a3b06004fc6964c03000000
1a7cc000c96c64f8c0000000
1a3b06004fc6964c03000000
1a7cc000c96c64f8c0000000
-
{e=>35365642,c=>5,a=>-40,g=>0,b=>6,d=>0,f=>6}
d82e00000aa31b6200000000
d82e00000aa31b6200000000
d82e00000aa31b6200000000
d8d4000021ba30ac00000000
d82e00000aa31b6200000000
d82e00000aa31b6200000000
d8d4000021ba30ac00000000
d82e00000aa31b6200000000
d8d4000021ba30ac00000000
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>95421875,a=>113,d=>4,c=>0,h=>6613,b=>1,g=>2,f=>5}
71010400b305b05556670000
71010400b305b05556670000
71010400b305b05556670000
712080005b005b3ab3aa0000
71010400b305b05556670000
71010400b305b05556670000
712080005b005b3ab3aa0000
71010400b305b05556670000
712080005b005b3ab3aa0000
-
{e=>219735823,a=>24,d=>6,c=>5,h=>3918,b=>5,g=>1,f=>0}
182d06000fe7180d393d0000
182d06000fe7180d393d0000
182d06000fe7180d393d0000
18b4c000d18e70f05e9c0000
182d06000fe7180d393d0000
182d06000fe7180d393d0000
18b4c000d18e70f05e9c0000
182d06000fe7180d393d0000
18b4c000d18e70f05e9c0000
-
{e=>114141874,a=>-127,d=>4,c=>4,h=>3018,b=>0,g=>0,f=>2}
81200400b2aacd26282f0000
81200400b2aacd26282f0000
81200400b2aacd26282f0000
811080006cdaab2417940000
81200400b2aacd26282f0000
81200400b2aacd26282f0000
811080006cdaab2417940000
81200400b2aacd26282f0000
811080006cdaab2417940000
-
{e=>116157792,a=>52,d=>7,c=>1,h=>7261,b=>4,g=>0,f=>5}
340c0700606dec5674710000
340c0700606dec5674710000
340c0700606dec5674710000
3484e0006ec6d60a38ba0000
340c0700606dec5674710000
340c0700606dec5674710000
3484e0006ec6d60a38ba0000
340c0700606dec5674710000
3484e0006ec6d60a38ba0000
-
{e=>164478627,a=>-23,d=>7,c=>1,h=>2155,b=>4,g=>3,f=>7}
e90c0700a3becd79af210000
e90c0700a3becd79af210000
e90c0700a3becd79af210000
e984e0009cdbea3ed0d60000
e90c0700a3becd79af210000
e90c0700a3becd79af210000
e984e0009cdbea3ed0d60000
e90c0700a3becd79af210000
e984e0009cdbea3ed0d60000
=
struct umixed_no_pack {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  signed   int   i;
};
-
{e=>31308849,a=>-51,d=>6,c=>1,h=>3257,b=>7,g=>2,f=>6,i=>35}
cd0f060031bcdd61e632000023000000
cd0f060031bcdd61e632000023000000
cd0f060031bcdd61e632000023000000
cde4c0001ddbc31c9972000000000023
cd0f060031bcdd61e632000023000000
cd0f060031bcdd61e632000023000000
cde4c0001ddbc31c9972000000000023
cd0f060031bcdd61e632000023000000
cde4c0001ddbc31c9972000000000023
-
{e=>200850095,a=>59,d=>3,c=>5,h=>4223,b=>2,g=>3,f=>7,i=>-30}
3b2a0300afbaf87bff410000e2ffffff
3b2a0300afbaf87bff410000e2ffffff
3b2a0300afbaf87bff410000e2ffffff
3b546000bf8baafee0fe0000ffffffe2
3b2a0300afbaf87bff410000e2ffffff
3b2a0300afbaf87bff410000e2ffffff
3b546000bf8baafee0fe0000ffffffe2
3b2a0300afbaf87bff410000e2ffffff
3b546000bf8baafee0fe0000ffffffe2
-
{e=>2384984,a=>-78,d=>5,c=>3,h=>4113,b=>0,g=>3,f=>7,i=>33}
b2180500586424704740000021000000
b2180500586424704740000021000000
b2180500586424704740000021000000
b20ca0000246458ee022000000000021
b2180500586424704740000021000000
b2180500586424704740000021000000
b20ca0000246458ee022000000000021
b2180500586424704740000021000000
b20ca0000246458ee022000000000021
-
{e=>170834401,a=>-122,d=>7,c=>0,h=>305,b=>5,g=>1,f=>3,i=>93}
86050700e1b92e3ac50400005d000000
86050700e1b92e3ac50400005d000000
86050700e1b92e3ac50400005d000000
86a0e000a2eb9e16426200000000005d
86050700e1b92e3ac50400005d000000
86050700e1b92e3ac50400005d000000
86a0e000a2eb9e16426200000000005d
86050700e1b92e3ac50400005d000000
86a0e000a2eb9e16426200000000005d
-
{e=>202616049,a=>-1,d=>7,c=>3,h=>4385,b=>5,g=>3,f=>0,i=>101}
ff1d0700f1ac130c8744000065000000
ff1d0700f1ac130c8744000065000000
ff1d0700f1ac130c8744000065000000
fface000c13acf10e242000000000065
ff1d0700f1ac130c8744000065000000
ff1d0700f1ac130c8744000065000000
fface000c13acf10e242000000000065
ff1d0700f1ac130c8744000065000000
fface000c13acf10e242000000000065
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
};
-
{a=>-23,b=>3}
e9ff0300
e9ff0300
e9ff0300
ffe96000
e9ff0300
e9ff0300
ffe96000
e9ff0300
ffe96000
-
{a=>-90,b=>7}
a6ff0700
a6ff0700
a6ff0700
ffa6e000
a6ff0700
a6ff0700
ffa6e000
a6ff0700
ffa6e000
-
{a=>33,b=>2}
21000200
21000200
21000200
00214000
21000200
21000200
00214000
21000200
00214000
-
{a=>-4,b=>6}
fcff0600
fcff0600
fcff0600
fffcc000
fcff0600
fcff0600
fffcc000
fcff0600
fffcc000
-
{a=>-31,b=>5}
e1ff0500
e1ff0500
e1ff0500
ffe1a000
e1ff0500
e1ff0500
ffe1a000
e1ff0500
ffe1a000
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>4,a=>-107,b=>7}
95ff2700
95ff2700
95ff2700
ff95f000
95ff2700
95ff2700
ff95f000
95ff2700
ff95f000
-
{c=>7,a=>6,b=>0}
06003800
06003800
06003800
00061c00
06003800
06003800
00061c00
06003800
00061c00
-
{c=>7,a=>47,b=>6}
2f003e00
2f003e00
2f003e00
002fdc00
2f003e00
2f003e00
002fdc00
2f003e00
002fdc00
-
{c=>2,a=>-33,b=>2}
dfff1200
dfff1200
dfff1200
ffdf4800
dfff1200
dfff1200
ffdf4800
dfff1200
ffdf4800
-
{c=>2,a=>-93,b=>3}
a3ff1300
a3ff1300
a3ff1300
ffa36800
a3ff1300
a3ff1300
ffa36800
a3ff1300
ffa36800
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>4,a=>35,b=>3,d=>7}
2300e301
2300e301
2300e301
00237380
2300e301
2300e301
00237380
2300e301
00237380
-
{c=>1,a=>-77,b=>0,d=>4}
b3ff0801
b3ff0801
b3ff0801
ffb30600
b3ff0801
b3ff0801
ffb30600
b3ff0801
ffb30600
-
{c=>4,a=>-88,b=>6,d=>0}
a8ff2600
a8ff2600
a8ff2600
ffa8d000
a8ff2600
a8ff2600
ffa8d000
a8ff2600
ffa8d000
-
{c=>2,a=>-10,b=>6,d=>4}
f6ff1601
f6ff1601
f6ff1601
fff6ca00
f6ff1601
f6ff1601
fff6ca00
f6ff1601
fff6ca00
-
{c=>2,a=>17,b=>4,d=>3}
1100d400
1100d400
1100d400
00118980
1100d400
1100d400
00118980
1100d400
00118980
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>230924365,c=>5,a=>-34,b=>0,d=>1}
deff68004da0c30d
deff68004da0c30d
deff68004da0c30d
ffde1480dc3a04d0
deff68004da0c30d
deff68004da0c30d
ffde1480dc3a04d0
deff68004da0c30d
ffde1480dc3a04d0
-
{e=>235124443,c=>6,a=>-25,b=>1,d=>0}
e7ff3100dbb6030e
e7ff3100dbb6030e
e7ff3100dbb6030e
ffe73800e03b6db0
e7ff3100dbb6030e
e7ff3100dbb6030e
ffe73800e03b6db0
e7ff3100dbb6030e
ffe73800e03b6db0
-
{e=>218139234,c=>4,a=>-11,b=>4,d=>6}
f5ffa401628a000d
f5ffa401628a000d
f5ffa401628a000d
fff59300d008a620
f5ffa401628a000d
f5ffa401628a000d
fff59300d008a620
f5ffa401628a000d
fff59300d008a620
-
{e=>96460758,c=>3,a=>-25,b=>1,d=>3}
e7ffd900d6dfbf05
e7ffd900d6dfbf05
e7ffd900d6dfbf05
ffe72d805bfdfd60
e7ffd900d6dfbf05
e7ffd900d6dfbf05
ffe72d805bfdfd60
e7ffd900d6dfbf05
ffe72d805bfdfd60
-
{e=>143236939,c=>5,a=>117,b=>3,d=>0}
75002b004b9f8908
75002b004b9f8908
75002b004b9f8908
007574008899f4b0
75002b004b9f8908
75002b004b9f8908
007574008899f4b0
75002b004b9f8908
007574008899f4b0
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>81182875,c=>2,a=>49,b=>2,d=>5,f=>3}
310052019bc0d634
310052019bc0d634
310052019bc0d634
00314a804d6c09b6
310052019bc0d634
310052019bc0d634
00314a804d6c09b6
310052019bc0d634
00314a804d6c09b6
-
{e=>165824077,c=>1,a=>51,b=>0,d=>0,f=>4}
330008004d46e249
330008004d46e249
330008004d46e249
003304009e2464d8
330008004d46e249
330008004d46e249
003304009e2464d8
330008004d46e249
003304009e2464d8
-
{e=>20080403,c=>1,a=>41,b=>4,d=>7,f=>6}
2900cc0113673261
2900cc0113673261
2900cc0113673261
002987801326713c
2900cc0113673261
2900cc0113673261
002987801326713c
2900cc0113673261
002987801326713c
-
{e=>100629693,c=>0,a=>61,b=>6,d=>6,f=>1}
3d008601bd7cff15
3d008601bd7cff15
3d008601bd7cff15
003dc3005ff7cbd2
3d008601bd7cff15
3d008601bd7cff15
003dc3005ff7cbd2
3d008601bd7cff15
003dc3005ff7cbd2
-
{e=>190350127,c=>5,a=>-101,b=>6,d=>0,f=>3}
9bff2e002f83583b
9bff2e002f83583b
9bff2e002f83583b
ff9bd400b58832f6
9bff2e002f83583b
9bff2e002f83583b
ff9bd400b58832f6
9bff2e002f83583b
ff9bd400b58832f6
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>227828092,c=>0,a=>-16,g=>2,b=>1,d=>0,f=>0}
f0ff01007c61940d02000000
f0ff01007c61940d02000000
f0ff01007c61940d02000000
fff02000d94617c080000000
f0ff01007c61940d02000000
f0ff01007c61940d02000000
fff02000d94617c080000000
f0ff01007c61940d02000000
fff02000d94617c080000000
-
{e=>182355747,c=>1,a=>112,g=>0,b=>0,d=>3,f=>7}
7000c8002387de7a00000000
7000c8002387de7a00000000
7000c8002387de7a00000000
00700580ade8723e00000000
7000c8002387de7a00000000
7000c8002387de7a00000000
00700580ade8723e00000000
7000c8002387de7a00000000
00700580ade8723e00000000
-
{e=>183757219,c=>3,a=>117,g=>3,b=>6,d=>6,f=>2}
75009e01a3e9f32a03000000
75009e01a3e9f32a03000000
75009e01a3e9f32a03000000
0075cf00af3e9a34c0000000
75009e01a3e9f32a03000000
75009e01a3e9f32a03000000
0075cf00af3e9a34c0000000
75009e01a3e9f32a03000000
0075cf00af3e9a34c0000000
-
{e=>250036859,c=>6,a=>66,g=>1,b=>2,d=>0,f=>6}
420032007b42e76e01000000
420032007b42e76e01000000
420032007b42e76e01000000
00425800ee7427bc40000000
420032007b42e76e01000000
420032007b42e76e01000000
00425800ee7427bc40000000
420032007b42e76e01000000
00425800ee7427bc40000000
-
{e=>238803723,c=>4,a=>110,g=>0,b=>1,d=>6,f=>1}
6e00a1010bdb3b1e00000000
6e00a1010bdb3b1e00000000
6e00a1010bdb3b1e00000000
006e3300e3bdb0b200000000
6e00a1010bdb3b1e00000000
6e00a1010bdb3b1e00000000
006e3300e3bdb0b200000000
6e00a1010bdb3b1e00000000
006e3300e3bdb0b200000000
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>123354721,a=>77,d=>1,c=>5,h=>6510,b=>2,g=>2,f=>7}
4d006a00613e5a77ba650000
4d006a00613e5a77ba650000
4d006a00613e5a77ba650000
004d548075a3e61eb2dc0000
4d006a00613e5a77ba650000
4d006a00613e5a77ba650000
004d548075a3e61eb2dc0000
4d006a00613e5a77ba650000
004d548075a3e61eb2dc0000
-
{e=>6270702,a=>72,d=>1,c=>2,h=>3832,b=>3,g=>1,f=>4}
48005300eeae5f40e13b0000
48005300eeae5f40e13b0000
48005300eeae5f40e13b0000
0048688005faeee85df00000
48005300eeae5f40e13b0000
48005300eeae5f40e13b0000
0048688005faeee85df00000
48005300eeae5f40e13b0000
0048688005faeee85df00000
-
{e=>151397274,a=>-111,d=>6,c=>7,h=>1061,b=>6,g=>3,f=>3}
91ffbe019a23063997100000
91ffbe019a23063997100000
91ffbe019a23063997100000
ff91df00906239a6c84a0000
91ffbe019a23063997100000
91ffbe019a23063997100000
ff91df00906239a6c84a0000
91ffbe019a23063997100000
ff91df00906239a6c84a0000
-
{e=>139689776,a=>26,d=>3,c=>0,h=>1364,b=>6,g=>1,f=>4}
1a00c600307f534851150000
1a00c600307f534851150000
1a00c600307f534851150000
001ac1808537f3084aa80000
1a00c600307f534851150000
1a00c600307f534851150000
001ac1808537f3084aa80000
1a00c600307f534851150000
001ac1808537f3084aa80000
-
{e=>36719821,a=>73,d=>2,c=>4,h=>2049,b=>7,g=>2,f=>3}
4900a700cd4c303206200000
4900a700cd4c303206200000
4900a700cd4c303206200000
0049f1002304ccd690020000
4900a700cd4c303206200000
4900a700cd4c303206200000
0049f1002304ccd690020000
4900a700cd4c303206200000
0049f1002304ccd690020000
=
struct umixed_no_pack {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  signed   int   i;
};
-
{e=>80052423,a=>38,d=>7,c=>5,h=>719,b=>0,g=>1,f=>2,i=>58}
2600e801c780c5243d0b00003a000000
2600e801c780c5243d0b00003a000000
2600e801c780c5243d0b00003a000000
002617804c580c74459e00000000003a
2600e801c780c5243d0b00003a000000
2600e801c780c5243d0b00003a000000
002617804c580c74459e00000000003a
2600e801c780c5243d0b00003a000000
002617804c580c74459e00000000003a
-
{e=>84879964,a=>-58,d=>2,c=>2,h=>7754,b=>5,g=>2,f=>6,i=>3}
c6ff95005c2a0f652a79000003000000
c6ff95005c2a0f652a79000003000000
c6ff95005c2a0f652a79000003000000
ffc6a90050f2a5ccbc94000000000003
c6ff95005c2a0f652a79000003000000
c6ff95005c2a0f652a79000003000000
ffc6a90050f2a5ccbc94000000000003
c6ff95005c2a0f652a79000003000000
ffc6a90050f2a5ccbc94000000000003
-
{e=>208832370,a=>-38,d=>5,c=>6,h=>7000,b=>7,g=>3,f=>1,i=>27}
daff77017287721c636d00001b000000
daff77017287721c636d00001b000000
daff77017287721c636d00001b000000
ffdafa80c7287722f6b000000000001b
daff77017287721c636d00001b000000
daff77017287721c636d00001b000000
ffdafa80c7287722f6b000000000001b
daff77017287721c636d00001b000000
ffdafa80c7287722f6b000000000001b
-
{e=>224138316,a=>99,d=>4,c=>7,h=>2886,b=>1,g=>1,f=>2,i=>-60}
630039014c145c2d192d0000c4ffffff
630039014c145c2d192d0000c4ffffff
630039014c145c2d192d0000c4ffffff
00633e00d5c144c4568c0000ffffffc4
630039014c145c2d192d0000c4ffffff
630039014c145c2d192d0000c4ffffff
00633e00d5c144c4568c0000ffffffc4
630039014c145c2d192d0000c4ffffff
00633e00d5c144c4568c0000ffffffc4
-
{e=>208271774,a=>61,d=>7,c=>5,h=>4345,b=>5,g=>1,f=>2,i=>-10}
3d00ed019ef9692ce5430000f6ffffff
3d00ed019ef9692ce5430000f6ffffff
3d00ed019ef9692ce5430000f6ffffff
003db780c69f99e461f20000fffffff6
3d00ed019ef9692ce5430000f6ffffff
3d00ed019ef9692ce5430000f6ffffff
003db780c69f99e461f20000fffffff6
3d00ed019ef9692ce5430000f6ffffff
003db780c69f99e461f20000fffffff6
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
};
-
{a=>77,b=>5}
4d00000005000000
4d00000005000000
4d00000005000000
0000004da0000000
4d00000005000000
4d00000005000000
0000004da0000000
4d00000005000000
0000004da0000000
-
{a=>-91,b=>1}
a5ffffff01000000
a5ffffff01000000
a5ffffff01000000
ffffffa520000000
a5ffffff01000000
a5ffffff01000000
ffffffa520000000
a5ffffff01000000
ffffffa520000000
-
{a=>42,b=>3}
2a00000003000000
2a00000003000000
2a00000003000000
0000002a60000000
2a00000003000000
2a00000003000000
0000002a60000000
2a00000003000000
0000002a60000000
-
{a=>-15,b=>3}
f1ffffff03000000
f1ffffff03000000
f1ffffff03000000
fffffff160000000
f1ffffff03000000
f1ffffff03000000
fffffff160000000
f1ffffff03000000
fffffff160000000
-
{a=>-34,b=>2}
deffffff02000000
deffffff02000000
deffffff02000000
ffffffde40000000
deffffff02000000
deffffff02000000
ffffffde40000000
deffffff02000000
ffffffde40000000
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>0,a=>123,b=>7}
7b00000007000000
7b00000007000000
7b00000007000000
0000007be0000000
7b00000007000000
7b00000007000000
0000007be0000000
7b00000007000000
0000007be0000000
-
{c=>5,a=>35,b=>6}
230000002e000000
230000002e000000
230000002e000000
00000023d4000000
230000002e000000
230000002e000000
00000023d4000000
230000002e000000
00000023d4000000
-
{c=>3,a=>-76,b=>4}
b4ffffff1c000000
b4ffffff1c000000
b4ffffff1c000000
ffffffb48c000000
b4ffffff1c000000
b4ffffff1c000000
ffffffb48c000000
b4ffffff1c000000
ffffffb48c000000
-
{c=>6,a=>84,b=>4}
5400000034000000
5400000034000000
5400000034000000
0000005498000000
5400000034000000
5400000034000000
0000005498000000
5400000034000000
0000005498000000
-
{c=>5,a=>-26,b=>5}
e6ffffff2d000000
e6ffffff2d000000
e6ffffff2d000000
ffffffe6b4000000
e6ffffff2d000000
e6ffffff2d000000
ffffffe6b4000000
e6ffffff2d000000
ffffffe6b4000000
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>6,a=>89,b=>0,d=>2}
59000000b0000000
59000000b0000000
59000000b0000000
0000005919000000
59000000b0000000
59000000b0000000
0000005919000000
59000000b0000000
0000005919000000
-
{c=>2,a=>71,b=>6,d=>6}
4700000096010000
4700000096010000
4700000096010000
00000047cb000000
4700000096010000
4700000096010000
00000047cb000000
4700000096010000
00000047cb000000
-
{c=>6,a=>43,b=>6,d=>4}
2b00000036010000
2b00000036010000
2b00000036010000
0000002bda000000
2b00000036010000
2b00000036010000
0000002bda000000
2b00000036010000
0000002bda000000
-
{c=>7,a=>74,b=>6,d=>1}
4a0000007e000000
4a0000007e000000
4a0000007e000000
0000004adc800000
4a0000007e000000
4a0000007e000000
0000004adc800000
4a0000007e000000
0000004adc800000
-
{c=>1,a=>24,b=>1,d=>7}
18000000c9010000
18000000c9010000
18000000c9010000
0000001827800000
18000000c9010000
18000000c9010000
0000001827800000
18000000c9010000
0000001827800000
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>258411058,c=>2,a=>-56,b=>3,d=>1}
c8ffffff53000000320a670f
c8ffffff53000000320a670f
c8ffffff53000000320a670f
ffffffc868800000f670a320
c8ffffff53000000320a670f
c8ffffff53000000320a670f
ffffffc868800000f670a320
c8ffffff53000000320a670f
ffffffc868800000f670a320
-
{e=>192775493,c=>2,a=>6,b=>7,d=>4}
060000001701000045857d0b
060000001701000045857d0b
060000001701000045857d0b
00000006ea000000b7d85450
060000001701000045857d0b
060000001701000045857d0b
00000006ea000000b7d85450
060000001701000045857d0b
00000006ea000000b7d85450
-
{e=>70245712,c=>3,a=>-1,b=>7,d=>1}
ffffffff5f00000050dd2f04
ffffffff5f00000050dd2f04
ffffffff5f00000050dd2f04
ffffffffec80000042fdd500
ffffffff5f00000050dd2f04
ffffffff5f00000050dd2f04
ffffffffec80000042fdd500
ffffffff5f00000050dd2f04
ffffffffec80000042fdd500
-
{e=>100376726,c=>7,a=>115,b=>0,d=>7}
73000000f801000096a0fb05
73000000f801000096a0fb05
73000000f801000096a0fb05
000000731f8000005fba0960
73000000f801000096a0fb05
73000000f801000096a0fb05
000000731f8000005fba0960
73000000f801000096a0fb05
000000731f8000005fba0960
-
{e=>261070995,c=>7,a=>-47,b=>1,d=>0}
d1ffffff3900000093a08f0f
d1ffffff3900000093a08f0f
d1ffffff3900000093a08f0f
ffffffd13c000000f8fa0930
d1ffffff3900000093a08f0f
d1ffffff3900000093a08f0f
ffffffd13c000000f8fa0930
d1ffffff3900000093a08f0f
ffffffd13c000000f8fa0930
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>202903687,c=>1,a=>-41,b=>7,d=>0,f=>7}
d7ffffff0f0000008710187c
d7ffffff0f0000008710187c
d7ffffff0f0000008710187c
ffffffd7e4000000c181087e
d7ffffff0f0000008710187c
d7ffffff0f0000008710187c
ffffffd7e4000000c181087e
d7ffffff0f0000008710187c
ffffffd7e4000000c181087e
-
{e=>156182618,c=>1,a=>83,b=>7,d=>1,f=>1}
530000004f0000005a284f19
530000004f0000005a284f19
530000004f0000005a284f19
00000053e480000094f285a2
530000004f0000005a284f19
530000004f0000005a284f19
00000053e480000094f285a2
530000004f0000005a284f19
00000053e480000094f285a2
-
{e=>30752427,c=>5,a=>-26,b=>6,d=>3,f=>6}
e6ffffffee000000ab3ed561
e6ffffffee000000ab3ed561
e6ffffffee000000ab3ed561
ffffffe6d58000001d53eabc
e6ffffffee000000ab3ed561
e6ffffffee000000ab3ed561
ffffffe6d58000001d53eabc
e6ffffffee000000ab3ed561
ffffffe6d58000001d53eabc
-
{e=>13986533,c=>2,a=>73,b=>0,d=>3,f=>0}
49000000d0000000e56ad500
49000000d0000000e56ad500
49000000d0000000e56ad500
00000049098000000d56ae50
49000000d0000000e56ad500
49000000d0000000e56ad500
00000049098000000d56ae50
49000000d0000000e56ad500
00000049098000000d56ae50
-
{e=>97832562,c=>7,a=>67,b=>3,d=>1,f=>6}
430000007b00000072ced465
430000007b00000072ced465
430000007b00000072ced465
000000437c8000005d4ce72c
430000007b00000072ced465
430000007b00000072ced465
000000437c8000005d4ce72c
430000007b00000072ced465
000000437c8000005d4ce72c
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>224204808,c=>0,a=>-125,g=>3,b=>2,d=>6,f=>5}
83ffffff8201000008185d5d03000000
83ffffff8201000008185d5d03000000
83ffffff8201000008185d5d03000000
ffffff8343000000d5d1808ac0000000
83ffffff8201000008185d5d03000000
83ffffff8201000008185d5d03000000
ffffff8343000000d5d1808ac0000000
83ffffff8201000008185d5d03000000
ffffff8343000000d5d1808ac0000000
-
{e=>248110203,c=>2,a=>32,g=>2,b=>2,d=>2,f=>2}
20000000920000007bdcc92e02000000
20000000920000007bdcc92e02000000
20000000920000007bdcc92e02000000
0000002049000000ec9dc7b480000000
20000000920000007bdcc92e02000000
20000000920000007bdcc92e02000000
0000002049000000ec9dc7b480000000
20000000920000007bdcc92e02000000
0000002049000000ec9dc7b480000000
-
{e=>176808355,c=>3,a=>74,g=>3,b=>7,d=>1,f=>0}
4a0000005f000000a3e1890a03000000
4a0000005f000000a3e1890a03000000
4a0000005f000000a3e1890a03000000
0000004aec800000a89e1a30c0000000
4a0000005f000000a3e1890a03000000
4a0000005f000000a3e1890a03000000
0000004aec800000a89e1a30c0000000
4a0000005f000000a3e1890a03000000
0000004aec800000a89e1a30c0000000
-
{e=>200366377,c=>3,a=>-125,g=>2,b=>4,d=>6,f=>4}
83ffffff9c0100002959f14b02000000
83ffffff9c0100002959f14b02000000
83ffffff9c0100002959f14b02000000
ffffff838f000000bf15929880000000
83ffffff9c0100002959f14b02000000
83ffffff9c0100002959f14b02000000
ffffff838f000000bf15929880000000
83ffffff9c0100002959f14b02000000
ffffff838f000000bf15929880000000
-
{e=>40965455,c=>3,a=>107,g=>2,b=>0,d=>3,f=>4}
6b000000d80000004f15714202000000
6b000000d80000004f15714202000000
6b000000d80000004f15714202000000
0000006b0d800000271154f880000000
6b000000d80000004f15714202000000
6b000000d80000004f15714202000000
0000006b0d800000271154f880000000
6b000000d80000004f15714202000000
0000006b0d800000271154f880000000
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>261834522,a=>113,d=>2,c=>3,h=>1720,b=>5,g=>2,f=>7}
710000009d0000001a479b7fe21a0000
710000009d0000001a479b7fe21a0000
710000009d0000001a479b7fe21a0000
00000071ad000000f9b471ae8d700000
710000009d0000001a479b7fe21a0000
710000009d0000001a479b7fe21a0000
00000071ad000000f9b471ae8d700000
710000009d0000001a479b7fe21a0000
00000071ad000000f9b471ae8d700000
-
{e=>81177197,a=>52,d=>7,c=>0,h=>7442,b=>0,g=>0,f=>3}
34000000c00100006daad63448740000
34000000c00100006daad63448740000
34000000c00100006daad63448740000
00000034038000004d6aa6d63a240000
34000000c00100006daad63448740000
34000000c00100006daad63448740000
00000034038000004d6aa6d63a240000
34000000c00100006daad63448740000
00000034038000004d6aa6d63a240000
-
{e=>252859983,a=>117,d=>4,c=>2,h=>3820,b=>7,g=>1,f=>3}
75000000170100004f56123fb13b0000
75000000170100004f56123fb13b0000
75000000170100004f56123fb13b0000
00000075ea000000f12564f65dd80000
75000000170100004f56123fb13b0000
75000000170100004f56123fb13b0000
00000075ea000000f12564f65dd80000
75000000170100004f56123fb13b0000
00000075ea000000f12564f65dd80000
-
{e=>260755755,a=>39,d=>6,c=>3,h=>5333,b=>4,g=>1,f=>6}
270000009c0100002bd18a6f55530000
270000009c0100002bd18a6f55530000
270000009c0100002bd18a6f55530000
000000278f000000f8ad12bc69aa0000
270000009c0100002bd18a6f55530000
270000009c0100002bd18a6f55530000
000000278f000000f8ad12bc69aa0000
270000009c0100002bd18a6f55530000
000000278f000000f8ad12bc69aa0000
-
{e=>197646476,a=>44,d=>1,c=>0,h=>1255,b=>0,g=>1,f=>7}
2c000000400000008cd8c77b9d130000
2c000000400000008cd8c77b9d130000
2c000000400000008cd8c77b9d130000
0000002c00800000bc7d88ce49ce0000
2c000000400000008cd8c77b9d130000
2c000000400000008cd8c77b9d130000
0000002c00800000bc7d88ce49ce0000
2c000000400000008cd8c77b9d130000
0000002c00800000bc7d88ce49ce0000
=
struct umixed_no_pack {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  signed   int   i;
};
-
{e=>3714946,a=>-88,d=>6,c=>2,h=>3065,b=>4,g=>0,f=>1,i=>-7}
a8ffffff9401000082af3810e42f0000f9ffffff
a8ffffff9401000082af3810e42f0000f9ffffff
a8ffffff9401000082af3810e42f0000f9ffffff
ffffffa88b000000038af82217f20000fffffff9
a8ffffff9401000082af3810e42f0000f9ffffff
a8ffffff9401000082af3810e42f0000f9ffffff
ffffffa88b000000038af82217f20000fffffff9
a8ffffff9401000082af3810e42f0000f9ffffff
ffffffa88b000000038af82217f20000fffffff9
-
{e=>217660046,a=>63,d=>4,c=>2,h=>4968,b=>5,g=>3,f=>5,i=>-17}
3f000000150100008e3af95ca34d0000efffffff
3f000000150100008e3af95ca34d0000efffffff
3f000000150100008e3af95ca34d0000efffffff
0000003faa000000cf93a8eae6d00000ffffffef
3f000000150100008e3af95ca34d0000efffffff
3f000000150100008e3af95ca34d0000efffffff
0000003faa000000cf93a8eae6d00000ffffffef
3f000000150100008e3af95ca34d0000efffffff
0000003faa000000cf93a8eae6d00000ffffffef
-
{e=>50265395,a=>101,d=>1,c=>3,h=>1816,b=>7,g=>1,f=>7,i=>113}
650000005f00000033fdfe72611c000071000000
650000005f00000033fdfe72611c000071000000
650000005f00000033fdfe72611c000071000000
00000065ec8000002fefd33e4e30000000000071
650000005f00000033fdfe72611c000071000000
650000005f00000033fdfe72611c000071000000
00000065ec8000002fefd33e4e30000000000071
650000005f00000033fdfe72611c000071000000
00000065ec8000002fefd33e4e30000000000071
-
{e=>165795744,a=>11,d=>5,c=>4,h=>2771,b=>2,g=>3,f=>6,i=>-6}
0b00000062010000a0d7e1694f2b0000faffffff
0b00000062010000a0d7e1694f2b0000faffffff
0b00000062010000a0d7e1694f2b0000faffffff
0000000b528000009e1d7a0cd5a60000fffffffa
0b00000062010000a0d7e1694f2b0000faffffff
0b00000062010000a0d7e1694f2b0000faffffff
0000000b528000009e1d7a0cd5a60000fffffffa
0b00000062010000a0d7e1694f2b0000faffffff
0000000b528000009e1d7a0cd5a60000fffffffa
-
{e=>246643849,a=>56,d=>5,c=>2,h=>3254,b=>0,g=>3,f=>7,i=>-43}
3800000050010000897cb37edb320000d5ffffff
3800000050010000897cb37edb320000d5ffffff
3800000050010000897cb37edb320000d5ffffff
000000380a800000eb37c89ed96c0000ffffffd5
3800000050010000897cb37edb320000d5ffffff
3800000050010000897cb37edb320000d5ffffff
000000380a800000eb37c89ed96c0000ffffffd5
3800000050010000897cb37edb320000d5ffffff
000000380a800000eb37c89ed96c0000ffffffd5
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
};
-
{a=>-22,b=>3}
eaffffff03000000
eaffffffffffffff0300000000000000
eaffffffffffffff0300000000000000
ffffffea60000000
eaffffff03000000
eaffffff03000000
ffffffffffffffea6000000000000000
eaffffff03000000
ffffffea60000000
-
{a=>15,b=>0}
0f00000000000000
0f000000000000000000000000000000
0f000000000000000000000000000000
0000000f00000000
0f00000000000000
0f00000000000000
000000000000000f0000000000000000
0f00000000000000
0000000f00000000
-
{a=>-58,b=>4}
c6ffffff04000000
c6ffffffffffffff0400000000000000
c6ffffffffffffff0400000000000000
ffffffc680000000
c6ffffff04000000
c6ffffff04000000
ffffffffffffffc68000000000000000
c6ffffff04000000
ffffffc680000000
-
{a=>39,b=>0}
2700000000000000
27000000000000000000000000000000
27000000000000000000000000000000
0000002700000000
2700000000000000
2700000000000000
00000000000000270000000000000000
2700000000000000
0000002700000000
-
{a=>55,b=>0}
3700000000000000
37000000000000000000000000000000
37000000000000000000000000000000
0000003700000000
3700000000000000
3700000000000000
00000000000000370000000000000000
3700000000000000
0000003700000000
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>6,a=>53,b=>3}
3500000033000000
35000000000000003300000000000000
35000000000000003300000000000000
0000003578000000
3500000033000000
3500000033000000
00000000000000357800000000000000
3500000033000000
0000003578000000
-
{c=>6,a=>-101,b=>4}
9bffffff34000000
9bffffffffffffff3400000000000000
9bffffffffffffff3400000000000000
ffffff9b98000000
9bffffff34000000
9bffffff34000000
ffffffffffffff9b9800000000000000
9bffffff34000000
ffffff9b98000000
-
{c=>6,a=>62,b=>1}
3e00000031000000
3e000000000000003100000000000000
3e000000000000003100000000000000
0000003e38000000
3e00000031000000
3e00000031000000
000000000000003e3800000000000000
3e00000031000000
0000003e38000000
-
{c=>5,a=>-63,b=>5}
c1ffffff2d000000
c1ffffffffffffff2d00000000000000
c1ffffffffffffff2d00000000000000
ffffffc1b4000000
c1ffffff2d000000
c1ffffff2d000000
ffffffffffffffc1b400000000000000
c1ffffff2d000000
ffffffc1b4000000
-
{c=>2,a=>26,b=>4}
1a00000014000000
1a000000000000001400000000000000
1a000000000000001400000000000000
0000001a88000000
1a00000014000000
1a00000014000000
000000000000001a8800000000000000
1a00000014000000
0000001a88000000
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>7,a=>84,b=>5,d=>0}
540000003d000000
54000000000000003d00000000000000
54000000000000003d00000000000000
00000054bc000000
540000003d000000
540000003d000000
0000000000000054bc00000000000000
540000003d000000
00000054bc000000
-
{c=>2,a=>-4,b=>6,d=>7}
fcffffffd6010000
fcffffffffffffffd601000000000000
fcffffffffffffffd601000000000000
fffffffccb800000
fcffffffd6010000
fcffffffd6010000
fffffffffffffffccb80000000000000
fcffffffd6010000
fffffffccb800000
-
{c=>0,a=>-1,b=>2,d=>4}
ffffffff02010000
ffffffffffffffff0201000000000000
ffffffffffffffff0201000000000000
ffffffff42000000
ffffffff02010000
ffffffff02010000
ffffffffffffffff4200000000000000
ffffffff02010000
ffffffff42000000
-
{c=>5,a=>75,b=>2,d=>1}
4b0000006a000000
4b000000000000006a00000000000000
4b000000000000006a00000000000000
0000004b54800000
4b0000006a000000
4b0000006a000000
000000000000004b5480000000000000
4b0000006a000000
0000004b54800000
-
{c=>1,a=>-35,b=>2,d=>2}
ddffffff8a000000
ddffffffffffffff8a00000000000000
ddffffffffffffff8a00000000000000
ffffffdd45000000
ddffffff8a000000
ddffffff8a000000
ffffffffffffffdd4500000000000000
ddffffff8a000000
ffffffdd45000000
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>12846720,c=>5,a=>-2,b=>6,d=>4}
feffffff2e0100008006c400
feffffffffffffff2e0100008006c400
feffffffffffffff2e0100008006c400
fffffffed60000000c406800
feffffff2e0100008006c400
feffffff2e0100008006c400
fffffffffffffffed60000000c406800
feffffff2e0100008006c400
fffffffed60000000c406800
-
{e=>122850482,c=>0,a=>44,b=>4,d=>5}
2c00000044010000b28c5207
2c0000000000000044010000b28c5207
2c0000000000000044010000b28c5207
0000002c828000007528cb20
2c00000044010000b28c5207
2c00000044010000b28c5207
000000000000002c828000007528cb20
2c00000044010000b28c5207
0000002c828000007528cb20
-
{e=>110531108,c=>0,a=>6,b=>7,d=>5}
060000004701000024929606
06000000000000004701000024929606
06000000000000004701000024929606
00000006e280000069692240
060000004701000024929606
060000004701000024929606
0000000000000006e280000069692240
060000004701000024929606
00000006e280000069692240
-
{e=>172922041,c=>3,a=>-21,b=>6,d=>1}
ebffffff5e000000b9944e0a
ebffffffffffffff5e000000b9944e0a
ebffffffffffffff5e000000b9944e0a
ffffffebcc800000a4e94b90
ebffffff5e000000b9944e0a
ebffffff5e000000b9944e0a
ffffffffffffffebcc800000a4e94b90
ebffffff5e000000b9944e0a
ffffffebcc800000a4e94b90
-
{e=>55535187,c=>1,a=>-73,b=>2,d=>3}
b7ffffffca00000053664f03
b7ffffffffffffffca00000053664f03
b7ffffffffffffffca00000053664f03
ffffffb74580000034f66530
b7ffffffca00000053664f03
b7ffffffca00000053664f03
ffffffffffffffb74580000034f66530
b7ffffffca00000053664f03
ffffffb74580000034f66530
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>66805985,c=>5,a=>115,b=>6,d=>2,f=>6}
73000000ae000000e160fb63
7300000000000000ae000000e160fb63
7300000000000000ae000000e160fb63
00000073d50000003fb60e1c
73000000ae000000e160fb63
73000000ae000000e160fb63
0000000000000073d50000003fb60e1c
73000000ae000000e160fb63
00000073d50000003fb60e1c
-
{e=>217412345,c=>5,a=>83,b=>2,d=>7,f=>1}
53000000ea010000f972f51c
5300000000000000ea010000f972f51c
5300000000000000ea010000f972f51c
0000005357800000cf572f92
53000000ea010000f972f51c
53000000ea010000f972f51c
000000000000005357800000cf572f92
53000000ea010000f972f51c
0000005357800000cf572f92
-
{e=>143288860,c=>4,a=>80,b=>4,d=>7,f=>2}
50000000e40100001c6a8a28
5000000000000000e40100001c6a8a28
5000000000000000e40100001c6a8a28
000000509380000088a6a1c4
50000000e40100001c6a8a28
50000000e40100001c6a8a28
00000000000000509380000088a6a1c4
50000000e40100001c6a8a28
000000509380000088a6a1c4
-
{e=>80533529,c=>3,a=>-56,b=>0,d=>4,f=>3}
c8ffffff1801000019d8cc34
c8ffffffffffffff1801000019d8cc34
c8ffffffffffffff1801000019d8cc34
ffffffc80e0000004ccd8196
c8ffffff1801000019d8cc34
c8ffffff1801000019d8cc34
ffffffffffffffc80e0000004ccd8196
c8ffffff1801000019d8cc34
ffffffc80e0000004ccd8196
-
{e=>76049210,c=>4,a=>41,b=>4,d=>0,f=>2}
29000000240000003a6b8824
2900000000000000240000003a6b8824
2900000000000000240000003a6b8824
00000029900000004886b3a4
29000000240000003a6b8824
29000000240000003a6b8824
0000000000000029900000004886b3a4
29000000240000003a6b8824
00000029900000004886b3a4
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>33149186,c=>0,a=>-66,g=>2,b=>6,d=>0,f=>2}
beffffff0600000002d1f92102000000
beffffffffffffff0600000002d1f9210200000000000000
beffffffffffffff0600000002d1f9210200000000000000
ffffffbec00000001f9d102480000000
beffffff0600000002d1f92102000000
beffffff0600000002d1f92102000000
ffffffffffffffbec00000001f9d10248000000000000000
beffffff0600000002d1f92102000000
ffffffbec00000001f9d102480000000
-
{e=>24018713,c=>6,a=>42,g=>0,b=>3,d=>1,f=>7}
2a00000073000000197f6e7100000000
2a0000000000000073000000197f6e710000000000000000
2a0000000000000073000000197f6e710000000000000000
0000002a7880000016e7f19e00000000
2a00000073000000197f6e7100000000
2a00000073000000197f6e7100000000
000000000000002a7880000016e7f19e0000000000000000
2a00000073000000197f6e7100000000
0000002a7880000016e7f19e00000000
-
{e=>238049791,c=>1,a=>-89,g=>0,b=>5,d=>4,f=>3}
a7ffffff0d010000ff59303e00000000
a7ffffffffffffff0d010000ff59303e0000000000000000
a7ffffffffffffff0d010000ff59303e0000000000000000
ffffffa7a6000000e3059ff600000000
a7ffffff0d010000ff59303e00000000
a7ffffff0d010000ff59303e00000000
ffffffffffffffa7a6000000e3059ff60000000000000000
a7ffffff0d010000ff59303e00000000
ffffffa7a6000000e3059ff600000000
-
{e=>45452680,c=>4,a=>85,g=>3,b=>5,d=>4,f=>2}
5500000025010000888db52203000000
550000000000000025010000888db5220300000000000000
550000000000000025010000888db5220300000000000000
00000055b20000002b58d884c0000000
5500000025010000888db52203000000
5500000025010000888db52203000000
0000000000000055b20000002b58d884c000000000000000
5500000025010000888db52203000000
00000055b20000002b58d884c0000000
-
{e=>127560049,c=>0,a=>38,g=>3,b=>5,d=>1,f=>4}
260000004500000071699a4703000000
26000000000000004500000071699a470300000000000000
26000000000000004500000071699a470300000000000000
00000026a080000079a69718c0000000
260000004500000071699a4703000000
260000004500000071699a4703000000
0000000000000026a080000079a69718c000000000000000
260000004500000071699a4703000000
00000026a080000079a69718c0000000
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>143259895,a=>-70,d=>4,c=>3,h=>4312,b=>6,g=>0,f=>5}
baffffff1e010000f7f8895860430000
baffffffffffffff1e010000f7f889586043000000000000
baffffffffffffff1e010000f7f889586043000000000000
ffffffbace000000889f8f7a21b00000
baffffff1e010000f7f8895860430000
baffffff1e010000f7f8895860430000
ffffffffffffffbace000000889f8f7a21b0000000000000
baffffff1e010000f7f8895860430000
ffffffbace000000889f8f7a21b00000
-
{e=>130209381,a=>75,d=>3,c=>6,h=>1172,b=>2,g=>1,f=>0}
4b000000f200000065d6c20751120000
4b00000000000000f200000065d6c2075112000000000000
4b00000000000000f200000065d6c2075112000000000000
0000004b598000007c2d665049280000
4b000000f200000065d6c20751120000
4b000000f200000065d6c20751120000
000000000000004b598000007c2d66504928000000000000
4b000000f200000065d6c20751120000
0000004b598000007c2d665049280000
-
{e=>169515883,a=>36,d=>3,c=>7,h=>7983,b=>7,g=>2,f=>0}
24000000ff0000006b9b1a0abe7c0000
2400000000000000ff0000006b9b1a0abe7c000000000000
2400000000000000ff0000006b9b1a0abe7c000000000000
00000024fd800000a1a9b6b0be5e0000
24000000ff0000006b9b1a0abe7c0000
24000000ff0000006b9b1a0abe7c0000
0000000000000024fd800000a1a9b6b0be5e000000000000
24000000ff0000006b9b1a0abe7c0000
00000024fd800000a1a9b6b0be5e0000
-
{e=>204680465,a=>-15,d=>2,c=>5,h=>8017,b=>2,g=>0,f=>6}
f1ffffffaa000000112d336c447d0000
f1ffffffffffffffaa000000112d336c447d000000000000
f1ffffffffffffffaa000000112d336c447d000000000000
fffffff155000000c332d11c3ea20000
f1ffffffaa000000112d336c447d0000
f1ffffffaa000000112d336c447d0000
fffffffffffffff155000000c332d11c3ea2000000000000
f1ffffffaa000000112d336c447d0000
fffffff155000000c332d11c3ea20000
-
{e=>243063688,a=>85,d=>2,c=>6,h=>342,b=>2,g=>0,f=>3}
55000000b200000088db7c3e58050000
5500000000000000b200000088db7c3e5805000000000000
5500000000000000b200000088db7c3e5805000000000000
0000005559000000e7cdb88602ac0000
55000000b200000088db7c3e58050000
55000000b200000088db7c3e58050000
000000000000005559000000e7cdb88602ac000000000000
55000000b200000088db7c3e58050000
0000005559000000e7cdb88602ac0000
=
struct umixed_no_pack {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  signed   int   i;
};
-
{e=>256419346,a=>25,d=>4,c=>1,h=>4924,b=>3,g=>1,f=>2,i=>-112}
190000000b01000012a6482ff14c000090ffffff
19000000000000000b01000012a6482ff14c000090ffffff
19000000000000000b01000012a6482ff14c000090ffffff
0000001966000000f48a612466780000ffffff90
190000000b01000012a6482ff14c000090ffffff
190000000b01000012a6482ff14c000090ffffff
000000000000001966000000f48a612466780000ffffff90
190000000b01000012a6482ff14c000090ffffff
0000001966000000f48a612466780000ffffff90
-
{e=>155022430,a=>75,d=>3,c=>2,h=>362,b=>7,g=>2,f=>1,i=>-49}
4b000000d70000005e743d19aa050000cfffffff
4b00000000000000d70000005e743d19aa050000cfffffff
4b00000000000000d70000005e743d19aa050000cfffffff
0000004be980000093d745e282d40000ffffffcf
4b000000d70000005e743d19aa050000cfffffff
4b000000d70000005e743d19aa050000cfffffff
000000000000004be980000093d745e282d40000ffffffcf
4b000000d70000005e743d19aa050000cfffffff
0000004be980000093d745e282d40000ffffffcf
-
{e=>190447867,a=>-73,d=>1,c=>2,h=>2876,b=>7,g=>0,f=>7,i=>1}
b7ffffff57000000fb005a7bf02c000001000000
b7ffffffffffffff57000000fb005a7bf02c000001000000
b7ffffffffffffff57000000fb005a7bf02c000001000000
ffffffb7e8800000b5a00fbe1678000000000001
b7ffffff57000000fb005a7bf02c000001000000
b7ffffff57000000fb005a7bf02c000001000000
ffffffffffffffb7e8800000b5a00fbe1678000000000001
b7ffffff57000000fb005a7bf02c000001000000
ffffffb7e8800000b5a00fbe1678000000000001
-
{e=>179690236,a=>9,d=>7,c=>0,h=>7267,b=>7,g=>1,f=>0,i=>-85}
09000000c7010000fcdab50a8d710000abffffff
0900000000000000c7010000fcdab50a8d710000abffffff
0900000000000000c7010000fcdab50a8d710000abffffff
00000009e3800000ab5dafc078c60000ffffffab
09000000c7010000fcdab50a8d710000abffffff
09000000c7010000fcdab50a8d710000abffffff
0000000000000009e3800000ab5dafc078c60000ffffffab
09000000c7010000fcdab50a8d710000abffffff
00000009e3800000ab5dafc078c60000ffffffab
-
{e=>104415787,a=>74,d=>7,c=>3,h=>3028,b=>4,g=>3,f=>7,i=>92}
4a000000dc0100002b423976532f00005c000000
4a00000000000000dc0100002b423976532f00005c000000
4a00000000000000dc0100002b423976532f00005c000000
0000004a8f800000639422bed7a800000000005c
4a000000dc0100002b423976532f00005c000000
4a000000dc0100002b423976532f00005c000000
000000000000004a8f800000639422bed7a800000000005c
4a000000dc0100002b423976532f00005c000000
0000004a8f800000639422bed7a800000000005c
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
};
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
-
{a=>3}
03
03
03
60
03000000
03
60
03
60
-
{a=>5}
05
05
05
a0
05000000
05
a0
05
a0
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
};
-
{a=>4,b=>3}
1c
1c
1c
8c
1c000000
1c
8c
1c
8c
-
{a=>5,b=>6}
35
35
35
b8
35000000
35
b8
35
b8
-
{a=>1,b=>3}
19
19
19
2c
19000000
19
2c
19
2c
-
{a=>7,b=>6}
37
37
37
f8
37000000
37
f8
37
f8
-
{a=>1,b=>0}
01
01
01
20
01000000
01
20
01
20
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
};
-
{c=>7,a=>2,b=>6}
f201
f201
f201
5b80
f2010000
f201
5b80
f201
5b80
-
{c=>3,a=>1,b=>4}
e100
e100
e100
3180
e1000000
e100
3180
e100
3180
-
{c=>0,a=>2,b=>1}
0a00
0a00
0a00
4400
0a000000
0a00
4400
0a00
4400
-
{c=>7,a=>6,b=>6}
f601
f601
f601
db80
f6010000
f601
db80
f601
db80
-
{c=>6,a=>5,b=>3}
9d01
9d01
9d01
af00
9d010000
9d01
af00
9d01
af00
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
};
-
{c=>3,a=>4,b=>6,d=>50977657}
f400000079db0903
f400000079db0903
f400000079db0903
99800000309db790
f400000079db0903
f400000079db0903
99800000309db790
f400000079db0903
99800000309db790
-
{c=>4,a=>1,b=>0,d=>156580251}
010100009b395509
010100009b395509
010100009b395509
22000000955399b0
010100009b395509
010100009b395509
22000000955399b0
010100009b395509
22000000955399b0
-
{c=>0,a=>6,b=>1,d=>120765803}
0e0000006bbd3207
0e0000006bbd3207
0e0000006bbd3207
c4000000732bd6b0
0e0000006bbd3207
0e0000006bbd3207
c4000000732bd6b0
0e0000006bbd3207
c4000000732bd6b0
-
{c=>5,a=>6,b=>4,d=>190259749}
660100002522570b
660100002522570b
660100002522570b
d2800000b5722250
660100002522570b
660100002522570b
d2800000b5722250
660100002522570b
d2800000b5722250
-
{c=>3,a=>6,b=>1,d=>14877875}
ce000000b304e300
ce000000b304e300
ce000000b304e300
c58000000e304b30
ce000000b304e300
ce000000b304e300
c58000000e304b30
ce000000b304e300
c58000000e304b30
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
};
-
{e=>7,c=>0,a=>5,b=>4,d=>131151049}
25000000c934d177
25000000c934d177
25000000c934d177
b00000007d134c9e
25000000c934d177
25000000c934d177
b00000007d134c9e
25000000c934d177
b00000007d134c9e
-
{e=>4,c=>6,a=>0,b=>3,d=>27196562}
9801000092fc9e41
9801000092fc9e41
9801000092fc9e41
0f00000019efc928
9801000092fc9e41
9801000092fc9e41
0f00000019efc928
9801000092fc9e41
0f00000019efc928
-
{e=>5,c=>2,a=>5,b=>2,d=>79198194}
95000000f277b854
95000000f277b854
95000000f277b854
a90000004b877f2a
95000000f277b854
95000000f277b854
a90000004b877f2a
95000000f277b854
a90000004b877f2a
-
{e=>1,c=>6,a=>1,b=>1,d=>53011008}
8901000040e22813
8901000040e22813
8901000040e22813
27000000328e2402
8901000040e22813
8901000040e22813
27000000328e2402
8901000040e22813
27000000328e2402
-
{e=>3,c=>0,a=>3,b=>5,d=>229669114}
2b000000fa78b03d
2b000000fa78b03d
2b000000fa78b03d
74000000db078fa6
2b000000fa78b03d
2b000000fa78b03d
74000000db078fa6
2b000000fa78b03d
74000000db078fa6
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
};
-
{e=>7,c=>4,a=>3,b=>2,d=>224213968,f=>0}
13010000d03b5d7d00000000
13010000d03b5d7d00000000
13010000d03b5d7d00000000
6a000000d5d3bd0e00000000
13010000d03b5d7d00000000
13010000d03b5d7d00000000
6a000000d5d3bd0e00000000
13010000d03b5d7d00000000
6a000000d5d3bd0e00000000
-
{e=>5,c=>0,a=>6,b=>7,d=>149199438,f=>2}
3e0000004e9ae45802000000
3e0000004e9ae45802000000
3e0000004e9ae45802000000
dc0000008e49a4ea80000000
3e0000004e9ae45802000000
3e0000004e9ae45802000000
dc0000008e49a4ea80000000
3e0000004e9ae45802000000
dc0000008e49a4ea80000000
-
{e=>4,c=>7,a=>4,b=>6,d=>212284222,f=>0}
f40100003e33a74c00000000
f40100003e33a74c00000000
f40100003e33a74c00000000
9b800000ca7333e800000000
f40100003e33a74c00000000
f40100003e33a74c00000000
9b800000ca7333e800000000
f40100003e33a74c00000000
9b800000ca7333e800000000
-
{e=>0,c=>4,a=>1,b=>3,d=>183266435,f=>3}
19010000836cec0a03000000
19010000836cec0a03000000
19010000836cec0a03000000
2e000000aec6c830c0000000
19010000836cec0a03000000
19010000836cec0a03000000
2e000000aec6c830c0000000
19010000836cec0a03000000
2e000000aec6c830c0000000
-
{e=>3,c=>3,a=>2,b=>0,d=>193465720,f=>3}
c2000000780d883b03000000
c2000000780d883b03000000
c2000000780d883b03000000
41800000b880d786c0000000
c2000000780d883b03000000
c2000000780d883b03000000
41800000b880d786c0000000
c2000000780d883b03000000
41800000b880d786c0000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
};
-
{e=>2,c=>0,a=>4,g=>7279,b=>3,d=>226086089,f=>0}
1c000000c9cc792dbc710000
1c000000c9cc792dbc710000
1c000000c9cc792dbc710000
8c000000d79ccc9438de0000
1c000000c9cc792dbc710000
1c000000c9cc792dbc710000
8c000000d79ccc9438de0000
1c000000c9cc792dbc710000
8c000000d79ccc9438de0000
-
{e=>4,c=>1,a=>5,g=>1474,b=>6,d=>135043372,f=>2}
750000002c990c480a170000
750000002c990c480a170000
750000002c990c480a170000
b880000080c992c88b840000
750000002c990c480a170000
750000002c990c480a170000
b880000080c992c88b840000
750000002c990c480a170000
b880000080c992c88b840000
-
{e=>0,c=>2,a=>4,g=>4289,b=>6,d=>167538358,f=>2}
b4000000b66efc0906430000
b4000000b66efc0906430000
b4000000b66efc0906430000
990000009fc6eb60a1820000
b4000000b66efc0906430000
b4000000b66efc0906430000
990000009fc6eb60a1820000
b4000000b66efc0906430000
990000009fc6eb60a1820000
-
{e=>3,c=>4,a=>0,g=>1460,b=>0,d=>191785714,f=>1}
00010000f26a6e3bd1160000
00010000f26a6e3bd1160000
00010000f26a6e3bd1160000
02000000b6e6af264b680000
00010000f26a6e3bd1160000
00010000f26a6e3bd1160000
02000000b6e6af264b680000
00010000f26a6e3bd1160000
02000000b6e6af264b680000
-
{e=>1,c=>0,a=>4,g=>4192,b=>7,d=>193646184,f=>0}
3c00000068ce8a1b80410000
3c00000068ce8a1b80410000
3c00000068ce8a1b80410000
9c000000b8ace68220c00000
3c00000068ce8a1b80410000
3c00000068ce8a1b80410000
9c000000b8ace68220c00000
3c00000068ce8a1b80410000
9c000000b8ace68220c00000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
  unsigned char  h;
};
-
{e=>2,a=>6,d=>72412399,c=>7,h=>156,b=>2,g=>1487,f=>3}
d6010000efec50243f179c00
d6010000efec50243f179c00
d6010000efec50243f179c00
cb800000450ecef4cb9e9c00
d6010000efec50243f179c00
d6010000efec50243f179c00
cb800000450ecef4cb9e9c00
d6010000efec50243f179c00
cb800000450ecef4cb9e9c00
-
{e=>6,a=>3,d=>227300670,c=>1,h=>201,b=>3,g=>4275,f=>1}
5b0000003e558c6dcd42c900
5b0000003e558c6dcd42c900
5b0000003e558c6dcd42c900
6c800000d8c553ec6166c900
5b0000003e558c6dcd42c900
5b0000003e558c6dcd42c900
6c800000d8c553ec6166c900
5b0000003e558c6dcd42c900
6c800000d8c553ec6166c900
-
{e=>3,a=>7,d=>180879568,c=>1,h=>224,b=>5,g=>7892,f=>3}
6f000000d000c83a537be000
6f000000d000c83a537be000
6f000000d000c83a537be000
f4800000ac800d06fda8e000
6f000000d000c83a537be000
6f000000d000c83a537be000
f4800000ac800d06fda8e000
6f000000d000c83a537be000
f4800000ac800d06fda8e000
-
{e=>3,a=>0,d=>137129408,c=>6,h=>116,b=>2,g=>269,f=>0}
90010000c06d2c3834047400
90010000c06d2c3834047400
90010000c06d2c3834047400
0b00000082c6dc06021a7400
90010000c06d2c3834047400
90010000c06d2c3834047400
0b00000082c6dc06021a7400
90010000c06d2c3834047400
0b00000082c6dc06021a7400
-
{e=>1,a=>3,d=>206927027,c=>2,h=>226,b=>7,g=>3383,f=>2}
bb000000b374551cde34e200
bb000000b374551cde34e200
bb000000b374551cde34e200
7d000000c5574b329a6ee200
bb000000b374551cde34e200
bb000000b374551cde34e200
7d000000c5574b329a6ee200
bb000000b374551cde34e200
7d000000c5574b329a6ee200
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
};
-
{a=>5,b=>0}
0500
0500
0500
0500
05000000
0500
0500
0500
0500
-
{a=>53,b=>0}
3500
3500
3500
3500
35000000
3500
3500
3500
3500
-
{a=>83,b=>5}
5305
5305
5305
53a0
53050000
5305
53a0
5305
53a0
-
{a=>4,b=>3}
0403
0403
0403
0460
04030000
0403
0460
0403
0460
-
{a=>-108,b=>1}
9401
9401
9401
9420
94010000
9401
9420
9401
9420
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>4,a=>-89,b=>5}
a725
a725
a725
a7b0
a7250000
a725
a7b0
a725
a7b0
-
{c=>3,a=>-94,b=>1}
a219
a219
a219
a22c
a2190000
a219
a22c
a219
a22c
-
{c=>2,a=>41,b=>1}
2911
2911
2911
2928
29110000
2911
2928
2911
2928
-
{c=>0,a=>-104,b=>5}
9805
9805
9805
98a0
98050000
9805
98a0
9805
98a0
-
{c=>4,a=>123,b=>7}
7b27
7b27
7b27
7bf0
7b270000
7b27
7bf0
7b27
7bf0
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>1,a=>26,b=>2,d=>6}
1a0a0600
1a0a0600
1a0a0600
1a44c000
1a0a0600
1a0a0600
1a44c000
1a0a0600
1a44c000
-
{c=>0,a=>41,b=>3,d=>7}
29030700
29030700
29030700
2960e000
29030700
29030700
2960e000
29030700
2960e000
-
{c=>0,a=>-60,b=>7,d=>5}
c4070500
c4070500
c4070500
c4e0a000
c4070500
c4070500
c4e0a000
c4070500
c4e0a000
-
{c=>4,a=>21,b=>5,d=>1}
15250100
15250100
15250100
15b02000
15250100
15250100
15b02000
15250100
15b02000
-
{c=>1,a=>-57,b=>3,d=>7}
c70b0700
c70b0700
c70b0700
c764e000
c70b0700
c70b0700
c764e000
c70b0700
c764e000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>251650091,c=>3,a=>18,b=>2,d=>6}
121a06002be0ff0e
121a06002be0ff0e
121a06002be0ff0e
124cc000effe02b0
121a06002be0ff0e
121a06002be0ff0e
124cc000effe02b0
121a06002be0ff0e
124cc000effe02b0
-
{e=>184337798,c=>4,a=>67,b=>1,d=>5}
4321050086c5fc0a
4321050086c5fc0a
4321050086c5fc0a
4330a000afcc5860
4321050086c5fc0a
4321050086c5fc0a
4330a000afcc5860
4321050086c5fc0a
4330a000afcc5860
-
{e=>18454609,c=>4,a=>-22,b=>2,d=>3}
ea22030051981901
ea22030051981901
ea22030051981901
ea50600011998510
ea22030051981901
ea22030051981901
ea50600011998510
ea22030051981901
ea50600011998510
-
{e=>172433341,c=>6,a=>76,b=>6,d=>7}
4c360700bd1f470a
4c360700bd1f470a
4c360700bd1f470a
4cd8e000a471fbd0
4c360700bd1f470a
4c360700bd1f470a
4cd8e000a471fbd0
4c360700bd1f470a
4cd8e000a471fbd0
-
{e=>134101335,c=>2,a=>103,b=>0,d=>4}
671004005739fe07
671004005739fe07
671004005739fe07
670880007fe39570
671004005739fe07
671004005739fe07
670880007fe39570
671004005739fe07
670880007fe39570
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>200236336,c=>5,a=>-24,b=>2,d=>3,f=>1}
e82a0300305def1b
e82a0300305def1b
e82a0300305def1b
e8546000bef5d302
e82a0300305def1b
e82a0300305def1b
e8546000bef5d302
e82a0300305def1b
e8546000bef5d302
-
{e=>16740769,c=>4,a=>-26,b=>0,d=>1,f=>3}
e6200100a171ff30
e6200100a171ff30
e6200100a171ff30
e61020000ff71a16
e6200100a171ff30
e6200100a171ff30
e61020000ff71a16
e6200100a171ff30
e61020000ff71a16
-
{e=>6071845,c=>4,a=>121,b=>4,d=>1,f=>2}
7924010025a65c20
7924010025a65c20
7924010025a65c20
7990200005ca6254
7924010025a65c20
7924010025a65c20
7990200005ca6254
7924010025a65c20
7990200005ca6254
-
{e=>24355757,c=>3,a=>-75,b=>5,d=>2,f=>2}
b51d0200ada37321
b51d0200ada37321
b51d0200ada37321
b5ac4000173a3ad4
b51d0200ada37321
b51d0200ada37321
b5ac4000173a3ad4
b51d0200ada37321
b5ac4000173a3ad4
-
{e=>167185341,c=>2,a=>21,b=>6,d=>4,f=>4}
15160400bd0bf749
15160400bd0bf749
15160400bd0bf749
15c880009f70bbd8
15160400bd0bf749
15160400bd0bf749
15c880009f70bbd8
15160400bd0bf749
15c880009f70bbd8
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>98259173,c=>2,a=>-44,g=>2,b=>6,d=>2,f=>2}
d4160200e550db2502000000
d4160200e550db2502000000
d4160200e550db2502000000
d4c840005db50e5480000000
d4160200e550db2502000000
d4160200e550db2502000000
d4c840005db50e5480000000
d4160200e550db2502000000
d4c840005db50e5480000000
-
{e=>101458287,c=>3,a=>107,g=>0,b=>2,d=>7,f=>2}
6b1a07006f210c2600000000
6b1a07006f210c2600000000
6b1a07006f210c2600000000
6b4ce00060c216f400000000
6b1a07006f210c2600000000
6b1a07006f210c2600000000
6b4ce00060c216f400000000
6b1a07006f210c2600000000
6b4ce00060c216f400000000
-
{e=>73372275,c=>5,a=>-94,g=>0,b=>1,d=>7,f=>1}
a229070073925f1400000000
a229070073925f1400000000
a229070073925f1400000000
a234e00045f9273200000000
a229070073925f1400000000
a229070073925f1400000000
a234e00045f9273200000000
a229070073925f1400000000
a234e00045f9273200000000
-
{e=>168006158,c=>5,a=>-34,g=>0,b=>0,d=>0,f=>5}
de2800000e92035a00000000
de2800000e92035a00000000
de2800000e92035a00000000
de140000a03920ea00000000
de2800000e92035a00000000
de2800000e92035a00000000
de140000a03920ea00000000
de2800000e92035a00000000
de140000a03920ea00000000
-
{e=>251692646,c=>0,a=>58,g=>1,b=>7,d=>2,f=>6}
3a0702006686006f01000000
3a0702006686006f01000000
3a0702006686006f01000000
3ae04000f008666c40000000
3a0702006686006f01000000
3a0702006686006f01000000
3ae04000f008666c40000000
3a0702006686006f01000000
3ae04000f008666c40000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>72582175,a=>66,d=>0,c=>0,h=>6020,b=>1,g=>0,f=>1}
420100001f845314105e0000
420100001f845314105e0000
420100001f845314105e0000
42200000453841f22f080000
420100001f845314105e0000
420100001f845314105e0000
42200000453841f22f080000
420100001f845314105e0000
42200000453841f22f080000
-
{e=>184039552,a=>30,d=>0,c=>3,h=>2419,b=>7,g=>2,f=>0}
1e1f00008038f80ace250000
1e1f00008038f80ace250000
1e1f00008038f80ace250000
1eec0000af83880092e60000
1e1f00008038f80ace250000
1e1f00008038f80ace250000
1eec0000af83880092e60000
1e1f00008038f80ace250000
1eec0000af83880092e60000
-
{e=>80164592,a=>-49,d=>3,c=>6,h=>7825,b=>5,g=>0,f=>7}
cf350300f036c774447a0000
cf350300f036c774447a0000
cf350300f036c774447a0000
cfb860004c736f0e3d220000
cf350300f036c774447a0000
cf350300f036c774447a0000
cfb860004c736f0e3d220000
cf350300f036c774447a0000
cfb860004c736f0e3d220000
-
{e=>159880110,a=>-107,d=>6,c=>0,h=>4520,b=>3,g=>1,f=>4}
95030600ae938749a1460000
95030600ae938749a1460000
95030600ae938749a1460000
9560c00098793ae863500000
95030600ae938749a1460000
95030600ae938749a1460000
9560c00098793ae863500000
95030600ae938749a1460000
9560c00098793ae863500000
-
{e=>237506163,a=>-31,d=>6,c=>0,h=>1061,b=>7,g=>3,f=>6}
e1070600730e286e97100000
e1070600730e286e97100000
e1070600730e286e97100000
e1e0c000e280e73cc84a0000
e1070600730e286e97100000
e1070600730e286e97100000
e1e0c000e280e73cc84a0000
e1070600730e286e97100000
e1e0c000e280e73cc84a0000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>75173975,a=>0,d=>7,c=>5,h=>219,b=>2,g=>0,f=>2,i=>75}
002a070057107b246c034b00
002a070057107b246c034b00
002a070057107b246c034b00
0054e00047b1057401b64b00
002a070057107b246c034b00
002a070057107b246c034b00
0054e00047b1057401b64b00
002a070057107b246c034b00
0054e00047b1057401b64b00
-
{e=>14359521,a=>-73,d=>7,c=>3,h=>7081,b=>3,g=>1,f=>4,i=>127}
b71b0700e11bdb40a56e7f00
b71b0700e11bdb40a56e7f00
b71b0700e11bdb40a56e7f00
b76ce0000db1be1877527f00
b71b0700e11bdb40a56e7f00
b71b0700e11bdb40a56e7f00
b76ce0000db1be1877527f00
b71b0700e11bdb40a56e7f00
b76ce0000db1be1877527f00
-
{e=>93479715,a=>-14,d=>2,c=>4,h=>5837,b=>2,g=>0,f=>5,i=>120}
f222020023639255345b7800
f222020023639255345b7800
f222020023639255345b7800
f25040005926323a2d9a7800
f222020023639255345b7800
f222020023639255345b7800
f25040005926323a2d9a7800
f222020023639255345b7800
f25040005926323a2d9a7800
-
{e=>240985188,a=>123,d=>3,c=>4,h=>1817,b=>6,g=>0,f=>0,i=>75}
7b26030064245d0e641c4b00
7b26030064245d0e641c4b00
7b26030064245d0e641c4b00
7bd06000e5d246400e324b00
7b26030064245d0e641c4b00
7b26030064245d0e641c4b00
7bd06000e5d246400e324b00
7b26030064245d0e641c4b00
7bd06000e5d246400e324b00
-
{e=>31234999,a=>99,d=>6,c=>3,h=>4938,b=>0,g=>3,f=>3,i=>200}
63180600b79bdc312b4dc800
63180600b79bdc312b4dc800
63180600b79bdc312b4dc800
630cc0001dc9bb76e694c800
63180600b79bdc312b4dc800
63180600b79bdc312b4dc800
630cc0001dc9bb76e694c800
63180600b79bdc312b4dc800
630cc0001dc9bb76e694c800
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
};
-
{a=>-20,b=>2}
ecff0200
ecff0200
ecff0200
ffec4000
ecff0200
ecff0200
ffec4000
ecff0200
ffec4000
-
{a=>51,b=>0}
33000000
33000000
33000000
00330000
33000000
33000000
00330000
33000000
00330000
-
{a=>-61,b=>7}
c3ff0700
c3ff0700
c3ff0700
ffc3e000
c3ff0700
c3ff0700
ffc3e000
c3ff0700
ffc3e000
-
{a=>109,b=>2}
6d000200
6d000200
6d000200
006d4000
6d000200
6d000200
006d4000
6d000200
006d4000
-
{a=>3,b=>5}
03000500
03000500
03000500
0003a000
03000500
03000500
0003a000
03000500
0003a000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>1,a=>91,b=>0}
5b000800
5b000800
5b000800
005b0400
5b000800
5b000800
005b0400
5b000800
005b0400
-
{c=>6,a=>40,b=>1}
28003100
28003100
28003100
00283800
28003100
28003100
00283800
28003100
00283800
-
{c=>3,a=>73,b=>7}
49001f00
49001f00
49001f00
0049ec00
49001f00
49001f00
0049ec00
49001f00
0049ec00
-
{c=>2,a=>-70,b=>0}
baff1000
baff1000
baff1000
ffba0800
baff1000
baff1000
ffba0800
baff1000
ffba0800
-
{c=>3,a=>-86,b=>2}
aaff1a00
aaff1a00
aaff1a00
ffaa4c00
aaff1a00
aaff1a00
ffaa4c00
aaff1a00
ffaa4c00
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>7,a=>-16,b=>2,d=>0}
f0ff3a00
f0ff3a00
f0ff3a00
fff05c00
f0ff3a00
f0ff3a00
fff05c00
f0ff3a00
fff05c00
-
{c=>2,a=>120,b=>3,d=>3}
7800d300
7800d300
7800d300
00786980
7800d300
7800d300
00786980
7800d300
00786980
-
{c=>1,a=>109,b=>6,d=>6}
6d008e01
6d008e01
6d008e01
006dc700
6d008e01
6d008e01
006dc700
6d008e01
006dc700
-
{c=>2,a=>109,b=>7,d=>5}
6d005701
6d005701
6d005701
006dea80
6d005701
6d005701
006dea80
6d005701
006dea80
-
{c=>7,a=>35,b=>6,d=>4}
23003e01
23003e01
23003e01
0023de00
23003e01
23003e01
0023de00
23003e01
0023de00
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>242573218,c=>0,a=>-82,b=>5,d=>3}
aeffc500a25f750e
aeffc500a25f750e
aeffc500a25f750e
ffaea180e755fa20
aeffc500a25f750e
aeffc500a25f750e
ffaea180e755fa20
aeffc500a25f750e
ffaea180e755fa20
-
{e=>30225390,c=>1,a=>-90,b=>1,d=>0}
a6ff0900ee33cd01
a6ff0900ee33cd01
a6ff0900ee33cd01
ffa624001cd33ee0
a6ff0900ee33cd01
a6ff0900ee33cd01
ffa624001cd33ee0
a6ff0900ee33cd01
ffa624001cd33ee0
-
{e=>42673361,c=>7,a=>2,b=>7,d=>4}
02003f01d1248b02
02003f01d1248b02
02003f01d1248b02
0002fe0028b24d10
02003f01d1248b02
02003f01d1248b02
0002fe0028b24d10
02003f01d1248b02
0002fe0028b24d10
-
{e=>177618799,c=>1,a=>-74,b=>4,d=>0}
b6ff0c006f3f960a
b6ff0c006f3f960a
b6ff0c006f3f960a
ffb68400a963f6f0
b6ff0c006f3f960a
b6ff0c006f3f960a
ffb68400a963f6f0
b6ff0c006f3f960a
ffb68400a963f6f0
-
{e=>162146214,c=>1,a=>9,b=>5,d=>2}
09008d00a627aa09
09008d00a627aa09
09008d00a627aa09
0009a5009aa27a60
09008d00a627aa09
09008d00a627aa09
0009a5009aa27a60
09008d00a627aa09
0009a5009aa27a60
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>51386433,c=>7,a=>-38,b=>4,d=>2,f=>2}
daffbc0041181023
daffbc0041181023
daffbc0041181023
ffda9d0031018414
daffbc0041181023
daffbc0041181023
ffda9d0031018414
daffbc0041181023
ffda9d0031018414
-
{e=>119132246,c=>3,a=>-125,b=>6,d=>1,f=>0}
83ff5e0056d01907
83ff5e0056d01907
83ff5e0056d01907
ff83cc80719d0560
83ff5e0056d01907
83ff5e0056d01907
ff83cc80719d0560
83ff5e0056d01907
ff83cc80719d0560
-
{e=>28309628,c=>6,a=>-101,b=>5,d=>5,f=>0}
9bff75017cf8af01
9bff75017cf8af01
9bff75017cf8af01
ff9bba801aff87c0
9bff75017cf8af01
9bff75017cf8af01
ff9bba801aff87c0
9bff75017cf8af01
ff9bba801aff87c0
-
{e=>151543114,c=>3,a=>3,b=>2,d=>7,f=>5}
0300da014a5d0859
0300da014a5d0859
0300da014a5d0859
00034f809085d4aa
0300da014a5d0859
0300da014a5d0859
00034f809085d4aa
0300da014a5d0859
00034f809085d4aa
-
{e=>213132804,c=>5,a=>-95,b=>4,d=>0,f=>0}
a1ff2c000426b40c
a1ff2c000426b40c
a1ff2c000426b40c
ffa19400cb426040
a1ff2c000426b40c
a1ff2c000426b40c
ffa19400cb426040
a1ff2c000426b40c
ffa19400cb426040
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>142590409,c=>6,a=>-41,g=>0,b=>6,d=>3,f=>7}
d7fff600c9c17f7800000000
d7fff600c9c17f7800000000
d7fff600c9c17f7800000000
ffd7d98087fc1c9e00000000
d7fff600c9c17f7800000000
d7fff600c9c17f7800000000
ffd7d98087fc1c9e00000000
d7fff600c9c17f7800000000
ffd7d98087fc1c9e00000000
-
{e=>97470275,c=>4,a=>81,g=>1,b=>6,d=>6,f=>3}
5100a6014347cf3501000000
5100a6014347cf3501000000
5100a6014347cf3501000000
0051d3005cf4743640000000
5100a6014347cf3501000000
5100a6014347cf3501000000
0051d3005cf4743640000000
5100a6014347cf3501000000
0051d3005cf4743640000000
-
{e=>267791921,c=>1,a=>34,g=>1,b=>7,d=>2,f=>1}
22008f00312ef61f01000000
22008f00312ef61f01000000
22008f00312ef61f01000000
0022e500ff62e31240000000
22008f00312ef61f01000000
22008f00312ef61f01000000
0022e500ff62e31240000000
22008f00312ef61f01000000
0022e500ff62e31240000000
-
{e=>41800024,c=>3,a=>-80,g=>2,b=>0,d=>0,f=>1}
b0ff180058d17d1202000000
b0ff180058d17d1202000000
b0ff180058d17d1202000000
ffb00c0027dd158280000000
b0ff180058d17d1202000000
b0ff180058d17d1202000000
ffb00c0027dd158280000000
b0ff180058d17d1202000000
ffb00c0027dd158280000000
-
{e=>258096646,c=>0,a=>-31,g=>2,b=>3,d=>0,f=>3}
e1ff0300063e623f02000000
e1ff0300063e623f02000000
e1ff0300063e623f02000000
ffe16000f623e06680000000
e1ff0300063e623f02000000
e1ff0300063e623f02000000
ffe16000f623e06680000000
e1ff0300063e623f02000000
ffe16000f623e06680000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>122313407,a=>19,d=>3,c=>0,h=>650,b=>1,g=>1,f=>3}
1300c100bf5a4a37290a0000
1300c100bf5a4a37290a0000
1300c100bf5a4a37290a0000
0013218074a5abf645140000
1300c100bf5a4a37290a0000
1300c100bf5a4a37290a0000
0013218074a5abf645140000
1300c100bf5a4a37290a0000
0013218074a5abf645140000
-
{e=>94490750,a=>35,d=>1,c=>1,h=>5999,b=>4,g=>1,f=>0}
23004c007ed0a105bd5d0000
23004c007ed0a105bd5d0000
23004c007ed0a105bd5d0000
002384805a1d07e06ede0000
23004c007ed0a105bd5d0000
23004c007ed0a105bd5d0000
002384805a1d07e06ede0000
23004c007ed0a105bd5d0000
002384805a1d07e06ede0000
-
{e=>76168925,a=>-99,d=>0,c=>3,h=>6309,b=>6,g=>0,f=>6}
9dff1e00dd3e8a6494620000
9dff1e00dd3e8a6494620000
9dff1e00dd3e8a6494620000
ff9dcc0048a3eddc314a0000
9dff1e00dd3e8a6494620000
9dff1e00dd3e8a6494620000
ff9dcc0048a3eddc314a0000
9dff1e00dd3e8a6494620000
ff9dcc0048a3eddc314a0000
-
{e=>69639528,a=>-114,d=>1,c=>7,h=>2240,b=>2,g=>1,f=>7}
8eff7a00689d267401230000
8eff7a00689d267401230000
8eff7a00689d267401230000
ff8e5c804269d68e51800000
8eff7a00689d267401230000
8eff7a00689d267401230000
ff8e5c804269d68e51800000
8eff7a00689d267401230000
ff8e5c804269d68e51800000
-
{e=>138012526,a=>109,d=>3,c=>5,h=>7241,b=>3,g=>2,f=>0}
6d00eb006ee7390826710000
6d00eb006ee7390826710000
6d00eb006ee7390826710000
006d7580839e76e0b8920000
6d00eb006ee7390826710000
6d00eb006ee7390826710000
006d7580839e76e0b8920000
6d00eb006ee7390826710000
006d7580839e76e0b8920000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>213997424,a=>12,d=>4,c=>5,h=>6891,b=>4,g=>0,f=>5,i=>155}
0c002c017057c15cac6b9b00
0c002c017057c15cac6b9b00
0c002c017057c15cac6b9b00
000c9600cc15770a35d69b00
0c002c017057c15cac6b9b00
0c002c017057c15cac6b9b00
000c9600cc15770a35d69b00
0c002c017057c15cac6b9b00
000c9600cc15770a35d69b00
-
{e=>80148154,a=>4,d=>3,c=>3,h=>5605,b=>4,g=>2,f=>7,i=>187}
0400dc00baf6c6749657bb00
0400dc00baf6c6749657bb00
0400dc00baf6c6749657bb00
00048d804c6f6baeabcabb00
0400dc00baf6c6749657bb00
0400dc00baf6c6749657bb00
00048d804c6f6baeabcabb00
0400dc00baf6c6749657bb00
00048d804c6f6baeabcabb00
-
{e=>17679511,a=>103,d=>4,c=>7,h=>793,b=>4,g=>1,f=>5,i=>154}
67003c0197c40d51650c9a00
67003c0197c40d51650c9a00
67003c0197c40d51650c9a00
00679e0010dc497a46329a00
67003c0197c40d51650c9a00
67003c0197c40d51650c9a00
00679e0010dc497a46329a00
67003c0197c40d51650c9a00
00679e0010dc497a46329a00
-
{e=>234963446,a=>-109,d=>7,c=>4,h=>4806,b=>2,g=>2,f=>0,i=>153}
93ffe201f641010e1a4b9900
93ffe201f641010e1a4b9900
93ffe201f641010e1a4b9900
ff935380e0141f60a58c9900
93ffe201f641010e1a4b9900
93ffe201f641010e1a4b9900
ff935380e0141f60a58c9900
93ffe201f641010e1a4b9900
ff935380e0141f60a58c9900
-
{e=>233686042,a=>26,d=>5,c=>3,h=>6938,b=>4,g=>1,f=>3,i=>229}
1a005c011ac4ed3d696ce500
1a005c011ac4ed3d696ce500
1a005c011ac4ed3d696ce500
001a8e80dedc41a67634e500
1a005c011ac4ed3d696ce500
1a005c011ac4ed3d696ce500
001a8e80dedc41a67634e500
1a005c011ac4ed3d696ce500
001a8e80dedc41a67634e500
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
};
-
{a=>-76,b=>0}
b4ffffff00000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
b4ffffff00000000
ffffffb400000000
b4ffffff00000000
ffffffb400000000
-
{a=>-65,b=>4}
bfffffff04000000
bfffffff04000000
bfffffff04000000
ffffffbf80000000
bfffffff04000000
bfffffff04000000
ffffffbf80000000
bfffffff04000000
ffffffbf80000000
-
{a=>13,b=>3}
0d00000003000000
0d00000003000000
0d00000003000000
0000000d60000000
0d00000003000000
0d00000003000000
0000000d60000000
0d00000003000000
0000000d60000000
-
{a=>79,b=>5}
4f00000005000000
4f00000005000000
4f00000005000000
0000004fa0000000
4f00000005000000
4f00000005000000
0000004fa0000000
4f00000005000000
0000004fa0000000
-
{a=>-81,b=>4}
afffffff04000000
afffffff04000000
afffffff04000000
ffffffaf80000000
afffffff04000000
afffffff04000000
ffffffaf80000000
afffffff04000000
ffffffaf80000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>3,a=>84,b=>1}
5400000019000000
5400000019000000
5400000019000000
000000542c000000
5400000019000000
5400000019000000
000000542c000000
5400000019000000
000000542c000000
-
{c=>1,a=>127,b=>1}
7f00000009000000
7f00000009000000
7f00000009000000
0000007f24000000
7f00000009000000
7f00000009000000
0000007f24000000
7f00000009000000
0000007f24000000
-
{c=>5,a=>-114,b=>0}
8effffff28000000
8effffff28000000
8effffff28000000
ffffff8e14000000
8effffff28000000
8effffff28000000
ffffff8e14000000
8effffff28000000
ffffff8e14000000
-
{c=>3,a=>108,b=>1}
6c00000019000000
6c00000019000000
6c00000019000000
0000006c2c000000
6c00000019000000
6c00000019000000
0000006c2c000000
6c00000019000000
0000006c2c000000
-
{c=>7,a=>9,b=>1}
0900000039000000
0900000039000000
0900000039000000
000000093c000000
0900000039000000
0900000039000000
000000093c000000
0900000039000000
000000093c000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>6,a=>-62,b=>1,d=>4}
c2ffffff31010000
c2ffffff31010000
c2ffffff31010000
ffffffc23a000000
c2ffffff31010000
c2ffffff31010000
ffffffc23a000000
c2ffffff31010000
ffffffc23a000000
-
{c=>7,a=>74,b=>5,d=>0}
4a0000003d000000
4a0000003d000000
4a0000003d000000
0000004abc000000
4a0000003d000000
4a0000003d000000
0000004abc000000
4a0000003d000000
0000004abc000000
-
{c=>3,a=>-122,b=>2,d=>7}
86ffffffda010000
86ffffffda010000
86ffffffda010000
ffffff864f800000
86ffffffda010000
86ffffffda010000
ffffff864f800000
86ffffffda010000
ffffff864f800000
-
{c=>3,a=>-73,b=>7,d=>2}
b7ffffff9f000000
b7ffffff9f000000
b7ffffff9f000000
ffffffb7ed000000
b7ffffff9f000000
b7ffffff9f000000
ffffffb7ed000000
b7ffffff9f000000
ffffffb7ed000000
-
{c=>1,a=>13,b=>5,d=>2}
0d0000008d000000
0d0000008d000000
0d0000008d000000
0000000da5000000
0d0000008d000000
0d0000008d000000
0000000da5000000
0d0000008d000000
0000000da5000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>130106456,c=>4,a=>127,b=>7,d=>3}
7f000000e70000005844c107
7f000000e70000005844c107
7f000000e70000005844c107
0000007ff18000007c144580
7f000000e70000005844c107
7f000000e70000005844c107
0000007ff18000007c144580
7f000000e70000005844c107
0000007ff18000007c144580
-
{e=>228064205,c=>5,a=>28,b=>5,d=>3}
1c000000ed000000cdfb970d
1c000000ed000000cdfb970d
1c000000ed000000cdfb970d
0000001cb5800000d97fbcd0
1c000000ed000000cdfb970d
1c000000ed000000cdfb970d
0000001cb5800000d97fbcd0
1c000000ed000000cdfb970d
0000001cb5800000d97fbcd0
-
{e=>217906279,c=>1,a=>99,b=>0,d=>7}
63000000c801000067fcfc0c
63000000c801000067fcfc0c
63000000c801000067fcfc0c
0000006307800000cfcfc670
63000000c801000067fcfc0c
63000000c801000067fcfc0c
0000006307800000cfcfc670
63000000c801000067fcfc0c
0000006307800000cfcfc670
-
{e=>51712296,c=>5,a=>-8,b=>2,d=>6}
f8ffffffaa01000028111503
f8ffffffaa01000028111503
f8ffffffaa01000028111503
fffffff85700000031511280
f8ffffffaa01000028111503
f8ffffffaa01000028111503
fffffff85700000031511280
f8ffffffaa01000028111503
fffffff85700000031511280
-
{e=>211735696,c=>6,a=>78,b=>1,d=>0}
4e0000003100000090d49e0c
4e0000003100000090d49e0c
4e0000003100000090d49e0c
0000004e38000000c9ed4900
4e0000003100000090d49e0c
4e0000003100000090d49e0c
0000004e38000000c9ed4900
4e0000003100000090d49e0c
0000004e38000000c9ed4900
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>242564914,c=>0,a=>6,b=>0,d=>4,f=>4}
0600000000010000323f754e
0600000000010000323f754e
0600000000010000323f754e
0000000602000000e753f328
0600000000010000323f754e
0600000000010000323f754e
0000000602000000e753f328
0600000000010000323f754e
0000000602000000e753f328
-
{e=>142230259,c=>5,a=>-69,b=>3,d=>4,f=>0}
bbffffff2b010000f3427a08
bbffffff2b010000f3427a08
bbffffff2b010000f3427a08
ffffffbb7600000087a42f30
bbffffff2b010000f3427a08
bbffffff2b010000f3427a08
ffffffbb7600000087a42f30
bbffffff2b010000f3427a08
ffffffbb7600000087a42f30
-
{e=>40226599,c=>3,a=>-72,b=>3,d=>0,f=>0}
b8ffffff1b00000027cf6502
b8ffffff1b00000027cf6502
b8ffffff1b00000027cf6502
ffffffb86c000000265cf270
b8ffffff1b00000027cf6502
b8ffffff1b00000027cf6502
ffffffb86c000000265cf270
b8ffffff1b00000027cf6502
ffffffb86c000000265cf270
-
{e=>4604876,c=>0,a=>18,b=>5,d=>2,f=>5}
1200000085000000cc434650
1200000085000000cc434650
1200000085000000cc434650
00000012a100000004643cca
1200000085000000cc434650
1200000085000000cc434650
00000012a100000004643cca
1200000085000000cc434650
00000012a100000004643cca
-
{e=>209840252,c=>0,a=>-52,b=>3,d=>3,f=>2}
ccffffffc30000007ce8812c
ccffffffc30000007ce8812c
ccffffffc30000007ce8812c
ffffffcc61800000c81e87c4
ccffffffc30000007ce8812c
ccffffffc30000007ce8812c
ffffffcc61800000c81e87c4
ccffffffc30000007ce8812c
ffffffcc61800000c81e87c4
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>13259097,c=>3,a=>-63,g=>1,b=>5,d=>7,f=>3}
c1ffffffdd0100005951ca3001000000
c1ffffffdd0100005951ca3001000000
c1ffffffdd0100005951ca3001000000
ffffffc1af8000000ca5159640000000
c1ffffffdd0100005951ca3001000000
c1ffffffdd0100005951ca3001000000
ffffffc1af8000000ca5159640000000
c1ffffffdd0100005951ca3001000000
ffffffc1af8000000ca5159640000000
-
{e=>156908516,c=>4,a=>36,g=>0,b=>6,d=>0,f=>6}
2400000026000000e43b5a6900000000
2400000026000000e43b5a6900000000
2400000026000000e43b5a6900000000
00000024d000000095a3be4c00000000
2400000026000000e43b5a6900000000
2400000026000000e43b5a6900000000
00000024d000000095a3be4c00000000
2400000026000000e43b5a6900000000
00000024d000000095a3be4c00000000
-
{e=>59405293,c=>0,a=>117,g=>2,b=>5,d=>7,f=>7}
75000000c5010000ed738a7302000000
75000000c5010000ed738a7302000000
75000000c5010000ed738a7302000000
00000075a380000038a73ede80000000
75000000c5010000ed738a7302000000
75000000c5010000ed738a7302000000
00000075a380000038a73ede80000000
75000000c5010000ed738a7302000000
00000075a380000038a73ede80000000
-
{e=>247527189,c=>5,a=>66,g=>2,b=>2,d=>2,f=>1}
42000000aa00000015f7c01e02000000
42000000aa00000015f7c01e02000000
42000000aa00000015f7c01e02000000
0000004255000000ec0f715280000000
42000000aa00000015f7c01e02000000
42000000aa00000015f7c01e02000000
0000004255000000ec0f715280000000
42000000aa00000015f7c01e02000000
0000004255000000ec0f715280000000
-
{e=>80174753,c=>2,a=>-35,g=>1,b=>2,d=>0,f=>2}
ddffffff12000000a15ec72401000000
ddffffff12000000a15ec72401000000
ddffffff12000000a15ec72401000000
ffffffdd480000004c75ea1440000000
ddffffff12000000a15ec72401000000
ddffffff12000000a15ec72401000000
ffffffdd480000004c75ea1440000000
ddffffff12000000a15ec72401000000
ffffffdd480000004c75ea1440000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>79855944,a=>-79,d=>6,c=>0,h=>1469,b=>5,g=>1,f=>0}
b1ffffff850100004881c204f5160000
b1ffffff850100004881c204f5160000
b1ffffff850100004881c204f5160000
ffffffb1a30000004c2814804b7a0000
b1ffffff850100004881c204f5160000
b1ffffff850100004881c204f5160000
ffffffb1a30000004c2814804b7a0000
b1ffffff850100004881c204f5160000
ffffffb1a30000004c2814804b7a0000
-
{e=>55286286,a=>-110,d=>5,c=>5,h=>6486,b=>5,g=>1,f=>3}
92ffffff6d0100000e9a4b3359650000
92ffffff6d0100000e9a4b3359650000
92ffffff6d0100000e9a4b3359650000
ffffff92b680000034b9a0e672ac0000
92ffffff6d0100000e9a4b3359650000
92ffffff6d0100000e9a4b3359650000
ffffff92b680000034b9a0e672ac0000
92ffffff6d0100000e9a4b3359650000
ffffff92b680000034b9a0e672ac0000
-
{e=>230194727,a=>-49,d=>2,c=>2,h=>6812,b=>6,g=>1,f=>4}
cfffffff96000000277eb84d716a0000
cfffffff96000000277eb84d716a0000
cfffffff96000000277eb84d716a0000
ffffffcfc9000000db87e27875380000
cfffffff96000000277eb84d716a0000
cfffffff96000000277eb84d716a0000
ffffffcfc9000000db87e27875380000
cfffffff96000000277eb84d716a0000
ffffffcfc9000000db87e27875380000
-
{e=>191802023,a=>61,d=>7,c=>6,h=>7935,b=>4,g=>1,f=>2}
3d000000f4010000a7aa6e2bfd7b0000
3d000000f4010000a7aa6e2bfd7b0000
3d000000f4010000a7aa6e2bfd7b0000
0000003d9b800000b6eaaa747dfe0000
3d000000f4010000a7aa6e2bfd7b0000
3d000000f4010000a7aa6e2bfd7b0000
0000003d9b800000b6eaaa747dfe0000
3d000000f4010000a7aa6e2bfd7b0000
0000003d9b800000b6eaaa747dfe0000
-
{e=>31737331,a=>18,d=>6,c=>6,h=>5531,b=>3,g=>2,f=>2}
12000000b3010000f345e4216e560000
12000000b3010000f345e4216e560000
12000000b3010000f345e4216e560000
000000127b0000001e445f34ab360000
12000000b3010000f345e4216e560000
12000000b3010000f345e4216e560000
000000127b0000001e445f34ab360000
12000000b3010000f345e4216e560000
000000127b0000001e445f34ab360000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>257753255,a=>78,d=>5,c=>1,h=>4307,b=>5,g=>1,f=>3,i=>23}
4e0000004d010000a7005d3f4d431700
4e0000004d010000a7005d3f4d431700
4e0000004d010000a7005d3f4d431700
0000004ea6800000f5d00a7661a61700
4e0000004d010000a7005d3f4d431700
4e0000004d010000a7005d3f4d431700
0000004ea6800000f5d00a7661a61700
4e0000004d010000a7005d3f4d431700
0000004ea6800000f5d00a7661a61700
-
{e=>154752796,a=>-128,d=>3,c=>3,h=>1857,b=>7,g=>2,f=>4,i=>149}
80ffffffdf0000001c573949061d9500
80ffffffdf0000001c573949061d9500
80ffffffdf0000001c573949061d9500
ffffff80ed800000939571c88e829500
80ffffffdf0000001c573949061d9500
80ffffffdf0000001c573949061d9500
ffffff80ed800000939571c88e829500
80ffffffdf0000001c573949061d9500
ffffff80ed800000939571c88e829500
-
{e=>48153402,a=>-86,d=>4,c=>5,h=>2443,b=>5,g=>1,f=>3,i=>106}
aaffffff2d0100003ac3de322d266a00
aaffffff2d0100003ac3de322d266a00
aaffffff2d0100003ac3de322d266a00
ffffffaab60000002dec33a653166a00
aaffffff2d0100003ac3de322d266a00
aaffffff2d0100003ac3de322d266a00
ffffffaab60000002dec33a653166a00
aaffffff2d0100003ac3de322d266a00
ffffffaab60000002dec33a653166a00
-
{e=>149056525,a=>-9,d=>6,c=>2,h=>4899,b=>0,g=>1,f=>2,i=>164}
f7ffffff900100000d6ce2288d4ca400
f7ffffff900100000d6ce2288d4ca400
f7ffffff900100000d6ce2288d4ca400
fffffff70b0000008e26c0d46646a400
f7ffffff900100000d6ce2288d4ca400
f7ffffff900100000d6ce2288d4ca400
fffffff70b0000008e26c0d46646a400
f7ffffff900100000d6ce2288d4ca400
fffffff70b0000008e26c0d46646a400
-
{e=>211134956,a=>118,d=>5,c=>1,h=>1779,b=>3,g=>1,f=>5,i=>234}
760000004b010000eca9955ccd1bea00
760000004b010000eca9955ccd1bea00
760000004b010000eca9955ccd1bea00
0000007666800000c95a9eca4de6ea00
760000004b010000eca9955ccd1bea00
760000004b010000eca9955ccd1bea00
0000007666800000c95a9eca4de6ea00
760000004b010000eca9955ccd1bea00
0000007666800000c95a9eca4de6ea00
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
};
-
{a=>83,b=>3}
5300000003000000
53000000000000000300000000000000
53000000000000000300000000000000
0000005360000000
5300000003000000
5300000003000000
00000000000000536000000000000000
5300000003000000
0000005360000000
-
{a=>118,b=>5}
7600000005000000
76000000000000000500000000000000
76000000000000000500000000000000
00000076a0000000
7600000005000000
7600000005000000
0000000000000076a000000000000000
7600000005000000
00000076a0000000
-
{a=>102,b=>4}
6600000004000000
66000000000000000400000000000000
66000000000000000400000000000000
0000006680000000
6600000004000000
6600000004000000
00000000000000668000000000000000
6600000004000000
0000006680000000
-
{a=>-46,b=>3}
d2ffffff03000000
d2ffffffffffffff0300000000000000
d2ffffffffffffff0300000000000000
ffffffd260000000
d2ffffff03000000
d2ffffff03000000
ffffffffffffffd26000000000000000
d2ffffff03000000
ffffffd260000000
-
{a=>-65,b=>5}
bfffffff05000000
bfffffffffffffff0500000000000000
bfffffffffffffff0500000000000000
ffffffbfa0000000
bfffffff05000000
bfffffff05000000
ffffffffffffffbfa000000000000000
bfffffff05000000
ffffffbfa0000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>6,a=>101,b=>1}
6500000031000000
65000000000000003100000000000000
65000000000000003100000000000000
0000006538000000
6500000031000000
6500000031000000
00000000000000653800000000000000
6500000031000000
0000006538000000
-
{c=>5,a=>32,b=>7}
200000002f000000
20000000000000002f00000000000000
20000000000000002f00000000000000
00000020f4000000
200000002f000000
200000002f000000
0000000000000020f400000000000000
200000002f000000
00000020f4000000
-
{c=>7,a=>-74,b=>2}
b6ffffff3a000000
b6ffffffffffffff3a00000000000000
b6ffffffffffffff3a00000000000000
ffffffb65c000000
b6ffffff3a000000
b6ffffff3a000000
ffffffffffffffb65c00000000000000
b6ffffff3a000000
ffffffb65c000000
-
{c=>4,a=>-84,b=>1}
acffffff21000000
acffffffffffffff2100000000000000
acffffffffffffff2100000000000000
ffffffac30000000
acffffff21000000
acffffff21000000
ffffffffffffffac3000000000000000
acffffff21000000
ffffffac30000000
-
{c=>3,a=>-100,b=>4}
9cffffff1c000000
9cffffffffffffff1c00000000000000
9cffffffffffffff1c00000000000000
ffffff9c8c000000
9cffffff1c000000
9cffffff1c000000
ffffffffffffff9c8c00000000000000
9cffffff1c000000
ffffff9c8c000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>3,a=>-18,b=>2,d=>4}
eeffffff1a010000
eeffffffffffffff1a01000000000000
eeffffffffffffff1a01000000000000
ffffffee4e000000
eeffffff1a010000
eeffffff1a010000
ffffffffffffffee4e00000000000000
eeffffff1a010000
ffffffee4e000000
-
{c=>0,a=>-123,b=>2,d=>3}
85ffffffc2000000
85ffffffffffffffc200000000000000
85ffffffffffffffc200000000000000
ffffff8541800000
85ffffffc2000000
85ffffffc2000000
ffffffffffffff854180000000000000
85ffffffc2000000
ffffff8541800000
-
{c=>5,a=>85,b=>2,d=>3}
55000000ea000000
5500000000000000ea00000000000000
5500000000000000ea00000000000000
0000005555800000
55000000ea000000
55000000ea000000
00000000000000555580000000000000
55000000ea000000
0000005555800000
-
{c=>5,a=>-113,b=>7,d=>6}
8fffffffaf010000
8fffffffffffffffaf01000000000000
8fffffffffffffffaf01000000000000
ffffff8ff7000000
8fffffffaf010000
8fffffffaf010000
ffffffffffffff8ff700000000000000
8fffffffaf010000
ffffff8ff7000000
-
{c=>3,a=>66,b=>0,d=>6}
4200000098010000
42000000000000009801000000000000
42000000000000009801000000000000
000000420f000000
4200000098010000
4200000098010000
00000000000000420f00000000000000
4200000098010000
000000420f000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>160937402,c=>7,a=>27,b=>7,d=>5}
1b0000007f010000bab59709
1b000000000000007f010000bab59709
1b000000000000007f010000bab59709
0000001bfe800000997b5ba0
1b0000007f010000bab59709
1b0000007f010000bab59709
000000000000001bfe800000997b5ba0
1b0000007f010000bab59709
0000001bfe800000997b5ba0
-
{e=>20048177,c=>3,a=>28,b=>7,d=>6}
1c0000009f01000031e93101
1c000000000000009f01000031e93101
1c000000000000009f01000031e93101
0000001cef000000131e9310
1c0000009f01000031e93101
1c0000009f01000031e93101
000000000000001cef000000131e9310
1c0000009f01000031e93101
0000001cef000000131e9310
-
{e=>246627849,c=>0,a=>-81,b=>4,d=>3}
afffffffc4000000093eb30e
afffffffffffffffc4000000093eb30e
afffffffffffffffc4000000093eb30e
ffffffaf81800000eb33e090
afffffffc4000000093eb30e
afffffffc4000000093eb30e
ffffffffffffffaf81800000eb33e090
afffffffc4000000093eb30e
ffffffaf81800000eb33e090
-
{e=>200039194,c=>5,a=>112,b=>2,d=>1}
700000006a0000001a5bec0b
70000000000000006a0000001a5bec0b
70000000000000006a0000001a5bec0b
0000007054800000bec5b1a0
700000006a0000001a5bec0b
700000006a0000001a5bec0b
000000000000007054800000bec5b1a0
700000006a0000001a5bec0b
0000007054800000bec5b1a0
-
{e=>250650060,c=>0,a=>124,b=>1,d=>6}
7c00000081010000cc9df00e
7c0000000000000081010000cc9df00e
7c0000000000000081010000cc9df00e
0000007c23000000ef09dcc0
7c00000081010000cc9df00e
7c00000081010000cc9df00e
000000000000007c23000000ef09dcc0
7c00000081010000cc9df00e
0000007c23000000ef09dcc0
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>164019807,c=>0,a=>-107,b=>4,d=>4,f=>4}
95ffffff040100005fbec649
95ffffffffffffff040100005fbec649
95ffffffffffffff040100005fbec649
ffffff95820000009c6be5f8
95ffffff040100005fbec649
95ffffff040100005fbec649
ffffffffffffff95820000009c6be5f8
95ffffff040100005fbec649
ffffff95820000009c6be5f8
-
{e=>148347054,c=>7,a=>122,b=>5,d=>4,f=>4}
7a0000003d010000ae98d748
7a000000000000003d010000ae98d748
7a000000000000003d010000ae98d748
0000007abe0000008d798ae8
7a0000003d010000ae98d748
7a0000003d010000ae98d748
000000000000007abe0000008d798ae8
7a0000003d010000ae98d748
0000007abe0000008d798ae8
-
{e=>201328566,c=>2,a=>-38,b=>2,d=>0,f=>5}
daffffff12000000b607005c
daffffffffffffff12000000b607005c
daffffffffffffff12000000b607005c
ffffffda48000000c0007b6a
daffffff12000000b607005c
daffffff12000000b607005c
ffffffffffffffda48000000c0007b6a
daffffff12000000b607005c
ffffffda48000000c0007b6a
-
{e=>17793067,c=>3,a=>62,b=>5,d=>1,f=>6}
3e0000005d0000002b800f61
3e000000000000005d0000002b800f61
3e000000000000005d0000002b800f61
0000003eac80000010f802bc
3e0000005d0000002b800f61
3e0000005d0000002b800f61
000000000000003eac80000010f802bc
3e0000005d0000002b800f61
0000003eac80000010f802bc
-
{e=>265362806,c=>3,a=>-81,b=>7,d=>0,f=>0}
afffffff1f000000761dd10f
afffffffffffffff1f000000761dd10f
afffffffffffffff1f000000761dd10f
ffffffafec000000fd11d760
afffffff1f000000761dd10f
afffffff1f000000761dd10f
ffffffffffffffafec000000fd11d760
afffffff1f000000761dd10f
ffffffafec000000fd11d760
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>119342936,c=>2,a=>-110,g=>0,b=>2,d=>6,f=>7}
92ffffff9201000058071d7700000000
92ffffffffffffff9201000058071d770000000000000000
92ffffffffffffff9201000058071d770000000000000000
ffffff924b00000071d0758e00000000
92ffffff9201000058071d7700000000
92ffffff9201000058071d7700000000
ffffffffffffff924b00000071d0758e0000000000000000
92ffffff9201000058071d7700000000
ffffff924b00000071d0758e00000000
-
{e=>62059604,c=>7,a=>-92,g=>3,b=>4,d=>4,f=>7}
a4ffffff3c01000054f4b27303000000
a4ffffffffffffff3c01000054f4b2730300000000000000
a4ffffffffffffff3c01000054f4b2730300000000000000
ffffffa49e0000003b2f454ec0000000
a4ffffff3c01000054f4b27303000000
a4ffffff3c01000054f4b27303000000
ffffffffffffffa49e0000003b2f454ec000000000000000
a4ffffff3c01000054f4b27303000000
ffffffa49e0000003b2f454ec0000000
-
{e=>174545826,c=>6,a=>-60,g=>3,b=>2,d=>3,f=>1}
c4fffffff2000000a25b671a03000000
c4fffffffffffffff2000000a25b671a0300000000000000
c4fffffffffffffff2000000a25b671a0300000000000000
ffffffc459800000a675ba22c0000000
c4fffffff2000000a25b671a03000000
c4fffffff2000000a25b671a03000000
ffffffffffffffc459800000a675ba22c000000000000000
c4fffffff2000000a25b671a03000000
ffffffc459800000a675ba22c0000000
-
{e=>133811322,c=>5,a=>106,g=>2,b=>2,d=>0,f=>4}
6a0000002a0000007accf94702000000
6a000000000000002a0000007accf9470200000000000000
6a000000000000002a0000007accf9470200000000000000
0000006a540000007f9cc7a880000000
6a0000002a0000007accf94702000000
6a0000002a0000007accf94702000000
000000000000006a540000007f9cc7a88000000000000000
6a0000002a0000007accf94702000000
0000006a540000007f9cc7a880000000
-
{e=>181399152,c=>6,a=>71,g=>3,b=>4,d=>7,f=>7}
47000000f401000070eecf7a03000000
4700000000000000f401000070eecf7a0300000000000000
4700000000000000f401000070eecf7a0300000000000000
000000479b800000acfee70ec0000000
47000000f401000070eecf7a03000000
47000000f401000070eecf7a03000000
00000000000000479b800000acfee70ec000000000000000
47000000f401000070eecf7a03000000
000000479b800000acfee70ec0000000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>178239616,a=>-56,d=>2,c=>0,h=>947,b=>6,g=>2,f=>5}
c8ffffff8600000080b89f5ace0e0000
c8ffffffffffffff8600000080b89f5ace0e000000000000
c8ffffffffffffff8600000080b89f5ace0e000000000000
ffffffc8c1000000a9fb880a87660000
c8ffffff8600000080b89f5ace0e0000
c8ffffff8600000080b89f5ace0e0000
ffffffffffffffc8c1000000a9fb880a8766000000000000
c8ffffff8600000080b89f5ace0e0000
ffffffc8c1000000a9fb880a87660000
-
{e=>92807764,a=>66,d=>7,c=>0,h=>2391,b=>5,g=>2,f=>3}
42000000c5010000542288355e250000
4200000000000000c5010000542288355e25000000000000
4200000000000000c5010000542288355e25000000000000
00000042a38000005882254692ae0000
42000000c5010000542288355e250000
42000000c5010000542288355e250000
0000000000000042a38000005882254692ae000000000000
42000000c5010000542288355e250000
00000042a38000005882254692ae0000
-
{e=>217147655,a=>26,d=>5,c=>6,h=>7725,b=>4,g=>1,f=>2}
1a000000740100000769f12cb5780000
1a00000000000000740100000769f12cb578000000000000
1a00000000000000740100000769f12cb578000000000000
0000001a9a800000cf1690747c5a0000
1a000000740100000769f12cb5780000
1a000000740100000769f12cb5780000
000000000000001a9a800000cf1690747c5a000000000000
1a000000740100000769f12cb5780000
0000001a9a800000cf1690747c5a0000
-
{e=>94483661,a=>-122,d=>7,c=>6,h=>3773,b=>6,g=>2,f=>7}
86fffffff6010000cdb4a175f63a0000
86fffffffffffffff6010000cdb4a175f63a000000000000
86fffffffffffffff6010000cdb4a175f63a000000000000
ffffff86db8000005a1b4cde9d7a0000
86fffffff6010000cdb4a175f63a0000
86fffffff6010000cdb4a175f63a0000
ffffffffffffff86db8000005a1b4cde9d7a000000000000
86fffffff6010000cdb4a175f63a0000
ffffff86db8000005a1b4cde9d7a0000
-
{e=>255972856,a=>-65,d=>4,c=>6,h=>4167,b=>3,g=>2,f=>7}
bfffffff33010000f8d5417f1e410000
bfffffffffffffff33010000f8d5417f1e41000000000000
bfffffffffffffff33010000f8d5417f1e41000000000000
ffffffbf7a000000f41d5f8ea08e0000
bfffffff33010000f8d5417f1e410000
bfffffff33010000f8d5417f1e410000
ffffffffffffffbf7a000000f41d5f8ea08e000000000000
bfffffff33010000f8d5417f1e410000
ffffffbf7a000000f41d5f8ea08e0000
=
#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct umixed_pack_1 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>236368736,a=>50,d=>0,c=>0,h=>550,b=>0,g=>3,f=>2,i=>115}
320000000000000060b3162e9b087300
32000000000000000000000060b3162e9b08730000000000
32000000000000000000000060b3162e9b08730000000000
0000003200000000e16b3604c44c7300
320000000000000060b3162e9b087300
320000000000000060b3162e9b087300
000000000000003200000000e16b3604c44c730000000000
320000000000000060b3162e9b087300
0000003200000000e16b3604c44c7300
-
{e=>88524857,a=>-90,d=>2,c=>1,h=>306,b=>4,g=>3,f=>5,i=>249}
a6ffffff8c00000039c84655cb04f900
a6ffffffffffffff8c00000039c84655cb04f90000000000
a6ffffffffffffff8c00000039c84655cb04f90000000000
ffffffa685000000546c839ac264f900
a6ffffff8c00000039c84655cb04f900
a6ffffff8c00000039c84655cb04f900
ffffffffffffffa685000000546c839ac264f90000000000
a6ffffff8c00000039c84655cb04f900
ffffffa685000000546c839ac264f900
-
{e=>192500988,a=>-84,d=>1,c=>2,h=>5667,b=>5,g=>0,f=>5,i=>178}
acffffff55000000fc54795b8c58b200
acffffffffffffff55000000fc54795b8c58b20000000000
acffffffffffffff55000000fc54795b8c58b20000000000
ffffffaca8800000b7954fca2c46b200
acffffff55000000fc54795b8c58b200
acffffff55000000fc54795b8c58b200
ffffffffffffffaca8800000b7954fca2c46b20000000000
acffffff55000000fc54795b8c58b200
ffffffaca8800000b7954fca2c46b200
-
{e=>102319901,a=>48,d=>6,c=>5,h=>4809,b=>5,g=>0,f=>5,i=>243}
30000000ad0100001d471956244bf300
3000000000000000ad0100001d471956244bf30000000000
3000000000000000ad0100001d471956244bf30000000000
00000030b7000000619471da2592f300
30000000ad0100001d471956244bf300
30000000ad0100001d471956244bf300
0000000000000030b7000000619471da2592f30000000000
30000000ad0100001d471956244bf300
00000030b7000000619471da2592f300
-
{e=>105125875,a=>-48,d=>6,c=>2,h=>3701,b=>4,g=>0,f=>6,i=>134}
d0ffffff94010000f3174466d4398600
d0ffffffffffffff94010000f3174466d439860000000000
d0ffffffffffffff94010000f3174466d439860000000000
ffffffd08b00000064417f3c1cea8600
d0ffffff94010000f3174466d4398600
d0ffffff94010000f3174466d4398600
ffffffffffffffd08b00000064417f3c1cea860000000000
d0ffffff94010000f3174466d4398600
ffffffd08b00000064417f3c1cea8600
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
};
-
{a=>7}
07
07
07
e0
07000000
07
e0
07
e0
-
{a=>4}
04
04
04
80
04000000
04
80
04
80
-
{a=>4}
04
04
04
80
04000000
04
80
04
80
-
{a=>7}
07
07
07
e0
07000000
07
e0
07
e0
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
};
-
{a=>6,b=>7}
3e
3e
3e
dc
3e000000
3e
dc
3e
dc
-
{a=>6,b=>0}
06
06
06
c0
06000000
06
c0
06
c0
-
{a=>1,b=>6}
31
31
31
38
31000000
31
38
31
38
-
{a=>3,b=>4}
23
23
23
70
23000000
23
70
23
70
-
{a=>5,b=>5}
2d
2d
2d
b4
2d000000
2d
b4
2d
b4
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
};
-
{c=>6,a=>3,b=>3}
9b01
9b01
9b01
6f00
9b010000
9b01
6f00
9b01
6f00
-
{c=>2,a=>6,b=>1}
8e00
8e00
8e00
c500
8e000000
8e00
c500
8e00
c500
-
{c=>6,a=>4,b=>1}
8c01
8c01
8c01
8700
8c010000
8c01
8700
8c01
8700
-
{c=>2,a=>1,b=>0}
8100
8100
8100
2100
81000000
8100
2100
8100
2100
-
{c=>7,a=>4,b=>7}
fc01
fc01
fc01
9f80
fc010000
fc01
9f80
fc01
9f80
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
};
-
{c=>1,a=>4,b=>4,d=>133269742}
64000000ee88f107
64000000ee88f107
64000000ee88f107
908000007f188ee0
64000000ee88f107
64000000ee88f107
908000007f188ee0
64000000ee88f107
908000007f188ee0
-
{c=>3,a=>7,b=>1,d=>257081784}
cf000000b8c1520f
cf000000b8c1520f
cf000000b8c1520f
e5800000f52c1b80
cf000000b8c1520f
cf000000b8c1520f
e5800000f52c1b80
cf000000b8c1520f
e5800000f52c1b80
-
{c=>0,a=>7,b=>6,d=>258403104}
3700000020eb660f
3700000020eb660f
3700000020eb660f
f8000000f66eb200
3700000020eb660f
3700000020eb660f
f8000000f66eb200
3700000020eb660f
f8000000f66eb200
-
{c=>5,a=>7,b=>0,d=>128978242}
47010000420db007
47010000420db007
47010000420db007
e28000007b00d420
47010000420db007
47010000420db007
e28000007b00d420
47010000420db007
e28000007b00d420
-
{c=>5,a=>0,b=>4,d=>243031951}
600100008f5f7c0e
600100008f5f7c0e
600100008f5f7c0e
12800000e7c5f8f0
600100008f5f7c0e
600100008f5f7c0e
12800000e7c5f8f0
600100008f5f7c0e
12800000e7c5f8f0
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
};
-
{e=>0,c=>2,a=>6,b=>7,d=>33702724}
be00000044430202
be00000044430202
be00000044430202
dd00000020243440
be00000044430202
be00000044430202
dd00000020243440
be00000044430202
dd00000020243440
-
{e=>2,c=>5,a=>5,b=>2,d=>6095297}
55010000c1015d20
55010000c1015d20
55010000c1015d20
aa80000005d01c14
55010000c1015d20
55010000c1015d20
aa80000005d01c14
55010000c1015d20
aa80000005d01c14
-
{e=>4,c=>4,a=>4,b=>6,d=>213519559}
34010000c70cba4c
34010000c70cba4c
34010000c70cba4c
9a000000cba0cc78
34010000c70cba4c
34010000c70cba4c
9a000000cba0cc78
34010000c70cba4c
9a000000cba0cc78
-
{e=>5,c=>2,a=>7,b=>5,d=>18462540}
af0000004cb71951
af0000004cb71951
af0000004cb71951
f5000000119b74ca
af0000004cb71951
af0000004cb71951
f5000000119b74ca
af0000004cb71951
f5000000119b74ca
-
{e=>1,c=>6,a=>1,b=>7,d=>89059346}
b901000012f04e15
b901000012f04e15
b901000012f04e15
3f00000054ef0122
b901000012f04e15
b901000012f04e15
3f00000054ef0122
b901000012f04e15
3f00000054ef0122
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
};
-
{e=>5,c=>1,a=>7,b=>1,d=>136757511,f=>1}
4f00000007c1265801000000
4f00000007c1265801000000
4f00000007c1265801000000
e4800000826c107a40000000
4f00000007c1265801000000
4f00000007c1265801000000
e4800000826c107a40000000
4f00000007c1265801000000
e4800000826c107a40000000
-
{e=>0,c=>4,a=>7,b=>4,d=>125709169,f=>0}
27010000712b7e0700000000
27010000712b7e0700000000
27010000712b7e0700000000
f200000077e2b71000000000
27010000712b7e0700000000
27010000712b7e0700000000
f200000077e2b71000000000
27010000712b7e0700000000
f200000077e2b71000000000
-
{e=>4,c=>6,a=>4,b=>0,d=>58396282,f=>2}
840100007a0e7b4302000000
840100007a0e7b4302000000
840100007a0e7b4302000000
8300000037b0e7a880000000
840100007a0e7b4302000000
840100007a0e7b4302000000
8300000037b0e7a880000000
840100007a0e7b4302000000
8300000037b0e7a880000000
-
{e=>0,c=>7,a=>2,b=>1,d=>156900784,f=>0}
ca010000b01d5a0900000000
ca010000b01d5a0900000000
ca010000b01d5a0900000000
4780000095a1db0000000000
ca010000b01d5a0900000000
ca010000b01d5a0900000000
4780000095a1db0000000000
ca010000b01d5a0900000000
4780000095a1db0000000000
-
{e=>6,c=>5,a=>4,b=>0,d=>153791533,f=>0}
440100002dac2a6900000000
440100002dac2a6900000000
440100002dac2a6900000000
8280000092aac2dc00000000
440100002dac2a6900000000
440100002dac2a6900000000
8280000092aac2dc00000000
440100002dac2a6900000000
8280000092aac2dc00000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
};
-
{e=>4,c=>6,a=>0,g=>3159,b=>3,d=>201444973,f=>3}
980100006dce014c5f310000
980100006dce014c5f310000
980100006dce014c5f310000
0f000000c01ce6d8d8ae0000
980100006dce014c5f310000
980100006dce014c5f310000
0f000000c01ce6d8d8ae0000
980100006dce014c5f310000
0f000000c01ce6d8d8ae0000
-
{e=>3,c=>5,a=>2,g=>1311,b=>0,d=>216985875,f=>0}
4201000013f1ee3c7c140000
4201000013f1ee3c7c140000
4201000013f1ee3c7c140000
42800000ceef11360a3e0000
4201000013f1ee3c7c140000
4201000013f1ee3c7c140000
42800000ceef11360a3e0000
4201000013f1ee3c7c140000
42800000ceef11360a3e0000
-
{e=>4,c=>1,a=>4,g=>4089,b=>3,d=>90392677,f=>2}
5c00000065486345e63f0000
5c00000065486345e63f0000
5c00000065486345e63f0000
8c800000563486589ff20000
5c00000065486345e63f0000
5c00000065486345e63f0000
8c800000563486589ff20000
5c00000065486345e63f0000
8c800000563486589ff20000
-
{e=>4,c=>6,a=>2,g=>6577,b=>0,d=>32952048,f=>2}
82010000f0cef641c6660000
82010000f0cef641c6660000
82010000f0cef641c6660000
430000001f6cef08b3620000
82010000f0cef641c6660000
82010000f0cef641c6660000
430000001f6cef08b3620000
82010000f0cef641c6660000
430000001f6cef08b3620000
-
{e=>6,c=>3,a=>2,g=>5134,b=>2,d=>70582675,f=>0}
d20000009301356438500000
d20000009301356438500000
d20000009301356438500000
498000004350193c281c0000
d20000009301356438500000
d20000009301356438500000
498000004350193c281c0000
d20000009301356438500000
498000004350193c281c0000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
  unsigned char  h;
};
-
{e=>4,a=>7,d=>66200696,c=>5,h=>31,b=>4,g=>6484,f=>1}
670100007824f24351651f00
670100007824f24351651f00
670100007824f24351651f00
f28000003f22478872a81f00
670100007824f24351651f00
670100007824f24351651f00
f28000003f22478872a81f00
670100007824f24351651f00
f28000003f22478872a81f00
-
{e=>3,a=>0,d=>142854848,c=>3,h=>30,b=>3,g=>2350,f=>3}
d8000000c0ca8338bb241e00
d8000000c0ca8338bb241e00
d8000000c0ca8338bb241e00
0d800000883cac06d25c1e00
d8000000c0ca8338bb241e00
d8000000c0ca8338bb241e00
0d800000883cac06d25c1e00
d8000000c0ca8338bb241e00
0d800000883cac06d25c1e00
-
{e=>0,a=>3,d=>178180283,c=>3,h=>162,b=>2,g=>1577,f=>2}
d3000000bbd09e0aa618a200
d3000000bbd09e0aa618a200
d3000000bbd09e0aa618a200
69800000a9ed0bb08c52a200
d3000000bbd09e0aa618a200
d3000000bbd09e0aa618a200
69800000a9ed0bb08c52a200
d3000000bbd09e0aa618a200
69800000a9ed0bb08c52a200
-
{e=>7,a=>3,d=>71770977,c=>0,h=>159,b=>4,g=>2221,f=>2}
2300000061234774b6229f00
2300000061234774b6229f00
2300000061234774b6229f00
700000004472361e915a9f00
2300000061234774b6229f00
2300000061234774b6229f00
700000004472361e915a9f00
2300000061234774b6229f00
700000004472361e915a9f00
-
{e=>3,a=>7,d=>209718566,c=>4,h=>184,b=>0,g=>4011,f=>3}
07010000260d803caf3eb800
07010000260d803caf3eb800
07010000260d803caf3eb800
e2000000c800d266df56b800
07010000260d803caf3eb800
07010000260d803caf3eb800
e2000000c800d266df56b800
07010000260d803caf3eb800
e2000000c800d266df56b800
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
};
-
{a=>-101,b=>3}
9b03
9b03
9b03
9b60
9b030000
9b03
9b60
9b03
9b60
-
{a=>-121,b=>0}
8700
8700
8700
8700
87000000
8700
8700
8700
8700
-
{a=>49,b=>5}
3105
3105
3105
31a0
31050000
3105
31a0
3105
31a0
-
{a=>-18,b=>5}
ee05
ee05
ee05
eea0
ee050000
ee05
eea0
ee05
eea0
-
{a=>-28,b=>7}
e407
e407
e407
e4e0
e4070000
e407
e4e0
e407
e4e0
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>5,a=>-95,b=>6}
a12e
a12e
a12e
a1d4
a12e0000
a12e
a1d4
a12e
a1d4
-
{c=>3,a=>105,b=>5}
691d
691d
691d
69ac
691d0000
691d
69ac
691d
69ac
-
{c=>5,a=>-88,b=>7}
a82f
a82f
a82f
a8f4
a82f0000
a82f
a8f4
a82f
a8f4
-
{c=>3,a=>-100,b=>0}
9c18
9c18
9c18
9c0c
9c180000
9c18
9c0c
9c18
9c0c
-
{c=>0,a=>-15,b=>0}
f100
f100
f100
f100
f1000000
f100
f100
f100
f100
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>1,a=>78,b=>7,d=>5}
4e0f0500
4e0f0500
4e0f0500
4ee4a000
4e0f0500
4e0f0500
4ee4a000
4e0f0500
4ee4a000
-
{c=>4,a=>18,b=>5,d=>2}
12250200
12250200
12250200
12b04000
12250200
12250200
12b04000
12250200
12b04000
-
{c=>7,a=>56,b=>5,d=>0}
383d0000
383d0000
383d0000
38bc0000
383d0000
383d0000
38bc0000
383d0000
38bc0000
-
{c=>5,a=>-82,b=>5,d=>1}
ae2d0100
ae2d0100
ae2d0100
aeb42000
ae2d0100
ae2d0100
aeb42000
ae2d0100
aeb42000
-
{c=>7,a=>60,b=>6,d=>5}
3c3e0500
3c3e0500
3c3e0500
3cdca000
3c3e0500
3c3e0500
3cdca000
3c3e0500
3cdca000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>221131133,c=>6,a=>105,b=>3,d=>0}
693300007d312e0d
693300007d312e0d
693300007d312e0d
69780000d2e317d0
693300007d312e0d
693300007d312e0d
69780000d2e317d0
693300007d312e0d
69780000d2e317d0
-
{e=>105130068,c=>7,a=>43,b=>7,d=>4}
2b3f040054284406
2b3f040054284406
2b3f040054284406
2bfc800064428540
2b3f040054284406
2b3f040054284406
2bfc800064428540
2b3f040054284406
2bfc800064428540
-
{e=>200295387,c=>7,a=>95,b=>0,d=>4}
5f380400db43f00b
5f380400db43f00b
5f380400db43f00b
5f1c8000bf043db0
5f380400db43f00b
5f380400db43f00b
5f1c8000bf043db0
5f380400db43f00b
5f1c8000bf043db0
-
{e=>204864432,c=>4,a=>121,b=>0,d=>5}
79200500b0fb350c
79200500b0fb350c
79200500b0fb350c
7910a000c35fbb00
79200500b0fb350c
79200500b0fb350c
7910a000c35fbb00
79200500b0fb350c
7910a000c35fbb00
-
{e=>116121104,c=>3,a=>-77,b=>7,d=>7}
b31f070010deeb06
b31f070010deeb06
b31f070010deeb06
b3ece0006ebde100
b31f070010deeb06
b31f070010deeb06
b3ece0006ebde100
b31f070010deeb06
b3ece0006ebde100
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>172836301,c=>0,a=>32,b=>7,d=>6,f=>3}
20070600cd454d3a
20070600cd454d3a
20070600cd454d3a
20e0c000a4d45cd6
20070600cd454d3a
20070600cd454d3a
20e0c000a4d45cd6
20070600cd454d3a
20e0c000a4d45cd6
-
{e=>127428220,c=>5,a=>-44,b=>2,d=>7,f=>1}
d42a07007c669817
d42a07007c669817
d42a07007c669817
d454e000798667c2
d42a07007c669817
d42a07007c669817
d454e000798667c2
d42a07007c669817
d454e000798667c2
-
{e=>422562,c=>0,a=>60,b=>7,d=>1,f=>2}
3c070100a2720620
3c070100a2720620
3c070100a2720620
3ce0200000672a24
3c070100a2720620
3c070100a2720620
3ce0200000672a24
3c070100a2720620
3ce0200000672a24
-
{e=>96278787,c=>7,a=>3,b=>7,d=>2,f=>0}
033f02000319bd05
033f02000319bd05
033f02000319bd05
03fc40005bd19030
033f02000319bd05
033f02000319bd05
03fc40005bd19030
033f02000319bd05
03fc40005bd19030
-
{e=>241856194,c=>3,a=>-107,b=>0,d=>6,f=>5}
95180600c26e6a5e
95180600c26e6a5e
95180600c26e6a5e
950cc000e6a6ec2a
95180600c26e6a5e
95180600c26e6a5e
950cc000e6a6ec2a
95180600c26e6a5e
950cc000e6a6ec2a
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>239818291,c=>6,a=>50,g=>2,b=>1,d=>2,f=>7}
3231020033564b7e02000000
3231020033564b7e02000000
3231020033564b7e02000000
32384000e4b5633e80000000
3231020033564b7e02000000
3231020033564b7e02000000
32384000e4b5633e80000000
3231020033564b7e02000000
32384000e4b5633e80000000
-
{e=>27118579,c=>2,a=>-3,g=>0,b=>0,d=>4,f=>5}
fd100400f3cb9d5100000000
fd100400f3cb9d5100000000
fd100400f3cb9d5100000000
fd08800019dcbf3a00000000
fd100400f3cb9d5100000000
fd100400f3cb9d5100000000
fd08800019dcbf3a00000000
fd100400f3cb9d5100000000
fd08800019dcbf3a00000000
-
{e=>134242001,c=>3,a=>59,g=>3,b=>5,d=>5,f=>6}
3b1d0500d15e006803000000
3b1d0500d15e006803000000
3b1d0500d15e006803000000
3baca0008005ed1cc0000000
3b1d0500d15e006803000000
3b1d0500d15e006803000000
3baca0008005ed1cc0000000
3b1d0500d15e006803000000
3baca0008005ed1cc0000000
-
{e=>65328260,c=>1,a=>-116,g=>1,b=>5,d=>4,f=>3}
8c0d040084d4e43301000000
8c0d040084d4e43301000000
8c0d040084d4e43301000000
8ca480003e4d484640000000
8c0d040084d4e43301000000
8c0d040084d4e43301000000
8ca480003e4d484640000000
8c0d040084d4e43301000000
8ca480003e4d484640000000
-
{e=>139743207,c=>3,a=>-41,g=>1,b=>3,d=>1,f=>6}
d71b0100e74f546801000000
d71b0100e74f546801000000
d71b0100e74f546801000000
d76c20008544fe7c40000000
d71b0100e74f546801000000
d71b0100e74f546801000000
d76c20008544fe7c40000000
d71b0100e74f546801000000
d76c20008544fe7c40000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>230124716,a=>16,d=>7,c=>1,h=>3908,b=>7,g=>2,f=>7}
100f0700ac6cb77d123d0000
100f0700ac6cb77d123d0000
100f0700ac6cb77d123d0000
10e4e000db76cace9e880000
100f0700ac6cb77d123d0000
100f0700ac6cb77d123d0000
10e4e000db76cace9e880000
100f0700ac6cb77d123d0000
10e4e000db76cace9e880000
-
{e=>124232976,a=>64,d=>4,c=>0,h=>5030,b=>2,g=>3,f=>4}
4002040010a567479b4e0000
4002040010a567479b4e0000
4002040010a567479b4e0000
40408000767a5108e74c0000
4002040010a567479b4e0000
4002040010a567479b4e0000
40408000767a5108e74c0000
4002040010a567479b4e0000
40408000767a5108e74c0000
-
{e=>239963925,a=>67,d=>1,c=>5,h=>5257,b=>4,g=>2,f=>4}
432c0100158f4d4e26520000
432c0100158f4d4e26520000
432c0100158f4d4e26520000
43942000e4d8f158a9120000
432c0100158f4d4e26520000
432c0100158f4d4e26520000
43942000e4d8f158a9120000
432c0100158f4d4e26520000
43942000e4d8f158a9120000
-
{e=>119523408,a=>-65,d=>2,c=>5,h=>4247,b=>2,g=>2,f=>3}
bf2a020050c81f375e420000
bf2a020050c81f375e420000
bf2a020050c81f375e420000
bf54400071fc8506a12e0000
bf2a020050c81f375e420000
bf2a020050c81f375e420000
bf54400071fc8506a12e0000
bf2a020050c81f375e420000
bf54400071fc8506a12e0000
-
{e=>9728961,a=>51,d=>5,c=>0,h=>2851,b=>7,g=>0,f=>4}
33070500c17394408c2c0000
33070500c17394408c2c0000
33070500c17394408c2c0000
33e0a00009473c1816460000
33070500c17394408c2c0000
33070500c17394408c2c0000
33e0a00009473c1816460000
33070500c17394408c2c0000
33e0a00009473c1816460000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>180027965,a=>92,d=>2,c=>4,h=>1057,b=>1,g=>1,f=>0,i=>60}
5c2102003d02bb0a85103c00
5c2102003d02bb0a85103c00
5c2102003d02bb0a85103c00
5c304000abb023d048423c00
5c2102003d02bb0a85103c00
5c2102003d02bb0a85103c00
5c304000abb023d048423c00
5c2102003d02bb0a85103c00
5c304000abb023d048423c00
-
{e=>231855491,a=>-124,d=>6,c=>4,h=>1682,b=>7,g=>0,f=>6,i=>222}
8427060083d5d16d481ade00
8427060083d5d16d481ade00
8427060083d5d16d481ade00
84f0c000dd1d583c0d24de00
8427060083d5d16d481ade00
8427060083d5d16d481ade00
84f0c000dd1d583c0d24de00
8427060083d5d16d481ade00
84f0c000dd1d583c0d24de00
-
{e=>14781907,a=>-124,d=>1,c=>0,h=>7235,b=>7,g=>0,f=>3,i=>179}
84070100d38de1300c71b300
84070100d38de1300c71b300
84070100d38de1300c71b300
84e020000e18dd363886b300
84070100d38de1300c71b300
84070100d38de1300c71b300
84e020000e18dd363886b300
84070100d38de1300c71b300
84e020000e18dd363886b300
-
{e=>268185659,a=>-127,d=>4,c=>0,h=>4094,b=>2,g=>3,f=>7,i=>166}
810204003b30fc7ffb3fa600
810204003b30fc7ffb3fa600
810204003b30fc7ffb3fa600
81408000ffc303bedffca600
810204003b30fc7ffb3fa600
810204003b30fc7ffb3fa600
81408000ffc303bedffca600
810204003b30fc7ffb3fa600
81408000ffc303bedffca600
-
{e=>102826413,a=>-10,d=>2,c=>6,h=>6758,b=>6,g=>2,f=>7,i=>80}
f6360200ad0121769a695000
f6360200ad0121769a695000
f6360200ad0121769a695000
f6d8400062101adeb4cc5000
f6360200ad0121769a695000
f6360200ad0121769a695000
f6d8400062101adeb4cc5000
f6360200ad0121769a695000
f6d8400062101adeb4cc5000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
};
-
{a=>-45,b=>6}
d3ff0600
d3ff0600
d3ff0600
ffd3c000
d3ff0600
d3ff0600
ffd3c000
d3ff0600
ffd3c000
-
{a=>-32,b=>7}
e0ff0700
e0ff0700
e0ff0700
ffe0e000
e0ff0700
e0ff0700
ffe0e000
e0ff0700
ffe0e000
-
{a=>43,b=>2}
2b000200
2b000200
2b000200
002b4000
2b000200
2b000200
002b4000
2b000200
002b4000
-
{a=>8,b=>3}
08000300
08000300
08000300
00086000
08000300
08000300
00086000
08000300
00086000
-
{a=>-1,b=>1}
ffff0100
ffff0100
ffff0100
ffff2000
ffff0100
ffff0100
ffff2000
ffff0100
ffff2000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>5,a=>126,b=>7}
7e002f00
7e002f00
7e002f00
007ef400
7e002f00
7e002f00
007ef400
7e002f00
007ef400
-
{c=>4,a=>-38,b=>6}
daff2600
daff2600
daff2600
ffdad000
daff2600
daff2600
ffdad000
daff2600
ffdad000
-
{c=>3,a=>-19,b=>2}
edff1a00
edff1a00
edff1a00
ffed4c00
edff1a00
edff1a00
ffed4c00
edff1a00
ffed4c00
-
{c=>0,a=>26,b=>4}
1a000400
1a000400
1a000400
001a8000
1a000400
1a000400
001a8000
1a000400
001a8000
-
{c=>4,a=>125,b=>4}
7d002400
7d002400
7d002400
007d9000
7d002400
7d002400
007d9000
7d002400
007d9000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>4,a=>66,b=>0,d=>6}
4200a001
4200a001
4200a001
00421300
4200a001
4200a001
00421300
4200a001
00421300
-
{c=>3,a=>-65,b=>7,d=>5}
bfff5f01
bfff5f01
bfff5f01
ffbfee80
bfff5f01
bfff5f01
ffbfee80
bfff5f01
ffbfee80
-
{c=>5,a=>42,b=>5,d=>4}
2a002d01
2a002d01
2a002d01
002ab600
2a002d01
2a002d01
002ab600
2a002d01
002ab600
-
{c=>1,a=>-96,b=>4,d=>5}
a0ff4c01
a0ff4c01
a0ff4c01
ffa08680
a0ff4c01
a0ff4c01
ffa08680
a0ff4c01
ffa08680
-
{c=>2,a=>-85,b=>0,d=>4}
abff1001
abff1001
abff1001
ffab0a00
abff1001
abff1001
ffab0a00
abff1001
ffab0a00
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>144118602,c=>6,a=>-68,b=>2,d=>5}
bcff72014a139708
bcff72014a139708
bcff72014a139708
ffbc5a80897134a0
bcff72014a139708
bcff72014a139708
ffbc5a80897134a0
bcff72014a139708
ffbc5a80897134a0
-
{e=>194550170,c=>1,a=>-13,b=>2,d=>6}
f3ff8a019a99980b
f3ff8a019a99980b
f3ff8a019a99980b
fff34700b98999a0
f3ff8a019a99980b
f3ff8a019a99980b
fff34700b98999a0
f3ff8a019a99980b
fff34700b98999a0
-
{e=>80715514,c=>4,a=>100,b=>3,d=>0}
64002300fa9ecf04
64002300fa9ecf04
64002300fa9ecf04
006470004cf9efa0
64002300fa9ecf04
64002300fa9ecf04
006470004cf9efa0
64002300fa9ecf04
006470004cf9efa0
-
{e=>265138084,c=>6,a=>37,b=>2,d=>0}
25003200a4afcd0f
25003200a4afcd0f
25003200a4afcd0f
00255800fcdafa40
25003200a4afcd0f
25003200a4afcd0f
00255800fcdafa40
25003200a4afcd0f
00255800fcdafa40
-
{e=>222887293,c=>6,a=>11,b=>1,d=>5}
0b0071017dfd480d
0b0071017dfd480d
0b0071017dfd480d
000b3a80d48fd7d0
0b0071017dfd480d
0b0071017dfd480d
000b3a80d48fd7d0
0b0071017dfd480d
000b3a80d48fd7d0
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>18626280,c=>1,a=>-46,b=>5,d=>7,f=>5}
d2ffcd01e8361c51
d2ffcd01e8361c51
d2ffcd01e8361c51
ffd2a78011c36e8a
d2ffcd01e8361c51
d2ffcd01e8361c51
ffd2a78011c36e8a
d2ffcd01e8361c51
ffd2a78011c36e8a
-
{e=>65331951,c=>5,a=>-123,b=>1,d=>4,f=>2}
85ff2901efe2e423
85ff2901efe2e423
85ff2901efe2e423
ff8536003e4e2ef4
85ff2901efe2e423
85ff2901efe2e423
ff8536003e4e2ef4
85ff2901efe2e423
ff8536003e4e2ef4
-
{e=>22199225,c=>6,a=>19,b=>2,d=>4,f=>0}
13003201b9bb5201
13003201b9bb5201
13003201b9bb5201
00135a00152bbb90
13003201b9bb5201
13003201b9bb5201
00135a00152bbb90
13003201b9bb5201
00135a00152bbb90
-
{e=>9181650,c=>6,a=>56,b=>1,d=>0,f=>5}
38003100d2198c50
38003100d2198c50
38003100d2198c50
0038380008c19d2a
38003100d2198c50
38003100d2198c50
0038380008c19d2a
38003100d2198c50
0038380008c19d2a
-
{e=>157034625,c=>6,a=>76,b=>0,d=>2,f=>5}
4c00b00081285c59
4c00b00081285c59
4c00b00081285c59
004c190095c2881a
4c00b00081285c59
4c00b00081285c59
004c190095c2881a
4c00b00081285c59
004c190095c2881a
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>267203857,c=>2,a=>90,g=>1,b=>5,d=>0,f=>2}
5a0015001135ed2f01000000
5a0015001135ed2f01000000
5a0015001135ed2f01000000
005aa800fed3511440000000
5a0015001135ed2f01000000
5a0015001135ed2f01000000
005aa800fed3511440000000
5a0015001135ed2f01000000
005aa800fed3511440000000
-
{e=>138564760,c=>2,a=>-49,g=>2,b=>4,d=>6,f=>3}
cfff94019854423802000000
cfff94019854423802000000
cfff94019854423802000000
ffcf8b008425498680000000
cfff94019854423802000000
cfff94019854423802000000
ffcf8b008425498680000000
cfff94019854423802000000
ffcf8b008425498680000000
-
{e=>91970329,c=>6,a=>-122,g=>1,b=>1,d=>3,f=>0}
86fff100195b7b0501000000
86fff100195b7b0501000000
86fff100195b7b0501000000
ff86398057b5b19040000000
86fff100195b7b0501000000
86fff100195b7b0501000000
ff86398057b5b19040000000
86fff100195b7b0501000000
ff86398057b5b19040000000
-
{e=>102576163,c=>7,a=>39,g=>1,b=>0,d=>2,f=>6}
2700b80023301d6601000000
2700b80023301d6601000000
2700b80023301d6601000000
00271d0061d3023c40000000
2700b80023301d6601000000
2700b80023301d6601000000
00271d0061d3023c40000000
2700b80023301d6601000000
00271d0061d3023c40000000
-
{e=>263662536,c=>3,a=>-27,g=>1,b=>3,d=>4,f=>5}
e5ff1b01c82bb75f01000000
e5ff1b01c82bb75f01000000
e5ff1b01c82bb75f01000000
ffe56e00fb72bc8a40000000
e5ff1b01c82bb75f01000000
e5ff1b01c82bb75f01000000
ffe56e00fb72bc8a40000000
e5ff1b01c82bb75f01000000
ffe56e00fb72bc8a40000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>194432513,a=>30,d=>2,c=>2,h=>1472,b=>2,g=>1,f=>3}
1e00920001ce963b01170000
1e00920001ce963b01170000
1e00920001ce963b01170000
001e4900b96ce0164b800000
1e00920001ce963b01170000
1e00920001ce963b01170000
001e4900b96ce0164b800000
1e00920001ce963b01170000
001e4900b96ce0164b800000
-
{e=>90729129,a=>18,d=>7,c=>0,h=>7366,b=>1,g=>1,f=>4}
1200c101a96a684519730000
1200c101a96a684519730000
1200c101a96a684519730000
001223805686aa98798c0000
1200c101a96a684519730000
1200c101a96a684519730000
001223805686aa98798c0000
1200c101a96a684519730000
001223805686aa98798c0000
-
{e=>241644573,a=>75,d=>6,c=>6,h=>2932,b=>7,g=>3,f=>1}
4b00b7011d34671ed32d0000
4b00b7011d34671ed32d0000
4b00b7011d34671ed32d0000
004bfb00e67341d2d6e80000
4b00b7011d34671ed32d0000
4b00b7011d34671ed32d0000
004bfb00e67341d2d6e80000
4b00b7011d34671ed32d0000
004bfb00e67341d2d6e80000
-
{e=>176079331,a=>31,d=>2,c=>1,h=>4829,b=>6,g=>2,f=>2}
1f008e00e3c17e2a764b0000
1f008e00e3c17e2a764b0000
1f008e00e3c17e2a764b0000
001fc500a7ec1e34a5ba0000
1f008e00e3c17e2a764b0000
1f008e00e3c17e2a764b0000
001fc500a7ec1e34a5ba0000
1f008e00e3c17e2a764b0000
001fc500a7ec1e34a5ba0000
-
{e=>239368188,a=>55,d=>5,c=>3,h=>1857,b=>6,g=>3,f=>7}
37005e01fc77447e071d0000
37005e01fc77447e071d0000
37005e01fc77447e071d0000
0037ce80e4477fcece820000
37005e01fc77447e071d0000
37005e01fc77447e071d0000
0037ce80e4477fcece820000
37005e01fc77447e071d0000
0037ce80e4477fcece820000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>108438729,a=>58,d=>1,c=>1,h=>5562,b=>0,g=>0,f=>6,i=>192}
3a004800c9a47666e856c000
3a004800c9a47666e856c000
3a004800c9a47666e856c000
003a0480676a4c9c2b74c000
3a004800c9a47666e856c000
3a004800c9a47666e856c000
003a0480676a4c9c2b74c000
3a004800c9a47666e856c000
003a0480676a4c9c2b74c000
-
{e=>5753109,a=>98,d=>6,c=>2,h=>3842,b=>0,g=>1,f=>4,i=>170}
6200900115c95740093caa00
6200900115c95740093caa00
6200900115c95740093caa00
00620b00057c91585e04aa00
6200900115c95740093caa00
6200900115c95740093caa00
00620b00057c91585e04aa00
6200900115c95740093caa00
00620b00057c91585e04aa00
-
{e=>152483984,a=>118,d=>4,c=>6,h=>3538,b=>4,g=>1,f=>6,i=>229}
7600340190b816694937e500
7600340190b816694937e500
7600340190b816694937e500
00769a00916b890c5ba4e500
7600340190b816694937e500
7600340190b816694937e500
00769a00916b890c5ba4e500
7600340190b816694937e500
00769a00916b890c5ba4e500
-
{e=>54363077,a=>36,d=>6,c=>6,h=>7156,b=>2,g=>1,f=>3,i=>92}
2400b201c5833d33d16f5c00
2400b201c5833d33d16f5c00
2400b201c5833d33d16f5c00
00245b0033d83c5677e85c00
2400b201c5833d33d16f5c00
2400b201c5833d33d16f5c00
00245b0033d83c5677e85c00
2400b201c5833d33d16f5c00
00245b0033d83c5677e85c00
-
{e=>73602633,a=>-19,d=>3,c=>5,h=>1654,b=>6,g=>2,f=>6,i=>188}
edffee0049166364da19bc00
edffee0049166364da19bc00
edffee0049166364da19bc00
ffedd5804631649c8cecbc00
edffee0049166364da19bc00
edffee0049166364da19bc00
ffedd5804631649c8cecbc00
edffee0049166364da19bc00
ffedd5804631649c8cecbc00
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
};
-
{a=>31,b=>7}
1f00000007000000
1f00000007000000
1f00000007000000
0000001fe0000000
1f00000007000000
1f00000007000000
0000001fe0000000
1f00000007000000
0000001fe0000000
-
{a=>70,b=>7}
4600000007000000
4600000007000000
4600000007000000
00000046e0000000
4600000007000000
4600000007000000
00000046e0000000
4600000007000000
00000046e0000000
-
{a=>-101,b=>4}
9bffffff04000000
9bffffff04000000
9bffffff04000000
ffffff9b80000000
9bffffff04000000
9bffffff04000000
ffffff9b80000000
9bffffff04000000
ffffff9b80000000
-
{a=>111,b=>2}
6f00000002000000
6f00000002000000
6f00000002000000
0000006f40000000
6f00000002000000
6f00000002000000
0000006f40000000
6f00000002000000
0000006f40000000
-
{a=>-80,b=>3}
b0ffffff03000000
b0ffffff03000000
b0ffffff03000000
ffffffb060000000
b0ffffff03000000
b0ffffff03000000
ffffffb060000000
b0ffffff03000000
ffffffb060000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>7,a=>76,b=>1}
4c00000039000000
4c00000039000000
4c00000039000000
0000004c3c000000
4c00000039000000
4c00000039000000
0000004c3c000000
4c00000039000000
0000004c3c000000
-
{c=>6,a=>52,b=>5}
3400000035000000
3400000035000000
3400000035000000
00000034b8000000
3400000035000000
3400000035000000
00000034b8000000
3400000035000000
00000034b8000000
-
{c=>4,a=>-96,b=>4}
a0ffffff24000000
a0ffffff24000000
a0ffffff24000000
ffffffa090000000
a0ffffff24000000
a0ffffff24000000
ffffffa090000000
a0ffffff24000000
ffffffa090000000
-
{c=>4,a=>16,b=>5}
1000000025000000
1000000025000000
1000000025000000
00000010b0000000
1000000025000000
1000000025000000
00000010b0000000
1000000025000000
00000010b0000000
-
{c=>5,a=>-115,b=>3}
8dffffff2b000000
8dffffff2b000000
8dffffff2b000000
ffffff8d74000000
8dffffff2b000000
8dffffff2b000000
ffffff8d74000000
8dffffff2b000000
ffffff8d74000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>3,a=>-95,b=>1,d=>3}
a1ffffffd9000000
a1ffffffd9000000
a1ffffffd9000000
ffffffa12d800000
a1ffffffd9000000
a1ffffffd9000000
ffffffa12d800000
a1ffffffd9000000
ffffffa12d800000
-
{c=>1,a=>-30,b=>2,d=>7}
e2ffffffca010000
e2ffffffca010000
e2ffffffca010000
ffffffe247800000
e2ffffffca010000
e2ffffffca010000
ffffffe247800000
e2ffffffca010000
ffffffe247800000
-
{c=>3,a=>28,b=>7,d=>3}
1c000000df000000
1c000000df000000
1c000000df000000
0000001ced800000
1c000000df000000
1c000000df000000
0000001ced800000
1c000000df000000
0000001ced800000
-
{c=>1,a=>34,b=>1,d=>3}
22000000c9000000
22000000c9000000
22000000c9000000
0000002225800000
22000000c9000000
22000000c9000000
0000002225800000
22000000c9000000
0000002225800000
-
{c=>5,a=>88,b=>6,d=>1}
580000006e000000
580000006e000000
580000006e000000
00000058d4800000
580000006e000000
580000006e000000
00000058d4800000
580000006e000000
00000058d4800000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>228389954,c=>6,a=>10,b=>1,d=>3}
0a000000f100000042f49c0d
0a000000f100000042f49c0d
0a000000f100000042f49c0d
0000000a39800000d9cf4420
0a000000f100000042f49c0d
0a000000f100000042f49c0d
0000000a39800000d9cf4420
0a000000f100000042f49c0d
0000000a39800000d9cf4420
-
{e=>26173929,c=>1,a=>46,b=>7,d=>3}
2e000000cf000000e9618f01
2e000000cf000000e9618f01
2e000000cf000000e9618f01
0000002ee580000018f61e90
2e000000cf000000e9618f01
2e000000cf000000e9618f01
0000002ee580000018f61e90
2e000000cf000000e9618f01
0000002ee580000018f61e90
-
{e=>31378561,c=>1,a=>-102,b=>0,d=>0}
9affffff0800000081ccde01
9affffff0800000081ccde01
9affffff0800000081ccde01
ffffff9a040000001decc810
9affffff0800000081ccde01
9affffff0800000081ccde01
ffffff9a040000001decc810
9affffff0800000081ccde01
ffffff9a040000001decc810
-
{e=>133881414,c=>3,a=>83,b=>6,d=>6}
530000009e01000046defa07
530000009e01000046defa07
530000009e01000046defa07
00000053cf0000007fade460
530000009e01000046defa07
530000009e01000046defa07
00000053cf0000007fade460
530000009e01000046defa07
00000053cf0000007fade460
-
{e=>185498202,c=>4,a=>-46,b=>2,d=>4}
d2ffffff220100005a7a0e0b
d2ffffff220100005a7a0e0b
d2ffffff220100005a7a0e0b
ffffffd252000000b0e7a5a0
d2ffffff220100005a7a0e0b
d2ffffff220100005a7a0e0b
ffffffd252000000b0e7a5a0
d2ffffff220100005a7a0e0b
ffffffd252000000b0e7a5a0
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>108248036,c=>1,a=>-113,b=>3,d=>5,f=>4}
8fffffff4b010000e4bb7346
8fffffff4b010000e4bb7346
8fffffff4b010000e4bb7346
ffffff8f66800000673bbe48
8fffffff4b010000e4bb7346
8fffffff4b010000e4bb7346
ffffff8f66800000673bbe48
8fffffff4b010000e4bb7346
ffffff8f66800000673bbe48
-
{e=>244754857,c=>2,a=>53,b=>1,d=>6,f=>7}
3500000091010000a9a9967e
3500000091010000a9a9967e
3500000091010000a9a9967e
000000352b000000e96a9a9e
3500000091010000a9a9967e
3500000091010000a9a9967e
000000352b000000e96a9a9e
3500000091010000a9a9967e
000000352b000000e96a9a9e
-
{e=>82868130,c=>3,a=>-17,b=>3,d=>4,f=>1}
efffffff1b010000a277f014
efffffff1b010000a277f014
efffffff1b010000a277f014
ffffffef6e0000004f077a22
efffffff1b010000a277f014
efffffff1b010000a277f014
ffffffef6e0000004f077a22
efffffff1b010000a277f014
ffffffef6e0000004f077a22
-
{e=>128771168,c=>5,a=>-97,b=>6,d=>5,f=>6}
9fffffff6e01000060e4ac67
9fffffff6e01000060e4ac67
9fffffff6e01000060e4ac67
ffffff9fd68000007ace460c
9fffffff6e01000060e4ac67
9fffffff6e01000060e4ac67
ffffff9fd68000007ace460c
9fffffff6e01000060e4ac67
ffffff9fd68000007ace460c
-
{e=>201646189,c=>5,a=>87,b=>0,d=>1,f=>3}
57000000680000006de0043c
57000000680000006de0043c
57000000680000006de0043c
0000005714800000c04e06d6
57000000680000006de0043c
57000000680000006de0043c
0000005714800000c04e06d6
57000000680000006de0043c
0000005714800000c04e06d6
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>52201699,c=>3,a=>-21,g=>2,b=>2,d=>3,f=>7}
ebffffffda000000e3881c7302000000
ebffffffda000000e3881c7302000000
ebffffffda000000e3881c7302000000
ffffffeb4d80000031c88e3e80000000
ebffffffda000000e3881c7302000000
ebffffffda000000e3881c7302000000
ffffffeb4d80000031c88e3e80000000
ebffffffda000000e3881c7302000000
ffffffeb4d80000031c88e3e80000000
-
{e=>156859917,c=>7,a=>28,g=>2,b=>4,d=>1,f=>7}
1c0000007c0000000d7e597902000000
1c0000007c0000000d7e597902000000
1c0000007c0000000d7e597902000000
0000001c9c8000009597e0de80000000
1c0000007c0000000d7e597902000000
1c0000007c0000000d7e597902000000
0000001c9c8000009597e0de80000000
1c0000007c0000000d7e597902000000
0000001c9c8000009597e0de80000000
-
{e=>73487576,c=>2,a=>44,g=>3,b=>5,d=>4,f=>1}
2c00000015010000d854611403000000
2c00000015010000d854611403000000
2c00000015010000d854611403000000
0000002caa00000046154d82c0000000
2c00000015010000d854611403000000
2c00000015010000d854611403000000
0000002caa00000046154d82c0000000
2c00000015010000d854611403000000
0000002caa00000046154d82c0000000
-
{e=>172142530,c=>5,a=>101,g=>2,b=>7,d=>3,f=>5}
65000000ef000000c2af425a02000000
65000000ef000000c2af425a02000000
65000000ef000000c2af425a02000000
00000065f5800000a42afc2a80000000
65000000ef000000c2af425a02000000
65000000ef000000c2af425a02000000
00000065f5800000a42afc2a80000000
65000000ef000000c2af425a02000000
00000065f5800000a42afc2a80000000
-
{e=>150725544,c=>6,a=>71,g=>1,b=>6,d=>0,f=>3}
4700000036000000a8e3fb3801000000
4700000036000000a8e3fb3801000000
4700000036000000a8e3fb3801000000
00000047d80000008fbe3a8640000000
4700000036000000a8e3fb3801000000
4700000036000000a8e3fb3801000000
00000047d80000008fbe3a8640000000
4700000036000000a8e3fb3801000000
00000047d80000008fbe3a8640000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>165197259,a=>-34,d=>6,c=>6,h=>2543,b=>0,g=>1,f=>4}
deffffffb0010000cbb5d849bd270000
deffffffb0010000cbb5d849bd270000
deffffffb0010000cbb5d849bd270000
ffffffde1b0000009d8b5cb853de0000
deffffffb0010000cbb5d849bd270000
deffffffb0010000cbb5d849bd270000
ffffffde1b0000009d8b5cb853de0000
deffffffb0010000cbb5d849bd270000
ffffffde1b0000009d8b5cb853de0000
-
{e=>66930837,a=>-1,d=>4,c=>3,h=>8014,b=>5,g=>2,f=>1}
ffffffff1d0100009548fd133a7d0000
ffffffff1d0100009548fd133a7d0000
ffffffff1d0100009548fd133a7d0000
ffffffffae0000003fd48952be9c0000
ffffffff1d0100009548fd133a7d0000
ffffffff1d0100009548fd133a7d0000
ffffffffae0000003fd48952be9c0000
ffffffff1d0100009548fd133a7d0000
ffffffffae0000003fd48952be9c0000
-
{e=>133257048,a=>80,d=>2,c=>3,h=>7657,b=>4,g=>1,f=>2}
500000009c0000005857f127a5770000
500000009c0000005857f127a5770000
500000009c0000005857f127a5770000
000000508d0000007f1575847bd20000
500000009c0000005857f127a5770000
500000009c0000005857f127a5770000
000000508d0000007f1575847bd20000
500000009c0000005857f127a5770000
000000508d0000007f1575847bd20000
-
{e=>213734502,a=>-90,d=>4,c=>5,h=>5237,b=>1,g=>2,f=>0}
a6ffffff290100006654bd0cd6510000
a6ffffff290100006654bd0cd6510000
a6ffffff290100006654bd0cd6510000
ffffffa636000000cbd54660a8ea0000
a6ffffff290100006654bd0cd6510000
a6ffffff290100006654bd0cd6510000
ffffffa636000000cbd54660a8ea0000
a6ffffff290100006654bd0cd6510000
ffffffa636000000cbd54660a8ea0000
-
{e=>132335321,a=>121,d=>0,c=>3,h=>5451,b=>4,g=>0,f=>7}
790000001c000000d946e3772c550000
790000001c000000d946e3772c550000
790000001c000000d946e3772c550000
000000798c0000007e346d9e2a960000
790000001c000000d946e3772c550000
790000001c000000d946e3772c550000
000000798c0000007e346d9e2a960000
790000001c000000d946e3772c550000
000000798c0000007e346d9e2a960000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>54142455,a=>-77,d=>3,c=>0,h=>5806,b=>5,g=>0,f=>1,i=>177}
b3ffffffc5000000f7253a13b85ab100
b3ffffffc5000000f7253a13b85ab100
b3ffffffc5000000f7253a13b85ab100
ffffffb3a180000033a25f722d5cb100
b3ffffffc5000000f7253a13b85ab100
b3ffffffc5000000f7253a13b85ab100
ffffffb3a180000033a25f722d5cb100
b3ffffffc5000000f7253a13b85ab100
ffffffb3a180000033a25f722d5cb100
-
{e=>146569251,a=>-111,d=>5,c=>1,h=>6377,b=>1,g=>3,f=>2,i=>217}
91ffffff490100002378bc28a763d900
91ffffff490100002378bc28a763d900
91ffffff490100002378bc28a763d900
ffffff91268000008bc78234f1d2d900
91ffffff490100002378bc28a763d900
91ffffff490100002378bc28a763d900
ffffff91268000008bc78234f1d2d900
91ffffff490100002378bc28a763d900
ffffff91268000008bc78234f1d2d900
-
{e=>103323231,a=>-35,d=>5,c=>3,h=>286,b=>0,g=>2,f=>5,i=>160}
ddffffff580100005f9628567a04a000
ddffffff580100005f9628567a04a000
ddffffff580100005f9628567a04a000
ffffffdd0e800000628965fa823ca000
ddffffff580100005f9628567a04a000
ddffffff580100005f9628567a04a000
ffffffdd0e800000628965fa823ca000
ddffffff580100005f9628567a04a000
ffffffdd0e800000628965fa823ca000
-
{e=>80135875,a=>-121,d=>4,c=>6,h=>4052,b=>0,g=>0,f=>6,i=>139}
87ffffff30010000c3c6c664503f8b00
87ffffff30010000c3c6c664503f8b00
87ffffff30010000c3c6c664503f8b00
ffffff871a0000004c6c6c3c1fa88b00
87ffffff30010000c3c6c664503f8b00
87ffffff30010000c3c6c664503f8b00
ffffff871a0000004c6c6c3c1fa88b00
87ffffff30010000c3c6c664503f8b00
ffffff871a0000004c6c6c3c1fa88b00
-
{e=>212259421,a=>46,d=>5,c=>2,h=>3423,b=>7,g=>2,f=>4,i=>165}
2e000000570100005dd2a64c7e35a500
2e000000570100005dd2a64c7e35a500
2e000000570100005dd2a64c7e35a500
0000002eea800000ca6d25d89abea500
2e000000570100005dd2a64c7e35a500
2e000000570100005dd2a64c7e35a500
0000002eea800000ca6d25d89abea500
2e000000570100005dd2a64c7e35a500
0000002eea800000ca6d25d89abea500
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
};
-
{a=>-17,b=>1}
efffffff01000000
efffffffffffffff0100000000000000
efffffffffffffff0100000000000000
ffffffef20000000
efffffff01000000
efffffff01000000
ffffffffffffffef2000000000000000
efffffff01000000
ffffffef20000000
-
{a=>-21,b=>5}
ebffffff05000000
ebffffffffffffff0500000000000000
ebffffffffffffff0500000000000000
ffffffeba0000000
ebffffff05000000
ebffffff05000000
ffffffffffffffeba000000000000000
ebffffff05000000
ffffffeba0000000
-
{a=>117,b=>4}
7500000004000000
75000000000000000400000000000000
75000000000000000400000000000000
0000007580000000
7500000004000000
7500000004000000
00000000000000758000000000000000
7500000004000000
0000007580000000
-
{a=>90,b=>5}
5a00000005000000
5a000000000000000500000000000000
5a000000000000000500000000000000
0000005aa0000000
5a00000005000000
5a00000005000000
000000000000005aa000000000000000
5a00000005000000
0000005aa0000000
-
{a=>48,b=>4}
3000000004000000
30000000000000000400000000000000
30000000000000000400000000000000
0000003080000000
3000000004000000
3000000004000000
00000000000000308000000000000000
3000000004000000
0000003080000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>0,a=>16,b=>5}
1000000005000000
10000000000000000500000000000000
10000000000000000500000000000000
00000010a0000000
1000000005000000
1000000005000000
0000000000000010a000000000000000
1000000005000000
00000010a0000000
-
{c=>6,a=>123,b=>0}
7b00000030000000
7b000000000000003000000000000000
7b000000000000003000000000000000
0000007b18000000
7b00000030000000
7b00000030000000
000000000000007b1800000000000000
7b00000030000000
0000007b18000000
-
{c=>4,a=>92,b=>2}
5c00000022000000
5c000000000000002200000000000000
5c000000000000002200000000000000
0000005c50000000
5c00000022000000
5c00000022000000
000000000000005c5000000000000000
5c00000022000000
0000005c50000000
-
{c=>4,a=>64,b=>0}
4000000020000000
40000000000000002000000000000000
40000000000000002000000000000000
0000004010000000
4000000020000000
4000000020000000
00000000000000401000000000000000
4000000020000000
0000004010000000
-
{c=>0,a=>-8,b=>0}
f8ffffff00000000
f8ffffffffffffff0000000000000000
f8ffffffffffffff0000000000000000
fffffff800000000
f8ffffff00000000
f8ffffff00000000
fffffffffffffff80000000000000000
f8ffffff00000000
fffffff800000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>6,a=>124,b=>2,d=>6}
7c000000b2010000
7c00000000000000b201000000000000
7c00000000000000b201000000000000
0000007c5b000000
7c000000b2010000
7c000000b2010000
000000000000007c5b00000000000000
7c000000b2010000
0000007c5b000000
-
{c=>2,a=>-19,b=>2,d=>0}
edffffff12000000
edffffffffffffff1200000000000000
edffffffffffffff1200000000000000
ffffffed48000000
edffffff12000000
edffffff12000000
ffffffffffffffed4800000000000000
edffffff12000000
ffffffed48000000
-
{c=>5,a=>55,b=>0,d=>1}
3700000068000000
37000000000000006800000000000000
37000000000000006800000000000000
0000003714800000
3700000068000000
3700000068000000
00000000000000371480000000000000
3700000068000000
0000003714800000
-
{c=>5,a=>-44,b=>0,d=>7}
d4ffffffe8010000
d4ffffffffffffffe801000000000000
d4ffffffffffffffe801000000000000
ffffffd417800000
d4ffffffe8010000
d4ffffffe8010000
ffffffffffffffd41780000000000000
d4ffffffe8010000
ffffffd417800000
-
{c=>6,a=>-50,b=>1,d=>4}
ceffffff31010000
ceffffffffffffff3101000000000000
ceffffffffffffff3101000000000000
ffffffce3a000000
ceffffff31010000
ceffffff31010000
ffffffffffffffce3a00000000000000
ceffffff31010000
ffffffce3a000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>95288597,c=>5,a=>-109,b=>2,d=>7}
93ffffffea01000015fdad05
93ffffffffffffffea01000015fdad05
93ffffffffffffffea01000015fdad05
ffffff93578000005adfd150
93ffffffea01000015fdad05
93ffffffea01000015fdad05
ffffffffffffff93578000005adfd150
93ffffffea01000015fdad05
ffffff93578000005adfd150
-
{e=>135290620,c=>4,a=>117,b=>5,d=>5}
7500000065010000fc5e1008
750000000000000065010000fc5e1008
750000000000000065010000fc5e1008
00000075b28000008105efc0
7500000065010000fc5e1008
7500000065010000fc5e1008
0000000000000075b28000008105efc0
7500000065010000fc5e1008
00000075b28000008105efc0
-
{e=>60560071,c=>0,a=>38,b=>6,d=>3}
26000000c6000000c7129c03
2600000000000000c6000000c7129c03
2600000000000000c6000000c7129c03
00000026c180000039c12c70
26000000c6000000c7129c03
26000000c6000000c7129c03
0000000000000026c180000039c12c70
26000000c6000000c7129c03
00000026c180000039c12c70
-
{e=>3218489,c=>7,a=>-111,b=>2,d=>3}
91fffffffa000000391c3100
91fffffffffffffffa000000391c3100
91fffffffffffffffa000000391c3100
ffffff915d8000000311c390
91fffffffa000000391c3100
91fffffffa000000391c3100
ffffffffffffff915d8000000311c390
91fffffffa000000391c3100
ffffff915d8000000311c390
-
{e=>124836907,c=>6,a=>-119,b=>3,d=>2}
89ffffffb30000002bdc7007
89ffffffffffffffb30000002bdc7007
89ffffffffffffffb30000002bdc7007
ffffff8979000000770dc2b0
89ffffffb30000002bdc7007
89ffffffb30000002bdc7007
ffffffffffffff8979000000770dc2b0
89ffffffb30000002bdc7007
ffffff8979000000770dc2b0
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>12389401,c=>4,a=>83,b=>0,d=>1,f=>1}
5300000060000000190cbd10
530000000000000060000000190cbd10
530000000000000060000000190cbd10
00000053108000000bd0c192
5300000060000000190cbd10
5300000060000000190cbd10
0000000000000053108000000bd0c192
5300000060000000190cbd10
00000053108000000bd0c192
-
{e=>142083432,c=>7,a=>-99,b=>5,d=>3,f=>3}
9dfffffffd00000068057838
9dfffffffffffffffd00000068057838
9dfffffffffffffffd00000068057838
ffffff9dbd80000087805686
9dfffffffd00000068057838
9dfffffffd00000068057838
ffffffffffffff9dbd80000087805686
9dfffffffd00000068057838
ffffff9dbd80000087805686
-
{e=>187721880,c=>2,a=>52,b=>6,d=>5,f=>2}
34000000560100009868302b
3400000000000000560100009868302b
3400000000000000560100009868302b
00000034ca800000b3068984
34000000560100009868302b
34000000560100009868302b
0000000000000034ca800000b3068984
34000000560100009868302b
00000034ca800000b3068984
-
{e=>48069462,c=>5,a=>48,b=>0,d=>2,f=>4}
30000000a8000000567bdd42
3000000000000000a8000000567bdd42
3000000000000000a8000000567bdd42
00000030150000002dd7b568
30000000a8000000567bdd42
30000000a8000000567bdd42
0000000000000030150000002dd7b568
30000000a8000000567bdd42
00000030150000002dd7b568
-
{e=>65320048,c=>4,a=>2,b=>6,d=>4,f=>3}
020000002601000070b4e433
02000000000000002601000070b4e433
02000000000000002601000070b4e433
00000002d20000003e4b4706
020000002601000070b4e433
020000002601000070b4e433
0000000000000002d20000003e4b4706
020000002601000070b4e433
00000002d20000003e4b4706
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>260512924,c=>0,a=>13,g=>3,b=>2,d=>7,f=>5}
0d000000c20100009c1c875f03000000
0d00000000000000c20100009c1c875f0300000000000000
0d00000000000000c20100009c1c875f0300000000000000
0000000d43800000f871c9cac0000000
0d000000c20100009c1c875f03000000
0d000000c20100009c1c875f03000000
000000000000000d43800000f871c9cac000000000000000
0d000000c20100009c1c875f03000000
0000000d43800000f871c9cac0000000
-
{e=>57231972,c=>0,a=>50,g=>1,b=>1,d=>1,f=>1}
3200000041000000644a691301000000
320000000000000041000000644a69130100000000000000
320000000000000041000000644a69130100000000000000
00000032208000003694a64240000000
3200000041000000644a691301000000
3200000041000000644a691301000000
0000000000000032208000003694a6424000000000000000
3200000041000000644a691301000000
00000032208000003694a64240000000
-
{e=>202592947,c=>7,a=>-82,g=>2,b=>0,d=>0,f=>6}
aeffffff38000000b352136c02000000
aeffffffffffffff38000000b352136c0200000000000000
aeffffffffffffff38000000b352136c0200000000000000
ffffffae1c000000c1352b3c80000000
aeffffff38000000b352136c02000000
aeffffff38000000b352136c02000000
ffffffffffffffae1c000000c1352b3c8000000000000000
aeffffff38000000b352136c02000000
ffffffae1c000000c1352b3c80000000
-
{e=>222000348,c=>7,a=>-76,g=>2,b=>4,d=>4,f=>5}
b4ffffff3c010000dc743b5d02000000
b4ffffffffffffff3c010000dc743b5d0200000000000000
b4ffffffffffffff3c010000dc743b5d0200000000000000
ffffffb49e000000d3b74dca80000000
b4ffffff3c010000dc743b5d02000000
b4ffffff3c010000dc743b5d02000000
ffffffffffffffb49e000000d3b74dca8000000000000000
b4ffffff3c010000dc743b5d02000000
ffffffb49e000000d3b74dca80000000
-
{e=>259177945,c=>7,a=>-89,g=>3,b=>2,d=>4,f=>1}
a7ffffff3a010000d9bd721f03000000
a7ffffffffffffff3a010000d9bd721f0300000000000000
a7ffffffffffffff3a010000d9bd721f0300000000000000
ffffffa75e000000f72bdd92c0000000
a7ffffff3a010000d9bd721f03000000
a7ffffff3a010000d9bd721f03000000
ffffffffffffffa75e000000f72bdd92c000000000000000
a7ffffff3a010000d9bd721f03000000
ffffffa75e000000f72bdd92c0000000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>83948314,a=>-39,d=>7,c=>7,h=>5026,b=>2,g=>2,f=>5}
d9fffffffa0100001af300558a4e0000
d9fffffffffffffffa0100001af300558a4e000000000000
d9fffffffffffffffa0100001af300558a4e000000000000
ffffffd95f800000500f31aaa7440000
d9fffffffa0100001af300558a4e0000
d9fffffffa0100001af300558a4e0000
ffffffffffffffd95f800000500f31aaa744000000000000
d9fffffffa0100001af300558a4e0000
ffffffd95f800000500f31aaa7440000
-
{e=>263712322,a=>73,d=>0,c=>3,h=>5678,b=>2,g=>3,f=>7}
490000001a00000042eeb77fbb580000
49000000000000001a00000042eeb77fbb58000000000000
49000000000000001a00000042eeb77fbb58000000000000
000000494c000000fb7ee42eec5c0000
490000001a00000042eeb77fbb580000
490000001a00000042eeb77fbb580000
00000000000000494c000000fb7ee42eec5c000000000000
490000001a00000042eeb77fbb580000
000000494c000000fb7ee42eec5c0000
-
{e=>29595889,a=>-74,d=>7,c=>3,h=>3087,b=>2,g=>3,f=>4}
b6ffffffda010000f198c3413f300000
b6ffffffffffffffda010000f198c3413f30000000000000
b6ffffffffffffffda010000f198c3413f30000000000000
ffffffb64f8000001c398f18d81e0000
b6ffffffda010000f198c3413f300000
b6ffffffda010000f198c3413f300000
ffffffffffffffb64f8000001c398f18d81e000000000000
b6ffffffda010000f198c3413f300000
ffffffb64f8000001c398f18d81e0000
-
{e=>229616258,a=>-13,d=>2,c=>2,h=>5537,b=>5,g=>2,f=>6}
f3ffffff9500000082aaaf6d86560000
f3ffffffffffffff9500000082aaaf6d8656000000000000
f3ffffffffffffff9500000082aaaf6d8656000000000000
fffffff3a9000000dafaa82cab420000
f3ffffff9500000082aaaf6d86560000
f3ffffff9500000082aaaf6d86560000
fffffffffffffff3a9000000dafaa82cab42000000000000
f3ffffff9500000082aaaf6d86560000
fffffff3a9000000dafaa82cab420000
-
{e=>192578723,a=>-50,d=>5,c=>7,h=>779,b=>7,g=>0,f=>1}
ceffffff7f010000a3847a1b2c0c0000
ceffffffffffffff7f010000a3847a1b2c0c000000000000
ceffffffffffffff7f010000a3847a1b2c0c000000000000
ffffffcefe800000b7a84a3206160000
ceffffff7f010000a3847a1b2c0c0000
ceffffff7f010000a3847a1b2c0c0000
ffffffffffffffcefe800000b7a84a320616000000000000
ceffffff7f010000a3847a1b2c0c0000
ffffffcefe800000b7a84a3206160000
=
#if defined PACK_PAREN
#pragma pack( 2 )
#elif defined PACK_NO_PAREN
#pragma pack 2
#endif
struct umixed_pack_2 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>53556282,a=>93,d=>1,c=>0,h=>6233,b=>5,g=>2,f=>6,i=>8}
5d000000450000003a34316366610800
5d00000000000000450000003a3431636661080000000000
5d00000000000000450000003a3431636661080000000000
0000005da0800000331343acb0b20800
5d000000450000003a34316366610800
5d000000450000003a34316366610800
000000000000005da0800000331343acb0b2080000000000
5d000000450000003a34316366610800
0000005da0800000331343acb0b20800
-
{e=>177717941,a=>-92,d=>4,c=>4,h=>2021,b=>5,g=>1,f=>5,i=>247}
a4ffffff25010000b5c2975a951ff700
a4ffffffffffffff25010000b5c2975a951ff70000000000
a4ffffffffffffff25010000b5c2975a951ff70000000000
ffffffa4b2000000a97c2b5a4fcaf700
a4ffffff25010000b5c2975a951ff700
a4ffffff25010000b5c2975a951ff700
ffffffffffffffa4b2000000a97c2b5a4fcaf70000000000
a4ffffff25010000b5c2975a951ff700
ffffffa4b2000000a97c2b5a4fcaf700
-
{e=>182845399,a=>88,d=>7,c=>0,h=>1885,b=>2,g=>0,f=>7,i=>153}
58000000c2010000d7ffe57a741d9900
5800000000000000c2010000d7ffe57a741d990000000000
5800000000000000c2010000d7ffe57a741d990000000000
0000005843800000ae5ffd7e0eba9900
58000000c2010000d7ffe57a741d9900
58000000c2010000d7ffe57a741d9900
000000000000005843800000ae5ffd7e0eba990000000000
58000000c2010000d7ffe57a741d9900
0000005843800000ae5ffd7e0eba9900
-
{e=>88054627,a=>92,d=>5,c=>7,h=>765,b=>5,g=>0,f=>1,i=>252}
5c0000007d010000639b3f15f40bfc00
5c000000000000007d010000639b3f15f40bfc0000000000
5c000000000000007d010000639b3f15f40bfc0000000000
0000005cbe80000053f9b63205fafc00
5c0000007d010000639b3f15f40bfc00
5c0000007d010000639b3f15f40bfc00
000000000000005cbe80000053f9b63205fafc0000000000
5c0000007d010000639b3f15f40bfc00
0000005cbe80000053f9b63205fafc00
-
{e=>77656705,a=>-32,d=>0,c=>0,h=>6746,b=>6,g=>3,f=>4,i=>4}
e0ffffff0600000081f2a0446b690400
e0ffffffffffffff0600000081f2a0446b69040000000000
e0ffffffffffffff0600000081f2a0446b69040000000000
ffffffe0c00000004a0f2818f4b40400
e0ffffff0600000081f2a0446b690400
e0ffffff0600000081f2a0446b690400
ffffffffffffffe0c00000004a0f2818f4b4040000000000
e0ffffff0600000081f2a0446b690400
ffffffe0c00000004a0f2818f4b40400
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
};
-
{a=>0}
00
00
00
00
00000000
00
00
00
00
-
{a=>2}
02
02
02
40
02000000
02
40
02
40
-
{a=>3}
03
03
03
60
03000000
03
60
03
60
-
{a=>4}
04
04
04
80
04000000
04
80
04
80
-
{a=>1}
01
01
01
20
01000000
01
20
01
20
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
};
-
{a=>1,b=>7}
39
39
39
3c
39000000
39
3c
39
3c
-
{a=>5,b=>4}
25
25
25
b0
25000000
25
b0
25
b0
-
{a=>2,b=>6}
32
32
32
58
32000000
32
58
32
58
-
{a=>6,b=>0}
06
06
06
c0
06000000
06
c0
06
c0
-
{a=>6,b=>3}
1e
1e
1e
cc
1e000000
1e
cc
1e
cc
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
};
-
{c=>7,a=>2,b=>3}
da01
da01
da01
4f80
da010000
da01
4f80
da01
4f80
-
{c=>7,a=>5,b=>5}
ed01
ed01
ed01
b780
ed010000
ed01
b780
ed01
b780
-
{c=>6,a=>2,b=>1}
8a01
8a01
8a01
4700
8a010000
8a01
4700
8a01
4700
-
{c=>2,a=>0,b=>4}
a000
a000
a000
1100
a0000000
a000
1100
a000
1100
-
{c=>2,a=>0,b=>0}
8000
8000
8000
0100
80000000
8000
0100
8000
0100
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
};
-
{c=>3,a=>7,b=>1,d=>50028689}
cf0000009160fb02
cf0000009160fb02
cf0000009160fb02
e58000002fb60910
cf0000009160fb02
cf0000009160fb02
e58000002fb60910
cf0000009160fb02
e58000002fb60910
-
{c=>0,a=>6,b=>4,d=>214060677}
26000000854ec20c
26000000854ec20c
26000000854ec20c
d0000000cc24e850
26000000854ec20c
26000000854ec20c
d0000000cc24e850
26000000854ec20c
d0000000cc24e850
-
{c=>5,a=>3,b=>2,d=>195763511}
53010000371dab0b
53010000371dab0b
53010000371dab0b
6a800000bab1d370
53010000371dab0b
53010000371dab0b
6a800000bab1d370
53010000371dab0b
6a800000bab1d370
-
{c=>3,a=>3,b=>6,d=>63439012}
f3000000a400c803
f3000000a400c803
f3000000a400c803
798000003c800a40
f3000000a400c803
f3000000a400c803
798000003c800a40
f3000000a400c803
798000003c800a40
-
{c=>0,a=>5,b=>5,d=>244764352}
2d000000c0ce960e
2d000000c0ce960e
2d000000c0ce960e
b4000000e96cec00
2d000000c0ce960e
2d000000c0ce960e
b4000000e96cec00
2d000000c0ce960e
b4000000e96cec00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
};
-
{e=>3,c=>2,a=>4,b=>7,d=>224624247}
bc000000777e633d
bc000000777e633d
bc000000777e633d
9d000000d637e776
bc000000777e633d
bc000000777e633d
9d000000d637e776
bc000000777e633d
9d000000d637e776
-
{e=>0,c=>1,a=>5,b=>1,d=>177052414}
4d000000fe9a8d0a
4d000000fe9a8d0a
4d000000fe9a8d0a
a4800000a8d9afe0
4d000000fe9a8d0a
4d000000fe9a8d0a
a4800000a8d9afe0
4d000000fe9a8d0a
a4800000a8d9afe0
-
{e=>0,c=>0,a=>2,b=>5,d=>246117108}
2a000000f472ab0e
2a000000f472ab0e
2a000000f472ab0e
54000000eab72f40
2a000000f472ab0e
2a000000f472ab0e
54000000eab72f40
2a000000f472ab0e
54000000eab72f40
-
{e=>6,c=>6,a=>5,b=>7,d=>185373738}
bd0100002a940c6b
bd0100002a940c6b
bd0100002a940c6b
bf000000b0c942ac
bd0100002a940c6b
bd0100002a940c6b
bf000000b0c942ac
bd0100002a940c6b
bf000000b0c942ac
-
{e=>5,c=>3,a=>4,b=>5,d=>54818930}
ec00000072784453
ec00000072784453
ec00000072784453
958000003447872a
ec00000072784453
ec00000072784453
958000003447872a
ec00000072784453
958000003447872a
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
};
-
{e=>3,c=>4,a=>4,b=>0,d=>79628885,f=>3}
04010000550abf3403000000
04010000550abf3403000000
04010000550abf3403000000
820000004bf0a556c0000000
04010000550abf3403000000
04010000550abf3403000000
820000004bf0a556c0000000
04010000550abf3403000000
820000004bf0a556c0000000
-
{e=>2,c=>4,a=>1,b=>5,d=>144152264,f=>2}
29010000c896972802000000
29010000c896972802000000
29010000c896972802000000
3600000089796c8480000000
29010000c896972802000000
29010000c896972802000000
3600000089796c8480000000
29010000c896972802000000
3600000089796c8480000000
-
{e=>5,c=>6,a=>2,b=>0,d=>26710878,f=>3}
820100005e93975103000000
820100005e93975103000000
820100005e93975103000000
43000000197935eac0000000
820100005e93975103000000
820100005e93975103000000
43000000197935eac0000000
820100005e93975103000000
43000000197935eac0000000
-
{e=>5,c=>6,a=>7,b=>4,d=>34004101,f=>1}
a701000085dc065201000000
a701000085dc065201000000
a701000085dc065201000000
f3000000206dc85a40000000
a701000085dc065201000000
a701000085dc065201000000
f3000000206dc85a40000000
a701000085dc065201000000
f3000000206dc85a40000000
-
{e=>0,c=>4,a=>2,b=>1,d=>16933732,f=>1}
0a0100006463020101000000
0a0100006463020101000000
0a0100006463020101000000
460000001026364040000000
0a0100006463020101000000
0a0100006463020101000000
460000001026364040000000
0a0100006463020101000000
460000001026364040000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
};
-
{e=>6,c=>4,a=>7,g=>5071,b=>0,d=>231122139,f=>3}
07010000dba4c66d3f4f0000
07010000dba4c66d3f4f0000
07010000dba4c66d3f4f0000
e2000000dc6a4dbce79e0000
07010000dba4c66d3f4f0000
07010000dba4c66d3f4f0000
e2000000dc6a4dbce79e0000
07010000dba4c66d3f4f0000
e2000000dc6a4dbce79e0000
-
{e=>6,c=>2,a=>7,g=>456,b=>3,d=>180080748,f=>0}
9f0000006cd0bb6a20070000
9f0000006cd0bb6a20070000
9f0000006cd0bb6a20070000
ed000000abbd06cc03900000
9f0000006cd0bb6a20070000
9f0000006cd0bb6a20070000
ed000000abbd06cc03900000
9f0000006cd0bb6a20070000
ed000000abbd06cc03900000
-
{e=>2,c=>3,a=>3,g=>5849,b=>3,d=>79209729,f=>3}
db00000001a5b824675b0000
db00000001a5b824675b0000
db00000001a5b824675b0000
6d8000004b8a5014edb20000
db00000001a5b824675b0000
db00000001a5b824675b0000
6d8000004b8a5014edb20000
db00000001a5b824675b0000
6d8000004b8a5014edb20000
-
{e=>1,c=>3,a=>7,g=>2821,b=>0,d=>127280147,f=>3}
c700000013249617172c0000
c700000013249617172c0000
c700000013249617172c0000
e180000079624132d60a0000
c700000013249617172c0000
c700000013249617172c0000
e180000079624132d60a0000
c700000013249617172c0000
e180000079624132d60a0000
-
{e=>3,c=>1,a=>1,g=>507,b=>0,d=>255482069,f=>1}
41000000d5583a3fed070000
41000000d5583a3fed070000
41000000d5583a3fed070000
20800000f3a58d5643f60000
41000000d5583a3fed070000
41000000d5583a3fed070000
20800000f3a58d5643f60000
41000000d5583a3fed070000
20800000f3a58d5643f60000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  unsigned char  a:3;
  unsigned char  b:3;
  unsigned short c:3;
  unsigned int   d:28;
  unsigned char  e:3;
  unsigned char  f:2;
  unsigned short g:13;
  unsigned char  h;
};
-
{e=>6,a=>7,d=>257420570,c=>7,h=>84,b=>1,g=>1915,f=>3}
cf0100001aed576fef1d5400
cf0100001aed576fef1d5400
cf0100001aed576fef1d5400
e7800000f57ed1accef65400
cf0100001aed576fef1d5400
cf0100001aed576fef1d5400
e7800000f57ed1accef65400
cf0100001aed576fef1d5400
e7800000f57ed1accef65400
-
{e=>5,a=>5,d=>71066412,c=>2,h=>226,b=>3,g=>1456,f=>3}
9d0000002c633c54c316e200
9d0000002c633c54c316e200
9d0000002c633c54c316e200
ad00000043c632cacb60e200
9d0000002c633c54c316e200
9d0000002c633c54c316e200
ad00000043c632cacb60e200
9d0000002c633c54c316e200
ad00000043c632cacb60e200
-
{e=>5,a=>0,d=>136880796,c=>4,h=>149,b=>6,g=>7356,f=>2}
300100009ca22858f2729500
300100009ca22858f2729500
300100009ca22858f2729500
1a000000828a29cab9789500
300100009ca22858f2729500
300100009ca22858f2729500
1a000000828a29cab9789500
300100009ca22858f2729500
1a000000828a29cab9789500
-
{e=>4,a=>2,d=>230323768,c=>1,h=>107,b=>2,g=>1870,f=>0}
520000003876ba4d381d6b00
520000003876ba4d381d6b00
520000003876ba4d381d6b00
48800000dba763880e9c6b00
520000003876ba4d381d6b00
520000003876ba4d381d6b00
48800000dba763880e9c6b00
520000003876ba4d381d6b00
48800000dba763880e9c6b00
-
{e=>0,a=>1,d=>100150911,c=>2,h=>68,b=>6,g=>5875,f=>1}
b10000007f2ef805cd5b4400
b10000007f2ef805cd5b4400
b10000007f2ef805cd5b4400
390000005f82e7f06de64400
b10000007f2ef805cd5b4400
b10000007f2ef805cd5b4400
390000005f82e7f06de64400
b10000007f2ef805cd5b4400
390000005f82e7f06de64400
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
};
-
{a=>65,b=>3}
4103
4103
4103
4160
41030000
4103
4160
4103
4160
-
{a=>6,b=>0}
0600
0600
0600
0600
06000000
0600
0600
0600
0600
-
{a=>95,b=>6}
5f06
5f06
5f06
5fc0
5f060000
5f06
5fc0
5f06
5fc0
-
{a=>-19,b=>1}
ed01
ed01
ed01
ed20
ed010000
ed01
ed20
ed01
ed20
-
{a=>69,b=>7}
4507
4507
4507
45e0
45070000
4507
45e0
4507
45e0
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>6,a=>-76,b=>3}
b433
b433
b433
b478
b4330000
b433
b478
b433
b478
-
{c=>6,a=>58,b=>2}
3a32
3a32
3a32
3a58
3a320000
3a32
3a58
3a32
3a58
-
{c=>0,a=>-87,b=>7}
a907
a907
a907
a9e0
a9070000
a907
a9e0
a907
a9e0
-
{c=>5,a=>95,b=>6}
5f2e
5f2e
5f2e
5fd4
5f2e0000
5f2e
5fd4
5f2e
5fd4
-
{c=>6,a=>69,b=>2}
4532
4532
4532
4558
45320000
4532
4558
4532
4558
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>3,a=>-39,b=>1,d=>1}
d9190100
d9190100
d9190100
d92c2000
d9190100
d9190100
d92c2000
d9190100
d92c2000
-
{c=>0,a=>-41,b=>0,d=>0}
d7000000
d7000000
d7000000
d7000000
d7000000
d7000000
d7000000
d7000000
d7000000
-
{c=>4,a=>98,b=>0,d=>0}
62200000
62200000
62200000
62100000
62200000
62200000
62100000
62200000
62100000
-
{c=>0,a=>-29,b=>1,d=>5}
e3010500
e3010500
e3010500
e320a000
e3010500
e3010500
e320a000
e3010500
e320a000
-
{c=>3,a=>-22,b=>1,d=>5}
ea190500
ea190500
ea190500
ea2ca000
ea190500
ea190500
ea2ca000
ea190500
ea2ca000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>124299546,c=>2,a=>-99,b=>6,d=>6}
9d1606001aa96807
9d1606001aa96807
9d1606001aa96807
9dc8c000768a91a0
9d1606001aa96807
9d1606001aa96807
9dc8c000768a91a0
9d1606001aa96807
9dc8c000768a91a0
-
{e=>146480008,c=>7,a=>77,b=>1,d=>1}
4d390100881bbb08
4d390100881bbb08
4d390100881bbb08
4d3c20008bb1b880
4d390100881bbb08
4d390100881bbb08
4d3c20008bb1b880
4d390100881bbb08
4d3c20008bb1b880
-
{e=>114844914,c=>3,a=>-69,b=>7,d=>6}
bb1f0600f264d806
bb1f0600f264d806
bb1f0600f264d806
bbecc0006d864f20
bb1f0600f264d806
bb1f0600f264d806
bbecc0006d864f20
bb1f0600f264d806
bbecc0006d864f20
-
{e=>66012636,c=>0,a=>-38,b=>2,d=>6}
da020600dc45ef03
da020600dc45ef03
da020600dc45ef03
da40c0003ef45dc0
da020600dc45ef03
da020600dc45ef03
da40c0003ef45dc0
da020600dc45ef03
da40c0003ef45dc0
-
{e=>262518736,c=>0,a=>20,b=>2,d=>0}
14020000d0b7a50f
14020000d0b7a50f
14020000d0b7a50f
14400000fa5b7d00
14020000d0b7a50f
14020000d0b7a50f
14400000fa5b7d00
14020000d0b7a50f
14400000fa5b7d00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>262442666,c=>5,a=>-46,b=>1,d=>0,f=>1}
d2290000aa8ea41f
d2290000aa8ea41f
d2290000aa8ea41f
d2340000fa48eaa2
d2290000aa8ea41f
d2290000aa8ea41f
d2340000fa48eaa2
d2290000aa8ea41f
d2340000fa48eaa2
-
{e=>51404586,c=>7,a=>-117,b=>0,d=>7,f=>2}
8b3807002a5f1023
8b3807002a5f1023
8b3807002a5f1023
8b1ce0003105f2a4
8b3807002a5f1023
8b3807002a5f1023
8b1ce0003105f2a4
8b3807002a5f1023
8b1ce0003105f2a4
-
{e=>62750320,c=>6,a=>103,b=>6,d=>5,f=>7}
67360500707ebd73
67360500707ebd73
67360500707ebd73
67d8a0003bd7e70e
67360500707ebd73
67360500707ebd73
67d8a0003bd7e70e
67360500707ebd73
67d8a0003bd7e70e
-
{e=>224998807,c=>7,a=>-64,b=>3,d=>6,f=>1}
c03b06009735691d
c03b06009735691d
c03b06009735691d
c07cc000d6935972
c03b06009735691d
c03b06009735691d
c07cc000d6935972
c03b06009735691d
c07cc000d6935972
-
{e=>147103397,c=>2,a=>51,b=>5,d=>5,f=>6}
33150500a59ec468
33150500a59ec468
33150500a59ec468
33a8a0008c49ea5c
33150500a59ec468
33150500a59ec468
33a8a0008c49ea5c
33150500a59ec468
33a8a0008c49ea5c
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>126791030,c=>2,a=>62,g=>0,b=>5,d=>3,f=>3}
3e15030076ad8e3700000000
3e15030076ad8e3700000000
3e15030076ad8e3700000000
3ea8600078ead76600000000
3e15030076ad8e3700000000
3e15030076ad8e3700000000
3ea8600078ead76600000000
3e15030076ad8e3700000000
3ea8600078ead76600000000
-
{e=>121945673,c=>5,a=>14,g=>2,b=>7,d=>0,f=>6}
0e2f000049be446702000000
0e2f000049be446702000000
0e2f000049be446702000000
0ef40000744be49c80000000
0e2f000049be446702000000
0e2f000049be446702000000
0ef40000744be49c80000000
0e2f000049be446702000000
0ef40000744be49c80000000
-
{e=>144073686,c=>3,a=>96,g=>1,b=>3,d=>3,f=>6}
601b0300d663966801000000
601b0300d663966801000000
601b0300d663966801000000
606c600089663d6c40000000
601b0300d663966801000000
601b0300d663966801000000
606c600089663d6c40000000
601b0300d663966801000000
606c600089663d6c40000000
-
{e=>215969518,c=>7,a=>-47,g=>2,b=>4,d=>4,f=>2}
d13c0400ee6edf2c02000000
d13c0400ee6edf2c02000000
d13c0400ee6edf2c02000000
d19c8000cdf6eee480000000
d13c0400ee6edf2c02000000
d13c0400ee6edf2c02000000
d19c8000cdf6eee480000000
d13c0400ee6edf2c02000000
d19c8000cdf6eee480000000
-
{e=>140309850,c=>5,a=>-50,g=>1,b=>5,d=>2,f=>0}
ce2d02005af55c0801000000
ce2d02005af55c0801000000
ce2d02005af55c0801000000
ceb4400085cf55a040000000
ce2d02005af55c0801000000
ce2d02005af55c0801000000
ceb4400085cf55a040000000
ce2d02005af55c0801000000
ceb4400085cf55a040000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>255150489,a=>50,d=>2,c=>3,h=>5131,b=>7,g=>0,f=>5}
321f02009949355f2c500000
321f02009949355f2c500000
321f02009949355f2c500000
32ec4000f354999a28160000
321f02009949355f2c500000
321f02009949355f2c500000
32ec4000f354999a28160000
321f02009949355f2c500000
32ec4000f354999a28160000
-
{e=>88288107,a=>30,d=>5,c=>2,h=>508,b=>1,g=>1,f=>4}
1e1105006b2b4345f1070000
1e1105006b2b4345f1070000
1e1105006b2b4345f1070000
1e28a0005432b6b843f80000
1e1105006b2b4345f1070000
1e1105006b2b4345f1070000
1e28a0005432b6b843f80000
1e1105006b2b4345f1070000
1e28a0005432b6b843f80000
-
{e=>69089767,a=>-51,d=>7,c=>1,h=>2817,b=>4,g=>0,f=>1}
cd0c0700e7391e14042c0000
cd0c0700e7391e14042c0000
cd0c0700e7391e14042c0000
cd84e00041e39e7216020000
cd0c0700e7391e14042c0000
cd0c0700e7391e14042c0000
cd84e00041e39e7216020000
cd0c0700e7391e14042c0000
cd84e00041e39e7216020000
-
{e=>181343856,a=>45,d=>0,c=>7,h=>8181,b=>5,g=>0,f=>3}
2d3d00007016cf3ad47f0000
2d3d00007016cf3ad47f0000
2d3d00007016cf3ad47f0000
2dbc0000acf167063fea0000
2d3d00007016cf3ad47f0000
2d3d00007016cf3ad47f0000
2dbc0000acf167063fea0000
2d3d00007016cf3ad47f0000
2dbc0000acf167063fea0000
-
{e=>255383303,a=>-26,d=>0,c=>4,h=>6731,b=>2,g=>0,f=>2}
e622000007d7382f2c690000
e622000007d7382f2c690000
e622000007d7382f2c690000
e6500000f38d707434960000
e622000007d7382f2c690000
e622000007d7382f2c690000
e6500000f38d707434960000
e622000007d7382f2c690000
e6500000f38d707434960000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  char a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>166068539,a=>7,d=>5,c=>2,h=>5695,b=>7,g=>1,f=>6,i=>154}
071705003b01e669fd589a00
071705003b01e669fd589a00
071705003b01e669fd589a00
07e8a0009e6013bc6c7e9a00
071705003b01e669fd589a00
071705003b01e669fd589a00
07e8a0009e6013bc6c7e9a00
071705003b01e669fd589a00
07e8a0009e6013bc6c7e9a00
-
{e=>33996722,a=>19,d=>3,c=>1,h=>5872,b=>0,g=>3,f=>4,i=>109}
13080300b2bf0642c35b6d00
13080300b2bf0642c35b6d00
13080300b2bf0642c35b6d00
13046000206bfb28ede06d00
13080300b2bf0642c35b6d00
13080300b2bf0642c35b6d00
13046000206bfb28ede06d00
13080300b2bf0642c35b6d00
13046000206bfb28ede06d00
-
{e=>233609477,a=>33,d=>2,c=>7,h=>5345,b=>1,g=>1,f=>4,i=>42}
213902000599ec4d85532a00
213902000599ec4d85532a00
213902000599ec4d85532a00
213c4000dec9905869c22a00
213902000599ec4d85532a00
213902000599ec4d85532a00
213c4000dec9905869c22a00
213902000599ec4d85532a00
213c4000dec9905869c22a00
-
{e=>221295631,a=>68,d=>4,c=>7,h=>2330,b=>4,g=>0,f=>7,i=>18}
443c04000fb4307d68241200
443c04000fb4307d68241200
443c04000fb4307d68241200
449c8000d30b40fe12341200
443c04000fb4307d68241200
443c04000fb4307d68241200
449c8000d30b40fe12341200
443c04000fb4307d68241200
449c8000d30b40fe12341200
-
{e=>91575618,a=>-124,d=>7,c=>1,h=>4394,b=>5,g=>0,f=>3,i=>236}
840d070042557535a844ec00
840d070042557535a844ec00
840d070042557535a844ec00
84a4e000575554262254ec00
840d070042557535a844ec00
840d070042557535a844ec00
84a4e000575554262254ec00
840d070042557535a844ec00
84a4e000575554262254ec00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
};
-
{a=>116,b=>5}
74000500
74000500
74000500
0074a000
74000500
74000500
0074a000
74000500
0074a000
-
{a=>71,b=>2}
47000200
47000200
47000200
00474000
47000200
47000200
00474000
47000200
00474000
-
{a=>-124,b=>5}
84ff0500
84ff0500
84ff0500
ff84a000
84ff0500
84ff0500
ff84a000
84ff0500
ff84a000
-
{a=>80,b=>5}
50000500
50000500
50000500
0050a000
50000500
50000500
0050a000
50000500
0050a000
-
{a=>-89,b=>4}
a7ff0400
a7ff0400
a7ff0400
ffa78000
a7ff0400
a7ff0400
ffa78000
a7ff0400
ffa78000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>3,a=>-17,b=>0}
efff1800
efff1800
efff1800
ffef0c00
efff1800
efff1800
ffef0c00
efff1800
ffef0c00
-
{c=>1,a=>-2,b=>7}
feff0f00
feff0f00
feff0f00
fffee400
feff0f00
feff0f00
fffee400
feff0f00
fffee400
-
{c=>1,a=>-91,b=>5}
a5ff0d00
a5ff0d00
a5ff0d00
ffa5a400
a5ff0d00
a5ff0d00
ffa5a400
a5ff0d00
ffa5a400
-
{c=>0,a=>68,b=>4}
44000400
44000400
44000400
00448000
44000400
44000400
00448000
44000400
00448000
-
{c=>7,a=>-51,b=>2}
cdff3a00
cdff3a00
cdff3a00
ffcd5c00
cdff3a00
cdff3a00
ffcd5c00
cdff3a00
ffcd5c00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>5,a=>-102,b=>5,d=>2}
9affad00
9affad00
9affad00
ff9ab500
9affad00
9affad00
ff9ab500
9affad00
ff9ab500
-
{c=>4,a=>79,b=>5,d=>3}
4f00e500
4f00e500
4f00e500
004fb180
4f00e500
4f00e500
004fb180
4f00e500
004fb180
-
{c=>7,a=>67,b=>7,d=>4}
43003f01
43003f01
43003f01
0043fe00
43003f01
43003f01
0043fe00
43003f01
0043fe00
-
{c=>1,a=>57,b=>7,d=>4}
39000f01
39000f01
39000f01
0039e600
39000f01
39000f01
0039e600
39000f01
0039e600
-
{c=>7,a=>56,b=>4,d=>2}
3800bc00
3800bc00
3800bc00
00389d00
3800bc00
3800bc00
00389d00
3800bc00
00389d00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>13432198,c=>4,a=>37,b=>0,d=>6}
2500a00186f5cc00
2500a00186f5cc00
2500a00186f5cc00
002513000ccf5860
2500a00186f5cc00
2500a00186f5cc00
002513000ccf5860
2500a00186f5cc00
002513000ccf5860
-
{e=>56807926,c=>1,a=>40,b=>5,d=>2}
28008d00f6d16203
28008d00f6d16203
28008d00f6d16203
0028a500362d1f60
28008d00f6d16203
28008d00f6d16203
0028a500362d1f60
28008d00f6d16203
0028a500362d1f60
-
{e=>135705606,c=>5,a=>-117,b=>1,d=>2}
8bffa90006b41608
8bffa90006b41608
8bffa90006b41608
ff8b3500816b4060
8bffa90006b41608
8bffa90006b41608
ff8b3500816b4060
8bffa90006b41608
ff8b3500816b4060
-
{e=>57461598,c=>5,a=>-92,b=>1,d=>0}
a4ff29005ecb6c03
a4ff29005ecb6c03
a4ff29005ecb6c03
ffa4340036ccb5e0
a4ff29005ecb6c03
a4ff29005ecb6c03
ffa4340036ccb5e0
a4ff29005ecb6c03
ffa4340036ccb5e0
-
{e=>47673734,c=>0,a=>-17,b=>2,d=>4}
efff02018671d702
efff02018671d702
efff02018671d702
ffef42002d771860
efff02018671d702
efff02018671d702
ffef42002d771860
efff02018671d702
ffef42002d771860
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>161341178,c=>6,a=>41,b=>3,d=>6,f=>4}
2900b301fade9d49
2900b301fade9d49
2900b301fade9d49
00297b0099ddefa8
2900b301fade9d49
2900b301fade9d49
00297b0099ddefa8
2900b301fade9d49
00297b0099ddefa8
-
{e=>17636513,c=>4,a=>97,b=>1,d=>0,f=>7}
61002100a11c0d71
61002100a11c0d71
61002100a11c0d71
0061300010d1ca1e
61002100a11c0d71
61002100a11c0d71
0061300010d1ca1e
61002100a11c0d71
0061300010d1ca1e
-
{e=>71589661,c=>4,a=>83,b=>1,d=>4,f=>3}
530021011d5f4434
530021011d5f4434
530021011d5f4434
005332004445f1d6
530021011d5f4434
530021011d5f4434
005332004445f1d6
530021011d5f4434
005332004445f1d6
-
{e=>130474327,c=>1,a=>95,b=>0,d=>6,f=>2}
5f00880157e1c627
5f00880157e1c627
5f00880157e1c627
005f07007c6e1574
5f00880157e1c627
5f00880157e1c627
005f07007c6e1574
5f00880157e1c627
005f07007c6e1574
-
{e=>97397382,c=>1,a=>47,b=>1,d=>2,f=>2}
2f008900862ace25
2f008900862ace25
2f008900862ace25
002f25005ce2a864
2f008900862ace25
2f008900862ace25
002f25005ce2a864
2f008900862ace25
002f25005ce2a864
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>212274530,c=>6,a=>61,g=>1,b=>5,d=>1,f=>6}
3d007500620da76c01000000
3d007500620da76c01000000
3d007500620da76c01000000
003db880ca70d62c40000000
3d007500620da76c01000000
3d007500620da76c01000000
003db880ca70d62c40000000
3d007500620da76c01000000
003db880ca70d62c40000000
-
{e=>84374245,c=>6,a=>105,g=>1,b=>3,d=>2,f=>4}
6900b300e572074501000000
6900b300e572074501000000
6900b300e572074501000000
0069790050772e5840000000
6900b300e572074501000000
6900b300e572074501000000
0069790050772e5840000000
6900b300e572074501000000
0069790050772e5840000000
-
{e=>59588346,c=>5,a=>-128,g=>1,b=>7,d=>7,f=>2}
80ffef01fa3e8d2301000000
80ffef01fa3e8d2301000000
80ffef01fa3e8d2301000000
ff80f78038d3efa440000000
80ffef01fa3e8d2301000000
80ffef01fa3e8d2301000000
ff80f78038d3efa440000000
80ffef01fa3e8d2301000000
ff80f78038d3efa440000000
-
{e=>183955461,c=>3,a=>33,g=>3,b=>6,d=>7,f=>3}
2100de0105f0f63a03000000
2100de0105f0f63a03000000
2100de0105f0f63a03000000
0021cf80af6f0056c0000000
2100de0105f0f63a03000000
2100de0105f0f63a03000000
0021cf80af6f0056c0000000
2100de0105f0f63a03000000
0021cf80af6f0056c0000000
-
{e=>192083138,c=>3,a=>-69,g=>3,b=>4,d=>0,f=>2}
bbff1c00c2f4722b03000000
bbff1c00c2f4722b03000000
bbff1c00c2f4722b03000000
ffbb8c00b72f4c24c0000000
bbff1c00c2f4722b03000000
bbff1c00c2f4722b03000000
ffbb8c00b72f4c24c0000000
bbff1c00c2f4722b03000000
ffbb8c00b72f4c24c0000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>113601201,a=>91,d=>3,c=>3,h=>3432,b=>1,g=>0,f=>2}
5b00d900b16ac526a0350000
5b00d900b16ac526a0350000
5b00d900b16ac526a0350000
005b2d806c56ab141ad00000
5b00d900b16ac526a0350000
5b00d900b16ac526a0350000
005b2d806c56ab141ad00000
5b00d900b16ac526a0350000
005b2d806c56ab141ad00000
-
{e=>203592947,a=>15,d=>7,c=>1,h=>5527,b=>6,g=>0,f=>7}
0f00ce01f394227c5c560000
0f00ce01f394227c5c560000
0f00ce01f394227c5c560000
000fc780c2294f3e2b2e0000
0f00ce01f394227c5c560000
0f00ce01f394227c5c560000
000fc780c2294f3e2b2e0000
0f00ce01f394227c5c560000
000fc780c2294f3e2b2e0000
-
{e=>20997174,a=>-60,d=>7,c=>4,h=>6515,b=>6,g=>0,f=>0}
c4ffe60136644001cc650000
c4ffe60136644001cc650000
c4ffe60136644001cc650000
ffc4d3801406436032e60000
c4ffe60136644001cc650000
c4ffe60136644001cc650000
ffc4d3801406436032e60000
c4ffe60136644001cc650000
ffc4d3801406436032e60000
-
{e=>235268567,a=>-47,d=>5,c=>4,h=>1813,b=>6,g=>2,f=>7}
d1ff6601d7e9057e561c0000
d1ff6601d7e9057e561c0000
d1ff6601d7e9057e561c0000
ffd1d280e05e9d7e8e2a0000
d1ff6601d7e9057e561c0000
d1ff6601d7e9057e561c0000
ffd1d280e05e9d7e8e2a0000
d1ff6601d7e9057e561c0000
ffd1d280e05e9d7e8e2a0000
-
{e=>104426910,a=>-85,d=>3,c=>1,h=>4758,b=>4,g=>2,f=>1}
abffcc009e6d39165a4a0000
abffcc009e6d39165a4a0000
abffcc009e6d39165a4a0000
ffab85806396d9e2a52c0000
abffcc009e6d39165a4a0000
abffcc009e6d39165a4a0000
ffab85806396d9e2a52c0000
abffcc009e6d39165a4a0000
ffab85806396d9e2a52c0000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  short a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>12539432,a=>-13,d=>1,c=>5,h=>262,b=>4,g=>3,f=>0,i=>197}
f3ff6c002856bf001b04c500
f3ff6c002856bf001b04c500
f3ff6c002856bf001b04c500
fff394800bf56280c20cc500
f3ff6c002856bf001b04c500
f3ff6c002856bf001b04c500
fff394800bf56280c20cc500
f3ff6c002856bf001b04c500
fff394800bf56280c20cc500
-
{e=>121930746,a=>112,d=>4,c=>3,h=>1222,b=>7,g=>1,f=>5,i=>13}
70001f01fa83445719130d00
70001f01fa83445719130d00
70001f01fa83445719130d00
0070ee0074483faa498c0d00
70001f01fa83445719130d00
70001f01fa83445719130d00
0070ee0074483faa498c0d00
70001f01fa83445719130d00
0070ee0074483faa498c0d00
-
{e=>212968800,a=>104,d=>5,c=>7,h=>2223,b=>4,g=>2,f=>6,i=>9}
68007c0160a5b16cbe220900
68007c0160a5b16cbe220900
68007c0160a5b16cbe220900
00689e80cb1a560c915e0900
68007c0160a5b16cbe220900
68007c0160a5b16cbe220900
00689e80cb1a560c915e0900
68007c0160a5b16cbe220900
00689e80cb1a560c915e0900
-
{e=>48555818,a=>-18,d=>2,c=>7,h=>3063,b=>4,g=>1,f=>1,i=>165}
eeffbc002ae7e412dd2fa500
eeffbc002ae7e412dd2fa500
eeffbc002ae7e412dd2fa500
ffee9d002e4e72a257eea500
eeffbc002ae7e412dd2fa500
eeffbc002ae7e412dd2fa500
ffee9d002e4e72a257eea500
eeffbc002ae7e412dd2fa500
ffee9d002e4e72a257eea500
-
{e=>204417579,a=>18,d=>3,c=>6,h=>3751,b=>6,g=>1,f=>5,i=>20}
1200f6002b2a2f5c9d3a1400
1200f6002b2a2f5c9d3a1400
1200f6002b2a2f5c9d3a1400
0012d980c2f2a2ba5d4e1400
1200f6002b2a2f5c9d3a1400
1200f6002b2a2f5c9d3a1400
0012d980c2f2a2ba5d4e1400
1200f6002b2a2f5c9d3a1400
0012d980c2f2a2ba5d4e1400
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
};
-
{a=>3,b=>1}
0300000001000000
0300000001000000
0300000001000000
0000000320000000
0300000001000000
0300000001000000
0000000320000000
0300000001000000
0000000320000000
-
{a=>-79,b=>0}
b1ffffff00000000
b1ffffff00000000
b1ffffff00000000
ffffffb100000000
b1ffffff00000000
b1ffffff00000000
ffffffb100000000
b1ffffff00000000
ffffffb100000000
-
{a=>22,b=>0}
1600000000000000
1600000000000000
1600000000000000
0000001600000000
1600000000000000
1600000000000000
0000001600000000
1600000000000000
0000001600000000
-
{a=>-61,b=>4}
c3ffffff04000000
c3ffffff04000000
c3ffffff04000000
ffffffc380000000
c3ffffff04000000
c3ffffff04000000
ffffffc380000000
c3ffffff04000000
ffffffc380000000
-
{a=>4,b=>5}
0400000005000000
0400000005000000
0400000005000000
00000004a0000000
0400000005000000
0400000005000000
00000004a0000000
0400000005000000
00000004a0000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>1,a=>15,b=>2}
0f0000000a000000
0f0000000a000000
0f0000000a000000
0000000f44000000
0f0000000a000000
0f0000000a000000
0000000f44000000
0f0000000a000000
0000000f44000000
-
{c=>6,a=>8,b=>1}
0800000031000000
0800000031000000
0800000031000000
0000000838000000
0800000031000000
0800000031000000
0000000838000000
0800000031000000
0000000838000000
-
{c=>7,a=>20,b=>5}
140000003d000000
140000003d000000
140000003d000000
00000014bc000000
140000003d000000
140000003d000000
00000014bc000000
140000003d000000
00000014bc000000
-
{c=>2,a=>65,b=>6}
4100000016000000
4100000016000000
4100000016000000
00000041c8000000
4100000016000000
4100000016000000
00000041c8000000
4100000016000000
00000041c8000000
-
{c=>6,a=>27,b=>7}
1b00000037000000
1b00000037000000
1b00000037000000
0000001bf8000000
1b00000037000000
1b00000037000000
0000001bf8000000
1b00000037000000
0000001bf8000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>4,a=>121,b=>6,d=>0}
7900000026000000
7900000026000000
7900000026000000
00000079d0000000
7900000026000000
7900000026000000
00000079d0000000
7900000026000000
00000079d0000000
-
{c=>7,a=>-95,b=>4,d=>6}
a1ffffffbc010000
a1ffffffbc010000
a1ffffffbc010000
ffffffa19f000000
a1ffffffbc010000
a1ffffffbc010000
ffffffa19f000000
a1ffffffbc010000
ffffffa19f000000
-
{c=>5,a=>-88,b=>5,d=>4}
a8ffffff2d010000
a8ffffff2d010000
a8ffffff2d010000
ffffffa8b6000000
a8ffffff2d010000
a8ffffff2d010000
ffffffa8b6000000
a8ffffff2d010000
ffffffa8b6000000
-
{c=>6,a=>101,b=>5,d=>1}
6500000075000000
6500000075000000
6500000075000000
00000065b8800000
6500000075000000
6500000075000000
00000065b8800000
6500000075000000
00000065b8800000
-
{c=>7,a=>24,b=>5,d=>6}
18000000bd010000
18000000bd010000
18000000bd010000
00000018bf000000
18000000bd010000
18000000bd010000
00000018bf000000
18000000bd010000
00000018bf000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>169306690,c=>2,a=>21,b=>0,d=>6}
1500000090010000426a170a
1500000090010000426a170a
1500000090010000426a170a
000000150b000000a176a420
1500000090010000426a170a
1500000090010000426a170a
000000150b000000a176a420
1500000090010000426a170a
000000150b000000a176a420
-
{e=>49555571,c=>7,a=>7,b=>1,d=>7}
07000000f90100007328f402
07000000f90100007328f402
07000000f90100007328f402
000000073f8000002f428730
07000000f90100007328f402
07000000f90100007328f402
000000073f8000002f428730
07000000f90100007328f402
000000073f8000002f428730
-
{e=>137008742,c=>3,a=>-69,b=>1,d=>4}
bbffffff1901000066962a08
bbffffff1901000066962a08
bbffffff1901000066962a08
ffffffbb2e00000082a96660
bbffffff1901000066962a08
bbffffff1901000066962a08
ffffffbb2e00000082a96660
bbffffff1901000066962a08
ffffffbb2e00000082a96660
-
{e=>85806609,c=>1,a=>-17,b=>5,d=>3}
efffffffcd000000114e1d05
efffffffcd000000114e1d05
efffffffcd000000114e1d05
ffffffefa580000051d4e110
efffffffcd000000114e1d05
efffffffcd000000114e1d05
ffffffefa580000051d4e110
efffffffcd000000114e1d05
ffffffefa580000051d4e110
-
{e=>133506977,c=>6,a=>93,b=>0,d=>6}
5d000000b0010000a127f507
5d000000b0010000a127f507
5d000000b0010000a127f507
0000005d1b0000007f527a10
5d000000b0010000a127f507
5d000000b0010000a127f507
0000005d1b0000007f527a10
5d000000b0010000a127f507
0000005d1b0000007f527a10
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>156208632,c=>7,a=>-84,b=>2,d=>2,f=>2}
acffffffba000000f88d4f29
acffffffba000000f88d4f29
acffffffba000000f88d4f29
ffffffac5d00000094f8df84
acffffffba000000f88d4f29
acffffffba000000f88d4f29
ffffffac5d00000094f8df84
acffffffba000000f88d4f29
ffffffac5d00000094f8df84
-
{e=>130617554,c=>4,a=>-17,b=>6,d=>7,f=>0}
efffffffe6010000d210c907
efffffffe6010000d210c907
efffffffe6010000d210c907
ffffffefd38000007c910d20
efffffffe6010000d210c907
efffffffe6010000d210c907
ffffffefd38000007c910d20
efffffffe6010000d210c907
ffffffefd38000007c910d20
-
{e=>95191856,c=>5,a=>65,b=>4,d=>6,f=>6}
41000000ac0100003083ac65
41000000ac0100003083ac65
41000000ac0100003083ac65
00000041970000005ac8330c
41000000ac0100003083ac65
41000000ac0100003083ac65
00000041970000005ac8330c
41000000ac0100003083ac65
00000041970000005ac8330c
-
{e=>142523577,c=>4,a=>114,b=>5,d=>2,f=>1}
72000000a5000000b9bc7e18
72000000a5000000b9bc7e18
72000000a5000000b9bc7e18
00000072b100000087ebcb92
72000000a5000000b9bc7e18
72000000a5000000b9bc7e18
00000072b100000087ebcb92
72000000a5000000b9bc7e18
00000072b100000087ebcb92
-
{e=>122537461,c=>7,a=>-44,b=>5,d=>0,f=>2}
d4ffffff3d000000f5c54d27
d4ffffff3d000000f5c54d27
d4ffffff3d000000f5c54d27
ffffffd4bc00000074dc5f54
d4ffffff3d000000f5c54d27
d4ffffff3d000000f5c54d27
ffffffd4bc00000074dc5f54
d4ffffff3d000000f5c54d27
ffffffd4bc00000074dc5f54
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>144539243,c=>5,a=>29,g=>2,b=>5,d=>0,f=>6}
1d0000002d0000006b7e9d6802000000
1d0000002d0000006b7e9d6802000000
1d0000002d0000006b7e9d6802000000
0000001db400000089d7e6bc80000000
1d0000002d0000006b7e9d6802000000
1d0000002d0000006b7e9d6802000000
0000001db400000089d7e6bc80000000
1d0000002d0000006b7e9d6802000000
0000001db400000089d7e6bc80000000
-
{e=>139635304,c=>6,a=>123,g=>2,b=>7,d=>7,f=>3}
7b000000f701000068aa523802000000
7b000000f701000068aa523802000000
7b000000f701000068aa523802000000
0000007bfb800000852aa68680000000
7b000000f701000068aa523802000000
7b000000f701000068aa523802000000
0000007bfb800000852aa68680000000
7b000000f701000068aa523802000000
0000007bfb800000852aa68680000000
-
{e=>8969412,c=>7,a=>-110,g=>2,b=>1,d=>2,f=>2}
92ffffffb9000000c4dc882002000000
92ffffffb9000000c4dc882002000000
92ffffffb9000000c4dc882002000000
ffffff923d000000088dcc4480000000
92ffffffb9000000c4dc882002000000
92ffffffb9000000c4dc882002000000
ffffff923d000000088dcc4480000000
92ffffffb9000000c4dc882002000000
ffffff923d000000088dcc4480000000
-
{e=>110093836,c=>0,a=>-32,g=>3,b=>2,d=>0,f=>5}
e0ffffff020000000ce68f5603000000
e0ffffff020000000ce68f5603000000
e0ffffff020000000ce68f5603000000
ffffffe04000000068fe60cac0000000
e0ffffff020000000ce68f5603000000
e0ffffff020000000ce68f5603000000
ffffffe04000000068fe60cac0000000
e0ffffff020000000ce68f5603000000
ffffffe04000000068fe60cac0000000
-
{e=>18345492,c=>1,a=>14,g=>2,b=>0,d=>1,f=>1}
0e0000004800000014ee171102000000
0e0000004800000014ee171102000000
0e0000004800000014ee171102000000
0000000e04800000117ee14280000000
0e0000004800000014ee171102000000
0e0000004800000014ee171102000000
0000000e04800000117ee14280000000
0e0000004800000014ee171102000000
0000000e04800000117ee14280000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>243213622,a=>-120,d=>4,c=>7,h=>7881,b=>7,g=>3,f=>2}
88ffffff3f01000036257f2e277b0000
88ffffff3f01000036257f2e277b0000
88ffffff3f01000036257f2e277b0000
ffffff88fe000000e7f25364fd920000
88ffffff3f01000036257f2e277b0000
88ffffff3f01000036257f2e277b0000
ffffff88fe000000e7f25364fd920000
88ffffff3f01000036257f2e277b0000
ffffff88fe000000e7f25364fd920000
-
{e=>86919501,a=>53,d=>5,c=>5,h=>380,b=>0,g=>0,f=>0}
35000000680100004d492e05f0050000
35000000680100004d492e05f0050000
35000000680100004d492e05f0050000
000000351680000052e494d002f80000
35000000680100004d492e05f0050000
35000000680100004d492e05f0050000
000000351680000052e494d002f80000
35000000680100004d492e05f0050000
000000351680000052e494d002f80000
-
{e=>147012077,a=>32,d=>1,c=>6,h=>2230,b=>1,g=>2,f=>7}
2000000071000000ed39c378da220000
2000000071000000ed39c378da220000
2000000071000000ed39c378da220000
00000020388000008c339ede916c0000
2000000071000000ed39c378da220000
2000000071000000ed39c378da220000
00000020388000008c339ede916c0000
2000000071000000ed39c378da220000
00000020388000008c339ede916c0000
-
{e=>23638499,a=>-48,d=>3,c=>7,h=>5753,b=>7,g=>2,f=>6}
d0ffffffff000000e3b16861e6590000
d0ffffffff000000e3b16861e6590000
d0ffffffff000000e3b16861e6590000
ffffffd0fd800000168b1e3cacf20000
d0ffffffff000000e3b16861e6590000
d0ffffffff000000e3b16861e6590000
ffffffd0fd800000168b1e3cacf20000
d0ffffffff000000e3b16861e6590000
ffffffd0fd800000168b1e3cacf20000
-
{e=>136927608,a=>-38,d=>6,c=>7,h=>773,b=>3,g=>2,f=>5}
daffffffbb01000078592958160c0000
daffffffbb01000078592958160c0000
daffffffbb01000078592958160c0000
ffffffda7f0000008295978a860a0000
daffffffbb01000078592958160c0000
daffffffbb01000078592958160c0000
ffffffda7f0000008295978a860a0000
daffffffbb01000078592958160c0000
ffffffda7f0000008295978a860a0000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  int a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>145884245,a=>43,d=>4,c=>7,h=>3698,b=>4,g=>0,f=>0,i=>117}
2b0000003c0100005504b208c8397500
2b0000003c0100005504b208c8397500
2b0000003c0100005504b208c8397500
0000002b9e0000008b2045501ce47500
2b0000003c0100005504b208c8397500
2b0000003c0100005504b208c8397500
0000002b9e0000008b2045501ce47500
2b0000003c0100005504b208c8397500
0000002b9e0000008b2045501ce47500
-
{e=>148618604,a=>-115,d=>5,c=>6,h=>3263,b=>7,g=>2,f=>1,i=>253}
8dffffff770100006cbddb18fe32fd00
8dffffff770100006cbddb18fe32fd00
8dffffff770100006cbddb18fe32fd00
ffffff8dfa8000008dbbd6c2997efd00
8dffffff770100006cbddb18fe32fd00
8dffffff770100006cbddb18fe32fd00
ffffff8dfa8000008dbbd6c2997efd00
8dffffff770100006cbddb18fe32fd00
ffffff8dfa8000008dbbd6c2997efd00
-
{e=>226652794,a=>48,d=>5,c=>2,h=>2101,b=>4,g=>1,f=>3,i=>16}
30000000540100007a72823dd5201000
30000000540100007a72823dd5201000
30000000540100007a72823dd5201000
000000308a800000d82727a6506a1000
30000000540100007a72823dd5201000
30000000540100007a72823dd5201000
000000308a800000d82727a6506a1000
30000000540100007a72823dd5201000
000000308a800000d82727a6506a1000
-
{e=>137257539,a=>-126,d=>4,c=>7,h=>3963,b=>0,g=>3,f=>1,i=>27}
82ffffff3801000043622e18ef3d1b00
82ffffff3801000043622e18ef3d1b00
82ffffff3801000043622e18ef3d1b00
ffffff821e00000082e62432def61b00
82ffffff3801000043622e18ef3d1b00
82ffffff3801000043622e18ef3d1b00
ffffff821e00000082e62432def61b00
82ffffff3801000043622e18ef3d1b00
ffffff821e00000082e62432def61b00
-
{e=>106849035,a=>-61,d=>5,c=>4,h=>1757,b=>7,g=>1,f=>5,i=>42}
c3ffffff670100000b635e56751b2a00
c3ffffff670100000b635e56751b2a00
c3ffffff670100000b635e56751b2a00
ffffffc3f280000065e630ba4dba2a00
c3ffffff670100000b635e56751b2a00
c3ffffff670100000b635e56751b2a00
ffffffc3f280000065e630ba4dba2a00
c3ffffff670100000b635e56751b2a00
ffffffc3f280000065e630ba4dba2a00
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
};
-
{a=>72,b=>5}
4800000005000000
48000000000000000500000000000000
48000000000000000500000000000000
00000048a0000000
4800000005000000
4800000005000000
0000000000000048a000000000000000
4800000005000000
00000048a0000000
-
{a=>-71,b=>1}
b9ffffff01000000
b9ffffffffffffff0100000000000000
b9ffffffffffffff0100000000000000
ffffffb920000000
b9ffffff01000000
b9ffffff01000000
ffffffffffffffb92000000000000000
b9ffffff01000000
ffffffb920000000
-
{a=>-67,b=>4}
bdffffff04000000
bdffffffffffffff0400000000000000
bdffffffffffffff0400000000000000
ffffffbd80000000
bdffffff04000000
bdffffff04000000
ffffffffffffffbd8000000000000000
bdffffff04000000
ffffffbd80000000
-
{a=>-126,b=>2}
82ffffff02000000
82ffffffffffffff0200000000000000
82ffffffffffffff0200000000000000
ffffff8240000000
82ffffff02000000
82ffffff02000000
ffffffffffffff824000000000000000
82ffffff02000000
ffffff8240000000
-
{a=>126,b=>2}
7e00000002000000
7e000000000000000200000000000000
7e000000000000000200000000000000
0000007e40000000
7e00000002000000
7e00000002000000
000000000000007e4000000000000000
7e00000002000000
0000007e40000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
};
-
{c=>2,a=>122,b=>0}
7a00000010000000
7a000000000000001000000000000000
7a000000000000001000000000000000
0000007a08000000
7a00000010000000
7a00000010000000
000000000000007a0800000000000000
7a00000010000000
0000007a08000000
-
{c=>7,a=>-32,b=>1}
e0ffffff39000000
e0ffffffffffffff3900000000000000
e0ffffffffffffff3900000000000000
ffffffe03c000000
e0ffffff39000000
e0ffffff39000000
ffffffffffffffe03c00000000000000
e0ffffff39000000
ffffffe03c000000
-
{c=>1,a=>33,b=>2}
210000000a000000
21000000000000000a00000000000000
21000000000000000a00000000000000
0000002144000000
210000000a000000
210000000a000000
00000000000000214400000000000000
210000000a000000
0000002144000000
-
{c=>2,a=>-13,b=>6}
f3ffffff16000000
f3ffffffffffffff1600000000000000
f3ffffffffffffff1600000000000000
fffffff3c8000000
f3ffffff16000000
f3ffffff16000000
fffffffffffffff3c800000000000000
f3ffffff16000000
fffffff3c8000000
-
{c=>6,a=>-22,b=>1}
eaffffff31000000
eaffffffffffffff3100000000000000
eaffffffffffffff3100000000000000
ffffffea38000000
eaffffff31000000
eaffffff31000000
ffffffffffffffea3800000000000000
eaffffff31000000
ffffffea38000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
};
-
{c=>4,a=>-120,b=>1,d=>6}
88ffffffa1010000
88ffffffffffffffa101000000000000
88ffffffffffffffa101000000000000
ffffff8833000000
88ffffffa1010000
88ffffffa1010000
ffffffffffffff883300000000000000
88ffffffa1010000
ffffff8833000000
-
{c=>6,a=>-100,b=>5,d=>5}
9cffffff75010000
9cffffffffffffff7501000000000000
9cffffffffffffff7501000000000000
ffffff9cba800000
9cffffff75010000
9cffffff75010000
ffffffffffffff9cba80000000000000
9cffffff75010000
ffffff9cba800000
-
{c=>7,a=>70,b=>5,d=>2}
46000000bd000000
4600000000000000bd00000000000000
4600000000000000bd00000000000000
00000046bd000000
46000000bd000000
46000000bd000000
0000000000000046bd00000000000000
46000000bd000000
00000046bd000000
-
{c=>5,a=>-124,b=>3,d=>0}
84ffffff2b000000
84ffffffffffffff2b00000000000000
84ffffffffffffff2b00000000000000
ffffff8474000000
84ffffff2b000000
84ffffff2b000000
ffffffffffffff847400000000000000
84ffffff2b000000
ffffff8474000000
-
{c=>7,a=>106,b=>6,d=>3}
6a000000fe000000
6a00000000000000fe00000000000000
6a00000000000000fe00000000000000
0000006add800000
6a000000fe000000
6a000000fe000000
000000000000006add80000000000000
6a000000fe000000
0000006add800000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
};
-
{e=>238948103,c=>0,a=>46,b=>1,d=>7}
2e000000c1010000070f3e0e
2e00000000000000c1010000070f3e0e
2e00000000000000c1010000070f3e0e
0000002e23800000e3e0f070
2e000000c1010000070f3e0e
2e000000c1010000070f3e0e
000000000000002e23800000e3e0f070
2e000000c1010000070f3e0e
0000002e23800000e3e0f070
-
{e=>85833411,c=>2,a=>41,b=>3,d=>7}
29000000d3010000c3b61d05
2900000000000000d3010000c3b61d05
2900000000000000d3010000c3b61d05
000000296b80000051db6c30
29000000d3010000c3b61d05
29000000d3010000c3b61d05
00000000000000296b80000051db6c30
29000000d3010000c3b61d05
000000296b80000051db6c30
-
{e=>85862305,c=>4,a=>-94,b=>6,d=>4}
a2ffffff26010000a1271e05
a2ffffffffffffff26010000a1271e05
a2ffffffffffffff26010000a1271e05
ffffffa2d200000051e27a10
a2ffffff26010000a1271e05
a2ffffff26010000a1271e05
ffffffffffffffa2d200000051e27a10
a2ffffff26010000a1271e05
ffffffa2d200000051e27a10
-
{e=>89255584,c=>4,a=>26,b=>1,d=>0}
1a00000021000000a0ee5105
1a0000000000000021000000a0ee5105
1a0000000000000021000000a0ee5105
0000001a30000000551eea00
1a00000021000000a0ee5105
1a00000021000000a0ee5105
000000000000001a30000000551eea00
1a00000021000000a0ee5105
0000001a30000000551eea00
-
{e=>218745112,c=>5,a=>-41,b=>3,d=>0}
d7ffffff2b00000018c9090d
d7ffffffffffffff2b00000018c9090d
d7ffffffffffffff2b00000018c9090d
ffffffd774000000d09c9180
d7ffffff2b00000018c9090d
d7ffffff2b00000018c9090d
ffffffffffffffd774000000d09c9180
d7ffffff2b00000018c9090d
ffffffd774000000d09c9180
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
};
-
{e=>181902780,c=>3,a=>-112,b=>6,d=>7,f=>4}
90ffffffde010000bc9dd74a
90ffffffffffffffde010000bc9dd74a
90ffffffffffffffde010000bc9dd74a
ffffff90cf800000ad79dbc8
90ffffffde010000bc9dd74a
90ffffffde010000bc9dd74a
ffffffffffffff90cf800000ad79dbc8
90ffffffde010000bc9dd74a
ffffff90cf800000ad79dbc8
-
{e=>243947917,c=>2,a=>-87,b=>0,d=>1,f=>7}
a9ffffff500000008d598a7e
a9ffffffffffffff500000008d598a7e
a9ffffffffffffff500000008d598a7e
ffffffa908800000e8a598de
a9ffffff500000008d598a7e
a9ffffff500000008d598a7e
ffffffffffffffa908800000e8a598de
a9ffffff500000008d598a7e
ffffffa908800000e8a598de
-
{e=>87380681,c=>3,a=>-46,b=>2,d=>3,f=>1}
d2ffffffda000000c9523515
d2ffffffffffffffda000000c9523515
d2ffffffffffffffda000000c9523515
ffffffd24d80000053552c92
d2ffffffda000000c9523515
d2ffffffda000000c9523515
ffffffffffffffd24d80000053552c92
d2ffffffda000000c9523515
ffffffd24d80000053552c92
-
{e=>23417204,c=>4,a=>50,b=>3,d=>0,f=>5}
320000002300000074516551
32000000000000002300000074516551
32000000000000002300000074516551
00000032700000001655174a
320000002300000074516551
320000002300000074516551
0000000000000032700000001655174a
320000002300000074516551
00000032700000001655174a
-
{e=>33123043,c=>0,a=>116,b=>6,d=>0,f=>4}
7400000006000000e36af941
740000000000000006000000e36af941
740000000000000006000000e36af941
00000074c00000001f96ae38
7400000006000000e36af941
7400000006000000e36af941
0000000000000074c00000001f96ae38
7400000006000000e36af941
00000074c00000001f96ae38
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
};
-
{e=>84208039,c=>0,a=>14,g=>1,b=>2,d=>1,f=>0}
0e00000042000000a7e9040501000000
0e0000000000000042000000a7e904050100000000000000
0e0000000000000042000000a7e904050100000000000000
0000000e40800000504e9a7040000000
0e00000042000000a7e9040501000000
0e00000042000000a7e9040501000000
000000000000000e40800000504e9a704000000000000000
0e00000042000000a7e9040501000000
0000000e40800000504e9a7040000000
-
{e=>116421098,c=>1,a=>-89,g=>2,b=>6,d=>4,f=>6}
a7ffffff0e010000ea71f06602000000
a7ffffffffffffff0e010000ea71f0660200000000000000
a7ffffffffffffff0e010000ea71f0660200000000000000
ffffffa7c60000006f071eac80000000
a7ffffff0e010000ea71f06602000000
a7ffffff0e010000ea71f06602000000
ffffffffffffffa7c60000006f071eac8000000000000000
a7ffffff0e010000ea71f06602000000
ffffffa7c60000006f071eac80000000
-
{e=>233446560,c=>1,a=>-126,g=>0,b=>7,d=>1,f=>0}
82ffffff4f000000a01cea0d00000000
82ffffffffffffff4f000000a01cea0d0000000000000000
82ffffffffffffff4f000000a01cea0d0000000000000000
ffffff82e4800000dea1ca0000000000
82ffffff4f000000a01cea0d00000000
82ffffff4f000000a01cea0d00000000
ffffffffffffff82e4800000dea1ca000000000000000000
82ffffff4f000000a01cea0d00000000
ffffff82e4800000dea1ca0000000000
-
{e=>196256397,c=>2,a=>-106,g=>1,b=>1,d=>5,f=>0}
96ffffff510100008da2b20b01000000
96ffffffffffffff510100008da2b20b0100000000000000
96ffffffffffffff510100008da2b20b0100000000000000
ffffff962a800000bb2a28d040000000
96ffffff510100008da2b20b01000000
96ffffff510100008da2b20b01000000
ffffffffffffff962a800000bb2a28d04000000000000000
96ffffff510100008da2b20b01000000
ffffff962a800000bb2a28d040000000
-
{e=>98949361,c=>1,a=>69,g=>3,b=>4,d=>4,f=>0}
450000000c010000f1d8e50503000000
45000000000000000c010000f1d8e5050300000000000000
45000000000000000c010000f1d8e5050300000000000000
00000045860000005e5d8f10c0000000
450000000c010000f1d8e50503000000
450000000c010000f1d8e50503000000
0000000000000045860000005e5d8f10c000000000000000
450000000c010000f1d8e50503000000
00000045860000005e5d8f10c0000000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
};
-
{e=>154431445,a=>-110,d=>6,c=>7,h=>5540,b=>6,g=>1,f=>7}
92ffffffbe010000d56f347991560000
92ffffffffffffffbe010000d56f34799156000000000000
92ffffffffffffffbe010000d56f34799156000000000000
ffffff92df0000009346fd5e6b480000
92ffffffbe010000d56f347991560000
92ffffffbe010000d56f347991560000
ffffffffffffff92df0000009346fd5e6b48000000000000
92ffffffbe010000d56f347991560000
ffffff92df0000009346fd5e6b480000
-
{e=>175556692,a=>-125,d=>1,c=>1,h=>2798,b=>5,g=>2,f=>5}
83ffffff4d00000054c8765aba2b0000
83ffffffffffffff4d00000054c8765aba2b000000000000
83ffffffffffffff4d00000054c8765aba2b000000000000
ffffff83a4800000a76c854a95dc0000
83ffffff4d00000054c8765aba2b0000
83ffffff4d00000054c8765aba2b0000
ffffffffffffff83a4800000a76c854a95dc000000000000
83ffffff4d00000054c8765aba2b0000
ffffff83a4800000a76c854a95dc0000
-
{e=>165973282,a=>-23,d=>2,c=>0,h=>4321,b=>0,g=>0,f=>0}
e9ffffff80000000228de40984430000
e9ffffffffffffff80000000228de4098443000000000000
e9ffffffffffffff80000000228de4098443000000000000
ffffffe9010000009e48d22021c20000
e9ffffff80000000228de40984430000
e9ffffff80000000228de40984430000
ffffffffffffffe9010000009e48d22021c2000000000000
e9ffffff80000000228de40984430000
ffffffe9010000009e48d22021c20000
-
{e=>13388635,a=>38,d=>7,c=>3,h=>3576,b=>1,g=>1,f=>0}
26000000d90100005b4bcc00e1370000
2600000000000000d90100005b4bcc00e137000000000000
2600000000000000d90100005b4bcc00e137000000000000
000000262f8000000cc4b5b05bf00000
26000000d90100005b4bcc00e1370000
26000000d90100005b4bcc00e1370000
00000000000000262f8000000cc4b5b05bf0000000000000
26000000d90100005b4bcc00e1370000
000000262f8000000cc4b5b05bf00000
-
{e=>21214690,a=>-124,d=>3,c=>4,h=>6149,b=>0,g=>3,f=>3}
84ffffffe0000000e2b5433117600000
84ffffffffffffffe0000000e2b543311760000000000000
84ffffffffffffffe0000000e2b543311760000000000000
ffffff8411800000143b5e26f00a0000
84ffffffe0000000e2b5433117600000
84ffffffe0000000e2b5433117600000
ffffffffffffff8411800000143b5e26f00a000000000000
84ffffffe0000000e2b5433117600000
ffffff8411800000143b5e26f00a0000
=
#if defined PACK_PAREN
#pragma pack( 4 )
#elif defined PACK_NO_PAREN
#pragma pack 4
#endif
struct umixed_pack_4 {
  long a;
  unsigned char  b:3;
  unsigned char  c:3;
  unsigned short d:3;
  unsigned int   e:28;
  unsigned char  f:3;
  unsigned char  g:2;
  unsigned short h:13;
  unsigned char  i;
};
-
{e=>130293957,a=>-6,d=>3,c=>0,h=>3224,b=>7,g=>2,f=>1,i=>96}
faffffffc7000000c520c41762326000
faffffffffffffffc7000000c520c4176232600000000000
faffffffffffffffc7000000c520c4176232600000000000
fffffffae18000007c420c5299306000
faffffffc7000000c520c41762326000
faffffffc7000000c520c41762326000
fffffffffffffffae18000007c420c529930600000000000
faffffffc7000000c520c41762326000
fffffffae18000007c420c5299306000
-
{e=>22275050,a=>24,d=>7,c=>6,h=>4511,b=>7,g=>0,f=>3,i=>194}
18000000f7010000eae353317c46c200
1800000000000000f7010000eae353317c46c20000000000
1800000000000000f7010000eae353317c46c20000000000
00000018fb800000153e3ea6233ec200
18000000f7010000eae353317c46c200
18000000f7010000eae353317c46c200
0000000000000018fb800000153e3ea6233ec20000000000
18000000f7010000eae353317c46c200
00000018fb800000153e3ea6233ec200
-
{e=>185744049,a=>-60,d=>7,c=>6,h=>1844,b=>6,g=>0,f=>2,i=>56}
c4fffffff6010000b13a122bd01c3800
c4fffffffffffffff6010000b13a122bd01c380000000000
c4fffffffffffffff6010000b13a122bd01c380000000000
ffffffc4db800000b123ab140e683800
c4fffffff6010000b13a122bd01c3800
c4fffffff6010000b13a122bd01c3800
ffffffffffffffc4db800000b123ab140e68380000000000
c4fffffff6010000b13a122bd01c3800
ffffffc4db800000b123ab140e683800
-
{e=>260322633,a=>-58,d=>5,c=>5,h=>6201,b=>7,g=>2,f=>2,i=>199}
c6ffffff6f0100004935842fe660c700
c6ffffffffffffff6f0100004935842fe660c70000000000
c6ffffffffffffff6f0100004935842fe660c70000000000
ffffffc6f6800000f8435494b072c700
c6ffffff6f0100004935842fe660c700
c6ffffff6f0100004935842fe660c700
ffffffffffffffc6f6800000f8435494b072c70000000000
c6ffffff6f0100004935842fe660c700
ffffffc6f6800000f8435494b072c700
-
{e=>148496573,a=>-115,d=>0,c=>0,h=>7411,b=>3,g=>0,f=>7,i=>14}
8dffffff03000000bde0d978cc730e00
8dffffffffffffff03000000bde0d978cc730e0000000000
8dffffffffffffff03000000bde0d978cc730e0000000000
ffffff8d600000008d9e0bde39e60e00
8dffffff03000000bde0d978cc730e00
8dffffff03000000bde0d978cc730e00
ffffffffffffff8d600000008d9e0bde39e60e0000000000
8dffffff03000000bde0d978cc730e00
ffffff8d600000008d9e0bde39e60e00
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
};
-
{a=>7}
07000000
07000000
07000000
e0000000
07000000
07000000
e0000000
07000000
e0000000
-
{a=>5}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{a=>5}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>7}
07000000
07000000
07000000
e0000000
07000000
07000000
e0000000
07000000
e0000000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
};
-
{a=>5,b=>3}
1d000000
1d000000
1d000000
ac000000
1d000000
1d000000
ac000000
1d000000
ac000000
-
{a=>6,b=>-4}
26000000
26000000
26000000
d0000000
26000000
26000000
d0000000
26000000
d0000000
-
{a=>7,b=>1}
0f000000
0f000000
0f000000
e4000000
0f000000
0f000000
e4000000
0f000000
e4000000
-
{a=>4,b=>2}
14000000
14000000
14000000
88000000
14000000
14000000
88000000
14000000
88000000
-
{a=>3,b=>2}
13000000
13000000
13000000
68000000
13000000
13000000
68000000
13000000
68000000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
};
-
{c=>1,a=>6,b=>-4}
66000000
66000000
66000000
d0800000
66000000
66000000
d0800000
66000000
d0800000
-
{c=>3,a=>2,b=>0}
c2000000
c2000000
c2000000
41800000
c2000000
c2000000
41800000
c2000000
41800000
-
{c=>1,a=>4,b=>-3}
6c000000
6c000000
6c000000
94800000
6c000000
6c000000
94800000
6c000000
94800000
-
{c=>-4,a=>2,b=>-4}
22010000
22010000
22010000
52000000
22010000
22010000
52000000
22010000
52000000
-
{c=>-3,a=>4,b=>-3}
6c010000
6c010000
6c010000
96800000
6c010000
6c010000
96800000
6c010000
96800000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
};
-
{c=>-3,a=>0,b=>-3,d=>3}
68070000
68070000
68070000
16b00000
68070000
68070000
16b00000
68070000
16b00000
-
{c=>-4,a=>3,b=>3,d=>4}
1b090000
1b090000
1b090000
6e400000
1b090000
1b090000
6e400000
1b090000
6e400000
-
{c=>-4,a=>4,b=>3,d=>1}
1c030000
1c030000
1c030000
8e100000
1c030000
1c030000
8e100000
1c030000
8e100000
-
{c=>-1,a=>6,b=>-3,d=>0}
ee010000
ee010000
ee010000
d7800000
ee010000
ee010000
d7800000
ee010000
d7800000
-
{c=>0,a=>5,b=>2,d=>2}
15040000
15040000
15040000
a8200000
15040000
15040000
a8200000
15040000
a8200000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
};
-
{e=>0,c=>2,a=>1,b=>2,d=>6}
910c0000
910c0000
910c0000
29600000
910c0000
910c0000
29600000
910c0000
29600000
-
{e=>-1,c=>-2,a=>6,b=>3,d=>7}
9e7f0000
9e7f0000
9e7f0000
cf7e0000
9e7f0000
9e7f0000
cf7e0000
9e7f0000
cf7e0000
-
{e=>-1,c=>-2,a=>0,b=>0,d=>2}
80750000
80750000
80750000
032e0000
80750000
80750000
032e0000
80750000
032e0000
-
{e=>0,c=>3,a=>6,b=>-1,d=>0}
fe000000
fe000000
fe000000
dd800000
fe000000
fe000000
dd800000
fe000000
dd800000
-
{e=>3,c=>-2,a=>1,b=>0,d=>7}
813f0000
813f0000
813f0000
23760000
813f0000
813f0000
23760000
813f0000
23760000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
};
-
{e=>2,c=>1,a=>2,b=>-4,d=>3,f=>6}
62260300
62260300
62260300
50b58000
62260300
62260300
50b58000
62260300
50b58000
-
{e=>-2,c=>-2,a=>6,b=>1,d=>6,f=>0}
8e6d0000
8e6d0000
8e6d0000
c76c0000
8e6d0000
8e6d0000
c76c0000
8e6d0000
c76c0000
-
{e=>1,c=>1,a=>3,b=>-4,d=>7,f=>5}
639e0200
639e0200
639e0200
70f34000
639e0200
639e0200
70f34000
639e0200
70f34000
-
{e=>2,c=>2,a=>0,b=>-1,d=>3,f=>2}
b8260100
b8260100
b8260100
1d348000
b8260100
b8260100
1d348000
b8260100
1d348000
-
{e=>0,c=>3,a=>5,b=>2,d=>5,f=>2}
d50a0100
d50a0100
d50a0100
a9d08000
d50a0100
d50a0100
a9d08000
d50a0100
a9d08000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
};
-
{e=>3,c=>-4,a=>1,b=>2,d=>1,f=>1}
11b30000
11b30000
11b30000
2a164000
11b30000
11b30000
2a164000
11b30000
2a164000
-
{e=>-1,c=>-2,a=>5,b=>-1,d=>7,f=>2}
bd7f0100
bd7f0100
bd7f0100
bf7e8000
bd7f0100
bd7f0100
bf7e8000
bd7f0100
bf7e8000
-
{e=>-3,c=>-2,a=>2,b=>-2,d=>2,f=>3}
b2d50100
b2d50100
b2d50100
5b2ac000
b2d50100
b2d50100
5b2ac000
b2d50100
5b2ac000
-
{e=>-1,c=>-1,a=>7,b=>-1,d=>3,f=>1}
fff70000
fff70000
fff70000
ffbe4000
fff70000
fff70000
ffbe4000
fff70000
ffbe4000
-
{e=>-3,c=>2,a=>7,b=>-2,d=>5,f=>0}
b75a0000
b75a0000
b75a0000
f95a0000
b75a0000
b75a0000
f95a0000
b75a0000
f95a0000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
};
-
{e=>0,c=>3,a=>3,g=>2,b=>0,d=>2,f=>7}
c384030002000000
c384030002000000
c384030002000000
61a1c00040000000
c384030002000000
c384030002000000
61a1c00040000000
c384030002000000
61a1c00040000000
-
{e=>1,c=>3,a=>0,g=>7,b=>1,d=>1,f=>4}
c812020007000000
c812020007000000
c812020007000000
05930000e0000000
c812020007000000
c812020007000000
05930000e0000000
c812020007000000
05930000e0000000
-
{e=>0,c=>3,a=>7,g=>0,b=>-2,d=>7,f=>2}
f70e010000000000
f70e010000000000
f70e010000000000
f9f0800000000000
f70e010000000000
f70e010000000000
f9f0800000000000
f70e010000000000
f9f0800000000000
-
{e=>-2,c=>3,a=>1,g=>2,b=>0,d=>2,f=>0}
c164000002000000
c164000002000000
c164000002000000
21ac000040000000
c164000002000000
c164000002000000
21ac000040000000
c164000002000000
21ac000040000000
-
{e=>2,c=>-1,a=>7,g=>5,b=>-2,d=>6,f=>7}
f7ad030005000000
f7ad030005000000
f7ad030005000000
fbe5c000a0000000
f7ad030005000000
f7ad030005000000
fbe5c000a0000000
f7ad030005000000
fbe5c000a0000000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
};
-
{e=>1,a=>0,d=>6,c=>-1,h=>3,b=>-1,g=>7,f=>6}
f81d03001f000000
f81d03001f000000
f81d03001f000000
1fe38000ec000000
f81d03001f000000
f81d03001f000000
1fe38000ec000000
f81d03001f000000
1fe38000ec000000
-
{e=>-4,a=>1,d=>3,c=>-4,h=>2,b=>2,g=>0,f=>5}
11c7020010000000
11c7020010000000
11c7020010000000
2a39400008000000
11c7020010000000
11c7020010000000
2a39400008000000
11c7020010000000
2a39400008000000
-
{e=>2,a=>3,d=>1,c=>-4,h=>0,b=>-1,g=>0,f=>2}
3b23010000000000
3b23010000000000
3b23010000000000
7e14800000000000
3b23010000000000
3b23010000000000
7e14800000000000
3b23010000000000
7e14800000000000
-
{e=>-2,a=>4,d=>4,c=>2,h=>-3,b=>-4,g=>7,f=>1}
a4e800002f000000
a4e800002f000000
a4e800002f000000
914c4000f4000000
a4e800002f000000
a4e800002f000000
914c4000f4000000
a4e800002f000000
914c4000f4000000
-
{e=>-2,a=>1,d=>2,c=>-1,h=>0,b=>-2,g=>5,f=>6}
f165030005000000
f165030005000000
f165030005000000
3bad8000a0000000
f165030005000000
f165030005000000
3bad8000a0000000
f165030005000000
3bad8000a0000000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
};
-
{e=>0,a=>3,d=>4,c=>-1,h=>3,b=>-2,g=>3,f=>4,i=>1}
f30902005b000000
f30902005b000000
f30902005b000000
7bc100006c800000
f30902005b000000
f30902005b000000
7bc100006c800000
f30902005b000000
7bc100006c800000
-
{e=>2,a=>5,d=>2,c=>1,h=>2,b=>-3,g=>4,f=>0,i=>3}
6d240000d4000000
6d240000d4000000
6d240000d4000000
b4a4000089800000
6d240000d4000000
6d240000d4000000
b4a4000089800000
6d240000d4000000
b4a4000089800000
-
{e=>0,a=>5,d=>3,c=>2,h=>-3,b=>-1,g=>7,f=>7,i=>4}
bd8603002f010000
bd8603002f010000
bd8603002f010000
bd31c000f6000000
bd8603002f010000
bd8603002f010000
bd31c000f6000000
bd8603002f010000
bd31c000f6000000
-
{e=>-3,a=>5,d=>1,c=>1,h=>3,b=>-1,g=>3,f=>2,i=>6}
7d5201009b010000
7d5201009b010000
7d5201009b010000
bc9a80006f000000
7d5201009b010000
7d5201009b010000
bc9a80006f000000
7d5201009b010000
bc9a80006f000000
-
{e=>3,a=>3,d=>6,c=>1,h=>0,b=>0,g=>3,f=>2,i=>7}
433c0100c3010000
433c0100c3010000
433c0100c3010000
60e6800063800000
433c0100c3010000
433c0100c3010000
60e6800063800000
433c0100c3010000
60e6800063800000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
};
-
{e=>-1,a=>4,d=>4,j=>-12,c=>2,h=>1,b=>-1,g=>7,f=>7,i=>0}
bcf803000f00f400
bcf803000f00f400
bcf803000f00f400
9d4fc000e400f400
bcf803000f00f400
bcf803000f00f400
9d4fc000e400f400
bcf803000f00f400
9d4fc000e400f400
-
{e=>3,a=>4,d=>1,j=>93,c=>-1,h=>3,b=>-4,g=>3,f=>2,i=>6}
e43301009b015d00
e43301009b015d00
e43301009b015d00
939680006f005d00
e43301009b015d00
e43301009b015d00
939680006f005d00
e43301009b015d00
939680006f005d00
-
{e=>1,a=>1,d=>6,j=>58,c=>-2,h=>-3,b=>3,g=>7,f=>5,i=>6}
999d0200af013a00
999d0200af013a00
999d0200af013a00
2f634000f7003a00
999d0200af013a00
999d0200af013a00
2f634000f7003a00
999d0200af013a00
2f634000f7003a00
-
{e=>-2,a=>4,d=>4,j=>96,c=>3,h=>3,b=>-3,g=>6,f=>0,i=>1}
ec6800005e006000
ec6800005e006000
ec6800005e006000
95cc0000cc806000
ec6800005e006000
ec6800005e006000
95cc0000cc806000
ec6800005e006000
95cc0000cc806000
-
{e=>-4,a=>6,d=>7,j=>-52,c=>-2,h=>-2,b=>2,g=>5,f=>4,i=>7}
964f0200f501cc00
964f0200f501cc00
964f0200f501cc00
cb790000bb80cc00
964f0200f501cc00
964f0200f501cc00
cb790000bb80cc00
964f0200f501cc00
cb790000bb80cc00
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
};
-
{e=>-4,a=>4,d=>6,j=>-110,c=>3,k=>1,h=>3,b=>-4,g=>4,f=>2,i=>5}
e44c01005c019201
e44c01005c019201
e44c01005c019201
91e880008e809220
e44c01005c019201
e44c01005c019201
91e880008e809220
e44c01005c019201
91e880008e809220
-
{e=>1,a=>1,d=>5,j=>-28,c=>-3,k=>4,h=>-4,b=>2,g=>2,f=>4,i=>2}
511b0200a200e404
511b0200a200e404
511b0200a200e404
2ad300005100e480
511b0200a200e404
511b0200a200e404
2ad300005100e480
511b0200a200e404
2ad300005100e480
-
{e=>1,a=>0,d=>1,j=>83,c=>2,k=>7,h=>0,b=>1,g=>6,f=>5,i=>0}
8892020006005307
8892020006005307
8892020006005307
05134000c00053e0
8892020006005307
8892020006005307
05134000c00053e0
8892020006005307
05134000c00053e0
-
{e=>3,a=>7,d=>1,j=>-110,c=>2,k=>0,h=>0,b=>-3,g=>0,f=>4,i=>6}
af32020080019200
af32020080019200
af32020080019200
f517000003009200
af32020080019200
af32020080019200
f517000003009200
af32020080019200
f517000003009200
-
{e=>-4,a=>5,d=>6,j=>-88,c=>1,k=>7,h=>-3,b=>0,g=>5,f=>2,i=>2}
454c0100ad00a807
454c0100ad00a807
454c0100ad00a807
a0e88000b500a8e0
454c0100ad00a807
454c0100ad00a807
a0e88000b500a8e0
454c0100ad00a807
a0e88000b500a8e0
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
};
-
{e=>1,a=>1,d=>5,j=>101,l=>-3,c=>-4,k=>2,h=>-2,b=>3,g=>1,f=>1,i=>2}
199b0000b100652a
199b0000b100652a
199b0000b100652a
2e52400039006554
199b0000b100652a
199b0000b100652a
2e52400039006554
199b0000b100652a
2e52400039006554
-
{e=>1,a=>6,d=>2,j=>-74,l=>0,c=>-4,k=>2,h=>-2,b=>2,g=>2,f=>0,i=>4}
161500003201b602
161500003201b602
161500003201b602
ca2200005a00b640
161500003201b602
161500003201b602
ca2200005a00b640
161500003201b602
ca2200005a00b640
-
{e=>3,a=>7,d=>2,j=>30,l=>2,c=>3,k=>6,h=>0,b=>-4,g=>2,f=>7,i=>6}
e7b4030082011e16
e7b4030082011e16
e7b4030082011e16
f1a7c00043001ec8
e7b4030082011e16
e7b4030082011e16
f1a7c00043001ec8
e7b4030082011e16
f1a7c00043001ec8
-
{e=>-2,a=>7,d=>0,j=>-4,l=>-2,c=>-4,k=>5,h=>0,b=>0,g=>4,f=>7,i=>4}
07e103000401fc35
07e103000401fc35
07e103000401fc35
e20dc0008200fcb8
07e103000401fc35
07e103000401fc35
e20dc0008200fcb8
07e103000401fc35
e20dc0008200fcb8
-
{e=>2,a=>0,d=>6,j=>65,l=>1,c=>-3,k=>6,h=>-3,b=>-2,g=>3,f=>1,i=>6}
70ad0000ab01410e
70ad0000ab01410e
70ad0000ab01410e
1ae44000770041c4
70ad0000ab01410e
70ad0000ab01410e
1ae44000770041c4
70ad0000ab01410e
1ae44000770041c4
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
  unsigned int  m:3;
};
-
{e=>-4,a=>6,m=>1,d=>1,j=>55,l=>-2,c=>0,k=>7,h=>-2,b=>-4,g=>1,f=>0,i=>1}
264200007100373701000000
264200007100373701000000
264200007100373701000000
d0180000388037f820000000
264200007100373701000000
264200007100373701000000
d0180000388037f820000000
264200007100373701000000
d0180000388037f820000000
-
{e=>3,a=>1,m=>6,d=>6,j=>-117,l=>-4,c=>-1,k=>5,h=>-4,b=>0,g=>2,f=>6,i=>7}
c13d0300e2018b2506000000
c13d0300e2018b2506000000
c13d0300e2018b2506000000
23e7800053808bb0c0000000
c13d0300e2018b2506000000
c13d0300e2018b2506000000
23e7800053808bb0c0000000
c13d0300e2018b2506000000
23e7800053808bb0c0000000
-
{e=>2,a=>2,m=>4,d=>7,j=>-36,l=>3,c=>-1,k=>7,h=>3,b=>3,g=>3,f=>5,i=>5}
daaf02005b01dc1f04000000
daaf02005b01dc1f04000000
daaf02005b01dc1f04000000
4ff540006e80dcec80000000
daaf02005b01dc1f04000000
daaf02005b01dc1f04000000
4ff540006e80dcec80000000
daaf02005b01dc1f04000000
4ff540006e80dcec80000000
-
{e=>1,a=>0,m=>7,d=>6,j=>-99,l=>-1,c=>0,k=>7,h=>-4,b=>1,g=>0,f=>3,i=>1}
089c010060009d3f07000000
089c010060009d3f07000000
089c010060009d3f07000000
0462c00010809dfce0000000
089c010060009d3f07000000
089c010060009d3f07000000
0462c00010809dfce0000000
089c010060009d3f07000000
0462c00010809dfce0000000
-
{e=>1,a=>2,m=>1,d=>3,j=>57,l=>-1,c=>0,k=>5,h=>3,b=>-4,g=>4,f=>4,i=>6}
221602009c01393d01000000
221602009c01393d01000000
221602009c01393d01000000
503300008f0039bc20000000
221602009c01393d01000000
221602009c01393d01000000
503300008f0039bc20000000
221602009c01393d01000000
503300008f0039bc20000000
=
typedef int foo;

struct mixed_no_pack {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
  unsigned int  m:3;
  unsigned char n;
};
-
{e=>0,n=>177,a=>4,m=>2,d=>0,j=>-5,l=>-2,c=>3,k=>3,h=>-3,b=>0,g=>7,f=>7,i=>3}
c4800300ef00fb3302b10000
c4800300ef00fb3302b10000
c4800300ef00fb3302b10000
8181c000f580fb7840b10000
c4800300ef00fb3302b10000
c4800300ef00fb3302b10000
8181c000f580fb7840b10000
c4800300ef00fb3302b10000
8181c000f580fb7840b10000
-
{e=>-3,n=>5,a=>7,m=>4,d=>0,j=>90,l=>-1,c=>-1,k=>6,h=>-4,b=>3,g=>6,f=>3,i=>2}
dfd10100a6005a3e04050000
dfd10100a6005a3e04050000
dfd10100a6005a3e04050000
ef8ac000d1005adc80050000
dfd10100a6005a3e04050000
dfd10100a6005a3e04050000
ef8ac000d1005adc80050000
dfd10100a6005a3e04050000
ef8ac000d1005adc80050000
-
{e=>-2,n=>218,a=>6,m=>2,d=>3,j=>122,l=>-3,c=>0,k=>7,h=>-3,b=>-2,g=>0,f=>1,i=>0}
36e6000028007a2f02da0000
36e6000028007a2f02da0000
36e6000028007a2f02da0000
d83c400014007af440da0000
36e6000028007a2f02da0000
36e6000028007a2f02da0000
d83c400014007af440da0000
36e6000028007a2f02da0000
d83c400014007af440da0000
-
{e=>-2,n=>245,a=>5,m=>7,d=>2,j=>-67,l=>-1,c=>3,k=>0,h=>3,b=>-2,g=>3,f=>5,i=>0}
f5e402001b00bd3807f50000
f5e402001b00bd3807f50000
f5e402001b00bd3807f50000
b9ad40006c00bd1ce0f50000
f5e402001b00bd3807f50000
f5e402001b00bd3807f50000
b9ad40006c00bd1ce0f50000
f5e402001b00bd3807f50000
b9ad40006c00bd1ce0f50000
-
{e=>3,n=>3,a=>5,m=>6,d=>6,j=>-78,l=>3,c=>-1,k=>5,h=>2,b=>2,g=>4,f=>7,i=>5}
d5bd03005401b21d06030000
d5bd03005401b21d06030000
d5bd03005401b21d06030000
abe7c0008a80b2acc0030000
d5bd03005401b21d06030000
d5bd03005401b21d06030000
abe7c0008a80b2acc0030000
d5bd03005401b21d06030000
abe7c0008a80b2acc0030000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
};
-
{a=>13,b=>7}
0d070000
0d070000
0d070000
0de00000
0d070000
0d070000
0de00000
0d070000
0de00000
-
{a=>-33,b=>1}
df010000
df010000
df010000
df200000
df010000
df010000
df200000
df010000
df200000
-
{a=>-85,b=>1}
ab010000
ab010000
ab010000
ab200000
ab010000
ab010000
ab200000
ab010000
ab200000
-
{a=>58,b=>4}
3a040000
3a040000
3a040000
3a800000
3a040000
3a040000
3a800000
3a040000
3a800000
-
{a=>18,b=>6}
12060000
12060000
12060000
12c00000
12060000
12060000
12c00000
12060000
12c00000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>-4,a=>8,b=>7}
08270000
08270000
08270000
08f00000
08270000
08270000
08f00000
08270000
08f00000
-
{c=>2,a=>-98,b=>6}
9e160000
9e160000
9e160000
9ec80000
9e160000
9e160000
9ec80000
9e160000
9ec80000
-
{c=>-4,a=>-119,b=>6}
89260000
89260000
89260000
89d00000
89260000
89260000
89d00000
89260000
89d00000
-
{c=>3,a=>-114,b=>0}
8e180000
8e180000
8e180000
8e0c0000
8e180000
8e180000
8e0c0000
8e180000
8e0c0000
-
{c=>-4,a=>104,b=>7}
68270000
68270000
68270000
68f00000
68270000
68270000
68f00000
68270000
68f00000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>2,a=>90,b=>5,d=>-3}
5a550100
5a550100
5a550100
5aaa8000
5a550100
5a550100
5aaa8000
5a550100
5aaa8000
-
{c=>-3,a=>-24,b=>2,d=>-1}
e8ea0100
e8ea0100
e8ea0100
e8578000
e8ea0100
e8ea0100
e8578000
e8ea0100
e8578000
-
{c=>0,a=>-46,b=>4,d=>-4}
d2040100
d2040100
d2040100
d2820000
d2040100
d2040100
d2820000
d2040100
d2820000
-
{c=>1,a=>-95,b=>5,d=>-3}
a14d0100
a14d0100
a14d0100
a1a68000
a14d0100
a14d0100
a1a68000
a14d0100
a1a68000
-
{c=>3,a=>-50,b=>5,d=>-3}
ce5d0100
ce5d0100
ce5d0100
ceae8000
ce5d0100
ce5d0100
ceae8000
ce5d0100
ceae8000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>2,c=>3,a=>-67,b=>0,d=>-1}
bdd80500
bdd80500
bdd80500
bd0fa000
bdd80500
bdd80500
bd0fa000
bdd80500
bd0fa000
-
{e=>6,c=>0,a=>-85,b=>0,d=>3}
abc00c00
abc00c00
abc00c00
ab01e000
abc00c00
abc00c00
ab01e000
abc00c00
ab01e000
-
{e=>1,c=>-4,a=>27,b=>3,d=>3}
1be30200
1be30200
1be30200
1b719000
1be30200
1be30200
1b719000
1be30200
1b719000
-
{e=>3,c=>1,a=>-53,b=>7,d=>3}
cbcf0600
cbcf0600
cbcf0600
cbe5b000
cbcf0600
cbcf0600
cbe5b000
cbcf0600
cbe5b000
-
{e=>4,c=>3,a=>-28,b=>2,d=>-4}
e41a0900
e41a0900
e41a0900
e44e4000
e41a0900
e41a0900
e44e4000
e41a0900
e44e4000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>1,c=>-1,a=>54,b=>0,d=>-1,f=>-4}
36f84300
36f84300
36f84300
361f9800
36f84300
36f84300
361f9800
36f84300
361f9800
-
{e=>5,c=>-2,a=>43,b=>2,d=>-2,f=>-4}
2bb24b00
2bb24b00
2bb24b00
2b5b5800
2bb24b00
2bb24b00
2b5b5800
2bb24b00
2b5b5800
-
{e=>2,c=>-1,a=>57,b=>7,d=>0,f=>-3}
393f5400
393f5400
393f5400
39fc2a00
393f5400
393f5400
39fc2a00
393f5400
39fc2a00
-
{e=>2,c=>-4,a=>-86,b=>0,d=>-4,f=>2}
aa202500
aa202500
aa202500
aa122400
aa202500
aa202500
aa122400
aa202500
aa122400
-
{e=>5,c=>-4,a=>36,b=>6,d=>-2,f=>1}
24a61b00
24a61b00
24a61b00
24d35200
24a61b00
24a61b00
24d35200
24a61b00
24d35200
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>1,c=>-1,a=>-59,g=>1,b=>7,d=>-1,f=>1}
c5ff9300
c5ff9300
c5ff9300
c5ff9240
c5ff9300
c5ff9300
c5ff9240
c5ff9300
c5ff9240
-
{e=>0,c=>-3,a=>-42,g=>3,b=>3,d=>-1,f=>3}
d6ebb101
d6ebb101
d6ebb101
d67786c0
d6ebb101
d6ebb101
d67786c0
d6ebb101
d67786c0
-
{e=>1,c=>-3,a=>-91,g=>5,b=>1,d=>1,f=>2}
a569a202
a569a202
a569a202
a5349540
a569a202
a569a202
a5349540
a569a202
a5349540
-
{e=>3,c=>-2,a=>3,g=>0,b=>1,d=>0,f=>-1}
03317600
03317600
03317600
03383e00
03317600
03317600
03383e00
03317600
03383e00
-
{e=>1,c=>-2,a=>-94,g=>1,b=>0,d=>-1,f=>2}
a2f0a300
a2f0a300
a2f0a300
a21b9440
a2f0a300
a2f0a300
a21b9440
a2f0a300
a21b9440
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>3,c=>3,a=>-87,g=>4,b=>0,d=>2,f=>2}
a9982602
a9982602
a9982602
a90d3500
a9982602
a9982602
a90d3500
a9982602
a90d3500
-
{e=>3,c=>2,a=>-100,g=>0,b=>7,d=>-2,f=>-4}
9c974700
9c974700
9c974700
9ceb3800
9c974700
9c974700
9ceb3800
9c974700
9ceb3800
-
{e=>4,c=>3,a=>30,g=>4,b=>0,d=>3,f=>-3}
1ed85802
1ed85802
1ed85802
1e0dcb00
1ed85802
1ed85802
1e0dcb00
1ed85802
1e0dcb00
-
{e=>3,c=>3,a=>117,g=>7,b=>3,d=>-3,f=>1}
755b9703
755b9703
755b9703
756eb3c0
755b9703
755b9703
756eb3c0
755b9703
756eb3c0
-
{e=>4,c=>-2,a=>-117,g=>5,b=>2,d=>-1,f=>0}
8bf28902
8bf28902
8bf28902
8b5bc140
8bf28902
8bf28902
8b5bc140
8bf28902
8b5bc140
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>3,a=>5,d=>-4,c=>1,h=>7,b=>0,g=>0,f=>-1}
0508770007000000
0508770007000000
0508770007000000
05063e00e0000000
0508770007000000
0508770007000000
05063e00e0000000
0508770007000000
05063e00e0000000
-
{e=>5,a=>30,d=>-4,c=>3,h=>3,b=>7,g=>4,f=>-1}
1e1f7b0203000000
1e1f7b0203000000
1e1f7b0203000000
1eee5f0060000000
1e1f7b0203000000
1e1f7b0203000000
1eee5f0060000000
1e1f7b0203000000
1eee5f0060000000
-
{e=>7,a=>0,d=>-3,c=>1,h=>0,b=>7,g=>2,f=>-1}
004f7f0100000000
004f7f0100000000
004f7f0100000000
00e6fe8000000000
004f7f0100000000
004f7f0100000000
00e6fe8000000000
004f7f0100000000
00e6fe8000000000
-
{e=>0,a=>126,d=>-3,c=>0,h=>0,b=>2,g=>5,f=>-1}
7e42f10200000000
7e42f10200000000
7e42f10200000000
7e428f4000000000
7e42f10200000000
7e42f10200000000
7e428f4000000000
7e42f10200000000
7e428f4000000000
-
{e=>0,a=>4,d=>-1,c=>-3,h=>7,b=>2,g=>4,f=>3}
04ea310207000000
04ea310207000000
04ea310207000000
04578700e0000000
04ea310207000000
04ea310207000000
04578700e0000000
04ea310207000000
04578700e0000000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>2,a=>55,d=>-4,c=>-4,h=>0,b=>6,g=>4,f=>2,i=>-3}
3726250228000000
3726250228000000
3726250228000000
37d2250014000000
3726250228000000
3726250228000000
37d2250014000000
3726250228000000
37d2250014000000
-
{e=>5,a=>43,d=>1,c=>1,h=>1,b=>3,g=>7,f=>-3,i=>1}
2b4bda0309000000
2b4bda0309000000
2b4bda0309000000
2b64dbc024000000
2b4bda0309000000
2b4bda0309000000
2b64dbc024000000
2b4bda0309000000
2b64dbc024000000
-
{e=>2,a=>-68,d=>-4,c=>-1,h=>6,b=>2,g=>5,f=>-3,i=>-3}
bc3ad5022e000000
bc3ad5022e000000
bc3ad5022e000000
bc5e2b40d4000000
bc3ad5022e000000
bc3ad5022e000000
bc5e2b40d4000000
bc3ad5022e000000
bc5e2b40d4000000
-
{e=>3,a=>-9,d=>2,c=>-4,h=>6,b=>3,g=>7,f=>-3,i=>1}
f7a3d6030e000000
f7a3d6030e000000
f7a3d6030e000000
f7713bc0c4000000
f7a3d6030e000000
f7a3d6030e000000
f7713bc0c4000000
f7a3d6030e000000
f7713bc0c4000000
-
{e=>6,a=>-80,d=>1,c=>-2,h=>3,b=>1,g=>5,f=>3,i=>-3}
b071bc022b000000
b071bc022b000000
b071bc022b000000
b038e74074000000
b071bc022b000000
b071bc022b000000
b038e74074000000
b071bc022b000000
b038e74074000000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>5,a=>114,d=>-4,j=>4,c=>3,h=>6,b=>2,g=>0,f=>-4,i=>2}
721a4b0016010000
721a4b0016010000
721a4b0016010000
724e5800ca000000
721a4b0016010000
721a4b0016010000
724e5800ca000000
721a4b0016010000
724e5800ca000000
-
{e=>3,a=>-15,d=>-2,j=>6,c=>-1,h=>1,b=>0,g=>2,f=>2,i=>0}
f1b8270181010000
f1b8270181010000
f1b8270181010000
f11f348023000000
f1b8270181010000
f1b8270181010000
f11f348023000000
f1b8270181010000
f11f348023000000
-
{e=>6,a=>-68,d=>-2,j=>5,c=>-3,h=>1,b=>4,g=>0,f=>-1,i=>2}
bcac7d0051010000
bcac7d0051010000
bcac7d0051010000
bc976e002a800000
bcac7d0051010000
bcac7d0051010000
bc976e002a800000
bcac7d0051010000
bc976e002a800000
-
{e=>4,a=>-102,d=>0,j=>1,c=>1,h=>4,b=>1,g=>0,f=>1,i=>-3}
9a0918006c000000
9a0918006c000000
9a0918006c000000
9a24420094800000
9a0918006c000000
9a0918006c000000
9a24420094800000
9a0918006c000000
9a24420094800000
-
{e=>7,a=>-118,d=>-4,j=>3,c=>-2,h=>3,b=>3,g=>4,f=>1,i=>-1}
8a331f02fb000000
8a331f02fb000000
8a331f02fb000000
8a7a73007d800000
8a331f02fb000000
8a331f02fb000000
8a7a73007d800000
8a331f02fb000000
8a7a73007d800000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>4,a=>36,d=>-2,j=>7,c=>1,k=>-85,h=>7,b=>5,g=>7,f=>-4,i=>-3}
248dc903ef01ab00
248dc903ef01ab00
248dc903ef01ab00
24a749c0f780ab00
248dc903ef01ab00
248dc903ef01ab00
24a749c0f780ab00
248dc903ef01ab00
24a749c0f780ab00
-
{e=>2,a=>57,d=>2,j=>6,c=>0,k=>-127,h=>0,b=>5,g=>5,f=>1,i=>-1}
39859402b8018100
39859402b8018100
39859402b8018100
39a123401f008100
39859402b8018100
39859402b8018100
39a123401f008100
39859402b8018100
39a123401f008100
-
{e=>7,a=>-85,d=>1,j=>0,c=>-2,k=>-9,h=>1,b=>1,g=>4,f=>0,i=>-2}
ab710e023100f700
ab710e023100f700
ab710e023100f700
ab38f1003800f700
ab710e023100f700
ab710e023100f700
ab38f1003800f700
ab710e023100f700
ab38f1003800f700
-
{e=>6,a=>12,d=>3,j=>2,c=>-1,k=>-109,h=>0,b=>1,g=>1,f=>3,i=>-2}
0cf9bc00b0009300
0cf9bc00b0009300
0cf9bc00b0009300
0c3de64019009300
0cf9bc00b0009300
0cf9bc00b0009300
0c3de64019009300
0cf9bc00b0009300
0c3de64019009300
-
{e=>3,a=>-93,d=>-3,j=>3,c=>0,k=>38,h=>2,b=>4,g=>2,f=>-3,i=>-3}
a3445701ea002600
a3445701ea002600
a3445701ea002600
a382ba8055802600
a3445701ea002600
a3445701ea002600
a382ba8055802600
a3445701ea002600
a382ba8055802600
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>1,a=>-121,d=>0,j=>7,l=>7,c=>-2,k=>104,h=>5,b=>5,g=>2,f=>-1,i=>-1}
87357201fd016807
87357201fd016807
87357201fd016807
87b81e80bf8068e0
87357201fd016807
87357201fd016807
87b81e80bf8068e0
87357201fd016807
87b81e80bf8068e0
-
{e=>4,a=>-69,d=>0,j=>7,l=>3,c=>3,k=>116,h=>2,b=>5,g=>0,f=>2,i=>3}
bb1d2800da017403
bb1d2800da017403
bb1d2800da017403
bbac44004f807460
bb1d2800da017403
bb1d2800da017403
bbac44004f807460
bb1d2800da017403
bbac44004f807460
-
{e=>7,a=>-88,d=>3,j=>2,l=>6,c=>-2,k=>94,h=>0,b=>1,g=>0,f=>-2,i=>2}
a8f16e0090005e06
a8f16e0090005e06
a8f16e0090005e06
a839fc0009005ec0
a8f16e0090005e06
a8f16e0090005e06
a839fc0009005ec0
a8f16e0090005e06
a839fc0009005ec0
-
{e=>7,a=>41,d=>1,j=>2,l=>2,c=>-2,k=>-6,h=>1,b=>4,g=>1,f=>-3,i=>2}
2974de009100fa02
2974de009100fa02
2974de009100fa02
2998fa402900fa40
2974de009100fa02
2974de009100fa02
2998fa402900fa40
2974de009100fa02
2998fa402900fa40
-
{e=>1,a=>-123,d=>-2,j=>3,l=>7,c=>3,k=>82,h=>1,b=>6,g=>6,f=>0,i=>-3}
859e0303e9005207
859e0303e9005207
859e0303e9005207
85cf1180358052e0
859e0303e9005207
859e0303e9005207
85cf1180358052e0
859e0303e9005207
85cf1180358052e0
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>4,a=>-121,m=>2,d=>-2,j=>6,l=>3,c=>0,k=>-106,h=>5,b=>7,g=>4,f=>3,i=>2}
8787390295019613
8787390295019613
8787390295019613
87e34700ab009668
8787390295019613
8787390295019613
87e34700ab009668
8787390295019613
87e34700ab009668
-
{e=>7,a=>-56,m=>1,d=>-1,j=>2,l=>7,c=>3,k=>102,h=>6,b=>0,g=>6,f=>-4,i=>-3}
c8d84f03ae00660f
c8d84f03ae00660f
c8d84f03ae00660f
c80ff980d50066e4
c8d84f03ae00660f
c8d84f03ae00660f
c80ff980d50066e4
c8d84f03ae00660f
c80ff980d50066e4
-
{e=>3,a=>-72,m=>-4,d=>-1,j=>6,l=>2,c=>-1,k=>-50,h=>4,b=>2,g=>1,f=>1,i=>-3}
b8fa9700ac01ce22
b8fa9700ac01ce22
b8fa9700ac01ce22
b85fb2409700ce50
b8fa9700ac01ce22
b8fa9700ac01ce22
b85fb2409700ce50
b8fa9700ac01ce22
b85fb2409700ce50
-
{e=>5,a=>84,m=>-4,d=>-2,j=>4,l=>0,c=>1,k=>-79,h=>5,b=>6,g=>1,f=>3,i=>1}
548ebb000d01b120
548ebb000d01b120
548ebb000d01b120
54c75640a600b110
548ebb000d01b120
548ebb000d01b120
54c75640a600b110
548ebb000d01b120
54c75640a600b110
-
{e=>6,a=>-18,m=>-2,d=>-4,j=>7,l=>4,c=>-1,k=>-2,h=>1,b=>1,g=>4,f=>3,i=>-3}
ee393d02e901fe34
ee393d02e901fe34
ee393d02e901fe34
ee3e67003780fe98
ee393d02e901fe34
ee393d02e901fe34
ee3e67003780fe98
ee393d02e901fe34
ee3e67003780fe98
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>5,n=>6,a=>-112,m=>3,d=>-1,j=>2,l=>0,c=>-3,k=>39,h=>4,b=>6,g=>4,f=>3,i=>2}
90ee3b029400271806000000
90ee3b029400271806000000
90ee3b029400271806000000
90d7d7008900270cc0000000
90ee3b029400271806000000
90ee3b029400271806000000
90d7d7008900270cc0000000
90ee3b029400271806000000
90d7d7008900270cc0000000
-
{e=>1,n=>2,a=>93,m=>-2,d=>2,j=>5,l=>5,c=>2,k=>-95,h=>1,b=>6,g=>0,f=>-1,i=>-3}
5d9672006901a13502000000
5d9672006901a13502000000
5d9672006901a13502000000
5dc91e003680a1b840000000
5d9672006901a13502000000
5d9672006901a13502000000
5dc91e003680a1b840000000
5d9672006901a13502000000
5dc91e003680a1b840000000
-
{e=>2,n=>1,a=>55,m=>2,d=>-2,j=>0,l=>0,c=>-2,k=>-97,h=>1,b=>7,g=>1,f=>3,i=>3}
37b7b50019009f1001000000
37b7b50019009f1001000000
37b7b50019009f1001000000
37fb26402c009f0820000000
37b7b50019009f1001000000
37b7b50019009f1001000000
37fb26402c009f0820000000
37b7b50019009f1001000000
37fb26402c009f0820000000
-
{e=>6,n=>2,a=>2,m=>2,d=>0,j=>7,l=>5,c=>-1,k=>-32,h=>7,b=>0,g=>5,f=>-2,i=>2}
0238ec02d701e01502000000
0238ec02d701e01502000000
0238ec02d701e01502000000
021c6d40eb80e0a840000000
0238ec02d701e01502000000
0238ec02d701e01502000000
021c6d40eb80e0a840000000
0238ec02d701e01502000000
021c6d40eb80e0a840000000
-
{e=>1,n=>2,a=>-65,m=>0,d=>-3,j=>5,l=>6,c=>-1,k=>10,h=>2,b=>2,g=>3,f=>-4,i=>2}
bf7ac30152010a0602000000
bf7ac30152010a0602000000
bf7ac30152010a0602000000
bf5e98c04a800ac040000000
bf7ac30152010a0602000000
bf7ac30152010a0602000000
bf5e98c04a800ac040000000
bf7ac30152010a0602000000
bf5e98c04a800ac040000000
=
typedef int foo;

struct mixed_no_pack {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>4,n=>4,a=>96,m=>-1,d=>-4,j=>2,l=>1,c=>-2,k=>-106,h=>1,b=>4,g=>2,f=>-2,o=>172,i=>3}
603469019900963904ac0000
603469019900963904ac0000
603469019900963904ac0000
609a4c802d00963c80ac0000
603469019900963904ac0000
603469019900963904ac0000
609a4c802d00963c80ac0000
603469019900963904ac0000
609a4c802d00963c80ac0000
-
{e=>3,n=>3,a=>-103,m=>-2,d=>-1,j=>6,l=>2,c=>-3,k=>-23,h=>7,b=>7,g=>4,f=>-3,o=>204,i=>0}
99ef57028701e93203cc0000
99ef57028701e93203cc0000
99ef57028701e93203cc0000
99f7bb00e300e95860cc0000
99ef57028701e93203cc0000
99ef57028701e93203cc0000
99f7bb00e300e95860cc0000
99ef57028701e93203cc0000
99f7bb00e300e95860cc0000
-
{e=>7,n=>2,a=>-104,m=>3,d=>2,j=>7,l=>5,c=>2,k=>49,h=>2,b=>0,g=>0,f=>3,o=>143,i=>0}
98903e00c201311d028f0000
98903e00c201311d028f0000
98903e00c201311d028f0000
98097600438031ac408f0000
98903e00c201311d028f0000
98903e00c201311d028f0000
98097600438031ac408f0000
98903e00c201311d028f0000
98097600438031ac408f0000
-
{e=>7,n=>0,a=>-12,m=>1,d=>2,j=>3,l=>2,c=>3,k=>73,h=>6,b=>0,g=>3,f=>-2,o=>165,i=>-3}
f498ee01ee00490a00a50000
f498ee01ee00490a00a50000
f498ee01ee00490a00a50000
f40d7cc0d580494400a50000
f498ee01ee00490a00a50000
f498ee01ee00490a00a50000
f40d7cc0d580494400a50000
f498ee01ee00490a00a50000
f40d7cc0d580494400a50000
-
{e=>2,n=>6,a=>-124,m=>-3,d=>-3,j=>1,l=>3,c=>-4,k=>109,h=>1,b=>5,g=>0,f=>-2,o=>55,i=>-3}
8465650069006d2b06370000
8465650069006d2b06370000
8465650069006d2b06370000
84b2ac0034806d74c0370000
8465650069006d2b06370000
8465650069006d2b06370000
84b2ac0034806d74c0370000
8465650069006d2b06370000
84b2ac0034806d74c0370000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
};
-
{a=>92,b=>1}
5c000100
5c000100
5c000100
005c2000
5c000100
5c000100
005c2000
5c000100
005c2000
-
{a=>51,b=>4}
33000400
33000400
33000400
00338000
33000400
33000400
00338000
33000400
00338000
-
{a=>-66,b=>3}
beff0300
beff0300
beff0300
ffbe6000
beff0300
beff0300
ffbe6000
beff0300
ffbe6000
-
{a=>-113,b=>2}
8fff0200
8fff0200
8fff0200
ff8f4000
8fff0200
8fff0200
ff8f4000
8fff0200
ff8f4000
-
{a=>10,b=>0}
0a000000
0a000000
0a000000
000a0000
0a000000
0a000000
000a0000
0a000000
000a0000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>0,a=>-103,b=>5}
99ff0500
99ff0500
99ff0500
ff99a000
99ff0500
99ff0500
ff99a000
99ff0500
ff99a000
-
{c=>0,a=>-75,b=>2}
b5ff0200
b5ff0200
b5ff0200
ffb54000
b5ff0200
b5ff0200
ffb54000
b5ff0200
ffb54000
-
{c=>-4,a=>-81,b=>3}
afff2300
afff2300
afff2300
ffaf7000
afff2300
afff2300
ffaf7000
afff2300
ffaf7000
-
{c=>-2,a=>14,b=>7}
0e003700
0e003700
0e003700
000ef800
0e003700
0e003700
000ef800
0e003700
000ef800
-
{c=>0,a=>94,b=>1}
5e000100
5e000100
5e000100
005e2000
5e000100
5e000100
005e2000
5e000100
005e2000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>-1,a=>-100,b=>5,d=>1}
9cff7d00
9cff7d00
9cff7d00
ff9cbc80
9cff7d00
9cff7d00
ff9cbc80
9cff7d00
ff9cbc80
-
{c=>3,a=>107,b=>2,d=>-4}
6b001a01
6b001a01
6b001a01
006b4e00
6b001a01
6b001a01
006b4e00
6b001a01
006b4e00
-
{c=>1,a=>-24,b=>1,d=>1}
e8ff4900
e8ff4900
e8ff4900
ffe82480
e8ff4900
e8ff4900
ffe82480
e8ff4900
ffe82480
-
{c=>-2,a=>-62,b=>0,d=>2}
c2ffb000
c2ffb000
c2ffb000
ffc21900
c2ffb000
c2ffb000
ffc21900
c2ffb000
ffc21900
-
{c=>0,a=>-40,b=>6,d=>-1}
d8ffc601
d8ffc601
d8ffc601
ffd8c380
d8ffc601
d8ffc601
ffd8c380
d8ffc601
ffd8c380
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>4,c=>-4,a=>-8,b=>5,d=>3}
f8ffe508
f8ffe508
f8ffe508
fff8b1c0
f8ffe508
f8ffe508
fff8b1c0
f8ffe508
fff8b1c0
-
{e=>4,c=>-3,a=>-46,b=>4,d=>2}
d2ffac08
d2ffac08
d2ffac08
ffd29540
d2ffac08
d2ffac08
ffd29540
d2ffac08
ffd29540
-
{e=>2,c=>0,a=>-15,b=>0,d=>-2}
f1ff8005
f1ff8005
f1ff8005
fff10320
f1ff8005
f1ff8005
fff10320
f1ff8005
fff10320
-
{e=>6,c=>3,a=>97,b=>1,d=>-1}
6100d90d
6100d90d
6100d90d
00612fe0
6100d90d
6100d90d
00612fe0
6100d90d
00612fe0
-
{e=>5,c=>1,a=>86,b=>2,d=>-1}
5600ca0b
5600ca0b
5600ca0b
005647d0
5600ca0b
5600ca0b
005647d0
5600ca0b
005647d0
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>2,c=>-4,a=>-30,b=>0,d=>2,f=>-4}
e2ffa044
e2ffa044
e2ffa044
ffe21128
e2ffa044
e2ffa044
ffe21128
e2ffa044
ffe21128
-
{e=>3,c=>-2,a=>58,b=>7,d=>3,f=>-2}
3a00f766
3a00f766
3a00f766
003af9bc
3a00f766
3a00f766
003af9bc
3a00f766
003af9bc
-
{e=>3,c=>2,a=>-93,b=>0,d=>1,f=>2}
a3ff5026
a3ff5026
a3ff5026
ffa308b4
a3ff5026
a3ff5026
ffa308b4
a3ff5026
ffa308b4
-
{e=>2,c=>3,a=>17,b=>1,d=>-3,f=>2}
11005925
11005925
11005925
00112ea4
11005925
11005925
00112ea4
11005925
00112ea4
-
{e=>3,c=>2,a=>-36,b=>3,d=>-1,f=>1}
dcffd317
dcffd317
dcffd317
ffdc6bb2
dcffd317
dcffd317
ffdc6bb2
dcffd317
ffdc6bb2
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>6,c=>3,a=>-5,g=>1,b=>4,d=>-4,f=>-4}
fbff1c4d01000000
fbff1c4d01000000
fbff1c4d01000000
fffb8e6820000000
fbff1c4d01000000
fbff1c4d01000000
fffb8e6820000000
fbff1c4d01000000
fffb8e6820000000
-
{e=>1,c=>0,a=>5,g=>5,b=>6,d=>-1,f=>-3}
0500c65305000000
0500c65305000000
0500c65305000000
0005c39aa0000000
0500c65305000000
0500c65305000000
0005c39aa0000000
0500c65305000000
0005c39aa0000000
-
{e=>5,c=>-3,a=>94,g=>6,b=>0,d=>-1,f=>2}
5e00e82b06000000
5e00e82b06000000
5e00e82b06000000
005e17d4c0000000
5e00e82b06000000
5e00e82b06000000
005e17d4c0000000
5e00e82b06000000
005e17d4c0000000
-
{e=>5,c=>-3,a=>-86,g=>4,b=>3,d=>2,f=>2}
aaffab2a04000000
aaffab2a04000000
aaffab2a04000000
ffaa755480000000
aaffab2a04000000
aaffab2a04000000
ffaa755480000000
aaffab2a04000000
ffaa755480000000
-
{e=>6,c=>0,a=>-114,g=>6,b=>6,d=>-3,f=>-4}
8eff464d06000000
8eff464d06000000
8eff464d06000000
ff8ec2e8c0000000
8eff464d06000000
8eff464d06000000
ff8ec2e8c0000000
8eff464d06000000
ff8ec2e8c0000000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>7,c=>-1,a=>-26,g=>4,b=>2,d=>-1,f=>-2}
e6fffa6f04000000
e6fffa6f04000000
e6fffa6f04000000
ffe65ffc80000000
e6fffa6f04000000
e6fffa6f04000000
ffe65ffc80000000
e6fffa6f04000000
ffe65ffc80000000
-
{e=>3,c=>-3,a=>-39,g=>5,b=>5,d=>2,f=>3}
d9ffad3605000000
d9ffad3605000000
d9ffad3605000000
ffd9b536a0000000
d9ffad3605000000
d9ffad3605000000
ffd9b536a0000000
d9ffad3605000000
ffd9b536a0000000
-
{e=>2,c=>-1,a=>-108,g=>4,b=>7,d=>1,f=>0}
94ff7f0404000000
94ff7f0404000000
94ff7f0404000000
ff94fca080000000
94ff7f0404000000
94ff7f0404000000
ff94fca080000000
94ff7f0404000000
ff94fca080000000
-
{e=>1,c=>3,a=>36,g=>7,b=>4,d=>1,f=>-4}
24005c4207000000
24005c4207000000
24005c4207000000
00248c98e0000000
24005c4207000000
24005c4207000000
00248c98e0000000
24005c4207000000
00248c98e0000000
-
{e=>0,c=>1,a=>-70,g=>2,b=>0,d=>-3,f=>0}
baff480102000000
baff480102000000
baff480102000000
ffba068040000000
baff480102000000
baff480102000000
ffba068040000000
baff480102000000
ffba068040000000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>1,a=>-73,d=>3,c=>-4,h=>3,b=>3,g=>5,f=>-2}
b7ffe3620500000003000000
b7ffe3620500000003000000
b7ffe3620500000003000000
ffb7719ca000000060000000
b7ffe3620500000003000000
b7ffe3620500000003000000
ffb7719ca000000060000000
b7ffe3620500000003000000
ffb7719ca000000060000000
-
{e=>2,a=>106,d=>3,c=>-1,h=>4,b=>0,g=>6,f=>-2}
6a00f8640600000004000000
6a00f8640600000004000000
6a00f8640600000004000000
006a1dacc000000080000000
6a00f8640600000004000000
6a00f8640600000004000000
006a1dacc000000080000000
6a00f8640600000004000000
006a1dacc000000080000000
-
{e=>2,a=>-78,d=>3,c=>3,h=>6,b=>0,g=>0,f=>-1}
b2ffd8740000000006000000
b2ffd8740000000006000000
b2ffd8740000000006000000
ffb20dae00000000c0000000
b2ffd8740000000006000000
b2ffd8740000000006000000
ffb20dae00000000c0000000
b2ffd8740000000006000000
ffb20dae00000000c0000000
-
{e=>4,a=>-84,d=>-2,c=>3,h=>4,b=>3,g=>5,f=>-3}
acff9b590500000004000000
acff9b590500000004000000
acff9b590500000004000000
ffac6f4aa000000080000000
acff9b590500000004000000
acff9b590500000004000000
ffac6f4aa000000080000000
acff9b590500000004000000
ffac6f4aa000000080000000
-
{e=>7,a=>-108,d=>1,c=>-4,h=>2,b=>4,g=>5,f=>-4}
94ff644e0500000002000000
94ff644e0500000002000000
94ff644e0500000002000000
ff9490f8a000000040000000
94ff644e0500000002000000
94ff644e0500000002000000
ff9490f8a000000040000000
94ff644e0500000002000000
ff9490f8a000000040000000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>4,a=>113,d=>3,c=>2,h=>4,b=>1,g=>6,f=>2,i=>3}
7100d128060000001c000000
7100d128060000001c000000
7100d128060000001c000000
007129c4c00000008c000000
7100d128060000001c000000
7100d128060000001c000000
007129c4c00000008c000000
7100d128060000001c000000
007129c4c00000008c000000
-
{e=>7,a=>83,d=>-1,c=>3,h=>0,b=>0,g=>4,f=>-3,i=>-2}
5300d85f0400000030000000
5300d85f0400000030000000
5300d85f0400000030000000
00530ffa8000000018000000
5300d85f0400000030000000
5300d85f0400000030000000
00530ffa8000000018000000
5300d85f0400000030000000
00530ffa8000000018000000
-
{e=>2,a=>-34,d=>3,c=>-4,h=>4,b=>4,g=>0,f=>1,i=>-3}
deffe414000000002c000000
deffe414000000002c000000
deffe414000000002c000000
ffde91a20000000094000000
deffe414000000002c000000
deffe414000000002c000000
ffde91a20000000094000000
deffe414000000002c000000
ffde91a20000000094000000
-
{e=>1,a=>87,d=>1,c=>0,h=>1,b=>7,g=>0,f=>1,i=>-1}
570047120000000039000000
570047120000000039000000
570047120000000039000000
0057e092000000003c000000
570047120000000039000000
570047120000000039000000
0057e092000000003c000000
570047120000000039000000
0057e092000000003c000000
-
{e=>1,a=>-63,d=>3,c=>-1,h=>2,b=>1,g=>6,f=>1,i=>-3}
c1fff912060000002a000000
c1fff912060000002a000000
c1fff912060000002a000000
ffc13d92c000000054000000
c1fff912060000002a000000
c1fff912060000002a000000
ffc13d92c000000054000000
c1fff912060000002a000000
ffc13d92c000000054000000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>0,a=>-8,d=>3,j=>1,c=>-3,h=>0,b=>1,g=>7,f=>3,i=>2}
f8ffe9300700000050000000
f8ffe9300700000050000000
f8ffe9300700000050000000
fff83586e000000008800000
f8ffe9300700000050000000
f8ffe9300700000050000000
fff83586e000000008800000
f8ffe9300700000050000000
fff83586e000000008800000
-
{e=>1,a=>-18,d=>-3,j=>7,c=>-4,h=>4,b=>2,g=>0,f=>3,i=>-2}
eeff623300000000f4010000
eeff623300000000f4010000
eeff623300000000f4010000
ffee5296000000009b800000
eeff623300000000f4010000
eeff623300000000f4010000
ffee5296000000009b800000
eeff623300000000f4010000
ffee5296000000009b800000
-
{e=>7,a=>-19,d=>0,j=>4,c=>2,h=>1,b=>3,g=>3,f=>-4,i=>3}
edff134e0300000019010000
edff134e0300000019010000
edff134e0300000019010000
ffed6878600000002e000000
edff134e0300000019010000
edff134e0300000019010000
ffed6878600000002e000000
edff134e0300000019010000
ffed6878600000002e000000
-
{e=>4,a=>43,d=>-3,j=>6,c=>-4,h=>4,b=>0,g=>5,f=>3,i=>-3}
2b00603905000000ac010000
2b00603905000000ac010000
2b00603905000000ac010000
002b12c6a000000097000000
2b00603905000000ac010000
2b00603905000000ac010000
002b12c6a000000097000000
2b00603905000000ac010000
002b12c6a000000097000000
-
{e=>3,a=>-3,d=>0,j=>5,c=>1,h=>7,b=>6,g=>0,f=>2,i=>1}
fdff0e26000000004f010000
fdff0e26000000004f010000
fdff0e26000000004f010000
fffdc43400000000e6800000
fdff0e26000000004f010000
fdff0e26000000004f010000
fffdc43400000000e6800000
fdff0e26000000004f010000
fffdc43400000000e6800000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>1,a=>29,d=>-1,j=>7,c=>-3,k=>-108,h=>1,b=>7,g=>6,f=>2,i=>-1}
1d00ef2306000000f9019400
1d00ef2306000000f9019400
1d00ef2306000000f9019400
001df794c00000003f809400
1d00ef2306000000f9019400
1d00ef2306000000f9019400
001df794c00000003f809400
1d00ef2306000000f9019400
001df794c00000003f809400
-
{e=>3,a=>48,d=>1,j=>5,c=>1,k=>-74,h=>0,b=>5,g=>7,f=>-2,i=>-2}
30004d66070000007001b600
30004d66070000007001b600
30004d66070000007001b600
0030a4bce00000001a80b600
30004d66070000007001b600
30004d66070000007001b600
0030a4bce00000001a80b600
30004d66070000007001b600
0030a4bce00000001a80b600
-
{e=>7,a=>-122,d=>2,j=>0,c=>-3,k=>14,h=>2,b=>1,g=>4,f=>-4,i=>0}
86ffa94e0400000002000e00
86ffa94e0400000002000e00
86ffa94e0400000002000e00
ff8635788000000040000e00
86ffa94e0400000002000e00
86ffa94e0400000002000e00
ff8635788000000040000e00
86ffa94e0400000002000e00
ff8635788000000040000e00
-
{e=>5,a=>-32,d=>-4,j=>2,c=>3,k=>-91,h=>7,b=>0,g=>3,f=>0,i=>2}
e0ff180b030000009700a500
e0ff180b030000009700a500
e0ff180b030000009700a500
ffe00e5060000000e900a500
e0ff180b030000009700a500
e0ff180b030000009700a500
ffe00e5060000000e900a500
e0ff180b030000009700a500
ffe00e5060000000e900a500
-
{e=>4,a=>-6,d=>2,j=>0,c=>-4,k=>-31,h=>6,b=>7,g=>4,f=>1,i=>0}
faffa718040000000600e100
faffa718040000000600e100
faffa718040000000600e100
fffaf14280000000c000e100
faffa718040000000600e100
faffa718040000000600e100
fffaf14280000000c000e100
faffa718040000000600e100
fffaf14280000000c000e100
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>1,a=>100,d=>-3,j=>2,l=>1,c=>-3,k=>17,h=>3,b=>6,g=>3,f=>3,i=>3}
64006e33030000009b001101
64006e33030000009b001101
64006e33030000009b001101
0064d696600000006d001120
64006e33030000009b001101
64006e33030000009b001101
0064d696600000006d001120
64006e33030000009b001101
0064d696600000006d001120
-
{e=>3,a=>46,d=>-4,j=>5,l=>3,c=>1,k=>-95,h=>7,b=>4,g=>7,f=>0,i=>1}
2e000c07070000004f01a103
2e000c07070000004f01a103
2e000c07070000004f01a103
002e8630e0000000e680a160
2e000c07070000004f01a103
2e000c07070000004f01a103
002e8630e0000000e680a160
2e000c07070000004f01a103
002e8630e0000000e680a160
-
{e=>3,a=>-72,d=>0,j=>6,l=>7,c=>-2,k=>41,h=>2,b=>2,g=>2,f=>2,i=>-3}
b8ff322602000000aa012907
b8ff322602000000aa012907
b8ff322602000000aa012907
ffb8583440000000570029e0
b8ff322602000000aa012907
b8ff322602000000aa012907
ffb8583440000000570029e0
b8ff322602000000aa012907
ffb8583440000000570029e0
-
{e=>5,a=>84,d=>-1,j=>6,l=>5,c=>2,k=>95,h=>3,b=>4,g=>4,f=>2,i=>-4}
5400d42b04000000a3015f05
5400d42b04000000a3015f05
5400d42b04000000a3015f05
00548bd48000000073005fa0
5400d42b04000000a3015f05
5400d42b04000000a3015f05
00548bd48000000073005fa0
5400d42b04000000a3015f05
00548bd48000000073005fa0
-
{e=>1,a=>13,d=>-2,j=>3,l=>0,c=>-3,k=>-14,h=>2,b=>5,g=>0,f=>1,i=>-4}
0d00ad1300000000e200f200
0d00ad1300000000e200f200
0d00ad1300000000e200f200
000db712000000005180f200
0d00ad1300000000e200f200
0d00ad1300000000e200f200
000db712000000005180f200
0d00ad1300000000e200f200
000db712000000005180f200
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>7,a=>-88,m=>2,d=>0,j=>2,l=>5,c=>0,k=>96,h=>5,b=>0,g=>7,f=>2,i=>3}
a8ff002e070000009d006015
a8ff002e070000009d006015
a8ff002e070000009d006015
ffa80074e0000000ad0060a8
a8ff002e070000009d006015
a8ff002e070000009d006015
ffa80074e0000000ad0060a8
a8ff002e070000009d006015
ffa80074e0000000ad0060a8
-
{e=>2,a=>-64,m=>1,d=>-2,j=>2,l=>0,c=>0,k=>83,h=>6,b=>7,g=>5,f=>-3,i=>1}
c0ff8755050000008e005308
c0ff8755050000008e005308
c0ff8755050000008e005308
ffc0e32aa0000000c5005304
c0ff8755050000008e005308
c0ff8755050000008e005308
ffc0e32aa0000000c5005304
c0ff8755050000008e005308
ffc0e32aa0000000c5005304
-
{e=>1,a=>50,m=>3,d=>0,j=>6,l=>6,c=>-4,k=>20,h=>4,b=>1,g=>7,f=>0,i=>-2}
3200210207000000b401141e
3200210207000000b401141e
3200210207000000b401141e
00323010e00000009b0014cc
3200210207000000b401141e
3200210207000000b401141e
00323010e00000009b0014cc
3200210207000000b401141e
00323010e00000009b0014cc
-
{e=>3,a=>-2,m=>1,d=>-1,j=>4,l=>0,c=>-1,k=>106,h=>4,b=>2,g=>6,f=>-3,i=>0}
fefffa570600000004016a08
fefffa570600000004016a08
fefffa570600000004016a08
fffe5fbac000000082006a04
fefffa570600000004016a08
fefffa570600000004016a08
fffe5fbac000000082006a04
fefffa570600000004016a08
fffe5fbac000000082006a04
-
{e=>3,a=>126,m=>2,d=>-4,j=>7,l=>2,c=>-4,k=>-75,h=>0,b=>2,g=>7,f=>-3,i=>-2}
7e00225707000000f001b512
7e00225707000000f001b512
7e00225707000000f001b512
007e523ae00000001b80b548
7e00225707000000f001b512
7e00225707000000f001b512
007e523ae00000001b80b548
7e00225707000000f001b512
007e523ae00000001b80b548
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>0,n=>3,a=>114,m=>2,d=>1,j=>4,l=>2,c=>0,k=>-114,h=>1,b=>5,g=>1,f=>1,i=>2}
720045100100000011018e1203000000
720045100100000011018e1203000000
720045100100000011018e1203000000
0072a082200000002a008e4860000000
720045100100000011018e1203000000
720045100100000011018e1203000000
0072a082200000002a008e4860000000
720045100100000011018e1203000000
0072a082200000002a008e4860000000
-
{e=>0,n=>2,a=>11,m=>1,d=>-2,j=>4,l=>7,c=>-4,k=>-117,h=>6,b=>1,g=>5,f=>1,i=>3}
0b00a111050000001e018b0f02000000
0b00a111050000001e018b0f02000000
0b00a111050000001e018b0f02000000
000b3302a0000000ce008be440000000
0b00a111050000001e018b0f02000000
0b00a111050000001e018b0f02000000
000b3302a0000000ce008be440000000
0b00a111050000001e018b0f02000000
000b3302a0000000ce008be440000000
-
{e=>5,n=>4,a=>8,m=>0,d=>2,j=>7,l=>3,c=>3,k=>71,h=>7,b=>2,g=>4,f=>-4,i=>2}
08009a4a04000000d701470304000000
08009a4a04000000d701470304000000
08009a4a04000000d701470304000000
00084d5880000000eb80476080000000
08009a4a04000000d701470304000000
08009a4a04000000d701470304000000
00084d5880000000eb80476080000000
08009a4a04000000d701470304000000
00084d5880000000eb80476080000000
-
{e=>4,n=>5,a=>25,m=>1,d=>2,j=>3,l=>7,c=>-1,k=>-69,h=>4,b=>5,g=>6,f=>1,i=>-1}
1900bd1806000000fc00bb0f05000000
1900bd1806000000fc00bb0f05000000
1900bd1806000000fc00bb0f05000000
0019bd42c00000009d80bbe4a0000000
1900bd1806000000fc00bb0f05000000
1900bd1806000000fc00bb0f05000000
0019bd42c00000009d80bbe4a0000000
1900bd1806000000fc00bb0f05000000
0019bd42c00000009d80bbe4a0000000
-
{e=>1,n=>3,a=>71,m=>3,d=>-1,j=>0,l=>0,c=>-2,k=>28,h=>1,b=>7,g=>3,f=>0,i=>1}
4700f7030300000009001c1803000000
4700f7030300000009001c1803000000
4700f7030300000009001c1803000000
0047fb906000000024001c0c60000000
4700f7030300000009001c1803000000
4700f7030300000009001c1803000000
0047fb906000000024001c0c60000000
4700f7030300000009001c1803000000
0047fb906000000024001c0c60000000
=
typedef int foo;

struct mixed_no_pack {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>2,n=>2,a=>-53,m=>-1,d=>2,j=>2,l=>6,c=>-3,k=>-55,h=>7,b=>3,g=>6,f=>3,o=>97,i=>-4}
cbffab3406000000a700c93e02610000
cbffab3406000000a700c93e02610000
cbffab3406000000a700c93e02610000
ffcb7526c0000000f100c9dc40610000
cbffab3406000000a700c93e02610000
cbffab3406000000a700c93e02610000
ffcb7526c0000000f100c9dc40610000
cbffab3406000000a700c93e02610000
ffcb7526c0000000f100c9dc40610000
-
{e=>0,n=>6,a=>-59,m=>1,d=>0,j=>6,l=>4,c=>0,k=>75,h=>2,b=>6,g=>7,f=>3,o=>144,i=>2}
c5ff06300700000092014b0c06900000
c5ff06300700000092014b0c06900000
c5ff06300700000092014b0c06900000
ffc5c006e00000004b004b84c0900000
c5ff06300700000092014b0c06900000
c5ff06300700000092014b0c06900000
ffc5c006e00000004b004b84c0900000
c5ff06300700000092014b0c06900000
ffc5c006e00000004b004b84c0900000
-
{e=>1,n=>1,a=>66,m=>2,d=>-3,j=>0,l=>3,c=>1,k=>103,h=>4,b=>3,g=>7,f=>-1,o=>216,i=>-2}
42004b73070000003400671301d80000
42004b73070000003400671301d80000
42004b73070000003400671301d80000
0042669ee00000009800676820d80000
42004b73070000003400671301d80000
42004b73070000003400671301d80000
0042669ee00000009800676820d80000
42004b73070000003400671301d80000
0042669ee00000009800676820d80000
-
{e=>2,n=>1,a=>-81,m=>-1,d=>3,j=>0,l=>3,c=>-2,k=>98,h=>2,b=>1,g=>3,f=>-2,o=>209,i=>-3}
affff164030000002a00623b01d10000
affff164030000002a00623b01d10000
affff164030000002a00623b01d10000
ffaf39ac600000005400627c20d10000
affff164030000002a00623b01d10000
affff164030000002a00623b01d10000
ffaf39ac600000005400627c20d10000
affff164030000002a00623b01d10000
ffaf39ac600000005400627c20d10000
-
{e=>1,n=>5,a=>-91,m=>-1,d=>-1,j=>3,l=>5,c=>-1,k=>-46,h=>2,b=>4,g=>6,f=>-2,o=>161,i=>-3}
a5fffc6306000000ea00d23d05a10000
a5fffc6306000000ea00d23d05a10000
a5fffc6306000000ea00d23d05a10000
ffa59f9cc00000005580d2bca0a10000
a5fffc6306000000ea00d23d05a10000
a5fffc6306000000ea00d23d05a10000
ffa59f9cc00000005580d2bca0a10000
a5fffc6306000000ea00d23d05a10000
ffa59f9cc00000005580d2bca0a10000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
};
-
{a=>55,b=>2}
3700000002000000
3700000002000000
3700000002000000
0000003740000000
3700000002000000
3700000002000000
0000003740000000
3700000002000000
0000003740000000
-
{a=>62,b=>5}
3e00000005000000
3e00000005000000
3e00000005000000
0000003ea0000000
3e00000005000000
3e00000005000000
0000003ea0000000
3e00000005000000
0000003ea0000000
-
{a=>127,b=>2}
7f00000002000000
7f00000002000000
7f00000002000000
0000007f40000000
7f00000002000000
7f00000002000000
0000007f40000000
7f00000002000000
0000007f40000000
-
{a=>-95,b=>4}
a1ffffff04000000
a1ffffff04000000
a1ffffff04000000
ffffffa180000000
a1ffffff04000000
a1ffffff04000000
ffffffa180000000
a1ffffff04000000
ffffffa180000000
-
{a=>-58,b=>4}
c6ffffff04000000
c6ffffff04000000
c6ffffff04000000
ffffffc680000000
c6ffffff04000000
c6ffffff04000000
ffffffc680000000
c6ffffff04000000
ffffffc680000000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>1,a=>-70,b=>7}
baffffff0f000000
baffffff0f000000
baffffff0f000000
ffffffbae4000000
baffffff0f000000
baffffff0f000000
ffffffbae4000000
baffffff0f000000
ffffffbae4000000
-
{c=>0,a=>-56,b=>5}
c8ffffff05000000
c8ffffff05000000
c8ffffff05000000
ffffffc8a0000000
c8ffffff05000000
c8ffffff05000000
ffffffc8a0000000
c8ffffff05000000
ffffffc8a0000000
-
{c=>-2,a=>-48,b=>2}
d0ffffff32000000
d0ffffff32000000
d0ffffff32000000
ffffffd058000000
d0ffffff32000000
d0ffffff32000000
ffffffd058000000
d0ffffff32000000
ffffffd058000000
-
{c=>1,a=>31,b=>2}
1f0000000a000000
1f0000000a000000
1f0000000a000000
0000001f44000000
1f0000000a000000
1f0000000a000000
0000001f44000000
1f0000000a000000
0000001f44000000
-
{c=>3,a=>120,b=>2}
780000001a000000
780000001a000000
780000001a000000
000000784c000000
780000001a000000
780000001a000000
000000784c000000
780000001a000000
000000784c000000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>-4,a=>-120,b=>6,d=>0}
88ffffff26000000
88ffffff26000000
88ffffff26000000
ffffff88d0000000
88ffffff26000000
88ffffff26000000
ffffff88d0000000
88ffffff26000000
ffffff88d0000000
-
{c=>0,a=>118,b=>7,d=>3}
76000000c7000000
76000000c7000000
76000000c7000000
00000076e1800000
76000000c7000000
76000000c7000000
00000076e1800000
76000000c7000000
00000076e1800000
-
{c=>-2,a=>-76,b=>5,d=>2}
b4ffffffb5000000
b4ffffffb5000000
b4ffffffb5000000
ffffffb4b9000000
b4ffffffb5000000
b4ffffffb5000000
ffffffb4b9000000
b4ffffffb5000000
ffffffb4b9000000
-
{c=>3,a=>-39,b=>6,d=>3}
d9ffffffde000000
d9ffffffde000000
d9ffffffde000000
ffffffd9cd800000
d9ffffffde000000
d9ffffffde000000
ffffffd9cd800000
d9ffffffde000000
ffffffd9cd800000
-
{c=>-3,a=>9,b=>5,d=>1}
090000006d000000
090000006d000000
090000006d000000
00000009b4800000
090000006d000000
090000006d000000
00000009b4800000
090000006d000000
00000009b4800000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>3,c=>3,a=>-74,b=>2,d=>3}
b6ffffffda060000
b6ffffffda060000
b6ffffffda060000
ffffffb64db00000
b6ffffffda060000
b6ffffffda060000
ffffffb64db00000
b6ffffffda060000
ffffffb64db00000
-
{e=>4,c=>2,a=>16,b=>7,d=>2}
1000000097080000
1000000097080000
1000000097080000
00000010e9400000
1000000097080000
1000000097080000
00000010e9400000
1000000097080000
00000010e9400000
-
{e=>2,c=>0,a=>48,b=>5,d=>-3}
3000000045050000
3000000045050000
3000000045050000
00000030a2a00000
3000000045050000
3000000045050000
00000030a2a00000
3000000045050000
00000030a2a00000
-
{e=>5,c=>2,a=>77,b=>3,d=>1}
4d000000530a0000
4d000000530a0000
4d000000530a0000
0000004d68d00000
4d000000530a0000
4d000000530a0000
0000004d68d00000
4d000000530a0000
0000004d68d00000
-
{e=>0,c=>-2,a=>78,b=>5,d=>1}
4e00000075000000
4e00000075000000
4e00000075000000
0000004eb8800000
4e00000075000000
4e00000075000000
0000004eb8800000
4e00000075000000
0000004eb8800000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>1,c=>2,a=>80,b=>4,d=>1,f=>0}
5000000054020000
5000000054020000
5000000054020000
0000005088900000
5000000054020000
5000000054020000
0000005088900000
5000000054020000
0000005088900000
-
{e=>6,c=>2,a=>-27,b=>4,d=>3,f=>-4}
e5ffffffd44c0000
e5ffffffd44c0000
e5ffffffd44c0000
ffffffe589e80000
e5ffffffd44c0000
e5ffffffd44c0000
ffffffe589e80000
e5ffffffd44c0000
ffffffe589e80000
-
{e=>0,c=>2,a=>-111,b=>5,d=>3,f=>-4}
91ffffffd5400000
91ffffffd5400000
91ffffffd5400000
ffffff91a9880000
91ffffffd5400000
91ffffffd5400000
ffffff91a9880000
91ffffffd5400000
ffffff91a9880000
-
{e=>7,c=>1,a=>-42,b=>7,d=>1,f=>3}
d6ffffff4f3e0000
d6ffffff4f3e0000
d6ffffff4f3e0000
ffffffd6e4f60000
d6ffffff4f3e0000
d6ffffff4f3e0000
ffffffd6e4f60000
d6ffffff4f3e0000
ffffffd6e4f60000
-
{e=>5,c=>0,a=>90,b=>4,d=>0,f=>0}
5a000000040a0000
5a000000040a0000
5a000000040a0000
0000005a80500000
5a000000040a0000
5a000000040a0000
0000005a80500000
5a000000040a0000
0000005a80500000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>3,c=>0,a=>0,g=>3,b=>3,d=>1,f=>-3}
0000000043d60100
0000000043d60100
0000000043d60100
0000000060bac000
0000000043d60100
0000000043d60100
0000000060bac000
0000000043d60100
0000000060bac000
-
{e=>3,c=>-4,a=>-62,g=>6,b=>1,d=>-3,f=>1}
c2ffffff61170300
c2ffffff61170300
c2ffffff61170300
ffffffc232b38000
c2ffffff61170300
c2ffffff61170300
ffffffc232b38000
c2ffffff61170300
ffffffc232b38000
-
{e=>2,c=>-3,a=>26,g=>5,b=>3,d=>0,f=>-4}
1a0000002bc40200
1a0000002bc40200
1a0000002bc40200
0000001a74294000
1a0000002bc40200
1a0000002bc40200
0000001a74294000
1a0000002bc40200
0000001a74294000
-
{e=>3,c=>3,a=>-96,g=>7,b=>7,d=>-3,f=>3}
a0ffffff5fb70300
a0ffffff5fb70300
a0ffffff5fb70300
ffffffa0eeb7c000
a0ffffff5fb70300
a0ffffff5fb70300
ffffffa0eeb7c000
a0ffffff5fb70300
ffffffa0eeb7c000
-
{e=>6,c=>2,a=>-81,g=>5,b=>1,d=>-1,f=>3}
afffffffd1bd0200
afffffffd1bd0200
afffffffd1bd0200
ffffffaf2be74000
afffffffd1bd0200
afffffffd1bd0200
ffffffaf2be74000
afffffffd1bd0200
ffffffaf2be74000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>4,c=>2,a=>21,g=>1,b=>4,d=>-4,f=>3}
1500000014b90000
1500000014b90000
1500000014b90000
000000158a464000
1500000014b90000
1500000014b90000
000000158a464000
1500000014b90000
000000158a464000
-
{e=>3,c=>-4,a=>82,g=>4,b=>5,d=>3,f=>1}
52000000e5160200
52000000e5160200
52000000e5160200
00000052b1b30000
52000000e5160200
52000000e5160200
00000052b1b30000
52000000e5160200
00000052b1b30000
-
{e=>2,c=>-3,a=>28,g=>5,b=>2,d=>0,f=>-4}
1c0000002ac40200
1c0000002ac40200
1c0000002ac40200
0000001c54294000
1c0000002ac40200
1c0000002ac40200
0000001c54294000
1c0000002ac40200
0000001c54294000
-
{e=>4,c=>2,a=>116,g=>2,b=>3,d=>-2,f=>0}
7400000093090100
7400000093090100
7400000093090100
000000746b408000
7400000093090100
7400000093090100
000000746b408000
7400000093090100
000000746b408000
-
{e=>5,c=>-2,a=>77,g=>7,b=>6,d=>-1,f=>3}
4d000000f6bb0300
4d000000f6bb0300
4d000000f6bb0300
0000004ddbd7c000
4d000000f6bb0300
4d000000f6bb0300
0000004ddbd7c000
4d000000f6bb0300
0000004ddbd7c000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>6,a=>-106,d=>0,c=>-3,h=>5,b=>4,g=>2,f=>0}
96ffffff2c0c010005000000
96ffffff2c0c010005000000
96ffffff2c0c010005000000
ffffff9694608000a0000000
96ffffff2c0c010005000000
96ffffff2c0c010005000000
ffffff9694608000a0000000
96ffffff2c0c010005000000
ffffff9694608000a0000000
-
{e=>2,a=>41,d=>-3,c=>-3,h=>1,b=>0,g=>7,f=>-4}
2900000068c5030001000000
2900000068c5030001000000
2900000068c5030001000000
0000002916a9c00020000000
2900000068c5030001000000
2900000068c5030001000000
0000002916a9c00020000000
2900000068c5030001000000
0000002916a9c00020000000
-
{e=>7,a=>-97,d=>2,c=>2,h=>5,b=>3,g=>1,f=>-3}
9fffffff93de000005000000
9fffffff93de000005000000
9fffffff93de000005000000
ffffff9f697a4000a0000000
9fffffff93de000005000000
9fffffff93de000005000000
ffffff9f697a4000a0000000
9fffffff93de000005000000
ffffff9f697a4000a0000000
-
{e=>2,a=>-90,d=>-1,c=>-4,h=>4,b=>0,g=>0,f=>3}
a6ffffffe035000004000000
a6ffffffe035000004000000
a6ffffffe035000004000000
ffffffa613a6000080000000
a6ffffffe035000004000000
a6ffffffe035000004000000
ffffffa613a6000080000000
a6ffffffe035000004000000
ffffffa613a6000080000000
-
{e=>6,a=>106,d=>-3,c=>2,h=>7,b=>7,g=>4,f=>-3}
6a000000575d020007000000
6a000000575d020007000000
6a000000575d020007000000
0000006aeaeb0000e0000000
6a000000575d020007000000
6a000000575d020007000000
0000006aeaeb0000e0000000
6a000000575d020007000000
0000006aeaeb0000e0000000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>6,a=>-65,d=>-4,c=>-4,h=>6,b=>0,g=>5,f=>3,i=>-4}
bfffffff20bd020026000000
bfffffff20bd020026000000
bfffffff20bd020026000000
ffffffbf12674000d0000000
bfffffff20bd020026000000
bfffffff20bd020026000000
ffffffbf12674000d0000000
bfffffff20bd020026000000
ffffffbf12674000d0000000
-
{e=>5,a=>-32,d=>-2,c=>1,h=>1,b=>6,g=>1,f=>0,i=>1}
e0ffffff8e8b000009000000
e0ffffff8e8b000009000000
e0ffffff8e8b000009000000
ffffffe0c750400024000000
e0ffffff8e8b000009000000
e0ffffff8e8b000009000000
ffffffe0c750400024000000
e0ffffff8e8b000009000000
ffffffe0c750400024000000
-
{e=>5,a=>-95,d=>-3,c=>2,h=>7,b=>5,g=>2,f=>3,i=>-3}
a1ffffff553b01002f000000
a1ffffff553b01002f000000
a1ffffff553b01002f000000
ffffffa1aad68000f4000000
a1ffffff553b01002f000000
a1ffffff553b01002f000000
ffffffa1aad68000f4000000
a1ffffff553b01002f000000
ffffffa1aad68000f4000000
-
{e=>3,a=>-22,d=>-1,c=>-1,h=>6,b=>6,g=>7,f=>-4,i=>-3}
eafffffffec703002e000000
eafffffffec703002e000000
eafffffffec703002e000000
ffffffeadfb9c000d4000000
eafffffffec703002e000000
eafffffffec703002e000000
ffffffeadfb9c000d4000000
eafffffffec703002e000000
ffffffeadfb9c000d4000000
-
{e=>6,a=>-103,d=>-1,c=>0,h=>2,b=>2,g=>7,f=>-2,i=>-4}
99ffffffc2ed030022000000
99ffffffc2ed030022000000
99ffffffc2ed030022000000
ffffff9943edc00050000000
99ffffffc2ed030022000000
99ffffffc2ed030022000000
ffffff9943edc00050000000
99ffffffc2ed030022000000
ffffff9943edc00050000000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>7,a=>87,d=>-2,j=>7,c=>-2,h=>2,b=>2,g=>2,f=>-2,i=>2}
57000000b26f0100d2010000
57000000b26f0100d2010000
57000000b26f0100d2010000
000000575b7c80004b800000
57000000b26f0100d2010000
57000000b26f0100d2010000
000000575b7c80004b800000
57000000b26f0100d2010000
000000575b7c80004b800000
-
{e=>3,a=>-126,d=>-4,j=>4,c=>0,h=>0,b=>6,g=>1,f=>-2,i=>-4}
82ffffff06e7000020010000
82ffffff06e7000020010000
82ffffff06e7000020010000
ffffff82c23c400012000000
82ffffff06e7000020010000
82ffffff06e7000020010000
ffffff82c23c400012000000
82ffffff06e7000020010000
ffffff82c23c400012000000
-
{e=>5,a=>90,d=>0,j=>7,c=>3,h=>0,b=>5,g=>6,f=>-1,i=>-1}
5a0000001d7a0300f8010000
5a0000001d7a0300f8010000
5a0000001d7a0300f8010000
0000005aac5f80001f800000
5a0000001d7a0300f8010000
5a0000001d7a0300f8010000
0000005aac5f80001f800000
5a0000001d7a0300f8010000
0000005aac5f80001f800000
-
{e=>6,a=>-47,d=>1,j=>3,c=>1,h=>4,b=>7,g=>7,f=>3,i=>-1}
d1ffffff4fbc0300fc000000
d1ffffff4fbc0300fc000000
d1ffffff4fbc0300fc000000
ffffffd1e4e7c0009d800000
d1ffffff4fbc0300fc000000
d1ffffff4fbc0300fc000000
ffffffd1e4e7c0009d800000
d1ffffff4fbc0300fc000000
ffffffd1e4e7c0009d800000
-
{e=>6,a=>47,d=>2,j=>7,c=>1,h=>4,b=>6,g=>1,f=>0,i=>-4}
2f0000008e8c0000e4010000
2f0000008e8c0000e4010000
2f0000008e8c0000e4010000
0000002fc560400093800000
2f0000008e8c0000e4010000
2f0000008e8c0000e4010000
0000002fc560400093800000
2f0000008e8c0000e4010000
0000002fc560400093800000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>4,a=>-69,d=>1,j=>5,c=>-2,k=>-25,h=>4,b=>3,g=>1,f=>3,i=>1}
bbffffff73b800004c01e700
bbffffff73b800004c01e700
bbffffff73b800004c01e700
ffffffbb78c640008680e700
bbffffff73b800004c01e700
bbffffff73b800004c01e700
ffffffbb78c640008680e700
bbffffff73b800004c01e700
ffffffbb78c640008680e700
-
{e=>1,a=>116,d=>0,j=>4,c=>2,k=>45,h=>6,b=>3,g=>3,f=>-2,i=>3}
7400000013e201001e012d00
7400000013e201001e012d00
7400000013e201001e012d00
00000074681cc000ce002d00
7400000013e201001e012d00
7400000013e201001e012d00
00000074681cc000ce002d00
7400000013e201001e012d00
00000074681cc000ce002d00
-
{e=>3,a=>-113,d=>1,j=>1,c=>0,k=>-27,h=>5,b=>5,g=>6,f=>-3,i=>-2}
8fffffff455603007500e500
8fffffff455603007500e500
8fffffff455603007500e500
ffffff8fa0bb8000b880e500
8fffffff455603007500e500
8fffffff455603007500e500
ffffff8fa0bb8000b880e500
8fffffff455603007500e500
ffffff8fa0bb8000b880e500
-
{e=>3,a=>49,d=>3,j=>2,c=>-2,k=>3,h=>1,b=>0,g=>2,f=>2,i=>2}
31000000f026010091000300
31000000f026010091000300
31000000f026010091000300
0000003119b4800029000300
31000000f026010091000300
31000000f026010091000300
0000003119b4800029000300
31000000f026010091000300
0000003119b4800029000300
-
{e=>0,a=>105,d=>-1,j=>3,c=>-3,k=>-114,h=>6,b=>5,g=>7,f=>-2,i=>3}
69000000ede10300de008e00
69000000ede10300de008e00
69000000ede10300de008e00
00000069b78dc000cd808e00
69000000ede10300de008e00
69000000ede10300de008e00
00000069b78dc000cd808e00
69000000ede10300de008e00
00000069b78dc000cd808e00
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>4,a=>-33,d=>-3,j=>2,l=>4,c=>2,k=>-127,h=>2,b=>1,g=>3,f=>0,i=>3}
dfffffff518901009a008104
dfffffff518901009a008104
dfffffff518901009a008104
ffffffdf2ac0c0004d008180
dfffffff518901009a008104
dfffffff518901009a008104
ffffffdf2ac0c0004d008180
dfffffff518901009a008104
ffffffdf2ac0c0004d008180
-
{e=>1,a=>30,d=>0,j=>3,l=>5,c=>-2,k=>-10,h=>5,b=>0,g=>3,f=>2,i=>-2}
1e00000030a20100f500f605
1e00000030a20100f500f605
1e00000030a20100f500f605
0000001e1814c000b980f6a0
1e00000030a20100f500f605
1e00000030a20100f500f605
0000001e1814c000b980f6a0
1e00000030a20100f500f605
0000001e1814c000b980f6a0
-
{e=>0,a=>87,d=>-1,j=>5,l=>6,c=>-2,k=>-45,h=>2,b=>7,g=>1,f=>3,i=>-2}
57000000f7b100007201d306
57000000f7b100007201d306
57000000f7b100007201d306
00000057fb8640005a80d3c0
57000000f7b100007201d306
57000000f7b100007201d306
00000057fb8640005a80d3c0
57000000f7b100007201d306
00000057fb8640005a80d3c0
-
{e=>1,a=>-27,d=>2,j=>3,l=>0,c=>1,k=>36,h=>0,b=>0,g=>5,f=>0,i=>-1}
e5ffffff88820200f8002400
e5ffffff88820200f8002400
e5ffffff88820200f8002400
ffffffe5051140001d802400
e5ffffff88820200f8002400
e5ffffff88820200f8002400
ffffffe5051140001d802400
e5ffffff88820200f8002400
ffffffe5051140001d802400
-
{e=>7,a=>38,d=>2,j=>1,l=>5,c=>-2,k=>37,h=>5,b=>5,g=>5,f=>1,i=>-1}
26000000b59e02007d002505
26000000b59e02007d002505
26000000b59e02007d002505
00000026b9734000bc8025a0
26000000b59e02007d002505
26000000b59e02007d002505
00000026b9734000bc8025a0
26000000b59e02007d002505
00000026b9734000bc8025a0
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>4,a=>-77,m=>-1,d=>-4,j=>3,l=>6,c=>0,k=>2,h=>7,b=>7,g=>3,f=>1,i=>1}
b3ffffff07990100cf00023e
b3ffffff07990100cf00023e
b3ffffff07990100cf00023e
ffffffb3e242c000e58002dc
b3ffffff07990100cf00023e
b3ffffff07990100cf00023e
ffffffb3e242c000e58002dc
b3ffffff07990100cf00023e
ffffffb3e242c000e58002dc
-
{e=>6,a=>-85,m=>-1,d=>0,j=>6,l=>2,c=>2,k=>121,h=>4,b=>0,g=>5,f=>-4,i=>3}
abffffff10cc02009c01793a
abffffff10cc02009c01793a
abffffff10cc02009c01793a
ffffffab086940008f00795c
abffffff10cc02009c01793a
abffffff10cc02009c01793a
ffffffab086940008f00795c
abffffff10cc02009c01793a
ffffffab086940008f00795c
-
{e=>0,a=>63,m=>-1,d=>3,j=>3,l=>1,c=>-1,k=>54,h=>5,b=>0,g=>0,f=>1,i=>-4}
3f000000f8100000e5003639
3f000000f8100000e5003639
3f000000f8100000e5003639
0000003f1d820000b180363c
3f000000f8100000e5003639
3f000000f8100000e5003639
0000003f1d820000b180363c
3f000000f8100000e5003639
0000003f1d820000b180363c
-
{e=>5,a=>3,m=>-4,d=>1,j=>0,l=>5,c=>-3,k=>-15,h=>4,b=>6,g=>2,f=>1,i=>1}
030000006e1a01000c00f125
030000006e1a01000c00f125
030000006e1a01000c00f125
00000003d4d280008400f1b0
030000006e1a01000c00f125
030000006e1a01000c00f125
00000003d4d280008400f1b0
030000006e1a01000c00f125
00000003d4d280008400f1b0
-
{e=>1,a=>93,m=>0,d=>3,j=>0,l=>2,c=>0,k=>57,h=>6,b=>0,g=>4,f=>-1,i=>2}
5d000000c072020016003902
5d000000c072020016003902
5d000000c072020016003902
0000005d019f0000c8003940
5d000000c072020016003902
5d000000c072020016003902
0000005d019f0000c8003940
5d000000c072020016003902
0000005d019f0000c8003940
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>6,n=>5,a=>93,m=>1,d=>1,j=>3,l=>1,c=>-2,k=>115,h=>3,b=>0,g=>2,f=>1,i=>1}
5d000000701c0100cb00730905000000
5d000000701c0100cb00730905000000
5d000000701c0100cb00730905000000
0000005d18e2800065807324a0000000
5d000000701c0100cb00730905000000
5d000000701c0100cb00730905000000
0000005d18e2800065807324a0000000
5d000000701c0100cb00730905000000
0000005d18e2800065807324a0000000
-
{e=>7,n=>6,a=>-112,m=>1,d=>-2,j=>2,l=>1,c=>-1,k=>66,h=>1,b=>5,g=>3,f=>-4,i=>3}
90ffffffbdcf01009900420906000000
90ffffffbdcf01009900420906000000
90ffffffbdcf01009900420906000000
ffffff90bf78c0002d004224c0000000
90ffffffbdcf01009900420906000000
90ffffffbdcf01009900420906000000
ffffff90bf78c0002d004224c0000000
90ffffffbdcf01009900420906000000
ffffff90bf78c0002d004224c0000000
-
{e=>7,n=>1,a=>102,m=>3,d=>3,j=>3,l=>6,c=>1,k=>-50,h=>5,b=>6,g=>7,f=>1,i=>1}
66000000ce9e0300cd00ce1e01000000
66000000ce9e0300cd00ce1e01000000
66000000ce9e0300cd00ce1e01000000
00000066c5f3c000a580cecc20000000
66000000ce9e0300cd00ce1e01000000
66000000ce9e0300cd00ce1e01000000
00000066c5f3c000a580cecc20000000
66000000ce9e0300cd00ce1e01000000
00000066c5f3c000a580cecc20000000
-
{e=>3,n=>6,a=>-108,m=>1,d=>-4,j=>4,l=>4,c=>-3,k=>85,h=>3,b=>7,g=>7,f=>-1,i=>1}
94ffffff2ff703000b01550c06000000
94ffffff2ff703000b01550c06000000
94ffffff2ff703000b01550c06000000
ffffff94f63fc00066005584c0000000
94ffffff2ff703000b01550c06000000
94ffffff2ff703000b01550c06000000
ffffff94f63fc00066005584c0000000
94ffffff2ff703000b01550c06000000
ffffff94f63fc00066005584c0000000
-
{e=>3,n=>5,a=>103,m=>1,d=>-3,j=>3,l=>2,c=>0,k=>103,h=>3,b=>4,g=>1,f=>1,i=>0}
6700000044970000c300670a05000000
6700000044970000c300670a05000000
6700000044970000c300670a05000000
0000006782b2400061806744a0000000
6700000044970000c300670a05000000
6700000044970000c300670a05000000
0000006782b2400061806744a0000000
6700000044970000c300670a05000000
0000006782b2400061806744a0000000
=
typedef int foo;

struct mixed_no_pack {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>6,n=>5,a=>-4,m=>-2,d=>-1,j=>4,l=>2,c=>-1,k=>-4,h=>5,b=>5,g=>2,f=>-2,o=>251,i=>1}
fcfffffffd6d01000d01fc3205fb0000
fcfffffffd6d01000d01fc3205fb0000
fcfffffffd6d01000d01fc3205fb0000
fffffffcbfec8000a600fc58a0fb0000
fcfffffffd6d01000d01fc3205fb0000
fcfffffffd6d01000d01fc3205fb0000
fffffffcbfec8000a600fc58a0fb0000
fcfffffffd6d01000d01fc3205fb0000
fffffffcbfec8000a600fc58a0fb0000
-
{e=>5,n=>7,a=>100,m=>-4,d=>-4,j=>4,l=>2,c=>0,k=>-86,h=>1,b=>5,g=>0,f=>2,o=>180,i=>-2}
64000000052b00003101aa2207b40000
64000000052b00003101aa2207b40000
64000000052b00003101aa2207b40000
00000064a25400003a00aa50e0b40000
64000000052b00003101aa2207b40000
64000000052b00003101aa2207b40000
00000064a25400003a00aa50e0b40000
64000000052b00003101aa2207b40000
00000064a25400003a00aa50e0b40000
-
{e=>6,n=>7,a=>-56,m=>-2,d=>-3,j=>5,l=>0,c=>-3,k=>122,h=>4,b=>7,g=>2,f=>1,o=>254,i=>0}
c8ffffff6f1d010044017a3007fe0000
c8ffffff6f1d010044017a3007fe0000
c8ffffff6f1d010044017a3007fe0000
ffffffc8f6e2800082807a18e0fe0000
c8ffffff6f1d010044017a3007fe0000
c8ffffff6f1d010044017a3007fe0000
ffffffc8f6e2800082807a18e0fe0000
c8ffffff6f1d010044017a3007fe0000
ffffffc8f6e2800082807a18e0fe0000
-
{e=>1,n=>5,a=>-64,m=>-2,d=>1,j=>0,l=>1,c=>-3,k=>77,h=>7,b=>1,g=>4,f=>-1,o=>3,i=>-2}
c0ffffff6972020037004d3105030000
c0ffffff6972020037004d3105030000
c0ffffff6972020037004d3105030000
ffffffc0349f0000f8004d38a0030000
c0ffffff6972020037004d3105030000
c0ffffff6972020037004d3105030000
ffffffc0349f0000f8004d38a0030000
c0ffffff6972020037004d3105030000
ffffffc0349f0000f8004d38a0030000
-
{e=>5,n=>6,a=>-59,m=>-3,d=>0,j=>4,l=>3,c=>-3,k=>47,h=>3,b=>7,g=>0,f=>0,o=>16,i=>2}
c5ffffff2f0a000013012f2b06100000
c5ffffff2f0a000013012f2b06100000
c5ffffff2f0a000013012f2b06100000
ffffffc5f45000006a002f74c0100000
c5ffffff2f0a000013012f2b06100000
c5ffffff2f0a000013012f2b06100000
ffffffc5f45000006a002f74c0100000
c5ffffff2f0a000013012f2b06100000
ffffffc5f45000006a002f74c0100000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
};
-
{a=>-106,b=>7}
96ffffff07000000
96ffffffffffffff0700000000000000
96ffffffffffffff0700000000000000
ffffff96e0000000
96ffffff07000000
96ffffff07000000
ffffffffffffff96e000000000000000
96ffffff07000000
ffffff96e0000000
-
{a=>-127,b=>2}
81ffffff02000000
81ffffffffffffff0200000000000000
81ffffffffffffff0200000000000000
ffffff8140000000
81ffffff02000000
81ffffff02000000
ffffffffffffff814000000000000000
81ffffff02000000
ffffff8140000000
-
{a=>-66,b=>6}
beffffff06000000
beffffffffffffff0600000000000000
beffffffffffffff0600000000000000
ffffffbec0000000
beffffff06000000
beffffff06000000
ffffffffffffffbec000000000000000
beffffff06000000
ffffffbec0000000
-
{a=>49,b=>6}
3100000006000000
31000000000000000600000000000000
31000000000000000600000000000000
00000031c0000000
3100000006000000
3100000006000000
0000000000000031c000000000000000
3100000006000000
00000031c0000000
-
{a=>107,b=>7}
6b00000007000000
6b000000000000000700000000000000
6b000000000000000700000000000000
0000006be0000000
6b00000007000000
6b00000007000000
000000000000006be000000000000000
6b00000007000000
0000006be0000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>0,a=>-18,b=>6}
eeffffff06000000
eeffffffffffffff0600000000000000
eeffffffffffffff0600000000000000
ffffffeec0000000
eeffffff06000000
eeffffff06000000
ffffffffffffffeec000000000000000
eeffffff06000000
ffffffeec0000000
-
{c=>-3,a=>-10,b=>6}
f6ffffff2e000000
f6ffffffffffffff2e00000000000000
f6ffffffffffffff2e00000000000000
fffffff6d4000000
f6ffffff2e000000
f6ffffff2e000000
fffffffffffffff6d400000000000000
f6ffffff2e000000
fffffff6d4000000
-
{c=>2,a=>40,b=>4}
2800000014000000
28000000000000001400000000000000
28000000000000001400000000000000
0000002888000000
2800000014000000
2800000014000000
00000000000000288800000000000000
2800000014000000
0000002888000000
-
{c=>-2,a=>-97,b=>3}
9fffffff33000000
9fffffffffffffff3300000000000000
9fffffffffffffff3300000000000000
ffffff9f78000000
9fffffff33000000
9fffffff33000000
ffffffffffffff9f7800000000000000
9fffffff33000000
ffffff9f78000000
-
{c=>0,a=>-24,b=>3}
e8ffffff03000000
e8ffffffffffffff0300000000000000
e8ffffffffffffff0300000000000000
ffffffe860000000
e8ffffff03000000
e8ffffff03000000
ffffffffffffffe86000000000000000
e8ffffff03000000
ffffffe860000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>2,a=>-99,b=>5,d=>-3}
9dffffff55010000
9dffffffffffffff5501000000000000
9dffffffffffffff5501000000000000
ffffff9daa800000
9dffffff55010000
9dffffff55010000
ffffffffffffff9daa80000000000000
9dffffff55010000
ffffff9daa800000
-
{c=>-3,a=>102,b=>4,d=>1}
660000006c000000
66000000000000006c00000000000000
66000000000000006c00000000000000
0000006694800000
660000006c000000
660000006c000000
00000000000000669480000000000000
660000006c000000
0000006694800000
-
{c=>-4,a=>108,b=>1,d=>2}
6c000000a1000000
6c00000000000000a100000000000000
6c00000000000000a100000000000000
0000006c31000000
6c000000a1000000
6c000000a1000000
000000000000006c3100000000000000
6c000000a1000000
0000006c31000000
-
{c=>1,a=>-81,b=>6,d=>3}
afffffffce000000
afffffffffffffffce00000000000000
afffffffffffffffce00000000000000
ffffffafc5800000
afffffffce000000
afffffffce000000
ffffffffffffffafc580000000000000
afffffffce000000
ffffffafc5800000
-
{c=>2,a=>-53,b=>2,d=>2}
cbffffff92000000
cbffffffffffffff9200000000000000
cbffffffffffffff9200000000000000
ffffffcb49000000
cbffffff92000000
cbffffff92000000
ffffffffffffffcb4900000000000000
cbffffff92000000
ffffffcb49000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>2,c=>2,a=>62,b=>7,d=>0}
3e00000017040000
3e000000000000001704000000000000
3e000000000000001704000000000000
0000003ee8200000
3e00000017040000
3e00000017040000
000000000000003ee820000000000000
3e00000017040000
0000003ee8200000
-
{e=>0,c=>1,a=>-91,b=>7,d=>1}
a5ffffff4f000000
a5ffffffffffffff4f00000000000000
a5ffffffffffffff4f00000000000000
ffffffa5e4800000
a5ffffff4f000000
a5ffffff4f000000
ffffffffffffffa5e480000000000000
a5ffffff4f000000
ffffffa5e4800000
-
{e=>3,c=>-1,a=>50,b=>3,d=>0}
320000003b060000
32000000000000003b06000000000000
32000000000000003b06000000000000
000000327c300000
320000003b060000
320000003b060000
00000000000000327c30000000000000
320000003b060000
000000327c300000
-
{e=>2,c=>-1,a=>-68,b=>2,d=>2}
bcffffffba040000
bcffffffffffffffba04000000000000
bcffffffffffffffba04000000000000
ffffffbc5d200000
bcffffffba040000
bcffffffba040000
ffffffffffffffbc5d20000000000000
bcffffffba040000
ffffffbc5d200000
-
{e=>5,c=>2,a=>67,b=>4,d=>1}
43000000540a0000
4300000000000000540a000000000000
4300000000000000540a000000000000
0000004388d00000
43000000540a0000
43000000540a0000
000000000000004388d0000000000000
43000000540a0000
0000004388d00000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>1,c=>3,a=>-33,b=>2,d=>-3,f=>-3}
dfffffff5a530000
dfffffffffffffff5a53000000000000
dfffffffffffffff5a53000000000000
ffffffdf4e9a0000
dfffffff5a530000
dfffffff5a530000
ffffffffffffffdf4e9a000000000000
dfffffff5a530000
ffffffdf4e9a0000
-
{e=>6,c=>-4,a=>-3,b=>1,d=>-3,f=>1}
fdffffff611d0000
fdffffffffffffff611d000000000000
fdffffffffffffff611d000000000000
fffffffd32e20000
fdffffff611d0000
fdffffff611d0000
fffffffffffffffd32e2000000000000
fdffffff611d0000
fffffffd32e20000
-
{e=>5,c=>-2,a=>-125,b=>1,d=>-3,f=>-3}
83ffffff715b0000
83ffffffffffffff715b000000000000
83ffffffffffffff715b000000000000
ffffff833ada0000
83ffffff715b0000
83ffffff715b0000
ffffffffffffff833ada000000000000
83ffffff715b0000
ffffff833ada0000
-
{e=>7,c=>-2,a=>101,b=>3,d=>-2,f=>-1}
65000000b37f0000
6500000000000000b37f000000000000
6500000000000000b37f000000000000
000000657b7e0000
65000000b37f0000
65000000b37f0000
00000000000000657b7e000000000000
65000000b37f0000
000000657b7e0000
-
{e=>1,c=>-2,a=>71,b=>4,d=>3,f=>2}
47000000f4220000
4700000000000000f422000000000000
4700000000000000f422000000000000
0000004799940000
47000000f4220000
47000000f4220000
00000000000000479994000000000000
47000000f4220000
0000004799940000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>5,c=>0,a=>56,g=>7,b=>1,d=>-1,f=>2}
38000000c1ab0300
3800000000000000c1ab030000000000
3800000000000000c1ab030000000000
0000003823d5c000
38000000c1ab0300
38000000c1ab0300
000000000000003823d5c00000000000
38000000c1ab0300
0000003823d5c000
-
{e=>6,c=>-4,a=>-45,g=>2,b=>2,d=>-1,f=>-1}
d3ffffffe27d0100
d3ffffffffffffffe27d010000000000
d3ffffffffffffffe27d010000000000
ffffffd353ee8000
d3ffffffe27d0100
d3ffffffe27d0100
ffffffffffffffd353ee800000000000
d3ffffffe27d0100
ffffffd353ee8000
-
{e=>7,c=>-4,a=>-101,g=>3,b=>1,d=>1,f=>-3}
9bffffff61de0100
9bffffffffffffff61de010000000000
9bffffffffffffff61de010000000000
ffffff9b30fac000
9bffffff61de0100
9bffffff61de0100
ffffffffffffff9b30fac00000000000
9bffffff61de0100
ffffff9b30fac000
-
{e=>0,c=>3,a=>62,g=>5,b=>2,d=>-3,f=>-4}
3e0000005ac10200
3e000000000000005ac1020000000000
3e000000000000005ac1020000000000
0000003e4e894000
3e0000005ac10200
3e0000005ac10200
000000000000003e4e89400000000000
3e0000005ac10200
0000003e4e894000
-
{e=>6,c=>3,a=>102,g=>2,b=>6,d=>1,f=>-1}
660000005e7c0100
66000000000000005e7c010000000000
66000000000000005e7c010000000000
00000066ccee8000
660000005e7c0100
660000005e7c0100
0000000000000066ccee800000000000
660000005e7c0100
00000066ccee8000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>0,c=>-3,a=>-101,g=>1,b=>2,d=>0,f=>-3}
9bffffff2ad00000
9bffffffffffffff2ad0000000000000
9bffffffffffffff2ad0000000000000
ffffff9b540a4000
9bffffff2ad00000
9bffffff2ad00000
ffffffffffffff9b540a400000000000
9bffffff2ad00000
ffffff9b540a4000
-
{e=>5,c=>-4,a=>-95,g=>4,b=>4,d=>-4,f=>-1}
a1ffffff247b0200
a1ffffffffffffff247b020000000000
a1ffffffffffffff247b020000000000
ffffffa1925f0000
a1ffffff247b0200
a1ffffff247b0200
ffffffffffffffa1925f000000000000
a1ffffff247b0200
ffffffa1925f0000
-
{e=>0,c=>0,a=>60,g=>4,b=>4,d=>2,f=>-3}
3c00000084500200
3c000000000000008450020000000000
3c000000000000008450020000000000
0000003c810b0000
3c00000084500200
3c00000084500200
000000000000003c810b000000000000
3c00000084500200
0000003c810b0000
-
{e=>4,c=>2,a=>-72,g=>5,b=>2,d=>1,f=>-2}
b8ffffff52e80200
b8ffffffffffffff52e8020000000000
b8ffffffffffffff52e8020000000000
ffffffb848cd4000
b8ffffff52e80200
b8ffffff52e80200
ffffffffffffffb848cd400000000000
b8ffffff52e80200
ffffffb848cd4000
-
{e=>4,c=>1,a=>-29,g=>7,b=>2,d=>-1,f=>2}
e3ffffffcaa90300
e3ffffffffffffffcaa9030000000000
e3ffffffffffffffcaa9030000000000
ffffffe347c5c000
e3ffffffcaa90300
e3ffffffcaa90300
ffffffffffffffe347c5c00000000000
e3ffffffcaa90300
ffffffe347c5c000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>1,a=>23,d=>2,c=>-2,h=>0,b=>2,g=>4,f=>-3}
17000000b252020000000000
1700000000000000b252020000000000
1700000000000000b252020000000000
00000017591b000000000000
17000000b252020000000000
17000000b252020000000000
0000000000000017591b000000000000
17000000b252020000000000
00000017591b000000000000
-
{e=>7,a=>-108,d=>3,c=>0,h=>1,b=>7,g=>7,f=>-2}
94ffffffc7ee030001000000
94ffffffffffffffc7ee030001000000
94ffffffffffffffc7ee030001000000
ffffff94e1fdc00020000000
94ffffffc7ee030001000000
94ffffffc7ee030001000000
ffffffffffffff94e1fdc00020000000
94ffffffc7ee030001000000
ffffff94e1fdc00020000000
-
{e=>5,a=>-126,d=>2,c=>1,h=>3,b=>4,g=>0,f=>3}
82ffffff8c3a000003000000
82ffffffffffffff8c3a000003000000
82ffffffffffffff8c3a000003000000
ffffff828556000060000000
82ffffff8c3a000003000000
82ffffff8c3a000003000000
ffffffffffffff828556000060000000
82ffffff8c3a000003000000
ffffff828556000060000000
-
{e=>4,a=>-62,d=>3,c=>-4,h=>1,b=>2,g=>2,f=>-3}
c2ffffffe258010001000000
c2ffffffffffffffe258010001000000
c2ffffffffffffffe258010001000000
ffffffc251ca800020000000
c2ffffffe258010001000000
c2ffffffe258010001000000
ffffffffffffffc251ca800020000000
c2ffffffe258010001000000
ffffffc251ca800020000000
-
{e=>0,a=>89,d=>-3,c=>3,h=>0,b=>7,g=>3,f=>2}
590000005fa1010000000000
59000000000000005fa1010000000000
59000000000000005fa1010000000000
00000059ee84c00000000000
590000005fa1010000000000
590000005fa1010000000000
0000000000000059ee84c00000000000
590000005fa1010000000000
00000059ee84c00000000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>6,a=>16,d=>1,c=>-4,h=>1,b=>7,g=>3,f=>-3,i=>0}
1000000067dc010001000000
100000000000000067dc010001000000
100000000000000067dc010001000000
00000010f0eac00020000000
1000000067dc010001000000
1000000067dc010001000000
0000000000000010f0eac00020000000
1000000067dc010001000000
00000010f0eac00020000000
-
{e=>6,a=>62,d=>0,c=>1,h=>2,b=>0,g=>5,f=>-3,i=>2}
3e00000008dc020012000000
3e0000000000000008dc020012000000
3e0000000000000008dc020012000000
0000003e046b400048000000
3e00000008dc020012000000
3e00000008dc020012000000
000000000000003e046b400048000000
3e00000008dc020012000000
0000003e046b400048000000
-
{e=>3,a=>-95,d=>-2,c=>3,h=>7,b=>3,g=>7,f=>-4,i=>0}
a1ffffff9bc7030007000000
a1ffffffffffffff9bc7030007000000
a1ffffffffffffff9bc7030007000000
ffffffa16f39c000e0000000
a1ffffff9bc7030007000000
a1ffffff9bc7030007000000
ffffffffffffffa16f39c000e0000000
a1ffffff9bc7030007000000
ffffffa16f39c000e0000000
-
{e=>6,a=>-45,d=>1,c=>0,h=>1,b=>6,g=>3,f=>-1,i=>1}
d3ffffff46fc010009000000
d3ffffffffffffff46fc010009000000
d3ffffffffffffff46fc010009000000
ffffffd3c0eec00024000000
d3ffffff46fc010009000000
d3ffffff46fc010009000000
ffffffffffffffd3c0eec00024000000
d3ffffff46fc010009000000
ffffffd3c0eec00024000000
-
{e=>1,a=>-122,d=>1,c=>0,h=>4,b=>1,g=>4,f=>0,i=>3}
86ffffff410202001c000000
86ffffffffffffff410202001c000000
86ffffffffffffff410202001c000000
ffffff86209100008c000000
86ffffff410202001c000000
86ffffff410202001c000000
ffffffffffffff86209100008c000000
86ffffff410202001c000000
ffffff86209100008c000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>1,a=>-114,d=>2,j=>5,c=>1,h=>4,b=>1,g=>6,f=>2,i=>-4}
8effffff8922030064010000
8effffffffffffff8922030064010000
8effffffffffffff8922030064010000
ffffff8e2515800092800000
8effffff8922030064010000
8effffff8922030064010000
ffffffffffffff8e2515800092800000
8effffff8922030064010000
ffffff8e2515800092800000
-
{e=>2,a=>-60,d=>-3,j=>3,c=>-1,h=>6,b=>2,g=>1,f=>3,i=>0}
c4ffffff7ab50000c6000000
c4ffffffffffffff7ab50000c6000000
c4ffffffffffffff7ab50000c6000000
ffffffc45ea64000c1800000
c4ffffff7ab50000c6000000
c4ffffff7ab50000c6000000
ffffffffffffffc45ea64000c1800000
c4ffffff7ab50000c6000000
ffffffc45ea64000c1800000
-
{e=>3,a=>51,d=>1,j=>5,c=>-4,h=>6,b=>7,g=>3,f=>2,i=>2}
3300000067a6010056010000
330000000000000067a6010056010000
330000000000000067a6010056010000
00000033f0b4c000ca800000
3300000067a6010056010000
3300000067a6010056010000
0000000000000033f0b4c000ca800000
3300000067a6010056010000
00000033f0b4c000ca800000
-
{e=>4,a=>-121,d=>-1,j=>3,c=>-3,h=>5,b=>3,g=>5,f=>1,i=>-1}
87ffffffeb990200fd000000
87ffffffffffffffeb990200fd000000
87ffffffffffffffeb990200fd000000
ffffff8777c34000bd800000
87ffffffeb990200fd000000
87ffffffeb990200fd000000
ffffffffffffff8777c34000bd800000
87ffffffeb990200fd000000
ffffff8777c34000bd800000
-
{e=>4,a=>80,d=>3,j=>5,c=>-1,h=>2,b=>0,g=>4,f=>-2,i=>0}
50000000f868020042010000
5000000000000000f868020042010000
5000000000000000f868020042010000
000000501dcd000042800000
50000000f868020042010000
50000000f868020042010000
00000000000000501dcd000042800000
50000000f868020042010000
000000501dcd000042800000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>6,a=>-88,d=>3,j=>5,c=>-3,k=>-40,h=>0,b=>6,g=>6,f=>1,i=>-2}
a8ffffffee1c03007001d800
a8ffffffffffffffee1c03007001d800
a8ffffffffffffffee1c03007001d800
ffffffa8d5e380001a80d800
a8ffffffee1c03007001d800
a8ffffffee1c03007001d800
ffffffffffffffa8d5e380001a80d800
a8ffffffee1c03007001d800
ffffffa8d5e380001a80d800
-
{e=>2,a=>100,d=>-2,j=>0,c=>-2,k=>126,h=>4,b=>0,g=>2,f=>-3,i=>-4}
64000000b055010024007e00
6400000000000000b055010024007e00
6400000000000000b055010024007e00
000000641b2a800090007e00
64000000b055010024007e00
64000000b055010024007e00
00000000000000641b2a800090007e00
64000000b055010024007e00
000000641b2a800090007e00
-
{e=>3,a=>-69,d=>2,j=>7,c=>2,k=>33,h=>6,b=>6,g=>0,f=>1,i=>-1}
bbffffff96160000fe012100
bbffffffffffffff96160000fe012100
bbffffffffffffff96160000fe012100
ffffffbbc9320000df802100
bbffffff96160000fe012100
bbffffff96160000fe012100
ffffffffffffffbbc9320000df802100
bbffffff96160000fe012100
ffffffbbc9320000df802100
-
{e=>4,a=>68,d=>0,j=>5,c=>-1,k=>-97,h=>7,b=>4,g=>1,f=>-1,i=>3}
440000003cf800005f019f00
44000000000000003cf800005f019f00
44000000000000003cf800005f019f00
000000449c4e4000ee809f00
440000003cf800005f019f00
440000003cf800005f019f00
00000000000000449c4e4000ee809f00
440000003cf800005f019f00
000000449c4e4000ee809f00
-
{e=>3,a=>-64,d=>-4,j=>1,c=>0,k=>-12,h=>3,b=>3,g=>2,f=>2,i=>0}
c0ffffff032701004300f400
c0ffffffffffffff032701004300f400
c0ffffffffffffff032701004300f400
ffffffc0623480006080f400
c0ffffff032701004300f400
c0ffffff032701004300f400
ffffffffffffffc0623480006080f400
c0ffffff032701004300f400
ffffffc0623480006080f400
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>7,a=>19,d=>-2,j=>6,l=>1,c=>3,k=>-48,h=>6,b=>3,g=>4,f=>2,i=>3}
130000009b2f02009e01d001
13000000000000009b2f02009e01d001
13000000000000009b2f02009e01d001
000000136f750000cf00d020
130000009b2f02009e01d001
130000009b2f02009e01d001
00000000000000136f750000cf00d020
130000009b2f02009e01d001
000000136f750000cf00d020
-
{e=>2,a=>-64,d=>-1,j=>0,l=>2,c=>-4,k=>-102,h=>5,b=>4,g=>0,f=>-4,i=>0}
c0ffffffe445000005009a02
c0ffffffffffffffe445000005009a02
c0ffffffffffffffe445000005009a02
ffffffc093a80000a0009a40
c0ffffffe445000005009a02
c0ffffffe445000005009a02
ffffffffffffffc093a80000a0009a40
c0ffffffe445000005009a02
ffffffc093a80000a0009a40
-
{e=>6,a=>32,d=>3,j=>6,l=>7,c=>0,k=>-18,h=>6,b=>2,g=>6,f=>3,i=>-4}
20000000c23c0300a601ee07
2000000000000000c23c0300a601ee07
2000000000000000c23c0300a601ee07
0000002041e78000d300eee0
20000000c23c0300a601ee07
20000000c23c0300a601ee07
000000000000002041e78000d300eee0
20000000c23c0300a601ee07
0000002041e78000d300eee0
-
{e=>4,a=>12,d=>0,j=>4,l=>0,c=>1,k=>-60,h=>6,b=>2,g=>0,f=>3,i=>-4}
0c0000000a3800002601c400
0c000000000000000a3800002601c400
0c000000000000000a3800002601c400
0000000c44460000d200c400
0c0000000a3800002601c400
0c0000000a3800002601c400
000000000000000c44460000d200c400
0c0000000a3800002601c400
0000000c44460000d200c400
-
{e=>1,a=>126,d=>-3,j=>3,l=>3,c=>-2,k=>127,h=>6,b=>2,g=>7,f=>3,i=>-2}
7e00000072b30300f6007f03
7e0000000000000072b30300f6007f03
7e0000000000000072b30300f6007f03
0000007e5a97c000d9807f60
7e00000072b30300f6007f03
7e00000072b30300f6007f03
000000000000007e5a97c000d9807f60
7e00000072b30300f6007f03
0000007e5a97c000d9807f60
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>7,a=>41,m=>-2,d=>-2,j=>7,l=>3,c=>-2,k=>100,h=>7,b=>4,g=>4,f=>3,i=>2}
29000000b43f0200d7016433
2900000000000000b43f0200d7016433
2900000000000000b43f0200d7016433
000000299b770000eb806478
29000000b43f0200d7016433
29000000b43f0200d7016433
00000000000000299b770000eb806478
29000000b43f0200d7016433
000000299b770000eb806478
-
{e=>0,a=>-34,m=>-1,d=>-1,j=>1,l=>4,c=>-4,k=>120,h=>0,b=>4,g=>1,f=>0,i=>1}
deffffffe48100004800783c
deffffffffffffffe48100004800783c
deffffffffffffffe48100004800783c
ffffffde938040000480789c
deffffffe48100004800783c
deffffffe48100004800783c
ffffffffffffffde938040000480789c
deffffffe48100004800783c
ffffffde938040000480789c
-
{e=>6,a=>29,m=>1,d=>-2,j=>2,l=>1,c=>-2,k=>-104,h=>4,b=>7,g=>2,f=>0,i=>-1}
1d000000b70d0100bc009809
1d00000000000000b70d0100bc009809
1d00000000000000b70d0100bc009809
0000001dfb6080009d009824
1d000000b70d0100bc009809
1d000000b70d0100bc009809
000000000000001dfb6080009d009824
1d000000b70d0100bc009809
0000001dfb6080009d009824
-
{e=>5,a=>-81,m=>3,d=>3,j=>2,l=>6,c=>-2,k=>-76,h=>3,b=>4,g=>4,f=>-1,i=>-3}
affffffff47a0200ab00b41e
affffffffffffffff47a0200ab00b41e
affffffffffffffff47a0200ab00b41e
ffffffaf99df00007500b4cc
affffffff47a0200ab00b41e
affffffff47a0200ab00b41e
ffffffffffffffaf99df00007500b4cc
affffffff47a0200ab00b41e
ffffffaf99df00007500b4cc
-
{e=>3,a=>-14,m=>2,d=>-1,j=>5,l=>2,c=>3,k=>77,h=>2,b=>0,g=>7,f=>0,i=>1}
f2ffffffd88703004a014d12
f2ffffffffffffffd88703004a014d12
f2ffffffffffffffd88703004a014d12
fffffff20fb1c00046804d48
f2ffffffd88703004a014d12
f2ffffffd88703004a014d12
fffffffffffffff20fb1c00046804d48
f2ffffffd88703004a014d12
fffffff20fb1c00046804d48
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>0,n=>2,a=>99,m=>-3,d=>-4,j=>1,l=>6,c=>-3,k=>5,h=>5,b=>2,g=>5,f=>3,i=>0}
630000002ab102004500052e02000000
63000000000000002ab102004500052e0200000000000000
63000000000000002ab102004500052e0200000000000000
0000006356074000a08005d440000000
630000002ab102004500052e02000000
630000002ab102004500052e02000000
000000000000006356074000a08005d44000000000000000
630000002ab102004500052e02000000
0000006356074000a08005d440000000
-
{e=>7,n=>4,a=>56,m=>-1,d=>0,j=>4,l=>6,c=>3,k=>123,h=>3,b=>0,g=>0,f=>-1,i=>1}
38000000187e00000b017b3e04000000
3800000000000000187e00000b017b3e0400000000000000
3800000000000000187e00000b017b3e0400000000000000
000000380c7e000066007bdc80000000
38000000187e00000b017b3e04000000
38000000187e00000b017b3e04000000
00000000000000380c7e000066007bdc8000000000000000
38000000187e00000b017b3e04000000
000000380c7e000066007bdc80000000
-
{e=>1,n=>0,a=>-72,m=>-1,d=>1,j=>2,l=>5,c=>-2,k=>29,h=>1,b=>1,g=>1,f=>2,i=>-3}
b8ffffff71a20000a9001d3d00000000
b8ffffffffffffff71a20000a9001d3d0000000000000000
b8ffffffffffffff71a20000a9001d3d0000000000000000
ffffffb83894400035001dbc00000000
b8ffffff71a20000a9001d3d00000000
b8ffffff71a20000a9001d3d00000000
ffffffffffffffb83894400035001dbc0000000000000000
b8ffffff71a20000a9001d3d00000000
ffffffb83894400035001dbc00000000
-
{e=>6,n=>5,a=>-35,m=>-3,d=>-2,j=>5,l=>6,c=>-1,k=>87,h=>4,b=>7,g=>0,f=>1,i=>-1}
ddffffffbf1d00007c01572e05000000
ddffffffffffffffbf1d00007c01572e0500000000000000
ddffffffffffffffbf1d00007c01572e0500000000000000
ffffffddff6200009e8057d4a0000000
ddffffffbf1d00007c01572e05000000
ddffffffbf1d00007c01572e05000000
ffffffffffffffddff6200009e8057d4a000000000000000
ddffffffbf1d00007c01572e05000000
ffffffddff6200009e8057d4a0000000
-
{e=>0,n=>1,a=>-32,m=>-1,d=>0,j=>6,l=>3,c=>1,k=>-26,h=>3,b=>1,g=>4,f=>-1,i=>3}
e0ffffff097002009b01e63b01000000
e0ffffffffffffff097002009b01e63b0100000000000000
e0ffffffffffffff097002009b01e63b0100000000000000
ffffffe0240f00006f00e67c20000000
e0ffffff097002009b01e63b01000000
e0ffffff097002009b01e63b01000000
ffffffffffffffe0240f00006f00e67c2000000000000000
e0ffffff097002009b01e63b01000000
ffffffe0240f00006f00e67c20000000
=
typedef int foo;

struct mixed_no_pack {
  long a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>4,n=>5,a=>-63,m=>0,d=>-4,j=>0,l=>3,c=>2,k=>0,h=>4,b=>6,g=>3,f=>0,o=>255,i=>1}
c1ffffff168901000c00000305ff0000
c1ffffffffffffff168901000c00000305ff000000000000
c1ffffffffffffff168901000c00000305ff000000000000
ffffffc1ca40c00084000060a0ff0000
c1ffffff168901000c00000305ff0000
c1ffffff168901000c00000305ff0000
ffffffffffffffc1ca40c00084000060a0ff000000000000
c1ffffff168901000c00000305ff0000
ffffffc1ca40c00084000060a0ff0000
-
{e=>4,n=>4,a=>-45,m=>-1,d=>-3,j=>5,l=>4,c=>-3,k=>-116,h=>7,b=>7,g=>0,f=>1,o=>47,i=>3}
d3ffffff6f1900005f018c3c042f0000
d3ffffffffffffff6f1900005f018c3c042f000000000000
d3ffffffffffffff6f1900005f018c3c042f000000000000
ffffffd3f6c20000ee808c9c802f0000
d3ffffff6f1900005f018c3c042f0000
d3ffffff6f1900005f018c3c042f0000
ffffffffffffffd3f6c20000ee808c9c802f000000000000
d3ffffff6f1900005f018c3c042f0000
ffffffd3f6c20000ee808c9c802f0000
-
{e=>2,n=>7,a=>37,m=>3,d=>2,j=>5,l=>5,c=>-2,k=>86,h=>3,b=>7,g=>5,f=>-2,o=>120,i=>-2}
25000000b7e402007301561d07780000
2500000000000000b7e402007301561d0778000000000000
2500000000000000b7e402007301561d0778000000000000
00000025f92d40007a8056ace0780000
25000000b7e402007301561d07780000
25000000b7e402007301561d07780000
0000000000000025f92d40007a8056ace078000000000000
25000000b7e402007301561d07780000
00000025f92d40007a8056ace0780000
-
{e=>7,n=>3,a=>-38,m=>-4,d=>0,j=>4,l=>5,c=>0,k=>30,h=>7,b=>7,g=>0,f=>3,o=>182,i=>-2}
daffffff073e000037011e2503b60000
daffffffffffffff073e000037011e2503b6000000000000
daffffffffffffff073e000037011e2503b6000000000000
ffffffdae0760000fa001eb060b60000
daffffff073e000037011e2503b60000
daffffff073e000037011e2503b60000
ffffffffffffffdae0760000fa001eb060b6000000000000
daffffff073e000037011e2503b60000
ffffffdae0760000fa001eb060b60000
-
{e=>4,n=>1,a=>-127,m=>0,d=>-4,j=>1,l=>7,c=>0,k=>-88,h=>1,b=>4,g=>3,f=>-2,o=>194,i=>-2}
81ffffff04e901007100a80701c20000
81ffffffffffffff04e901007100a80701c2000000000000
81ffffffffffffff04e901007100a80701c2000000000000
ffffff81824cc0003880a8e020c20000
81ffffff04e901007100a80701c20000
81ffffff04e901007100a80701c20000
ffffffffffffff81824cc0003880a8e020c2000000000000
81ffffff04e901007100a80701c20000
ffffff81824cc0003880a8e020c20000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
};
-
{a=>0}
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
00000000
-
{a=>5}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{a=>5}
05000000
05000000
05000000
a0000000
05000000
05000000
a0000000
05000000
a0000000
-
{a=>4}
04000000
04000000
04000000
80000000
04000000
04000000
80000000
04000000
80000000
-
{a=>1}
01000000
01000000
01000000
20000000
01000000
01000000
20000000
01000000
20000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
};
-
{a=>0,b=>-1}
38000000
38000000
38000000
1c000000
38000000
38000000
1c000000
38000000
1c000000
-
{a=>0,b=>2}
10000000
10000000
10000000
08000000
10000000
10000000
08000000
10000000
08000000
-
{a=>1,b=>0}
01000000
01000000
01000000
20000000
01000000
01000000
20000000
01000000
20000000
-
{a=>0,b=>3}
18000000
18000000
18000000
0c000000
18000000
18000000
0c000000
18000000
0c000000
-
{a=>5,b=>-1}
3d000000
3d000000
3d000000
bc000000
3d000000
3d000000
bc000000
3d000000
bc000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
};
-
{c=>3,a=>0,b=>-3}
e8000000
e8000000
e8000000
15800000
e8000000
e8000000
15800000
e8000000
15800000
-
{c=>3,a=>7,b=>-4}
e7000000
e7000000
e7000000
f1800000
e7000000
e7000000
f1800000
e7000000
f1800000
-
{c=>2,a=>3,b=>3}
9b000000
9b000000
9b000000
6d000000
9b000000
9b000000
6d000000
9b000000
6d000000
-
{c=>0,a=>3,b=>-3}
2b000000
2b000000
2b000000
74000000
2b000000
2b000000
74000000
2b000000
74000000
-
{c=>-1,a=>3,b=>2}
d3010000
d3010000
d3010000
6b800000
d3010000
d3010000
6b800000
d3010000
6b800000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
};
-
{c=>3,a=>7,b=>-4,d=>7}
e70e0000
e70e0000
e70e0000
f1f00000
e70e0000
e70e0000
f1f00000
e70e0000
f1f00000
-
{c=>1,a=>2,b=>1,d=>0}
4a000000
4a000000
4a000000
44800000
4a000000
4a000000
44800000
4a000000
44800000
-
{c=>-1,a=>1,b=>-4,d=>5}
e10b0000
e10b0000
e10b0000
33d00000
e10b0000
e10b0000
33d00000
e10b0000
33d00000
-
{c=>3,a=>6,b=>-1,d=>0}
fe000000
fe000000
fe000000
dd800000
fe000000
fe000000
dd800000
fe000000
dd800000
-
{c=>1,a=>4,b=>-2,d=>0}
74000000
74000000
74000000
98800000
74000000
74000000
98800000
74000000
98800000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
};
-
{e=>2,c=>-2,a=>3,b=>-2,d=>6}
b32d0000
b32d0000
b32d0000
7b640000
b32d0000
b32d0000
7b640000
b32d0000
7b640000
-
{e=>-2,c=>-1,a=>3,b=>-3,d=>2}
eb650000
eb650000
eb650000
77ac0000
eb650000
eb650000
77ac0000
eb650000
77ac0000
-
{e=>3,c=>1,a=>7,b=>-1,d=>3}
7f360000
7f360000
7f360000
fcb60000
7f360000
7f360000
fcb60000
7f360000
fcb60000
-
{e=>-4,c=>-2,a=>5,b=>-4,d=>1}
a5430000
a5430000
a5430000
b3180000
a5430000
a5430000
b3180000
a5430000
b3180000
-
{e=>1,c=>-2,a=>4,b=>-2,d=>4}
b4190000
b4190000
b4190000
9b420000
b4190000
b4190000
9b420000
b4190000
9b420000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
};
-
{e=>-3,c=>1,a=>4,b=>-1,d=>2,f=>2}
7c540100
7c540100
7c540100
9caa8000
7c540100
7c540100
9caa8000
7c540100
9caa8000
-
{e=>3,c=>2,a=>5,b=>-1,d=>0,f=>4}
bd300200
bd300200
bd300200
bd070000
bd300200
bd300200
bd070000
bd300200
bd070000
-
{e=>1,c=>-3,a=>3,b=>0,d=>6,f=>6}
431d0300
431d0300
431d0300
62e38000
431d0300
431d0300
62e38000
431d0300
62e38000
-
{e=>2,c=>0,a=>1,b=>-3,d=>1,f=>6}
29220300
29220300
29220300
34158000
29220300
29220300
34158000
29220300
34158000
-
{e=>2,c=>1,a=>4,b=>3,d=>0,f=>4}
5c200200
5c200200
5c200200
8c850000
5c200200
5c200200
8c850000
5c200200
8c850000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
};
-
{e=>-4,c=>0,a=>2,b=>2,d=>2,f=>3}
12c40100
12c40100
12c40100
4828c000
12c40100
12c40100
4828c000
12c40100
4828c000
-
{e=>2,c=>-4,a=>0,b=>2,d=>4,f=>2}
10290100
10290100
10290100
0a448000
10290100
10290100
0a448000
10290100
0a448000
-
{e=>-2,c=>-4,a=>4,b=>0,d=>3,f=>0}
04670000
04670000
04670000
823c0000
04670000
04670000
823c0000
04670000
823c0000
-
{e=>-1,c=>1,a=>2,b=>3,d=>7,f=>0}
5a7e0000
5a7e0000
5a7e0000
4cfe0000
5a7e0000
5a7e0000
4cfe0000
5a7e0000
4cfe0000
-
{e=>0,c=>-1,a=>1,b=>-3,d=>0,f=>5}
e9810200
e9810200
e9810200
37814000
e9810200
e9810200
37814000
e9810200
37814000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
};
-
{e=>3,c=>1,a=>1,g=>6,b=>0,d=>5,f=>2}
413a010006000000
413a010006000000
413a010006000000
20d68000c0000000
413a010006000000
413a010006000000
20d68000c0000000
413a010006000000
20d68000c0000000
-
{e=>-2,c=>-2,a=>3,g=>0,b=>3,d=>0,f=>7}
9be1030000000000
9be1030000000000
9be1030000000000
6f0dc00000000000
9be1030000000000
9be1030000000000
6f0dc00000000000
9be1030000000000
6f0dc00000000000
-
{e=>-2,c=>-4,a=>6,g=>3,b=>-4,d=>6,f=>3}
26ed010003000000
26ed010003000000
26ed010003000000
d26cc00060000000
26ed010003000000
26ed010003000000
d26cc00060000000
26ed010003000000
d26cc00060000000
-
{e=>-2,c=>1,a=>7,g=>4,b=>3,d=>7,f=>3}
5fee010004000000
5fee010004000000
5fee010004000000
ecfcc00080000000
5fee010004000000
5fee010004000000
ecfcc00080000000
5fee010004000000
ecfcc00080000000
-
{e=>-2,c=>-3,a=>0,g=>1,b=>-3,d=>7,f=>5}
68ef020001000000
68ef020001000000
68ef020001000000
16fd400020000000
68ef020001000000
68ef020001000000
16fd400020000000
68ef020001000000
16fd400020000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
};
-
{e=>-2,a=>2,d=>0,c=>-4,h=>1,b=>-4,g=>0,f=>0}
2261000008000000
2261000008000000
2261000008000000
520c000004000000
2261000008000000
2261000008000000
520c000004000000
2261000008000000
520c000004000000
-
{e=>-1,a=>0,d=>5,c=>-2,h=>-3,b=>2,g=>2,f=>7}
90fb03002a000000
90fb03002a000000
90fb03002a000000
0b5fc00054000000
90fb03002a000000
90fb03002a000000
0b5fc00054000000
90fb03002a000000
0b5fc00054000000
-
{e=>3,a=>4,d=>0,c=>2,h=>-3,b=>3,g=>2,f=>7}
9cb003002a000000
9cb003002a000000
9cb003002a000000
8d07c00054000000
9cb003002a000000
9cb003002a000000
8d07c00054000000
9cb003002a000000
8d07c00054000000
-
{e=>2,a=>7,d=>5,c=>2,h=>1,b=>0,g=>0,f=>2}
872a010008000000
872a010008000000
872a010008000000
e154800004000000
872a010008000000
872a010008000000
e154800004000000
872a010008000000
e154800004000000
-
{e=>-3,a=>3,d=>6,c=>2,h=>0,b=>-1,g=>7,f=>4}
bb5c020007000000
bb5c020007000000
bb5c020007000000
7d6b0000e0000000
bb5c020007000000
bb5c020007000000
7d6b0000e0000000
bb5c020007000000
7d6b0000e0000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
};
-
{e=>2,a=>3,d=>4,c=>1,h=>-4,b=>-1,g=>4,f=>2,i=>7}
7b280100e4010000
7b280100e4010000
7b280100e4010000
7cc4800093800000
7b280100e4010000
7b280100e4010000
7cc4800093800000
7b280100e4010000
7cc4800093800000
-
{e=>2,a=>7,d=>2,c=>-3,h=>2,b=>-1,g=>6,f=>7,i=>5}
7fa5030056010000
7fa5030056010000
7fa5030056010000
fea5c000ca800000
7fa5030056010000
7fa5030056010000
fea5c000ca800000
7fa5030056010000
fea5c000ca800000
-
{e=>2,a=>2,d=>5,c=>-2,h=>0,b=>-1,g=>0,f=>6,i=>7}
ba2b0300c0010000
ba2b0300c0010000
ba2b0300c0010000
5f55800003800000
ba2b0300c0010000
ba2b0300c0010000
5f55800003800000
ba2b0300c0010000
5f55800003800000
-
{e=>-4,a=>0,d=>7,c=>0,h=>1,b=>3,g=>6,f=>0,i=>2}
184e00008e000000
184e00008e000000
184e00008e000000
0c780000c5000000
184e00008e000000
184e00008e000000
0c780000c5000000
184e00008e000000
0c780000c5000000
-
{e=>0,a=>4,d=>3,c=>-1,h=>-4,b=>-4,g=>3,f=>6,i=>7}
e4070300e3010000
e4070300e3010000
e4070300e3010000
93b1800073800000
e4070300e3010000
e4070300e3010000
93b1800073800000
e4070300e3010000
93b1800073800000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
};
-
{e=>-3,a=>2,d=>5,j=>51,c=>-3,h=>-4,b=>-1,g=>5,f=>7,i=>4}
7adb030025013300
7adb030025013300
7adb030025013300
5edbc000b2003300
7adb030025013300
7adb030025013300
5edbc000b2003300
7adb030025013300
5edbc000b2003300
-
{e=>2,a=>5,d=>0,j=>-45,c=>-2,h=>2,b=>-1,g=>6,f=>3,i=>2}
bda101009600d300
bda101009600d300
bda101009600d300
bf04c000c900d300
bda101009600d300
bda101009600d300
bf04c000c900d300
bda101009600d300
bf04c000c900d300
-
{e=>-1,a=>3,d=>4,j=>-26,c=>2,h=>3,b=>0,g=>1,f=>5,i=>0}
83f802001900e600
83f802001900e600
83f802001900e600
614f40002c00e600
83f802001900e600
83f802001900e600
614f40002c00e600
83f802001900e600
614f40002c00e600
-
{e=>1,a=>4,d=>0,j=>-56,c=>1,h=>3,b=>2,g=>2,f=>3,i=>4}
549001001a01c800
549001001a01c800
549001001a01c800
8882c0004e00c800
549001001a01c800
549001001a01c800
8882c0004e00c800
549001001a01c800
8882c0004e00c800
-
{e=>2,a=>7,d=>4,j=>-122,c=>-4,h=>1,b=>-2,g=>1,f=>4,i=>6}
3729020089018600
3729020089018600
3729020089018600
fa45000027008600
3729020089018600
3729020089018600
fa45000027008600
3729020089018600
fa45000027008600
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
};
-
{e=>3,a=>6,d=>7,j=>112,c=>0,k=>2,h=>-4,b=>-3,g=>3,f=>7,i=>5}
2ebe030063017002
2ebe030063017002
2ebe030063017002
d477c00072807040
2ebe030063017002
2ebe030063017002
d477c00072807040
2ebe030063017002
d477c00072807040
-
{e=>-3,a=>1,d=>7,j=>-86,c=>3,k=>2,h=>3,b=>-4,g=>7,f=>0,i=>3}
e15e0000df00aa02
e15e0000df00aa02
e15e0000df00aa02
31fa0000ed80aa40
e15e0000df00aa02
e15e0000df00aa02
31fa0000ed80aa40
e15e0000df00aa02
31fa0000ed80aa40
-
{e=>-2,a=>0,d=>6,j=>-117,c=>-3,k=>7,h=>0,b=>-1,g=>6,f=>7,i=>2}
78ed030086008b07
78ed030086008b07
78ed030086008b07
1eedc000c1008be0
78ed030086008b07
78ed030086008b07
1eedc000c1008be0
78ed030086008b07
1eedc000c1008be0
-
{e=>1,a=>5,d=>5,j=>-119,c=>-2,k=>6,h=>1,b=>2,g=>3,f=>2,i=>0}
951b01000b008906
951b01000b008906
951b01000b008906
ab528000640089c0
951b01000b008906
951b01000b008906
ab528000640089c0
951b01000b008906
ab528000640089c0
-
{e=>3,a=>6,d=>6,j=>-128,c=>-2,k=>0,h=>2,b=>-4,g=>3,f=>3,i=>5}
a6bd010053018000
a6bd010053018000
a6bd010053018000
d366c0006a808000
a6bd010053018000
a6bd010053018000
d366c0006a808000
a6bd010053018000
d366c0006a808000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
};
-
{e=>-1,a=>1,d=>3,j=>90,l=>-1,c=>2,k=>4,h=>0,b=>-2,g=>5,f=>4,i=>3}
b1760200c5005a3c
b1760200c5005a3c
b1760200c5005a3c
393f0000a1805a9c
b1760200c5005a3c
b1760200c5005a3c
393f0000a1805a9c
b1760200c5005a3c
393f0000a1805a9c
-
{e=>3,a=>0,d=>3,j=>27,l=>-2,c=>-3,k=>5,h=>0,b=>-1,g=>2,f=>1,i=>5}
78b7000042011b35
78b7000042011b35
78b7000042011b35
1eb6400042801bb8
78b7000042011b35
78b7000042011b35
1eb6400042801bb8
78b7000042011b35
1eb6400042801bb8
-
{e=>1,a=>1,d=>3,j=>-13,l=>-4,c=>-3,k=>5,h=>2,b=>-2,g=>6,f=>1,i=>1}
719700005600f325
719700005600f325
719700005600f325
3ab24000c880f3b0
719700005600f325
719700005600f325
3ab24000c880f3b0
719700005600f325
3ab24000c880f3b0
-
{e=>2,a=>3,d=>7,j=>-47,l=>-2,c=>-3,k=>1,h=>3,b=>-3,g=>6,f=>3,i=>6}
6baf01009e01d131
6baf01009e01d131
6baf01009e01d131
76f4c000cf00d138
6baf01009e01d131
6baf01009e01d131
76f4c000cf00d138
6baf01009e01d131
76f4c000cf00d138
-
{e=>1,a=>3,d=>4,j=>20,l=>2,c=>-4,k=>3,h=>-3,b=>2,g=>4,f=>0,i=>4}
131900002c011413
131900002c011413
131900002c011413
6a42000096001468
131900002c011413
131900002c011413
6a42000096001468
131900002c011413
6a42000096001468
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
  unsigned int  m:3;
};
-
{e=>-2,a=>2,m=>1,d=>3,j=>66,l=>2,c=>1,k=>7,h=>0,b=>3,g=>3,f=>3,i=>4}
5ae601000301421701000000
5ae601000301421701000000
5ae601000301421701000000
4cbcc000620042e820000000
5ae601000301421701000000
5ae601000301421701000000
4cbcc000620042e820000000
5ae601000301421701000000
4cbcc000620042e820000000
-
{e=>3,a=>7,m=>5,d=>2,j=>87,l=>-2,c=>-4,k=>4,h=>0,b=>1,g=>4,f=>1,i=>1}
0fb500004400573405000000
0fb500004400573405000000
0fb500004400573405000000
e626400080805798a0000000
0fb500004400573405000000
0fb500004400573405000000
e626400080805798a0000000
0fb500004400573405000000
e626400080805798a0000000
-
{e=>0,a=>3,m=>7,d=>4,j=>2,l=>-3,c=>2,k=>7,h=>-4,b=>-2,g=>0,f=>4,i=>1}
b30802006000022f07000000
b30802006000022f07000000
b30802006000022f07000000
79410000108002f4e0000000
b30802006000022f07000000
b30802006000022f07000000
79410000108002f4e0000000
b30802006000022f07000000
79410000108002f4e0000000
-
{e=>0,a=>6,m=>1,d=>0,j=>-127,l=>0,c=>0,k=>2,h=>-3,b=>-2,g=>3,f=>2,i=>1}
360001006b00810201000000
360001006b00810201000000
360001006b00810201000000
d80080007480814020000000
360001006b00810201000000
360001006b00810201000000
d80080007480814020000000
360001006b00810201000000
d80080007480814020000000
-
{e=>-1,a=>4,m=>4,d=>0,j=>-10,l=>-3,c=>0,k=>4,h=>-4,b=>1,g=>6,f=>3,i=>0}
0cf001002600f62c04000000
0cf001002600f62c04000000
0cf001002600f62c04000000
840ec000d000f69480000000
0cf001002600f62c04000000
0cf001002600f62c04000000
840ec000d000f69480000000
0cf001002600f62c04000000
840ec000d000f69480000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  unsigned int  a:3;
  signed   int  b:3;
  foo           c:3;
  unsigned char d:3;
  signed   char e:3;
  unsigned int  f:3;
  int            :0;
  unsigned char g:3;
  signed   char h:3;
  unsigned int  i:3;
  char          j;
  unsigned char k:3;
  signed   char l:3;
  unsigned int  m:3;
  unsigned char n;
};
-
{e=>-3,n=>71,a=>1,m=>5,d=>3,j=>-14,l=>-1,c=>0,k=>5,h=>-3,b=>0,g=>0,f=>5,i=>5}
01d602006801f23d05470000
01d602006801f23d05470000
01d602006801f23d05470000
203b40001680f2bca0470000
01d602006801f23d05470000
01d602006801f23d05470000
203b40001680f2bca0470000
01d602006801f23d05470000
203b40001680f2bca0470000
-
{e=>1,n=>212,a=>5,m=>3,d=>1,j=>-32,l=>3,c=>-2,k=>5,h=>-2,b=>-3,g=>4,f=>0,i=>4}
ad1300003401e01d03d40000
ad1300003401e01d03d40000
ad1300003401e01d03d40000
b71200009a00e0ac60d40000
ad1300003401e01d03d40000
ad1300003401e01d03d40000
b71200009a00e0ac60d40000
ad1300003401e01d03d40000
b71200009a00e0ac60d40000
-
{e=>-1,n=>32,a=>4,m=>3,d=>1,j=>-40,l=>-2,c=>-1,k=>3,h=>-1,b=>2,g=>0,f=>5,i=>5}
d4f302007801d83303200000
d4f302007801d83303200000
d4f302007801d83303200000
8b9f40001e80d87860200000
d4f302007801d83303200000
d4f302007801d83303200000
8b9f40001e80d87860200000
d4f302007801d83303200000
8b9f40001e80d87860200000
-
{e=>-1,n=>95,a=>2,m=>6,d=>6,j=>-84,l=>0,c=>2,k=>0,h=>2,b=>-3,g=>2,f=>3,i=>2}
aafc01009200ac00065f0000
aafc01009200ac00065f0000
aafc01009200ac00065f0000
556ec0004900ac00c05f0000
aafc01009200ac00065f0000
aafc01009200ac00065f0000
556ec0004900ac00c05f0000
aafc01009200ac00065f0000
556ec0004900ac00c05f0000
-
{e=>0,n=>37,a=>4,m=>6,d=>1,j=>46,l=>2,c=>-3,k=>7,h=>0,b=>3,g=>0,f=>7,i=>0}
5c83030000002e1706250000
5c83030000002e1706250000
5c83030000002e1706250000
8e91c00000002ee8c0250000
5c83030000002e1706250000
5c83030000002e1706250000
8e91c00000002ee8c0250000
5c83030000002e1706250000
8e91c00000002ee8c0250000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
};
-
{a=>106,b=>0}
6a000000
6a000000
6a000000
6a000000
6a000000
6a000000
6a000000
6a000000
6a000000
-
{a=>-10,b=>0}
f6000000
f6000000
f6000000
f6000000
f6000000
f6000000
f6000000
f6000000
f6000000
-
{a=>12,b=>6}
0c060000
0c060000
0c060000
0cc00000
0c060000
0c060000
0cc00000
0c060000
0cc00000
-
{a=>-86,b=>1}
aa010000
aa010000
aa010000
aa200000
aa010000
aa010000
aa200000
aa010000
aa200000
-
{a=>-33,b=>2}
df020000
df020000
df020000
df400000
df020000
df020000
df400000
df020000
df400000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>-3,a=>-108,b=>2}
942a0000
942a0000
942a0000
94540000
942a0000
942a0000
94540000
942a0000
94540000
-
{c=>1,a=>96,b=>5}
600d0000
600d0000
600d0000
60a40000
600d0000
600d0000
60a40000
600d0000
60a40000
-
{c=>3,a=>-121,b=>6}
871e0000
871e0000
871e0000
87cc0000
871e0000
871e0000
87cc0000
871e0000
87cc0000
-
{c=>-1,a=>-58,b=>1}
c6390000
c6390000
c6390000
c63c0000
c6390000
c6390000
c63c0000
c6390000
c63c0000
-
{c=>2,a=>62,b=>2}
3e120000
3e120000
3e120000
3e480000
3e120000
3e120000
3e480000
3e120000
3e480000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>-4,a=>40,b=>3,d=>-2}
28a30100
28a30100
28a30100
28730000
28a30100
28a30100
28730000
28a30100
28730000
-
{c=>-3,a=>68,b=>4,d=>-3}
446c0100
446c0100
446c0100
44968000
446c0100
446c0100
44968000
446c0100
44968000
-
{c=>-3,a=>21,b=>0,d=>3}
15e80000
15e80000
15e80000
15158000
15e80000
15e80000
15158000
15e80000
15158000
-
{c=>-3,a=>-98,b=>2,d=>-1}
9eea0100
9eea0100
9eea0100
9e578000
9eea0100
9eea0100
9e578000
9eea0100
9e578000
-
{c=>-3,a=>74,b=>7,d=>1}
4a6f0000
4a6f0000
4a6f0000
4af48000
4a6f0000
4a6f0000
4af48000
4a6f0000
4af48000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>3,c=>-2,a=>4,b=>0,d=>-4}
04300700
04300700
04300700
041a3000
04300700
04300700
041a3000
04300700
041a3000
-
{e=>4,c=>-1,a=>44,b=>0,d=>2}
2cb80800
2cb80800
2cb80800
2c1d4000
2cb80800
2cb80800
2c1d4000
2cb80800
2c1d4000
-
{e=>7,c=>-1,a=>-108,b=>5,d=>-2}
94bd0f00
94bd0f00
94bd0f00
94bf7000
94bd0f00
94bd0f00
94bf7000
94bd0f00
94bf7000
-
{e=>3,c=>2,a=>-123,b=>0,d=>3}
85d00600
85d00600
85d00600
8509b000
85d00600
85d00600
8509b000
85d00600
8509b000
-
{e=>3,c=>0,a=>-85,b=>5,d=>0}
ab050600
ab050600
ab050600
aba03000
ab050600
ab050600
aba03000
ab050600
aba03000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>2,c=>-3,a=>-86,b=>1,d=>-3,f=>3}
aa693500
aa693500
aa693500
aa36a600
aa693500
aa693500
aa36a600
aa693500
aa36a600
-
{e=>4,c=>1,a=>-10,b=>0,d=>0,f=>3}
f6083800
f6083800
f6083800
f6044600
f6083800
f6083800
f6044600
f6083800
f6044600
-
{e=>7,c=>-2,a=>18,b=>2,d=>-2,f=>-1}
12b27f00
12b27f00
12b27f00
125b7e00
12b27f00
12b27f00
125b7e00
12b27f00
125b7e00
-
{e=>2,c=>3,a=>-8,b=>5,d=>1,f=>2}
f85d2400
f85d2400
f85d2400
f8aca400
f85d2400
f85d2400
f8aca400
f85d2400
f8aca400
-
{e=>1,c=>0,a=>-98,b=>0,d=>1,f=>0}
9e400200
9e400200
9e400200
9e009000
9e400200
9e400200
9e009000
9e400200
9e009000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>3,c=>1,a=>126,g=>5,b=>0,d=>0,f=>3}
7e08b602
7e08b602
7e08b602
7e043740
7e08b602
7e08b602
7e043740
7e08b602
7e043740
-
{e=>0,c=>-4,a=>-72,g=>4,b=>2,d=>-1,f=>2}
b8e22102
b8e22102
b8e22102
b8538500
b8e22102
b8e22102
b8538500
b8e22102
b8538500
-
{e=>4,c=>-2,a=>-68,g=>1,b=>6,d=>3,f=>3}
bcf6b800
bcf6b800
bcf6b800
bcd9c640
bcf6b800
bcf6b800
bcd9c640
bcf6b800
bcd9c640
-
{e=>1,c=>-2,a=>34,g=>4,b=>7,d=>-4,f=>-4}
22374302
22374302
22374302
22fa1900
22374302
22374302
22fa1900
22374302
22fa1900
-
{e=>2,c=>3,a=>13,g=>1,b=>3,d=>2,f=>-3}
0d9bd400
0d9bd400
0d9bd400
0d6d2a40
0d9bd400
0d9bd400
0d6d2a40
0d9bd400
0d6d2a40
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>6,c=>2,a=>-126,g=>7,b=>4,d=>-3,f=>2}
8254ad03
8254ad03
8254ad03
828ae5c0
8254ad03
8254ad03
828ae5c0
8254ad03
828ae5c0
-
{e=>7,c=>-3,a=>-72,g=>3,b=>6,d=>-4,f=>-3}
b82edf01
b82edf01
b82edf01
b8d67ac0
b82edf01
b82edf01
b8d67ac0
b82edf01
b8d67ac0
-
{e=>6,c=>-3,a=>67,g=>7,b=>6,d=>-1,f=>-4}
43eecd03
43eecd03
43eecd03
43d7e9c0
43eecd03
43eecd03
43d7e9c0
43eecd03
43d7e9c0
-
{e=>4,c=>-2,a=>-37,g=>6,b=>2,d=>3,f=>3}
dbf23803
dbf23803
dbf23803
db59c780
dbf23803
dbf23803
db59c780
dbf23803
db59c780
-
{e=>4,c=>3,a=>23,g=>7,b=>1,d=>2,f=>2}
1799a803
1799a803
1799a803
172d45c0
1799a803
1799a803
172d45c0
1799a803
172d45c0
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>3,a=>106,d=>0,c=>1,h=>0,b=>6,g=>3,f=>3}
6a0eb60100000000
6a0eb60100000000
6a0eb60100000000
6ac436c000000000
6a0eb60100000000
6a0eb60100000000
6ac436c000000000
6a0eb60100000000
6ac436c000000000
-
{e=>0,a=>102,d=>-2,c=>-2,h=>0,b=>5,g=>0,f=>2}
66b5210000000000
66b5210000000000
66b5210000000000
66bb040000000000
66b5210000000000
66b5210000000000
66bb040000000000
66b5210000000000
66bb040000000000
-
{e=>1,a=>-118,d=>2,c=>-3,h=>1,b=>1,g=>6,f=>3}
8aa9320301000000
8aa9320301000000
8aa9320301000000
8a35178020000000
8aa9320301000000
8aa9320301000000
8a35178020000000
8aa9320301000000
8a35178020000000
-
{e=>0,a=>60,d=>-3,c=>2,h=>0,b=>3,g=>0,f=>0}
3c53010000000000
3c53010000000000
3c53010000000000
3c6a800000000000
3c53010000000000
3c53010000000000
3c6a800000000000
3c53010000000000
3c6a800000000000
-
{e=>5,a=>19,d=>-2,c=>3,h=>1,b=>2,g=>4,f=>3}
139a3b0201000000
139a3b0201000000
139a3b0201000000
134f570020000000
139a3b0201000000
139a3b0201000000
134f570020000000
139a3b0201000000
134f570020000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>4,a=>126,d=>2,c=>1,h=>5,b=>4,g=>6,f=>3,i=>-4}
7e8c380325000000
7e8c380325000000
7e8c380325000000
7e854780b0000000
7e8c380325000000
7e8c380325000000
7e854780b0000000
7e8c380325000000
7e854780b0000000
-
{e=>7,a=>-19,d=>0,c=>1,h=>2,b=>3,g=>5,f=>0,i=>-3}
ed0b8e022a000000
ed0b8e022a000000
ed0b8e022a000000
ed64714054000000
ed0b8e022a000000
ed0b8e022a000000
ed64714054000000
ed0b8e022a000000
ed64714054000000
-
{e=>0,a=>122,d=>3,c=>3,h=>2,b=>4,g=>2,f=>-2,i=>2}
7adc600112000000
7adc600112000000
7adc600112000000
7a8d8c8048000000
7adc600112000000
7adc600112000000
7a8d8c8048000000
7adc600112000000
7a8d8c8048000000
-
{e=>2,a=>62,d=>-4,c=>-4,h=>6,b=>3,g=>5,f=>-2,i=>3}
3e23e5021e000000
3e23e5021e000000
3e23e5021e000000
3e722d40cc000000
3e23e5021e000000
3e23e5021e000000
3e722d40cc000000
3e23e5021e000000
3e722d40cc000000
-
{e=>1,a=>64,d=>-3,c=>-4,h=>0,b=>3,g=>1,f=>-4,i=>-4}
4063c30020000000
4063c30020000000
4063c30020000000
4072984010000000
4063c30020000000
4063c30020000000
4072984010000000
4063c30020000000
4072984010000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>6,a=>-51,d=>2,j=>2,c=>1,h=>0,b=>4,g=>2,f=>0,i=>-3}
cd8c0c01a8000000
cd8c0c01a8000000
cd8c0c01a8000000
cd85608015000000
cd8c0c01a8000000
cd8c0c01a8000000
cd85608015000000
cd8c0c01a8000000
cd85608015000000
-
{e=>3,a=>36,d=>-4,j=>7,c=>3,h=>7,b=>5,g=>6,f=>0,i=>-2}
241d0703f7010000
241d0703f7010000
241d0703f7010000
24ae3180fb800000
241d0703f7010000
241d0703f7010000
24ae3180fb800000
241d0703f7010000
24ae3180fb800000
-
{e=>3,a=>-65,d=>-2,j=>7,c=>-1,h=>5,b=>0,g=>5,f=>3,i=>-1}
bfb8b702fd010000
bfb8b702fd010000
bfb8b702fd010000
bf1f3740bf800000
bfb8b702fd010000
bfb8b702fd010000
bf1f3740bf800000
bfb8b702fd010000
bf1f3740bf800000
-
{e=>3,a=>-4,d=>2,j=>4,c=>1,h=>1,b=>5,g=>1,f=>-1,i=>1}
fc8df60009010000
fc8df60009010000
fc8df60009010000
fca53e4026000000
fc8df60009010000
fc8df60009010000
fca53e4026000000
fc8df60009010000
fca53e4026000000
-
{e=>5,a=>114,d=>2,j=>0,c=>1,h=>2,b=>7,g=>2,f=>-3,i=>-3}
728f5a012a000000
728f5a012a000000
728f5a012a000000
72e55a8054000000
728f5a012a000000
728f5a012a000000
72e55a8054000000
728f5a012a000000
72e55a8054000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>6,a=>66,d=>1,j=>3,c=>3,k=>-88,h=>4,b=>5,g=>0,f=>3,i=>1}
425d3c00cc00a800
425d3c00cc00a800
425d3c00cc00a800
42ace6008580a800
425d3c00cc00a800
425d3c00cc00a800
42ace6008580a800
425d3c00cc00a800
42ace6008580a800
-
{e=>3,a=>-27,d=>3,j=>3,c=>-4,k=>-71,h=>2,b=>6,g=>1,f=>1,i=>-3}
e5e69600ea00b900
e5e69600ea00b900
e5e69600ea00b900
e5d1b2405580b900
e5e69600ea00b900
e5e69600ea00b900
e5d1b2405580b900
e5e69600ea00b900
e5d1b2405580b900
-
{e=>7,a=>-4,d=>-3,j=>1,c=>-3,k=>-71,h=>5,b=>0,g=>3,f=>2,i=>-4}
fc68af016500b900
fc68af016500b900
fc68af016500b900
fc16f4c0b080b900
fc68af016500b900
fc68af016500b900
fc16f4c0b080b900
fc68af016500b900
fc16f4c0b080b900
-
{e=>7,a=>-35,d=>-3,j=>6,c=>2,k=>50,h=>5,b=>5,g=>6,f=>1,i=>2}
dd551f0395013200
dd551f0395013200
dd551f0395013200
ddaaf380ab003200
dd551f0395013200
dd551f0395013200
ddaaf380ab003200
dd551f0395013200
ddaaf380ab003200
-
{e=>5,a=>-47,d=>0,j=>3,c=>3,k=>-120,h=>3,b=>2,g=>7,f=>2,i=>1}
d11aaa03cb008800
d11aaa03cb008800
d11aaa03cb008800
d14c55c065808800
d11aaa03cb008800
d11aaa03cb008800
d14c55c065808800
d11aaa03cb008800
d14c55c065808800
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>2,a=>-32,d=>-4,j=>1,l=>2,c=>-4,k=>-17,h=>5,b=>0,g=>3,f=>1,i=>-3}
e02095016d00ef02
e02095016d00ef02
e02095016d00ef02
e01222c0b480ef40
e02095016d00ef02
e02095016d00ef02
e01222c0b480ef40
e02095016d00ef02
e01222c0b480ef40
-
{e=>7,a=>-51,d=>2,j=>0,l=>7,c=>-1,k=>-66,h=>1,b=>5,g=>3,f=>1,i=>-1}
cdbd9e013900be07
cdbd9e013900be07
cdbd9e013900be07
cdbd72c03c00bee0
cdbd9e013900be07
cdbd9e013900be07
cdbd72c03c00bee0
cdbd9e013900be07
cdbd72c03c00bee0
-
{e=>5,a=>73,d=>2,j=>4,l=>7,c=>-3,k=>-107,h=>4,b=>6,g=>4,f=>-2,i=>-4}
49ae6a0224019507
49ae6a0224019507
49ae6a0224019507
49d55d00920095e0
49ae6a0224019507
49ae6a0224019507
49d55d00920095e0
49ae6a0224019507
49d55d00920095e0
-
{e=>7,a=>-32,d=>0,j=>2,l=>6,c=>1,k=>-119,h=>6,b=>7,g=>0,f=>-4,i=>0}
e00f4e0086008906
e00f4e0086008906
e00f4e0086008906
e0e47800c10089c0
e00f4e0086008906
e00f4e0086008906
e0e47800c10089c0
e00f4e0086008906
e0e47800c10089c0
-
{e=>7,a=>70,d=>1,j=>3,l=>0,c=>2,k=>-78,h=>4,b=>1,g=>4,f=>3,i=>-1}
46513e02fc00b200
46513e02fc00b200
46513e02fc00b200
4628f7009d80b200
46513e02fc00b200
46513e02fc00b200
4628f7009d80b200
46513e02fc00b200
4628f7009d80b200
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>5,a=>82,m=>1,d=>-4,j=>4,l=>4,c=>2,k=>75,h=>1,b=>7,g=>3,f=>-2,i=>2}
5217eb0111014b0c
5217eb0111014b0c
5217eb0111014b0c
52ea5cc02a004b84
5217eb0111014b0c
5217eb0111014b0c
52ea5cc02a004b84
5217eb0111014b0c
52ea5cc02a004b84
-
{e=>1,a=>65,m=>0,d=>-2,j=>6,l=>6,c=>1,k=>10,h=>7,b=>6,g=>6,f=>1,i=>3}
418e13039f010a06
418e13039f010a06
418e13039f010a06
41c71380ef000ac0
418e13039f010a06
418e13039f010a06
41c71380ef000ac0
418e13039f010a06
41c71380ef000ac0
-
{e=>1,a=>50,m=>0,d=>-1,j=>4,l=>1,c=>3,k=>-39,h=>4,b=>5,g=>1,f=>3,i=>2}
32ddb3001401d901
32ddb3001401d901
32ddb3001401d901
32af96408a00d920
32ddb3001401d901
32ddb3001401d901
32af96408a00d920
32ddb3001401d901
32af96408a00d920
-
{e=>1,a=>-30,m=>-3,d=>-3,j=>4,l=>3,c=>0,k=>-58,h=>2,b=>2,g=>4,f=>-3,i=>-1}
e24253023a01c62b
e24253023a01c62b
e24253023a01c62b
e2429b005e00c674
e24253023a01c62b
e24253023a01c62b
e2429b005e00c674
e24253023a01c62b
e2429b005e00c674
-
{e=>6,a=>-8,m=>-1,d=>-4,j=>1,l=>7,c=>1,k=>-96,h=>4,b=>1,g=>2,f=>-4,i=>3}
f8094d015c00a03f
f8094d015c00a03f
f8094d015c00a03f
f82668808c80a0fc
f8094d015c00a03f
f8094d015c00a03f
f82668808c80a0fc
f8094d015c00a03f
f82668808c80a0fc
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>6,n=>7,a=>127,m=>-3,d=>2,j=>1,l=>4,c=>3,k=>113,h=>7,b=>0,g=>3,f=>-2,i=>1}
7f98ec014f00712c07000000
7f98ec014f00712c07000000
7f98ec014f00712c07000000
7f0d6cc0e4807194e0000000
7f98ec014f00712c07000000
7f98ec014f00712c07000000
7f0d6cc0e4807194e0000000
7f98ec014f00712c07000000
7f0d6cc0e4807194e0000000
-
{e=>4,n=>0,a=>91,m=>2,d=>-1,j=>4,l=>6,c=>0,k=>7,h=>3,b=>0,g=>3,f=>2,i=>2}
5bc0a9011301071600000000
5bc0a9011301071600000000
5bc0a9011301071600000000
5b03c4c06a0007c800000000
5bc0a9011301071600000000
5bc0a9011301071600000000
5b03c4c06a0007c800000000
5bc0a9011301071600000000
5b03c4c06a0007c800000000
-
{e=>3,n=>7,a=>-20,m=>-1,d=>-3,j=>0,l=>1,c=>3,k=>18,h=>1,b=>6,g=>4,f=>2,i=>-2}
ec5e27023100123907000000
ec5e27023100123907000000
ec5e27023100123907000000
ecceb5003800123ce0000000
ec5e27023100123907000000
ec5e27023100123907000000
ecceb5003800123ce0000000
ec5e27023100123907000000
ecceb5003800123ce0000000
-
{e=>6,n=>4,a=>46,m=>-4,d=>-2,j=>7,l=>6,c=>-3,k=>27,h=>0,b=>6,g=>7,f=>2,i=>3}
2eaead03d8011b2604000000
2eaead03d8011b2604000000
2eaead03d8011b2604000000
2ed765c00f801bd080000000
2eaead03d8011b2604000000
2eaead03d8011b2604000000
2ed765c00f801bd080000000
2eaead03d8011b2604000000
2ed765c00f801bd080000000
-
{e=>6,n=>5,a=>47,m=>-1,d=>-4,j=>7,l=>6,c=>-3,k=>-66,h=>0,b=>6,g=>0,f=>-4,i=>0}
2f2e4d00c001be3e05000000
2f2e4d00c001be3e05000000
2f2e4d00c001be3e05000000
2fd668000380bedca0000000
2f2e4d00c001be3e05000000
2f2e4d00c001be3e05000000
2fd668000380bedca0000000
2f2e4d00c001be3e05000000
2fd668000380bedca0000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  char a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>7,n=>3,a=>90,m=>-1,d=>-4,j=>1,l=>4,c=>2,k=>65,h=>5,b=>7,g=>5,f=>1,o=>24,i=>2}
5a179f025500413c03180000
5a179f025500413c03180000
5a179f025500413c03180000
5aea7340a880419c60180000
5a179f025500413c03180000
5a179f025500413c03180000
5aea7340a880419c60180000
5a179f025500413c03180000
5aea7340a880419c60180000
-
{e=>2,n=>4,a=>119,m=>3,d=>-2,j=>6,l=>0,c=>-4,k=>51,h=>3,b=>6,g=>7,f=>-4,o=>208,i=>-4}
77a6c503a301331804d00000
77a6c503a301331804d00000
77a6c503a301331804d00000
77d329c07300330c80d00000
77a6c503a301331804d00000
77a6c503a301331804d00000
77d329c07300330c80d00000
77a6c503a301331804d00000
77d329c07300330c80d00000
-
{e=>7,n=>2,a=>-108,m=>-3,d=>2,j=>4,l=>7,c=>-1,k=>14,h=>5,b=>7,g=>3,f=>3,o=>186,i=>3}
94bfbe011d010e2f02ba0000
94bfbe011d010e2f02ba0000
94bfbe011d010e2f02ba0000
94fd76c0ae000ef440ba0000
94bfbe011d010e2f02ba0000
94bfbe011d010e2f02ba0000
94fd76c0ae000ef440ba0000
94bfbe011d010e2f02ba0000
94fd76c0ae000ef440ba0000
-
{e=>6,n=>0,a=>-25,m=>-1,d=>1,j=>2,l=>3,c=>-1,k=>-23,h=>6,b=>5,g=>5,f=>2,o=>143,i=>2}
e77dac029600e93b008f0000
e77dac029600e93b008f0000
e77dac029600e93b008f0000
e7bce540c900e97c008f0000
e77dac029600e93b008f0000
e77dac029600e93b008f0000
e7bce540c900e97c008f0000
e77dac029600e93b008f0000
e7bce540c900e97c008f0000
-
{e=>3,n=>2,a=>-24,m=>0,d=>-1,j=>4,l=>3,c=>3,k=>57,h=>3,b=>7,g=>0,f=>-2,o=>223,i=>2}
e8df67001301390302df0000
e8df67001301390302df0000
e8df67001301390302df0000
e8efbc006a00396040df0000
e8df67001301390302df0000
e8df67001301390302df0000
e8efbc006a00396040df0000
e8df67001301390302df0000
e8efbc006a00396040df0000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
};
-
{a=>-22,b=>5}
eaff0500
eaff0500
eaff0500
ffeaa000
eaff0500
eaff0500
ffeaa000
eaff0500
ffeaa000
-
{a=>45,b=>7}
2d000700
2d000700
2d000700
002de000
2d000700
2d000700
002de000
2d000700
002de000
-
{a=>-48,b=>5}
d0ff0500
d0ff0500
d0ff0500
ffd0a000
d0ff0500
d0ff0500
ffd0a000
d0ff0500
ffd0a000
-
{a=>-29,b=>0}
e3ff0000
e3ff0000
e3ff0000
ffe30000
e3ff0000
e3ff0000
ffe30000
e3ff0000
ffe30000
-
{a=>124,b=>1}
7c000100
7c000100
7c000100
007c2000
7c000100
7c000100
007c2000
7c000100
007c2000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>0,a=>-68,b=>0}
bcff0000
bcff0000
bcff0000
ffbc0000
bcff0000
bcff0000
ffbc0000
bcff0000
ffbc0000
-
{c=>0,a=>-11,b=>4}
f5ff0400
f5ff0400
f5ff0400
fff58000
f5ff0400
f5ff0400
fff58000
f5ff0400
fff58000
-
{c=>-4,a=>-111,b=>3}
91ff2300
91ff2300
91ff2300
ff917000
91ff2300
91ff2300
ff917000
91ff2300
ff917000
-
{c=>-1,a=>-105,b=>0}
97ff3800
97ff3800
97ff3800
ff971c00
97ff3800
97ff3800
ff971c00
97ff3800
ff971c00
-
{c=>0,a=>-96,b=>4}
a0ff0400
a0ff0400
a0ff0400
ffa08000
a0ff0400
a0ff0400
ffa08000
a0ff0400
ffa08000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>-4,a=>-55,b=>7,d=>1}
c9ff6700
c9ff6700
c9ff6700
ffc9f080
c9ff6700
c9ff6700
ffc9f080
c9ff6700
ffc9f080
-
{c=>3,a=>59,b=>3,d=>-2}
3b009b01
3b009b01
3b009b01
003b6f00
3b009b01
3b009b01
003b6f00
3b009b01
003b6f00
-
{c=>-1,a=>-48,b=>3,d=>0}
d0ff3b00
d0ff3b00
d0ff3b00
ffd07c00
d0ff3b00
d0ff3b00
ffd07c00
d0ff3b00
ffd07c00
-
{c=>-1,a=>-29,b=>6,d=>3}
e3fffe00
e3fffe00
e3fffe00
ffe3dd80
e3fffe00
e3fffe00
ffe3dd80
e3fffe00
ffe3dd80
-
{c=>-3,a=>32,b=>0,d=>1}
20006800
20006800
20006800
00201480
20006800
20006800
00201480
20006800
00201480
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>4,c=>-3,a=>20,b=>1,d=>-3}
14006909
14006909
14006909
001436c0
14006909
14006909
001436c0
14006909
001436c0
-
{e=>3,c=>2,a=>-60,b=>0,d=>-2}
c4ff9007
c4ff9007
c4ff9007
ffc40b30
c4ff9007
c4ff9007
ffc40b30
c4ff9007
ffc40b30
-
{e=>5,c=>-3,a=>-102,b=>3,d=>-4}
9aff2b0b
9aff2b0b
9aff2b0b
ff9a7650
9aff2b0b
9aff2b0b
ff9a7650
9aff2b0b
ff9a7650
-
{e=>3,c=>-4,a=>5,b=>0,d=>1}
05006006
05006006
05006006
000510b0
05006006
05006006
000510b0
05006006
000510b0
-
{e=>4,c=>0,a=>-80,b=>6,d=>0}
b0ff0608
b0ff0608
b0ff0608
ffb0c040
b0ff0608
b0ff0608
ffb0c040
b0ff0608
ffb0c040
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>5,c=>-1,a=>-102,b=>0,d=>1,f=>0}
9aff780a
9aff780a
9aff780a
ff9a1cd0
9aff780a
9aff780a
ff9a1cd0
9aff780a
ff9a1cd0
-
{e=>4,c=>2,a=>7,b=>4,d=>-4,f=>-1}
07001479
07001479
07001479
00078a4e
07001479
07001479
00078a4e
07001479
00078a4e
-
{e=>4,c=>-1,a=>99,b=>1,d=>1,f=>-1}
63007978
63007978
63007978
00633cce
63007978
63007978
00633cce
63007978
00633cce
-
{e=>3,c=>-2,a=>-105,b=>7,d=>-4,f=>-3}
97ff3757
97ff3757
97ff3757
ff97fa3a
97ff3757
97ff3757
ff97fa3a
97ff3757
ff97fa3a
-
{e=>6,c=>-2,a=>102,b=>7,d=>-4,f=>-1}
6600377d
6600377d
6600377d
0066fa6e
6600377d
6600377d
0066fa6e
6600377d
0066fa6e
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>4,c=>0,a=>106,g=>0,b=>1,d=>-3,f=>1}
6a00411900000000
6a00411900000000
6a00411900000000
006a22c200000000
6a00411900000000
6a00411900000000
006a22c200000000
6a00411900000000
006a22c200000000
-
{e=>6,c=>-4,a=>-47,g=>4,b=>0,d=>2,f=>-1}
d1ffa07c04000000
d1ffa07c04000000
d1ffa07c04000000
ffd1116e80000000
d1ffa07c04000000
d1ffa07c04000000
ffd1116e80000000
d1ffa07c04000000
ffd1116e80000000
-
{e=>2,c=>0,a=>28,g=>2,b=>3,d=>-4,f=>-1}
1c00037502000000
1c00037502000000
1c00037502000000
001c622e40000000
1c00037502000000
1c00037502000000
001c622e40000000
1c00037502000000
001c622e40000000
-
{e=>2,c=>2,a=>8,g=>0,b=>4,d=>-3,f=>1}
0800541500000000
0800541500000000
0800541500000000
00088aa200000000
0800541500000000
0800541500000000
00088aa200000000
0800541500000000
00088aa200000000
-
{e=>7,c=>1,a=>-41,g=>1,b=>6,d=>-3,f=>-3}
d7ff4e5f01000000
d7ff4e5f01000000
d7ff4e5f01000000
ffd7c6fa20000000
d7ff4e5f01000000
d7ff4e5f01000000
ffd7c6fa20000000
d7ff4e5f01000000
ffd7c6fa20000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>2,c=>2,a=>57,g=>4,b=>4,d=>-3,f=>-3}
3900545504000000
3900545504000000
3900545504000000
00398aaa80000000
3900545504000000
3900545504000000
00398aaa80000000
3900545504000000
00398aaa80000000
-
{e=>5,c=>-1,a=>108,g=>7,b=>2,d=>-1,f=>-3}
6c00fa5b07000000
6c00fa5b07000000
6c00fa5b07000000
006c5fdae0000000
6c00fa5b07000000
6c00fa5b07000000
006c5fdae0000000
6c00fa5b07000000
006c5fdae0000000
-
{e=>3,c=>-3,a=>59,g=>1,b=>5,d=>1,f=>-2}
3b006d6601000000
3b006d6601000000
3b006d6601000000
003bb4bc20000000
3b006d6601000000
3b006d6601000000
003bb4bc20000000
3b006d6601000000
003bb4bc20000000
-
{e=>3,c=>-2,a=>82,g=>7,b=>1,d=>-1,f=>-1}
5200f17707000000
5200f17707000000
5200f17707000000
00523bbee0000000
5200f17707000000
5200f17707000000
00523bbee0000000
5200f17707000000
00523bbee0000000
-
{e=>1,c=>-1,a=>12,g=>2,b=>6,d=>3,f=>-1}
0c00fe7202000000
0c00fe7202000000
0c00fe7202000000
000cdd9e40000000
0c00fe7202000000
0c00fe7202000000
000cdd9e40000000
0c00fe7202000000
000cdd9e40000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>1,a=>50,d=>-3,c=>-2,h=>0,b=>7,g=>4,f=>-2}
320077630400000000000000
320077630400000000000000
320077630400000000000000
0032fa9c8000000000000000
320077630400000000000000
320077630400000000000000
0032fa9c8000000000000000
320077630400000000000000
0032fa9c8000000000000000
-
{e=>5,a=>40,d=>-3,c=>-4,h=>2,b=>3,g=>0,f=>3}
2800633b0000000002000000
2800633b0000000002000000
2800633b0000000002000000
002872d60000000040000000
2800633b0000000002000000
2800633b0000000002000000
002872d60000000040000000
2800633b0000000002000000
002872d60000000040000000
-
{e=>6,a=>21,d=>-1,c=>3,h=>2,b=>6,g=>7,f=>-1}
1500de7d0700000002000000
1500de7d0700000002000000
1500de7d0700000002000000
0015cfeee000000040000000
1500de7d0700000002000000
1500de7d0700000002000000
0015cfeee000000040000000
1500de7d0700000002000000
0015cfeee000000040000000
-
{e=>0,a=>-119,d=>0,c=>-1,h=>6,b=>1,g=>7,f=>3}
89ff39300700000006000000
89ff39300700000006000000
89ff39300700000006000000
ff893c06e0000000c0000000
89ff39300700000006000000
89ff39300700000006000000
ff893c06e0000000c0000000
89ff39300700000006000000
ff893c06e0000000c0000000
-
{e=>4,a=>-45,d=>2,c=>1,h=>2,b=>7,g=>7,f=>0}
d3ff8f080700000002000000
d3ff8f080700000002000000
d3ff8f080700000002000000
ffd3e540e000000040000000
d3ff8f080700000002000000
d3ff8f080700000002000000
ffd3e540e000000040000000
d3ff8f080700000002000000
ffd3e540e000000040000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
};
-
{e=>2,a=>95,d=>0,c=>-2,h=>1,b=>4,g=>3,f=>0,i=>-1}
5f0034040300000039000000
5f0034040300000039000000
5f0034040300000039000000
005f9820600000003c000000
5f0034040300000039000000
5f0034040300000039000000
005f9820600000003c000000
5f0034040300000039000000
005f9820600000003c000000
-
{e=>4,a=>34,d=>0,c=>3,h=>3,b=>2,g=>1,f=>0,i=>-1}
22001a08010000003b000000
22001a08010000003b000000
22001a08010000003b000000
00224c40200000007c000000
22001a08010000003b000000
22001a08010000003b000000
00224c40200000007c000000
22001a08010000003b000000
00224c40200000007c000000
-
{e=>7,a=>40,d=>-2,c=>-2,h=>0,b=>3,g=>1,f=>2,i=>1}
2800b32f0100000008000000
2800b32f0100000008000000
2800b32f0100000008000000
00287b742000000004000000
2800b32f0100000008000000
2800b32f0100000008000000
00287b742000000004000000
2800b32f0100000008000000
00287b742000000004000000
-
{e=>2,a=>-13,d=>-3,c=>1,h=>1,b=>0,g=>5,f=>3,i=>-2}
f3ff48350500000031000000
f3ff48350500000031000000
f3ff48350500000031000000
fff306a6a000000038000000
f3ff48350500000031000000
f3ff48350500000031000000
fff306a6a000000038000000
f3ff48350500000031000000
fff306a6a000000038000000
-
{e=>6,a=>-50,d=>0,c=>1,h=>6,b=>6,g=>5,f=>-3,i=>-2}
ceff0e5c0500000036000000
ceff0e5c0500000036000000
ceff0e5c0500000036000000
ffcec46aa0000000d8000000
ceff0e5c0500000036000000
ceff0e5c0500000036000000
ffcec46aa0000000d8000000
ceff0e5c0500000036000000
ffcec46aa0000000d8000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
};
-
{e=>0,a=>-78,d=>-2,j=>4,c=>-1,h=>1,b=>3,g=>6,f=>-3,i=>-2}
b2ffbb510600000031010000
b2ffbb510600000031010000
b2ffbb510600000031010000
ffb27f0ac00000003a000000
b2ffbb510600000031010000
b2ffbb510600000031010000
ffb27f0ac00000003a000000
b2ffbb510600000031010000
ffb27f0ac00000003a000000
-
{e=>7,a=>76,d=>-2,j=>1,c=>-4,h=>5,b=>6,g=>3,f=>-4,i=>2}
4c00a64f0300000055000000
4c00a64f0300000055000000
4c00a64f0300000055000000
004cd37860000000a8800000
4c00a64f0300000055000000
4c00a64f0300000055000000
004cd37860000000a8800000
4c00a64f0300000055000000
004cd37860000000a8800000
-
{e=>7,a=>88,d=>0,j=>0,c=>1,h=>1,b=>1,g=>1,f=>1,i=>2}
5800091e0100000011000000
5800091e0100000011000000
5800091e0100000011000000
005824722000000028000000
5800091e0100000011000000
5800091e0100000011000000
005824722000000028000000
5800091e0100000011000000
005824722000000028000000
-
{e=>7,a=>-27,d=>0,j=>7,c=>-1,h=>1,b=>0,g=>0,f=>-4,i=>-1}
e5ff384e00000000f9010000
e5ff384e00000000f9010000
e5ff384e00000000f9010000
ffe51c78000000003f800000
e5ff384e00000000f9010000
e5ff384e00000000f9010000
ffe51c78000000003f800000
e5ff384e00000000f9010000
ffe51c78000000003f800000
-
{e=>1,a=>-99,d=>-3,j=>3,c=>1,h=>5,b=>1,g=>6,f=>3,i=>3}
9dff493306000000dd000000
9dff493306000000dd000000
9dff493306000000dd000000
ff9d2696c0000000ad800000
9dff493306000000dd000000
9dff493306000000dd000000
ff9d2696c0000000ad800000
9dff493306000000dd000000
ff9d2696c0000000ad800000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
};
-
{e=>2,a=>4,d=>1,j=>5,c=>-3,k=>75,h=>5,b=>0,g=>2,f=>3,i=>-1}
04006834020000007d014b00
04006834020000007d014b00
04006834020000007d014b00
000414a640000000be804b00
04006834020000007d014b00
04006834020000007d014b00
000414a640000000be804b00
04006834020000007d014b00
000414a640000000be804b00
-
{e=>5,a=>7,d=>-2,j=>1,c=>0,k=>19,h=>4,b=>6,g=>6,f=>3,i=>1}
0700863b060000004c001300
0700863b060000004c001300
0700863b060000004c001300
0007c356c000000084801300
0700863b060000004c001300
0700863b060000004c001300
0007c356c000000084801300
0700863b060000004c001300
0007c356c000000084801300
-
{e=>2,a=>57,d=>1,j=>0,c=>1,k=>89,h=>1,b=>3,g=>6,f=>3,i=>1}
39004b340600000009005900
39004b340600000009005900
39004b340600000009005900
003964a6c000000024005900
39004b340600000009005900
39004b340600000009005900
003964a6c000000024005900
39004b340600000009005900
003964a6c000000024005900
-
{e=>4,a=>7,d=>0,j=>2,c=>-1,k=>-8,h=>3,b=>7,g=>4,f=>-1,i=>-4}
07003f7804000000a300f800
07003f7804000000a300f800
07003f7804000000a300f800
0007fc4e800000007100f800
07003f7804000000a300f800
07003f7804000000a300f800
0007fc4e800000007100f800
07003f7804000000a300f800
0007fc4e800000007100f800
-
{e=>5,a=>105,d=>3,j=>1,c=>3,k=>119,h=>7,b=>7,g=>0,f=>0,i=>-2}
6900df0a0000000077007700
6900df0a0000000077007700
6900df0a0000000077007700
0069edd000000000f8807700
6900df0a0000000077007700
6900df0a0000000077007700
0069edd000000000f8807700
6900df0a0000000077007700
0069edd000000000f8807700
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
};
-
{e=>3,a=>-68,d=>3,j=>1,l=>0,c=>-3,k=>40,h=>5,b=>6,g=>0,f=>0,i=>2}
bcffee060000000055002800
bcffee060000000055002800
bcffee060000000055002800
ffbcd5b000000000a8802800
bcffee060000000055002800
bcffee060000000055002800
ffbcd5b000000000a8802800
bcffee060000000055002800
ffbcd5b000000000a8802800
-
{e=>6,a=>84,d=>-4,j=>4,l=>0,c=>1,k=>100,h=>2,b=>1,g=>6,f=>3,i=>2}
5400093d0600000012016400
5400093d0600000012016400
5400093d0600000012016400
00542666c00000004a006400
5400093d0600000012016400
5400093d0600000012016400
00542666c00000004a006400
5400093d0600000012016400
00542666c00000004a006400
-
{e=>2,a=>-8,d=>-4,j=>2,l=>4,c=>-2,k=>-68,h=>2,b=>6,g=>5,f=>-1,i=>-1}
f8ff367505000000ba00bc04
f8ff367505000000ba00bc04
f8ff367505000000ba00bc04
fff8da2ea00000005d00bc80
f8ff367505000000ba00bc04
f8ff367505000000ba00bc04
fff8da2ea00000005d00bc80
f8ff367505000000ba00bc04
fff8da2ea00000005d00bc80
-
{e=>0,a=>-64,d=>3,j=>4,l=>1,c=>-4,k=>-2,h=>3,b=>1,g=>4,f=>-3,i=>-3}
c0ffe150040000002b01fe01
c0ffe150040000002b01fe01
c0ffe150040000002b01fe01
ffc0318a800000007600fe20
c0ffe150040000002b01fe01
c0ffe150040000002b01fe01
ffc0318a800000007600fe20
c0ffe150040000002b01fe01
ffc0318a800000007600fe20
-
{e=>5,a=>64,d=>-4,j=>6,l=>7,c=>0,k=>13,h=>2,b=>4,g=>7,f=>-4,i=>3}
4000044b070000009a010d07
4000044b070000009a010d07
4000044b070000009a010d07
00408258e00000004f000de0
4000044b070000009a010d07
4000044b070000009a010d07
00408258e00000004f000de0
4000044b070000009a010d07
00408258e00000004f000de0
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
};
-
{e=>2,a=>-53,m=>2,d=>0,j=>4,l=>6,c=>0,k=>-28,h=>4,b=>1,g=>0,f=>0,i=>-1}
cbff0104000000003c01e416
cbff0104000000003c01e416
cbff0104000000003c01e416
ffcb2020000000009e00e4c8
cbff0104000000003c01e416
cbff0104000000003c01e416
ffcb2020000000009e00e4c8
cbff0104000000003c01e416
ffcb2020000000009e00e4c8
-
{e=>2,a=>-58,m=>-4,d=>-3,j=>7,l=>1,c=>1,k=>-110,h=>4,b=>2,g=>5,f=>-2,i=>1}
c6ff4a6505000000cc019221
c6ff4a6505000000cc019221
c6ff4a6505000000cc019221
ffc646aca000000087809230
c6ff4a6505000000cc019221
c6ff4a6505000000cc019221
ffc646aca000000087809230
c6ff4a6505000000cc019221
ffc646aca000000087809230
-
{e=>2,a=>-95,m=>1,d=>2,j=>3,l=>1,c=>2,k=>47,h=>7,b=>5,g=>2,f=>3,i=>0}
a1ff953402000000c7002f09
a1ff953402000000c7002f09
a1ff953402000000c7002f09
ffa1a92640000000e1802f24
a1ff953402000000c7002f09
a1ff953402000000c7002f09
ffa1a92640000000e1802f24
a1ff953402000000c7002f09
ffa1a92640000000e1802f24
-
{e=>2,a=>86,m=>0,d=>-1,j=>3,l=>0,c=>3,k=>-1,h=>4,b=>3,g=>1,f=>0,i=>-3}
5600db0501000000ec00ff00
5600db0501000000ec00ff00
5600db0501000000ec00ff00
00566fa0200000009580ff00
5600db0501000000ec00ff00
5600db0501000000ec00ff00
00566fa0200000009580ff00
5600db0501000000ec00ff00
00566fa0200000009580ff00
-
{e=>5,a=>31,m=>-3,d=>1,j=>4,l=>5,c=>1,k=>1,h=>6,b=>1,g=>2,f=>2,i=>-4}
1f00492a020000002601012d
1f00492a020000002601012d
1f00492a020000002601012d
001f24d440000000d20001b4
1f00492a020000002601012d
1f00492a020000002601012d
001f24d440000000d20001b4
1f00492a020000002601012d
001f24d440000000d20001b4
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
};
-
{e=>4,n=>3,a=>-119,m=>-2,d=>0,j=>0,l=>0,c=>3,k=>127,h=>3,b=>3,g=>0,f=>-3,i=>-3}
89ff1b58000000002b007f3003000000
89ff1b58000000002b007f3003000000
89ff1b58000000002b007f3003000000
ff896c4a0000000074007f1860000000
89ff1b58000000002b007f3003000000
89ff1b58000000002b007f3003000000
ff896c4a0000000074007f1860000000
89ff1b58000000002b007f3003000000
ff896c4a0000000074007f1860000000
-
{e=>2,n=>3,a=>47,m=>-4,d=>1,j=>6,l=>7,c=>1,k=>-126,h=>6,b=>1,g=>2,f=>-2,i=>-4}
2f00496402000000a601822703000000
2f00496402000000a601822703000000
2f00496402000000a601822703000000
002f24ac40000000d30082f060000000
2f00496402000000a601822703000000
2f00496402000000a601822703000000
002f24ac40000000d30082f060000000
2f00496402000000a601822703000000
002f24ac40000000d30082f060000000
-
{e=>6,n=>4,a=>-16,m=>3,d=>-4,j=>3,l=>3,c=>2,k=>-100,h=>4,b=>4,g=>3,f=>-1,i=>3}
f0ff147d03000000dc009c1b04000000
f0ff147d03000000dc009c1b04000000
f0ff147d03000000dc009c1b04000000
fff08a6e600000008d809c6c80000000
f0ff147d03000000dc009c1b04000000
f0ff147d03000000dc009c1b04000000
fff08a6e600000008d809c6c80000000
f0ff147d03000000dc009c1b04000000
fff08a6e600000008d809c6c80000000
-
{e=>0,n=>3,a=>99,m=>-3,d=>-4,j=>4,l=>1,c=>-1,k=>-77,h=>3,b=>1,g=>0,f=>-2,i=>3}
63003961000000001b01b32903000000
63003961000000001b01b32903000000
63003961000000001b01b32903000000
00633e0c000000006e00b33460000000
63003961000000001b01b32903000000
63003961000000001b01b32903000000
00633e0c000000006e00b33460000000
63003961000000001b01b32903000000
00633e0c000000006e00b33460000000
-
{e=>5,n=>0,a=>-106,m=>-2,d=>-4,j=>7,l=>7,c=>-3,k=>-97,h=>3,b=>3,g=>2,f=>1,i=>-3}
96ff2b1b02000000eb019f3700000000
96ff2b1b02000000eb019f3700000000
96ff2b1b02000000eb019f3700000000
ff9676524000000077809ff800000000
96ff2b1b02000000eb019f3700000000
96ff2b1b02000000eb019f3700000000
ff9676524000000077809ff800000000
96ff2b1b02000000eb019f3700000000
ff9676524000000077809ff800000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  short a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
  signed   char i:3;
  unsigned int  j:3;
  char          k;
  unsigned char l:3;
  signed   char m:3;
  unsigned int  n:3;
  unsigned char o;
};
-
{e=>3,n=>7,a=>-113,m=>1,d=>-3,j=>5,l=>0,c=>1,k=>2,h=>6,b=>0,g=>5,f=>-2,o=>22,i=>0}
8fff4867050000004601020807160000
8fff4867050000004601020807160000
8fff4867050000004601020807160000
ff8f06bca0000000c2800204e0160000
8fff4867050000004601020807160000
8fff4867050000004601020807160000
ff8f06bca0000000c2800204e0160000
8fff4867050000004601020807160000
ff8f06bca0000000c2800204e0160000
-
{e=>6,n=>7,a=>-82,m=>-2,d=>-3,j=>7,l=>3,c=>-1,k=>-116,h=>6,b=>1,g=>5,f=>2,o=>227,i=>-2}
aeff792d05000000f6018c3307e30000
aeff792d05000000f6018c3307e30000
aeff792d05000000f6018c3307e30000
ffae3ee4a0000000db808c78e0e30000
aeff792d05000000f6018c3307e30000
aeff792d05000000f6018c3307e30000
ffae3ee4a0000000db808c78e0e30000
aeff792d05000000f6018c3307e30000
ffae3ee4a0000000db808c78e0e30000
-
{e=>1,n=>4,a=>-117,m=>-2,d=>-2,j=>2,l=>5,c=>1,k=>-17,h=>3,b=>6,g=>3,f=>-4,o=>238,i=>-2}
8bff8e4303000000b300ef3504ee0000
8bff8e4303000000b300ef3504ee0000
8bff8e4303000000b300ef3504ee0000
ff8bc718600000007900efb880ee0000
8bff8e4303000000b300ef3504ee0000
8bff8e4303000000b300ef3504ee0000
ff8bc718600000007900efb880ee0000
8bff8e4303000000b300ef3504ee0000
ff8bc718600000007900efb880ee0000
-
{e=>4,n=>6,a=>62,m=>-2,d=>3,j=>0,l=>4,c=>2,k=>119,h=>2,b=>7,g=>6,f=>0,o=>141,i=>-4}
3e00d7080600000022007734068d0000
3e00d7080600000022007734068d0000
3e00d7080600000022007734068d0000
003ee9c0c000000050007798c08d0000
3e00d7080600000022007734068d0000
3e00d7080600000022007734068d0000
003ee9c0c000000050007798c08d0000
3e00d7080600000022007734068d0000
003ee9c0c000000050007798c08d0000
-
{e=>0,n=>5,a=>59,m=>0,d=>1,j=>3,l=>5,c=>-2,k=>-64,h=>0,b=>7,g=>0,f=>-4,o=>130,i=>3}
3b00774000000000d800c00505820000
3b00774000000000d800c00505820000
3b00774000000000d800c00505820000
003bf888000000000d80c0a0a0820000
3b00774000000000d800c00505820000
3b00774000000000d800c00505820000
003bf888000000000d80c0a0a0820000
3b00774000000000d800c00505820000
003bf888000000000d80c0a0a0820000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
};
-
{a=>-25,b=>5}
e7ffffff05000000
e7ffffff05000000
e7ffffff05000000
ffffffe7a0000000
e7ffffff05000000
e7ffffff05000000
ffffffe7a0000000
e7ffffff05000000
ffffffe7a0000000
-
{a=>10,b=>1}
0a00000001000000
0a00000001000000
0a00000001000000
0000000a20000000
0a00000001000000
0a00000001000000
0000000a20000000
0a00000001000000
0000000a20000000
-
{a=>8,b=>7}
0800000007000000
0800000007000000
0800000007000000
00000008e0000000
0800000007000000
0800000007000000
00000008e0000000
0800000007000000
00000008e0000000
-
{a=>-93,b=>6}
a3ffffff06000000
a3ffffff06000000
a3ffffff06000000
ffffffa3c0000000
a3ffffff06000000
a3ffffff06000000
ffffffa3c0000000
a3ffffff06000000
ffffffa3c0000000
-
{a=>-67,b=>1}
bdffffff01000000
bdffffff01000000
bdffffff01000000
ffffffbd20000000
bdffffff01000000
bdffffff01000000
ffffffbd20000000
bdffffff01000000
ffffffbd20000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
};
-
{c=>0,a=>-12,b=>7}
f4ffffff07000000
f4ffffff07000000
f4ffffff07000000
fffffff4e0000000
f4ffffff07000000
f4ffffff07000000
fffffff4e0000000
f4ffffff07000000
fffffff4e0000000
-
{c=>-4,a=>99,b=>7}
6300000027000000
6300000027000000
6300000027000000
00000063f0000000
6300000027000000
6300000027000000
00000063f0000000
6300000027000000
00000063f0000000
-
{c=>1,a=>18,b=>7}
120000000f000000
120000000f000000
120000000f000000
00000012e4000000
120000000f000000
120000000f000000
00000012e4000000
120000000f000000
00000012e4000000
-
{c=>2,a=>43,b=>7}
2b00000017000000
2b00000017000000
2b00000017000000
0000002be8000000
2b00000017000000
2b00000017000000
0000002be8000000
2b00000017000000
0000002be8000000
-
{c=>-4,a=>34,b=>0}
2200000020000000
2200000020000000
2200000020000000
0000002210000000
2200000020000000
2200000020000000
0000002210000000
2200000020000000
0000002210000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
};
-
{c=>-2,a=>26,b=>4,d=>1}
1a00000074000000
1a00000074000000
1a00000074000000
0000001a98800000
1a00000074000000
1a00000074000000
0000001a98800000
1a00000074000000
0000001a98800000
-
{c=>-3,a=>42,b=>5,d=>0}
2a0000002d000000
2a0000002d000000
2a0000002d000000
0000002ab4000000
2a0000002d000000
2a0000002d000000
0000002ab4000000
2a0000002d000000
0000002ab4000000
-
{c=>3,a=>115,b=>3,d=>-4}
730000001b010000
730000001b010000
730000001b010000
000000736e000000
730000001b010000
730000001b010000
000000736e000000
730000001b010000
000000736e000000
-
{c=>1,a=>21,b=>4,d=>-2}
150000008c010000
150000008c010000
150000008c010000
0000001587000000
150000008c010000
150000008c010000
0000001587000000
150000008c010000
0000001587000000
-
{c=>1,a=>124,b=>0,d=>-2}
7c00000088010000
7c00000088010000
7c00000088010000
0000007c07000000
7c00000088010000
7c00000088010000
0000007c07000000
7c00000088010000
0000007c07000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
};
-
{e=>1,c=>-3,a=>-59,b=>7,d=>-3}
c5ffffff6f030000
c5ffffff6f030000
c5ffffff6f030000
ffffffc5f6900000
c5ffffff6f030000
c5ffffff6f030000
ffffffc5f6900000
c5ffffff6f030000
ffffffc5f6900000
-
{e=>5,c=>3,a=>96,b=>7,d=>1}
600000005f0a0000
600000005f0a0000
600000005f0a0000
00000060ecd00000
600000005f0a0000
600000005f0a0000
00000060ecd00000
600000005f0a0000
00000060ecd00000
-
{e=>6,c=>-3,a=>97,b=>1,d=>1}
61000000690c0000
61000000690c0000
61000000690c0000
0000006134e00000
61000000690c0000
61000000690c0000
0000006134e00000
61000000690c0000
0000006134e00000
-
{e=>0,c=>-3,a=>45,b=>5,d=>-2}
2d000000ad010000
2d000000ad010000
2d000000ad010000
0000002db7000000
2d000000ad010000
2d000000ad010000
0000002db7000000
2d000000ad010000
0000002db7000000
-
{e=>5,c=>-4,a=>-125,b=>0,d=>1}
83ffffff600a0000
83ffffff600a0000
83ffffff600a0000
ffffff8310d00000
83ffffff600a0000
83ffffff600a0000
ffffff8310d00000
83ffffff600a0000
ffffff8310d00000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
};
-
{e=>6,c=>3,a=>-75,b=>2,d=>-3,f=>0}
b5ffffff5a0d0000
b5ffffff5a0d0000
b5ffffff5a0d0000
ffffffb54ee00000
b5ffffff5a0d0000
b5ffffff5a0d0000
ffffffb54ee00000
b5ffffff5a0d0000
ffffffb54ee00000
-
{e=>5,c=>-4,a=>-82,b=>3,d=>3,f=>1}
aeffffffe31a0000
aeffffffe31a0000
aeffffffe31a0000
ffffffae71d20000
aeffffffe31a0000
aeffffffe31a0000
ffffffae71d20000
aeffffffe31a0000
ffffffae71d20000
-
{e=>7,c=>1,a=>53,b=>4,d=>-2,f=>0}
350000008c0f0000
350000008c0f0000
350000008c0f0000
0000003587700000
350000008c0f0000
350000008c0f0000
0000003587700000
350000008c0f0000
0000003587700000
-
{e=>1,c=>2,a=>126,b=>6,d=>-3,f=>0}
7e00000056030000
7e00000056030000
7e00000056030000
0000007eca900000
7e00000056030000
7e00000056030000
0000007eca900000
7e00000056030000
0000007eca900000
-
{e=>3,c=>0,a=>11,b=>4,d=>-1,f=>-1}
0b000000c4770000
0b000000c4770000
0b000000c4770000
0000000b83be0000
0b000000c4770000
0b000000c4770000
0000000b83be0000
0b000000c4770000
0000000b83be0000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
};
-
{e=>2,c=>-1,a=>-28,g=>6,b=>6,d=>1,f=>-2}
e4ffffff7e640300
e4ffffff7e640300
e4ffffff7e640300
ffffffe4dcad8000
e4ffffff7e640300
e4ffffff7e640300
ffffffe4dcad8000
e4ffffff7e640300
ffffffe4dcad8000
-
{e=>1,c=>2,a=>-122,g=>5,b=>3,d=>2,f=>-2}
86ffffff93e20200
86ffffff93e20200
86ffffff93e20200
ffffff86691d4000
86ffffff93e20200
86ffffff93e20200
ffffff86691d4000
86ffffff93e20200
ffffff86691d4000
-
{e=>7,c=>-2,a=>-4,g=>7,b=>7,d=>1,f=>3}
fcffffff77be0300
fcffffff77be0300
fcffffff77be0300
fffffffcf8f7c000
fcffffff77be0300
fcffffff77be0300
fffffffcf8f7c000
fcffffff77be0300
fffffffcf8f7c000
-
{e=>3,c=>-1,a=>-107,g=>6,b=>5,d=>-4,f=>-3}
95ffffff3d570300
95ffffff3d570300
95ffffff3d570300
ffffff95be3b8000
95ffffff3d570300
95ffffff3d570300
ffffff95be3b8000
95ffffff3d570300
ffffff95be3b8000
-
{e=>2,c=>1,a=>-115,g=>0,b=>7,d=>2,f=>0}
8dffffff8f040000
8dffffff8f040000
8dffffff8f040000
ffffff8de5200000
8dffffff8f040000
8dffffff8f040000
ffffff8de5200000
8dffffff8f040000
ffffff8de5200000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
};
-
{e=>4,c=>1,a=>-92,g=>6,b=>5,d=>-4,f=>-4}
a4ffffff0d490300
a4ffffff0d490300
a4ffffff0d490300
ffffffa4a6498000
a4ffffff0d490300
a4ffffff0d490300
ffffffa4a6498000
a4ffffff0d490300
ffffffa4a6498000
-
{e=>3,c=>3,a=>112,g=>1,b=>4,d=>0,f=>-3}
700000001cd60000
700000001cd60000
700000001cd60000
000000708c3a4000
700000001cd60000
700000001cd60000
000000708c3a4000
700000001cd60000
000000708c3a4000
-
{e=>2,c=>1,a=>-90,g=>7,b=>2,d=>1,f=>0}
a6ffffff4a840300
a6ffffff4a840300
a6ffffff4a840300
ffffffa644a1c000
a6ffffff4a840300
a6ffffff4a840300
ffffffa644a1c000
a6ffffff4a840300
ffffffa644a1c000
-
{e=>1,c=>3,a=>20,g=>3,b=>6,d=>-1,f=>-4}
14000000dec30100
14000000dec30100
14000000dec30100
00000014cf98c000
14000000dec30100
14000000dec30100
00000014cf98c000
14000000dec30100
00000014cf98c000
-
{e=>0,c=>1,a=>-18,g=>4,b=>0,d=>-2,f=>-2}
eeffffff88610200
eeffffff88610200
eeffffff88610200
ffffffee070d0000
eeffffff88610200
eeffffff88610200
ffffffee070d0000
eeffffff88610200
ffffffee070d0000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed   int  c:3;
  foo           d:3;
  unsigned char e:3;
  signed   char f:3;
  unsigned int  g:3;
  int            :0;
  unsigned char h:3;
};
-
{e=>6,a=>38,d=>-1,c=>-1,h=>0,b=>7,g=>7,f=>3}
26000000ffbd030000000000
26000000ffbd030000000000
26000000ffbd030000000000
00000026ffe7c00000000000
26000000ffbd030000000000
26000000ffbd030000000000
00000026ffe7c00000000000
26000000ffbd030000000000
00000026ffe7c00000000000
-
{e=>6,a=>31,d=>3,c=>2,h=>1,b=>2,g=>0,f=>3}
1f000000d23c000001000000
1f000000d23c000001000000
1f000000d23c000001000000
0000001f49e6000020000000
1f000000d23c000001000000
1f000000d23c000001000000
0000001f49e6000020000000
1f000000d23c000001000000
0000001f49e6000020000000
-
{e=>7,a=>-56,d=>-4,c=>0,h=>5,b=>1,g=>2,f=>-4}
c8ffffff014f010005000000
c8ffffff014f010005000000
c8ffffff014f010005000000
ffffffc822788000a0000000
c8ffffff014f010005000000
c8ffffff014f010005000000
ffffffc822788000a0000000
c8ffffff014f010005000000
ffffffc822788000a0000000
-
{e=>7,a=>119,d=>2,c=>-4,h=>5,b=>7,g=>0,f=>-3}
77000000a75e000005000000
77000000a75e000005000000
77000000a75e000005000000
00000077f17a0000a0000000
77000000a75e000005000000
77000000a75e000005000000
00000077f17a0000a0000000
77000000a75e000005000000
00000077f17a0000a0000000
-
{e=>7,a=>-122,d=>3,c=>3,h=>6,b=>2,g=>7,f=>2}
86ffffffdaae030006000000
86ffffffdaae030006000000
86ffffffdaae030006000000
ffffff864df5c000c0000000
86ffffffdaae030006000000
86ffffffdaae030006000000
ffffff864df5c000c0000000
86ffffffdaae030006000000
ffffff864df5c000c0000000
=
typedef int foo;

#if defined PACK_PAREN
#pragma pack( 1 )
#elif defined PACK_NO_PAREN
#pragma pack 1
#endif
struct mixed_pack_1 {
  int a;
  unsigned int  b:3;
  signed  