#!/usr/bin/perl

use strict;
use DBI;
use CGI;
use CGI::Authentication;

# == connect to the database
my ($host,$db,$user,$pass) = ('localhost','dev','root','pass123');
my $dbh = DBI->connect("DBI:mysql:database=$db;host=$host",$user,$pass,{RaiseError => 0});

# == setup the CGI
my $cgi = new CGI;

# == setup the Authentication module
my $auth = CGI::Authentication->new({
		title	=> 'Application Title',
		cgi	=> $cgi,
		dbh	=> $dbh,
		footer	=> 'Sample page'
	});

# == Add a refresh menu on menu1, which will be there regardless if you're logged on or not.  This is just for show..
$auth->render_menu(1,'Refresh','?');

# == we need to print the header.  This is simiar to $cgi->header, except this one will also generate a unique session ID
print $auth->header();

# == now we call the authenticate procedure (default username is admin, password is password)
$auth->authenticate();

# == if you make it this far, you managed to log on successfully

# Do not print stuff directly.  Well, you could, but we want to use the templating feature.  So instead, let's define a global
# variable called $content

my $content = "Hello.  You are " . $auth->username() . " with a unique user ID of " . $auth->{id} . "<br>Your session is " . $auth->{sessionid};

# == Add the content to the template
$auth->render_param('CONTENT',$content);

# == we want to show some links once the user has logged on
$auth->render_menu(2,'News','http://news.google.com');
$auth->render_menu(2,'SMH','http://www.smh.com.au');

$auth->render_menu(3,'Google','http://www.google.com');
$auth->render_menu(3,'Yahoo','http://www.yahoo.com');

# == show it
print $auth->render_output();

# == disconnect and clean up
$dbh->disconnect();
exit(0);
