use v6;

use Semi-xml;
use TMap::Variant;


package TMap:ver<0.2.0> {

  role TopicName {

    # Topic parent
    #
    has $.t-parent;

    has Str $.value;
    has $.type;
    has TMap::Variant @.variants;
    has @.scopes;

    #---------------------------------------------------------------------------
    # Initialize name element
    #
    method initialize ( $topic where $topic.name eq 'topic' ) {
      $!t-parent = $topic;
      self.check-item-identifiers;
      self.set-reifier($topic);

      for self.nodes -> $n-node {
        if $n-node ~~ XML::Element {
          given $n-node.name {

            # If value get basename of topic
            #
            when 'value' {
              $!value = self.get-text-value($n-node);
  say "Name value: {self.get('value')}";
            }

            # Get the type of this name value
            #
            when 'type' {

              for $n-node.nodes -> $t-node {
                if $t-node ~~ XML::Element
                   and $t-node.name eq 'topicRef'
                   and $t-node.attribs<href> {

                  my $tref = self.modify-topic-reference(
                    self.get('filename'),
                    $t-node.attribs<href>
                  );

                  $!type = $topic.get-topic-from-id($tref);
say "Name type: ", $!type.attribs<id>;

                  # Only one type/role
                  #
                  last;
                }
              }
            }

            # Get scope of this name value
            #
            when 'scope' {
            
              my @trefs = self.get-topic-references($n-node);

              for @trefs -> $tref {
                my $scope = $topic.get-topic-from-id($tref);
                if ?$scope {

                  # Store id as string. Later when checked get object of
                  # reference
                  #
                  @!scopes.push($scope);
say "Name scope: ", $scope.attribs<id>;
                }
              }
            }

            # Get any variants
            #
            when 'variant' {

              # Promote to variant
              #
              $n-node does TMap::Variant;
              my TMap::Variant $variant := $n-node;
              $variant.initialize( self, $topic);
            }
          }
        }
      }
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'value' ) { return $!value; }
    multi method get ( 'parent' ) { return $!t-parent; }
    multi method get ( 'type' ) { return $!type; }
    multi method get ( 'variants' ) { return @!variants; }
  }
}
