#!/usr/bin/env perl6

use v6;
use OWL::IRI;
use OWL::Ontology;

say '';

OWL::IRI.prefix(local-name => 'file://Perl6/Projects/OWL#');
my OWL::Ontology $o .= new(:iri('file://Perl6/Projects/OWL#'));

$o.declaration( [
    class               => <person human>,
    named-individual    => <Mary Bill Susan>,
    object-property     => <has-parent has-son has-daughter>,
    data-property       => <age>,
    data-type           => <person-age>,
  ]
);

$o.sub-class-of( [
    # woman, man ... are subclasses of person
    #
    person              => <woman man father mother>,
  ]
);

$o.class-assertion( [
    man                 => <Bill>,
    father              => <Bill>,

    woman               => <Mary Susan>,
    mother              => <Mary>,

    Bill                => <alone>,
  ]
);

$o.data-property-range( [
    has-name            => 'xsd:string',
    age                 => 'xsd:integer',
  ]
);

$o.data-property-assertion( [
    has-name            => Bill => 'Billy Turf',
    age                 => Bill => 51,
  ]
);

