package Bundle::MARCEL;

use strict;
use warnings;


our $VERSION = '0.01';


1;


__END__

=head1 NAME

Bundle::MARCEL - install (nearly) all modules by MARCEL

=head1 SYNOPSIS

    cpan Bundle::MARCEL

=head1 DESCRIPTION

This bundle contains all distributions by the CPAN author MARCEL. It is useful
if you want to set up a development environment for these modules so you can
easily make sure that all the dependencies are installed. You would probably
only want to do this if you are MARCEL.

=head1 CONTENTS

Acme::Tiroler

App::vget

Aspect

Attribute::Overload

Attribute::TieClasses

Attribute::Util

Carp::Source

Class::Accessor::Complex

Class::Accessor::Constructor

Class::Accessor::FactoryTyped

Class::Accessor::Installer

Class::Factory::Enhanced

Class::Null

Class::Scaffold

Class::Value

Class::Value::Contact

Class::Value::Net

Data::Comparable

Data::Container

Data::Conveyor

Data::Inherited

Data::Miscellany

Data::Storage

DBIx::Lookup::Field

Devel::SearchINC

Devel::TraceINC

Dist::Joseki

Error::Hierarchy

Exporter::Simple

Games::Go::Coordinate

Games::Go::Rank

Getopt::Attribute

GraphViz::DBI

GraphViz::ISA

Hook::Modular

Module::Changes

Module::Cloud

Module::Install::StandardTests

Net::IP::Match

Number::Rangify

Regexp::Common::AT::NICAT

Scalar::Properties

ShipIt::Step::CheckYAMLChangeLog

ShipIt::Step::DistClean

ShipIt::Step::Manifest

String::BlackWhiteList

String::FlexMatch

Sub::CharacterProperties

Term::Shell::Enhanced

Test::CompanionClasses

Test::Compile

Test::Distribution

Text::UpsideDown

Tie::Scalar::Timeout

YAML::Active

=head1 TAGS

If you talk about this module in blogs, on del.icio.us or anywhere else,
please use the C<bundlemarcel> tag.

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-bundle-marcel@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.

=head1 INSTALLATION

See perlmodinstall for information and options on installing Perl modules.

=head1 AVAILABILITY

The latest version of this module is available from the Comprehensive Perl
Archive Network (CPAN). Visit <http://www.perl.com/CPAN/> to find a CPAN
site near you. Or see <http://www.perl.com/CPAN/authors/id/M/MA/MARCEL/>.

=head1 AUTHOR

Marcel GrE<uuml>nauer, C<< <marcel@cpan.org> >>

=head1 COPYRIGHT AND LICENSE

Copyright 2007 by Marcel GrE<uuml>nauer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

