#!/usr/bin/perl

use strict;
use warnings;
use WebService::Google::Client::Discovery;
use WebService::Google::Client;
use Data::Dumper;
use JSON;
use Text::Table;
use JSON::PP::Boolean;
use Carp;
use CHI;
use feature 'say';
use GraphViz::Data::Grapher; ## see also alterntative use GraphViz::Data::Structure;

=pod

=head1 discovery_example.pl

=head2 ABSTRACT

This code is being used to explore functionality realted to service discovery. 
The intent is to learn about how the current code works and whether it can be 
made to work as advertised. 
Also whether this approach is appropriate and to explore alternative ways of representing
and interfacing with the discovery data structures of services.

=cut

#my $ret;
#my $ret = WebService::Google::Client::Discovery->new( debug => 1 )->get_resource_meta('WebService::Google::Client::Calendar::Events'); ## ::CalendarList::delete
my $ret = WebService::Google::Client::Discovery->new( debug => 1 )->get_resource_meta('WebService::Google::Client::Gmail::Users'); ## ::CalendarList::delete


print "ret = " . $ret ."\n";
print "ref = " . ref( $ret ) . "\n";

#print "FINAL RESULT DUMPER = " . Dumper $ret;

print "FINAL RESULT METHODS = ". join(',',  sort keys %{$ret->{methods}} ) . "\n";
print "CHI Namespace = " . WebService::Google::Client::Discovery->new()->chi->{namespace} . "\n";
print "CHI Root = " . WebService::Google::Client::Discovery->new()->chi->root_dir . "\n";
exit;

my $aapis = WebService::Google::Client::Discovery->new->available_APIs();

for my $api ( @{ $aapis } )
{
  #print Dumper $api;
    my @clean_doclinks = grep { defined $_ } @{ $api->{ doclinks } }; ## was seeing undef in doclinks array - eg 'surveys'causing warnings in join
    my %seen = ();
    my $doclinks = join( ',', ( grep { !$seen{ $_ }++  } @clean_doclinks ) ) || '';    ## unique doclinks as string
    print "$api->{ name } - $doclinks\n";
}

exit;

print WebService::Google::Client::Discovery->new->supported_as_text();
exit;




if ( 1 == 0 ) ## initial play to explore how CHI works and whether could be applied - informed integration of CHI into WebService::Google::Client::Discovery
{
    print "Package = " . __PACKAGE__ . "\n";
    #my $x =   discovery_data();
    #say Dumper $x;
    my $cache = CHI->new(  driver => 'File', namespace =>__PACKAGE__ );
    say $cache->root_dir;
    if ( my $expires_at = $cache->get_expires_at(  'discovery_data' ) ) 
    {
      say "expires  in ", scalar($expires_at) - time(), " seconds";
    }
    else
    {
      $cache->set( 'discovery_data', WebService::Google::Client::Discovery->new->discover_all, '10d' );
      say "Sleeping after web fetch - are you feeling the pain sufficiently ? "; sleep(5);
    }
    my $dd = $cache->get( 'discovery_data');
    say Dumper $dd;
    say render_services_as_formatted_table( $dd );
    exit;
}

#$cache->set( 'discovery_data', Dumper $x );
#exit;

my $d = WebService::Google::Client::Discovery->new->discover_all;
say render_services_as_formatted_table($d);
#exit;


$d = WebService::Google::Client::Discovery->new;
#say Dumper $d->get_rest({ api=> 'calendar', version => 'v3' });

my $discovered_api_spec = $d->get_rest({ api=> 'gmail', version => 'v1' });
say Dumper  $discovered_api_spec;
#exit;

## GRAPH SCHEMA AS PNG AS WRITE OUT AS json .. nb from command line use: pp_json < filename.json 
if ( 1==1 )
{
  foreach my $schemakey ( keys %{$discovered_api_spec->{schemas}} )
  {
    
    ## GraphViz::Data::Grapher borks on any contained quotes so serialising, removing and restoring
    my $clean_json = to_json( $discovered_api_spec->{schemas}{$schemakey} );
    $clean_json =~ s/\\"/'/msxg;
    my $clean = from_json(  $clean_json );

    ## nb failure doesn't prevent new returning instance 
    my $graph = GraphViz::Data::Grapher->new( $clean  )->as_png("$schemakey.png");
    
    open(OF,'>',"$schemakey.json") || croak($!);
    print OF to_json(  $discovered_api_spec->{schemas}{$schemakey} );
    close(OF);
    #`pp_json < $schemakey.json > $schemakey.json`;

  }
}

exit;


my $gapi_agent = WebService::Google::Client->new( debug => 1 );    # my $gapi = WebService::Google::Client->new(access_token => '');
my $user = 'peter@shotgundriver.com';                              # full gmail

$gapi_agent->auth_storage->setup( { type => 'jsonfile', path => './gapi.json' } );    # by default - could this be auto on new?
        # $gapi->auth_storage->setup({ type => 'dbi', path => 'DBI object' });  ## NOT IMPLEMENTED
        # $gapi->auth_storage->setup({ type => 'mongodb', path => 'details' }); ## NOT IMPLEMENTED

$gapi_agent->user( $user );
#$gapi_agent->do_autorefresh( 1 ); - i think this is redundant as 1 is default value ?

#cal_examples( $gapi_agent );


########################################
sub render_services_as_formatted_table
{
  my ( $d ) = @_;
  ## Render as nicely formatted MD table - https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet
  

  # wrap into an array of rows for table
  my $rows = [];
  foreach my $r ( @{ $d->{ items } } )
  {
    push @$rows, [ $r->{ version }, $r->{ title }, $r->{ description }];    ## documentationLink icon-s->{x32|16}  id discoveryRestUrl

  }
  my $tb = Text::Table->new( ## currently use Text::Table - perhaps should use Text::MarkdownTable so can put images and links in without bloaring the col lengths
    { is_sep => 1, title => '| ', body => '| ' }, "Version", { is_sep => 1, title => '| ', body => '| ' }, "Title",
    { is_sep => 1, title => '| ', body => '| ' }, "Description",
    { is_sep => 1, title => '| ', body => '| ' }, "",
  );

  $tb->load( @$rows );
  return $tb;
}
########################################

sub cal_examples
{
  my ( $gapi ) = @_;
  my $r1 = $gapi->Calendar->Events->list( { calendarId => 'primary' } )->json;
  carp scalar @{ $r1->{ items } };
  exit if ( 1 == 1 );
}

sub discovery_data ## kept as handy structure reference but no need to use now
{
  croak('no need to use this as have a lifespanned CHI Cached version available');
  return {
    'items' => [
      {
        'description' =>
          'View Abusive Experience Report data, and get a list of sites that have a significant number of abusive experiences.',
        'title' => 'Abusive Experience Report API',
        'id'    => 'abusiveexperiencereport:v1',
        'name'  => 'abusiveexperiencereport',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://abusiveexperiencereport.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/abusive-experience-report/'
      },
      {
        'description' =>
          'This API contains a single method, batchGet. Call this method to retrieve the AMP URL (and equivalent AMP Cache URL) for given public URL(s).',
        'title' => 'Accelerated Mobile Pages (AMP) URL API',
        'id'    => 'acceleratedmobilepageurl:v1',
        'name'  => 'acceleratedmobilepageurl',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://acceleratedmobilepageurl.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/amp/cache/'
      },
      {
        'id' => 'adexchangebuyer:v1.2',
        'description' =>
          'Accesses your bidding-account information, submits creatives for validation, finds available direct deals, and retrieves performance reports.',
        'title' => 'Ad Exchange Buyer API',
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif'
        },
        'name'              => 'adexchangebuyer',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1.2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/adexchangebuyer/v1.2/rest',
        'documentationLink' => 'https://developers.google.com/ad-exchange/buyer-rest',
        'discoveryLink'     => './apis/adexchangebuyer/v1.2/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'icons' => {
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif',
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif'
        },
        'name'  => 'adexchangebuyer',
        'id'    => 'adexchangebuyer:v1.3',
        'title' => 'Ad Exchange Buyer API',
        'description' =>
          'Accesses your bidding-account information, submits creatives for validation, finds available direct deals, and retrieves performance reports.',
        'documentationLink' => 'https://developers.google.com/ad-exchange/buyer-rest',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/adexchangebuyer/v1.3/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/adexchangebuyer/v1.3/rest',
        'version'           => 'v1.3'
      },
      {
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif'
        },
        'name' => 'adexchangebuyer',
        'id'   => 'adexchangebuyer:v1.4',
        'description' =>
          'Accesses your bidding-account information, submits creatives for validation, finds available direct deals, and retrieves performance reports.',
        'title'             => 'Ad Exchange Buyer API',
        'documentationLink' => 'https://developers.google.com/ad-exchange/buyer-rest',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/adexchangebuyer/v1.4/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/adexchangebuyer/v1.4/rest',
        'version'           => 'v1.4'
      },
      {
        'id' => 'adexchangebuyer2:v2beta1',
        'description' =>
          'Accesses the latest features for managing Ad Exchange accounts, Real-Time Bidding configurations and auction metrics, and Marketplace programmatic deals.',
        'title' => 'Ad Exchange Buyer API II',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'adexchangebuyer2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2beta1',
        'discoveryRestUrl'  => 'https://adexchangebuyer.googleapis.com/$discovery/rest?version=v2beta1',
        'documentationLink' => 'https://developers.google.com/ad-exchange/buyer-rest/reference/rest/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'id'          => 'adexperiencereport:v1',
        'title'       => 'Ad Experience Report API',
        'description' => 'View Ad Experience Report data, and get a list of sites that have a significant number of annoying ads.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'adexperiencereport',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://adexperiencereport.googleapis.com/$discovery/rest?version=v1',
        'documentationLink' => 'https://developers.google.com/ad-experience-report/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'admin',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Admin Data Transfer API',
        'description'       => 'Transfers user data from one user to another.',
        'id'                => 'admin:datatransfer_v1',
        'discoveryLink'     => './apis/admin/datatransfer_v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/admin-sdk/data-transfer/',
        'version'           => 'datatransfer_v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/admin/datatransfer_v1/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'id' => 'admin:directory_v1',
        'description' =>
          'Manages enterprise resources such as users and groups, administrative notifications, security features, and more.',
        'title' => 'Admin Directory API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'admin',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/admin/directory_v1/rest',
        'version'           => 'directory_v1',
        'documentationLink' => 'https://developers.google.com/admin-sdk/directory/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/admin/directory_v1/rest'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'admin',
        'id'   => 'admin:reports_v1',
        'description' =>
          'Fetches reports for the administrators of G Suite customers about the usage, collaboration, security, and risk for their users.',
        'title'             => 'Admin Reports API',
        'documentationLink' => 'https://developers.google.com/admin-sdk/reports/',
        'discoveryLink'     => './apis/admin/reports_v1/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/admin/reports_v1/rest',
        'version'           => 'reports_v1'
      },
      {
        'name'  => 'adsense',
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/adsense-16.png',
          'x32' => 'https://www.google.com/images/icons/product/adsense-32.png'
        },
        'title'             => 'AdSense Management API',
        'description'       => 'Accesses AdSense publishers\' inventory and generates performance reports.',
        'id'                => 'adsense:v1.4',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/adsense/v1.4/rest',
        'documentationLink' => 'https://developers.google.com/adsense/management/',
        'version'           => 'v1.4',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/adsense/v1.4/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/adsensehost/v4.1/rest',
        'version'           => 'v4.1',
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/adsensehost/v4.1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/adsense/host/',
        'title'             => 'AdSense Host API',
        'description' =>
          'Generates performance reports, generates ad codes, and provides publisher management capabilities for AdSense Hosts.',
        'id'    => 'adsensehost:v4.1',
        'name'  => 'adsensehost',
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/adsense-16.png',
          'x32' => 'https://www.google.com/images/icons/product/adsense-32.png'
        }
      },
      {
        'name'  => 'analytics',
        'icons' => {
          'x32' => 'https://www.google.com/images/icons/product/analytics-32.png',
          'x16' => 'https://www.google.com/images/icons/product/analytics-16.png'
        },
        'title'             => 'Google Analytics API',
        'description'       => 'Views and manages your Google Analytics data.',
        'id'                => 'analytics:v2.4',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/analytics/v2.4/rest',
        'documentationLink' => 'https://developers.google.com/analytics/',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/analytics/v2.4/rest',
        'version'           => 'v2.4',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'name'  => 'analytics',
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/analytics-16.png',
          'x32' => 'https://www.google.com/images/icons/product/analytics-32.png'
        },
        'description'       => 'Views and manages your Google Analytics data.',
        'title'             => 'Google Analytics API',
        'id'                => 'analytics:v3',
        'discoveryLink'     => './apis/analytics/v3/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/analytics/',
        'version'           => 'v3',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/analytics/v3/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'description' => 'Accesses Analytics report data.',
        'title'       => 'Google Analytics Reporting API',
        'id'          => 'analyticsreporting:v4',
        'name'        => 'analyticsreporting',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://analyticsreporting.googleapis.com/$discovery/rest?version=v4',
        'version'           => 'v4',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/analytics/devguides/reporting/core/v4/'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/zero-touch/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://androiddeviceprovisioning.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'androiddeviceprovisioning',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Android Device Provisioning Partner API',
        'description' => 'Automates Android zero-touch enrollment for device resellers, customers, and EMMs.',
        'id'          => 'androiddeviceprovisioning:v1'
      },
      {
        'icons' => {
          'x32' => 'https://www.google.com/images/icons/product/android-32.png',
          'x16' => 'https://www.google.com/images/icons/product/android-16.png'
        },
        'name'              => 'androidenterprise',
        'id'                => 'androidenterprise:v1',
        'title'             => 'Google Play EMM API',
        'description'       => 'Manages the deployment of apps to Android for Work users.',
        'documentationLink' => 'https://developers.google.com/android/work/play/emm-api',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/androidenterprise/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/androidenterprise/v1/rest',
        'version'           => 'v1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/android/management',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://androidmanagement.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'androidmanagement',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Android Management API',
        'description' => 'The Android Management API provides remote enterprise management of Android devices and apps.',
        'id'          => 'androidmanagement:v1'
      },
      {
        'title'       => 'Google Play Developer API',
        'description' => 'Lets Android application developers access their Google Play accounts.',
        'id'          => 'androidpublisher:v1',
        'name'        => 'androidpublisher',
        'icons'       => {
          'x32' => 'https://www.google.com/images/icons/product/android-32.png',
          'x16' => 'https://www.google.com/images/icons/product/android-16.png'
        },
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/androidpublisher/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/androidpublisher/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/android-publisher'
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/androidpublisher/v1.1/rest',
        'version'           => 'v1.1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/androidpublisher/v1.1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/android-publisher',
        'description'       => 'Lets Android application developers access their Google Play accounts.',
        'title'             => 'Google Play Developer API',
        'id'                => 'androidpublisher:v1.1',
        'name'              => 'androidpublisher',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/android-32.png',
          'x16' => 'https://www.google.com/images/icons/product/android-16.png'
        }
      },
      {
        'discoveryLink'     => './apis/androidpublisher/v2/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/android-publisher',
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/androidpublisher/v2/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'androidpublisher',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/android-16.png',
          'x32' => 'https://www.google.com/images/icons/product/android-32.png'
        },
        'description' => 'Lets Android application developers access their Google Play accounts.',
        'title'       => 'Google Play Developer API',
        'id'          => 'androidpublisher:v2'
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/androidpublisher/v3/rest',
        'version'           => 'v3',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/androidpublisher/v3/rest',
        'documentationLink' => 'https://developers.google.com/android-publisher',
        'title'             => 'Google Play Developer API',
        'description'       => 'Lets Android application developers access their Google Play accounts.',
        'id'                => 'androidpublisher:v3',
        'name'              => 'androidpublisher',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/android-16.png',
          'x32' => 'https://www.google.com/images/icons/product/android-32.png'
        }
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://appengine.googleapis.com/$discovery/rest?version=v1alpha',
        'version'           => 'v1alpha',
        'documentationLink' => 'https://cloud.google.com/appengine/docs/admin-api/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'appengine:v1alpha',
        'title'             => 'App Engine Admin API',
        'description'       => 'The App Engine Admin API enables developers to provision and manage their App Engine applications.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'appengine'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta',
        'discoveryRestUrl'  => 'https://appengine.googleapis.com/$discovery/rest?version=v1beta',
        'documentationLink' => 'https://cloud.google.com/appengine/docs/admin-api/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'appengine:v1beta',
        'title'             => 'App Engine Admin API',
        'description'       => 'The App Engine Admin API enables developers to provision and manage their App Engine applications.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'appengine'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'appengine',
        'id'                => 'appengine:v1',
        'title'             => 'App Engine Admin API',
        'description'       => 'The App Engine Admin API enables developers to provision and manage their App Engine applications.',
        'documentationLink' => 'https://cloud.google.com/appengine/docs/admin-api/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://appengine.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1'
      },
      {
        'id'          => 'appengine:v1beta4',
        'title'       => 'App Engine Admin API',
        'description' => 'The App Engine Admin API enables developers to provision and manage their App Engine applications.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'appengine',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta4',
        'discoveryRestUrl'  => 'https://appengine.googleapis.com/$discovery/rest?version=v1beta4',
        'documentationLink' => 'https://cloud.google.com/appengine/docs/admin-api/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'description' => 'The App Engine Admin API enables developers to provision and manage their App Engine applications.',
        'title'       => 'App Engine Admin API',
        'id'          => 'appengine:v1beta5',
        'name'        => 'appengine',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'discoveryRestUrl'  => 'https://appengine.googleapis.com/$discovery/rest?version=v1beta5',
        'version'           => 'v1beta5',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/appengine/docs/admin-api/'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'appsactivity',
        'id'                => 'appsactivity:v1',
        'description'       => 'Provides a historical view of activity.',
        'title'             => 'Drive Activity API',
        'documentationLink' => 'https://developers.google.com/google-apps/activity/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/appsactivity/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/appsactivity/v1/rest',
        'version'           => 'v1'
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/appstate/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/appstate/v1/rest',
        'documentationLink' => 'https://developers.google.com/games/services/web/api/states',
        'title'             => 'Google App State API',
        'description'       => 'The Google App State API.',
        'id'                => 'appstate:v1',
        'name'              => 'appstate',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'id'          => 'bigquery:v2',
        'description' => 'A data platform for customers to create, manage, share and query data.',
        'title'       => 'BigQuery API',
        'icons'       => {
          'x16' => 'https://www.google.com/images/icons/product/search-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/search-32.gif'
        },
        'name'              => 'bigquery',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/bigquery/v2/rest',
        'version'           => 'v2',
        'documentationLink' => 'https://cloud.google.com/bigquery/',
        'discoveryLink'     => './apis/bigquery/v2/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/bigquery/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://bigquerydatatransfer.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'bigquerydatatransfer',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' => 'Transfers data from partner SaaS applications to Google BigQuery on a scheduled, managed basis.',
        'title'       => 'BigQuery Data Transfer API',
        'id'          => 'bigquerydatatransfer:v1'
      },
      {
        'name'  => 'binaryauthorization',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'The management interface for Binary Authorization, a system providing policy control for images deployed to Kubernetes Engine clusters.',
        'title'             => 'Binary Authorization API',
        'id'                => 'binaryauthorization:v1beta1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/binary-authorization/',
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://binaryauthorization.googleapis.com/$discovery/rest?version=v1beta1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'discoveryLink'     => './apis/blogger/v2/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/blogger/docs/2.0/json/getting_started',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/blogger/v2/rest',
        'version'           => 'v2',
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'blogger',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/blogger-16.png',
          'x32' => 'https://www.google.com/images/icons/product/blogger-32.png'
        },
        'title'       => 'Blogger API',
        'description' => 'API for access to the data within Blogger.',
        'id'          => 'blogger:v2'
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/blogger/v3/rest',
        'version'           => 'v3',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'labels'            => ['limited_availability'],
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/blogger/v3/rest',
        'documentationLink' => 'https://developers.google.com/blogger/docs/3.0/getting_started',
        'description'       => 'API for access to the data within Blogger.',
        'title'             => 'Blogger API',
        'id'                => 'blogger:v3',
        'name'              => 'blogger',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/blogger-16.png',
          'x32' => 'https://www.google.com/images/icons/product/blogger-32.png'
        }
      },
      {
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/ebooks-16.png',
          'x32' => 'https://www.google.com/images/icons/product/ebooks-32.png'
        },
        'name'              => 'books',
        'id'                => 'books:v1',
        'title'             => 'Books API',
        'description'       => 'Searches for books and manages your Google Books library.',
        'documentationLink' => 'https://developers.google.com/books/docs/v1/getting_started',
        'discoveryLink'     => './apis/books/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/books/v1/rest',
        'version'           => 'v1'
      },
      {
        'id'          => 'calendar:v3',
        'title'       => 'Calendar API',
        'description' => 'Manipulates events and other calendar data.',
        'icons'       => {
          'x32' => 'http://www.google.com/images/icons/product/calendar-32.png',
          'x16' => 'http://www.google.com/images/icons/product/calendar-16.png'
        },
        'name'              => 'calendar',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v3',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/calendar/v3/rest',
        'documentationLink' => 'https://developers.google.com/google-apps/calendar/firstapp',
        'discoveryLink'     => './apis/calendar/v3/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'description' => 'Create bots and extend the new Hangouts Chat.',
        'title'       => 'Hangouts Chat API',
        'id'          => 'chat:v1',
        'name'        => 'chat',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://chat.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/hangouts/chat'
      },
      {
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/civicinfo/v2/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/civicinfo/v2/rest',
        'documentationLink' => 'https://developers.google.com/civic-information',
        'title'             => 'Google Civic Information API',
        'description' =>
          'Provides polling places, early vote locations, contest data, election officials, and government representatives for U.S. residential addresses.',
        'id'    => 'civicinfo:v2',
        'name'  => 'civicinfo',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'id'          => 'classroom:v1',
        'description' => 'Manages classes, rosters, and invitations in Google Classroom.',
        'title'       => 'Google Classroom API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'classroom',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://classroom.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/classroom',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'cloudasset',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Cloud Asset API',
        'description'       => 'The cloud asset API manages the history and inventory of cloud resources.',
        'id'                => 'cloudasset:v1beta1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://console.cloud.google.com/apis/api/cloudasset.googleapis.com/overview',
        'discoveryRestUrl'  => 'https://cloudasset.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'title'       => 'Cloud Billing API',
        'description' => 'Allows developers to manage billing for their Google Cloud Platform projects programmatically.',
        'id'          => 'cloudbilling:v1',
        'name'        => 'cloudbilling',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'discoveryRestUrl'  => 'https://cloudbilling.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/billing/'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'cloudbuild',
        'id'                => 'cloudbuild:v1alpha1',
        'title'             => 'Cloud Build API',
        'description'       => 'Creates and manages builds on Google Cloud Platform.',
        'documentationLink' => 'https://cloud.google.com/cloud-build/docs/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1alpha1',
        'discoveryRestUrl'  => 'https://cloudbuild.googleapis.com/$discovery/rest?version=v1alpha1'
      },
      {
        'discoveryRestUrl'  => 'https://cloudbuild.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/cloud-build/docs/',
        'description'       => 'Creates and manages builds on Google Cloud Platform.',
        'title'             => 'Cloud Build API',
        'id'                => 'cloudbuild:v1',
        'name'              => 'cloudbuild',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'documentationLink' => 'https://cloud.google.com/debugger',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://clouddebugger.googleapis.com/$discovery/rest?version=v2',
        'version'           => 'v2',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'        => 'clouddebugger',
        'id'          => 'clouddebugger:v2',
        'description' => 'Examines the call stack and variables of a running application without stopping or slowing it down.',
        'title'       => 'Stackdriver Debugger API'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/error-reporting/',
        'discoveryRestUrl'  => 'https://clouderrorreporting.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'clouderrorreporting',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'Groups and counts similar errors from cloud services and applications, reports new errors, and provides access to error groups and their associated errors.',
        'title' => 'Stackdriver Error Reporting API',
        'id'    => 'clouderrorreporting:v1beta1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/functions',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://cloudfunctions.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'cloudfunctions',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Cloud Functions API',
        'description' => 'Manages lightweight user-provided functions executed in response to events.',
        'id'          => 'cloudfunctions:v1'
      },
      {
        'name'  => 'cloudfunctions',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Cloud Functions API',
        'description'       => 'Manages lightweight user-provided functions executed in response to events.',
        'id'                => 'cloudfunctions:v1beta2',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/functions',
        'version'           => 'v1beta2',
        'discoveryRestUrl'  => 'https://cloudfunctions.googleapis.com/$discovery/rest?version=v1beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/iot',
        'discoveryRestUrl'  => 'https://cloudiot.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'cloudiot',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Cloud IoT API',
        'description' => 'Registers and manages IoT (Internet of Things) devices that connect to the Google Cloud Platform.',
        'id'          => 'cloudiot:v1'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://cloudiot.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/iot',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'cloudiot:v1beta1',
        'title'             => 'Cloud IoT API',
        'description'       => 'Registers and manages IoT (Internet of Things) devices that connect to the Google Cloud Platform.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'cloudiot'
      },
      {
        'name'  => 'cloudkms',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title' => 'Cloud Key Management Service (KMS) API',
        'description' =>
          'Manages keys and performs cryptographic operations in a central cloud service, for direct use by other cloud resources and applications.',
        'id'                => 'cloudkms:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/kms/',
        'discoveryRestUrl'  => 'https://cloudkms.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'name'  => 'cloudprofiler',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description'       => 'Manages continuous profiling information.',
        'title'             => 'Stackdriver Profiler API',
        'id'                => 'cloudprofiler:v2',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/profiler/',
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://cloudprofiler.googleapis.com/$discovery/rest?version=v2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://cloudresourcemanager.googleapis.com/$discovery/rest?version=v1',
        'documentationLink' => 'https://cloud.google.com/resource-manager',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'cloudresourcemanager:v1',
        'description' => 'The Google Cloud Resource Manager API provides methods for creating, reading, and updating project metadata.',
        'title'       => 'Cloud Resource Manager API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'cloudresourcemanager'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://cloudresourcemanager.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/resource-manager',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'cloudresourcemanager:v1beta1',
        'description' => 'The Google Cloud Resource Manager API provides methods for creating, reading, and updating project metadata.',
        'title'       => 'Cloud Resource Manager API',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'cloudresourcemanager'
      },
      {
        'name'  => 'cloudresourcemanager',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' => 'The Google Cloud Resource Manager API provides methods for creating, reading, and updating project metadata.',
        'title'       => 'Cloud Resource Manager API',
        'id'          => 'cloudresourcemanager:v2',
        'kind'        => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/resource-manager',
        'discoveryRestUrl'  => 'https://cloudresourcemanager.googleapis.com/$discovery/rest?version=v2',
        'version'           => 'v2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'id'          => 'cloudresourcemanager:v2beta1',
        'description' => 'The Google Cloud Resource Manager API provides methods for creating, reading, and updating project metadata.',
        'title'       => 'Cloud Resource Manager API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'cloudresourcemanager',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://cloudresourcemanager.googleapis.com/$discovery/rest?version=v2beta1',
        'version'           => 'v2beta1',
        'documentationLink' => 'https://cloud.google.com/resource-manager',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'documentationLink' => 'https://cloud.google.com/shell/docs/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1alpha1',
        'discoveryRestUrl'  => 'https://cloudshell.googleapis.com/$discovery/rest?version=v1alpha1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'cloudshell',
        'id'          => 'cloudshell:v1alpha1',
        'title'       => 'Cloud Shell API',
        'description' => 'Allows users to start, configure, and connect to interactive shell sessions running in the cloud.'
      },
      {
        'name'  => 'cloudshell',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description'       => 'Allows users to start, configure, and connect to interactive shell sessions running in the cloud.',
        'title'             => 'Cloud Shell API',
        'id'                => 'cloudshell:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/shell/docs/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://cloudshell.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'version'           => 'v2beta2',
        'discoveryRestUrl'  => 'https://cloudtasks.googleapis.com/$discovery/rest?version=v2beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/tasks/',
        'description'       => 'Manages the execution of large numbers of distributed requests.',
        'title'             => 'Cloud Tasks API',
        'id'                => 'cloudtasks:v2beta2',
        'name'              => 'cloudtasks',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'cloudtasks',
        'id'                => 'cloudtasks:v2beta3',
        'description'       => 'Manages the execution of large numbers of distributed requests.',
        'title'             => 'Cloud Tasks API',
        'documentationLink' => 'https://cloud.google.com/tasks/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://cloudtasks.googleapis.com/$discovery/rest?version=v2beta3',
        'version'           => 'v2beta3'
      },
      {
        'title' => 'Stackdriver Trace API',
        'description' =>
          'Sends application trace data to Stackdriver Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Trace API directly. If you are looking to instrument your application for Stackdriver Trace, we recommend using OpenCensus.',
        'id'    => 'cloudtrace:v2alpha1',
        'name'  => 'cloudtrace',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'version'           => 'v2alpha1',
        'discoveryRestUrl'  => 'https://cloudtrace.googleapis.com/$discovery/rest?version=v2alpha1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/trace'
      },
      {
        'id' => 'cloudtrace:v1',
        'description' =>
          'Sends application trace data to Stackdriver Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Trace API directly. If you are looking to instrument your application for Stackdriver Trace, we recommend using OpenCensus.',
        'title' => 'Stackdriver Trace API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'cloudtrace',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://cloudtrace.googleapis.com/$discovery/rest?version=v1',
        'documentationLink' => 'https://cloud.google.com/trace',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'id'    => 'cloudtrace:v2',
        'title' => 'Stackdriver Trace API',
        'description' =>
          'Sends application trace data to Stackdriver Trace for viewing. Trace data is collected for all App Engine applications by default. Trace data from other applications can be provided using this API. This library is used to interact with the Trace API directly. If you are looking to instrument your application for Stackdriver Trace, we recommend using OpenCensus.',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'cloudtrace',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://cloudtrace.googleapis.com/$discovery/rest?version=v2',
        'documentationLink' => 'https://cloud.google.com/trace',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'composer',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description'       => 'Manages Apache Airflow environments on Google Cloud Platform.',
        'title'             => 'Cloud Composer API',
        'id'                => 'composer:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/composer/',
        'discoveryRestUrl'  => 'https://composer.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'id'          => 'composer:v1beta1',
        'description' => 'Manages Apache Airflow environments on Google Cloud Platform.',
        'title'       => 'Cloud Composer API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'composer',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://composer.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/composer/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'documentationLink' => 'https://developers.google.com/compute/docs/reference/latest/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/compute/alpha/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'alpha',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/compute/alpha/rest',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/compute_engine-32.png',
          'x16' => 'https://www.google.com/images/icons/product/compute_engine-16.png'
        },
        'name'        => 'compute',
        'id'          => 'compute:alpha',
        'title'       => 'Compute Engine API',
        'description' => 'Creates and runs virtual machines on Google Cloud Platform.'
      },
      {
        'documentationLink' => 'https://developers.google.com/compute/docs/reference/latest/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/compute/beta/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'beta',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/compute/beta/rest',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/compute_engine-16.png',
          'x32' => 'https://www.google.com/images/icons/product/compute_engine-32.png'
        },
        'name'        => 'compute',
        'id'          => 'compute:beta',
        'description' => 'Creates and runs virtual machines on Google Cloud Platform.',
        'title'       => 'Compute Engine API'
      },
      {
        'id'          => 'compute:v1',
        'title'       => 'Compute Engine API',
        'description' => 'Creates and runs virtual machines on Google Cloud Platform.',
        'icons'       => {
          'x32' => 'https://www.google.com/images/icons/product/compute_engine-32.png',
          'x16' => 'https://www.google.com/images/icons/product/compute_engine-16.png'
        },
        'name'              => 'compute',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/compute/v1/rest',
        'documentationLink' => 'https://developers.google.com/compute/docs/reference/latest/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/compute/v1/rest'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'container',
        'id'   => 'container:v1',
        'description' =>
          'The Google Kubernetes Engine API is used for building and managing container based applications, powered by the open source Kubernetes technology.',
        'title'             => 'Kubernetes Engine API',
        'documentationLink' => 'https://cloud.google.com/container-engine/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://container.googleapis.com/$discovery/rest?version=v1'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'container',
        'id'   => 'container:v1beta1',
        'description' =>
          'The Google Kubernetes Engine API is used for building and managing container based applications, powered by the open source Kubernetes technology.',
        'title'             => 'Kubernetes Engine API',
        'documentationLink' => 'https://cloud.google.com/container-engine/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://container.googleapis.com/$discovery/rest?version=v1beta1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/content/v2sandbox/rest',
        'documentationLink' => 'https://developers.google.com/shopping-content',
        'version'           => 'v2sandbox',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/content/v2sandbox/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'content',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Content API for Shopping',
        'description' => 'Manages product items, inventory, and Merchant Center accounts for Google Shopping.',
        'id'          => 'content:v2sandbox'
      },
      {
        'id'          => 'content:v2',
        'description' => 'Manages product items, inventory, and Merchant Center accounts for Google Shopping.',
        'title'       => 'Content API for Shopping',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'content',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/content/v2/rest',
        'documentationLink' => 'https://developers.google.com/shopping-content',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/content/v2/rest'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'customsearch',
        'id'                => 'customsearch:v1',
        'title'             => 'CustomSearch API',
        'description'       => 'Searches over a website or collection of websites',
        'documentationLink' => 'https://developers.google.com/custom-search/v1/using_rest',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/customsearch/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/customsearch/v1/rest'
      },
      {
        'documentationLink' => 'https://cloud.google.com/dataflow',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://dataflow.googleapis.com/$discovery/rest?version=v1b3',
        'version'           => 'v1b3',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'dataflow',
        'id'          => 'dataflow:v1b3',
        'description' => 'Manages Google Cloud Dataflow projects on Google Cloud Platform.',
        'title'       => 'Dataflow API'
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://dataproc.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/dataproc/',
        'description'       => 'Manages Hadoop-based clusters and jobs on Google Cloud Platform.',
        'title'             => 'Cloud Dataproc API',
        'id'                => 'dataproc:v1',
        'name'              => 'dataproc',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'title'       => 'Cloud Dataproc API',
        'description' => 'Manages Hadoop-based clusters and jobs on Google Cloud Platform.',
        'id'          => 'dataproc:v1beta2',
        'name'        => 'dataproc',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://dataproc.googleapis.com/$discovery/rest?version=v1beta2',
        'version'           => 'v1beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/dataproc/'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'datastore',
        'id'          => 'datastore:v1',
        'title'       => 'Cloud Datastore API',
        'description' => 'Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application.',
        'documentationLink' => 'https://cloud.google.com/datastore/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://datastore.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1'
      },
      {
        'description' => 'Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application.',
        'title'       => 'Cloud Datastore API',
        'id'          => 'datastore:v1beta1',
        'name'        => 'datastore',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'discoveryRestUrl'  => 'https://datastore.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/datastore/'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/datastore/',
        'version'           => 'v1beta3',
        'discoveryRestUrl'  => 'https://datastore.googleapis.com/$discovery/rest?version=v1beta3',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'datastore',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' => 'Accesses the schemaless NoSQL database to provide fully managed, robust, scalable storage for your application.',
        'title'       => 'Cloud Datastore API',
        'id'          => 'datastore:v1beta3'
      },
      {
        'id' => 'deploymentmanager:alpha',
        'description' =>
          'The Deployment Manager API allows users to declaratively configure, deploy and run complex solutions on the Google Cloud Platform.',
        'title' => 'Google Cloud Deployment Manager Alpha API',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'deploymentmanager',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'alpha',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/deploymentmanager/alpha/rest',
        'documentationLink' => 'https://cloud.google.com/deployment-manager/',
        'discoveryLink'     => './apis/deploymentmanager/alpha/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'id' => 'deploymentmanager:v2beta',
        'description' =>
          'The Deployment Manager API allows users to declaratively configure, deploy and run complex solutions on the Google Cloud Platform.',
        'title' => 'Google Cloud Deployment Manager API V2Beta Methods',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'deploymentmanager',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2beta',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/deploymentmanager/v2beta/rest',
        'documentationLink' => 'https://developers.google.com/deployment-manager/',
        'discoveryLink'     => './apis/deploymentmanager/v2beta/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/deploymentmanager/v2/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/deploymentmanager/v2/rest',
        'documentationLink' => 'https://cloud.google.com/deployment-manager/',
        'title'             => 'Google Cloud Deployment Manager API',
        'description'       => 'Declares, configures, and deploys complex solutions on Google Cloud Platform.',
        'id'                => 'deploymentmanager:v2',
        'name'              => 'deploymentmanager',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'name'  => 'dfareporting',
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif'
        },
        'description'       => 'Manages your DoubleClick Campaign Manager ad campaigns and reports.',
        'title'             => 'DCM/DFA Reporting And Trafficking API',
        'id'                => 'dfareporting:v2.8',
        'discoveryLink'     => './apis/dfareporting/v2.8/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/doubleclick-advertisers/',
        'version'           => 'v2.8',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dfareporting/v2.8/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'documentationLink' => 'https://developers.google.com/doubleclick-advertisers/',
        'discoveryLink'     => './apis/dfareporting/v3.0/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dfareporting/v3.0/rest',
        'version'           => 'v3.0',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif'
        },
        'name'        => 'dfareporting',
        'id'          => 'dfareporting:v3.0',
        'description' => 'Manages your DoubleClick Campaign Manager ad campaigns and reports.',
        'title'       => 'DCM/DFA Reporting And Trafficking API'
      },
      {
        'title'       => 'DCM/DFA Reporting And Trafficking API',
        'description' => 'Manages your DoubleClick Campaign Manager ad campaigns and reports.',
        'id'          => 'dfareporting:v3.1',
        'name'        => 'dfareporting',
        'icons'       => {
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif',
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif'
        },
        'version'           => 'v3.1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dfareporting/v3.1/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/dfareporting/v3.1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/doubleclick-advertisers/'
      },
      {
        'id'          => 'dfareporting:v3.2',
        'description' => 'Manages your DoubleClick Campaign Manager ad campaigns and reports.',
        'title'       => 'DCM/DFA Reporting And Trafficking API',
        'icons'       => {
          'x16' => 'https://www.google.com/images/icons/product/doubleclick-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/doubleclick-32.gif'
        },
        'name'              => 'dfareporting',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v3.2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dfareporting/v3.2/rest',
        'documentationLink' => 'https://developers.google.com/doubleclick-advertisers/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/dfareporting/v3.2/rest'
      },
      {
        'title'       => 'Dialogflow API',
        'description' => 'An end-to-end development suite for conversational interfaces (e.g., chatbots, voice-powered apps and devices).',
        'id'          => 'dialogflow:v2',
        'name'        => 'dialogflow',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://dialogflow.googleapis.com/$discovery/rest?version=v2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/dialogflow-enterprise/'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/dialogflow-enterprise/',
        'discoveryRestUrl'  => 'https://dialogflow.googleapis.com/$discovery/rest?version=v2beta1',
        'version'           => 'v2beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'dialogflow',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Dialogflow API',
        'description' => 'An end-to-end development suite for conversational interfaces (e.g., chatbots, voice-powered apps and devices).',
        'id'          => 'dialogflow:v2beta1'
      },
      {
        'documentationLink' => 'https://developers.google.com/digital-asset-links/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://digitalassetlinks.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'digitalassetlinks',
        'id'          => 'digitalassetlinks:v1',
        'description' => 'API for discovering relationships between online assets such as web sites or mobile apps.',
        'title'       => 'Digital Asset Links API'
      },
      {
        'discoveryLink'     => './apis/discovery/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/discovery/',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/discovery/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'discovery',
        'icons'             => {
          'x16' => 'http://www.google.com/images/icons/feature/filing_cabinet_search-g16.png',
          'x32' => 'http://www.google.com/images/icons/feature/filing_cabinet_search-g32.png'
        },
        'description' =>
          'Provides information about other Google APIs, such as what APIs are available, the resource, and method details for each API.',
        'title' => 'APIs Discovery Service',
        'id'    => 'discovery:v1'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://dlp.googleapis.com/$discovery/rest?version=v2',
        'documentationLink' => 'https://cloud.google.com/dlp/docs/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'dlp:v2',
        'title'             => 'Cloud Data Loss Prevention (DLP) API',
        'description' =>
          'Provides methods for detection, risk analysis, and de-identification of privacy-sensitive fragments in text, images, and Google Cloud Platform storage repositories.',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'dlp'
      },
      {
        'discoveryLink'     => './apis/dns/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/cloud-dns',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dns/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'dns',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' => 'Configures and serves authoritative DNS records.',
        'title'       => 'Google Cloud DNS API',
        'id'          => 'dns:v1'
      },
      {
        'description' => 'Configures and serves authoritative DNS records.',
        'title'       => 'Google Cloud DNS API',
        'id'          => 'dns:v1beta2',
        'name'        => 'dns',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v1beta2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dns/v1beta2/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/dns/v1beta2/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/cloud-dns'
      },
      {
        'id'          => 'dns:v2beta1',
        'title'       => 'Google Cloud DNS API',
        'description' => 'Configures and serves authoritative DNS records.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'dns',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/dns/v2beta1/rest',
        'version'           => 'v2beta1',
        'documentationLink' => 'https://developers.google.com/cloud-dns',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/dns/v2beta1/rest'
      },
      {
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/doubleclickbidmanager/v1/rest',
        'documentationLink' => 'https://developers.google.com/bid-manager/',
        'discoveryLink'     => './apis/doubleclickbidmanager/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'doubleclickbidmanager:v1',
        'title'             => 'DoubleClick Bid Manager API',
        'description'       => 'API for viewing and managing your reports in DoubleClick Bid Manager.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'doubleclickbidmanager'
      },
      {
        'id'    => 'doubleclicksearch:v2',
        'title' => 'DoubleClick Search API',
        'description' =>
          'Reports and modifies your advertising data in DoubleClick Search (for example, campaigns, ad groups, keywords, and conversions).',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'doubleclicksearch',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/doubleclicksearch/v2/rest',
        'documentationLink' => 'https://developers.google.com/doubleclick-search/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/doubleclicksearch/v2/rest'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/drive/v2/rest',
        'documentationLink' => 'https://developers.google.com/drive/',
        'discoveryLink'     => './apis/drive/v2/rest',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'drive:v2',
        'title'             => 'Drive API',
        'description' =>
          'Manages files in Drive including uploading, downloading, searching, detecting changes, and updating sharing permissions.',
        'icons' => {
          'x16' => 'https://ssl.gstatic.com/docs/doclist/images/drive_icon_16.png',
          'x32' => 'https://ssl.gstatic.com/docs/doclist/images/drive_icon_32.png'
        },
        'name' => 'drive'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/drive/v3/rest',
        'version'           => 'v3',
        'documentationLink' => 'https://developers.google.com/drive/',
        'discoveryLink'     => './apis/drive/v3/rest',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'drive:v3',
        'description' =>
          'Manages files in Drive including uploading, downloading, searching, detecting changes, and updating sharing permissions.',
        'title' => 'Drive API',
        'icons' => {
          'x16' => 'https://ssl.gstatic.com/docs/doclist/images/drive_icon_16.png',
          'x32' => 'https://ssl.gstatic.com/docs/doclist/images/drive_icon_32.png'
        },
        'name' => 'drive'
      },
      {
        'id'          => 'file:v1beta1',
        'title'       => 'Cloud Filestore API',
        'description' => 'The Cloud Filestore API is used for creating and managing cloud file servers.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'file',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://file.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/filestore/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'discoveryRestUrl'  => 'https://firebasedynamiclinks.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://firebase.google.com/docs/dynamic-links/',
        'title'             => 'Firebase Dynamic Links API',
        'description'       => 'Programmatically creates and manages Firebase Dynamic Links.',
        'id'                => 'firebasedynamiclinks:v1',
        'name'              => 'firebasedynamiclinks',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'id'          => 'firebaserules:v1',
        'title'       => 'Firebase Rules API',
        'description' => 'Creates and manages rules that determine when a Firebase Rules-enabled service should permit a request.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'firebaserules',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://firebaserules.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://firebase.google.com/docs/storage/security',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/firestore',
        'discoveryRestUrl'  => 'https://firestore.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'firestore',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development.',
        'title' => 'Cloud Firestore API',
        'id'    => 'firestore:v1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/firestore',
        'discoveryRestUrl'  => 'https://firestore.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'firestore',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' =>
          'Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development.',
        'title' => 'Cloud Firestore API',
        'id'    => 'firestore:v1beta1'
      },
      {
        'name'  => 'firestore',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title' => 'Cloud Firestore API',
        'description' =>
          'Accesses the NoSQL document database built for automatic scaling, high performance, and ease of application development.',
        'id'                => 'firestore:v1beta2',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/firestore',
        'version'           => 'v1beta2',
        'discoveryRestUrl'  => 'https://firestore.googleapis.com/$discovery/rest?version=v1beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'id'          => 'fitness:v1',
        'description' => 'Stores and accesses user data in the fitness store from apps on any platform.',
        'title'       => 'Fitness',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'fitness',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/fitness/v1/rest',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/fit/rest/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/fitness/v1/rest'
      },
      {
        'id'          => 'fusiontables:v1',
        'title'       => 'Fusion Tables API',
        'description' => 'API for working with Fusion Tables data.',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'fusiontables',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/fusiontables/v1/rest',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/fusiontables',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/fusiontables/v1/rest'
      },
      {
        'description' => 'API for working with Fusion Tables data.',
        'title'       => 'Fusion Tables API',
        'id'          => 'fusiontables:v2',
        'name'        => 'fusiontables',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/fusiontables/v2/rest',
        'version'           => 'v2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/fusiontables/v2/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/fusiontables'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/games/v1/rest',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/games/services/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/games/v1/rest',
        'id'                => 'games:v1',
        'description'       => 'The API for Google Play Game Services.',
        'title'             => 'Google Play Game Services API',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'games'
      },
      {
        'name'  => 'gamesConfiguration',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Google Play Game Services Publishing API',
        'description'       => 'The Publishing API for Google Play Game Services.',
        'id'                => 'gamesConfiguration:v1configuration',
        'discoveryLink'     => './apis/gamesConfiguration/v1configuration/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/games/services',
        'version'           => 'v1configuration',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/gamesConfiguration/v1configuration/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1management',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/gamesManagement/v1management/rest',
        'documentationLink' => 'https://developers.google.com/games/services',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/gamesManagement/v1management/rest',
        'id'                => 'gamesManagement:v1management',
        'title'             => 'Google Play Game Services Management API',
        'description'       => 'The Management API for Google Play Game Services.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'gamesManagement'
      },
      {
        'id'          => 'genomics:v1alpha2',
        'title'       => 'Genomics API',
        'description' => 'Upload, process, query, and search Genomics data in the cloud.',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'genomics',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://genomics.googleapis.com/$discovery/rest?version=v1alpha2',
        'version'           => 'v1alpha2',
        'documentationLink' => 'https://cloud.google.com/genomics',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/genomics',
        'version'           => 'v2alpha1',
        'discoveryRestUrl'  => 'https://genomics.googleapis.com/$discovery/rest?version=v2alpha1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'genomics',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' => 'Upload, process, query, and search Genomics data in the cloud.',
        'title'       => 'Genomics API',
        'id'          => 'genomics:v2alpha1'
      },
      {
        'name'  => 'genomics',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'             => 'Genomics API',
        'description'       => 'Upload, process, query, and search Genomics data in the cloud.',
        'id'                => 'genomics:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/genomics',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://genomics.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'id'          => 'gmail:v1',
        'title'       => 'Gmail API',
        'description' => 'Access Gmail mailboxes including sending user email.',
        'icons'       => {
          'x16' => 'https://www.google.com/images/icons/product/googlemail-16.png',
          'x32' => 'https://www.google.com/images/icons/product/googlemail-32.png'
        },
        'name'              => 'gmail',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/gmail/v1/rest',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/gmail/api/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/gmail/v1/rest'
      },
      {
        'discoveryLink'     => './apis/groupsmigration/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/google-apps/groups-migration/',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/groupsmigration/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'groupsmigration',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/discussions-16.gif',
          'x32' => 'https://www.google.com/images/icons/product/discussions-32.gif'
        },
        'description' => 'Groups Migration Api.',
        'title'       => 'Groups Migration API',
        'id'          => 'groupsmigration:v1'
      },
      {
        'documentationLink' => 'https://developers.google.com/google-apps/groups-settings/get_started',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/groupssettings/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/groupssettings/v1/rest',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'        => 'groupssettings',
        'id'          => 'groupssettings:v1',
        'title'       => 'Groups Settings API',
        'description' => 'Lets you manage permission levels and related settings of a group.'
      },
      {
        'name'  => 'iam',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'Manages identity and access control for Google Cloud Platform resources, including the creation of service accounts, which you can use to authenticate to Google and make API calls.',
        'title'             => 'Identity and Access Management (IAM) API',
        'id'                => 'iam:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/iam/',
        'discoveryRestUrl'  => 'https://iam.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'id'          => 'iamcredentials:v1',
        'title'       => 'IAM Service Account Credentials API',
        'description' => 'IAM Service Account Credentials API',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'iamcredentials',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://iamcredentials.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://cloud.google.com/iam/docs/creating-short-lived-service-account-credentials',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://iap.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/iap',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'iap:v1beta1',
        'title'             => 'Cloud Identity-Aware Proxy API',
        'description'       => 'Controls access to cloud applications running on Google Cloud Platform.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'iap'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'identitytoolkit',
        'id'                => 'identitytoolkit:v3',
        'title'             => 'Google Identity Toolkit API',
        'description'       => 'Help the third party sites to implement federated login.',
        'documentationLink' => 'https://developers.google.com/identity-toolkit/v3/',
        'discoveryLink'     => './apis/identitytoolkit/v3/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v3',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/identitytoolkit/v3/rest'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/search/apis/indexing-api/',
        'version'           => 'v3',
        'discoveryRestUrl'  => 'https://indexing.googleapis.com/$discovery/rest?version=v3',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'indexing',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Indexing API',
        'description' => 'The Indexing API allows developers to share the life cycle of a Web Document with Google.',
        'id'          => 'indexing:v3'
      },
      {
        'documentationLink' => 'https://cloud.google.com/talent-solution/job-search/docs/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://jobs.googleapis.com/$discovery/rest?version=v3p1beta1',
        'version'           => 'v3p1beta1',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'jobs',
        'id'   => 'jobs:v3p1beta1',
        'description' =>
          'Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters.',
        'title' => 'Cloud Talent Solution API'
      },
      {
        'documentationLink' => 'https://cloud.google.com/talent-solution/job-search/docs/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://jobs.googleapis.com/$discovery/rest?version=v2',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'  => 'jobs',
        'id'    => 'jobs:v2',
        'title' => 'Cloud Talent Solution API',
        'description' =>
          'Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters.'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v3',
        'discoveryRestUrl'  => 'https://jobs.googleapis.com/$discovery/rest?version=v3',
        'documentationLink' => 'https://cloud.google.com/talent-solution/job-search/docs/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'jobs:v3',
        'description' =>
          'Cloud Talent Solution provides the capability to create, read, update, and delete job postings, as well as search jobs based on keywords and filters.',
        'title' => 'Cloud Talent Solution API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'jobs'
      },
      {
        'discoveryRestUrl'  => 'https://kgsearch.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/knowledge-graph/',
        'description'       => 'Searches the Google Knowledge Graph for entities.',
        'title'             => 'Knowledge Graph Search API',
        'id'                => 'kgsearch:v1',
        'name'              => 'kgsearch',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'id' => 'language:v1',
        'description' =>
          'Provides natural language understanding technologies to developers. Examples include sentiment analysis, entity recognition, entity sentiment analysis, and text annotations.',
        'title' => 'Cloud Natural Language API',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'language',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://language.googleapis.com/$discovery/rest?version=v1',
        'documentationLink' => 'https://cloud.google.com/natural-language/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'language',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'Provides natural language understanding technologies to developers. Examples include sentiment analysis, entity recognition, entity sentiment analysis, and text annotations.',
        'title'             => 'Cloud Natural Language API',
        'id'                => 'language:v1beta1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/natural-language/',
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://language.googleapis.com/$discovery/rest?version=v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'  => 'language',
        'id'    => 'language:v1beta2',
        'title' => 'Cloud Natural Language API',
        'description' =>
          'Provides natural language understanding technologies to developers. Examples include sentiment analysis, entity recognition, entity sentiment analysis, and text annotations.',
        'documentationLink' => 'https://cloud.google.com/natural-language/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://language.googleapis.com/$discovery/rest?version=v1beta2',
        'version'           => 'v1beta2'
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/licensing/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/licensing/v1/rest',
        'documentationLink' => 'https://developers.google.com/google-apps/licensing/',
        'title'             => 'Enterprise License Manager API',
        'description'       => 'Views and manages licenses for your domain.',
        'id'                => 'licensing:v1',
        'name'              => 'licensing',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'description' => 'Writes log entries and manages your Logging configuration.',
        'title'       => 'Stackdriver Logging API',
        'id'          => 'logging:v2',
        'name'        => 'logging',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://logging.googleapis.com/$discovery/rest?version=v2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/logging/docs/'
      },
      {
        'documentationLink' => 'https://cloud.google.com/logging/docs/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2beta1',
        'discoveryRestUrl'  => 'https://logging.googleapis.com/$discovery/rest?version=v2beta1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'logging',
        'id'          => 'logging:v2beta1',
        'title'       => 'Stackdriver Logging API',
        'description' => 'Writes log entries and manages your Logging configuration.'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'manufacturers',
        'id'                => 'manufacturers:v1',
        'title'             => 'Manufacturer Center API',
        'description'       => 'Public API for managing Manufacturer Center related data.',
        'documentationLink' => 'https://developers.google.com/manufacturers/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://manufacturers.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1'
      },
      {
        'name'  => 'mirror',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description'       => 'Interacts with Glass users via the timeline.',
        'title'             => 'Google Mirror API',
        'id'                => 'mirror:v1',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/mirror/v1/rest',
        'documentationLink' => 'https://developers.google.com/glass',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/mirror/v1/rest',
        'version'           => 'v1',
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'ml',
        'id'                => 'ml:v1',
        'description'       => 'An API to enable creating and using machine learning models.',
        'title'             => 'Cloud Machine Learning Engine',
        'documentationLink' => 'https://cloud.google.com/ml/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://ml.googleapis.com/$discovery/rest?version=v1'
      },
      {
        'discoveryRestUrl'  => 'https://monitoring.googleapis.com/$discovery/rest?version=v3',
        'version'           => 'v3',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/monitoring/api/',
        'description' =>
          'Manages your Stackdriver Monitoring data and configurations. Most projects must be associated with a Stackdriver account, with a few exceptions as noted on the individual method pages.',
        'title' => 'Stackdriver Monitoring API',
        'id'    => 'monitoring:v3',
        'name'  => 'monitoring',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/oauth2/v1/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/oauth2/v1/rest',
        'documentationLink' => 'https://developers.google.com/accounts/docs/OAuth2',
        'title'             => 'Google OAuth2 API',
        'description'       => 'Obtains end-user authorization grants for use with other Google APIs.',
        'id'                => 'oauth2:v1',
        'name'              => 'oauth2',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'id'          => 'oauth2:v2',
        'title'       => 'Google OAuth2 API',
        'description' => 'Obtains end-user authorization grants for use with other Google APIs.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'oauth2',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/oauth2/v2/rest',
        'version'           => 'v2',
        'documentationLink' => 'https://developers.google.com/accounts/docs/OAuth2',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/oauth2/v2/rest'
      },
      {
        'version'           => 'v1alpha',
        'discoveryRestUrl'  => 'https://oslogin.googleapis.com/$discovery/rest?version=v1alpha',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/compute/docs/oslogin/rest/',
        'title'             => 'Cloud OS Login API',
        'description'       => 'Manages OS login configuration for Google account users.',
        'id'                => 'oslogin:v1alpha',
        'name'              => 'oslogin',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'id'          => 'oslogin:v1beta',
        'description' => 'Manages OS login configuration for Google account users.',
        'title'       => 'Cloud OS Login API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'oslogin',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://oslogin.googleapis.com/$discovery/rest?version=v1beta',
        'version'           => 'v1beta',
        'documentationLink' => 'https://cloud.google.com/compute/docs/oslogin/rest/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'oslogin',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Cloud OS Login API',
        'description'       => 'Manages OS login configuration for Google account users.',
        'id'                => 'oslogin:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/compute/docs/oslogin/rest/',
        'discoveryRestUrl'  => 'https://oslogin.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/pagespeedonline/v1/rest',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/pagespeedonline/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/speed/docs/insights/v1/getting_started',
        'description'       => 'Analyzes the performance of a web page and provides tailored suggestions to make that page faster.',
        'title'             => 'PageSpeed Insights API',
        'id'                => 'pagespeedonline:v1',
        'name'              => 'pagespeedonline',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/pagespeed-16.png',
          'x32' => 'https://www.google.com/images/icons/product/pagespeed-32.png'
        }
      },
      {
        'discoveryLink'     => './apis/pagespeedonline/v2/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/speed/docs/insights/v2/getting-started',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/pagespeedonline/v2/rest',
        'version'           => 'v2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'pagespeedonline',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/pagespeed-32.png',
          'x16' => 'https://www.google.com/images/icons/product/pagespeed-16.png'
        },
        'title'       => 'PageSpeed Insights API',
        'description' => 'Analyzes the performance of a web page and provides tailored suggestions to make that page faster.',
        'id'          => 'pagespeedonline:v2'
      },
      {
        'icons' => {
          'x16' => 'https://www.google.com/images/icons/product/pagespeed-16.png',
          'x32' => 'https://www.google.com/images/icons/product/pagespeed-32.png'
        },
        'name'              => 'pagespeedonline',
        'id'                => 'pagespeedonline:v4',
        'title'             => 'PageSpeed Insights API',
        'description'       => 'Analyzes the performance of a web page and provides tailored suggestions to make that page faster.',
        'documentationLink' => 'https://developers.google.com/speed/docs/insights/v4/getting-started',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/pagespeedonline/v4/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/pagespeedonline/v4/rest',
        'version'           => 'v4'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'partners',
        'id'                => 'partners:v2',
        'title'             => 'Google Partners API',
        'description'       => 'Searches certified companies and creates contact leads with them, and also audits the usage of clients.',
        'documentationLink' => 'https://developers.google.com/partners/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://partners.googleapis.com/$discovery/rest?version=v2'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://people.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/people/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'people:v1',
        'title'             => 'People API',
        'description'       => 'Provides access to information about profiles and contacts.',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'people'
      },
      {
        'discoveryLink'     => './apis/playcustomapp/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/android/work/play/custom-app-api',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/playcustomapp/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'playcustomapp',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' => 'An API to publish custom Android apps.',
        'title'       => 'Google Play Custom App Publishing API',
        'id'          => 'playcustomapp:v1'
      },
      {
        'documentationLink' => 'https://developers.google.com/+/api/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/plus/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/plus/v1/rest',
        'icons'             => {
          'x16' => 'http://www.google.com/images/icons/product/gplus-16.png',
          'x32' => 'http://www.google.com/images/icons/product/gplus-32.png'
        },
        'name'        => 'plus',
        'id'          => 'plus:v1',
        'title'       => 'Google+ API',
        'description' => 'Builds on top of the Google+ platform.'
      },
      {
        'description' => 'Builds on top of the Google+ platform for Google Apps Domains.',
        'title'       => 'Google+ Domains API',
        'id'          => 'plusDomains:v1',
        'name'        => 'plusDomains',
        'icons'       => {
          'x16' => 'http://www.google.com/images/icons/product/gplus-16.png',
          'x32' => 'http://www.google.com/images/icons/product/gplus-32.png'
        },
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/plusDomains/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/plusDomains/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/+/domains/'
      },
      {
        'id'          => 'poly:v1',
        'title'       => 'Poly API',
        'description' => 'The Poly API provides read-only access to assets hosted on poly.google.com.',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'poly',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://poly.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/poly/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'proximitybeacon',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description'       => 'Registers, manages, indexes, and searches beacons.',
        'title'             => 'Proximity Beacon API',
        'id'                => 'proximitybeacon:v1beta1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/beacons/proximity/',
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://proximitybeacon.googleapis.com/$discovery/rest?version=v1beta1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'description' => 'Provides reliable, many-to-many, asynchronous messaging between applications.',
        'title'       => 'Cloud Pub/Sub API',
        'id'          => 'pubsub:v1beta1a',
        'name'        => 'pubsub',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v1beta1a',
        'discoveryRestUrl'  => 'https://pubsub.googleapis.com/$discovery/rest?version=v1beta1a',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/pubsub/docs'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'pubsub',
        'id'                => 'pubsub:v1',
        'description'       => 'Provides reliable, many-to-many, asynchronous messaging between applications.',
        'title'             => 'Cloud Pub/Sub API',
        'documentationLink' => 'https://cloud.google.com/pubsub/docs',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://pubsub.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/pubsub/docs',
        'version'           => 'v1beta2',
        'discoveryRestUrl'  => 'https://pubsub.googleapis.com/$discovery/rest?version=v1beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'pubsub',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' => 'Provides reliable, many-to-many, asynchronous messaging between applications.',
        'title'       => 'Cloud Pub/Sub API',
        'id'          => 'pubsub:v1beta2'
      },
      {
        'documentationLink' => 'https://cloud.google.com/memorystore/docs/redis/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://redis.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'redis',
        'id'   => 'redis:v1',
        'description' =>
          'The Google Cloud Memorystore for Redis API is used for creating and managing Redis instances on the Google Cloud Platform.',
        'title' => 'Google Cloud Memorystore for Redis API'
      },
      {
        'id'    => 'redis:v1beta1',
        'title' => 'Google Cloud Memorystore for Redis API',
        'description' =>
          'The Google Cloud Memorystore for Redis API is used for creating and managing Redis instances on the Google Cloud Platform.',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'redis',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://redis.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'documentationLink' => 'https://cloud.google.com/memorystore/docs/redis/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'id'    => 'replicapool:v1beta1',
        'title' => 'Replica Pool API',
        'description' =>
          'The Replica Pool API allows users to declaratively provision and manage groups of Google Compute Engine instances based on a common template.',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'replicapool',
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/replicapool/v1beta1/rest',
        'documentationLink' => 'https://developers.google.com/compute/docs/replica-pool/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/replicapool/v1beta1/rest'
      },
      {
        'preferred'        => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'labels'           => ['limited_availability'],
        'discoveryRestUrl' => 'https://www.googleapis.com/discovery/v1/apis/replicapoolupdater/v1beta1/rest',
        'version'          => 'v1beta1',
        'documentationLink' =>
          'https://cloud.google.com/compute/docs/instance-groups/manager/#applying_rolling_updates_using_the_updater_service',
        'kind'          => 'discovery#directoryItem',
        'discoveryLink' => './apis/replicapoolupdater/v1beta1/rest',
        'id'            => 'replicapoolupdater:v1beta1',
        'description' =>
          '[Deprecated. Please use compute.instanceGroupManagers.update method. replicapoolupdater API will be disabled after December 30th, 2016] Updates groups of Compute Engine instances.',
        'title' => 'Google Compute Engine Instance Group Updater API',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'replicapoolupdater'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/reseller/v1/rest',
        'documentationLink' => 'https://developers.google.com/google-apps/reseller/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/reseller/v1/rest',
        'labels'            => ['limited_availability'],
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'reseller',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Enterprise Apps Reseller API',
        'description' => 'Creates and manages your customers and their subscriptions.',
        'id'          => 'reseller:v1'
      },
      {
        'id' => 'runtimeconfig:v1',
        'description' =>
          'The Runtime Configurator allows you to dynamically configure and expose variables through Google Cloud Platform. In addition, you can also set Watchers and Waiters that will watch for changes to your data and return based on certain conditions.',
        'title' => 'Cloud Runtime Configuration API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'runtimeconfig',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://runtimeconfig.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://cloud.google.com/deployment-manager/runtime-configurator/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://runtimeconfig.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/deployment-manager/runtime-configurator/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'runtimeconfig:v1beta1',
        'description' =>
          'The Runtime Configurator allows you to dynamically configure and expose variables through Google Cloud Platform. In addition, you can also set Watchers and Waiters that will watch for changes to your data and return based on certain conditions.',
        'title' => 'Cloud Runtime Configuration API',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'runtimeconfig'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/safe-browsing/',
        'version'           => 'v4',
        'discoveryRestUrl'  => 'https://safebrowsing.googleapis.com/$discovery/rest?version=v4',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'safebrowsing',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' =>
          'Enables client applications to check web resources (most commonly URLs) against Google-generated lists of unsafe web resources.',
        'title' => 'Safe Browsing API',
        'id'    => 'safebrowsing:v4'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/apps-script/api/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://script.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'script',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' => 'An API for managing and executing Google Apps Script projects.',
        'title'       => 'Apps Script API',
        'id'          => 'script:v1'
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'searchconsole',
        'id'                => 'searchconsole:v1',
        'description'       => 'Provides tools for running validation tests against single URLs',
        'title'             => 'Google Search Console URL Testing Tools API',
        'documentationLink' => 'https://developers.google.com/webmaster-tools/search-console-api/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://searchconsole.googleapis.com/$discovery/rest?version=v1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/kubernetes-engine/docs/concepts/add-on/service-broker',
        'discoveryRestUrl'  => 'https://servicebroker.googleapis.com/$discovery/rest?version=v1alpha1',
        'version'           => 'v1alpha1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'servicebroker',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description' =>
          'The Google Cloud Platform Service Broker API provides Google hosted implementation of the Open Service Broker API (https://www.openservicebrokerapi.org/).',
        'title' => 'Service Broker API',
        'id'    => 'servicebroker:v1alpha1'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'servicebroker',
        'id'   => 'servicebroker:v1',
        'description' =>
          'The Google Cloud Platform Service Broker API provides Google hosted implementation of the Open Service Broker API (https://www.openservicebrokerapi.org/).',
        'title'             => 'Service Broker API',
        'documentationLink' => 'https://cloud.google.com/kubernetes-engine/docs/concepts/add-on/service-broker',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://servicebroker.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1'
      },
      {
        'id' => 'servicebroker:v1beta1',
        'description' =>
          'The Google Cloud Platform Service Broker API provides Google hosted implementation of the Open Service Broker API (https://www.openservicebrokerapi.org/).',
        'title' => 'Service Broker API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'servicebroker',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://servicebroker.googleapis.com/$discovery/rest?version=v1beta1',
        'documentationLink' => 'https://cloud.google.com/kubernetes-engine/docs/concepts/add-on/service-broker',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://serviceconsumermanagement.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://cloud.google.com/service-consumer-management/docs/overview',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'serviceconsumermanagement:v1',
        'description'       => 'Provides management methods for configuring service producer resources on Google Cloud.',
        'title'             => 'Service Consumer Management API',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'serviceconsumermanagement'
      },
      {
        'discoveryRestUrl'  => 'https://servicecontrol.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/service-control/',
        'title'             => 'Service Control API',
        'description' =>
          'Google Service Control provides control plane functionality to managed services, such as logging, monitoring, and status checks.',
        'id'    => 'servicecontrol:v1',
        'name'  => 'servicecontrol',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'documentationLink' => 'https://cloud.google.com/service-management/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://servicemanagement.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'servicemanagement',
        'id'   => 'servicemanagement:v1',
        'description' =>
          'Google Service Management allows service producers to publish their services on Google Cloud Platform so that they can be discovered and used by service consumers.',
        'title' => 'Service Management API'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/',
        'discoveryRestUrl'  => 'https://servicenetworking.googleapis.com/$discovery/rest?version=v1beta',
        'version'           => 'v1beta',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'servicenetworking',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' =>
          'The Service Networking API provides automatic management of network configurations necessary for certain services.',
        'title' => 'Service Networking API',
        'id'    => 'servicenetworking:v1beta'
      },
      {
        'documentationLink' => 'https://cloud.google.com/service-infrastructure/docs/service-networking/reference/rest/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://servicenetworking.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'servicenetworking',
        'id'   => 'servicenetworking:v1',
        'description' =>
          'The Service Networking API provides automatic management of network configurations necessary for certain services.',
        'title' => 'Service Networking API'
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'serviceusage',
        'id'   => 'serviceusage:v1',
        'description' =>
          'Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.',
        'title'             => 'Service Usage API',
        'documentationLink' => 'https://cloud.google.com/service-usage/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://serviceusage.googleapis.com/$discovery/rest?version=v1'
      },
      {
        'name'  => 'serviceusage',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'description' =>
          'Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.',
        'title'             => 'Service Usage API',
        'id'                => 'serviceusage:v1beta1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/service-usage/',
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://serviceusage.googleapis.com/$discovery/rest?version=v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'serviceuser',
        'id'   => 'serviceuser:v1',
        'description' =>
          'Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.',
        'title'             => 'Google Service User API',
        'documentationLink' => 'https://cloud.google.com/service-management/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://serviceuser.googleapis.com/$discovery/rest?version=v1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/sheets/',
        'discoveryRestUrl'  => 'https://sheets.googleapis.com/$discovery/rest?version=v4',
        'version'           => 'v4',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'sheets',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Google Sheets API',
        'description' => 'Reads and writes Google Sheets.',
        'id'          => 'sheets:v4'
      },
      {
        'title'       => 'Google Site Verification API',
        'description' => 'Verifies ownership of websites or domains with Google.',
        'id'          => 'siteVerification:v1',
        'name'        => 'siteVerification',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/siteVerification/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/siteVerification/v1/rest',
        'documentationLink' => 'https://developers.google.com/site-verification/'
      },
      {
        'id'          => 'slides:v1',
        'description' => 'An API for creating and editing Google Slides presentations.',
        'title'       => 'Google Slides API',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'slides',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://slides.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/slides/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'documentationLink' => 'https://cloud.google.com/source-repositories/docs/apis',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://sourcerepo.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'        => 'sourcerepo',
        'id'          => 'sourcerepo:v1',
        'title'       => 'Cloud Source Repositories API',
        'description' => 'Access source code repositories hosted by Google.'
      },
      {
        'name'  => 'spanner',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Cloud Spanner API',
        'description' => 'Cloud Spanner is a managed, mission-critical, globally consistent and scalable relational database service.',
        'id'          => 'spanner:v1',
        'kind'        => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/spanner/',
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://spanner.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://speech.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/speech-to-text/docs/quickstart-protocol',
        'description'       => 'Converts audio to text by applying powerful neural network models.',
        'title'             => 'Cloud Speech API',
        'id'                => 'speech:v1',
        'name'              => 'speech',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'title'       => 'Cloud Speech API',
        'description' => 'Converts audio to text by applying powerful neural network models.',
        'id'          => 'speech:v1beta1',
        'name'        => 'speech',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://speech.googleapis.com/$discovery/rest?version=v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/speech-to-text/docs/quickstart-protocol'
      },
      {
        'documentationLink' => 'https://cloud.google.com/sql/docs/reference/latest',
        'discoveryLink'     => './apis/sqladmin/v1beta4/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1beta4',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/sqladmin/v1beta4/rest',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'sqladmin',
        'id'          => 'sqladmin:v1beta4',
        'description' => 'Creates and manages Cloud SQL instances, which provide fully managed MySQL or PostgreSQL databases.',
        'title'       => 'Cloud SQL Admin API'
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/storage/v1/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'labels'            => ['labs'],
        'discoveryLink'     => './apis/storage/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/storage/docs/json_api/',
        'title'             => 'Cloud Storage JSON API',
        'description'       => 'Stores and retrieves potentially large, immutable data objects.',
        'id'                => 'storage:v1',
        'name'              => 'storage',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/cloud_storage-32.png',
          'x16' => 'https://www.google.com/images/icons/product/cloud_storage-16.png'
        }
      },
      {
        'description' => 'Lets you store and retrieve potentially-large, immutable data objects.',
        'title'       => 'Cloud Storage JSON API',
        'id'          => 'storage:v1beta1',
        'name'        => 'storage',
        'icons'       => {
          'x16' => 'https://www.google.com/images/icons/product/cloud_storage-16.png',
          'x32' => 'https://www.google.com/images/icons/product/cloud_storage-32.png'
        },
        'version'           => 'v1beta1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/storage/v1beta1/rest',
        'labels'            => ['labs'],
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/storage/v1beta1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/storage/docs/json_api/'
      },
      {
        'id'          => 'storage:v1beta2',
        'description' => 'Lets you store and retrieve potentially-large, immutable data objects.',
        'title'       => 'Cloud Storage JSON API',
        'icons'       => {
          'x16' => 'https://www.google.com/images/icons/product/cloud_storage-16.png',
          'x32' => 'https://www.google.com/images/icons/product/cloud_storage-32.png'
        },
        'name'              => 'storage',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'labels'            => ['labs'],
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/storage/v1beta2/rest',
        'version'           => 'v1beta2',
        'documentationLink' => 'https://developers.google.com/storage/docs/json_api/',
        'discoveryLink'     => './apis/storage/v1beta2/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://storagetransfer.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://cloud.google.com/storage/transfer',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'storagetransfer:v1',
        'title'             => 'Storage Transfer API',
        'description' =>
          'Transfers data from external data sources to a Google Cloud Storage bucket or between Google Cloud Storage buckets.',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'storagetransfer'
      },
      {
        'documentationLink' => 'https://developers.google.com/streetview/publish/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://streetviewpublish.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'  => 'streetviewpublish',
        'id'    => 'streetviewpublish:v1',
        'title' => 'Street View Publish API',
        'description' =>
          'Publishes 360 photos to Google Maps, along with position, orientation, and connectivity metadata. Apps can offer an interface for positioning, connecting, and uploading user-generated Street View images.'
      },
      {
        'preferred'        => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'          => 'v2',
        'discoveryRestUrl' => 'https://www.googleapis.com/discovery/v1/apis/surveys/v2/rest',
        'discoveryLink'    => './apis/surveys/v2/rest',
        'kind'             => 'discovery#directoryItem',
        'id'               => 'surveys:v2',
        'description' =>
          'Creates and conducts surveys, lists the surveys that an authenticated user owns, and retrieves survey results and information about specified surveys.',
        'title' => 'Surveys API',
        'icons' => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'surveys'
      },
      {
        'name'  => 'tagmanager',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'description'       => 'Accesses Tag Manager accounts and containers.',
        'title'             => 'Tag Manager API',
        'id'                => 'tagmanager:v1',
        'discoveryLink'     => './apis/tagmanager/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/tag-manager/api/v1/',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/tagmanager/v1/rest',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
      },
      {
        'id'          => 'tagmanager:v2',
        'description' => 'Accesses Tag Manager accounts and containers.',
        'title'       => 'Tag Manager API',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'tagmanager',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/tagmanager/v2/rest',
        'documentationLink' => 'https://developers.google.com/tag-manager/api/v2/',
        'kind'              => 'discovery#directoryItem',
        'discoveryLink'     => './apis/tagmanager/v2/rest'
      },
      {
        'documentationLink' => 'https://developers.google.com/google-apps/tasks/firstapp',
        'discoveryLink'     => './apis/tasks/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/tasks/v1/rest',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/tasks-32.png',
          'x16' => 'https://www.google.com/images/icons/product/tasks-16.png'
        },
        'name'        => 'tasks',
        'id'          => 'tasks:v1',
        'title'       => 'Tasks API',
        'description' => 'Lets you manage your tasks and task lists.'
      },
      {
        'id'          => 'testing:v1',
        'description' => 'Allows developers to run automated tests for their mobile applications on Google infrastructure.',
        'title'       => 'Cloud Testing API',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'testing',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://testing.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/cloud-test-lab/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'name'  => 'texttospeech',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'             => 'Cloud Text-to-Speech API',
        'description'       => 'Synthesizes natural-sounding speech by applying powerful neural network models.',
        'id'                => 'texttospeech:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/text-to-speech/',
        'discoveryRestUrl'  => 'https://texttospeech.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/text-to-speech/',
        'discoveryRestUrl'  => 'https://texttospeech.googleapis.com/$discovery/rest?version=v1beta1',
        'version'           => 'v1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'texttospeech',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Cloud Text-to-Speech API',
        'description' => 'Synthesizes natural-sounding speech by applying powerful neural network models.',
        'id'          => 'texttospeech:v1beta1'
      },
      {
        'discoveryLink'     => './apis/toolresults/v1beta3/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://firebase.google.com/docs/test-lab/',
        'version'           => 'v1beta3',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/toolresults/v1beta3/rest',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'toolresults',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title'       => 'Cloud Tool Results API',
        'description' => 'Reads and publishes results from Firebase Test Lab.',
        'id'          => 'toolresults:v1beta3'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/tpu/',
        'version'           => 'v1alpha1',
        'discoveryRestUrl'  => 'https://tpu.googleapis.com/$discovery/rest?version=v1alpha1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'tpu',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title'       => 'Cloud TPU API',
        'description' => 'TPU API provides customers with access to Google TPU technology.',
        'id'          => 'tpu:v1alpha1'
      },
      {
        'documentationLink' => 'https://cloud.google.com/tpu/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://tpu.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'        => 'tpu',
        'id'          => 'tpu:v1',
        'title'       => 'Cloud TPU API',
        'description' => 'TPU API provides customers with access to Google TPU technology.'
      },
      {
        'id'          => 'translate:v2',
        'title'       => 'Cloud Translation API',
        'description' => 'The Google Cloud Translation API lets websites and programs integrate with Google Translate programmatically.',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'translate',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v2',
        'discoveryRestUrl'  => 'https://translation.googleapis.com/$discovery/rest?version=v2',
        'documentationLink' => 'https://code.google.com/apis/language/translate/v2/getting_started.html',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'id'          => 'urlshortener:v1',
        'title'       => 'URL Shortener API',
        'description' => 'Lets you create, inspect, and manage goo.gl short URLs',
        'icons'       => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'              => 'urlshortener',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/urlshortener/v1/rest',
        'version'           => 'v1',
        'documentationLink' => 'https://developers.google.com/url-shortener/v1/getting_started',
        'discoveryLink'     => './apis/urlshortener/v1/rest',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://vault.googleapis.com/$discovery/rest?version=v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/vault',
        'title'             => 'G Suite Vault API',
        'description'       => 'Archiving and eDiscovery for G Suite.',
        'id'                => 'vault:v1',
        'name'              => 'vault',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        }
      },
      {
        'title'       => 'Cloud Video Intelligence API',
        'description' => 'Cloud Video Intelligence API.',
        'id'          => 'videointelligence:v1p1beta1',
        'name'        => 'videointelligence',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'version'           => 'v1p1beta1',
        'discoveryRestUrl'  => 'https://videointelligence.googleapis.com/$discovery/rest?version=v1p1beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/video-intelligence/docs/'
      },
      {
        'id'          => 'videointelligence:v1',
        'title'       => 'Cloud Video Intelligence API',
        'description' => 'Cloud Video Intelligence API.',
        'icons'       => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'              => 'videointelligence',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://videointelligence.googleapis.com/$discovery/rest?version=v1',
        'documentationLink' => 'https://cloud.google.com/video-intelligence/docs/',
        'kind'              => 'discovery#directoryItem'
      },
      {
        'discoveryRestUrl'  => 'https://videointelligence.googleapis.com/$discovery/rest?version=v1beta2',
        'version'           => 'v1beta2',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/video-intelligence/docs/',
        'title'             => 'Cloud Video Intelligence API',
        'description'       => 'Cloud Video Intelligence API.',
        'id'                => 'videointelligence:v1beta2',
        'name'              => 'videointelligence',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        }
      },
      {
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name' => 'vision',
        'id'   => 'vision:v1p1beta1',
        'description' =>
          'Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.',
        'title'             => 'Cloud Vision API',
        'documentationLink' => 'https://cloud.google.com/vision/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://vision.googleapis.com/$discovery/rest?version=v1p1beta1',
        'version'           => 'v1p1beta1'
      },
      {
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://cloud.google.com/vision/',
        'discoveryRestUrl'  => 'https://vision.googleapis.com/$discovery/rest?version=v1p2beta1',
        'version'           => 'v1p2beta1',
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'vision',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'title' => 'Cloud Vision API',
        'description' =>
          'Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.',
        'id' => 'vision:v1p2beta1'
      },
      {
        'documentationLink' => 'https://cloud.google.com/vision/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://vision.googleapis.com/$discovery/rest?version=v1',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name'  => 'vision',
        'id'    => 'vision:v1',
        'title' => 'Cloud Vision API',
        'description' =>
          'Integrates Google Vision features, including image labeling, face, logo, and landmark detection, optical character recognition (OCR), and detection of explicit content, into applications.'
      },
      {
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/webfonts/v1/rest',
        'documentationLink' => 'https://developers.google.com/fonts/docs/developer_api',
        'discoveryLink'     => './apis/webfonts/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'webfonts:v1',
        'title'             => 'Google Fonts Developer API',
        'description' =>
          'Accesses the metadata for all families served by Google Fonts, providing a list of families currently available (including available styles and a list of supported script subsets).',
        'icons' => {
          'x32' => 'https://www.google.com/images/icons/feature/font_api-32.gif',
          'x16' => 'https://www.google.com/images/icons/feature/font_api-16.png'
        },
        'name' => 'webfonts'
      },
      {
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/webmasters/v3/rest',
        'version'           => 'v3',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryLink'     => './apis/webmasters/v3/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/webmaster-tools/',
        'title'             => 'Search Console API',
        'description'       => 'View Google Search Console data for your verified sites.',
        'id'                => 'webmasters:v3',
        'name'              => 'webmasters',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/webmaster_tools-16.png',
          'x32' => 'https://www.google.com/images/icons/product/webmaster_tools-32.png'
        }
      },
      {
        'documentationLink' => 'https://cloud.google.com/security-scanner/',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1alpha',
        'discoveryRestUrl'  => 'https://websecurityscanner.googleapis.com/$discovery/rest?version=v1alpha',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'        => 'websecurityscanner',
        'id'          => 'websecurityscanner:v1alpha',
        'description' => 'Web Security Scanner API (under development).',
        'title'       => 'Web Security Scanner API'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://websecurityscanner.googleapis.com/$discovery/rest?version=v1beta',
        'version'           => 'v1beta',
        'documentationLink' => 'https://cloud.google.com/security-scanner/',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'websecurityscanner:v1beta',
        'title'             => 'Web Security Scanner API',
        'description'       => 'Web Security Scanner API (under development).',
        'icons'             => {
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png',
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png'
        },
        'name' => 'websecurityscanner'
      },
      {
        'documentationLink' => 'https://developers.google.com/youtube/v3',
        'discoveryLink'     => './apis/youtube/v3/rest',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/youtube/v3/rest',
        'version'           => 'v3',
        'icons'             => {
          'x32' => 'https://www.google.com/images/icons/product/youtube-32.png',
          'x16' => 'https://www.google.com/images/icons/product/youtube-16.png'
        },
        'name' => 'youtube',
        'id'   => 'youtube:v3',
        'description' =>
          'Supports core YouTube features, such as uploading videos, creating and managing playlists, searching for content, and much more.',
        'title' => 'YouTube Data API'
      },
      {
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'version'           => 'v1',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/youtubeAnalytics/v1/rest',
        'documentationLink' => 'http://developers.google.com/youtube/analytics/',
        'discoveryLink'     => './apis/youtubeAnalytics/v1/rest',
        'kind'              => 'discovery#directoryItem',
        'id'                => 'youtubeAnalytics:v1',
        'description'       => 'Retrieves your YouTube Analytics data.',
        'title'             => 'YouTube Analytics API',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/youtube-16.png',
          'x32' => 'https://www.google.com/images/icons/product/youtube-32.png'
        },
        'name' => 'youtubeAnalytics'
      },
      {
        'discoveryLink'     => './apis/youtubeAnalytics/v1beta1/rest',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'http://developers.google.com/youtube/analytics/',
        'discoveryRestUrl'  => 'https://www.googleapis.com/discovery/v1/apis/youtubeAnalytics/v1beta1/rest',
        'version'           => 'v1beta1',
        'labels'            => ['deprecated'],
        'preferred'         => bless( do { \( my $o = 0 ) }, 'JSON::PP::Boolean' ),
        'name'              => 'youtubeAnalytics',
        'icons'             => {
          'x16' => 'https://www.google.com/images/icons/product/youtube-16.png',
          'x32' => 'https://www.google.com/images/icons/product/youtube-32.png'
        },
        'title'       => 'YouTube Analytics API',
        'description' => 'Retrieves your YouTube Analytics data.',
        'id'          => 'youtubeAnalytics:v1beta1'
      },
      {
        'documentationLink' => 'https://developers.google.com/youtube/analytics',
        'kind'              => 'discovery#directoryItem',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' ),
        'discoveryRestUrl'  => 'https://youtubeanalytics.googleapis.com/$discovery/rest?version=v2',
        'version'           => 'v2',
        'icons'             => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'name'        => 'youtubeAnalytics',
        'id'          => 'youtubeAnalytics:v2',
        'title'       => 'YouTube Analytics API',
        'description' => 'Retrieves your YouTube Analytics data.'
      },
      {
        'name'  => 'youtubereporting',
        'icons' => {
          'x32' => 'https://www.gstatic.com/images/branding/product/1x/googleg_32dp.png',
          'x16' => 'https://www.gstatic.com/images/branding/product/1x/googleg_16dp.png'
        },
        'title' => 'YouTube Reporting API',
        'description' =>
          'Schedules reporting jobs containing your YouTube Analytics data and downloads the resulting bulk data reports in the form of CSV files.',
        'id'                => 'youtubereporting:v1',
        'kind'              => 'discovery#directoryItem',
        'documentationLink' => 'https://developers.google.com/youtube/reporting/v1/reports/',
        'discoveryRestUrl'  => 'https://youtubereporting.googleapis.com/$discovery/rest?version=v1',
        'version'           => 'v1',
        'preferred'         => bless( do { \( my $o = 1 ) }, 'JSON::PP::Boolean' )
      }
    ],
    'discoveryVersion' => 'v1',
    'kind'             => 'discovery#directoryList'
  };
}
