# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.4
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Math::GSL::Histogram2D;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::Histogram2Dc;
bootstrap Math::GSL::Histogram2D;
package Math::GSL::Histogram2D;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::Histogram2D;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Histogram2D;

*gsl_histogram2d_alloc = *Math::GSL::Histogram2Dc::gsl_histogram2d_alloc;
*gsl_histogram2d_calloc = *Math::GSL::Histogram2Dc::gsl_histogram2d_calloc;
*gsl_histogram2d_calloc_uniform = *Math::GSL::Histogram2Dc::gsl_histogram2d_calloc_uniform;
*gsl_histogram2d_free = *Math::GSL::Histogram2Dc::gsl_histogram2d_free;
*gsl_histogram2d_increment = *Math::GSL::Histogram2Dc::gsl_histogram2d_increment;
*gsl_histogram2d_accumulate = *Math::GSL::Histogram2Dc::gsl_histogram2d_accumulate;
*gsl_histogram2d_find = *Math::GSL::Histogram2Dc::gsl_histogram2d_find;
*gsl_histogram2d_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_get;
*gsl_histogram2d_get_xrange = *Math::GSL::Histogram2Dc::gsl_histogram2d_get_xrange;
*gsl_histogram2d_get_yrange = *Math::GSL::Histogram2Dc::gsl_histogram2d_get_yrange;
*gsl_histogram2d_xmax = *Math::GSL::Histogram2Dc::gsl_histogram2d_xmax;
*gsl_histogram2d_xmin = *Math::GSL::Histogram2Dc::gsl_histogram2d_xmin;
*gsl_histogram2d_nx = *Math::GSL::Histogram2Dc::gsl_histogram2d_nx;
*gsl_histogram2d_ymax = *Math::GSL::Histogram2Dc::gsl_histogram2d_ymax;
*gsl_histogram2d_ymin = *Math::GSL::Histogram2Dc::gsl_histogram2d_ymin;
*gsl_histogram2d_ny = *Math::GSL::Histogram2Dc::gsl_histogram2d_ny;
*gsl_histogram2d_reset = *Math::GSL::Histogram2Dc::gsl_histogram2d_reset;
*gsl_histogram2d_calloc_range = *Math::GSL::Histogram2Dc::gsl_histogram2d_calloc_range;
*gsl_histogram2d_set_ranges_uniform = *Math::GSL::Histogram2Dc::gsl_histogram2d_set_ranges_uniform;
*gsl_histogram2d_set_ranges = *Math::GSL::Histogram2Dc::gsl_histogram2d_set_ranges;
*gsl_histogram2d_memcpy = *Math::GSL::Histogram2Dc::gsl_histogram2d_memcpy;
*gsl_histogram2d_clone = *Math::GSL::Histogram2Dc::gsl_histogram2d_clone;
*gsl_histogram2d_max_val = *Math::GSL::Histogram2Dc::gsl_histogram2d_max_val;
*gsl_histogram2d_max_bin = *Math::GSL::Histogram2Dc::gsl_histogram2d_max_bin;
*gsl_histogram2d_min_val = *Math::GSL::Histogram2Dc::gsl_histogram2d_min_val;
*gsl_histogram2d_min_bin = *Math::GSL::Histogram2Dc::gsl_histogram2d_min_bin;
*gsl_histogram2d_xmean = *Math::GSL::Histogram2Dc::gsl_histogram2d_xmean;
*gsl_histogram2d_ymean = *Math::GSL::Histogram2Dc::gsl_histogram2d_ymean;
*gsl_histogram2d_xsigma = *Math::GSL::Histogram2Dc::gsl_histogram2d_xsigma;
*gsl_histogram2d_ysigma = *Math::GSL::Histogram2Dc::gsl_histogram2d_ysigma;
*gsl_histogram2d_cov = *Math::GSL::Histogram2Dc::gsl_histogram2d_cov;
*gsl_histogram2d_sum = *Math::GSL::Histogram2Dc::gsl_histogram2d_sum;
*gsl_histogram2d_equal_bins_p = *Math::GSL::Histogram2Dc::gsl_histogram2d_equal_bins_p;
*gsl_histogram2d_add = *Math::GSL::Histogram2Dc::gsl_histogram2d_add;
*gsl_histogram2d_sub = *Math::GSL::Histogram2Dc::gsl_histogram2d_sub;
*gsl_histogram2d_mul = *Math::GSL::Histogram2Dc::gsl_histogram2d_mul;
*gsl_histogram2d_div = *Math::GSL::Histogram2Dc::gsl_histogram2d_div;
*gsl_histogram2d_scale = *Math::GSL::Histogram2Dc::gsl_histogram2d_scale;
*gsl_histogram2d_shift = *Math::GSL::Histogram2Dc::gsl_histogram2d_shift;
*gsl_histogram2d_fwrite = *Math::GSL::Histogram2Dc::gsl_histogram2d_fwrite;
*gsl_histogram2d_fread = *Math::GSL::Histogram2Dc::gsl_histogram2d_fread;
*gsl_histogram2d_fprintf = *Math::GSL::Histogram2Dc::gsl_histogram2d_fprintf;
*gsl_histogram2d_fscanf = *Math::GSL::Histogram2Dc::gsl_histogram2d_fscanf;
*gsl_histogram2d_pdf_alloc = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_alloc;
*gsl_histogram2d_pdf_init = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_init;
*gsl_histogram2d_pdf_free = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_free;
*gsl_histogram2d_pdf_sample = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_sample;

############# Class : Math::GSL::Histogram2D::gsl_histogram2d ##############

package Math::GSL::Histogram2D::gsl_histogram2d;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Histogram2D );
%OWNER = ();
%ITERATORS = ();
*swig_nx_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_nx_get;
*swig_nx_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_nx_set;
*swig_ny_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_ny_get;
*swig_ny_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_ny_set;
*swig_xrange_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_xrange_get;
*swig_xrange_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_xrange_set;
*swig_yrange_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_yrange_get;
*swig_yrange_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_yrange_set;
*swig_bin_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_bin_get;
*swig_bin_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_bin_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Histogram2Dc::new_gsl_histogram2d(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Histogram2Dc::delete_gsl_histogram2d($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::Histogram2D::gsl_histogram2d_pdf ##############

package Math::GSL::Histogram2D::gsl_histogram2d_pdf;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Histogram2D );
%OWNER = ();
%ITERATORS = ();
*swig_nx_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_nx_get;
*swig_nx_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_nx_set;
*swig_ny_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_ny_get;
*swig_ny_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_ny_set;
*swig_xrange_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_xrange_get;
*swig_xrange_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_xrange_set;
*swig_yrange_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_yrange_get;
*swig_yrange_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_yrange_set;
*swig_sum_get = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_sum_get;
*swig_sum_set = *Math::GSL::Histogram2Dc::gsl_histogram2d_pdf_sum_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Histogram2Dc::new_gsl_histogram2d_pdf(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Histogram2Dc::delete_gsl_histogram2d_pdf($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::Histogram2D;

*GSL_MAJOR_VERSION = *Math::GSL::Histogram2Dc::GSL_MAJOR_VERSION;
*GSL_MINOR_VERSION = *Math::GSL::Histogram2Dc::GSL_MINOR_VERSION;
*GSL_POSZERO = *Math::GSL::Histogram2Dc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::Histogram2Dc::GSL_NEGZERO;

@EXPORT_OK = qw/
               gsl_histogram2d_alloc 
               gsl_histogram2d_calloc 
               gsl_histogram2d_calloc_uniform 
               gsl_histogram2d_free 
               gsl_histogram2d_increment 
               gsl_histogram2d_accumulate 
               gsl_histogram2d_find 
               gsl_histogram2d_get 
               gsl_histogram2d_get_xrange 
               gsl_histogram2d_get_yrange 
               gsl_histogram2d_xmax 
               gsl_histogram2d_xmin 
               gsl_histogram2d_nx 
               gsl_histogram2d_ymax 
               gsl_histogram2d_ymin 
               gsl_histogram2d_ny 
               gsl_histogram2d_reset 
               gsl_histogram2d_calloc_range 
               gsl_histogram2d_set_ranges_uniform 
               gsl_histogram2d_set_ranges 
               gsl_histogram2d_memcpy 
               gsl_histogram2d_clone 
               gsl_histogram2d_max_val 
               gsl_histogram2d_max_bin 
               gsl_histogram2d_min_val 
               gsl_histogram2d_min_bin 
               gsl_histogram2d_xmean 
               gsl_histogram2d_ymean 
               gsl_histogram2d_xsigma 
               gsl_histogram2d_ysigma 
               gsl_histogram2d_cov 
               gsl_histogram2d_sum 
               gsl_histogram2d_equal_bins_p 
               gsl_histogram2d_add 
               gsl_histogram2d_sub 
               gsl_histogram2d_mul 
               gsl_histogram2d_div 
               gsl_histogram2d_scale 
               gsl_histogram2d_shift 
               gsl_histogram2d_fwrite 
               gsl_histogram2d_fread 
               gsl_histogram2d_fprintf 
               gsl_histogram2d_fscanf 
               gsl_histogram2d_pdf_alloc 
               gsl_histogram2d_pdf_init 
               gsl_histogram2d_pdf_free 
               gsl_histogram2d_pdf_sample 
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

=head1 NAME

Math::GSL::Histogram2D - Create and manipulate histograms of data in 2 dimensions

=head1 SYNOPSIS

    use Math::GSL::Histogram2D qw/:all/;

    my $H = gsl_histogram2d_alloc(100, 100);
    gsl_histogram2d_set_ranges_uniform($H,0,101, 0, 101);
    gsl_histogram2d_increment($H, -50, -12);  # ignored
    gsl_histogram2d_increment($H, 70 );   
    gsl_histogram2d_increment($H, 85.2 );

    my $G = gsl_histogram2d_clone($H);
    my $value = gsl_histogram2d_get($G, 70, 33);
    my ($max,$min) = (gsl_histogram2d_min_val($H), gsl_histogram2d_max_val($H) );
    my $sum = gsl_histogram2d_sum($H);

=cut

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over 

=item C<gsl_histogram2d_alloc($nx, $ny)> - This function allocates memory for a two-dimensional histogram with $nx bins in the x direction and $ny bins in the y direction. The function returns a pointer to a newly created gsl_histogram2d struct. If insufficient memory is available a null pointer is returned and the error handler is invoked with an error code of $GSL_ENOMEM. The bins and ranges must be initialized with one of the functions below before the histogram is ready for use.

=item C<gsl_histogram2d_calloc >

=item C<gsl_histogram2d_calloc_uniform >

=item C<gsl_histogram2d_free($h)> - This function frees the 2D histogram h and all of the memory associated with it.

=item C<gsl_histogram2d_increment($h, $xmin, $xmax, $ymin, $ymax)> - This function sets the ranges of the existing histogram $h to cover the ranges $xmin to $xmax and $ymin to $ymax uniformly. The values of the histogram bins are reset to zero.

=item C<gsl_histogram2d_accumulate($h, $x, $y, $weight)> - This function is similar to gsl_histogram2d_increment but increases the value of the appropriate bin in the histogram $h by the floating-point number $weight.

=item C<gsl_histogram2d_find($h, $x, $y)> - This function finds indices i and j to the to the bin which covers the coordinates ($x,$y). The bin is located using a binary search. The search includes an optimization for histograms with uniform ranges, and will return the correct bin immediately in this case. If ($x,$y) is found then the function return GSL_SUCCESS, i and j in this order. If ($x,$y) lies outside the valid range of the histogram then the function returns $GSL_EDOM and the error handler is invoked.

=item C<gsl_histogram2d_get($h, $i, $j)> - This function returns the contents of the ($i,$j)-th bin of the histogram $h. If ($i,$j) lies outside the valid range of indices for the histogram then the error handler is called with an error code of $GSL_EDOM and the function returns 0.

=item C<gsl_histogram2d_get_xrange($h, $i)> - This functions finds the upper and lower range limits of the $i-th in the x direction of the histogram $h. The range limits are stored in returned after 0 or 1 in this order : xlower and xupper. The lower limits are inclusive (i.e. events with these coordinates are included in the bin) and the upper limits are exclusive (i.e. events with the value of the upper limit are not included and fall in the neighboring higher bin, if it exists). The functions returns 0 has first value to indicate success. If $i lies outside the valid range of indices for the histogram then the error handler is called with an error code of GSL_EDOM. 

=item C<gsl_histogram2d_get_yrange($h, $j)> - This functions finds the upper and lower range limits of the $j-th in the y direction of the histogram $h. The range limits are stored in returned after 0 or 1 in this order : ylower and yupper. The lower limits are inclusive (i.e. events with these coordinates are included in the bin) and the upper limits are exclusive (i.e. events with the value of the upper limit are not included and fall in the neighboring higher bin, if it exists). The functions returns 0 has first value to indicate success. If $j lies outside the valid range of indices for the histogram then the error handler is called with an error code of GSL_EDOM. 

=item C<gsl_histogram2d_xmax($h)> - This functions returns the maximum upper range limit for the x direction of the histogram $h.

=item C<gsl_histogram2d_xmin($h)> - This functions returns the minimum lower range limit for the x direction of the histogram $h.

=item C<gsl_histogram2d_nx($h)> - This functions the number of bins for the x direction. 

=item C<gsl_histogram2d_ymax($h)> - This functions returns the maximum upper range limit for the y direction of the histogram $h.

=item C<gsl_histogram2d_ymin($h)> - This functions returns the minimum lower range limit for the y direction of the histogram $h.

=item C<gsl_histogram2d_ny($h)> - This functions the number of bins for the y direction.

=item C<gsl_histogram2d_reset($h)> - This function resets all the bins of the histogram $h to zero.

=item C<gsl_histogram2d_calloc_range >

=item C<gsl_histogram2d_set_ranges($h, $xrange, $xsize, $yrange, $ysize)> - This function sets the ranges of the existing histogram $h using the arrays $xrange and $yrange of size $xsize and $ysize respectively. The values of the histogram bins are reset to zero.

=item C<gsl_histogram2d_set_ranges_uniform($h, $xmin, $xmax, $ymin, $ymax)> - This function sets the ranges of the existing histogram $h to cover the ranges $xmin to $xmax and $ymin to $ymax uniformly. The values of the histogram bins are reset to zero.

=item C<gsl_histogram2d_memcpy($dest, $src)> - This function copies the histogram $src into the pre-existing histogram $dest, making $dest into an exact copy of $src. The two histograms must be of the same size.

=item C<gsl_histogram2d_clone($src)> - This function returns a pointer to a newly created histogram which is an exact copy of the histogram $src.

=item C<gsl_histogram2d_max_val($h)> - This function returns the maximum value contained in the histogram bins.

=item C<gsl_histogram2d_max_bin($h)> - This function finds the indices of the bin containing the maximum value in the histogram $h and returns the result in this order : 0 if the operation succeded, 1 otherwise, i and j. In the case where several bins contain the same maximum value the first bin found is returned. 

=item C<gsl_histogram2d_min_val($h)> - This function returns the minimum value contained in the histogram bins.

=item C<gsl_histogram2d_min_bin($h)> - This function finds the indices of the bin containing the minimum value in the histogram $h and returns the result in this order : 0 if the operation succeded, 1 otherwise, i and j. In the case where several bins contain the same minimum value the first bin found is returned. 

=item C<gsl_histogram2d_xmean($h)> - This function returns the mean of the histogrammed x variable, where the histogram is regarded as a probability distribution. Negative bin values are ignored for the purposes of this calculation.

=item C<gsl_histogram2d_ymean($h)> - This function returns the mean of the histogrammed y variable, where the histogram is regarded as a probability distribution. Negative bin values are ignored for the purposes of this calculation.

=item C<gsl_histogram2d_xsigma($h)> - This function returns the standard deviation of the histogrammed x variable, where the histogram is regarded as a probability distribution. Negative bin values are ignored for the purposes of this calculation.

=item C<gsl_histogram2d_ysigma($h)> - This function returns the standard deviation of the histogrammed y variable, where the histogram is regarded as a probability distribution. Negative bin values are ignored for the purposes of this calculation.

=item C<gsl_histogram2d_cov($h)> - This function returns the covariance of the histogrammed x and y variables, where the histogram is regarded as a probability distribution. Negative bin values are ignored for the purposes of this calculation.

=item C<gsl_histogram2d_sum($h)> - This function returns the sum of all bin values. Negative bin values are included in the sum.

=item C<gsl_histogram2d_equal_bins_p($h1, $h2)> - This function returns 1 if all the individual bin ranges of the two histograms are identical, and 0 otherwise.

=item C<gsl_histogram2d_add($h1, $h2)> - This function adds the contents of the bins in histogram $h2 to the corresponding bins of histogram $h1, i.e. h'_1(i,j) = h_1(i,j) + h_2(i,j). The two histograms must have identical bin ranges.

=item C<gsl_histogram2d_sub($h1, $h2)> - This function subtracts the contents of the bins in histogram $h2 from the corresponding bins of histogram $h1, i.e. h'_1(i,j) = h_1(i,j) - h_2(i,j). The two histograms must have identical bin ranges.

=item C<gsl_histogram2d_mul($h1, $h2)> - This function multiplies the contents of the bins of histogram $h1 by the contents of the corresponding bins in histogram $h2, i.e. h'_1(i,j) = h_1(i,j) * h_2(i,j). The two histograms must have identical bin ranges.

=item C<gsl_histogram2d_div($h1, $h2)> - This function divides the contents of the bins of histogram $h1 by the contents of the corresponding bins in histogram $h2, i.e. h'_1(i,j) = h_1(i,j) / h_2(i,j). The two histograms must have identical bin ranges.

=item C<gsl_histogram2d_scale($h, $scale)> - This function multiplies the contents of the bins of histogram $h by the constant scale, i.e. h'_1(i,j) = h_1(i,j) $scale. 

=item C<gsl_histogram2d_shift($h, $offset)> - This function shifts the contents of the bins of histogram $h by the constant offset, i.e. h'_1(i,j) = h_1(i,j) + $offset. 

=item C<gsl_histogram2d_fwrite($stream $h)> - This function writes the ranges and bins of the histogram $h to the stream $stream (opened with the gsl_fopen function from the Math::GSL module) in binary format. The return value is 0 for success and $GSL_EFAILED if there was a problem writing to the file. Since the data is written in the native binary format it may not be portable between different architectures.

=item C<gsl_histogram2d_fread($stream $h)> - This function reads into the histogram $h from the stream $stream (opened with the gsl_fopen function from the Math::GSL module) in binary format. The histogram $h must be preallocated with the correct size since the function uses the number of x and y bins in $h to determine how many bytes to read. The return value is 0 for success and $GSL_EFAILED if there was a problem reading from the file. The data is assumed to have been written in the native binary format on the same architecture.

=item C<gsl_histogram2d_fprintf($stream, $h, $range_format, $bin_format)> - This function writes the ranges and bins of the histogram $h line-by-line to the stream $stream (opened with the gsl_fopen function from the Math::GSL module) using the format specifiers $range_format and $bin_format. These should be one of the %g, %e or %f formats for floating point numbers. The function returns 0 for success and $GSL_EFAILED if there was a problem writing to the file. The histogram output is formatted in five columns, and the columns are separated by spaces, like this,

=over

=item xrange[0] xrange[1] yrange[0] yrange[1] bin(0,0)

=item xrange[0] xrange[1] yrange[1] yrange[2] bin(0,1)

=item xrange[0] xrange[1] yrange[2] yrange[3] bin(0,2)

=item ....

=item xrange[0] xrange[1] yrange[ny-1] yrange[ny] bin(0,ny-1)

=item           

=item xrange[1] xrange[2] yrange[0] yrange[1] bin(1,0)

=item xrange[1] xrange[2] yrange[1] yrange[2] bin(1,1)

=item xrange[1] xrange[2] yrange[1] yrange[2] bin(1,2)

=item ....

=item xrange[1] xrange[2] yrange[ny-1] yrange[ny] bin(1,ny-1)

=item          

=item ....

=item              

=item xrange[nx-1] xrange[nx] yrange[0] yrange[1] bin(nx-1,0)

=item xrange[nx-1] xrange[nx] yrange[1] yrange[2] bin(nx-1,1)

=item xrange[nx-1] xrange[nx] yrange[1] yrange[2] bin(nx-1,2)

=item ....

=item xrange[nx-1] xrange[nx] yrange[ny-1] yrange[ny] bin(nx-1,ny-1)

=back         

Each line contains the lower and upper limits of the bin and the contents of the bin. Since the upper limits of the each bin are the lower limits of the neighboring bins there is duplication of these values but this allows the histogram to be manipulated with line-oriented tools. 

=item C<gsl_histogram2d_fscanf($stream, $h)> - This function reads formatted data from the stream $stream (opened with the gsl_fopen function from the Math::GSL module) into the histogram $h. The data is assumed to be in the five-column format used by gsl_histogram2d_fprintf. The histogram $h must be preallocated with the correct lengths since the function uses the sizes of $h to determine how many numbers to read. The function returns 0 for success and $GSL_EFAILED if there was a problem reading from the file.

=item C<gsl_histogram2d_pdf_alloc($nx, $ny)> - This function allocates memory for a two-dimensional probability distribution of size $nx-by-$ny and returns a pointer to a newly initialized gsl_histogram2d_pdf struct. If insufficient memory is available a null pointer is returned and the error handler is invoked with an error code of $GSL_ENOMEM.

=item C<gsl_histogram2d_pdf_init($p, $h)> - This function initializes the two-dimensional probability distribution calculated $p from the histogram $h. If any of the bins of $h are negative then the error handler is invoked with an error code of GSL_EDOM because a probability distribution cannot contain negative values.

=item C<gsl_histogram2d_pdf_free($p)> - This function frees the two-dimensional probability distribution function $p and all of the memory associated with it.

=item C<gsl_histogram2d_pdf_sample($p, $r1, $r2)> - This function uses two uniform random numbers between zero and one, $r1 and $r2, to compute a single random sample from the two-dimensional probability distribution p. The function returns 0 if the operation succeeded, 1 otherwise followed by the x and y values of the sample.

=back

=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2009 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1;
