use v6.d;
use Test;
use FindBin::libs;

use ProcStats :Extract;

my %pass0  = extract-stats;
my %diff0  = diff-stats %pass0;

say 'Pass0: ', %pass0.perl;
say 'Diff0: ', %diff0.perl;

ok %pass0, "First stats is populated.";
ok %diff0, "First diff  is populated.";

constant ALL = ( |ProcStats::COMPARE, |ProcStats::HEADER );

for ALL  -> $key
{
    ok %pass0{ $key } :exists, "Exist: \%pass0 '$key' (%pass0{$key})";
}

for ALL  -> $key
{
    ok %diff0{ $key } :exists   , "Exist: \%diff0 '$key' (%pass0{$key})";
    ok %diff0{ $key } == 0      , "Zero:  \%diff0 '$key'";
}

# cause some difference in maxrss...

do { my @a = ( 1 .. 1_000_000 ) };

my %pass1   = extract-stats;

my %diff1 = diff-stats %pass1;

for 1 .. 1_000 -> $i
{
    my @a   = ( 1 .. $i ); 
}

# wallclock and user are guaranteed to be different

diag 'Last: ' ~ %pass1.perl;
diag 'Diff: ' ~ %diff1.perl;

for ProcStats::HEADER -> $field 
{
    %pass0{ $field } != %pass1{ $field }
    ?? ok  %diff1{ $field } :exists, "Changed: '$field' in diff"
    !! nok %diff1{ $field } :exists, "Unchanged: '$field' not in diff"
}

done-testing;
