########################################################################
# housekeeping
########################################################################

use v6.d;

unit module FindBin::Dirs:ver<0.1.1>:auth<CPAN:lembark>;

use FindBin;

################################################################
# package variables
################################################################

my %filterz =
(
    all     => -> IO $path { True },
    dir     => -> IO $path { $path ~~ :d },
    file    => -> IO $path { $path ~~ :f },
    exist   => -> IO $path { $path ~~ :e },
);

################################################################
# exported (API)
################################################################

multi Dirs
(
    Stringy :$filter    = 'all',

    Str     :$append    = '',
    Bool    :$resolve   = False,
    Bool    :$verbose   = False,
    IO()    :$start     = Bin( :$resolve, :$verbose )
    --> Seq
)
{

    my $handler = %filterz{ $filter }
    or
    die "Unknown filter: '$filter'. Known: " ~ %filterz.keys.join;

    Dirs
        filter  => $handler,
        append  => $append,
        resolve => $resolve,
        verbose => $verbose,
        start   => $start
}

multi Dirs 
(
    Block   :$filter,

    Str     :$append    = '',
    Bool    :$resolve   = False,
    Bool    :$verbose   = False,
    IO()    :$start     = Bin( :$resolve, :$verbose )
    --> Seq
)
is export( :DEFAULT )
{
    my $path    
    = $resolve
    ?? $start.absolute.resolve.IO
    !! $start.absolute.IO
    ;

    $path   ~~ :d
    or 
    $path   = $path.parent;

    if $verbose
    {
        note '# Start:  ' ~ $start.gist;
        note "# Path:   '$path'";
        note "# Append: '$append'";
    }

    return gather loop
    {
        my $dir
        = $append
        ?? $path.add( $append )
        !! $path
        ;

        if $filter( $dir )
        {
            note "# Want: $dir"
            if $verbose;

            take $dir;
        }
        else
        {
            note "# Skip: $dir"
            if $verbose;
        }

        # $next & $path may contain a volume or 
        # path trim, parent compares all of it.

        my $next    = $path.parent;

        $next ~~ $path
        and last;
        
        $path   = $next;
    }
}

=finish
