########################################################################
# housekeeping
########################################################################

use v6.d;

unit module FindBin::Dirs:ver<0.1.0>:auth<CPAN:lembark>;

use FindBin;

################################################################
# exported (API)
################################################################

my $all := -> IO $path { True };

our sub Dirs 
(
    Str     :$subdir    = '',
    Bool    :$resolve   = False,
    Bool    :$verbose   = False,
    Block   :$wanted    = $all,
    IO()    :$start     = Bin( :$resolve, :$verbose )
    --> Seq
)
is export( :DEFAULT )
{
    my $path    = $start.absolute.IO;

    $path   ~~ :d
    or 
    $path   = $path.parent;

    if $verbose
    {
        note '# Start:  ' ~ $start.gist;
        note "# Path:   '$path'";
        note "# Subdir: '$subdir'";
    }

    return gather loop
    {
        my $dir
        = $subdir
        ?? $path.add( $subdir )
        !! $path
        ;

        if $wanted( $dir )
        {
            note "# Want: $dir"
            if $verbose;

            take $dir;
        }
        else
        {
            note "# Skip: $dir"
            if $verbose;
        }

        # $next & $path may contain a volume or 
        # path trim, parent compares all of it.

        my $next    = $path.parent;

        $next ~~ $path
        and last;
        
        $path   = $next;
    }
}

=finish
