use Test::More tests => 5;

use HTML::Strip;
use FindBin qw/$Bin/;

use Encode qw/encode is_utf8/;

my $filename = "$Bin/russian.html";
ok( open my $fh, $filename );
SKIP: {
    skip "Cannot open $filename", 4 unless $fh;

	binmode $fh, ':utf8';
    local $/;
	my $data = <$fh>;
	close $fh;

    my $expected_text = <DATA>;

	my $hs = HTML::Strip->new();
	ok( my $clean_text = $hs->parse( $data ) );

    ok( is_utf8($clean_text), "Text comes back as UTF-8" );
    $clean_text = encode( 'UTF-8', $clean_text ); 
	is( strip_spaces($clean_text), strip_spaces($expected_text) );
    TODO: {
        local $TODO = "emit_spaces after '»' is inconsistent on other arch/versions"; 
        is( $clean_text, $expected_text );
    }
}

sub strip_spaces {
    my $text = shift;
    my $stripped = $text =~ tr! !!dr;
    return $stripped;
}

__DATA__
 23 января 2009 года \r
 28 января 2009 года в Челябинске состоится семинар компании «Доктор Веб» — российского разработчика средств информационной безопасности под маркой Dr.Web. Мероприятие посетят партнеры компании, а также представители региональных масс-медиа. \r
 На сегодняшний день все большее количество пользователей в Челябинской области проявляют интерес к проблеме информационной безопасности. Несмотря на финансовый кризис, спрос на средства антивирусной и антиспам-защиты в регионе остается достаточно высоким. «Доктор Веб», высоко оценивая потребительский потенциал области, 28 января проведет в Челябинске партнерский семинар, который соберет многочисленных партнеров компании. \r
 В ходе семинара специалисты «Доктор Веб» подробно расскажут о ключевых функциях программных продуктов Dr.Web, их преимуществах в сравнении с конкурентами. Особое внимание будет уделено новинкам — Dr.Web Security Space и Антивирус Dr.Web для Windows 5.0. Помимо этого, будут обсуждены новые вирусные угрозы и технологии борьбы с ними. \r
 Также в рамках семинара состоится вручение сертификатов специалиста по продажам программного обеспечения Dr.Web. Для получения сертификата участник семинара должен дистанционно сдать экзамен до 26 января 2009 г. Для этого необходимо будет предварительно заполнить регистрационную анкету на сайте компании «Доктор Веб» , выбрав в ней соответствующий пункт («сдать on-line экзамен»). \r
 В подарок все участники семинара получат ключи, позволяющие в течение 2 месяцев бесплатно протестировать всю линейку продуктов Dr.Web. \r
 \r
 Адрес : \r
 Отель «Holiday Inn Chelyabinsk-Riverside», Университетская набережная, 18 \r
 Конференц-зал (2 этаж) \r
 Регистрация участников: 11:00 — 11:30 \r
 
