use v6;
use Traced;
use Tracee::Standard;
use Tracer;
#|[ A tracer for files following the standard format. ]
unit role Tracer::File[Tracee::Standard:_ $tracee] does Tracer;

#|[ A file handle. ]
has IO::Handle:D $.handle is required;

method new(::?ROLE:_: IO::Handle:D $handle --> ::?ROLE:D) {
    self.bless: :$handle
}

multi method render(::?ROLE:D: Traced:D $event is raw --> Bool:_) {
    PRE  $!handle.lock;
    POST $!handle.unlock;
    $!handle.print: $tracee.fill: $event, :nl($!handle.nl-out)
}
