#!/usr/bin/perl
# Last Update by /gn0/jong/Perl/update_subroutines.pl: Sat Dec  6 15:14:06 GMT 1997
#________________________________________________________________________________
# Title     : write_nhco_files.pl
# Usage     : write_nhco_files.pl Exxx.msp
# Function  :
# Example   :
# Keywords  : write_nomol_homol_column_files.pl
# Options   :
#  $exclude_these_pairs= by x=
#  $show_fractional_success= by f=   # for example f=6964  to show the fraction out of 6964
# Author    :
# Version   : 1.2
#--------------------------------------------------------------------------------

my @files=@{&parse_arguments(1)};
my (%hash, @keys, $sum_eval, $sorted_name);

if($exclude_these_pairs){
        print "\n#  \$exclude_these_pairs is set \n";
        @file_out=@{&write_nhco_files(@files, "x=$exclude_these_pairs")};
}else{
        @file_out=@{&write_nhco_files(@files)};
}

for(@file_out){
     print "\n# \@file_out is $_";
}
print "\n\n\n";


#________________________________________________________________________________
# Title     : write_nhco_files
# Usage     :
# Function  : writes nhco files with each class(4 of them) file nhco as well.
#              NHCO stands for Nomolog, Homolog Column Output file
# Example   :
#            Output example (from: ~/Proj/Bio/Search_meth_comp/Final x>more ISS_935.nhco)
#              1        130
#              2        418
#              3        451
#              4        461
#              5        506
#
# Keywords  : write homology column file, write_nomol_homol_column_files,
#             write_homol_col_files
# Options   :
#  $exclude_these_pairs= by x=
#  $ISS_2nd_Eval_factor= by E=
#  $show_fractional_success= by f=   # for example f=6964  to show the fraction out of 6964
#
# Author    : jong@salt2.med.harvard.edu, NHCO stands for Nomolog, Homolog Column Output file
# Category  :
# Version   : 2.3
#--------------------------------------------------------------------------------
sub write_nhco_files{
    #"""""""""""""""""< handle_arguments{ head Ver 4.1 >"""""""""""""""""""""""
    my(@A)=&handle_arguments(@_);my($num_opt)=${$A[7]};my($char_opt)=${$A[8]};
    my(@hash)=@{$A[0]};my(@file)=@{$A[4]};my(@dir)=@{$A[3]};my(@array)=@{$A[1]};
    my(@string)=@{$A[2]};my(@num_opt)=@{$A[5]};my(@char_opt)=@{$A[6]};
    my(@raw_string)=@{$A[9]};my(%vars)=%{$A[10]};my(@range)=@{$A[11]};
    my($i,$j,$c,$d,$e,$f,$g,$h,$k,$l,$m,$n,$o,$p,$q,$r,$s,$t,$u,$v,$w,$x,$y,$z);
    if($debug==1){print "\n\t\@hash=\"@hash\"
    \@raw_string=\"@raw_string\"\n\t\@array=\"@array\"\n\t\@num_opt=\"@num_opt\"
    \@char_opt=\"@char_opt\"\n\t\@file=\"@file\"\n\t\@string=\"@string\"\n" }
    #---------------------------------------------------------------------------
    my($out_nhco_file_name, @final_nhco_files, $answer_char, $target_direc, $query_class, $match_class, $homolog_a, $homolog_b, $homolog_a_b,
       $out_linked_pairs_file, %linkage_hash, %all_linked_pair_hash, $homolog_a_p_b, %all_pair_hash, $exclude_these_pairs,  $exclude_these_pairs, %pairs_excluded); ## $exclude_these_pairs contains filename

    if($vars{'E'}=~/\d+/){    $ISS_2nd_Eval_factor=$vars{'E'};
    }elsif(-s $vars{'x'}){    $exclude_these_pairs=$vars{'x'};
    }elsif($vars{'f'} > 2){   $show_fractional_success=$vars{'f'}; ## fraction denominator is a big number usually (6964 for pdb40d_1.38)
    }elsif($char_opt=~/d/){   $pdbd_seq_only='d';
    }elsif($char_opt=~/571/){ $sam_571_seq_only=571;    }

    $pair_info_file=$exclude_these_pairs;
    open(PAIR_INFO, $pair_info_file);
    while(<PAIR_INFO>){   if(/^(\S+ +\S+)/){ $pairs_excluded{$1}=$1;   }   }
    close(PAIR_INFO);

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    print "\n# (1) gettting correcting_pairs from  \&get_scop_correcting_pairs, \%fix_hash made!\n";
    #___________________________________
    %correcting_pairs=%{&get_scop_correcting_pairs()};

    if(@file < 1){ print "\n\n\n# \@file is empty, something is wrong, Do your input files in PWD?\n\n\n\n"; exit }

    @file=@{&check_input_file_extension('parf,mprf', \@file)};

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    print "\n# (4) processing \"@file\" \n";
    #_______________________________________
    for($i=0; $i< @file; $i++){
        my($File, $seq1, $seq2, $sorted, $base, $homolog_counter, $nomolog); $File=$file[$i];
        $base=${&get_base_names($File)};
        if($base=~/(\S+[^_]+)_+$/){ $base=$1; }
        $out_nhco_file_name      ="$base\.nhco";
        $out_nhco_file_name_a    ="$base\_a\.nhco";
        $out_nhco_file_name_b    ="$base\_b\.nhco";
        $out_nhco_file_name_a_b  ="$base\_a_b\.nhco";
        $out_nhco_file_name_a_p_b="$base\_a_p_b\.nhco";
        $out_nhco_linked_file_name      ="$base\_linked\.nhco";  ### These are for Single linkage counting result
        $out_nhco_linked_file_name_a    ="$base\_linked\_a\.nhco";
        $out_nhco_linked_file_name_b    ="$base\_linked\_b\.nhco";
        $out_nhco_linked_file_name_a_b  ="$base\_linked\_a_b\.nhco";
        $out_nhco_linked_file_name_a_p_b="$base\_linked\_a_p_b\.nhco";
        $out_linked_pairs_file=">$base\_linked\.pair";
        $out_linked_pairs_file_a=">$base\_linked_a\.pair";
        $out_linked_pairs_file_b=">$base\_linked_b\.pair";
        $out_linked_pairs_file_a_b=">$base\_linked_a_b\.pair";
        $out_linked_pairs_file_a_p_b=">$base\_linked_a_p_b\.pair";

        open(F, $File) || die "Can not open $File \n";
        open(NHCO, ">$out_nhco_file_name");               open(NHCO_LINKED, ">$out_nhco_linked_file_name");
        open(NHCO_a, ">$out_nhco_file_name_a");   open(NHCO_LINKED_a, ">$out_nhco_linked_file_name_a");
        open(NHCO_b, ">$out_nhco_file_name_b");     open(NHCO_LINKED_b, ">$out_nhco_linked_file_name_b");
        open(NHCO_a_b, ">$out_nhco_file_name_a_b");   open(NHCO_LINKED_a_b, ">$out_nhco_linked_file_name_a_b");
        open(NHCO_a_p_b, ">$out_nhco_file_name_a_p_b");   open(NHCO_LINKED_a_p_b, ">$out_nhco_linked_file_name_a_p_b");
        open(NHCO_LINKED_PAIRS, ">$out_linked_pairs_file") || die "$0 can not open $out_linked_pairs_file\n\n";
        open(NHCO_LINKED_PAIRS_a, ">$out_linked_pairs_file_a") || die "$0 can not open $out_linked_pairs_file_a\n\n";
        open(NHCO_LINKED_PAIRS_b, ">$out_linked_pairs_file_b") || die "$0 can not open $out_linked_pairs_file_b\n\n";
        open(NHCO_LINKED_PAIRS_a_b, ">$out_linked_pairs_file_a_b") || die "$0 can not open $out_linked_pairs_file_a_b\n\n";
        open(NHCO_LINKED_PAIRS_a_p_b, ">$out_linked_pairs_file_a_p_b") || die "$0 can not open $out_linked_pairs_file_a_p_b\n\n";

        while(<F>){
           if(/^ *#/ or /[\t ]+Un/ or /^ *#/ or /[\t ]+[FV]omolog/i){ next; # ignoring Unmologk=Vomolog, Fomolog

           #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~``
           # (5) This is when there is NO HOMOLogy information is written in the line as in RAW data file from Kevin Karplus
           #____________________________________________________________________________________________________________
           }elsif(/^ *(\S+)[\t ]+(\S+)[\t ]+(\S+)[\t ]+((\d+)\.\d+\.\d+)\.*\d*\.*\d*[\t ]*((\d+)\.\d+\.\d+)\.*\d*\.*\d*/){
               $seq1=$1; $seq2=$2;  $single_linkage_made_with_linkage_hash=0; ## this should be reset
               if($seq1=~/(\S+)_\d+\.\d+\.\d+/){ $seq1=$1; }
               if($seq2=~/(\S+)_\d+\.\d+\.\d+/){ $seq2=$1;                 }
               $sorted = join(' ', sort($seq1, $seq2));

               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
               # This is to prevent repetitive counting.
               #_______________________________________________________________
               if( $all_pair_hash{$sorted} ){  print "\n# Already $sorted\n"; next
               }else{                       $all_pair_hash{$sorted}=$sorted;                     }

               if($5 == 8 or $7 == 8 or $5 == 9 or $7 == 9){  next; ## ignore class 8 and 9
               }else{     $query_class=$5;  $match_class=$7;  $match_superfam=$4; $query_superfam=$6;               }

               if($match_class eq $query_class){      $homolog_counter++;  goto HOMOLOGY_CASE;
               }elsif($match_class ne $query_class){  $nomolog++;  goto NOMOLOGY_CASE;
               }else{  print "\n# write_nhco_files: Something is wrong, dying, \n"; exit;    }
           }
           #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~```
           # (6) Dealing with proper PARF file (Paired Ranking File), HOMOLOGY case
           #___________________________________________________________
           elsif(/^ *(\S+)[\t ]+(\S+)[\t ]+Homolog[\t ]+(\S+)[\t ]+(\d+)\.\d+\.\d+[\.\d+\.\d+]*[\t ]*(\d+)\.\d+\.\d+[\.\d+\.\d+]*/){
               $seq1=$1; $seq2=$2; $query_class=$4; $match_class=$5;
               $sorted=join(' ', sort($seq1, $seq2)); $single_linkage_made_with_linkage_hash=0; ## this should be reset
               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
               # This is to prevent repetitive counting.
               #_______________________________________________________________
               if( $all_pair_hash{$sorted} ){ print "\n# Already $sorted\n"; next  }else{  $all_pair_hash{$sorted}=$sorted; }

               HOMOLOGY_CASE: $homolog_counter++; #==================================================<<<<<<<<<
               if($exclude_these_pairs and $pairs_excluded{$sorted} ){    $homolog_exclude++;
                   if(    $query_class == 1){   $homolog_a_exclude++;
                   }elsif($query_class == 2){   $homolog_b_exclude++;
                   }elsif($query_class == 3){   $homolog_a_b_exclude++;
                   }elsif($query_class == 4){   $homolog_a_p_b_exclude++;  }
               }
               if(    $query_class == 1){   $homolog_a++;
               }elsif($query_class == 2){   $homolog_b++;
               }elsif($query_class == 3){   $homolog_a_b++;
               }elsif($query_class == 4){   $homolog_a_p_b++;
               }
               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
               # Single LINKage clustering counting. Checks if there were previous entries
               #___________________________________________________________________________________
               for $j (@hash_index_array){
                   if( $linkage_hash{$j}{$seq1}=~/\S/ or $linkage_hash{$j}{$seq2}=~/\S/ ){
                        #print "\n $j : $linkage_hash{$j}{$seq1} ";
                        $linkage_hash{$j}{$seq1}=$seq1;
                        $linkage_hash{$j}{$seq2}=$seq2;
                        $linkage_hash_a{$j}{$seq1}=$seq1 if $query_class==1;
                        $linkage_hash_a{$j}{$seq2}=$seq2 if $query_class==1;;
                        $linkage_hash_b{$j}{$seq1}=$seq1 if $query_class==2;;
                        $linkage_hash_b{$j}{$seq2}=$seq2 if $query_class==2;;
                        $linkage_hash_a_b{$j}{$seq1}=$seq1 if $query_class==3;;
                        $linkage_hash_a_b{$j}{$seq2}=$seq2 if $query_class==3;;
                        $linkage_hash_a_p_b{$j}{$seq1}=$seq1 if $query_class==4;;
                        $linkage_hash_a_p_b{$j}{$seq2}=$seq2 if $query_class==4;;
                        $single_linkage_made_with_linkage_hash=1;    last;
                   }
               }
               unless($single_linkage_made_with_linkage_hash){
                   $linkage_hash{$homolog_counter}{$seq1}=$seq1;
                   $linkage_hash{$homolog_counter}{$seq2}=$seq2;
                   $linkage_hash_a{$homolog_counter}{$seq1}=$seq1 if $query_class==1;
                   $linkage_hash_a{$homolog_counter}{$seq2}=$seq2 if $query_class==1;
                   $linkage_hash_b{$homolog_counter}{$seq1}=$seq1 if $query_class==2;
                   $linkage_hash_b{$homolog_counter}{$seq2}=$seq2 if $query_class==2;
                   $linkage_hash_a_b{$homolog_counter}{$seq1}=$seq1 if $query_class==3;
                   $linkage_hash_a_b{$homolog_counter}{$seq2}=$seq2 if $query_class==3;
                   $linkage_hash_a_p_b{$homolog_counter}{$seq1}=$seq1 if $query_class==4;
                   $linkage_hash_a_p_b{$homolog_counter}{$seq2}=$seq2 if $query_class==4;
                   push(@hash_index_array, $homolog_counter);
               }
           }
           #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           # (7) Dealing with proper PARF file (Paired Ranking File), NOMOLOG and Fomolog (fold level homology only)
           #___________________________________________________________________________________________________________
           elsif(/^ *(\S+)[\t ]+(\S+)[\t ]+Nomolog[\t ]+(\S+)[\t ]+(\d+)\.\d+\.\d+[\.\d+\.\d+]*[\t ]+(\d+)\.\d+\.\d+[\.\d+\.\d+]*/){
               $seq1=$1; $seq2=$2;
               if($seq1=~/(\S+)_\d+\.\d+\.\d+/){ $seq1=$1; } # remving attached classification info
               if($seq2=~/(\S+)_\d+\.\d+\.\d+/){ $seq2=$1; }
               $sorted=join(' ', sort($seq1, $seq2));
               #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
               # This is to prevent repetitive counting.
               #_______________________________________________________________
               if( $all_pair_hash{$sorted} ){ print "\n# Already $sorted\n"; next
               }else{          $all_pair_hash{$sorted}=$sorted;            }

               NOMOLOGY_CASE:  #==================================================<<<<<<<<<
               if($4 >= 8 or $5 >= 8){ next; }else{  $query_class=$4; $match_class=$5;   }
               $possible_combination=0; ## To have correct all possible pairs count
               $possible_combination_a=$possible_combination_b=$possible_combination_a_b=$possible_combination_a_p_b=0;

               if($correcting_pairs{$sorted}){  $homolog_counter++;
                   if($exclude_these_pairs and $pairs_excluded{$sorted} ){
                       $homolog_exclude++;
                       if(    $query_class == 1){   $homolog_a_exclude++;
                       }elsif($query_class == 2){   $homolog_b_exclude++;
                       }elsif($query_class == 3){   $homolog_a_b_exclude++;
                       }elsif($query_class == 4){   $homolog_a_p_b_exclude++;
                       }
                   }
                   if(    $query_class == 1){    $homolog_a++;
                   }elsif($query_class == 2){    $homolog_b++;
                   }elsif($query_class == 3){    $homolog_a_b++;
                   }elsif($query_class == 4){    $homolog_a_p_b++;
                   }
               }else{  $nomolog++;
                   if($exclude_these_pairs and $pairs_excluded{$sorted} ){     $nomolog_exclude++;
                       if(    $query_class == 1){   $nomolog_a_exclude++;
                       }elsif($query_class == 2){   $nomolog_b_exclude++;
                       }elsif($query_class == 3){   $nomolog_a_b_exclude++;
                       }elsif($query_class == 4){   $nomolog_a_p_b_exclude++;
                       }
                   }
                   $homolog_after_exclude     = $homolog_counter - $homolog_exclude;
                   $homolog_after_exclude_a   = $homolog_a-$homolog_a_exclude;
                   $homolog_after_exclude_b   = $homolog_b-$homolog_b_exclude;
                   $homolog_after_exclude_a_b = $homolog_a_b - $homolog_a_b_exclude;
                   $homolog_after_exclude_a_p_b= $homolog_a_p_b - $homolog_a_p_b_exclude;

                   #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                   # Writing all the outputs!
                   #_____________________________________________________
                   for($v=1; $v <=5; $v++){
                       $possible_combination=0;
                       if($v==1){    %temp=%linkage_hash;       $NHCO='NHCO';       $NHCO_LINKED='NHCO_LINKED';     $NHCO_LINKED_PAIRS= 'NHCO_LINKED_PAIRS'; }
                       elsif($v==2){ %temp=%linkage_hash_a;     $NHCO='NHCO_a';     $NHCO_LINKED='NHCO_LINKED_a';   $NHCO_LINKED_PAIRS= 'NHCO_LINKED_PAIRS_a';}
                       elsif($v==3){ %temp=%linkage_hash_b;     $NHCO='NHCO_b';     $NHCO_LINKED='NHCO_LINKED_b';   $NHCO_LINKED_PAIRS= 'NHCO_LINKED_PAIRS_b';}
                       elsif($v==4){ %temp=%linkage_hash_a_b;   $NHCO='NHCO_a_b';   $NHCO_LINKED='NHCO_LINKED_a_b'; $NHCO_LINKED_PAIRS= 'NHCO_LINKED_PAIRS_a_b';}
                       elsif($v==5){ %temp=%linkage_hash_a_p_b; $NHCO='NHCO_a_p_b'; $NHCO_LINKED='NHCO_LINKED_a_p_b'; $NHCO_LINKED_PAIRS= 'NHCO_LINKED_PAIRS_a_p_b';}
                       @linkage_keys= sort {$a <=> $b } keys %temp;
                       for($k=0; $k< @linkage_keys; $k++){
                           $superfamily_member_count       =@members      =keys %{$temp{$linkage_keys[$k]}};
                           $superfamily_member_pairs       =$superfamily_member_count  *($superfamily_member_count   -1)/2;
                           $possible_combination       += $superfamily_member_pairs;
                           %all_linked_pair_hash =%{&get_all_possible_pairs_from_array(\@members)};
                           @all_linked_pairs=keys %all_linked_pair_hash;
                           print $NHCO_LINKED_PAIRS   "\n>$linkage_keys[$k] $superfamily_member_pairs : @members : $homolog_counter << $possible_combination";
                           for($j=0 ; $j< @all_linked_pairs; $j++){
                              if($all_pair_hash{$all_linked_pairs[$j]}){  print $NHCO_LINKED_PAIRS "\n       *$all_linked_pairs[$j]";
                              }else{                                      print $NHCO_LINKED_PAIRS "\n        $all_linked_pairs[$j]";     }
                           }
                           print $NHCO_LINKED_PAIRS "\n";
                       }
                       #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                       # WRITING !!, at each NOMOLOGY detection
                       #_____________________________________________________________________
                       if($show_fractional_success){ $fractional_homolog=$homolog_counter/$show_fractional_success }else{ $fractional_homolog='' }
                       printf $NHCO_LINKED ("%-8s %-6s\n", $nomolog, $possible_combination);

                       if($nomolog ==5 or $nomolog==10 or $nomolog==44 or $nomolog==88 or $nomolog==433 ){
                            if($show_fractional_success){ $fractional_homolog=$homolog_counter/$show_fractional_success }else{ $fractional_homolog='' }
                            #printf ("%-8s %-6s %-6s %-6s %-6s\n", $nomolog,$homolog_counter, $homolog_after_exclude, $homolog_exclude);
                            #printf ("%-8s %-6s %-6s %-6s\n", $nomolog, $homolog_counter, $superfamily_member_pairs, $possible_combination);
                       }
                    }
                    # writing class only counts
                    printf NHCO ("%-8s %-6s %-6s %-6s %-6s\n", $nomolog, $fractional_homolog, $homolog_counter, $homolog_after_exclude, $homolog_exclude);
                    if(    $query_class == 1){   $nomolog_a++;
                        printf NHCO_a ("%-6s %-6s %-6s %-6s\n", $nomolog_a, $homolog_a, $homolog_after_exclude_a, $homolog_a_exclude);
                        printf NHCO_LINKED_a ("%-6s %-6s\n",    $nomolog_a, $possible_combination);
                    }elsif($query_class == 2){   $nomolog_b++;
                        printf NHCO_b ("%-8s %-6s %-6s %-6s\n", $nomolog_b,  $homolog_b, $homolog_after_exclude_b, $homolog_b_exclude);
                        printf NHCO_LINKED_b ("%-6s %-6s\n",    $nomolog_b, $possible_combination);
                    }elsif($query_class == 3){   $nomolog_a_b++;
                        printf NHCO_a_b ("%-8s %-6s %-6s %-6s\n", $nomolog_a_b, $homolog_a_b, $homolog_after_exclude_a_b, $homolog_a_b_exclude);
                        printf NHCO_LINKED_a_b ("%-6s %-6s\n",    $nomolog_a_b, $possible_combination);
                    }elsif($query_class == 4){    $nomolog_a_p_b++;
                        printf NHCO_a_p_b ("%-8s %-6s %-6s %-6s\n", $nomolog_a_p_b, $homolog_a_p_b, $homolog_after_exclude_a_p_b, $homolog_a_p_b_exclude);
                        printf NHCO_LINKED_a_p_b ("%-6s %-6s\n",    $nomolog_a_p_b,    $possible_combination);
                    }

               }
           }
       }
       #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       # Closing all the NHCO files here
       #______________________________________________________________
       close (NHCO); close (NHCO_a); close (NHCO_b);  close(NHCO_a_b);  close(NHCO_a_p_b);
       close (NHCO_LINKED); close(NHCO_LINKED_a); close(NHCO_LINKED_b); close(NHCO_LINKED_a_b); close(NHCO_LINKED_a_p_b);

       if(-s $out_nhco_file_name){
           push(@final_nhco_files, $out_nhco_file_name, $out_nhco_file_name_a, $out_nhco_file_name_b, $out_nhco_file_name_a_b,
                $out_nhco_file_name_a_p_b );
           if(-d $ENV{'haussler'} ){  $target_direc=$ENV{'haussler'};
                print "\n# $target_direc is found !!, You must be JONG Park, or Are you Sarah??\n";
                print "\n# write_nhco_files : As you have haussler dir, I copy $out_nhco_file_name and others to it\n\n";
                for(@final_nhco_files){   system("cp $_ $target_direc");    }
           }
       }else{   print "\n\n\n\n# write_nhco_files: \$out_nhco_file_name is not big, ERROR???\n\n\n\n";    }
    }
    return(\@final_nhco_files);
}


#________________________________________________________________________
# Title     : assign_options_to_variables
# Usage     : &assign_options_to_variables(\$input_line);
# Function  : Assigns the values set in head box to the variables used in
#             the programs according to the values given at prompt.
#             This produces global values.
#             When numbers are given at prompt, they go to @num_opt
#              global variable. %vars global option will be made
#
# Example   : When you want to set 'a' char to a variable called '$dummy' in
#             the program, you put a head box commented line
#             '#  $dummy    becomes  a  by  -a '
#             Then, the parse_arguments and this sub routine will read the head
#             box and assigns 'a' to $dummy IF you put an argument of '-a' in
#             the prompt.
# Warning   : This is a global vars generator!!!
# Keywords  :
# Options   : '#' at prompt will make a var  $debug set to 1. This is to
#              print out all the print lines to make debugging easier.
# Returns   : Some globaly used variables according to prompt options.
#             @num_opt,
#
# Argument  : None.
# Version   : 2.6
#--------------------------------------------------------------------
sub assign_options_to_variables{
	my($i, %vars, $j, $op, $z, $n, $symb, $value, $var, %val, @val, $ARG_REG,
	 $option_table_example, @input_options, $first_border_and_title, $sym, @arg);

	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#      Defining small variables for option table reading
	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	my($g)='gets';                my($if)='if';
	my($is)='is';                 my(@input_files);
	my($o)='or';   my(@arguments) = sort @ARGV;

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#  Assigning global arguments(@num_opt, %vars) variables
	#_______________________________________________________________
	for($i=0; $i< @arguments; $i++){
	 if(($arguments[$i]=~/^(\-?\d+[\.\d+]?)$/)&&   ### it mustn't be a file
		( !(-f $arguments[$i]) ) ){                ### getting NUM opt
		push(@num_opt, $1);
	 }elsif( $arguments[$i]=~/^(\S+)=(\S+)$/){
		$vars{$1}=$2;
	 }
	}

	#""""""""""""""""""""""""""""""""""""""""""""""""""
	#   Some DEFAULT $debug variables for debugging purposes
	#""""""""""""""""""""""""""""""""""""""""""""""""""
	&set_debug_option;

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#   The main processing of self
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	open(SELF, "$0");    ## opens the program you ran to get the options table.
	while(<SELF>){

	  if( $first_border_and_title > 6 ){  ## This is to make it read only the first headbox.
		  last;                            #  $first_border_and_title is an incremental counter.
	  }elsif( /^ *#[_\*\-]{15,}$/ and /^ *# *[Tt][itle]*[ :]*/ ){
		  $first_border_and_title++;
		  print __LINE__, "# assign_options_to_variables : Title line found\n" if $debug eq 1;
	  }elsif(/^ {0,5}# {1,50}[\$\%\@].+$/){
		  $op = $&;  ## $op is for the whole input option line which has $xxxx, @xxx, %xxxx format
		  $op =~ s/^( *\# *)(\W\w+.+)$/$2/;  ## This is removing '#  ' in the line.
		  $op =~ s/^(\W\w+.+)(\s+\#.*)$/$1/;  ## This is removing any comments in the line.
			 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
			 ## matching the following line input format.
			 ## $av_sc_segment     becomes    a  by  a  # To smooth the SC rates. Gets the averages of
			 ## $ARG_REG is for arguments regular expression variable.
			 ##  This reg. exp. matches = 'a or A or E or e' part
			 ##  which represents alternative prompt arguments possibilities. \=$b$g$is$e$set
			 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
			 $ARG_REG ='(\S*) *[or=\,]* *(\S*) *[=or\,]* *(\S*) *[=or\,]* *(\S*) *[=or\,]* *(\S*)';
			 if($op=~/^([\$\@\%])([\w\-]+) {0,20}[=|$g|$is] *[\$\@\%]*([\- \w\.\d]+) *[bB]y +$ARG_REG/){
							 ## $sym     $var        becomes          a [$a...]       by       a -a -A
				  my $sym = $1;  #### The symbols like ($, @, %), '$' in the above.
				  my $var = $2;  #### Actual variable name 'var' from $var, 'av_sc_segment' in the above.
				  my $val = $3;  #### The becoming value  first 'a' in the above.
				  my @arg = ($4, $5, $6, $7, $8);  ## The alternative prompt arguments, second 'a' in the above..
			      print "\n $sym $var $val \n" if $debug==1;
			      print "\n \@arg are @arg \n" if $debug==1;

				  #""""""""""""""""""""""""""""""""""""""""""""""""""""
				  #  Going through the PROMPT args.
				  #""""""""""""""""""""""""""""""""""""""""""""""""""""
				  for($z=0; $z < @arguments; $z++){     ## $arguments[$z]  is from @ARGV
					  if($arguments[$z]=~/^\-\w+$/){
						  $arguments[$z] =~ s/\-//;
					  }
					  for ($i=0; $i < @arg; $i ++ ){
						 if( ("$arg[$i]" eq "$arguments[$z]" )&& ($arg[$i] !~ /\=/)
							 && ($sym eq '$') ){
							 ${"$var"}="$val";
							 if($debug == 1){
								 print __LINE__," \$${var} is set to \"$1\"\n";
							 }

						 }#'''''''''''''''' $arg = by s=  syntax ~~~~~~~~~~~~~~~~~~~~~~~~~~~
						 elsif( ( $arg[$i] =~ /^(\w+) *\=/ ) &&
							( $arguments[$z] =~ /^${1}= *([\w\.*\-*]+)$/) &&
							( $sym eq '$') ){
							  ${"$var"}="$1";
							  if($debug eq 1){ print __LINE__,"\$${var} is set to \"$1\"\n";  }
						 }
					  }
				  }
			  }
		}
	}
}
#________________________________________________________________________
# Title     : parse_arguments
# Usage     : &parse_arguments; or  (file1, file2)=@{&parse_arguments};
# Function  : Parse and assign any types of arguments on prompt in UNIX to
#             the various variables inside of the running program.
#             This is more visual than getopt and easier.
#             just change the option table_example below for your own variable
#             setttings. This program reads itself and parse the arguments
#             according to the setting you made in this subroutine or
#             option table in anywhere in the program.
#             It also imports the ENV variables to your program.
#
# Example   : &parse_arguments(1);
#             @files=@{&parse_arguments(1)};
# Warning   : HASH and ARRAY mustn't be like = (1, 2,3) or (1,2 ,3)
# Keywords  :
# Options   : '0'  to specify that there is no argument to sub, use
#              &parse_arguments(0);
#             parse_arguments itself does not have any specific option.
#             '#' at prompt will make a var  $debug set to 1. This is to
#              print out all the print lines to make debugging easier.
#
#             'e=xxxx' for filtering input files by extension xxxx
#
# Returns   : Filenames in a reference of array
#             and input files in an array (file1, file2)=@{&parse_arguments};
# Argument  : uses @ARGV
# Version   : 2.0
#--------------------------------------------------------------------
sub parse_arguments{
	my( $c, $d, $f, $arg_num, $option_table_seen, $n, $option_filtered,
		$option_table_example, $input_line, @input_files,
		$extension);

	&import_ENV_vars; # this enables  $PDB40D automatically assigns the shell var value of $ENV{'PDB40D'}

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#   Checks if there were arguments
	#_______________________________________________________
	if( @ARGV < 1 ){ #<-- If Argument is not given at prompt
	  for(@_){
		 if($_ eq '0'){ ## this means, parsearguments do not need any argus. So no need to parse anything
			 last;
		 }else{
			 print "\n \"$0\" requires at least one Argument, suiciding.\n\n";
			 print chr(7); #<-- This is beeping
			 print "  To get help type \"$0  h\"\n\n\n ";
			 exit;
		 }
	  }
	}
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#   Some DEFAULT $debug variables for debugging purposes
	#__________________________________________________________
	&set_debug_option;

	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#  If there is only one prompt arg. and is [-]*[hH][elp]*, it calls
	#   &default_help and exits
	#___________________________________________________________________
	if( ( @ARGV == 1 ) && ($ARGV[0] =~ /^[\-]*[hH\?][elp ]*$/) ){
		&default_help;
		exit;
	}

	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	#  Checking some input options like 'e=txt' for extension filtering
	#_____________________________________________________________________
	for($i=0; $i< @_; $i++){
			if($_[$i]=~/e=(\S+)/){
		  push(@extension, $1);
	  }elsif($_[$i]=~/^[\-]?r$/){ ## reversing file order in return stage
					$reverse_out_file_name_order='r';
			}
	}


	for($f=0; $f < @ARGV; $f++){
	 if( $ARGV[$f] =~ /\w+[\-\.\w]+$/ and -f $ARGV[$f] ){
		 #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		 # When extension is defined, filter files by it
		 #____________________________________________
		 if(@extension > 0){
		     for($e=0; $e < @extension; $e++){
				 $extension=$extension[$e];
				 if($ARGV[$f]=~/\S\.$extension/){
					 push(@input_files, $ARGV[$f] );
				 }else{ next }
			 }
		 }else{
			 push(@input_files, $ARGV[$f] );
			 next;
		 }
	 }
	}

	#""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	#     Reading the running program script
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""
	&assign_options_to_variables;
	if($HELP == 1){ &default_help }
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# reverse order if 'r' opt is set
	#_____________________________________________
	if($reverse_out_file_name_order){
			@input_files=reverse(@input_files);
	}
	return(\@input_files);
}
#________________________________________________________________________
# Title     : set_debug_option
# Usage     : &set_debug_option;
# Function  : If you put '#' or  '##' at the prompt of any program which uses
#             this sub you will get verbose printouts for the program if the program
#             has a lot of comments.
# Example   : set_debug_option #    <-- at prompt.
# Warning   :
# Keywords  :
# Options   : #   for 1st level of verbose printouts
#             ##  for even more verbose printouts
# $debug  becomes 1 by '#'  or '_'
# $debug2 becomes 1 by '##'  or '__'
#
# Returns   :  $debug
# Argument  :
# Version   : 1.8
#--------------------------------------------------------------------
sub set_debug_option{
	my($j, $i, $level);
	unless( defined($debug) ){
	 for($j=0; $j < @ARGV; $j ++){
		 if( $ARGV[$j] =~/^(_+)$|^(#+)$/){ # in bash, '#' is a special var, so use '_'
			 print __LINE__," >>>>>>> Debug option is set by $1 <<<<<<<<<\n";
			 $debug=1;
				  print chr(7);
			 print __LINE__," \$debug  is set to ", $debug, "\n";
			 splice(@ARGV,$j,1); $j-- ;
			 $level = length($1)+1;
			 for($i=0; $i < $level; $i++){
				 ${"debug$i"}=1;
				 print __LINE__," \$debug${i} is set to ", ${"debug$i"}, "\n";
			 }
		 }
	 }
	}
}

#________________________________________________________________________________
# Title     : get_scop_correcting_pairs
# Usage     : %correct=%{&get_scop_correcting_pairs()};
# Function  :
# Example   :
# Keywords  : get_pdb_correcting_pairs ,
# Options   :
# Category  :
# Version   : 1.3
#--------------------------------------------------------------------------------
sub get_scop_correcting_pairs{
		my (%correcting_pairs, @correcting_pairs);

		#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# %correcting_pairs is a correcting table for old pdb40d file classi
		#_____________________________________________________________________
		@correcting_pairs=(  # should be pairs
				'd2kauc1 d2kauc2', 'd1pkya1 d1pkya2',
				'd1pvda2 d1trka1', 'd1pbe_1 d1pbe_2',
				'd1poxa3 d1pvda2', 'd1efga1 d1efga2',
				'd1dsba1 d1dsba2', 'd2gsta1 d2gsta2',
				'd1bct__ d1brd__', 'd1qora1 d1qora2',
				'd2ohxa1 d2ohxa2', 'd1efga2 d1eft_1',
				'd1tada1 d1tada2', 'd1gsea1 d1gsea2',
				'd1gesa2 d2tmda3', 'd1lvl_2 d2tmda3',
				'd2tmda3 d2tpra2', 'd1tde_1 d2tmda3',
				'd1nhp_2 d2tmda3', 'd1gesa1 d2tmda3',
				'd1lvl_1 d2tmda3', 'd2tmda3 d2tpra1',
				'd1fcda1 d2tmda3', 'd1nhp_1 d2tmda3',
				'd1tde_2 d2tmda3', 'd1pbe_1 d2tmda3',
				'd1ebha1 d1ebha2', 'd1gesa2 d2dlda2', ## 3.4.1  with
				'd1gesa2 d1psda2', 'd1nhp_2 d2dlda2',
				'd1ldm_1 d1tde_2', 'd1coy_1 d1ldb_1',
				'd1lvl_2 d1psda2', 'd1psda2 d1tde_2',
				'd1hyha1 d1tde_2', 'd1fcda1 d1ldm_1',
				'd1hdca_ d1nhp_2', 'd1fcda1 d1hlpa1',
				'd1llda1 d1lvl_2', 'd2dlda2 d2tpra2',
				'd1ldm_1 d1nhp_2', 'd1llda1 d1pbe_1',
				'd1gdha2 d2tpra1', 'd1ldb_1 d1nhp_2',
				'd1gesa2 d1scua2', 'd1fcda1 d1hyha1',
				'd1gesa1 d1hlpa1', 'd1gdha2 d1gesa2',
				'd1lvl_2 d2dlda2', 'd1gesa1 d2dlda2',
				'd1nhp_2 d2ohxa2', 'd1tde_2 d2dlda2', # 3.4.1. with 3.18.1, 3.17.1.
				'd1nhp_1 d2cmd_1', 'd1fcda1 d1ldb_1',
				'd1lvl_1 d2ohxa2', 'd1nhp_2 d2naca2',
				'd1pbe_1 d2ohxa2', 'd1gdha2 d1nhp_2',
				'd2cmd_1 d2tpra1', 'd1tde_1 d2cmd_1',
				'd1llda1 d1nhp_2', 'd1hlpa1 d1nhp_2',
				'd1nhp_1 d2dlda2', 'd1hyha1 d1nhp_2',
				'd1nhp_2 d1psda2', 'd1fcda1 d2cmd_1',
				'd1fcda1 d1llda1', 'd1lvl_2 d1udpa_',
				'd1psda2 d2tpra2', 'd1hdca_ d1lvl_2',
				'd1gesa2 d1llda1', 'd1nhp_2 d1qora2',
				'd1ldm_1 d2tpra1', 'd1coy_1 d2dlda2',
				'd2dlda2 d2tpra1', 'd1hdca_ d1pbe_1',
				'd1coy_1 d1gdha2', 'd1nhp_2 d2cmd_1',
				'd1llda1 d1tde_1', 'd1llda1 d1lvl_1',
				'd1bdma1 d2tpra1', 'd1gd1o1 d2tpra2',
				'd1ldb_1 d1lvl_1', 'd1hlpa1 d1tde_2',
				'd1coy_1 d1psda2', 'd1nhp_2 d1udpa_',
				'd1llda1 d1tde_2', 'd1tde_2 d2cmd_1',
				'd1llda1 d2tpra2', 'd1ldb_1 d1tde_1',
				'd1coy_1 d1hlpa1', 'd1coy_1 d2cmd_1',
				'd1bdma1 d1gesa2', 'd1hyha1 d2tpra2',
				'd1gesa2 d1hyha1', 'd1gesa2 d2ohxa2',
				'd1ldb_1 d1tde_2', 'd1hlpa1 d1pbe_1',
				'd1ldm_1 d2tpra2', 'd2ohxa2 d2tpra1',
				'd1ldb_1 d2tpra2', 'd1gesa2 d1ldm_1',
				'd1lvl_2 d1qora2', 'd1gesa1 d2naca2',
				'd1coy_1 d1llda1', 'd1coy_1 d1hyha1',
				'd1coy_1 d1ldm_1', 'd1ldm_1 d1lvl_2',
				'd1eny__ d1nhp_2', 'd1pbe_1 d2pgd_2',
				'd1ldb_1 d1pbe_1', 'd1ldb_1 d1lvl_2',
				'd1gesa2 d1hlpa1', 'd1dhr__ d1nhp_2',
				'd1hdca_ d1tde_1', 'd1gesa1 d1psda2',
				'd1pbe_1 d2cmd_1', 'd1tde_2 d1udpa_',
				'd1pbe_1 d2dlda2', 'd1hdca_ d1tde_2',
				'd1gesa2 d1ldb_1', 'd1psda2 d2tpra1',
				'd1gdha2 d1lvl_2', 'd1tde_1 d2dlda2',
				'd1ldm_1 d1pbe_1', 'd1pbe_1 d1scua2',
				'd1gesa1 d2ohxa2', 'd1lvl_2 d2naca2',
				'd1gd1o1 d1lvl_1', 'd1fvl__ d1kst__',
				'd1kst__ d2ech__', 'd1hsaa2 d1std__', ## d1hsaa.. is NOT homol, but to fix a problem in E_100_e_0.0005_j30_segged_2092
				'd1afp__ d1hfi__'
				);


		 for($i=0; $i< @correcting_pairs; $i++){
										 $correcting_pairs{$correcting_pairs[$i]}=$correcting_pairs[$i];
		 }
		 return(\%correcting_pairs);
}

#________________________________________________________________________
# Title     : get_base_names
# Usage     : $base =${&get_base_names(\$file_name)};
#             :   or @bases = &get_base_names(\@files);  # <-- uses `pwd` for abs directory
# Function  : produces the file base name(eg, "evalign"  out of "evalign.pl" ).
#              when xxxx.xx.gz form file is given, it removes gz as well
#
# Example   : $base => 'test'  with 'test.txt' or '/home/dir/of/mine/text.txt'
# Warning   :
# Keywords  : get_base_name{, base_name, file_base_name ,  get_file_base_name
#             get_basename, basename, get_root_name, base , root, get_file_root
# Options   :
# Returns   :
# Argument  : handles both ref and non-ref.
# Version   : 1.5
#--------------------------------------------------------------------
sub get_base_names{
	my($x, $pos, $pos1, @out_file, $file_only, $file, @file, $base, @base);
	@file=@{$_[0]} if (ref($_[0]) eq 'ARRAY');
	@file=@_ if !(ref($_[0]) eq 'ARRAY');
	for($x=0; $x < @file; $x ++){
		if( ref($file[$x]) ){
			$file = ${$file[$x]};
			$pos1=rindex($file, "/");
	        $file_only=substr($file, ($pos1+1));
						if($file_only=~/(\S+\.\S+)\.gz$/){
							 $pos = rindex($1, ".");
			   $base= substr($1, 0, $pos);
			}elsif($file_only=~/^[^\.]+$/){ ## when file does not have '.' in its name
							 $base= $file_only;
						}else{
							 $pos = rindex($file_only, ".");
							 $base= substr($file_only, 0, $pos);
						}
		}else{
			$file = $file[$x];
			$pos1=rindex($file, "/");
	        $file_only=substr($file, ($pos1+1));
			if($file_only=~/(\S+\.\S+)\.gz$/){
							 $pos = rindex($1, ".");
			   $base= substr($1, 0, $pos);
						}elsif($file_only=~/^[^\.]+$/){ ## when file does not have '.' in its name
							 $base= $file_only;
			}else{
							 $pos = rindex($file_only, ".");
							 $base= substr($file_only, 0, $pos);
						}
		}
		push(@base, $base);
	}
	if(@base == 1 ){ \$base[0] }else{ \@base }
}
#________________________________________________________________________
# Title     : default_help
# Usage     : &default_help2;  usually with 'parse_arguments' sub.
# Function  : Prints usage information and others when invoked. You need to have
#             sections like this explanation box in your perl code. When invoked,
#             default_help routine reads the running perl code (SELF READING) and
#             displays what you have typed in this box.
#             After one entry names like # Function :, the following lines without
#             entry name (like this very line) are attached to the previous entry.
#             In this example, to # Function : entry.
# Example   : &default_help2; &default_help2(\$arg_num_limit);   &default_help2( '3' );
#             1 scalar digit for the minimum number of arg (optional),
#             or its ref. If this defined, it will produce exit the program
#             telling the minimum arguments.
# Warning   : this uses format and references
# Keywords  :
# Options   :
# Returns   : formated information
# Argument  :
# Version   : 3.4
#--------------------------------------------------------------------
sub default_help{
	my($i, $perl_dir, $arg_num_limit, $head ,$arg_num_limit, $key_press, $e,
	  @entries, @entries_I_want_write, $option_tb_found, $extension, $logname, $tmp );
	$logname=getlogin();
	my($pwd)=`pwd`;
	my($date)=`date`;
	chomp($date,$pwd);
	my($not_provided)="--- not provided ---\n";
	my($file_to_read) = $0;

	for($i=0; $i < @_; $i ++){
	  if((ref($_[$i]) eq 'SCALAR')&&(${$_[$i]} =~ /^\d$/)){
		  $arg_num_limit = ${$_[$i]};  }
	  elsif( (!(ref($_[$i]))) && ($_[$i] =~ /^\d$/)){
		  $arg_num_limit = $_[$i];     }
	}
	my %entries = %{&read_head_box(\$file_to_read )};
	if($option_tb_found ==1){
	 @option_tb=@{&read_option_table(\$file_to_read)};
	}

	@entries = keys %entries;
	foreach $help_item (@entries){
	  ${$help_item}= $not_provided if( ${$help_item}=~/^[\W]*$/  and  !defined(${$help_item}) );
	}
	#""""""""""""""""""""""""""""""""""""""""
	#########  Writing the format <<<<<<<<<<<
	#""""""""""""""""""""""""""""""""""""""""
	$~ =HEADER_HELP;
	write;   ## <<--  $~ is the selection operator
	$~ =DEFAULT_HELP_FORM;

	@entries_I_want_write=sort keys %entries;

	for( @entries_I_want_write ){  write  }

	print chr(7);  print "_"x72,"\n\n";

	if(@ARGV < $arg_num_limit){ print "\* $0 fataly needs $arg_num_limit arguments\n\n" }

	if(  $option_tb_found == 1){
	 #########  Printing the OPTION table contents <<<<<<<<<<<<
	 print "  Press \"Return\" key to see what options $logname\'s \n\n    \"$0\" take... \n";
				 $key_press=getc();
	 print @option_tb, "\n"x2 if(@option_tb > 0);
	}
format HEADER_HELP  =
_____________________________________________________________________
		  __  __      ______     __          _____
		 /\ \/\ \    /\  ___\   /\ \        /\  _ `\
		 \ \ \_\ \   \ \ \__/   \ \ \       \ \ \L\ \
		  \ \  _  \   \ \  _\    \ \ \       \ \ ,__/
		   \ \ \ \ \   \ \ \/___  \ \ \_____  \ \ \/
		    \ \_\ \_\   \ \_____\  \ \______\  \ \_\
		     \/_/\/_/    \/_____/   \/______/   \/_/ V 3.1`
_____________________________________________________________________
.
format DEFAULT_HELP_FORM =
 @<<<<<<<<<: @*
 $_,        $entries{$_}
.
}
#________________________________________________________________________
# Title     : handle_arguments
# Usage     : Just put the whole box delimited by the two '###..' lines below
#             to inside of your subroutines. It will call 'handle_arguments'
#             subroutine and parse all the given input arguments.
#             To use, claim the arguments, just use the variable in the box.
#             For example, if you had passed 2 file names for files existing
#             in your PWD(or if the string looks like this: xxxx.ext),
#             you can claim them by $file[0], $file[1] in
#             your subroutine.
# Function  : Sorts input arguments going into subroutines and returns default
#             arrays of references for various types (file, dir, hash, array,,,,)
#             If you give (\@out, @file), it will put @out into @array as a ref
#             and also the contents of @out will be dereferenced and put to
#             raw_string regardless what is in it).
#
# Example   : 'handle_arguments(\@array, $string, \%hash, 8, 'any_string')
# Warning   :
# Keywords  : handling arguments, parsing arguments,
# Options   :
# Returns   : Following GLOBAL variables
#
#             $num_opt,    @num_opt     @file          @dir
#             $char_opt,   @char_opt    %vars          @array,
#             @hash        @string,     @raw_string    @range,
#
#             $num_opt has 10,20
#             @num_opt has (10, 20)
#             @file has  xxxx.ext
#             @dir has  dir  or /my/dir
#             $char_opt has 'A,B'
#             @char_opt has (A, B)
#             @array has  (\@ar1, \@ar2)
#             @hash has (\%hash1, \%hash2)
#             @string  ('sdfasf', 'dfsf')
#             @raw_string (file.ext, dir_name, 'strings',,)
#             @range has values like  10-20
#             %vars deals with x=2, y=3 stuff.
#
# Argument  : any type, any amount
# Version   : 4.8
#--------------------------------------------------------------------
sub handle_arguments{
	my($c, $d, $e, $f, $i, $j, $k, $l, $s, $t, $x, $y, $z, $char_opt, $dir, @hash,
		$file, $in_dir, $num_opt, @char_opt, @dir, @file, @string, @file_dir, @k,
		@num_opt, @raw_string,@string, @array, %vars, @range, @temp, $temp,
		@char_options);

	&set_debug_option;
	if(@_<1){ print chr(7),"\n This is handle_arguments. No args Passed, Error?\n"}
	elsif( (@_ ==1)&& (ref($_[0]) eq 'ARRAY') ){ # when there is only 1 argument
	  push(@array, $_[0]);
	  push(@k, $_[0]);
	}elsif( (@_==1)&&( !ref($_[0]) ) ){
	  if(-f $_[0]){ push(@file, $_[0]);   push(@string, $_[0]) }
	  elsif(-d $_[0]){ push(@dir, $_[0]); push(@string, $_[0]) }
	  elsif($_[0]=~/^\d+$/){ push(@num_opt, $_[0]); $num_opt.=$_[0] }
	  elsif($_[0]=~/^\w+$/){ push(@string, $_[0]); }
	}elsif(@_ >=1){ @k = @_ }

	#####______Start of  general argument handling______######
	for($k=0; $k < @k ;$k++){
	  if( !ref($k[$k]) ){
		  if($k[$k]=~ /^[\-]?([a-zA-Z]\d*) {0,5}$/){  push(@char_opt, $1); $char_opt .= "$1\,";
		  }elsif($k[$k]=~ /^\-([a-zA-Z]+)$/){          ## When multiple option is given,
			  @char_options = split(/\,|/, $1);  push(@char_opt, @char_options);
			  $char_opt .= join("\,", @char_options); ## '-' should be used. eg. '-HEGI'
		  }elsif($k[$k]=~ /^(\w+)\=(\S* *)$/){  $vars{$1}=$2;  $vars .= "$1\,";
		  }elsif($k[$k]=~ /^(\-?\d+)$/){ push(@num_opt, $1);  $num_opt .= "$1\,";
		  }elsif($k[$k]=~ /^\d+\.?\d*\-\d+\.?\d*$/){  push(@range,  $k[$k] );
		  }elsif(-f $k[$k]){                          push(@file,   $k[$k] );
		  }elsif(-d $k[$k]){                          push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /\/[\w\d\.\-]+[\/].+[\/]$/){push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /^\/[\w\d\.\-]+[\/]*$/){    push(@dir,    $k[$k] );
		  }elsif($k[$k]=~ /^[\/\w\d\-\.]+\.\w+$/){    push(@file,   $k[$k] );
		  }elsif($k[$k]=~ /\S\/[\/\w\d\-\.]+\.\w+$/){ push(@file,   $k[$k] );
		  }elsif($k[$k]=~/^\w+[\/\\\w\d\.\-]+$/){     push(@string, $k[$k] );
		        # string does not have space, but includes '\', '/', '.'
		  }else{                                      push(@raw_string, $k[$k] );  }

	  }elsif( ref($k[$k]) ){
		  if( ref($k[$k]) eq "SCALAR"){
			 if(${$k[$k]} =~ /^[\-]?([a-zA-Z]\d*) {0,5}$/){ push(@char_opt, $1); $char_opt  .= "$1\,";
				}elsif(${$k[$k]}=~ /^\-([a-zA-Z]+)$/){ push(@char_opt, @char_options);
					$char_opt  .= join("\,", @char_options);  ## as an option string.
				}elsif(${$k[$k]}=~ /^(\w+)\=(\S* *)$/){  $vars{$1}=$2;  $vars .= "$1\,";
				}elsif(${$k[$k]}=~ /^(\-?\d+)$/){ $num_opt .= "$1\,";  push(@num_opt, $1);
			    }elsif(${$k[$k]}=~ /^\d+\.?\d*\-\d+\.?\d*$/){    push(@range,  $k[$k] );
				}elsif(-f ${$k[$k]}){                            push(@file,   ${$k[$k]} );
				}elsif(-d ${$k[$k]}){                            push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~ /\/[\/\w\d\.\-]+[\/].+[\/]/){ push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~/^\/[\/\w\d\.\-]+[\/]*$/){     push(@dir,    ${$k[$k]} );
				}elsif(${$k[$k]}=~ /^[\/\w\d\-\.]+\.\w+$/){      push(@file,   ${$k[$k]} );
				}elsif(${$k[$k]}=~/^\w+[\w\d\.\-]+$/){           push(@string, ${$k[$k]} );
				}else{                                           push(@raw_string, ${$k[$k]}); }
		  }elsif(ref($k[$k]) eq "ARRAY"){ my @temp_arr = @{$k[$k]}; push(@array, $k[$k]);
			for ($i=0; $i<@temp_arr; $i++){
			   if(-f $temp_arr[$i]){                            push(@file, $temp_arr[$i]);
			   }elsif($temp_arr[$i]=~/^\d+\.?\d*\-\d+\.?\d*$/){ push(@range,$temp_arr[$i] );
			   }elsif(-d $temp_arr[$i]){                        push(@dir , $temp_arr[$i]);
			   }elsif($temp_arr[$i]=~/\/[\/\w\d\.\-]+[\/].+[\/]/){ push(@dir, $temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^\/[\/\w\d\.\-]+[\/]*$/){ push(@dir, $temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^[\/\w\d\-\.]+\.\w+$/){   push(@file,$temp_arr[$i] );
																push(@string,$temp_arr[$i] );
			   }elsif($temp_arr[$i]=~/^\w+[\w\d\.\-]+$/){       push(@string,$temp_arr[$i]);
			   }else{                                           push(@raw_string, $temp_arr[$i]); }
			 }
		  }elsif(ref($k[$k]) eq "HASH"){                             push(@hash,   $k[$k] ); }
	  }
	}
	@raw_string=(@raw_string, @string);
	@file = @{&remove_dup_in_arrayH(\@file)};
	#-----------------------------------------------------
	 sub remove_dup_in_arrayH{  my($i, @nondup, @out_ref, %duplicate, @orig, @out_ref);
		for($i=0; $i<@_; $i++){  undef(%duplicate);
	       if(ref($_[$i]) eq 'ARRAY'){    @orig = @{$_[$i]};    }
		   @nondup = grep { ! $duplicate{$_}++ } @orig; push(@out_ref, \@nondup);  }
		if(@out_ref ==1){ return($out_ref[0]);}
		elsif(@out_ref >1){  return(@out_ref);}
	 }
	#-----------------------------------------------------
	return(\@hash, \@array, \@string, \@dir, \@file, \@num_opt,
			\@char_opt, \$num_opt, \$char_opt, \@raw_string, \%vars, \@range );
}
#________________________________________________________________________________
# Title     : import_ENV_vars
# Usage     :
# Function  : You can use any ENV set variables directly in your
#             program. So, you can say $USER instead of $ENV{'USER'}
# Example   :
# Keywords  : import_Env_vars, import_ENV_variables
# Options   :
# Version   : 1.1
#--------------------------------------------------------------------------------
sub import_ENV_vars{
		my($caller_package, $env_var_name);
		$caller_package=caller;
		foreach  $env_var_name (keys %ENV){
			 ${"${'caller_package'}::${'env_var_name'}"}=$ENV{$env_var_name}; ## ' ' are necessary
		}
		print "\n# import_ENV_vars: ALL the ENV settings are imported to $0 program\n";
}
#________________________________________________________________________
# Title     : read_option_table
# Usage     :
# Function  : Reads the option table made by Jong in any perl script. The
#             option table is a box with separators.
# Example   :
# Warning   :
# Keywords  :
# Options   :
# Returns   :
# Argument  :
# Version   : 1.0
#--------------------------------------------------------------------
sub read_option_table{
	my($table_found, @option_tb, $head, );
	 open(SELF, "${$_[0]}");
	 while(<SELF>){
		if( (/^ *#+/) && ( $table_found== 1) ){
		  push (@option_tb, "$_");
		}elsif( ($table_found != 1)&&(/^ *\#+ *[Oo]ption *[Tt]able */) ){
			$table_found=1; $head="############## Option Table  \"$0\"\n"; ##
			push(@option_tb, $head);
		}
		if( ($table_found==1)&&(/^ *###################+ *$/)){  ### to find the end point of reading
			$table_found =0; last; }
	 }
	 return(\@option_tb);
}
#________________________________________________________________________
# Title     : read_head_box
# Usage     : %entries = %{&read_head_box([\$file_to_read, \@BOXED ] )};
# Function  : Reads the introductory header box(the one you see on top of sub routines of
#             Jong's programs.). Make a hash(associative array) to put entries
#             and descriptions of the items. The hash values have new lines '\n' are
#             attached, so that later write_head_box just sorts Title to the top
#             and prints without much calculation.
#             This is similar to read_head_box, but
#             This has one long straight string as value(no \n inside)
#             There are two types of ending line one is Jong's #---------- ...
#             the other is Astrid's  #*************** ...
# Example   : Output is something like
#             ('Title', 'read_head_box', 'Tips', 'Use to parse doc', ...)
# Warning   :
# Keywords  : open_head_box, open_headbox, read_headbox
# Options   : 'b' for remove blank lines. This will remove all the entries
#             with no descriptions
# Returns   : A hash ref.
# Argument  : One or None. If you give an argu. it should be a ref. of an ARRAY
#              or a filename, or ref. of a filename.
#             If no arg is given, it reads SELF, ie. the program itself.
# Version   : 2.7
#--------------------------------------------------------------------
sub read_head_box{
	my($i, $c, $d, $j, $s, $z, @whole_file, $title_found, %Final_out,
	  $variable_string, $TITLE, $title, @keys, $end_found, $line, $entry,
	  $entry_match, $End_line_num, $remove_blank,  $title_entry_null,
	  $end_found, $Enclosed_entry, $Enclosed_var, $blank_counter,
	  $title_entry_exist, $entry_value, $temp_W, $Warning_part, $tmp,
	  $option_tb_found
	);

	if(ref($_[0]) eq 'ARRAY'){ ## When array is given
	  @whole_file = @{$_[0]};
	}elsif(-e ${$_[0]}){       ## When filename is given in a ref
	  open(FILE, "${$_[0]}");
	  @whole_file=(<FILE>);
	}elsif(-e $_[0]){          ## When filename is given
	  open(FILE, "$_[0]");
	  @whole_file=(<FILE>);
	}elsif( $_[0] eq 'b'){          ## When filename is given
	  $remove_blank = 1;
	}elsif( ${$_[0]} eq 'b'){          ## When filename is given
	  $remove_blank = 1;
	}else{
	  open(SELF, "$0");
	  @whole_file=(<SELF>);
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	for($i=0; $i<@whole_file; $i++){
	 $whole_file[$i] =~ tr/\t/ {7}/;  ## This is quite important to some parsing!!!
	 #########################################
	 ##  The first and second line of box 1 ##
	 #########################################
	 if( ($whole_file[$i]=~/^#[_\*\~\-\=]{20,}$/)&&    ##  '#______' is discarded
		 ($whole_file[$i+1]=~/ *\# {0,3}([TitlNam]+e) {0,8}: {1,10}([\w\.:]*) *(Copyright.*)/i) ){
		 $TITLE = $1;      $title = "$2\n";   $Final_out{'Warning'}.="$3\n";
		 $entry_match=$TITLE; ## The very first $entry_match is set to 'Title' to prevent null entry
		 if($TITLE =~ /^Title|Name$/i){   #
			  if( ($title=~/^\s+$/)||( $title eq "\n") ){
				  $title_entry_null =1;  $title = '';  }    }
		 $Final_out{$TITLE}=$title;
		 $title_found ++ ;   $i++;  ## << this is essential to prevent reading the same line again.
		 last if $title_found > 1;    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ## The first and second line of box 2, #__________ or #**************
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($whole_file[$i]=~/^#[_\*]{20,}$/)&&
		 ($whole_file[$i+1]=~/^# {1,3}(\w{1,6}\s{0,2}\w+) {0,7}: {1,5}(.*) */i) ){
		 $title_found ++ ;        $i++;
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;  ## Capitalize words
		 $Final_out{$entry_match}.= "$entry_value\n";
		 last if $title_found > 1;  next;   }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  'Enclosed' : section. After this, everything is read without discrimination ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($Enclosed_entry == 1)&&($whole_file[$i] =~/^#{1,} {1,}(.*)$/) ){
		 $Final_out{$Enclosed_var}.= "$1\n";    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  With proper entry 1 : for  'eg)'
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,12}(eg ?\)) {0,8}(.*)/i)){
		 $entry_match='Example';
		 $Final_out{$entry_match}.= "$2\n";
	 }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ##  With PROPER entry 2 : descriptins like. 'Ussage : ssssssxxjkk  kj'
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,2}(\w{1,4}\s{0,2}\w{1,7}) {0,8}[:\)] {0,6}(.*) */i)){
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;
		 $Final_out{$entry_match}.= "$entry_value\n";
		 if($entry_match=~/^(Enclosed?)$/i){
			  $Enclosed_entry = 1;  $Enclosed_var=$1;        }    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  With proper entry 3 : descriptins like. 'Ussage :', But blank description ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&($title_found==1)&&
		 ($whole_file[$i]=~ /^# {1,2}(\w{1,4}\s{0,2}\w{1,7}) {0,8}[:\)]( {0,})$/i)){
		 $entry_match=$1;       $entry_value=$2;
		 $entry_match =~ s#^\S#(($tmp = $&) =~ tr/[a-z]/[A-Z]/,$tmp)#e;
		 $Final_out{$entry_match}.= " $entry_value\n";
		 if($entry_match=~/^(Enclosed?)$/i){
			  $Enclosed_entry = 1;  $Enclosed_var=$1;      }    }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  $option variable matching                ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1) && ($title_found==1) &&
		 ($whole_file[$i]=~ /^# {1,15}([\$\@]\w+ +[\w=\>]+ +\S+ \w+ \S+ *.*)/ )){
		 $Final_out{$entry_match} .= "$1\n";  }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  all space line matching                 ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&  ##<----- If blank line is matched. Take the line
		 ($title_found==1)&&($whole_file[$i]=~/^# {0,}$/) ){
		 $blank_counter++;
		 if($blank_counter > 2){ $blank_counter--; }
		 else{ $Final_out{$entry_match}.= " \n";  }     }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  Anything after 3 space to 12 positions  ##
	 ###  To match 'examples' etc. INC. ':'       ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&
		 ($title_found==1)&&($whole_file[$i]=~/^#( {2,12})(.+)/) ){
		 $Final_out{$entry_match}.= "$1$2\n"; $blank_counter=0; }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###  Anything after 1 space to 11 positions  ##
	 ###  To match 'examples' etc. EXC. ':'       ##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($end_found != 1)&&
		 ($title_found==1)&&($whole_file[$i]=~/^# {1,12}([^:.]+)/) ){
		 $Final_out{$entry_match}.= "$1\n"; $blank_counter=0;}

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 ###-------End of the read_box reading--------##
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( ($title_found==1)&&
		 ($whole_file[$i]=~ /^#[\~\=\*\-]{15,}/)){  ## to match '#-----..' or '#******..'(Astrid's)
		 $End_line_num = $i;       $end_found++;
		 last;      }

	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 #  <<<<  Check if there is option table >>>>  #
	 #"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	 elsif( (/^#{10,} option table of this program   #{10,}/)&&($end_found >=1) &&($title_found==1)){
				 $option_tb_found++; ### This is a global var.
	 }
	} ## < End of for loop


	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### If title is not there at all     ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	@keys=keys %Final_out;
	for(@keys){
	  if(/^Title$/i){    ## No Entry of Title at all??
		  $TITLE =$&;
		  $title_entry_exist = 1;
		  if($Final_out{$_}=~/^ *$/){   ## if Title => Null or just space
			  $title_entry_null = 1;    }  }  }

	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### When title entry is not there    ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	if( $title_entry_exist != 1){
		for($s=$End_line_num+1; $s < $End_line_num+20; $s++){
			if( $whole_file[$s] =~ /^sub {1,5}([\w\.]+) {0,6}\{/){
				$Final_out{'Title'} = "$1\n";   last;       }
			elsif( $whole_file[$s] =~/^#________________________+/){
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{'Title'} = "$0";     last;
			}else{
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{'Title'} = "$0";
			}
		}
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	### When title is blank              ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	elsif($title_entry_null ==1){  ## It looks for 'sub xxxxx{ ' line to get title
		### $End_line_num is the last line read.
		for($s = $End_line_num+1; $s < $End_line_num+20; $s++){
			if( $whole_file[$s] =~ /^sub {1,5}(\w+\.*\w*) {0,7}{/){
				$Final_out{$TITLE} = "$1\n";    last;     }
			elsif( $whole_file[$s] =~/^#________________________+/){
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{$TITLE} = "$0";     last;
			}else{
				#######################################
				## Uses running file name as titile  ##
				#######################################
				$Final_out{$TITLE} = "$0";
			}
		}
	}
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	## Error handling, if no head box is found   ####
	#"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
	if($title_found < 1){ print "\nFatal: No headbox found by read_head_box2 sub.\n";  }
	\%Final_out;
}               ##<<--- ENd of the sub read_head_box


#________________________________________________________________________________
# Title     : check_input_file_extension
# Usage     : @file=@{&check_input_file_extension('msp', \@file)};
#             or @file=@{&check_input_file_extension('msp,nhco', \@file)};
#                for multiple extension allowance
# Function  :
# Example   : @file=@{&check_input_file_extension('msp', \@file)};
# Keywords  :
# Options   :
# Category  :
# Version   : 1.2
#--------------------------------------------------------------------------------
sub check_input_file_extension{
		my($i);
				my $file_ext_wanted=$_[0];
				my ($extension_not_matched);
				my @extentions=split(/[\, ]+/, $file_ext_wanted);
				my @file=@{$_[1]};
				for(@extentions){
						$file_ext_wanted=$_;
						#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
						print "\n# (2) checking file extension \n";
						#___________________________________________________
						if($file[0] =~/\.$file_ext_wanted/){
								 $extension_not_matched=1;
						}
				}
				unless($extension_not_matched){
						 print "\n# write_nhco_files : normally accepts xxxx.$file_ext_wanted files. Put y+return to continue";
						 print "\n# write_nhco_files : You can type \'c\' for changing the file extension to parf \n\n>>>";
						 $answer_char=getc;
						 if($answer_char=~/^y/i){
								 $answer_char='';
						 }elsif($answer_char=~/^c/i){
								 $answer_char='';
								 #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
								 print "\n# (3) write_nhco_files: chaning all the file input extension to 'parf'";
								 #_______________________________________________________________________________
								 for($i=0; $i< @file; $i++){
										 $base=${&get_base_names($file[$i])};
										 $file[$i]="$base\.$file_ext_wanted";
								 }
						 }else{
								 $answer_char='';
								 print "\n\n\n# check_input_file_extension: You rudely put rubbish, I am dying. $0\n\n\n";
								 print chr(7);
								 exit;
						 }
				}
				return(\@file);
}




#______________________________________________________________________________
# Title     : get_all_possible_pairs_from_array
# Usage     :
# Function  : gets pairs (sorted) from array
# Example   :
# Keywords  : pair_combination, combination, permutation, get_combinatorial_pairs
# Options   :
# Author    : jong@bio.cc,
# Category  :
# Returns   : HASH
# Version   : 1.0
#------------------------------------------------------------------------------
sub get_all_possible_pairs_from_array{
    my(%resulting_pairs_hash);
    @input_array=@{$_[0]};
    for($i=0; $i< @input_array; $i++){
       for($j=$i+1; $j<@input_array; $j++){
          $sorted_pair=join(' ', sort($input_array[$i], $input_array[$j]));
          $resulting_pairs_hash{$sorted_pair}=$sorted_pair;
       }
    }
    return(\%resulting_pairs_hash);
}

