package Locale::CLDR::Sr v0.25.1;
# This file auto generated from Data\common\main\sr.xml
#	on Sun 11 May 12:24:34 am GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'Афарски',
 				'ab' => 'Абказијски',
 				'ace' => 'Ачинески',
 				'ach' => 'Аколи',
 				'ada' => 'Адангмејски',
 				'ady' => 'Адигејски',
 				'ae' => 'Авестански',
 				'af' => 'Африканерски',
 				'afh' => 'Африхили',
 				'ain' => 'Аину',
 				'ak' => 'Акан',
 				'akk' => 'Акадијски',
 				'ale' => 'Аљут',
 				'alt' => 'Јужни алтаи',
 				'am' => 'Амхарски',
 				'an' => 'Арагонежански',
 				'ang' => 'Староенглески',
 				'anp' => 'Ангика',
 				'ar' => 'Арапски',
 				'ar_001' => 'модеран стандардни арапски',
 				'arc' => 'Армајски',
 				'arn' => 'Ароканијски',
 				'arp' => 'Арапахо',
 				'arw' => 'Аравак',
 				'as' => 'Асемијски',
 				'ast' => 'Астуријски',
 				'av' => 'Аварски',
 				'awa' => 'Авадхи',
 				'ay' => 'Ајмара',
 				'az' => 'Азербејџански',
 				'az@alt=short' => 'Азерски',
 				'ba' => 'Башкир',
 				'bal' => 'Балучи',
 				'ban' => 'Балинезијски',
 				'bas' => 'Баса',
 				'be' => 'Белоруски',
 				'bej' => 'Беја',
 				'bem' => 'Бемба',
 				'bg' => 'Бугарски',
 				'bho' => 'Бојпури',
 				'bi' => 'Бислама',
 				'bik' => 'Бикол',
 				'bin' => 'Бини',
 				'bla' => 'Сисика',
 				'bm' => 'Бамбара',
 				'bn' => 'Бенгласки',
 				'bo' => 'Тибетански',
 				'br' => 'Бретонски',
 				'bra' => 'Брај',
 				'bs' => 'Босански',
 				'bua' => 'Буриат',
 				'bug' => 'Бугинежански',
 				'byn' => 'Блин',
 				'ca' => 'Каталонски',
 				'cad' => 'Кадо',
 				'car' => 'Карипски',
 				'cch' => 'Атсамски',
 				'ce' => 'Чеченски',
 				'ceb' => 'Цебуано',
 				'ch' => 'Чаморо',
 				'chb' => 'Чибча',
 				'chg' => 'Чагатаи',
 				'chk' => 'Чукески',
 				'chm' => 'Мари',
 				'chn' => 'Чинукски',
 				'cho' => 'Чоктавски',
 				'chp' => 'Чипвијански',
 				'chr' => 'Чероки',
 				'chy' => 'Чејенски',
 				'ckb' => 'сорани курдски',
 				'co' => 'Корзикански',
 				'cop' => 'Коптски',
 				'cr' => 'Кри',
 				'crh' => 'Кримеански турски',
 				'cs' => 'Чешки',
 				'csb' => 'Кашубијански',
 				'cu' => 'Старословенски',
 				'cv' => 'Чувашки',
 				'cy' => 'Велшки',
 				'da' => 'Дански',
 				'dak' => 'Дакота',
 				'dar' => 'Даргва',
 				'de' => 'Немачки',
 				'de_AT' => 'Аустријски немачки',
 				'de_CH' => 'Швајцарски високи немачки',
 				'del' => 'Делавер',
 				'den' => 'Славски',
 				'dgr' => 'Догриб',
 				'din' => 'Динка',
 				'doi' => 'Догри',
 				'dsb' => 'Ниски сорбијански',
 				'dua' => 'Дуала',
 				'dum' => 'Средњи холандски',
 				'dv' => 'Дивехијски',
 				'dyu' => 'Ђула',
 				'dz' => 'Џонга',
 				'ee' => 'Еве',
 				'efi' => 'Ефикски',
 				'egy' => 'Староегипатски',
 				'eka' => 'Екајук',
 				'el' => 'Грчки',
 				'elx' => 'Еламитски',
 				'en' => 'Енглески',
 				'en_AU' => 'Аустралијски енглески',
 				'en_CA' => 'Канадски енглески',
 				'en_GB' => 'Британски енглески',
 				'en_GB@alt=short' => 'енглески (УК)',
 				'en_US' => 'САД енглески',
 				'en_US@alt=short' => 'енглески (САД)',
 				'enm' => 'Средњи енглески',
 				'eo' => 'Есперанто',
 				'es' => 'Шпански',
 				'es_419' => 'Латино-амерички шпански',
 				'es_ES' => 'Иберијски шпански',
 				'es_MX' => 'мексички шпански',
 				'et' => 'Естонски',
 				'eu' => 'Баскијски',
 				'ewo' => 'Евондо',
 				'fa' => 'Персијски',
 				'fan' => 'Фанг',
 				'fat' => 'Фанти',
 				'ff' => 'Фулах',
 				'fi' => 'Фински',
 				'fil' => 'Филипински',
 				'fj' => 'Фиджијски',
 				'fo' => 'Фарски',
 				'fon' => 'Фон',
 				'fr' => 'Француски',
 				'fr_CA' => 'Канадски француски',
 				'fr_CH' => 'Швајцарски француски',
 				'frm' => 'Средњи француски',
 				'fro' => 'Старофранцуски',
 				'frr' => 'Северно-фризијски',
 				'frs' => 'Источни фризијски',
 				'fur' => 'Фриулијски',
 				'fy' => 'Фризијски',
 				'ga' => 'Ирски',
 				'gaa' => 'Га',
 				'gay' => 'Гајо',
 				'gba' => 'Гбаја',
 				'gd' => 'Шкотски Галски',
 				'gez' => 'Џиз',
 				'gil' => 'Гилбертшки',
 				'gl' => 'Галски',
 				'gmh' => 'Средњи високи немачки',
 				'gn' => 'Гварани',
 				'goh' => 'Старонемачки',
 				'gon' => 'Гонди',
 				'gor' => 'Горонтало',
 				'got' => 'Готски',
 				'grb' => 'Гребо',
 				'grc' => 'Старогрчки',
 				'gsw' => 'Швајцарски немачки',
 				'gu' => 'Гуџарати',
 				'gv' => 'Манкс',
 				'gwi' => 'Гвич\'ин',
 				'ha' => 'Хауса',
 				'hai' => 'Хаида',
 				'haw' => 'Хавајски',
 				'he' => 'Хебрејски',
 				'hi' => 'Хинди',
 				'hil' => 'Хилигајнон',
 				'hit' => 'Хитите',
 				'hmn' => 'Хмонг',
 				'ho' => 'Хири Моту',
 				'hr' => 'Хрватски',
 				'hsb' => 'Горњи сорбијски',
 				'ht' => 'Хаитски',
 				'hu' => 'Мађарски',
 				'hup' => 'Хупа',
 				'hy' => 'Јерменски',
 				'hz' => 'Хереро',
 				'ia' => 'Интерлингва',
 				'iba' => 'Ибан',
 				'id' => 'Индонежански',
 				'ie' => 'Међујезички',
 				'ig' => 'Игбо',
 				'ii' => 'Сичуан ји',
 				'ik' => 'Унупиак',
 				'ilo' => 'Илоко',
 				'inh' => 'Ингвишки',
 				'io' => 'Идо',
 				'is' => 'Исландски',
 				'it' => 'Италијански',
 				'iu' => 'Инуктитут',
 				'ja' => 'Јапански',
 				'jbo' => 'Лојбан',
 				'jpr' => 'Јудео-персијски',
 				'jrb' => 'Јудео-арапски',
 				'jv' => 'Јавански',
 				'ka' => 'Грузијски',
 				'kaa' => 'Кара-калпашки',
 				'kab' => 'Кабиле',
 				'kac' => 'Качин',
 				'kaj' => 'Ђу',
 				'kam' => 'Камба',
 				'kaw' => 'Кави',
 				'kbd' => 'Кабардијски',
 				'kcg' => 'Тјап',
 				'kfo' => 'Коро',
 				'kg' => 'Конго',
 				'kha' => 'Каси',
 				'kho' => 'Котанешки',
 				'ki' => 'Кикују',
 				'kj' => 'Куањама',
 				'kk' => 'Козачки',
 				'kl' => 'Калалисут',
 				'km' => 'Кмерски',
 				'kmb' => 'Кимбунду',
 				'kn' => 'Канада',
 				'ko' => 'Корејски',
 				'kok' => 'Конкани',
 				'kos' => 'Косреански',
 				'kpe' => 'Кпеле',
 				'kr' => 'Канури',
 				'krc' => 'Карачај-балкар',
 				'krl' => 'Карелијски',
 				'kru' => 'Курукх',
 				'ks' => 'Кашмирски',
 				'ku' => 'Курдски',
 				'kum' => 'Кумик',
 				'kut' => 'Кутенаи',
 				'kv' => 'Коми',
 				'kw' => 'Корнишки',
 				'ky' => 'Киргиски',
 				'la' => 'Латински',
 				'lad' => 'Ладино',
 				'lah' => 'Ланда',
 				'lam' => 'Ламба',
 				'lb' => 'Луксембуршки',
 				'lez' => 'Лезгиан',
 				'lg' => 'Ганда',
 				'li' => 'Лимбургиш',
 				'ln' => 'Лингала',
 				'lo' => 'Лаоски',
 				'lol' => 'Монго',
 				'loz' => 'Лози',
 				'lt' => 'Литвански',
 				'lu' => 'Луба-катанга',
 				'lua' => 'Луба-лулуа',
 				'lui' => 'Луисено',
 				'lun' => 'Лунда',
 				'luo' => 'Луо',
 				'lus' => 'Лушаи',
 				'lv' => 'Летонски',
 				'mad' => 'Мадурешки',
 				'mag' => 'Магахи',
 				'mai' => 'Маитили',
 				'mak' => 'Макасар',
 				'man' => 'Мандинго',
 				'mas' => 'Масаи',
 				'mdf' => 'Мокша',
 				'mdr' => 'Мандар',
 				'men' => 'Менде',
 				'mfe' => 'Морисјен',
 				'mg' => 'Малагасијски',
 				'mga' => 'Средњи ирски',
 				'mh' => 'Маршалски',
 				'mi' => 'Маорски',
 				'mic' => 'Микмак',
 				'min' => 'Минангкабау',
 				'mk' => 'Македонски',
 				'ml' => 'Малајалам',
 				'mn' => 'Монголски',
 				'mnc' => 'Манчу',
 				'mni' => 'Манипури',
 				'moh' => 'Махавски',
 				'mos' => 'Моси',
 				'mr' => 'Марати',
 				'ms' => 'Малајски',
 				'mt' => 'Мелтешки',
 				'mul' => 'Више језика',
 				'mus' => 'Кришки',
 				'mwl' => 'Мирандешки',
 				'mwr' => 'Марвари',
 				'my' => 'Бурмански',
 				'myv' => 'Ерзија',
 				'na' => 'Науру',
 				'nap' => 'Неаполитански',
 				'nb' => 'Норвешки бокмал',
 				'nd' => 'Северни ндебеле',
 				'nds' => 'Ниски немачки',
 				'ne' => 'Непалски',
 				'new' => 'Невари',
 				'ng' => 'Ндонга',
 				'nia' => 'Ниас',
 				'niu' => 'Ниуеан',
 				'nl' => 'Холандски',
 				'nl_BE' => 'Фламански',
 				'nn' => 'Норвешки њорск',
 				'no' => 'Норвешки',
 				'nog' => 'Ногаи',
 				'non' => 'Стари норски',
 				'nqo' => 'Н’ко',
 				'nr' => 'Јужни ндебеле',
 				'nso' => 'Северни сото',
 				'nv' => 'Навахо',
 				'nwc' => 'Класични невари',
 				'ny' => 'Њања',
 				'nym' => 'Њамвези',
 				'nyn' => 'Њанколе',
 				'nyo' => 'Њоро',
 				'nzi' => 'Нзима',
 				'oc' => 'Провансалски',
 				'oj' => 'Ојибва',
 				'om' => 'Оромо',
 				'or' => 'Оријски',
 				'os' => 'Осетски',
 				'osa' => 'Осаге',
 				'ota' => 'Отомански турски',
 				'pa' => 'Панџабски',
 				'pag' => 'Пангасински',
 				'pal' => 'Пахлави',
 				'pam' => 'Пампанга',
 				'pap' => 'Папиаменто',
 				'pau' => 'Палауански',
 				'peo' => 'Староперсијски',
 				'phn' => 'Феничански',
 				'pi' => 'Пали',
 				'pl' => 'Пољски',
 				'pon' => 'Понпејски',
 				'pro' => 'Старопровансалски',
 				'ps' => 'Паштунски',
 				'ps@alt=variant' => 'пашто',
 				'pt' => 'Португалски',
 				'pt_BR' => 'Бразилски португалски',
 				'pt_PT' => 'Иберијски португалски',
 				'qu' => 'Квенча',
 				'raj' => 'Рађастани',
 				'rap' => 'Рапануи',
 				'rar' => 'Раротонган',
 				'rm' => 'Рето-Романски',
 				'rn' => 'Рунди',
 				'ro' => 'Румунски',
 				'ro_MD' => 'Молдавски',
 				'rom' => 'Романи',
 				'root' => 'Рут',
 				'ru' => 'Руски',
 				'rup' => 'Ароманијски',
 				'rw' => 'Кинјаруанда',
 				'sa' => 'Санскрит',
 				'sad' => 'Сандаве',
 				'sah' => 'Јакут',
 				'sam' => 'Самаритански арамејски',
 				'sas' => 'Сасак',
 				'sat' => 'Сантали',
 				'sc' => 'Сардињаски',
 				'scn' => 'Сицилијански',
 				'sco' => 'Шкотски',
 				'sd' => 'Синди',
 				'se' => 'Северни сами',
 				'sel' => 'Селкап',
 				'sg' => 'Санго',
 				'sga' => 'Староирски',
 				'sh' => 'Српскохрватски',
 				'shn' => 'Шан',
 				'si' => 'Сингалески',
 				'sid' => 'Сидамо',
 				'sk' => 'Словачки',
 				'sl' => 'Словеначки',
 				'sm' => 'Самоански',
 				'sma' => 'Јужни сами',
 				'smj' => 'Луле сами',
 				'smn' => 'Инари сами',
 				'sms' => 'Сколтски језик',
 				'sn' => 'Шона',
 				'snk' => 'Сонинке',
 				'so' => 'Сомалски',
 				'sog' => 'Соџијенски',
 				'sq' => 'Албански',
 				'sr' => 'Српски',
 				'srn' => 'Сранански тонго',
 				'srr' => 'Серер',
 				'ss' => 'Свати',
 				'st' => 'Сесото',
 				'su' => 'Судански',
 				'suk' => 'Сукума',
 				'sus' => 'Сусу',
 				'sux' => 'Сумерски',
 				'sv' => 'Шведски',
 				'sw' => 'Свахили',
 				'swb' => 'Коморски',
 				'syc' => 'Класични сиријски',
 				'syr' => 'Сиријски',
 				'ta' => 'Тамилски',
 				'te' => 'Телугу',
 				'tem' => 'Тимне',
 				'ter' => 'Терено',
 				'tet' => 'Тетум',
 				'tg' => 'Тађик',
 				'th' => 'Тајландски',
 				'ti' => 'Тигриња',
 				'tig' => 'Тигре',
 				'tiv' => 'Тив',
 				'tk' => 'Туркменски',
 				'tkl' => 'Токелау',
 				'tl' => 'Тагалски',
 				'tlh' => 'Клингонски',
 				'tli' => 'Тлингит',
 				'tmh' => 'Тамашек',
 				'tn' => 'Тсвана',
 				'to' => 'Тонга',
 				'tog' => 'Њаса тонга',
 				'tpi' => 'Ток Писин',
 				'tr' => 'Турски',
 				'ts' => 'Тсонга',
 				'tsi' => 'Тсимшиан',
 				'tt' => 'Татарски',
 				'tum' => 'Тумбука',
 				'tvl' => 'Тувалу',
 				'tw' => 'Тви',
 				'ty' => 'Тахићански',
 				'tyv' => 'Тувинијски',
 				'udm' => 'Удмурт',
 				'ug' => 'Ујгурски',
 				'ug@alt=variant' => 'ујгурски',
 				'uga' => 'Угаритски',
 				'uk' => 'Украјински',
 				'umb' => 'Умбунду',
 				'und' => 'Непознат или неважећи језик',
 				'ur' => 'Урду',
 				'uz' => 'Узбечки',
 				'vai' => 'Ваи',
 				've' => 'Венда',
 				'vi' => 'Вијетнамски',
 				'vo' => 'Волапук',
 				'vot' => 'Вотски',
 				'wa' => 'Валун',
 				'wal' => 'Валамо',
 				'war' => 'Варај',
 				'was' => 'Вашо',
 				'wo' => 'Волоф',
 				'xal' => 'Калмик',
 				'xh' => 'Ксхоса',
 				'yao' => 'Јао',
 				'yap' => 'Јапешки',
 				'yi' => 'Јидиш',
 				'yo' => 'Јоруба',
 				'yue' => 'Кантонски',
 				'za' => 'Жуанг',
 				'zap' => 'Запотечки',
 				'zbl' => 'Блисимболи',
 				'zen' => 'Зенага',
 				'zgh' => 'стандардни марокански тамазигт',
 				'zh' => 'Кинески',
 				'zh_Hans' => 'Кинески (поједностављен)',
 				'zh_Hant' => 'Кинески (традиционални)',
 				'zu' => 'Зулу',
 				'zun' => 'Зуни',
 				'zxx' => 'Без лингвистичког садржаја',
 				'zza' => 'Заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арапско писмо',
 			'Arab@alt=variant' => 'персијско-арапско',
 			'Armi' => 'империјско арамејско писмо',
 			'Armn' => 'јерменско писмо',
 			'Avst' => 'авестанско писмо',
 			'Bali' => 'балијско писмо',
 			'Batk' => 'батак писмо',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блисимболично писмо',
 			'Bopo' => 'бопомофо писмо',
 			'Brah' => 'браманско писмо',
 			'Brai' => 'Брајево писмо',
 			'Bugi' => 'бугинско писмо',
 			'Buhd' => 'бухидско писмо',
 			'Cakm' => 'чакманско писмо',
 			'Cans' => 'уједињени канадски абориџински силабици',
 			'Cari' => 'каријско писмо',
 			'Cham' => 'чамско писмо',
 			'Cher' => 'Чероки',
 			'Cirt' => 'цирт писмо',
 			'Copt' => 'коптичко писмо',
 			'Cprt' => 'кипарско писмо',
 			'Cyrl' => 'Ћирилица',
 			'Cyrs' => 'Старословенска црквена ћирилица',
 			'Deva' => 'Деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'египатско народно писмо',
 			'Egyh' => 'египатско хијератско писмо',
 			'Egyp' => 'египатски хијероглифи',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузијско кхутсури писмо',
 			'Geor' => 'грузијско писмо',
 			'Glag' => 'глагољица',
 			'Goth' => 'Готика',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гујарати писмо',
 			'Guru' => 'гурмуки писмо',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hano' => 'хануно',
 			'Hans' => 'поједностављено кинеско писмо',
 			'Hans@alt=stand-alone' => 'поједностављено хан писмо',
 			'Hant' => 'традиционално кинеско писмо',
 			'Hant@alt=stand-alone' => 'традиционално хан писмо',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'Хирагана',
 			'Hmng' => 'пахав хмонг писмо',
 			'Hrkt' => 'Катакана или Хирагана',
 			'Hung' => 'старомађарско писмо',
 			'Inds' => 'индушко писмо',
 			'Ital' => 'стари италик',
 			'Java' => 'јаванско писмо',
 			'Jpan' => 'јапанско писмо',
 			'Kali' => 'кајах-ли писмо',
 			'Kana' => 'Катакана',
 			'Khar' => 'карошти писмо',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'каннада писмо',
 			'Kore' => 'корејско писмо',
 			'Kthi' => 'каити',
 			'Lana' => 'ланна писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'латиница (фрактур варијанта)',
 			'Latg' => 'галска латиница',
 			'Latn' => 'Латиница',
 			'Lepc' => 'лепча писмо',
 			'Limb' => 'лимбу писмо',
 			'Lina' => 'линеарно А писмо',
 			'Linb' => 'линеарно Б писмо',
 			'Lyci' => 'лисијско писмо',
 			'Lydi' => 'лидијско писмо',
 			'Mand' => 'мандеанско писмо',
 			'Mani' => 'манихејско писмо',
 			'Maya' => 'мајански хијероглифи',
 			'Mero' => 'мероитик писмо',
 			'Mlym' => 'малајалам писмо',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'месечево писмо',
 			'Mtei' => 'меитеи мајек писмо',
 			'Mymr' => 'мијанмарско писмо',
 			'Nkoo' => 'н’ко писмо',
 			'Ogam' => 'огамско писмо',
 			'Olck' => 'ол чики писмо',
 			'Orkh' => 'орконско писмо',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'осмањанско писмо',
 			'Perm' => 'старо пермикско писмо',
 			'Phag' => 'пагс-па писмо',
 			'Phli' => 'писани пахлави',
 			'Phlp' => 'псалтер пахлави',
 			'Phlv' => 'пахлави писмо',
 			'Phnx' => 'Феничанско писмо',
 			'Plrd' => 'поралд фонетско писмо',
 			'Prti' => 'писани партиан',
 			'Rjng' => 'рејанг писмо',
 			'Roro' => 'ронгоронго писмо',
 			'Runr' => 'рунско писмо',
 			'Samr' => 'самаританско писмо',
 			'Sara' => 'сарати писмо',
 			'Saur' => 'саураштра писмо',
 			'Sgnw' => 'знаковно писмо',
 			'Shaw' => 'шавијанско писмо',
 			'Sinh' => 'синхала писмо',
 			'Sund' => 'суданско писмо',
 			'Sylo' => 'силоти нагри писмо',
 			'Syrc' => 'сиријско писмо',
 			'Syre' => 'сиријско естрангело писмо',
 			'Syrj' => 'западносиријско писмо',
 			'Syrn' => 'писмо источне Сирије',
 			'Tagb' => 'тагбанва писмо',
 			'Tale' => 'таи ле писмо',
 			'Talu' => 'нови таи луе',
 			'Taml' => 'тамилско писмо',
 			'Tavt' => 'таи виет писмо',
 			'Telu' => 'телугу писмо',
 			'Teng' => 'тенгвар писмо',
 			'Tfng' => 'тифинаг писмо',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тхана писмо',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетанско писмо',
 			'Ugar' => 'угаритско писмо',
 			'Vaii' => 'ваи писмо',
 			'Visp' => 'видљиви говор',
 			'Xpeo' => 'староперсијско писмо',
 			'Xsux' => 'сумерско-акадско кунеиформ писмо',
 			'Yiii' => 'ји писмо',
 			'Zinh' => 'наследно писмо',
 			'Zmth' => 'математичка нотација',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'Неписани језик',
 			'Zyyy' => 'заједничко писмо',
 			'Zzzz' => 'Непознато или неважеће писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Свет',
 			'002' => 'Африка',
 			'003' => 'Северноамерички континент',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Америке',
 			'021' => 'Северна Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Аустралија и Нови Зеланд',
 			'054' => 'Меланезија',
 			'057' => 'Микронезијски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'Острво Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Уједињени Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигве и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Арменија',
 			'AN' => 'Холандски Антили',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Америчка Самоа',
 			'AT' => 'Аустрија',
 			'AU' => 'Аустралија',
 			'AW' => 'Аруба',
 			'AX' => 'Аландска острва',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарска',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Бартоломеј',
 			'BM' => 'Бермуда',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Буве Острва',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Келинг) Острва',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Централно Афричка Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарска',
 			'CI' => 'Обала Слоноваче',
 			'CK' => 'Кукова Острва',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Острво Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Капе Верде',
 			'CW' => 'Курасао',
 			'CX' => 'Божићна острва',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'DE' => 'Немачка',
 			'DG' => 'Дијего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египат',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска Унија',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фокландска острва',
 			'FK@alt=variant' => 'Фокландска (Малвинска) острва',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарска Острва',
 			'FR' => 'Француска',
 			'GA' => 'Габон',
 			'GB' => 'Велика Британија',
 			'GB@alt=short' => 'УК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гурнси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гваделупе',
 			'GQ' => 'Екваторијална Гвинеја',
 			'GR' => 'Грчка',
 			'GS' => 'Јужна Џорџија и Јужна Сендвич Острва',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја-Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонг Конг С. А. Р. Кина',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Херд и Мекдоналд Острва',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Мађарска',
 			'IC' => 'Канарска острва',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Острво Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска територија у Индијском океану',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапан',
 			'KE' => 'Кенија',
 			'KG' => 'Киргизстан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморска Острва',
 			'KN' => 'Сент Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајманска Острва',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Сент Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Летонија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалска Острва',
 			'MK' => 'Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мијанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'Макао С. А. Р. Кина',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северна Маријанска Острва',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мауританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маурицијус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк Острво',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нови Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Пољска',
 			'PM' => 'Сен Пјер и Микелон',
 			'PN' => 'Питкерн',
 			'PR' => 'Порто Рико',
 			'PS' => 'Палестинске територије',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португал',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Остала океанија',
 			'RE' => 'Реинион',
 			'RO' => 'Румунија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудијска Арабија',
 			'SB' => 'Соломонска Острва',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Јелена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јанмајен Острва',
 			'SK' => 'Словачка',
 			'SL' => 'Сијера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужни Судан',
 			'ST' => 'Сао Томе и Принципе',
 			'SV' => 'Салвадор',
 			'SX' => 'Свети Мартин',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Туркс и Кајкос Острва',
 			'TD' => 'Чад',
 			'TF' => 'Француске Јужне Територије',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Источни Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турска',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украјина',
 			'UG' => 'Уганда',
 			'UM' => 'Мања удаљена острва САД',
 			'US' => 'Сједињене Америчке Државе',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британска Девичанска Острва',
 			'VI' => 'С.А.Д. Девичанска Острва',
 			'VN' => 'Вијетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна Острва',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајоте',
 			'ZA' => 'Јужноафричка Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непозната или неважећа област',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиционална немачка ортографија',
 			'1994' => 'Стандарднизована ресијанска ортографија',
 			'1996' => 'Немачка ортографија из 1996',
 			'1606NICT' => 'Француски из касног средњег века до 1606.',
 			'1694ACAD' => 'Рани модерни француски',
 			'1959ACAD' => 'Академски',
 			'AREVELA' => 'Источни арменијски',
 			'AREVMDA' => 'Западно јерменска',
 			'BAKU1926' => 'Уједињен турски латинични алфабет',
 			'BISKE' => 'Сан Ђорђио/Била дијалект',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'ИПА фонетика',
 			'FONUPA' => 'УПА фонетика',
 			'KKCOR' => 'Уобичајена ортографија',
 			'LIPAW' => 'Липовички дијалект ресијански',
 			'MONOTON' => 'Монотоник',
 			'NEDIS' => 'Натисоне дијалект',
 			'NJIVA' => 'Гњива/Њива дијалкект',
 			'OSOJS' => 'Осеако/Осојане дијалект',
 			'POLYTON' => 'Политоник',
 			'POSIX' => 'Компјутер',
 			'REVISED' => 'Ревидирана ортографија',
 			'ROZAJ' => 'Ресијан',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шкотски стандардни Енглески',
 			'SCOUSE' => 'Скауз',
 			'SOLBA' => 'Столвица/Солбица дијалект',
 			'TARASK' => 'Тараскијевичка ортографија',
 			'UCCOR' => 'Уједињена ортографија',
 			'UCRCOR' => 'Уједињена ревидирана ортографија',
 			'VALENCIA' => 'Валенцијска',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Календар',
 			'colalternate' => 'Сортирање уз игнорисање симбола',
 			'colbackwards' => 'Сортирање према обрнутим акцентима',
 			'colcasefirst' => 'Ређање према малом/великом слову',
 			'colcaselevel' => 'Сортирање према малом/великом слову',
 			'colhiraganaquaternary' => 'Сортирање према кана симболима',
 			'collation' => 'Сортирање',
 			'colnormalization' => 'Нормализовано сортирање',
 			'colnumeric' => 'Нумеричко сортирање',
 			'colstrength' => 'Сортирање према јачини',
 			'currency' => 'Валута',
 			'numbers' => 'Бројеви',
 			'timezone' => 'Временска зона',
 			'va' => 'Варијанта локалитета',
 			'variabletop' => 'Сортирај као симболе',
 			'x' => 'Приватна употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будистички календар},
 				'chinese' => q{Кинески календар},
 				'coptic' => q{коптски календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{етиопски амет алем календар},
 				'gregorian' => q{Грегоријански календар},
 				'hebrew' => q{Хебрејски календар},
 				'indian' => q{Индијски национални календар},
 				'islamic' => q{Исламски календар},
 				'islamic-civil' => q{Исламски цивилни календар},
 				'japanese' => q{Јапански календар},
 				'persian' => q{персијски календар},
 				'roc' => q{Календар Републике Кине},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{Сортирај симболе},
 				'shifted' => q{Сортирање уз игнорисање симбола},
 			},
 			'colbackwards' => {
 				'no' => q{Сортирај акценте нормално},
 				'yes' => q{Сортирај акценте обрнуто},
 			},
 			'colcasefirst' => {
 				'lower' => q{Сортирај прво мала слова},
 				'no' => q{Сортирај нормалан редослед великих и малих слова},
 				'upper' => q{Сортирај прво велика слова},
 			},
 			'colcaselevel' => {
 				'no' => q{Сортирај без обзира на велика и мала слова},
 				'yes' => q{Сортирај мала и велика слова},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{Сортирај кана симболе одвојено},
 				'yes' => q{Сортирај кана симболе другачије},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'dictionary' => q{Редослед сортирања у речнику},
 				'ducet' => q{Подразумевани Unicode редослед сортирања},
 				'gb2312han' => q{Поједностављено кинеско сортирање},
 				'phonebook' => q{Сортирање као телефонски именик},
 				'phonetic' => q{Фонетски редослед сортирања},
 				'pinyin' => q{Пињин сортирање},
 				'reformed' => q{Реформисани редослед сортирања},
 				'search' => q{Опште намењена претрага},
 				'searchjl' => q{Претрага према хангул почетном сугласнику},
 				'standard' => q{стандардни редослед сортирања},
 				'stroke' => q{Сортирање по броју црта},
 				'traditional' => q{Традиционално сортирање},
 				'unihan' => q{Редослед сортирања радикалним цртицама},
 			},
 			'colnormalization' => {
 				'no' => q{Сортирај без нормализације},
 				'yes' => q{Сортирај Unicode нормализовано},
 			},
 			'colnumeric' => {
 				'no' => q{Сортирај цифре појединачно},
 				'yes' => q{Сортирај цифре нумерички},
 			},
 			'colstrength' => {
 				'identical' => q{Сортирај све},
 				'primary' => q{Сортирај само основна слова},
 				'quaternary' => q{Сортирај акценте/мала и велика слова/ширину/кана симболе},
 				'secondary' => q{Сортирај акценте},
 				'tertiary' => q{Сортирај акценте/мала и велика слова/ширину},
 			},
 			'numbers' => {
 				'arab' => q{арапско-индијске цифре},
 				'arabext' => q{продужене арапско-индијске цифре},
 				'armn' => q{јерменски бројеви},
 				'armnlow' => q{мали јерменски бројеви},
 				'beng' => q{бенгалске цифре},
 				'deva' => q{девангари цифре},
 				'ethi' => q{етиопски бројеви},
 				'finance' => q{Финансијски бројеви},
 				'fullwide' => q{цифре пуне ширине},
 				'geor' => q{грузијски бројеви},
 				'grek' => q{грчки бројеви},
 				'greklow' => q{мали грчки бројеви},
 				'gujr' => q{гуџаратске цифре},
 				'guru' => q{гурмуки цифре},
 				'hanidec' => q{кинески децимални бројеви},
 				'hans' => q{поједностављени кинески бројеви},
 				'hansfin' => q{поједностављени кинески финансијски бројеви},
 				'hant' => q{традиционални кинески бројеви},
 				'hantfin' => q{традиционални кинески финансијски бројеви},
 				'hebr' => q{хебрејски бројеви},
 				'jpan' => q{јапански бројеви},
 				'jpanfin' => q{јапански финансијски бројеви},
 				'khmr' => q{кмерске цифре},
 				'knda' => q{канада цифре},
 				'laoo' => q{лаошке цифре},
 				'latn' => q{западне цифре},
 				'mlym' => q{малајалам цифре},
 				'mong' => q{монголске цифре},
 				'mymr' => q{мијанмарске цифре},
 				'native' => q{Локалне цифре},
 				'orya' => q{орија цифре},
 				'roman' => q{римски бројеви},
 				'romanlow' => q{мали римски бројеви},
 				'taml' => q{тамилски бројеви},
 				'tamldec' => q{тамилске цифре},
 				'telu' => q{телугу цифре},
 				'thai' => q{тајске цифре},
 				'tibt' => q{тибетанске цифре},
 				'traditional' => q{Традиционални бројеви},
 				'vaii' => q{Ваи цифре},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрички},
 			'UK' => q{империјални},
 			'US' => q{САД},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'БГН (BGN)',
 			'numeric' => 'Нумеричка',
 			'tone' => 'Тон',
 			'ungegn' => 'УНГЕГН (BGN)',
 			'x-accents' => 'Акценти',
 			'x-fullwidth' => 'пуна ширина',
 			'x-halfwidth' => 'пола ширине',
 			'x-jamo' => 'Џамо',
 			'x-pinyin' => 'Пинјин',
 			'x-publishing' => 'Издавачки',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Језик: {0}',
 			'script' => 'Скрипт: {0}',
 			'territory' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ё й щ ъ ы ь э ю я])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{(?^u:[а б в г д ђ е ж з и ј к л љ м н њ о п р с т ћ у ф х ц ч џ ш])},
			punctuation => qr{(?^u:[\- ‐ – , ; \: ! ? . … ‘ ‚ “ „ ( ) \[ \] \{ \} * #])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‚},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'few' => q({0} акера),
						'one' => q({0} акер),
						'other' => q({0} акера),
					},
					'arc-minute' => {
						'few' => q({0} минута),
						'one' => q({0} минут),
						'other' => q({0} минута),
					},
					'arc-second' => {
						'few' => q({0} секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'celsius' => {
						'few' => q({0} степена Целзијуса),
						'one' => q({0} степен Целзијуса),
						'other' => q({0} степени Целзијуса),
					},
					'centimeter' => {
						'few' => q({0} центиментра),
						'one' => q({0} центиметар),
						'other' => q({0} центиметара),
					},
					'cubic-kilometer' => {
						'few' => q({0} кубна километра),
						'one' => q({0} кубни километар),
						'other' => q({0} кубних километара),
					},
					'cubic-mile' => {
						'few' => q({0} кубне миље),
						'one' => q({0} кубни миља),
						'other' => q({0} кубних миља),
					},
					'day' => {
						'few' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дана),
					},
					'degree' => {
						'few' => q({0} степена),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					'fahrenheit' => {
						'few' => q({0} степена Фаренхајта),
						'one' => q({0} степен Фаренхајта),
						'other' => q({0} степени Фаренхајта),
					},
					'foot' => {
						'few' => q({0} стопе),
						'one' => q({0} стопа),
						'other' => q({0} стопа),
					},
					'g-force' => {
						'few' => q({0} ге сила),
						'one' => q({0} ге сила),
						'other' => q({0} ге сила),
					},
					'gram' => {
						'few' => q({0} грама),
						'one' => q({0} грам),
						'other' => q({0} грама),
					},
					'hectare' => {
						'few' => q({0} хектара),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					'hectopascal' => {
						'few' => q({0} хектопаскала),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					'horsepower' => {
						'few' => q({0} коњске снаге),
						'one' => q({0} коњска снага),
						'other' => q({0} коњских снага),
					},
					'hour' => {
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'few' => q({0} инча живиног стуба),
						'one' => q({0} инч живиног стуба),
						'other' => q({0} инча живиног стуба),
					},
					'kilogram' => {
						'few' => q({0} килограма),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
					},
					'kilometer' => {
						'few' => q({0} километра),
						'one' => q({0} километар),
						'other' => q({0} километара),
					},
					'kilometer-per-hour' => {
						'few' => q({0} километра на сат),
						'one' => q({0} километар на сат),
						'other' => q({0} километара на сат),
					},
					'kilowatt' => {
						'few' => q({0} киловата),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					'light-year' => {
						'few' => q({0} светлосне године),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосних година),
					},
					'liter' => {
						'few' => q({0} литра),
						'one' => q({0} литар),
						'other' => q({0} литара),
					},
					'meter' => {
						'few' => q({0} метра),
						'one' => q({0} метар),
						'other' => q({0} метара),
					},
					'meter-per-second' => {
						'few' => q({0} метра у секунди),
						'one' => q({0} метар у секунди),
						'other' => q({0} метара у секунди),
					},
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-hour' => {
						'few' => q({0} миље на сат),
						'one' => q({0} миља на сат),
						'other' => q({0} миља на сат),
					},
					'millibar' => {
						'few' => q({0} милибара),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					'millimeter' => {
						'few' => q({0} милиметра),
						'one' => q({0} милиметар),
						'other' => q({0} милиметара),
					},
					'millisecond' => {
						'few' => q({0} милисекунде),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'minute' => {
						'few' => q({0} минута),
						'one' => q({0} минут),
						'other' => q({0} минута),
					},
					'month' => {
						'few' => q({0} месеца),
						'one' => q({0} месец),
						'other' => q({0} месеци),
					},
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} пикометра),
						'one' => q({0} пикометар),
						'other' => q({0} пикометара),
					},
					'pound' => {
						'few' => q({0} фунте),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'second' => {
						'few' => q({0} секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'square-foot' => {
						'few' => q({0} квадратне стопе),
						'one' => q({0} квадратна стопа),
						'other' => q({0} квадратних стопа),
					},
					'square-kilometer' => {
						'few' => q({0} квадратна километра),
						'one' => q({0} квадратни километар),
						'other' => q({0} квадратних километара),
					},
					'square-meter' => {
						'few' => q({0} квадратна метра),
						'one' => q({0} квадратни метар),
						'other' => q({0} квадратних метара),
					},
					'square-mile' => {
						'few' => q({0} квадратне миље),
						'one' => q({0} квадратна миља),
						'other' => q({0} квадратних миља),
					},
					'watt' => {
						'few' => q({0} вата),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'few' => q({0} недеље),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
					},
					'yard' => {
						'few' => q({0} јарда),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'few' => q({0} године),
						'one' => q({0} година),
						'other' => q({0} година),
					},
				},
				'narrow' => {
					'acre' => {
						'few' => q({0} ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'few' => q({0} д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'degree' => {
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'few' => q({0} ст),
						'one' => q({0} ст),
						'other' => q({0} ст),
					},
					'g-force' => {
						'few' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'few' => q({0} g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'few' => q({0} km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'few' => q({0} сг),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'few' => q({0} l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'few' => q({0} m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'month' => {
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'few' => q({0} lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
					},
					'second' => {
						'few' => q({0} сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'few' => q({0} W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'few' => q({0} н),
						'one' => q({0} н),
						'other' => q({0} н),
					},
					'yard' => {
						'few' => q({0} јрд),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'few' => q({0} г),
						'one' => q({0} г),
						'other' => q({0} г),
					},
				},
				'short' => {
					'acre' => {
						'few' => q({0} ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'few' => q({0}°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'few' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дана),
					},
					'degree' => {
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'few' => q({0} ст),
						'one' => q({0} ст),
						'other' => q({0} ст),
					},
					'g-force' => {
						'few' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'few' => q({0} g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'few' => q({0} km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'few' => q({0} сг),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'few' => q({0} l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'few' => q({0} m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'few' => q({0} мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'few' => q({0} мес),
						'one' => q({0} мес),
						'other' => q({0} мес),
					},
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'few' => q({0} lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
					},
					'second' => {
						'few' => q({0} сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'few' => q({0} W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'few' => q({0} нед),
						'one' => q({0} нед),
						'other' => q({0} нед),
					},
					'yard' => {
						'few' => q({0} јрд),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'few' => q({0} год),
						'one' => q({0} год),
						'other' => q({0} год),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'few' => '0',
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'few' => '00K',
					'one' => '00 хиљ',
					'other' => '00 хиљ',
				},
				'100000' => {
					'few' => '000K',
					'one' => '000 хиљ',
					'other' => '000 хиљ',
				},
				'1000000' => {
					'few' => '0 мил',
					'one' => '0 мил',
					'other' => '0 мил',
				},
				'10000000' => {
					'few' => '00 мил',
					'one' => '00 мил',
					'other' => '00 мил',
				},
				'100000000' => {
					'few' => '000 мил',
					'one' => '000 мил',
					'other' => '000 мил',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 бил',
					'one' => '0 бил',
					'other' => '0 бил',
				},
				'10000000000000' => {
					'few' => '00 бил',
					'one' => '00 бил',
					'other' => '00 бил',
				},
				'100000000000000' => {
					'few' => '000 бил',
					'one' => '000 бил',
					'other' => '000 бил',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 хиљаде',
					'one' => '0 хиљада',
					'other' => '0 хиљада',
				},
				'10000' => {
					'few' => '00 хиљаде',
					'one' => '00 хиљада',
					'other' => '00 хиљада',
				},
				'100000' => {
					'few' => '000 хиљаде',
					'one' => '000 хиљада',
					'other' => '000 хиљада',
				},
				'1000000' => {
					'few' => '0 милиона',
					'one' => '0 милион',
					'other' => '0 милиона',
				},
				'10000000' => {
					'few' => '00 милиона',
					'one' => '00 милион',
					'other' => '00 милиона',
				},
				'100000000' => {
					'few' => '000 милиона',
					'one' => '000 милион',
					'other' => '000 милиона',
				},
				'1000000000' => {
					'few' => '0 милијарде',
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'few' => '00 милијарде',
					'one' => '00 милијарда',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'few' => '000 милијарде',
					'one' => '000 милијарда',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'few' => '0 трилиона',
					'one' => '0 трилион',
					'other' => '0 трилиона',
				},
				'10000000000000' => {
					'few' => '00 трилиона',
					'one' => '00 трилион',
					'other' => '00 трилиона',
				},
				'100000000000000' => {
					'few' => '000 трилиона',
					'one' => '000 трилион',
					'other' => '000 трилиона',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0',
					'one' => '0',
					'other' => '0',
				},
				'10000' => {
					'few' => '00K',
					'one' => '00 хиљ',
					'other' => '00 хиљ',
				},
				'100000' => {
					'few' => '000K',
					'one' => '000 хиљ',
					'other' => '000 хиљ',
				},
				'1000000' => {
					'few' => '0 мил',
					'one' => '0 мил',
					'other' => '0 мил',
				},
				'10000000' => {
					'few' => '00 мил',
					'one' => '00 мил',
					'other' => '00 мил',
				},
				'100000000' => {
					'few' => '000 мил',
					'one' => '000 мил',
					'other' => '000 мил',
				},
				'1000000000' => {
					'few' => '0 млрд',
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'few' => '00 млрд',
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'few' => '000 млрд',
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'few' => '0 бил',
					'one' => '0 бил',
					'other' => '0 бил',
				},
				'10000000000000' => {
					'few' => '00 бил',
					'one' => '00 бил',
					'other' => '00 бил',
				},
				'100000000000000' => {
					'few' => '000 бил',
					'one' => '000 бил',
					'other' => '000 бил',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00 ¤)',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска пезета),
				'few' => q(андорске пезете),
				'one' => q(андорска пезета),
				'other' => q(андорске пезете),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(Уједињени арапски емирати дирхам),
				'few' => q(УАЕ дирама),
				'one' => q(УАЕ дирам),
				'other' => q(УАЕ дирама),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авганистански авгани \(1927–2002\)),
				'few' => q(авганистанска авгана \(1927–2002\)),
				'one' => q(aвганистански авгани \(1927–2002\)),
				'other' => q(авганистанских авгана \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Авганистански авгани),
				'few' => q(авганистанска авгана),
				'one' => q(aвганистански авгани),
				'other' => q(авганистанских авгана),
			},
		},
		'ALK' => {
			display_name => {
				'few' => q(стара албанска лека),
				'one' => q(стари албански лек),
				'other' => q(старих албанских лека),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албански лек),
				'few' => q(албанске леке),
				'one' => q(албански лек),
				'other' => q(албанских лека),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Јерменски драм),
				'few' => q(јерменска драма),
				'one' => q(јерменски драм),
				'other' => q(јерменска драма),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Холандски антили гилдер),
				'few' => q(холандска антила),
				'one' => q(холандско-антилски гилдер),
				'other' => q(холандско-антилских гилдера),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Анголијска кванза),
				'few' => q(анголијске кванзе),
				'one' => q(анголијска кванза),
				'other' => q(анголијских кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголијска кванза \(1977–1990\)),
				'few' => q(анголијске кванзе \(1977–1990\)),
				'one' => q(анголијска кванза \(1977–1990\)),
				'other' => q(анголијских кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголијска нова кванза \(1990–2000\)),
				'few' => q(анголијске нове кванзе),
				'one' => q(анголијска нова кванза),
				'other' => q(анголијских нових кванзи),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголијска кванза реађустадо \(1995–1999\)),
				'few' => q(анголијске кванзе реађустадо \(1995–1999\)),
				'one' => q(анголијска кванза реађустадо \(1995–1999\)),
				'other' => q(анголијских кванзи реађустадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентински аустрал),
				'few' => q(аргентинска аустрала),
				'one' => q(аргентински аустрал),
				'other' => q(аргентинских аустрала),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(Аргентински пезос леј),
				'few' => q(аргентинска пезос леја),
				'one' => q(аргентински пезос леј),
				'other' => q(аргентинских пезос леја),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(Аргентински пезос монедо национал),
				'few' => q(аргентинска пезос монеда национал),
				'one' => q(аргентински пезос монедо национал),
				'other' => q(аргентинских пезос монеда национала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински пезо \(1983–1985\)),
				'few' => q(аргентинска пезоса \(1983–1985\)),
				'one' => q(аргентински пезо \(1983–1985\)),
				'other' => q(аргентинских пезоса \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентински пезо),
				'few' => q(аргентинска пезоса),
				'one' => q(аргентински пезос),
				'other' => q(аргентинских пезоса),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Аустријски шилинг),
				'few' => q(аустријска шилинга),
				'one' => q(аустријски шилинг),
				'other' => q(аустријских шилинга),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(Аустралијски долар),
				'few' => q(Аустралијска долара),
				'one' => q(аустралијски долар),
				'other' => q(аустралијских долара),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Арубански флорин),
				'few' => q(арубанска флорина),
				'one' => q(арубански флорин),
				'other' => q(арубанских флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербејџански манат \(1993–2006\)),
				'few' => q(азербејџанска маната \(1993–2006\)),
				'one' => q(азербејџански манат \(1993–2006\)),
				'other' => q(азербејџанских маната \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербејџански манат),
				'few' => q(азербејџанска маната),
				'one' => q(азербејџански манат),
				'other' => q(азербејџанских маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговачки динар),
				'few' => q(босанско-херцеговачка динара),
				'one' => q(босанско-херцеговачки динар),
				'other' => q(босанско-херцеговачких динара),
			},
		},
		'BAM' => {
			symbol => 'КМ',
			display_name => {
				'currency' => q(Конвертибилна марка),
				'few' => q(босанско-херцеговачке конвертибилне маркe),
				'one' => q(босанско-херцеговачка конвертибилна марка),
				'other' => q(босанско-херцеговачких конвертибилних марака),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(Босанско-херцеговачки нови динар),
				'few' => q(босанско-херцеговачка нова динара),
				'one' => q(босанско-херцеговачки нови динар),
				'other' => q(босанско-херцеговачких нових динара),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадошки долар),
				'few' => q(барбадошка долара),
				'one' => q(барбадошки долар),
				'other' => q(барбадошких долара),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладешка така),
				'few' => q(бангладешке таке),
				'one' => q(бангладешка така),
				'other' => q(бангладешких така),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгијски франак \(конвертибилни\)),
				'few' => q(белгијска франка \(конвертибилна\)),
				'one' => q(белгијски франак \(конвертибилни\)),
				'other' => q(белгијских франака \(конвертибилних\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгијски франак),
				'few' => q(белгијска франка),
				'one' => q(белгијски франак),
				'other' => q(белгијских франака),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгијски франак \(финансијски\)),
				'few' => q(белгијска франка \(финансијска\)),
				'one' => q(белгијски франак \(финансијски\)),
				'other' => q(белгијских франака \(финансијских\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски тврди лев),
				'few' => q(бугарска тврда лева),
				'one' => q(бугарски тврди лев),
				'other' => q(бугарских тврдих лева),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(Бугарски социјалистички лев),
				'few' => q(бугарска социјалистичка лева),
				'one' => q(бугарски социјалистички лев),
				'other' => q(бугарских социјалистичких лева),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Бугарски лев),
				'few' => q(бугарска лева),
				'one' => q(бугарски лев),
				'other' => q(бугарских лева),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(Стари бугарски лев),
				'few' => q(стара бугарска лева),
				'one' => q(стари бугарски лев),
				'other' => q(старих бугарских лева),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахреински динар),
				'few' => q(бахреинскa динара),
				'one' => q(бахреински динар),
				'other' => q(бахреинских динара),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурундски франак),
				'few' => q(бурундска франка),
				'one' => q(бурундски франак),
				'other' => q(бурундских франакa),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермудски долар),
				'few' => q(бермудска долара),
				'one' => q(бермудски долар),
				'other' => q(бермудских долара),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Брунејски долар),
				'few' => q(брунејска долара),
				'one' => q(брунејски долар),
				'other' => q(брунејских долара),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливијски Боливиано),
				'few' => q(боливијска боливиана),
				'one' => q(боливијски боливиано),
				'other' => q(боливијских боливиана),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(Стари боливијски боливијано),
				'few' => q(стара боливијска боливијана),
				'one' => q(стари боливијски боливијано),
				'other' => q(старих боливијских боливијана),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливијски пезо),
				'few' => q(боливијска пезоса),
				'one' => q(боливијски пезо),
				'other' => q(боливијских пезоса),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливијски мвдол),
				'few' => q(боливијска мвдола),
				'one' => q(боливијски мвдол),
				'other' => q(боливијских мвдола),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилски нови крузеиро \(1967–1986\)),
				'few' => q(бразилска нова крузеира \(1967–1986\)),
				'one' => q(бразилски нови крузеиро \(1967–1986\)),
				'other' => q(бразилских нових крузеира \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилијски крузадо),
				'few' => q(бразилска крузадоса),
				'one' => q(бразилски крузадос),
				'other' => q(бразилских крузадоса),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилски крузеиро \(1990–1993\)),
				'few' => q(бразилска крузеира \(1990–1993\)),
				'one' => q(бразилски крузеиро \(1990–1993\)),
				'other' => q(бразилских крузеира \(1990–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразилски Реал),
				'few' => q(бразилска реала),
				'one' => q(бразилски реал),
				'other' => q(бразилских реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилијски нови крузадо),
				'few' => q(бразилска нова крузада),
				'one' => q(бразилски нови крузадо),
				'other' => q(бразилских нових крузада),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилски крузеиро),
				'few' => q(бразилска крузеира),
				'one' => q(бразилски крузеиро),
				'other' => q(бразилских крузеира),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(Стари бразилски крузеиро),
				'few' => q(стара бразилска крузеира),
				'one' => q(стари бразилски крузеиро),
				'other' => q(старих бразилских крузеира),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Бахамски долар),
				'few' => q(бахамска долара),
				'one' => q(бахамски долар),
				'other' => q(бахамских долара),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутански нгултрум),
				'few' => q(бутанска нгултрума),
				'one' => q(бутански нгултрум),
				'other' => q(бутанских нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бурмански кјат),
				'few' => q(бурманска кјата),
				'one' => q(бурмански кјат),
				'other' => q(бурманских кјата),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Боцванска пула),
				'few' => q(боцванске пуле),
				'one' => q(боцванска пула),
				'other' => q(боцванских пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
				'few' => q(белоруске нове рубља \(1994–1999\)),
				'one' => q(белоруска нова рубља \(1994–1999\)),
				'other' => q(белоруских нових рубљи \(1994–1999\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белоруска рубља),
				'few' => q(белоруске рубље),
				'one' => q(белоруска рубља),
				'other' => q(белоруских рубљи),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белизе долар),
				'few' => q(белизеанска долара),
				'one' => q(белизеански долар),
				'other' => q(белизеанских долара),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канадски долар),
				'few' => q(канадска долара),
				'one' => q(канадски долар),
				'other' => q(канадских долара),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конголски франак),
				'few' => q(конголска франка),
				'one' => q(конголски франак),
				'other' => q(конголских франака),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'few' => q(WIR евра),
				'one' => q(WIR евро),
				'other' => q(WIR евра),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швајцарски франак),
				'few' => q(швајцарска франка),
				'one' => q(швајцарски франак),
				'other' => q(швајцарских франака),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франак),
				'few' => q(WIR франка),
				'one' => q(WIR франак),
				'other' => q(WIR франака),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(Чилеански ескудо),
				'few' => q(чилеанска ескуда),
				'one' => q(чилеански ескудо),
				'other' => q(чилеанских ескуда),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чилеовски унидадес се фоменто),
				'few' => q(чилеанска унидадес де фомента),
				'one' => q(чилеански унидадес де фоменто),
				'other' => q(чилеански унидадеси де фоменто),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чилеански пезо),
				'few' => q(чилеанска пезоса),
				'one' => q(чилеански пезо),
				'other' => q(чилеански пезоси),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Долар кинеске народне банке),
				'few' => q(долара кинеске народне банке),
				'one' => q(долар кинеске народне банке),
				'other' => q(долара кинеске народне банке),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Кинески јуан ренминби),
				'few' => q(кинеска јуан),
				'one' => q(кинески јуан),
				'other' => q(кинеских јуана),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбијски пезо),
				'few' => q(колумбијска пезоса),
				'one' => q(колумбијски пезо),
				'other' => q(колумбијских пезоса),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Унидад де валоршки реал),
				'few' => q(нидад де валор реала),
				'one' => q(унидад де валоршки реал),
				'other' => q(унидад де валоршких реала),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Костарикански колон),
				'few' => q(костариканска колона),
				'one' => q(костарикански колон),
				'other' => q(костарикански колони),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стари српски динар),
				'few' => q(стара српска динара),
				'one' => q(стари српски динар),
				'other' => q(старих српских динара),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка тврда круна),
				'few' => q(чехословачке тврде круне),
				'one' => q(чехословачка тврда круна),
				'other' => q(чехословачких тврдих круна),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Кубански конвертибилни песо),
				'few' => q(кубанскa конвертибилнa пезосa),
				'one' => q(кубански конвертибилни песо),
				'other' => q(кубански конвертибилни пезос),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Кубански пезо),
				'few' => q(кубанска пезоса),
				'one' => q(кубански пезос),
				'other' => q(кубанских пезоса),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Зеленортски ескудо),
				'few' => q(зеленортска ескуда),
				'one' => q(зеленортски ескудо),
				'other' => q(зеленортских ескуда),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
				'few' => q(кипарске фунте),
				'one' => q(кипарска фунта),
				'other' => q(кипарских фунти),
			},
		},
		'CZK' => {
			symbol => 'Кч',
			display_name => {
				'currency' => q(Чешка круна),
				'few' => q(чешке круне),
				'one' => q(чешка круна),
				'other' => q(чешких крунa),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Источно-немачка марка),
				'few' => q(источно-немачке марке),
				'one' => q(источно-немачка марка),
				'other' => q(источно-немачких марака),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Немачка марка),
				'few' => q(немачке марке),
				'one' => q(немачка марка),
				'other' => q(немачких марака),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Џибутански франак),
				'few' => q(џибутанскa франкa),
				'one' => q(џибутански франак),
				'other' => q(џибутанских франакa),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Данска круна),
				'few' => q(данске круне),
				'one' => q(данска круна),
				'other' => q(данских круна),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикански пезо),
				'few' => q(доминиканска пезоса),
				'one' => q(доминикански пезо),
				'other' => q(доминиканских пезоса),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжирски динар),
				'few' => q(алжирска динара),
				'one' => q(алжирски динар),
				'other' => q(алжирских динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорски сакр),
				'few' => q(еквадорска сакра),
				'one' => q(еквадорски сакр),
				'other' => q(еквадорских сакра),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорски унидад де валор константе),
				'few' => q(еквадорска унидад де валор константа),
				'one' => q(еквадорски унидад де валор константе),
				'other' => q(еквадорских унидад де валор константа),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска кроон),
				'few' => q(естонске круне),
				'one' => q(естонска круна),
				'other' => q(естонских круна),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египатска фунта),
				'few' => q(египатске фунте),
				'one' => q(египатска фунта),
				'other' => q(египатских фунти),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Eритрејска накфa),
				'few' => q(еритрејске накфе),
				'one' => q(еритрејска накфа),
				'other' => q(еритрејских накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Шпанска пезета \(рачун\)),
				'few' => q(шпанске пезете \(А рачун\)),
				'one' => q(шпанска пезета \(А рачун\)),
				'other' => q(шпанских пезета \(А рачун\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Шпанска пезета \(конвертибилнирачун\)),
				'few' => q(шпанске пезете \(конвертибилан рачун\)),
				'one' => q(шпанска пезета \(конвертибилан рачун\)),
				'other' => q(шпанских пезета \(конвертибилан рачун\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска пезета),
				'few' => q(шпанска пезета),
				'one' => q(шпанска пезета),
				'other' => q(шпанске пезете),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Етиопијски бир),
				'few' => q(етиопијска бира),
				'one' => q(етиопијски бир),
				'other' => q(етиопијских бира),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'few' => q(евра),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
				'few' => q(финске марке),
				'one' => q(финска марка),
				'other' => q(финских марака),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиџи долар),
				'few' => q(фиџи долара),
				'one' => q(фиџи долар),
				'other' => q(фиџи долара),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фокландска острва фунта),
				'few' => q(фолкландске фунте),
				'one' => q(фолкландска фунта),
				'other' => q(фолкландских фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франак),
				'few' => q(француска франка),
				'one' => q(француски франак),
				'other' => q(француских франака),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Британска фунта стерлинга),
				'few' => q(британске фунте стерлинга),
				'one' => q(британска фунта стерлинга),
				'other' => q(британских фунти стерлинга),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузијски купон ларит),
				'few' => q(грузијска купон ларита),
				'one' => q(грузијски купон ларит),
				'other' => q(грузијских купон ларита),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузијски лари),
				'few' => q(грузијска лариса),
				'one' => q(грузијски ларис),
				'other' => q(грузијских лариса),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гански цеди \(1979–2007\)),
				'few' => q(ганска цеда \(1979–2007\)),
				'one' => q(гански цед \(1979–2007\)),
				'other' => q(ганских цеда \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гански цеди),
				'few' => q(ганска цеда),
				'one' => q(гански цед),
				'other' => q(ганских цеда),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'few' => q(гибралтарске фунте),
				'one' => q(гибралтарска фунта),
				'other' => q(гибралтарских фунти),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбијски даласи),
				'few' => q(гамбијска даласа),
				'one' => q(гамбијски далас),
				'other' => q(гамбијских даласа),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинејски франак),
				'few' => q(гвинејска франка),
				'one' => q(гвинејски франак),
				'other' => q(гвинејских франака),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинејски сили),
				'few' => q(гвинејска сила),
				'one' => q(гвинејски сили),
				'other' => q(гвинејских сила),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваторијално-гвинејски еквеле),
				'few' => q(екваторијално-гвинејска еквела),
				'one' => q(екваторијално-гвинејски еквеле),
				'other' => q(екваторијално-гвинејских еквела),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
				'few' => q(грчке драхме),
				'one' => q(грчка драхма),
				'other' => q(грчких драхми),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемалски квецал),
				'few' => q(гватемалска квецала),
				'one' => q(гватемалски квецал),
				'other' => q(гватемалских квецала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Португалска гвинеја ескудо),
				'few' => q(португалско-гвинејска ескуда),
				'one' => q(португалско-гвинејски ескудо),
				'other' => q(португалско-гвинејских ескуда),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинеја Бисао Пезо),
				'few' => q(гвинеја-бисаошка пезоса),
				'one' => q(гвинеја-бисаошки пезо),
				'other' => q(гвинеја-бисаошких пезоса),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гујански долар),
				'few' => q(гвајанска долара),
				'one' => q(гвајански долар),
				'other' => q(гвајанских долара),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'few' => q(хонгконшка долара),
				'one' => q(хонгконшки долар),
				'other' => q(хонгконшких долара),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Хондурашка лемпира),
				'few' => q(хондурашка лемпира),
				'one' => q(хондурашки лемпир),
				'other' => q(хондурашких лемпира),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
				'few' => q(хрватска динара),
				'one' => q(хрватски динар),
				'other' => q(хрватских динара),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хрватска куна),
				'few' => q(хрватске куне),
				'one' => q(хрватска куна),
				'other' => q(хрватских куна),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Хаићански гурд),
				'few' => q(хаићанска гурда),
				'one' => q(хаићански гурд),
				'other' => q(хаићанских гурда),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Мађарска форинта),
				'few' => q(мађарске форинте),
				'one' => q(мађарска форинта),
				'other' => q(мађарских форинти),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонежанска рупија),
				'few' => q(индонежанске рупије),
				'one' => q(индонежанска рупија),
				'other' => q(индонежанских рупијa),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
				'few' => q(ирске фунте),
				'one' => q(ирска фунта),
				'other' => q(ирских фунти),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска фунта),
				'few' => q(израелске фунте),
				'one' => q(израелска фунта),
				'other' => q(израелских фунти),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Стари израелски шекели),
				'few' => q(стари израелски шекели),
				'one' => q(стари израелски шекели),
				'other' => q(стари израелски шекели),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Израелски нови шекел),
				'few' => q(израелска нова шекела),
				'one' => q(израелски нови шекел),
				'other' => q(израелских нових шекела),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Индијска рупија),
				'few' => q(индијске рупије),
				'one' => q(индијска рупија),
				'other' => q(индијских рупија),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирачки динар),
				'few' => q(ирачка динара),
				'one' => q(ирачки динар),
				'other' => q(ирачких динара),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Ирански риjал),
				'few' => q(иранска ријала),
				'one' => q(ирански ријал),
				'other' => q(иранских ријала),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(Стара исландска круна),
				'few' => q(стара исландска круна),
				'one' => q(стара исландска круна),
				'other' => q(стара исландска круна),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландска круна),
				'few' => q(исландске круне),
				'one' => q(исландска круна),
				'other' => q(исландских круна),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
				'few' => q(италијанске лире),
				'one' => q(италијанска лира),
				'other' => q(италијанске лире),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Јамајкански долар),
				'few' => q(jамајканскa доларa),
				'one' => q(jамајкански долар),
				'other' => q(jамајканскиx доларa),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Јордански динар),
				'few' => q(јорданскa динара),
				'one' => q(јордански динар),
				'other' => q(јорданских динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(Јапански јен),
				'few' => q(јапанска јена),
				'one' => q(јапански јен),
				'other' => q(јапанских јена),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кенијски шилинг),
				'few' => q(кенијска шилинга),
				'one' => q(кенијски шилинг),
				'other' => q(кенијских шилинга),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Киргистански сом),
				'few' => q(киргистанска сома),
				'one' => q(киргистански сом),
				'other' => q(киргистанских сома),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Kамбоџански ријел),
				'few' => q(камбоџанска ријела),
				'one' => q(камбоџански ријел),
				'other' => q(камбоџанских ријела),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморски франак),
				'few' => q(коморскa франкa),
				'one' => q(коморски франак),
				'other' => q(коморских франакa),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Севернокорејски вон),
				'few' => q(севернокорејска вона),
				'one' => q(севернокорејски вон),
				'other' => q(севернокорејских вона),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(Јужнокорејски хван),
				'few' => q(јужнокорејска хвана),
				'one' => q(јужнокорејски хван),
				'other' => q(јужнокорејских хвана),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(Стари јужнокорејски вон),
				'few' => q(стара јужнокорејска вона),
				'one' => q(стари јужнокорејски вон),
				'other' => q(старих јужнокорејских вона),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(Јужнокорејски Вон),
				'few' => q(јужнокорејска вона),
				'one' => q(јужнокорејски вон),
				'other' => q(јужнокорејских вона),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувајтски динар),
				'few' => q(кувајтскa динара),
				'one' => q(кувајтски динар),
				'other' => q(кувајтских динара),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кајманска острва долар),
				'few' => q(кајманска долара),
				'one' => q(кајмански долар),
				'other' => q(кајманских долара),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казахстански тенџ),
				'few' => q(казахстанске тенџе),
				'one' => q(казахстанска тенџа),
				'other' => q(казахстанских тенџи),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаошки кип),
				'few' => q(лаошка кипа),
				'one' => q(лаошки кип),
				'other' => q(лаошки кипи),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Либанска фунта),
				'few' => q(либанскe фунтe),
				'one' => q(либанскa фунтa),
				'other' => q(либанских фунти),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шриланканскa рупиja),
				'few' => q(шриланканскe рупијe),
				'one' => q(шриланканска рупија),
				'other' => q(шриланканских рупија),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либеријски долар),
				'few' => q(либеријска долара),
				'one' => q(либеријски долар),
				'other' => q(либеријских долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лоти),
				'few' => q(лесотска лотиса),
				'one' => q(лесотски лотис),
				'other' => q(лесотских лотиса),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литвански литас),
				'few' => q(литванска литаса),
				'one' => q(литвански литас),
				'other' => q(литванских литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литвански талонас),
				'few' => q(литванска талонаса),
				'one' => q(литвански талонас),
				'other' => q(литванских талонаса),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Луксембуршки конвертибилни франак),
				'few' => q(луксембуршка конвертибилна франка),
				'one' => q(луксембуршки конвертибилни франак),
				'other' => q(луксембуршких конвертибилних франака),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франак),
				'few' => q(луксембуршка франка),
				'one' => q(луксембуршки франак),
				'other' => q(луксембуршки франци),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Луксембуршки финансијски франак),
				'few' => q(луксембуршка финансијска франка),
				'one' => q(луксембуршки финансијски франак),
				'other' => q(луксембуршких финансијских франака),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвијски лати),
				'few' => q(латвијска лата),
				'one' => q(латвијски лат),
				'other' => q(латвијских лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
				'few' => q(латвијске рубље),
				'one' => q(латвијска рубља),
				'other' => q(латвијских рубљи),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Либијски динар),
				'few' => q(либијскa динарa),
				'one' => q(либијски динар),
				'other' => q(либијских динарa),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокански дирхам),
				'few' => q(мароканске дирхаме),
				'one' => q(мароканска дирхама),
				'other' => q(мароканских дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франак),
				'few' => q(мароканска франка),
				'one' => q(марокански франак),
				'other' => q(мароканских франака),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(Монегаскански франак),
				'few' => q(монегасканска франка),
				'one' => q(монегаскански франак),
				'other' => q(монегасканских франака),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(Молдовански купон),
				'few' => q(молдованска купона),
				'one' => q(молдовански купон),
				'other' => q(молдованских купона),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдавски леј),
				'few' => q(молдaвскa леја),
				'one' => q(молдaвски леј),
				'other' => q(молдaвских леја),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагасијски ариари),
				'few' => q(малагасијскa ариариja),
				'one' => q(малагасијски ариари),
				'other' => q(малагасијских ариариja),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагасијски франак),
				'few' => q(малагашајска франка),
				'one' => q(малагашајски франак),
				'other' => q(малагашајски франци),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Македонски денар),
				'few' => q(македонска денара),
				'one' => q(македонски денар),
				'other' => q(македонских динара),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(Стари македонски денар),
				'few' => q(стара македонска денара),
				'one' => q(стари македонски денар),
				'other' => q(старих македонских денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малијански франак),
				'few' => q(малијска франка),
				'one' => q(малијски франак),
				'other' => q(малијских франака),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мјанмарски кјат),
				'few' => q(мјанмарскa кјатa),
				'one' => q(мјанмарски кјат),
				'other' => q(мјанмарских кјатa),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монголски тугрик),
				'few' => q(монголскa тугрика),
				'one' => q(монголски тугрик),
				'other' => q(монголских тугрика),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Маканишка патака),
				'few' => q(маканешке патаке),
				'one' => q(маканешка патака),
				'other' => q(маканешких патака),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мауританијска oгија),
				'few' => q(мауританијскe oгијe),
				'one' => q(мауританијска oгија),
				'other' => q(мауританијских oгијa),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
				'few' => q(малтешке лире),
				'one' => q(малтешка лира),
				'other' => q(малтешких лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
				'few' => q(малтешке фунте),
				'one' => q(малтешка фунта),
				'other' => q(малтешких фунти),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Маурицијска рупија),
				'few' => q(маурицијскe рупијe),
				'one' => q(маурицијска рупија),
				'other' => q(маурицијских рупија),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Малдивска руфија),
				'few' => q(малдивскe руфијe),
				'one' => q(малдивскa руфија),
				'other' => q(малдивских руфија),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малавијска квача),
				'few' => q(малавијске кваче),
				'one' => q(малавијска квача),
				'other' => q(малавијских квача),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексички пезо),
				'few' => q(мексичка пезоса),
				'one' => q(мексички пезо),
				'other' => q(мексичких пезоса),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексички сребрни пезо \(1861–1992\)),
				'few' => q(мексичка сребрна пезоса),
				'one' => q(мексички сребрни пезо),
				'other' => q(мексичких сребрних пезоса),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексички унидад де инверсион \(UDI\)),
				'few' => q(мексичка унидадс де инверзиона),
				'one' => q(мексички унидадс де инверзион),
				'other' => q(мексичких унидадс де инверзиона),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малезијски ринггит),
				'few' => q(малезијска ринггита),
				'one' => q(малезијски ринггит),
				'other' => q(малезијских ринггита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбијски ескудо),
				'few' => q(мозамбијска ескуда),
				'one' => q(мозамбијски ескудо),
				'other' => q(мозамбијских ескуда),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стари мозамбијски метикал),
				'few' => q(стара мозамбијска метикала),
				'one' => q(стари мозамбијски метикал),
				'other' => q(старих мозамбијских метикала),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбијски метикал),
				'few' => q(мозамбијска метикала),
				'one' => q(мозамбијски метикал),
				'other' => q(мозамбијских метикала),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибијски долар),
				'few' => q(намибијска долара),
				'one' => q(намибијски долар),
				'other' => q(намибијских долара),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигеријска наира),
				'few' => q(нигеријске наире),
				'one' => q(нигеријска наира),
				'other' => q(нигеријских наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'few' => q(никарагванске кордобе),
				'one' => q(никарагванска кордоба),
				'other' => q(никарагванских кордоба),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагванска златна кордоба),
				'few' => q(никарагванске златне кордобе),
				'one' => q(никарагванска златна кордоба),
				'other' => q(никарагванских златних кордоба),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'few' => q(холандска гулдена),
				'one' => q(холандски гулден),
				'other' => q(холандских гулдена),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвешка круна),
				'few' => q(норвешке круне),
				'one' => q(норвешка круна),
				'other' => q(норвешких круна),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непалскa рупиja),
				'few' => q(непалске рупије),
				'one' => q(непалска рупија),
				'other' => q(непалских рупија),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Новозеландски долар),
				'few' => q(новозеландска долара),
				'one' => q(новозеландски долар),
				'other' => q(новозеландских долара),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Омански ријал),
				'few' => q(оманскa ријала),
				'one' => q(омански ријал),
				'other' => q(оманских ријала),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панамска балбоа),
				'few' => q(панамске балбое),
				'one' => q(панамска балбоа),
				'other' => q(панамских балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуански инти),
				'few' => q(перувијска интија),
				'one' => q(перувијски инти),
				'other' => q(перувијских интија),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перуански нуево сол),
				'few' => q(перуанска нуево сола),
				'one' => q(перуански нуево сол),
				'other' => q(перуанских нуево сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
				'few' => q(перуанска сола),
				'one' => q(перуански сол),
				'other' => q(перуанских сола),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуанска кина),
				'few' => q(папуанскe кинe),
				'one' => q(папуанска кина),
				'other' => q(папуанских кинa),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Филипински пезо),
				'few' => q(филипинска пезоса),
				'one' => q(филипински пезо),
				'other' => q(филипинских пезоса),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистанскa рупиja),
				'few' => q(пакистанске рупије),
				'one' => q(пакистанска рупија),
				'other' => q(пакистанских рупија),
			},
		},
		'PLN' => {
			symbol => 'зл',
			display_name => {
				'currency' => q(Пољски злот),
				'few' => q(пољска злота),
				'one' => q(пољски злот),
				'other' => q(пољских злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Пољски злоти \(1950–1995\)),
				'few' => q(пољска злота \(1950–1995\)),
				'one' => q(пољски злот \(1950–1995\)),
				'other' => q(пољских злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалски ескудо),
				'few' => q(португалска ескуда),
				'one' => q(португалски ескудо),
				'other' => q(португалских ескуда),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвајски гуарни),
				'few' => q(парагвајска гваранија),
				'one' => q(парагвајски гвараниј),
				'other' => q(парагвајских гваранија),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катаршки ријал),
				'few' => q(катарска ријала),
				'one' => q(катарски ријал),
				'other' => q(катарских ријала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родејскидолар),
				'few' => q(родежанска долара),
				'one' => q(родежански долар),
				'other' => q(родежанских долара),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Румунски леј),
				'few' => q(румунскa леја),
				'one' => q(румунски леј),
				'other' => q(румунских леја),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Румунски леј \(1952–2006\)),
				'few' => q(румунскa леја \(1952–2006\)),
				'one' => q(румунски леј \(1952–2006\)),
				'other' => q(румунских леја \(1952–2006\)),
			},
		},
		'RSD' => {
			symbol => 'дин.',
			display_name => {
				'currency' => q(Српски динар),
				'few' => q(српска динара),
				'one' => q(српски динар),
				'other' => q(српских динара),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Руска рубља),
				'few' => q(руске рубље),
				'one' => q(руска рубља),
				'other' => q(руских рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
				'few' => q(руске рубље \(1991–1998\)),
				'one' => q(руска рубља \(1991–1998\)),
				'other' => q(руских рубљи \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руандски франак),
				'few' => q(руандскa франка),
				'one' => q(руандски франак),
				'other' => q(руандских франака),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Саудијски ријал),
				'few' => q(саудијска ријала),
				'one' => q(саудијски ријал),
				'other' => q(саудијских ријала),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломонско-острвски долар),
				'few' => q(соломонско-острвска долара),
				'one' => q(соломонско-острвски долар),
				'other' => q(соломонско-острвских долара),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сејшелска рупија),
				'few' => q(сејшелске рупије),
				'one' => q(сејшелска рупија),
				'other' => q(сејшелских рупија),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стари судански динар),
				'few' => q(стара суданска динара),
				'one' => q(стари судански динар),
				'other' => q(старих суданских динара),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Суданска фунта),
				'few' => q(суданске фунте),
				'one' => q(суданска фунта),
				'other' => q(суданских фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
				'few' => q(старе суданске фунте),
				'one' => q(стара суданска фунта),
				'other' => q(старих суданских фунти),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Шведска круна),
				'few' => q(шведске круне),
				'one' => q(шведска круна),
				'other' => q(шведских круна),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапурски долар),
				'few' => q(сингапурска долара),
				'one' => q(сингапурски долар),
				'other' => q(сингапурских долара),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Св. јеленска фунта),
				'few' => q(св. јеленске фунте),
				'one' => q(св. јеленска фунта),
				'other' => q(св. јеленских фунти),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словеначки толар),
				'few' => q(словеначка толара),
				'one' => q(словеначки толар),
				'other' => q(словеначких толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
				'few' => q(словачке круне),
				'one' => q(словачка круна),
				'other' => q(словачких круна),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сијера-леоншки леоне),
				'few' => q(сијералеонска леона),
				'one' => q(сијералеонски леоне),
				'other' => q(сијералеонских леона),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'few' => q(сомалијска шилинга),
				'one' => q(сомалијски шилинг),
				'other' => q(сомалијских шилинга),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринамски долар),
				'few' => q(суринамска долара),
				'one' => q(суринамски долар),
				'other' => q(суринамских долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'few' => q(суринамска гилдера),
				'one' => q(суринамски гилдер),
				'other' => q(суринамских гилдера),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'few' => q(јужносуданскe фунтe),
				'one' => q(јужносуданска фунта),
				'other' => q(јужносуданских фунти),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Сао Томе и Принципе добра),
				'few' => q(сао томе и принципе добра),
				'one' => q(сао томе и принципе добар),
				'other' => q(сао томе и принципе добра),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совјетска рубља),
				'few' => q(совјетске рубље),
				'one' => q(совјетска рубља),
				'other' => q(совјетских рубљи),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
				'few' => q(салвадорска колона),
				'one' => q(салвадорски колон),
				'other' => q(салвадорских колона),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сиријска фунта),
				'few' => q(сиријске фунте),
				'one' => q(сиријска фунта),
				'other' => q(сиријских фунти),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свази лилангени),
				'few' => q(свази емалангена),
				'one' => q(свази емаланген),
				'other' => q(свази емалангена),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Таи бахт),
				'few' => q(таи бахта),
				'one' => q(таи бахт),
				'other' => q(таи бахта),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџихистанска рубља),
				'few' => q(таџихистанске рубље),
				'one' => q(таџихистанска рубља),
				'other' => q(таџихистанских рубљи),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Tаџихистански сомон),
				'few' => q(таџихистанска сомона),
				'one' => q(таџихистански сомон),
				'other' => q(таџихистанских сомона),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат \(1993–2009\)),
				'few' => q(туркменистанска маната \(1993–2009\)),
				'one' => q(туркменистански манат \(1993–2009\)),
				'other' => q(туркменистански манат \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Туркменистански манат),
				'few' => q(туркменистанскa манатa),
				'one' => q(туркменистански манат),
				'other' => q(туркменистанских маната),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Tунежански динар),
				'few' => q(тунежанскa динара),
				'one' => q(тунежански динар),
				'other' => q(тунежанских динара),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонгоншка Панга),
				'few' => q(тонгашке панге),
				'one' => q(тонгашка панга),
				'other' => q(тонгашких панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморшки ескудо),
				'few' => q(тиморшка ескуда),
				'one' => q(тиморшки ескудо),
				'other' => q(тиморшких ескуда),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'few' => q(турске лире \(1922–2005\)),
				'one' => q(турска лира \(1922–2005\)),
				'other' => q(турских лира \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'Тл',
			display_name => {
				'currency' => q(Турска лира),
				'few' => q(турске лире),
				'one' => q(турска лира),
				'other' => q(турских лира),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад тобагошки долар),
				'few' => q(тринидад-тобагошка долара),
				'one' => q(тринидад-тобагошки долар),
				'other' => q(тринидад-тобагошких долара),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Нови тајвански долар),
				'few' => q(нова тајванска долара),
				'one' => q(нови тајвански долар),
				'other' => q(нових тајванских долара),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзанијски шилинг),
				'few' => q(танзанијска шилинга),
				'one' => q(танзанијски шилинг),
				'other' => q(танзанијских шилинга),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украјинска хривња),
				'few' => q(украјинскe хривњe),
				'one' => q(украјинскa хривњa),
				'other' => q(украјинских хривњи),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украјински карбованети),
				'few' => q(украјинска карбованцива),
				'one' => q(украјински карбованец),
				'other' => q(украјинских карбованцива),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандски шилинг \(1966–1987\)),
				'few' => q(угандијска шилинга \(1966–1987\)),
				'one' => q(угандијски шилинг \(1966–1987\)),
				'other' => q(угандијских шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Угандски шилинг),
				'few' => q(угандскa шилинга),
				'one' => q(угандски шилинг),
				'other' => q(угандских шилинга),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(Амерички долар),
				'few' => q(америчка долара),
				'one' => q(амерички долар),
				'other' => q(америчких долара),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(следећи дан\)),
				'few' => q(САД долара \(следећи дан\)),
				'one' => q(САД долар \(следећи дан\)),
				'other' => q(САД долара \(следећи дан\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(исти дан\)),
				'few' => q(САД долара \(исти дан\)),
				'one' => q(САД долар \(исти дан\)),
				'other' => q(САД долара \(исти дан\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвајски пезо ен унидадес индексадас),
				'few' => q(уругвајска пезоса ен унидадес индексадеса),
				'one' => q(уругвајски пезо ен унидадес индексадес),
				'other' => q(угвајских пезоса ен унидадес индексадеса),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезо \(1975–1993\)),
				'few' => q(уругвајска пезоса \(1975–1993\)),
				'one' => q(уругвајски пезо \(1975–1993\)),
				'other' => q(уругвајских пезоса \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвајски пезо),
				'few' => q(уругвајска пезоса),
				'one' => q(уругвајски пезо),
				'other' => q(уругвајских пезоса),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбекистански сом),
				'few' => q(узбекистанска сома),
				'one' => q(узбекистански сом),
				'other' => q(узбекистанских сома),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(1871–2008\)),
				'few' => q(венецуеланска боливара \(1871–2008\)),
				'one' => q(венецуелански боливар \(1871–2008\)),
				'other' => q(венецуеланских боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венецуелански боливар),
				'few' => q(венецуеланска боливара),
				'one' => q(венецуелански боливар),
				'other' => q(венецуеланских боливара),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Вијетнамски донг),
				'few' => q(вијетнамска донга),
				'one' => q(вијетнамски донг),
				'other' => q(вијетнамских донга),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(Вијетнамски донг \(1978–1985\)),
				'few' => q(вијетнамска донга \(1978–1985\)),
				'one' => q(вијетнамски донг \(1978–1985\)),
				'other' => q(вијетнамских донга \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануатски вату),
				'few' => q(вануатскa ватуa),
				'one' => q(вануатски вату),
				'other' => q(вануатских ватуa),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоанска тала),
				'few' => q(самоанске тале),
				'one' => q(самоанска тала),
				'other' => q(самоанских тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA франак BEAC),
				'few' => q(CFA франка BEAC),
				'one' => q(CFA франак BEAC),
				'other' => q(CFA франака BEAC),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
				'few' => q(сребра),
				'one' => q(сребро),
				'other' => q(сребра),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
				'few' => q(злата),
				'one' => q(злато),
				'other' => q(злата),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европска композитна јединица),
				'few' => q(европске композитне јединице),
				'one' => q(европска композитна јединица),
				'other' => q(европских композитних јединица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европска новчана јединица),
				'few' => q(европске новчане јединице \(XBB\)),
				'one' => q(европска новчана јединица \(XBB\)),
				'other' => q(европске новчане јединице \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBC\)),
				'few' => q(европске јединице рачуна \(XBC\)),
				'one' => q(европска јединица рачуна \(XBC\)),
				'other' => q(европских јединица рачуна \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBD\)),
				'few' => q(европске јединице рачуна \(XBD\)),
				'one' => q(европска јединица рачуна \(XBD\)),
				'other' => q(европских јединица рачуна \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Источно-карипски долар),
				'few' => q(источно-карипскa доларa),
				'one' => q(источно-карипски долар),
				'other' => q(источно-карипскиx доларa),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Посебна цртаћа права),
				'few' => q(посебна цртаћа права),
				'one' => q(посебно цртаће право),
				'other' => q(посебних цртаћих права),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европска валутна јединица),
				'few' => q(европске новчане јединице \(XEU\)),
				'one' => q(европска новчана јединица \(XEU\)),
				'other' => q(европских новчаних јединица),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Француски златни франак),
				'few' => q(француска златна франка),
				'one' => q(француски златни франак),
				'other' => q(француских златних франака),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Француски UIC-франак),
				'few' => q(француска UIC-франка),
				'one' => q(француски UIC-франак),
				'other' => q(француских UIC-франака),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA франак BCEAO),
				'few' => q(CFA франка BCEAO),
				'one' => q(CFA франак BCEAO),
				'other' => q(CFA франака BCEAO),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладијум),
				'few' => q(паладијума),
				'one' => q(паладијум),
				'other' => q(паладијума),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP франак),
				'few' => q(CFP франка),
				'one' => q(CFP франак),
				'other' => q(CFP франака),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
				'few' => q(платине),
				'one' => q(платина),
				'other' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд),
				'few' => q(RINET фонда),
				'one' => q(RINET фонд),
				'other' => q(RINET фондова),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код тестиране валуте),
				'few' => q(кода тестиране валуте),
				'one' => q(код тестиране валуте),
				'other' => q(кодова тестиране валуте),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната или неважећа валута),
				'few' => q(непознате или неважеће валуте),
				'one' => q(непозната или неважећа валута),
				'other' => q(непознатих или неважећих валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
				'few' => q(јеменска долара),
				'one' => q(јеменски долар),
				'other' => q(јеменских долара),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Јеменски риjал),
				'few' => q(јеменска ријала),
				'one' => q(јеменски ријал),
				'other' => q(jеменских ријала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски тврди динар),
				'few' => q(југословенска тврда динара),
				'one' => q(југословенски тврди динар),
				'other' => q(југословенских тврдих динара),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Југословенски нови динар),
				'few' => q(југословенска нова динара),
				'one' => q(југословенски нови динар),
				'other' => q(југословенских нових динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилни динар),
				'few' => q(југословенска конвертибилна динара),
				'one' => q(југословенски конвертибилни динар),
				'other' => q(југословенских конвертибилних динара),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(Југословенски реформирани динар),
				'few' => q(југословенска реформирана динара),
				'one' => q(југословенски реформирани динар),
				'other' => q(југословенских реформираних динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд \(финансијски\)),
				'few' => q(јужноафричка ранда \(финансијска\)),
				'one' => q(јужноафрички ранд \(финансијски\)),
				'other' => q(јужноафричких ранда \(финансијских\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд),
				'few' => q(јужно-афричка ранда),
				'one' => q(јужно-афрички ранд),
				'other' => q(јужно-афричких ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
				'few' => q(замбијске кваче \(1968–2012\)),
				'one' => q(замбијска квача \(1968–2012\)),
				'other' => q(замбијских квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбијска квача),
				'few' => q(замбијске кваче),
				'one' => q(замбијска квача),
				'other' => q(замбијских квача),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирски нови заир),
				'few' => q(заирска нова заира),
				'one' => q(заирски нови заир),
				'other' => q(заирских нових заира),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирски заир),
				'few' => q(заирска заира),
				'one' => q(заирски заир),
				'other' => q(заирских заира),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(1980–2008\)),
				'few' => q(зимбабвејска долара \(1980–2008\)),
				'one' => q(зимбабвејски долар \(1980–2008\)),
				'other' => q(зимбабвејских долара \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2009\)),
				'few' => q(зимбабвејска долара \(2009\)),
				'one' => q(зимбабвејски долар \(2009\)),
				'other' => q(зимбабвејских долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2008\)),
				'few' => q(зимбабвејска долара \(2008\)),
				'one' => q(зимбабвејски долар \(2008\)),
				'other' => q(зимбабвејских долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Таут',
							'Баба',
							'Хатор',
							'Киахк',
							'Тоба',
							'Амшир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Паона',
							'Епеп',
							'Месра',
							'Наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'Мескерем',
							'Текемт',
							'Хедар',
							'Тахсас',
							'Тер',
							'Јекатит',
							'Мегабит',
							'Миазиа',
							'Генбот',
							'Сене',
							'Хамле',
							'Нехасе',
							'Пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишри',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ијар',
							'Сиван',
							'Тамуз',
							'Ав',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чаитра',
							'Ваисака',
							'Јиаиста',
							'Асада',
							'Сравана',
							'Бадра',
							'Асвина',
							'Картика',
							'Аргајана',
							'Пауза',
							'Мага',
							'Фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Мух.',
							'Саф.',
							'Реб. 1',
							'Реб 2',
							'Џум. 1',
							'Џум. 2',
							'Реџ.',
							'Ша.',
							'Рам.',
							'Ше.',
							'Зул-к.',
							'Зул-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мурахам',
							'Сафар',
							'Рабиʻ I',
							'Рабиʻ II',
							'Јумада I',
							'Јумада II',
							'Рађаб',
							'Шаʻбан',
							'Рамадан',
							'Шавал',
							'Дуʻл-Киʻда',
							'Дуʻл-хиђа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Мухарем',
							'Сафер',
							'Реби 1',
							'Реби 2',
							'Џумаде 1',
							'Џумаде 2',
							'Реџеб',
							'Шаʻбан',
							'Рамазан',
							'Шевал',
							'Зул-каде',
							'Зул-хиџе'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фаравадин',
							'Ордибехешт',
							'Кордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Деј',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'по',
						tue => 'ут',
						wed => 'ср',
						thu => 'че',
						fri => 'пе',
						sat => 'су',
						sun => 'не'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'Прво тромесечје',
						1 => 'Друго тромесечје',
						2 => 'Треће тромесечје',
						3 => 'Четврто тромесечје'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'Прво тромесечје',
						1 => 'Друго тромесечје',
						2 => 'Треће тромесечје',
						3 => 'Четврто тромесечје'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{пре подне},
					'pm' => q{поподне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'БЕ'
			},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'Пре нове ере',
				'1' => 'Нове ере'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'САКА'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'АХ'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Таика (645-650)',
				'1' => 'Хакучи (650-671)',
				'2' => 'Хакухо (672-686)',
				'3' => 'Шучо (686-701)',
				'4' => 'Таихо (701-704)',
				'5' => 'Кеиун (704-708)',
				'6' => 'Вадо (708-715)',
				'7' => 'Реики (715-717)',
				'8' => 'Јоро (717-724)',
				'9' => 'Јинки (724-729)',
				'10' => 'Темпио (729-749)',
				'11' => 'Темпио-кампо (749-749)',
				'12' => 'Темпио-шохо (749-757)',
				'13' => 'Темпио-хођи (757-765)',
				'14' => 'Темпо-ђинго (765-767)',
				'15' => 'Ђинго-кеиун (767-770)',
				'16' => 'Хоки (770-780)',
				'17' => 'Тен-о (781-782)',
				'18' => 'Енрјаку (782-806)',
				'19' => 'Даидо (806-810)',
				'20' => 'Конин (810-824)',
				'21' => 'Тенчо (824-834)',
				'22' => 'Шова (834-848)',
				'23' => 'Кајо (848-851)',
				'24' => 'Нињу (851-854)',
				'25' => 'Саико (854-857)',
				'26' => 'Тенан (857-859)',
				'27' => 'Јоган (859-877)',
				'28' => 'Генкеи (877-885)',
				'29' => 'Ниња (885-889)',
				'30' => 'Кампјо (889-898)',
				'31' => 'Шотаи (898-901)',
				'32' => 'Енђи (901-923)',
				'33' => 'Енчо (923-931)',
				'34' => 'Шохеи (931-938)',
				'35' => 'Тенгјо (938-947)',
				'36' => 'Тенриаку (947-957)',
				'37' => 'Тентоку (957-961)',
				'38' => 'Ова (961-964)',
				'39' => 'Кохо (964-968)',
				'40' => 'Ана (968-970)',
				'41' => 'Тенроку (970-973)',
				'42' => 'Тен-ен (973-976)',
				'43' => 'Јоген (976-978)',
				'44' => 'Тенген (978-983)',
				'45' => 'Еикан (983-985)',
				'46' => 'Кана (985-987)',
				'47' => 'Еи-ен (987-989)',
				'48' => 'Еисо (989-990)',
				'49' => 'Шорјаку (990-995)',
				'50' => 'Чотоку (995-999)',
				'51' => 'Чохо (999-1004)',
				'52' => 'Канко (1004-1012)',
				'53' => 'Чова (1012-1017)',
				'54' => 'Канин (1017-1021)',
				'55' => 'Ђиан (1021-1024)',
				'56' => 'Мању (1024-1028)',
				'57' => 'Чоген (1028-1037)',
				'58' => 'Чорјаку (1037-1040)',
				'59' => 'Чокју (1040-1044)',
				'60' => 'Кантоку (1044-1046)',
				'61' => 'Еишо (1046-1053)',
				'62' => 'Тенђи (1053-1058)',
				'63' => 'Кохеи (1058-1065)',
				'64' => 'Ђирјаку (1065-1069)',
				'65' => 'Енкју (1069-1074)',
				'66' => 'Шохо (1074-1077)',
				'67' => 'Шорјаку (1077-1081)',
				'68' => 'Еишо (1081-1084)',
				'69' => 'Отоку (1084-1087)',
				'70' => 'Канђи (1087-1094)',
				'71' => 'Кахо (1094-1096)',
				'72' => 'Еичо (1096-1097)',
				'73' => 'Шотоку (1097-1099)',
				'74' => 'Кова (1099-1104)',
				'75' => 'Чођи (1104-1106)',
				'76' => 'Кашо (1106-1108)',
				'77' => 'Тенин (1108-1110)',
				'78' => 'Тен-еи (1110-1113)',
				'79' => 'Еикју (1113-1118)',
				'80' => 'Ђен-еи (1118-1120)',
				'81' => 'Хоан (1120-1124)',
				'82' => 'Тенђи (1124-1126)',
				'83' => 'Даиђи (1126-1131)',
				'84' => 'Теншо (1131-1132)',
				'85' => 'Чошао (1132-1135)',
				'86' => 'Хоен (1135-1141)',
				'87' => 'Еиђи (1141-1142)',
				'88' => 'Кођи (1142-1144)',
				'89' => 'Тењо (1144-1145)',
				'90' => 'Кјуан (1145-1151)',
				'91' => 'Нинпеи (1151-1154)',
				'92' => 'Кјују (1154-1156)',
				'93' => 'Хоген (1156-1159)',
				'94' => 'Хеиђи (1159-1160)',
				'95' => 'Еирјаку (1160-1161)',
				'96' => 'Охо (1161-1163)',
				'97' => 'Чокан (1163-1165)',
				'98' => 'Еиман (1165-1166)',
				'99' => 'Нин-ан (1166-1169)',
				'100' => 'Као (1169-1171)',
				'101' => 'Шоан (1171-1175)',
				'102' => 'Анген (1175-1177)',
				'103' => 'Ђишо (1177-1181)',
				'104' => 'Јова (1181-1182)',
				'105' => 'Ђуеи (1182-1184)',
				'106' => 'Генрјуку (1184-1185)',
				'107' => 'Бунђи (1185-1190)',
				'108' => 'Кенкју (1190-1199)',
				'109' => 'Шођи (1199-1201)',
				'110' => 'Кенин (1201-1204)',
				'111' => 'Генкју (1204-1206)',
				'112' => 'Кен-еи (1206-1207)',
				'113' => 'Шоген (1207-1211)',
				'114' => 'Кенрјаку (1211-1213)',
				'115' => 'Кенпо (1213-1219)',
				'116' => 'Шокју (1219-1222)',
				'117' => 'Ђу (1222-1224)',
				'118' => 'Ђенин (1224-1225)',
				'119' => 'Кароку (1225-1227)',
				'120' => 'Антеи (1227-1229)',
				'121' => 'Канки (1229-1232)',
				'122' => 'Ђоеи (1232-1233)',
				'123' => 'Темпуку (1233-1234)',
				'124' => 'Бунрјаку (1234-1235)',
				'125' => 'Катеи (1235-1238)',
				'126' => 'Рјакунин (1238-1239)',
				'127' => 'Ен-о (1239-1240)',
				'128' => 'Нињи (1240-1243)',
				'129' => 'Канген (1243-1247)',
				'130' => 'Хођи (1247-1249)',
				'131' => 'Кенчо (1249-1256)',
				'132' => 'Коген (1256-1257)',
				'133' => 'Шока (1257-1259)',
				'134' => 'Шоген (1259-1260)',
				'135' => 'Бун-о (1260-1261)',
				'136' => 'Кочо (1261-1264)',
				'137' => 'Бун-еи (1264-1275)',
				'138' => 'Кенђи (1275-1278)',
				'139' => 'Коан (1278-1288)',
				'140' => 'Шу (1288-1293)',
				'141' => 'Еинин (1293-1299)',
				'142' => 'Шоан (1299-1302)',
				'143' => 'Кенген (1302-1303)',
				'144' => 'Каген (1303-1306)',
				'145' => 'Токуђи (1306-1308)',
				'146' => 'Енкеи (1308-1311)',
				'147' => 'Очо (1311-1312)',
				'148' => 'Шова (1312-1317)',
				'149' => 'Бунпо (1317-1319)',
				'150' => 'Ђено (1319-1321)',
				'151' => 'Ђенкјо (1321-1324)',
				'152' => 'Шочу (1324-1326)',
				'153' => 'Кареки (1326-1329)',
				'154' => 'Гентоку (1329-1331)',
				'155' => 'Генко (1331-1334)',
				'156' => 'Кему (1334-1336)',
				'157' => 'Енген (1336-1340)',
				'158' => 'Кококу (1340-1346)',
				'159' => 'Шохеи (1346-1370)',
				'160' => 'Кентоку (1370-1372)',
				'161' => 'Бучу (1372-1375)',
				'162' => 'Тењу (1375-1379)',
				'163' => 'Корјаку (1379-1381)',
				'164' => 'Кова (1381-1384)',
				'165' => 'Генчу (1384-1392)',
				'166' => 'Меитоку (1384-1387)',
				'167' => 'Какеи (1387-1389)',
				'168' => 'Ку (1389-1390)',
				'169' => 'Меитоку (1390-1394)',
				'170' => 'Оеи (1394-1428)',
				'171' => 'Шочо (1428-1429)',
				'172' => 'Еикјо (1429-1441)',
				'173' => 'Какитсу (1441-1444)',
				'174' => 'Бун-ан (1444-1449)',
				'175' => 'Хотоку (1449-1452)',
				'176' => 'Кјотоку (1452-1455)',
				'177' => 'Кошо (1455-1457)',
				'178' => 'Чороку (1457-1460)',
				'179' => 'Каншо (1460-1466)',
				'180' => 'Буншо (1466-1467)',
				'181' => 'Онин (1467-1469)',
				'182' => 'Бунмеи (1469-1487)',
				'183' => 'Чокјо (1487-1489)',
				'184' => 'Ентоку (1489-1492)',
				'185' => 'Меио (1492-1501)',
				'186' => 'Бунки (1501-1504)',
				'187' => 'Еишо (1504-1521)',
				'188' => 'Таиеи (1521-1528)',
				'189' => 'Кјороку (1528-1532)',
				'190' => 'Тенмон (1532-1555)',
				'191' => 'Кођи (1555-1558)',
				'192' => 'Еироку (1558-1570)',
				'193' => 'Генки (1570-1573)',
				'194' => 'Теншо (1573-1592)',
				'195' => 'Бунроку (1592-1596)',
				'196' => 'Кеичо (1596-1615)',
				'197' => 'Генва (1615-1624)',
				'198' => 'Кан-еи (1624-1644)',
				'199' => 'Шохо (1644-1648)',
				'200' => 'Кеиан (1648-1652)',
				'201' => 'Шу (1652-1655)',
				'202' => 'Меирјаку (1655-1658)',
				'203' => 'Мањи (1658-1661)',
				'204' => 'Канбун (1661-1673)',
				'205' => 'Енпо (1673-1681)',
				'206' => 'Тенва (1681-1684)',
				'207' => 'Јокјо (1684-1688)',
				'208' => 'Генроку (1688-1704)',
				'209' => 'Хоеи (1704-1711)',
				'210' => 'Шотоку (1711-1716)',
				'211' => 'Кјохо (1716-1736)',
				'212' => 'Генбун (1736-1741)',
				'213' => 'Канпо (1741-1744)',
				'214' => 'Енкјо (1744-1748)',
				'215' => 'Кан-ен (1748-1751)',
				'216' => 'Хорјаку (1751-1764)',
				'217' => 'Меива (1764-1772)',
				'218' => 'Ан-еи (1772-1781)',
				'219' => 'Тенмеи (1781-1789)',
				'220' => 'Кансеи (1789-1801)',
				'221' => 'Кјова (1801-1804)',
				'222' => 'Бунка (1804-1818)',
				'223' => 'Бунсеи (1818-1830)',
				'224' => 'Тенпо (1830-1844)',
				'225' => 'Кока (1844-1848)',
				'226' => 'Каеи (1848-1854)',
				'227' => 'Ансеи (1854-1860)',
				'228' => 'Ман-ен (1860-1861)',
				'229' => 'Бункју (1861-1864)',
				'230' => 'Генђи (1864-1865)',
				'231' => 'Кеико (1865-1868)',
				'232' => 'Меиђи',
				'233' => 'Таишо',
				'234' => 'Шова',
				'235' => 'Хаисеи'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'Пре РК',
				'1' => 'РК'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, dd. MMMM y. G},
			'long' => q{dd. MMMM y. G},
			'medium' => q{dd.MM.y. G},
			'short' => q{d.M.y. GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd. MMMM y.},
			'long' => q{dd. MMMM y.},
			'medium' => q{dd.MM.y.},
			'short' => q{d.M.yy.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy G},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH.mm.ss zzzz},
			'long' => q{HH.mm.ss z},
			'medium' => q{HH.mm.ss},
			'short' => q{HH.mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{E d.},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH.mm},
			Hms => q{HH.mm.ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d/M},
			d => q{d},
			h => q{hh a},
			hm => q{hh.mm a},
			hms => q{hh.mm.ss a},
			ms => q{mm.ss},
			y => q{y.},
			yM => q{M.y.},
			yMEd => q{E, d.M.y.},
			yMM => q{MM.y.},
			yMMM => q{MMM y.},
			yMMMEd => q{E, d. MMM y.},
			yMMMM => q{MMMM y.},
			yMMMd => q{d. MMM y.},
			yMMdd => q{dd.MM.y.},
			yMd => q{d.M.y.},
			yQQQ => q{QQQ. y},
			yQQQQ => q{QQQQ. y},
		},
		'generic' => {
			Ed => q{E d.},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH.mm},
			Hms => q{HH.mm.ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d/M},
			d => q{d},
			h => q{hh a},
			hm => q{hh.mm a},
			hms => q{hh.mm.ss a},
			ms => q{mm.ss},
			y => q{y. G},
			yyyy => q{y. G},
			yyyyM => q{M.y. G},
			yyyyMEd => q{E, d.M.y. G},
			yyyyMM => q{MM.y. G},
			yyyyMMM => q{MMM y. G},
			yyyyMMMEd => q{E, d. MMM y. G},
			yyyyMMMM => q{MMMM y. G},
			yyyyMMMd => q{d. MMM y. G},
			yyyyMMdd => q{dd.MM.y. G},
			yyyyMd => q{d.M.y. G},
			yyyyQQQ => q{QQQ, y. G},
			yyyyQQQQ => q{QQQQ y. G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH.mm-HH.mm},
				m => q{HH.mm-HH.mm},
			},
			Hmv => {
				H => q{HH.mm-HH.mm v},
				m => q{HH.mm-HH.mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h.mm a - h.mm a},
				h => q{h.mm-h.mm a},
				m => q{h.mm-h.mm a},
			},
			hmv => {
				a => q{h.mm a - h.mm a v},
				h => q{h.mm-h.mm a v},
				m => q{h.mm-h.mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{y M - M},
				y => q{y M - M},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y.},
				d => q{E, d.M.y. - E, d.M.y.},
				y => q{E, d.M.y. - E, d.M.y.},
			},
			yMMM => {
				M => q{MMM-MMM y.},
				y => q{MMM y. - MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y.},
				d => q{E, dd. - E, dd. MMM y.},
				y => q{E, dd. MMM y. - E, dd. MMM y.},
			},
			yMMMM => {
				M => q{y-MM – MM},
				y => q{y-MM – y-MM},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y.},
				d => q{dd.-dd. MMM y.},
				y => q{dd. MMM y. - dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. - d.M.y.},
				d => q{d.M.y. - d.M.y.},
				y => q{d.M.y. - d.M.y.},
			},
		},
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH.mm-HH.mm},
				m => q{HH.mm-HH.mm},
			},
			Hmv => {
				H => q{HH.mm-HH.mm v},
				m => q{HH.mm-HH.mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h.mm a - h.mm a},
				h => q{h.mm-h.mm a},
				m => q{h.mm-h.mm a},
			},
			hmv => {
				a => q{h.mm a - h.mm a v},
				h => q{h.mm-h.mm a v},
				m => q{h.mm-h.mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{y M - M},
				y => q{M.y - M.y},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y.},
				d => q{E, d.M.y. - E, d.M.y.},
				y => q{E, d.M.y. - E, d.M.y.},
			},
			yMMM => {
				M => q{MMM-MMM y.},
				y => q{MMM y. - MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y.},
				d => q{E, dd. - E, dd. MMM y.},
				y => q{E, dd. MMM y. - E, dd. MMM y.},
			},
			yMMMM => {
				M => q{y-MM – MM},
				y => q{y-MM – y-MM},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y.},
				d => q{dd.-dd. MMM y.},
				y => q{dd. MMM y. - dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. - d.M.y.},
				d => q{d.M.y. - d.M.y.},
				y => q{d.M.y. - d.M.y.},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HHmm;-HHmm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Време у земљи: {0}),
		regionFormat => q({0}, летње време),
		regionFormat => q({0}, стандардно време),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(Акре летње рачунање времена),
				'generic' => q(Акре време),
				'standard' => q(Акре стандардно време),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(Авганистан време),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#алжирско#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисао#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габорон#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лумумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадиш#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Навакшут#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#тунижанско#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Централно-афричко време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Источно-афричко време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Јужно-афричко време),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западно-афричко летње рачунање времена),
				'generic' => q(Западно-афричко време),
				'standard' => q(Западно-афричко стандардно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аљашко летње време),
				'generic' => q(Аљашко време),
				'standard' => q(Аљашко стандардно време),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(Алмати летње рачунање времена),
				'generic' => q(Алмати време),
				'standard' => q(Алмати стандардно време),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазон летње рачунање времена),
				'generic' => q(Амазон време),
				'standard' => q(Амазон стандардно време),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоја#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Гелегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаија#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баија Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајманска острва#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбур#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кирасо#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхаген#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхаб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гуана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Кнокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Петерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевај, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винценес, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анђелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луивиле#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер Принсиз Квортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бијула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нови Салем, Северна Даткоа#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамирбо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порто Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ресолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантијаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорезбисунд#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Св. Бартоломeј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Св. Џон#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Св. Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Св. Тома#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Северноамерички Централно летње рачунање времена),
				'generic' => q(Северноамерички Централно време),
				'standard' => q(Северноамерички Централно стандардно време),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Северноамерички Источно летње рачунање времена),
				'generic' => q(Северноамерички Источно време),
				'standard' => q(Северноамерички Источно стандардно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Северноамерички Планинско летње рачунање времена),
				'generic' => q(Северноамерички Планинско време),
				'standard' => q(Северноамерички Планинско стандардно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Северноамерички Пацифичко летње рачунање времена),
				'generic' => q(Северноамерички Пацифичко време),
				'standard' => q(Северноамерички Пацифичко стандардно време),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(Анадир летње рачунање времена),
				'generic' => q(Анадир време),
				'standard' => q(Анадир стандардно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Касеј#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон д’Урвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Меквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(Акватау летње рачунање времена),
				'generic' => q(Акватау време),
				'standard' => q(Акватау стандардно време),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(Акутобе летње рачунање времена),
				'generic' => q(Акутобе време),
				'standard' => q(Акутобе стандардно време),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабијско летње рачунање времена),
				'generic' => q(Арабијско време),
				'standard' => q(Арабијско стандардно време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентина летње рачунање времена),
				'generic' => q(Аргентина време),
				'standard' => q(Аргентина стандардно време),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Западна Аргентина летње рачунање времена),
				'generic' => q(Западна Аргентина време),
				'standard' => q(Западна Аргентина стандардно време),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Арменија летње рачунање времена),
				'generic' => q(Арменија време),
				'standard' => q(Арменија стандардно време),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Акутобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Банкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеји#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чонгкинг#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркуцк#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Јерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макау#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумкви#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вијентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Јекатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Јереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атланско лтње рачунање времена),
				'generic' => q(Атланско време),
				'standard' => q(Атланско стандардно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азори#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарска острва#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зеленортска Острва#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарска острва#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадера#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Св. Јелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хов#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Аустралијско централно летње рачунање времена),
				'generic' => q(Аустралијско централно време),
				'standard' => q(Аустралијско централно стандардно време),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Аустралијско централно западно летње рачунање времена),
				'generic' => q(Аустралијско централно западно време),
				'standard' => q(Аустралијско централно западно стандардно време),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Аустралијско источно летње рачунање времена),
				'generic' => q(Аустралијско источно време),
				'standard' => q(Аустралијско источно стандардно време),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Аустралијско западно летње рачунање времена),
				'generic' => q(Аустралијско западно време),
				'standard' => q(Аустралијско западно стандардно време),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербејџан летње рачунање времена),
				'generic' => q(Азербејџан време),
				'standard' => q(Азербејџан стандардно време),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азори летње рачунање времена),
				'generic' => q(Азори време),
				'standard' => q(Азори стандардно време),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладеш летње рачунање времена),
				'generic' => q(Бангладеш време),
				'standard' => q(Бангладеш стандардно време),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутан време),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливија време),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилија летње рачунање времена),
				'generic' => q(Бразилија време),
				'standard' => q(Бразилија стандардно време),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Брунеј Дарусалум време),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Зеленортско летње рачунање времена),
				'generic' => q(Зелениртско време),
				'standard' => q(Зелениртско стандардно време),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморо време),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатам летње рачунање времена),
				'generic' => q(Чатам време),
				'standard' => q(Чатам стандардно време),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чиле летње рачунање времена),
				'generic' => q(Чиле време),
				'standard' => q(Чиле стандардно време),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Кина летње рачунање времена),
				'generic' => q(Кина време),
				'standard' => q(Кинеско стандардно време),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чојбалсан летње рачунање времена),
				'generic' => q(Чојбалсан време),
				'standard' => q(Чојбалсан стандардно време),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Божићна острва време),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос (Келинг) Острва време),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбија летње рачунање времена),
				'generic' => q(Колумбија време),
				'standard' => q(Колумбија стандардно време),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Кукова острва полу-летње рачунање времена),
				'generic' => q(Кукова острва време),
				'standard' => q(Кукова острва стандардно време),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Куба летње рачунање времена),
				'generic' => q(Куба време),
				'standard' => q(Куба стандардно време),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дејвис време),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Димон д’Урвил време),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Источни тимор време),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Ускршња острва летње рачунање времена),
				'generic' => q(Ускршња острва време),
				'standard' => q(Ускршња острва стандардно време),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Еквадор време),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат или неважећи град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Београд#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишињев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q(ирско летње време),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острво Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Кијев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(британско летње време),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Праг#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сарајево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопље#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Беч#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Виљнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Средњеевропско летње рачунање времена),
				'generic' => q(Средњеевропско време),
				'standard' => q(Средњеевропско стандардно време),
			},
			short => {
				'daylight' => q(CEST),
				'generic' => q(CET),
				'standard' => q(CET),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Источноевропско летње рачунање времена),
				'generic' => q(Источноевропско време),
				'standard' => q(Источноевропско стандардно време),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропско летње рачунање времена),
				'generic' => q(Западноевропско време),
				'standard' => q(Западноевропско стандардно време),
			},
			short => {
				'daylight' => q(WEST),
				'generic' => q(WET),
				'standard' => q(WET),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолкландска Острва летње рачунање времена),
				'generic' => q(Фолкландска Острва време),
				'standard' => q(Фолкландска Острва стандардно време),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фиџи летње рачунање времена),
				'generic' => q(Фиџи време),
				'standard' => q(Фиџи стандардно време),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Француска Гвајана време),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француско јужно и антарктичко време),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Гринвич средње време),
			},
			short => {
				'standard' => q(GMT),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагос време),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбијер време),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузија летње рачунање времена),
				'generic' => q(Грузија време),
				'standard' => q(Грузија стандардно време),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Гилберт острва време),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Источни Гренланд летње рачунање времена),
				'generic' => q(Источни Гренланд време),
				'standard' => q(Источни Гренланд стандардно време),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Западни Гренланд летње рачунање времена),
				'generic' => q(Западни Гренланд време),
				'standard' => q(Западни Гренланд стандардно време),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(Гуам стандардно време),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Залив време),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гвајана време),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Хавајско-алеутско летње рачунање времена),
				'generic' => q(Хавајско-алеутско време),
				'standard' => q(Хавајско-алеутско стандардно време),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Хонг Конг летње рачунање времена),
				'generic' => q(Хонг Конг време),
				'standard' => q(Хонг Конг стандардно време),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховд летње рачунање времена),
				'generic' => q(Ховд време),
				'standard' => q(Ховд стандардно време),
			},
		},
		'India' => {
			long => {
				'standard' => q(Индијско стандардно време),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божић#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маурицијус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Индијско океанско време),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Индокина време),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Централно-индонезијско време),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Источно-индонезијско време),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Западно-индонезијско време),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иран летње рачунање времена),
				'generic' => q(Иран време),
				'standard' => q(Иран стандардно време),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркуцк летње рачунање времена),
				'generic' => q(Иркуцк време),
				'standard' => q(Иркуцк стандардно време),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израелско летње рачунање времена),
				'generic' => q(Израелско време),
				'standard' => q(Израелско стандардно време),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Јапанско летње рачунање времена),
				'generic' => q(Јапанско време),
				'standard' => q(Јапанско стандардно време),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(Петропавловско-камчатско летње рачунање времена),
				'generic' => q(Петропавловско-камчатско време),
				'standard' => q(Петропавловско-камчатско стандардно време),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Источно-казахстанско време),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Западно-казахстанско време),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корејско летње рачунање времена),
				'generic' => q(Корејско време),
				'standard' => q(Корејско стандардно време),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Кошре време),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Краснојарск летње рачунање времена),
				'generic' => q(Краснојарск време),
				'standard' => q(Краснојарск стандардно време),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Киргизстан време),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(Шри Ланка време),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лине Острва време),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хов летње рачунање времена),
				'generic' => q(Лорд Хов време),
				'standard' => q(Лорд Хов стандардно време),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(Макао летње рачунање времена),
				'generic' => q(Макао време),
				'standard' => q(Макао стандардно време),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Макверијско време),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магадан летње рачунање времена),
				'generic' => q(Магадан време),
				'standard' => q(Магадан стандардно време),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малезија време),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Малдиви време),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркиз време),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалска Острва време),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Маурицијус летње рачунање времена),
				'generic' => q(Маурицијус време),
				'standard' => q(Маурицијус стандардно време),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Мосон време),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улан Батор летње рачунање времена),
				'generic' => q(Улан Батор време),
				'standard' => q(Улан Батор стандардно време),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Москва летње рачунање времена),
				'generic' => q(Москва време),
				'standard' => q(Москва стандардно време),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мијанмар време),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру време),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непал време),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Нова Каледонија летње рачунање времена),
				'generic' => q(Нова Каледонија време),
				'standard' => q(Нова Каледонија стандардно време),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Нови Зеланд летње рачунање времена),
				'generic' => q(Нови Зеланд време),
				'standard' => q(Нови Зеланд стандардно време),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Њуфаундленд летње рачунање времена),
				'generic' => q(Њуфаундленд време),
				'standard' => q(Њуфаундленд стандардно време),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуе време),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк Острво време),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Нороња летње рачунање времена),
				'generic' => q(Фернандо де Нороња време),
				'standard' => q(Фернандо де Нороња стандардно време),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(Северна Маријанска Острва време),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирск летње рачунање времена),
				'generic' => q(Новосибирск време),
				'standard' => q(Новосибирск стандардно време),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омск летње рачунање времена),
				'generic' => q(Омск време),
				'standard' => q(Омск стандардно време),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Катхам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ускршње острво#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошре#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мајуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкаирн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морзби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистан летње рачунање времена),
				'generic' => q(Пакистан време),
				'standard' => q(Пакистан стандардно време),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау време),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа Нова Гвинеја време),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвај летње рачунање времена),
				'generic' => q(Парагвај време),
				'standard' => q(Парагвај стандардно време),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перу летње рачунање времена),
				'generic' => q(Перу време),
				'standard' => q(Перу стандардно време),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филипини летње рачунање времена),
				'generic' => q(Филипини време),
				'standard' => q(Филипини стандардно време),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс острва време),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен Пјер и Микелон летње рачунање времена),
				'generic' => q(Сен Пјер и Микелон време),
				'standard' => q(Сен Пјер и Микелон стандардно време),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкерн време),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понпеи време),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(Кизилорда летње рачунање времена),
				'generic' => q(Кизилорда време),
				'standard' => q(Кизилорда стандардно време),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реинион време),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера време),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалин летње рачунање времена),
				'generic' => q(Сахалин време),
				'standard' => q(Сахалин стандардно време),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара летње рачунање времена),
				'generic' => q(Самара време),
				'standard' => q(Самара стандардно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоа летње рачунање времена),
				'generic' => q(Самоа време),
				'standard' => q(Самоа стандардно време),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сејшели време),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапур стандардно време),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломонска Острва време),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Јужна Џорџија време),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринам),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Шова време),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Тахити време),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Таипеи летње рачунање времена),
				'generic' => q(Таипеи време),
				'standard' => q(Таипеи стандардно време),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Таџикистан време),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау време),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга летње рачунање времена),
				'generic' => q(Тонга време),
				'standard' => q(Тонга стандардно време),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чуук време),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Туркменистан летње рачунање времена),
				'generic' => q(Туркменистан време),
				'standard' => q(Туркменистан стандардно време),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу време),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвај летње рачунање времена),
				'generic' => q(Уругвај време),
				'standard' => q(Уругвај стандардно време),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Узбекистан летње рачунање времена),
				'generic' => q(Узбекистан време),
				'standard' => q(Узбекистан стандардно време),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату летње рачунање времена),
				'generic' => q(Вануату време),
				'standard' => q(Вануату стандардно време),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венецуела време),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивосток летње рачунање времена),
				'generic' => q(Владивосток време),
				'standard' => q(Владивосток стандардно време),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоград летње рачунање времена),
				'generic' => q(Волгоград време),
				'standard' => q(Волгоград стандардно време),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток време),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Вејк острво време),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Валис и Футуна Острва време),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Јакутск летње рачунање времена),
				'generic' => q(Јакутск време),
				'standard' => q(Јакутск стандардно време),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Јекатеринбург летње рачунање времена),
				'generic' => q(Јекатеринбург време),
				'standard' => q(Јекатеринбург стандардно време),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
