package Locale::CLDR::Transformations::Any::Am_fonipa::Am;
# This file auto generated from Data\common\transforms\am-am_FONIPA.xml
#	on Tue  5 Dec 12:59:04 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.4');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q([̰̃̋́̄̀̏̌̂˥˦˧˨˩ꜜꜛ↗↘]),
					result  => q(),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(([pbtd])ʷː),
					result  => q($1ːʷ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([pbtd])ʲː),
					result  => q($1ːʲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʱ]),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʰ),
					result  => q(ʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɑ),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɔø]),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɛæɘ]),
					result  => q(ə),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʊɯ]),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɪʉ]),
					result  => q(ɨ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y),
					result  => q(i),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ːʼ),
					result  => q(ʼː),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʷ),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([aeəiɨou]),
					replace => q(u̯),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɬ),
					result  => q(ʃl),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+74.361.26C}\N{U+74.26C}]),
					result  => q(t͡ʃl),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʎ[iɨ]?[jʝʲ]?),
					result  => q(lj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʝʲ]),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɦ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕ̝),
					result  => q(ʕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([çxχ]),
					result  => q(x),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(β),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r̝),
					result  => q(rʒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r̝ː),
					result  => q(rːʒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɾɽʁ]),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʐʑ]),
					result  => q(ʒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʂɕ]),
					result  => q(ʃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+62.32A}\N{U+62.346}ȸ\N{U+62.361.76}\N{U+62.32A.361.76}]),
					result  => q(bv),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+70.32A}\N{U+70.346}ȹ\N{U+70.361.66}\N{U+70.32A.66}\N{U+70.32A.35C.66}]),
					result  => q(pf),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʤʣ\N{U+64.361.7A}\N{U+64.35C.7A}\N{U+64.361.255}ʥ\N{U+64.361.291}\N{U+64.35C.291}\N{U+256.361.290}\N{U+64.361.290}ɟ]),
					result  => q(d͡ʒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ǀʇǂʄ]),
					result  => q(t͡ʃʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+74.35C.283}ʧ\N{U+74.361.255}\N{U+74.35C.255}ʨ\N{U+288.361.282}c]),
					result  => q(t͡ʃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+74.361.73}\N{U+74.35C.73}ʦ]),
					result  => q(sʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ð\N{U+F0.320}\N{U+F0.33C}\N{U+3B2.33A}]),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([θ\N{U+3B8.331}\N{U+3B8.31E}\N{U+3B8.33C}\N{U+278.33A}]),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʡ),
					result  => q(ʔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᵑɡ),
					result  => q(nɡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([gɢɣɠʛ]),
					result  => q(ɡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ǃʗ]),
					result  => q(kʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(q),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɖɗᶑ]),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ǁʖ]),
					result  => q(tʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+74.32A}ʈ]),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+64.33C}\N{U+62.33A}\N{U+27E.33C}ɓ]),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ʘɋ]),
					result  => q(pʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+74.33C}\N{U+70.33A}]),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+274.30A}\N{U+274.325}ɴ]),
					result  => q(ɴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+14B.30A}\N{U+14B.325}ŋ]),
					result  => q(ŋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+273.30A}\N{U+273.325}ɳ\N{U+272.30A}\N{U+272.325}ɲ]),
					result  => q(ɲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ɱ\N{U+6D.325}\N{U+6D.32A}ᵐ]),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([n\N{U+6E.33C}\N{U+6E.33C.30A}\N{U+6D.33A}\N{U+6E.30A}\N{U+6E.325}ⁿᵑ]),
					result  => q(n),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q([aeəiɨou]),
					replace => q(([aeəiɨou]ː?)̯),
					result  => q($1w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.o),
					result  => q(ʔo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.ɨ),
					result  => q(ʔɨ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.e),
					result  => q(ʔe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.a),
					result  => q(ʔa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.i),
					result  => q(ʔi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.u),
					result  => q(ʔu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\.ə),
					result  => q(ʔə),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ue),
					result  => q(uwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ui),
					result  => q(uwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡s),
					result  => q(sʼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bue),
					result  => q(bwe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ua),
					result  => q(uwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ŋ),
					result  => q(nɡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ŋɡ),
					result  => q(nɡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(io),
					result  => q(jo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(iu),
					result  => q(iw),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(iə),
					result  => q(ijə),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ia),
					result  => q(ija),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(eo),
					result  => q(ewo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ei),
					result  => q(eji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(au),
					result  => q(aw),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ai),
					result  => q(aj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ˈˌ\.̯̃]),
					result  => q(),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(([mnɲɴ p \N{U+70.2BC} bt \N{U+74.2BC} dk \N{U+6B.2BC} ɡʔʕ fvs \N{U+73.2BC} zʃʒxh lr \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292}]ː[w]?[aeəiɨou]?)),
					result  => q($1\u135F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([mnɲɴ p \N{U+70.2BC} bt \N{U+74.2BC} dk \N{U+6B.2BC} ɡʔʕ fvs \N{U+73.2BC} zʃʒxh lr \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292}][w]?[aeəiɨou]ː)),
					result  => q($1\u135E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([mnɲɴ p \N{U+70.2BC} bt \N{U+74.2BC} dk \N{U+6B.2BC} ɡʔʕ fvs \N{U+73.2BC} zʃʒxh lr \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292}]ː[w]?[aeəiɨou]ː)),
					result  => q($1\u135D),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((jː[aeəiɨou]?)),
					result  => q($1\u135F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([jw][aeəiɨou]ː)),
					result  => q($1\u135E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((jː[aeəiɨou]ː)),
					result  => q($1\u135D),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([aeəiɨou]ː)),
					result  => q($1\u135E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(((?:[b]|[p\N{U+70.2BC}t\N{U+74.2BC}\N{U+74.361.283}\N{U+74.361.283.2BC}\N{U+64.361.292}\N{U+64.361.292.2BC}s\N{U+73.2BC}zʃʒfvr]))ː([jw][aeəiɨou]?)),
					result  => q($1\u135F$2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(((?:[b]|[p\N{U+70.2BC}t\N{U+74.2BC}\N{U+74.361.283}\N{U+74.361.283.2BC}\N{U+64.361.292}\N{U+64.361.292.2BC}s\N{U+73.2BC}zʃʒfvr]))ː([jw][aeəiɨou])ː),
					result  => q($1\u135F$2\u135E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([p \N{U+70.2BC} t \N{U+74.2BC} \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292} \N{U+64.361.292.2BC} s \N{U+73.2BC} zʃʒ fv r])ːwa),
					result  => q($1wa\u135F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([p \N{U+70.2BC} t \N{U+74.2BC} \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292} \N{U+64.361.292.2BC} s \N{U+73.2BC} zʃʒ fv r])waː),
					result  => q($1wa\u135E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(([p \N{U+70.2BC} t \N{U+74.2BC} \N{U+74.361.283} \N{U+74.361.283.2BC} \N{U+64.361.292} \N{U+64.361.292.2BC} s \N{U+73.2BC} zʃʒ fv r])ːwaː),
					result  => q($1wa\u135D),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ː),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i),
					result  => q(ኢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o),
					result  => q(ኦ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɨ),
					result  => q(እ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(e),
					result  => q(ኤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(a),
					result  => q(አ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(u),
					result  => q(ኡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ə),
					result  => q(ኧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(p),
					result  => q(ፕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pwa),
					result  => q(ፗ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(po),
					result  => q(ፖ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pɨ),
					result  => q(ፕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pe),
					result  => q(ፔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pa),
					result  => q(ፓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pi),
					result  => q(ፒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pu),
					result  => q(ፑ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pə),
					result  => q(ፐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(f),
					result  => q(ፍ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fwa),
					result  => q(ፏ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fo),
					result  => q(ፎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fɨ),
					result  => q(ፍ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fe),
					result  => q(ፌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fa),
					result  => q(ፋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fi),
					result  => q(ፊ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fu),
					result  => q(ፉ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(fə),
					result  => q(ፈ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s),
					result  => q(ስ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(swa),
					result  => q(ሷ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(so),
					result  => q(ሶ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sɨ),
					result  => q(ስ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(se),
					result  => q(ሴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sa),
					result  => q(ሳ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(si),
					result  => q(ሲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(su),
					result  => q(ሱ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sə),
					result  => q(ሰ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼ),
					result  => q(ጽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼwa),
					result  => q(ጿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼo),
					result  => q(ጾ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼɨ),
					result  => q(ጽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼe),
					result  => q(ጼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼa),
					result  => q(ጻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼi),
					result  => q(ጺ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼu),
					result  => q(ጹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sʼə),
					result  => q(ጸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼ),
					result  => q(ጵ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼwa),
					result  => q(ጷ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼo),
					result  => q(ጶ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼɨ),
					result  => q(ጵ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼe),
					result  => q(ጴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼa),
					result  => q(ጳ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼi),
					result  => q(ጲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼu),
					result  => q(ጱ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(pʼə),
					result  => q(ጰ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t),
					result  => q(ት),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(twa),
					result  => q(ቷ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(to),
					result  => q(ቶ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tɨ),
					result  => q(ት),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(te),
					result  => q(ቴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ta),
					result  => q(ታ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ti),
					result  => q(ቲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tu),
					result  => q(ቱ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tə),
					result  => q(ተ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃ),
					result  => q(ች),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃwa),
					result  => q(ቿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃo),
					result  => q(ቾ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃɨ),
					result  => q(ች),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃe),
					result  => q(ቼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃa),
					result  => q(ቻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃi),
					result  => q(ቺ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃu),
					result  => q(ቹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃə),
					result  => q(ቸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼ),
					result  => q(ጪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼwa),
					result  => q(ጯ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼo),
					result  => q(ጮ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼɨ),
					result  => q(ጭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼe),
					result  => q(ጬ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼa),
					result  => q(ጫ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼi),
					result  => q(ጪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼu),
					result  => q(ጩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t͡ʃʼə),
					result  => q(ጨ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼ),
					result  => q(ጢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼwa),
					result  => q(ጧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼo),
					result  => q(ጦ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼɨ),
					result  => q(ጥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼe),
					result  => q(ጤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼa),
					result  => q(ጣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼi),
					result  => q(ጢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼu),
					result  => q(ጡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tʼə),
					result  => q(ጠ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴ),
					result  => q(ጝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴo),
					result  => q(ጞ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴɨ),
					result  => q(ጝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴe),
					result  => q(ጜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴa),
					result  => q(ጛ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴi),
					result  => q(ጚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴu),
					result  => q(ጙ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɴə),
					result  => q(ጘ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡ),
					result  => q(ግ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡwe),
					result  => q(ጔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡwa),
					result  => q(ጓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡwi),
					result  => q(ጒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡwu),
					result  => q(ጕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡwə),
					result  => q(ጐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡo),
					result  => q(ጎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡɨ),
					result  => q(ግ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡe),
					result  => q(ጌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡa),
					result  => q(ጋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡi),
					result  => q(ጊ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡu),
					result  => q(ጉ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɡə),
					result  => q(ገ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d),
					result  => q(ድ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dwa),
					result  => q(ዷ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(do),
					result  => q(ዶ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dɨ),
					result  => q(ድ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(de),
					result  => q(ዴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(da),
					result  => q(ዳ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(di),
					result  => q(ዲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(du),
					result  => q(ዱ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(də),
					result  => q(ደ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒ),
					result  => q(ጅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒwa),
					result  => q(ጇ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒo),
					result  => q(ጆ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒɨ),
					result  => q(ጅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒe),
					result  => q(ጄ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒa),
					result  => q(ጃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒi),
					result  => q(ጂ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒu),
					result  => q(ጁ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d͡ʒə),
					result  => q(ጀ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(j),
					result  => q(ይ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(jo),
					result  => q(ዮ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(jɨ),
					result  => q(ይ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(je),
					result  => q(ዬ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ja),
					result  => q(ያ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ji),
					result  => q(ዪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ju),
					result  => q(ዩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(jə),
					result  => q(የ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒ),
					result  => q(ዢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒwa),
					result  => q(ዧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒo),
					result  => q(ዦ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒɨ),
					result  => q(ዥ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒe),
					result  => q(ዤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒa),
					result  => q(ዣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒi),
					result  => q(ዢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒu),
					result  => q(ዡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʒə),
					result  => q(ዠ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(z),
					result  => q(ዝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zwa),
					result  => q(ዟ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zo),
					result  => q(ዞ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zɨ),
					result  => q(ዝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ze),
					result  => q(ዜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(za),
					result  => q(ዛ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zi),
					result  => q(ዚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zu),
					result  => q(ዙ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zə),
					result  => q(ዘ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕ),
					result  => q(ዒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕo),
					result  => q(ዖ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕɨ),
					result  => q(ዕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕe),
					result  => q(ዔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕa),
					result  => q(ዓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕi),
					result  => q(ዒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕu),
					result  => q(ዑ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʕə),
					result  => q(ዐ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(w),
					result  => q(ው),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wo),
					result  => q(ዎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wɨ),
					result  => q(ው),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(we),
					result  => q(ዌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wa),
					result  => q(ዋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wi),
					result  => q(ዊ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wu),
					result  => q(ዉ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(wə),
					result  => q(ወ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k),
					result  => q(ክ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwe),
					result  => q(ኴ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwa),
					result  => q(ኳ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwi),
					result  => q(ኲ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwu),
					result  => q(ኵ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kwə),
					result  => q(ኰ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ko),
					result  => q(ኮ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kɨ),
					result  => q(ክ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ke),
					result  => q(ኬ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ka),
					result  => q(ካ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ki),
					result  => q(ኪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ku),
					result  => q(ኩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kə),
					result  => q(ከ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔ),
					result  => q(እ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔo),
					result  => q(ኦ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔɨ),
					result  => q(እ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔe),
					result  => q(ኤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔa),
					result  => q(ኣ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔi),
					result  => q(ኢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔu),
					result  => q(ኡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʔə),
					result  => q(አ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(x),
					result  => q(ኽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xo),
					result  => q(ኾ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xɨ),
					result  => q(ኽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xe),
					result  => q(ኼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xa),
					result  => q(ኻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xi),
					result  => q(ኺ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xu),
					result  => q(ኹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xə),
					result  => q(ኸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xw),
					result  => q(ዅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwɨ),
					result  => q(ዅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwe),
					result  => q(ዄ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwa),
					result  => q(ዃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwi),
					result  => q(ዂ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(xwə),
					result  => q(ዀ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲ),
					result  => q(ኝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲwa),
					result  => q(ኟ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲo),
					result  => q(ኞ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲɨ),
					result  => q(ኝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲe),
					result  => q(ኜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲa),
					result  => q(ኛ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲi),
					result  => q(ኚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲu),
					result  => q(ኙ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ɲə),
					result  => q(ኘ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(n),
					result  => q(ን),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nwa),
					result  => q(ኗ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(no),
					result  => q(ኖ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nɨ),
					result  => q(ን),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ne),
					result  => q(ኔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(na),
					result  => q(ና),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ni),
					result  => q(ኒ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nu),
					result  => q(ኑ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(nə),
					result  => q(ነ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(v),
					result  => q(ቭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(vwa),
					result  => q(ቯ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(vo),
					result  => q(ቮ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(vɨ),
					result  => q(ቭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ve),
					result  => q(ቬ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(va),
					result  => q(ቫ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(vi),
					result  => q(ቪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(vu),
					result  => q(ቩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(və),
					result  => q(ቨ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(b),
					result  => q(ብ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bo),
					result  => q(ቦ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bɨ),
					result  => q(ብ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(be),
					result  => q(ቤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ba),
					result  => q(ባ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bi),
					result  => q(ቢ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bu),
					result  => q(ቡ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(bə),
					result  => q(በ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼ),
					result  => q(ቅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼwe),
					result  => q(ቌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼwa),
					result  => q(ቋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼwi),
					result  => q(ቊ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼwu),
					result  => q(ቍ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼwə),
					result  => q(ቈ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼo),
					result  => q(ቆ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼɨ),
					result  => q(ቅ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼe),
					result  => q(ቄ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼa),
					result  => q(ቃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼi),
					result  => q(ቂ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼu),
					result  => q(ቁ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kʼə),
					result  => q(ቀ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃ),
					result  => q(ሽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃwa),
					result  => q(ሿ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃo),
					result  => q(ሾ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃɨ),
					result  => q(ሽ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃe),
					result  => q(ሼ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃa),
					result  => q(ሻ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃi),
					result  => q(ሺ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃu),
					result  => q(ሹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʃə),
					result  => q(ሸ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r),
					result  => q(ር),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rwa),
					result  => q(ሯ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ro),
					result  => q(ሮ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rɨ),
					result  => q(ር),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(re),
					result  => q(ሬ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ra),
					result  => q(ራ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ri),
					result  => q(ሪ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ru),
					result  => q(ሩ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(rə),
					result  => q(ረ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(m),
					result  => q(ም),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mwa),
					result  => q(ሟ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mo),
					result  => q(ሞ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mɨ),
					result  => q(ም),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(me),
					result  => q(ሜ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ma),
					result  => q(ማ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mi),
					result  => q(ሚ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mu),
					result  => q(ሙ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(mə),
					result  => q(መ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(l),
					result  => q(ል),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lwa),
					result  => q(ሏ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lo),
					result  => q(ሎ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lɨ),
					result  => q(ል),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(le),
					result  => q(ሌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(la),
					result  => q(ላ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(li),
					result  => q(ሊ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lu),
					result  => q(ሉ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(lə),
					result  => q(ለ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(h),
					result  => q(ህ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ho),
					result  => q(ሆ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(hɨ),
					result  => q(ህ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(he),
					result  => q(ሄ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ha),
					result  => q(ሃ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(hi),
					result  => q(ሂ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(hu),
					result  => q(ሁ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(hə),
					result  => q(ሀ),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q([ʼ̯͜͡]),
					result  => q(),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
