package Locale::CLDR::Transformations::Bgn::Hy::Hy_latn;
# This file auto generated from Data\common\transforms\Armenian-Latin-BGN.xml
#	on Sun  5 Aug  5:49:13 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.33.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G[ԱԲԳԴԵԶԷԸԹԺԻԼԽԾԿՀՁՂՃՄՅՆՇՈՉՊՋՌՍՎՏՐՑՒՓՔՕՖաբգդեզէըթժիլխծկհձղճմյնշոչպջռսվտրցւփքօֆև։])/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q((?:(?:(?![\p{L}\p{M}\p{N}])(?s:.))|[աեէիո\N{U+578.582}օԱԵԷԻՈ\N{U+548.552}\N{U+548.582}Օ])),
					after   => q(),
					replace => q([\N{U+535.54E} \N{U+535.552} \N{U+535.53B}]),
					result  => q(YEV),
					revisit => 0,
				},
				{
					before  => q((?:(?:(?![\p{L}\p{M}\p{N}])(?s:.))|[աեէիո\N{U+578.582}օԱԵԷԻՈ\N{U+548.552}\N{U+548.582}Օ])),
					after   => q(),
					replace => q([\N{U+535.57E} \N{U+535.582} \N{U+535.56B}]),
					result  => q(Yev),
					revisit => 0,
				},
				{
					before  => q((?:(?:(?![\p{L}\p{M}\p{N}])(?s:.))|[աեէիո\N{U+578.582}օԱԵԷԻՈ\N{U+548.552}\N{U+548.582}Օ])),
					after   => q(),
					replace => q([\N{U+565.57E} \N{U+565.582} և \N{U+565.56B}]),
					result  => q(yev),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+535.54E} \N{U+535.552} \N{U+535.53B}]),
					result  => q(EV),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+535.57E} \N{U+535.582} \N{U+535.56B}]),
					result  => q(Ev),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([\N{U+565.57E} \N{U+565.582} և \N{U+565.56B}]),
					result  => q(ev),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q([ԱԵԷԸԻՈՕՒ]),
					after   => q(),
					replace => q(Ե),
					result  => q(YE),
					revisit => 0,
				},
				{
					before  => q([աեէըիոևօւ]),
					after   => q(),
					replace => q(Ե),
					result  => q(Ye),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(Ե),
					result  => q(Ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ե),
					result  => q(E),
					revisit => 0,
				},
				{
					before  => q((?:[ԱԵԷԸԻՈՕՒ]|[աեէըիոևօւ])),
					after   => q(),
					replace => q(ե),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ե),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ե),
					result  => q(e),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(Ա),
					result  => q(A),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ա),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Բ),
					result  => q(B),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(բ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Գ),
					result  => q(G),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(գ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Դ),
					result  => q(D),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(դ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Զ),
					result  => q(Z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(զ),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Է),
					result  => q(E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(է),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ը),
					result  => q(Y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ը),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Թ),
					result  => q(T’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(թ),
					result  => q(t’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ժ),
					result  => q(Zh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ժ),
					result  => q(ZH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ժ),
					result  => q(zh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ի),
					result  => q(I),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ի),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Լ),
					result  => q(L),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(լ),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Խ),
					result  => q(Kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Խ),
					result  => q(KH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(խ),
					result  => q(kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ծ),
					result  => q(Ts),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ծ),
					result  => q(TS),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ծ),
					result  => q(ts),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Կ),
					result  => q(K),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(կ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Հ),
					result  => q(H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(հ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ձ),
					result  => q(Dz),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ձ),
					result  => q(DZ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ձ),
					result  => q(dz),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ղ),
					result  => q(Gh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ղ),
					result  => q(GH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ղ),
					result  => q(gh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ճ),
					result  => q(Ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ճ),
					result  => q(CH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ճ),
					result  => q(ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Մ),
					result  => q(M),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(մ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Յ),
					result  => q(Y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(յ),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ն),
					result  => q(N),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ն),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Շ),
					result  => q(Sh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Շ),
					result  => q(SH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(շ),
					result  => q(sh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ու),
					result  => q(U),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ՈՒ),
					result  => q(U),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ու),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ՈՎ),
					result  => q(OV),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ով),
					result  => q(Ov),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ով),
					result  => q(ov),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ո),
					result  => q(Vo),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(Ո),
					result  => q(VO),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ո),
					result  => q(O),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ո),
					result  => q(vo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ո),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Չ),
					result  => q(Ch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Չ),
					result  => q(CH’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(չ),
					result  => q(ch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Պ),
					result  => q(P),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(պ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ջ),
					result  => q(J),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ջ),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ռ),
					result  => q(Rr),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ռ),
					result  => q(RR),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ռ),
					result  => q(rr),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ս),
					result  => q(S),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ս),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Վ),
					result  => q(V),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(վ),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Տ),
					result  => q(T),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(տ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ր),
					result  => q(R),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ր),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[բգդզթժլխծկհձղճմյնշչպջռսվտրցփքֆ]|[աեէըիոևօւ])),
					replace => q(Ց),
					result  => q(Ts’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ց),
					result  => q(TS’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ց),
					result  => q(ts’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Փ),
					result  => q(P’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(փ),
					result  => q(p’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ք),
					result  => q(K’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ք),
					result  => q(k’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Օ),
					result  => q(O),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(օ),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ֆ),
					result  => q(F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ֆ),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(։),
					result  => q(\.),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
