package Locale::CLDR::Transformations::Bgn::Am::Am_latn;
# This file auto generated from Data\common\transforms\Amharic-Latin-BGN.xml
#	on Sat  4 Aug 10:39:07 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.33.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G[ሀ-᎙])/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ሀ),
					result  => q(hā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሁ),
					result  => q(hu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሂ),
					result  => q(hī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሃ),
					result  => q(ha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሄ),
					result  => q(hē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ህ),
					result  => q(hi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሆ),
					result  => q(ho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ለ),
					result  => q(le),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሉ),
					result  => q(lu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሊ),
					result  => q(lī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ላ),
					result  => q(la),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሌ),
					result  => q(lē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ል),
					result  => q(li),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሎ),
					result  => q(lo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሏ),
					result  => q(lwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሐ),
					result  => q(ḥā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሑ),
					result  => q(ḥu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሒ),
					result  => q(ḥī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሓ),
					result  => q(ḥa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሔ),
					result  => q(ḥē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሕ),
					result  => q(ḥi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሖ),
					result  => q(ḥo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(መ),
					result  => q(me),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሙ),
					result  => q(mu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሚ),
					result  => q(mī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ማ),
					result  => q(ma),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሜ),
					result  => q(mē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ም),
					result  => q(mi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሞ),
					result  => q(mo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሟ),
					result  => q(mwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሠ),
					result  => q(še),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሡ),
					result  => q(šu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሢ),
					result  => q(šī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሣ),
					result  => q(ša),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሤ),
					result  => q(šē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሥ),
					result  => q(ši),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሦ),
					result  => q(šo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ረ),
					result  => q(re),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሩ),
					result  => q(ru),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሪ),
					result  => q(rī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ራ),
					result  => q(ra),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሬ),
					result  => q(rē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ር),
					result  => q(ri),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሮ),
					result  => q(ro),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሯ),
					result  => q(rwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሰ),
					result  => q(se),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሱ),
					result  => q(su),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሲ),
					result  => q(sī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሳ),
					result  => q(sa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሴ),
					result  => q(sē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ስ),
					result  => q(si),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሶ),
					result  => q(so),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሷ),
					result  => q(swa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሸ),
					result  => q(she),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሹ),
					result  => q(shu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሺ),
					result  => q(shī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሻ),
					result  => q(sha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሼ),
					result  => q(shē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሽ),
					result  => q(shi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሾ),
					result  => q(sho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ሿ),
					result  => q(shwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቀ),
					result  => q(k’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቁ),
					result  => q(k’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቂ),
					result  => q(k’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቃ),
					result  => q(k’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቄ),
					result  => q(k’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቅ),
					result  => q(k’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቆ),
					result  => q(k’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቈ),
					result  => q(k’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቍ),
					result  => q(k’wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቋ),
					result  => q(k’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቌ),
					result  => q(k’wē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቊ),
					result  => q(k’wī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቐ),
					result  => q(ḵ’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቑ),
					result  => q(ḵ’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቒ),
					result  => q(ḵ’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቓ),
					result  => q(ḵ’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቔ),
					result  => q(ḵ’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቕ),
					result  => q(ḵ’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቖ),
					result  => q(ḵ’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቘ),
					result  => q(ḵ’wo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቚ),
					result  => q(ḵ’wī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቛ),
					result  => q(ḵ’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቜ),
					result  => q(ḵ’wē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቝ),
					result  => q(ḵ’wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(በ),
					result  => q(be),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቡ),
					result  => q(bu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቢ),
					result  => q(bī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ባ),
					result  => q(ba),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቤ),
					result  => q(bē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ብ),
					result  => q(bi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቦ),
					result  => q(bo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቧ),
					result  => q(bwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ተ),
					result  => q(te),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቱ),
					result  => q(tu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቲ),
					result  => q(tī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ታ),
					result  => q(ta),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቴ),
					result  => q(tē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ት),
					result  => q(ti),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቶ),
					result  => q(to),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቷ),
					result  => q(twa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቸ),
					result  => q(che),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቹ),
					result  => q(chu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቺ),
					result  => q(chī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቻ),
					result  => q(cha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቼ),
					result  => q(chē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ች),
					result  => q(chi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቾ),
					result  => q(cho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቿ),
					result  => q(chwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኀ),
					result  => q(ḫā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኁ),
					result  => q(ḫu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኂ),
					result  => q(ḫī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኃ),
					result  => q(ḫa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኄ),
					result  => q(ḫē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኅ),
					result  => q(ḫi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኆ),
					result  => q(ḫo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኈ),
					result  => q(ḫo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኊ),
					result  => q(ḫwī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኋ),
					result  => q(ḫwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኌ),
					result  => q(ḫwē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኍ),
					result  => q(ḫwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ነ),
					result  => q(ne),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኑ),
					result  => q(nu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኒ),
					result  => q(nī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ና),
					result  => q(na),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኔ),
					result  => q(nē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ን),
					result  => q(ni),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኖ),
					result  => q(no),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኗ),
					result  => q(nwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኘ),
					result  => q(nye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኙ),
					result  => q(nyu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኚ),
					result  => q(nyī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኛ),
					result  => q(nya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኜ),
					result  => q(nyē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኝ),
					result  => q(nyi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኞ),
					result  => q(nyo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኟ),
					result  => q(nywa),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(አ),
					result  => q(ā),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኡ),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኢ),
					result  => q(ī),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኣ),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኤ),
					result  => q(ē),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(እ),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኦ),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ኧ),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(አ),
					result  => q(’ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኡ),
					result  => q(’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኢ),
					result  => q(’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኣ),
					result  => q(’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኤ),
					result  => q(’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(እ),
					result  => q(’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኦ),
					result  => q(’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኧ),
					result  => q(’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ከ),
					result  => q(ke),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኩ),
					result  => q(ku),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኪ),
					result  => q(kī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ካ),
					result  => q(ka),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኬ),
					result  => q(kē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ክ),
					result  => q(ki),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኮ),
					result  => q(ko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኰ),
					result  => q(ko),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኲ),
					result  => q(kwī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኳ),
					result  => q(kwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኴ),
					result  => q(kwē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኵ),
					result  => q(kwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኸ),
					result  => q(ẖe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኹ),
					result  => q(ẖu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኺ),
					result  => q(ẖī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኻ),
					result  => q(ẖa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኼ),
					result  => q(ẖē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኽ),
					result  => q(ẖi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ኾ),
					result  => q(ẖo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ወ),
					result  => q(we),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዉ),
					result  => q(wu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዊ),
					result  => q(wī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዋ),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዌ),
					result  => q(wē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ው),
					result  => q(wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዎ),
					result  => q(wo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዐ),
					result  => q(‘ā),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዑ),
					result  => q(‘u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዒ),
					result  => q(‘ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዓ),
					result  => q(‘a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዔ),
					result  => q(‘ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዕ),
					result  => q(‘i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዖ),
					result  => q(‘o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዘ),
					result  => q(ze),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዙ),
					result  => q(zu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዚ),
					result  => q(zī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዛ),
					result  => q(za),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዜ),
					result  => q(zē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዝ),
					result  => q(zi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዞ),
					result  => q(zo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዟ),
					result  => q(zwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዠ),
					result  => q(zhe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዡ),
					result  => q(zhu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዢ),
					result  => q(zhī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዣ),
					result  => q(zha),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዤ),
					result  => q(zhē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዥ),
					result  => q(zhi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዦ),
					result  => q(zho),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዧ),
					result  => q(zhwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(የ),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዩ),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዪ),
					result  => q(yī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ያ),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዬ),
					result  => q(yē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ይ),
					result  => q(yi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዮ),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ደ),
					result  => q(de),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዱ),
					result  => q(du),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዲ),
					result  => q(dī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዳ),
					result  => q(da),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዴ),
					result  => q(dē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ድ),
					result  => q(di),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዶ),
					result  => q(do),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ዷ),
					result  => q(dwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጀ),
					result  => q(je),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጁ),
					result  => q(ju),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጂ),
					result  => q(jī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጃ),
					result  => q(ja),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጄ),
					result  => q(jē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጅ),
					result  => q(ji),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጆ),
					result  => q(jo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጇ),
					result  => q(jwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ገ),
					result  => q(ge),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጉ),
					result  => q(gu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጊ),
					result  => q(gī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጋ),
					result  => q(ga),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጌ),
					result  => q(gē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ግ),
					result  => q(gi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጎ),
					result  => q(go),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጐ),
					result  => q(go),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጒ),
					result  => q(gwī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጓ),
					result  => q(gwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጔ),
					result  => q(gwē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጕ),
					result  => q(gwi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጠ),
					result  => q(t’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጡ),
					result  => q(t’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጢ),
					result  => q(t’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጣ),
					result  => q(t’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጤ),
					result  => q(t’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጥ),
					result  => q(t’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጦ),
					result  => q(t’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጧ),
					result  => q(t’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጨ),
					result  => q(ch’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጩ),
					result  => q(ch’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጪ),
					result  => q(ch’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጫ),
					result  => q(ch’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጬ),
					result  => q(ch’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጭ),
					result  => q(ch’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጮ),
					result  => q(ch’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጯ),
					result  => q(ch’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጰ),
					result  => q(p’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጱ),
					result  => q(p’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጲ),
					result  => q(p’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጳ),
					result  => q(p’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጴ),
					result  => q(p’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጵ),
					result  => q(p’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጶ),
					result  => q(p’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጷ),
					result  => q(p’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጸ),
					result  => q(ts’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጹ),
					result  => q(ts’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጺ),
					result  => q(ts’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጻ),
					result  => q(ts’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጼ),
					result  => q(ts’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጽ),
					result  => q(ts’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጾ),
					result  => q(ts’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ጿ),
					result  => q(ts’wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፀ),
					result  => q(t͟s’e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፁ),
					result  => q(t͟s’u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፂ),
					result  => q(t͟s’ī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፃ),
					result  => q(t͟s’a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፄ),
					result  => q(t͟s’ē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፅ),
					result  => q(t͟s’i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፆ),
					result  => q(t͟s’o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፈ),
					result  => q(fe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፉ),
					result  => q(fu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፊ),
					result  => q(fī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፋ),
					result  => q(fa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፌ),
					result  => q(fē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፍ),
					result  => q(fi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፎ),
					result  => q(fo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፏ),
					result  => q(fwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፐ),
					result  => q(pe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፑ),
					result  => q(pu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፒ),
					result  => q(pī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፓ),
					result  => q(pa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፔ),
					result  => q(pē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፕ),
					result  => q(pi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፖ),
					result  => q(po),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፗ),
					result  => q(pwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፘ),
					result  => q(rya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፙ),
					result  => q(mya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ፚ),
					result  => q(fya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቨ),
					result  => q(ve),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቩ),
					result  => q(vu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቪ),
					result  => q(vī),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቫ),
					result  => q(va),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቬ),
					result  => q(vē),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቭ),
					result  => q(vi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቮ),
					result  => q(vo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ቯ),
					result  => q(vwa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፩),
					result  => q(1),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፪),
					result  => q(2),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፫),
					result  => q(3),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፬),
					result  => q(4),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፭),
					result  => q(5),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፮),
					result  => q(6),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፯),
					result  => q(7),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፰),
					result  => q(8),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፱),
					result  => q(9),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፲),
					result  => q(10),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፳),
					result  => q(20),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፴),
					result  => q(30),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፵),
					result  => q(40),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፶),
					result  => q(50),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፷),
					result  => q(60),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፸),
					result  => q(70),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፹),
					result  => q(80),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፺),
					result  => q(90),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(፻),
					result  => q(100),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
