package Locale::CLDR::Locales::Bg;
# This file auto generated from Data\common\main\bg.xml
#	on Mon 29 Dec 10:22:43 am GMT
# XML file generated 2014-08-14 15:10:07 -0500 (Thu, 14 Aug 2014)

use version;

our $VERSION = version->declare('v0.26.6');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(едно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четиридесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(петдесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шестдесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седемдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осемдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деветдесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(четиристотин[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(петстотин[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шестстотин[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(седемстотин[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(осемстотин[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(деветстотин[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(хиляда[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиляди[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милиона[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милиард[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милиарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← трилион[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← трилиона[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← квадрилион[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← квадрилиона[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(един),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седем),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осем),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(единадесет),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванадесет),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринадесет),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четиринадесет),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнадесет),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шестнадесет),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седемнадесет),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осемнадесет),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнадесет),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четиридесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(петдесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шестдесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седемдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осемдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деветдесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(четиристотин[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(петстотин[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(шестстотин[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(седемстотин[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(осемстотин[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(деветстотин[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(хиляда[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиляди[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милиона[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милиард[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милиарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← трилион[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← трилиона[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← квадрилион[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← квадрилиона[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-feminine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-feminine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афар',
 				'ab' => 'абхазки',
 				'ace' => 'ачински',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адиге',
 				'ae' => 'авестски',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агем',
 				'ain' => 'айну',
 				'ak' => 'акан',
 				'akk' => 'акадски',
 				'ale' => 'алеутски',
 				'alt' => 'южноалтайски',
 				'am' => 'амхарски',
 				'an' => 'арагонски',
 				'ang' => 'староанглийски',
 				'anp' => 'ангика',
 				'ar' => 'арабски',
 				'ar_001' => 'съвременен стандартен арабски',
 				'arc' => 'арамейски',
 				'arn' => 'мапуче',
 				'arp' => 'арапахо',
 				'arw' => 'аравак',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ast' => 'астурски',
 				'av' => 'аварски',
 				'awa' => 'авади',
 				'ay' => 'аймара',
 				'az' => 'азербайджански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'балучи',
 				'ban' => 'балинейски',
 				'bas' => 'баса',
 				'be' => 'беларуски',
 				'bej' => 'бея',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'български',
 				'bho' => 'божпури',
 				'bi' => 'бислама',
 				'bik' => 'биколски',
 				'bin' => 'бини',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетски',
 				'br' => 'бретонски',
 				'bra' => 'брадж',
 				'brx' => 'бодо',
 				'bs' => 'босненски',
 				'bua' => 'бурятски',
 				'bug' => 'бугински',
 				'byn' => 'биленски',
 				'ca' => 'каталонски',
 				'cad' => 'каддо',
 				'car' => 'карибски',
 				'cch' => 'атсам',
 				'ce' => 'чеченски',
 				'ceb' => 'себуано',
 				'cgg' => 'чига',
 				'ch' => 'чаморо',
 				'chb' => 'чибча',
 				'chg' => 'чагатай',
 				'chk' => 'чуук',
 				'chm' => 'марийски',
 				'chn' => 'жаргон чинуук',
 				'cho' => 'чокто',
 				'chp' => 'чиипувски',
 				'chr' => 'чероки',
 				'chy' => 'чейенски',
 				'ckb' => 'кюрдски (сорани)',
 				'co' => 'корсикански',
 				'cop' => 'коптски',
 				'cr' => 'крии',
 				'crh' => 'кримскотатарски',
 				'cs' => 'чешки',
 				'csb' => 'кашубски',
 				'cu' => 'църковно славянски',
 				'cv' => 'чувашки',
 				'cy' => 'уелски',
 				'da' => 'датски',
 				'dak' => 'дакотски',
 				'dar' => 'даргва',
 				'dav' => 'таита',
 				'de' => 'немски',
 				'de_AT' => 'австрийски немски',
 				'de_CH' => 'швейцарски горногермански',
 				'del' => 'делауер',
 				'den' => 'слейви',
 				'dgr' => 'догриб',
 				'din' => 'динка',
 				'dje' => 'джерма',
 				'doi' => 'догри',
 				'dsb' => 'долнолужишки',
 				'dua' => 'дуала',
 				'dum' => 'средновековен холандски',
 				'dv' => 'дивехи',
 				'dyo' => 'диола',
 				'dyu' => 'диула',
 				'dz' => 'дзонха',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефик',
 				'egy' => 'египетски',
 				'eka' => 'екажук',
 				'el' => 'гръцки',
 				'elx' => 'еламитски',
 				'en' => 'английски',
 				'en_AU' => 'австралийски английски',
 				'en_CA' => 'канадски английски',
 				'en_GB' => 'британски английски',
 				'en_GB@alt=short' => 'английски (GB)',
 				'en_US' => 'американски английски',
 				'en_US@alt=short' => 'английски (US)',
 				'enm' => 'средновековен английски',
 				'eo' => 'есперанто',
 				'es' => 'испански',
 				'es_MX' => 'мексикански испански',
 				'et' => 'естонски',
 				'eu' => 'баски',
 				'ewo' => 'евондо',
 				'fa' => 'персийски',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fj' => 'фиджийски',
 				'fo' => 'фарьорски',
 				'fon' => 'фон',
 				'fr' => 'френски',
 				'fr_CA' => 'канадски френски',
 				'fr_CH' => 'швейцарски френски',
 				'frm' => 'средновековен френски',
 				'fro' => 'старофренски',
 				'frr' => 'северен фризски',
 				'frs' => 'източен фризски',
 				'fur' => 'фриулиански',
 				'fy' => 'фризийски',
 				'ga' => 'ирландски',
 				'gaa' => 'га',
 				'gag' => 'гагаузки',
 				'gay' => 'гайо',
 				'gba' => 'гбая',
 				'gd' => 'шотландски галски',
 				'gez' => 'гииз',
 				'gil' => 'гилбертски',
 				'gl' => 'галисийски',
 				'gmh' => 'средновековен немски',
 				'gn' => 'гуарани',
 				'goh' => 'старовисоконемски',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готически',
 				'grb' => 'гребо',
 				'grc' => 'древногръцки',
 				'gsw' => 'швейцарски немски',
 				'gu' => 'гуджарати',
 				'guz' => 'гусии',
 				'gv' => 'манкски',
 				'gwi' => 'гвичин',
 				'ha' => 'хауза',
 				'hai' => 'хайда',
 				'haw' => 'хавайски',
 				'he' => 'иврит',
 				'hi' => 'хинди',
 				'hil' => 'хилигайнон',
 				'hit' => 'хитски',
 				'hmn' => 'хмонг',
 				'ho' => 'хири моту',
 				'hr' => 'хърватски',
 				'hsb' => 'горнолужишки',
 				'ht' => 'хаитянски',
 				'hu' => 'унгарски',
 				'hup' => 'хупа',
 				'hy' => 'арменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан',
 				'id' => 'индонезийски',
 				'ie' => 'оксидентал',
 				'ig' => 'игбо',
 				'ii' => 'съчуански и',
 				'ik' => 'инупиак',
 				'ilo' => 'илоко',
 				'inh' => 'ингушетски',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италиански',
 				'iu' => 'инуктитут',
 				'ja' => 'японски',
 				'jbo' => 'лоджбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'еврейско-персийски',
 				'jrb' => 'еврейско-арабски',
 				'jv' => 'явански',
 				'ka' => 'грузински',
 				'kaa' => 'каракалпашки',
 				'kab' => 'кабилски',
 				'kac' => 'качински',
 				'kaj' => 'жжи',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардиан',
 				'kcg' => 'туап',
 				'kde' => 'маконде',
 				'kea' => 'кабовердиански',
 				'kfo' => 'коро',
 				'kg' => 'конгоански',
 				'kha' => 'кхаси',
 				'kho' => 'котски',
 				'khq' => 'койра чиини',
 				'ki' => 'кикую',
 				'kj' => 'кваняма',
 				'kk' => 'казахски',
 				'kl' => 'гренландски',
 				'kln' => 'календжин',
 				'km' => 'кхмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'корейски',
 				'koi' => 'коми-пермяцки',
 				'kok' => 'конкани',
 				'kos' => 'косраен',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачай-балкарски',
 				'krl' => 'карелски',
 				'kru' => 'курук',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафия',
 				'ku' => 'кюрдски',
 				'kum' => 'кумикски',
 				'kut' => 'кутенай',
 				'kv' => 'Коми',
 				'kw' => 'корнуолски',
 				'ky' => 'киргизки',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'лахнда',
 				'lam' => 'ламба',
 				'lb' => 'люксембургски',
 				'lez' => 'лезгински',
 				'lg' => 'ганда',
 				'li' => 'лимбургски',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаоски',
 				'lol' => 'монго',
 				'loz' => 'лози',
 				'lt' => 'литовски',
 				'lu' => 'луба катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луисеньо',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'лушаи',
 				'luy' => 'луя',
 				'lv' => 'латвийски',
 				'mad' => 'мадурски',
 				'mag' => 'магахи',
 				'mai' => 'майтхили',
 				'mak' => 'макасар',
 				'man' => 'мандинго',
 				'mas' => 'масайски',
 				'mdf' => 'мокша',
 				'mdr' => 'мандар',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисиен',
 				'mg' => 'малгашки',
 				'mga' => 'средновековен ирландски',
 				'mgh' => 'макуа мето',
 				'mgo' => 'мета',
 				'mh' => 'маршалезе',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангбау',
 				'mk' => 'македонски',
 				'ml' => 'малаялам',
 				'mn' => 'монголски',
 				'mnc' => 'манчжурски',
 				'mni' => 'манипури',
 				'moh' => 'мохоук',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'ms' => 'малайски',
 				'mt' => 'малтийски',
 				'mua' => 'мунданг',
 				'mul' => 'многоезични',
 				'mus' => 'крик',
 				'mwl' => 'мирандийски',
 				'mwr' => 'марвари',
 				'my' => 'бирмански',
 				'myv' => 'ерзиа',
 				'na' => 'науру',
 				'nap' => 'неаполитански',
 				'naq' => 'нама',
 				'nb' => 'норвежки букмол',
 				'nd' => 'северен ндебеле',
 				'nds' => 'долносаксонски',
 				'ne' => 'непалски',
 				'new' => 'неварски',
 				'ng' => 'ндонга',
 				'nia' => 'ниас',
 				'niu' => 'ниуеан',
 				'nl' => 'нидерландски',
 				'nl_BE' => 'фламандски',
 				'nmg' => 'квасио',
 				'nn' => 'норвежки нюношк',
 				'no' => 'норвежки',
 				'nog' => 'ногаи',
 				'non' => 'старонорвежски',
 				'nqo' => 'нко',
 				'nr' => 'южен ндебеле',
 				'nso' => 'северен сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класически невари',
 				'ny' => 'чинянджа',
 				'nym' => 'ниамвези',
 				'nyn' => 'нианколе',
 				'nyo' => 'нуоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оджибва',
 				'om' => 'оромо',
 				'or' => 'ория',
 				'os' => 'осетски',
 				'osa' => 'оседжи',
 				'ota' => 'отомански турски',
 				'pa' => 'пенджабски',
 				'pag' => 'пангасинан',
 				'pal' => 'пехлевийски',
 				'pam' => 'пампанга',
 				'pap' => 'папиаменту',
 				'pau' => 'палауан',
 				'peo' => 'староперсийски',
 				'phn' => 'финикийски',
 				'pi' => 'пали',
 				'pl' => 'полски',
 				'pon' => 'похнпеиан',
 				'pro' => 'провансалски',
 				'ps' => 'пущу',
 				'ps@alt=variant' => 'пущунски',
 				'pt' => 'португалски',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'raj' => 'раджастански',
 				'rap' => 'рапа нуи',
 				'rar' => 'рапотонган',
 				'rm' => 'реторомански',
 				'rn' => 'рунди',
 				'ro' => 'румънски',
 				'ro_MD' => 'молдовски',
 				'rof' => 'ромбо',
 				'rom' => 'цигански език',
 				'root' => 'роот',
 				'ru' => 'руски',
 				'rup' => 'арумънски',
 				'rw' => 'киняруанда',
 				'rwk' => 'рва',
 				'sa' => 'санкскритски',
 				'sad' => 'сандве',
 				'sah' => 'якутски',
 				'sam' => 'самаритански арамейски',
 				'saq' => 'самбуру',
 				'sas' => 'сасак',
 				'sat' => 'сантали',
 				'sbp' => 'сангу',
 				'sc' => 'сардински',
 				'scn' => 'сицилиански',
 				'sco' => 'шотландски',
 				'sd' => 'синдхи',
 				'se' => 'северносаамски',
 				'seh' => 'сена',
 				'sel' => 'селкуп',
 				'ses' => 'койраборо сени',
 				'sg' => 'санго',
 				'sga' => 'староирландски',
 				'sh' => 'сърбохърватски',
 				'shi' => 'ташелхит',
 				'shn' => 'шан',
 				'si' => 'синхалски',
 				'sid' => 'сидамо',
 				'sk' => 'словашки',
 				'sl' => 'словенски',
 				'sm' => 'самоански',
 				'sma' => 'южносаамски',
 				'smj' => 'луле-саамски',
 				'smn' => 'инари-саамски',
 				'sms' => 'сколт-саамски',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалийски',
 				'sog' => 'согдийски',
 				'sq' => 'албански',
 				'sr' => 'сръбски',
 				'srn' => 'сранан тонго',
 				'srr' => 'серер',
 				'ss' => 'суази',
 				'st' => 'сесуто',
 				'su' => 'сундански',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'шумерски',
 				'sv' => 'шведски',
 				'sw' => 'суахили',
 				'swb' => 'коморски',
 				'swc' => 'конгоански суахили',
 				'syc' => 'класически сирийски',
 				'syr' => 'сирийски',
 				'ta' => 'тамилски',
 				'te' => 'телугу',
 				'tem' => 'темне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таджикски',
 				'th' => 'тайски',
 				'ti' => 'тигриня',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелайски',
 				'tl' => 'тагалог',
 				'tlh' => 'клингон',
 				'tli' => 'тлингит',
 				'tmh' => 'тамашек',
 				'tn' => 'тсвана',
 				'to' => 'тонга',
 				'tog' => 'нианса тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'ts' => 'тсонга',
 				'tsi' => 'цимшиански',
 				'tt' => 'татарски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалуански',
 				'tw' => 'туи',
 				'twq' => 'тасавак',
 				'ty' => 'таитянски',
 				'tyv' => 'тувински',
 				'tzm' => 'централноатласки тамазигт',
 				'udm' => 'удмуртски',
 				'ug' => 'уйгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украински',
 				'umb' => 'умбунду',
 				'und' => 'неопределен',
 				'ur' => 'урду',
 				'uz' => 'узбекски',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'виетнамски',
 				'vo' => 'волапюк',
 				'vot' => 'вотик',
 				'vun' => 'вунджо',
 				'wa' => 'валонски',
 				'wal' => 'валамо',
 				'war' => 'варай',
 				'was' => 'уашо',
 				'wo' => 'волоф',
 				'xal' => 'калмик',
 				'xh' => 'ксоса',
 				'xog' => 'сога',
 				'yao' => 'яо',
 				'yap' => 'япезе',
 				'yi' => 'идиш',
 				'yo' => 'йоруба',
 				'yue' => 'кантонски',
 				'za' => 'зуанг',
 				'zap' => 'запотек',
 				'zbl' => 'блис символи',
 				'zen' => 'зенага',
 				'zgh' => 'стандартен марокански тамазигт',
 				'zh' => 'китайски',
 				'zh_Hans' => 'опростен китайски',
 				'zh_Hant' => 'традиционен китайски',
 				'zu' => 'зулуски',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистично съдържание',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арабска',
 			'Arab@alt=variant' => 'персийско-арабска',
 			'Armi' => 'Арамейска',
 			'Armn' => 'арменска',
 			'Avst' => 'Авестанска',
 			'Bali' => 'Балийски',
 			'Batk' => 'Батакска',
 			'Beng' => 'бенгалска',
 			'Blis' => 'Блис символи',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'Брахми',
 			'Brai' => 'Брайлова',
 			'Bugi' => 'Бугинска',
 			'Buhd' => 'Бухид',
 			'Cakm' => 'Чакма',
 			'Cans' => 'Унифицирани символи на канадски аборигени',
 			'Cari' => 'Карийска',
 			'Cham' => 'Хамитска',
 			'Cher' => 'Чероки',
 			'Cirt' => 'Кирт',
 			'Copt' => 'Коптска',
 			'Cprt' => 'Кипърска',
 			'Cyrl' => 'кирилица',
 			'Cyrs' => 'Стар църковно-славянски вариант Кирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'Египетско демотично писмо',
 			'Egyh' => 'Египетско йератично писмо',
 			'Egyp' => 'Египетски йероглифи',
 			'Ethi' => 'етиопска',
 			'Geok' => 'Грузинска хуцури',
 			'Geor' => 'грузинска',
 			'Glag' => 'Глаголическа',
 			'Goth' => 'Готическа',
 			'Grek' => 'гръцка',
 			'Gujr' => 'гуджарати',
 			'Guru' => 'гурмукхи',
 			'Hang' => 'хангъл',
 			'Hani' => 'китайска',
 			'Hano' => 'Хануну',
 			'Hans' => 'опростен',
 			'Hans@alt=stand-alone' => 'опростен китайски',
 			'Hant' => 'традиционен',
 			'Hant@alt=stand-alone' => 'традиционен китайски',
 			'Hebr' => 'иврит',
 			'Hira' => 'хирагана',
 			'Hmng' => 'Пахау хмонг',
 			'Hrkt' => 'Катакана или Хирагана',
 			'Hung' => 'Староунгарска',
 			'Inds' => 'Харапска',
 			'Ital' => 'Древно италийска',
 			'Java' => 'Яванска',
 			'Jpan' => 'японска',
 			'Kali' => 'Кая Ли',
 			'Kana' => 'катакана',
 			'Khar' => 'Кхароштхи',
 			'Khmr' => 'кхмерска',
 			'Knda' => 'каннада',
 			'Kore' => 'корейска',
 			'Kthi' => 'Кайтхи',
 			'Lana' => 'Ланна',
 			'Laoo' => 'лаоска',
 			'Latf' => 'Латинска фрактура',
 			'Latg' => 'Галска латинска',
 			'Latn' => 'латиница',
 			'Lepc' => 'Лепча',
 			'Limb' => 'Лимбу',
 			'Lina' => 'Линейна А',
 			'Linb' => 'Линейна Б',
 			'Lyci' => 'Лицийска',
 			'Lydi' => 'Лидийска',
 			'Mand' => 'Мандаринска',
 			'Mani' => 'Манихейска',
 			'Maya' => 'Йероглифи на Маите',
 			'Mero' => 'Мероитска',
 			'Mlym' => 'малаялам',
 			'Mong' => 'монголска',
 			'Moon' => 'Мун',
 			'Mtei' => 'Манипури',
 			'Mymr' => 'бирманска',
 			'Nkoo' => 'Н’Ко',
 			'Ogam' => 'Огамическа',
 			'Olck' => 'Ол Чики',
 			'Orkh' => 'Орхоно-енисейска',
 			'Orya' => 'ория',
 			'Osma' => 'Османска',
 			'Perm' => 'Древно пермска',
 			'Phag' => 'Фагс-па',
 			'Phlv' => 'Пахлавска',
 			'Phnx' => 'Финикийска',
 			'Plrd' => 'Писменост Полард',
 			'Roro' => 'Ронго-ронго',
 			'Runr' => 'Руническа',
 			'Samr' => 'Самаританска',
 			'Sara' => 'Сарати',
 			'Saur' => 'Саураштра',
 			'Sinh' => 'синхалска',
 			'Sund' => 'Сунданска',
 			'Sylo' => 'Силоти Нагри',
 			'Syrc' => 'Сирийска',
 			'Syre' => 'Сирийска естрангело',
 			'Syrj' => 'Западна сирийска',
 			'Syrn' => 'Източна сирийска',
 			'Tagb' => 'Тагбанва',
 			'Tale' => 'Тай Ле',
 			'Talu' => 'Нова Тай Ле',
 			'Taml' => 'тамилска',
 			'Telu' => 'телугу',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'таана',
 			'Thai' => 'тайска',
 			'Tibt' => 'тибетска',
 			'Ugar' => 'Угаритска',
 			'Vaii' => 'Вайска',
 			'Visp' => 'Видима реч',
 			'Xpeo' => 'Староперсийска',
 			'Xsux' => 'Шумеро-акадски клинопис',
 			'Yiii' => 'Йи',
 			'Zmth' => 'Математически символи',
 			'Zsym' => 'символи',
 			'Zxxx' => 'без писменост',
 			'Zyyy' => 'обща',
 			'Zzzz' => 'непозната писменост',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Земята',
 			'002' => 'Африка',
 			'003' => 'Северноамерикански континент',
 			'005' => 'Южна Америка',
 			'009' => 'Океания',
 			'011' => 'Западна Афирка',
 			'013' => 'Централна Америка',
 			'014' => 'Източна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Южноафрикански регион',
 			'019' => 'Америка',
 			'021' => 'Северна Америка',
 			'029' => 'Карибски регион',
 			'030' => 'Източна Азия',
 			'034' => 'Южна Азия',
 			'035' => 'Югоизточна Азия',
 			'039' => 'Южна Европа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезийски регион',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Централна Азия',
 			'145' => 'Западна Азия',
 			'150' => 'Европа',
 			'151' => 'Източна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'остров Възнесение',
 			'AD' => 'Андора',
 			'AE' => 'Обединени арабски емирства',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа и Барбуда',
 			'AI' => 'Ангуила',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AN' => 'Холандски Антили',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктика',
 			'AR' => 'Аржентина',
 			'AS' => 'Американска Самоа',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Оландски острови',
 			'AZ' => 'Азербайджан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгия',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'България',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен Бартелеми',
 			'BM' => 'Бермуда',
 			'BN' => 'Бруней Дарусалам',
 			'BO' => 'Боливия',
 			'BQ' => 'Карибска Нидерландия',
 			'BR' => 'Бразилия',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'остров Буве',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларус',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокосови острови (острови Кийлинг)',
 			'CD' => 'Демократична република Конго',
 			'CD@alt=variant' => 'Конго (Демократична република)',
 			'CF' => 'Централноафриканска република',
 			'CG' => 'Конго',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот д’Ивоар',
 			'CI@alt=variant' => 'Бряг на слоновата кост',
 			'CK' => 'острови Кук',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Китай',
 			'CO' => 'Колумбия',
 			'CP' => 'остров Клипертон',
 			'CR' => 'Коста Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'остров Рождество',
 			'CY' => 'Кипър',
 			'CZ' => 'Чехия',
 			'DE' => 'Германия',
 			'DG' => 'Диего Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелия',
 			'EC' => 'Еквадор',
 			'EE' => 'Естония',
 			'EG' => 'Египет',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритрея',
 			'ES' => 'Испания',
 			'ET' => 'Етиопия',
 			'EU' => 'Европейски съюз',
 			'FI' => 'Финландия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолклендски острови',
 			'FK@alt=variant' => 'Фолклендски острови (Малвински острови)',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарьорски острови',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Великобритания',
 			'GB@alt=short' => 'Великобритания',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Френска Гвиана',
 			'GG' => 'Гърнси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Екваториална Гвинея',
 			'GR' => 'Гърция',
 			'GS' => 'Южна Джорджия и Южни Сандвичеви острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гаяна',
 			'HK' => 'Хонконг, САР на Китай',
 			'HK@alt=short' => 'Хонконг',
 			'HM' => 'остров Хърд и острови Макдоналд',
 			'HN' => 'Хондурас',
 			'HR' => 'Хърватия',
 			'HT' => 'Хаити',
 			'HU' => 'Унгария',
 			'IC' => 'Канарски острови',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израел',
 			'IM' => 'остров Ман',
 			'IN' => 'Индия',
 			'IO' => 'Британска територия в Индийския океан',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Джърси',
 			'JM' => 'Ямайка',
 			'JO' => 'Йордания',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Киргизстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморски острови',
 			'KN' => 'Сейнт Китс и Невис',
 			'KP' => 'Северна Корея',
 			'KR' => 'Южна Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманови острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сейнт Лусия',
 			'LI' => 'Лихтенщайн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Либия',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черна гора',
 			'MF' => 'Сен Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалови острови',
 			'MK' => 'Македония',
 			'MK@alt=variant' => 'Македония (БЮРМ)',
 			'ML' => 'Мали',
 			'MM' => 'Мианмар (Бирма)',
 			'MN' => 'Монголия',
 			'MO' => 'Макао, САР на Китай',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северни Мариански острови',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсерат',
 			'MT' => 'Малта',
 			'MU' => 'Мавриций',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Нова Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'остров Норфолк',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерландия',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нова Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Френска Полинезия',
 			'PG' => 'Папуа Нова Гвинея',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Полша',
 			'PM' => 'Сен Пиер и Микелон',
 			'PN' => 'Острови Питкерн',
 			'PR' => 'Пуерто Рико',
 			'PS' => 'Палестински територии',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'отдалечени острови на Океания',
 			'RE' => 'Реюнион',
 			'RO' => 'Румъния',
 			'RS' => 'Сърбия',
 			'RU' => 'Русия',
 			'RW' => 'Руанда',
 			'SA' => 'Саудитска Арабия',
 			'SB' => 'Соломонови острови',
 			'SC' => 'Сейшели',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Елена',
 			'SI' => 'Словения',
 			'SJ' => 'Свалбард и Ян Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сиера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалия',
 			'SR' => 'Суринам',
 			'SS' => 'Южен Судан',
 			'ST' => 'Сао Томе и Принсипи',
 			'SV' => 'Салвадор',
 			'SX' => 'Синт Мартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куня',
 			'TC' => 'острови Търкс и Кайкос',
 			'TD' => 'Чад',
 			'TF' => 'Френски южни територии',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Таджикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Източен Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турция',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайван',
 			'TZ' => 'Танзания',
 			'UA' => 'Украйна',
 			'UG' => 'Уганда',
 			'UM' => 'Отдалечени острови на САЩ',
 			'US' => 'Съединени щати',
 			'US@alt=short' => 'САЩ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сейнт Винсънт и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британски Вирджински острови',
 			'VI' => 'Американски Вирджински острови',
 			'VN' => 'Виетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уолис и Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майот',
 			'ZA' => 'Южна Африка',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиционен немски правопис',
 			'1994' => 'Стандартен резиански правопис',
 			'1996' => 'Немски правопис от 1996',
 			'1606NICT' => 'Късен средновековен френски до 1606',
 			'1694ACAD' => 'Ранен съвременен френски',
 			'1959ACAD' => 'Академичен',
 			'AREVELA' => 'Източно арменски',
 			'AREVMDA' => 'Западно арменски',
 			'BAKU1926' => 'Унифицирана тюркска азбука',
 			'BISKE' => 'Диалект Сан Джорджио/Била',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'Международна фонетична азбука',
 			'FONUPA' => 'Уралска фонетична азбука',
 			'KKCOR' => 'Общ правопис',
 			'LIPAW' => 'Диалект Липовац',
 			'MONOTON' => 'Монотонично',
 			'NEDIS' => 'Диалект Натисоне',
 			'NJIVA' => 'Диалект Нджива',
 			'OSOJS' => 'Диалект Осеако/Осояне',
 			'PINYIN' => 'Пинин романизация',
 			'POLYTON' => 'Политонично',
 			'POSIX' => 'Компютърен',
 			'REVISED' => 'Променен правопис',
 			'ROZAJ' => 'Резиански',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шотландски английски',
 			'SCOUSE' => 'Ливърпулски диалект',
 			'SOLBA' => 'Диалект Столвиза',
 			'TARASK' => 'Тарашкевица',
 			'VALENCIA' => 'Валенсиански',
 			'WADEGILE' => 'Уейд-Джайлс романизация',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'календар',
 			'colalternate' => 'Пренебрегване на сортирането по символи',
 			'colbackwards' => 'Сортиране по диакритични знаци в обратен ред',
 			'colcasefirst' => 'Подреждане по горен/долен регистър',
 			'colcaselevel' => 'Сортиране с различаване на регистъра на буквите',
 			'colhiraganaquaternary' => 'Сортиране на кана',
 			'collation' => 'ред на сортиране',
 			'colnormalization' => 'Нормализирано сортиране',
 			'colnumeric' => 'Сортиране на цифрите',
 			'colstrength' => 'Сила на сортиране',
 			'currency' => 'валута',
 			'numbers' => 'цифри',
 			'timezone' => 'Часова зона',
 			'va' => 'Вариант на локала',
 			'variabletop' => 'Сортиране като символи',
 			'x' => 'Собствена употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{будистки календар},
 				'chinese' => q{китайски календар},
 				'coptic' => q{Коптски календар},
 				'dangi' => q{корейски календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{Етиопски календар Амит Алем},
 				'gregorian' => q{григориански календар},
 				'hebrew' => q{еврейски календар},
 				'indian' => q{Индийски граждански календар},
 				'islamic' => q{ислямски календар},
 				'islamic-civil' => q{Ислямски цивилен календар},
 				'iso8601' => q{календар според ISO 8601},
 				'japanese' => q{японски календар},
 				'persian' => q{персийски календар},
 				'roc' => q{календар на Република Китай},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{Сортиране по символи},
 				'shifted' => q{Сортиране с пренебрегване на символи},
 			},
 			'colbackwards' => {
 				'no' => q{Нормално сортиране по диакритични знаци},
 				'yes' => q{Обратно сортиране по диакритични знаци},
 			},
 			'colcasefirst' => {
 				'lower' => q{Сортиране първо по долен регистър},
 				'no' => q{Сортиране с нормален ред за регистъра},
 				'upper' => q{Сортиране първо по горен регистър},
 			},
 			'colcaselevel' => {
 				'no' => q{Сортиране без различаване на регистъра на буквите},
 				'yes' => q{Сортиране с различаване на регистъра на буквите},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{Сортиране на кана отделно},
 				'yes' => q{Сортиране на кана по различен начин},
 			},
 			'collation' => {
 				'big5han' => q{Традиционен китайски (Big5)},
 				'dictionary' => q{Речников ред на сортиране},
 				'ducet' => q{стандартен ред на сортиране в уникод},
 				'gb2312han' => q{Опростен китайски (GB2312)},
 				'phonebook' => q{Азбучен ред},
 				'phonetic' => q{Фонетичен ред на сортиране},
 				'pinyin' => q{Сортиране Пинин},
 				'reformed' => q{Следреформен ред на сортиране},
 				'search' => q{търсене с общо предназначение},
 				'searchjl' => q{Търсене по първоначални съгласни в хангул},
 				'standard' => q{стандартен ред на сортиране},
 				'stroke' => q{Сортиране по щрих},
 				'traditional' => q{Традиционно},
 				'unihan' => q{Ред на сортиране по ключове и черти},
 			},
 			'colnormalization' => {
 				'no' => q{Сортиране без нормализиране},
 				'yes' => q{Нормализирано сортиране в Уникод},
 			},
 			'colnumeric' => {
 				'no' => q{Сортиране на цифрите индивидуално},
 				'yes' => q{Сортиране на цифрите по числена стойност},
 			},
 			'colstrength' => {
 				'identical' => q{Сортиране на всички},
 				'primary' => q{Сортиране само по основни букви},
 				'quaternary' => q{Сортиране по диакритични знаци/регистър/ширина/кана},
 				'secondary' => q{Сортиране по диакритични знаци},
 				'tertiary' => q{Сортиране по диакритични знаци/регистър/ширина},
 			},
 			'numbers' => {
 				'arab' => q{арабско-индийски цифри},
 				'arabext' => q{разширени арабско-индийски цифри},
 				'armn' => q{арменски цифри},
 				'armnlow' => q{арменски цифри в долен регистър},
 				'beng' => q{бенгалски цифри},
 				'deva' => q{цифри в деванагари},
 				'ethi' => q{етиопски цифри},
 				'finance' => q{Финансови цифри},
 				'fullwide' => q{цифри с пълна ширина},
 				'geor' => q{грузински цифри},
 				'grek' => q{гръцки цифри},
 				'greklow' => q{гръцки цифри в долен регистър},
 				'gujr' => q{цифри в гуджарати},
 				'guru' => q{цифри в гурмукхи},
 				'hanidec' => q{китайски десетични цифри},
 				'hans' => q{цифри в опростения китайски},
 				'hansfin' => q{финансови цифри в опростения китайски},
 				'hant' => q{цифри в традиционния китайски},
 				'hantfin' => q{финансови цифри в традиционния китайски},
 				'hebr' => q{цифри в иврит},
 				'jpan' => q{японски цифри},
 				'jpanfin' => q{японски финансови цифри},
 				'khmr' => q{кхмерски цифри},
 				'knda' => q{цифри в каннада},
 				'laoo' => q{лаоски цифри},
 				'latn' => q{западни цифри},
 				'mlym' => q{цифри в малаялам},
 				'mong' => q{Монголски цифри},
 				'mymr' => q{мианмарски цифри},
 				'native' => q{Местни цифри},
 				'orya' => q{цифри в ория},
 				'roman' => q{римски цифри},
 				'romanlow' => q{римски цифри в долен регистър},
 				'taml' => q{традиционни тамилски цифри},
 				'tamldec' => q{тамилски цифри},
 				'telu' => q{цифри в телугу},
 				'thai' => q{тайландски цифри},
 				'tibt' => q{тибетски цифри},
 				'traditional' => q{Традиционни цифри},
 				'vaii' => q{Цифри във ваи},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрична},
 			'UK' => q{имперска},
 			'US' => q{американска},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'АКГН (BGN)',
 			'numeric' => 'Цифрови',
 			'tone' => 'Интонация',
 			'ungegn' => 'ГЕСГИООН (UNGEGN)',
 			'x-accents' => 'Диакритични знаци',
 			'x-fullwidth' => 'С пълна ширина',
 			'x-halfwidth' => 'С половин ширина',
 			'x-jamo' => 'Джамо',
 			'x-pinyin' => 'Пинин',
 			'x-publishing' => 'Типографски',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Език: {0}',
 			'script' => 'Писменост: {0}',
 			'territory' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[{а̀} ѐ ё ѝ {о̀} {у̀} {ъ̀} ы ѣ э {ю̀} {я̀} ѫ])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'],
			main => qr{(?^u:[а б в г д е ж з и й к л м н о п р с т у ф х ц ч ш щ ъ ь ю я])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ‚ " “ „ ( ) \[ \] § * / ″ №])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}… {1}',
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}… {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'1' => q(акри),
						'one' => q({0} акър),
						'other' => q({0} акра),
					},
					'acre-foot' => {
						'1' => q(акър-футове),
						'one' => q({0} акър-фут),
						'other' => q({0} акър-фута),
					},
					'ampere' => {
						'1' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					'arc-minute' => {
						'1' => q(дъгови минути),
						'one' => q({0} дъгова минута),
						'other' => q({0} дъгови минути),
					},
					'arc-second' => {
						'1' => q(дъгови секунди),
						'one' => q({0} дъгова секунда),
						'other' => q({0} дъгови секунди),
					},
					'astronomical-unit' => {
						'1' => q(астрономически единици),
						'one' => q({0} астрономическа единица),
						'other' => q({0} астрономически единици),
					},
					'bit' => {
						'1' => q(битове),
						'one' => q({0} бит),
						'other' => q({0} бита),
					},
					'byte' => {
						'1' => q(байтове),
						'one' => q({0} байт),
						'other' => q({0} байта),
					},
					'calorie' => {
						'1' => q(калории),
						'one' => q({0} калория),
						'other' => q({0} калории),
					},
					'carat' => {
						'1' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'celsius' => {
						'1' => q(градуси Целзий),
						'one' => q({0} градус Целзий),
						'other' => q({0} градуса Целзий),
					},
					'centiliter' => {
						'1' => q(сентилитри),
						'one' => q({0} сентилитър),
						'other' => q({0} сентилитра),
					},
					'centimeter' => {
						'1' => q(сантиметри),
						'one' => q({0} сантиметър),
						'other' => q({0} сантиметра),
					},
					'cubic-centimeter' => {
						'1' => q(кубически сантиметри),
						'one' => q({0} кубически сантиметър),
						'other' => q({0} кубически сантиметра),
					},
					'cubic-foot' => {
						'1' => q(кубически футове),
						'one' => q({0} кубически фут),
						'other' => q({0} кубически фута),
					},
					'cubic-inch' => {
						'1' => q(кубически инчове),
						'one' => q({0} кубически инч),
						'other' => q({0} кубически инча),
					},
					'cubic-kilometer' => {
						'1' => q(кубически километри),
						'one' => q({0} кубически километър),
						'other' => q({0} кубически километра),
					},
					'cubic-meter' => {
						'1' => q(кубически метри),
						'one' => q({0} кубически метър),
						'other' => q({0} кубически метра),
					},
					'cubic-mile' => {
						'1' => q(кубически мили),
						'one' => q({0} кубическа миля),
						'other' => q({0} кубически мили),
					},
					'cubic-yard' => {
						'1' => q(кубически ярдове),
						'one' => q({0} кубически ярд),
						'other' => q({0} кубически ярда),
					},
					'cup' => {
						'1' => q(чаши),
						'one' => q({0} чаша),
						'other' => q({0} чаши),
					},
					'day' => {
						'1' => q(дни),
						'one' => q({0} ден),
						'other' => q({0} дни),
					},
					'deciliter' => {
						'1' => q(децилитри),
						'one' => q({0} децилитър),
						'other' => q({0} децилитра),
					},
					'decimeter' => {
						'1' => q(дециметри),
						'one' => q({0} дециметър),
						'other' => q({0} дециметра),
					},
					'degree' => {
						'1' => q(градуси),
						'one' => q({0} градус),
						'other' => q({0} градуса),
					},
					'fahrenheit' => {
						'1' => q(градуси по Фаренхайт),
						'one' => q({0} градус по Фаренхайт),
						'other' => q({0} градуса по Фаренхайт),
					},
					'fluid-ounce' => {
						'1' => q(течни унции),
						'one' => q({0} течна унция),
						'other' => q({0} течни унции),
					},
					'foodcalorie' => {
						'1' => q(калории),
						'one' => q({0} калория),
						'other' => q({0} калории),
					},
					'foot' => {
						'1' => q(футове),
						'one' => q({0} фут),
						'other' => q({0} фута),
					},
					'g-force' => {
						'1' => q(G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'1' => q(галони),
						'one' => q({0} галона),
						'other' => q({0} галона),
					},
					'gigabit' => {
						'1' => q(гигабити),
						'one' => q({0} гигабит),
						'other' => q({0} гигабита),
					},
					'gigabyte' => {
						'1' => q(гигабайти),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайта),
					},
					'gigahertz' => {
						'1' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерца),
					},
					'gigawatt' => {
						'1' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавата),
					},
					'gram' => {
						'1' => q(грамове),
						'one' => q({0} грам),
						'other' => q({0} грама),
					},
					'hectare' => {
						'1' => q(хектари),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					'hectoliter' => {
						'1' => q(хектолитри),
						'one' => q({0} хектолитър),
						'other' => q({0} хектолитра),
					},
					'hectopascal' => {
						'1' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					'hertz' => {
						'1' => q(херцове),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					'horsepower' => {
						'1' => q(конски сили),
						'one' => q({0} конска сила),
						'other' => q({0} конски сили),
					},
					'hour' => {
						'1' => q({0} за час),
						'one' => q({0} час),
						'other' => q({0} часа),
					},
					'inch' => {
						'1' => q(инчове),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'1' => q(инчове живачен стълб),
						'one' => q({0} инч живачен стълб),
						'other' => q({0} инча живачен стълб),
					},
					'joule' => {
						'1' => q(джаули),
						'one' => q({0} джаул),
						'other' => q({0} джаула),
					},
					'karat' => {
						'1' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'kelvin' => {
						'1' => q(келвини),
						'one' => q({0} келвин),
						'other' => q({0} келвина),
					},
					'kilobit' => {
						'1' => q(килобитове),
						'one' => q({0} килобит),
						'other' => q({0} килобита),
					},
					'kilobyte' => {
						'1' => q(килобайтове),
						'one' => q({0} килобайт),
						'other' => q({0} килобайта),
					},
					'kilocalorie' => {
						'1' => q(килокалории),
						'one' => q({0} килокалория),
						'other' => q({0} килокалории),
					},
					'kilogram' => {
						'1' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
					},
					'kilohertz' => {
						'1' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерца),
					},
					'kilojoule' => {
						'1' => q(килоджаули),
						'one' => q({0} килоджаул),
						'other' => q({0} килоджаула),
					},
					'kilometer' => {
						'1' => q(километри),
						'one' => q({0} километър),
						'other' => q({0} километра),
					},
					'kilometer-per-hour' => {
						'1' => q(километри в час),
						'one' => q({0} километър в час),
						'other' => q({0} километра в час),
					},
					'kilowatt' => {
						'1' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловата),
					},
					'kilowatt-hour' => {
						'1' => q(киловатчаси),
						'one' => q({0} киловатчас),
						'other' => q({0} киловатчаса),
					},
					'light-year' => {
						'1' => q(светлинни години),
						'one' => q({0} светлинна година),
						'other' => q({0} светлинни години),
					},
					'liter' => {
						'1' => q(литри),
						'one' => q({0} литър),
						'other' => q({0} литра),
					},
					'liter-per-kilometer' => {
						'1' => q(литри на километър),
						'one' => q({0} литър на километър),
						'other' => q({0} литра на километър),
					},
					'lux' => {
						'1' => q(луксове),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					'megabit' => {
						'1' => q(мегабитове),
						'one' => q({0} мегабит),
						'other' => q({0} мегабита),
					},
					'megabyte' => {
						'1' => q(мегабайти),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайта),
					},
					'megahertz' => {
						'1' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерца),
					},
					'megaliter' => {
						'1' => q(мегалитри),
						'one' => q({0} мегалитър),
						'other' => q({0} мегалитра),
					},
					'megawatt' => {
						'1' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавата),
					},
					'meter' => {
						'1' => q(метри),
						'one' => q({0} метър),
						'other' => q({0} метра),
					},
					'meter-per-second' => {
						'1' => q(метри за секунда),
						'one' => q({0} метър за секунда),
						'other' => q({0} метра за секунда),
					},
					'meter-per-second-squared' => {
						'1' => q(метри за секунда на квадрат),
						'one' => q({0} метър за секунда на квадрат),
						'other' => q({0} метра за секунда на квадрат),
					},
					'metric-ton' => {
						'1' => q(тонове),
						'one' => q({0} тон),
						'other' => q({0} тона),
					},
					'microgram' => {
						'1' => q(микрограмове),
						'one' => q({0} микрограм),
						'other' => q({0} микрограма),
					},
					'micrometer' => {
						'1' => q(микрометри),
						'one' => q({0} микрометър),
						'other' => q({0} микрометра),
					},
					'microsecond' => {
						'1' => q(микросекунди),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					'mile' => {
						'1' => q(мили),
						'one' => q({0} миля),
						'other' => q({0} мили),
					},
					'mile-per-gallon' => {
						'1' => q(мили с един галон),
						'one' => q({0} миля с един галон),
						'other' => q({0} мили с един галон),
					},
					'mile-per-hour' => {
						'1' => q(мили в час),
						'one' => q({0} миля в час),
						'other' => q({0} мили в час),
					},
					'milliampere' => {
						'1' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампера),
					},
					'millibar' => {
						'1' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					'milligram' => {
						'1' => q(милиграмове),
						'one' => q({0} милиграм),
						'other' => q({0} милиграма),
					},
					'milliliter' => {
						'1' => q(милилитри),
						'one' => q({0} милилитър),
						'other' => q({0} милилитра),
					},
					'millimeter' => {
						'1' => q(милиметри),
						'one' => q({0} милиметър),
						'other' => q({0} милиметра),
					},
					'millimeter-of-mercury' => {
						'1' => q(милиметри живачен стълб),
						'one' => q({0} мм живачен стълб),
						'other' => q({0} мм живачен стълб),
					},
					'millisecond' => {
						'1' => q(милисекунди),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'milliwatt' => {
						'1' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливата),
					},
					'minute' => {
						'1' => q(минути),
						'one' => q({0} минута),
						'other' => q({0} минути),
					},
					'month' => {
						'1' => q(месеци),
						'one' => q({0} месец),
						'other' => q({0} месеца),
					},
					'nanometer' => {
						'1' => q(нанометри),
						'one' => q({0} нанометър),
						'other' => q({0} нанометра),
					},
					'nanosecond' => {
						'1' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					'nautical-mile' => {
						'1' => q(морски мили),
						'one' => q({0} морска миля),
						'other' => q({0} морски мили),
					},
					'ohm' => {
						'1' => q(омове),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					'ounce' => {
						'1' => q(унции),
						'one' => q({0} унция),
						'other' => q({0} унции),
					},
					'ounce-troy' => {
						'1' => q(тройунции),
						'one' => q({0} тройунция),
						'other' => q({0} тройунции),
					},
					'parsec' => {
						'1' => q(парсеци),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					'per' => {
						'1' => q({0} в {1}),
					},
					'picometer' => {
						'1' => q(пикометри),
						'one' => q({0} пикометър),
						'other' => q({0} пикометра),
					},
					'pint' => {
						'1' => q(пинти),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					'pound' => {
						'1' => q(фунтове),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
					},
					'pound-per-square-inch' => {
						'1' => q(фунтове на квадратен инч),
						'one' => q({0} фунт на квадратен инч),
						'other' => q({0} фунта на квадратен инч),
					},
					'quart' => {
						'1' => q(кварти),
						'one' => q({0} кварта),
						'other' => q({0} кварти),
					},
					'radian' => {
						'1' => q(радиани),
						'one' => q({0} радиан),
						'other' => q({0} радиана),
					},
					'second' => {
						'1' => q({0} за секунда),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'square-centimeter' => {
						'1' => q(квадратни сантиметри),
						'one' => q({0} квадратен сантиметър),
						'other' => q({0} квадратни сантиметра),
					},
					'square-foot' => {
						'1' => q(квадратни футове),
						'one' => q({0} квадратен фут),
						'other' => q({0} квадратни фута),
					},
					'square-inch' => {
						'1' => q(квадратни инчове),
						'one' => q({0} квадратен инч),
						'other' => q({0} квадратни инча),
					},
					'square-kilometer' => {
						'1' => q(квадратни километри),
						'one' => q({0} квадратен километър),
						'other' => q({0} квадратни километра),
					},
					'square-meter' => {
						'1' => q(квадратни метри),
						'one' => q({0} квадратен метър),
						'other' => q({0} квадратни метра),
					},
					'square-mile' => {
						'1' => q(квадратни мили),
						'one' => q({0} квадратна миля),
						'other' => q({0} квадратни мили),
					},
					'square-yard' => {
						'1' => q(квадратни ярдове),
						'one' => q({0} квадратен ярд),
						'other' => q({0} квадратни ярда),
					},
					'tablespoon' => {
						'1' => q(супени лъжици),
						'one' => q({0} супена лъжица),
						'other' => q({0} супени лъжици),
					},
					'teaspoon' => {
						'1' => q(чаени лъжици),
						'one' => q({0} чаена лъжица),
						'other' => q({0} чаени лъжици),
					},
					'terabit' => {
						'1' => q(терабитове),
						'one' => q({0} терабит),
						'other' => q({0} терабита),
					},
					'terabyte' => {
						'1' => q(терабайтове),
						'one' => q({0} терабайт),
						'other' => q({0} терабайта),
					},
					'ton' => {
						'1' => q(къси тонове),
						'one' => q({0} къс тон),
						'other' => q({0} къси тона),
					},
					'volt' => {
						'1' => q(волтове),
						'one' => q({0} волт),
						'other' => q({0} волта),
					},
					'watt' => {
						'1' => q(ватове),
						'one' => q({0} ват),
						'other' => q({0} вата),
					},
					'week' => {
						'1' => q(седмици),
						'one' => q({0} седмица),
						'other' => q({0} седмици),
					},
					'yard' => {
						'1' => q(ярдове),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'1' => q(години),
						'one' => q({0} година),
						'other' => q({0} години),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акър),
						'other' => q({0} акра),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'1' => q(°C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					'centimeter' => {
						'1' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} куб. миля),
						'other' => q({0} куб. мили),
					},
					'day' => {
						'1' => q(д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					'foot' => {
						'one' => q({0} фут),
						'other' => q({0} фута),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'1' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} к.с.),
						'other' => q({0} к.с.),
					},
					'hour' => {
						'1' => q(h),
						'one' => q({0} h),
						'other' => q({0} h),
					},
					'inch' => {
						'one' => q({0}"),
						'other' => q({0}"),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'1' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'1' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'1' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} св.г.),
						'other' => q({0} св.г.),
					},
					'liter' => {
						'1' => q(l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'1' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'one' => q({0} миля),
						'other' => q({0} мили),
					},
					'mile-per-hour' => {
						'one' => q({0} миля/ч),
						'other' => q({0} мили/ч),
					},
					'millibar' => {
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'1' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'1' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'1' => q(min),
						'one' => q({0} min),
						'other' => q({0} min),
					},
					'month' => {
						'1' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'ounce' => {
						'one' => q({0} унц.),
						'other' => q({0} унц.),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунта),
					},
					'second' => {
						'1' => q(s),
						'one' => q({0} s),
						'other' => q({0} s),
					},
					'square-foot' => {
						'one' => q({0} кв. фут),
						'other' => q({0} кв. фута),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} кв. миля),
						'other' => q({0} кв. мили),
					},
					'watt' => {
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'1' => q(седм.),
						'one' => q({0} седм.),
						'other' => q({0} седм.),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'1' => q(г),
						'one' => q({0} г),
						'other' => q({0} г),
					},
				},
				'short' => {
					'acre' => {
						'1' => q(акри),
						'one' => q({0} акър),
						'other' => q({0} акра),
					},
					'acre-foot' => {
						'1' => q(акър-футове),
						'one' => q({0} акър-фут),
						'other' => q({0} акър-фута),
					},
					'ampere' => {
						'1' => q(A),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'1' => q(дъгови мин.),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'1' => q(дъгови с),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'1' => q(AU),
						'one' => q({0} AU),
						'other' => q({0} AU),
					},
					'bit' => {
						'1' => q(б),
						'one' => q({0} б),
						'other' => q({0} б),
					},
					'byte' => {
						'1' => q(B),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					'calorie' => {
						'1' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'1' => q(CD),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'1' => q(°C),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					'centiliter' => {
						'1' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
					},
					'centimeter' => {
						'1' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-centimeter' => {
						'1' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
					},
					'cubic-foot' => {
						'1' => q(куб. футове),
						'one' => q({0} куб. фут),
						'other' => q({0} куб. фута),
					},
					'cubic-inch' => {
						'1' => q(куб. инчове),
						'one' => q({0} куб. инч),
						'other' => q({0} куб. инча),
					},
					'cubic-kilometer' => {
						'1' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'1' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
					},
					'cubic-mile' => {
						'1' => q(куб. мили),
						'one' => q({0} куб. миля),
						'other' => q({0} куб. мили),
					},
					'cubic-yard' => {
						'1' => q(куб. ярдове),
						'one' => q({0} куб. ярд),
						'other' => q({0} куб. ярда),
					},
					'cup' => {
						'1' => q(чаши),
						'one' => q({0} чаша),
						'other' => q({0} чаши),
					},
					'day' => {
						'1' => q(дни),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'deciliter' => {
						'1' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
					},
					'decimeter' => {
						'1' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'1' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'1' => q(°F),
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					'fluid-ounce' => {
						'1' => q(т. унц.),
						'one' => q({0} т. унц.),
						'other' => q({0} т. унц.),
					},
					'foodcalorie' => {
						'1' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'foot' => {
						'1' => q(футове),
						'one' => q({0} фут),
						'other' => q({0} фута),
					},
					'g-force' => {
						'1' => q(G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'1' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
					},
					'gigabit' => {
						'1' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'1' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'1' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'1' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'1' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'1' => q(хектари),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'1' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
					},
					'hectopascal' => {
						'1' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'1' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'1' => q(к. с.),
						'one' => q({0} к. с.),
						'other' => q({0} к. с.),
					},
					'hour' => {
						'1' => q({0}/h),
						'one' => q({0} h),
						'other' => q({0} h),
					},
					'inch' => {
						'1' => q(инчове),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'1' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'1' => q(J),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'1' => q(К),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'1' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'1' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'1' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'1' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'1' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilohertz' => {
						'1' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'1' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'1' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'1' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'1' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'1' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'light-year' => {
						'1' => q(св. г.),
						'one' => q({0} св.г.),
						'other' => q({0} св.г.),
					},
					'liter' => {
						'1' => q(литри),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'liter-per-kilometer' => {
						'1' => q(l/km),
						'one' => q({0} l/km),
						'other' => q({0} l/km),
					},
					'lux' => {
						'1' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'1' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'1' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'1' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'1' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
					},
					'megawatt' => {
						'1' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'1' => q(метри),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'1' => q(m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'1' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'1' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'1' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'1' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'1' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'1' => q(мили),
						'one' => q({0} миля),
						'other' => q({0} мили),
					},
					'mile-per-gallon' => {
						'1' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-hour' => {
						'1' => q(мили/ч),
						'one' => q({0} миля/ч),
						'other' => q({0} мили/ч),
					},
					'milliampere' => {
						'1' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'1' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'1' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milliliter' => {
						'1' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
					},
					'millimeter' => {
						'1' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'1' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					'millisecond' => {
						'1' => q(милисекунди),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'1' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'1' => q(min),
						'one' => q({0} min),
						'other' => q({0} min),
					},
					'month' => {
						'1' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
					},
					'nanometer' => {
						'1' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'1' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'1' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'1' => q(Ω),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'1' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
					},
					'ounce-troy' => {
						'1' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					'parsec' => {
						'1' => q(pc),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'1' => q(пикометри),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pint' => {
						'1' => q(пинти),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					'pound' => {
						'1' => q(фунтове),
						'one' => q({0} фунт),
						'other' => q({0} фунта),
					},
					'pound-per-square-inch' => {
						'1' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'1' => q(кварти),
						'one' => q({0} кварта),
						'other' => q({0} кварти),
					},
					'radian' => {
						'1' => q(rad),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'second' => {
						'1' => q({0}/s),
						'one' => q({0} s),
						'other' => q({0} s),
					},
					'square-centimeter' => {
						'1' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
					},
					'square-foot' => {
						'1' => q(кв. футове),
						'one' => q({0} кв. фут),
						'other' => q({0} кв. фута),
					},
					'square-inch' => {
						'1' => q(кв. инчове),
						'one' => q({0} кв. инч),
						'other' => q({0} кв. инча),
					},
					'square-kilometer' => {
						'1' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'1' => q(m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'1' => q(кв. мили),
						'one' => q({0} кв. миля),
						'other' => q({0} кв. мили),
					},
					'square-yard' => {
						'1' => q(кв. ярдове),
						'one' => q({0} кв. ярд),
						'other' => q({0} кв. ярда),
					},
					'tablespoon' => {
						'1' => q(с. л.),
						'one' => q({0} с. л.),
						'other' => q({0} с. л.),
					},
					'teaspoon' => {
						'1' => q(ч. л.),
						'one' => q({0} ч. л.),
						'other' => q({0} ч. л.),
					},
					'terabit' => {
						'1' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'1' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'1' => q(къси тонове),
						'one' => q({0} к. т.),
						'other' => q({0} к. т.),
					},
					'volt' => {
						'1' => q(V),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'1' => q(W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'1' => q(седмици),
						'one' => q({0} седм.),
						'other' => q({0} седм.),
					},
					'yard' => {
						'1' => q(ярдове),
						'one' => q({0} ярд),
						'other' => q({0} ярда),
					},
					'year' => {
						'1' => q(години),
						'one' => q({0} г),
						'other' => q({0} г),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0} и {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 хил'.'',
					'other' => '0 хил'.'',
				},
				'10000' => {
					'one' => '00 хил'.'',
					'other' => '00 хил'.'',
				},
				'100000' => {
					'one' => '000 хил'.'',
					'other' => '000 хил'.'',
				},
				'1000000' => {
					'one' => '0 млн'.'',
					'other' => '0 млн'.'',
				},
				'10000000' => {
					'one' => '00 млн'.'',
					'other' => '00 млн'.'',
				},
				'100000000' => {
					'one' => '000 млн'.'',
					'other' => '000 млн'.'',
				},
				'1000000000' => {
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'one' => '0 трлн'.'',
					'other' => '0 трлн'.'',
				},
				'10000000000000' => {
					'one' => '00 трлн'.'',
					'other' => '00 трлн'.'',
				},
				'100000000000000' => {
					'one' => '000 трлн'.'',
					'other' => '000 трлн'.'',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 хиляда',
					'other' => '0 хиляди',
				},
				'10000' => {
					'one' => '00 хиляди',
					'other' => '00 хиляди',
				},
				'100000' => {
					'one' => '000 хиляди',
					'other' => '000 хиляди',
				},
				'1000000' => {
					'one' => '0 милион',
					'other' => '0 милиона',
				},
				'10000000' => {
					'one' => '00 милиона',
					'other' => '00 милиона',
				},
				'100000000' => {
					'one' => '000 милиона',
					'other' => '000 милиона',
				},
				'1000000000' => {
					'one' => '0 милиард',
					'other' => '0 милиарда',
				},
				'10000000000' => {
					'one' => '00 милиарда',
					'other' => '00 милиарда',
				},
				'100000000000' => {
					'one' => '000 милиарда',
					'other' => '000 милиарда',
				},
				'1000000000000' => {
					'one' => '0 трилион',
					'other' => '0 трилиона',
				},
				'10000000000000' => {
					'one' => '00 трилиона',
					'other' => '00 трилиона',
				},
				'100000000000000' => {
					'one' => '000 трилиона',
					'other' => '000 трилиона',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 хил'.'',
					'other' => '0 хил'.'',
				},
				'10000' => {
					'one' => '00 хил'.'',
					'other' => '00 хил'.'',
				},
				'100000' => {
					'one' => '000 хил'.'',
					'other' => '000 хил'.'',
				},
				'1000000' => {
					'one' => '0 млн'.'',
					'other' => '0 млн'.'',
				},
				'10000000' => {
					'one' => '00 млн'.'',
					'other' => '00 млн'.'',
				},
				'100000000' => {
					'one' => '000 млн'.'',
					'other' => '000 млн'.'',
				},
				'1000000000' => {
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'one' => '0 трлн'.'',
					'other' => '0 трлн'.'',
				},
				'10000000000000' => {
					'one' => '00 трлн'.'',
					'other' => '00 трлн'.'',
				},
				'100000000000000' => {
					'one' => '000 трлн'.'',
					'other' => '000 трлн'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00 ¤)',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска песета),
				'one' => q(андорска песета),
				'other' => q(андорски песети),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Дирхам на Обединените арабски емирства),
				'one' => q(дирхам на Обединените арабски емирства),
				'other' => q(дирхама на Обединените арабски емирства),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Афганистански афган \(1927–2002\)),
				'one' => q(афганистански афган \(1927–2002\)),
				'other' => q(афганистански афгана \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Афганистански афган),
				'one' => q(афганистански афган),
				'other' => q(афганистански афгана),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албански лек),
				'one' => q(албански лек),
				'other' => q(албански лека),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Арменски драм),
				'one' => q(арменски драм),
				'other' => q(арменски драма),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Антилски гулден),
				'one' => q(антилски гулден),
				'other' => q(антилски гулдена),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Анголска кванза),
				'one' => q(анголска кванза),
				'other' => q(анголски кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголска кванца \(1977–1990\)),
				'one' => q(анголска кванца \(1977–1991\)),
				'other' => q(анголски кванци \(1977–1991\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголска нова кванца \(1990–2000\)),
				'one' => q(анголска нова кванца \(1990–2000\)),
				'other' => q(анголски нови кванци \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголска нова кванца \(1995–1999\)),
				'one' => q(анголска нова кванца \(1995–1999\)),
				'other' => q(анголски нови кванци \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аржентински австрал),
				'one' => q(аржентински австрал),
				'other' => q(аржентински австрала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аржентинско песо \(1983–1985\)),
				'one' => q(аржентинско песо \(1983–1985\)),
				'other' => q(аржентински песо \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аржентинско песо),
				'one' => q(аржентинско песо),
				'other' => q(аржентински песо),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Австрийски шилинг),
				'one' => q(австрийски шилинг),
				'other' => q(австрийски шилинга),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралийски долар),
				'one' => q(австралийски долар),
				'other' => q(австралийски долара),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Арубски флорин),
				'one' => q(арубски флорин),
				'other' => q(арубски флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербайджански манат \(1993–2006\)),
				'one' => q(азербайджански манат \(1993–2006\)),
				'other' => q(азербайджански маната \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербайджански манат),
				'one' => q(азербайджански манат),
				'other' => q(азербайджански маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босна и Херцеговина-динар),
				'one' => q(Босна и Херцеговина-динар),
				'other' => q(Босна и Херцеговина-динара),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Босненска конвертируема марка),
				'one' => q(босненска конвертируема марка),
				'other' => q(босненски конвертируеми марки),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадоски долар),
				'one' => q(барбадоски долар),
				'other' => q(барбадоски долара),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладешка така),
				'one' => q(бангладешка така),
				'other' => q(бангладешки таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгийски франк \(конвертируем\)),
				'one' => q(белгийски франк \(конвертируем\)),
				'other' => q(белгийски франка \(конвертируеми\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгийски франк),
				'one' => q(белгийски франк),
				'other' => q(белгийски франка),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгийски франк \(финансов\)),
				'one' => q(белгийски франк \(финансов\)),
				'other' => q(белгийски франка \(финансови\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Български конвертируем лев \(1962–1999\)),
				'one' => q(български конвертируем лев),
				'other' => q(български конвертируеми лева),
			},
		},
		'BGN' => {
			symbol => 'лв.',
			display_name => {
				'currency' => q(Български лев),
				'one' => q(български лев),
				'other' => q(български лева),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахрейнски динар),
				'one' => q(бахрейнски динар),
				'other' => q(бахрейнски динара),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурундийски франк),
				'one' => q(бурундийски франк),
				'other' => q(бурундийски франка),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Бермудски долар),
				'one' => q(бермудски долар),
				'other' => q(бермудски долара),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Брунейски долар),
				'one' => q(брунейски долар),
				'other' => q(брунейски долара),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливийско боливиано),
				'one' => q(боливийско боливиано),
				'other' => q(боливийски боливиано),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливийско песо),
				'one' => q(боливийско песо),
				'other' => q(боливийски песо),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливийски мвдол),
				'one' => q(боливийски мвдол),
				'other' => q(боливийски мвдол),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилско ново крузейро \(1967–1986\)),
				'one' => q(бразилско ново крузейро \(1967–1986\)),
				'other' => q(бразилско ново крузейро \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилско крозадо),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилско крузейро \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(Бразилски реал),
				'one' => q(бразилски реал),
				'other' => q(бразилски реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилско ново крозадо),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилско крузейро),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Бахамски долар),
				'one' => q(бахамски долар),
				'other' => q(бахамски долара),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутански нгултрум),
				'one' => q(бутански нгултрум),
				'other' => q(бутански нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бирмански киат),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Ботсванска пула),
				'one' => q(ботсванска пула),
				'other' => q(ботсвански пули),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Беларуска нова рубла \(1994–1999\)),
				'one' => q(беларуска нова рубла \(1994–1999\)),
				'other' => q(беларуски нови рубли \(1994–1999\)),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Беларуска рубла),
				'one' => q(беларуска рубла),
				'other' => q(беларуски рубли),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белизийски долар),
				'one' => q(белизийски долар),
				'other' => q(белизийски долара),
			},
		},
		'CAD' => {
			symbol => 'CAD',
			display_name => {
				'currency' => q(Канадски долар),
				'one' => q(канадски долар),
				'other' => q(канадски долара),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конгоански франк),
				'one' => q(конгоански франк),
				'other' => q(конгоански франка),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швейцарски франк),
				'one' => q(швейцарски франк),
				'other' => q(швейцарски франка),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франк),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Условна разчетна единица на Чили),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чилийско песо),
				'one' => q(чилийско песо),
				'other' => q(чилийски песо),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(Китайски юан),
				'one' => q(китайски юан),
				'other' => q(китайски юана),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбийско песо),
				'one' => q(колумбийско песо),
				'other' => q(колумбийски песо),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Колумбийска единица на реалната стойност),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Костарикански колон),
				'one' => q(костарикански колон),
				'other' => q(костарикански колона),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стар сръбски динар),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословашка конвертируема крона),
				'one' => q(чехословашка конвертируема крона),
				'other' => q(чехословашки конвертируеми крони),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Кубинско конвертируемо песо),
				'one' => q(кубинско конвертируемо песо),
				'other' => q(кубински конвертируеми песо),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Кубинско песо),
				'one' => q(кубинско песо),
				'other' => q(кубински песо),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Ескудо на Кабо Верде),
				'one' => q(ескудо на Кабо Верде),
				'other' => q(ескудо на Кабо Верде),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипърска лира),
				'one' => q(кипърска лира),
				'other' => q(кипърски лири),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чешка крона),
				'one' => q(чешка крона),
				'other' => q(чешки крони),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Източногерманска марка),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Германска марка),
				'one' => q(германска марка),
				'other' => q(германски марки),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Джибутски франк),
				'one' => q(джибутски франк),
				'other' => q(джибутски франка),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Датска крона),
				'one' => q(датска крона),
				'other' => q(датски крони),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминиканско песо),
				'one' => q(доминиканско песо),
				'other' => q(доминикански песо),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжирски динар),
				'one' => q(алжирски динар),
				'other' => q(алжирски динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорско сукре),
				'one' => q(еквадорско сукре),
				'other' => q(еквадорско сукре),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорска банкова единица),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска крона),
				'one' => q(естонска крона),
				'other' => q(естонски крони),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Египетска лира),
				'one' => q(египетска лира),
				'other' => q(египетски лири),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Еритрейска накфа),
				'one' => q(еритрейска накфа),
				'other' => q(еритрейски накфи),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Испанска песета),
				'one' => q(испанска песета),
				'other' => q(испански песети),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Етиопски бир),
				'one' => q(етиопски бир),
				'other' => q(етиопски бира),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(евро),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финландска марка),
				'one' => q(финландска марка),
				'other' => q(финландски марки),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиджийски долар),
				'one' => q(фиджийски долар),
				'other' => q(фиджийски долара),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фолклендска лира),
				'one' => q(фолклендска лира),
				'other' => q(фолклендски лири),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Френски франк),
				'one' => q(френски франк),
				'other' => q(френски франка),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(Британска лира),
				'one' => q(британска лира),
				'other' => q(британски лири),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузински купон),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузински лари),
				'one' => q(грузински лари),
				'other' => q(грузински лари),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Ганайско седи \(1979–2007\)),
				'one' => q(ганайско седи \(1979–2007\)),
				'other' => q(ганайски седи \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Ганайско седи),
				'one' => q(ганайско седи),
				'other' => q(ганайски седи),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтарска лира),
				'one' => q(гибралтарска лира),
				'other' => q(гибралтарски лири),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбийско даласи),
				'one' => q(гамбийско даласи),
				'other' => q(гамбийски даласи),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинейски франк),
				'one' => q(гвинейски франк),
				'other' => q(гвинейски франка),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинейска сили),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваториално гвинейско еквеле),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Гръцка драхма),
				'one' => q(гръцка драхма),
				'other' => q(гръцки драхми),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемалски кетцал),
				'one' => q(гватемалски кетцал),
				'other' => q(гватемалски кетцала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Ескудо от Португалска Гвинея),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинея-Бисау песо),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гаянски долар),
				'one' => q(гаянски долар),
				'other' => q(гаянски долара),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Хонконгски долар),
				'one' => q(хонконгски долар),
				'other' => q(хонконгски долара),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Хондураска лемпира),
				'one' => q(хондураска лемпира),
				'other' => q(хондураски лемпири),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хърватски динар),
				'one' => q(хърватски динар),
				'other' => q(хърватски динара),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хърватска куна),
				'one' => q(хърватска куна),
				'other' => q(хърватски куни),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Хаитски гурд),
				'one' => q(хаитски гурд),
				'other' => q(хаитски гурда),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Унгарски форинт),
				'one' => q(унгарски форинт),
				'other' => q(унгарски форинта),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонезийска рупия),
				'one' => q(индонезийска рупия),
				'other' => q(индонезийски рупии),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирландска лира),
				'one' => q(ирландска лира),
				'other' => q(ирландски лири),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска лира),
				'one' => q(израелска лира),
				'other' => q(израелски лири),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израелски нов шекел),
				'one' => q(израелски нов шекел),
				'other' => q(израелски нови шекела),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индийска рупия),
				'one' => q(индийска рупия),
				'other' => q(индийски рупии),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Иракски динар),
				'one' => q(иракски динар),
				'other' => q(иракски динара),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Ирански риал),
				'one' => q(ирански риал),
				'other' => q(ирански риала),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландска крона),
				'one' => q(исландска крона),
				'other' => q(исландски крони),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италианска лира),
				'one' => q(италианска лира),
				'other' => q(италиански лири),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Ямайски долар),
				'one' => q(ямайски долар),
				'other' => q(ямайски долара),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Йордански динар),
				'one' => q(йордански динар),
				'other' => q(йордански динара),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(Японска йена),
				'one' => q(японска йена),
				'other' => q(японски йени),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кенийски шилинг),
				'one' => q(кенийски шилинг),
				'other' => q(кенийски шилинга),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Киргизстански сом),
				'one' => q(киргизстански сом),
				'other' => q(киргизстански сома),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Камбоджански риел),
				'one' => q(камбоджански риел),
				'other' => q(камбоджански риела),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморски франк),
				'one' => q(коморски франк),
				'other' => q(коморски франка),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Севернокорейски вон),
				'one' => q(севернокорейски вон),
				'other' => q(севернокорейски вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Южнокорейски вон),
				'one' => q(южнокорейски вон),
				'other' => q(южнокорейски вона),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувейтски динар),
				'one' => q(кувейтски динар),
				'other' => q(кувейтски динара),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Кайманов долар),
				'one' => q(кайманов долар),
				'other' => q(кайманови долара),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Казахстанско тенге),
				'one' => q(казахстанско тенге),
				'other' => q(казахстански тенге),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаоски кип),
				'one' => q(лаоски кип),
				'other' => q(лаоски кипа),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Ливанска лира),
				'one' => q(ливанска лира),
				'other' => q(ливански лири),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шриланкска рупия),
				'one' => q(шриланкска рупия),
				'other' => q(шриланкски рупии),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либерийски долар),
				'one' => q(либерийски долар),
				'other' => q(либерийски долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесотско лоти),
				'one' => q(лесотско лоти),
				'other' => q(лесотски лоти),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Литовски литас),
				'one' => q(литовски литас),
				'other' => q(литовски литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литовски талон),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Люксембургски франк),
				'one' => q(люксембургски франк),
				'other' => q(люксембургски франка),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Латвийски лат),
				'one' => q(латвийски лат),
				'other' => q(латвийски лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвийска рубла),
				'one' => q(латвийска рубла),
				'other' => q(латвийски рубли),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Либийски динар),
				'one' => q(либийски динар),
				'other' => q(либийски динара),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Марокански дирхам),
				'one' => q(марокански дирхам),
				'other' => q(марокански дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франк),
				'one' => q(марокански франк),
				'other' => q(марокански франка),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдовско леу),
				'one' => q(молдовско леу),
				'other' => q(молдовски леу),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малгашко ариари),
				'one' => q(малгашко ариари),
				'other' => q(малгашки ариари),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малгашки франк - Мадагаскар),
				'one' => q(малгашки франк - Мадагаскар),
				'other' => q(малгашки франка - Мадагаскар),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Македонски денар),
				'one' => q(македонски денар),
				'other' => q(македонски денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малийски франк),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мианмарски кият),
				'one' => q(мианмарски кият),
				'other' => q(мианмарски кията),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монголски тугрик),
				'one' => q(монголски тугрик),
				'other' => q(монголски тугрика),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Патака на Макао),
				'one' => q(патака на Макао),
				'other' => q(патаки на Макао),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавританска угия),
				'one' => q(мавританска угия),
				'other' => q(мавритански угии),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтийска лира),
				'one' => q(малтийска лира),
				'other' => q(малтийски лири),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Маврицийска рупия),
				'one' => q(маврицийска рупия),
				'other' => q(маврицийски рупии),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Малдивска руфия),
				'one' => q(малдивска руфия),
				'other' => q(малдивски руфии),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малавийска квача),
				'one' => q(малавийска квача),
				'other' => q(малавийски квачи),
			},
		},
		'MXN' => {
			symbol => 'MXN',
			display_name => {
				'currency' => q(Мексиканско песо),
				'one' => q(мексиканско песо),
				'other' => q(мексикански песо),
			},
		},
		'MXP' => {
			symbol => 'MXP',
			display_name => {
				'currency' => q(Мексиканско сребърно песо \(1861–1992\)),
				'one' => q(мексиканско сребърно песо \(1861–1992\)),
				'other' => q(мексикански сребърни песо \(1861–1992\)),
			},
		},
		'MXV' => {
			symbol => 'MXV',
			display_name => {
				'currency' => q(Мексиканска конвертируема единица \(UDI\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малайзийски рингит),
				'one' => q(малайзийски рингит),
				'other' => q(малайзийски рингита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбикско ескудо),
				'one' => q(мозамбикско ескудо),
				'other' => q(мозамбикски ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Мозамбикски метикал \(1980–2006\)),
				'one' => q(мозамбикски метикал \(1980–2006\)),
				'other' => q(мозамбикски метикала \(1980–2006\)),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбикски метикал),
				'one' => q(мозамбикски метикал),
				'other' => q(мозамбикски метикала),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибийски долар),
				'one' => q(намибийски долар),
				'other' => q(намибийски долара),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигерийска найра),
				'one' => q(нигерийска найра),
				'other' => q(нигерийски найри),
			},
		},
		'NIC' => {
			symbol => 'NIC',
			display_name => {
				'currency' => q(Никарагуанска кордоба \(1988–1991\)),
				'one' => q(никарагуанска кордоба \(1988–1991\)),
				'other' => q(никарагуански кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагуанска кордоба),
				'one' => q(никарагуанска кордоба),
				'other' => q(никарагуански кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'one' => q(холандски гулден),
				'other' => q(холандски гулдена),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвежка крона),
				'one' => q(норвежка крона),
				'other' => q(норвежки крони),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непалска рупия),
				'one' => q(непалска рупия),
				'other' => q(непалски рупии),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'one' => q(новозеландски долар),
				'other' => q(новозеландски долара),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Омански риал),
				'one' => q(омански риал),
				'other' => q(омански риала),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панамска балбоа),
				'one' => q(панамска балбоа),
				'other' => q(панамски балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуанско инти),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перуански нов сол),
				'one' => q(перуански нов сол),
				'other' => q(перуански нови сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
				'one' => q(перуански сол \(1863–1965\)),
				'other' => q(перуански сол \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа-новогвинейска кина),
				'one' => q(папуа-новогвинейска кина),
				'other' => q(папуа-новогвинейски кини),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филипинско песо),
				'one' => q(филипинско песо),
				'other' => q(филипински песо),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистанска рупия),
				'one' => q(пакистанска рупия),
				'other' => q(пакистански рупии),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Полска злота),
				'one' => q(полска злота),
				'other' => q(полски злоти),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Полска злота \(1950–1995\)),
				'one' => q(полска злота \(1950–1995\)),
				'other' => q(полски злоти \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалско ескудо),
				'one' => q(португалско ескудо),
				'other' => q(португалски ескудо),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвайско гуарани),
				'one' => q(парагвайско гуарани),
				'other' => q(парагвайски гуарани),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катарски риал),
				'one' => q(катарски риал),
				'other' => q(катарски риала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родезийски долар),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Стара румънска лея),
				'one' => q(стара румънска лея),
				'other' => q(стари румънски леи),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Румънска лея),
				'one' => q(румънска лея),
				'other' => q(румънски леи),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Сръбски динар),
				'one' => q(сръбски динар),
				'other' => q(сръбски динара),
			},
		},
		'RUB' => {
			symbol => 'руб.',
			display_name => {
				'currency' => q(Руска рубла),
				'one' => q(руска рубла),
				'other' => q(руски рубли),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубла \(1991–1998\)),
				'one' => q(руска рубла \(1991–1998\)),
				'other' => q(руски рубли \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руандски франк),
				'one' => q(руандски франк),
				'other' => q(руандски франка),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Саудитскоарабски риал),
				'one' => q(саудитскоарабски риал),
				'other' => q(саудитскоарабски риала),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Долар на Соломоновите острови),
				'one' => q(долар на Соломоновите острови),
				'other' => q(долара на Соломоновите острови),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сейшелска рупия),
				'one' => q(сейшелска рупия),
				'other' => q(сейшелски рупии),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Судански динар),
				'one' => q(судански динар),
				'other' => q(судански динара),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Суданска лира),
				'one' => q(суданска лира),
				'other' => q(судански лири),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Шведска крона),
				'one' => q(шведска крона),
				'other' => q(шведски крони),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапурски долар),
				'one' => q(сингапурски долар),
				'other' => q(сингапурски долара),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Лира на Света Елена),
				'one' => q(лира на Света Елена),
				'other' => q(лири на Света Елена),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словенски толар),
				'one' => q(словенски толар),
				'other' => q(словенски толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словашка крона),
				'one' => q(словашка крона),
				'other' => q(словашки крони),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сиералеонско леоне),
				'one' => q(сиералеонско леоне),
				'other' => q(сиералеонски леоне),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомалийски шилинг),
				'one' => q(сомалийски шилинг),
				'other' => q(сомалийски шилинга),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринамски долар),
				'one' => q(суринамски долар),
				'other' => q(суринамски долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'one' => q(суринамски гилдер),
				'other' => q(суринамски гилдера),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Южносуданска лира),
				'one' => q(южносуданска лира),
				'other' => q(южносудански лири),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Добра на Сао Томе и Принсипи),
				'one' => q(добра на Сао Томе и Принсипи),
				'other' => q(добра на Сао Томе и Принсипи),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Съветска рубла),
				'one' => q(съветска рубла),
				'other' => q(съветски рубли),
			},
		},
		'SVC' => {
			symbol => 'SVC',
			display_name => {
				'currency' => q(Салвадорски колон),
				'one' => q(салвадорски колон),
				'other' => q(салвадорски колона),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сирийска лира),
				'one' => q(сирийска лира),
				'other' => q(сирийски лири),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазилендски лилангени),
				'one' => q(свазилендски лилангени),
				'other' => q(свазилендски лилангени),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Тайландски бат),
				'one' => q(тайландски бат),
				'other' => q(тайландски бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таджикистанска рубла),
				'one' => q(таджикистанска рубла),
				'other' => q(таджикистански рубли),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Таджикистански сомони),
				'one' => q(таджикистански сомони),
				'other' => q(таджикистански сомони),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат),
				'one' => q(туркменистански манат),
				'other' => q(туркменистански маната),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Туркменски манат),
				'one' => q(туркменски манат),
				'other' => q(туркменски маната),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Тунизийски динар),
				'one' => q(тунизийски динар),
				'other' => q(тунизийски динара),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонганска паанга),
				'one' => q(тонганска паанга),
				'other' => q(тонгански паанги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморско ескудо),
				'one' => q(тиморско ескудо),
				'other' => q(тиморски ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'one' => q(турска лира \(1922–2005\)),
				'other' => q(турски лири \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Турска лира),
				'one' => q(турска лира),
				'other' => q(турски лири),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Долар на Тринидад и Тобаго),
				'one' => q(долар на Тринидад и Тобаго),
				'other' => q(долара на Тринидад и Тобаго),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тайвански долар),
				'one' => q(тайвански долар),
				'other' => q(тайвански долара),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзанийски шилинг),
				'one' => q(танзанийски шилинг),
				'other' => q(танзанийски шилинга),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украинска хривня),
				'one' => q(украинска хривня),
				'other' => q(украински хривни),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украински карбованец),
				'one' => q(украински карбованец),
				'other' => q(украински карбованеца),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандийски шилинг \(1966–1987\)),
				'one' => q(угандийски шилинг \(1966–1987\)),
				'other' => q(угандийски шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Угандски шилинг),
				'one' => q(угандски шилинг),
				'other' => q(угандски шилинга),
			},
		},
		'USD' => {
			symbol => 'щ.д.',
			display_name => {
				'currency' => q(Щатски долар),
				'one' => q(щатски долар),
				'other' => q(щатски долара),
			},
		},
		'USN' => {
			symbol => 'USN',
		},
		'USS' => {
			symbol => 'USS',
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвайско песо \(индекс на инфлацията\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвайско песо \(1975–1993\)),
				'one' => q(уругвайско песо \(1975–1993\)),
				'other' => q(уругвайски песо \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвайско песо),
				'one' => q(уругвайско песо),
				'other' => q(уругвайски песо),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Узбекски сум),
				'one' => q(узбекски сум),
				'other' => q(узбекски сума),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелски боливар \(1871–2008\)),
				'one' => q(венецуелски боливар \(1871–2008\)),
				'other' => q(венецуелски боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венецуелски боливар),
				'one' => q(венецуелски боливар),
				'other' => q(венецуелски боливара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Виетнамски донг),
				'one' => q(виетнамски донг),
				'other' => q(виетнамски донга),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануатско вату),
				'one' => q(вануатско вату),
				'other' => q(вануатски вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоанска тала),
				'one' => q(самоанска тала),
				'other' => q(самоански тали),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Централноафрикански франк),
				'one' => q(централноафрикански франк),
				'other' => q(централноафрикански франка),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европейска съставна единица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европейска валутна единица),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европейска единица по сметка \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европейска единица по сметка \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(Източнокарибски долар),
				'one' => q(източнокарибски долар),
				'other' => q(източнокарибски долара),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Специални права на тираж),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Еку на ЕИО),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Френски златен франк),
				'one' => q(френски златен франк),
				'other' => q(френски златна франка),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Западноафрикански франк),
				'one' => q(западноафрикански франк),
				'other' => q(западноафрикански франка),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладий),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(Френскополинезийски франк),
				'one' => q(френскополинезийски франк),
				'other' => q(френскополинезийски франка),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код резервиран за целите на тестване),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
				'one' => q(\(непозната валута\)),
				'other' => q(\(непозната валута\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Йеменски динар),
				'one' => q(йеменски динар),
				'other' => q(йеменски динара),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Йеменски риал),
				'one' => q(йеменски риал),
				'other' => q(йеменски риала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Югославски твърд динар),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Югославски динар),
				'one' => q(югославски динар),
				'other' => q(югославски динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Югославски конвертируем динар),
				'one' => q(югославски конвертируем динар),
				'other' => q(югославски конвертируеми динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Южноафрикански ранд \(финансов\)),
				'one' => q(южноафрикански ранд \(финансов\)),
				'other' => q(южноафрикански ранда \(финансови\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Южноафрикански ранд),
				'one' => q(южноафрикански ранд),
				'other' => q(южноафрикански ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбийска квача \(1968–2012\)),
				'one' => q(замбийска квача \(1968–2012\)),
				'other' => q(замбийски квачи \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбийска куача),
				'one' => q(замбийска куача),
				'other' => q(замбийски куачи),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирско ново зайре),
				'one' => q(заирско ново зайре),
				'other' => q(заирски нови зайре),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирско зайре),
				'one' => q(заирско зайре),
				'other' => q(заирски зайре),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвийски долар),
				'one' => q(зимбабвийски долар),
				'other' => q(зимбабвийски долара),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвийски долар \(2009\)),
				'one' => q(зимбабвийски долар \(2009\)),
				'other' => q(зимбабвийски долара \(2009\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ян.',
							'февр.',
							'март',
							'апр.',
							'май',
							'юни',
							'юли',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'я',
							'ф',
							'м',
							'а',
							'м',
							'ю',
							'ю',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'януари',
							'февруари',
							'март',
							'април',
							'май',
							'юни',
							'юли',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ян.',
							'февр.',
							'март',
							'апр.',
							'май',
							'юни',
							'юли',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'я',
							'ф',
							'м',
							'а',
							'м',
							'ю',
							'ю',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'януари',
							'февруари',
							'март',
							'април',
							'май',
							'юни',
							'юли',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'тишри',
							'хешван',
							'кислев',
							'тебет',
							'шебат',
							'адар I',
							'адар',
							'нисан',
							'иар',
							'сиван',
							'тамуз',
							'ав',
							'елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'чайтра',
							'вайсакха',
							'джаинтха',
							'асадха',
							'сравана',
							'бхада',
							'азвина',
							'картика',
							'аграхайана',
							'пауза',
							'магха',
							'пхалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'мухарам',
							'сафар',
							'раби-1',
							'раби-2',
							'джумада-1',
							'джумада-2',
							'раджаб',
							'шабан',
							'рамазан',
							'Шавал',
							'Дхул-Каада',
							'Дхул-хиджа'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'сряда',
						thu => 'четвъртък',
						fri => 'петък',
						sat => 'събота',
						sun => 'неделя'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пн',
						tue => 'вт',
						wed => 'ср',
						thu => 'чт',
						fri => 'пт',
						sat => 'сб',
						sun => 'нд'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'сряда',
						thu => 'четвъртък',
						fri => 'петък',
						sat => 'събота',
						sun => 'неделя'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1. трим.',
						1 => '2. трим.',
						2 => '3. трим.',
						3 => '4. трим.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1. тримесечие',
						1 => '2. тримесечие',
						2 => '3. тримесечие',
						3 => '4. тримесечие'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1. трим.',
						1 => '2. трим.',
						2 => '3. трим.',
						3 => '4. трим.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1. тримесечие',
						1 => '2. тримесечие',
						2 => '3. тримесечие',
						3 => '4. тримесечие'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time) = @_;
		SWITCH:
		for ($type) {
			if ($_ eq 'indian') {
				return 'afternoon' if $time >= 1500
					&& $time < 1800;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1800
					&& $time < 2000;
				return 'lateEvening' if $time >= 2000
					&& $time < 2200;
				return 'lateMorning' if $time >= 1000
					&& $time < 1200;
				return 'midDay' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 500
					&& $time < 600;
				return 'night' if $time >= 2200
					&& $time < 2400;
				return 'weeHours' if $time >= 0000
					&& $time < 500;
				return 'morning' if $time >= 600
					&& $time < 1000;
			last SWITCH;
			}
			if ($_ eq 'gregorian') {
				return 'afternoon' if $time >= 1500
					&& $time < 1800;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1800
					&& $time < 2000;
				return 'lateEvening' if $time >= 2000
					&& $time < 2200;
				return 'lateMorning' if $time >= 1000
					&& $time < 1200;
				return 'midDay' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 500
					&& $time < 600;
				return 'night' if $time >= 2200
					&& $time < 2400;
				return 'weeHours' if $time >= 0000
					&& $time < 500;
				return 'morning' if $time >= 600
					&& $time < 1000;
			last SWITCH;
			}
			if ($_ eq 'hebrew') {
				return 'afternoon' if $time >= 1500
					&& $time < 1800;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1800
					&& $time < 2000;
				return 'lateEvening' if $time >= 2000
					&& $time < 2200;
				return 'lateMorning' if $time >= 1000
					&& $time < 1200;
				return 'midDay' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 500
					&& $time < 600;
				return 'night' if $time >= 2200
					&& $time < 2400;
				return 'weeHours' if $time >= 0000
					&& $time < 500;
				return 'morning' if $time >= 600
					&& $time < 1000;
			last SWITCH;
			}
			if ($_ eq 'islamic') {
				return 'afternoon' if $time >= 1500
					&& $time < 1800;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1800
					&& $time < 2000;
				return 'lateEvening' if $time >= 2000
					&& $time < 2200;
				return 'lateMorning' if $time >= 1000
					&& $time < 1200;
				return 'midDay' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 500
					&& $time < 600;
				return 'night' if $time >= 2200
					&& $time < 2400;
				return 'weeHours' if $time >= 0000
					&& $time < 500;
				return 'morning' if $time >= 600
					&& $time < 1000;
			last SWITCH;
			}
			if ($_ eq 'generic') {
				return 'afternoon' if $time >= 1500
					&& $time < 1800;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1800
					&& $time < 2000;
				return 'lateEvening' if $time >= 2000
					&& $time < 2200;
				return 'lateMorning' if $time >= 1000
					&& $time < 1200;
				return 'midDay' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 500
					&& $time < 600;
				return 'night' if $time >= 2200
					&& $time < 2400;
				return 'weeHours' if $time >= 0000
					&& $time < 500;
				return 'morning' if $time >= 600
					&& $time < 1000;
			last SWITCH;
			}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'noon' => q{пл.},
					'am' => q{пр.об.},
					'pm' => q{сл.об.},
				},
				'wide' => {
					'am' => q{пр.об.},
					'noon' => q{пладне},
					'pm' => q{сл.об.},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'пр.Хр.',
				'1' => 'сл.Хр.'
			},
			narrow => {
				'1' => 'сл.н.е.'
			},
			wide => {
				'0' => 'преди Христа',
				'1' => 'след Христа'
			},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM y 'г'. G},
			'long' => q{d MMMM y 'г'. G},
			'medium' => q{d.MM.y 'г'. G},
			'short' => q{d.MM.yy G},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'г'.},
			'long' => q{d MMMM y 'г'.},
			'medium' => q{d.MM.y 'г'.},
			'short' => q{d.MM.yy 'г'.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss zzzz},
			'long' => q{H:mm:ss z},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E, HH:mm},
			EHms => q{E, H:mm:ss},
			Ed => q{E, d},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{y 'г'. G},
			GyMMM => q{MM.y 'г'. G},
			GyMMMEd => q{E, d.MM.y 'г'. G},
			GyMMMM => q{MMMM y 'г'. G},
			GyMMMMEd => q{E, d MMMM y 'г'. G},
			GyMMMMd => q{d MMMM y 'г'. G},
			GyMMMd => q{d.MM.y 'г'. G},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{E, d.MM},
			MMM => q{MM},
			MMMEd => q{E, d.MM},
			MMMM => q{LLLL},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMMdd => q{d MMMM},
			MMMd => q{d.MM},
			Md => q{d.MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{m:ss},
			y => q{y 'г'.},
			yM => q{M.y 'г'.},
			yMEd => q{E, d.MM.y 'г'.},
			yMMM => q{MM.y 'г'.},
			yMMMEd => q{E, d.MM.y 'г'.},
			yMMMM => q{MMMM y 'г'.},
			yMMMMEd => q{E, d MMMM y 'г'.},
			yMMMMd => q{d MMMM y 'г'.},
			yMMMd => q{d.MM.y 'г'.},
			yMd => q{d.MM.y 'г'.},
			yQQQ => q{QQQ y 'г'.},
			yQQQQ => q{QQQQ y 'г'.},
		},
		'generic' => {
			Ed => q{E, d},
			Gy => q{y 'г'. G},
			GyMMM => q{MM.y 'г'. G},
			GyMMMEd => q{E, d.MM.y 'г'. G},
			GyMMMM => q{MMMM y 'г'. G},
			GyMMMMEd => q{E, d MMMM y 'г'. G},
			GyMMMMd => q{d MMMM y 'г'. G},
			GyMMMd => q{d.MM.y 'г'. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{M},
			MEd => q{E, d.MM},
			MMM => q{MM},
			MMMEd => q{E, d.MM},
			MMMM => q{LLLL},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d.MM},
			Md => q{d.MM},
			d => q{d},
			h => q{h},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y 'г'. G},
			yyyy => q{y 'г'. G},
			yyyyM => q{M.y 'г'. G},
			yyyyMEd => q{E, d.MM.y 'г'. G},
			yyyyMMM => q{MM.y 'г'. G},
			yyyyMMMEd => q{E, d.MM.y 'г'. G},
			yyyyMMMM => q{MMMM y 'г'. G},
			yyyyMMMMEd => q{E, d MMMM y 'г'. G},
			yyyyMMMMd => q{d MMMM y 'г'. G},
			yyyyMMMd => q{d.MM.y 'г'. G},
			yyyyMd => q{d.MM.y 'г'. G},
			yyyyQQQ => q{QQQ y 'г'. G},
			yyyyQQQQ => q{QQQQ y 'г'. G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{H – H},
			},
			Hm => {
				H => q{H:mm – H:mm},
				m => q{H:mm – H:mm},
			},
			Hmv => {
				H => q{H:mm – H:mm v},
				m => q{H:mm – H:mm v},
			},
			Hv => {
				H => q{H – H v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d.MM – E, d.MM},
				d => q{E, d.MM – E, d.MM},
			},
			MMM => {
				M => q{MM – MM},
			},
			MMMEd => {
				M => q{E, d.MM – E, d.MM},
				d => q{E, d.MM – E, d.MM},
			},
			MMMM => {
				M => q{LLLL – LLLL},
			},
			MMMMEd => {
				M => q{E, d MMMM – E, d MMMM},
				d => q{E, d MMMM – E, d MMMM},
			},
			MMMMd => {
				M => q{d MMMM – d MMMM},
				d => q{d – d MMMM},
			},
			MMMd => {
				M => q{d.MM – d.MM},
				d => q{d.MM – d.MM},
			},
			Md => {
				M => q{d.MM – d.MM},
				d => q{d.MM – d.MM},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm a – h:mm a v},
				m => q{h:mm a – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y 'г'.},
			},
			yM => {
				M => q{MM.y 'г'. – MM.y 'г'.},
				y => q{MM.y 'г'. – MM.y 'г'.},
			},
			yMEd => {
				M => q{E, d.MM – E, d.MM.y 'г'.},
				d => q{E, d.MM – E, d.MM.y 'г'.},
				y => q{E, d.MM.y 'г'. – E, d.MM.y 'г'.},
			},
			yMMM => {
				M => q{MM.y 'г'. – MM.y 'г'.},
				y => q{MM.y 'г'. – MM.y 'г'.},
			},
			yMMMEd => {
				M => q{E, d.MM – E, d.MM.y 'г'.},
				d => q{E, d.MM – E, d.MM.y 'г'.},
				y => q{E, d.MM.y 'г'. – E, d.MM.y 'г'.},
			},
			yMMMM => {
				M => q{MMMM – MMMM y 'г'.},
				y => q{MMMM y 'г'. – MMMM y 'г'.},
			},
			yMMMMEd => {
				M => q{E, d MMMM – E, d MMMM y 'г'.},
				d => q{E, d MMMM – E, d MMMM y 'г'.},
				y => q{E, d MMMM y 'г'. – E, d MMMM y 'г'.},
			},
			yMMMMd => {
				M => q{d MMMM – d MMMM y 'г'.},
				d => q{d – d MMMM y 'г'.},
				y => q{d MMMM y 'г'. – d MMMM y 'г'.},
			},
			yMMMd => {
				M => q{d.MM – d.MM.y 'г'.},
				d => q{d.MM – d.MM.y 'г'.},
				y => q{d.MM.y 'г'. – d.MM.y 'г'.},
			},
			yMd => {
				M => q{d.MM – d.MM.y 'г'.},
				d => q{d.MM – d.MM.y 'г'.},
				y => q{d.MM.y 'г'. – d.MM.y 'г'.},
			},
		},
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{HH:mm-HH:mm v},
				m => q{HH:mm-HH:mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d.MM – E, d.MM},
				d => q{E, d.MM – E, d.MM},
			},
			MMM => {
				M => q{MM – MM},
			},
			MMMEd => {
				M => q{E, d.MM – E, d.MM},
				d => q{E, d.MM – E, d.MM},
			},
			MMMM => {
				M => q{LLLL – LLLL},
			},
			MMMMEd => {
				M => q{E, d MMMM – E, d MMMM},
				d => q{E, d MMMM – E, d MMMM},
			},
			MMMMd => {
				M => q{d MMMM – d MMMM},
				d => q{d – d MMMM},
			},
			MMMd => {
				M => q{d.MM – d.MM},
				d => q{d.MM – d.MM},
			},
			Md => {
				M => q{d.MM – d.MM},
				d => q{d.MM – d.MM},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y – y 'г'.G},
			},
			yM => {
				M => q{MM – MM.y 'г'. G},
				y => q{MM.y 'г'. – MM.y 'г'. G},
			},
			yMEd => {
				M => q{E, d.MM – E, d.MM.y 'г'. G},
				d => q{E, d.MM – E, d.MM.y 'г'. G},
				y => q{E, d.MM.y 'г'. – E, d.MM.y 'г'. G},
			},
			yMMM => {
				M => q{MM – MM.y 'г'. G},
				y => q{MM.y 'г'. – MM.y 'г'. G},
			},
			yMMMEd => {
				M => q{E, d.MM – E, d.MM.y 'г'. G},
				d => q{E, d.MM – E, d.MM.y 'г'. G},
				y => q{E, d.MM.y 'г'. – E, d.MM.y 'г'. G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y 'г'. G},
				y => q{MMMM y 'г'. – MMMM y 'г'. G},
			},
			yMMMMEd => {
				M => q{E, d MMMM – E, d MMMM y 'г'. G},
				d => q{E, d MMMM – E, d MMMM y 'г'. G},
				y => q{E, d MMMM y 'г'. – E, d MMMM y 'г'. G},
			},
			yMMMMd => {
				M => q{d MMMM – d MMMM y 'г'. G},
				d => q{d – d MMMM y 'г'. G},
				y => q{d MMMM y 'г'. – d MMMM y 'г'. G},
			},
			yMMMd => {
				M => q{d.MM – d.MM.y 'г'. G},
				d => q{d.MM – d.MM.y 'г'. G},
				y => q{d.MM.y 'г'. – d.MM.y 'г'. G},
			},
			yMd => {
				M => q{d.MM – d.MM.y 'г'. G},
				d => q{d.MM – d.MM.y 'г'. G},
				y => q{d.MM.y 'г'. – d.MM.y 'г'. G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(Гринуич{0}),
		gmtZeroFormat => q(Гринуич),
		regionFormat => q({0}),
		regionFormat => q({0} – лятно часово време),
		regionFormat => q({0} – стандартно време),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Афганистанско време),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банджул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайър#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Кайро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар ес Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фрийтаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровия#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Централноафриканско време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Източноафриканско време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Южноафриканско време),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западноафриканско лятно часово време),
				'generic' => q(Западноафриканско време),
				'standard' => q(Западноафриканско стандартно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аляска – лятно часово време),
				'generic' => q(Аляска),
				'standard' => q(Аляска – стандартно време),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазонско лятно часово време),
				'generic' => q(Амазонско време),
				'standard' => q(Амазонско стандартно време),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкъридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангуила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуайна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуая#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баия#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баия де Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Блан-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойси#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кеймбридж Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайманови острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбър#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестън#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Чуяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусън#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусън Крийк#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвър#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмънтън#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Ейрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Търк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гаяна#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосильо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питърсбърг#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Виви#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенс#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Хухуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анджелис#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвил#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуър принсес куотър#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Ню Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ноум#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороня#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бюла#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентър#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Ню Сейлъм#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт ъф Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вельо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуерто Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни Ривър#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Риджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Исабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Пауло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Сгорсбисон#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сейнт Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сейнт Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сейнт Лусия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сейнт Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сейнт Винсънт#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Суифт Кърент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тъндър Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувър#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Уинипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йелоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Северноамериканско централно лятно часово време),
				'generic' => q(Северноамериканско централно време),
				'standard' => q(Северноамериканско централно стандартно време),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Северноамериканско източно лятно часово време),
				'generic' => q(Северноамериканско източно време),
				'standard' => q(Северноамериканско източно стандартно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Северноамериканско планинско лятно часово време),
				'generic' => q(Северноамериканско планинско време),
				'standard' => q(Северноамериканско планинско стандартно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Северноамериканско тихоокеанско лятно часово време),
				'generic' => q(Северноамериканско тихоокеанско време),
				'standard' => q(Северноамериканско тихоокеанско стандартно време),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(Анадир – лятно часово време),
				'generic' => q(Анадир време),
				'standard' => q(Анадир – стандартно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дейвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон Дюрвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусън#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмърдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмър#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Апия – лятно часово време),
				'generic' => q(Апия),
				'standard' => q(Апия – стандартно време),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабско лятно часово време),
				'generic' => q(Арабско време),
				'standard' => q(Арабско стандартно време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгирбюен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аржентинско лятно часово време),
				'generic' => q(Аржентинско време),
				'standard' => q(Аржентинско стандартно време),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Западноаржентинско лятно часово време),
				'generic' => q(Западноаржентинско време),
				'standard' => q(Западноаржентинско стандартно време),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Арменско лятно часово време),
				'generic' => q(Арменско време),
				'standard' => q(Арменско стандартно време),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Банкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чунцин#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джаяпура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Йерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучин#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Арал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхенян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Къзълорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпе#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Северноамериканско атлантическо лятно часово време),
				'generic' => q(Северноамериканско атлантическо време),
				'standard' => q(Северноамериканско атлантическо стандартно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорски о-ви#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермудски острови#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарски о-ви#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарьорски острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Южна Джорджия#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбейн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Броукън Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Къри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбърн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Пърт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидни#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Австралия – централно лятно часово време),
				'generic' => q(Австралия – централно време),
				'standard' => q(Австралия – централно стандартно време),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Австралия – западно централно лятно часово време),
				'generic' => q(Австралия – западно централно време),
				'standard' => q(Австралия – западно централно стандартно време),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Австралия – източно лятно часово време),
				'generic' => q(Австралия – източно време),
				'standard' => q(Австралия – източно стандартно време),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Австралия – западно лятно часово време),
				'generic' => q(Австралия – западно време),
				'standard' => q(Австралия – западно стандартно време),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербайджанско лятно часово време),
				'generic' => q(Азербайджанско време),
				'standard' => q(Азербайджанско стандартно време),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азорски острови – лятно часово време),
				'generic' => q(Азорски острови),
				'standard' => q(Азорски острови – стандартно време),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладешко лятно часово време),
				'generic' => q(Бангладешко време),
				'standard' => q(Бангладешко стандартно време),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутанско време),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливийско време),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилско лятно часово време),
				'generic' => q(Бразилско време),
				'standard' => q(Бразилско стандартно време),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Бруней Даруссалам),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Кабо Верде – лятно часово време),
				'generic' => q(Кабо Верде),
				'standard' => q(Кабо Верде – стандартно време),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморо – стандартно време),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатъм – лятно часово време),
				'generic' => q(Чатъм),
				'standard' => q(Чатъм – стандартно време),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чилийско лятно часово време),
				'generic' => q(Чилийско време),
				'standard' => q(Чилийско стандартно време),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Китайско лятно часово време),
				'generic' => q(Китайско време),
				'standard' => q(Китайско стандартно време),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чойбалсанско лятно часово време),
				'generic' => q(Чойбалсанско време),
				'standard' => q(Чойбалсанско стандартно време),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Остров Рождество),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокосови острови),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбийско лятно часово време),
				'generic' => q(Колумбийско време),
				'standard' => q(Колумбийско стандартно време),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Острови Кук – лятно часово време),
				'generic' => q(Острови Кук),
				'standard' => q(Острови Кук – стандартно време),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Кубинско лятно часово време),
				'generic' => q(Кубинско време),
				'standard' => q(Кубинско стандартно време),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дейвис),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Дюмон Дюрвил),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Източнотиморско време),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Великденски остров – лятно часово време),
				'generic' => q(Великденски остров),
				'standard' => q(Великденски остров – стандартно време),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Еквадорско време),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#неизвестен#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюксел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурещ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапеща#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дъблин#,
			long => {
				'daylight' => q(Ирландско стандартно време),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гърнси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелзинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#о-в Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джърси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Британско лятно часово време),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Севастопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопие#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Виена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожие#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Централноевропейско лятно часово време),
				'generic' => q(Централноевропейско време),
				'standard' => q(Централноевропейско стандартно време),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Източноевропейско лятно часово време),
				'generic' => q(Източноевропейско време),
				'standard' => q(Източноевропейско стандартно време),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Далечно източноевропейско време),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропейско лятно време),
				'generic' => q(Западноевропейско време),
				'standard' => q(Западноевропейско стандартно време),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолклендски острови – лятно часово време),
				'generic' => q(Фолклендски острови),
				'standard' => q(Фолклендски острови – стандартно време),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фиджи – лятно часово време),
				'generic' => q(Фиджи),
				'standard' => q(Фиджи – стандартно време),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Френска Гвиана),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Френски южни и антарктически територии),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Средно гринуичко време),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагоско време),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбие),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузинско лятно часово време),
				'generic' => q(Грузинско време),
				'standard' => q(Грузинско стандартно време),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Острови Гилбърт),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Източногренландско лятно часово време),
				'generic' => q(Източногренландско време),
				'standard' => q(Източногренландско стандартно време),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Западногренландско лятно часово време),
				'generic' => q(Западногренландско време),
				'standard' => q(Западногренландско стандартно време),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Персийски залив),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гаяна),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Хавайско-алеутско лятно часово време),
				'generic' => q(Хавайско-алеутско време),
				'standard' => q(Хавайско-алеутско стандартно време),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Хонконгско лятно часово време),
				'generic' => q(Хонконгско време),
				'standard' => q(Хонконгско стандартно време),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховдско лятно часово време),
				'generic' => q(Ховдско време),
				'standard' => q(Ховдско стандартно време),
			},
		},
		'India' => {
			long => {
				'standard' => q(Индийско стандартно време),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Рождество#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосови острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморски острови#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Мае#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Мавриций#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Индийски океан),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Индокитайско време),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Централноиндонезийско време),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Източноиндонезийско време),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Западноиндонезийско време),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иранско лятно часово време),
				'generic' => q(Иранско време),
				'standard' => q(Иранско стандартно време),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркутско лятно часово време),
				'generic' => q(Иркутско време),
				'standard' => q(Иркутско стандартно време),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израелско лятно часово време),
				'generic' => q(Израелско време),
				'standard' => q(Израелско стандартно време),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Японско лятно часово време),
				'generic' => q(Японско време),
				'standard' => q(Японско стандартно време),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(Петропавловск-Камчатски – лятно часово време),
				'generic' => q(Петропавловск-Камчатски време),
				'standard' => q(Петропавловск-Камчатски стандартно време),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Източноказахстанско време),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Западноказахстанско време),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корейско лятно часово време),
				'generic' => q(Корейско време),
				'standard' => q(Корейско стандартно време),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Кошрай),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Красноярско лятно часово време),
				'generic' => q(Красноярско време),
				'standard' => q(Красноярско стандартно време),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Киргизстанско време),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Екваториални острови),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хау – лятно часово време),
				'generic' => q(Лорд Хау),
				'standard' => q(Лорд Хау – стандартно време),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Маккуори),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магаданско лятно часово време),
				'generic' => q(Магаданско време),
				'standard' => q(Магаданско стандартно време),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малайзийско време),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Малдивски острови),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркизки острови),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалови острови),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Мавриций – лятно часово време),
				'generic' => q(Мавриций),
				'standard' => q(Мавриций – стандартно време),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Моусън),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Мексико – северозападно лятно часово време),
				'generic' => q(Мексико – северозападно време),
				'standard' => q(Мексико – северозападно стандартно време),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Мексиканско тихоокеанско лятно часово време),
				'generic' => q(Мексиканско тихоокеанско време),
				'standard' => q(Мексиканско тихоокеанско стандартно време),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Уланбаторско лятно часово време),
				'generic' => q(Уланбаторско време),
				'standard' => q(Уланбаторско стандартно време),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Московско лятно часово време),
				'generic' => q(Московско време),
				'standard' => q(Московско стандартно време),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мианмарско време),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непалско време),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Новокаледонско лятно часово време),
				'generic' => q(Новокаледонско време),
				'standard' => q(Новокаледонско стандартно време),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Новозеландско лятно часово време),
				'generic' => q(Новозеландско време),
				'standard' => q(Новозеландско стандартно време),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Нюфаундлендско лятно часово време),
				'generic' => q(Нюфаундлендско време),
				'standard' => q(Нюфаундлендско стандартно време),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуе),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Нороня – лятно часово време),
				'generic' => q(Фернандо де Нороня),
				'standard' => q(Фернандо де Нороня – стандартно време),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирско лятно часово време),
				'generic' => q(Новосибирско време),
				'standard' => q(Новосибирско стандартно време),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омско лятно часово време),
				'generic' => q(Омско време),
				'standard' => q(Омско стандартно време),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апия#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Великденски о-в#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендърбъри#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиджи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагоски о-ви#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбие#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстън#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошрай#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Куаджалин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизки о-ви#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарауа#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чуюк#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уолис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистанско лятно часово време),
				'generic' => q(Пакистанско време),
				'standard' => q(Пакистанско стандартно време),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа Нова Гвинея),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвайско лятно часово време),
				'generic' => q(Парагвайско време),
				'standard' => q(Парагвайско стандартно време),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перуанско лятно часово време),
				'generic' => q(Перуанско време),
				'standard' => q(Перуанско стандартно време),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филипинско лятно часово време),
				'generic' => q(Филипинско време),
				'standard' => q(Филипинско стандартно време),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Острови Феникс),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен Пиер и Микелон – лятно часово време),
				'generic' => q(Сен Пиер и Микелон),
				'standard' => q(Сен Пиер и Микелон – стандартно време),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкерн),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понапе),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реюнион),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалинско лятно часово време),
				'generic' => q(Сахалинско време),
				'standard' => q(Сахалинско стандартно време),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара – лятно часово време),
				'generic' => q(Самара време),
				'standard' => q(Самара – стандартно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоанско лятно часово време),
				'generic' => q(Самоанско време),
				'standard' => q(Самоанско стандартно време),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сейшелски острови),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапурско време),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломонови острови),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Южна Джорджия),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринамско време),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Шова),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Таитянско време),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Тайпе – лятно часово време),
				'generic' => q(Тайпе),
				'standard' => q(Тайпе – стандартно време),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Таджикистанско време),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга – лятно часово време),
				'generic' => q(Тонга),
				'standard' => q(Тонга – стандартно време),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чуюк),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Туркменистанско лятно часово време),
				'generic' => q(Туркменистанско време),
				'standard' => q(Туркменистанско стандартно време),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвайско лятно часово време),
				'generic' => q(Уругвайско време),
				'standard' => q(Уругвайско стандартно време),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Узбекистанско лятно часово време),
				'generic' => q(Узбекистанско време),
				'standard' => q(Узбекистанско стандартно време),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату – лятно часово време),
				'generic' => q(Вануату),
				'standard' => q(Вануату – стандартно време),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венецуелско време),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивостокско лятно часово време),
				'generic' => q(Владивостокско време),
				'standard' => q(Владивостокско стандартно време),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоградско лятно часово време),
				'generic' => q(Волгоградско време),
				'standard' => q(Волгоградско стандартно време),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Остров Уейк),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Уолис и Футуна),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Якутскско лятно часово време),
				'generic' => q(Якутско време),
				'standard' => q(Якутскско стандартно време),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Екатеринбургско лятно часово време),
				'generic' => q(Екатеринбургско време),
				'standard' => q(Екатеринбургско стандартно време),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
