#!/usr/local/bin/perl
# Test Geo::Ellipsoid bearing
use Test::More tests => 220;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
use blib;
use strict;
use warnings;

my $e = Geo::Ellipsoid->new(units=>'degrees');
my $az;
$az = $e->bearing(-88.000000, 0.000000,-88.000000, 90.000000);
delta_within( $az, 134.982543210783, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,-88.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,-88.000000, 270.000000);
delta_within( $az, 225.017456789217, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,0.000000, 0.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,0.000000, 90.000000);
delta_within( $az, 90.0105511254454, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,0.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,0.000000, 270.000000);
delta_within( $az, 269.989448874555, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,88.000000, 0.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,88.000000, 90.000000);
delta_within( $az, 45.0249253504956, 0.1 );

$az = $e->bearing(-88.000000, 0.000000,88.000000, 270.000000);
delta_within( $az, 314.975074649504, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,-88.000000, 0.000000);
delta_within( $az, 225.017456789217, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,-88.000000, 180.000000);
delta_within( $az, 134.982543210783, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,-88.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,0.000000, 0.000000);
delta_within( $az, 269.989448874555, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,0.000000, 90.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,0.000000, 180.000000);
delta_within( $az, 90.0105511254454, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,0.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,88.000000, 0.000000);
delta_within( $az, 314.975074649504, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,88.000000, 90.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 90.000000,88.000000, 180.000000);
delta_within( $az, 45.0249253504956, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,-88.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,-88.000000, 90.000000);
delta_within( $az, 225.017456789217, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,-88.000000, 270.000000);
delta_within( $az, 134.982543210783, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,0.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,0.000000, 90.000000);
delta_within( $az, 269.989448874555, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,0.000000, 180.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,0.000000, 270.000000);
delta_within( $az, 90.0105511254454, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,88.000000, 90.000000);
delta_within( $az, 314.975074649504, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,88.000000, 180.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 180.000000,88.000000, 270.000000);
delta_within( $az, 45.0249253504956, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,-88.000000, 0.000000);
delta_within( $az, 134.982543210783, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,-88.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,-88.000000, 180.000000);
delta_within( $az, 225.017456789217, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,0.000000, 0.000000);
delta_within( $az, 90.0105511254454, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,0.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,0.000000, 180.000000);
delta_within( $az, 269.989448874555, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,0.000000, 270.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,88.000000, 0.000000);
delta_within( $az, 45.0249253504956, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,88.000000, 180.000000);
delta_within( $az, 314.975074649504, 0.1 );

$az = $e->bearing(-88.000000, 270.000000,88.000000, 270.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(0.000000, 0.000000,-88.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 0.000000,-88.000000, 90.000000);
delta_within( $az, 177.993277346031, 0.1 );

$az = $e->bearing(0.000000, 0.000000,-88.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 0.000000,-88.000000, 270.000000);
delta_within( $az, 182.006722653969, 0.1 );

$az = $e->bearing(0.000000, 0.000000,0.000000, 90.000000);
delta_within( $az, 90, 0.1 );

$az = $e->bearing(0.000000, 0.000000,0.000000, 270.000000);
delta_within( $az, 270, 0.1 );

$az = $e->bearing(0.000000, 0.000000,88.000000, 0.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(0.000000, 0.000000,88.000000, 90.000000);
delta_within( $az, 2.00672265396903, 0.1 );

$az = $e->bearing(0.000000, 0.000000,88.000000, 180.000000);
delta_within( $az, 2.45853187192722e-16, 0.1 );

$az = $e->bearing(0.000000, 0.000000,88.000000, 270.000000);
delta_within( $az, 357.993277346031, 0.1 );

$az = $e->bearing(0.000000, 90.000000,-88.000000, 0.000000);
delta_within( $az, 182.006722653969, 0.1 );

$az = $e->bearing(0.000000, 90.000000,-88.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 90.000000,-88.000000, 180.000000);
delta_within( $az, 177.993277346031, 0.1 );

$az = $e->bearing(0.000000, 90.000000,-88.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 90.000000,0.000000, 0.000000);
delta_within( $az, 270, 0.1 );

$az = $e->bearing(0.000000, 90.000000,0.000000, 180.000000);
delta_within( $az, 90, 0.1 );

$az = $e->bearing(0.000000, 90.000000,88.000000, 0.000000);
delta_within( $az, 357.993277346031, 0.1 );

$az = $e->bearing(0.000000, 90.000000,88.000000, 90.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(0.000000, 90.000000,88.000000, 180.000000);
delta_within( $az, 2.00672265396903, 0.1 );

$az = $e->bearing(0.000000, 90.000000,88.000000, 270.000000);
delta_within( $az, 2.45853187192722e-16, 0.1 );

$az = $e->bearing(0.000000, 180.000000,-88.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 180.000000,-88.000000, 90.000000);
delta_within( $az, 182.006722653969, 0.1 );

$az = $e->bearing(0.000000, 180.000000,-88.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 180.000000,-88.000000, 270.000000);
delta_within( $az, 177.993277346031, 0.1 );

$az = $e->bearing(0.000000, 180.000000,0.000000, 90.000000);
delta_within( $az, 270, 0.1 );

$az = $e->bearing(0.000000, 180.000000,0.000000, 270.000000);
delta_within( $az, 90, 0.1 );

$az = $e->bearing(0.000000, 180.000000,88.000000, 0.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(0.000000, 180.000000,88.000000, 90.000000);
delta_within( $az, 357.993277346031, 0.1 );

$az = $e->bearing(0.000000, 180.000000,88.000000, 180.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(0.000000, 180.000000,88.000000, 270.000000);
delta_within( $az, 2.00672265396903, 0.1 );

$az = $e->bearing(0.000000, 270.000000,-88.000000, 0.000000);
delta_within( $az, 177.993277346031, 0.1 );

$az = $e->bearing(0.000000, 270.000000,-88.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 270.000000,-88.000000, 180.000000);
delta_within( $az, 182.006722653969, 0.1 );

$az = $e->bearing(0.000000, 270.000000,-88.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(0.000000, 270.000000,0.000000, 0.000000);
delta_within( $az, 90, 0.1 );

$az = $e->bearing(0.000000, 270.000000,0.000000, 180.000000);
delta_within( $az, 270, 0.1 );

$az = $e->bearing(0.000000, 270.000000,88.000000, 0.000000);
delta_within( $az, 2.00672265396903, 0.1 );

$az = $e->bearing(0.000000, 270.000000,88.000000, 90.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(0.000000, 270.000000,88.000000, 180.000000);
delta_within( $az, 357.993277346031, 0.1 );

$az = $e->bearing(0.000000, 270.000000,88.000000, 270.000000);
delta_within( $az, 0, 0.1 );

$az = $e->bearing(88.000000, 0.000000,-88.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 0.000000,-88.000000, 90.000000);
delta_within( $az, 134.975074649506, 0.1 );

$az = $e->bearing(88.000000, 0.000000,-88.000000, 270.000000);
delta_within( $az, 225.024925350494, 0.1 );

$az = $e->bearing(88.000000, 0.000000,0.000000, 0.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 0.000000,0.000000, 90.000000);
delta_within( $az, 89.9894488745546, 0.1 );

$az = $e->bearing(88.000000, 0.000000,0.000000, 180.000000);
delta_within( $az, 7.02101510964039e-15, 0.1 );

$az = $e->bearing(88.000000, 0.000000,0.000000, 270.000000);
delta_within( $az, 270.010551125445, 0.1 );

$az = $e->bearing(88.000000, 0.000000,88.000000, 90.000000);
delta_within( $az, 45.0174567892171, 0.1 );

$az = $e->bearing(88.000000, 0.000000,88.000000, 180.000000);
delta_within( $az, 3.51050755482019e-15, 0.1 );

$az = $e->bearing(88.000000, 0.000000,88.000000, 270.000000);
delta_within( $az, 314.982543210783, 0.1 );

$az = $e->bearing(88.000000, 90.000000,-88.000000, 0.000000);
delta_within( $az, 225.024925350494, 0.1 );

$az = $e->bearing(88.000000, 90.000000,-88.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 90.000000,-88.000000, 180.000000);
delta_within( $az, 134.975074649506, 0.1 );

$az = $e->bearing(88.000000, 90.000000,0.000000, 0.000000);
delta_within( $az, 270.010551125445, 0.1 );

$az = $e->bearing(88.000000, 90.000000,0.000000, 90.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 90.000000,0.000000, 180.000000);
delta_within( $az, 89.9894488745546, 0.1 );

$az = $e->bearing(88.000000, 90.000000,0.000000, 270.000000);
delta_within( $az, 7.02101510964039e-15, 0.1 );

$az = $e->bearing(88.000000, 90.000000,88.000000, 0.000000);
delta_within( $az, 314.982543210783, 0.1 );

$az = $e->bearing(88.000000, 90.000000,88.000000, 180.000000);
delta_within( $az, 45.0174567892171, 0.1 );

$az = $e->bearing(88.000000, 90.000000,88.000000, 270.000000);
delta_within( $az, 3.51050755482019e-15, 0.1 );

$az = $e->bearing(88.000000, 180.000000,-88.000000, 90.000000);
delta_within( $az, 225.024925350494, 0.1 );

$az = $e->bearing(88.000000, 180.000000,-88.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 180.000000,-88.000000, 270.000000);
delta_within( $az, 134.975074649506, 0.1 );

$az = $e->bearing(88.000000, 180.000000,0.000000, 0.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(88.000000, 180.000000,0.000000, 90.000000);
delta_within( $az, 270.010551125445, 0.1 );

$az = $e->bearing(88.000000, 180.000000,0.000000, 180.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 180.000000,0.000000, 270.000000);
delta_within( $az, 89.9894488745546, 0.1 );

$az = $e->bearing(88.000000, 180.000000,88.000000, 0.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(88.000000, 180.000000,88.000000, 90.000000);
delta_within( $az, 314.982543210783, 0.1 );

$az = $e->bearing(88.000000, 180.000000,88.000000, 270.000000);
delta_within( $az, 45.0174567892171, 0.1 );

$az = $e->bearing(88.000000, 270.000000,-88.000000, 0.000000);
delta_within( $az, 134.975074649506, 0.1 );

$az = $e->bearing(88.000000, 270.000000,-88.000000, 180.000000);
delta_within( $az, 225.024925350494, 0.1 );

$az = $e->bearing(88.000000, 270.000000,-88.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 270.000000,0.000000, 0.000000);
delta_within( $az, 89.9894488745546, 0.1 );

$az = $e->bearing(88.000000, 270.000000,0.000000, 90.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(88.000000, 270.000000,0.000000, 180.000000);
delta_within( $az, 270.010551125445, 0.1 );

$az = $e->bearing(88.000000, 270.000000,0.000000, 270.000000);
delta_within( $az, 180, 0.1 );

$az = $e->bearing(88.000000, 270.000000,88.000000, 0.000000);
delta_within( $az, 45.0174567892171, 0.1 );

$az = $e->bearing(88.000000, 270.000000,88.000000, 90.000000);
delta_within( $az, 360, 0.1 );

$az = $e->bearing(88.000000, 270.000000,88.000000, 180.000000);
delta_within( $az, 314.982543210783, 0.1 );

$az = $e->bearing(-57.934266, 269.964713,-71.038589, 313.367482);
delta_within( $az, 143.495982424711, 0.1 );

$az = $e->bearing(13.605417, 282.887733,33.826171, 132.755857);
delta_within( $az, 329.877393304846, 0.1 );

$az = $e->bearing(65.807118, 268.234235,-9.495920, 127.342153);
delta_within( $az, 315.487194712953, 0.1 );

$az = $e->bearing(40.923455, 93.679920,-18.604296, 279.644382);
delta_within( $az, 345.548718774953, 0.1 );

$az = $e->bearing(60.726184, 207.283752,37.934793, 29.881529);
delta_within( $az, 357.929792828869, 0.1 );

$az = $e->bearing(-7.774777, 39.580853,7.960132, 140.647165);
delta_within( $az, 83.5147933078239, 0.1 );

$az = $e->bearing(12.071034, 345.263922,64.718561, 58.748224);
delta_within( $az, 25.5684606529896, 0.1 );

$az = $e->bearing(-39.510429, 93.729994,74.640675, 156.932149);
delta_within( $az, 16.1314169841382, 0.1 );

$az = $e->bearing(50.945112, 45.942126,-73.531799, 338.631126);
delta_within( $az, 200.832170860037, 0.1 );

$az = $e->bearing(-83.498813, 55.515935,-20.735893, 55.705212);
delta_within( $az, 0.199186799984656, 0.1 );

$az = $e->bearing(5.162682, 315.665457,-12.212387, 95.006241);
delta_within( $az, 102.773420623229, 0.1 );

$az = $e->bearing(-32.807368, 277.233007,-69.099205, 277.575212);
delta_within( $az, 179.793034667054, 0.1 );

$az = $e->bearing(36.114418, 78.710277,46.075743, 148.216696);
delta_within( $az, 56.0065080486888, 0.1 );

$az = $e->bearing(26.193521, 334.784252,0.425668, 247.478645);
delta_within( $az, 269.310665743865, 0.1 );

$az = $e->bearing(-11.247993, 218.988327,13.474320, 227.743816);
delta_within( $az, 19.7057344431644, 0.1 );

$az = $e->bearing(-6.437086, 227.607764,-63.660092, 345.874110);
delta_within( $az, 156.810521246297, 0.1 );

$az = $e->bearing(-62.590000, 160.805906,-30.873135, 342.930268);
delta_within( $az, 181.824242572861, 0.1 );

$az = $e->bearing(-24.959632, 143.354960,-70.174449, 343.830865);
delta_within( $az, 186.863601169541, 0.1 );

$az = $e->bearing(85.292583, 207.349229,64.400817, 53.955321);
delta_within( $az, 337.144191000546, 0.1 );

$az = $e->bearing(72.010476, 234.450903,-76.760490, 343.799779);
delta_within( $az, 136.554146907295, 0.1 );

$az = $e->bearing(82.062247, 282.795619,53.709008, 205.651325);
delta_within( $az, 268.118556686811, 0.1 );

$az = $e->bearing(-38.264913, 346.518379,13.987962, 157.269106);
delta_within( $az, 159.131156324152, 0.1 );

$az = $e->bearing(-21.923233, 332.426739,-82.948909, 276.789592);
delta_within( $az, 186.481082703262, 0.1 );

$az = $e->bearing(39.266792, 212.748966,-13.043617, 231.171501);
delta_within( $az, 157.839268087425, 0.1 );

$az = $e->bearing(43.430240, 24.846678,-78.620089, 278.752912);
delta_within( $az, 195.726980930824, 0.1 );

$az = $e->bearing(35.816613, 43.655923,-34.595103, 26.822827);
delta_within( $az, 194.576181045333, 0.1 );

$az = $e->bearing(33.063322, 131.384200,40.382161, 70.051002);
delta_within( $az, 297.178412432248, 0.1 );

$az = $e->bearing(-60.791775, 58.245260,58.472988, 198.337306);
delta_within( $az, 79.0615676823811, 0.1 );

$az = $e->bearing(-32.182827, 189.985094,-11.752936, 76.924247);
delta_within( $az, 247.195040193053, 0.1 );

$az = $e->bearing(40.410413, 0.492949,15.171991, 171.877678);
delta_within( $az, 9.98055464219618, 0.1 );

$az = $e->bearing(77.415003, 274.377083,-65.518823, 5.320166);
delta_within( $az, 114.737218071592, 0.1 );

$az = $e->bearing(-0.001169, 304.117753,61.978146, 32.763058);
delta_within( $az, 28.0963878459979, 0.1 );

$az = $e->bearing(62.964471, 284.016319,13.811810, 35.816077);
delta_within( $az, 64.4264818092797, 0.1 );

$az = $e->bearing(57.757522, 268.990763,71.873398, 184.371272);
delta_within( $az, 327.2750182981, 0.1 );

$az = $e->bearing(67.683592, 346.301076,11.705901, 170.600523);
delta_within( $az, 355.725079106085, 0.1 );

$az = $e->bearing(-14.509993, 234.124251,66.915477, 210.936486);
delta_within( $az, 351.01236525307, 0.1 );

$az = $e->bearing(-48.837869, 359.764786,-59.984409, 250.415053);
delta_within( $az, 214.202392497164, 0.1 );

$az = $e->bearing(35.469166, 355.034035,26.153177, 235.757036);
delta_within( $az, 308.158079735, 0.1 );

$az = $e->bearing(60.579911, 245.437140,82.746095, 119.397052);
delta_within( $az, 349.513862043143, 0.1 );

$az = $e->bearing(52.814462, 57.371114,63.937125, 216.992405);
delta_within( $az, 9.96338244893614, 0.1 );

$az = $e->bearing(-14.087235, 353.288548,64.925852, 167.053343);
delta_within( $az, 3.39185219099383, 0.1 );

$az = $e->bearing(-44.555528, 304.069875,60.410717, 265.142366);
delta_within( $az, 340.693626694262, 0.1 );

$az = $e->bearing(-64.733717, 171.649788,50.043309, 179.133361);
delta_within( $az, 5.30605565409109, 0.1 );

$az = $e->bearing(12.112040, 159.861758,-81.799749, 119.465377);
delta_within( $az, 185.351686923878, 0.1 );

$az = $e->bearing(-12.913136, 209.725263,-72.500921, 242.959763);
delta_within( $az, 169.270961300788, 0.1 );

$az = $e->bearing(15.388763, 84.854820,43.057681, 345.007357);
delta_within( $az, 313.800022958026, 0.1 );

$az = $e->bearing(64.108958, 26.794838,7.006558, 137.813405);
delta_within( $az, 67.9411483566917, 0.1 );

$az = $e->bearing(-87.675134, 257.981187,-78.556203, 7.576067);
delta_within( $az, 119.615115520357, 0.1 );

$az = $e->bearing(45.506762, 226.425777,75.858502, 197.258652);
delta_within( $az, 347.251530908183, 0.1 );

$az = $e->bearing(-15.130062, 141.465980,-53.226032, 110.910346);
delta_within( $az, 205.586864367362, 0.1 );

$az = $e->bearing(-51.171998, 219.992892,-22.538592, 57.834091);
delta_within( $az, 196.966622858705, 0.1 );

$az = $e->bearing(-7.000668, 289.072816,-55.716970, 258.457540);
delta_within( $az, 200.751140142797, 0.1 );

$az = $e->bearing(-4.103181, 51.031553,23.523933, 87.322753);
delta_within( $az, 50.4493441771287, 0.1 );

$az = $e->bearing(-66.149558, 313.732597,-69.799797, 271.586522);
delta_within( $az, 237.915691067636, 0.1 );

$az = $e->bearing(-21.017857, 200.424780,-74.230046, 135.855002);
delta_within( $az, 196.040727615166, 0.1 );

$az = $e->bearing(22.032424, 284.263825,-13.840647, 296.727744);
delta_within( $az, 159.939176654336, 0.1 );

$az = $e->bearing(9.137311, 262.152203,-1.968743, 94.386354);
delta_within( $az, 300.722071086073, 0.1 );

$az = $e->bearing(-0.367684, 176.244258,-1.495746, 305.845852);
delta_within( $az, 92.254200882634, 0.1 );

$az = $e->bearing(73.726080, 130.305234,8.059198, 217.631502);
delta_within( $az, 90.2187469853124, 0.1 );

$az = $e->bearing(19.299877, 158.695298,36.382896, 77.814439);
delta_within( $az, 303.025906398025, 0.1 );

$az = $e->bearing(46.759530, 110.299360,50.379077, 32.324924);
delta_within( $az, 304.633726536012, 0.1 );

$az = $e->bearing(70.152840, 336.092025,82.259265, 222.676574);
delta_within( $az, 342.272975326945, 0.1 );

$az = $e->bearing(-76.222244, 40.691029,22.995327, 26.717480);
delta_within( $az, 346.952142522718, 0.1 );

$az = $e->bearing(10.103669, 84.313406,19.705372, 336.438821);
delta_within( $az, 293.141469167342, 0.1 );

$az = $e->bearing(12.619602, 206.733155,-6.260003, 43.507509);
delta_within( $az, 290.063847557674, 0.1 );

$az = $e->bearing(-46.431748, 359.498721,10.070717, 310.960507);
delta_within( $az, 308.625407534259, 0.1 );

$az = $e->bearing(-37.466916, 262.779852,56.541387, 175.943954);
delta_within( $az, 320.923712804673, 0.1 );

$az = $e->bearing(16.376357, 40.377857,-60.139286, 251.664078);
delta_within( $az, 199.941781738799, 0.1 );

$az = $e->bearing(16.688504, 317.877537,-12.125937, 75.628131);
delta_within( $az, 94.5497924966981, 0.1 );

$az = $e->bearing(-55.936936, 247.494628,-49.609989, 95.206424);
delta_within( $az, 198.465952711615, 0.1 );

$az = $e->bearing(-48.734356, 177.356139,-40.864142, 160.579825);
delta_within( $az, 297.225924659718, 0.1 );

$az = $e->bearing(-46.420266, 106.843903,26.510982, 269.915143);
delta_within( $az, 140.568713323341, 0.1 );

$az = $e->bearing(33.895806, 152.960690,45.681845, 143.422437);
delta_within( $az, 330.990801947478, 0.1 );

$az = $e->bearing(-22.177541, 230.794842,5.952076, 323.707746);
delta_within( $az, 85.6923735369705, 0.1 );

$az = $e->bearing(27.348830, 335.040139,-86.270375, 62.080991);
delta_within( $az, 175.804229852436, 0.1 );

$az = $e->bearing(25.235341, 275.774114,31.035045, 277.375893);
delta_within( $az, 13.3850142160344, 0.1 );

$az = $e->bearing(44.964609, 322.536805,-49.665325, 229.175856);
delta_within( $az, 231.718750704844, 0.1 );

$az = $e->bearing(17.105270, 224.034545,-23.725503, 25.530801);
delta_within( $az, 114.328718330763, 0.1 );

$az = $e->bearing(-43.562030, 129.996443,-2.881152, 181.334105);
delta_within( $az, 63.3777807043478, 0.1 );

$az = $e->bearing(-36.975702, 85.936197,28.597533, 323.170028);
delta_within( $az, 277.258344365826, 0.1 );

$az = $e->bearing(30.175209, 15.545439,59.419522, 205.929510);
delta_within( $az, 354.737516001717, 0.1 );

$az = $e->bearing(-55.644950, 9.518430,-4.344329, 202.739897);
delta_within( $az, 195.068181346622, 0.1 );

$az = $e->bearing(-58.450106, 219.758248,25.011231, 110.301202);
delta_within( $az, 267.404143348047, 0.1 );

$az = $e->bearing(80.393984, 275.743098,23.935568, 24.731901);
delta_within( $az, 67.3009782129282, 0.1 );

$az = $e->bearing(-65.005040, 272.564728,-3.463969, 257.290127);
delta_within( $az, 342.716900592903, 0.1 );

$az = $e->bearing(-67.713271, 230.640539,-17.890516, 254.265464);
delta_within( $az, 28.9708039179722, 0.1 );

$az = $e->bearing(49.977476, 253.823581,-40.736808, 280.971459);
delta_within( $az, 159.64985287105, 0.1 );

$az = $e->bearing(-64.390959, 99.691638,-73.699237, 76.773535);
delta_within( $az, 211.048516722968, 0.1 );

$az = $e->bearing(-53.488147, 222.914699,18.783198, 197.750208);
delta_within( $az, 335.33932853657, 0.1 );

$az = $e->bearing(11.886353, 45.130760,-75.325990, 317.821511);
delta_within( $az, 194.976652815042, 0.1 );

$az = $e->bearing(-61.023376, 203.679753,-32.274576, 120.526333);
delta_within( $az, 258.450398494753, 0.1 );

$az = $e->bearing(-51.815775, 243.455936,-81.006002, 15.254084);
delta_within( $az, 170.437335167331, 0.1 );

$az = $e->bearing(55.609307, 23.266927,36.573196, 147.424699);
delta_within( $az, 43.1196124880041, 0.1 );

$az = $e->bearing(68.261410, 338.284240,-87.468266, 126.278650);
delta_within( $az, 176.004575135045, 0.1 );

$az = $e->bearing(77.163243, 356.912286,-24.865636, 351.624329);
delta_within( $az, 184.912263586077, 0.1 );

$az = $e->bearing(-83.363412, 122.791865,60.930467, 157.757983);
delta_within( $az, 29.30864338025, 0.1 );

$az = $e->bearing(35.819668, 205.416787,-69.790147, 65.110415);
delta_within( $az, 200.024233150533, 0.1 );

$az = $e->bearing(-45.720757, 246.329948,85.378805, 184.898940);
delta_within( $az, 354.403120386001, 0.1 );

$az = $e->bearing(70.557651, 168.054555,-4.512946, 146.711647);
delta_within( $az, 201.95684320969, 0.1 );

$az = $e->bearing(45.494490, 41.408793,-62.327500, 251.688039);
delta_within( $az, 214.896328131679, 0.1 );

