package Eliza::Application;

use strict;
use Chatbot::Eliza;
use OpenFrame::Application;
use base qw (OpenFrame::Application);

my $chatbot = Chatbot::Eliza->new();

sub default {
  my $self = shift;
  my $session = shift;
  my $request = shift;
  my $config = shift;

  my $input = $request->arguments->{input} || 'Hello';
  $self->{input}  = $input;
  $self->{output} = $chatbot->transform($input);
}

1;

__END__

=head1 NAME

Eliza::Application - A module containing the Eliza logic

=head1 DESCRIPTION

C<Eliza::Application> is part of the simple Eliza web application. The
module contains all the logic and presentation for Eliza.

Note that the application only has one entry point: the default()
subroutines. 

The default() entry point is given itself, the session, an abstract
request, and per-application configuration. It then contains
application logic - note that we store a Chatbot::Eliza object inside
C<$self> and that this is magically persistent between calls.

This code is small and clean as the output is generated by
C<Eliza::Generator> later on in the slot process. Any messages are
passed in C<$self>.

=head1 AUTHOR

Leon Brocard <leon@fotango.com>

=head1 COPYRIGHT

Copyright (C) 2001, Fotango Ltd.

This module is free software; you can redistribute it or modify it
under the same terms as Perl itself.
