static const char *marpaESLIFJSON_decode_strict_grammars =
  "                   #####################################################\n"
  "                   # >>>>>>>>>>>>>>> Strict JSON Grammar <<<<<<<<<<<<<<<\n"
  "                   #####################################################\n"
  "\n"
  "# --------------------------------------------------\n"
  "# Meta settings\n"
  "# --------------------------------------------------\n"
  ":desc              ::= 'Strict JSON Grammar'\n"
  ":default           ::= regex-action => marpaESLIFJsonRegexAction fallback-encoding => UTF-8\n"
  "\n"
  "# ---------------------------------\n"
  "# Discard unsignificant whitespaces\n"
  "# ---------------------------------\n"
  ":discard           ::= /[\\x{9}\\x{A}\\x{D}\\x{20}]+/\n"
  "\n"
  "# ----------------\n"
  "# Start is a value\n"
  "# ----------------\n"
  ":start             ::= value\n"
  "\n"
  "# ----------\n"
  "# JSON value\n"
  "# ----------\n"
  "value              ::= object\n"
  "                     | array\n"
  "                     | string\n"
  "                     | constant_or_number\n"
  "\n"
  "# -----------\n"
  "# JSON object\n"
  "# -----------\n"
  "object             ::= /\\{(?C10)/ members /\\}(?C20)/\n"
  "members            ::= pair*              separator => comma proper => 1 # Strict comma separator\n"
  "pair               ::= string ':' value\n"
  "\n"
  "# ----------\n"
  "# JSON Array\n"
  "# ----------\n"
  "array              ::= /\\[(?C30)/ elements /\\](?C40)/\n"
  "elements           ::= value*             separator => comma proper => 1 # Strict comma separator\n"
  "\n"
  "# -----------\n"
  "# JSON String\n"
  "# -----------\n"
  "string             ::= /\"(?C50)(?:((?:[^\"\\\\\\x00-\\x1F]+)|(?:\\\\[\"\\\\\\/bfnrt])|(?:(?:\\\\u[[:xdigit:]]{4})+))(?C51))*\"(?C52)/\n"
  "\n"
  "\n"
  "# -----------------------\n"
  "# JSON constant or number\n"
  "# -----------------------\n"
  "constant_or_number ::= /true(?C60)|false(?C61)|null(?C62)|(?:-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?)(?C63)/\n"
  "\n"
  "# ---------\n"
  "# Separator\n"
  "# ---------\n"
  "comma              ::= ','\n"
  ;
