# This Makefile.PL for MarpaX-ESLIF was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008;
use ExtUtils::MakeMaker;

BEGIN {
  use File::Spec;                     # Formally it is not necessary I believe to do it here
  # Make sure we have our 'inc' directory in the perl search path
  my $inc_dir = File::Spec->catdir(File::Spec->curdir, 'inc');
  push(@INC, $inc_dir);
  #
  # ExtUtils::CppGuess does not install everywhere.
  # This is why we provide it explicitely, we are ok if it fails at run-time
  # (eg. on solaris).
  #
  eval 'use ExtUtils::CppGuess; 1;' || die "$@";
}
use Config;
use Config::AutoConf;
use ExtUtils::Constant qw /constant_types C_constant XS_constant autoload/;
use File::Basename;
use File::Find;
use IO::Handle;
use IPC::Run qw/run/;
use Perl::OSType qw/is_os_type/;
use Try::Tiny;

autoflush STDOUT 1;

# iconv dependency is the trickest thing
# On non-Windows platforms we have to check if iconv is in libc or not -;
# On windows it is using dlfcn-win32 that will imply a dependency on psapi. We verify this library is available
#
my $iconv_lib = '';
my ($cpp_compiler, $cpp_libs);
try {
   ($cpp_compiler, $cpp_libs) = guess_compiler();
} catch {
   print STDOUT "ExtUtils::CppGuess failure, $_\n";
   #
   # Try ourself. guess_compiler() fails when this is not a gcc compiler.
   #
   if (is_os_type('Unix', 'solaris') || is_os_type('Unix', 'sunos')) {
     #
     # So this is very very probably native Sun cc, so CC should be used for C++ files
     #
     print STDOUT "Solaris/SunOS special CXX settings: setting environment variables CXX=CC, CXXFLAGS= and cpp_libs=-lCrun\n";
     $ENV{CXX} = 'CC';
     $ENV{CXXFLAGS} = '';
     ($cpp_compiler, $cpp_libs) = ('CC', '-lCrun');
   } else {
     ($cpp_compiler, $cpp_libs) = ('cc', '');
   }
};
if (! is_os_type('Windows')) {
  print "# Determining iconv location\n";
  foreach my $this_lib ('', 'iconv', 'iconv-2') {
    my $ac = Config::AutoConf->new();
    $ac->check_cc;
    $ac->msg_checking(sprintf "iconv is in %s library", $this_lib || 'standard');
    my $conftest = $ac->lang_build_program("#include <stdlib.h>\n#include <iconv.h>", "{iconv_t cd; iconv(cd, NULL, NULL, NULL, NULL);}");
    $ac->push_libraries($this_lib) if $this_lib;
    if ($ac->link_if_else($conftest)) {
      $ac->msg_result('yes');
      $iconv_lib = "-l${this_lib}" if $this_lib;
      last;
    } else {
      $ac->msg_result('no');
    }
  }
} else {
  print "# Determining the need for -lpsapi\n";
  my $ac = Config::AutoConf->new();
  $ac->push_libraries('psapi');
  if ($ac->link_if_else("#include <windows.h>\n#include <psapi.h>\nint main() { EnumProcessModules(NULL, NULL, 0, NULL); }")) {
    if (basename($Config{cc}) =~ /^cl/i) {
      $cpp_libs .= " psapi.lib";
    } else {
      $cpp_libs .= " -lpsapi";
    }
  }
}

print "Extra libraries: $cpp_libs $iconv_lib\n";

my $fh;
print "Generating constant types\n";
open($fh, '>', 'c-constant-types.inc') || die "Cannot open c-constant-types.inc, $!";
print $fh constant_types();
close($fh) || warn "Failed to close c-constant-types.inc, $!";

my %types = ( 'event' => { pkg => 'MarpaX::ESLIF::Event::Type', constants => [qw/MARPAESLIF_EVENTTYPE_NONE MARPAESLIF_EVENTTYPE_COMPLETED MARPAESLIF_EVENTTYPE_NULLED MARPAESLIF_EVENTTYPE_PREDICTED MARPAESLIF_EVENTTYPE_BEFORE MARPAESLIF_EVENTTYPE_AFTER MARPAESLIF_EVENTTYPE_EXHAUSTED MARPAESLIF_EVENTTYPE_DISCARD/] }, 'value' => { pkg => 'MarpaX::ESLIF::Value::Type', constants => [qw/MARPAESLIF_VALUE_TYPE_UNDEF MARPAESLIF_VALUE_TYPE_CHAR MARPAESLIF_VALUE_TYPE_SHORT MARPAESLIF_VALUE_TYPE_INT MARPAESLIF_VALUE_TYPE_LONG MARPAESLIF_VALUE_TYPE_FLOAT MARPAESLIF_VALUE_TYPE_DOUBLE MARPAESLIF_VALUE_TYPE_PTR MARPAESLIF_VALUE_TYPE_ARRAY/] }, 'loggerLevel' => { pkg => 'MarpaX::ESLIF::Logger::Level', constants => [qw/GENERICLOGGER_LOGLEVEL_TRACE GENERICLOGGER_LOGLEVEL_DEBUG GENERICLOGGER_LOGLEVEL_INFO GENERICLOGGER_LOGLEVEL_NOTICE GENERICLOGGER_LOGLEVEL_WARNING GENERICLOGGER_LOGLEVEL_ERROR GENERICLOGGER_LOGLEVEL_CRITICAL GENERICLOGGER_LOGLEVEL_ALERT GENERICLOGGER_LOGLEVEL_EMERGENCY/] });

foreach (sort keys %types) {
  my $pkg = $types{$_}->{pkg};
  print "Generating $pkg C $_ types\n";
  open($fh, '>', "c-$_-types.inc") || die "Cannot open c-$_-types.inc, $!";
  print $fh C_constant($pkg, "${_}_constant", undef, undef, undef, undef, @{$types{$_}->{constants}});
  close($fh) || warn "Failed to close c-$_-types.inc, $!";

  # This is a bit vicious but in our case these are NOT macros but ENUMS !
  # We know what were are doing and replace all #ifdef MARPAESLIF_xxx and #ifdef GENERICLOGGER_xxx by #if 1

  print "Tweaking $pkg C $_ types to work with enums\n";
  open($fh, '<', "c-$_-types.inc") || die "Failed to open c-$_-types.inc, $!";
  my $content = do { local $/; <$fh> };
  close($fh) || warn "Failed to close c-$_-types.inc, $!";
  $content =~ s/^#\s*ifdef\s+(?:MARPAESLIF_|GENERICLOGGER_).*?$/#if 1/smg;
  open($fh, '>', "c-$_-types.inc") || die "Failed to open c-$_-types.inc, $!";
  print $fh $content;
  close($fh) || warn "Failed to close c-$_-types.inc, $!";

  print "Generating $pkg XS $_ types\n";
  open($fh, '>', "xs-$_-types.inc") || die "Cannot open xs-$_-types.inc, $!";
  print $fh XS_constant($pkg, 'IV', 'constant', "${_}_constant");
  close($fh) || warn "Failed to close xs-$_-types.inc, $!";

  print "Generating $pkg AUTOLOAD\n";
  my $autoload = autoload($pkg, '5.10', 1);

  my @pkg = split(/::/, $pkg);
  $pkg[-1] .= '.pm';
  my $pkgfile = File::Spec->catfile('lib', @pkg);
  print "Pushing AUTOLOAD into $pkgfile\n";
  open($fh, '<', $pkgfile) || die "Failed to open $pkgfile, $!";
  $content = do { local $/; <$fh> };
  close($fh) || warn "Failed to close $pkgfile, $!";
  $content =~ s/^#\s*AUTOLOAD.*?$/\n$autoload\n/sm;
  open($fh, '>', $pkgfile) || die "Failed to open $pkgfile, $!";
  print $fh $content;
  close($fh) || warn "Failed to close $pkgfile, $!";
}

run([$^X, File::Spec->catfile('src', 'CMakeObjects.PL')]) or die "src/CMakeObjects.PL: $?";
my @ldfrom = ();
my %unique = ();

find({ wanted => sub {
                       if (-f $_) {
                         my $cpath = File::Spec->canonpath($_);
                         if (basename(dirname($cpath)) eq 'obj4perl') {
                           if (! ${unique}{basename($cpath)}++) {
                             push(@ldfrom, $cpath);
                           }
                         }
                       }
                     },
      no_chdir => 1 }, File::Spec->curdir);

print "Linking ESLIF\$(OBJ_EXT) using: @ldfrom\n";

#
# Copy/paste of Inline-CPP-0.74/inc/ILCPPConfig/CompilerGuess.pm
#
sub guess_compiler {

  my( $cc_guess, $libs_guess, $guesser, %configuration );

  if( $Config::Config{osname} eq 'freebsd'
    && $Config::Config{osvers} =~ /^(\d+)/
    && $1 >= 10
  ){
    $cc_guess = 'clang++';
    $libs_guess = '-lc++';
  }
  else {
    $guesser = ExtUtils::CppGuess->new;
    %configuration = $guesser->module_build_options;
    if( $guesser->is_gcc ) {
      if( $Config{cc} eq 'clang' ) {
        $cc_guess = 'clang++';
      } else {
        $cc_guess = 'g++';
      }
    }
    elsif ( $guesser->is_msvc ) {
      $cc_guess = 'cl';
    }

    $cc_guess .= $configuration{extra_compiler_flags};
    $libs_guess = $configuration{extra_linker_flags};

    ( $cc_guess, $libs_guess )
      = map { _trim_whitespace($_) } ( $cc_guess, $libs_guess );
  }
  return ( $cc_guess, $libs_guess );
}

sub _trim_whitespace {
  my $string = shift;
  $string =~ s/^\s+|\s+$//g;
  return $string;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "ESLIF is Extended ScanLess InterFace",
  "AUTHOR" => "Jean-Damien Durand <jeandamiendurand\@free.fr>",
  "CONFIGURE_REQUIRES" => {
    "Archive::Tar" => 0,
    "Capture::Tiny" => 0,
    "Config" => 0,
    "Config::AutoConf" => 0,
    "Config::AutoConf::INI" => 0,
    "ExtUtils::CBuilder" => "0.280224",
    "ExtUtils::Constant" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Basename" => 0,
    "File::Copy" => 0,
    "File::Copy::Recursive" => 0,
    "File::Find" => 0,
    "File::Path" => 0,
    "File::Spec" => 0,
    "File::chdir" => 0,
    "IO::Handle" => 0,
    "IPC::Run" => 0,
    "POSIX" => 0,
    "Perl::OSType" => 0,
    "Try::Tiny" => 0,
    "diagnostics" => 0,
    "strict" => 0
  },
  "DISTNAME" => "MarpaX-ESLIF",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "MarpaX::ESLIF",
  "PREREQ_PM" => {
    "Carp" => 0,
    "XSLoader" => 0,
    "strict" => 0,
    "vars" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Encode" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Log::Any" => 0,
    "Log::Any::Adapter" => 0,
    "Log::Any::Adapter::Log4perl" => 0,
    "Log::Log4perl" => 0,
    "Test::More" => 0,
    "Test::More::UTF8" => 0,
    "Try::Tiny" => 0,
    "blib" => "1.01",
    "diagnostics" => 0,
    "open" => 0,
    "utf8" => 0
  },
  "VERSION" => "2.0.11",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    OBJECT => 'ESLIF$(OBJ_EXT)',
    LDFROM => join(' ', '$(OBJECT)', @ldfrom),
    dynamic_lib => { OTHERLDFLAGS => "$cpp_libs $iconv_lib" },
    INC => join(' ', map { "-I$_ " } (File::Spec->catdir('src', 'output', 'include'), File::Spec->catdir('src', 'include'), File::Spec->catdir('src', 'output', '3rdparty', 'genericLogger', 'output', 'include'), File::Spec->catdir('src', 'output', '3rdparty', 'genericLogger', 'include'), File::Spec->catdir('src', 'output', '3rdparty', 'genericStack', 'include'), File::Spec->catdir('src', 'output', '3rdparty', 'genericHash', 'include') ) ),
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Encode" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Log::Any" => 0,
  "Log::Any::Adapter" => 0,
  "Log::Any::Adapter::Log4perl" => 0,
  "Log::Log4perl" => 0,
  "Test::More" => 0,
  "Test::More::UTF8" => 0,
  "Try::Tiny" => 0,
  "XSLoader" => 0,
  "blib" => "1.01",
  "diagnostics" => 0,
  "open" => 0,
  "strict" => 0,
  "utf8" => 0,
  "vars" => 0,
  "warnings" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.032
use Config;
if (! $Config{usethreads}) {
  foreach (qw/PREREQ_PM BUILD_REQUIRES TEST_REQUIRES/) {
    delete($WriteMakefileArgs{$_}{Thread}) if (exists($WriteMakefileArgs{$_}));
    delete($FallbackPrereqs{$_}{Thread})   if (exists($FallbackPrereqs{$_}));
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
