/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.utils.Command;
import com.javonet.utils.ExceptionType;
import com.javonet.utils.exceptions.UncheckedFileNotFoundException;
import com.javonet.utils.exceptions.UncheckedIOException;

public class ExceptionThrower {
    public static void throwException(Command commandException) {
        String javonetStackCommand = (String)commandException.getPayload()[1];
        String exceptionName = (String)commandException.getPayload()[2];
        String exceptionMessage = (String)commandException.getPayload()[3];
        StackTraceElement[] stackTrace = ExceptionThrower.getLocalStackTrace((String)commandException.getPayload()[4], (String)commandException.getPayload()[5], (String)commandException.getPayload()[6], (String)commandException.getPayload()[7]);
        ExceptionType exceptionType = ExceptionType.values()[(Integer)commandException.getPayload()[0]];
        switch (exceptionType) {
            case EXCEPTION: 
            case RUNTIME_EXCEPTION: {
                RuntimeException runtimeException = new RuntimeException(exceptionMessage);
                runtimeException.setStackTrace(stackTrace);
                throw runtimeException;
            }
            case IO_EXCEPTION: {
                UncheckedIOException uncheckedIOException = new UncheckedIOException(exceptionMessage);
                uncheckedIOException.setStackTrace(stackTrace);
                throw uncheckedIOException;
            }
            case ARITHMETIC_EXCEPTION: 
            case DIVIDE_BY_ZERO_EXCEPTION: {
                ArithmeticException arithmeticException = new ArithmeticException(exceptionMessage);
                arithmeticException.setStackTrace(stackTrace);
                throw arithmeticException;
            }
            case NULL_POINTER_EXCEPTION: {
                NullPointerException nullPointerException = new NullPointerException(exceptionMessage);
                nullPointerException.setStackTrace(stackTrace);
                throw nullPointerException;
            }
            case FILE_NOT_FOUND_EXCEPTION: {
                UncheckedFileNotFoundException uncheckedFileNotFoundException = new UncheckedFileNotFoundException(exceptionMessage);
                uncheckedFileNotFoundException.setStackTrace(stackTrace);
                throw uncheckedFileNotFoundException;
            }
            case ILLEGAL_ARGUMENT_EXCEPTION: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exceptionMessage);
                illegalArgumentException.setStackTrace(stackTrace);
                throw illegalArgumentException;
            }
            case INDEX_OUT_OF_BOUNDS_EXCEPTION: {
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(exceptionMessage);
                indexOutOfBoundsException.setStackTrace(stackTrace);
                throw indexOutOfBoundsException;
            }
        }
        throw new RuntimeException("Unable to process Exception: " + commandException.payloadToString());
    }

    private static StackTraceElement[] getLocalStackTrace(String stackTraceClasses, String stackTraceMethods, String stackTraceLines, String stackTraceFiles) {
        String[] stackClasses = stackTraceClasses.split("\\|");
        String[] stackMethods = stackTraceMethods.split("\\|");
        String[] stackLines = stackTraceLines.split("\\|");
        String[] stackFiles = stackTraceFiles.split("\\|");
        StackTraceElement[] result = new StackTraceElement[stackLines.length];
        for (int i = 0; i < stackLines.length; ++i) {
            StackTraceElement ste;
            int stackLine = 0;
            try {
                stackLine = Integer.parseInt(stackLines[i]);
            }
            catch (NumberFormatException ex) {
                stackLine = 0;
            }
            result[i] = ste = new StackTraceElement(stackClasses[i], stackMethods[i], stackFiles[i], stackLine);
        }
        return result;
    }
}

