package Daje::Plugin::Perl::Manager;
use Mojo::Base 'Daje::Plugin::Perl::Base::Common', -base, -signatures;

use Daje::Plugin::Perl::Generate::Fields;
use Daje::Plugin::Perl::Generate::Methods;
use Daje::Plugin::Perl::Generate::Class;
use Daje::Plugin::Output::Class;
use Daje::Plugin::Perl::Generate::BaseClass;
use Daje::Plugin::Perl::Generate::Interface;

our $VERSION = '0.01';

has 'success';
has 'config';

sub generate_classes($self) {
    $self->_base_class();
    my $length = scalar @{$self->json->{tables}};
    for (my $i = 0; $i < $length; $i++) {
        $self->_generate_table_class(@{$self->json->{tables}}[$i]);
        $self->_generate_interface_class(@{$self->json->{tables}}[$i]->{table}->{table_name});
    }
    $length = scalar $self->json->{views};
    for (my $i = 0; $i < $length; $i++) {
        $self->_generate_view_class(@{$self->json->{views}}[$i]);
    }
    return 1;
}

sub _generate_interface_class($self, $table_name) {
    my $template = $self->template();
    Daje::Plugin::Perl::Generate::Interface->new(
        template => $template,
        config   => $self->config,
        table    => $table_name,
    )->generate();
}

sub _base_class($self) {
    my $template = $self->template();
    Daje::Plugin::Perl::Generate::BaseClass->new(
        template => $template,
        config   => $self->config,
    )->generate();

}

sub _generate_table_class($self, $table) {
    my $fields = $self->_get_fields($table);
    my $methods = $self->_methods($fields, $table);
    my $perl = $self->_class($methods, $table, $fields);
    $self->_save_class($perl, $table->{table});
}

sub _save_class($self, $perl, $table) {

    my $output = Daje::Plugin::Output::Class->new(
        config         => $self->config,
        table_name     => $table->{table_name},
        perl           => $perl,
        name_space_dir => "name_space_dir",
    );
    $output->save_file();
}

sub _class($self, $methods, $table, $fields) {
    my $template = $self->template();
    my $class = Daje::Plugin::Perl::Generate::Class->new(
        json     => $table->{table},
        methods  => $methods,
        template => $template,
        config   => $self->config,
        fields   => $fields,
    );
    my $perl = $class->generate();

    return $perl;
}

sub _methods($self, $fields, $table) {
    my $template = $self->template();
    my $methods = Daje::Plugin::Perl::Generate::Methods->new(
        json     => $table->{table},
        fields   => $fields,
        template => $template
    );
    $methods->generate();

    return $methods;
}

sub _generate_view_class($self, $view) {
    $view = $view;
}

sub _get_fields($self, $json) {
    my $template = $self->template();
    my $fields = Daje::Plugin::Perl::Generate::Fields->new(
        json     => $json->{table},
        template => $template
    );
    $fields->generate();
    return $fields;
}

1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::Perl::Manager


=head1 REQUIRES

L<Daje::Plugin::Perl::Generate::Interface> 

L<Daje::Plugin::Perl::Generate::BaseClass> 

L<Daje::Plugin::Output::Class> 

L<Daje::Plugin::Perl::Generate::Class> 

L<Daje::Plugin::Perl::Generate::Methods> 

L<Daje::Plugin::Perl::Generate::Fields> 

L<Mojo::Base> 


=head1 METHODS

=head2 generate_classes($self)

 generate_classes($self)();


=cut

