package Daje::Plugin::Perl::Generate::Interface;
use Mojo::Base 'Daje::Plugin::Perl::Base::Common', -base, -signatures;

use Daje::Plugin::Output::Class;
use String::CamelCase qw(camelize);

our $VERSION = '0.01';

has 'config';
has 'template';
has 'table';

sub generate($self) {
    $self->table(camelize($self->table));

    return if $self->_interface_exists($self->table());

    my $tpl = $self->template->get_data_section('interface');
    my $name_space = $self->config->{CLASS}->{name_space};
    my $interface = $self->config->{CLASS}->{name_interface};
    my $date = localtime();
    my $table = $self->table();

    $tpl =~ s/<<date>>/$date/ig;
    $tpl =~ s/<<interface>>/$interface/ig;
    $tpl =~ s/<<classname>>/$table/ig;
    $tpl =~ s/<<name_space>>/$name_space/ig;

    my $output = Daje::Plugin::Output::Class->new(
        config         => $self->config,
        table_name     => $self->table,
        perl           => $tpl,
        name_space_dir => "interface_space_dir",
    );
    $output->save_file();
}

sub _interface_exists($self, $table){
    my $result = 0;

    my $interface_space_dir = $self->config->{PATH}->{interface_space_dir} . $self->table() . ".pm";
    if ( -e $interface_space_dir) {
        $result = 1;
    }

    return $result;
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::Perl::Generate::Interface


=head1 REQUIRES

L<String::CamelCase> 

L<Daje::Plugin::Output::Class> 

L<Mojo::Base> 


=head1 METHODS

=head2 generate($self)

 generate($self)();


=cut

