use v5.40;
use feature 'class';
no warnings 'experimental::class';

our $VERSION = '0.01';

class Daje::Generate::Perl::Generate::Interface {
    use String::CamelCase qw(camelize);

    field $config :param;
    field $template :param;
    field $table :param;

    method generate() {
        $table = camelize($table);

        return if $self->_interface_exists($table);

        my $tpl = $template->get_data_section('interface');
        my $name_space = $config->{CLASS}->{name_space};
        my $interface = $config->{CLASS}->{name_interface};

        $tpl =~ s/<<interface>>/$interface/ig;
        $tpl =~ s/<<classname>>/$table/ig;
        $tpl =~ s/<<name_space>>/$name_space/ig;

        my $output = Daje::Generate::Output::Perl::Class->new(
            config         => $config,
            table_name     => $table,
            perl           => $tpl,
            name_space_dir => "interface_space_dir",
        );
        $output->save_file();
    }

    method _interface_exists($table){
        my $result = 0;

        my $interface_space_dir = $config->{PATH}->{interface_space_dir} . $table . ".pm";
        if ( -e $interface_space_dir) {
            $result = 1;
        }

        return $result;
    }
}


1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

lib::Daje::Generate::Perl::Generate::Interface - lib::Daje::Generate::Perl::Generate::Interface


=head1 REQUIRES

L<String::CamelCase> 

L<feature> 

L<v5.40> 


=head1 METHODS


=cut

