## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Es_ec v1.1.3;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Es_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Es_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-es.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: spanish (es)
% encoding: ec
%
% This file has been auto-generated from hyph-es.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E1="E1
\lccode"E9="E9
\lccode"ED="ED
\lccode"F1="F1
\lccode"F3="F3
\lccode"FA="FA
\patterns{
1b
4b.
2bb
2bc
2bd
2bf
2bg
2b1h
2bj
2bk
2bm
2bn
2bp
2bq
2bs
2bt
2bv
2bw
2bx
2by
2bz
1c
4c.
2cb
2cc
2cd
2cf
2cg
2cj
2ck
2cm
2cn
2cp
2cq
2cs
2ct
2cv
2cw
2cx
2cy
2cz
1d
4d.
2db
2dc
2dd
2df
2dg
2d1h
2dj
2dk
2dl
2dm
2dn
2dp
2dq
2ds
2dt
2dv
2dw
2dx
2dy
2dz
1f
4f.
2fb
2fc
2fd
2ff
2fg
2f1h
2fj
2fk
2fm
2fn
2fp
2fq
2fs
2ft
2fv
2fw
2fx
2fy
2fz
1g
4g.
2gb
2gc
2gd
2gf
2gg
2g1h
2gj
2gk
2gm
2gn
2gp
2gq
2gs
2gt
2gv
2gw
2gx
2gy
2gz
4h.
2hb
2hc
2hd
2hf
2hg
2h1h
2hj
2hk
2hl
2hm
2hn
2hp
2hq
2hr
2hs
2ht
2hv
2hw
2hx
2hy
2hz
1j
4j.
2jb
2jc
2jd
2jf
2jg
2j1h
2jj
2jk
2jl
2jm
2jn
2jp
2jq
2jr
2js
2jt
2jv
2jw
2jx
2jy
2jz
1k
4k.
2kb
2kc
2kd
2kf
2kg
2k1h
2kj
2kk
2km
2kn
2kp
2kq
2ks
2kt
2kv
2kw
2kx
2ky
2kz
1l
4l.
2lb
2lc
2ld
2lf
2lg
2l1h
2lj
2lk
2lm
2ln
2lp
2lq
2lr
2ls
2lt
2lv
2lw
2lx
2ly
2lz
1m
4m.
2mb
2mc
2md
2mf
2mg
2m1h
2mj
2mk
2ml
2mm
2mn
2mp
2mq
2mr
2ms
2mt
2mv
2mw
2mx
2my
2mz
1n
4n.
2nb
2nc
2nd
2nf
2ng
2n1h
2nj
2nk
2nl
2nm
2nn
2np
2nq
2nr
2ns
2nt
2nv
2nw
2nx
2ny
2nz
1p
4p.
2pb
2pc
2pd
2pf
2pg
2p1h
2pj
2pk
2pm
2pn
2pp
2pq
2ps
2pt
2pv
2pw
2px
2py
2pz
1q
4q.
2qb
2qc
2qd
2qf
2qg
2q1h
2qj
2qk
2ql
2qm
2qn
2qp
2qq
2qr
2qs
2qt
2qv
2qw
2qx
2qy
2qz
1r
4r.
2rb
2rc
2rd
2rf
2rg
2r1h
2rj
2rk
2rl
2rm
2rn
2rp
2rq
2rs
2rt
2rv
2rw
2rx
2ry
2rz
1s
4s.
2sb
2sc
2sd
2sf
2sg
2s1h
2sj
2sk
2sl
2sm
2sn
2sp
2sq
2sr
2ss
2st
2sv
2sw
2sx
2sy
2sz
1t
4t.
2tb
2tc
2td
2tf
2tg
2t1h
2tj
2tk
2tm
2tn
2tp
2tq
2ts
2tt
2tv
2tw
2tx
2ty
2tz
1v
4v.
2vb
2vc
2vd
2vf
2vg
2v1h
2vj
2vk
2vm
2vn
2vp
2vq
2vs
2vt
2vv
2vw
2vx
2vy
2vz
1w
4w.
2wb
2wc
2wd
2wf
2wg
2w1h
2wj
2wk
2wl
2wm
2wn
2wp
2wq
2wr
2ws
2wt
2wv
2ww
2wx
2wy
2wz
1x
4x.
2xb
2xc
2xd
2xf
2xg
2x1h
2xj
2xk
2xl
2xm
2xn
2xp
2xq
2xr
2xs
2xt
2xv
2xw
2xx
2xy
2xz
1y
4y.
2yb
2yc
2yd
2yf
2yg
2y1h
2yj
2yk
2yl
2ym
2yn
2yp
2yq
2yr
2ys
2yt
2yv
2yw
2yx
2yy
2yz
1z
4z.
2zb
2zc
2zd
2zf
2zg
2z1h
2zj
2zk
2zl
2zm
2zn
2zp
2zq
2zr
2zs
2zt
2zv
2zw
2zx
2zy
2zz
1^^f1
4^^f1.
c4h
4ch.
2chb
2chc
2chd
2chf
2chg
2chh
2chj
2chk
ch2l
2chm
2chn
2chp
2chq
ch2r
2chs
2cht
2chv
2chw
2chx
2chy
2chz
l4l
4ll.
2llb
2llc
2lld
2llf
2llg
2llh
2llj
2llk
2lll
2llm
2lln
2llp
2llq
2llr
2lls
2llt
2llv
2llw
2llx
2lly
2llz
b2l
4bl.
2bl2b
2bl2c
2bl2d
2bl2f
2bl2g
2bl2h
2bl2j
2bl2k
2bl2l
2bl2m
2bl2n
2bl2p
2bl2q
2bl2r
2bl2s
2bl2t
2bl2v
2bl2w
2bl2x
2bl2y
2bl2z
c2l
4cl.
2cl2b
2cl2c
2cl2d
2cl2f
2cl2g
2cl2h
2cl2j
2cl2k
2cl2l
2cl2m
2cl2n
2cl2p
2cl2q
2cl2r
2cl2s
2cl2t
2cl2v
2cl2w
2cl2x
2cl2y
2cl2z
f2l
4fl.
2fl2b
2fl2c
2fl2d
2fl2f
2fl2g
2fl2h
2fl2j
2fl2k
2fl2l
2fl2m
2fl2n
2fl2p
2fl2q
2fl2r
2fl2s
2fl2t
2fl2v
2fl2w
2fl2x
2fl2y
2fl2z
g2l
4gl.
2gl2b
2gl2c
2gl2d
2gl2f
2gl2g
2gl2h
2gl2j
2gl2k
2gl2l
2gl2m
2gl2n
2gl2p
2gl2q
2gl2r
2gl2s
2gl2t
2gl2v
2gl2w
2gl2x
2gl2y
2gl2z
k2l
4kl.
2kl2b
2kl2c
2kl2d
2kl2f
2kl2g
2kl2h
2kl2j
2kl2k
2kl2l
2kl2m
2kl2n
2kl2p
2kl2q
2kl2r
2kl2s
2kl2t
2kl2v
2kl2w
2kl2x
2kl2y
2kl2z
p2l
4pl.
2pl2b
2pl2c
2pl2d
2pl2f
2pl2g
2pl2h
2pl2j
2pl2k
2pl2l
2pl2m
2pl2n
2pl2p
2pl2q
2pl2r
2pl2s
2pl2t
2pl2v
2pl2w
2pl2x
2pl2y
2pl2z
v2l
4vl.
2vl2b
2vl2c
2vl2d
2vl2f
2vl2g
2vl2h
2vl2j
2vl2k
2vl2l
2vl2m
2vl2n
2vl2p
2vl2q
2vl2r
2vl2s
2vl2t
2vl2v
2vl2w
2vl2x
2vl2y
2vl2z
b2r
4br.
2br2b
2br2c
2br2d
2br2f
2br2g
2br2h
2br2j
2br2k
2br2l
2br2m
2br2n
2br2p
2br2q
2br2r
2br2s
2br2t
2br2v
2br2w
2br2x
2br2y
2br2z
c2r
4cr.
2cr2b
2cr2c
2cr2d
2cr2f
2cr2g
2cr2h
2cr2j
2cr2k
2cr2l
2cr2m
2cr2n
2cr2p
2cr2q
2cr2r
2cr2s
2cr2t
2cr2v
2cr2w
2cr2x
2cr2y
2cr2z
d2r
4dr.
2dr2b
2dr2c
2dr2d
2dr2f
2dr2g
2dr2h
2dr2j
2dr2k
2dr2l
2dr2m
2dr2n
2dr2p
2dr2q
2dr2r
2dr2s
2dr2t
2dr2v
2dr2w
2dr2x
2dr2y
2dr2z
f2r
4fr.
2fr2b
2fr2c
2fr2d
2fr2f
2fr2g
2fr2h
2fr2j
2fr2k
2fr2l
2fr2m
2fr2n
2fr2p
2fr2q
2fr2r
2fr2s
2fr2t
2fr2v
2fr2w
2fr2x
2fr2y
2fr2z
g2r
4gr.
2gr2b
2gr2c
2gr2d
2gr2f
2gr2g
2gr2h
2gr2j
2gr2k
2gr2l
2gr2m
2gr2n
2gr2p
2gr2q
2gr2r
2gr2s
2gr2t
2gr2v
2gr2w
2gr2x
2gr2y
2gr2z
k2r
4kr.
2kr2b
2kr2c
2kr2d
2kr2f
2kr2g
2kr2h
2kr2j
2kr2k
2kr2l
2kr2m
2kr2n
2kr2p
2kr2q
2kr2r
2kr2s
2kr2t
2kr2v
2kr2w
2kr2x
2kr2y
2kr2z
p2r
4pr.
2pr2b
2pr2c
2pr2d
2pr2f
2pr2g
2pr2h
2pr2j
2pr2k
2pr2l
2pr2m
2pr2n
2pr2p
2pr2q
2pr2r
2pr2s
2pr2t
2pr2v
2pr2w
2pr2x
2pr2y
2pr2z
r2r
4rr.
2rr2b
2rr2c
2rr2d
2rr2f
2rr2g
2rr2h
2rr2j
2rr2k
2rr2l
2rr2m
2rr2n
2rr2p
2rr2q
2rr2r
2rr2s
2rr2t
2rr2v
2rr2w
2rr2x
2rr2y
2rr2z
t2r
4tr.
2tr2b
2tr2c
2tr2d
2tr2f
2tr2g
2tr2h
2tr2j
2tr2k
2tr2l
2tr2m
2tr2n
2tr2p
2tr2q
2tr2r
2tr2s
2tr2t
2tr2v
2tr2w
2tr2x
2tr2y
2tr2z
v2r
4vr.
2vr2b
2vr2c
2vr2d
2vr2f
2vr2g
2vr2h
2vr2j
2vr2k
2vr2l
2vr2m
2vr2n
2vr2p
2vr2q
2vr2r
2vr2s
2vr2t
2vr2v
2vr2w
2vr2x
2vr2y
2vr2z
2b3p2t
2c3p2t
2d3p2t
2l3p2t
2m3p2t
2n3p2t
2r3p2t
2s3p2t
2t3p2t
2x3p2t
2y3p2t
4pt.
2b3c2t
2c3c2t
2d3c2t
2l3c2t
2m3c2t
2n3c2t
2r3c2t
2s3c2t
2t3c2t
2x3c2t
2y3c2t
4ct.
2b3c2n
2c3c2n
2d3c2n
2l3c2n
2m3c2n
2n3c2n
2r3c2n
2s3c2n
2t3c2n
2x3c2n
2y3c2n
4cn.
2b3p2s
2c3p2s
2d3p2s
2l3p2s
2m3p2s
2n3p2s
2r3p2s
2s3p2s
2t3p2s
2x3p2s
2y3p2s
4ps.
2b3m2n
2c3m2n
2d3m2n
2l3m2n
2m3m2n
2n3m2n
2r3m2n
2s3m2n
2t3m2n
2x3m2n
2y3m2n
4mn.
2b3g2n
2c3g2n
2d3g2n
2l3g2n
2m3g2n
2n3g2n
2r3g2n
2s3g2n
2t3g2n
2x3g2n
2y3g2n
4gn.
2b3f2t
2c3f2t
2d3f2t
2l3f2t
2m3f2t
2n3f2t
2r3f2t
2s3f2t
2t3f2t
2x3f2t
2y3f2t
4ft.
2b3p2n
2c3p2n
2d3p2n
2l3p2n
2m3p2n
2n3p2n
2r3p2n
2s3p2n
2t3p2n
2x3p2n
2y3p2n
4pn.
2b3c2z
2c3c2z
2d3c2z
2l3c2z
2m3c2z
2n3c2z
2r3c2z
2s3c2z
2t3c2z
2x3c2z
2y3c2z
4cz.
2b3t2z
2c3t2z
2d3t2z
2l3t2z
2m3t2z
2n3t2z
2r3t2z
2s3t2z
2t3t2z
2x3t2z
2y3t2z
4tz.
2b3t2s
2c3t2s
2d3t2s
2l3t2s
2m3t2s
2n3t2s
2r3t2s
2s3t2s
2t3t2s
2x3t2s
2y3t2s
4ts.
san4c5t
plan4c5t
2no.
2t2l
4caca4
4cago4
4caga4
4cagas.
4teta.
4tetas.
4puta4
4puto4
.hu4mea
.hu4meo
.he4mee
4meo.
4meable.
4meables.
4pedo4
4culo4
3mente.
4i3go.
4es.
4^^e9s
4e.
4e3mos.
4^^e9is.
4en.
4^^eda.
4^^edas.
4^^eda3mos.
4^^edais.
4^^edan.
4^^ed.
4^^ed4s3te.
4^^ed4s3tes.
4^^ed3tes.
4^^ed3mos.
4^^eds3teis.
4e3r^^e9.
4e3r^^e1s.
4e3r^^e9s.
4e3r^^eds.
4e3r^^e1.
4e3re3mos.
4e3r^^e9is.
4e3r^^e1n.
4i3ga.
4i3gas.
4i3g^^e1s.
4i3gamos.
4i3g^^e1is.
4a4i3gan.
4e3r^^eda.
4e3r^^edas.
4e3r^^edamos.
4e3r^^edais.
4e3r^^edan.
4i3g^^e13mosme.
4i3g^^e13mosmele.
4i3g^^e13mosmelo.
4i3g^^e13mos3mela.
4i3g^^e13mosmeles.
4i3g^^e13mosmelos.
4i3g^^e13mos3melas.
4i3g^^e13moste.
4i3g^^e13mostele.
4i3g^^e13mostelo.
4i3g^^e13mos3tela.
4i3g^^e13mosteles.
4i3g^^e13mostelos.
4i3g^^e13mos3telas.
4i3g^^e13mosle.
4i3g^^e13mosla.
4i3g^^e13moslo.
4i3g^^e13mosele.
4i3g^^e13moselo.
4i3g^^e13mosela.
4i3g^^e13moseles.
4i3g^^e13moselos.
4i3g^^e13moselas.
4i3g^^e13monos.
4i3g^^e13monosle.
4i3g^^e13monoslo.
4i3g^^e13monosla.
4i3g^^e13monosles.
4i3g^^e13monoslos.
4i3g^^e13monoslas.
4i3g^^e13moos.
4i3g^^e13moosle.
4i3g^^e13mooslo.
4i3g^^e13moosla.
4i3g^^e13moosles.
4i3g^^e13mooslos.
4i3g^^e13mooslas.
4i3g^^e13mosles.
4i3g^^e13moslas.
4i3g^^e13moslos.
4ed.
4^^e9.
4edme.
4^^e9dmele.
4^^e9dmelo.
4^^e9d3mela.
4^^e9dmeles.
4^^e9dmelos.
4^^e9d3melas.
4edte.
4^^e9dtele.
4^^e9dtelo.
4^^e9d3tela.
4^^e9dteles.
4^^e9dtelos.
4^^e9d3telas.
4edle.
4eedla.
4edlo.
4^^e9dsele.
4^^e9dselo.
4^^e9dsela.
4^^e9dseles.
4^^e9dselos.
4^^e9dselas.
4ednos.
4^^e9dnosle.
4^^e9dnoslo.
4^^e9dnosla.
4^^e9dnosles.
4^^e9dnoslos.
4^^e9dnoslas.
4eos.
4^^e9osle.
4^^e9oslo.
4^^e9osla.
4^^e9osles.
4^^e9oslos.
4^^e9oslas.
4edles.
4edlas.
4edlos.
4er.
4erme.
4^^e9rmele.
4^^e9rmelo.
4^^e9r3mela.
4^^e9rmeles.
4^^e9rmelos.
4^^e9r3melas.
4erte.
4^^e9rtele.
4^^e9rtelo.
4^^e9r3tela.
4^^e9rteles.
4^^e9rtelos.
4^^e9r3telas.
4erle.
4erla.
4erlo.
4erse.
4^^e9rsele.
4^^e9rselo.
4^^e9rsela.
4^^e9rseles.
4^^e9rselos.
4^^e9rselas.
4ernos.
4^^e9rnosle.
4^^e9rnoslo.
4^^e9rnosla.
4^^e9rnosles.
4^^e9rnoslos.
4^^e9rnoslas.
4e3ros.
4^^e93rosle.
4^^e93roslo.
4^^e93rosla.
4^^e93rosles.
4^^e93roslos.
4^^e93roslas.
4erles.
4erlas.
4erlos.
4^^ed3do.
4^^ed3da.
4^^ed3dos.
4^^ed3das.
4o.
4as.
4a.
4^^e1s.
4a3mos.
4^^e1is.
4an.
4aste.
4astes.
4^^f3.
4ates.
4asteis.
4a3ron.
4a3ba.
4a3bas.
4^^e13bamos.
4a3bais.
4a3ban.
4a3r^^eda.
4a3r^^edas.
4a3r^^edamos.
4a3r^^edais
4a3r^^edan.
4a3r^^e9.
4a3r^^e1s.
4a3r^^e9s.
4a3r^^eds.
4a3r^^e1.
4a3remos.
4a3r^^e9is.
4a3r^^e1n.
4a3ra.
4a3ras.
4^^e13ramos.
4a3rais.
4a3ran.
4a3re.
4a3res.
4^^e13remos.
4a3reis.
4a3ren.
4a3se.
4a3ses.
4^^e13semos.
4a3seis.
4a3sen.
4ad.
e5r4as.
e5r4a3mos.
e5r4^^e1is.
e5r4an.
e5r4aste.
e5r4astes.
e5r4ates.
e5r4asteis.
e5r4a3ron.
e5r4a3ba.
e5r4a3bas.
e5r4^^e13bamos.
e5r4a3bais.
e5r4a3ban.
e5r4a3r^^eda.
e5r4a3r^^edas.
e5r4a3r^^edamos.
e5r4a3r^^edais
e5r4a3r^^edan.
e5r4a3r^^e9.
e5r4a3r^^e1s.
e5r4a3r^^e9s.
e5r4a3r^^eds.
e5r4a3r^^e1.
e5r4a3remos.
e5r4a3r^^e9is.
e5r4a3r^^e1n.
e5r4a3ra.
e5r4a3ras.
e5r4^^e13ramos.
e5r4a3rais.
e5r4a3ran.
e5r4a3re.
e5r4a3res.
e5r4^^e13remos.
e5r4a3reis.
e5r4a3ren.
e5r4a3se.
e5r4a3ses.
e5r4^^e13semos.
e5r4a3seis.
e5r4a3sen.
e5r4ad.
4adme.
4^^e1dmele.
4^^e1dmelo.
4^^e1d3mela.
4^^e1dmeles.
4^^e1dmelos.
4^^e1d3melas.
4adte.
4^^e1dtele.
4^^e1dtelo.
4^^e1d3tela.
4^^e1dteles.
4^^e1dtelos.
4^^e1d3telas.
4adle.
4eadla.
4adlo.
4^^e1dsele.
4^^e1dselo.
4^^e1dsela.
4^^e1dseles.
4^^e1dselos.
4^^e1dselas.
4adnos.
4^^e1dnosle.
4^^e1dnoslo.
4^^e1dnosla.
4^^e1dnosles.
4^^e1dnoslos.
4^^e1dnoslas.
4aos.
4^^e1osle.
4^^e1oslo.
4^^e1osla.
4^^e1osles.
4^^e1oslos.
4^^e1oslas.
4adles.
4adlas.
4adlos.
4ar.
4a4rme.
4^^e14rmele.
4^^e14rmelo.
4^^e14r3mela.
4^^e14r3meles.
4^^e14r3melos.
4^^e14r3melas.
4a4r3te.
4^^e14r3tele.
4^^e14r3telo.
4^^e14r3tela.
4^^e14r3teles.
4^^e14r3telos.
4^^e14r3telas.
4a4r3le.
4a4r3la.
4a4r3lo.
4a4r3se.
4^^e14r3sele.
4^^e14r3selo.
4^^e14r3sela.
4^^e14r3seles.
4^^e14r3selos.
4^^e14r3selas.
4a4r3nos.
4^^e14r3nosle.
4^^e14r3noslo.
4^^e14r3nosla.
4^^e14r3nosles.
4^^e14r3noslos.
4^^e14r3noslas.
4a3ros.
4^^e1rosle.
4^^e1roslo.
4^^e1rosla.
4^^e1rosles.
4^^e1roslos.
4^^e1roslas.
4a4r3les.
4a4r3las.
4a4r3los.
4a3do.
4a3da.
4a3dos.
4a3das.
e5r4a3do.
e5r4a3da.
e5r4a3dos.
e5r4a3das.
4ando
4^^e1ndole.
4^^e1ndolo.
4^^e1ndola.
4^^e1ndoles.
4^^e1ndolos.
4^^e1ndolas.
4^^e1ndonos.
4^^e1ndoos.
4^^e1ndome.
4^^e1ndomelo.
4^^e1ndomela.
4^^e1ndomele.
4^^e1ndomelos.
4^^e1ndomelas.
4^^e1ndomeles.
4^^e1ndote.
4^^e1ndoteme.
4^^e1ndotelo.
4^^e1ndotela.
4^^e1ndotele.
4^^e1ndotelos.
4^^e1ndotelas.
4^^e1ndoteles.
4^^e1ndotenos.
4^^e1ndose.
4^^e1ndoseme.
4^^e1ndoselo.
4^^e1ndosela.
4^^e1ndosele.
4^^e1ndoselos.
4^^e1ndoselas.
4^^e1ndoseles.
4^^e1ndosenos.
4a3dor.
4a3dora.
4a3dores.
4a3doras.
e5r4a3dor.
e5r4a3dora.
e5r4a3dores.
e5r4a3doras.
acto1h
acto1a2
acto1e2
acto1i2
acto1o2
acto1u2
acto1^^e12
acto1^^e92
acto1^^ed2
acto1^^f32
acto1^^fa2
afro1h
afro1a2
afro1e2
afro1i2
afro1o2
afro1u2
afro1^^e12
afro1^^e92
afro1^^ed2
afro1^^f32
afro1^^fa2
.a2
.an2a2
.an2e2
.an2i2
.an2o2
.an2u2
.an2^^e12
.an2^^e92
.an2^^ed2
.an2^^f32
.an2^^fa2.
ana3l^^ed
.an^^e13li
.ana3li
.an3aero
.an3e2pigr
.ane3xa
.ane3x^^e1
.ane3xe
.ane3x^^e9
.ane3xio
.ane3xi^^f3
.an3h
.ani3mad
.ani3m^^e1d
.ani3dar
.ani3ll
.ani3m
.ani^^f1a
.ani3q
.an3i2so
.an3i2s^^f3
.ani3vel
.ano5che
.ano5din
.ano5mal
.ano5nad
.an^^f33nim
.an^^f35mal
.ano5nim
.ano5ta
.ano3t^^e1
.anua3l
.anua4lm
.anu3bl
.anu3da
.anu3l
asu3b2
aero1h
aero1a2
aero1e2
aero1i2
aero1o2
aero1u2
aero1^^e12
aero1^^e92
aero1^^ed2
aero1^^f32
aero1^^fa2
anfi1h
anfi1a2
anfi1e2
anfi1i2
anfi1o2
anfi1u2
anfi1^^e12
anfi1^^e92
anfi1^^ed2
anfi1^^f32
anfi1^^fa2
anglo1h
anglo1a2
anglo1e2
anglo1i2
anglo1o2
anglo1u2
anglo1^^e12
anglo1^^e92
anglo1^^ed2
anglo1^^f32
anglo1^^fa2
ante1h
ante1a2
ante1e2
ante1i2
ante1o2
ante1u2
ante1^^e12
ante1^^e92
ante1^^ed2
ante1^^f32
ante1^^fa2
.ante2o3je
acante2
4^^edsmo.
4^^edsmos.
4^^edsta.
4^^edstas.
4^^edstico.
4^^edsticos.
4^^edstica.
4^^edsticas.
t4eo3nes.
mante4a
e4a3miento
.anti1h
.anti1a2
.anti1e2
.anti1i2
.anti1o2
.anti1u2
.anti1^^e12
.anti1^^e92
.anti1^^ed2
.anti1^^f32
.anti1^^fa2
ti2o3qu
ti2o3co
archi1h
archi1a2
archi1e2
archi1i2
archi1o2
archi1u2
archi1^^e12
archi1^^e92
archi1^^ed2
archi1^^f32
archi1^^fa2
auto1h
auto1a2
auto1e2
auto1i2
auto1o2
auto1u2
auto1^^e12
auto1^^e92
auto1^^ed2
auto1^^f32
auto1^^fa2
biblio1h
biblio1a2
biblio1e2
biblio1i2
biblio1o2
biblio1u2
biblio1^^e12
biblio1^^e92
biblio1^^ed2
biblio1^^f32
biblio1^^fa2
bio1h
bio1a2
bio1e2
bio1i2
bio1o2
bio1u2
bio1^^e12
bio1^^e92
bio1^^ed2
bio1^^f32
bio1^^fa2
bi1u2n^^ed
cardio1h
cardio1a2
cardio1e2
cardio1i2
cardio1o2
cardio1u2
cardio1^^e12
cardio1^^e92
cardio1^^ed2
cardio1^^f32
cardio1^^fa2
cefalo1h
cefalo1a2
cefalo1e2
cefalo1i2
cefalo1o2
cefalo1u2
cefalo1^^e12
cefalo1^^e92
cefalo1^^ed2
cefalo1^^f32
cefalo1^^fa2
centi1h
centi1a2
centi1e2
centi1i2
centi1o2
centi1u2
centi1^^e12
centi1^^e92
centi1^^ed2
centi1^^f32
centi1^^fa2
centi5^^e1rea
ciclo1h
ciclo1a2
ciclo1e2
ciclo1i2
ciclo1o2
ciclo1u2
ciclo1^^e12
ciclo1^^e92
ciclo1^^ed2
ciclo1^^f32
ciclo1^^fa2
o4i3dea.
o4i3deas.
o4i3dal.
o4i3dales.
4o2i3de.
4o2i3des.
4i2dal.
4i2dales.
4i3deo.
4i3deos.
cito1h
cito1a2
cito1e2
cito1i2
cito1o2
cito1u2
cito1^^e12
cito1^^e92
cito1^^ed2
cito1^^f32
cito1^^fa2
3c2neor
cnico1h
cnico1a2
cnico1e2
cnico1i2
cnico1o2
cnico1u2
cnico1^^e12
cnico1^^e92
cnico1^^ed2
cnico1^^f32
cnico1^^fa2
.co2a2
.co2e2
.co2i2
.co3o4
.co2u2
.co2^^e12
.co2^^e92
.co2^^ed2
.co2^^f32
.co2^^fa2
co4^^e13gul
co4acci
co4acti
co4adju
co4a3dun
co4adyu
co3agen
co4a3gul
co4a3lic
co4aptac
co4art
co4^^e1rt
co4e3fic
co4erc
co4erz
co4e3t^^e1
co3exis
co4imbr
co4inci
co4i3to
co3n4imbri
co4o3per
co4o3p^^e9r
co4opt
co4ord
con1imbr
con1urb
cripto1h
cripto1a2
cripto1e2
cripto1i2
cripto1o2
cripto1u2
cripto1^^e12
cripto1^^e92
cripto1^^ed2
cripto1^^f32
cripto1^^fa2
crono1h
crono1a2
crono1e2
crono1i2
crono1o2
crono1u2
crono1^^e12
crono1^^e92
crono1^^ed2
crono1^^f32
crono1^^fa2
contra1h
contra1a2
contra1e2
contra1i2
contra1o2
contra1u2
contra1^^e12
contra1^^e92
contra1^^ed2
contra1^^f32
contra1^^fa2
deca1h
deca1a2
deca1e2
deca1i2
deca1o2
deca1u2
deca1^^e12
deca1^^e92
deca1^^ed2
deca1^^f32
deca1^^fa2
4e3dro.
4e3dros.
4^^e93drico.
4^^e93dricos.
4^^e93drica.
4^^e93dricas.
.de2sa2
.de2se2
.de2si2
.de2so2
.de2su2
.de2s^^e12
.de2s^^e92
.de2s^^ed2
.de2s^^f32
.de2s^^fa2
deca2i3mient
decimo1
3sa.
3sas.
de2s3^^f3rde
de2s3orde
de2s3abast
de2s3aboll
de2s3aboto
de2s3abr
desa3brid
de2s3abroch
de2s3aceit
de2s3aceler
desa3cert
desa3ciert
de2s3acobar
de2s3acomod
de2s3acomp
de2s3acons
de2s3acopl
de2s3acorr
de2s3acostum
de2s3acot
desa3craliz
de2s3acredit
de2s3activ
de2s3acuart
de2s3aderez
de2s3adeud
de2s3adorar
de2s3adormec
de2s3adorn
de2s3advert
de2s3aferr
de2s3afic
de2s3afil
de2s3afin
de2s3afor
desa3g^^fa
desa3garr
de2s3agraci
de2s3agrad
de2s3agravi
de2s3agreg
de2s3agrup
de2s3agu
desa3guisado
de2s3aherr
de2s3ahij
de2s3ajust
de2s3alagar
de2s3alent
de2s3alfom
de2s3alfor
de2s3ali^^f1
desa3lin
de2s3alien
de2s3aline
desa3liv
de2s3alm
de2s3almid
de2s3aloj
de2s3alquil
de2s3alter
de2s3alumbr
desa3marr
desa3mobl
de2s3amold
de2s3amort
de2s3amuebl
de2s3ampa
de2s3and
de2s3angel
de3sangr
de2s3anid
de2s3anim
de2s3an^^edm
de2s3anud
desa3pa^^f1
desa3pacib
de2s3apadr
de2s3apare
de2s3aparec
de2s3aparic
de2s3apeg
de2s3apercib
de2s3apes
de2s3aplic
de2s3apolill
de2s3apoy
de2s3aprend
de2s3apret
de2s3apriet
de2s3aprob
de2s3apropi
de2s3aprovech
de2s3arbol
de2s3aren
de2s3arm
des4arme
de2s3arraig
de2s3arregl
de2s3arrend
de2s3arrim
desa3rroll
de2s3arrop
de2s3arrug
de2s3articul
de2s3asent
de2s3asist
de2s3asn
desa3soseg
desa3sosieg
de2s3atenc
de2s3atend
de2s3atiend
de2s3atent
desa3tin
de2s3atorn
de2s3atranc
de2s3autor
de2s3avis
desa3yun
desa3z^^f3n
desa3zon
de2s3embal
de2s3emb^^e1l
de2s3embar
de2s3emb^^e1r
de2s3embarg
de2s3embols
de2s3emborr
de2s3embosc
de2s3embot
de2s3embrag
de2s3embr^^e1g
de2s3embrave
de2s3embr^^e1ve
de2s3embroll
de2s3embr^^f3ll
de2s3embruj
de2s3embr^^faj
de3semej
de2s3empa^^f1
de2s3emp^^e1^^f1
de2s3empac
de2s3empaquet
de2s3empaqu^^e9t
de2s3emparej
de2s3empar^^e9j
de2s3emparent
de2s3empat
de2s3emp^^e9
de2s3empedr
de2s3empeg
de2s3empeor
de2s3emperez
de2s3empern
de2s3emple
de2s3empolv
de2s3empotr
de2s3empoz
de2s3enam
de2s3encab
de2s3encad
de2s3encaj
de2s3enc^^e1j
de2s3encall
de2s3enc^^e1ll
de2s3encam
de3sencant
de2s3encap
de2s3encar
de2s3enc^^e1r
de2s3ench
de2s3encl
de2s3enco
de2s3encr
de2s3encu
de2s3end
de3senfad
de3senf^^e1d
de2s3enfi
de2s3enfo
de2s3enf^^f3
de3senfren
de2s3enfund
de2s3enfur
de3senga^^f1
de3seng^^e1^^f1
de2s3enganch
de2s3engar
de2s3engas
de2s3engom
de2s3engoz
de2s3engra
de2s3enhebr
de2s3enj
de2s3enlad
de2s3enlaz
de2s3enlo
de2s3enm
de2s3enr
de2s3ens
de2s3enta
de3sentend
de3sentien
de3senti^^e9n
de2s3enter
de2s3entier
de2s3enti^^e9r
de2s3ento
de2s3entr
de2s3entu
de2s3envain
de3senvolvim
de3seo
de2s3eq
de3s4erci
de3s4ert
de3s4^^e9rt
de2s3espa
de3sesperac
de2s3esperanz
de3sesper
de2s3estabil
de2s3estim
de3sider
de3sidia
de3sidio
de3siert
de3sign
de3sigual
de3silusi
de2s3imagin
de2s3iman
de2s3impon
de2s3impres
de2s3incent
de2s3inclin
de2s3incorp
de2s3incrust
de3sinenc
de3sinfec
de3su3dar
de3su3das
de3su3dan
de2s3inflam
de2s3infl
de2s3inform
de2s3inhib
de2s3insect
de2s3instal
ini3ci
in^^ed3ci
de3s4integr
de3s4inter
de2s3intox
de2s3inver
de3sisten
de3isti
de2s3obedec
de2s3oblig
de2s3obstr
de3socup
de2s3odor
de3solac
de3solad
de3soll
de2s3orej
de2s3orient
de3sortij
de2s3organi
de3suell
de3sonce
de2s3ovi
de2s3oxi
de2s3oye
de2s3oy^^e9
de3s4ubstan
de3s4ustan
de3s4oseg
de2s3ub4ic
de2s3unir
de2s3unier
de2s3unim
.dieci1o2
dodeca1h
dodeca1a2
dodeca1e2
dodeca1i2
dodeca1o2
dodeca1u2
dodeca1^^e12
dodeca1^^e92
dodeca1^^ed2
dodeca1^^f32
dodeca1^^fa2
ecano1h
ecano1a2
ecano1e2
ecano1i2
ecano1o2
ecano1u2
ecano1^^e12
ecano1^^e92
ecano1^^ed2
ecano1^^f32
ecano1^^fa2
eco1h
eco1a2
eco1e2
eco1i2
eco1o2
eco1u2
eco1^^e12
eco1^^e92
eco1^^ed2
eco1^^f32
eco1^^fa2
ectro1h
ectro1a2
ectro1e2
ectro1i2
ectro1o2
ectro1u2
ectro1^^e12
ectro1^^e92
ectro1^^ed2
ectro1^^f32
ectro1^^fa2
.en2a2
.en2e2
.en2i2
.en2o2
.en2u2
.en2^^e12
.en2^^e92
.en2^^ed2
.en2^^f32
.en2^^fa2
.ene3mist
.ene3m^^edst
.eno3jar
.enu3mera
.enu3mer^^e1
.enu3mere
4o3l^^f3gico.
4o3l^^f3gica.
4o3l^^f3gicos.
4o3l^^f3gicas.
4o3l^^f3gicamente.
4o3log^^eda.
4o3log^^edas.
4^^f33logo.
4^^f33loga.
4^^f33logos.
4^^f33logas.
endo1h
endo1a2
endo1e2
endo1i2
endo1o2
endo1u2
endo1^^e12
endo1^^e92
endo1^^ed2
endo1^^f32
endo1^^fa2
ento1h
ento1a2
ento1e2
ento1i2
ento1o2
ento1u2
ento1^^e12
ento1^^e92
ento1^^ed2
ento1^^f32
ento1^^fa2
4emboca
entre1h
entre1a2
entre1e2
entre1i2
entre1o2
entre1u2
entre1^^e12
entre1^^e92
entre1^^ed2
entre1^^f32
entre1^^fa2
euco1h
euco1a2
euco1e2
euco1i2
euco1o2
euco1u2
euco1^^e12
euco1^^e92
euco1^^ed2
euco1^^f32
euco1^^fa2
euro1h
euro1a2
euro1e2
euro1i2
euro1o2
euro1u2
euro1^^e12
euro1^^e92
euro1^^ed2
euro1^^f32
euro1^^fa2
extra1h
extra1a2
extra1e2
extra1i2
extra1o2
extra1u2
extra1^^e12
extra1^^e92
extra1^^ed2
extra1^^f32
extra1^^fa2
u4teri
.cau5t
.deu5t
fono1h
fono1a2
fono1e2
fono1i2
fono1o2
fono1u2
fono1^^e12
fono1^^e92
fono1^^ed2
fono1^^f32
fono1^^fa2
foto1h
foto1a2
foto1e2
foto1i2
foto1o2
foto1u2
foto1^^e12
foto1^^e92
foto1^^ed2
foto1^^f32
foto1^^fa2
gastro1h
gastro1a2
gastro1e2
gastro1i2
gastro1o2
gastro1u2
gastro1^^e12
gastro1^^e92
gastro1^^ed2
gastro1^^f32
gastro1^^fa2
geo1h
geo1a2
geo1e2
geo1i2
geo1o2
geo1u2
geo1^^e12
geo1^^e92
geo1^^ed2
geo1^^f32
geo1^^fa2
gluco1h
gluco1a2
gluco1e2
gluco1i2
gluco1o2
gluco1u2
gluco1^^e12
gluco1^^e92
gluco1^^ed2
gluco1^^f32
gluco1^^fa2
hecto1h
hecto1a2
hecto1e2
hecto1i2
hecto1o2
hecto1u2
hecto1^^e12
hecto1^^e92
hecto1^^ed2
hecto1^^f32
hecto1^^fa2
helio1h
helio1a2
helio1e2
helio1i2
helio1o2
helio1u2
helio1^^e12
helio1^^e92
helio1^^ed2
helio1^^f32
helio1^^fa2
hemato1h
hemato1a2
hemato1e2
hemato1i2
hemato1o2
hemato1u2
hemato1^^e12
hemato1^^e92
hemato1^^ed2
hemato1^^f32
hemato1^^fa2
hemi1h
hemi1a2
hemi1e2
hemi1i2
hemi1o2
hemi1u2
hemi1^^e12
hemi1^^e92
hemi1^^ed2
hemi1^^f32
hemi1^^fa2
hemo1h
hemo1a2
hemo1e2
hemo1i2
hemo1o2
hemo1u2
hemo1^^e12
hemo1^^e92
hemo1^^ed2
hemo1^^f32
hemo1^^fa2
2al.
2ales.
hexa1h
hexa1a2
hexa1e2
hexa1i2
hexa1o2
hexa1u2
hexa1^^e12
hexa1^^e92
hexa1^^ed2
hexa1^^f32
hexa1^^fa2
hidro1h
hidro1a2
hidro1e2
hidro1i2
hidro1o2
hidro1u2
hidro1^^e12
hidro1^^e92
hidro1^^ed2
hidro1^^f32
hidro1^^fa2
hipe2r3r
hipe2r1a2
hipe2r1e2
hipe2r1i2
hipe2r1o2
hipe2r1u2
hipe2r1^^e12
hipe2r1^^e92
hipe2r1^^ed2
hipe2r1^^f32
hipe2r1^^fa2
pe3r4e3mia
histo1h
histo1a2
histo1e2
histo1i2
histo1o2
histo1u2
histo1^^e12
histo1^^e92
histo1^^ed2
histo1^^f32
histo1^^fa2
homo1h
homo1a2
homo1e2
homo1i2
homo1o2
homo1u2
homo1^^e12
homo1^^e92
homo1^^ed2
homo1^^f32
homo1^^fa2
icono1h
icono1a2
icono1e2
icono1i2
icono1o2
icono1u2
icono1^^e12
icono1^^e92
icono1^^ed2
icono1^^f32
icono1^^fa2
.i2n2a2
.i2n2e2
.i2n2i2
.i2n2o2
.i2n2u2
.i2n2^^e12
.i2n2^^e92
.i2n2^^ed2
.i2n2^^f32
.i2n2^^fa2
.in3abord
.in3abarc
.in3acent
.in3aguant
.in3adapt
.ina3movib
.in3analiz
.ina3nic
.in3anim
.in^^e13nim
.in3apel
.in3aplic
.in3aprens
.in3apreci
.in3arrug
.in3asist
.in^^e93dit
.in3efic
.in3efici
.in3eludi
.ine3narr
ini3cia
in^^ed3cia
ini3ci^^e1
ini3cie
.rei3na
re3ini3cia
re3in^^ed3cia
re3ini3ci^^e1
re3ini3cie
.ini3cuo
.ini3cua
.ino3cuo
.ino3cua
.ino3cula
.ino3cul^^e1
.ino3cule
.in^^fa3til
.inu3tiliz
infra1h
infra1a2
infra1e2
infra1i2
infra1o2
infra1u2
infra1^^e12
infra1^^e92
infra1^^ed2
infra1^^f32
infra1^^fa2
.inte2r3r
.inte2r1a2
.inte2r1e2
.inte2r1i2
.inte2r1o2
.inte2r1u2
.inte2r1^^e12
.inte2r1^^e92
.inte2r1^^ed2
.inte2r1^^f32
.inte2r1^^fa2
.in3ter2e3sa
.in3ter2e3se
.in3ter2e3so
.in3ter2e3s^^e1
.in3ter2e3s^^e9
.in3ter2e3s^^f3
.de3s4in3ter2e3sa
.de3s4in3ter2e3se
.de3s4in3ter2e3so
.de3s4in3ter2e3s^^e1
.de3s4in3ter2e3s^^e9
.de3s4in3ter2e3s^^f3
3te3ri3n
4te4r5i4nsu
.in3te3r4rog
.in3te3r4rupc
.in3te3r4rupt
.in3te3r4rump
intra1h
intra1a2
intra1e2
intra1i2
intra1o2
intra1u2
intra1^^e12
intra1^^e92
intra1^^ed2
intra1^^f32
intra1^^fa2
iso1h
iso1a2
iso1e2
iso1i2
iso1o2
iso1u2
iso1^^e12
iso1^^e92
iso1^^ed2
iso1^^f32
iso1^^fa2
kilo1h
kilo1a2
kilo1e2
kilo1i2
kilo1o2
kilo1u2
kilo1^^e12
kilo1^^e92
kilo1^^ed2
kilo1^^f32
kilo1^^fa2
macro1h
macro1a2
macro1e2
macro1i2
macro1o2
macro1u2
macro1^^e12
macro1^^e92
macro1^^ed2
macro1^^f32
macro1^^fa2
mal2
ma4l3h
.ma4l3e4du
mal3b
mal3c
mal3d
mal3f
mal3g
mal3m
mal3p
mal3q
mal3s
mal3t
mal3v
bien2
bien3h
bien3v
bien3q
bien3m
bien3t
b4ien3do.
.su3b4ien
b4ien3das.
maxi1h
maxi1a2
maxi1e2
maxi1i2
maxi1o2
maxi1u2
maxi1^^e12
maxi1^^e92
maxi1^^ed2
maxi1^^f32
maxi1^^fa2
megalo1h
megalo1a2
megalo1e2
megalo1i2
megalo1o2
megalo1u2
megalo1^^e12
megalo1^^e92
megalo1^^ed2
megalo1^^f32
megalo1^^fa2
mega1h
mega1a2
mega1e2
mega1i2
mega1o2
mega1u2
mega1^^e12
mega1^^e92
mega1^^ed2
mega1^^f32
mega1^^fa2
melano1h
melano1a2
melano1e2
melano1i2
melano1o2
melano1u2
melano1^^e12
melano1^^e92
melano1^^ed2
melano1^^f32
melano1^^fa2
micro1h
micro1a2
micro1e2
micro1i2
micro1o2
micro1u2
micro1^^e12
micro1^^e92
micro1^^ed2
micro1^^f32
micro1^^fa2
mili1h
mili1a2
mili1e2
mili1i2
mili1o2
mili1u2
mili1^^e12
mili1^^e92
mili1^^ed2
mili1^^f32
mili1^^fa2
familia3ri
ia5res.
amili6a
a3rio
li5^^e1rea
mini1h
mini1a2
mini1e2
mini1i2
mini1o2
mini1u2
mini1^^e12
mini1^^e92
mini1^^ed2
mini1^^f32
mini1^^fa2
2os.
2o3so.
2o3sos.
2o3sa.
2o3sas.
2o3samente.
mini4a5tur
multi1h
multi1a2
multi1e2
multi1i2
multi1o2
multi1u2
multi1^^e12
multi1^^e92
multi1^^ed2
multi1^^f32
multi1^^fa2
miria1h
miria1a2
miria1e2
miria1i2
miria1o2
miria1u2
miria1^^e12
miria1^^e92
miria1^^ed2
miria1^^f32
miria1^^fa2
mono1h
mono1a2
mono1e2
mono1i2
mono1o2
mono1u2
mono1^^e12
mono1^^e92
mono1^^ed2
mono1^^f32
mono1^^fa2
2i3co.
2i3cos.
2i3ca.
2i3cas.
namo1h
namo1a2
namo1e2
namo1i2
namo1o2
namo1u2
namo1^^e12
namo1^^e92
namo1^^ed2
namo1^^f32
namo1^^fa2
necro1h
necro1a2
necro1e2
necro1i2
necro1o2
necro1u2
necro1^^e12
necro1^^e92
necro1^^ed2
necro1^^f32
necro1^^fa2
neo1h
neo1a2
neo1e2
neo1i2
neo1o2
neo1u2
neo1^^e12
neo1^^e92
neo1^^ed2
neo1^^f32
neo1^^fa2
neto1h
neto1a2
neto1e2
neto1i2
neto1o2
neto1u2
neto1^^e12
neto1^^e92
neto1^^ed2
neto1^^f32
neto1^^fa2
norte1h
norte1a2
norte1e2
norte1i2
norte1o2
norte1u2
norte1^^e12
norte1^^e92
norte1^^ed2
norte1^^f32
norte1^^fa2
octo1h
octo1a2
octo1e2
octo1i2
octo1o2
octo1u2
octo1^^e12
octo1^^e92
octo1^^ed2
octo1^^f32
octo1^^fa2
octa1h
octa1a2
octa1e2
octa1i2
octa1o2
octa1u2
octa1^^e12
octa1^^e92
octa1^^ed2
octa1^^f32
octa1^^fa2
oligo1h
oligo1a2
oligo1e2
oligo1i2
oligo1o2
oligo1u2
oligo1^^e12
oligo1^^e92
oligo1^^ed2
oligo1^^f32
oligo1^^fa2
omni1h
omni1a2
omni1e2
omni1i2
omni1o2
omni1u2
omni1^^e12
omni1^^e92
omni1^^ed2
omni1^^f32
omni1^^fa2
i2o.
i2os.
paleo1h
paleo1a2
paleo1e2
paleo1i2
paleo1o2
paleo1u2
paleo1^^e12
paleo1^^e92
paleo1^^ed2
paleo1^^f32
paleo1^^fa2
para1h
para1a2
para1e2
para1i2
para1o2
para1u2
para1^^e12
para1^^e92
para1^^ed2
para1^^f32
para1^^fa2
para2is.
a^^ed5so.
a^^ed5sos.
penta1h
penta1a2
penta1e2
penta1i2
penta1o2
penta1u2
penta1^^e12
penta1^^e92
penta1^^ed2
penta1^^f32
penta1^^fa2
piezo1h
piezo1a2
piezo1e2
piezo1i2
piezo1o2
piezo1u2
piezo1^^e12
piezo1^^e92
piezo1^^ed2
piezo1^^f32
piezo1^^fa2
pluri1h
pluri1a2
pluri1e2
pluri1i2
pluri1o2
pluri1u2
pluri1^^e12
pluri1^^e92
pluri1^^ed2
pluri1^^f32
pluri1^^fa2
poli1h
poli1a2
poli1e2
poli1i2
poli1o2
poli1u2
poli1^^e12
poli1^^e92
poli1^^ed2
poli1^^f32
poli1^^fa2
poli4u3r
poli4o5mie
poli4arq
poli4^^e1rq
poli4^^e9ste
poli4andr
poli4antea
expoli4
.pos2t2a2
.pos2t2e2
.pos2t2i2
.pos2t2o2
.pos2t2u2
.pos2t2^^e12
.pos2t2^^e92
.pos2t2^^ed2
.pos2t2^^f32
.pos2t2^^fa2
.pos3tin
.pos3t^^edn
pos3ta.
pos3tas.
s3te.
s3tes.
s3tal.
s3ta3les.
s3ti3lla.
s3ti3llas.
s3ti3ll^^f3n.
s3ti3llones.
.pos3t^^f33ni
.pos3terg
.pos3te3ri
.pos3ti3go
.pos3ti3la
.pos3ti3ne
.pos3ti3za
.pos3ti3zo
.pos3tu3ra
s3tor.
s3tora.
s3toras.
s3tores.
.pos3tu3la
.pos3tu3l^^e1
.pos3tu3le
.pos3tu3l^^e9
.post3elec
.post3impr
.post3ind
.post3ope
.post3rev
.pre2a2
.pre2e2
.pre2i2
.pre2o2
.pre2u2
.pre2h2
.pre2^^e12
.pre2^^e92
.pre2^^ed2
.pre2^^f32
.pre2^^fa2
pre3elij
pre3elig
pre3exis
pre3emin
preo3cup
preo2c^^fap
pre3ol^^ed
pre3opin
.pro2a2
.pro2e2
.pro2i2
.pro2o2
.pro2u2
.pro2h2
.pro2^^e12
.pro2^^e92
.pro2^^ed2
.pro2^^f32
.pro2^^fa2
proto1h
proto1a2
proto1e2
proto1i2
proto1o2
proto1u2
proto1^^e12
proto1^^e92
proto1^^ed2
proto1^^f32
proto1^^fa2
radio1h
radio1a2
radio1e2
radio1i2
radio1o2
radio1u2
radio1^^e12
radio1^^e92
radio1^^ed2
radio1^^f32
radio1^^fa2
ranco1h
ranco1a2
ranco1e2
ranco1i2
ranco1o2
ranco1u2
ranco1^^e12
ranco1^^e92
ranco1^^ed2
ranco1^^f32
ranco1^^fa2
.re2a2
.re3e4
.re2i2
.re2o2
.re2u2
.re2^^e12
.re2^^e92
.re2^^ed2
.re2^^f32
.re2^^fa2
ea3cio.
ea3cios.
ea3cia.
ea3cias.
.re3abr
.re3^^e1br
.re3afirm
.re3af^^edrm
.re3ajust
.rea3j^^fast
.rea3liza
.rea3liz^^e1
.rea3l^^edza
.re3alim
.rea3lism
.rea3list
.re3anim
.re3an^^edm
.re3aparec
.re3ubica
.re3ub^^edca
.reu3mati
.reu3m^^e1ti
.re3unir
.re3un^^edr
.re3usar
.re3us^^e1r
.re3utiliz
.re3util^^edz
rmano1h
rmano1a2
rmano1e2
rmano1i2
rmano1o2
rmano1u2
rmano1^^e12
rmano1^^e92
rmano1^^ed2
rmano1^^f32
rmano1^^fa2
retro1h
retro1a2
retro1e2
retro1i2
retro1o2
retro1u2
retro1^^e12
retro1^^e92
retro1^^ed2
retro1^^f32
retro1^^fa2
romo1h
romo1a2
romo1e2
romo1i2
romo1o2
romo1u2
romo1^^e12
romo1^^e92
romo1^^ed2
romo1^^f32
romo1^^fa2
sobre1h
sobre1a2
sobre1e2
sobre1i2
sobre1o2
sobre1u2
sobre1^^e12
sobre1^^e92
sobre1^^ed2
sobre1^^f32
sobre1^^fa2
semi1h
semi1a2
semi1e2
semi1i2
semi1o2
semi1u2
semi1^^e12
semi1^^e92
semi1^^ed2
semi1^^f32
semi1^^fa2
i2a.
i2as.
2^^f3tic
emi2o2
seudo1h
seudo1a2
seudo1e2
seudo1i2
seudo1o2
seudo1u2
seudo1^^e12
seudo1^^e92
seudo1^^ed2
seudo1^^f32
seudo1^^fa2
o2os.
.so3a4s
socio1h
socio1a2
socio1e2
socio1i2
socio1o2
socio1u2
socio1^^e12
socio1^^e92
socio1^^ed2
socio1^^f32
socio1^^fa2
a3rio.
a3rios.
3log^^eda
4^^f3n.
4ones.
4i4er.
4o2ico.
4o2icos.
4o2ica.
4o2icas.
.su2b2a2
.su2b2e2
.su2b2i2
.su2b2o2
.su2b2u2
.su2b2^^e12
.su2b2^^e92
.su2b2^^ed2
.su2b2^^f32
.su2b2^^fa2
.sub2i3ll
.sub2i3mien
.sub3^^ednd
.sub3^^edmi
.su4b3ray
.sub3aflue
.sub3arr
.sub3enten
.sub3estim
.sub3est^^edm
.sub3ofici
.sub3urba
.sub3alter
.sub3insp
.su3bi^^e9n
.su3bir
.su3bam
.su3bordin
.su3bord^^edn
.sub3acu^^e1
.sub3espe
.sub3esta
.su3burbi
.su4b5rein
supe2r3r
supe2r1a2
supe2r1e2
supe2r1i2
supe2r1o2
supe2r1u2
supe2r1^^e12
supe2r1^^e92
supe2r1^^ed2
supe2r1^^f32
supe2r1^^fa2
supe3r4a4r
supe3r4^^e14r
supe3r4^^e13vit.
supe3r4^^e13vits.
4a3ci^^f3n.
4a3ciones.
4e3rior.
4e3riores.
4e3riora.
4e3rioras.
4e3riormente.
4e3rioridad.
4e3rioridades.
4e3ra3ble.
4e3ra3bles.
4e3ra3blemente.
pe5r4ante
perpon5d6r
supra1h
supra1a2
supra1e2
supra1i2
supra1o2
supra1u2
supra1^^e12
supra1^^e92
supra1^^ed2
supra1^^f32
supra1^^fa2
sup6ra
talmo1h
talmo1a2
talmo1e2
talmo1i2
talmo1o2
talmo1u2
talmo1^^e12
talmo1^^e92
talmo1^^ed2
talmo1^^f32
talmo1^^fa2
tele1h
tele1a2
tele1e2
tele1i2
tele1o2
tele1u2
tele1^^e12
tele1^^e92
tele1^^ed2
tele1^^f32
tele1^^fa2
4^^f3steo.
4^^f3steos.
termo1h
termo1a2
termo1e2
termo1i2
termo1o2
termo1u2
termo1^^e12
termo1^^e92
termo1^^ed2
termo1^^f32
termo1^^fa2
tetra1h
tetra1a2
tetra1e2
tetra1i2
tetra1o2
tetra1u2
tetra1^^e12
tetra1^^e92
tetra1^^ed2
tetra1^^f32
tetra1^^fa2
topo1h
topo1a2
topo1e2
topo1i2
topo1o2
topo1u2
topo1^^e12
topo1^^e92
topo1^^ed2
topo1^^f32
topo1^^fa2
tropo1h
tropo1a2
tropo1e2
tropo1i2
tropo1o2
tropo1u2
tropo1^^e12
tropo1^^e92
tropo1^^ed2
tropo1^^f32
tropo1^^fa2
poi3de.
poi3des.
ultra1h
ultra1a2
ultra1e2
ultra1i2
ultra1o2
ultra1u2
ultra1^^e12
ultra1^^e92
ultra1^^ed2
ultra1^^f32
ultra1^^fa2
xeno1h
xeno1a2
xeno1e2
xeno1i2
xeno1o2
xeno1u2
xeno1^^e12
xeno1^^e92
xeno1^^ed2
xeno1^^f32
xeno1^^fa2
inter4^^e9s
inter4esar
inter4in
inter4ino
inter4ior
mili4ar
mili4ario
para4^^edso
para4ulata
super4able
super4aci^^f3n
super4ior
tran4sacc
trans4ar
trans4e^^fante
trans4iber
trans4ici^^f3n
trans4ido
trans4igen
trans4igir
trans4istor
trans4itab
trans4it
trans4itorio
trans4ubsta
ultra4^^edsmo
wa3s4h
.bi1anual
.bi1aur
.bien1and
.bien1apa
.bien1ave
.bien1est
.bien1int
.bi1ox
.bi1^^f32x
.bi1un
.en1aceit
.en1aciy
.en1aguach
.en1aguaz
.en1anch
.en1apa
.en1arb
.en1art
.en2artr
.en1ej
.hepta1e
.intra1o
.intra1u
.mal1acon
.mal1acos
.mala1e
.mal1andant
.mal1andanz
.mal1est
.mal1int
.pa4n1a4meri
.pa4n1europ
.pa4n1afri
.pa4n1^^f3pti
3p2sic
3p2siq
.re3a2eg
.re3a2q
.re3a2z
.re3a2grup
.re3i2m
.re3inc
.re3ing
.re3ins
.re3int
.re3o2b
.re1oc
.re1oj
.re3orga
.re1unt
.retro1a
.su2d1a2fr
.su2d1a2me
.su2d1est
su4d3oes
.sur1a2me
.sur1est
.sur1oes
.tele1imp
.tele1obj
.tra2s1a
.tra2s1o
.tra2s2o^^f1
.tran2s1alp
.tran2s1and
.tran2s1atl
.tran2s1oce
.tran2s1ur
.tri1^^f32x
}
\egroup

